#!/bin/sh

# Writes to ram are much faster than writes to flash.  ;)
LOG=/var/tmp/HardwareReport.log
: >$LOG

# Load Amazon provided functions
source /etc/upstart/functions

BOARD=$(f_board) 2>&1
REV=$(f_rev) 2>&1
PLAT=$(f_platform) 2>&1

echo 'Hardware Version Report' >> $LOG
echo '  Board: '$BOARD >> $LOG
echo '  Revision: '$REV >> $LOG
echo '  Platform: '$PLAT >> $LOG

echo '' >> $LOG
# Inspired by /etc/upstart/battery

BDIR=$(dirname `kdb get system/driver/charger/SYS_BATT_CAP`)

BAT_C=$(cat $BDIR/battery_capacity)
BAT_MV=$(cat $BDIR/battery_voltage)
BAT_MA=$(cat $BDIR/battery_current) 
BAT_MAH=$(cat $BDIR/battery_mAH) 
BAT_LMD=$(cat $BDIR/battery_lmd) 
BAT_ID=$(cat $BDIR/battery_id) 

echo 'Battery Status Report' >> $LOG
echo '  Battery ID: '$BAT_ID >> $LOG
echo '  Battery capacity: '$BAT_C >> $LOG
echo '  Charging voltage: '$BAT_MV' mv.' >> $LOG
echo '  Charging current: '$BAT_MA' ma.' >> $LOG
echo '  Current charge: '$BAT_MAH' maH.' >> $LOG
echo '  Last measured discharge: '$BAT_LMD' ma.' >> $LOG

# Make the cache drop any prior copy of the report:
rm -fr /mnt/us/documents/HardwareReport.* >/dev/null 2>&1
mv $LOG /mnt/us/documents/HardwareReport.txt >/dev/null 2>&1
dbus-send --system /default com.lab126.powerd.resuming int32:1 

exit 0
