#!/bin/sh

# Writes to ram are much faster than writes to flash.  ;)
LOG=/var/tmp/HardwareReport.log
: >$LOG

# Load Amazon provided functions
source /etc/upstart/functions

BOARD=$(f_board) 2>1
REV=$(f_rev) 2>1
PLAT=$(f_platform) 2>1

echo 'Hardware Version Report' >> $LOG
echo 'Board: '$BOARD >> $LOG
echo 'Revision: '$REV >> $LOG
echo 'Platform: '$PLAT >> $LOG

# Make the cache drop any prior copy of the report:
rm -fr /mnt/us/documents/HardwareReport.* >/dev/null 2>&1
mv $LOG /mnt/us/documents/HardwareReport.txt >/dev/null 2>&1
dbus-send --system /default com.lab126.powerd.resuming int32:1 >/dev/null 2>&1

exit 0
