import os
from calibre.customize import MetadataReaderPlugin

class LitMeta(MetadataReaderPlugin):

  name                = 'New LIT metadata' # Name of the plugin
  description         = 'New metadata reader for LIT'
  supported_platforms = ['windows'] # Platforms this plugin will run on
  author              = 'None' # The author of this plugin
  version             = (1, 0, 0)   # The version number of this plugin
  file_types          = set(['lit']) # The file types that this plugin will be applied to
  priority            = 2
  on_import           = True # Run this plugin after conversion is complete

  def get_metadata(self, stream, ftype):
    from calibre.ebooks.metadata.lit import get_metadata
    mi = get_metadata(stream, ftype)
    return mi