from os import path
import sys
import fitz

'''
Creates 1000 bookmarks to prevent PDF from being converted to Print Replica
by Send To Kindle service.py
'''

try:
    pdf = sys.argv[1]
    if not path.isfile(pdf):
        raise FileNotFoundError

except (IndexError, FileNotFoundError):
    print('Please specify the path to an existing PDF file, e.g.:\n    > python bookmark_hack.py [pdf_path]')
    exit(1)

doc = fitz.Document(pdf)
toc = doc.get_toc()

dummy_toc = [[1, 'Dummy TOC', 1]]
for b_num in range(1, 1000):
    dummy_toc.append([2, f'Dummy TOC entry {b_num}', 1])

toc += dummy_toc
doc.set_toc(toc)

doc.save(f'{path.splitext(pdf)[0]}_hacked.pdf')
