﻿#!/usr/bin/env python
# -*- coding: utf-8 -*-

# *****************************************************************************#
#                                                                              #
# author: Becky * 2023                                                         #
#                                                                              #
# *****************************************************************************#

import sys
import os
from io import BytesIO
from PIL import Image
from sigil_bs4 import BeautifulSoup

def run(bk):

    main_img_bookpath = None

    # Loop to detect hash for main image
    for (html_id, file_href) in bk.text_iter():
        html = bk.readfile(html_id)

        # load html code into BeautifulSoup
        soup = BeautifulSoup(html, 'html.parser')

        # look for images
        img_tags = soup.find_all('img')

        for img in img_tags:
            if 'src' in img.attrs:
                href = img['src']
                base_name = os.path.basename(href)
                id = bk.basename_to_id(base_name)
                main_img_bookpath = "OEBPS/" + href
                if bk.launcher_version() >= 20190927:
                    main_img_bookpath = bk.id_to_bookpath(id)
                break

    # process file list (main loop)
    for (html_id, file_href) in bk.text_iter():
        file_name = os.path.basename(file_href)
        print('Processing {}...'.format(file_name))
        html = bk.readfile(html_id)

        # load html code into BeautifulSoup
        soup = BeautifulSoup(html, 'html.parser')
        orig_soup = str(soup)

        # look for images
        img_tags = soup.find_all('img')

        for img in img_tags:
            if 'src' in img.attrs:
                href = img['src']
                base_name = os.path.basename(href)
                id = bk.basename_to_id(base_name)
                img_bookpath = "OEBPS/" + href
                if bk.launcher_version() >= 20190927:
                    img_bookpath = bk.id_to_bookpath(id)

                if id:
                    # get image file size
                    imgdata = bk.readfile(id)
                    img_data = Image.open(BytesIO(imgdata)).convert('L')
                    width, height = img_data.size
                    img['width'] = str(width) + "px"
                    img['height'] = str(height) + "px"
                    print('Added dimensions to the {} image.'.format(base_name))
            else:
                print(img['src'] + ' skipped! (empty img tag)\n')

        if str(soup) != orig_soup:
            bk.writefile(html_id, str(soup.prettyprint_xhtml()))
            print('{} updated\n'.format(file_name))

    print('\nPlease click OK to close the Plugin Runner window.')

    return 0

def main():
    print('I reached main when I should not have\n')
    return -1


if __name__ == "__main__":
    sys.exit(main())
