# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.191"  #Qt6

from qt.core import (Qt, QDialog, QVBoxLayout, QFont, QWidget,
                                       QTableWidget, QTableWidgetItem, QSize, QPushButton,
                                       QIcon, QAbstractItemView, QTextEdit)
from calibre.constants import DEBUG
from calibre.gui2 import gprefs

from polyglot.builtins import as_unicode
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):
    initial_extra_size = QSize(400, 400)

    def __init__(self, parent, unique_pref_name):
        QDialog.__init__(self, parent)
        self.unique_pref_name = unique_pref_name
        self.geom = gprefs.get(unique_pref_name, None)

    def resize_dialog(self):
        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
        else:
            self.restoreGeometry(self.geom)

    def save_dialog_geometry(self):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_name] = geom
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class JSCommentsViewerDialog(SizePersistedDialog):

    def __init__(self,gui,guidb,icon,selected_list):

        parent = gui
        unique_pref_name = 'jobspy:commentsviewerdialog'
        SizePersistedDialog.__init__(self, parent, unique_pref_name)

        self.gui = gui
        self.guidb = guidb
        self.icon = icon

        self.selected_list = selected_list

        self.setWindowTitle('JS: Comments Viewer')
        self.setWindowIcon(self.icon)

        self.layout = QVBoxLayout()
        self.setLayout(self.layout)

        font = QFont()
        font.setBold(False)
        font.setPointSize(8)

        self.selected_list.sort()
        nrows = len(self.selected_list)

        column_label_list = []
        column_label_list.append("ID")
        column_label_list.append("Author(s)")
        column_label_list.append("Title")
        column_label_list.append("Comments")

        self.js_qtablewidget = QTableWidget(nrows,4)     # number of rows and columns

        self.js_qtablewidget.setSortingEnabled(False)

        self.js_qtablewidget.setHorizontalHeaderLabels(column_label_list)

        self.js_qtablewidget.setColumnWidth(0, 25)
        self.js_qtablewidget.setColumnWidth(1, 75)
        self.js_qtablewidget.setColumnWidth(2, 75)
        self.js_qtablewidget.setColumnWidth(3, 600)

        r = 0
        for book in self.selected_list:
            mi = self.guidb.get_metadata(book,index_is_id=True)
            #~ ---------
            book = as_unicode(book)
            c0 = QTableWidgetItem(book,0)
            #~ ---------
            authors = mi.authors
            author = " "
            for row in authors:
                author = author + row + ", "
            #END FOR
            author = author[0:-2]
            author = author.strip()
            c1 = QTableWidgetItem(author,0)
            #~ ---------
            title = mi.title
            c2 = QTableWidgetItem(title,0)
            #~ ---------
            self.js_qtablewidget.setItem(r,0,c0)
            self.js_qtablewidget.setItem(r,1,c1)
            self.js_qtablewidget.setItem(r,2,c2)
            #~ ---------
            comments =  mi.comments
            c3 = QTableWidgetItem(comments)
            self.js_qtablewidget.setItem(r,3,c3)

            comments_text = QTextEdit()
            comments_text.insertHtml(comments)
            comments_text.setReadOnly(True)

            self.js_qtablewidget.setCellWidget(r,3,comments_text)          #~ QTableWidget::setCellWidget(int row, int column, QWidget *widget)
            #~ ---------
            self.js_qtablewidget.resizeRowToContents(r)
            r = r + 1
        #END FOR

        self.js_qtablewidget.resizeColumnToContents(0)

        self.layout.addWidget(self.js_qtablewidget)

        self.js_qtablewidget.setEditTriggers(QAbstractItemView.NoEditTriggers)
        self.js_qtablewidget.setAlternatingRowColors(True)
        #~ self.js_qtablewidget.setSelectionMode(QAbstractItemView.ExtendedSelection)
        self.js_qtablewidget.setSelectionMode(QAbstractItemView.MultiSelection)
        self.js_qtablewidget.setSelectionBehavior(QAbstractItemView.SelectRows)

        self.js_qtablewidget.setSortingEnabled(True)

        font.setPointSize(8)

        self.push_button_save_geometry = QPushButton(" ", self)
        self.push_button_save_geometry.setText("Exit")
        self.push_button_save_geometry.clicked.connect(self.save_current_geometry)
        self.push_button_save_geometry.setFont(font)
        self.push_button_save_geometry.setMaximumWidth(200)
        self.push_button_save_geometry.setToolTip("<p style='white-space:wrap'>Save the current size of these results and then exit.")
        self.layout.addWidget(self.push_button_save_geometry)

        self.resize(self.sizeHint())

        self.resize_dialog()

        self.show()

    #----------------------------------------------------
    def save_current_geometry(self):
        self.save_dialog_geometry()
        self.close()
    #----------------------------------------------------


#END OF js_comments_viewer_dialog.py