# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.206"  # New  "JS+:GUI Tool: NBIB to RIS Converter/Exploder to Auto-Add

import ast,os,copy,json

from qt.core import QDialog

from calibre.constants import DEBUG

from polyglot.builtins import iteritems

from calibre_plugins.job_spy.ris_tags_custom_columns_select_dialog import RISCustomColumnsSelectDialog

TAGS_NORMAL = 'datatype:text |||  {"description": "XXX", "is_names": False} |||	is_multiple=1	normalized=1'
TAGS_AUTHOR_LIKE = 'datatype:text |||  {"description": "XXX", "is_names": True}	||| is_multiple=1	normalized=1'
SHORTTEXT_PLAIN_IN_TAGBROWSER = 'datatype:text |||  {"use_decorations": False, "description": "XXX"}	||| is_multiple=0	normalized=1'

SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER = 'datatype:comments |||  {"description": "XXX", "heading_position": "side", "interpret_as": "short-text"}	|||   is_multiple=0	normalized=0'
LONGTEXT_COMMENTS_NORMAL_NOT_HTML = 'datatype:comments |||  {"description": "XXX", "heading_position": "side", "interpret_as": "long-text"} |||	is_multiple=0	normalized=0'
COMMENTS_LIKE_HTML = 'datatype:comments  ||| {"description": "XXX", "interpret_as": "html", "heading_position": "side"} |||	is_multiple=0	normalized=0'

DATETIME = 'datatype:datetime |||  {"date_format": "dd MMM yyyy", "description": "XXX"} |||	is_multiple=0	normalized=0'

#-----------------------------------------------------------------------------------------
def ris_add_custom_column_control(gprefs,guidb,plugin_path,js_icon):

    created_already_list = guidb.custom_field_keys()   #  e.g.  "#ris_date"

    ris_tag_name_target_list = return_ris_tag_name_target_list()

    param_list,tag_cc_mapping_dict = create_custom_column_creation_params(ris_tag_name_target_list)

    ris_cc_select_dialog = RISCustomColumnsSelectDialog(guidb,created_already_list,tag_cc_mapping_dict,js_icon)
    ris_cc_select_dialog.show()
    ris_cc_select_dialog.exec()
    selected_cc_list = ris_cc_select_dialog.return_tag_cc_list()
    ris_cc_select_dialog.close()
    del ris_cc_select_dialog

    expanded_selected_cc_list = []
    for row in selected_cc_list:
        tag,cc = row
        expanded_selected_cc_list.append(cc)
    #END FOR

    #~ if DEBUG: print("=============>>> selected_cc_list: ", type(expanded_selected_cc_list), "     ", str(expanded_selected_cc_list))

    if len(expanded_selected_cc_list) == 0:
        from calibre.gui2 import question_dialog
        from calibre.gui2.ui import get_gui
        maingui = get_gui()
        msg = "No new RIS Custom Columns were (or needed to be) created.  However, you may still update the ERC plugin's Tag-to-Custom Column mappings.\
        <br><br>Do you want to still update the ERC plugin's Tag-to-Custom Column mappings?"
        if DEBUG: print(msg)
        if question_dialog(maingui, "JS+ GUI Tool - Create #ris_custom_columns", msg):
            skip_mapping = False
        else:
            skip_mapping = True
        del question_dialog
        del get_gui
        del maingui
    else:
        skip_mapping = False

    if not skip_mapping:
        is_valid,msg = set_ris_plugin_prefs_for_tag_mapping(tag_cc_mapping_dict,plugin_path)
        #~ if DEBUG: print("is_valid,msg = set_ris_plugin_prefs_for_tag_mapping:  ", is_valid, msg)
        if not is_valid:
            if DEBUG: print("not is_valid: ", msg)
            return False,msg

    msg = None

    if len(expanded_selected_cc_list) > 0:
        msg = "Number of custom columns that are supposed to be created: ", str(len(expanded_selected_cc_list))
        if DEBUG: print(msg)
        n_created = 0
        for param in param_list:  #already sorted by RIS Tag...
            label, name, datatype, is_multiple, display = param
            cc_label = "#" + label
            if cc_label in created_already_list:
                if DEBUG: print("duplicate cc avoided: ", cc_label)
                continue
            if not cc_label in expanded_selected_cc_list:
                if DEBUG: print("+++++++++>>>not cc_label in selected_cc_list:", cc_label)
                continue
            try:
                msg = ris_add_custom_column(param,guidb,gprefs)
            except Exception as e:
                if DEBUG: print("exception in ris_add_custom_column(param,guidb,gprefs): ", str(e))
                if DEBUG: print("RIS Custom Column failed to add: ", param)
                continue
            if msg is not None:
                if DEBUG: print("RIS Custom Column failed to add: ", param)
                if DEBUG: print("msg from ris_add_custom_column: ", msg)
                continue
            if DEBUG: print("RIS Custom Column successfully added: ", param)
            created_already_list.append(label)
            n_created = n_created + 1
        #END FOR
        msg = "Number of RIS Custom Columns just created: " + str(n_created)
    else:
        msg = "\n\nZero RIS Custom Columns were selected to be created.  None were created.\n\n"
        if DEBUG: print(msg)

    del param_list
    del tag_cc_mapping_dict

    return True,msg
#-----------------------------------------------------------------------------------------
def set_ris_plugin_prefs_for_tag_mapping(tag_cc_mapping_dict,plugin_path):

    msg = ""

    try:
        erc_json_path = str(plugin_path)
        erc_json_path = erc_json_path.replace("\Job Spy.zip", "", 1)
        erc_json_path = erc_json_path.replace("/Job Spy.zip", "", 1)

        file_name = 'Extract RIS Citations.json'
        erc_json_file = os.path.join(erc_json_path, file_name)
        erc_json_file = erc_json_file.replace(os.sep,"/")   # calibre\plugins\Extract RIS Citations.json"

        #~ if DEBUG: print("erc_json_file: ", erc_json_file)

        if not os.path.isfile(erc_json_file):
            msg = "erc_json_file path error: " + erc_json_file
            if DEBUG: print(msg)
            return False,msg

        with open(erc_json_file, 'r') as json_file:
            #~ erc_prefs_dict = json.loads(json_file.read())
            erc_prefs_dict = json.load(json_file)

        if not isinstance(erc_prefs_dict,dict):
            msg = "User Error in ERC Plugin: not yet installed & default config viewed for the first time...doing nothing. "
            if DEBUG: print(msg)
            return False,msg

        backup_dict = copy.deepcopy(erc_prefs_dict)
        erc_json_file_backup = erc_json_file.replace(".json","_js_tool_backup.json")
        with open(erc_json_file_backup, 'wt', encoding='utf-8') as json_file:
            json.dump(backup_dict, json_file, indent=2)
        json_file.close()  #OCD
        if not os.path.isfile(erc_json_file_backup):
            if DEBUG: print("erc_json_file_backup path error: ", erc_json_file_backup)
        else:
            if DEBUG: print("erc_json_file_backup has been written",erc_json_file_backup)
        #~ ---------------------------------
        #~ Update the existing prefs for ERC to use the new  custom columns instead...
        #~ ---------------------------------
        for k,v in iteritems(tag_cc_mapping_dict):
            erc_prefs_dict[k] = tag_cc_mapping_dict[k]
        #END FOR
        #~ ---------------------------------
        #~ ---------------------------------

        with open(erc_json_file, 'wt', encoding='utf-8') as json_file:
            json.dump(erc_prefs_dict, json_file, indent=2)
        json_file.close()  #OCD
        if not os.path.isfile(erc_json_file_backup):
            if DEBUG: print("erc_json_file_backup path error: ", erc_json_file_backup)
        else:
            if DEBUG: print("new erc_json_file has been written")
    except Exception as e:
        msg = "Exception:  set_ris_plugin_prefs_for_tag_mapping:  error - " + str(e)
        if DEBUG: print(msg)
        return False,msg

    return True,msg
#-----------------------------------------------------------------------------------------
def create_custom_column_creation_params(ris_tag_name_target_list):
    param_list = []
    tag_cc_mapping_dict = {}

    ris_tag_name_target_list.sort()  # by RIS Tag, not by #label...

    for row_list in ris_tag_name_target_list:     #  ['A1', 'first_authors','#ris_first_authors',TAGS_AUTHOR_LIKE],
        tag = row_list[0]
        name = row_list[1]
        name = tag + "_" + name
        label = row_list[2]
        tag_cc_mapping_dict[tag] = label
        label = label.replace("#","").strip()
        label = label.lower()
        other = row_list[3]
        if "datatype:text" in other:
            datatype = "text"
        elif "datatype:comments" in other:
            datatype = "comments"
        elif "datatype:datetime" in other:
            datatype = "datetime"
        else:
            continue
        if "is_multiple=0" in other:
            is_multiple = False
        else:
            is_multiple = True
        other_split = other.split("|||")
        display = other_split[1]
        display = display.replace("XXX",name).strip()
        if display.startswith('"'):
            display = display[1: ]
        if display.endswith('"'):
            display = display[0:-1]
        display = display.strip()
        try:
            display = ast.literal_eval(display)
        except Exception as e:
            if DEBUG: print("display = ast.literal_eval(display): ", str(e))
            if not isinstance(display,dict):
                if DEBUG: print("display is  not a dict; skipping: ", str(display))
            return

        if "is_names" in display:
            val = display["is_names"]
            if str(val) == "True":
                val = True
            else:
                val = False
            display["is_names"] = val

        param = label, name, datatype, is_multiple, display
        param_list.append(param)

        if DEBUG: print("param: ", label, name, datatype, is_multiple, display)

        del tag
        del name
        del label
        del other
        del other_split

        #END FOR
    #END FOR

    del ris_tag_name_target_list
    del param

    return param_list,tag_cc_mapping_dict
#-----------------------------------------------------------------------------------------
def ris_add_custom_column(param,guidb,gprefs):

    label, name, datatype, is_multiple, display = param
    is_editable = 1
    msg = None

    try:
        num = guidb.create_custom_column(label, name, datatype, is_multiple, display=display)
        if DEBUG: print("Custom column created:  ", str(num), "  ", label, "  ", name, "  ", datatype, "  ", display)
        try:
            changed = guidb.new_api.set_custom_column_metadata(num, name=name, label=label, is_editable=is_editable, display=display)  #new_api == class Cache
        except Exception as e:
            if DEBUG: print("new custom column id in table custom_columns added: ", str(e))
        guidb.prefs['field_metadata'] = guidb.field_metadata.all_metadata()
    except Exception as e:
        msg = "error in guidb.create_custom_column for param: " + param + "     with error:  " + str(e)
        if DEBUG: print(msg)

    return msg
#-----------------------------------------------------------------------------------------
def return_ris_tag_name_target_list():
    #C0-C9 & U1-U5 are for NBIB PubMed .nbib files
    #list of lists

    ris_tag_name_target_list = \
    [['A1', 'first_authors','#ris_first_authors',TAGS_AUTHOR_LIKE],
    ['A2', 'secondary_authors','#ris_secondary_authors',TAGS_AUTHOR_LIKE],
    ['A3', 'tertiary_authors','#ris_tertiary_authors',TAGS_AUTHOR_LIKE],
    ['A4', 'subsidiary_authors','#ris_subsidiary_authors',TAGS_AUTHOR_LIKE],
    ['AB', 'abstract','#ris_abstract',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['AD', 'author_address','#ris_author_address',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['AN', 'accession_number','#ris_accession_number',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['AV', 'location_in_archives','#ris_location_in_archives',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['BT', 'user_defined/secondary_title','#ris_secondary_title',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['CA', 'caption','#ris_caption',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['CN', 'call_number','#ris_call_number',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['CP', 'pmid','#ris_pmid',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['CT', 'title_of_unpublished_reference','#ris_title_of_unpublished_reference',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['CY', 'place_published','#ris_place_published',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['DA', 'date','#ris_date',DATETIME],
    ['DB', 'name_of_database','#ris_name_of_database',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['DO', 'doi','#ris_doi',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['DP', 'database_provider','#ris_database_provider',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['ED', 'editor','#ris_editor',TAGS_AUTHOR_LIKE],
    ['EP', 'end_page','#ris_end_page',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['ER', 'end_of_reference','#ris_end_of_reference',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['ET', 'edition','#ris_edition',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['ID','reference_id','#ris_reference_id',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['IS','issue_number','#ris_issue_number',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['J1','periodical_name_user_abbreviation','#ris_periodical_name_user_abbreviation',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['J2','alternate_title','#ris_alternate_title',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['JA','journal_periodical_name_abbreviation','#ris_journal_periodical_name_abbreviation',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['JF','journal_periodical_name_full','#ris_journal_periodical_name_full',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['JO', 'journal_name','#ris_journal_name',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['KW', 'keywords','#ris_keywords',TAGS_NORMAL],
    ['LB', 'label','#ris_label',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['LK', 'website_link','#ris_website_link',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['M1', 'note','#ris_note',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['M2', 'miscellaneous','#ris_miscellaneous',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['M3', 'type_of_work','#ris_type_of_work',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['N1', 'notes','#ris_notes',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['N2', 'notes/abstract','#ris_notes_abstract',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['NV', 'number_of_volumes','#ris_number_of_volumes',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['OP', 'original_publication','#ris_original_publication',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['PP', 'publishing_place','#ris_publishing_place',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['RI', 'reviewed_item','#ris_reviewed_item',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['RN', 'research_notes','#ris_research_notes',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['RP', 'reprint_edition','#ris_reprint_edition',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['SE', 'section','#ris_section',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['SP', 'start_page','#ris_start_page',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['ST', 'short_title','#ris_short_title',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['T2', 'secondary_title','#ris_secondary_title',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['T3', 'tertiary_title','#ris_tertiary_title',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['TA', 'translated_author','#ris_translated_author',TAGS_AUTHOR_LIKE],
    ['TT', 'translated_title','#ris_translated_title',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['TY', 'type_of_reference','#ris_type_of_reference',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['UR', 'url','#ris_url',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['VL', 'volume','#ris_volume',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['VO', 'published_standard_number','#ris_published_standard_number',SHORTTEXT_PLAIN_NOT_IN_TAGBROWSER],
    ['Y1', 'publication_year','#ris_publication_year',DATETIME],
    ['Y2', 'access_date','#ris_access_date',DATETIME],
    ['C1','people_other','#ris_people_other',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['C2','article_other','#ris_article_other',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['C3','legal','#ris_legal',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['C4','dates_other','#ris_dates_other',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['C5','correction_republication','#ris_republication',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['C6','miscellany','#ris_miscellany',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['C7','grant_contract','#ris_grant_contract',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['C8','location_id','#ris_location_id',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['C9','other','#ris_other',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['C0','phst_date','#ris_phst_date',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['U0','pmc_id','#ris_pmc_id',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['U1','pmc_release','#ris_pmc_release',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['U2','ec_rn_number','#ris_ec_rn_number',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['U3','subset','#ris_subset',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['U4','composite_source','#ris_composite_source',LONGTEXT_COMMENTS_NORMAL_NOT_HTML],
    ['U5','journal_id','#ris_journal_id',LONGTEXT_COMMENTS_NORMAL_NOT_HTML]]

    return ris_tag_name_target_list
#--------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------
    #~ The following should be mapped either to a Standard Calibre column or to 'comments'.
    #~ ['AU', 'authors','authors',],  Standard Calibre...
    #~ ['L1', 'file_attachments1/pdf','comments',],
    #~ ['L2', 'file_attachments2','comments',],
    #~ ['L3','related_records','comments',],
    #~ ['L4', 'image(s)','comments',],
    #~ ['LA', 'language','language',],  Standard Calibre...
    #~ ['PB', 'publisher','#publisher',],  Standard Calibre...
    #~ ['PY', 'publication_year','pubdate',],  Standard Calibre...
    #~ ['SN', 'isbn/issn','identifier',],  Standard Calibre...
    #~ ['T1', 'primary_title','title',],  Standard Calibre...  title or comments  (use either T1 or TI; ERC plugin always creates the other if missing...Zotero uses TI; academic databases use T1...
    #~ ['TI', 'title','title',],                 Standard Calibre...  comments or title  (use either T1 or TI; ERC plugin always creates the other if missing...Zotero uses TI; academic databases use T1...
    #~ ['UK', 'unknown_tag','comments',],
#--------------------------------------------------------------------------------------------
#~ END OF ris_filetype_tags_custom_columns.py