# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.191"  #Qt6

from qt.core import ( Qt, QDialog, QRegularExpression, QApplication, QObject, QWidget, QComboBox, QCompleter,
                                         QMetaObject,QMetaProperty, QMainWindow, QTabWidget,
                                         QLayout,QHBoxLayout,QVBoxLayout,QGridLayout)
from calibre.constants import DEBUG
from calibre.gui2.__init__ import ResizableDialog
from calibre.gui2.actions.edit_metadata import EditMetadataAction
from calibre.gui2.actions.edit_collections import EditCollectionsAction
from calibre.gui2.actions import InterfaceAction
from calibre.gui2.complete2 import LineEdit, EditWithComplete, Completer
from calibre.gui2.custom_column_widgets import MultipleWidget, Text, Series, Enumeration, BulkBase, BulkText, BulkSeries, BulkEnumeration
from calibre.gui2.dialogs.metadata_bulk import MetadataBulkDialog
from calibre.gui2.dialogs.metadata_bulk_ui import Ui_MetadataBulkDialog
from calibre.gui2.dialogs.saved_search_editor import SavedSearchEditor
from calibre.gui2.dialogs.search import SearchDialog
from calibre.gui2.main_window import MainWindow
from calibre.gui2.metadata.basic_widgets import AuthorsEdit, SeriesEdit, TagsEdit, PublisherEdit, LanguagesEdit
from calibre.gui2.metadata.single import MetadataSingleDialog, MetadataSingleDialogAlt1, MetadataSingleDialogAlt2
from calibre.gui2.search_box import SearchBox2
from calibre.gui2.ui import Main
from calibre.gui2.widgets import EnComboBox, HistoryLineEdit, ComboBoxWithHelp, LineEditECM, ItemsCompleter, CompleteLineEdit, EnLineEdit
from calibre.gui2.widgets2 import HistoryComboBox, HistoryLineEdit2

from polyglot.builtins import as_unicode

SRE = QRegularExpression(".+")

class JSGetGUIObjects(object):

    # Return Calibre's GUI object pointers needed by Job Spy 'GUI Tools' that tweak the attributes of certain GUI objects.  Example: increase max items visible in dropdowns.

    def __init__(self,gui,main_gui,myqapplication):
        self.gui = gui
        self.main_gui = main_gui
        self.myqapplication = myqapplication
        self.myqapplication_pointer = myqapplication.instance()
        self.tmp_list = []
        s = as_unicode("ReadingList")     # *guaranteed* to cause Calibre to 'stop working' when this daemon is running...due to RL's use of pyqtSignals...
        self.tmp_list.append(s)
        s = as_unicode("message_box")
        self.tmp_list.append(s)
        s = as_unicode(".device.")
        self.tmp_list.append(s)
        s = as_unicode(".devices.")
        self.tmp_list.append(s)
        s = as_unicode("calibre.ebooks.conversion.")
        self.tmp_list.append(s)
        s = as_unicode(".profiles.")
        self.tmp_list.append(s)
        s = as_unicode("calibre_plugins")  # *all* plug-ins will be excluded to avoid conflicts...
        self.tmp_list.append(s)
        s = as_unicode("JobSpy")
        self.tmp_list.append(s)
        s = as_unicode("CustomColumnEditableDialog")  # way too many widgets (1 qcheckbox per cell in its matrix), none of which this daemon needs to look at...
        self.tmp_list.append(s)
        s = as_unicode("MultiColumnSearch")  # results tab uses pyqtSignals for combo-box choices...same issue as for RL
        self.tmp_list.append(s)
        s = as_unicode("MCSDialog")        # results tab uses pyqtSignals for combo-box choices...same issue as for RL
        self.tmp_list.append(s)
        s = as_unicode("MCSResultsTab")  # results tab uses pyqtSignals for combo-box choices...same issue as for RL
        self.tmp_list.append(s)
        s = as_unicode("calibre.customize.builtins.Store")
        self.tmp_list.append(s)
        s = as_unicode("MetadataReader")
        self.tmp_list.append(s)
        s = as_unicode("MetadataWriter")
        self.tmp_list.append(s)
        s = as_unicode("QInputDialog")
        self.tmp_list.append(s)
        s = as_unicode("QMenu")
        self.tmp_list.append(s)
        s = as_unicode("QWizard")
        self.tmp_list.append(s)
        s = as_unicode("QAction")
        self.tmp_list.append(s)
        s = as_unicode("QUndo")
        self.tmp_list.append(s)
        s = as_unicode("QTree")
        self.tmp_list.append(s)
        s = as_unicode("QTool")
        self.tmp_list.append(s)
        s = as_unicode("QTable")
        self.tmp_list.append(s)
        s = as_unicode("QTabWidget")
        self.tmp_list.append(s)
        s = as_unicode("Gesture")
        self.tmp_list.append(s)
        s = as_unicode("QStyle")
        self.tmp_list.append(s)
        s = as_unicode("QStatus")
        self.tmp_list.append(s)
        s = as_unicode("QStacked")
        self.tmp_list.append(s)
        s = as_unicode("QMessage")
        self.tmp_list.append(s)
        s = as_unicode("QList")
        self.tmp_list.append(s)
        s = as_unicode("Paint")
        self.tmp_list.append(s)
        s = as_unicode("Graphics")
        self.tmp_list.append(s)
        s = as_unicode("File")
        self.tmp_list.append(s)
        s = as_unicode("Error")
        self.tmp_list.append(s)
        s = as_unicode("Spin")
        self.tmp_list.append(s)
        s = as_unicode("Date")
        self.tmp_list.append(s)
        s = as_unicode("Button")
        self.tmp_list.append(s)
        s = as_unicode("Check")
        self.tmp_list.append(s)
        s = as_unicode("QThread")
        self.tmp_list.append(s)
        s = as_unicode("pyqtSignal")
        self.tmp_list.append(s)

        #~ if DEBUG:
            #~ from calibre.customize.ui import _initialized_plugins as tmp_list2
            #~ for row in tmp_list2:
                #~ s = as_unicode(row)
                #~ print(s)
            #~ del tmp_list2

        self.ignore_objects_list = []
        for row in self.tmp_list:
            row = row.lower()
            row = as_unicode(row)
            if not row in self.ignore_objects_list:
                self.ignore_objects_list.append(row)
        #END FOR
        self.ignore_objects_list.sort()  #so generic Q's are last and a leading period/dot and letters less than Q are first...so loop can be exited more quickly if possible...
        del self.tmp_list

        #~ if DEBUG: print("Total number of object keywords ignored by gui_objects.py: ", as_unicode(len(self.ignore_objects_list)))

    def get_objects(self,criteria_type,name_criteria_set,hasattr_criteria_set,object_class_set,iterations,children_level):
        try:
            objects_to_return_set = set()
            #--------------------------------------------------------------------------------------
            #~ print("Criteria Type: ", as_unicode(criteria_type))
            #--------------------------------------------------------------------------------------
            #~ criteria_type:  1 = name; 2 = hasattr; 3 = object_class; NNN = multiple ANDs
            #--------------------------------------------------------------------------------------
            top_set = set()
            answer_set = set()
            #------------------------------------
            #------------------------------------
            window_list = self.myqapplication_pointer.topLevelWidgets()
            for window in window_list:
                if window:
                    key = as_unicode(window)
                    #~ if DEBUG: print(key)
                    ignore = self.check_ignore_list(key)
                    if ignore:
                        continue
                    top_set.add(window)
            #END FOR
            top_set.add(self.main_gui)
            top_set.add(self.gui)
            #~ desktop = self.myqapplication_pointer.instance().desktop()   Qt 5  QDesktopWidget was already deprecated in Qt 5, and has been removed in Qt 6, together with QApplication::desktop().
            desktop = self.myqapplication_pointer.instance().primaryScreen()   #  https://doc.qt.io/qt-6/qguiapplication.html#primaryScreen-prop
            top_set.add(desktop)
            #~ if DEBUG: print("Number of unique topmost objects in top_set: ", as_unicode(len(top_set)))
            answer_set = self.get_top_set_children(top_set,answer_set)
            #~ print("Number of unique objects in answer_set: ", as_unicode(len(answer_set)))
            for n in range(0,iterations):
                answer_set = self.get_children(answer_set,children_level)
                #~ if DEBUG: print("Iteration: ", as_unicode(n+1), " Number of unique objects in answer_set: ", as_unicode(len(answer_set)))
            try:
                for item in answer_set:
                    key = as_unicode(item)
                    #~ if DEBUG: print("gui_objects.get_objects: ", item.staticMetaObject.className())
                    ignore = self.check_ignore_list(key)
                    if ignore:
                        continue
                    if item:
                        #~ if DEBUG: print(as_unicode(item))
                        if criteria_type == 1:
                            if "*" in name_criteria_set:
                                objects_to_return_set.add(item)
                            else:
                                s = as_unicode(item)
                                for name in name_criteria_set:
                                    if name in s:
                                        objects_to_return_set.add(item)
                        elif criteria_type == 2:
                            if "*" in hasattr_criteria_set:
                                objects_to_return_set.add(item)
                            else:
                                try:
                                    keep_it = False
                                    for attr in hasattr_criteria_set:
                                        if hasattr(item,attr):
                                            keep_it = True
                                        else:
                                            keep_it = False
                                            break
                                    if keep_it:
                                        objects_to_return_set.add(item)
                                except:  # object was *just* destroyed
                                        pass
                        elif criteria_type == 3:
                            if "*" in object_class_set:
                                objects_to_return_set.add(item)
                            else:
                                try:
                                    if item.staticMetaObject.className() in object_class_set:
                                        objects_to_return_set.add(item)
                                except:  # object was *just* destroyed
                                    pass
                        elif criteria_type == 12:  # 1 AND 2
                            s = as_unicode(item)
                            for name in name_criteria_set:             #  1
                                if name in s:
                                    keep_it = False
                                    try:
                                        for attr in hasattr_criteria_set:   #  2
                                            if hasattr(item,attr):
                                                keep_it = True
                                                break
                                            else:
                                                pass
                                        if keep_it:
                                            objects_to_return_set.add(item)
                                    except: # object was *just* destroyed
                                        pass
                            #END FOR
                        #END IF
                    else:
                        pass
            except Exception as e:
                if DEBUG:  print("[0] Exception in get_gui_objects: ", as_unicode(item), as_unicode(e))
            #------------------------------------
            #------------------------------------
        except Exception as e:
            if DEBUG: print("[1] EXCEPTION in get_gui_objects: ", as_unicode(e))
        answer_set = None
        del answer_set

        #~ if DEBUG:
            #~ print("returning objects_to_return_set with the following items:")
            #~ for item in objects_to_return_set:
                #~ print(as_unicode(item))

        return objects_to_return_set
    #------------------------------------
    #------------------------------------
    #------------------------------------
    def check_ignore_list(self,key):
        key = key.lower()
        ignore = False
        for name in self.ignore_objects_list:
            if name in key:
                ignore = True
                break
        return ignore
    #------------------------------------
    #------------------------------------
    def get_top_set_children(self,top_set,answer_set):
        for anobject in top_set:
            key = as_unicode(anobject)
            ignore = self.check_ignore_list(key)
            if ignore:
                continue
            #~ if DEBUG: print("top: ", as_unicode(anobject))
            answer_set.add(anobject)
            answer = anobject.findChildren(QDialog,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(MetadataSingleDialog,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(MetadataSingleDialogAlt1,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(MetadataSingleDialogAlt2,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(MetadataBulkDialog,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(Ui_MetadataBulkDialog,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(ResizableDialog,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(QMainWindow,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(MainWindow,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(Main,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(EditMetadataAction,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(EditCollectionsAction,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(InterfaceAction,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            #------------------------
        #END FOR
        del top_set
        return answer_set
    #------------------------------------
    #------------------------------------
    def get_children(self,answer_set,children_level):
        if children_level == 0:
            answer_set = self.get_children_basic(answer_set)                # sufficient for:  Search Bar
        else:
            answer_set = self.get_children_moderate(answer_set)         # sufficient for: 'Edit Metadata' plus *any* QComboBoxes and QCompleters
            if children_level > 1:
                answer_set = self.get_children_extreme(answer_set)        # sufficient for: anything...
        return answer_set
    #------------------------------------
    def get_children_basic(self,answer_set):
        try:
            copy_set = answer_set.copy()
            for anobject in copy_set:
                key = as_unicode(anobject)
                ignore = self.check_ignore_list(key)
                if ignore:
                    continue
                answer = anobject.findChildren(SavedSearchEditor,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(SearchDialog,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(SearchBox2,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QComboBox,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                #------------------------
            #END FOR
            del copy_set
        except:
            pass
        return answer_set
    #------------------------------------
    #------------------------------------
    #------------------------------------
    #------------------------------------
    def get_children_moderate(self,answer_set):
        try:
            copy_set = answer_set.copy()
            for anobject in copy_set:
                key = as_unicode(anobject)
                ignore = self.check_ignore_list(key)
                if ignore:
                    continue
                answer = anobject.findChildren(QComboBox,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(EnComboBox,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(Completer,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QCompleter,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(EditWithComplete,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(HistoryLineEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                #------------------------
                answer = anobject.findChildren(LineEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(AuthorsEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(SeriesEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(TagsEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(PublisherEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(LanguagesEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                #------------------------
            #END FOR
            del copy_set
        except:
            pass
        return answer_set
    #------------------------------------
    #------------------------------------
    #------------------------------------
    #------------------------------------
    def get_children_extreme(self,answer_set):
        try:
            copy_set = answer_set.copy()
            for anobject in copy_set:
                key = as_unicode(anobject)
                ignore = self.check_ignore_list(key)
                if ignore:
                    continue
                answer = anobject.findChildren(QObject,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QWidget,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(ComboBoxWithHelp,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(EnLineEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(CompleteLineEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(ItemsCompleter,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(HistoryComboBox,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(BulkText,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(BulkSeries,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(BulkEnumeration,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(MultipleWidget,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(Text,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(Series,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(Enumeration,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QTabWidget,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QLayout,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QGridLayout,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QHBoxLayout,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QVBoxLayout,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                    #------------------------
            #END FOR
            del copy_set
        except:
            pass
        return answer_set
#-----------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------
# END OF gui_objects.py