from os.path import expanduser
try:
    from PyQt5.Qt import QWidget, QPushButton, QGridLayout, QHBoxLayout, QLabel, QLineEdit, QCheckBox, QComboBox, QVariant, QFileDialog
except:
    from PyQt4.Qt import QWidget, QPushButton, QGridLayout, QHBoxLayout, QLabel, QLineEdit, QCheckBox, QComboBox, QVariant, QFileDialog

from calibre.utils.config import JSONConfig
from calibre.gui2 import FileDialog

# This is where all preferences for this plugin will be stored
# Remember that this name (i.e. plugins/interface_demo) is also
# in a global namespace, so make it as unique as possible.
# You should always prefix your config file name with plugins/,
# so as to ensure you dont accidentally clobber a calibre config file
prefs = JSONConfig('plugins/savetoformat')

# Set defaults
prefs.defaults['formats'] = ['epub']
prefs.defaults['defdir']  = expanduser("~")
prefs.defaults['autoconvert'] = True
prefs.defaults['autodelete'] = True
prefs.defaults['defaction'] = 'PROMPT'


class SaveToDiskConfigWidget(QWidget):

    def __init__(self):
        QWidget.__init__(self)
        self.l = QGridLayout()
        self.setLayout(self.l)
        
        self.defdir_label = QLabel(_('Default directory to save to:'))
        self.l.addWidget(self.defdir_label, 0, 0, 1, 1)
        
        self.hl = QHBoxLayout()
        
        self.defdir = QLineEdit(self)
        self.defdir.setText(prefs['defdir'])
        self.hl.addWidget(self.defdir)
        
        self.browsebtn = QPushButton('Browse...', self)
        self.browsebtn.clicked.connect(self._setDefaultDir)
        self.hl.addWidget(self.browsebtn)
                
        self.l.addLayout(self.hl, 0, 1, 1, 1)

        self.autodelete_label = QLabel(_('Remove auto converted files:'))
        self.l.addWidget(self.autodelete_label, 1, 0, 1, 1)
        
        self.autodelete = QCheckBox(self)
        self.autodelete.setChecked(prefs['autodelete'])
        self.l.addWidget(self.autodelete, 1, 1, 1, 1)

        self.autoconvert_label = QLabel(_('Automatically convert to missing formats:'))
        self.l.addWidget(self.autoconvert_label, 2, 0, 1, 1)
        
        self.autoconvert = QCheckBox(self)
        self.autoconvert.setChecked(prefs['autoconvert'])
        self.l.addWidget(self.autoconvert, 2, 1, 1, 1)

        self.defaction_label = QLabel(_('Default plugin action:'))
        self.l.addWidget(self.defaction_label, 3, 0, 1, 1)
        
        self.defaction = QComboBox(self)
        self.defaction.addItem(_('Prompt action'), QVariant('PROMPT'))
        self.defaction.addItem(_('Favourite format to favourite location'), QVariant('FAVOURITE'))
        self.defaction.setCurrentIndex(self.defaction.findData(QVariant(prefs['defaction'])))
        self.l.addWidget(self.defaction, 3, 1, 1, 1)

    def save_settings(self):
        prefs['defdir'] = str(self.defdir.text())
        prefs['autodelete'] = self.autodelete.isChecked()
        prefs['autoconvert'] = self.autoconvert.isChecked()
        prefs['defaction'] = str(self.defaction.itemData(self.defaction.currentIndex()))
    
    def _setDefaultDir(self):
        fd = FileDialog(title=_('Choose the directory'), filters=[], add_all_files_filter=False,
            parent=self, name='ChDir', mode=QFileDialog.getExistingDirectory,
            default_dir=prefs['defdir'])
        dir = fd.get_files()
        fd.setParent(None)
        if dir:
            (path, ) = dir 
            self.defdir.setText(path)
        
