# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import)
from calibre.ebooks import BOOK_EXTENSIONS
from calibre.gui2.dialogs.select_formats import SelectFormats, Formats
#from calibre.gui2 import NONE

__license__ = 'GPL 3'
__copyright__ = '2015, Darau, blė <darau.ble@gmail.com>'
__docformat__ = 'restructuredtext en'

try:
    from PyQt5.Qt import QModelIndex, QItemSelectionModel, QDialog, Qt, QVariant
except:
    from PyQt4.Qt import QModelIndex, QItemSelectionModel, QDialog, Qt, QVariant
    
from calibre_plugins.savetoformat.gui.config import prefs 
from calibre.gui2.dialogs.select_formats import Formats

class PromptDialog(SelectFormats):

    def __init__(self, fmt_count, msg, selected_formats=[], parent=None):
        SelectFormats.__init__(self, fmt_count, msg, single=False, parent=parent, exclude=False)
        self.formats = SaveFormats(fmt_count)
        self.fview.setModel(self.formats)
        self.selected_formats = []
        
        for i in range(0, self.formats.rowCount(parent)):
            index = self.formats.index(i, 0, QModelIndex())
            if self.formats.fmt(index) in prefs['formats']:
                self.fview.selectionModel().select(index, QItemSelectionModel.SelectionFlag.Select)

                
    def accept(self, *args):
        for idx in self.fview.selectedIndexes():
            self.selected_formats.append(self.formats.fmt(idx))
        prefs['formats'] = self.selected_formats
        QDialog.accept(self, *args)

class SaveFormats(Formats):
    
    def data(self, index, role):
        row = index.row()
        if role == Qt.DisplayRole:
            fmt = self.fmts[row]
            count = self.counts[fmt]
            return QVariant('%s'%fmt.upper())
        if role == Qt.DecorationRole:
            return QVariant(self.fi.icon_from_ext(self.fmts[row].lower()))
        if role == Qt.ToolTipRole:
            fmt = self.fmts[row]
            count = self.counts[fmt]
            return QVariant(
                _('There are %(count)d book(s) with the %(fmt)s format')%dict(
                    count=count, fmt=fmt.upper()))
        #return NONE

