# -*- coding: utf-8 -*-

from __future__ import (unicode_literals, division, absolute_import, print_function)

__license__ = 'GPL 3'
__copyright__ = '2015, Saulius P. <saulius@kofmarai.net>'
__docformat__ = 'restructuredtext en'

from calibre.customize import InterfaceActionBase

class ActionSaveToFormat(InterfaceActionBase):

    name = 'Save To Format'
    description = _('Save books to particular format with auto conversion')
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'Saulius P.'
    version = (0, 0, 6)
    minimum_calibre_version = (0, 9, 19)
    
    actual_plugin = 'calibre_plugins.savetoformat.savetoformataction:SaveToFormatAction'
    
    def is_customizable(self):
        '''
        This method must return True to enable customization via
        Preferences->Plugins
        '''
        return True
    
    def config_widget(self):
        from calibre_plugins.savetoformat.gui.config import SaveToDiskConfigWidget
        return SaveToDiskConfigWidget()
    
    def save_settings(self, config_widget):
        config_widget.save_settings()
       # Apply the changes
        ac = self.actual_plugin_
        if ac is not None:
            ac.changeConfig()
