#!/usr/bin/perl
#
# prs-gen.pl - generate PRS formatted PDFs from full-text RSS feeds
#
# Author: boB Rudis (bob@rudis.net)
# Version 0.1
#

# Change this to whatever works for you

$BASE = "/Users/bob/prs-gen" ;

open(SOURCES,"$BASE/sources.txt") ;
while(<SOURCES>) {

   chomp $_ ;

   ($feedTitle, $feedURL) = split(/\t/,$_,2) ;

   system("rm -f $BASE/rss/$feedTitle.xml $BASE/html/$feedTitle.html $BASE/pdf/$feedTitle.pdf") ;

   system("/usr/local/bin/wget --quiet --output-document=$BASE/rss/$feedTitle.xml \"$feedURL\"") ;

   if ( -f "$BASE/rss/$feedTitle.xml" ) {

      system("$BASE/rss2html.pl $BASE/rss/$feedTitle.xml > $BASE/html/$feedTitle.html") ;

      if ( -f "$BASE/html/$feedTitle.html") {

         print "Generating [$feedTitle]...\n" ; 

         system("/usr/bin/htmldoc --quiet --no-links --textfont Times --browserwidth 600 --embedfonts --format pdf14 --webpage --bodyfont Times --fontsize 14.0 --left 0.1in --right 0.1in --top 0.1in --bottom 0.1in --size 5.24x6.69in $BASE/html/$feedTitle.html --outfile $BASE/pdf/$feedTitle.pdf") ;
      } # if #

   } # if 

} # while #
close(SOURCES) ;
