#!/usr/bin/perl 

# rss2html - converts an RSS file to HTML
# It take one argument, either a file on the local system,
# or an HTTP URL like http://slashdot.org/slashdot.rdf
# by Jonathan Eisenzopf. v1.0 19990901
# Copyright (c) 1999 Jupitermedia Corp. All Rights Reserved.
# See http://www.webreference.com/perl for more information
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# INCLUDES
use strict;
use XML::RSS;
use LWP::Simple;

# Declare variables
my $content;
my $file;

# MAIN
# check for command-line argument
die "Usage: rss2html.pl (<RSS file> | <URL>)\n" unless @ARGV == 1;

# get the command-line argument
my $arg = shift;

# create new instance of XML::RSS
my $rss = new XML::RSS;

# argument is a URL
if ($arg=~ /http:/i) {
    $content = get($arg);
    die "Could not retrieve $arg" unless $content;
    # parse the RSS content
    $rss->parse($content);

# argument is a file
} else {
    $file = $arg;
    die "File \"$file\" does't exist.\n" unless -e $file;
    # parse the RSS file
    $rss->parsefile($file);
}

# print the HTML channel
&print_html($rss);

# SUBROUTINES
sub print_html {
    my $rss = shift;
    print <<HTML;
<h4>$rss->{channel}->{title}</h4>
HTML

    # print the channel items
    foreach my $item (@{$rss->{items}}) {
	next unless defined($item->{title}) && defined($item->{link});
	print<<EOF
<b>$item->{title}</b><br/>
$item->{description}<br/><br/>
EOF
    }

}






