#!/bin/sh

if [ "$#" -eq 1 ]; then
	FILENAME=$1
	KEYSTORE=$HOME/.kindle/kindle.keystore/developer.keystore
	JAR=$FILENAME.azw2
	MANIFEST=$FILENAME.manifest
	
	echo "Building: $FILENAME.jar"
	
	ant jar
	cp $FILENAME.jar $JAR
	
	utente="test"
	
	echo "Signing with keystore: $KEYSTORE"
	echo "Kindlet file: $JAR"
	echo "User: $utente"
	
	jarsigner -keystore $KEYSTORE -storepass password $JAR dk$utente
	jarsigner -keystore $KEYSTORE -storepass password $JAR di$utente
	jarsigner -keystore $KEYSTORE -storepass password $JAR dn$utente
else
	echo "Usage: $0 Filename"
fi