# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.237"  # Per Library Tweak for 'Default Author Link', default_author_link.

from qt.core import  ( Qt, QVBoxLayout, QHBoxLayout, QWidget, QCheckBox, QFrame,
                                         QFont, QSpinBox, QPushButton, QLineEdit, QLabel, QComboBox, QColor,
                                         QScrollArea, QCompleter, QGroupBox, QRegularExpression )

from calibre import isbytestring
from calibre.constants import filesystem_encoding, DEBUG, iswindows
from calibre.customize.ui import available_output_formats
from calibre.ebooks.metadata.book.render import DEFAULT_AUTHOR_LINK
from calibre.utils.config import JSONConfig
from calibre.gui2 import error_dialog

from polyglot.builtins import as_unicode, iteritems, unicode_type

import os,ast,re

prefs = JSONConfig('plugins/Job Spy')

prefs.defaults['JOB_SPY_JSON_FILE_BACKUP_DIRECTORY'] = unicode_type("")

prefs.defaults['JOBS_TO_SHOW_CONSECUTIVELY'] = int(3)
prefs.defaults['GUI_TOOLS_VISIBLE_ITEMS_SEARCHBAR_AUTORUN'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_VISIBLE_ITEMS_EDIT_METADATA_AUTORUN'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_INTERVAL'] = int(8)
prefs.defaults['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_LAST_STARTED'] = unicode_type("never")
prefs.defaults['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_LAST_FAILED'] = unicode_type("never")
prefs.defaults['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_TOTAL_STARTS'] = int(0)
prefs.defaults['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_TOTAL_FAILURES'] = int(0)
prefs.defaults['GUI_TOOLS_SHOW_TOOLTIPS'] = unicode_type("False")
empty_list = []
prefs.defaults['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY'] = unicode_type(as_unicode(empty_list))
prefs.defaults['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY_PURGE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_EXTRACT_ORIGINAL_TITLE_KEYWORD'] = unicode_type("Título original|Titulo original|Original Title|titre original|originaler Titel")
prefs.defaults['GUI_TOOLS_EXTRACT_ORIGINAL_TITLE_CUSTOM_COLUMN'] = unicode_type("#original_title")
prefs.defaults['GUI_TOOLS_EXTRACT_TRANSLATOR_KEYWORD'] = unicode_type("Traducción|Traductor|Traduccion|Traducido por|Traducción del inglés por|Traducciones de|de la traducción|Translator|Translated by|traducteur|Traduit par|traduit de l'anglais par|traduction par|Übersetzer|übersetzt von|aus dem Englischen übersetzt von|Übersetzung von")
prefs.defaults['GUI_TOOLS_EXTRACT_TRANSLATOR_CUSTOM_COLUMN'] = unicode_type("#translator")
prefs.defaults['GUI_TOOLS_AUTO_DELETE_TEMPORARY_READING_LISTS'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP1'] = unicode_type("Apples")
prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP2'] = unicode_type("Cherries")
prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP3'] = unicode_type("Avocados")
prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP4'] = unicode_type("Apricots")
prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP5'] = unicode_type("Mangos")
prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP6'] = unicode_type("Papayas")
prefs.defaults['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_REGEX'] = unicode_type("[-][-][-][0-9]+$")
prefs.defaults['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_ACTIVE'] = unicode_type("False")
prefs.defaults['DEFAULT_VISUALIZE_METADATA_EXPORT_DIRECTORY'] = unicode_type("")
prefs.defaults['JOB_SPY_GRACEFUL_SHUTDOWN_LAST_TIME'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_IGNORE_CC_MESSAGES_ACTIVE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_IGNORE_CC_MESSAGES_SOURCES_1'] = unicode_type("CalibreMCS2|CalibreMCS")
prefs.defaults['GUI_TOOLS_IGNORE_CC_MESSAGES_SOURCES_2'] = unicode_type("SpanishNormal|QuarantineAndScrub_Spanish")
prefs.defaults['GUI_TOOLS_IGNORE_CC_MESSAGES_TARGETS_1'] = unicode_type("*")
prefs.defaults['GUI_TOOLS_IGNORE_CC_MESSAGES_TARGETS_2'] = unicode_type("CalibreJobSpyTest1|CalibreJobSpyTest2|Normal1|Normal2|CalibreNormal|CalibreLibraryCodes")
prefs.defaults['GUI_TOOLS_LIBRARY_VIEW_TEXT_COLOR'] = unicode_type("black")
prefs.defaults['GUI_TOOLS_LIBRARY_VIEW_BACKGROUND_COLOR'] = unicode_type("snow")
prefs.defaults['GUI_TOOLS_LIBRARY_VIEW_ALTERNATING_COLOR'] = unicode_type("powderblue")
prefs.defaults['GUI_TOOLS_LIBRARY_VIEW_COLUMN_HEADING_COLOR_CHANGE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_LIBRARY_VIEW_COLOR_CONFIGURED'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_LIBRARY_VIEW_COLOR_ACTIVE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_LIBRARY_VIEW_COLOR_AUTORUN'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_STATUS_BAR_COLOR_CHANGE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_MAIN_GUI_COLOR_CONFIGURED'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_MAIN_GUI_COLOR_ACTIVE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_MAIN_GUI_COLOR_AUTORUN'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_MAIN_GUI_TEXT_COLOR'] = unicode_type("midnightblue")
prefs.defaults['GUI_TOOLS_MAIN_GUI_VIRTUAL_LIBRARY_COLOR'] = unicode_type("plum")
prefs.defaults['GUI_TOOLS_MAIN_GUI_SEARCHBAR_COLOR'] = unicode_type("seashell")
prefs.defaults['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_AUTOFILL_ACTIVE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE1_CUSTOM_COLUMN'] = unicode_type("#?")
prefs.defaults['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE1_VALUE'] = unicode_type("?")
prefs.defaults['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE2_CUSTOM_COLUMN'] = unicode_type("#?")
prefs.defaults['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE2_VALUE'] = unicode_type("?")
prefs.defaults['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE3_CUSTOM_COLUMN'] = unicode_type("#?")
prefs.defaults['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE3_VALUE'] = unicode_type("?")
prefs.defaults['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE4_CUSTOM_COLUMN'] = unicode_type("#?")
prefs.defaults['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE4_VALUE'] = unicode_type("?")

choices_dict = {}
choices_dict["tags"] = "True"
choices_dict["cc"] = "False"
cc_list = []
cc_list.append("#genre")
choices_dict["custom_columns"] = unicode_type(cc_list)
prefs.defaults['GUI_TOOLS_MEGA_METADATA_BOOK_HELPER_CHOICES_DICT'] = unicode_type(choices_dict)
del choices_dict
del cc_list

prefs.defaults['GUI_TOOLS_FTP_HOST'] = unicode_type("192.168.1.147")
prefs.defaults['GUI_TOOLS_FTP_HOST_DIRECTORY'] = unicode_type("/hostfolder/")
prefs.defaults['GUI_TOOLS_FTP_HOST_PORT'] = unicode_type("21")
prefs.defaults['GUI_TOOLS_FTP_USERID'] = unicode_type("myuserid")
prefs.defaults['GUI_TOOLS_FTP_PASSWORD'] = unicode_type("mypassword")
prefs.defaults['GUI_TOOLS_FTP_FORMAT'] = unicode_type("epub,pdf,docx")

prefs.defaults['GUI_TOOLS_ADD_NULL_VALUES_ACTIVE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_ADD_NULL_VALUES_AUTORUN'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_ADD_NULL_VALUES_LIBRARIES'] = unicode_type("CalibreJobSpyTest1|CalibreJobSpyTest2")
prefs.defaults['GUI_TOOLS_ADD_NULL_VALUES_COMMENTS'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_ADD_NULL_VALUES_TEXT'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_ADD_NULL_VALUES_TAGLIKE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_ADD_NULL_VALUES_SERIES'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_ADD_NULL_VALUES_BOOL'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_ADD_NULL_VALUES_INT'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_ADD_NULL_VALUES_FLOAT'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_ADD_NULL_VALUES_DATETIME'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_ADD_NULL_VALUES_IGNORE_NAMES'] = unicode_type("#ddc|#lcc|#lcead|#lc_genre|#oclc|#oclc_owi|#abc_hierarchy|#abc_numeric|#author_book_count")

prefs.defaults['GUI_TOOLS_USER_CATEGORIES_COPY_LAST_SOURCE_USER_CAT'] = unicode_type("")
prefs.defaults['GUI_TOOLS_USER_CATEGORIES_COPY_LAST_TARGET_LIBRARY'] = unicode_type("")

prefs.defaults['GUI_TOOLS_ACTIVATE_TWEAK_AUTHOR_SORT_COPY_METHOD'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_ACTIVATE_TWEAK_ADD_BOOKS_READ_METADATA_FROM_FILE_CONTENTS_NOT_NAME'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_ACTIVATE_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_DEFAULT_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY'] = unicode_type("")

prefs.defaults['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_DEFAULT_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY'] = unicode_type("")
prefs.defaults['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_DEFAULT_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] = unicode_type("{author_sort}/{title}/{title} - {authors}")
prefs.defaults['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_COVER_SEPARATELY_BY_LIBRARY'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_METADATA_IN_OPF_FILE_BY_LIBRARY'] = unicode_type("False")

prefs.defaults['GUI_TOOLS_ACTIVATE_TWEAK_TITLE_SERIES_SORTING_BY_LIBRARY'] = unicode_type("False")

prefs.defaults['GUI_TOOLS_ACTIVATE_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_DEFAULT_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY'] = unicode_type("EPUB")

prefs.defaults['GUI_TOOLS_ACTIVATE_TWEAK_METADATA_EDIT_CUSTOM_COLUMN_ORDER_BY_LIBRARY'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_DEFAULT_TWEAK_METADATA_EDIT_CUSTOM_COLUMN_ORDER_BY_LIBRARY'] = unicode_type("[]")

prefs.defaults['GUI_TOOLS_ACTIVATE_TWEAK_DEFAULT_AUTHOR_LINK_BY_LIBRARY'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_DEFAULT_TWEAK_DEFAULT_AUTHOR_LINK_BY_LIBRARY'] = DEFAULT_AUTHOR_LINK
prefs.defaults['GUI_TOOLS_CUSTOM_URL_TWEAK_DEFAULT_AUTHOR_LINK_BY_LIBRARY'] = unicode_type("")

prefs.defaults['GUI_TOOLS_ACTIVATE_TWEAK_TAG_BROWSER_CATEGORY_ORDER'] = unicode_type("False")

prefs.defaults['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_REGEXP'] = unicode_type("[ ][de du la]+[ ][a-z]+$|[ ][von und zu der]+[ ][a-z]+$|[ ][van der]+[ ][a-z]+$")
prefs.defaults['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_IGNORE'] = unicode_type("Andre|Andrea|Ann|Anna|Anne|Arnar|Dan|Dane|Dean|Ed|Elle|Lael|Lea|Leal|Lee|Ove|Radden|Rae|Ray|Reene|Ren|Rene|Renee|Ron|Vande|Verde")

prefs.defaults['GUI_TOOLS_QUALITY_FIXES_ACTIVATE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_ACTIVATE_LIBRARIES'] = unicode_type("MyWorkBenchLibrary1|MyWorkBenchLibrary2")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_CLEAR_PUBLISHERS'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_CLEAR_TAGS'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_IGNORE_BOOK'] = unicode_type("Magazine|Periodical|Journal|Newspaper|Manga|Comics|(Jan(uary)?|Feb(ruary)?|Mar(ch)?|Apr(il)?|May|Jun(e)?|Jul(y)?|Aug(ust)?|Sep(tember)?|Oct(ober)?|Nov(ember)?|Dec(ember)?)\s+\d{1,2},\s+\d{4}|[0-9]+[-][0-9]+[ ][BC]*[AD]*|[0-9][0-9][0-9]*[-][0-9][0-9][0-9]*|Volumes [0-9]+[-][0-9]+|[0-9][0-9][/][0-9][0-9][/][0-9][0-9][0-9]*[0-9]*")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE'] = unicode_type("(?#COMMENT: ADD CUSTOM REs TO THE FAR LEFT. DO NOT CHANGE HERE.)[:] A Novel|[(][1-2][0-9][0-9][0-9][)]$|[(][a-zA-Z ]*[ ]Novels[)]$|[:] A Novel of Suspense|[:] A Novella$|[:] A Novel$|[(][v][0-9]+[.]*[0-9]*[)]$|[(]Contemporary Romance[)]|Microsoft Word|[.]doc$|[.]pdf$|[.]epub$|[.]txt$|[.]zip$|[.]rar$|[.]indd$|[.]png|[.]jpg|[*][*].+[*][*]$|[(]Size[:][0-9 .]+ [GMKB]+[)]$|[\[(]Complete[\])]|^[- ]+|[- ]+$|[(][)]|[,][ ]*The$|[9][7][8][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]|New Deluxe Edition|A New Adult Romance|Bdsm Erotic Romance|Bbw Romance|Epilogue|Harlequin Superromance|Motorcycle Club Romance|BBW Paranormal Werewolf Shifter Romance")
#~ this implicitly assumes (with statistical justification) that the series and series index have some type of pattern or delimiters, and that the actual title is not so delimited.  if the title is so marked but not the series, then not much will be done here.
#~ to capture the series with index with or without a decimal, use   [0-9]+[.]*[0-9]*   instead of    [0-9]+
#~ to capture alphabetic words, use    [a-z ,&' -]+   instead of just [a-z ]+   so that punctuation within and among the words is captured
#~ regex is sorted by most specific to the left, and most generic to the far right. this is "split" at the "|", that list looped thru, and !!!the first search match wins!!! changing this order or adding new values not in this order will cause many selection errors.  1,000 books were tested in debug with this default value, and it was also tested at pythex.org.
r = "(?#COMMENT: ADD CUSTOM REs TO THE FAR LEFT. DO NOT CHANGE HERE.)[, ]+part[ ]+[0-9]+[.]*[0-9]*$|The [a-z ]+[ ]Book[s]*[ ]*[0-9]+[.]*[0-9]*$|episode [0-9]+[.]*[0-9]*$|[\[( ][a-z ,&' -]+[-, :;_]+book[ #]+[0-9]+[.]*[0-9]*[\]]|[:_][ ]+[a-z ,&' -]+[-, :;_]+book[ #]+[0-9]+[.]*[0-9]*|[\[(][a-z -]+Trilogy[ ][0-9]+[.]*[0-9]*[\])]|[\[(]+[a-z ,&' -]+series[\])]+|[ ]+Volume[ ]+[0-9]+[.]*[0-9]*$|[(][a-z '-]+[)][ ]*[(]Volume [0-9]+[.]*[0-9]*[)]$|[\[(][a-z ,&' -][:]*[ ]*[0-9]+[.]*[0-9]*[\])]|[\[(][a-z ,&' -][:]*[ ]*[#][0-9]+[\])]|[\[( ][a-z ,&' -]+[0-9]+[.]*[0-9]*[[\])]|[\[( ][a-z ,&' -]+[\])]|[ :; -]+[\[(][a-z  ' -,]+[:]*[ ]*[#]*[0-9]+[.]*[0-9]*[\])]|[\[(][a-z ,&' -]+[ ][0-9]+[.]*[0-9]*[\])]|[\[(][a-z ,&' -]+[\])]$|[,-:][ ]+[a-z &' ]+[ ]+[[0-9]+[.]*[0-9]*$|^[a-z ,&' ]+[ ]*[#][0-9]+[:]*|^[a-z ,&' -]+[ ]*[0-9]+[.]*[0-9]*[- ]+|^[a-z ,&' -]+[0-9]+[.]*[0-9]*|^[a-z ,&' -]+[,]*[ ]+Part [0-9]+[.]*[0-9]*[:]|^[a-z ,&' -]+[0-9]+[.]*[0-9]*[-]*[:]*[;]*|^[a-z '-]+Vol[. ]+[0-9]+[.]*[0-9]*|^[a-z '-]+[ ][0-9]+[.]*[0-9]*$|^[a-z '-]+[#]*[0-9]+[.]*[0-9]*[ -:]+|[ ]*[\(][a-z ,&' -]+[\)][ ]*$|[-:; ]+[a-z ,&' -]+[,]*[:]*[ ]*[#]*[0-9]+[.]*[0-9]*$|[a-z &'-]+[ ][0-9]+[.]*[0-9]*[ -]+|[,][ ][a-z &']+[ ][0-9]+[.]*[0-9]*$|[- ]+[a-z ,&' -]+[0-9]+[.]*[0-9]*[:]*[;]*"
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE'] = unicode_type(r)
r = "(?#COMMENT: ADD CUSTOM REs TO THE FAR LEFT. DO NOT CHANGE HERE.)[#][ ]*[0-9]+[.]*[0-9]*|[\[][ ]*[#][#]*[0-9]+[.]*[0-9]*[\]]|[(][a-z ]+Book [0-9]+[.]*[0-9]*[)]$|[(][a-z ][)]$|[:][ ][a-z ]+[,] Book [0-9]+[.]*[0-9]*$|^[a-z ]+[0-9]+[.]*[0-9]*[:-][ ]|[(][a-z ]+[#][0-9]+[.]*[0-9]*[ ]*[)]|^Book[0-9 -]+|[(]Book[ ]+[0-9]+[.]*[0-9]*[)]$"
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE'] = unicode_type(r)
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE'] = unicode_type("(?#COMMENT: ADD CUSTOM REs TO THE FAR LEFT. DO NOT CHANGE HERE.)[, - : ; ]+$|[(][ ]*[)]|[\[][ ]*[\]]|^[- ]+|[- ]+$")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_ORIGINAL_TITLE_CUSTOM_COLUMN'] = unicode_type("#orig_title")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_SERIES_ORIGINAL_SERIES_CUSTOM_COLUMN'] = unicode_type("#orig_series")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE_VERSION'] = unicode_type("1.0.106")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE_VERSION'] = unicode_type("1.0.106")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE_VERSION'] = unicode_type("1.0.106")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE_VERSION'] = unicode_type("1.0.106")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_TITLECASE_TITLES'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_TITLECASE_TITLES_ADVANCED'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_UPDATE_TITLE_SORTS'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_ORIGINAL_AUTHORS_CUSTOM_COLUMN'] = unicode_type("#orig_authors")
#~ regex is sorted by most specific to the left, and most generic to the far right. this is "split" at the "|", that list looped thru. changing this order or adding new values not in this order will cause many selection errors.  1,000 books were tested in debug with this default value, and it was also tested at pythex.org.
r = "^[-]|^[\*]$|Edited by|editor|[(]ed[)]|retail|[.]*pdf|[(][v][0-9][.][0][)]+|[(][ ]*[)]|^[()]|[()]$|[-][ ]+[a-z][a-z ]+[0-9][-][0-9]$|[-][ ]+[a-z][a-z ]+$|^[.][0-9]+[.]+|[#]+|[0-9]+[.]*[0-9]*|[(][a-z ]+$|[(].+$|[,-.:;(].$"
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_RESIDUAL_ARTIFACTS_REGEX_DELETE'] = unicode_type(r)
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_CHANGE_AUTHORS_FNLN'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_CHANGE_AUTHORS_LNFN'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_INITIALS'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_INITIALS_MODE'] = unicode_type("A.B.")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_SORTS'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_UPDATE_PSEUDONYMS']  = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_APPLY_DEFAULT_VALUES'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_ISBN'] = unicode_type("True")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_EXTRACT_ISBN_JOB'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_POLISH_BOOKS_JOB'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_RESIZE_COVER_PLUGIN'] = unicode_type("False")
del r

prefs.defaults['GUI_TOOLS_APPLY_DEFAULT_VALUES_1_ACTIVATE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_APPLY_DEFAULT_VALUES_1_CUSTOM_COLUMN'] = unicode_type("")
prefs.defaults['GUI_TOOLS_APPLY_DEFAULT_VALUES_1_VALUE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_APPLY_DEFAULT_VALUES_2_ACTIVATE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_APPLY_DEFAULT_VALUES_2_CUSTOM_COLUMN'] = unicode_type("")
prefs.defaults['GUI_TOOLS_APPLY_DEFAULT_VALUES_2_VALUE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_APPLY_DEFAULT_VALUES_3_ACTIVATE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_APPLY_DEFAULT_VALUES_3_CUSTOM_COLUMN'] = unicode_type("")
prefs.defaults['GUI_TOOLS_APPLY_DEFAULT_VALUES_3_VALUE'] = unicode_type("False")

prefs.defaults['GUI_TOOLS_COPY_TO_LIBRARY_SHORTCUT_DEFAULT_DIRECTORY'] = unicode_type("/")

prefs.defaults['GUI_TOOLS_UCCBOACC_ACTIVE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_1'] = unicode_type("#?")
prefs.defaults['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_VALUE_1'] = unicode_type("")
prefs.defaults['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_1'] = unicode_type("#?")
prefs.defaults['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_VALUE_1'] = unicode_type("")
prefs.defaults['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_2'] = unicode_type("")
prefs.defaults['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_VALUE_2'] = unicode_type("")
prefs.defaults['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_2'] = unicode_type("")
prefs.defaults['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_VALUE_2'] = unicode_type("")

prefs.defaults['GUI_TOOLS_AUTHOR_PSEUDONYMS_CUSTOM_COLUMN'] = unicode_type("#real_author")
prefs.defaults['GUI_TOOLS_AUTHOR_PSEUDONYMS_DEFAULT_CSV_DIRECTORY'] = unicode_type("/")

history_list = []
if iswindows:
    history_list.append("C:/Program Files/Agent Ransack/AgentRansack.exe")
    history_list.append("C:/Program Files/LibreOffice/program/soffice.exe")
    history_list.append("C:/Program Files/Mozilla Firefox/firefox.exe")
    history_list.append("C:/Program Files/7-Zip/7zFM.exe")
    history_list.append("C:/Windows/explorer.exe")
    history_list.append("C:/Windows/notepad.exe")
    history_list.append("C:/Windows/regedit.exe")
    history_list.append("C:/Windows/write.exe")
    history_list.sort()
history_list = as_unicode(history_list)
prefs.defaults['GUI_TOOLS_RUN_ARBITRARY_PROGRAMS_HISTORY_LIST'] = unicode_type(history_list)
prefs.defaults['GUI_TOOLS_RUN_ARBITRARY_PROGRAMS_HISTORY_LIST_LAST_SELECTED'] = unicode_type("")
prefs.defaults['GUI_TOOLS_RUN_ARBITRARY_PROGRAMS_HISTORY_LIST_CURRENT_DIRECTORY'] = unicode_type("")
del history_list

prefs.defaults['GUI_TOOLS_TAGBROWSER_ICONS_DEFAULT_SEARCH_DIRECTORY'] = unicode_type("/")
prefs.defaults['GUI_TOOLS_TAGBROWSER_ICONS_AUTO_SET_AT_STARTUP'] = unicode_type("False")
regex_list = []
regex_list.append("^.+$")
regex_list = as_unicode(regex_list)
prefs.defaults['GUI_TOOLS_TAGBROWSER_ICONS_REGEX_COMPLETER_LIST'] = unicode_type(regex_list)
del regex_list

prefs.defaults['GUI_TOOLS_VIRTUAL_LIBRARIES_COPY_LAST_TARGET_LIBRARY'] = unicode_type("")
prefs.defaults['GUI_TOOLS_VIRTUAL_LIBRARIES_COPY_LAST_SOURCE_VIRTUAL_LIBRARY'] = unicode_type("")

prefs.defaults['GUI_TOOLS_TAG_RULES_DEFAULT_CSV_DIRECTORY'] = unicode_type("/")

prefs.defaults['GUI_TOOLS_IMPORT_CSV_FILE_TO_UPDATE_METADATA_DEFAULT_DIRECTORY'] = unicode_type("/")
sql = "SELECT book FROM books_tags_link WHERE tag IN (SELECT id FROM tags WHERE name REGEXP '^.+$'  )"
prefs.defaults['GUI_TOOLS_IMPORT_CSV_FILE_TO_UPDATE_METADATA_RAW_SQL'] = unicode_type(sql)
del sql
opt_filename_dict = {}
opt_dict = {}
opt_filename_dict['DEFAULT'] = opt_dict
opt_filename_dict = as_unicode(opt_dict)
prefs.defaults['GUI_TOOLS_IMPORT_CSV_FILE_TO_UPDATE_METADATA_OPTIONS_DICT'] = unicode_type(opt_filename_dict)
del opt_filename_dict
del opt_dict

prefs.defaults['GUI_TOOLS_UPDATE_LAST_VIEWED_CUSTOM_COLUMN_AUTOMATICALLY_ACTIVATE'] = unicode_type("False")
prefs.defaults['GUI_TOOLS_UPDATE_LAST_VIEWED_CUSTOM_COLUMN_AUTOMATICALLY_COLUMN_NAME'] = unicode_type("#mylastviewed")
prefs.defaults['GUI_TOOLS_UPDATE_LAST_VIEWED_CUSTOM_COLUMN_AUTOMATICALLY_LIBRARIES'] = unicode_type("CalibreLibrary1|CalibreLibrary2|CalibreLibrary3")

prefs.defaults['GUI_TOOLS_BIBLIOGRAPHY_TEXT_TEMPLATE'] = unicode_type("AUTHOR_SORT ET AL. 'TITLE'. SERIES, no. SERIES_INDEX (MONTH YYYY) PUBLISHER.")

prefs.defaults['GUI_TOOLS_RIS_CITATION_FILE_SPLIT_SETS_OF_TAGS'] = ""  #all py3 & qt6+ now

prefs.defaults['GUI_TOOLS_CONVERT_BIB_FORMAT_TO_RIS_FORMAT_DIR'] = ""

prefs.defaults['GUI_TOOLS_CONVERT_NBIB_FORMAT_TO_RIS_FORMAT_DIR'] = ""


prefs.defaults['GUI_TOOLS_NOTES_VIEWER_LAST_LIBRARY_USED'] = ""
prefs.defaults['GUI_TOOLS_NOTES_VIEWER_LAST_CUSTOM_COLUMN_USED'] = ""
prefs.defaults['GUI_TOOLS_NOTES_VIEWER_LAST_BOOKID_VIEWED'] = "0"
prefs.defaults['GUI_TOOLS_NOTES_VIEWER_INSTANCE_1_LAST_CUSTOM_COLUMN_VIEWED'] = ""
prefs.defaults['GUI_TOOLS_NOTES_VIEWER_INSTANCE_2_LAST_CUSTOM_COLUMN_VIEWED'] = ""
prefs.defaults['GUI_TOOLS_NOTES_VIEWER_INSTANCE_3_LAST_CUSTOM_COLUMN_VIEWED'] = ""
prefs.defaults['GUI_TOOLS_NOTES_VIEWER_INSTANCE_1_LAST_BOOKID_VIEWED'] = ""
prefs.defaults['GUI_TOOLS_NOTES_VIEWER_INSTANCE_2_LAST_BOOKID_VIEWED'] = ""
prefs.defaults['GUI_TOOLS_NOTES_VIEWER_INSTANCE_3_LAST_BOOKID_VIEWED'] = ""
library_options_dict = {}
prefs.defaults['GUI_TOOLS_NOTES_VIEWER_CUSTOMIZATION_BY_LIBRARY'] = as_unicode(library_options_dict)
del library_options_dict
prefs.defaults['GUI_TOOLS_NOTES_VIEWER_DEFAULT_CUSTOM_COLUMN_GLOBAL'] = ""

tmp_list = []
tmp_list.append('GUI_TOOLS_NOTES_VIEWER_INSTANCE_2_LAST_BOOKID_VIEWED')
tmp_list.append('GUI_TOOLS_NOTES_VIEWER_INSTANCE_2_LAST_CUSTOM_COLUMN_VIEWED')
tmp_list.append('GUI_TOOLS_NOTES_VIEWER_INSTANCE_3_LAST_BOOKID_VIEWED')
tmp_list.append('GUI_TOOLS_NOTES_VIEWER_INSTANCE_3_LAST_CUSTOM_COLUMN_VIEWED')
NOTES_VIEW_INSTANCE_SPECIFIC_PREFS_KEYS_SET = set(tmp_list)
del tmp_list

tmp_list = []
tmp_list.append('GUI_TOOLS_NOTES_VIEWER_INSTANCE_1_LAST_BOOKID_VIEWED')
tmp_list.append('GUI_TOOLS_NOTES_VIEWER_INSTANCE_1_LAST_CUSTOM_COLUMN_VIEWED')
tmp_list.append('GUI_TOOLS_NOTES_VIEWER_LAST_BOOKID_VIEWED')
tmp_list.append('GUI_TOOLS_NOTES_VIEWER_LAST_CUSTOM_COLUMN_USED')
tmp_list.append('GUI_TOOLS_NOTES_VIEWER_LAST_LIBRARY_USED')
NOTES_VIEW_PARENT_INSTANCE_SPECIFIC_PREFS_KEYS_SET = set(tmp_list)
del tmp_list

#-----------------------------------------------------
#-----------------------------------------------------
PREFS_NAMESPACE = 'JobSpyPlugin'
PREFS_KEY_SETTINGS = 'settings'
#-----------------------------------------------------
#-----------------------------------------------------
class ConfigWidget(QWidget):

    def __init__(self):

        QWidget.__init__(self)

        from calibre.gui2.ui import get_gui
        self.maingui = get_gui()
        self.guidb = self.maingui.library_view.model().db

        tip = "<p style='white-space:wrap'>JS+ Job Spy and GUI Tools Customization.<br><br>Each item has its own ToolTip to explain its purpose.<br><br>If the widgets are too close together for viewing ease, manually make the window bigger so they can automatically separate based on function."

        self.layout_frame = QVBoxLayout()
        self.setLayout(self.layout_frame)
        self.layout_frame.setAlignment(Qt.AlignCenter)
        self.setToolTip(tip)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame = QScrollArea()
        self.scroll_area_frame.setAlignment(Qt.AlignCenter)
        self.scroll_area_frame.setWidgetResizable(True)
        self.scroll_area_frame.ensureVisible(600,600)

        self.layout_frame.addWidget(self.scroll_area_frame)       # the scroll area is now the child of the parent of self.layout_frame

        # NOTE: the self.scroll_area_frame.setWidget(self.scroll_widget) is at the end of the init() AFTER all children have been created and assigned to a layout...
        #-----------------------------------------------------
        self.scroll_widget = QWidget()
        self.layout_frame.addWidget(self.scroll_widget)           # causes automatic reparenting of QWidget to the parent of self.layout_frame, which is:  self .
        #-----------------------------------------------------
        self.layout_top = QVBoxLayout()
        self.layout_top.setSpacing(0)
        self.layout_top.setAlignment(Qt.AlignCenter)
        #-----------------------------------------------------
        self.scroll_widget.setLayout(self.layout_top)        # causes automatic reparenting of any widget later added below to the above parent
        #-----------------------------------------------------

        font = QFont()

        font.setBold(False)
        font.setPointSize(10)

        #----------------------------------------

        #~ for k,v in prefs.defaults.iteritems():
        for k,v in iteritems(prefs.defaults):
            if k in prefs:
                continue
            else:
                prefs[k] = v
                prefs
        #END FOR

        #----------------------------------------

        self.show_guitool_tooltips_checkbox = QCheckBox("Automatically Show JS+ Menu ToolTips? [Change Requires Restart]")
        self.show_guitool_tooltips_checkbox.setToolTip("<p style='white-space:wrap'>Do you want to read the menu ToolTips? ")
        self.layout_top.addWidget(self.show_guitool_tooltips_checkbox)

        if prefs['GUI_TOOLS_SHOW_TOOLTIPS'] == unicode_type("True"):
            self.show_guitool_tooltips_checkbox.setChecked(True)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_13_label = QLabel("")
        self.layout_top.addWidget(self.spacer_13_label)
        #--------------------------------------------------
        #--------------------------------------------------

        tip = "<p style='white-space:wrap'>Job Spy will present the Job Details of the last N Jobs starting with the very latest Job.  If you have 10 jobs, but your Maximum is set to 3, then only the last 3 jobs to execute will be presented for inspection.  If you have zero jobs, nothing will happen."

        self.max_jobs_spin = QSpinBox(self)
        self.max_jobs_spin.setMinimum(1)
        self.max_jobs_spin.setMaximum(100)
        self.max_jobs_spin.setSuffix("        Maximum Number of Job Details to Show Consecutively")
        #~ self.max_jobs_spin.setMinimumWidth(300)
        self.max_jobs_spin.setToolTip(tip)
        self.max_jobs_spin.setProperty('value',prefs['JOBS_TO_SHOW_CONSECUTIVELY'])
        self.layout_top.addWidget(self.max_jobs_spin)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_6_label = QLabel("")
        self.layout_top.addWidget(self.spacer_6_label)
        #--------------------------------------------------
        #--------------------------------------------------

        self.searchbar_autorun_checkbox = QCheckBox("Automatically increase the Search Bar Visible Items and Search History to 100 at Calibre startup?")
        self.searchbar_autorun_checkbox.setToolTip("<p style='white-space:wrap'>Automatically increase the Search Bar Visible Items and Search History to 100 at Calibre startup?")
        self.layout_top.addWidget(self.searchbar_autorun_checkbox)

        if prefs['GUI_TOOLS_VISIBLE_ITEMS_SEARCHBAR_AUTORUN'] == unicode_type("True"):
            self.searchbar_autorun_checkbox.setChecked(True)

        font.setPointSize(8)

        self.purge_additional_search_history_pushbutton = QPushButton("Purge 'Additional' Search History Immediately")
        self.purge_additional_search_history_pushbutton.setMaximumWidth(300)
        self.purge_additional_search_history_pushbutton.clicked.connect(self.purge_additional_history)
        self.purge_additional_search_history_pushbutton.setDefault(False)
        self.purge_additional_search_history_pushbutton.setFont(font)
        self.purge_additional_search_history_pushbutton.setToolTip("<p style='white-space:wrap'>Purge the additional search history accumulated so far.  Only the first (newest) 25 history items will be retained.  After restarting Calibre, you must perform at least one (1) search to trigger Calibre to save the shorter history.")
        self.layout_top.addWidget(self.purge_additional_search_history_pushbutton)

        font.setPointSize(10)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_11_label = QLabel("")
        self.layout_top.addWidget(self.spacer_11_label)
        #--------------------------------------------------
        #--------------------------------------------------

        self.layout_daemon = QHBoxLayout()
        self.layout_daemon.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_daemon)

        self.daemon_interval_spin = QSpinBox(self)
        self.daemon_interval_spin.setMinimum(6)
        self.daemon_interval_spin.setMaximum(10)
        self.daemon_interval_spin.setSuffix("        How often the Dropdown Visible Items daemon 'runs' to check for the Edit Metadata dialog so it can be tweaked")
        self.daemon_interval_spin.setMaximumWidth(900)
        self.daemon_interval_spin.setToolTip("<p style='white-space:wrap'>How often the daemon 'runs' to check for the Edit Metadata dialogs so they can be tweaked.  Minimum: 6 seconds.  Maximum: 10 seconds.  Recommended: 8 seconds.")
        self.daemon_interval_spin.setProperty('value',prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_INTERVAL'])
        self.layout_daemon.addWidget(self.daemon_interval_spin)

        self.daemon_autorun_checkbox = QCheckBox("Automatically start the Edit Metadata Dropdown Visible Items Increaser daemon at Calibre startup?")
        self.daemon_autorun_checkbox.setToolTip("<p style='white-space:wrap'>Automatically start the Dropdown Visible Items daemon at Calibre startup?<br><br>New Job Spy users might have to restart Calibre twice after checking this box before the daemon starts automatically.<br><br>If Calibre does not shut down properly, the daemon will not be started automatically until after the next proper Calibre shutdown.")
        self.layout_top.addWidget(self.daemon_autorun_checkbox)

        if prefs['GUI_TOOLS_VISIBLE_ITEMS_EDIT_METADATA_AUTORUN'] == unicode_type("True"):
            self.daemon_autorun_checkbox.setChecked(True)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_5_label = QLabel("")
        self.layout_top.addWidget(self.spacer_5_label)
        #--------------------------------------------------
        #--------------------------------------------------

        font.setPointSize(8)

        self.layout_original_title = QHBoxLayout()
        self.layout_original_title.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_original_title)

        self.extract_original_title_qlabel = QLabel("Extract Original Title/Translator:   ")
        self.extract_original_title_qlabel.setToolTip("<p style='white-space:wrap'>Used by the GUI Tool of the same name.")
        #~ self.extract_original_title_qlabel.setMaximumWidth(250)
        self.layout_original_title.addWidget(self.extract_original_title_qlabel)

        s = prefs['GUI_TOOLS_EXTRACT_ORIGINAL_TITLE_KEYWORD']
        s = s.strip()
        if s.endswith("|"):
            s = s[0:-1]

        self.extract_original_title_keyword_qlineedit = QLineEdit(self)
        self.extract_original_title_keyword_qlineedit.setText(s)
        self.extract_original_title_keyword_qlineedit.setFont(font)
        self.extract_original_title_keyword_qlineedit.setToolTip("<p style='white-space:wrap'>These are the textual keywords for which to search to find the Original Title.  Separate each keyword with a bar, '|'. These are the words found in the front of books that have an Original Title and/or Translator.")
        self.extract_original_title_keyword_qlineedit.setCursorPosition(0)
        #~ self.extract_original_title_keyword_qlineedit.setMaximumWidth(500)
        self.layout_original_title.addWidget(self.extract_original_title_keyword_qlineedit)

        self.extract_original_title_custom_column_qlineedit = QLineEdit(self)
        self.extract_original_title_custom_column_qlineedit.setText(prefs['GUI_TOOLS_EXTRACT_ORIGINAL_TITLE_CUSTOM_COLUMN'])
        self.extract_original_title_custom_column_qlineedit.setFont(font)
        self.extract_original_title_custom_column_qlineedit.setToolTip("<p style='white-space:wrap'>CRITICAL: This is the <u><b>'Long Text, like Comments (NOT shown in the Tag Browser) - Interpret this Column as Short Text, Like a Title'</b></u> Custom Column Search/Lookup #name to be updated with the Original Title.")
        self.extract_original_title_custom_column_qlineedit.setCursorPosition(0)
        #~ self.extract_original_title_custom_column_qlineedit.setMaximumWidth(100)
        self.layout_original_title.addWidget(self.extract_original_title_custom_column_qlineedit)


        self.layout_translator = QHBoxLayout()
        self.layout_translator.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_translator)

        self.extract_translator_qlabel = QLabel("Extract Original Title/Translator:   ")
        self.extract_translator_qlabel.setToolTip("<p style='white-space:wrap'>Used by the GUI Tool of the same name.")
        #~ self.extract_translator_qlabel.setMaximumWidth(250)
        self.layout_translator.addWidget(self.extract_translator_qlabel)

        s = prefs['GUI_TOOLS_EXTRACT_TRANSLATOR_KEYWORD']
        s = s.strip()
        if s.endswith("|"):
            s = s[0:-1]

        self.extract_translator_keyword_qlineedit = QLineEdit(self)
        self.extract_translator_keyword_qlineedit.setText(s)
        self.extract_translator_keyword_qlineedit.setFont(font)
        self.extract_translator_keyword_qlineedit.setToolTip("<p style='white-space:wrap'>These are the textual keywords for which to search to find the Translator.  Separate each keyword with a bar, '|'. These are the words found in the front of books that have an Original Title and/or Translator.")
        #~ self.extract_translator_keyword_qlineedit.setMaximumWidth(500)
        self.extract_translator_keyword_qlineedit.setCursorPosition(0)
        self.layout_translator.addWidget(self.extract_translator_keyword_qlineedit)

        self.extract_translator_custom_column_qlineedit = QLineEdit(self)
        self.extract_translator_custom_column_qlineedit.setText(prefs['GUI_TOOLS_EXTRACT_TRANSLATOR_CUSTOM_COLUMN'])
        self.extract_translator_custom_column_qlineedit.setFont(font)
        self.extract_translator_custom_column_qlineedit.setToolTip("<p style='white-space:wrap'>'CRITICAL: This is the <u><b>'Long Text, like Comments (NOT shown in the Tag Browser) - Interpret this Column as Short Text, Like a Title</b></u> Custom Column Search/Lookup #name to be updated with the Translator.")
        #~ self.extract_translator_custom_column_qlineedit.setMaximumWidth(100)
        self.extract_translator_custom_column_qlineedit.setCursorPosition(0)
        self.layout_translator.addWidget(self.extract_translator_custom_column_qlineedit)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_9_label = QLabel("")
        self.layout_top.addWidget(self.spacer_9_label)
        #--------------------------------------------------
        #--------------------------------------------------

        self.auto_delete_temp_reading_lists_checkbox = QCheckBox("Automatically Delete Current Library's Temporary Reading Lists at Calibre Shutdown?   [ !ReadingLists ]")
        self.auto_delete_temp_reading_lists_checkbox.setToolTip("<p style='white-space:wrap'>Do you want to automatically delete Reading Lists that begin with an exclamation, '!',  whenever Calibre shuts down?<br><br>Current Calibre Library at Shutdown Only.")
        self.layout_top.addWidget(self.auto_delete_temp_reading_lists_checkbox)

        if prefs['GUI_TOOLS_AUTO_DELETE_TEMPORARY_READING_LISTS'] == unicode_type("True"):
            self.auto_delete_temp_reading_lists_checkbox.setChecked(True)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_12_label = QLabel("")
        self.layout_top.addWidget(self.spacer_12_label)
        #--------------------------------------------------
        #--------------------------------------------------

        self.layout_vl_views = QHBoxLayout()
        self.layout_vl_views.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_vl_views)

        self.vl_views_active_checkbox = QCheckBox("Activate VL Views?   REGEX:")
        #~ self.vl_views_active_checkbox.setMaximumWidth(200)
        self.vl_views_active_checkbox.setToolTip("<p style='white-space:wrap'>Find and apply the View Manager 'View' that matches the Regular Expression search upon the Virtual Library Name \
        whenever this GUI Tool is triggered via a shortcut to the JS+ menu, or the Favourites menu?")
        self.layout_vl_views.addWidget(self.vl_views_active_checkbox)

        self.vl_regex_qlineedit = QLineEdit(self)
        self.vl_regex_qlineedit.setText(prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_REGEX'])
        self.vl_regex_qlineedit.setFont(font)
        self.vl_regex_qlineedit.setToolTip("<p style='white-space:wrap'>This is the Regular Expression that is used via a shortcut to match a Virtual Library Name to a View Manager View Name.\
                                                               <br><br>Example:  to match '---36' at the very end of both Names in order to dynamically link them, a Regular Expression of '[-][-][-][0-9]+$' would be used.\
                                                               <br><br>Your desired Regular Expression will be tested when you click 'OK', and if it fails, you will be notified, and all of the associated checkboxes will be cleared.")
        #~ self.vl_regex_qlineedit.setMaximumWidth(100)
        self.vl_regex_qlineedit.setCursorPosition(0)
        self.layout_vl_views.addWidget(self.vl_regex_qlineedit)

        if prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_ACTIVE'] == unicode_type("True"):
            self.vl_views_active_checkbox.setChecked(True)

        #--------------------------------------------------
        if 'GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_CLICK_RELEASE_ACTIVE' in prefs:
            del prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_CLICK_RELEASE_ACTIVE']       #deprecated 2020 02 20; use a shortcut instead.
            prefs
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_4_label = QLabel("")
        self.layout_top.addWidget(self.spacer_4_label)
        #--------------------------------------------------
        #--------------------------------------------------

        t = "<p style='white-space:wrap'>While copying a book from one Library to another Library, \
        do you want for Calibre to <b>NOT</b> create a message about your 'from' Library having Custom Columns that your 'to' Library does not?\
        <br><br>Important Note:  If you create a New Library while within another Calibre Library, Calibre will automatically switch to that New Library.\
        If you then switch to a prexisting Calibre Library and copy a book from that Library to the New Library, you <b>will</b> see the Custom Column messages if appropriate.\
        That is because these settings are applied when Calibre first starts.  If you change these settings, you must Restart Calibre.  Likewise, if you create new Libraries and want them\
         included in the next copy action, you must first Restart Calibre."


        self.missing_cc_dialog_active_checkbox = QCheckBox("Ignore Copy-to-Library Custom Column Messages for Specified Source-Target Combinations? [Changes Require Restart]")
        self.missing_cc_dialog_active_checkbox.setToolTip(t)
        self.layout_top.addWidget(self.missing_cc_dialog_active_checkbox)

        if prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_ACTIVE'] == unicode_type("True"):
            self.missing_cc_dialog_active_checkbox.setChecked(True)

        self.layout_missing_cc_dialog_line_1 = QHBoxLayout()
        self.layout_missing_cc_dialog_line_1.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_missing_cc_dialog_line_1)

        self.source_library_qlabel1 = QLabel("Source(s):")
        self.source_library_qlabel1.setToolTip("<p style='white-space:wrap'>Source means 'From'")
        #~ self.source_library_qlabel1.setMaximumWidth(75)
        self.layout_missing_cc_dialog_line_1.addWidget(self.source_library_qlabel1)

        self.from_library_name1_qlineedit = QLineEdit(self)
        self.from_library_name1_qlineedit.setText(prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_SOURCES_1'])
        self.from_library_name1_qlineedit.setFont(font)
        self.from_library_name1_qlineedit.setToolTip("<p style='white-space:wrap'>Specify the Source/From Library Names for this 'ignore' rule.  A wildcard of '*' means 'all known Calibre Libraries'.  Separate multiple Library Names with a bar '|'.")
        #~ self.from_library_name1_qlineedit.setMaximumWidth(300)
        self.layout_missing_cc_dialog_line_1.addWidget(self.from_library_name1_qlineedit)

        self.target_library_qlabel1 = QLabel("Target(s):")
        self.target_library_qlabel1.setToolTip("<p style='white-space:wrap'>Target means 'To'")
        #~ self.target_library_qlabel1.setMaximumWidth(75)
        self.layout_missing_cc_dialog_line_1.addWidget(self.target_library_qlabel1)

        self.to_library_name1_qlineedit = QLineEdit(self)
        self.to_library_name1_qlineedit.setText(prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_TARGETS_1'])
        self.to_library_name1_qlineedit.setFont(font)
        self.to_library_name1_qlineedit.setToolTip("<p style='white-space:wrap'>Specify the Target/To Library Names for this 'ignore' rule.  A wildcard of '*' means 'all known Calibre Libraries'.  Separate multiple Library Names with a bar '|'.  ")
        #~ self.to_library_name1_qlineedit.setMaximumWidth(300)
        self.layout_missing_cc_dialog_line_1.addWidget(self.to_library_name1_qlineedit)

        self.layout_missing_cc_dialog_line_2 = QHBoxLayout()
        self.layout_missing_cc_dialog_line_2.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_missing_cc_dialog_line_2)

        self.source_library_qlabel2 = QLabel("Source(s):")
        self.source_library_qlabel2.setToolTip("<p style='white-space:wrap'>Source means 'From'")
        #~ self.source_library_qlabel2.setMaximumWidth(75)
        self.layout_missing_cc_dialog_line_2.addWidget(self.source_library_qlabel2)

        self.from_library_name2_qlineedit = QLineEdit(self)
        self.from_library_name2_qlineedit.setText(prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_SOURCES_2'])
        self.from_library_name2_qlineedit.setFont(font)
        self.from_library_name2_qlineedit.setToolTip("<p style='white-space:wrap'>Specify the Source/From Library Names for this 'ignore' rule.  A wildcard of '*' means 'all known Calibre Libraries'.  Separate multiple Library Names with a bar '|'.")
        #~ self.from_library_name2_qlineedit.setMaximumWidth(300)
        self.layout_missing_cc_dialog_line_2.addWidget(self.from_library_name2_qlineedit)

        self.target_library_qlabel2 = QLabel("Target(s):")
        self.target_library_qlabel2.setToolTip("<p style='white-space:wrap'>Target means 'To'")
        #~ self.target_library_qlabel2.setMaximumWidth(75)
        self.layout_missing_cc_dialog_line_2.addWidget(self.target_library_qlabel2)

        self.to_library_name2_qlineedit = QLineEdit(self)
        self.to_library_name2_qlineedit.setText(prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_TARGETS_2'])
        self.to_library_name2_qlineedit.setFont(font)
        self.to_library_name2_qlineedit.setToolTip("<p style='white-space:wrap'>Specify the Target/To Library Names for this 'ignore' rule.  A wildcard of '*' means 'all known Calibre Libraries'.  Separate multiple Library Names with a bar '|'.  ")
        #~ self.to_library_name2_qlineedit.setMaximumWidth(300)
        self.layout_missing_cc_dialog_line_2.addWidget(self.to_library_name2_qlineedit)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_3_label = QLabel("")
        self.layout_top.addWidget(self.spacer_3_label)
        #--------------------------------------------------
        #--------------------------------------------------

        self.groupbox_libraryview = QGroupBox('GUI Colors: Library View, Tag Browser')
        self.groupbox_libraryview.setToolTip("<p style='white-space:wrap'>This changes only Library View/Tag Browser. ")
        self.layout_top.addWidget(self.groupbox_libraryview)

        self.layout_library_view_groupbox = QVBoxLayout()
        self.groupbox_libraryview.setLayout(self.layout_library_view_groupbox)

        self.layout_library_view_colors = QHBoxLayout()
        self.layout_library_view_colors.setAlignment(Qt.AlignLeft)

        self.layout_library_view_groupbox.addLayout(self.layout_library_view_colors)

        self.text_color_label = QLabel("Text:")
        self.text_color_label.setToolTip("<p style='white-space:wrap'>These are 100% of the text colors available to choose from.  'Black' is the default neutral color.")
        self.layout_library_view_colors.addWidget(self.text_color_label)

        self.text_color_combobox = QComboBox()
        self.text_color_combobox.setEditable(False)
        self.text_color_combobox.setFont(font)
        self.text_color_combobox.setToolTip("<p style='white-space:wrap'>These are 100% of the text colors available to choose from.  'Black' is the default neutral color.")
        self.layout_library_view_colors.addWidget(self.text_color_combobox)

        self.background_color_label = QLabel("BG 1:")
        self.background_color_label.setToolTip("<p style='white-space:wrap'>These are 100% of the background colors available to choose from.  'Snow' is the default neutral color.")
        self.layout_library_view_colors.addWidget(self.background_color_label)

        self.background_color_combobox = QComboBox()
        self.background_color_combobox.setEditable(False)
        self.background_color_combobox.setFont(font)
        self.background_color_combobox.setToolTip("<p style='white-space:wrap'>These are 100% of the background colors available to choose from.  'Snow' is the default neutral color.")
        self.layout_library_view_colors.addWidget(self.background_color_combobox)

        self.alternating_color_label = QLabel("BG 2:")
        self.alternating_color_label.setToolTip("<p style='white-space:wrap'>These are 100% of the alternate background colors available to choose from.  'Gainsboro' is the default neutral color.")
        self.layout_library_view_colors.addWidget(self.alternating_color_label)

        self.alternating_color_combobox = QComboBox()
        self.alternating_color_combobox.setEditable(False)
        self.alternating_color_combobox.setFont(font)
        self.alternating_color_combobox.setToolTip("<p style='white-space:wrap'>These are 100% of the alternate background colors available to choose from.  'Gainsboro' is the default neutral color.")
        self.layout_library_view_colors.addWidget(self.alternating_color_combobox)

        color_list = QColor.colorNames()
        for color in color_list:
            self.text_color_combobox.addItem(color)
            self.background_color_combobox.addItem(color)
            self.alternating_color_combobox.addItem(color)
        #END FOR

        tc = prefs['GUI_TOOLS_LIBRARY_VIEW_TEXT_COLOR']
        bc = prefs['GUI_TOOLS_LIBRARY_VIEW_BACKGROUND_COLOR']
        ac = prefs['GUI_TOOLS_LIBRARY_VIEW_ALTERNATING_COLOR']

        self.text_color_combobox.setCurrentText(tc)
        self.background_color_combobox.setCurrentText(bc)
        self.alternating_color_combobox.setCurrentText(ac)

        self.text_color_combobox.setEditable(False)
        self.background_color_combobox.setEditable(False)
        self.alternating_color_combobox.setEditable(False)

        style_text = "background-color: [BC]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[BC]",bc)
        self.text_color_combobox.setStyleSheet(style_text)

        style_text = "background-color: [BC]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[BC]",bc)
        self.background_color_combobox.setStyleSheet(style_text)

        style_text = "background-color: [BC]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[BC]",ac)
        self.alternating_color_combobox.setStyleSheet(style_text)

        self.text_color_combobox.activated.connect(self.event_combo_box_colors_changed)
        self.background_color_combobox.activated.connect(self.event_combo_box_colors_changed)
        self.alternating_color_combobox.activated.connect(self.event_combo_box_colors_changed)

        self.apply_library_view_color_selections_pushbutton = QPushButton("Apply Selected Colors")
        self.apply_library_view_color_selections_pushbutton.clicked.connect(self.apply_library_view_color_selection)
        self.apply_library_view_color_selections_pushbutton.setDefault(False)
        self.apply_library_view_color_selections_pushbutton.setFont(font)
        self.apply_library_view_color_selections_pushbutton.setToolTip("<p style='white-space:wrap'>Change the GUI to the colors that have been selected in the dropdowns to the left.  This change is valid for this current Calibre session only.  To reset to Calibre 'factory settings', you must Restart Calibre without having checked the 'Automatically Apply' checkbox just above.")
        self.layout_library_view_colors.addWidget(self.apply_library_view_color_selections_pushbutton)

        #~ self.set_gui_to_neutral_pushbutton = QPushButton("Set GUI to Neutral")
        #~ self.set_gui_to_neutral_pushbutton.clicked.connect(self.set_gui_colors_to_neutral)
        #~ self.set_gui_to_neutral_pushbutton.setDefault(False)
        #~ self.set_gui_to_neutral_pushbutton.setFont(font)
        #~ self.set_gui_to_neutral_pushbutton.setToolTip("<p style='white-space:wrap'>Change the GUI to the default neutral colors: 'Black/Snow/Gainsboro'.  This change is valid for this current Calibre session only.  To reset to Calibre 'factory settings', you must Restart Calibre without having checked the 'Automatically Apply' checkbox just above.")
        #~ self.layout_library_view_colors.addWidget(self.set_gui_to_neutral_pushbutton)

        self.column_headings_color_checkbox = QCheckBox("The Library View Column/Row Headings should have this background color (not the default greyish color)?")
        self.column_headings_color_checkbox.setToolTip("<p style='white-space:wrap'>Do you want the 'Background 1' GUI color that you have specified above also to apply to the Column/Row Headings of the Library View?")
        self.layout_library_view_groupbox.addWidget(self.column_headings_color_checkbox)

        if prefs['GUI_TOOLS_LIBRARY_VIEW_COLUMN_HEADING_COLOR_CHANGE'] == unicode_type("True"):
            self.column_headings_color_checkbox.setChecked(True)

        #~ self.status_bar_color_checkbox = QCheckBox("The GUI Status Bar should follow this color scheme (not the one below)?")
        #~ self.status_bar_color_checkbox.setToolTip("<p style='white-space:wrap'>Do you want the 'Text' and 'Background 1' GUI colors that you have specified above also to apply to the Status Bar at the bottom of the GUI?")
        #~ self.layout_library_view_groupbox.addWidget(self.status_bar_color_checkbox)

        #~ if prefs['GUI_TOOLS_STATUS_BAR_COLOR_CHANGE'] == unicode_type("True"):
            #~ self.status_bar_color_checkbox.setChecked(True)

        self.autorun_color_selections_checkbox = QCheckBox("Automatically Apply the Selected GUI Colors at Calibre startup?")
        self.autorun_color_selections_checkbox.setToolTip("<p style='white-space:wrap'>Do you want the GUI colors that you have specified below to be automatically applied at Calibre Startup?")
        self.layout_library_view_groupbox.addWidget(self.autorun_color_selections_checkbox)

        if prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_AUTORUN'] == unicode_type("True"):
            self.autorun_color_selections_checkbox.setChecked(True)

        self.activate_color_selections_checkbox = QCheckBox("Activate this color scheme for use?")
        self.activate_color_selections_checkbox.setToolTip("<p style='white-space:wrap'>Do you want the GUI colors that you have specified to be able to be used?")
        self.layout_library_view_groupbox.addWidget(self.activate_color_selections_checkbox)

        if prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_ACTIVE'] == unicode_type("True"):
            self.activate_color_selections_checkbox.setChecked(True)

        #--------------------------------------------------
        #--------------------------------------------------

        self.groupbox_maindefault = QGroupBox('GUI Colors: Virtual Library')           # @ Calibre 6.8:  (GUI Colors: Virtual Library, Tool Bar, Search Bar, Search Buttons, Status Bar)
        self.groupbox_maindefault.setToolTip("<p style='white-space:wrap'>This changes the Virtual Library color.")
        self.layout_top.addWidget(self.groupbox_maindefault)

        self.layout_main_default_groupbox = QVBoxLayout()
        self.groupbox_maindefault.setLayout(self.layout_main_default_groupbox)

        self.layout_main_default_colors = QHBoxLayout()
        self.layout_main_default_colors.setAlignment(Qt.AlignLeft)

        self.layout_main_default_groupbox.addLayout(self.layout_main_default_colors)

        self.maingui_text_color_label = QLabel("Text:")
        self.maingui_text_color_label.setToolTip("<p style='white-space:wrap'>These are 100% of the text colors available to choose from.  'Black' is the default neutral color.")
        self.layout_main_default_colors.addWidget(self.maingui_text_color_label)

        self.maingui_text_color_combobox = QComboBox()
        self.maingui_text_color_combobox.setEditable(False)
        self.maingui_text_color_combobox.setFont(font)
        self.maingui_text_color_combobox.setToolTip("<p style='white-space:wrap'>These are 100% of the text colors available to choose from.  'Black' is the default neutral color.")
        self.layout_main_default_colors.addWidget(self.maingui_text_color_combobox)

        self.maingui_background_color_label = QLabel("VL:")
        self.maingui_background_color_label.setToolTip("<p style='white-space:wrap'>These are 100% of the VL background colors available to choose from.  'Snow' is the default neutral color.")
        self.layout_main_default_colors.addWidget(self.maingui_background_color_label)

        self.maingui_vl_color_combobox = QComboBox()
        self.maingui_vl_color_combobox.setEditable(False)
        self.maingui_vl_color_combobox.setFont(font)
        self.maingui_vl_color_combobox.setToolTip("<p style='white-space:wrap'>These are 100% of the VL background colors available to choose from.  'Snow' is the default neutral color.")
        self.layout_main_default_colors.addWidget(self.maingui_vl_color_combobox)

        #~ self.maingui_alternating_color_label = QLabel("Others:")   #removed @ Calibre 6.8
        #~ self.maingui_alternating_color_label.setToolTip("<p style='white-space:wrap'>These are 100% of the Tool Bar, Search Bar and Status Bar background colors available to choose from.  'Gainsboro' is the default neutral color.")
        #~ self.layout_main_default_colors.addWidget(self.maingui_alternating_color_label)

        #~ self.maingui_searchbar_color_combobox = QComboBox()        #removed @ Calibre 6.8
        #~ self.maingui_searchbar_color_combobox.setEditable(False)
        #~ self.maingui_searchbar_color_combobox.setFont(font)
        #~ self.maingui_searchbar_color_combobox.setToolTip("<p style='white-space:wrap'>These are 100% of the Tool Bar, Search Bar and Status Bar background colors available to choose from.  'Gainsboro' is the default neutral color.")
        #~ self.layout_main_default_colors.addWidget(self.maingui_searchbar_color_combobox)

        #~ color_list = QColor.colorNames()
        for color in color_list:
            self.maingui_text_color_combobox.addItem(color)
            self.maingui_vl_color_combobox.addItem(color)
            #~ self.maingui_searchbar_color_combobox.addItem(color)          #removed @ Calibre 6.8
        #END FOR

        tc = prefs['GUI_TOOLS_MAIN_GUI_TEXT_COLOR']
        bc = prefs['GUI_TOOLS_MAIN_GUI_VIRTUAL_LIBRARY_COLOR']
        ac = prefs['GUI_TOOLS_MAIN_GUI_SEARCHBAR_COLOR']

        self.maingui_text_color_combobox.setCurrentText(tc)
        self.maingui_vl_color_combobox.setCurrentText(bc)
        #~ self.maingui_searchbar_color_combobox.setCurrentText(ac)           #removed @ Calibre 6.8

        self.maingui_text_color_combobox.setEditable(False)
        self.maingui_vl_color_combobox.setEditable(False)
        #~ self.maingui_searchbar_color_combobox.setEditable(False)           #removed @ Calibre 6.8

        style_text = "background-color: [BC]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[BC]",bc)
        self.maingui_text_color_combobox.setStyleSheet(style_text)

        style_text = "background-color: [BC]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[BC]",bc)
        self.maingui_vl_color_combobox.setStyleSheet(style_text)

        #~ style_text = "background-color: [BC]; color : [TC]"            #removed @ Calibre 6.8
        #~ style_text = style_text.replace("[TC]",tc)
        #~ style_text = style_text.replace("[BC]",ac)
        #~ self.maingui_searchbar_color_combobox.setStyleSheet(style_text)

        self.maingui_text_color_combobox.activated.connect(self.event_maingui_combo_box_colors_changed)
        self.maingui_vl_color_combobox.activated.connect(self.event_maingui_combo_box_colors_changed)
        #~ self.maingui_searchbar_color_combobox.activated.connect(self.event_maingui_combo_box_colors_changed)         #removed @ Calibre 6.8

        self.apply_maingui_color_selections_pushbutton = QPushButton("Apply Selected Colors")
        self.apply_maingui_color_selections_pushbutton.clicked.connect(self.apply_maingui_color_selection)
        self.apply_maingui_color_selections_pushbutton.setDefault(False)
        self.apply_maingui_color_selections_pushbutton.setFont(font)
        self.apply_maingui_color_selections_pushbutton.setToolTip("<p style='white-space:wrap'>Change the GUI to the colors that have been selected in the dropdowns to the left.  This change is valid for this current Calibre session only.  To reset to Calibre 'factory settings', you must Restart Calibre without having checked the 'Automatically Apply' checkbox just above.")
        self.layout_main_default_colors.addWidget(self.apply_maingui_color_selections_pushbutton)

        #~ self.set_main_gui_to_neutral_pushbutton = QPushButton("Set GUI to Neutral")
        #~ self.set_main_gui_to_neutral_pushbutton.clicked.connect(self.set_main_gui_colors_to_neutral)
        #~ self.set_main_gui_to_neutral_pushbutton.setDefault(False)
        #~ self.set_main_gui_to_neutral_pushbutton.setFont(font)
        #~ self.set_main_gui_to_neutral_pushbutton.setToolTip("<p style='white-space:wrap'>Change the GUI to the default neutral colors: 'Black/Snow/Gainsboro'.  This change is valid for this current Calibre session only.  To reset to Calibre 'factory settings', you must Restart Calibre without having checked the 'Automatically Apply' checkbox just above.")
        #~ self.layout_main_default_colors.addWidget(self.set_main_gui_to_neutral_pushbutton)

        self.autorun_maingui_color_selections_checkbox = QCheckBox("Automatically Apply the Selected GUI Colors at Calibre startup?")
        self.autorun_maingui_color_selections_checkbox.setToolTip("<p style='white-space:wrap'>Do you want the GUI colors that you have specified below to be automatically applied at Calibre Startup?")
        self.layout_main_default_groupbox.addWidget(self.autorun_maingui_color_selections_checkbox)

        if prefs['GUI_TOOLS_MAIN_GUI_COLOR_AUTORUN'] == unicode_type("True"):
            self.autorun_maingui_color_selections_checkbox.setChecked(True)

        self.activate_maingui_color_selections_checkbox = QCheckBox("Activate this color scheme for use?")
        self.activate_maingui_color_selections_checkbox.setToolTip("<p style='white-space:wrap'>Do you want the GUI colors that you have specified to be able to be used?")
        self.layout_main_default_groupbox.addWidget(self.activate_maingui_color_selections_checkbox)

        if prefs['GUI_TOOLS_MAIN_GUI_COLOR_ACTIVE'] == unicode_type("True"):
            self.activate_maingui_color_selections_checkbox.setChecked(True)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_8_label = QLabel("")
        self.layout_top.addWidget(self.spacer_8_label)
        #--------------------------------------------------
        #--------------------------------------------------

        t = "<p style='white-space:wrap'>If you want to actually use any configuration for this specific GUI Tool, you must activate it for use."

        self.kb_shortcut_cc_autofill_active_checkbox = QCheckBox("Activate Keyboard Shortcuts for Custom Column Auto-Fill? [Changes Require Restart]")
        self.kb_shortcut_cc_autofill_active_checkbox.setToolTip(t)
        self.layout_top.addWidget(self.kb_shortcut_cc_autofill_active_checkbox)

        if prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_AUTOFILL_ACTIVE'] == unicode_type("True"):
            self.kb_shortcut_cc_autofill_active_checkbox.setChecked(True)

        autocompletion_field_list = []
        tmp_list = self.guidb.custom_field_keys()
        for row in tmp_list:
            autocompletion_field_list.append(row)
        #END FOR
        del tmp_list
        autocompletion_field_list.sort()
        #--------------------------------------------------
        self.layout_shortcut_cc_rule1_line = QHBoxLayout()
        self.layout_shortcut_cc_rule1_line.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_shortcut_cc_rule1_line)

        self.shortcut_cc_rule1_label = QLabel("Keyboard Shortcut for Custom Column Autofill - #1 and its Fill Value:")
        self.shortcut_cc_rule1_label.setMinimumWidth(400)
        #~ self.shortcut_cc_rule1_label.setMaximumWidth(600)
        t = "<p style='white-space:wrap'>Select a textual or comments Custom Column for this rule.\
                                                      <br>Custom Column names, value types and fixed sets of values (if any) must be standardized across all of your Calibre Libraries if you wish this rule to function for all of your Calibre Libraries.  Otherwise, it will function only for those Libraries having the specified Custom Column.\
                                                      <br>Do not select a Custom Column that has a value type of Integer, Float, Composite, Ratings or Yes/No.<br>Currently, only textual Custom Columns are supported.\
                                                      <br>If you specify a text CC with a fixed set of values, then the value specified here must be a valid value in the current Library, or Calibre will ignore it."
        self.shortcut_cc_rule1_label.setToolTip(t)
        self.layout_shortcut_cc_rule1_line.addWidget(self.shortcut_cc_rule1_label)

        self.shortcut_cc_rule1_completer = QCompleter(autocompletion_field_list)
        self.shortcut_cc_rule1_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.shortcut_cc_rule1_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.shortcut_cc_rule1_completer.setMaxVisibleItems(50)

        self.shortcut_cc_rule1_lineedit = QLineEdit(self)
        self.shortcut_cc_rule1_lineedit.setMinimumWidth(150)
        #~ self.shortcut_cc_rule1_lineedit.setMaximumWidth(150)
        self.shortcut_cc_rule1_lineedit.setText(prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE1_CUSTOM_COLUMN'])
        self.shortcut_cc_rule1_lineedit.setToolTip(t)

        self.shortcut_cc_rule1_lineedit.setCompleter(self.shortcut_cc_rule1_completer)

        self.layout_shortcut_cc_rule1_line.addWidget(self.shortcut_cc_rule1_lineedit)

        self.shortcut_cc_value_rule1_lineedit = QLineEdit(self)
        self.shortcut_cc_value_rule1_lineedit.setMinimumWidth(150)
        #~ self.shortcut_cc_value_rule1_lineedit.setMaximumWidth(150)
        self.shortcut_cc_value_rule1_lineedit.setText(prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE1_VALUE'])
        self.shortcut_cc_value_rule1_lineedit.setToolTip(t)

        self.layout_shortcut_cc_rule1_line.addWidget(self.shortcut_cc_value_rule1_lineedit)
        #--------------------------------------------------
        self.layout_shortcut_cc_rule2_line = QHBoxLayout()
        self.layout_shortcut_cc_rule2_line.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_shortcut_cc_rule2_line)

        self.shortcut_cc_rule2_label = QLabel("Keyboard Shortcut for Custom Column Autofill - #2 and its Fill Value:")
        self.shortcut_cc_rule2_label.setMinimumWidth(400)
        #~ self.shortcut_cc_rule2_label.setMaximumWidth(600)
        self.shortcut_cc_rule2_label.setToolTip(t)
        self.layout_shortcut_cc_rule2_line.addWidget(self.shortcut_cc_rule2_label)

        self.shortcut_cc_rule2_completer = QCompleter(autocompletion_field_list)
        self.shortcut_cc_rule2_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.shortcut_cc_rule2_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.shortcut_cc_rule2_completer.setMaxVisibleItems(50)

        self.shortcut_cc_rule2_lineedit = QLineEdit(self)
        self.shortcut_cc_rule2_lineedit.setMinimumWidth(150)
        #~ self.shortcut_cc_rule2_lineedit.setMaximumWidth(150)
        self.shortcut_cc_rule2_lineedit.setText(prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE2_CUSTOM_COLUMN'])
        self.shortcut_cc_rule2_lineedit.setToolTip(t)

        self.shortcut_cc_rule2_lineedit.setCompleter(self.shortcut_cc_rule2_completer)

        self.layout_shortcut_cc_rule2_line.addWidget(self.shortcut_cc_rule2_lineedit)

        self.shortcut_cc_value_rule2_lineedit = QLineEdit(self)
        self.shortcut_cc_value_rule2_lineedit.setMinimumWidth(150)
        #~ self.shortcut_cc_value_rule2_lineedit.setMaximumWidth(150)
        self.shortcut_cc_value_rule2_lineedit.setText(prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE2_VALUE'])
        self.shortcut_cc_value_rule2_lineedit.setToolTip(t)

        self.layout_shortcut_cc_rule2_line.addWidget(self.shortcut_cc_value_rule2_lineedit)
        #--------------------------------------------------
        self.layout_shortcut_cc_rule3_line = QHBoxLayout()
        self.layout_shortcut_cc_rule3_line.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_shortcut_cc_rule3_line)

        self.shortcut_cc_rule3_label = QLabel("Keyboard Shortcut for Custom Column Autofill - #3 and its Fill Value:")
        self.shortcut_cc_rule3_label.setMinimumWidth(400)
        #~ self.shortcut_cc_rule3_label.setMaximumWidth(600)
        self.shortcut_cc_rule3_label.setToolTip(t)
        self.layout_shortcut_cc_rule3_line.addWidget(self.shortcut_cc_rule3_label)

        self.shortcut_cc_rule3_completer = QCompleter(autocompletion_field_list)
        self.shortcut_cc_rule3_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.shortcut_cc_rule3_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.shortcut_cc_rule3_completer.setMaxVisibleItems(50)

        self.shortcut_cc_rule3_lineedit = QLineEdit(self)
        self.shortcut_cc_rule3_lineedit.setMinimumWidth(150)
        #~ self.shortcut_cc_rule3_lineedit.setMaximumWidth(150)
        self.shortcut_cc_rule3_lineedit.setText(prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE3_CUSTOM_COLUMN'])
        self.shortcut_cc_rule3_lineedit.setToolTip(t)

        self.shortcut_cc_rule3_lineedit.setCompleter(self.shortcut_cc_rule3_completer)

        self.layout_shortcut_cc_rule3_line.addWidget(self.shortcut_cc_rule3_lineedit)

        self.shortcut_cc_value_rule3_lineedit = QLineEdit(self)
        self.shortcut_cc_value_rule3_lineedit.setMinimumWidth(150)
        #~ self.shortcut_cc_value_rule3_lineedit.setMaximumWidth(150)
        self.shortcut_cc_value_rule3_lineedit.setText(prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE3_VALUE'])
        self.shortcut_cc_value_rule3_lineedit.setToolTip(t)

        self.layout_shortcut_cc_rule3_line.addWidget(self.shortcut_cc_value_rule3_lineedit)
        #--------------------------------------------------
        self.layout_shortcut_cc_rule4_line = QHBoxLayout()
        self.layout_shortcut_cc_rule4_line.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_shortcut_cc_rule4_line)

        self.shortcut_cc_rule4_label = QLabel("Keyboard Shortcut for Custom Column Autofill - #4 and its Fill Value:")
        self.shortcut_cc_rule4_label.setMinimumWidth(400)
        #~ self.shortcut_cc_rule4_label.setMaximumWidth(600)
        self.shortcut_cc_rule4_label.setToolTip(t)
        self.layout_shortcut_cc_rule4_line.addWidget(self.shortcut_cc_rule4_label)

        self.shortcut_cc_rule4_completer = QCompleter(autocompletion_field_list)
        self.shortcut_cc_rule4_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.shortcut_cc_rule4_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.shortcut_cc_rule4_completer.setMaxVisibleItems(50)

        self.shortcut_cc_rule4_lineedit = QLineEdit(self)
        self.shortcut_cc_rule4_lineedit.setMinimumWidth(150)
        #~ self.shortcut_cc_rule4_lineedit.setMaximumWidth(150)
        self.shortcut_cc_rule4_lineedit.setText(prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE4_CUSTOM_COLUMN'])
        self.shortcut_cc_rule4_lineedit.setToolTip(t)

        self.shortcut_cc_rule4_lineedit.setCompleter(self.shortcut_cc_rule4_completer)

        self.layout_shortcut_cc_rule4_line.addWidget(self.shortcut_cc_rule4_lineedit)

        self.shortcut_cc_value_rule4_lineedit = QLineEdit(self)
        self.shortcut_cc_value_rule4_lineedit.setMinimumWidth(150)
        #~ self.shortcut_cc_value_rule4_lineedit.setMaximumWidth(150)
        self.shortcut_cc_value_rule4_lineedit.setText(prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE4_VALUE'])
        self.shortcut_cc_value_rule4_lineedit.setToolTip(t)

        self.layout_shortcut_cc_rule4_line.addWidget(self.shortcut_cc_value_rule4_lineedit)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_19_label = QLabel("")
        self.layout_top.addWidget(self.spacer_19_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.groupbox_uccboacc = QGroupBox('Update Custom Column Based on Another Custom Column [Selected Books]:')
        self.groupbox_uccboacc.setToolTip("<p style='white-space:wrap'>This Tool allows you to update a Target Custom Column with a specified value based on the existance of a Source Custom Column specified value for a book.")
        self.layout_top.addWidget(self.groupbox_uccboacc)

        self.layout_uccboacc_groupbox = QVBoxLayout()
        self.groupbox_uccboacc.setLayout(self.layout_uccboacc_groupbox)

        self.layout_uccboacc_1 = QHBoxLayout()
        self.layout_uccboacc_1.setAlignment(Qt.AlignLeft)
        self.layout_uccboacc_groupbox.addLayout(self.layout_uccboacc_1)

        self.uccboacc_active_checkbox = QCheckBox("Activate?")
        self.uccboacc_active_checkbox.setToolTip("<p style='white-space:wrap'>If you wish to use this Tool, then it must be activated.  Further, at least Rule #1 must be valid.  Rule #2 is optional.")
        self.layout_uccboacc_1.addWidget(self.uccboacc_active_checkbox)

        if prefs['GUI_TOOLS_UCCBOACC_ACTIVE'] == unicode_type("True"):
            self.uccboacc_active_checkbox.setChecked(True)
        #--------------------------------------------------
        self.layout_uccboacc_2 = QHBoxLayout()
        self.layout_uccboacc_2.setAlignment(Qt.AlignLeft)
        self.layout_uccboacc_groupbox.addLayout(self.layout_uccboacc_2)

        self.uccboacc_source_1_label = QLabel("Source #1:")
        #~ self.uccboacc_source_1_label.setMaximumWidth(100)
        t = "<p style='white-space:wrap'>Rule #1 must be valid.  Rule #2 is optional."
        self.uccboacc_source_1_label.setToolTip(t)
        self.layout_uccboacc_2.addWidget(self.uccboacc_source_1_label)

        self.uccboacc_source_1_completer = QCompleter(autocompletion_field_list)
        self.uccboacc_source_1_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.uccboacc_source_1_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.uccboacc_source_1_completer.setMaxVisibleItems(50)

        self.uccboacc_source_1_lineedit = QLineEdit(self)
        self.uccboacc_source_1_lineedit.setMinimumWidth(150)
        self.uccboacc_source_1_lineedit.setText(prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_1'])
        t = "<p style='white-space:wrap'>Select the Source Custom Column from the drop-down list to be used for Rule #1.\
                                                              <br>Custom Column names, value types and fixed sets of values (if any) must be standardized across all of your Calibre Libraries if you wish this rule to function for all of your Calibre Libraries.  Otherwise, it will function only for those Libraries having the specified Custom Column.\
                                                              <br>Do not select a Custom Column that has a value type of Integer, Float, Composite, Ratings or Yes/No.<br>Only textual Custom Columns are supported."
        self.uccboacc_source_1_lineedit.setToolTip(t)

        self.uccboacc_source_1_lineedit.setCompleter(self.uccboacc_source_1_completer)

        self.layout_uccboacc_2.addWidget(self.uccboacc_source_1_lineedit)

        self.uccboacc_value_source_1_lineedit = QLineEdit(self)
        self.uccboacc_value_source_1_lineedit.setMinimumWidth(150)
        self.uccboacc_value_source_1_lineedit.setText(prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_VALUE_1'])
        tsv = "<p style='white-space:wrap'>Specify the value that must be in the Source Custom Column to enable this Rule for further action:\
                                                               <br><br>One or more specific textual value(s) for the Source Custom Column, each value separated by a 'bar', '|'; or,\
                                                               <br><br>An asterisk, '*', meaning 'any normal value' (which excludes Null and None); or,\
                                                               <br><br>A '␀' or 'null' to mean 'if there is no value (i.e., Null or None)'.  If desired, a '␀' or 'null' may be treated as any other bar-separated textual value.  Example: green|null|yellow  or  green|␀|yellow .  "
        self.uccboacc_value_source_1_lineedit.setToolTip(tsv)

        self.layout_uccboacc_2.addWidget(self.uccboacc_value_source_1_lineedit)

        self.uccboacc_target_1_label = QLabel("Target #1:")
        #~ self.uccboacc_target_1_label.setMaximumWidth(100)
        t = "<p style='white-space:wrap'>Rule #1 must be valid.  Rule #2 is optional."
        self.uccboacc_target_1_label.setToolTip(t)
        self.layout_uccboacc_2.addWidget(self.uccboacc_target_1_label)

        self.uccboacc_target_1_completer = QCompleter(autocompletion_field_list)
        self.uccboacc_target_1_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.uccboacc_target_1_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.uccboacc_target_1_completer.setMaxVisibleItems(50)

        self.uccboacc_target_1_lineedit = QLineEdit(self)
        self.uccboacc_target_1_lineedit.setMinimumWidth(150)
        self.uccboacc_target_1_lineedit.setText(prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_1'])
        t = "<p style='white-space:wrap'>Select the Target Custom Column from the drop-down list to be used for Rule #1.\
                                                              <br>Custom Column names, value types and fixed sets of values (if any) must be standardized across all of your Calibre Libraries if you wish this rule to function for all of your Calibre Libraries.  Otherwise, it will function only for those Libraries having the specified Custom Column.\
                                                              <br>Do not select a Custom Column that has a value type of Integer, Float, Composite, Ratings or Yes/No.<br>Only textual Custom Columns are supported."
        self.uccboacc_target_1_lineedit.setToolTip(t)

        self.uccboacc_target_1_lineedit.setCompleter(self.uccboacc_target_1_completer)

        self.layout_uccboacc_2.addWidget(self.uccboacc_target_1_lineedit)

        self.uccboacc_value_target_1_lineedit = QLineEdit(self)
        self.uccboacc_value_target_1_lineedit.setMinimumWidth(150)
        self.uccboacc_value_target_1_lineedit.setText(prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_VALUE_1'])
        t = "<p style='white-space:wrap'>Specify the textual value to be updated in the Custom Column specified as the Target for Rule #1.\
                                                            <br>If you specify a text CC with a fixed set of values, then the value specified here must be a valid value in the current Library, or Calibre will ignore it."
        self.uccboacc_value_target_1_lineedit.setToolTip(t)

        self.layout_uccboacc_2.addWidget(self.uccboacc_value_target_1_lineedit)

        #--------------------------------------------------
        self.layout_uccboacc_3 = QHBoxLayout()
        self.layout_uccboacc_3.setAlignment(Qt.AlignLeft)
        self.layout_uccboacc_groupbox.addLayout(self.layout_uccboacc_3)

        self.uccboacc_source_2_label = QLabel("Source #2:")
        #~ self.uccboacc_source_2_label.setMaximumWidth(100)
        t = "<p style='white-space:wrap'>Rule #1 must be valid.  Rule #2 is optional."
        self.uccboacc_source_2_label.setToolTip(t)
        self.layout_uccboacc_3.addWidget(self.uccboacc_source_2_label)

        self.uccboacc_source_2_completer = QCompleter(autocompletion_field_list)
        self.uccboacc_source_2_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.uccboacc_source_2_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.uccboacc_source_2_completer.setMaxVisibleItems(50)

        self.uccboacc_source_2_lineedit = QLineEdit(self)
        self.uccboacc_source_2_lineedit.setMinimumWidth(150)
        self.uccboacc_source_2_lineedit.setText(prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_2'])
        t = "<p style='white-space:wrap'>Select the Source Custom Column from the drop-down list to be used for Rule #2.\
                                                              <br>Custom Column names, value types and fixed sets of values (if any) must be standardized across all of your Calibre Libraries if you wish this rule to function for all of your Calibre Libraries.  Otherwise, it will function only for those Libraries having the specified Custom Column.\
                                                              <br>Do not select a Custom Column that has a value type of Integer, Float, Composite, Ratings or Yes/No.<br>Only textual Custom Columns are supported."
        self.uccboacc_source_2_lineedit.setToolTip(t)

        self.uccboacc_source_2_lineedit.setCompleter(self.uccboacc_source_2_completer)

        self.layout_uccboacc_3.addWidget(self.uccboacc_source_2_lineedit)

        self.uccboacc_value_source_2_lineedit = QLineEdit(self)
        self.uccboacc_value_source_2_lineedit.setMinimumWidth(150)
        self.uccboacc_value_source_2_lineedit.setText(prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_VALUE_2'])
        self.uccboacc_value_source_2_lineedit.setToolTip(tsv)

        self.layout_uccboacc_3.addWidget(self.uccboacc_value_source_2_lineedit)

        self.uccboacc_target_2_label = QLabel("Target #2:")
        #~ self.uccboacc_target_2_label.setMaximumWidth(100)
        t = "<p style='white-space:wrap'>Rule #1 must be valid.  Rule #2 is optional."
        self.uccboacc_target_2_label.setToolTip(t)
        self.layout_uccboacc_3.addWidget(self.uccboacc_target_2_label)

        self.uccboacc_target_2_completer = QCompleter(autocompletion_field_list)
        self.uccboacc_target_2_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.uccboacc_target_2_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.uccboacc_target_2_completer.setMaxVisibleItems(50)

        self.uccboacc_target_2_lineedit = QLineEdit(self)
        self.uccboacc_target_2_lineedit.setMinimumWidth(150)
        self.uccboacc_target_2_lineedit.setText(prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_2'])
        t = "<p style='white-space:wrap'>Select the Target Custom Column from the drop-down list to be used for Rule #2.\
                                                              <br>Custom Column names, value types and fixed sets of values (if any) must be standardized across all of your Calibre Libraries if you wish this rule to function for all of your Calibre Libraries.  Otherwise, it will function only for those Libraries having the specified Custom Column.\
                                                              <br>Do not select a Custom Column that has a value type of Integer, Float, Composite, Ratings or Yes/No.<br>Only textual Custom Columns are supported."
        self.uccboacc_target_2_lineedit.setToolTip(t)

        self.uccboacc_target_2_lineedit.setCompleter(self.uccboacc_target_2_completer)

        self.layout_uccboacc_3.addWidget(self.uccboacc_target_2_lineedit)

        self.uccboacc_value_target_2_lineedit = QLineEdit(self)
        self.uccboacc_value_target_2_lineedit.setMinimumWidth(150)
        self.uccboacc_value_target_2_lineedit.setMaximumWidth(150)
        self.uccboacc_value_target_2_lineedit.setText(prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_VALUE_2'])
        t = "<p style='white-space:wrap'>Specify the textual value to be updated in the Custom Column specified as the Target for Rule #2.\
                                                            <br>If you specify a text CC with a fixed set of values, then the value specified here must be a valid value in the current Library, or Calibre will ignore it."
        self.uccboacc_value_target_2_lineedit.setToolTip(t)

        self.layout_uccboacc_3.addWidget(self.uccboacc_value_target_2_lineedit)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_7_label = QLabel("")
        self.layout_top.addWidget(self.spacer_7_label)
        #--------------------------------------------------
        #--------------------------------------------------

        self.groupbox_nulls = QGroupBox('NULL Values:')
        self.groupbox_nulls.setToolTip("<p style='white-space:wrap'>Add Null to <b>'qualifying'</b> Custom Columns for books with no pre-existing real values in them [All Books].")
        self.layout_top.addWidget(self.groupbox_nulls)

        self.layout_nulls_groupbox = QVBoxLayout()
        self.groupbox_nulls.setLayout(self.layout_nulls_groupbox)

        self.layout_add_null_values_1 = QHBoxLayout()
        self.layout_add_null_values_1.setAlignment(Qt.AlignLeft)
        self.layout_nulls_groupbox.addLayout(self.layout_add_null_values_1)

        self.add_null_values_active_checkbox = QCheckBox("Activate 'Add NULL Values'? ")
        self.add_null_values_active_checkbox.setToolTip("<p style='white-space:wrap'>Add Null to <b>'qualifying'</b> Custom Columns for books with no pre-existing real values in them [All Books]?  Change Requires Restart.\
                                                                                                                                      <br><br>Note: <b>'Non-qualifying'</b> Custom Columns are those with a datatype of one of the following: composite; rating; enumeration.\
                                                                                                                                      <br><br>All other Custom Column datatypes are considered as <b>'qualifying'</b> for the purposes of this JS+ GUI Tool. \
                                                                                                                                      <br><br>The meaning of 'Null' is defined as: '␀' for textual values; 0 for integer values; 0.0 for floating point values; 0 for yes/no (boolean) values; and '0102-01-01 00:00:00.000' for datetime values.")
        self.layout_add_null_values_1.addWidget(self.add_null_values_active_checkbox)

        if prefs['GUI_TOOLS_ADD_NULL_VALUES_ACTIVE'] == unicode_type("True"):
            self.add_null_values_active_checkbox.setChecked(True)

        self.add_null_values_autorun_checkbox = QCheckBox("Run at Startup? ")
        self.add_null_values_autorun_checkbox.setToolTip("<p style='white-space:wrap'>Automatically submit this job at Calibre Startup and also after Calibre has switched to another Library?\
                                                                                                                                          <br><br>Note: for very large Libraries, you should probably <b>manually</b> execute this GUI Tool via the JS+ Menu for the <b>first</b> time.")
        self.layout_add_null_values_1.addWidget(self.add_null_values_autorun_checkbox)

        if prefs['GUI_TOOLS_ADD_NULL_VALUES_AUTORUN'] == unicode_type("True"):
            self.add_null_values_autorun_checkbox.setChecked(True)

        self.add_nulls_to_library_qlabel = QLabel("For Libraries:")
        self.add_nulls_to_library_qlabel.setToolTip("<p style='white-space:wrap'>Specify for which Libraries this GUI Tool is active.")
        self.layout_add_null_values_1.addWidget(self.add_nulls_to_library_qlabel)

        t = "<p style='white-space:wrap'>Specify the Libraries for which you would like to activate this GUI Tool.  A wildcard of '*' means 'all known Calibre Libraries'.  Separate multiple Library Names with a bar '|'.\
              <br><br>Note: 'QuarantineAndScrub' library names will be ignored, as Q&S libraries should never be used by this JS+ GUI Tool.\
              <br><br>Note: ZMI-configured library names may be specified, but any '#zotero_' Custom Columns will <b>not</b> be processed by this JS+ GUI Tool.  Other non-ZMI Custom Columns will be processed as normal, however."

        self.add_nulls_to_library_qlineedit = QLineEdit(self)
        self.add_nulls_to_library_qlineedit.setText(prefs['GUI_TOOLS_ADD_NULL_VALUES_LIBRARIES'])
        self.add_nulls_to_library_qlineedit.setFont(font)
        self.add_nulls_to_library_qlineedit.setToolTip(t)
        self.add_nulls_to_library_qlineedit.setCursorPosition(0)
        self.layout_add_null_values_1.addWidget(self.add_nulls_to_library_qlineedit)
        #-------------
        self.layout_add_null_values_2 = QHBoxLayout()
        self.layout_add_null_values_2.setAlignment(Qt.AlignCenter)
        self.layout_nulls_groupbox.addLayout(self.layout_add_null_values_2)

        self.add_null_values_comments_checkbox = QCheckBox("Comments/Long Text?")
        self.add_null_values_comments_checkbox.setToolTip("<p style='white-space:wrap'>Add '␀' to Comments/Long-Text Custom Columns?")
        self.layout_add_null_values_2.addWidget(self.add_null_values_comments_checkbox)

        if prefs['GUI_TOOLS_ADD_NULL_VALUES_COMMENTS'] == unicode_type("True"):
            self.add_null_values_comments_checkbox.setChecked(True)

        self.add_null_values_text_checkbox = QCheckBox("Text?")
        self.add_null_values_text_checkbox.setToolTip("<p style='white-space:wrap'>Add '␀' to Text (Shown in Tag-Browser) Custom Columns?")
        self.layout_add_null_values_2.addWidget(self.add_null_values_text_checkbox)

        if prefs['GUI_TOOLS_ADD_NULL_VALUES_TEXT'] == unicode_type("True"):
            self.add_null_values_text_checkbox.setChecked(True)

        self.add_null_values_taglike_checkbox = QCheckBox("Tag-Like?")
        self.add_null_values_taglike_checkbox.setToolTip("<p style='white-space:wrap'>Add '␀' to Comma-Separated and Ampersand-Separated Text (Like Tags) Custom Columns?")
        self.layout_add_null_values_2.addWidget(self.add_null_values_taglike_checkbox)

        if prefs['GUI_TOOLS_ADD_NULL_VALUES_TAGLIKE'] == unicode_type("True"):
            self.add_null_values_taglike_checkbox.setChecked(True)

        self.add_null_values_series_checkbox = QCheckBox("Series?")
        self.add_null_values_series_checkbox.setToolTip("<p style='white-space:wrap'>Add '␀' to Series-Like Custom Columns?")
        self.layout_add_null_values_2.addWidget(self.add_null_values_series_checkbox)

        if prefs['GUI_TOOLS_ADD_NULL_VALUES_SERIES'] == unicode_type("True"):
            self.add_null_values_series_checkbox.setChecked(True)

        self.add_null_values_bool_checkbox = QCheckBox("Yes/No?")
        self.add_null_values_bool_checkbox.setToolTip("<p style='white-space:wrap'>Add 'No' (0) to Yes/No (Boolean) Custom Columns?")
        self.layout_add_null_values_2.addWidget(self.add_null_values_bool_checkbox)

        if prefs['GUI_TOOLS_ADD_NULL_VALUES_BOOL'] == unicode_type("True"):
            self.add_null_values_bool_checkbox.setChecked(True)

        self.add_null_values_int_checkbox = QCheckBox("Integer?")
        self.add_null_values_int_checkbox.setToolTip("<p style='white-space:wrap'>Add 0 to Integer Custom Columns?")
        self.layout_add_null_values_2.addWidget(self.add_null_values_int_checkbox)

        if prefs['GUI_TOOLS_ADD_NULL_VALUES_INT'] == unicode_type("True"):
            self.add_null_values_int_checkbox.setChecked(True)

        self.add_null_values_float_checkbox = QCheckBox("Float?")
        self.add_null_values_float_checkbox.setToolTip("<p style='white-space:wrap'>Add 0.0 to Floating Point Numeric Custom Columns?")
        self.layout_add_null_values_2.addWidget(self.add_null_values_float_checkbox)

        if prefs['GUI_TOOLS_ADD_NULL_VALUES_FLOAT'] == unicode_type("True"):
            self.add_null_values_float_checkbox.setChecked(True)

        self.add_null_values_datetime_checkbox = QCheckBox("DateTime?")
        self.add_null_values_datetime_checkbox.setToolTip("<p style='white-space:wrap'>Add '0102-01-01 00:00:00.000 UTC' to DateTime Custom Columns?\
                                                                                              <br><br>Note: Since UTC is used, Calibre will display the value in <b>your</b> timezone, not UTC.  So, for example, you might see '0101 Dec 31' instead of '0102 Jan 01'.  However, the value stored in the database is '0102 Jan 01'.")
        self.layout_add_null_values_2.addWidget(self.add_null_values_datetime_checkbox)

        if prefs['GUI_TOOLS_ADD_NULL_VALUES_DATETIME'] == unicode_type("True"):
            self.add_null_values_datetime_checkbox.setChecked(True)

        #-------------
        self.layout_add_null_values_3 = QHBoxLayout()
        self.layout_add_null_values_3.setAlignment(Qt.AlignCenter)
        self.layout_nulls_groupbox.addLayout(self.layout_add_null_values_3)

        self.add_nulls_ignore_names_qlabel = QLabel("Exclude:")
        #~ self.add_nulls_ignore_names_qlabel.setMaximumWidth(100)
        self.add_nulls_ignore_names_qlabel.setToolTip("<p style='white-space:wrap'>Specify for which Custom Column #names this GUI Tool is <b>NOT</b> active.")
        self.layout_add_null_values_3.addWidget(self.add_nulls_ignore_names_qlabel)

        self.add_nulls_ignore_names_qlineedit = QLineEdit(self)
        self.add_nulls_ignore_names_qlineedit.setText(prefs['GUI_TOOLS_ADD_NULL_VALUES_IGNORE_NAMES'])
        #~ self.add_nulls_ignore_names_qlineedit.setMaximumWidth(500)
        self.add_nulls_ignore_names_qlineedit.setFont(font)
        self.add_nulls_ignore_names_qlineedit.setToolTip("<p style='white-space:wrap'>Specify the Custom Column #names for which you would like this GUI Tool to <b>ignore</b>.  Separate multiple #names with a bar '|'.")
        self.add_nulls_ignore_names_qlineedit.setCursorPosition(0)
        self.layout_add_null_values_3.addWidget(self.add_nulls_ignore_names_qlineedit)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_10_label = QLabel("")
        self.layout_top.addWidget(self.spacer_10_label)
        #--------------------------------------------------
        #--------------------------------------------------
        choices = as_unicode(prefs['GUI_TOOLS_MEGA_METADATA_BOOK_HELPER_CHOICES_DICT'])
        choices_dict = ast.literal_eval(choices)
        if not isinstance(choices_dict,dict):
            if DEBUG: print("choices_dict is invalid dict")
            choices_dict = {}
        else:
            tags = choices_dict["tags"]
            if tags == "True":
                tags = True
            else:
                tags = False
            cc = choices_dict["cc"]
            if cc == "True":
                cc = True
            else:
                cc = False
            custom_columns = as_unicode(choices_dict["custom_columns"])
            custom_columns_list = ast.literal_eval(custom_columns)
            custom_columns_list.sort()
            cc_str = ",".join(custom_columns_list)
            if cc_str.startswith(","):
                cc_str = cc_str[1: ]
            cc_str = as_unicode(cc_str)

        self.layout_mega_metadata_helper = QHBoxLayout()
        self.layout_mega_metadata_helper.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_mega_metadata_helper)

        t = "<p style='white-space:wrap'>All current values of one or more of these Tag-like metadata types in a library may be selected to be automatically populated for a selected book.<br><br> The respective book may be copied to a 'Workbench' type of library so that all possible valid values will appear in its drop-down lists.<br><br>This is especially useful for Tags and Genres."

        self.mega_metadata_helper_label = QLabel("Mega-Metadata Reference Book Dropdown Helper: ")
        self.mega_metadata_helper_label.setMinimumWidth(300)
        #~ self.mega_metadata_helper_label.setMaximumWidth(400)
        self.mega_metadata_helper_label.setToolTip(t)
        self.layout_mega_metadata_helper.addWidget(self.mega_metadata_helper_label)

        self.mega_metadata_helper_tags_checkbox = QCheckBox("Tags")
        self.mega_metadata_helper_tags_checkbox.setChecked(tags)
        self.mega_metadata_helper_tags_checkbox.setMinimumWidth(75)
        #~ self.mega_metadata_helper_tags_checkbox.setMaximumWidth(75)
        self.mega_metadata_helper_tags_checkbox.setToolTip(t)
        self.layout_mega_metadata_helper.addWidget(self.mega_metadata_helper_tags_checkbox)

        self.mega_metadata_helper_custom_columns_checkbox = QCheckBox("Tag-like Custom Columns:")
        self.mega_metadata_helper_custom_columns_checkbox.setChecked(cc)
        self.mega_metadata_helper_custom_columns_checkbox.setMinimumWidth(180)
        #~ self.mega_metadata_helper_custom_columns_checkbox.setMaximumWidth(180)
        self.mega_metadata_helper_custom_columns_checkbox.setToolTip(t)
        self.layout_mega_metadata_helper.addWidget(self.mega_metadata_helper_custom_columns_checkbox)

        if not "#" in cc_str:
            self.mega_metadata_helper_custom_columns_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>Multiple Tag-like Custom Columns may be specified here as a comma-separated list.  The specified Tag-like Custom Columns must begin with their '#' search name, and be separated by commas.  "

        self.mega_metadata_helper_lineedit = QLineEdit(self)
        self.mega_metadata_helper_lineedit.setToolTip(t)
        self.mega_metadata_helper_lineedit.setMinimumWidth(150)
        #~ self.mega_metadata_helper_lineedit.setMaximumWidth(150)
        self.mega_metadata_helper_lineedit.setText(cc_str)
        self.layout_mega_metadata_helper.addWidget(self.mega_metadata_helper_lineedit)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_1_label = QLabel("")
        self.layout_top.addWidget(self.spacer_1_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.frame_1 = QFrame()
        self.frame_1.setFrameShape(QFrame.HLine);
        self.frame_1.setFrameShadow(QFrame.Sunken);
        self.layout_top.addWidget(self.frame_1);
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_1a_label = QLabel("")
        self.layout_top.addWidget(self.spacer_1a_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_ftp = QHBoxLayout()
        self.layout_ftp.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_ftp)

        self.ftp_host_label = QLabel("FTP: ")
        t = "<p style='white-space:wrap'>These FTP parameters control the FTP GUI Tool.  You may assign the JS+ menu item for this GUI Tool to a keyboard shortcut."
        self.ftp_host_label.setToolTip(t)
        self.layout_ftp.addWidget(self.ftp_host_label)

        self.ftp_host_lineedit = QLineEdit(self)
        t = "<p style='white-space:wrap'>FTP Host.  Not TLS Encrypted."
        self.ftp_host_lineedit.setToolTip(t)
        self.ftp_host_lineedit.setText(prefs['GUI_TOOLS_FTP_HOST'])
        self.layout_ftp.addWidget(self.ftp_host_lineedit)

        self.ftp_port_label = QLabel("Port: ")
        t = "<p style='white-space:wrap'>FTP Port.  Usually 21.  Specify an integer."
        self.ftp_port_label.setToolTip(t)
        self.layout_ftp.addWidget(self.ftp_port_label)

        self.ftp_port_lineedit = QLineEdit(self)
        self.ftp_port_lineedit.setToolTip(t)
        self.ftp_port_lineedit.setMinimumWidth(25)
        #~ self.ftp_port_lineedit.setMaximumWidth(25)
        self.ftp_port_lineedit.setText(prefs['GUI_TOOLS_FTP_HOST_PORT'])
        self.layout_ftp.addWidget(self.ftp_port_lineedit)

        self.ftp_directory_label = QLabel("Dir: ")
        t = "<p style='white-space:wrap'>FTP Host Directory into which the selected book formats will be uploaded.<br>Include a leading and trailing '/'.  <br>Example:  /myfolder/ "
        self.ftp_directory_label.setToolTip(t)
        self.layout_ftp.addWidget(self.ftp_directory_label)

        self.ftp_directory_lineedit = QLineEdit(self)
        self.ftp_directory_lineedit.setToolTip(t)
        self.ftp_directory_lineedit.setText(prefs['GUI_TOOLS_FTP_HOST_DIRECTORY'])
        self.layout_ftp.addWidget(self.ftp_directory_lineedit)

        self.ftp_userid_label = QLabel("UserID: ")
        t = "<p style='white-space:wrap'>FTP Host User ID"
        self.ftp_userid_label.setToolTip(t)
        self.layout_ftp.addWidget(self.ftp_userid_label)

        self.ftp_userid_lineedit = QLineEdit(self)
        self.ftp_userid_lineedit.setToolTip(t)
        self.ftp_userid_lineedit.setText(prefs['GUI_TOOLS_FTP_USERID'])
        self.layout_ftp.addWidget(self.ftp_userid_lineedit)

        self.ftp_password_label = QLabel("PW: ")
        t = "<p style='white-space:wrap'>FTP Host Password.  This password is not encrypted within Calibre, and will be completely visible in Job Spy's .json preferences file."
        self.ftp_password_label.setToolTip(t)
        self.layout_ftp.addWidget(self.ftp_password_label)

        self.ftp_password_lineedit = QLineEdit(self)
        self.ftp_password_lineedit.setToolTip(t)
        self.ftp_password_lineedit.setText(prefs['GUI_TOOLS_FTP_PASSWORD'])
        self.layout_ftp.addWidget(self.ftp_password_lineedit)

        self.ftp_format_label = QLabel("Formats: ")
        t = "<p style='white-space:wrap'>Calibre book formats to upload, comma separated, with the highest priority on the left, and the lowest priority on the right.  A book with multiple formats will have uploaded only the leftmost format (if there is one).  Only one (1) format will be uploaded.  Example:  epub,pdf,txt,mobi "
        self.ftp_format_label.setToolTip(t)
        self.layout_ftp.addWidget(self.ftp_format_label)

        self.ftp_format_lineedit = QLineEdit(self)
        self.ftp_format_lineedit.setToolTip(t)
        self.ftp_format_lineedit.setMinimumWidth(75)
        #~ self.ftp_format_lineedit.setMaximumWidth(75)
        self.ftp_format_lineedit.setText(prefs['GUI_TOOLS_FTP_FORMAT'])
        self.layout_ftp.addWidget(self.ftp_format_lineedit)
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_2_label = QLabel("")
        self.layout_top.addWidget(self.spacer_2_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.frame_2 = QFrame()
        self.frame_2.setFrameShape(QFrame.HLine);
        self.frame_2.setFrameShadow(QFrame.Sunken);
        self.layout_top.addWidget(self.frame_2);
        #--------------------------------------------------
        #--------------------------------------------------
        self.groupbox_tweaks = QGroupBox('Library-Specific Tweaks:')
        self.groupbox_tweaks.setToolTip("<p style='white-space:wrap'>Library-Specific Tweaks for Otherwise Calibre Global Settings")
        self.layout_top.addWidget(self.groupbox_tweaks)

        self.layout_tweaks_groupbox = QVBoxLayout()
        self.groupbox_tweaks.setLayout(self.layout_tweaks_groupbox)
        #--------------------------------------------------
        #--------------------------------------------------

        self.layout_tweak_author_sort_copy_method = QHBoxLayout()
        self.layout_tweak_author_sort_copy_method.setAlignment(Qt.AlignLeft)
        self.layout_tweaks_groupbox.addLayout(self.layout_tweak_author_sort_copy_method)

        t = "<p style='white-space:wrap'>To <b>completely activate</b> this GUI Tool, you must <b>also</b> do the following: \
                                                                <br><br>Go To 'Preferences > Tweaks > Plugin Tweaks' and then add a Tweak value for '<b>job_spy_author_sort_copy_method</b>' that conforms to the following format: <br><br>job_spy_author_sort_copy_method = {'MyLibraryName1': 'nocomma', 'MyLibraryName2': 'invert', 'MyLibraryName3': 'copy', 'MyLibraryName4': 'comma'}\
                                                                <br><br>The sort method values <b>must</b> be those allowed in the Calibre Standard Tweak for 'author_sort_copy_method'.\
                                                                <br><br>Any Library Name that is <b>not</b> included in this Tweak will default to the Calibre Standard Tweak.  This Job Spy Tweak is totally optional.\
                                                                <br><br>Each 'Library Name-to-Method' pair <b>must</b> be in this colon-separated format:   'MyLibraryName': 'nocomma'  (with multiple pairs comma-separated).\
                                                                <br><br>The entire specification of pairs <b>must</b> be surrounded by 'braces', {.....}.  Example: {'MyLibraryNameA': 'nocomma', 'MyLibraryNameB': 'copy'}\
                                                                <br><br>If you make a format error in Preferences > Tweaks > Plugin Tweaks, your Tweak will be ignored, and the Calibre Standard Tweak for 'author_sort_copy_method' will be used as normal.  Also, an error message will be written to the Debug Log to specify what the error was.\
                                                                <br><br>"

        self.tweak_author_sort_copy_method_label = QLabel("Tweak for Per-Library: 'Author Sort Copy Method':          ")
        self.tweak_author_sort_copy_method_label.setMinimumWidth(350)
        #~ self.tweak_author_sort_copy_method_label.setMaximumWidth(350)
        self.tweak_author_sort_copy_method_label.setToolTip(t)
        self.layout_tweak_author_sort_copy_method.addWidget(self.tweak_author_sort_copy_method_label)

        self.tweak_author_sort_copy_method_activate_checkbox = QCheckBox("Activate 'Preferences>Tweaks>Plugin Tweaks' Configuration?")
        self.tweak_author_sort_copy_method_activate_checkbox.setToolTip(t)
        self.layout_tweak_author_sort_copy_method.addWidget(self.tweak_author_sort_copy_method_activate_checkbox)

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_AUTHOR_SORT_COPY_METHOD'] == unicode_type("True"):
            self.tweak_author_sort_copy_method_activate_checkbox.setChecked(True)
        else:
            self.tweak_author_sort_copy_method_activate_checkbox.setChecked(False)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_14_label = QLabel("")
        self.layout_tweaks_groupbox.addWidget(self.spacer_14_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_tweak_add_books_read_metadata_from_file_contents_not_name = QHBoxLayout()
        self.layout_tweak_add_books_read_metadata_from_file_contents_not_name.setAlignment(Qt.AlignLeft)
        self.layout_tweaks_groupbox.addLayout(self.layout_tweak_add_books_read_metadata_from_file_contents_not_name)

        t = "<p style='white-space:wrap'>To <b>completely activate</b> this GUI Tool, you must <b>also</b> do the following: \
                                                                <br><br>Go To 'Preferences > Tweaks > Plugin Tweaks' and then add a Tweak value for '<b>job_spy_add_books_read_metadata_from_file_contents_not_name</b>' that conforms to the following format: <br><br>job_spy_add_books_read_metadata_from_file_contents_not_name = {'MyLibraryName1': 'True', 'MyLibraryName2': 'False', 'MyLibraryName3': 'True', 'MyLibraryName4': 'False'}\
                                                                <br><br>The valid values <b>must</b> be either 'True' or 'False'.  The first letter must be capitalized, and the remaining letters must be lower-case.\
                                                                <br><br>Each 'Library Name-to-Method' pair <b>must</b> be in this colon-separated format:   'MyLibraryName': 'True'  (with multiple pairs comma-separated).\
                                                                <br><br>The entire specification of pairs <b>must</b> be surrounded by 'braces', {.....}.  Example: {'MyLibraryNameA': 'False', 'MyLibraryNameB': 'True'}\
                                                                <br><br>If you make a format error in Preferences > Tweaks > Plugin Tweaks, your Tweak will be ignored, and 'True' will be used. Also, an error message will be written to the Debug Log to specify what the error was.\
                                                                <br><br>\
                                                                <br><br>Important: If you do not include every Library name in this Tweak, then those missing Libraries will default automatically to 'True'.  So, you need only specify the Libraries that should use 'False' in this Tweak."

        self.tweak_add_books_read_metadata_from_file_contents_not_name_label = QLabel("Tweak for Per-Library: 'Add Books Read Metadata from File Contents Not Name':          ")
        self.tweak_add_books_read_metadata_from_file_contents_not_name_label.setMinimumWidth(500)
        #~ self.tweak_add_books_read_metadata_from_file_contents_not_name_label.setMaximumWidth(500)
        self.tweak_add_books_read_metadata_from_file_contents_not_name_label.setToolTip(t)
        self.layout_tweak_add_books_read_metadata_from_file_contents_not_name.addWidget(self.tweak_add_books_read_metadata_from_file_contents_not_name_label)

        self.tweak_add_books_read_metadata_from_file_contents_not_name_activate_checkbox = QCheckBox("Activate?")
        self.tweak_add_books_read_metadata_from_file_contents_not_name_activate_checkbox.setToolTip(t)
        self.layout_tweak_add_books_read_metadata_from_file_contents_not_name.addWidget(self.tweak_add_books_read_metadata_from_file_contents_not_name_activate_checkbox)

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_ADD_BOOKS_READ_METADATA_FROM_FILE_CONTENTS_NOT_NAME'] == unicode_type("True"):
            self.tweak_add_books_read_metadata_from_file_contents_not_name_activate_checkbox.setChecked(True)
        else:
            self.tweak_add_books_read_metadata_from_file_contents_not_name_activate_checkbox.setChecked(False)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_15_label = QLabel("")
        self.layout_tweaks_groupbox.addWidget(self.spacer_15_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_tweak_auto_add_directory_by_library = QHBoxLayout()
        self.layout_tweak_auto_add_directory_by_library.setAlignment(Qt.AlignLeft)
        self.layout_tweaks_groupbox.addLayout(self.layout_tweak_auto_add_directory_by_library)

        t = "<p style='white-space:wrap'>To <b>completely activate</b> this GUI Tool, you must <b>also</b> do the following: \
                                                                <br><br>Go To 'Preferences > Tweaks > Plugin Tweaks' and then add a Tweak value for '<b>job_spy_auto_add_directory</b>' that conforms to the following format: <br><br>job_spy_auto_add_directory = {'MyLibraryName1': 'c:/my_auto_add_dir_1', 'MyLibraryName2': 'c:/my_auto_add_dir_2', 'MyLibraryName3': 'c:/my_auto_add_dir_3', 'MyLibraryName4': 'c:/my_auto_add_dir_4'}\
                                                                <br><br>For Windows paths, always use '/' and <b>never</b> '\\' , and do not use any double-quotes around any path that you specify for this Tweak.\
                                                                <br><br>Each 'Library Name-to-Directory' pair <b>must</b> be in this colon-separated format:   'MyLibraryName': 'c:/mydirX'  (with multiple pairs comma-separated).\
                                                                <br><br>The entire specification of pairs <b>must</b> be surrounded by 'braces', {.....}.  Example: {'MyLibraryNameA': 'c:/mydirA', 'MyLibraryNameB': 'c:/mydirB'}\
                                                                <br><br>If you make a format error in Preferences > Tweaks > Plugin Tweaks, your Tweak will be ignored, and an error message will be displayed in a non-modal Information dialog.\
                                                                <br><br>The 'Default Tweak Directory' will be used for any Library <b>not</b> otherwise specified in Preferences > Tweaks > Plugin Tweaks for <b>job_spy_auto_add_directory</b>.\
                                                                <br><br>If you do not include every Library name in this Tweak, then those missing Libraries will default automatically to the 'Default Tweak Directory'.\
                                                                <br><br>Once you Activate this Tweak, then the Standard Calibre 'Preferences>Adding Books>Automatic Adding' Specified Folder <b>will no longer be used</b>.  Instead, its value will rotate to the current Tweak value.  However, <b>Calibre requires a valid directory to activate its Auto-Add process.  Do not ever leave that value blank if you wish to use Auto-Adding.</b> \
                                                                <br><br>It is <b>not</b> a good idea to 'Quick-Switch' Calibre Libraries in the midst of auto-adding books into the Old Library.  Wait to 'Quick-Switch' to a New Library until all in-progress auto-adding has completed.\
                                                                <br><br>You might notice a slight delay in being able to fully use the New Library after a 'Quick-Switch' if that Library's Auto-Add Directory had a large number of books waiting to be auto-added, as the very first thing done after a 'Quick-Switch' is to immediately add any books that already exist in a Library's Auto-Add Directory. "

        self.tweak_auto_add_directory_by_library_label = QLabel("Tweak for Per-Library: 'Auto-Add Directory':     Default Directory:     ")
        self.tweak_auto_add_directory_by_library_label.setMinimumWidth(400)
        #~ self.tweak_auto_add_directory_by_library_label.setMaximumWidth(400)
        self.tweak_auto_add_directory_by_library_label.setToolTip(t)
        self.layout_tweak_auto_add_directory_by_library.addWidget(self.tweak_auto_add_directory_by_library_label)

        self.tweak_last_resort_lineedit = QLineEdit(self)
        self.tweak_last_resort_lineedit.setToolTip(t)
        self.tweak_last_resort_lineedit.setMinimumWidth(300)
        #~ self.tweak_last_resort_lineedit.setMaximumWidth(300)
        self.tweak_last_resort_lineedit.setText(prefs['GUI_TOOLS_DEFAULT_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY'])
        self.layout_tweak_auto_add_directory_by_library.addWidget(self.tweak_last_resort_lineedit)

        self.spacer_tweak_last_resort_label = QLabel("   ")
        self.layout_tweak_auto_add_directory_by_library.addWidget(self.spacer_tweak_last_resort_label)

        self.tweak_auto_add_directory_by_library_activate_checkbox = QCheckBox("Activate?")
        self.tweak_auto_add_directory_by_library_activate_checkbox.setToolTip(t)
        self.tweak_auto_add_directory_by_library_activate_checkbox.setMinimumWidth(150)
        self.layout_tweak_auto_add_directory_by_library.addWidget(self.tweak_auto_add_directory_by_library_activate_checkbox)

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY'] == unicode_type("True"):
            self.tweak_auto_add_directory_by_library_activate_checkbox.setChecked(True)
        else:
            self.tweak_auto_add_directory_by_library_activate_checkbox.setChecked(False)
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_15a_label = QLabel("")
        self.layout_tweaks_groupbox.addWidget(self.spacer_15a_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_tweak_save_to_directory_by_library = QHBoxLayout()
        self.layout_tweak_save_to_directory_by_library.setAlignment(Qt.AlignLeft)
        self.layout_tweaks_groupbox.addLayout(self.layout_tweak_save_to_directory_by_library)

        t = "<p style='white-space:wrap'>To <b>completely activate</b> this GUI Tool, you must <b>also</b> do the following: \
                                                                <br><br>Go To 'Preferences > Tweaks > Plugin Tweaks' and then add a Tweak value for '<b>job_spy_save_to_directory</b>' that conforms to the following format: <br><br>job_spy_save_to_directory = {'MyLibraryName1': 'c:/my_save_to_dir_1', 'MyLibraryName2': 'c:/my_save_to_dir_2', 'MyLibraryName3': 'c:/my_save_to_dir_3', 'MyLibraryName4': 'c:/my_save_to_dir_4'}\
                                                                <br><br>For Windows paths, always use '/' and <b>never</b> '\\' , and do not use any double-quotes around any path that you specify for this Tweak.\
                                                                <br><br>Each 'Library Name-to-Directory' pair <b>must</b> be in this colon-separated format:   'MyLibraryName': 'c:/mydirX'  (with multiple pairs comma-separated).\
                                                                <br><br>The entire specification of pairs <b>must</b> be surrounded by 'braces', {.....}.  Example: {'MyLibraryNameA': 'c:/mydirA', 'MyLibraryNameB': 'c:/mydirB'}\
                                                                <br><br>If you make a format error in Preferences > Tweaks > Plugin Tweaks, your Tweak will be ignored, and an error message will be displayed in a non-modal Information dialog.\
                                                                <br><br>The 'Default Tweak Directory' will be used for any Library <b>not</b> otherwise specified in Preferences > Tweaks > Plugin Tweaks for <b>job_spy_save_to_directory</b>.\
                                                                <br><br>If you do not include every Library name in this Tweak, then those missing Libraries will default automatically to the 'Default Tweak Directory'.\
                                                                <br><br>Restart Calibre after making any changes."

        self.tweak_save_to_directory_by_library_label = QLabel("Tweak for Per-Library: 'Save-To Directory':     Default Directory:     ")
        self.tweak_save_to_directory_by_library_label.setMinimumWidth(400)
        #~ self.tweak_save_to_directory_by_library_label.setMaximumWidth(400)
        self.tweak_save_to_directory_by_library_label.setToolTip(t)
        self.layout_tweak_save_to_directory_by_library.addWidget(self.tweak_save_to_directory_by_library_label)

        self.tweak_save_to_directory_by_library_lineedit = QLineEdit(self)
        self.tweak_save_to_directory_by_library_lineedit.setToolTip(t)
        self.tweak_save_to_directory_by_library_lineedit.setMinimumWidth(300)
        #~ self.tweak_save_to_directory_by_library_lineedit.setMaximumWidth(300)
        self.tweak_save_to_directory_by_library_lineedit.setText(prefs['GUI_TOOLS_DEFAULT_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY'])
        self.layout_tweak_save_to_directory_by_library.addWidget(self.tweak_save_to_directory_by_library_lineedit)

        self.spacer_tweak_save_to_directory_by_library_label = QLabel("   ")
        self.layout_tweak_save_to_directory_by_library.addWidget(self.spacer_tweak_save_to_directory_by_library_label)

        self.tweak_save_to_directory_by_library_activate_checkbox = QCheckBox("Activate?")
        self.tweak_save_to_directory_by_library_activate_checkbox.setToolTip(t)
        self.tweak_save_to_directory_by_library_activate_checkbox.setMinimumWidth(150)
        self.layout_tweak_save_to_directory_by_library.addWidget(self.tweak_save_to_directory_by_library_activate_checkbox)

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY'] == unicode_type("True"):
            self.tweak_save_to_directory_by_library_activate_checkbox.setChecked(True)
        else:
            self.tweak_save_to_directory_by_library_activate_checkbox.setChecked(False)
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_15b_label = QLabel("")
        self.layout_tweaks_groupbox.addWidget(self.spacer_15b_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_tweak_save_to_template_by_library = QHBoxLayout()
        self.layout_tweak_save_to_template_by_library.setAlignment(Qt.AlignLeft)
        self.layout_tweaks_groupbox.addLayout(self.layout_tweak_save_to_template_by_library)

        t = "<p style='white-space:wrap'>To <b>completely activate</b> this GUI Tool, you must <b>also</b> do the following: \
                                                                <br><br>Go To 'Preferences > Tweaks > Plugin Tweaks' and then add a Tweak value for '<b>job_spy_save_to_template</b>' that conforms to the following format: <br><br>job_spy_save_to_template = {'MyLibraryName1': '{author_sort}/{title}/{title} - {authors}', 'MyLibraryName2': '{author_sort}/{title}/{title} - {authors}', 'MyLibraryName3': '{author_sort}/{title}/{title} - {authors}', 'MyLibraryName4': '{author_sort}/{title}/{title} - {authors}'}\
                                                                <br><br>Each 'Library Name-to-Template' pair <b>must</b> be in this colon-separated format:   'MyLibraryName': '{author_sort}/{title}/{title} - {authors}'  (with multiple pairs comma-separated).\
                                                                <br><br>The entire specification of pairs <b>must</b> be surrounded by 'braces', {.....}.  Example: {'MyLibraryNameA': '{author_sort}/{title}/{title} - {authors}', 'MyLibraryNameB': '{author_sort}/{title}/{title} - {authors}'}\
                                                                <br><br>If you make a format error in Preferences > Tweaks > Plugin Tweaks, your Tweak will be ignored, and an error message will be displayed in a non-modal Information dialog.\
                                                                <br><br>The 'Default Tweak Template' will be used for any Library <b>not</b> otherwise specified in Preferences > Tweaks > Plugin Tweaks for <b>job_spy_save_to_template</b>.\
                                                                <br><br>If you do not include every Library name in this Tweak, then those missing Libraries will default automatically to the 'Default Tweak Template'.\
                                                                <br><br>Restart Calibre after making any changes."

        self.tweak_save_to_template_by_library_label = QLabel("Tweak for Per-Library: 'Save-To Template':     Default Template:     ")
        self.tweak_save_to_template_by_library_label.setMinimumWidth(400)
        #~ self.tweak_save_to_template_by_library_label.setMaximumWidth(400)
        self.tweak_save_to_template_by_library_label.setToolTip(t)
        self.layout_tweak_save_to_template_by_library.addWidget(self.tweak_save_to_template_by_library_label)

        self.tweak_save_to_template_by_library_lineedit = QLineEdit(self)
        self.tweak_save_to_template_by_library_lineedit.setToolTip(t)
        self.tweak_save_to_template_by_library_lineedit.setMinimumWidth(300)
        #~ self.tweak_save_to_template_by_library_lineedit.setMaximumWidth(300)
        self.tweak_save_to_template_by_library_lineedit.setText(prefs['GUI_TOOLS_DEFAULT_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'])
        self.layout_tweak_save_to_template_by_library.addWidget(self.tweak_save_to_template_by_library_lineedit)

        self.spacer_tweak_save_to_template_by_library_label = QLabel("   ")
        self.layout_tweak_save_to_template_by_library.addWidget(self.spacer_tweak_save_to_template_by_library_label)

        self.tweak_save_to_template_by_library_activate_checkbox = QCheckBox("Activate?")
        self.tweak_save_to_template_by_library_activate_checkbox.setToolTip(t)
        self.tweak_save_to_template_by_library_activate_checkbox.setMinimumWidth(150)
        self.layout_tweak_save_to_template_by_library.addWidget(self.tweak_save_to_template_by_library_activate_checkbox)

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] == unicode_type("True"):
            self.tweak_save_to_template_by_library_activate_checkbox.setChecked(True)
        else:
            self.tweak_save_to_template_by_library_activate_checkbox.setChecked(False)
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_15c_label = QLabel("")
        self.layout_tweaks_groupbox.addWidget(self.spacer_15c_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_tweak_save_cover_separately_by_library = QHBoxLayout()
        self.layout_tweak_save_cover_separately_by_library.setAlignment(Qt.AlignLeft)
        self.layout_tweaks_groupbox.addLayout(self.layout_tweak_save_cover_separately_by_library)

        t = "<p style='white-space:wrap'>To <b>completely activate</b> this GUI Tool, you must <b>also</b> do the following: \
                                                                <br><br>Go To 'Preferences > Tweaks > Plugin Tweaks' and then add a Tweak value for '<b>job_spy_save_cover_separately</b>' that conforms to the following format: <br><br>job_spy_save_cover_separately = {'MyLibraryName1': 'False', 'MyLibraryName2': 'False', 'MyLibraryName3': 'False', 'MyLibraryName4': 'False'}\
                                                                <br><br>Each 'Library Name-to-Option' pair <b>must</b> be in this colon-separated format:   'MyLibraryName': 'False'  (with multiple pairs comma-separated).\
                                                                <br><br>The entire specification of pairs <b>must</b> be surrounded by 'braces', {.....}.  Example: {'MyLibraryNameA': 'False', 'MyLibraryNameB': 'False'}\
                                                                <br><br>The Calibre default of 'True' will be used for any Library <b>not</b> otherwise specified in Preferences > Tweaks > Plugin Tweaks for <b>job_spy_save_cover_separately</b>.\
                                                                <br><br>If you do not include every Library name in this Tweak, then those missing Libraries will default automatically to 'True'.  So, you need only specify the 'False' Library Names.\
                                                                <br><br>Restart Calibre after making any changes."


        self.tweak_save_cover_separately_by_library_label = QLabel("Tweak for Per-Library: 'Save Cover Separately': ")
        self.tweak_save_cover_separately_by_library_label.setMinimumWidth(325)
        #~ self.tweak_save_cover_separately_by_library_label.setMaximumWidth(325)
        self.tweak_save_cover_separately_by_library_label.setToolTip(t)
        self.layout_tweak_save_cover_separately_by_library.addWidget(self.tweak_save_cover_separately_by_library_label)

        self.tweak_save_cover_separately_by_library_activate_checkbox = QCheckBox("Activate?")
        self.tweak_save_cover_separately_by_library_activate_checkbox.setToolTip(t)
        self.layout_tweak_save_cover_separately_by_library.addWidget(self.tweak_save_cover_separately_by_library_activate_checkbox)

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_COVER_SEPARATELY_BY_LIBRARY'] == unicode_type("True"):
            self.tweak_save_cover_separately_by_library_activate_checkbox.setChecked(True)
        else:
            self.tweak_save_cover_separately_by_library_activate_checkbox.setChecked(False)
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_15d_label = QLabel("")
        self.layout_tweaks_groupbox.addWidget(self.spacer_15d_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_tweak_save_metadata_in_opf_file_by_library = QHBoxLayout()
        self.layout_tweak_save_metadata_in_opf_file_by_library.setAlignment(Qt.AlignLeft)
        self.layout_tweaks_groupbox.addLayout(self.layout_tweak_save_metadata_in_opf_file_by_library)

        t = "<p style='white-space:wrap'>To <b>completely activate</b> this GUI Tool, you must <b>also</b> do the following: \
                                                                <br><br>Go To 'Preferences > Tweaks > Plugin Tweaks' and then add a Tweak value for '<b>job_spy_save_metadata_in_opf_file</b>' that conforms to the following format: <br><br>job_spy_save_metadata_in_opf_file = {'MyLibraryName1': 'False', 'MyLibraryName2': 'False', 'MyLibraryName3': 'False', 'MyLibraryName4': 'False'}\
                                                                <br><br>Each 'Library Name-to-Option' pair <b>must</b> be in this colon-separated format:   'MyLibraryName': 'False'  (with multiple pairs comma-separated).\
                                                                <br><br>The entire specification of pairs <b>must</b> be surrounded by 'braces', {.....}.  Example: {'MyLibraryNameA': 'False', 'MyLibraryNameB': 'False'}\
                                                                <br><br>The Calibre default of 'True' will be used for any Library <b>not</b> otherwise specified in Preferences > Tweaks > Plugin Tweaks for <b>job_spy_save_metadata_in_opf_file</b>.\
                                                                <br><br>If you do not include every Library name in this Tweak, then those missing Libraries will default automatically to 'True'.  So, you need only specify the 'False' Library Names.\
                                                                <br><br>Restart Calibre after making any changes."


        self.tweak_save_metadata_in_opf_file_by_library_label = QLabel("Tweak for Per-Library: 'Save Metadata in OPF File': ")
        self.tweak_save_metadata_in_opf_file_by_library_label.setMinimumWidth(325)
        #~ self.tweak_save_metadata_in_opf_file_by_library_label.setMaximumWidth(325)
        self.tweak_save_metadata_in_opf_file_by_library_label.setToolTip(t)
        self.layout_tweak_save_metadata_in_opf_file_by_library.addWidget(self.tweak_save_metadata_in_opf_file_by_library_label)

        self.tweak_save_metadata_in_opf_file_by_library_activate_checkbox = QCheckBox("Activate?")
        self.tweak_save_metadata_in_opf_file_by_library_activate_checkbox.setToolTip(t)
        self.layout_tweak_save_metadata_in_opf_file_by_library.addWidget(self.tweak_save_metadata_in_opf_file_by_library_activate_checkbox)

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_METADATA_IN_OPF_FILE_BY_LIBRARY'] == unicode_type("True"):
            self.tweak_save_metadata_in_opf_file_by_library_activate_checkbox.setChecked(True)
        else:
            self.tweak_save_metadata_in_opf_file_by_library_activate_checkbox.setChecked(False)
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_15d1_label = QLabel("")
        self.layout_tweaks_groupbox.addWidget(self.spacer_15d1_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_tweak_default_output_format_by_library = QHBoxLayout()
        self.layout_tweak_default_output_format_by_library.setAlignment(Qt.AlignLeft)
        self.layout_tweaks_groupbox.addLayout(self.layout_tweak_default_output_format_by_library)

        t = "<p style='white-space:wrap'>To <b>completely activate</b> this GUI Tool, you must <b>also</b> do the following: \
                                                                <br><br>Go To 'Preferences > Tweaks > Plugin Tweaks' and then add a Tweak value for '<b>job_spy_default_output_format</b>' that conforms to the following format: <br><br>job_spy_default_output_format = {'MyLibraryName1': 'PDF', 'MyLibraryName2': 'MOBI', 'MyLibraryName3': 'PDF', 'MyLibraryName4': 'MOBI'}\
                                                                <br><br>Each 'Library Name-to-Option' pair <b>must</b> be in this colon-separated format:   'MyLibraryName': 'EPUB'  (with multiple pairs comma-separated).\
                                                                <br><br>The entire specification of pairs <b>must</b> be surrounded by 'braces', {.....}.  Example: {'MyLibraryNameA': 'MOBI', 'MyLibraryNameB': 'PDF'}\
                                                                <br><br>The default value that you specify in the drop-down list for this GUI Tool will be used for any Library <b>not</b> otherwise specified in Preferences > Tweaks > Plugin Tweaks for <b>job_spy_default_output_format</b>.\
                                                                <br><br>If you do not include every Library name in this Tweak, then those missing Libraries will default automatically to the default value that you specify in the drop-down list for this GUI Tool.  So, you need only specify the Library Names that are an exception to this default value rule.\
                                                                <br><br>Restart Calibre after making any changes."

        self.tweak_default_output_format_by_library_label = QLabel("Tweak for Per-Library: 'Default Output Format':")
        self.tweak_default_output_format_by_library_label.setMinimumWidth(325)
        #~ self.tweak_default_output_format_by_library_label.setMaximumWidth(325)
        self.tweak_default_output_format_by_library_label.setToolTip(t)
        self.layout_tweak_default_output_format_by_library.addWidget(self.tweak_default_output_format_by_library_label)

        self.tweak_default_output_format_by_library_activate_checkbox = QCheckBox("Activate?")
        self.tweak_default_output_format_by_library_activate_checkbox.setToolTip(t)
        self.layout_tweak_default_output_format_by_library.addWidget(self.tweak_default_output_format_by_library_activate_checkbox)

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY'] == unicode_type("True"):
            self.tweak_default_output_format_by_library_activate_checkbox.setChecked(True)
        else:
            self.tweak_default_output_format_by_library_activate_checkbox.setChecked(False)


        t = "<p style='white-space:wrap'>This format will be used <b>instead of</b> Calibre's 'Default Output Format' in 'Preferences > Behavior' if <b>no</b> Tweak for a Library is found in 'Preferences > Tweaks > Plugin Tweaks'.\
                                                               <br><br>You should <b><i>no longer manually change Calibre's 'Default Output Format' in 'Preferences > Behavior'</i></b>, since JS will automatically maintain that value after you Activate this Tool."

        self.tweak_default_output_format_by_library_combobox = QComboBox()
        self.tweak_default_output_format_by_library_combobox.setEditable(False)
        self.tweak_default_output_format_by_library_combobox.setFont(font)
        self.tweak_default_output_format_by_library_combobox.setMinimumWidth(100)
        #~ self.tweak_default_output_format_by_library_combobox.setMaximumWidth(100)
        self.tweak_default_output_format_by_library_combobox.setToolTip(t)
        self.layout_tweak_default_output_format_by_library.addWidget(self.tweak_default_output_format_by_library_combobox)

        output_formats_set = available_output_formats()  #all lower case
        output_formats_set.remove('oeb')
        output_formats_list = list(output_formats_set)
        output_formats_list.sort()
        for choice in output_formats_list:
            self.tweak_default_output_format_by_library_combobox.addItem(choice.upper())
        #END FOR

        df = prefs['GUI_TOOLS_DEFAULT_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY']
        df = df.lower()
        if not df in output_formats_list:
            df = "EPUB"
            prefs['GUI_TOOLS_DEFAULT_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY'] = "EPUB"
            prefs
        else:
            df = df.upper()

        self.tweak_default_output_format_by_library_combobox.setCurrentText(df)

        del output_formats_set
        del output_formats_list
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_15e_label = QLabel("")
        self.layout_tweaks_groupbox.addWidget(self.spacer_15e_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_tweak_title_series_sorting_by_library = QHBoxLayout()
        self.layout_tweak_title_series_sorting_by_library.setAlignment(Qt.AlignLeft)
        self.layout_tweaks_groupbox.addLayout(self.layout_tweak_title_series_sorting_by_library)

        t = "<p style='white-space:wrap'>To <b>completely activate</b> this GUI Tool, you must <b>also</b> do the following: \
                                                                <br><br>Go To 'Preferences > Tweaks > Plugin Tweaks' and then add a Tweak value for '<b>job_spy_title_series_sorting</b>' that conforms to the following format: <br><br>job_spy_title_series_sorting = {'MyLibraryName1': 'strictly_alphabetic', 'MyLibraryName2': 'strictly_alphabetic', 'MyLibraryName3': 'strictly_alphabetic', 'MyLibraryName4': 'strictly_alphabetic'}\
                                                                <br><br>Each 'Library Name-to-Option' pair <b>must</b> be in this colon-separated format:   'MyLibraryName': 'strictly_alphabetic'  (with multiple pairs comma-separated).\
                                                                <br><br>The entire specification of pairs <b>must</b> be surrounded by 'braces', {.....}.  Example: {'MyLibraryNameA': 'strictly_alphabetic', 'MyLibraryNameB': 'strictly_alphabetic'}\
                                                                <br><br>The Calibre default of 'library_order' will be used for any Library <b>not</b> otherwise specified in Preferences > Tweaks > Plugin Tweaks for <b>job_spy_title_series_sorting</b>.\
                                                                <br><br>If you do not include every Library name in this Tweak, then those missing Libraries will default automatically to 'library_order'.  So, you need only specify the 'strictly_alphabetic' Library Names.\
                                                                <br><br>Restart Calibre after making any changes."

        self.tweak_title_series_sorting_by_library_label = QLabel("Tweak for Per-Library: 'Title_Series_Sorting': ")
        self.tweak_title_series_sorting_by_library_label.setMinimumWidth(325)
        #~ self.tweak_title_series_sorting_by_library_label.setMaximumWidth(325)
        self.tweak_title_series_sorting_by_library_label.setToolTip(t)
        self.layout_tweak_title_series_sorting_by_library.addWidget(self.tweak_title_series_sorting_by_library_label)

        self.tweak_title_series_sorting_by_library_activate_checkbox = QCheckBox("Activate?")
        self.tweak_title_series_sorting_by_library_activate_checkbox.setToolTip(t)
        self.layout_tweak_title_series_sorting_by_library.addWidget(self.tweak_title_series_sorting_by_library_activate_checkbox)

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_TITLE_SERIES_SORTING_BY_LIBRARY'] == unicode_type("True"):
            self.tweak_title_series_sorting_by_library_activate_checkbox.setChecked(True)
        else:
            self.tweak_title_series_sorting_by_library_activate_checkbox.setChecked(False)
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_15f_label = QLabel("")
        self.layout_tweaks_groupbox.addWidget(self.spacer_15f_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_tweak_metadata_edit_custom_column_order_by_library = QHBoxLayout()
        self.layout_tweak_metadata_edit_custom_column_order_by_library.setAlignment(Qt.AlignLeft)
        self.layout_tweaks_groupbox.addLayout(self.layout_tweak_metadata_edit_custom_column_order_by_library)

        t = "<p style='white-space:wrap'>To <b>completely activate</b> this GUI Tool, you must <b>also</b> do the following: \
                                                                <br><br>Go To 'Preferences > Tweaks > Plugin Tweaks' and then add a Tweak value for '<b>job_spy_metadata_edit_custom_column_order</b>' that conforms to the following format: \
                                                                <br><br>job_spy_metadata_edit_custom_column_order = {'MyLibraryName1': ['#x','#y','#z'], 'MyLibraryName2': ['#x','#y','#z'], 'MyLibraryName3': ['#x','#y','#z'], 'MyLibraryName4': ['#x','#y','#z']}\
                                                                <br><br>Each 'Library:Order' pair <b>must</b> be in this colon-separated format:   'MyLibraryName': ['#x','#y','#z']  (with multiple pairs comma-separated).\
                                                                <br><br>The entire specification of pairs <b>must</b> be surrounded by 'braces', {.....}.  Example: {'MyLibraryNameA': ['#x','#y','#z'], 'MyLibraryNameB': ['#x','#y','#z']}\
                                                                <br><br>Carefully note the location of single quotes where they should exist, and their absence where they should not exist.\
                                                                <br><br>If you make a format error in Preferences > Tweaks > Plugin Tweaks, your Tweak will be ignored, and an error message will be displayed in a non-modal Information dialog.\
                                                                <br><br>The 'Default Order' will be used for any Library <b>not</b> otherwise specified in Preferences > Tweaks > Plugin Tweaks for <b>job_spy_metadata_edit_custom_column_order</b>.\
                                                                <br><br>If you do not include every Library name in this Tweak, then those missing Libraries will default automatically to the 'Default Order' specified here. "


        self.tweak_metadata_edit_custom_column_order_by_library_label = QLabel("Tweak for Per-Library: 'Metadata Edit CC Order':     Default Order:     ")
        self.tweak_metadata_edit_custom_column_order_by_library_label.setMinimumWidth(400)
        #~ self.tweak_metadata_edit_custom_column_order_by_library_label.setMaximumWidth(400)
        self.tweak_metadata_edit_custom_column_order_by_library_label.setToolTip(t)
        self.layout_tweak_metadata_edit_custom_column_order_by_library.addWidget(self.tweak_metadata_edit_custom_column_order_by_library_label)

        self.tweak_metadata_edit_custom_column_order_by_library_lineedit = QLineEdit(self)
        self.tweak_metadata_edit_custom_column_order_by_library_lineedit.setToolTip(t)
        self.tweak_metadata_edit_custom_column_order_by_library_lineedit.setMinimumWidth(300)
        #~ self.tweak_metadata_edit_custom_column_order_by_library_lineedit.setMaximumWidth(300)
        self.tweak_metadata_edit_custom_column_order_by_library_lineedit.setText(prefs['GUI_TOOLS_DEFAULT_TWEAK_METADATA_EDIT_CUSTOM_COLUMN_ORDER_BY_LIBRARY'])
        self.layout_tweak_metadata_edit_custom_column_order_by_library.addWidget(self.tweak_metadata_edit_custom_column_order_by_library_lineedit)

        self.spacer_metadata_edit_custom_column_order_by_library_label = QLabel("   ")
        self.layout_tweak_metadata_edit_custom_column_order_by_library.addWidget(self.spacer_metadata_edit_custom_column_order_by_library_label)

        self.tweak_metadata_edit_custom_column_order_by_library_activate_checkbox = QCheckBox("Activate?")
        self.tweak_metadata_edit_custom_column_order_by_library_activate_checkbox.setToolTip(t)
        self.tweak_metadata_edit_custom_column_order_by_library_activate_checkbox.setMinimumWidth(150)
        self.layout_tweak_metadata_edit_custom_column_order_by_library.addWidget(self.tweak_metadata_edit_custom_column_order_by_library_activate_checkbox)

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_METADATA_EDIT_CUSTOM_COLUMN_ORDER_BY_LIBRARY'] == unicode_type("True"):
            self.tweak_metadata_edit_custom_column_order_by_library_activate_checkbox.setChecked(True)
        else:
            self.tweak_metadata_edit_custom_column_order_by_library_activate_checkbox.setChecked(False)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_15g_label = QLabel("")
        self.layout_tweaks_groupbox.addWidget(self.spacer_15g_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_tweak_tag_browser_category_order_by_library = QHBoxLayout()
        self.layout_tweak_tag_browser_category_order_by_library.setAlignment(Qt.AlignLeft)
        self.layout_tweaks_groupbox.addLayout(self.layout_tweak_tag_browser_category_order_by_library)

        t = "<p style='white-space:wrap'>To <b>completely activate</b> this GUI Tool, you must <b>also</b> do the following:"
        t = t + "<br><br>Go To 'Preferences > Tweaks > Plugin Tweaks' and then add two (2) different Tweak assignments: (1) Order Definition; and (2) Library Assignment of Order Definition."
        t = t + "<br><br><b>job_spy_tag_browser_category_order_assignment</b> = { 'CalibreJobSpyTest1': 'A', 'CalibreJobSpyTest2': 'B', 'CalibreJobSpyTest3': 'C' }"
        t = t + "<br><br><b>job_spy_tag_browser_category_order_definition</b> = { 'A': {'languages': 1 ,'*': 2} , 'B': {'series': 1, '*': 2} , 'C': {'#genre': 1, '*': 2} , 'D': {'#genre':1, 'series':2, 'tags':3, '*':4} }"
        t = t + "<br><br>The Calibre default of 'tag_browser_category_order = {u'*': 1}' will be used for any Library <b>not</b> otherwise specified in Preferences > Tweaks > Plugin Tweaks for <b>job_spy_tag_browser_category_order_assignment</b>."
        t = t + "<br><br>The Calibre default of 'tag_browser_category_order = {u'*': 1}' will be used for any Library <b>not</b> assigned a valid <b>job_spy_tag_browser_category_order_definition</b>."
        t = t + "<br><br><br>Caution: be <b><u>very careful</u></b> in defining each 'category order definition' using 'job_spy_tag_browser_category_order_definition'; improper configuration could possibly cause Calibre Startup errors.  Be careful, and back up your Calibre configuration directory periodically, and also just before configuring this particular Tweak. "

        self.tweak_tag_browser_category_order_by_library_label = QLabel("Tweak for Per-Library: 'Tag Browser Category Order': ")
        self.tweak_tag_browser_category_order_by_library_label.setMinimumWidth(325)
        #~ self.tweak_tag_browser_category_order_by_library_label.setMaximumWidth(325)
        self.tweak_tag_browser_category_order_by_library_label.setToolTip(t)
        self.layout_tweak_tag_browser_category_order_by_library.addWidget(self.tweak_tag_browser_category_order_by_library_label)

        self.tweak_tag_browser_category_order_by_library_activate_checkbox = QCheckBox("Activate?")
        self.tweak_tag_browser_category_order_by_library_activate_checkbox.setToolTip(t)
        self.layout_tweak_tag_browser_category_order_by_library.addWidget(self.tweak_tag_browser_category_order_by_library_activate_checkbox)

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_TAG_BROWSER_CATEGORY_ORDER'] == unicode_type("True"):
            self.tweak_tag_browser_category_order_by_library_activate_checkbox.setChecked(True)
        else:
            self.tweak_tag_browser_category_order_by_library_activate_checkbox.setChecked(False)

       #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_15h_label = QLabel("")
        self.layout_tweaks_groupbox.addWidget(self.spacer_15h_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_tweak_default_author_link_by_library = QHBoxLayout()
        self.layout_tweak_default_author_link_by_library.setAlignment(Qt.AlignLeft)
        self.layout_tweaks_groupbox.addLayout(self.layout_tweak_default_author_link_by_library)

        t = "<p style='white-space:wrap'>To <b>completely activate</b> this GUI Tool, you must <b>also</b> do the following: \
                                                                <br><br>Go To 'Preferences > Tweaks > Plugin Tweaks' and then add a Tweak value for '<b>job_spy_default_author_link_by_library</b>' that conforms to the following format: \
                                                                <br><br>job_spy_default_author_link_by_library = {'MyLibraryName1': 'valid_choice', 'MyLibraryName2': 'valid_choice', 'MyLibraryName3': 'valid_choice', 'MyLibraryName4': 'valid_choice'}\
                                                                <br><br>The 'valid_choice' refers to either pre-defined 'search-xxxxxx' values in the dropdown list, <b>OR</b> to the custom URL that you specify.  \
                                                                <br><br>The entire specification of pairs <b>must</b> be surrounded by 'braces', {.....}, as shown above.\
                                                                <br><br>Carefully note the location of single quotes where they should exist, and their absence where they should not exist.\
                                                                <br><br>If you make a format error in Preferences > Tweaks > Plugin Tweaks, your Tweak will be ignored, and an error message will be displayed in a non-modal Information dialog.\
                                                                <br><br>The 'Default' will be used for any Library <b>not</b> otherwise specified in Preferences > Tweaks > Plugin Tweaks for <b>job_spy_default_author_link_by_library</b>.\
                                                                <br><br>If you do not include every Library name in this Tweak, then those missing Libraries will default automatically to the 'Default' specified here. "

        self.tweak_default_author_link_by_library_label = QLabel("Tweak for Per-Library: 'Default Author Link': ")
        self.tweak_default_author_link_by_library_label.setMaximumWidth(300)
        self.tweak_default_author_link_by_library_label.setToolTip(t)
        self.layout_tweak_default_author_link_by_library.addWidget(self.tweak_default_author_link_by_library_label)

        self.tweak_default_author_link_by_library_activate_checkbox = QCheckBox("Activate?")
        self.tweak_default_author_link_by_library_activate_checkbox.setToolTip(t)
        self.layout_tweak_default_author_link_by_library.addWidget(self.tweak_default_author_link_by_library_activate_checkbox)

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_DEFAULT_AUTHOR_LINK_BY_LIBRARY'] == unicode_type("True"):
            self.tweak_default_author_link_by_library_activate_checkbox.setChecked(True)
        else:
            self.tweak_default_author_link_by_library_activate_checkbox.setChecked(False)

        self.tweak_default_author_link_by_library_combobox_label = QLabel("Default: ")
        self.tweak_default_author_link_by_library_combobox_label.setMaximumWidth(100)
        self.layout_tweak_default_author_link_by_library.addWidget(self.tweak_default_author_link_by_library_combobox_label)

        self.tweak_default_author_link_by_library_qcombobox = QComboBox(self)
        self.tweak_default_author_link_by_library_qcombobox.setToolTip(t)
        self.tweak_default_author_link_by_library_qcombobox.setMaximumWidth(200)
        self.layout_tweak_default_author_link_by_library.addWidget(self.tweak_default_author_link_by_library_qcombobox)

        self.tweak_default_author_link_by_library_qcombobox.addItem('search-goodreads')
        self.tweak_default_author_link_by_library_qcombobox.addItem('search-amzn')
        self.tweak_default_author_link_by_library_qcombobox.addItem('search-calibre')
        self.tweak_default_author_link_by_library_qcombobox.addItem('search-wikipedia')
        self.tweak_default_author_link_by_library_qcombobox.addItem('search-google')
        self.tweak_default_author_link_by_library_qcombobox.addItem('search-goodreads-book')
        self.tweak_default_author_link_by_library_qcombobox.addItem('search-amzn-book')
        self.tweak_default_author_link_by_library_qcombobox.addItem('search-google-book')
        self.tweak_default_author_link_by_library_qcombobox.addItem('Use a custom search URL')

        self.tweak_default_author_link_by_library_qcombobox.setCurrentIndex(0)

        try:
            self.tweak_default_author_link_by_library_qcombobox.setCurrentText(prefs['GUI_TOOLS_DEFAULT_TWEAK_DEFAULT_AUTHOR_LINK_BY_LIBRARY'])
        except Exception as e:
            self.tweak_default_author_link_by_library_qcombobox.setCurrentIndex(0)
            if DEBUG: print("Error:  self.tweak_default_author_link_by_library_qcombobox.setCurrentText(prefs['GUI_TOOLS_DEFAULT_TWEAK_DEFAULT_AUTHOR_LINK_BY_LIBRARY']): ", str(e))

        self.tweak_default_author_link_by_library_lineedit_label = QLabel("Custom URL: ")
        self.tweak_default_author_link_by_library_lineedit_label.setMaximumWidth(150)
        self.layout_tweak_default_author_link_by_library.addWidget(self.tweak_default_author_link_by_library_lineedit_label)

        self.tweak_default_author_link_by_library_lineedit = QLineEdit(self)
        self.tweak_default_author_link_by_library_lineedit.setToolTip(t)
        self.tweak_default_author_link_by_library_lineedit.setMaximumWidth(200)
        self.tweak_default_author_link_by_library_lineedit.setText(prefs['GUI_TOOLS_CUSTOM_URL_TWEAK_DEFAULT_AUTHOR_LINK_BY_LIBRARY'])
        self.layout_tweak_default_author_link_by_library.addWidget(self.tweak_default_author_link_by_library_lineedit)


#~ zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_16_label = QLabel("")
        self.layout_top.addWidget(self.spacer_16_label)
        #--------------------------------------------------
        #--------------------------------------------------

        t = "<p style='white-space:wrap'>If you wish to enable changing pre-existing Author Sorts for complex surnames, specify the Regular Expression that should be used to extract the entire surname (a.k.a. 'last name').  Everything else within the Author Name will be considered as the 'first name(s)'.\
             <br><br>To execute this function, use the Tool found in Metadata Tools named 'Update Author Sort for Complex Surnames'.\
             <br><br>This function cannot be used with the 'author_sort_copy_method = 'copy' standard Calibre tweak, as that method would be pointless in these cases.\
            <br><br>The selected books must have a valid Author Sort (i.e., it is not the color 'red' if you were to use the 'Edit Metadata' function). If not, then you must use 'Bulk Edit Metadata' to automatically set the Author Sorts for those books prior to using this tool.\
             <br><br>Example:  Author 'Walter de la Mare' could be changed to have an Author Sort of 'de la Mare, Walter' for a sort method of 'invert' (or 'comma').\
             <br><br>When you save these settings, the Regular Expression will be tested to see if it is a valid Regular Expression.  If not, it will be changed to the default RE. \
             <br><br>Caution:  Being a valid RE is not the same as being a correct RE!  You must test your RE thorougly elsewhere (for example, https://pythex.org/ ) before attempting to use it here."

        self.groupbox_complex_surnames = QGroupBox('Update Author Sort for Complex Surnames: ')
        self.groupbox_complex_surnames.setToolTip(t)
        self.layout_top.addWidget(self.groupbox_complex_surnames)

        self.layout_complex_surnames_groupbox = QVBoxLayout()
        self.groupbox_complex_surnames.setLayout(self.layout_complex_surnames_groupbox)

        self.layout_update_author_sort_for_complex_surnames = QHBoxLayout()
        self.layout_update_author_sort_for_complex_surnames.setAlignment(Qt.AlignLeft)
        self.layout_complex_surnames_groupbox.addLayout(self.layout_update_author_sort_for_complex_surnames)

        self.update_author_sort_for_complex_surnames_label = QLabel("REGEX to Extract Surname:")
        self.update_author_sort_for_complex_surnames_label.setToolTip(t)
        self.layout_update_author_sort_for_complex_surnames.addWidget(self.update_author_sort_for_complex_surnames_label)

        self.update_author_sort_for_complex_surnames_lineedit = QLineEdit(self)
        self.update_author_sort_for_complex_surnames_lineedit.setToolTip(t)
        self.update_author_sort_for_complex_surnames_lineedit.setText(prefs['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_REGEXP'])
        self.update_author_sort_for_complex_surnames_lineedit.setCursorPosition(0)
        self.layout_update_author_sort_for_complex_surnames.addWidget(self.update_author_sort_for_complex_surnames_lineedit)

        self.layout_update_author_sort_for_complex_surnames_ignore = QHBoxLayout()
        self.layout_update_author_sort_for_complex_surnames_ignore.setAlignment(Qt.AlignCenter)
        self.layout_complex_surnames_groupbox.addLayout(self.layout_update_author_sort_for_complex_surnames_ignore)

        t = "<p style='white-space:wrap'>The Regular Expression necessarily might be too broad to avoid treating certain 'middle names' as if they were otherwise desirable in the final surname.  Those exceptions may be specified here."

        self.update_author_sort_for_complex_surnames_ignore_label = QLabel("Full Name Particles to Ignore: ")
        self.update_author_sort_for_complex_surnames_ignore_label.setToolTip(t)
        self.layout_update_author_sort_for_complex_surnames_ignore.addWidget(self.update_author_sort_for_complex_surnames_ignore_label)

        self.update_author_sort_for_complex_surnames_ignore_lineedit = QLineEdit(self)
        self.update_author_sort_for_complex_surnames_ignore_lineedit.setToolTip(t)
        self.update_author_sort_for_complex_surnames_ignore_lineedit.setText(prefs['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_IGNORE'])
        self.update_author_sort_for_complex_surnames_ignore_lineedit.setCursorPosition(0)
        self.layout_update_author_sort_for_complex_surnames_ignore.addWidget(self.update_author_sort_for_complex_surnames_ignore_lineedit)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_17_label = QLabel("")
        self.layout_top.addWidget(self.spacer_17_label)
        #--------------------------------------------------
        #--------------------------------------------------

        t = "<p style='white-space:wrap'>This Tool allows you to automatically apply one or more metadata quality fixes to newly auto-added Books in order to reduce otherwise-required repetitive manual effort. "

        self.groupbox_quality_fixes = QGroupBox('Auto-Added Books: Automatic JS Quality Fixes')
        self.groupbox_quality_fixes.setToolTip(t)
        self.layout_top.addWidget(self.groupbox_quality_fixes)

        self.layout_quality_fixes_groupbox = QVBoxLayout()
        self.groupbox_quality_fixes.setLayout(self.layout_quality_fixes_groupbox)

        #~ --------------------------
        self.layout_quality_fixes_top = QHBoxLayout()
        self.layout_quality_fixes_top.setAlignment(Qt.AlignLeft)
        self.layout_quality_fixes_groupbox.addLayout(self.layout_quality_fixes_top)

        t = "<p style='white-space:wrap'>Do you wish to automatically apply one or more metadata quality fixes to newly auto-added Books?  "

        self.quality_fixes_activate_checkbox = QCheckBox("Activate?  [Change Requires Restart]        For Libraries: ")
        self.quality_fixes_activate_checkbox.setToolTip(t)
        self.layout_quality_fixes_top.addWidget(self.quality_fixes_activate_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_ACTIVATE'] == unicode_type("True"):
            self.quality_fixes_activate_checkbox.setChecked(True)
        else:
            self.quality_fixes_activate_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>You must specify for which Calibre Libraries this tool will be activated.  Specify the wildcard '*' to activate it for all Libraries.  Otherwise, specify one or more Library Names  separated with a bar ('|')."

        self.quality_fixes_activate_libraries_lineedit = QLineEdit(self)
        self.quality_fixes_activate_libraries_lineedit.setToolTip(t)
        self.quality_fixes_activate_libraries_lineedit.setText(prefs['GUI_TOOLS_QUALITY_FIXES_ACTIVATE_LIBRARIES'])
        self.quality_fixes_activate_libraries_lineedit.setCursorPosition(0)
        self.layout_quality_fixes_top.addWidget(self.quality_fixes_activate_libraries_lineedit)

        #~ ----------------------------
        self.layout_quality_fixes_clearings = QHBoxLayout()
        self.layout_quality_fixes_clearings.setAlignment(Qt.AlignCenter)
        self.layout_quality_fixes_groupbox.addLayout(self.layout_quality_fixes_clearings)

        t = "<p style='white-space:wrap'>Do you wish to automatically delete (clear) the Publisher for all newly auto-added books?"

        self.quality_fixes_clear_publishers_checkbox = QCheckBox("Clear Publishers?")
        self.quality_fixes_clear_publishers_checkbox.setToolTip(t)
        #~ self.quality_fixes_clear_publishers_checkbox.setMinimumWidth(150)
        self.layout_quality_fixes_clearings.addWidget(self.quality_fixes_clear_publishers_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_CLEAR_PUBLISHERS'] == unicode_type("True"):
            self.quality_fixes_clear_publishers_checkbox.setChecked(True)
        else:
            self.quality_fixes_clear_publishers_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>Do you wish to automatically delete (clear) all Tags for all newly auto-added books?"

        self.quality_fixes_clear_tags_checkbox = QCheckBox("Clear Tags?")
        self.quality_fixes_clear_tags_checkbox.setToolTip(t)
        self.layout_quality_fixes_clearings.addWidget(self.quality_fixes_clear_tags_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_CLEAR_TAGS'] == unicode_type("True"):
            self.quality_fixes_clear_tags_checkbox.setChecked(True)
        else:
            self.quality_fixes_clear_tags_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>Do you wish to automatically 'Scrub' the Titles for newly auto-added books?"

        self.quality_fixes_scrub_titles_checkbox = QCheckBox("Scrub Titles (Delete Authors && Certain Words; Move/Delete Series && Index)?")
        self.quality_fixes_scrub_titles_checkbox.setToolTip(t)
        self.layout_quality_fixes_clearings.addWidget(self.quality_fixes_scrub_titles_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES'] == unicode_type("True"):
            self.quality_fixes_scrub_titles_checkbox.setChecked(True)
        else:
            self.quality_fixes_scrub_titles_checkbox.setChecked(False)

        #~ ----------------------------
        self.layout_quality_fixes_original_title = QHBoxLayout()
        self.layout_quality_fixes_original_title.setAlignment(Qt.AlignCenter)
        self.layout_quality_fixes_groupbox.addLayout(self.layout_quality_fixes_original_title)

        t = "<p style='white-space:wrap'>Since this GUI Tool is intended to be used in a 'WorkBench' type of Library, it is appropriate to allow the Original Title, prior to any changes by JS, to be captured for later comparison to the 'scrubbed' Title.  Specify that Custom Column #name here.\
                                                               <br><br>This Custom Column <b>must</b> be a 'Comments - Short Text Like a Title - Plain Text (Not HTML)' type of Custom Column.  Simply use the Preferences > Add your own columns > Add a user-defined column > 'Quick Create' link for 'Short Text'."

        self.quality_fixes_scrub_titles_original_title_label = QLabel("Custom Column to update with the Original Title prior to scrubbing:")
        #~ self.quality_fixes_scrub_titles_original_title_label.setMaximumWidth(450)
        self.quality_fixes_scrub_titles_original_title_label.setToolTip(t)
        self.layout_quality_fixes_original_title.addWidget(self.quality_fixes_scrub_titles_original_title_label)

        self.quality_fixes_scrub_titles_original_title_lineedit = QLineEdit(self)
        #~ self.quality_fixes_scrub_titles_original_title_lineedit.setMaximumWidth(200)
        self.quality_fixes_scrub_titles_original_title_lineedit.setToolTip(t)
        self.quality_fixes_scrub_titles_original_title_lineedit.setText(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_ORIGINAL_TITLE_CUSTOM_COLUMN'])
        self.layout_quality_fixes_original_title.addWidget(self.quality_fixes_scrub_titles_original_title_lineedit)

        #~ ----------------------------
        self.layout_quality_fixes_original_series = QHBoxLayout()
        self.layout_quality_fixes_original_series.setAlignment(Qt.AlignCenter)
        self.layout_quality_fixes_groupbox.addLayout(self.layout_quality_fixes_original_series)

        t = "<p style='white-space:wrap'>Since this GUI Tool is intended to be used in a 'WorkBench' type of Library, it is appropriate to allow the Original Series, prior to any changes by JS, to be captured for later comparison to the 'scrubbed' Series.  Specify that Custom Column #name here.\
                                                               <br><br>This Custom Column <b>must</b> be a 'Comments - Short Text Like a Series - Plain Text (Not HTML)' type of Custom Column.  Simply use the Preferences > Add your own columns > Add a user-defined column > 'Quick Create' link for 'Short Text'."

        self.quality_fixes_scrub_series_original_series_label = QLabel("Custom Column to update with the Original Series prior to scrubbing:")
        #~ self.quality_fixes_scrub_series_original_series_label.setMaximumWidth(450)
        self.quality_fixes_scrub_series_original_series_label.setToolTip(t)
        self.layout_quality_fixes_original_series.addWidget(self.quality_fixes_scrub_series_original_series_label)

        self.quality_fixes_scrub_series_original_series_lineedit = QLineEdit(self)
        #~ self.quality_fixes_scrub_series_original_series_lineedit.setMaximumWidth(200)
        self.quality_fixes_scrub_series_original_series_lineedit.setToolTip(t)
        self.quality_fixes_scrub_series_original_series_lineedit.setText(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_SERIES_ORIGINAL_SERIES_CUSTOM_COLUMN'])
        self.layout_quality_fixes_original_series.addWidget(self.quality_fixes_scrub_series_original_series_lineedit)
        #~ ----------------------------
        self.layout_quality_fixes_title_regexes_ignore_book = QHBoxLayout()
        self.layout_quality_fixes_title_regexes_ignore_book.setAlignment(Qt.AlignLeft)
        self.layout_quality_fixes_groupbox.addLayout(self.layout_quality_fixes_title_regexes_ignore_book)

        t = "<p style='white-space:wrap'>This is the Regular Expression that will be used to determine if an entire book should be ignored for Title <b>and</b> Author Scrubbing.  Examples: Magazines, Periodicals, Newspapers, Journals.<br><br>This is <b>never</b> 'reset to defaults' or changed in future versions of this Tool."

        self.quality_fixes_scrub_titles_regex_ignore_book_label = QLabel("Ignore/Skip Entire Book with Title:")
        self.quality_fixes_scrub_titles_regex_ignore_book_label.setMinimumWidth(200)
        self.quality_fixes_scrub_titles_regex_ignore_book_label.setToolTip(t)
        self.layout_quality_fixes_title_regexes_ignore_book.addWidget(self.quality_fixes_scrub_titles_regex_ignore_book_label)

        self.quality_fixes_scrub_titles_regex_ignore_book_lineedit = QLineEdit(self)
        self.quality_fixes_scrub_titles_regex_ignore_book_lineedit.setToolTip(t)
        self.quality_fixes_scrub_titles_regex_ignore_book_lineedit.setText(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_IGNORE_BOOK'])
        self.quality_fixes_scrub_titles_regex_ignore_book_lineedit.setCursorPosition(0)
        self.layout_quality_fixes_title_regexes_ignore_book.addWidget(self.quality_fixes_scrub_titles_regex_ignore_book_lineedit)

        #~ ----------------------------
        self.layout_quality_fixes_title_regexes_delete = QHBoxLayout()
        self.layout_quality_fixes_title_regexes_delete.setAlignment(Qt.AlignLeft)
        self.layout_quality_fixes_groupbox.addLayout(self.layout_quality_fixes_title_regexes_delete)

        t = "<p style='white-space:wrap'>This is the Regular Expression that will be used at the beginning of 'scrubbing' to delete various undesirable words and characters from the Title.  This is the first step in 'scrubbing'."
        t = t + "<br><br>Version: " + prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE_VERSION']

        self.quality_fixes_scrub_titles_regex_delete_label = QLabel("Delete Words:")
        self.quality_fixes_scrub_titles_regex_delete_label.setMinimumWidth(200)
        self.quality_fixes_scrub_titles_regex_delete_label.setToolTip(t)
        self.layout_quality_fixes_title_regexes_delete.addWidget(self.quality_fixes_scrub_titles_regex_delete_label)

        self.quality_fixes_scrub_titles_regex_delete_lineedit = QLineEdit(self)
        self.quality_fixes_scrub_titles_regex_delete_lineedit.setMinimumWidth(200)
        self.quality_fixes_scrub_titles_regex_delete_lineedit.setToolTip(t)
        self.quality_fixes_scrub_titles_regex_delete_lineedit.setText(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE'])
        self.quality_fixes_scrub_titles_regex_delete_lineedit.setCursorPosition(0)
        self.layout_quality_fixes_title_regexes_delete.addWidget(self.quality_fixes_scrub_titles_regex_delete_lineedit)

        #~ ----------------------------
        self.layout_quality_fixes_title_series_related_regexes = QHBoxLayout()
        self.layout_quality_fixes_title_series_related_regexes.setAlignment(Qt.AlignLeft)
        self.layout_quality_fixes_groupbox.addLayout(self.layout_quality_fixes_title_series_related_regexes)

        t = "<p style='white-space:wrap'>This is the Regular Expression that will be used to capture any Series (and Series Index if it exists) from the Title, and then to relocate those values from the Title to the Series (and possibly Series Index) column.  This is the second step in 'scrubbing'. "
        t = t + "<br><br>Version: " +prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE_VERSION']

        self.quality_fixes_scrub_titles_series_related_regex_relocate_label = QLabel("Relocate Series & Index:")
        self.quality_fixes_scrub_titles_series_related_regex_relocate_label.setMinimumWidth(200)
        self.quality_fixes_scrub_titles_series_related_regex_relocate_label.setToolTip(t)
        self.layout_quality_fixes_title_series_related_regexes.addWidget(self.quality_fixes_scrub_titles_series_related_regex_relocate_label)

        self.quality_fixes_scrub_titles_series_related_regex_relocate_lineedit = QLineEdit(self)
        self.quality_fixes_scrub_titles_series_related_regex_relocate_lineedit.setToolTip(t)
        self.quality_fixes_scrub_titles_series_related_regex_relocate_lineedit.setText(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE'])
        #~ self.quality_fixes_scrub_titles_series_related_regex_relocate_lineedit.setMaximumWidth(300)
        self.quality_fixes_scrub_titles_series_related_regex_relocate_lineedit.setCursorPosition(0)
        self.layout_quality_fixes_title_series_related_regexes.addWidget(self.quality_fixes_scrub_titles_series_related_regex_relocate_lineedit)

        #~ ----------------------------
        self.layout_quality_fixes_title_series_index_related_regexes = QHBoxLayout()
        self.layout_quality_fixes_title_series_index_related_regexes.setAlignment(Qt.AlignLeft)
        self.layout_quality_fixes_groupbox.addLayout(self.layout_quality_fixes_title_series_index_related_regexes)

        t = "<p style='white-space:wrap'>This is the Regular Expression that will be used to capture any Series Index from Titles that <b>do not also have a Series</b> in them.  The SI will then be relocated to the Series Index column if the book already has an existing Series with a default SI.  This is the third step in 'scrubbing'."
        t = t + "<br><br>Version: " +prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE_VERSION']

        self.quality_fixes_scrub_titles_series_index_related_regex_relocate_label = QLabel("Relocate Index Only:")
        self.quality_fixes_scrub_titles_series_index_related_regex_relocate_label.setMinimumWidth(200)
        self.quality_fixes_scrub_titles_series_index_related_regex_relocate_label.setToolTip(t)
        self.layout_quality_fixes_title_series_index_related_regexes.addWidget(self.quality_fixes_scrub_titles_series_index_related_regex_relocate_label)

        self.quality_fixes_scrub_titles_series_index_related_regex_relocate_lineedit = QLineEdit(self)
        self.quality_fixes_scrub_titles_series_index_related_regex_relocate_lineedit.setToolTip(t)
        self.quality_fixes_scrub_titles_series_index_related_regex_relocate_lineedit.setText(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE'])
        #~ self.quality_fixes_scrub_titles_series_index_related_regex_relocate_lineedit.setMaximumWidth(300)
        self.quality_fixes_scrub_titles_series_index_related_regex_relocate_lineedit.setCursorPosition(0)
        self.layout_quality_fixes_title_series_index_related_regexes.addWidget(self.quality_fixes_scrub_titles_series_index_related_regex_relocate_lineedit)

        #~ ----------------------------
        self.layout_quality_fixes_title_series_residual_artifacts_regexes = QHBoxLayout()
        self.layout_quality_fixes_title_series_residual_artifacts_regexes.setAlignment(Qt.AlignLeft)
        self.layout_quality_fixes_groupbox.addLayout(self.layout_quality_fixes_title_series_residual_artifacts_regexes)

        t = "<p style='white-space:wrap'>This Regular Expression is used to delete 'leftover' characters after the Series and/or Series Index have been relocated. This is the fourth and final step in 'scrubbing'."
        t = t + "<br><br>Version: " +prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE_VERSION']

        self.quality_fixes_scrub_titles_series_residual_artifacts_regex_relocate_label = QLabel("Delete Residual Artifacts:")
        self.quality_fixes_scrub_titles_series_residual_artifacts_regex_relocate_label.setMinimumWidth(200)
        self.quality_fixes_scrub_titles_series_residual_artifacts_regex_relocate_label.setToolTip(t)
        self.layout_quality_fixes_title_series_residual_artifacts_regexes.addWidget(self.quality_fixes_scrub_titles_series_residual_artifacts_regex_relocate_label)

        self.quality_fixes_scrub_titles_series_residual_artifacts_regex_relocate_lineedit = QLineEdit(self)
        self.quality_fixes_scrub_titles_series_residual_artifacts_regex_relocate_lineedit.setToolTip(t)
        self.quality_fixes_scrub_titles_series_residual_artifacts_regex_relocate_lineedit.setText(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE'])
        #~ self.quality_fixes_scrub_titles_series_residual_artifacts_regex_relocate_lineedit.setMaximumWidth(300)
        self.quality_fixes_scrub_titles_series_residual_artifacts_regex_relocate_lineedit.setCursorPosition(0)
        self.layout_quality_fixes_title_series_residual_artifacts_regexes.addWidget(self.quality_fixes_scrub_titles_series_residual_artifacts_regex_relocate_lineedit)

        #~ ----------------------------
        self.layout_quality_fixes_regexes_reset = QHBoxLayout()
        self.layout_quality_fixes_regexes_reset.setAlignment(Qt.AlignCenter)
        self.layout_quality_fixes_groupbox.addLayout(self.layout_quality_fixes_regexes_reset)

        self.quality_fixes_scrub_titles_reset_regexes_pushbutton = QPushButton("Reset Regular Expressions to Default Values")
        self.quality_fixes_scrub_titles_reset_regexes_pushbutton.clicked.connect(self.reset_quality_fixes_regexes_to_default)
        self.quality_fixes_scrub_titles_reset_regexes_pushbutton.setDefault(False)
        self.quality_fixes_scrub_titles_reset_regexes_pushbutton.setFont(font)
        self.quality_fixes_scrub_titles_reset_regexes_pushbutton.setToolTip("<p style='white-space:wrap'>Reset the above Regular Expressions to their Default Values, which were thoroughly tested using a testing library of over 1,000 books having mostly very undesirable titles.<br><br>Important: The 'ignore/skip entire title' Regular Expression is <b>never</> 'reset to defaults' or changed in future versions of this Tool.")
        self.layout_quality_fixes_regexes_reset.addWidget(self.quality_fixes_scrub_titles_reset_regexes_pushbutton)

        #~ ----------------------------
        self.layout_quality_fixes_titles = QHBoxLayout()
        self.layout_quality_fixes_titles.setAlignment(Qt.AlignCenter)
        self.layout_quality_fixes_groupbox.addLayout(self.layout_quality_fixes_titles)

        t = "<p style='white-space:wrap'>Do you wish to automatically 'Title-Case' the Titles for newly auto-added books?  The default is to use standard simple title-casing."

        self.quality_fixes_titlecase_titles_checkbox = QCheckBox("Title-Case Titles?")
        self.quality_fixes_titlecase_titles_checkbox.setToolTip(t)
        self.quality_fixes_titlecase_titles_checkbox.setMinimumWidth(150)
        self.layout_quality_fixes_titles.addWidget(self.quality_fixes_titlecase_titles_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_TITLECASE_TITLES'] == unicode_type("True"):
            self.quality_fixes_titlecase_titles_checkbox.setChecked(True)
        else:
            self.quality_fixes_titlecase_titles_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>Use only English-grammar based title-casing rules?<br><br>This is not advisable for non-English language ebooks."

        self.quality_fixes_titlecase_titles_advanced_checkbox = QCheckBox("English Title-casing Rules?")
        self.quality_fixes_titlecase_titles_advanced_checkbox.setToolTip(t)
        self.quality_fixes_titlecase_titles_advanced_checkbox.setMinimumWidth(150)
        self.layout_quality_fixes_titles.addWidget(self.quality_fixes_titlecase_titles_advanced_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_TITLECASE_TITLES_ADVANCED'] == unicode_type("True"):
            self.quality_fixes_titlecase_titles_advanced_checkbox.setChecked(True)
        else:
            self.quality_fixes_titlecase_titles_advanced_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>Do you wish to automatically 'Update Title Sorts' for newly auto-added books?  Note that if you also selected 'Title-Case Titles', then this option is required."

        self.quality_fixes_update_title_sorts_checkbox = QCheckBox("Update Title Sorts?")
        self.quality_fixes_update_title_sorts_checkbox.setToolTip(t)
        self.quality_fixes_update_title_sorts_checkbox.setMinimumWidth(150)
        self.layout_quality_fixes_titles.addWidget(self.quality_fixes_update_title_sorts_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_TITLE_SORTS'] == unicode_type("True"):
            self.quality_fixes_update_title_sorts_checkbox.setChecked(True)
        else:
            self.quality_fixes_update_title_sorts_checkbox.setChecked(False)

        if self.quality_fixes_titlecase_titles_checkbox.isChecked():
            self.quality_fixes_update_title_sorts_checkbox.setChecked(True)

        #~ ----------------------------
        self.layout_quality_fixes_scrub_authors = QHBoxLayout()
        self.layout_quality_fixes_scrub_authors.setAlignment(Qt.AlignCenter)
        self.layout_quality_fixes_groupbox.addLayout(self.layout_quality_fixes_scrub_authors)

        t = "<p style='white-space:wrap'>Do you wish to automatically 'scrub' the Authors for newly auto-added books?"

        self.quality_fixes_scrub_authors_checkbox = QCheckBox("Scrub Authors (Delete Title, Series, Etc.)?")
        self.quality_fixes_scrub_authors_checkbox.setToolTip(t)
        self.layout_quality_fixes_titles.addWidget(self.quality_fixes_scrub_authors_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS'] == unicode_type("True"):
            self.quality_fixes_scrub_authors_checkbox.setChecked(True)
        else:
            self.quality_fixes_scrub_authors_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>Since this GUI Tool is intended to be used in a 'WorkBench' type of Library, it is appropriate to allow the Original Authors, prior to any changes by JS, to be captured for later comparison to the 'scrubbed' Authors.  Specify that Custom Column #name here.\
                                                               <br><br>This Custom Column <b>must</b> be a 'Comments - Short Text Like a Title - Plain Text (Not HTML)' type of Custom Column.  Simply use the Preferences > Add your own columns > Add a user-defined column > 'Quick Create' link for 'Short Text'."

        self.quality_fixes_scrub_authors_original_authors_label = QLabel("Custom Column to update with the Original Authors prior to scrubbing:")
        #~ self.quality_fixes_scrub_authors_original_authors_label.setMaximumWidth(450)
        self.quality_fixes_scrub_authors_original_authors_label.setToolTip(t)
        self.layout_quality_fixes_scrub_authors.addWidget(self.quality_fixes_scrub_authors_original_authors_label)

        self.quality_fixes_scrub_authors_original_authors_lineedit = QLineEdit(self)
        #~ self.quality_fixes_scrub_authors_original_authors_lineedit.setMaximumWidth(200)
        self.quality_fixes_scrub_authors_original_authors_lineedit.setToolTip(t)
        self.quality_fixes_scrub_authors_original_authors_lineedit.setText(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_ORIGINAL_AUTHORS_CUSTOM_COLUMN'])
        self.layout_quality_fixes_scrub_authors.addWidget(self.quality_fixes_scrub_authors_original_authors_lineedit)

        #~ ----------------------------
        self.layout_quality_fixes_authors_residual_artifacts_residual_artifacts_regexes = QHBoxLayout()
        self.layout_quality_fixes_authors_residual_artifacts_residual_artifacts_regexes.setAlignment(Qt.AlignLeft)
        self.layout_quality_fixes_groupbox.addLayout(self.layout_quality_fixes_authors_residual_artifacts_residual_artifacts_regexes)

        t = "<p style='white-space:wrap'>This Regular Expression is used to delete 'leftover' characters after the Authors have been scrubbed.<br><br>This is <b>never</b> 'reset to defaults' or changed in future versions of this Tool."

        self.quality_fixes_scrub_authors_residual_artifacts_regex_delete_label = QLabel("Delete Residual Artifacts from Authors:")
        self.quality_fixes_scrub_authors_residual_artifacts_regex_delete_label.setToolTip(t)
        self.layout_quality_fixes_authors_residual_artifacts_residual_artifacts_regexes.addWidget(self.quality_fixes_scrub_authors_residual_artifacts_regex_delete_label)

        self.quality_fixes_scrub_authors_residual_artifacts_regex_delete_lineedit = QLineEdit(self)
        self.quality_fixes_scrub_authors_residual_artifacts_regex_delete_lineedit.setToolTip(t)
        self.quality_fixes_scrub_authors_residual_artifacts_regex_delete_lineedit.setText(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_RESIDUAL_ARTIFACTS_REGEX_DELETE'])
        self.quality_fixes_scrub_authors_residual_artifacts_regex_delete_lineedit.setCursorPosition(0)
        self.layout_quality_fixes_authors_residual_artifacts_residual_artifacts_regexes.addWidget(self.quality_fixes_scrub_authors_residual_artifacts_regex_delete_lineedit)

        #~ ----------------------------
        self.layout_quality_fixes_authors = QHBoxLayout()
        self.layout_quality_fixes_authors.setAlignment(Qt.AlignCenter)
        self.layout_quality_fixes_groupbox.addLayout(self.layout_quality_fixes_authors)

        t = "<p style='white-space:wrap'>Do you wish to standardize Author Names as FN LN?  If you choose this option, the related LN, FN option cannot be used simultaneously"

        self.quality_fixes_change_authors_fnln_checkbox = QCheckBox("Change Authors to FN LN?")
        self.quality_fixes_change_authors_fnln_checkbox.setToolTip(t)
        self.quality_fixes_change_authors_fnln_checkbox.setMinimumWidth(150)
        self.layout_quality_fixes_authors.addWidget(self.quality_fixes_change_authors_fnln_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_CHANGE_AUTHORS_FNLN'] == unicode_type("True"):
            self.quality_fixes_change_authors_fnln_checkbox.setChecked(True)
        else:
            self.quality_fixes_change_authors_fnln_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>Do you wish to standardize Author Names as LN, FN?  If you choose this option, the related FN LN option cannot be used simultaneously."

        self.quality_fixes_change_authors_lnfn_checkbox = QCheckBox("Change Authors to LN, FN?")
        self.quality_fixes_change_authors_lnfn_checkbox.setToolTip(t)
        self.quality_fixes_change_authors_lnfn_checkbox.setMinimumWidth(150)
        self.layout_quality_fixes_authors.addWidget(self.quality_fixes_change_authors_lnfn_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_CHANGE_AUTHORS_LNFN'] == unicode_type("True"):
            if prefs['GUI_TOOLS_QUALITY_FIXES_CHANGE_AUTHORS_FNLN'] == unicode_type("False"):
                self.quality_fixes_change_authors_lnfn_checkbox.setChecked(True)
        else:
            self.quality_fixes_change_authors_lnfn_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>Do you wish to automatically standardize Author Initials for newly auto-added books"

        self.quality_fixes_update_author_initials_checkbox = QCheckBox("Update Author Initials?")
        self.quality_fixes_update_author_initials_checkbox.setToolTip(t)
        self.quality_fixes_update_author_initials_checkbox.setMinimumWidth(150)
        self.layout_quality_fixes_authors.addWidget(self.quality_fixes_update_author_initials_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_INITIALS'] == unicode_type("True"):
            self.quality_fixes_update_author_initials_checkbox.setChecked(True)
        else:
            self.quality_fixes_update_author_initials_checkbox.setChecked(False)

        self.author_initials_combobox = QComboBox()
        self.author_initials_combobox.setEditable(False)
        self.author_initials_combobox.setFont(font)
        self.author_initials_combobox.setToolTip("<p style='white-space:wrap'>These are available formats to use to standardize Author Initials.")
        self.layout_quality_fixes_authors.addWidget(self.author_initials_combobox)
        author_initials_modes_list = ['A.B.', 'A. B.', 'A B', 'AB']
        for mode in author_initials_modes_list:
            self.author_initials_combobox.addItem(mode)
        #END FOR
        mode = prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_INITIALS_MODE']
        if mode in author_initials_modes_list:
            self.author_initials_combobox.setCurrentText(mode)

        t = "<p style='white-space:wrap'>Do you wish to automatically 'Update Author Sorts' for newly auto-added books?  Note that this option is required if any other option related to changing Author Names is selected."
        self.quality_fixes_update_author_sorts_checkbox = QCheckBox("Update Author Sorts?")
        self.quality_fixes_update_author_sorts_checkbox.setToolTip(t)
        self.layout_quality_fixes_authors.addWidget(self.quality_fixes_update_author_sorts_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_SORTS'] == unicode_type("True"):
            self.quality_fixes_update_author_sorts_checkbox.setChecked(True)
        else:
            self.quality_fixes_update_author_sorts_checkbox.setChecked(False)
        #~ ----------------------------
        self.layout_quality_fixes_jobs = QHBoxLayout()
        self.layout_quality_fixes_jobs.setAlignment(Qt.AlignCenter)
        self.layout_quality_fixes_groupbox.addLayout(self.layout_quality_fixes_jobs)

        t = "<p style='white-space:wrap'>Do you wish to automatically find the 'Real Author' for pseudonymous Authors for newly auto-added books?"
        self.quality_fixes_find_pseudonyms_checkbox = QCheckBox("Find Author Pseudonyms?")
        self.quality_fixes_find_pseudonyms_checkbox.setToolTip(t)
        self.layout_quality_fixes_jobs.addWidget(self.quality_fixes_find_pseudonyms_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_PSEUDONYMS'] == unicode_type("True"):
            self.quality_fixes_find_pseudonyms_checkbox.setChecked(True)
        else:
            self.quality_fixes_find_pseudonyms_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>Do you wish to automatically Scrub ISBNs, including their formatting and converting ISBN-10 to ISBN-13?  This is always done for <b>all</b> books in the current Library, not just for newly-added or selected books."
        self.quality_fixes_scrub_isbn_checkbox = QCheckBox("Scrub ISBNs?")
        self.quality_fixes_scrub_isbn_checkbox.setToolTip(t)
        self.layout_quality_fixes_jobs.addWidget(self.quality_fixes_scrub_isbn_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_ISBN'] == unicode_type("True"):
            self.quality_fixes_scrub_isbn_checkbox.setChecked(True)
        else:
            self.quality_fixes_scrub_isbn_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>Do you wish to automatically run the 'Extract ISBN' Plug-in Job for newly auto-added books?"
        self.quality_fixes_auto_run_extract_isbn_job_checkbox = QCheckBox("Run 'Extract ISBN'?")
        self.quality_fixes_auto_run_extract_isbn_job_checkbox.setToolTip(t)
        self.layout_quality_fixes_jobs.addWidget(self.quality_fixes_auto_run_extract_isbn_job_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_EXTRACT_ISBN_JOB'] == unicode_type("True"):
            self.quality_fixes_auto_run_extract_isbn_job_checkbox.setChecked(True)
        else:
            self.quality_fixes_auto_run_extract_isbn_job_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>Do you wish to automatically run the 'Polish Books' Job for newly auto-added books?"
        self.quality_fixes_auto_run_polish_books_job_checkbox = QCheckBox("Run 'Polish Books'?")
        self.quality_fixes_auto_run_polish_books_job_checkbox.setToolTip(t)
        self.layout_quality_fixes_jobs.addWidget(self.quality_fixes_auto_run_polish_books_job_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_POLISH_BOOKS_JOB'] == unicode_type("True"):
            self.quality_fixes_auto_run_polish_books_job_checkbox.setChecked(True)
        else:
            self.quality_fixes_auto_run_polish_books_job_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>Do you wish to automatically execute the 'Resize Cover' plug-in for newly auto-added books?"
        self.quality_fixes_auto_run_resize_cover_plugin_checkbox = QCheckBox("Run 'Resize Cover'?")
        self.quality_fixes_auto_run_resize_cover_plugin_checkbox.setToolTip(t)
        self.layout_quality_fixes_jobs.addWidget(self.quality_fixes_auto_run_resize_cover_plugin_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_RESIZE_COVER_PLUGIN'] == unicode_type("True"):
            self.quality_fixes_auto_run_resize_cover_plugin_checkbox.setChecked(True)
        else:
            self.quality_fixes_auto_run_resize_cover_plugin_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>Do you wish to automatically apply 'Default Values' for newly auto-added books?"
        self.quality_fixes_auto_run_apply_default_values_checkbox = QCheckBox("Apply 'Default Values'?")
        self.quality_fixes_auto_run_apply_default_values_checkbox.setToolTip(t)
        self.layout_quality_fixes_jobs.addWidget(self.quality_fixes_auto_run_apply_default_values_checkbox)

        if prefs['GUI_TOOLS_QUALITY_FIXES_APPLY_DEFAULT_VALUES'] == unicode_type("True"):
            self.quality_fixes_auto_run_apply_default_values_checkbox.setChecked(True)
        else:
            self.quality_fixes_auto_run_apply_default_values_checkbox.setChecked(False)
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_22_label = QLabel("")
        self.layout_top.addWidget(self.spacer_22_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.groupbox_apply_default_values = QGroupBox('Apply Default Values')
        self.groupbox_apply_default_values.setToolTip(t)
        self.layout_top.addWidget(self.groupbox_apply_default_values)

        self.layout_apply_default_values_groupbox = QVBoxLayout()
        self.groupbox_apply_default_values.setLayout(self.layout_apply_default_values_groupbox)
        #~ --------------------------
        self.layout_apply_default_values_1 = QHBoxLayout()
        self.layout_apply_default_values_1.setAlignment(Qt.AlignLeft)
        self.layout_apply_default_values_groupbox.addLayout(self.layout_apply_default_values_1)

        t = "<p style='white-space:wrap'>Do you wish to enable applying 'Default Values' as specified to the right?"

        self.apply_default_values_1_activate_checkbox = QCheckBox("[#1] Activate?")
        self.apply_default_values_1_activate_checkbox.setToolTip(t)
        self.apply_default_values_1_activate_checkbox.setMaximumWidth(150)
        self.layout_apply_default_values_1.addWidget(self.apply_default_values_1_activate_checkbox)

        if prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_1_ACTIVATE'] == unicode_type("True"):
            self.apply_default_values_1_activate_checkbox.setChecked(True)
        else:
            self.apply_default_values_1_activate_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>What is the #name for the Yes/No Custom Column to default?  Examples:  #have_read; #in_cloud; #needs_review"

        self.apply_default_values_1_custom_column_lineedit = QLineEdit(self)
        self.apply_default_values_1_custom_column_lineedit.setToolTip(t)
        self.apply_default_values_1_custom_column_lineedit.setText(prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_1_CUSTOM_COLUMN'])
        self.apply_default_values_1_custom_column_lineedit.setCursorPosition(0)
        self.apply_default_values_1_custom_column_lineedit.setMaximumWidth(150)
        self.layout_apply_default_values_1.addWidget(self.apply_default_values_1_custom_column_lineedit)

        t = "<p style='white-space:wrap'>What is the default Yes/No value for the #name?  Check the box for 'Yes', and clear the box for 'No'."

        self.apply_default_values_1_custom_column_default_value_checkbox = QCheckBox("Yes or No?")
        self.apply_default_values_1_custom_column_default_value_checkbox.setToolTip(t)
        #~ self.apply_default_values_1_custom_column_default_value_checkbox.setMaximumWidth(200)
        self.layout_apply_default_values_1.addWidget(self.apply_default_values_1_custom_column_default_value_checkbox)

        if prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_1_VALUE'] == unicode_type("True"):
            self.apply_default_values_1_custom_column_default_value_checkbox.setChecked(True)
        else:
            self.apply_default_values_1_custom_column_default_value_checkbox.setChecked(False)
        #~ --------------------------
        self.layout_apply_default_values_2 = QHBoxLayout()
        self.layout_apply_default_values_2.setAlignment(Qt.AlignLeft)
        self.layout_apply_default_values_groupbox.addLayout(self.layout_apply_default_values_2)

        t = "<p style='white-space:wrap'>Do you wish to enable applying 'Default Values' as specified to the right?"

        self.apply_default_values_2_activate_checkbox = QCheckBox("[#2] Activate?")
        self.apply_default_values_2_activate_checkbox.setToolTip(t)
        self.apply_default_values_2_activate_checkbox.setMaximumWidth(150)
        self.layout_apply_default_values_2.addWidget(self.apply_default_values_2_activate_checkbox)

        if prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_2_ACTIVATE'] == unicode_type("True"):
            self.apply_default_values_2_activate_checkbox.setChecked(True)
        else:
            self.apply_default_values_2_activate_checkbox.setChecked(False)


        t = "<p style='white-space:wrap'>What is the #name for the Yes/No Custom Column to default?  Examples:  #have_read; #in_cloud; #needs_review"

        self.apply_default_values_2_custom_column_lineedit = QLineEdit(self)
        self.apply_default_values_2_custom_column_lineedit.setToolTip(t)
        self.apply_default_values_2_custom_column_lineedit.setText(prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_2_CUSTOM_COLUMN'])
        self.apply_default_values_2_custom_column_lineedit.setCursorPosition(0)
        self.apply_default_values_2_custom_column_lineedit.setMaximumWidth(150)
        self.layout_apply_default_values_2.addWidget(self.apply_default_values_2_custom_column_lineedit)

        t = "<p style='white-space:wrap'>What is the default Yes/No value for the #name?  Check the box for 'Yes', and clear the box for 'No'."

        self.apply_default_values_2_custom_column_default_value_checkbox = QCheckBox("Yes or No?")
        self.apply_default_values_2_custom_column_default_value_checkbox.setToolTip(t)
        #~ self.apply_default_values_2_custom_column_default_value_checkbox.setMaximumWidth(200)
        self.layout_apply_default_values_2.addWidget(self.apply_default_values_2_custom_column_default_value_checkbox)

        if prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_2_VALUE'] == unicode_type("True"):
            self.apply_default_values_2_custom_column_default_value_checkbox.setChecked(True)
        else:
            self.apply_default_values_2_custom_column_default_value_checkbox.setChecked(False)
        #~ --------------------------
        self.layout_apply_default_values_3 = QHBoxLayout()
        self.layout_apply_default_values_3.setAlignment(Qt.AlignLeft)
        self.layout_apply_default_values_groupbox.addLayout(self.layout_apply_default_values_3)

        t = "<p style='white-space:wrap'>Do you wish to enable applying 'Default Values' as specified to the right?"

        self.apply_default_values_3_activate_checkbox = QCheckBox("[#3] Activate?")
        self.apply_default_values_3_activate_checkbox.setToolTip(t)
        self.apply_default_values_3_activate_checkbox.setMaximumWidth(150)
        self.layout_apply_default_values_3.addWidget(self.apply_default_values_3_activate_checkbox)

        if prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_3_ACTIVATE'] == unicode_type("True"):
            self.apply_default_values_3_activate_checkbox.setChecked(True)
        else:
            self.apply_default_values_3_activate_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>What is the #name for the Yes/No Custom Column to default?  Examples:  #have_read; #in_cloud; #needs_review"

        self.apply_default_values_3_custom_column_lineedit = QLineEdit(self)
        self.apply_default_values_3_custom_column_lineedit.setToolTip(t)
        self.apply_default_values_3_custom_column_lineedit.setText(prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_3_CUSTOM_COLUMN'])
        self.apply_default_values_3_custom_column_lineedit.setCursorPosition(0)
        self.apply_default_values_3_custom_column_lineedit.setMaximumWidth(150)
        self.layout_apply_default_values_3.addWidget(self.apply_default_values_3_custom_column_lineedit)

        t = "<p style='white-space:wrap'>What is the default Yes/No value for the #name?  Check the box for 'Yes', and clear the box for 'No'."

        self.apply_default_values_3_custom_column_default_value_checkbox = QCheckBox("Yes or No?")
        self.apply_default_values_3_custom_column_default_value_checkbox.setToolTip(t)
        #~ self.apply_default_values_3_custom_column_default_value_checkbox.setMaximumWidth(200)
        self.layout_apply_default_values_3.addWidget(self.apply_default_values_3_custom_column_default_value_checkbox)

        if prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_3_VALUE'] == unicode_type("True"):
            self.apply_default_values_3_custom_column_default_value_checkbox.setChecked(True)
        else:
            self.apply_default_values_3_custom_column_default_value_checkbox.setChecked(False)
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_18_label = QLabel("")
        self.layout_top.addWidget(self.spacer_18_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_copy_to_library_shortcut_default_directory = QHBoxLayout()
        self.layout_copy_to_library_shortcut_default_directory.setAlignment(Qt.AlignCenter)
        self.layout_top.addLayout(self.layout_copy_to_library_shortcut_default_directory)

        t = "<p style='white-space:wrap'>To use the Job Spy enhanced 'Copy-to-Library' Shortcut, you must specify the top-level directory where you keep most or all of your Calibre Libraries."

        self.copy_to_library_shortcut_default_directory_label = QLabel("Copy-to-Library Shortcut Default Top Directory of Your Calibre Libraries:")
        self.copy_to_library_shortcut_default_directory_label.setToolTip(t)
        self.layout_copy_to_library_shortcut_default_directory.addWidget(self.copy_to_library_shortcut_default_directory_label)

        self.copy_to_library_shortcut_default_directory_lineedit = QLineEdit(self)
        self.copy_to_library_shortcut_default_directory_lineedit.setToolTip(t)
        self.copy_to_library_shortcut_default_directory_lineedit.setText(prefs['GUI_TOOLS_COPY_TO_LIBRARY_SHORTCUT_DEFAULT_DIRECTORY'])
        self.copy_to_library_shortcut_default_directory_lineedit.setCursorPosition(0)
        self.layout_copy_to_library_shortcut_default_directory.addWidget(self.copy_to_library_shortcut_default_directory_lineedit)
        #--------------------------------------------------
        #--------------------------------------------------
        #~ spacer 19 is far above...as is spacer 22...
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_20_label = QLabel("")
        self.layout_top.addWidget(self.spacer_20_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.frame_20 = QFrame()
        self.frame_20.setFrameShape(QFrame.HLine);
        self.frame_20.setFrameShadow(QFrame.Sunken);
        self.layout_top.addWidget(self.frame_20);
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_20a_label = QLabel("")
        self.layout_top.addWidget(self.spacer_20a_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_author_pseudonyms = QHBoxLayout()
        self.layout_author_pseudonyms.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_author_pseudonyms)

        t = "<p style='white-space:wrap'>Specify the 'Text,Tag-Like, Ampersand-Separated People' Custom Column to be used to update the 'Real Author' for any pseudonym used as an 'Author' for a book."

        self.author_pseudonyms_label = QLabel("'Real Author' Custom Column for Pseudonymous Authors:")
        self.author_pseudonyms_label.setToolTip(t)
        #~ self.author_pseudonyms_label.setMaximumWidth(375)
        self.layout_author_pseudonyms.addWidget(self.author_pseudonyms_label)

        self.author_pseudonyms_lineedit = QLineEdit(self)
        self.author_pseudonyms_lineedit.setToolTip(t)
        self.author_pseudonyms_lineedit.setText(prefs['GUI_TOOLS_AUTHOR_PSEUDONYMS_CUSTOM_COLUMN'])
        #~ self.author_pseudonyms_lineedit.setMaximumWidth(125)
        self.author_pseudonyms_lineedit.setCursorPosition(0)
        self.layout_author_pseudonyms.addWidget(self.author_pseudonyms_lineedit)
        #--------------------------------------------------
        #--------------------------------------------------
        #~ spacer 22 is far above...as is spacer 19...
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_23_label = QLabel("")
        self.layout_top.addWidget(self.spacer_23_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.frame_23 = QFrame()
        self.frame_23.setFrameShape(QFrame.HLine);
        self.frame_23.setFrameShadow(QFrame.Sunken);
        self.layout_top.addWidget(self.frame_23);
        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_23a_label = QLabel("")
        self.layout_top.addWidget(self.spacer_23a_label)
        #--------------------------------------------------
        #--------------------------------------------------

        t = "<p style='white-space:wrap'>Update a Last-Viewed Custom Column Automatically upon 'Viewing' in Calibre"

        self.groupbox_update_last_viewed_custom_column_automatically = QGroupBox('Update Last-Viewed Custom Column Automatically')
        self.groupbox_update_last_viewed_custom_column_automatically.setToolTip(t)
        self.layout_top.addWidget(self.groupbox_update_last_viewed_custom_column_automatically)

        self.layout_update_last_viewed_custom_column_automatically_groupbox = QVBoxLayout()
        self.groupbox_update_last_viewed_custom_column_automatically.setLayout(self.layout_update_last_viewed_custom_column_automatically_groupbox)
        #~ --------------------------
        self.layout_update_last_viewed_custom_column_automatically = QHBoxLayout()
        self.layout_update_last_viewed_custom_column_automatically.setAlignment(Qt.AlignLeft)
        self.layout_update_last_viewed_custom_column_automatically_groupbox.addLayout(self.layout_update_last_viewed_custom_column_automatically)

        t = "<p style='white-space:wrap'>Do you wish to Activate this Tool so that a datetime Custom Column can be updated automatically when you 'View' a book?<br><br>Restart required if changed."

        self.update_last_viewed_custom_column_automatically_activate_checkbox = QCheckBox("Activate?")
        self.update_last_viewed_custom_column_automatically_activate_checkbox.setToolTip(t)
        self.update_last_viewed_custom_column_automatically_activate_checkbox.setMaximumWidth(125)
        self.layout_update_last_viewed_custom_column_automatically.addWidget(self.update_last_viewed_custom_column_automatically_activate_checkbox)

        if prefs['GUI_TOOLS_UPDATE_LAST_VIEWED_CUSTOM_COLUMN_AUTOMATICALLY_ACTIVATE'] == unicode_type("True"):
            self.update_last_viewed_custom_column_automatically_activate_checkbox.setChecked(True)
        else:
            self.update_last_viewed_custom_column_automatically_activate_checkbox.setChecked(False)

        t = "<p style='white-space:wrap'>Specify the 'Last-Viewed' #customcolumn to update automatically when a book is 'Viewed'.<br><br>This #customcolumn must have a datatype of 'datetime'.<br><br>Restart required if changed."

        self.update_last_viewed_custom_column_automatically_custom_column_lineedit = QLineEdit(self)
        self.update_last_viewed_custom_column_automatically_custom_column_lineedit.setToolTip(t)
        self.update_last_viewed_custom_column_automatically_custom_column_lineedit.setText(prefs['GUI_TOOLS_UPDATE_LAST_VIEWED_CUSTOM_COLUMN_AUTOMATICALLY_COLUMN_NAME'])
        self.update_last_viewed_custom_column_automatically_custom_column_lineedit.setCursorPosition(0)
        self.update_last_viewed_custom_column_automatically_custom_column_lineedit.setMaximumWidth(150)
        self.layout_update_last_viewed_custom_column_automatically.addWidget(self.update_last_viewed_custom_column_automatically_custom_column_lineedit)

        t = "<p style='white-space:wrap'>You must specify for which Calibre Libraries this tool will be activated.  Specify the wildcard '*' to activate it for all Libraries.  Otherwise, specify one or more Library Names  separated with a bar ('|').<br><br>Restart required if changed."

        self.update_last_viewed_custom_column_automatically_libraries_lineedit = QLineEdit(self)
        self.update_last_viewed_custom_column_automatically_libraries_lineedit.setToolTip(t)
        self.update_last_viewed_custom_column_automatically_libraries_lineedit.setText(prefs['GUI_TOOLS_UPDATE_LAST_VIEWED_CUSTOM_COLUMN_AUTOMATICALLY_LIBRARIES'])
        self.update_last_viewed_custom_column_automatically_libraries_lineedit.setCursorPosition(0)
        self.update_last_viewed_custom_column_automatically_libraries_lineedit.setMinimumWidth(400)
        self.layout_update_last_viewed_custom_column_automatically.addWidget(self.update_last_viewed_custom_column_automatically_libraries_lineedit)

        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_24_label = QLabel("")
        self.layout_top.addWidget(self.spacer_24_label)
        #--------------------------------------------------
        #--------------------------------------------------

        self.layout_create_bibliography_text = QHBoxLayout()
        self.layout_create_bibliography_text.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_create_bibliography_text)

        t = "<p style='white-space:wrap'>Specify the template to use for generating a book's bibliography text.<br><br>Punctuation and constant values you wish to add will be used as-is with no changes.  However, the keywords <b>must</b> be capitalized as shown.\
        <br><br>Example: 'AUTHOR (YYYY): TITLE' ---> 'John Smith (2020): Avoiding the Wuhan Virus'.  ['et al' never appears even if multiple Authors] \
        <br><br>Example: 'LN, 'TITLE', YYYY' ---> 'Smith, 'Avoiding the Wuhan Virus', 2020.\
        <br><br>Example: 'AUTHOR, YYYY' ---> 'John Smith 2020'.\
        <br><br>Example: 'TITLE. PUBLISHER, YYYY.' ---> 'Avoiding the Wuhan Virus. Science Publishing Group, 2020'.\
        <br><br>Example: 'AUTHOR_SORT, YYYY' ---> 'Smith, John 2020' OR 'John Smith 2020' depending on your personal Preferences > Tweaks for 'author_sort_copy_method'\
        <br><br>Example: 'AUTHOR ET AL (YYYY): TITLE' ---> 'John Smith et al (2020): Avoiding the Wuhan Virus'.  ['et al' appears only if there exist multiple Authors]\
        <br><br>Example: 'AUTHOR_SORT. TITLE. PUBLISHER, YYYY' ---> 'Smith, John. Avoiding the Wuhan Virus. Science Publishing Group, 2020.\
        <br><br>Example: 'AUTHOR_SORT. 'TITLE'. SERIES, no. SERIES_INDEX (MONTH YYYY)' ---> 'Smith, John. 'Avoiding the Wuhan Virus'. The Journal of Science, no. 18 (April 2020).\
        <br><br>Additional Keywords:<br>'MM' is the 2-digit Month (01-12).  'MONTH' is always the English name of 'MM'.\
        <br>'FN' is First Name, just as 'LN' is Last Name.\
        <br><br>Custom Column #names may be used as Keywords.  The #names must be all lower-case.  Values for non-textual #names (e.g. integer) will be converted to text.  \
        Custom Column Tag-Like values will be concatenated with a comma ',' before being used in the bibliography text.<br> "

        self.create_bibliography_text_template_label = QLabel("'Bibliography Text' Template:")
        self.create_bibliography_text_template_label.setToolTip(t)
        self.create_bibliography_text_template_label.setMinimumWidth(200)
        #~ self.create_bibliography_text_template_label.setMaximumWidth(200)
        self.layout_create_bibliography_text.addWidget(self.create_bibliography_text_template_label)

        self.create_bibliography_text_template_lineedit = QLineEdit(self)
        self.create_bibliography_text_template_lineedit.setToolTip(t)
        self.create_bibliography_text_template_lineedit.setText(prefs['GUI_TOOLS_BIBLIOGRAPHY_TEXT_TEMPLATE'])
        self.create_bibliography_text_template_lineedit.setCursorPosition(0)
        self.create_bibliography_text_template_lineedit.setMinimumWidth(600)
        #~ self.create_bibliography_text_template_lineedit.setMaximumWidth(600)
        self.layout_create_bibliography_text.addWidget(self.create_bibliography_text_template_lineedit)


        #--------------------------------------------------
        #--------------------------------------------------
        self.spacer_25_label = QLabel("")
        self.layout_top.addWidget(self.spacer_25_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.frame_25 = QFrame()
        self.frame_25.setFrameShape(QFrame.HLine);
        self.frame_25.setFrameShadow(QFrame.Sunken);
        self.layout_top.addWidget(self.frame_25);
        #--------------------------------------------------
        #--------------------------------------------------

        self.layout_save_settings = QHBoxLayout()
        self.layout_save_settings.setAlignment(Qt.AlignCenter)
        self.layout_top.addLayout(self.layout_save_settings)

        font.setPointSize(12)

        self.save_js_settings_pushbutton = QPushButton("Save All Settings")
        self.save_js_settings_pushbutton.setMinimumWidth(300)
        #~ self.save_js_settings_pushbutton.setMaximumWidth(300)
        self.save_js_settings_pushbutton.clicked.connect(self.save_settings)
        self.save_js_settings_pushbutton.setDefault(True)
        self.save_js_settings_pushbutton.setFont(font)
        self.save_js_settings_pushbutton.setToolTip("<p style='white-space:wrap'>Validate and Save Settings")
        self.layout_save_settings.addWidget(self.save_js_settings_pushbutton)

        font.setPointSize(10)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_widget.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.setWidget(self.scroll_widget)    # now that all widgets have been created and assigned to a layout...
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------

        self.resize(self.sizeHint())

        self.settings_may_be_saved = True
        #-----------------------------------------------------
        #-----------------------------------------------------
    def event_combo_box_colors_changed(self):

        prefs['GUI_TOOLS_LIBRARY_VIEW_TEXT_COLOR'] = self.text_color_combobox.currentText()
        prefs['GUI_TOOLS_LIBRARY_VIEW_BACKGROUND_COLOR'] = self.background_color_combobox.currentText()
        prefs['GUI_TOOLS_LIBRARY_VIEW_ALTERNATING_COLOR'] =  self.alternating_color_combobox.currentText()

        prefs

        tc = prefs['GUI_TOOLS_LIBRARY_VIEW_TEXT_COLOR']
        bc = prefs['GUI_TOOLS_LIBRARY_VIEW_BACKGROUND_COLOR']
        ac = prefs['GUI_TOOLS_LIBRARY_VIEW_ALTERNATING_COLOR']

        style_text = "background-color: [BC]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[BC]",bc)
        self.text_color_combobox.setStyleSheet(style_text)

        style_text = "background-color: [BC]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[BC]",bc)
        self.background_color_combobox.setStyleSheet(style_text)

        style_text = "background-color: [BC]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[BC]",ac)
        self.alternating_color_combobox.setStyleSheet(style_text)
        #-----------------------------------------------------
        #-----------------------------------------------------
    def event_maingui_combo_box_colors_changed(self):

        prefs['GUI_TOOLS_MAIN_GUI_TEXT_COLOR'] = self.maingui_text_color_combobox.currentText()
        prefs['GUI_TOOLS_MAIN_GUI_VIRTUAL_LIBRARY_COLOR'] = self.maingui_vl_color_combobox.currentText()
        #~ prefs['GUI_TOOLS_MAIN_GUI_SEARCHBAR_COLOR'] =  self.maingui_searchbar_color_combobox.currentText()           #removed @ Calibre 6.8

        prefs

        tc = prefs['GUI_TOOLS_MAIN_GUI_TEXT_COLOR']
        vl = prefs['GUI_TOOLS_MAIN_GUI_VIRTUAL_LIBRARY_COLOR']
        srch = prefs['GUI_TOOLS_MAIN_GUI_SEARCHBAR_COLOR']

        style_text = "background-color: [VL]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[VL]",vl)
        self.maingui_text_color_combobox.setStyleSheet(style_text)

        style_text = "background-color: [VL]; color : [TC]"
        style_text = style_text.replace("[TC]",tc)
        style_text = style_text.replace("[VL]",vl)
        self.maingui_vl_color_combobox.setStyleSheet(style_text)

        #~ style_text = "background-color: [SRCH]; color : [TC]"                #removed @ Calibre 6.8
        #~ style_text = style_text.replace("[TC]",tc)
        #~ style_text = style_text.replace("[SRCH]",srch)
        #~ self.maingui_searchbar_color_combobox.setStyleSheet(style_text)           #removed @ Calibre 6.8
        #-----------------------------------------------------
        #-----------------------------------------------------
    def save_settings(self):

        self.settings_may_be_saved = True

        prefs['JOBS_TO_SHOW_CONSECUTIVELY'] = int(unicode_type(self.max_jobs_spin.value()))

        if self.searchbar_autorun_checkbox.isChecked():
            prefs['GUI_TOOLS_VISIBLE_ITEMS_SEARCHBAR_AUTORUN'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_VISIBLE_ITEMS_SEARCHBAR_AUTORUN'] = unicode_type("False")

        if self.daemon_autorun_checkbox.isChecked():
            prefs['GUI_TOOLS_VISIBLE_ITEMS_EDIT_METADATA_AUTORUN'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_VISIBLE_ITEMS_EDIT_METADATA_AUTORUN'] = unicode_type("False")

        prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_INTERVAL'] = int(unicode_type(self.daemon_interval_spin.value()))

        if self.show_guitool_tooltips_checkbox.isChecked():
            prefs['GUI_TOOLS_SHOW_TOOLTIPS'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_SHOW_TOOLTIPS'] = unicode_type("False")

        prefs['GUI_TOOLS_EXTRACT_ORIGINAL_TITLE_KEYWORD'] = self.extract_original_title_keyword_qlineedit.text() + "| "   #for split()
        prefs['GUI_TOOLS_EXTRACT_ORIGINAL_TITLE_CUSTOM_COLUMN'] =  self.extract_original_title_custom_column_qlineedit.text()

        prefs['GUI_TOOLS_EXTRACT_TRANSLATOR_KEYWORD'] = self.extract_translator_keyword_qlineedit.text() + "| "   #for split()
        prefs['GUI_TOOLS_EXTRACT_TRANSLATOR_CUSTOM_COLUMN'] =  self.extract_translator_custom_column_qlineedit.text()

        if self.auto_delete_temp_reading_lists_checkbox.isChecked():
            prefs['GUI_TOOLS_AUTO_DELETE_TEMPORARY_READING_LISTS'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_AUTO_DELETE_TEMPORARY_READING_LISTS'] = unicode_type("False")


        if self.vl_views_active_checkbox.isChecked():
            prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_ACTIVE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_ACTIVE'] = unicode_type("False")

        prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_REGEX'] = self.vl_regex_qlineedit.text()


        if self.missing_cc_dialog_active_checkbox.isChecked():
            prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_ACTIVE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_ACTIVE'] = unicode_type("False")
        prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_SOURCES_1'] = self.from_library_name1_qlineedit.text()
        prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_TARGETS_1'] = self.to_library_name1_qlineedit.text()
        prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_SOURCES_2'] = self.from_library_name2_qlineedit.text()
        prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_TARGETS_2'] = self.to_library_name2_qlineedit.text()


        if self.autorun_color_selections_checkbox.isChecked():
            prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_AUTORUN'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_AUTORUN'] = unicode_type("False")
        if self.activate_color_selections_checkbox.isChecked():
            prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_ACTIVE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_ACTIVE'] = unicode_type("False")
        prefs['GUI_TOOLS_LIBRARY_VIEW_TEXT_COLOR'] = self.text_color_combobox.currentText()
        prefs['GUI_TOOLS_LIBRARY_VIEW_BACKGROUND_COLOR'] = self.background_color_combobox.currentText()
        prefs['GUI_TOOLS_LIBRARY_VIEW_ALTERNATING_COLOR'] =  self.alternating_color_combobox.currentText()
        prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_CONFIGURED'] = unicode_type("True")
        #~ if self.status_bar_color_checkbox.isChecked():
            #~ prefs['GUI_TOOLS_STATUS_BAR_COLOR_CHANGE'] = unicode_type("True")
        #~ else:
        prefs['GUI_TOOLS_STATUS_BAR_COLOR_CHANGE'] = unicode_type("False")  # Calibre 6.8
        if self.column_headings_color_checkbox.isChecked():
            prefs['GUI_TOOLS_LIBRARY_VIEW_COLUMN_HEADING_COLOR_CHANGE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_LIBRARY_VIEW_COLUMN_HEADING_COLOR_CHANGE'] = unicode_type("False")


        if self.autorun_maingui_color_selections_checkbox.isChecked():
            prefs['GUI_TOOLS_MAIN_GUI_COLOR_AUTORUN'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_MAIN_GUI_COLOR_AUTORUN'] = unicode_type("False")
        if self.activate_color_selections_checkbox.isChecked():
            prefs['GUI_TOOLS_MAIN_GUI_COLOR_ACTIVE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_MAIN_GUI_COLOR_ACTIVE'] = unicode_type("False")
        prefs['GUI_TOOLS_MAIN_GUI_TEXT_COLOR'] = self.maingui_text_color_combobox.currentText()
        prefs['GUI_TOOLS_MAIN_GUI_VIRTUAL_LIBRARY_COLOR'] = self.maingui_vl_color_combobox.currentText()
        #~ prefs['GUI_TOOLS_MAIN_GUI_SEARCHBAR_COLOR'] =  self.maingui_searchbar_color_combobox.currentText()           #removed @ Calibre 6.8
        prefs['GUI_TOOLS_MAIN_GUI_COLOR_CONFIGURED'] = unicode_type("True")


        if self.kb_shortcut_cc_autofill_active_checkbox.isChecked():
            prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_AUTOFILL_ACTIVE']  = unicode_type("True")
        else:
            prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_AUTOFILL_ACTIVE']  = unicode_type("False")

        cc_inactive_count = 0

        cc1 = self.shortcut_cc_rule1_lineedit.text()
        cc1 = cc1.strip()
        cc1 = as_unicode(cc1)
        if len(cc1) == 0:
            cc1 = as_unicode("#?")
        if not cc1.startswith("#"):
            cc1 = as_unicode("#?")
        prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE1_CUSTOM_COLUMN'] = cc1
        if cc1 == as_unicode("#?"):
            cc_inactive_count = cc_inactive_count + 1
            prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE1_VALUE'] = "?"
        else:
            prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE1_VALUE'] = self.shortcut_cc_value_rule1_lineedit.text()

        cc2 = self.shortcut_cc_rule2_lineedit.text()
        cc2 = cc2.strip()
        cc2 = as_unicode(cc2)
        if len(cc2) == 0:
            cc2 = as_unicode("#?")
        if not cc2.startswith("#"):
            cc2 = as_unicode("#?")
        prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE2_CUSTOM_COLUMN'] = cc2
        if cc2 == as_unicode("#?"):
            cc_inactive_count = cc_inactive_count + 1
            prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE2_VALUE'] = "?"
        else:
            prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE2_VALUE'] = self.shortcut_cc_value_rule2_lineedit.text()

        cc3 = self.shortcut_cc_rule3_lineedit.text()
        cc3 = cc3.strip()
        cc3 = as_unicode(cc3)
        if len(cc3) == 0:
            cc3 = as_unicode("#?")
        if not cc3.startswith("#"):
            cc3 = as_unicode("#?")
        prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE3_CUSTOM_COLUMN'] = cc3
        if cc3 == as_unicode("#?"):
            cc_inactive_count = cc_inactive_count + 1
            prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE3_VALUE'] = "?"
        else:
            prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE3_VALUE'] = self.shortcut_cc_value_rule3_lineedit.text()

        cc4 = self.shortcut_cc_rule4_lineedit.text()
        cc4 = cc4.strip()
        cc4 = as_unicode(cc4)
        if len(cc4) == 0:
            cc4 = as_unicode("#?")
        if not cc4.startswith("#"):
            cc4 = as_unicode("#?")
        prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE4_CUSTOM_COLUMN'] = cc4
        if cc4 == as_unicode("#?"):
            cc_inactive_count = cc_inactive_count + 1
            prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE4_VALUE'] = "?"
        else:
            prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE4_VALUE'] = self.shortcut_cc_value_rule4_lineedit.text()

        if cc_inactive_count == 4:
            prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_AUTOFILL_ACTIVE']  = unicode_type("False")

        #~ ------------------------
        if self.uccboacc_active_checkbox.isChecked():
            prefs['GUI_TOOLS_UCCBOACC_ACTIVE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_UCCBOACC_ACTIVE'] = unicode_type("False")
        #~ ----
        prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_1'] = self.uccboacc_source_1_lineedit.text()
        v = self.uccboacc_value_source_1_lineedit.text()
        v = v.replace("null","␀")
        v = v.replace("Null","␀")
        v = v.replace("NULL","␀")
        v = v.strip()
        self.uccboacc_value_source_1_lineedit.setText(v)
        prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_VALUE_1'] = v
        prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_1'] = self.uccboacc_target_1_lineedit.text()
        v = self.uccboacc_value_target_1_lineedit.text()
        v = v.replace("null","␀")
        v = v.replace("Null","␀")
        v = v.replace("NULL","␀")
        v = v.strip()
        if "|" in v:
            v = v + "|"
            s_split = v.split("|")
            for s in s_split:
                s = s.strip()
                if s > " ":
                    v = s.strip()
                    break
            #END FOR
            del s_split
        self.uccboacc_value_target_1_lineedit.setText(v)
        prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_VALUE_1'] = v

        if "?" in prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_1']:
            prefs['GUI_TOOLS_UCCBOACC_ACTIVE'] = unicode_type("False")
        elif "?" in prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_1']:
            prefs['GUI_TOOLS_UCCBOACC_ACTIVE'] = unicode_type("False")

        if prefs['GUI_TOOLS_UCCBOACC_ACTIVE'] == unicode_type("False"):
            self.uccboacc_active_checkbox.setChecked(False)
        #~ ----
        prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_2'] = self.uccboacc_source_2_lineedit.text()
        v = self.uccboacc_value_source_2_lineedit.text()
        v = v.replace("null","␀")
        v = v.replace("Null","␀")
        v = v.replace("NULL","␀")
        v = v.strip()
        self.uccboacc_value_source_2_lineedit.setText(v)
        prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_VALUE_2'] = v
        prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_2'] = self.uccboacc_target_2_lineedit.text()
        v = self.uccboacc_value_target_2_lineedit.text()
        v = v.replace("null","␀")
        v = v.replace("Null","␀")
        v = v.replace("NULL","␀")
        v = v.strip()
        if "|" in v:
            v = v + "|"
            s_split = v.split("|")
            for s in s_split:
                s = s.strip()
                if s > " ":
                    v = s.strip()
                    break
            #END FOR
            del s_split
        self.uccboacc_value_target_2_lineedit.setText(v)
        prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_VALUE_2'] = v

        #~ ------------------------
        self.custom_columns_metadata_dict = self.maingui.current_db.field_metadata.custom_field_metadata()

        choices_dict = {}
        choices_dict["tags"] = as_unicode(self.mega_metadata_helper_tags_checkbox.isChecked())
        choices_dict["cc"] = as_unicode(self.mega_metadata_helper_custom_columns_checkbox.isChecked())
        cc_str = as_unicode(self.mega_metadata_helper_lineedit.text())
        cc_str = cc_str.replace(";",",")
        cc_str = cc_str.replace("|",",")
        cc_str = cc_str.replace(" ",",")
        cc_str = cc_str.strip()
        cc_list = []
        if cc_str > "":
            if not "," in cc_str:
                cc_str = cc_str + ", "
            s_split = cc_str.split(",")
            if isinstance(s_split,list):
                for row in s_split:
                    row = row.strip().lower()
                    if row.startswith("#"):
                        #~ if DEBUG: print("cc is: ", as_unicode(row))
                        row = as_unicode(row)
                        try:
                            custcol = self.custom_columns_metadata_dict[row]   # should be a '#label'
                            #~ if DEBUG: print("custcol: >>>>", as_unicode(custcol))
                        except Exception as e:
                            #~ if DEBUG: print(row, "    ", as_unicode(e))
                            continue
                        cc_datatype = custcol['datatype']
                        if cc_datatype == "text":
                            is_multiple = custcol['is_multiple']
                            #~ if DEBUG: print(cc_datatype, "  ", as_unicode(is_multiple))
                            if as_unicode(is_multiple) != as_unicode("{}"):  #tag-like  'is_multiple': {u'ui_to_list': u',', u'cache_to_list': u'|', u'list_to_ui': u', '}
                                cc_list.append(row)
                #END FOR
        choices_dict["custom_columns"] = as_unicode(cc_list)
        prefs['GUI_TOOLS_MEGA_METADATA_BOOK_HELPER_CHOICES_DICT'] = unicode_type(choices_dict)
        cc_str = ",".join(cc_list)
        cc_str = cc_str.strip()
        if cc_str.startswith(","):
            cc_str = cc_str[1: ]
        cc_str = as_unicode(cc_str)
        self.mega_metadata_helper_lineedit.setText(cc_str)
        #~ ------------------------
        prefs['GUI_TOOLS_FTP_HOST'] = self.ftp_host_lineedit.text()
        prefs['GUI_TOOLS_FTP_HOST_PORT'] = self.ftp_port_lineedit.text()
        prefs['GUI_TOOLS_FTP_HOST_DIRECTORY'] = self.ftp_directory_lineedit.text()
        prefs['GUI_TOOLS_FTP_USERID'] = self.ftp_userid_lineedit.text()
        prefs['GUI_TOOLS_FTP_PASSWORD'] = self.ftp_password_lineedit.text()
        s = self.ftp_format_lineedit.text()
        s = s.strip()
        s = s.replace(";",",")
        s = s.replace(" ","")
        prefs['GUI_TOOLS_FTP_FORMAT'] = s
        self.ftp_format_lineedit.setText(s)
        #~ ------------------------
        if self.add_null_values_active_checkbox.isChecked():
            prefs['GUI_TOOLS_ADD_NULL_VALUES_ACTIVE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ADD_NULL_VALUES_ACTIVE'] = unicode_type("False")

        if self.add_null_values_autorun_checkbox.isChecked():
            prefs['GUI_TOOLS_ADD_NULL_VALUES_AUTORUN'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ADD_NULL_VALUES_AUTORUN'] = unicode_type("False")

        p = self.add_nulls_to_library_qlineedit.text()
        p = p.strip()
        prefs['GUI_TOOLS_ADD_NULL_VALUES_LIBRARIES'] = p

        if self.add_null_values_comments_checkbox.isChecked():
            prefs['GUI_TOOLS_ADD_NULL_VALUES_COMMENTS'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ADD_NULL_VALUES_COMMENTS'] = unicode_type("False")

        if self.add_null_values_text_checkbox.isChecked():
            prefs['GUI_TOOLS_ADD_NULL_VALUES_TEXT'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ADD_NULL_VALUES_TEXT'] = unicode_type("False")

        if self.add_null_values_taglike_checkbox.isChecked():
            prefs['GUI_TOOLS_ADD_NULL_VALUES_TAGLIKE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ADD_NULL_VALUES_TAGLIKE'] = unicode_type("False")

        if self.add_null_values_series_checkbox.isChecked():
            prefs['GUI_TOOLS_ADD_NULL_VALUES_SERIES'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ADD_NULL_VALUES_SERIES'] = unicode_type("False")

        if self.add_null_values_int_checkbox.isChecked():
            prefs['GUI_TOOLS_ADD_NULL_VALUES_INT'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ADD_NULL_VALUES_INT'] = unicode_type("False")

        if self.add_null_values_float_checkbox.isChecked():
            prefs['GUI_TOOLS_ADD_NULL_VALUES_FLOAT'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ADD_NULL_VALUES_FLOAT'] = unicode_type("False")

        if self.add_null_values_bool_checkbox.isChecked():
            prefs['GUI_TOOLS_ADD_NULL_VALUES_BOOL'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ADD_NULL_VALUES_BOOL'] = unicode_type("False")

        if self.add_null_values_datetime_checkbox.isChecked():
            prefs['GUI_TOOLS_ADD_NULL_VALUES_DATETIME'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ADD_NULL_VALUES_DATETIME'] = unicode_type("False")

        p = self.add_nulls_ignore_names_qlineedit.text()
        p = p.strip()
        p = p.replace(",","|")
        p = p.replace(";","|")
        p = p.lower()
        self.add_nulls_ignore_names_qlineedit.setText(p)
        self.add_nulls_ignore_names_qlineedit.update()
        prefs['GUI_TOOLS_ADD_NULL_VALUES_IGNORE_NAMES'] = p
        #~ ------------------------
        if self.tweak_author_sort_copy_method_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_AUTHOR_SORT_COPY_METHOD'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_AUTHOR_SORT_COPY_METHOD'] = unicode_type("False")

        if self.tweak_add_books_read_metadata_from_file_contents_not_name_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_ADD_BOOKS_READ_METADATA_FROM_FILE_CONTENTS_NOT_NAME'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_ADD_BOOKS_READ_METADATA_FROM_FILE_CONTENTS_NOT_NAME'] = unicode_type("False")

        if self.tweak_auto_add_directory_by_library_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY'] = unicode_type("True")
            tweak_active = True
        else:
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY'] = unicode_type("False")
            tweak_active = False

        if tweak_active:
            d = self.tweak_last_resort_lineedit.text()
            d = self.standardize_path_format(d)
            if not os.path.isdir(d):
                d = "ERROR"
                self.tweak_last_resort_lineedit.setText(d)
                self.tweak_last_resort_lineedit.update()
                self.tweak_auto_add_directory_by_library_activate_checkbox.setChecked(False)
                self.tweak_auto_add_directory_by_library_activate_checkbox.update()
                prefs['GUI_TOOLS_ACTIVATE_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY'] = unicode_type("False")
            else:
                prefs['GUI_TOOLS_DEFAULT_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY'] = d
                self.tweak_last_resort_lineedit.setText(d)
                self.tweak_last_resort_lineedit.update()
        else:
            d = prefs['GUI_TOOLS_DEFAULT_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY']
            self.tweak_last_resort_lineedit.setText(d)  #overwrite changes (possibly invalid) since tweak is not active.
            self.tweak_last_resort_lineedit.update()
        #~ ------------------------
        if self.tweak_save_to_directory_by_library_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY'] = unicode_type("True")
            tweak_active = True
        else:
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY'] = unicode_type("False")
            tweak_active = False

        if tweak_active:
            d = self.tweak_save_to_directory_by_library_lineedit.text()
            d = self.standardize_path_format(d)
            if not os.path.isdir(d):
                d = "ERROR"
                self.tweak_save_to_directory_by_library_lineedit.setText(d)
                self.tweak_save_to_directory_by_library_lineedit.update()
                self.tweak_auto_add_directory_by_library_activate_checkbox.setChecked(False)
                self.tweak_auto_add_directory_by_library_activate_checkbox.update()
                prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY'] = unicode_type("False")
            else:
                prefs['GUI_TOOLS_DEFAULT_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY'] = d
                self.tweak_save_to_directory_by_library_lineedit.setText(d)
                self.tweak_save_to_directory_by_library_lineedit.update()
        else:
            d = prefs['GUI_TOOLS_DEFAULT_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY']
            self.tweak_save_to_directory_by_library_lineedit.setText(d)  #overwrite changes (possibly invalid) since tweak is not active.
            self.tweak_save_to_directory_by_library_lineedit.update()
        #~ ------------------------
        if self.tweak_save_to_template_by_library_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] = unicode_type("False")

        t = self.tweak_save_to_template_by_library_lineedit.text()
        t = t.replace("  "," ")
        t = t.strip()
        is_valid = True
        if not t.count("{") > 0:
            is_valid = False
        if not t.count("/") > 0:
            is_valid = False
        if t.count("{") != t.count("}"):
            is_valid = False
        if not t.count("\\") == 0:
            is_valid = False
        #~ if not t.count("'") == 0:
            #~ is_valid = False
        #~ if not t.count('"') == 0:
            #~ is_valid = False
        if is_valid:
            prefs['GUI_TOOLS_DEFAULT_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] = t
        else:
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] = unicode_type("False")
            self.tweak_save_to_directory_by_library_activate_checkbox.setChecked(False)
            self.tweak_save_to_directory_by_library_activate_checkbox.update()
            self.tweak_save_to_template_by_library_lineedit.setText(prefs.defaults['GUI_TOOLS_DEFAULT_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'])
            prefs['GUI_TOOLS_DEFAULT_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] = prefs.defaults['GUI_TOOLS_DEFAULT_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY']
            msg = "Save-To Template is Invalid.  Reset to Calibre Default Template."
            return error_dialog(self.maingui, _('JS+ GUI Tool'),_(msg), show=True)

        #~ ------------------------
        if self.tweak_save_cover_separately_by_library_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_COVER_SEPARATELY_BY_LIBRARY'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_COVER_SEPARATELY_BY_LIBRARY'] = unicode_type("False")
        #~ ------------------------
        if self.tweak_save_metadata_in_opf_file_by_library_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_METADATA_IN_OPF_FILE_BY_LIBRARY']  = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_METADATA_IN_OPF_FILE_BY_LIBRARY'] = unicode_type("False")
        #~ ------------------------
        if self.tweak_default_output_format_by_library_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY'] = unicode_type("False")

        prefs['GUI_TOOLS_DEFAULT_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY'] = self.tweak_default_output_format_by_library_combobox.currentText()
        #~ ------------------------
        if self.tweak_title_series_sorting_by_library_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_TITLE_SERIES_SORTING_BY_LIBRARY'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_TITLE_SERIES_SORTING_BY_LIBRARY'] = unicode_type("False")
        #~ ------------------------
        if self.tweak_metadata_edit_custom_column_order_by_library_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_METADATA_EDIT_CUSTOM_COLUMN_ORDER_BY_LIBRARY'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_METADATA_EDIT_CUSTOM_COLUMN_ORDER_BY_LIBRARY'] = unicode_type("False")

        p = self.tweak_metadata_edit_custom_column_order_by_library_lineedit.text()
        p = p.strip()
        if p == "[]":
            pass
        else:
            if p.startswith("[") and p.endswith("]"):
                n1 = p.count("#")
                n2 = p.count(",")
                if n2 != n1 - 1:
                    p = "['ERROR']"
                    self.tweak_metadata_edit_custom_column_order_by_library_lineedit.setText(p)
                    self.tweak_metadata_edit_custom_column_order_by_library_lineedit.update()
                    p = "[]"
        prefs['GUI_TOOLS_DEFAULT_TWEAK_METADATA_EDIT_CUSTOM_COLUMN_ORDER_BY_LIBRARY'] = p
        #~ ------------------------
        if self.tweak_tag_browser_category_order_by_library_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_TAG_BROWSER_CATEGORY_ORDER'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_TAG_BROWSER_CATEGORY_ORDER'] = unicode_type("False")
        #~ ------------------------
        if self.tweak_default_author_link_by_library_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_DEFAULT_AUTHOR_LINK_BY_LIBRARY'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_ACTIVATE_TWEAK_DEFAULT_AUTHOR_LINK_BY_LIBRARY'] = unicode_type("False")

        prefs['GUI_TOOLS_DEFAULT_TWEAK_DEFAULT_AUTHOR_LINK_BY_LIBRARY'] = self.tweak_default_author_link_by_library_qcombobox.currentText()

        if self.tweak_default_author_link_by_library_qcombobox.currentText() != "Use a custom search URL":
            link = ""
        else:
            link = self.tweak_default_author_link_by_library_lineedit.text()
            link = link.strip()
        self.tweak_default_author_link_by_library_lineedit.setText(link)
        prefs['GUI_TOOLS_CUSTOM_URL_TWEAK_DEFAULT_AUTHOR_LINK_BY_LIBRARY'] = link
        #~ ------------------------
        p  = self.update_author_sort_for_complex_surnames_lineedit.text()
        prefs['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_REGEXP'] = p.strip()

        if prefs['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_REGEXP'] != prefs.defaults['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_REGEXP']:
            try:
                p = re.compile(prefs['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_REGEXP'])
            except Exception as e:
                if DEBUG: print("ERROR:  p = re.compile(prefs['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_REGEXP'])",as_unicode(e))
                prefs['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_REGEXP'] = prefs.defaults['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_REGEXP']
                self.update_author_sort_for_complex_surnames_lineedit.setText(prefs['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_REGEXP'])
                self.update_author_sort_for_complex_surnames_lineedit.update()

        p = self.update_author_sort_for_complex_surnames_ignore_lineedit.text()
        p = p.replace(",","|")
        p = p.replace(";","|")
        p = p.replace("||","|").strip()
        prefs['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_IGNORE'] = p
        self.update_author_sort_for_complex_surnames_ignore_lineedit.setText(p)
        self.update_author_sort_for_complex_surnames_ignore_lineedit.update()
        #~ ------------------------
        if self.quality_fixes_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_ACTIVATE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_ACTIVATE'] = unicode_type("False")

        quality_fix_activity_checked = False

        s = self.quality_fixes_activate_libraries_lineedit.text()
        s = s.replace(",","|")
        s = s.replace(";","|")
        s = s.replace("|||","|")
        s = s.replace("||","|")
        if s.endswith("|"):
            s = s[0:-1]
        s = s.replace(" ","").strip()
        if "*" in s:
            s = "*"
        if s == "" or s == "NONE":
            s = "NONE"
            self.quality_fixes_activate_checkbox.setChecked(False)
        prefs['GUI_TOOLS_QUALITY_FIXES_ACTIVATE_LIBRARIES'] = s
        self.quality_fixes_activate_libraries_lineedit.setText(s)

        if self.quality_fixes_clear_publishers_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_CLEAR_PUBLISHERS'] = unicode_type("True")
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_CLEAR_PUBLISHERS'] = unicode_type("False")

        if self.quality_fixes_clear_tags_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_CLEAR_TAGS'] = unicode_type("True")
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_CLEAR_TAGS'] = unicode_type("False")

        if self.quality_fixes_scrub_titles_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES'] = unicode_type("True")
            self.quality_fixes_update_title_sorts_checkbox.setChecked(True)
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES'] = unicode_type("False")

        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_IGNORE_BOOK'] = self.quality_fixes_scrub_titles_regex_ignore_book_lineedit.text()
        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_ORIGINAL_TITLE_CUSTOM_COLUMN'] = self.quality_fixes_scrub_titles_original_title_lineedit.text()
        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_SERIES_ORIGINAL_SERIES_CUSTOM_COLUMN'] = self.quality_fixes_scrub_series_original_series_lineedit.text()
        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE'] = self.quality_fixes_scrub_titles_regex_delete_lineedit.text()
        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE']  = self.quality_fixes_scrub_titles_series_related_regex_relocate_lineedit.text()
        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE'] = self.quality_fixes_scrub_titles_series_index_related_regex_relocate_lineedit.text()
        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE'] = self.quality_fixes_scrub_titles_series_residual_artifacts_regex_relocate_lineedit.text()

        if self.quality_fixes_scrub_titles_checkbox.isChecked():
            try:
                p = re.compile(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE'])
            except Exception as e:
                prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES'] = unicode_type("False")
                self.settings_may_be_saved = False
                msg = "[1] Title Words to Delete Regular Expression is invalid and will fail: " + as_unicode(e) + "<br><br>Please correct it before continuing."
                return error_dialog(self.maingui, _('JS+ GUI Tool'),_(msg), show=True)
            try:
                p = re.compile(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE'])
            except Exception as e:
                prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES'] = unicode_type("False")
                self.settings_may_be_saved = False
                msg = "[2] Series and Index to Relocate Regular Expression is invalid and will fail: " + as_unicode(e) + "<br><br>Please correct it before continuing."
                return error_dialog(self.maingui, _('JS+ GUI Tool'),_(msg), show=True)
            try:
                p = re.compile(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE'])
            except Exception as e:
                prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES'] = unicode_type("False")
                self.settings_may_be_saved = False
                msg = "[3] Index to Relocate Regular Expression is invalid and will fail: " + as_unicode(e) + "<br><br>Please correct it before continuing."
                return error_dialog(self.maingui, _('JS+ GUI Tool'),_(msg), show=True)
            try:
                p = re.compile(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE'])
            except Exception as e:
                prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES'] = unicode_type("False")
                self.settings_may_be_saved = False
                msg = "[4] Delete Residual Artifacts Regular Expression is invalid and will fail: " + as_unicode(e) + "<br><br>Please correct it before continuing."
                return error_dialog(self.maingui, _('JS+ GUI Tool'),_(msg), show=True)

        self.mark_user_changed_regexes_for_future_upgrade_logic()

        if self.quality_fixes_titlecase_titles_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_TITLECASE_TITLES'] = unicode_type("True")
            self.quality_fixes_update_title_sorts_checkbox.setChecked(True)                                       # ui.py will do this anyway, but this informs the user how it works and why...
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_TITLECASE_TITLES'] = unicode_type("False")

        if self.quality_fixes_titlecase_titles_advanced_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_TITLECASE_TITLES_ADVANCED'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_TITLECASE_TITLES_ADVANCED'] = unicode_type("False")

        if self.quality_fixes_update_title_sorts_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_TITLE_SORTS'] = unicode_type("True")
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_TITLE_SORTS'] = unicode_type("False")

        if self.quality_fixes_scrub_authors_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS'] = unicode_type("True")
            self.quality_fixes_update_author_sorts_checkbox.setChecked(True)
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS'] = unicode_type("False")

        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_ORIGINAL_AUTHORS_CUSTOM_COLUMN'] = self.quality_fixes_scrub_authors_original_authors_lineedit.text()

        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_RESIDUAL_ARTIFACTS_REGEX_DELETE'] = self.quality_fixes_scrub_authors_residual_artifacts_regex_delete_lineedit.text()

        if self.quality_fixes_update_author_initials_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_INITIALS'] = unicode_type("True")
            self.quality_fixes_update_author_sorts_checkbox.setChecked(True)                                   # ui.py will do this anyway, but this informs the user how it works and why...
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_INITIALS'] = unicode_type("False")

        prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_INITIALS_MODE'] = self.author_initials_combobox.currentText()

        if self.quality_fixes_change_authors_fnln_checkbox.isChecked():          # FN LN is the default here if mutually exclusive options selected
            prefs['GUI_TOOLS_QUALITY_FIXES_CHANGE_AUTHORS_FNLN'] = unicode_type("True")
            self.quality_fixes_change_authors_lnfn_checkbox.setChecked(False)                                  # mutually exclusive
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_CHANGE_AUTHORS_FNLN'] = unicode_type("False")

        if self.quality_fixes_change_authors_lnfn_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_CHANGE_AUTHORS_LNFN'] = unicode_type("True")
            self.quality_fixes_change_authors_fnln_checkbox.setChecked(False)                                  # mutually exclusive
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_CHANGE_AUTHORS_LNFN'] = unicode_type("False")

        if self.quality_fixes_update_author_sorts_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_SORTS'] = unicode_type("True")
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_SORTS'] = unicode_type("False")

        if self.quality_fixes_find_pseudonyms_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_PSEUDONYMS'] = unicode_type("True")
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_PSEUDONYMS'] = unicode_type("False")

        if self.quality_fixes_scrub_isbn_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_ISBN'] = unicode_type("True")
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_ISBN'] = unicode_type("False")

        try:
            extract_isbn_action = self.maingui.iactions['Extract ISBN']  # if plug-in is not installed, do not allow activation of this option.
            del extract_isbn_action
        except:
            self.quality_fixes_auto_run_extract_isbn_job_checkbox.setChecked(False)

        if self.quality_fixes_auto_run_extract_isbn_job_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_EXTRACT_ISBN_JOB'] = unicode_type("True")
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_EXTRACT_ISBN_JOB'] = unicode_type("False")

        if self.quality_fixes_auto_run_polish_books_job_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_POLISH_BOOKS_JOB'] = unicode_type("True")
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_POLISH_BOOKS_JOB'] = unicode_type("False")

        if self.quality_fixes_auto_run_resize_cover_plugin_checkbox.isChecked():
            try:
                resize_cover_action = self.maingui.iactions['Resize Cover']  # if plug-in is not installed, do not allow activation of this option.
                del resize_cover_action
            except:
                self.quality_fixes_auto_run_resize_cover_plugin_checkbox.setChecked(False)

        if self.quality_fixes_auto_run_resize_cover_plugin_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_RESIZE_COVER_PLUGIN'] = unicode_type("True")
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_RESIZE_COVER_PLUGIN'] = unicode_type("False")

        if self.quality_fixes_auto_run_apply_default_values_checkbox.isChecked():
            prefs['GUI_TOOLS_QUALITY_FIXES_APPLY_DEFAULT_VALUES'] = unicode_type("True")
            quality_fix_activity_checked = True
        else:
            prefs['GUI_TOOLS_QUALITY_FIXES_APPLY_DEFAULT_VALUES'] = unicode_type("False")

        if self.quality_fixes_activate_checkbox.isChecked():
           if not quality_fix_activity_checked:
                self.quality_fixes_activate_checkbox.setChecked(False)
                prefs['GUI_TOOLS_QUALITY_FIXES_ACTIVATE'] = unicode_type("False")
        #~ ------------------------
        text = self.apply_default_values_1_custom_column_lineedit.text()
        if not "#" in text:
            self.apply_default_values_1_activate_checkbox.setChecked(False)
            self.apply_default_values_1_custom_column_lineedit.setText("")
            self.apply_default_values_1_custom_column_default_value_checkbox.setChecked(False)
        if self.apply_default_values_1_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_1_ACTIVATE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_1_ACTIVATE'] = unicode_type("False")
        prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_1_CUSTOM_COLUMN'] = self.apply_default_values_1_custom_column_lineedit.text()
        if self.apply_default_values_1_custom_column_default_value_checkbox.isChecked():
            prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_1_VALUE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_1_VALUE'] = unicode_type("False")
        #~ ------------------------
        text = self.apply_default_values_2_custom_column_lineedit.text()
        if not "#" in text:
            self.apply_default_values_2_activate_checkbox.setChecked(False)
            self.apply_default_values_2_custom_column_lineedit.setText("")
            self.apply_default_values_2_custom_column_default_value_checkbox.setChecked(False)
        if self.apply_default_values_2_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_2_ACTIVATE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_2_ACTIVATE'] = unicode_type("False")
        prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_2_CUSTOM_COLUMN'] = self.apply_default_values_2_custom_column_lineedit.text()
        if self.apply_default_values_2_custom_column_default_value_checkbox.isChecked():
            prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_2_VALUE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_2_VALUE'] = unicode_type("False")
        #~ ------------------------
        text = self.apply_default_values_3_custom_column_lineedit.text()
        if not "#" in text:
            self.apply_default_values_3_activate_checkbox.setChecked(False)
            self.apply_default_values_3_custom_column_lineedit.setText("")
            self.apply_default_values_3_custom_column_default_value_checkbox.setChecked(False)
        if self.apply_default_values_3_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_3_ACTIVATE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_3_ACTIVATE'] = unicode_type("False")
        prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_3_CUSTOM_COLUMN'] = self.apply_default_values_3_custom_column_lineedit.text()
        if self.apply_default_values_3_custom_column_default_value_checkbox.isChecked():
            prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_3_VALUE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_3_VALUE'] = unicode_type("False")
        #~ ------------------------
        prefs['GUI_TOOLS_COPY_TO_LIBRARY_SHORTCUT_DEFAULT_DIRECTORY'] = self.copy_to_library_shortcut_default_directory_lineedit.text()
        #~ ------------------------
        custom_columns_metadata_dict = self.maingui.current_db.field_metadata.custom_field_metadata()
        cc = self.author_pseudonyms_lineedit.text()
        if cc in custom_columns_metadata_dict:  #exists in the current library
            is_valid = False
            custcol = custom_columns_metadata_dict[cc]
            #~ if DEBUG: print(as_unicode(custcol))
            if "'is_names': True" in as_unicode(custcol):
                is_valid = True
                prefs['GUI_TOOLS_AUTHOR_PSEUDONYMS_CUSTOM_COLUMN'] = self.author_pseudonyms_lineedit.text()
            if not is_valid:
                self.author_pseudonyms_lineedit.setText("#?")
                self.author_pseudonyms_lineedit.update()
                msg = "Invalid 'Real Author' Custom Column for Pseudonyms.  Must Be: Text; Tag-Like; Ampersand Separated People's Names.<br><br>Please correct it before continuing."
                return error_dialog(self.maingui, _('JS+ Pseudonym Customization'),_(msg), show=True)
        else:
            pass
        #~ ------------
        if self.update_last_viewed_custom_column_automatically_activate_checkbox.isChecked():
            prefs['GUI_TOOLS_UPDATE_LAST_VIEWED_CUSTOM_COLUMN_AUTOMATICALLY_ACTIVATE'] = unicode_type("True")
        else:
            prefs['GUI_TOOLS_UPDATE_LAST_VIEWED_CUSTOM_COLUMN_AUTOMATICALLY_ACTIVATE'] = unicode_type("False")

        prefs['GUI_TOOLS_UPDATE_LAST_VIEWED_CUSTOM_COLUMN_AUTOMATICALLY_COLUMN_NAME'] = self.update_last_viewed_custom_column_automatically_custom_column_lineedit.text().strip()

        prefs['GUI_TOOLS_UPDATE_LAST_VIEWED_CUSTOM_COLUMN_AUTOMATICALLY_LIBRARIES'] = self.update_last_viewed_custom_column_automatically_libraries_lineedit.text().strip()
        #~ ------------
        s = self.create_bibliography_text_template_lineedit.text().strip()
        s = s.replace("{","")
        s = s.replace("}","")
        s = s.replace("FN LN","AUTHOR")
        s = s.replace("AUTHOR SORT","AUTHOR_SORT")
        s = s.replace("AUTHORS","AUTHOR")
        self.create_bibliography_text_template_lineedit.setText(s)
        self.create_bibliography_text_template_lineedit.update()
        prefs['GUI_TOOLS_BIBLIOGRAPHY_TEXT_TEMPLATE'] = s
        #~ ------------
        prefs
        #~ ------------

        if prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_ACTIVE'] == unicode_type("True"):
            try:
                p = re.compile(prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_REGEX'])
            except Exception as e:
                prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_ACTIVE'] = unicode_type("False")
                prefs
                self.settings_may_be_saved = False
                msg = "VL Views Regular Expression is invalid and will fail: " + as_unicode(e) + "<br><br>Please correct it before continuing."
                error_dialog(self.maingui, _('JS+ GUI Tool'),_(msg), show=True)
        #-----------------------------------------------------
        #-----------------------------------------------------
    def reset_quality_fixes_regexes_to_default(self):

        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE'] = prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE']
        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE'] = prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE']
        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE'] = prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE']
        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE'] = prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE']
        prefs

        self.quality_fixes_scrub_titles_regex_delete_lineedit.setText(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE'])
        self.quality_fixes_scrub_titles_series_related_regex_relocate_lineedit.setText(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE'])
        self.quality_fixes_scrub_titles_series_index_related_regex_relocate_lineedit.setText(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE'])
        self.quality_fixes_scrub_titles_series_residual_artifacts_regex_relocate_lineedit.setText(prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE'])

        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE_VERSION'] = unicode_type(__my_version__)
        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE_VERSION'] = unicode_type(__my_version__)
        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE_VERSION'] = unicode_type(__my_version__)
        prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE_VERSION'] = unicode_type(__my_version__)
        #-----------------------------------------------------
        #-----------------------------------------------------
    def mark_user_changed_regexes_for_future_upgrade_logic(self):
        msg = "Warranty Voided. User Made Changes to the Default Regular Expression Values."
        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE'] != prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE']:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE_VERSION'] = unicode_type(msg)
        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE'] != prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE']:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE_VERSION'] = unicode_type(msg)
        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE'] != prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE']:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE_VERSION'] = unicode_type(msg)
        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE'] != prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE']:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE_VERSION'] = unicode_type(msg)
        #-----------------------------------------------------
        #-----------------------------------------------------
    def standardize_path_format(self,path):
        path = path.replace('"','')  #no double quotes as used in windows
        path = path.replace("'","")  #no single quotes either
        path = path.strip()
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        if path.endswith("/"):
            path = path[0:-1]
            path = path.strip()
        return path
        #-----------------------------------------------------
        #-----------------------------------------------------
    def apply_library_view_color_selection(self):
        self.event_combo_box_colors_changed()
        prefs
        #----------------------------------------
        if not self.maingui:
            try:
                from calibre.gui2.ui import get_gui
                self.maingui = get_gui()
            except Exception as e:
                if DEBUG: print(as_unicode(e))
                self.maingui = None
        #----------------------------------------
        try:
            if not self.maingui:
                return
            tc = prefs['GUI_TOOLS_LIBRARY_VIEW_TEXT_COLOR']
            bc = prefs['GUI_TOOLS_LIBRARY_VIEW_BACKGROUND_COLOR']
            ac = prefs['GUI_TOOLS_LIBRARY_VIEW_ALTERNATING_COLOR']

            if prefs['GUI_TOOLS_LIBRARY_VIEW_COLUMN_HEADING_COLOR_CHANGE'] == unicode_type("True"):
                style_string = "QTableView, QTreeView, QHeaderView, StatusBar, QToolButton {alternate-background-color: [AC];background-color: [BC];color : [TC]; }"
            else:
                style_string = "QTableView, QTreeView, StatusBar, QToolButton {alternate-background-color: [AC];background-color: [BC];color : [TC]; }"

            style_string = style_string.replace("[TC]",tc)
            style_string = style_string.replace("[BC]",bc)
            style_string = style_string.replace("[AC]",ac)
            self.maingui.library_view.setAlternatingRowColors(True)    # QTableView BooksView library_view         QHeaderView will change the column heading color
            self.maingui.library_view.setStyleSheet(style_string)
            self.maingui.tags_view.setAlternatingRowColors(True)       # QTreeView TagsView tags_view
            self.maingui.tags_view.setStyleSheet(style_string)
            self.maingui.alter_tb.setStyleSheet(style_string)   # QToolButton alter_tb       This is the 'configure' button in the very left bottom of the tag browser...just above the status bar...
            if prefs['GUI_TOOLS_STATUS_BAR_COLOR_CHANGE'] == unicode_type("True"):
                self.maingui.status_bar.setStyleSheet(style_string)   # StatusBar status_bar
                style_string = "VersionLabel, " + style_string
                self.maingui.status_bar.defmsg.setStyleSheet(style_string)  # Version Label on left of status bar

            #~ book_details_style_string = "QWidget {background-color: [BC];color : [TC];}"              #removed @ Calibre 6.8
            #~ book_details_style_string = book_details_style_string.replace("[TC]",tc)
            #~ book_details_style_string = book_details_style_string.replace("[BC]",bc)
            #~ self.maingui.book_details.setStyleSheet(book_details_style_string)     # QWidget  BookDetails book_details
            #~ prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_CONFIGURED'] = unicode_type("True")
            #~ prefs
            #~ if DEBUG: print(self.maingui.library_view.styleSheet())
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass
        #-----------------------------------------------------
        #-----------------------------------------------------
    def apply_maingui_color_selection(self):
        self.event_maingui_combo_box_colors_changed()
        prefs
        #----------------------------------------
        if not self.maingui:
            try:
                from calibre.gui2.ui import get_gui
                self.maingui = get_gui()
            except Exception as e:
                if DEBUG: print(as_unicode(e))
                self.maingui = None
        #----------------------------------------
        try:
            if not self.maingui:
                return
            tc = prefs['GUI_TOOLS_MAIN_GUI_TEXT_COLOR']
            vl = prefs['GUI_TOOLS_MAIN_GUI_VIRTUAL_LIBRARY_COLOR']
            srch = prefs['GUI_TOOLS_MAIN_GUI_SEARCHBAR_COLOR']

            vl_style_string = "QToolButton {background-color: [VL];color : [TC]; }"
            vl_style_string = vl_style_string.replace("[TC]",tc)
            vl_style_string = vl_style_string.replace("[VL]",vl)
            self.maingui.virtual_library.setStyleSheet(vl_style_string)     # QToolButton virtual_library
            self.maingui.clear_vl.setStyleSheet(vl_style_string)               # QToolButton clear_vl

            #~ #removed @ Calibre 6.8 --------------------------------------------------------------------------
            #~ ss_string = "[QT] {background-color: [SRCH];color : [TC]; }"
            #~ search_style_string = ss_string.replace("[TC]",tc)
            #~ search_style_string = search_style_string.replace("[SRCH]",srch)
            #~ search_style_string = search_style_string.replace("[QT] ","QToolButton, RightClickButton,SavedSearchBox,SearchBar,SearchBox2,StatusBar, VersionLabel ")
            #~ self.maingui.copy_search_button.setStyleSheet(search_style_string)    # QToolButton copy_search_button
            #~ self.maingui.save_search_button.setStyleSheet(search_style_string)     # RightClickButton save_search_button
            #~ self.maingui.saved_search.setStyleSheet(search_style_string)   #SavedSearchBox saved_search
            #~ self.maingui.search_bar.setStyleSheet(search_style_string)     # SearchBar search_bar
            #~ self.maingui.search.setStyleSheet(search_style_string)            # SearchBox2 search
            #~ if not self.status_bar_color_checkbox.isChecked():
                #~ self.maingui.status_bar.setStyleSheet(search_style_string)     # StatusBar status_bar
                #~ self.maingui.status_bar.defmsg.setStyleSheet(search_style_string)  # Version Label on left of status bar

            #~ toolbar_style_string = 'QToolBar { border: 0px; background-color: [SRCH];color : [TC]; }'           #removed @ Calibre 6.8
            #~ toolbar_style_string = toolbar_style_string.replace("[TC]",tc)
            #~ toolbar_style_string = toolbar_style_string.replace("[SRCH]",srch)
            #~ for bar in self.maingui.bars_manager.main_bars:
                #~ bar.setStyleSheet(toolbar_style_string)
            #~ for bar in self.maingui.bars_manager.child_bars:
                #~ bar.setStyleSheet(toolbar_style_string)

            #~ prefs['GUI_TOOLS_MAIN_GUI_COLOR_CONFIGURED'] = unicode_type("True")          #removed @ Calibre 6.8
            prefs['GUI_TOOLS_MAIN_GUI_COLOR_CONFIGURED'] = unicode_type("False")
            prefs
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass
        #-----------------------------------------------------
        #-----------------------------------------------------
    def set_gui_colors_to_neutral(self):

        prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_CONFIGURED'] = unicode_type("True")

        #----------------------------------------
        if not self.maingui:
            try:
                from calibre.gui2.ui import get_gui
                self.maingui = get_gui()
            except Exception as e:
                if DEBUG: print(as_unicode(e))
                self.maingui = None
        #----------------------------------------

        if not self.maingui:
            return
        tc = unicode_type("black")
        bc = unicode_type("snow")
        ac = unicode_type("gainsboro")

        if prefs['GUI_TOOLS_LIBRARY_VIEW_COLUMN_HEADING_COLOR_CHANGE'] == unicode_type("True"):
            style_string = "BooksView, QHeaderView, TagsView, StatusBar, QToolButton {alternate-background-color: [AC];background-color: [BC];color : [TC]; }"
        else:
            style_string = "BooksView, TagsView, StatusBar, QToolButton {alternate-background-color: [AC];background-color: [BC];color : [TC]; }"

        style_string = "BooksView, TagsView, StatusBar, QToolButton {alternate-background-color: [AC];background-color: [BC];color : [TC]; }"
        style_string = style_string.replace("[TC]",tc)
        style_string = style_string.replace("[BC]",bc)
        style_string = style_string.replace("[AC]",ac)
        self.maingui.library_view.setAlternatingRowColors(True)    # BooksView library_view
        self.maingui.library_view.setStyleSheet(style_string)
        self.maingui.tags_view.setAlternatingRowColors(True)       # TagsView tags_view
        self.maingui.tags_view.setStyleSheet(style_string)
        self.maingui.alter_tb.setStyleSheet(style_string)   # QToolButton alter_tb       This is the 'configure' button in the very left bottom of the tag browser...just above the status bar...
        #~ if self.status_bar_color_checkbox.isChecked():                          #removed @ Calibre 6.8
            #~ self.maingui.status_bar.setStyleSheet(style_string)   # StatusBar status_bar
            #~ style_string = "VersionLabel, " + style_string
            #~ self.maingui.status_bar.defmsg.setStyleSheet(style_string)  # Version Label on left of status bar

        #~ book_details_style_string = "QWidget {background-color: [BC];color : [TC];}"                 #removed @ Calibre 6.8
        #~ book_details_style_string = book_details_style_string.replace("[TC]",tc)
        #~ book_details_style_string = book_details_style_string.replace("[BC]",bc)
        #~ self.maingui.book_details.setStyleSheet(book_details_style_string)     # QWidget  BookDetails book_details
        #-----------------------------------------------------
        #-----------------------------------------------------
    #~ def set_main_gui_colors_to_neutral(self):                     #removed @ Calibre 6.8

        #~ prefs['GUI_TOOLS_MAIN_GUI_COLOR_CONFIGURED'] = unicode_type("True")

        #~ #----------------------------------------
        #~ if not self.maingui:
            #~ try:
                #~ from calibre.gui2.ui import get_gui
                #~ self.maingui = get_gui()
            #~ except Exception as e:
                #~ if DEBUG: print(as_unicode(e))
                #~ self.maingui = None
        #~ #----------------------------------------

        #~ if not self.maingui:
            #~ return

        #~ tc = unicode_type("black")
        #~ vl = unicode_type("snow")
        #~ srch = unicode_type("gainsboro")

        #~ vl_style_string = "QToolButton {background-color: [VL];color : [TC]; }"
        #~ vl_style_string = vl_style_string.replace("[TC]",tc)
        #~ vl_style_string = vl_style_string.replace("[VL]",vl)
        #~ self.maingui.virtual_library.setStyleSheet(vl_style_string)     # QToolButton virtual_library
        #~ self.maingui.clear_vl.setStyleSheet(vl_style_string)               # QToolButton clear_vl


        #~ #removed @ Calibre 6.8 -------------------------------------------------------------------------------------------------
        #~ ss_string = "[QT] {background-color: [SRCH];color : [TC]; }"
        #~ search_style_string = ss_string.replace("[TC]",tc)
        #~ search_style_string = search_style_string.replace("[SRCH]",srch)
        #~ search_style_string = search_style_string.replace("[QT] ","QToolButton, RightClickButton,SavedSearchBox,SearchBar,SearchBox2,StatusBar ")
        #~ self.maingui.copy_search_button.setStyleSheet(search_style_string)    # QToolButton copy_search_button
        #~ self.maingui.save_search_button.setStyleSheet(search_style_string)     # RightClickButton save_search_button
        #~ self.maingui.saved_search.setStyleSheet(search_style_string)   #SavedSearchBox saved_search
        #~ self.maingui.search_bar.setStyleSheet(search_style_string)     # SearchBar search_bar
        #~ self.maingui.search.setStyleSheet(search_style_string)            # SearchBox2 search
        #~ if not self.status_bar_color_checkbox.isChecked():
            #~ self.maingui.status_bar.setStyleSheet(search_style_string)     # StatusBar status_bar
            #~ search_style_string = "VersionLabel, " + search_style_string
            #~ self.maingui.status_bar.defmsg.setStyleSheet(search_style_string)  # Version Label on left of status bar

        #~ toolbar_style_string = 'QToolBar { border: 0px; background-color: [SRCH];color : [TC]; }'
        #~ toolbar_style_string = toolbar_style_string.replace("[TC]",tc)
        #~ toolbar_style_string = toolbar_style_string.replace("[SRCH]",srch)
        #~ for bar in self.maingui.bars_manager.main_bars:
            #~ bar.setStyleSheet(toolbar_style_string)
        #~ for bar in self.maingui.bars_manager.child_bars:
            #~ bar.setStyleSheet(toolbar_style_string)


        #~ prefs['GUI_TOOLS_MAIN_GUI_COLOR_CONFIGURED'] = unicode_type("False")          # changed to False @ Calibre 6.8
        #~ prefs
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def purge_additional_history(self):
        prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY'] = prefs.defaults['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY']
        prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY_PURGE'] = unicode_type("True")
        prefs
        self.purge_additional_search_history_pushbutton.setText("Restart Calibre to Complete Purge")
    #-----------------------------------------------------------------------------------------
    def validate(self):
        if self.settings_may_be_saved:
            return True
        else:
            return False
    #-----------------------------------------------------------------------------------------
#END of config.py

