# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.237"  # Per Library Tweak for 'Default Author Link', default_author_link.  Notes Viewer: Ctrl+C conflict; Ctrl+V now for Create Instance.
#~ zzzzzzzzzzzz unreleased zzzzzzzzzzzzzzzz

from calibre.customize import InterfaceActionBase

JS_DESCRIPTION = "JS+: Big Tool Box of 79 unique functions to make Calibre better."          # also imported by ui.py for use in action_spec

class ActionBaseJobSpy(InterfaceActionBase):

    name                    = 'Job Spy'
    description           = JS_DESCRIPTION
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 0, 236)
    minimum_calibre_version = (6, 15, 0)    # originally 2.49.0

    actual_plugin       = 'calibre_plugins.job_spy.ui:ActionJobSpy'

    gui_name = 'Job Spy'

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):
        pass
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return True
    #--------------------------------------------------------------------------------------------------------------------------
    def config_widget(self):
        from calibre_plugins.job_spy.config import ConfigWidget
        return ConfigWidget()
    #--------------------------------------------------------------------------------------------------------------------------
    def save_settings(self, ConfigWidget):
        ConfigWidget.save_settings()
        ac = self.actual_plugin_
        if ac is not None:
            ac.apply_settings()
    #-------------------------------------------
#END of __init__.py