from calibre.gui2 import error_dialog
from calibre.gui2.actions import InterfaceAction

class ToggleInternalViewerAction(InterfaceAction):
    name = 'Toggle Internal Viewer'
    action_spec = ('Toggle internal viewer for EPUB formats', None, None)
    action_type = 'current'

    def genesis(self):
        self.qaction.setToolTip('Toggle internal viewer for EPUB formats')
        self.qaction.setIcon(QIcon(self.get_icon_path()))
        self.qaction.triggered.connect(self.toggle_internal_viewer)

    def location_selected(self, loc):
        self.qaction.setVisible(bool(loc == 'library'))

    def toggle_internal_viewer(self):
        internal_viewer = self.gui_action('behavior_plugin_use_internal_viewer_for')
        self.gui_action('behavior_plugin_use_internal_viewer_for', not internal_viewer)
        try:
            self.commit_gui_settings()
        except Exception as e:
            error_dialog(self.gui, _('Error'), str(e))

    def apply_settings(self):
        self.qaction.setVisible(True)

    def remove_settings(self):
        pass

    def get_icon(self):
        return self.get_icon_path()

    def get_icon_path(self):
        return self.interface_action_base_path + '/images/icon.png'

    def save_settings(self):
        pass

    def restore_settings(self):
        pass
