from calibre.customize import InterfaceActionBase
from calibre_plugins.toggle.toggle import ToggleInternalViewerAction

class ToggleInternalViewerPlugin(InterfaceActionBase):
    name = 'Toggle Internal Viewer'
    description = 'Toggle internal viewer for EPUB formats'
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'Your Name'
    version = (1, 0, 0)
    minimum_calibre_version = (3, 0, 0)
    can_be_disabled = True

    def is_customizable(self):
        return True

    def customization_help(self):
        return _('This plugin adds a button to the toolbar that allows you to toggle the "Use internal viewer for EPUB formats" behavior preference in Calibre.')

    def __init__(self, plugin_action):
        self.action = plugin_action

    def create_action(self, for_toolbar=False):
        return ToggleInternalViewerAction(self.action, self.name)

    def apply_settings(self, settings):
        pass

    def save_settings(self, config_widget):
        pass

    def restore_settings(self, config_widget):
        pass

    def customization_widget(self):
        return None

    def config_widget(self):
        return None

    def save_settings(self):
        pass

    def is_customizable(self):
        return False

    def config_changed(self, prefs):
        pass

    def library_changed(self, db):
        pass

    def save_settings(self, config_widget):
        pass
