# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "3.6.120"    # Qt.core

from qt.core import (Qt, QDialog, QLabel, QLineEdit, QVBoxLayout, QHBoxLayout, QWidget, QPushButton,
        QGridLayout, pyqtSignal, QDialogButtonBox, QScrollArea, QFont, QPalette, QColor,
        QTabWidget, QIcon, QToolButton, QSplitter, QGroupBox, QSpacerItem,
        QSizePolicy, QFrame, QSize, QKeySequence, QMenu, QShortcut)

from polyglot.builtins import as_unicode

class WorkTagAddDialog(QDialog):

    def __init__(self, gui,icon,guidb,execute_work_tag_add):


        QDialog.__init__(self, gui)
        self.gui = gui

        self.guidb = guidb

        self.execute_work_tag_add = execute_work_tag_add

        self.layout = QVBoxLayout()
        self.setLayout(self.layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(11)

        self.layout.addSpacing(2)

        self.text_heading = QLabel()
        self.text_heading.setTextFormat(Qt.RichText)
        self.text_heading.setText("<center><font color='#0404B4'>Add a Specific Work Tag [Selected Books]</font></center>")
        self.text_heading.setFont(font)
        self.layout.addWidget(self.text_heading)
        self.layout.addSpacing(20)


        self.setWindowTitle('Quarantine And Scrub                                                                                                                          ')
        self.setWindowIcon(icon)

        font.setBold(True)
        font.setPointSize(8)

        self.label1 = QLabel()
        self.label1.setTextFormat(Qt.RichText)
        self.label1.setText("<center><font color='#0404B4'>Work Tag to Add</font></center>")
        self.label1.setFont(font)
        self.layout.addWidget(self.label1)

        self.msg1 = QLineEdit(self)
        self.msg1.setText('?')
        self.layout.addWidget(self.msg1)
        self.label1.setBuddy(self.msg1)

        self.layout.addSpacing(20)

        self.push_button1 = QPushButton(" ", self)
        self.push_button1.setText("Execute: Work Tag to Add [Selected Books]")
        self.push_button1.clicked.connect(self.__do_push_button1)
        self.push_button1.setFont(font)
        self.layout.addWidget(self.push_button1)

        self.layout.addSpacing(20)

        font.setBold(True)
        font.setPointSize(8)

        button_box = QDialogButtonBox(QDialogButtonBox.Cancel)
        button_box.rejected.connect(self.reject)
        self.layout.addWidget(button_box)

        self.resize(self.sizeHint())


    def __do_push_button1(self):
        self.work_tag_keyword = as_unicode(self.msg1.text())
        self.work_tag_keyword = self.work_tag_keyword.replace(",","")
        self.work_tag_keyword = self.work_tag_keyword.replace(";","")
        self.work_tag_keyword = self.work_tag_keyword.strip()
        self.msg1.setText(self.work_tag_keyword)
        self.execute_work_tag_add(self.work_tag_keyword)



#END of worktagadddialog.py
