# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "3.6.120"    # Qt.core

from qt.core import (Qt, QDialog, QLabel, QVBoxLayout, QFont, QWidget)

class UIToastDialog(QDialog):

    def __init__(self,gui,icon,msg_num):

        QDialog.__init__(self, gui)

        self.gui = gui

        self.msg_num = msg_num

        s_msg = "Wait"

        if self.msg_num == 0:
            s_msg = "Current Calibre Library is Not a Q&S Library"
        if self.msg_num == 1:
            s_msg = "Wait While the Requested Action Completes"
        if self.msg_num == 2:
            s_msg = "Wait While Related Background Processes Complete"
        if self.msg_num == 3:
            s_msg = "Job Submitted"
        if self.msg_num == 4:
            s_msg = "Click the Arrow to the Right"

        self.setWindowFlags( Qt.Widget | Qt.CustomizeWindowHint )              # http://doc.qt.io/qt-4.8/qt.html#WindowType-enum

        self.layout = QVBoxLayout()
        self.setLayout(self.layout)

        font = QFont()
        font.setBold(True)
        font.setPointSize(20)

        self.text_line = QLabel()
        self.text_line.setTextFormat(Qt.RichText)
        self.text_line.setFont(font)
        self.text_line.setText("<center><font color='#0404B4'>" + s_msg + "</font></center>")
        self.layout.addWidget(self.text_line)

        self.resize(self.sizeHint())

#END OF ui_toastdialog.py
