# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "3.6.120"  
import os, sys
import apsw
import codecs
import re
from difflib import SequenceMatcher
from time import sleep
from calibre import isbytestring
from calibre.constants import filesystem_encoding, DEBUG
from calibre.utils.logging import Log as log
from polyglot.builtins import as_unicode, iteritems, range, unicode_type
from polyglot.queue import Queue
from calibre_plugins.quarantine_and_scrub.debug_nicely import debug_nicely
from calibre_plugins.quarantine_and_scrub.heading import log_heading_common
header_s1 = None
header_s2 = None
header_s3 = None
header_s4 = None
header_s5 = None
notifications = Queue()
mynothing = ""
scrubbed_books_final_list = []
candidate_list = []
my_series_priority = "Pristine,Global,Work"
my_run_type = "0"
n_cutoff = 0.700000
n_cutoff_minor = 0.750000
def main_scrub_series_level(self,guidb,series_source_priority,run_type,log=None,abort=None,notifications=True):
    global header_s1
    global header_s2
    global header_s3
    global header_s4
    global header_s5
    global mynothing
    global my_series_priority
    global my_run_type
    global n_cutoff
    my_run_type = run_type
    if my_run_type != "0" and my_run_type != "1":
        my_run_type = "0"
        header_s4 = "Error: invalid type of run"
        return
    if  my_run_type == "0":
        header_s4 = "......What-if only......no Actual updates will be made."
    else:
        header_s4 = "Actual updates to be performed"
    header_s5 = "Series Source Priority is: " + as_unicode(series_source_priority)
    my_series_priority = as_unicode(series_source_priority)
    if (not my_series_priority) or (my_series_priority == mynothing):
        my_series_priority = as_unicode("Pristine,Global,Work")
    notifications.put((0.01, 'Beginning Series-Level Scrubbing'))
    path = guidb.library_path
    if isbytestring(path):
        path = path.decode(filesystem_encoding)
    path = path.replace(os.sep, '/')
    path = os.path.join(path, 'metadata.db')
    path = path.replace(os.sep, '/')
    log("Library DB: " + path)
    try:
        my_db =apsw.Connection(path)
    except Exception as e:
        log( as_unicode(e))
        raise e
        return
    my_cursor = my_db.cursor()
    mysql = "PRAGMA main.busy_timeout = 15000;"    
    my_cursor.execute(mysql)
    header_s1 =  "SQLite Version: " + as_unicode(apsw.SQLITE_VERSION_NUMBER) + "  [APSW]"
    header_s2 = "Database is SHARED, not EXCLUSIVE"
    sleep(0)
    Scrub_Control(my_db,my_cursor,notifications,log)
    my_db.close()
    log("Job complete.")
def Scrub_Control(my_db,my_cursor,notifications,log):
    global header_s1
    global header_s2
    global header_s3
    global header_s4
    global header_s5
    header_s3 = "Beginning Series Level Scrubbing"
    log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
    mysql = "PRAGMA main.busy_timeout = 5000;"    
    my_cursor.execute(mysql)
    mysql = "SELECT Count(*),NULL FROM custom_column_10"
    my_cursor.execute(mysql)
    rows = my_cursor.fetchall()
    count1,dummy = rows[0]
    log("Number of Work Series:    ", as_unicode(count1))
    if as_unicode(count1) == "0":
        log("Nothing to do.")
        log("Series-Level Consolidation/Renaming is complete.")
        notifications.put((1.0, 'Series Level Scrubbing Complete'))
        return
    notifications.put((0.01, 'Adding New Global Series from WSSVD'))
    add_new_global_series_from_wssvd(my_db,my_cursor,log)
    notifications.put((0.02, 'Counting Global/Pristine Series'))
    count_global_series(my_db,my_cursor,log)
    notifications.put((0.03, 'Doing Light Work Series Housekeeping'))
    explode_custom_column_10_if_needed(my_db,my_cursor,log)
    refresh_custom_column_15(my_db,my_cursor,notifications,log)
    notifications.put((0.04, 'Comparing Each Work Series to Other Work Series, Global Series & Pristine Series'))
    log("Comparing Each Work Series to Other Work Series, Global Series & Pristine Series")
    build_instr_series_series_table(my_db,my_cursor,notifications,log)
    notifications.put((0.50, 'Selecting Appropriate Series Names'))
    log("Selecting Appropriate Series Names")
    process_instr_series_series_table(my_db,my_cursor,notifications,log)
    n = len(candidate_list)
    if n == 0 :
        notifications.put((0.99, 'Nothing To Rename'))
        log("Nothing To Rename")
    else:
        notifications.put((0.95, 'Renaming Series Names'))
        log("Consolidating Series by Renaming Series Names")
        update_results(my_db,my_cursor,notifications,log)
        explode_custom_column_10_if_needed(my_db,my_cursor,log)
        refresh_custom_column_15(my_db,my_cursor,notifications,log)
    delete_unused_values(my_db,my_cursor,notifications,log)
    log("Series-Level Consolidation/Renaming is complete.")
    notifications.put((1.0, 'Series Level Scrubbing Complete'))
def  update_results(my_db,my_cursor,notifications,log):
    global candidate_list
    global my_run_type
    n = len(candidate_list)
    if n == 0 :
        return
    else:
        pass
    final_list = []
    for row in candidate_list:
        if row not in final_list:
            final_list.append(row)
        else:
            pass
    candidate_dict = {}
    n_changes = 0
    log(" ")
    for row in final_list:
        candidate_dict = row
        for k,v in iteritems(candidate_dict):
            s_old_series = as_unicode(k)
            s_new_series = as_unicode(v)
            s = as_unicode("Work Series: [ " + as_unicode(s_old_series) + " ] will be changed to: [ " + as_unicode(s_new_series) + " ]")
            log( as_unicode(s))
            if my_run_type == "0":
                pass
            else:
                mysql = "UPDATE custom_column_10 SET value = ? WHERE value = ? "
                execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,s_new_series,s_old_series)
                n_changes = n_changes + 1
        log(" ")
    log(" ")
    if my_run_type == "0":
        log("No Changes Made; What-if Only")
    else:
        s = as_unicode(as_unicode(n_changes) + " Actual Changes to Work Series Were Made As Listed Above.")
        log(s)
    log(" ")
def process_instr_series_series_table(my_db,my_cursor,notifications,log):
    global candidate_list
    global n_cutoff
    global n_cutoff_minor
    candidate_list[:] = []
    candidate_dict = {}
    log("------------------------------------------------------------------------------------------")
    log("------------------------------------------------------------------------------------------")
    log("Initial Cutoff Similarity Percentage:", as_unicode(n_cutoff))
    log("Minor Differences Cutoff Similarity Percentage:", as_unicode(n_cutoff_minor))
    log(" ")
    mysql = "SELECT series, name1, name2, sourceseries, sourcename1, sourcename2 FROM _instr_series_series"
    tmp_rows = execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None)
    tmp_rows.sort()
    s_old_s = ""
    for row in tmp_rows:
        ignore_other_1 = True
        ignore_other_2 = True
        n_count0  = 0
        n_count1  = 0
        n_count2  = 0
        f_ratio1 = 0.000001
        f_ratio1 = 0.000001
        s = ""
        s_special_msg = ""
        swap_in_reverse_1 = False
        swap_in_reverse_2 = False
        log("------------------------------------------------------------------------------------------")
        log("Work Series, Other 1, Other 2, Source, Source 1, Source 2 ")
        log("------------------------------------------------------------------------------------------")
        series,name1,name2,sourceseries,sourcename1,sourcename2 = row
        if not name1:
            name1 = "(nothing)"
        if not name2:
            name1 = "(nothing)"
        s = as_unicode(as_unicode(series) + " , " + as_unicode(name1) + " , "  + as_unicode(name2) + " , " \
        + as_unicode(sourceseries) + " , "  + as_unicode(sourcename1) + " , "  + as_unicode(sourcename2))
        if s == s_old_s:
            continue
        s_old_s = s
        log(s)
        log(" ")
        n_count0 = count_series_usage(my_db,my_cursor,as_unicode(series))
        s = as_unicode("Usage of Work Series as Work Series:      " + as_unicode(n_count0) + " time(s) ")
        log(s)
        n_count1 = count_series_usage(my_db,my_cursor,as_unicode(name1))
        s = as_unicode("Usage of Other Series 1 as Work Series:   " + as_unicode(n_count1) + " time(s) ")
        log(s)
        n_count2 = count_series_usage(my_db,my_cursor,as_unicode(name2))
        s = as_unicode("Usage of Other Series 2 as Work Series:   " + as_unicode(n_count2) + " time(s) ")
        log(s)
        log(" ")
        f_ratio1 = calculate_similarity(as_unicode(series),as_unicode(name1))
        s = as_unicode("Similarity of Work Series to Other Series 1 is: " + as_unicode(f_ratio1))
        log( as_unicode(s))
        f_ratio2 = calculate_similarity(as_unicode(series),as_unicode(name2))
        s = as_unicode("Similarity of Work Series to Other Series 2 is: " + as_unicode(f_ratio2))
        log(s)
        log(" ")
        s_action = as_unicode("To Be Determined")
        ignore_other_1 = True
        ignore_other_2 = True
        picked1 = False
        picked2 = False
        picked0_1 = False
        picked0_2 = False
        if f_ratio1 < 1.0 and f_ratio1 >= n_cutoff :
            ignore_other_1 = False
        if f_ratio2 < 1.0 and f_ratio2 >= n_cutoff:
            ignore_other_2 = False 
        if not ignore_other_1:
            if n_count1 > n_count0:
                pass
            else:
                if n_count1 == n_count0:
                    if f_ratio1 >= n_cutoff_minor: 
                        pass
                    else:
                        ignore_other_1 = True
                else:
                    ignore_other_1 = True
        if not ignore_other_2:
            if n_count2 > n_count0:
                pass
            else:
                if n_count2 == n_count0:
                    if f_ratio2 >= n_cutoff_minor: 
                        pass
                    else:
                        ignore_other_2 = True
                else:
                    ignore_other_2 = True
        if f_ratio1 == 1.0:
            ignore_other_1 = True
        if f_ratio2 == 1.0:
            ignore_other_2 = True
        if ignore_other_1 and ignore_other_2:
            s_action = "None"
        else:
            if (not ignore_other_1) and (not ignore_other_2) :
                if n_count1 == n_count2 :
                    if f_ratio1 > f_ratio2:
                        ignore_other_2 = True
                    else:
                        ignore_other_1 = True
            else:
                if not ignore_other_1:
                    if n_count1 > n_count0 :
                        picked1 = True
                    else:
                        if n_count1 == n_count0:
                            if f_ratio1 >= n_cutoff_minor: 
                                if (((not series.startswith("The ")) and name1.startswith("The ")) or ((not series.startswith("A ")) and name1.startswith("A "))
                                                                                                                                      or ((not series.startswith("An ")) and name1.startswith("An "))):
                                    picked1 = True
                                    s_special_msg = "Other 1 selected due to minor differences (The/A/An) cutoff percentage although counts were identical."
                                else:
                                    if (((series.startswith("The ")) and (not name1.startswith("The "))) or ((series.startswith("A ")) and (not name1.startswith("A ")))
                                                                                                                                            or ((series.startswith("An ")) and (not name1.startswith("An ")))):
                                        picked1 = False
                                        swap_in_reverse_1 = True
                                        picked0_1 = True
                                        s_special_msg = "Reverse Swap: Series Will Replace Other 1 due to (The/A/An) cutoff percentage although counts were identical."
                                    else:
                                        s_action = "None"
                        else:
                            s_action = "None"
                else:
                    if not ignore_other_2:
                        if n_count2 > n_count0 :
                            picked2 = True
                        else:
                            if n_count2 == n_count0:
                                if f_ratio2 >= n_cutoff_minor: 
                                    if (((not series.startswith("The ")) and name2.startswith("The ")) or ((not series.startswith("A ")) and name2.startswith("A "))
                                                                                                                                          or ((not series.startswith("An ")) and name2.startswith("An "))):
                                        picked2 = True
                                        s_special_msg = "Other 2 selected due to minor differences (The/A/An) cutoff percentage although counts were identical."
                                    else:
                                        if (((series.startswith("The ")) and (not name2.startswith("The "))) or ((series.startswith("A ")) and (not name2.startswith("A ")))
                                                                                                                                                or ((series.startswith("An ")) and (not name2.startswith("An ")))):
                                            picked2 = False
                                            swap_in_reverse_2 = True
                                            picked0_2 = True
                                            s_special_msg = "Reverse Swap: Series Will Replace Other 2 due to (The/A/An) cutoff percentage although counts were identical."
                                        else:
                                            s_action = "None"
                            else:
                                s_action = "None"
                    else:
                        s_action = "None"
        if swap_in_reverse_1 :
            if sourcename1 != "series":
                swap_in_reverse_1 = False
                picked0_1 = False
                s_special_msg = ""
        if swap_in_reverse_2 :
            if sourcename2 != "series":
                swap_in_reverse_2 = False
                picked0_2 = False
                s_special_msg = ""
        if (picked1 and picked2) or (picked1 and picked0_1) or (picked2 and picked0_2):
            log("ERROR: Too Many Choices Chosen for:" + as_unicode(series))
            continue
        else:
            del candidate_dict
            candidate_dict = {}
            if picked1:
                s_action = as_unicode("Other Series 1: [ " + as_unicode(name1) + " ] Will Replace: [ " + as_unicode(series) + " ]")
                candidate_dict[as_unicode(series)] = as_unicode(name1)
                candidate_list.append(candidate_dict)
            else:
                if picked2:
                    s_action = as_unicode("Other Series 2: [ " + as_unicode(name2) + " ] Will Replace: [ " + as_unicode(series) + " ]")
                    candidate_dict[as_unicode(series)] = as_unicode(name2)
                    candidate_list.append(candidate_dict)
                else:
                    if swap_in_reverse_1 :#change name1 to series, not the other way around
                        s_action = as_unicode("Work Series : [ " + as_unicode(series) + " ] Will Replace Other Series 1: [ " + as_unicode(name1) + " ]")
                        candidate_dict[as_unicode(name1)] = as_unicode(series)
                        candidate_list.append(candidate_dict)
                    else:
                        if swap_in_reverse_2 :
                            s_action = as_unicode("Work Series : [ " + as_unicode(series) + " ] Will Replace Other Series 2: [ " + as_unicode(name2) + " ]")
                            candidate_dict[as_unicode(name2)] = as_unicode(series)
                            candidate_list.append(candidate_dict)
                        else:
                            s_action = "None"
        if s_special_msg != "":
            log(" ")
            log(s_special_msg)
            log(" ")
        log ("Action To Be Taken:", as_unicode(s_action))
        log(" ")
    log("----------------------------------------------------------------------------------------")
    log("----------------------------------------------------------------------------------------")
    log("----------------------------------------------------------------------------------------")
def build_instr_series_series_table(my_db,my_cursor,notifications,log):
    global my_series_priority
    series_source_priority_1 = "Pristine,Global,Work"
    series_source_priority_2 = "Global,Work"
    series_source_priority_3 = "Work"
    mysql = "DELETE FROM _instr_series_series WHERE id IS NOT NULL   "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.5)
    if my_series_priority == series_source_priority_1:
        notifications.put((0.05, 'Sources:  Pristine,Global,Work -  Comparing Each Work Series to Other Work Series, Global Series & Pristine Series'))
        log("Highest Priority For Similarity Matching is: Pristine Series")
        mysql = "INSERT OR IGNORE INTO _instr_series_series SELECT null,seriesname,name1,name2, 'series','series','pristine' FROM  __instr_series_within_pristine_series_part2"
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
        sleep(1.0)
        notifications.put((0.10, 'Sources:  Pristine,Global,Work -  Comparing Each Work Series to Other Work Series, Global Series & Pristine Series'))
        log("Middle Priority For Similarity Matching is: Global Series")
        mysql = "INSERT OR IGNORE INTO _instr_series_series SELECT null,seriesname,name1,name2, 'series','series','global' FROM  __instr_series_within_global_series_part2"
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
        sleep(1.0)
        notifications.put((0.40, 'Sources:  Pristine,Global,Work -  Comparing Each Work Series to Other Work Series, Global Series & Pristine Series'))
        log("Lowest Priority For Similarity Matching is: Other Current Work Series")
        mysql = "INSERT OR IGNORE INTO _instr_series_series SELECT null,seriesname,name1,name2, 'series','series','series'  FROM  __instr_series_within_series_part2"
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
        sleep(1.0)
        return
    if my_series_priority == series_source_priority_2:
        sleep(1.0)
        notifications.put((0.05, 'Sources:  Global,Work -   Comparing Each Work Series to Other Work Series & Global Series'))
        log("Higher Priority For Similarity Matching is: Global Series")
        mysql = "INSERT OR IGNORE INTO _instr_series_series SELECT null,seriesname,name1,name2, 'series','series','global' FROM  __instr_series_within_global_series_part2"
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
        sleep(1.0)
        notifications.put((0.40, 'Sources:  Global,Work -   Comparing Each Work Series to Other Work Series & Global Series'))
        log("Lower Priority For Similarity Matching is: Other Current Work Series")
        mysql = "INSERT OR IGNORE INTO _instr_series_series SELECT null,seriesname,name1,name2, 'series','series','series'  FROM  __instr_series_within_series_part2"
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
        sleep(1.0)
        return
    if my_series_priority == series_source_priority_3:
        sleep(1.0)
        notifications.put((0.05, 'Sources:  Work -  Comparing Each Work Series to Other Work Series'))
        log("Single Source for Similarity Matching is: Other Current Work Series")
        mysql = "INSERT OR IGNORE INTO _instr_series_series SELECT null,seriesname,name1,name2, 'series','series','series'  FROM  __instr_series_within_series_part2"
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
        sleep(1.0)
        return
    log("Error.  Series Source Priority Invalid.  Processing Terminated Early.")
    return
def count_series_usage(my_db,my_cursor,s_series):
    if not s_series:
        return 0
    s_series = as_unicode(s_series)
    if s_series == "":
        return 0
    mysql = "SELECT Count(*),NULL FROM __series_work_full WHERE seriesname = ?  "
    my_cursor.execute(mysql,([s_series]))
    tmprows = my_cursor.fetchall()
    if not tmprows:
        return 0
    else:
        n_count = 0
        for row in tmprows:
            n_count,dummy = row
            break
    return n_count
def refresh_custom_column_15(my_db,my_cursor,notifications,log):
    c_work_series_full_table = "custom_column_15"
    mysql = "DELETE FROM custom_column_15 WHERE book IS NOT NULL "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    c_work_series_full_table = "custom_column_15" 
    mysql = "INSERT or IGNORE INTO custom_column_15 SELECT book,book,seriesfull FROM __series_work_full WHERE book IS NOT NULL "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    c_work_series_full_table = "custom_column_15" 
    mysql =  "UPDATE custom_column_15 SET value=REPLACE(value,'.0','') WHERE book IS NOT NULL "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    c_work_series_full_table = "custom_column_15" 
    mysql =  "UPDATE custom_column_15 SET value=REPLACE(value,'.5]','.50]') WHERE book IS NOT NULL "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
def explode_custom_column_10_if_needed(my_db,my_cursor,log):
    sleep(0.1)
    mysql = 'DELETE FROM custom_column_10 WHERE id IN __series_unused'
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    mysql = "INSERT or REPLACE INTO custom_column_10 (id,value) SELECT book, seriesname FROM __books_work_populate WHERE seriesname > ' '  ; "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
    mysql = "UPDATE books_custom_column_10_link  SET value = books_custom_column_10_link.book "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
    mysql = "DELETE FROM custom_column_10 WHERE id NOT IN (SELECT value FROM books_custom_column_10_link)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0.1)
    mysql = 'DELETE FROM custom_column_10 WHERE id IN __series_unused'
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
def calculate_similarity(a,b):
    return SequenceMatcher(None, a, b).ratio()
def delete_unused_values(my_db,my_cursor,notifications,log):
    mysql = 'DELETE FROM custom_column_10 WHERE id IN __series_unused'
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
def add_new_global_series_from_wssvd(my_db,my_cursor,log):
    mysql = "INSERT OR IGNORE INTO _global_authors SELECT null,authname,' ',' ' FROM _global_web_author_series"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    mysql = "INSERT OR IGNORE INTO _global_series SELECT null,seriesname,' ' FROM _global_web_author_series"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    mysql = "INSERT OR IGNORE INTO _global_author_series_link SELECT null,authid,seriesid FROM __global_author_series_link_in_wssvd WHERE authid NOT NULL and seriesid NOT NULL"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    log("If Available, New Global Series and their Global Authors Added from Web Source Series Validation Data (WSSVD)")
def count_global_series(my_db,my_cursor,log):
    log("===================================")
    log("For Your Reference")
    log("===================================")
    mysql = "SELECT Count(*),NULL FROM _global_series"
    my_cursor.execute(mysql)
    rows = my_cursor.fetchall()
    count2,dummy = rows[0]
    log("Number of Global Series:    ", as_unicode(count2))
    mysql = "SELECT Count(*),NULL FROM _pristine_series"
    my_cursor.execute(mysql)
    rows = my_cursor.fetchall()
    count4,dummy = rows[0]
    log("Number of Pristine Series:  ", as_unicode(count4))
    log("===================================")
    log("===================================")
def execute_mysql_fetchall_generic_1_arg(my_db,my_cursor,log,mysql,v1=None):
    sleep(0.1)
    try:
        if v1 is None:
            my_cursor.execute(mysql)
        else:
            my_cursor.execute(mysql,([v1]))
        tmp_rows = my_cursor.fetchall()
        if tmp_rows:
            return tmp_rows
        else:
            tmp_rows = []
            return tmp_rows
    except Exception as e:
        log("v1: " + as_unicode(v1))
        log(as_unicode(e))
        my_db.close()
        raise e
def execute_mysql_fetchall_generic_2_args(my_db,my_cursor,log,mysql,v1=None,v2=None):
    sleep(0.05)
    tmp_rows = []
    if v1 is None:
        return tmp_rows
    v2_was_null = False
    if v1 == 'null':
        v1 = None
    if v2 == 'null':
        v2_was_null = True
        v2 = None
    try:
        if v2 is None and not v2_was_null:
            my_cursor.execute(mysql,([v1]))
        else:
            my_cursor.execute(mysql,(v1,v2))
        tmp_rows = my_cursor.fetchall()
        if tmp_rows:
            return tmp_rows
        else:
            tmp_rows = []
            return tmp_rows
    except Exception as e:
        log("execute_mysql_fetchall_complex_generic ", as_unicode(e))
        my_db.close()
        log("database has been CLOSED")
        raise e
def execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql):
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except Exception as e:
        log("execute_mysql_with_commit_generic: " + as_unicode(e))
        my_db.close()
        log("database has been CLOSED")
        raise e
    sleep(0.05)
def execute_mysql_for_custom_column_generic_1_arg(my_db,my_cursor,log,mysql,v1=None):
    global freeze_current_book
    if 'book' in mysql and ('INSERT' in mysql or 'future_use' in mysql):
        freeze_current_book = True
    s1 = ""
    if v1 == None:
        s1 = "IGNORE"
    if v1 == 'null':
        v1 = None
    try:
        my_cursor.execute("begin")
        if s1 == "IGNORE":
            my_cursor.execute(mysql)
        else:
            my_cursor.execute(mysql,([v1]))
        my_cursor.execute("commit")
    except Exception as e:
        e = as_unicode(e)
        log("execute_mysql_for_custom_column_generic_1_arg: " + e )
        my_db.close()
        log("database has been CLOSED")
        raise e
    sleep(0.05)
def execute_mysql_for_custom_column_generic_2_args(my_db,my_cursor,log,mysql,v1=None,v2=None):
    global freeze_current_book
    if 'book' in mysql and ('INSERT' in mysql or 'future_use' in mysql):
        freeze_current_book = True
    s2 = ""
    if v2 == "" or v2 is None:     
        s2 = "IGNORE"
    if v1 == 'null':
        v1 = None
    if v2 == 'null':
        v2 = None
    try:
        my_cursor.execute("begin")
        if s2 != "IGNORE":
            my_cursor.execute(mysql,(v1,v2))
        else:
            my_cursor.execute(mysql,([v1]))
        my_cursor.execute("commit")
    except Exception as e:
        log("execute_mysql_with_commit_generic_2_arg: " + as_unicode(e))
        my_db.close()
        log("database has been CLOSED")
        raise e
    sleep(0.05)
