# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "3.6.122"    # Remove DDC/LCC functionality; use Library Codes plugin instead.

from qt.core import (Qt, QDialog, QLabel, QVBoxLayout, QHBoxLayout, QFormLayout, QWidget, QPushButton,
        QGridLayout, pyqtSignal, QDialogButtonBox, QScrollArea, QFont, QPalette, QColor, QCheckBox,
        QTabWidget, QIcon, QToolButton, QSplitter, QGroupBox, QSpacerItem, QLineEdit,QSpinBox,
        QSizePolicy, QFrame, QSize, QKeySequence, QMenu, QShortcut, QMargins)

from polyglot.builtins import as_unicode

from calibre.utils.config import JSONConfig

# This is where all preferences for this plugin will be stored
prefs = JSONConfig('plugins/quarantine_and_scrub')

# Set defaults
prefs.defaults['pristine_library'] = "S:/Users/Public/Public eBooks/CalibreMain/metadata.db"
prefs.defaults['maximum_tags'] = "10"
prefs.defaults['ignore_award_tags'] = "True"
prefs.defaults['qs_library_best_rules'] = "S:/Users/Public/Public eBooks/QuarantineAndScrub/metadata.db"
prefs.defaults['qs_library_1'] = "S:/Users/Public/Public eBooks/QuarantineAndScrub_prescrub/metadata.db"
prefs.defaults['qs_library_2'] = "S:/Users/Public/Public eBooks/QuarantineAndScrub_postscrub/metadata.db"
prefs.defaults['qs_library_3'] = "none"
prefs.defaults['qs_library_4'] = "none"
prefs.defaults['genre'] = "#genre"
prefs.defaults['ddc'] = "#none"   #deprecated
prefs.defaults['lcc'] = "#none"     #deprecated
prefs.defaults['classify'] = "False"     #deprecated
prefs.defaults['pseudonyms'] = "#none"

prefs.defaults['FICTIONDB_USERNAME'] = ""
prefs.defaults['FICTIONDB_PASSWORD'] = ""

class ConfigWidget(QWidget):
    #how this is invoked directly from the plugin menu:    self.conf_button.clicked.connect(self.config)  in configdialog.py     connecting to:     self.config  in ui.py
    #this ConfigWidget widget is invoked directly from Calibre > Preferences > Plugins > Customize Plugin  (without anything to do with configdialog.py)

    def __init__(self):

        QWidget.__init__(self)

        self.layout_1 = QVBoxLayout()
        self.setLayout(self.layout_1)

        self.layout_1.setSpacing(0)
        self.layout_1.setContentsMargins(QMargins(0,0,0,0));

        self.paths_groupbox = QGroupBox('Paths')
        self.layout_1.addWidget(self.paths_groupbox)          #groupbox now a child of the layout_1, QVBoxLayout()

        self.paths_layout = QGridLayout()
        self.paths_groupbox.setLayout(self.paths_layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(8)

        self.label1 = QLabel()
        self.label1.setTextFormat(Qt.RichText)
        self.label1.setText("<center><font color='#0404B4'>Enter the Full Path of Your Pristine Calibre Library, Including metadata.db</font></center>")
        self.label1.setFont(font)
        self.paths_layout.addWidget(self.label1)

        font.setBold(False)
        font.setPointSize(8)

        self.msg1 = QLineEdit(self)
        self.msg1.setText(prefs['pristine_library'])
        self.paths_layout.addWidget(self.msg1)
        self.label1.setBuddy(self.msg1)

        self.label3 = QLabel()
        self.label3.setTextFormat(Qt.RichText)
        self.label3.setText("<br><center><font color='#0404B4'>Q&&S Library with the Best Tag && Title Rules and Web Source Series Validation Data (WSSVD)</font></center>")
        self.label3.setFont(font)
        self.paths_layout.addWidget(self.label3)


        self.msg3 = QLineEdit(self)
        self.msg3.setText(prefs['qs_library_best_rules'])
        self.paths_layout.addWidget(self.msg3)
        self.label3.setBuddy(self.msg3)


        self.label4 = QLabel()
        self.label4.setTextFormat(Qt.RichText)
        self.label4.setText("<br><center><font color='#0404B4'>Q&&S Target Library # [1][2][3][4] for Tag && Title Rules and WSSVD</font></center>")
        self.label4.setFont(font)
        self.paths_layout.addWidget(self.label4)


        self.msg4 = QLineEdit(self)
        self.msg4.setText(prefs['qs_library_1'])
        self.paths_layout.addWidget(self.msg4)

        self.label4.setBuddy(self.msg4)

        self.msg5 = QLineEdit(self)
        self.msg5.setText(prefs['qs_library_2'])
        self.paths_layout.addWidget(self.msg5)


        self.msg6 = QLineEdit(self)
        self.msg6.setText(prefs['qs_library_3'])
        self.paths_layout.addWidget(self.msg6)


        self.msg7 = QLineEdit(self)
        self.msg7.setText(prefs['qs_library_4'])
        self.paths_layout.addWidget(self.msg7)


        self.misc_groupbox = QGroupBox('Miscellaneous')
        self.layout_1.addWidget(self.misc_groupbox)          #groupbox now a child of the layout_1, QVBoxLayout()

        self.misc_layout = QGridLayout()
        self.misc_groupbox.setLayout(self.misc_layout)

        #......................................................


        font.setBold(False)
        font.setPointSize(8)

        self.label2 = QLabel()
        self.label2.setTextFormat(Qt.RichText)
        self.label2.setText("<br><center><font color='#0404B4'>maximum number of work tags to allow via tag priorities</font></center>")
        self.label2.setFont(font)
        self.misc_layout.addWidget(self.label2)

        self.max_tags_spin = QSpinBox(self)
        self.max_tags_spin.setMinimum(1)
        self.max_tags_spin.setMaximum(100)
        self.max_tags_spin.setProperty('value',prefs['maximum_tags'])
        self.misc_layout.addWidget(self.max_tags_spin,0,0)   #row 0 column 0

        self.label2.setBuddy(self.max_tags_spin)

        self.awards_checkbox = QCheckBox('Minimize Tags Job Should Ignore Tags Derived from Table Book Awards?')                     # self.awards_checkbox.isChecked()
        self.misc_layout.addWidget(self.awards_checkbox)
        if prefs['ignore_award_tags'] == "True":
            self.awards_checkbox.setChecked(1)
        else:
            self.awards_checkbox.setChecked(0)


        #......................................................


        self.label8 = QLabel()
        self.label8.setTextFormat(Qt.RichText)
        self.label8.setText("<br><center><font color='#0707B7'>Q&&S Derive Genres: Custom Column Lookup/Search #Name to Update</font></center>")
        self.label8.setFont(font)
        self.misc_layout.addWidget(self.label8)

        self.msg8 = QLineEdit(self)
        self.msg8.setText(prefs['genre'])
        self.misc_layout.addWidget(self.msg8)

        self.label8.setBuddy(self.msg8)


        #~ self.label9 = QLabel()
        #~ self.label9.setTextFormat(Qt.RichText)
        #~ self.label9.setText("<br><center><font color='#0707B7'>Dewey Decimal Code:  Custom Column Lookup/Search #Name to Update</font></center>")
        #~ self.label9.setFont(font)
        #~ self.misc_layout.addWidget(self.label9)

        #~ self.msg9 = QLineEdit(self)
        #~ self.msg9.setText(prefs['ddc'])
        #~ self.misc_layout.addWidget(self.msg9)

        #~ self.label9.setBuddy(self.msg9)


        #~ self.label10 = QLabel()
        #~ self.label10.setTextFormat(Qt.RichText)
        #~ self.label10.setText("<br><center><font color='#0707B7'>Library of Congress Code:  Custom Column Lookup/Search #Name to Update</font></center>")
        #~ self.label10.setFont(font)
        #~ self.misc_layout.addWidget(self.label10)

        #~ self.msg10 = QLineEdit(self)
        #~ self.msg10.setText(prefs['lcc'])
        #~ self.misc_layout.addWidget(self.msg10)

        #~ self.label10.setBuddy(self.msg10)


        #~ self.classify_checkbox = QCheckBox('Activate DDC/LCC Classification?')                     # self.classify_checkbox.isChecked()
        #~ self.misc_layout.addWidget(self.classify_checkbox)
        #~ if prefs['classify'] == "True":
            #~ self.classify_checkbox.setChecked(1)
        #~ else:
            #~ self.classify_checkbox.setChecked(0)

        self.label11 = QLabel()
        self.label11.setTextFormat(Qt.RichText)
        self.label11.setText("<br><center><font color='#0707B7'>Author Pseudonyms:  'People' Custom Column Lookup/Search #Name to Update</font></center>")
        self.label11.setFont(font)
        self.misc_layout.addWidget(self.label11)

        self.msg11 = QLineEdit(self)
        self.msg11.setText(prefs['pseudonyms'])
        self.misc_layout.addWidget(self.msg11)

        self.label11.setBuddy(self.msg11)

        self.resize(self.sizeHint())


    def save_settings(self):
        prefs['pristine_library'] = as_unicode(self.msg1.text())
        prefs['maximum_tags'] = int(as_unicode(self.max_tags_spin.value()))
        prefs['qs_library_best_rules'] = as_unicode(self.msg3.text())
        prefs['qs_library_1'] = as_unicode(self.msg4.text())
        prefs['qs_library_2'] = as_unicode(self.msg5.text())
        prefs['qs_library_3'] = as_unicode(self.msg6.text())
        prefs['qs_library_4'] = as_unicode(self.msg7.text())
        prefs['genre'] = as_unicode(self.msg8.text())
        #~ prefs['ddc'] = as_unicode(self.msg9.text())     #deprecated
        #~ prefs['lcc'] = as_unicode(self.msg10.text())    #deprecated
        #~ prefs['classify'] = as_unicode(self.classify_checkbox.isChecked())      #deprecated
        prefs['ignore_award_tags'] = as_unicode(self.awards_checkbox.isChecked())
        prefs['pseudonyms'] = as_unicode(self.msg11.text())

    def validate(self):
        return True

#END of config.py
