# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "3.6.121"   
import os, sys, apsw, ast
from copy import deepcopy
from time import sleep
from calibre import isbytestring
from calibre.constants import iswindows, filesystem_encoding, DEBUG
from calibre.utils.logging import Log as log
from polyglot.builtins import as_bytes, as_unicode, unicode_type
from polyglot.queue import Queue
from calibre_plugins.quarantine_and_scrub.config import prefs
from calibre_plugins.quarantine_and_scrub.titlecase import titlecase
from calibre_plugins.quarantine_and_scrub.booklevel import  (explode_custom_column_8_if_needed,
                                                                                                      remove_all_double_quotes)
from calibre_plugins.quarantine_and_scrub.heading import log_heading_common
from calibre_plugins.quarantine_and_scrub.sqlobjects_global_authors import add_global_authors
from calibre_plugins.quarantine_and_scrub.convert_types_to_other_types import (qs_standardize_any_string,
                                                            qs_convert_list_of_nominal_book_ids_to_integers, qs_standardize_string_numerics)
from calibre_plugins.quarantine_and_scrub.debug_nicely import debug_nicely
myquotes = "\""
mysinglequote = "\'"
mynothing = ""
mynull = None
my_terminate_early = False
notifications = Queue()
my_current_book_id = "000000"
my_book_ids = []
scrubbed_books_final = {}
c_work_author_table = "custom_column_4"       
l_work_author_table = "books_custom_column_4_link"  
c_work_title_table = "custom_column_8"  
l_work_title_table = "books_custom_column_8_link"  
valid_global_authors = False
list_of_known_authors = []
list_of_known_books = []
list_of_known_books_swapped_author = []
my_re = None
re_already_imported = False
book_title_list = []
global_dict1 = {}
global_dict2 = {}
global_dict3 = {}
global_dict4 = {}
header_s1 = None
header_s2 = None
header_s3 = None
header_s4 = None
header_s5 = None
def main_scrub_author_level(self, guidb, book_ids, scrubbed_books_final, log=None, abort=None, notifications=True):
    global header_s1
    global header_s2
    global header_s3
    global header_s4
    global header_s5
    global my_terminate_early
    global mynothing
    global my_book_ids
    global scrubbed_books_final_list
    scrubbed_books_final_list = []
    notifications.put((0.002, 'Beginning Author-Level Scrubbing'))
    my_book_ids = deepcopy(book_ids)
    del book_ids
    path = guidb.library_path
    if isbytestring(path):
        path = path.decode(filesystem_encoding)
    path = path.replace(os.sep, '/')
    path = os.path.join(path, 'metadata.db')
    path = path.replace(os.sep, '/')
    log("Library DB: " + path)
    try:
        my_db =apsw.Connection(path)
    except Exception as e:
        log(as_unicode(e))
        raise e
        return
    my_cursor = my_db.cursor()
    header_s1 = "SQLite Version: " +as_unicode(apsw.SQLITE_VERSION_NUMBER) + "  [APSW]"
    mysql = "PRAGMA main.locking_mode=EXCLUSIVE;"
    my_cursor.execute(mysql)
    header_s2 = mysql
    header_s3 = "Beginning Author Level Scrubbing"
    log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
    mysql = "PRAGMA main.busy_timeout = 5000;"     
    my_cursor.execute(mysql)
    global my_re
    global re_already_imported
    if not re_already_imported:
        import re
        my_re = re
        del re
        re_already_imported = True
        test_utility = qs_standardize_any_string("não-ficção")
        if not test_utility == "não-ficção":
            log("não-ficção was returned as: " + test_utility)
    add_global_authors(my_db, my_cursor, log)    
    delete_invalid_global_authors(my_db, my_cursor, log)
    create_sqlite_user_functions(my_db, my_cursor, log)
    __reformat_author_initials(my_db, my_cursor, log)
    update_global_author_sorts(my_db, my_cursor, log)
    sleep(0.1)
    update_global_author_links(my_db, my_cursor, log)
    sleep(0.1)
    delete_invalid_global_authors(my_db, my_cursor, log)
    sleep(0.1)
    scrub_control(my_db, my_cursor, my_book_ids, notifications, log,scrubbed_books_final)
    my_db.close()
    sleep(0)
    log("Job complete.")
    return scrubbed_books_final
def scrub_control(my_db, my_cursor,  my_book_ids, notifications, log, scrubbed_books_final):
    my_book_ids = None 
    scrubbed_books_final = {}
    delete_unused_values(my_db,my_cursor,notifications,log)
    remove_all_double_quotes(my_db,my_cursor,notifications,log)
    titlecase_authors(my_db,my_cursor,notifications,log)
    explode_custom_column_4_if_needed(my_db, my_cursor, log)   
    explode_custom_column_8_if_needed(my_db, my_cursor, log)   
    explode_custom_column_10_if_needed(my_db, my_cursor, log)  
    s_abort_execution = count_auth_ok_usage(my_db, my_cursor, log)
    if s_abort_execution == "FALSE":
        count_global_authors_series(my_db, my_cursor, log)
        author_level_scrub_control(my_db,my_cursor,notifications,log)
        delete_unused_values(my_db,my_cursor,notifications,log)
    else:
        for x in range(1,20):
            log("<font color='#FF0000'>This job cannot be run a second time for the same set and statuses of Work Data.  Recopy all Real Data to Work Data first.</font>")
    if s_abort_execution == "TRUE":
        notifications.put((0.99, 'TERMINATING DUE TO ERROR: SEE LOG'))
        sleep(5.0)
    mysql = "SELECT Count(*),'dummy' FROM __book_real_and_work_comparison WHERE (realtitle != worktitle OR realauthor != workauthor) \
                    AND (book NOT IN(SELECT book FROM __books_work_status WHERE value = 'book_ok' )) "
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        tmp_list = []
    if len(tmp_list) == 0:
        count1 = 0
    else:
        count1 = 0
        for row in tmp_list:
            count1,dummy = row
    log(" ")
    log(" ")
    log("Total Number of  Books with Authors and/or Titles Just Changed:  ",as_unicode(count1))
    log(" ")
    log(" ")
    return scrubbed_books_final
def author_level_scrub_control(my_db,my_cursor,notifications,log):
    notifications.put((0.01, 'Beginning Analysis of All Authors and Titles'))
    mysql = "SELECT Count(*),'dummy' FROM books "
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        tmp_list = []
    if len(tmp_list) == 0:
        count1 = 0
    else:
        count1 = 0
        for row in tmp_list:
            count1,dummy = row
    log("Number of books: " +as_unicode(count1))
    if count1 == "0":
        return
    mysql = "SELECT Count(*),'dummy' FROM books_custom_column_4_link WHERE book NOT NULL"
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        tmp_list = []
    if len(tmp_list) == 0:
        count1 = 0
    else:
        count1 = 0
        for row in tmp_list:
            count1,dummy = row
    log("Number of books with a Work Author: " +as_unicode(count1))
    if count1 == 0:
        return
    mysql = "SELECT Count(*),'dummy' FROM __books_work_status WHERE value = 'book_ok' "
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        tmp_list = []
    if len(tmp_list) == 0:
        count1 = 0
    else:
        count1 = 0
        for row in tmp_list:
            count1,dummy = row
    log("Number of books with a Status of 'book_ok': " +as_unicode(count1))
    mysql = "SELECT Count(*),'dummy' FROM __books_work_status WHERE value = 'dirty' "
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        tmp_list = []
    if len(tmp_list) == 0:
        count1 = 0
    else:
        count1 = 0
        for row in tmp_list:
            count1,dummy = row
    log("Number of books with a Status of 'dirty': " +as_unicode(count1))
    if count1 == 0:
        return
    notifications.put((0.01, 'Please Be Patient While All Titles and Authors Are Compared to All Global Authors and Pristine Authors In All Of Their Permutations'))
    log(" ")
    log("<font size='4'><b><font color='#0000FF'>'New' Valid Real Authors Must Be Added to the Pristine Author Table Prior to Author Level Scrubbing.</b></font>")
    log("<font size='4'><b><font color='#0000FF'>'New' Valid Real Authors Are Not Already Global Authors and Not Already Pristine Authors.</b></font>")
    log("<font size='4'><b><font color='#0000FF'>Calibre>Q&S>[Menu] Q&S Copy Work to Real > Copy Valid Real Authors to Q&S Pristine Author Validation Table [Selected Books] </b></font>")
    log("<font size='4'><b><font color='#0000FF'>Be certain to select only truly valid Real Authors to copy to the  Q&S Pristine Author Validation Table.</b></font>")
    log(" ")
    scrub_author_in_author_but_split_in_two(my_db,my_cursor,notifications,log)  
    scrub_author_in_title_but_split_in_two(my_db,my_cursor,notifications,log)
    scrub_author_title_reversed(my_db,my_cursor,notifications,log)      
    scrub_author_in_author_with_nonauthor(my_db,my_cursor,notifications,log)
    scrub_final_author_in_final_title(my_db,my_cursor,notifications,log)
    rename_authors_per_mapping_rules(my_db,my_cursor,notifications,log)  
    global mynothing
    global list_of_known_books_swapped_author
    global list_of_known_authors
    list_of_known_authors = []
    std_author = ""
    sleep(1.0)
    notifications.put((0.51, 'Selecting Global Authors'))
    log(" ")
    log(" ")
    log("Biographies & Autobiographies (per Work Tags) are ignored due to inability to accurately distinguish between Author and the Subject Person.")
    log(" ")
    mysql = "SELECT name,'dummy' from _global_authors  ;"
    tmp_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql,book=None)
    if not tmp_rows:
        pass 
    else:
        for row in tmp_rows:
            std_author,dummy = row
            if not std_author > " ":
                continue
            else:
                if len(std_author) > 8: 
                    list_of_known_authors.append(std_author)
    list_of_known_authors = list(set(list_of_known_authors))
    notifications.put((0.52, 'Selecting Pristine Authors'))
    tmp_rows = []
    del tmp_rows
    std_author = ""
    mysql = "SELECT name,'dummy' from _pristine_authors  ;"
    tmp_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql,book=None)
    if not tmp_rows:
        pass 
    else:
        if len(tmp_rows) == 0:
            pass
        else:
            for row in tmp_rows:
                std_author,dummy = row
                if not std_author > " ":
                    continue
                else:
                    if len(std_author) > 8: 
                        list_of_known_authors.append(std_author)
        list_of_known_authors = list(set(list_of_known_authors))
    notifications.put((0.53, 'Making a List of Books'))
    create_book_title_list(my_db,my_cursor,notifications,log)
    notifications.put((0.55, 'Identifying Remaining Titles Containing Authors'))
    make_list_of_known_books_swapped_author(my_db,my_cursor,notifications,log)
    try:
        n1 = len(list_of_known_books_swapped_author)
        if n1 < 1 :
            titlecase_authors(my_db,my_cursor,notifications,log)
        else:
            notifications.put((0.80, 'Fixing Swapped Authors/Titles Etc.'))
            swap_author_title(my_db,my_cursor,notifications,log)
            titlecase_authors(my_db,my_cursor,notifications,log)
        return
    except:
        return
def make_list_of_known_books_swapped_author(my_db,my_cursor,notifications,log):
    global mynothing
    global list_of_known_authors
    global list_of_known_books_swapped_author
    global global_dict1
    global global_dict2
    global global_dict3
    global global_dict4
    list_of_known_books_swapped_author = []
    global_dict1 = {}
    global_dict2 = {}
    global_dict3 = {}
    global_dict4 = {}
    for row in list_of_known_authors:  
        tmp_value = row            
        tmp_rows = search_title(tmp_value)
        if not tmp_rows:
            continue
        else:
            for tmp_book in tmp_rows:
                tmp_book = qs_standardize_string_numerics(tmp_book,return_integer=True)
                list_of_known_books_swapped_author.append(tmp_book)
                global_dict1[tmp_book] = tmp_value
            del tmp_rows
    for row in list_of_known_authors:  
        tmp_value = row
        try:
            s = tmp_value.split(" ")
            s1 = s[0]
            s2 = s[1]
            s1 = s1.strip()
            s2 = s2.strip()
            tmp_value = s2 + "," + s1     
            tmp_rows = search_title(tmp_value)
            if not tmp_rows:
                continue
            else:
                for row in tmp_rows:
                    tmp_book = row
                    tmp_book = qs_standardize_string_numerics(tmp_book,return_integer=True)
                    list_of_known_books_swapped_author.append(tmp_book)
                    global_dict2[tmp_book] = tmp_value
                del tmp_rows
        except:
            pass
    for row in list_of_known_authors:  
        tmp_value = row
        try:
            s = tmp_value.split(" ")
            s1 = s[0]
            s2 = s[1]
            s1 = s1.strip()
            s2 = s2.strip()
            tmp_value = s2 + ", " + s1 
            tmp_rows = search_title(tmp_value)
            if not tmp_rows:
                continue
            else:
                for row in tmp_rows:
                    tmp_book = row
                    tmp_book = qs_standardize_string_numerics(tmp_book,return_integer=True)
                    list_of_known_books_swapped_author.append(tmp_book)
                    global_dict3[tmp_book] = tmp_value
                del tmp_rows
        except:
            pass
    for row in list_of_known_authors:  
        tmp_value = row            
        tmp_value = tmp_value.strip()
        s0 = tmp_value.replace(" ", ".")
        tmp_value = tmp_value.replace(" ", "\.")
        tmp_rows = search_title(tmp_value)
        if not tmp_rows:
            continue
        else:
            for row in tmp_rows:
                tmp_book = row
                tmp_book = qs_standardize_string_numerics(tmp_book,return_integer=True)
                list_of_known_books_swapped_author.append(tmp_book)
                global_dict4[tmp_book] = s0
            del tmp_rows
    list_of_known_books_swapped_author = list(set(list_of_known_books_swapped_author))
def search_title(tmp_value):
    global book_title_list
    global my_re
    global re_already_imported
    if not re_already_imported:
        import re
        my_re = re
        del re
        re_already_imported = True
    tmp_rows = []
    tmp_value = tmp_value
    ns = tmp_value.count(" ")
    nc = tmp_value.count(",")
    nd = tmp_value.count("\.")
    if ns == 0 and nc == 0 and nd == 0:
        return None
    n_forever_jack = tmp_value.count(", ") 
    n_length = len(tmp_value)
    if n_length < 9 and n_forever_jack > 0: 
        return None
    tmp_value = tmp_value.replace("|", " ") 
    n = tmp_value.count("\.") 
    if n > 0:
        pass
    else:
        tmp_value = tmp_value.replace(".", mynothing) 
    tmp_value = tmp_value.replace("MD", mynothing)
    tmp_value = tmp_value.replace("PhD", mynothing)
    tmp_value = tmp_value.replace("PHD", mynothing)
    tmp_value = tmp_value.replace("  ", "")
    tmp_value = tmp_value.strip()
    my_re1 = tmp_value
    p1 = my_re.compile(my_re1, my_re.IGNORECASE)
    for row in book_title_list:
        s = row
        match1 = p1.search(s)
        if match1:
            s_list = s.split("^")
            s1 = s_list[0]
            tmp_rows.append(s1)
    n = len(tmp_rows)
    if not n > 0:
        tmp_rows = None
    return tmp_rows
def create_book_title_list(my_db,my_cursor,notifications,log):
    global book_title_list
    global mynothing
    book_title_list = []
    mysql = "SELECT book, booktitle FROM __books_work_populate WHERE tagsall NOT LIKE '%biograph%' "
    tmp_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql,book=None)
    for row in tmp_rows:
        book, title = row
        book = as_unicode(book)
        title = title.replace("|", "")
        title = title.replace(",  ", ", ")
        title = title.replace("  ", "")
        s2 = book + "^" + title
        book_title_list.append(s2)
    del tmp_rows
    book_title_list = list(set(book_title_list))
    book_title_list.sort()
def swap_author_title(my_db,my_cursor,notifications,log):
    global mynothing
    global list_of_known_authors
    global list_of_known_books_swapped_author
    global global_dict1
    global global_dict2
    global global_dict3
    global global_dict4
    global my_re
    global re_already_imported
    if not re_already_imported:
        import re
        my_re = re
        del re
        re_already_imported = True
    n0 = len(list_of_known_books_swapped_author)
    if n0 == 0:
        return
    log("Additional Author-in-Title Scrubbing will now be performed.")
    n1 = 0
    for row in list_of_known_books_swapped_author:
        n1 = n1 + 1
        n2 = float(n1/n0)
        pc = float((.2* n2) + .80)
        notifications.put((pc, 'Fixing Swapped Authors/Titles'))
        if not isinstance(my_current_book,int):
            my_current_book = int(row)
        sleep(0)
        mysql = "SELECT authname,'dummy' from __books_work_populate WHERE book = ?"
        tmp_auth_rows = execute_mysql_fetchall_generic(my_db,my_cursor,log,mysql,my_current_book)
        if not tmp_auth_rows:
            continue
        if len(tmp_rows) == 0:
            tmp_auth = "Unknown"
        else:
            tmp_auth,dummy = tmp_auth_rows[0]
        mysql = "SELECT booktitle FROM __books_work_populate WHERE book = ? "
        tmp_title_rows = execute_mysql_fetchall_generic(my_db,my_cursor,log,mysql,my_current_book)
        if not tmp_title_rows:
            continue
        else:
            tmp_title = tmp_title_rows[0]
            tmp_title = qs_standardize_any_string(tmp_title)
            tmp_title = tmp_title.replace(",", mynothing)
        re_1 = "^[a-z ]+[']s\s[a-z ]+$"                                     
        p = my_re.compile(re_1, my_re.IGNORECASE)
        match1 = p.search(tmp_title)
        if match1:
            continue
        try:
            m1 = global_dict1[my_current_book]
        except:
            m1 = None
        try:
            m2 = global_dict2[my_current_book]
        except:
            m2 = None
        try:
            m3 = global_dict3[my_current_book]
        except:
            m3 = None
        try:
            m4 = global_dict4[my_current_book]
        except:
            m4 = None
        if (not m1) and (not m2) and (not m3) and (not m4):
            continue
        new_auth = "ERROR" 
        tmp_title = tmp_title.replace("|","")
        if m1:
            if m1 !=  mynothing and m1 > "":
                m1 = qs_standardize_any_string(m1)
                m1 = m1.strip()
                tmp_title = tmp_title.replace(m1, mynothing)
                new_auth = m1
            else:
                continue
        else:
            if m2:
                if m2 != mynothing and m2 > " ":
                    m2 = qs_standardize_any_string(m2)
                    m2 = m2.strip()
                    tmp_title = tmp_title.replace(m2, mynothing)
                    new_auth = m2
                else:
                    continue
            else:
                if m3:
                    if m3 != mynothing and m3 > " ":
                        m3 = qs_standardize_any_string(m3)
                        m3 = m3.strip()
                        tmp_title = tmp_title.replace(m3, mynothing)
                        new_auth = m3
                    else:
                        continue
                else:
                   if m4:
                        if m4 != mynothing and m4 > " ":
                            m4 = qs_standardize_any_string(m4)
                            m4 = m4.strip()
                            tmp_title = tmp_title.replace(m4, mynothing)
                            new_auth = m4
                        else:
                            continue
                   else:
                        continue
        tmp_title = tmp_title.strip()
        tmp_auth = tmp_auth.strip()
        s = tmp_auth
        s = s.replace(",", " ")
        tmp_title = tmp_title.replace(tmp_auth, mynothing)
        tmp_title = tmp_title.replace(s, mynothing)
        tmp_title = tmp_title.strip()
        s_separator = " "
        n_colona = tmp_auth.count(":")
        n_dasha = tmp_auth.count("-")
        n_colont = tmp_title.count(":")
        n_dasht = tmp_title.count("-")
        if n_colont > 0: s_separator = " : "
        else:
            if n_dasht > 0: s_separator = " - "
            else:
                if n_colona > 0: s_separator = " : "
                else:
                    if n_dasha > 0: s_separator = " - "
        new_title = tmp_auth + s_separator + tmp_title 
        s = new_auth
        s = s.replace(",", mynothing)
        new_title = new_title.replace(new_auth, mynothing)
        new_title = new_title.replace(s, mynothing)
        new_title = new_title.replace("--", "- ")
        new_title = new_title.replace("- -", "- ")
        new_title = new_title.replace("-  -", "- ")
        new_title = new_title.replace(": :", ": ")
        new_title = new_title.replace(":  :", ": ")
        new_title = new_title.replace("|", "")
        new_title = new_title.strip()
        if new_title.startswith("-") or new_title.startswith(":"):
            new_title = new_title[1: ]
            new_title = new_title.strip()
        if new_title.endswith("-") or new_title.endswith(":"):
            new_title = new_title[0:-1]
            new_title = new_title.strip()
        new_title = new_title.replace("|", ",")
        if new_auth == mynothing or (not new_auth > " "):
            continue
        new_auth = new_auth.replace(".", " ") 
        if new_title.startswith("Unknown"):
            new_title = new_title.replace("Unknown", mynothing) 
            new_title = new_title.strip()
        mysql = "SELECT id,'dummy' from custom_column_4 WHERE value = ?"
        tmp_id_rows = execute_mysql_fetchall_generic(my_db,my_cursor,log,mysql,new_auth)
        if tmp_id_rows:
            sleep(.05)
            tmp_id,dummy = tmp_id_rows[0]
            mysql = "DELETE FROM books_custom_column_4_link WHERE book = ? "
            execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=my_current_book)
            mysql = "INSERT INTO books_custom_column_4_link (id,book,value) VALUES (null,?,?) "
            execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=my_current_book,value=tmp_id)
        else:
            sleep(.05)
            mysql = "INSERT OR IGNORE INTO custom_column_4 (id,value,link) VALUES (null, ?,'')"
            execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None,value=new_auth)
            sleep(.1)
            mysql = "SELECT id from custom_column_4  WHERE value = ? "
            tmp_auth_rows = execute_mysql_fetchall_generic(my_db,my_cursor,log,mysql,new_auth)
            if not tmp_auth_rows:
                continue
            else:
                tmp_id = tmp_auth_rows[0]
                tmp_id = qs_standardize_string_numerics(tmp_id,return_integer=True)
            sleep(.1)
            mysql = "DELETE FROM books_custom_column_4_link WHERE book = ? "
            execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,v1=my_current_book)
            sleep(0)
            mysql = "INSERT  INTO books_custom_column_4_link (id, book, value) VALUES (null,?,?)  "
            execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=my_current_book,v2=tmp_id,v1_is_first=True)
        sleep(0)
        mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;'
        execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=my_current_book,v2=new_title,v1_is_first=False)
        mysql = "SELECT id,'dummy'  FROM custom_column_18 WHERE value = 'auth_ok' "
        tmp_id_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql,book=None)
        if not tmp_id_rows:
            sleep(0)
            mysql = "INSERT OR IGNORE INTO custom_column_18 (id,value,link) VALUES (null, 'auth_ok','') "
            execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
            sleep(0)
            mysql = "SELECT id,'dummy'  FROM custom_column_18 WHERE value = 'auth_ok' "
            tmp_id_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql,book=None)
        if not tmp_id_rows:
            continue
        tmp_id,dummy = tmp_id_rows[0]
        sleep(.1)
        mysql = "DELETE FROM books_custom_column_18_link WHERE book = ? AND book > ?"
        execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=my_current_book,v2=0,v1_is_first=True)
        sleep(.1)
        mysql = "INSERT OR REPLACE INTO books_custom_column_18_link (id,book,value) VALUES (null,?,?) "
        execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=my_current_book,v2=tmp_id,v1_is_first=True)
        sleep(.1)
        clear_work_freeze(my_db, my_cursor, my_current_book, notifications, log)
        scrub_author_good_but_author_also_in_title(my_db, my_cursor,  my_current_book, notifications, log)
def scrub_author_good_but_author_also_in_title(my_db, my_cursor,  my_current_book, notifications, log):
    global mynothing
    global my_re
    global re_already_imported
    if not re_already_imported:
        import re
        my_re = re
        del re
        re_already_imported = True
    mysql = "SELECT authname, booktitle from  __books_work_populate WHERE book = ? "
    tmp_auth_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql,book=my_current_book)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            tmp_auth, tmp_title = row
            break
    else:
        return
    tmp_auth = qs_standardize_any_string(tmp_auth)
    tmp_title = qs_standardize_any_string(tmp_title)
    orig_title = tmp_title
    s_string = as_unicode("scrub_author_good_but_author_also_in_title...[0]prior to update or return:  origtitle:  \
                        " +as_unicode(orig_title) + ">>>>>tmptitle:" +as_unicode(tmp_title) + ">>>>>tmpauth:" +as_unicode(tmp_auth))
    n_orig1 = len(tmp_title)
    re_1 = "^[a-z ]+[']s\s[a-z ]+$"                                     
    p = my_re.compile(re_1, my_re.IGNORECASE)
    match1 = p.search(tmp_title)
    if match1:
        return
    if tmp_title == "Collected Stories of":   
        tmp_title = as_unicode("Collected Stories")
    s_string = as_unicode("scrub_author_good_but_author_also_in_title....[1]prior to update or return:  origtitle:  \
                    " +as_unicode(orig_title) + ">>>>>tmptitle:" +as_unicode(tmp_title) + ">>>>>tmpauth:" +as_unicode(tmp_auth))
    n_orig1 = len(tmp_title)
    tmp_title = tmp_title.replace(tmp_auth, mynothing) 
    tmp_title = tmp_title.strip() 
    a = tmp_auth 
    a_split = a.split(" ")
    n1 = len(a_split)
    if n1 == 2:         
        b = a_split[1] + " " + a_split[0]  
        tmp_title = tmp_title.replace(b, mynothing)
        b = a_split[1] + ", " + a_split[0]  
        tmp_title = tmp_title.replace(b, mynothing)
    else:
        if n1 == 3:    
            b = a_split[2] + " " + a_split[0]  + " " + a_split[1]#  Washington George Burt
            tmp_title = tmp_title.replace(b, mynothing)
            b = a_split[2] + ", " + a_split[0]  + " " + a_split[1]
            tmp_title = tmp_title.replace(b, mynothing)
        else:
            pass
    tmp_title = tmp_title.strip() 
    n_orig2 = len(tmp_title)
    if n_orig1 != n_orig2:
        pass
    else:
        a = tmp_auth 
        t1 = tmp_title.replace(a, mynothing)
        a = a.replace(".",". ") 
        t2 = t1.replace(a, mynothing) 
        a = a.replace(".", mynothing) 
        t3 = t2.replace(a, mynothing) 
        a_split = a.split(" ") 
        for row in a_split:
            a0 = row
            t4 = t3.replace(a0, mynothing) 
            a0 = a0.replace(".", ". ") 
            t5 = t4.replace(a0, mynothing) 
            t6 = t5.replace(". ",mynothing)
            if t6.startswith(","):
                t6 = t6[1: ]
            t6 = t6.strip()
            t3 = t6
        tmp_title = t6
        tmp_title = tmp_title.replace("  ", " ")             
        tmp_title = tmp_title.strip() 
        tmp_title = titlecase(tmp_title)
        tmp_title = tmp_title.strip() 
    if tmp_title == mynothing:
        tmp_title = "_Unknown_"
    if tmp_title.startswith("-") or tmp_title.startswith(":") or tmp_title.startswith(";"):
        tmp_title = tmp_title[1: ]
        tmp_title = tmp_title.strip() 
    s_string = as_unicode("scrub_author_good_but_author_also_in_title....[2]prior to update or return:  origtitle:\
                    " +as_unicode(orig_title) + ">>>>>tmptitle:" +as_unicode(tmp_title) + ">>>>>tmpauth:" +as_unicode(tmp_auth))
    if tmp_title == orig_title or tmp_title == mynothing or (not (tmp_title > " ")):
        return
    tmp_title = qs_standardize_any_string(tmp_title)
    mysql = 'UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;'
    execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=my_current_book,v2=tmp_id,v1_is_first=False)
def execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql,book=None):
    sleep(0.1)
    try:
        if book is None:
            my_cursor.execute(mysql)
        else:
            my_cursor.execute(mysql,([book]))
        tmp_rows = my_cursor.fetchall()
        if tmp_rows:
            return tmp_rows
        else:
            tmp_rows = []
            return tmp_rows
    except:
        sleep(5.0)
        tmp_rows = []
        del tmp_rows
        tmp_rows = []
        try:
            if book is None:
                my_cursor.execute(mysql)
            else:
                my_cursor.execute(mysql,([book]))
            tmp_rows = my_cursor.fetchall()
            if tmp_rows:
                return tmp_rows
            else:
                tmp_rows = []
                return tmp_rows
        except Exception as e:
            log(as_unicode(e))
            my_db.close()
            raise e
def execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None):
    global freeze_current_book
    freeze_current_book = True
    is_book = False
    try:
        my_cursor.execute("begin")
        if book is not None and mysql.count("?") == 1:
            is_book = True
            my_cursor.execute(mysql,([book]))
        else:
            my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except:
        sleep(5.0)
        try:
            if is_book:
                my_cursor.execute(mysql,([book]))
            else:
                my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except Exception as e:
            log(as_unicode(e))
            my_db.close()
            raise e
    sleep(0.03)
def execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql, v1=None, v2=None, v1_is_first=True):
    global freeze_current_book
    freeze_current_book = True
    try:
        my_cursor.execute("begin")
        if v2 is not None:
            if v1_is_first:
                my_cursor.execute(mysql,(v1,v2))
            else:
                my_cursor.execute(mysql,(v2,v1))
        else:
            my_cursor.execute(mysql,(v1))
        my_cursor.execute("commit")
    except:
        log("database locked; sleeping and then will retry")
        sleep(5.0)
        try:
            if v2 is not None:
                my_cursor.execute(mysql,(v1,v2))
            else:
                my_cursor.execute(mysql,(v1))
            my_cursor.execute("commit")
        except Exception as e:
            log(as_unicode(e))
            my_db.close()
            raise e
    sleep(0.03)
def execute_mysql_for_custom_column_generic_3_args(my_db,my_cursor,log,mysql, v1, v2, v3):
    global mynothing
    global freeze_current_book
    freeze_current_book = True
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,(v1,v2,v3))
        my_cursor.execute("commit")
    except Exception as e:
        log(as_unicode(e))
        my_db.close()
        raise e
    sleep(0.03)
def create_sqlite_user_functions(my_db, my_cursor, log):
    global my_terminate_early
    try:
        my_db.createscalarfunction("regexp", sqlite_user_function_3)
    except Exception as e:
        my_terminate_early = True
        log("create_sqlite_user_function [3] failed...cannot proceed...")
    try:
        my_db.createscalarfunction("update_author_sort", sqlite_user_function_5)
    except Exception as e:
        my_terminate_early = True
        log("create_sqlite_user_function [5] failed...cannot proceed...")
    try:
        my_db.createscalarfunction("update_author_link", sqlite_user_function_6)
    except Exception as e:
        my_terminate_early = True
        log("create_sqlite_user_function [6] failed...cannot proceed...")
    try:
        my_db.createscalarfunction("u_rfind", sqlite_user_function_7,2)           
    except Exception as e:
        my_terminate_early = True
        log("create_sqlite_user_function [7] failed...cannot proceed...")
    try:
        my_db.createscalarfunction("u_count", sqlite_user_function_8,2)           
    except Exception as e:
        my_terminate_early = True
        log("create_sqlite_user_function [8] failed...cannot proceed...")
        log(as_unicode(e))
    try:
        my_db.createscalarfunction("reformat_initials", sqlite_user_function_9,1)           
    except Exception as e:
        my_terminate_early = True
        log("create_sqlite_user_function [9] failed...cannot proceed...")
        log(as_unicode(e))
    sleep(1.0)
def sqlite_user_function_3(regexpr,avalue):
    global re_already_imported
    global my_re
    if not re_already_imported:
        import re
        my_re = re
        del re
        re_already_imported = True
    if regexpr:
        if avalue:
            try:
                s_string = avalue
                s_string = qs_standardize_any_string(s_string)
                re_string = regexpr
                re_string = qs_standardize_any_string(re_string)
                p = my_re.compile(re_string, my_re.IGNORECASE)
                match = p.search(s_string)
                if match:
                    return True
                else:
                    return False
            except Exception as e:
                return False
def sqlite_user_function_5(s):
    mynothing = ""
    t = s
    if t is None:
        return s
    else:
        try:
            t = qs_standardize_any_string(t)
            t = t.replace(", Jr.", mynothing)
            t = t.replace(", Jr", mynothing)
            t = t.replace(" Jr.", mynothing)
            t = t.replace(" Jr", mynothing)
            t = t.replace(" II", mynothing)
            t = t.replace(" III", mynothing)
            t = t.replace(" Ph.D.", mynothing)
            n = t.count(" ")
            if n == 0:
                return s
            if n == 1:
                s_split = t.split(" ")
                n = len(s_split)
                if n == 2:
                    firstname = s_split[0]
                    if len(firstname) == 1:
                        firstname = firstname + "."
                    lastname = s_split[1]
                    firstname = firstname.strip()
                    lastname = lastname.strip()
                    ssort = lastname + ", " + firstname
                    ssort = unicode_type(ssort)
                    return ssort
                else:
                    return s
            if n == 2:
                s_split = t.split(" ")
                n1 = len(s_split)
                if n1 == 3:
                    firstname = s_split[0]
                    middlename = s_split[1]
                    lastname = s_split[2]
                    firstname = firstname.strip()
                    if len(firstname) == 1:
                        firstname = firstname + "."
                    middlename = middlename.strip()
                    if len(middlename) == 1:
                        middlename = middlename + "."
                    lastname = lastname.strip()
                    ssort = lastname + ", " + firstname + " " + middlename
                    ssort = unicode_type(ssort)
                    return ssort
                else:
                    return s
            return s
        except Exception as e:
            s_error = as_unicode(e)
            return s_error
            pass
    return s
def sqlite_user_function_6(ssort):
    orig_sort = ssort
    newlink = as_unicode("")
    if ssort is None:
        return 'ERROR[NULL]'
    else:
        try:
            ssort = as_unicode(ssort)
            nc = ssort.count(",")
            ns = ssort.count(" ")
            if nc > 0 and ns == 0:   
                ssort = ssort.replace(",", ", ") 
            if ns == 0: 
                return ("~" + ssort + "~")
            ssort = ssort.replace(",", "")
            s_split = ssort.split(" ")
            n = len(s_split)
            if n == 0 or n == 1:
                return "ERROR[0]"
            if ns == 1:       
                if n == 2:                           
                    s0 = s_split[0]          
                    s0 = s0.strip()
                    s1 = s_split[1]          
                    s1 = s1[0:1] + "."     
                    s1 = s1.strip()
                    newlink = as_unicode("~" + s1 + " " + s0 )                                
                    newlink = newlink +as_unicode("~" + s1 +  s0 + "~")       
                    if newlink > " ":
                        return unicode_type(newlink)
                    else:
                        return "ERROR[1A]"
                else: 
                    return "ERROR[1]"
            if ns == 2:            
                if n == 3:
                    s0 = s_split[0]          
                    s0 = s0.strip()
                    s1 = s_split[1]          
                    s1 = s1[0:1] + "."     
                    s1 = s1.strip()
                    s2 = s_split[2]          
                    s2 = s2[0:1] + "."     
                    s2 = s2.strip()
                    newlink = as_unicode("~" + s1 + " " + s2 + " " + s0)                      
                    newlink = newlink +as_unicode("~" + s1 + s2 + " " + s0)      
                    newlink = newlink +as_unicode("~" + s1 + s2 + s0 + "~")      
                    if newlink > " ":
                        return unicode_type(newlink)
                    else:
                        return "ERROR[2A]"
                else:
                    return "ERROR[2]"
            if ns == 3:    
                if n == 4:
                    s0 = s_split[0]          
                    s0 = s0.strip()
                    s1 = s_split[1]          
                    s1 = s1[0:1] + "."     
                    s1 = s1.strip()
                    s2 = s_split[2]         
                    s2 = s2[0:1] + "."    
                    s2 = s2.strip()
                    s3 = s_split[3]          
                    s3 = s3[0:1] + "."     
                    s3 = s3.strip()
                    newlink = as_unicode("~" + s1 + " " + s2 + " " + s3 + " " + s0)              
                    newlink = newlink +as_unicode("~" + s1 + s2 + s3 + " " + s0)       
                    newlink = newlink +as_unicode("~" + s1+ s2 + s3 + s0 + "~")      
                    if newlink > " ":
                        return unicode_type(newlink)
                    else:
                        return "ERROR[3A]"
                else:
                    return "ERROR[3]"
            if " de " in ssort or " du " in ssort or " von " in ssort:  
                newlink = as_unicode("~" + ssort + "~")
                return unicode_type(newlink)
            else:
                return "ERROR[4]" 
        except Exception as e:
            s_error = as_unicode("ERROR[5]  " + as_unicode(e))
            return s_error
    return "ERROR[6]"
def sqlite_user_function_7(searchedstring,searchforstring):
    if searchedstring is None or searchforstring is None:    
        return 0
    else:
        n = len(searchedstring)
        if n < 4:     
            return 0
        try:
            s = as_unicode(searchedstring)
            s = s.strip()
            t = searchforstring
            ns = s.count(t)
            if ns == 0:
                return 0
            else:
                n = s.rfind(t)
                n = n + 1  
                return n
        except Exception as e:
            return 0
def sqlite_user_function_8(searchedstring,countedstring):
    if searchedstring is None or countedstring is None:    
        return 0
    else:
        try:
            ns = searchedstring.count(countedstring)
            return ns
        except Exception as e:
            return 0
def sqlite_user_function_9(name):
    if name is None:    
        return name
    else:
        try:
            initials_mode = 'A.B.'
            ignore_words = ['von', 'van', 'jr', 'jr.', 'sr', 'sr.', 'st', 'st.', 'ed', 'ed.', 'dr', 'dr.', 'phd', 'ph.d', 'ph.d.']
            ignore_upper_words = ['ii', 'iii']
            ignore_words_map = dict((k,True) for k in ignore_words)
            parts = name.split()
            new_parts = []
            append_to_previous = False
            for tok in parts:
                if len(tok) == 0:
                    continue
                handled = False
                if tok.lower() in ignore_words_map and tok.upper() != tok:
                    pass
                elif tok.lower() in ignore_upper_words:
                    pass
                elif tok.isdigit(): 
                    pass
                elif '.' in tok or (tok.upper() == tok and len(tok) <= 2):
                    if initials_mode == 'A.B.':
                        new_tok = ''
                        for c in tok.replace('.',''):
                            new_tok += c + '.'
                        if append_to_previous:
                            new_parts[-1] = new_parts[-1] + new_tok
                        else:
                            new_parts.append(new_tok)
                            append_to_previous = True
                    else:
                        return name
                    handled = True
                if not handled:
                    new_parts.append(tok)
                    append_to_previous = False
            return ' '.join(new_parts)
        except Exception as e:
            return name
def __reformat_author_initials(my_db, my_cursor, log):
    mysql = "UPDATE OR IGNORE _global_authors SET name =(reformat_initials(name)), sort = '', link = ''  \
                    WHERE name != (reformat_initials(name)) "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "UPDATE OR IGNORE _pristine_authors SET name =(reformat_initials(name)), sort = '', link = ''  \
                    WHERE name != (reformat_initials(name)) "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "UPDATE OR IGNORE _book_awards SET author =(reformat_initials(author))  "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "DELETE FROM _global_authors WHERE name != (reformat_initials(name)) "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "DELETE FROM _pristine_authors WHERE name != (reformat_initials(name)) "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "DELETE FROM _book_awards WHERE author != (reformat_initials(author)) "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
def update_global_author_sorts(my_db, my_cursor, log):
    mysql = "UPDATE _global_authors SET sort = (update_author_sort(name)) WHERE sort NOT LIKE '%, %'  ;"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "UPDATE _pristine_authors SET sort = ' '  ;"                                          
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "UPDATE _pristine_authors SET sort = (update_author_sort(name)) ;"  
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
def update_global_author_links(my_db, my_cursor, log):
    mysql = "UPDATE _global_authors SET link = (update_author_link(sort)) WHERE link NOT LIKE '%~%'  ;"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "UPDATE _global_authors SET link =(link|| substr(sort,1,(instr(sort,', ')- 0 ) )||' '||substr(name,1,1 )||'.'||'~'||substr(sort,1,(instr(sort,', ')- 0 ) )||''||\
                substr(name,1,1 )||'.'||'~'|| substr(sort,1,(instr(sort,',')- 1 ) )|| ' '||substr(name,1,1 )||'.'||'~'|| substr(sort,1,(instr(sort,',')- 1 ) )|| ' '||substr(name,1,1 )||''||' ^' ) \
                WHERE sort LIKE '%,%' AND link NOT LIKE '%^%'  ;"                                     
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "UPDATE _pristine_authors SET link = ' '  ;"                                                  
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "UPDATE _pristine_authors SET link = (update_author_link(sort));"              
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "UPDATE _pristine_authors SET link =(link|| substr(sort,1,(instr(sort,', ')- 0 ) )||' '||substr(name,1,1 )||'.'||'~'||substr(sort,1,(instr(sort,', ')- 0 ) )||''||\
                substr(name,1,1 )||'.'||'~'|| substr(sort,1,(instr(sort,',')- 1 ) )|| ' '||substr(name,1,1 )||'.'||'~'|| substr(sort,1,(instr(sort,',')- 1 ) )|| ' '||substr(name,1,1 )||''||' ^' ) \
                WHERE sort LIKE '%,%' AND link NOT LIKE '%^%'  ;"                                     
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
def explode_custom_column_4_if_needed(my_db, my_cursor, log):
    try:
        mysql = "DELETE FROM custom_column_4 WHERE id > 0 " 
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
        mysql = "DELETE FROM books_custom_column_4_link WHERE id > 0 "
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
        sleep(0.5)
        c_work_author_table = "custom_column_4"       
        mysql = "INSERT OR IGNORE INTO custom_column_4 SELECT book,name,'' FROM __book_author_name_sort WHERE name not null"
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
        l_work_author_table = "books_custom_column_4_link"  
        mysql = "INSERT or IGNORE INTO books_custom_column_4_link SELECT book,book,book FROM __book_author_name_sort "
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
        sleep(0.5)
        mysql = "DELETE FROM books_custom_column_4_link WHERE book IN(SELECT book FROM __books_work_populate \
                                                                                                WHERE authname NOT NULL AND booktitle IS NULL \
                                                                                                AND seriesname  IS NULL AND seriesindex  IS NULL \
                                                                                                AND seriesfull  IS NULL AND tagsall  IS NULL)"
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
        sleep(0.5)
        mysql = "DELETE FROM custom_column_4 WHERE id NOT IN(SELECT value FROM books_custom_column_4_link WHERE id > '0')"
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
        sleep(0.5)
        mysql = "UPDATE custom_column_4 SET value = (SELECT authorname FROM _books_work WHERE book = custom_column_4.id) \
                        WHERE custom_column_4.id IN(SELECT book FROM _books_work WHERE book NOT NULL)"
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
        sleep(0.5)
        mysql = "DELETE FROM _books_work WHERE book NOT NULL"
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
        sleep(0.1)
    except Exception as e:
        raise e
def explode_custom_column_10_if_needed(my_db, my_cursor, log):
    mysql = "INSERT or REPLACE INTO custom_column_10 (id,value,link) SELECT book, seriesname, '' FROM __books_work_populate WHERE seriesname > ' '  ; "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.5)
    mysql = "UPDATE books_custom_column_10_link  SET value = books_custom_column_10_link.book "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.5)
    mysql = "DELETE FROM custom_column_10 WHERE id NOT IN (SELECT value FROM books_custom_column_10_link)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.5)
def delete_unused_values(my_db,my_cursor,notifications,log):
    mysql = 'DELETE FROM custom_column_4 WHERE id IN __author_unused'
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = 'DELETE FROM custom_column_8 WHERE id IN __title_unused'
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = 'DELETE FROM custom_column_10 WHERE id IN __series_unused'
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = 'DELETE FROM custom_column_13 WHERE id IN __tags_unused'
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
def clear_work_freeze(my_db, my_cursor, my_current_book, notifications, log):
    mysql = "DELETE FROM custom_column_16 WHERE book = ? "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=my_current_book)
    sleep(0)
    mysql = "INSERT INTO custom_column_16 (id,book,value) VALUES (null, ?, ?)"
    execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=my_current_book,v2=0,v1_is_first=True)
    sleep(0)
def count_global_authors_series(my_db, my_cursor, log):
    log("===================================")
    log("For Your Reference")
    log("===================================")
    mysql = "SELECT Count(*),'dummy' FROM _global_authors"
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        tmp_list = []
    if len(tmp_list) == 0:
        count1 = 0
    else:
        for row in tmp_list:
            count1,dummy = row
    log("Number of Global Authors:  ",as_unicode(count1))
    mysql = "SELECT Count(*),'dummy' FROM _global_series"
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        tmp_list = []
    if len(tmp_list) == 0:
        count2 = 0
    else:
        for row in tmp_list:
            count2,dummy = row
    log("Number of Global Series:    ",as_unicode(count2))
    mysql = "SELECT Count(*),'dummy' FROM _pristine_authors"
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        tmp_list = []
    if len(tmp_list) == 0:
        count3 = 0
    else:
        for row in tmp_list:
            count3,dummy = row
    log("Number of Pristine Authors:",as_unicode(count3))
    mysql = "SELECT Count(*),'dummy' FROM _pristine_series"
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        tmp_list = []
    if len(tmp_list) == 0:
        count4 = 0
    else:
        for row in tmp_list:
            count4,dummy = row
    log("Number of Pristine Series:  ",as_unicode(count4))
    log("===================================")
    log("===================================")
def count_auth_ok_usage(my_db, my_cursor, log):
    s_abort_execution = as_unicode("FALSE")
    mysql = "SELECT Count(*),'dummy' FROM books_custom_column_18_link WHERE value IN(SELECT id FROM custom_column_18 WHERE value = 'auth_ok' ) "
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        tmp_list = []
    if len(tmp_list) == 0:
        s_abort_execution = as_unicode("TRUE")
    else:
        count1 = 0
        for row in tmp_list:
            count1,dummy = row
        if count1 != 0:
            s_abort_execution = as_unicode("TRUE")
    return s_abort_execution
def delete_invalid_global_authors(my_db, my_cursor, log):
    mysql = "DELETE FROM _global_authors WHERE name LIKE '%Unknown%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _global_authors WHERE name LIKE '%Other Stories%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _global_authors WHERE name LIKE '%Others%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _global_authors WHERE name LIKE '%Various%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _global_authors WHERE name LIKE '% and %' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _global_authors WHERE name LIKE '%:%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _global_authors WHERE name LIKE '%-.%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _global_authors WHERE name LIKE '% by %' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _global_authors WHERE name LIKE '% of %' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _global_authors WHERE link LIKE '%ERROR[4]%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _global_authors WHERE name NOT LIKE '% %' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _global_authors WHERE name LIKE '%|%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _global_authors WHERE name LIKE '%(%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _global_authors WHERE name LIKE '%[%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _global_authors WHERE name LIKE '%editor%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE name LIKE '%Unknown%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE name LIKE '%Other Stories%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE name LIKE '%Others%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE name LIKE '%Various%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE name LIKE '% and %' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE name LIKE '%:%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE name LIKE '%-.%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE name LIKE '% by %' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE name LIKE '% of %' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE link LIKE '%ERROR[4]%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE name NOT LIKE '% %' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE name LIKE '%,%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE name LIKE '%|%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE name LIKE '%(%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE name LIKE '%[%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    mysql = "DELETE FROM _pristine_authors WHERE name LIKE '%editor%' "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    my_cursor.execute("\
                            BEGIN TRANSACTION;\
                            DELETE FROM _global_authors WHERE name IN(SELECT name from _global_series);\
                            DELETE FROM _global_author_series_link WHERE authid NOT IN(SELECT id from _global_authors);\
                            DELETE FROM _global_author_series_link WHERE seriesid NOT IN(SELECT id from _global_series);\
                            DELETE FROM _pristine_authors WHERE name IN(SELECT name from _pristine_series);\
                            DELETE FROM _pristine_authors WHERE name IN(SELECT name from _global_series);\
                            DELETE FROM _pristine_authors WHERE name IN(SELECT name from _global_authors);\
                            DELETE FROM _pristine_series WHERE name IN(SELECT name from _global_series);\
                            DELETE FROM _pristine_author_series_link WHERE authid NOT IN(SELECT id from _pristine_authors);\
                            DELETE FROM _pristine_author_series_link WHERE seriesid NOT IN(SELECT id from _pristine_series);\
                            COMMIT;")
def scrub_author_title_reversed(my_db,my_cursor,notifications,log):
    mysql = "UPDATE custom_column_8 SET value = (SELECT replace(value,authname,'') FROM __instr_author_title_by_id \
                    WHERE book = custom_column_8.id ) WHERE value IN(SELECT booktitle FROM __instr_author_title_by_id \
                    WHERE book = custom_column_8.id AND __instr_author_title_by_id.book = __instr_author_title_by_id.id ) \
                    AND custom_column_8.id IN(SELECT book FROM __books_work_status WHERE value = 'dirty' AND book = custom_column_8.id)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "UPDATE custom_column_8 SET value =(trim(value))"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "UPDATE custom_column_4 SET value = (replace(value,'|',','))"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "DELETE FROM _author_title_work"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "INSERT OR REPLACE INTO _author_title_work SELECT book,authname,booktitle,name,authname FROM __instr_global_author_title \
                    WHERE book IN(SELECT book FROM __books_work_status WHERE value = 'dirty') \
                    AND book NOT NULL AND authname NOT NULL AND booktitle NOT NULL AND name NOT NULL \
                    AND (instr(name,' ') > 0 ) \
                    AND authname != name AND authname NOT IN(SELECT name FROM _global_authors WHERE name = authname) "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "INSERT OR REPLACE INTO _author_title_work SELECT book,authname,booktitle,name,authname FROM __instr_pristine_author_title \
                    WHERE book IN(SELECT book FROM __books_work_status WHERE value = 'dirty') \
                    AND book NOT NULL AND authname NOT NULL AND booktitle NOT NULL AND name NOT NULL \
                    AND (instr(name,' ') > 0 ) \
                    AND authname != name AND authname NOT IN(SELECT name FROM _pristine_authors WHERE name = authname)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    notifications.put((0.05, 'Please Be Patient While All Titles and Authors Are Compared to All Global Authors and Pristine Authors In All Of Their Permutations'))
    mysql = "INSERT OR REPLACE INTO _author_title_work SELECT book,authname,booktitle,name,booktitle||'  '||authname FROM __instr_global_author_sort_title \
                    WHERE book IN(SELECT book FROM __books_work_status WHERE value = 'dirty') \
                    AND book NOT NULL AND authname NOT NULL AND booktitle NOT NULL AND name NOT NULL \
                    AND (instr(name,' ') > 0 ) AND booktitle != authname \
                    AND authname != name AND authname NOT IN(SELECT name FROM _global_authors WHERE name = authname)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "INSERT OR REPLACE INTO _author_title_work SELECT book,authname,booktitle,name,booktitle||'  '||authname FROM __instr_pristine_author_sort_title \
                    WHERE book IN(SELECT book FROM __books_work_status WHERE value = 'dirty') \
                    AND book NOT NULL AND authname NOT NULL AND booktitle NOT NULL AND name NOT NULL \
                    AND (instr(name,' ') > 0 ) AND booktitle != authname \
                    AND authname != name AND authname NOT IN(SELECT name FROM _pristine_authors WHERE name = authname)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    notifications.put((0.10, 'Please Be Patient While All Titles and Authors Are Compared to All Global Authors and Pristine Authors In All Of Their Permutations'))
    mysql = "UPDATE custom_column_8 SET value = (replace(value,(SELECT sort FROM  __instr_global_author_sort_title  \
                    WHERE __instr_global_author_sort_title.book = custom_column_8.id),'')) \
                    WHERE custom_column_8.id IN(SELECT book FROM __books_work_status WHERE value = 'dirty' AND book = custom_column_8.id) \
                    AND custom_column_8.id IN(SELECT book FROM  __instr_global_author_sort_title  \
                    WHERE __instr_global_author_sort_title.book = custom_column_8.id)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "UPDATE custom_column_8 SET value = (replace(value,(SELECT sort FROM  __instr_pristine_author_sort_title  \
                    WHERE __instr_pristine_author_sort_title.book = custom_column_8.id),'')) \
                    WHERE custom_column_8.id IN(SELECT book FROM __books_work_status WHERE value = 'dirty' AND book = custom_column_8.id) \
                    AND custom_column_8.id IN (SELECT book FROM  __instr_pristine_author_sort_title  \
                    WHERE __instr_pristine_author_sort_title.book = custom_column_8.id)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    notifications.put((0.15, 'Please Be Patient While All Titles and Authors Are Compared to All Global Authors and Pristine Authors In All Of Their Permutations'))
    mysql = "UPDATE custom_column_8 SET value=(replace(custom_column_8.value,(SELECT first1 FROM __instr_global_author_link_title_part2 \
                WHERE book = custom_column_8.id),'') ) \
                WHERE custom_column_8.id IN(SELECT book FROM __books_work_status WHERE value = 'dirty' AND book = custom_column_8.id) \
                AND custom_column_8.id =(SELECT book FROM __instr_global_author_link_title_part2 \
                WHERE booktitle = custom_column_8.value AND book = custom_column_8.id)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "UPDATE custom_column_8 SET value=(replace(custom_column_8.value,(SELECT first1 FROM __instr_pristine_author_link_title_part2 \
                WHERE book = custom_column_8.id),'') ) \
                WHERE custom_column_8.id IN(SELECT book FROM __books_work_status WHERE value = 'dirty' AND book = custom_column_8.id) \
                AND custom_column_8.id =(SELECT book FROM __instr_pristine_author_link_title_part2 \
                WHERE booktitle = custom_column_8.value AND book = custom_column_8.id)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    notifications.put((0.20, 'Please Be Patient While All Titles and Authors Are Compared to All Global Authors and Pristine Authors In All Of Their Permutations'))
    mysql = "INSERT OR IGNORE INTO custom_column_18 (id,value,link) VALUES (null, 'auth_ok','') "
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    mysql = "SELECT book,old_author,old_title,new_author,new_title FROM _author_title_work WHERE book NOT NULL"
    tmp_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql,book=None)
    if not tmp_rows:
       pass
    else:
        log("Swapped Author & Title Will Be Corrected for: Book, Old Author, Old Title, New Author, New Title")
        for row in tmp_rows:
            book,oldauth,oldtitle,newauth,newtitle = row
            orig_oldauth = oldauth
            log(" ")
            a2 = oldauth +  "                                                                                  "
            a3 = oldtitle +  "                                                                                   "
            a4 = newauth +  "                                                                                "
            a5 = newtitle +  "                                                                                 "
            a2 = a2[0:60]
            a3 = a3[0:60]
            a4 = a4[0:50]
            a5 = a5[0:60]
            log(as_unicode(book) + "  " +as_unicode(a2) + "  " +as_unicode(a3) + "  " +as_unicode(a4) + "  " +as_unicode(a5))
            book = qs_standardize_string_numerics(book,return_integer=True)
            mysql = "UPDATE custom_column_4 SET value = (SELECT new_author FROM _author_title_work  WHERE _author_title_work.book = custom_column_4.id ) \
                            WHERE custom_column_4.id = ? "
            execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=book)
            sleep(0.1)
            mysql = "SELECT sort,link FROM _global_authors WHERE name = ?"
            my_cursor.execute(mysql,([newauth]))
            tmp_global_auth_rows = my_cursor.fetchall()
            if not tmp_global_auth_rows:
                pass
            else:
                for item in tmp_global_auth_rows:
                    ssort,link = item
                    tmp_global_link_rows = link.split("~")
                    if len(tmp_global_link_rows) == 0:
                        tmp_global_link_rows.append("~")
                newtitle = newtitle.replace(newauth,mynothing)
                newtitle = newtitle.replace(ssort,mynothing)
                for s in tmp_global_link_rows:
                    newtitle = newtitle.replace(s,mynothing)
            mysql = "SELECT sort,link FROM _pristine_authors WHERE name = ?"         
            my_cursor.execute(mysql,([newauth]))
            tmp_global_auth_rows = my_cursor.fetchall()
            if not tmp_global_auth_rows:
                pass
            else:
                for authrow in tmp_global_auth_rows:
                    ssort,link = authrow
                    tmp_global_link_rows = link.split("~")
                    if len(tmp_global_link_rows) == 0:
                        tmp_global_link_rows.append("~")
                newtitle = newtitle.replace(newauth,mynothing)
                newtitle = newtitle.replace(ssort,mynothing)
                for s in tmp_global_link_rows:
                    newtitle = newtitle.replace(s,mynothing)
            newtitle = scrub_interim_newtitle(orig_oldauth,newtitle,log)
            mysql = "UPDATE custom_column_8 SET value = ?  WHERE custom_column_8.id = ? "
            execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=newtitle,v1_is_first=False)
            sleep(0.1)
            mysql = "UPDATE books_custom_column_18_link SET value =(SELECT id FROM custom_column_18 \
                        WHERE value = 'auth_ok') WHERE books_custom_column_18_link.book = ? "
            execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=book)
            sleep(0.1)
            mysql = "DELETE FROM _author_title_work WHERE book  = ?"
            execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=book)
            sleep(0.1)
            newtitle = ""
            book = ""
    sleep(0.1)
    mysql = "UPDATE custom_column_4 SET value = (replace(value,'|',','))"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    notifications.put((0.50, 'Continuing Next Phase...'))
def scrub_interim_newtitle(orig_oldauth,newtitle,log):
    global re_already_imported
    global my_re
    if not re_already_imported:
        import re
        my_re = re
        del re
        re_already_imported = True
    newtitle = newtitle.strip()
    if newtitle.startswith("-") or newtitle.startswith(",") or newtitle.startswith(":"):
        newtitle = newtitle[1: ]
        newtitle = newtitle.strip()
    newtitle = newtitle.title()    
    tmp_title = newtitle
    try:
        tmp_title = tmp_title.lower()
        orig_oldauth = orig_oldauth
        orig_oldauth = orig_oldauth.lower()
    except:
        return newtitle
    if orig_oldauth in tmp_title:   
        n = tmp_title.count(orig_oldauth)
        if n > 1:
            backup_title = tmp_title
            tmp_title = tmp_title.replace(orig_oldauth,"",(n-1))
            newtitle = tmp_title
            newtitle = newtitle.title()
            newtitle = newtitle.replace("  ", " ")
            newtitle = newtitle.strip()
            if newtitle.startswith("-") or newtitle.startswith(",") or newtitle.startswith(":"):
                newtitle = newtitle[1: ]
                newtitle = newtitle.strip()
            if newtitle == "":
                newtitle = backup_title
    s_split_0 = []
    s_split = []
    s = ""
    s1 = ""
    s2 = ""
    s3 = ""
    s4 = ""
    s5 = ""
    s6 = ""
    sa = ""
    sb = ""
    sc = ""
    sd = ""
    se = ""
    sf = ""
    n = 0
    try:
        my_re_1 =  "^[a-z ]+[ ][0-9]+[ ]"                                   
        my_re_2 =  "[[(]*[a-z ]+[#]*[0-9]+[)\]]*$"                       
        p1 = my_re.compile(my_re_1, my_re.IGNORECASE)
        p2 = my_re.compile(my_re_2, my_re.IGNORECASE)
        match1 = p1.search(newtitle)
        match2 = p2.search(newtitle)
        if (not match1) or (not match2):
            return newtitle
        else:
            try:
                s1 = match1.group(0)
                s2 = match2.group(0)
                my_re_3 = "[0-9]+"     
                p3 = my_re.compile(my_re_3, my_re.IGNORECASE)
                match3 = p3.search(s1)
                match4 = p3.search(s2)
            except:
                return newtitle   
            if not match3 or not match4:
                return newtitle   
            else:
                s3 = match3.group(0)
                s4 = match4.group(0)
                if s3 > s4:
                    newtitle = newtitle.replace(s4,s3)
                newtitle = newtitle.replace(s1,"")
                newtitle = newtitle.strip()
                if newtitle.startswith("-") or newtitle.startswith(",") or newtitle.startswith(":"):
                    newtitle = newtitle[1: ]
                newtitle = newtitle.replace("  ", " ")
                newtitle = newtitle.strip()
                newtitle = newtitle.replace("(", "[")
                newtitle = newtitle.replace(")", "]")
                if not "[" in newtitle:
                    return newtitle
                s_split_0 = newtitle.split("[")
                n = len(s_split_0)
                if n == 0 or n == 1:
                    return newtitle
                s = s_split_0[0]
                s = s.replace("  ", " ")
                s = s.strip()
                s_split = s.split(" ")  
                n = len(s_split)
                if n == 0 or n == 1:
                    return as_unicode(newtitle)
                if n == 2:    
                    sa = s_split[0]  
                    sb = s_split[1]  
                    sa = sa.replace("-", "")
                    sa = sa.strip()
                    sb = sb.replace("-", "")
                    sb = sb.strip()
                    if sa == sb:      
                        newtitle = newtitle.replace(sa,"")
                    else: 
                        pass
                    newtitle = newtitle.replace("  ", " ")
                    newtitle = newtitle.strip()
                    return newtitle
                if n >= 4 and n < 6:     
                    sa = s_split[0]    
                    sb = s_split[1]    
                    sc = s_split[2]    
                    sd = s_split[3]    
                    sa = sa.replace("-", "")
                    sb = sb.replace("-", "")
                    sc = sc.replace("-", "")
                    sd = sd.replace("-", "")
                    sa = sa.strip()
                    sb = sb.strip()
                    sc = sc.strip()
                    sd = sd.strip()
                    if sa == sc:      
                        newtitle = newtitle.replace(sa,"")   
                    if sb == sd:
                        newtitle = newtitle.replace(sb,"")   
                    newtitle = newtitle.replace("  ", " ")
                    newtitle = newtitle.strip()
                    return newtitle
                else:
                    if n >= 6:     
                        sa = s_split[0]    
                        sb = s_split[1]   
                        sc = s_split[2]   
                        sd = s_split[3]  
                        se = s_split[4]   
                        sf = s_split[5]   
                        sa = sa.replace("-", "")
                        sb = sb.replace("-", "")
                        sc = sc.replace("-", "")
                        sd = sd.replace("-", "")
                        se = se.replace("-", "")
                        sf = sf.replace("-", "")
                        sa = sa.strip()
                        sb = sb.strip()
                        sc = sc.strip()
                        sd = sd.strip()
                        se = se.strip()
                        sf = sf.strip()
                        if sa == sd:      
                            newtitle = newtitle.replace(sa,"")   
                        if sb == se:
                            newtitle = newtitle.replace(sb,"")   
                        if sc == sf:      
                            newtitle = newtitle.replace(sc,"")   
                        newtitle = newtitle.replace("  ", " ")
                        newtitle = newtitle.strip()
                        return newtitle
                    else:
                        newtitle = newtitle.replace("  ", " ")
                        newtitle = newtitle.strip()
                        return newtitle
    except Exception as e:
        log("Exception is: " + as_unicode(e))
        pass
    newtitle = newtitle.replace("  ", " ")
    newtitle = newtitle.strip()
    return newtitle
def scrub_author_in_author_with_nonauthor(my_db,my_cursor,notifications,log):
    book_list = []
    mysql = "SELECT book,booktitle,authname,name FROM __instr_global_author_author \
                    WHERE authname NOT IN(SELECT name from _global_authors WHERE name = authname) \
                    AND authname NOT IN(SELECT name from _pristine_authors WHERE name = authname)"
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        pass
    else:
        if len(tmp_list) == 0:
            pass
        else:
            log(" ")
            for row in tmp_list:
                book,booktitle,authname,name = row
                book = int(book)
                new_auth = name
                make_series = False
                for c in authname:
                    if c.isdigit():
                        make_series = True
                        break
                if make_series:
                    authname = "[ " + authname + " ]"
                s = authname
                s = s.replace(name,"")
                s = s.replace("-.","")
                s = s.replace(" - "," ",4)
                s = s.replace(" -"," ",4)
                s = s.replace("- "," ",4)   
                s = s.strip()
                if len(s) < 5:   
                    s = ""
                s = s.replace(booktitle, "")          
                new_title = booktitle + " " + s
                new_title = new_title.replace(name,"")
                new_title = new_title.replace("-.","")
                new_title = new_title.replace("  ", " ")
                new_title = new_title.replace("[]","")
                new_title = new_title.replace("[ ]","")
                new_title = new_title.replace("[  ]","")
                new_title = new_title.replace("  ", " ")
                new_title = new_title.strip()
                mysql = "UPDATE custom_column_4 SET value = ? WHERE id = ? "
                execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=new_auth,v1_is_first=False)
                mysql = "UPDATE custom_column_8 SET value = ? WHERE id = ? "
                execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=new_title,v1_is_first=False)
                authname = authname + "                                                                                       "
                new_auth = new_auth   + "                                                                                       "
                new_title = new_title     + "                                                                                       "
                authname = authname[0:60]
                new_auth = new_auth[0:30]
                new_title = new_title[0:60]
                log("[Author]: " + authname + "  [was changed to]: " + new_auth + " [for a book with a new title of]: " + new_title)
                book_list.append(book)
    mysql = "SELECT book,booktitle,authname,name FROM __instr_pristine_author_author \
                    WHERE authname NOT IN(SELECT name from _pristine_authors WHERE name = authname) \
                      AND authname NOT IN(SELECT name from _global_authors WHERE name = authname)"
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        pass
    else:
        if len(tmp_list) == 0:
            pass
        else:
            log(" ")
            for row in tmp_list:
                book,booktitle,authname,name = row
                book = int(book)
                new_auth = name
                make_series = False
                for c in authname:
                    if c.isdigit():
                        make_series = True
                        break
                if make_series:
                    authname = "[ " + authname + " ]"
                s = authname
                s = s.replace(name,"")
                s = s.strip()
                if len(s) < 5:   
                    s = ""
                new_title = booktitle + " " + s
                new_title = new_title.replace(name,"")
                new_title = new_title.replace("-.","")
                new_title = new_title.replace("  ", " ")
                new_title = new_title.replace("[]","")
                new_title = new_title.replace("[ ]","")
                new_title = new_title.replace("[  ]","")
                new_title = new_title.replace("  ", " ")
                new_title = new_title.strip()
                mysql = "UPDATE custom_column_4 SET value = ? WHERE id = ? "
                execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=new_auth,v1_is_first=False)
                mysql = "UPDATE custom_column_8 SET value = ? WHERE id = ? "
                execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=new_title,v1_is_first=False)
                authname = authname + "                                                                                       "
                new_auth = new_auth   + "                                                                                       "
                new_title = new_title     + "                                                                                       "
                authname = authname[0:60]
                new_auth = new_auth[0:30]
                new_title = new_title[0:60]
                log("[Author]: " + authname + "  [was changed to]: " + new_auth + " [for a book with a new title of]: " + new_title)
                book_list.append(book)
    if len(book_list) == 0:
        return
    mysql = "SELECT id,'dummy'  FROM custom_column_18 WHERE value = 'auth_ok' "
    tmp_id_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql,book=None)
    if not tmp_id_rows:
        tmp_id_rows = []
    if len(tmp_id_rows) == 0:
        sleep(0)
        mysql = "INSERT OR IGNORE INTO custom_column_18 (id,value,link) VALUES (null, 'auth_ok','') "
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
        sleep(0)
        mysql = "SELECT id,'dummy' FROM custom_column_18 WHERE value = 'auth_ok' "
        tmp_id_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql,book=None)
        if not tmp_id_rows:
            tmp_id_rows = []
        if len(tmp_id_rows) == 0:
            log("[1]sql error: custom_column_18 WHERE value = 'auth_ok' ; notify developer")
            return
    tmp_id,dummy = tmp_id_rows[0]
    if not isinstance(tmp_id,int):
        log("[2]sql error: custom_column_18 WHERE value = 'auth_ok' ; notify developer")
        return
    sleep(0)
    book_list = qs_convert_list_of_nominal_book_ids_to_integers(book_list)
    for row in book_list:
        my_current_book = row
        mysql = "DELETE FROM books_custom_column_18_link WHERE book = ? AND book > ?"
        execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=my_current_book,v2=0,v1_is_first=True)
        sleep(0)
        mysql = "INSERT OR REPLACE INTO books_custom_column_18_link (id,book,value) VALUES (null,?,?) "
        execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=my_current_book,v2=tmp_id,v1_is_first=True)
        sleep(0)
        clear_work_freeze(my_db, my_cursor, my_current_book, notifications, log)
        sleep(0)
def scrub_author_in_title_but_split_in_two(my_db,my_cursor,notifications,log):
    book_list = []
    mysql = "SELECT name,book,authname,booktitle,(substr(booktitle,0,(instr(booktitle,' ')) )) AS matchleft,\
                substr(booktitle,u_rfind(booktitle,' '),length(booktitle) - u_rfind(booktitle,' ') +1 )  AS matchright \
                FROM __books_work_populate,_global_authors \
                WHERE name != booktitle \
                AND length(booktitle) > 8 \
                AND instr(booktitle,' ') > 0 \
                AND authname != name AND matchleft NOT NULL AND matchright NOT NULL AND booktitle NOT NULL \
                AND authname NOT NULL AND book NOT NULL \
                AND authname NOT IN(SELECT name FROM _global_authors WHERE name = authname) \
                AND authname NOT IN(SELECT name FROM _pristine_authors WHERE name = authname) \
                AND _global_authors.name LIKE  '%'||(substr(booktitle,0,(instr(booktitle,' ')) ))||'%' \
                AND _global_authors.name LIKE  '%'||matchright||'%'  "
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        pass
    else:
        if len(tmp_list) == 0:
            pass
        else:
            log(" ")
            log("Global Author Names Split into Two Parts in Title But Also Not in Work Author (If Any) Will Be Corrected. ")
            log(" ")
            for row in tmp_list:
                name,book,authname,booktitle,matchleft,matchright = row
                book = int(book)
                s_found = False
                for c in booktitle:
                    if (not c.isalpha() ) and (not c == ' '):   
                        s_found = True      
                        break
                if not s_found:
                    continue
                if len(matchleft) < 2 or matchright == "" or matchright.strip() == "":
                    continue
                if matchleft.startswith("The ") or matchleft.startswith("An ") or matchleft.startswith("A "):
                    continue
                if len(matchleft) + len(matchright) == len(booktitle):
                    continue
                matchright = matchright.strip()
                if not matchright.isalpha():
                    continue
                s_split = name.split(" ")
                n = len(s_split)
                if n < 2:
                    continue
                if n == 2:
                    sl = s_split[1]
                    try:
                        sl = sl.lower()
                        smr = matchright.lower()
                    except:
                        smr = matchright
                    if sl != smr:
                        continue
                else:
                    sl = s_split[2]
                    try:
                        sl = sl.lower()
                        smr = matchright.lower()
                    except:
                        smr = matchright
                    if sl != smr:
                        continue
                for item in s_split:
                    s0 = item.strip()
                    booktitle = booktitle.replace(s0,"")
                    authname  = authname.replace(s0,"")  
                    try:
                        s0 = s0.lower()
                        booktitle = booktitle.replace(s0,"")
                        authname  = authname.replace(s0,"")  
                    except:
                        log("lower exception")
                        log("current function being executed: " + sys._getframe(0).f_code.co_name)
                new_auth = name
                new_title = booktitle + " " + authname
                new_title = new_title.replace(name,"")     
                new_title = new_title.replace("-.","")
                new_title = new_title.replace("  ", " ")
                new_title = new_title.replace("[]","")
                new_title = new_title.replace("[ ]","")
                new_title = new_title.replace("[  ]","")
                new_title = new_title.replace("  ", " ")
                new_title = new_title.strip()
                book_list.append(book)
                mysql = "UPDATE custom_column_4 SET value = ? WHERE id = ? "
                execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=new_auth,v1_is_first=False)
                mysql = "UPDATE custom_column_8 SET value = ? WHERE id = ? "
                execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=new_title,v1_is_first=False)
                log("[Author]: " + authname + "  [was changed to]: " + new_auth + " [for a book with a new title of]: " + new_title)
                log(" ")
                log(" ")
    mysql = "SELECT name,book,authname,booktitle,(substr(booktitle,0,(instr(booktitle,' ')) )) AS matchleft,\
                substr(booktitle,u_rfind(booktitle,' '),length(booktitle) - u_rfind(booktitle,' ') + 1 )  AS matchright \
                FROM __books_work_populate,_pristine_authors \
                WHERE name != booktitle \
                AND length(booktitle) > 8 \
                AND instr(booktitle,' ') > 0 \
                AND authname != name AND matchleft NOT NULL AND matchright NOT NULL AND booktitle NOT NULL \
                AND authname NOT NULL AND book NOT NULL \
                AND authname NOT IN(SELECT name FROM _pristine_authors WHERE name = authname) \
                AND authname NOT IN(SELECT name FROM _global_authors WHERE name = authname) \
                AND _pristine_authors.name LIKE  '%'||(substr(booktitle,0,(instr(booktitle,' ')) ))||'%' \
                AND _pristine_authors.name LIKE  '%'||matchright||'%'  "
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        pass
    else:
        if len(tmp_list) == 0:
            pass
        else:
            log(" ")
            log("Pristine Author Names Split in Two Parts in Title But Not In Work Author Corrected. ")
            log(" ")
            for row in tmp_list:
                name,book,authname,booktitle,matchleft,matchright = row
                book = int(book)
                s_found = False
                for c in booktitle:
                    if (not c.isalpha() ) and (not c == ' '):   
                        s_found = True      
                        break
                if not s_found:
                    continue
                if len(matchleft) < 2 or matchright == "" or matchright.strip() == "":
                    continue
                if matchleft.startswith("The ") or matchleft.startswith("An ") or matchleft.startswith("A "):
                    continue
                if len(matchleft) + len(matchright) == len(booktitle):
                    continue
                matchright = matchright.strip()
                if not matchright.isalpha():
                    continue
                s_split = name.split(" ")
                n = len(s_split)
                if n < 2:
                    continue
                if n == 2:
                    sl = s_split[1]
                    try:
                        sl = sl.lower()
                        smr = matchright.lower()
                    except:
                        smr = matchright
                    if sl != smr:
                        continue
                else:
                    sl = s_split[2]
                    try:
                        sl = sl.lower()
                        smr = matchright.lower()
                    except:
                        smr = matchright
                    if sl != smr:
                        continue
                for item in s_split:
                    s0 = item.strip()
                    booktitle = booktitle.replace(s0,"")
                    authname  = authname.replace(s0,"")  
                    try:
                        s0 = s0.lower()
                        booktitle = booktitle.replace(s0,"")
                        authname  = authname.replace(s0,"")  
                    except:
                        log("lower exception")
                new_auth = name
                new_title = booktitle + " " + authname
                new_title = new_title.replace(name,"")     
                new_title = new_title.replace("-.","")
                new_title = new_title.replace("  ", " ")
                new_title = new_title.replace("[]","")
                new_title = new_title.replace("[ ]","")
                new_title = new_title.replace("[  ]","")
                new_title = new_title.replace("  ", " ")
                new_title = new_title.strip()
                book_list.append(book)
                mysql = "UPDATE custom_column_4 SET value = ? WHERE id = ? "
                execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=new_auth,v1_is_first=False)
                mysql = "UPDATE custom_column_8 SET value = ? WHERE id = ? "
                execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=new_title,v1_is_first=False)
                log("[Author]: " + authname + "  [was changed to]: " + new_auth + " [for a book with a new title of]: " + new_title)
                log(" ")
                log(" ")
    if len(book_list) == 0:
        return
    mysql = "SELECT id,'dummy'  FROM custom_column_18 WHERE value = 'auth_ok' "
    tmp_id_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql,book=None)
    if not tmp_id_rows:
        sleep(0)
        mysql = "INSERT OR IGNORE INTO custom_column_18 (id,value,link) VALUES (null, 'auth_ok','') "
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
        sleep(0)
        mysql = "SELECT id,'dummy'  FROM custom_column_18 WHERE value = 'auth_ok' "
        tmp_id_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql,book=None)
    if not tmp_id_rows:
        tmp_id_rows = []
    if len(tmp_id_rows) == 0:
        log("sql error: custom_column_18 WHERE value = 'auth_ok' ; notify developer")
        return
    tmp_id,dummy = tmp_id_rows[0]
    book_list = qs_convert_list_of_nominal_book_ids_to_integers(book_list)
    for book in book_list:
        my_current_book = book
        sleep(.1)
        mysql = "DELETE FROM books_custom_column_18_link WHERE book = ? AND book > ?"
        execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=my_current_book,v2=0,v1_is_first=True)
        sleep(.1)
        mysql = "INSERT OR REPLACE INTO books_custom_column_18_link (id,book,value) VALUES (null,?,?) "
        execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=my_current_book,v2=tmp_id,v1_is_first=True)
        sleep(.1)
        clear_work_freeze(my_db, my_cursor, my_current_book, notifications, log)
        sleep(.1)
def scrub_final_author_in_final_title(my_db,my_cursor,notifications,log):
    book_author_list = list(my_cursor.execute("SELECT id,value FROM custom_column_4") )
    book_title_list = list(my_cursor.execute("SELECT id,value FROM custom_column_8") )
    book_status_dirty_list = list(my_cursor.execute("SELECT book,value FROM __books_work_status WHERE value = 'dirty' ") )
    new_book_title_list = []
    for row in book_status_dirty_list:
        book,value = row
        for row in book_title_list:
            tbook,title = row
            if not tbook == book:
                continue
            for line in book_author_list:
                abook,author = line
                if not abook == book:
                    continue
                if author in title:
                    newtitle = title.replace(author,"").strip()
                    if newtitle.startswith("-"):
                        newtitle = newtitle[1: ]
                    if newtitle.endswith("-"):
                        newtitle = newtitle[0:-1]
                    newtitle = newtitle.replace('"','') 
                    r = book,newtitle
                    new_book_title_list.append(r)
                    log(" ")
                    log("Author removed from Title: " + author + "  " + title + "    new title: " + newtitle)
                break
    if len(new_book_title_list) == 0:
        return
    for row in new_book_title_list:
        book,newtitle = row
        mysql = "UPDATE custom_column_8 SET value = ? WHERE id = ?  "
        execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=newtitle,v1_is_first=False)
    mysql = "UPDATE custom_column_8 SET value =(trim(value))"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
    sleep(0.1)
    del book_author_list
    del book_title_list
    del new_book_title_list
def scrub_author_in_author_but_split_in_two(my_db,my_cursor,notifications,log):
    book_list = []
    sleep(0.1)
    mysql = "SELECT name,book,authname,booktitle,(substr(authname,0,(instr(authname,' ')) )) AS matchleft,\
                substr(authname,u_rfind(authname,' '),length(authname) - u_rfind(authname,' ') +1 )  AS matchright \
                FROM __books_work_populate,_global_authors \
                WHERE name != authname \
                AND length(authname) > 8 \
                AND instr(authname,' ') > 0 \
                AND matchleft NOT NULL AND matchright NOT NULL AND booktitle NOT NULL \
                AND authname NOT NULL AND book NOT NULL \
                AND authname NOT IN(SELECT name FROM _global_authors WHERE name = authname) \
                AND authname NOT IN(SELECT name FROM _pristine_authors WHERE name = authname) \
                AND _global_authors.name LIKE  '%'||(substr(authname,0,(instr(authname,' ')) ))||'%' \
                AND _global_authors.name LIKE  '%'||matchright||'%'  \
                AND trim(matchright) != trim(matchleft)  \
                AND (u_count(authname,' ') > 1)"
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        pass
    else:
        if len(tmp_list) == 0:
            pass
        else:
            log(" ")
            log("Global Author Names Split into Two Parts (Along With Bits of Title) in Work Author Will Be Corrected. ")
            log(" ")
            for row in tmp_list:
                name,book,authname,booktitle,matchleft,matchright = row
                s_found = False
                for c in booktitle:
                    if (not c.isalpha() ) and (not c == ' '):   
                        s_found = True      
                        break
                if not s_found:
                    continue
                if "." in matchleft:   
                    continue
                if matchleft.strip() == matchright.strip():    
                    continue
                if len(matchleft) < 2 or as_unicode(matchright) == "" or matchright.strip() == "":
                    continue
                if matchleft.startswith("The ") or matchleft.startswith("An ") or matchleft.startswith("A "):
                    continue
                if len(matchleft) + len(matchright) == len(booktitle):
                    continue
                matchright = matchright.strip()
                if not matchright.isalpha():
                    continue
                s_split = name.split(" ")     
                n = len(s_split)
                if n < 2:
                    continue
                if n == 2:
                    sl = s_split[1]
                    try:
                        sl = sl.lower()
                        smr = matchright.lower()
                    except:
                        smr = matchright
                    if sl != smr:
                        continue
                else:
                    sl = s_split[2]
                    try:
                        sl = sl.lower()
                        smr = matchright.lower()
                    except:
                        smr = matchright
                    if sl != smr:
                        continue
                new_auth = name
                if any(char.isdigit() for char in authname):        
                    authname = "[ " + authname + " ]"  
                try:
                    authname = authname.title()  
                    booktitle = booktitle.title()      
                except:
                    pass
                new_title = booktitle + " " + authname  
                s2 = authname 
                for item in s_split:
                    s0 = item.strip()
                    new_title = new_title.replace(s0,"")
                    s2 = s2.replace(s0,"")     
                    try:
                        s0 = s0.lower()
                        new_title = new_title.replace(s0,"")
                        s2 = s2.lower()
                        s2 = s2.replace(s0,"")     
                    except:
                        pass
                s2 = s2.replace("-.","")
                s2 = s2.replace("-","")
                s2 = s2.strip()
                try:
                    s2 = s2.title() 
                except:
                    pass
                n = new_title.lower().strip().count(s2.lower())
                if n > 1:
                    new_title = new_title.lower().strip().replace(s2.lower(),"",1)
                new_title = new_title.replace(name,"")     
                new_title = new_title.replace("-.","")
                new_title = new_title.replace("  ", " ")
                new_title = new_title.replace("[]","")
                new_title = new_title.replace("[ ]","")
                new_title = new_title.replace("[  ]","")
                new_title = new_title.replace("  ", " ")
                new_title = new_title.strip()
                new_title = new_title.title()
                sleep(.1)
                mysql = "UPDATE custom_column_4 SET value = ? WHERE id = ? "
                execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=new_auth,v1_is_first=False)
                sleep(.1)
                mysql = "UPDATE custom_column_8 SET value = ? WHERE id = ? "
                execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=new_title,v1_is_first=False)
                log("[Author]: " + authname + "  [was changed to]: " + new_auth + " [for a book with a new title of]: " + new_title)
                log(" ")
                log(" ")
                book_list.append(book)
    sleep(0.1)
    mysql = "SELECT name,book,authname,booktitle,(substr(authname,0,(instr(authname,' ')) )) AS matchleft,\
                substr(authname,u_rfind(authname,' '),length(authname) - u_rfind(authname,' ') +1 )  AS matchright \
                FROM __books_work_populate,_pristine_authors \
                WHERE name != authname \
                AND length(authname) > 8 \
                AND instr(authname,' ') > 0 \
                AND matchleft NOT NULL AND matchright NOT NULL AND booktitle NOT NULL \
                AND authname NOT NULL AND book NOT NULL \
                AND authname NOT IN(SELECT name FROM _pristine_authors WHERE name = authname) \
                AND authname NOT IN(SELECT name FROM _global_authors WHERE name = authname) \
                AND _pristine_authors.name LIKE  '%'||(substr(authname,0,(instr(authname,' ')) ))||'%' \
                AND _pristine_authors.name LIKE  '%'||matchright||'%' \
                AND trim(matchright) != trim(matchleft)  \
                AND (u_count(authname,' ') > 1)"
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        pass
    else:
        if len(tmp_list) == 0:
            pass
        else:
            log(" ")
            log("Pristine Author Names Split into Two Parts (Along With Bits of Title) in Work Author Will Be Corrected. ")
            log(" ")
            for row in tmp_list:
                name,book,authname,booktitle,matchleft,matchright = row
                book = int(book)
                s_found = False
                for c in booktitle:
                    if (not c.isalpha() ) and (not c == ' '):   
                        s_found = True      
                        break
                if not s_found:
                    continue
                if "." in matchleft:
                    continue
                if matchleft.strip() == matchright.strip():    
                    continue
                if len(matchleft) < 2 or matchright == "" or matchright.strip() == "":
                    continue
                if matchleft.startswith("The ") or matchleft.startswith("An ") or matchleft.startswith("A "):
                    continue
                if len(matchleft) + len(matchright) == len(booktitle):
                    continue
                matchright = matchright.strip()
                if not matchright.isalpha():
                    continue
                s_split = name.split(" ")     
                n = len(s_split)
                if n < 2:
                    continue
                if n == 2:
                    sl = s_split[1]
                    try:
                        sl = sl.lower()
                        smr = matchright.lower()
                    except:
                        smr = matchright
                    if sl != smr:
                        continue
                else:
                    sl = s_split[2]
                    try:
                        sl = sl.lower()
                        smr = matchright.lower()
                    except:
                        smr = matchright
                    if sl != smr:
                        continue
                new_auth = name
                if any(char.isdigit() for char in authname):        
                    authname = "[ " + authname + " ]"  
                try:
                    authname = authname.title()  
                    booktitle = booktitle.title()      
                except:
                    pass
                new_title = booktitle + " " + authname  
                s2 = authname 
                for item in s_split:
                    s0 = item.strip()
                    new_title = new_title.replace(s0,"")
                    s2 = s2.replace(s0,"")     
                    try:
                        s0 = s0.lower()
                        new_title = new_title.replace(s0,"")
                        s2 = s2.lower()
                        s2 = s2.replace(s0,"")     
                    except:
                        pass
                s2 = s2.replace("-.","")
                s2 = s2.replace("-","")
                s2 = s2.strip()
                try:
                    s2 = s2.title() 
                except:
                    pass
                n = new_title.lower().strip().count(s2.lower())
                if n > 1:
                    new_title = new_title.lower().strip().replace(s2.lower(),"",1)
                new_title = new_title.replace(name,"")     
                new_title = new_title.replace("-.","")
                new_title = new_title.replace("  ", " ")
                new_title = new_title.replace("[]","")
                new_title = new_title.replace("[ ]","")
                new_title = new_title.replace("[  ]","")
                new_title = new_title.replace("  ", " ")
                new_title = new_title.strip()
                sleep(.1)
                mysql = "UPDATE custom_column_4 SET value = ? WHERE id = ? "
                execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=new_auth,v1_is_first=False)
                sleep(.1)
                mysql = "UPDATE custom_column_8 SET value = ? WHERE id = ? "
                execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=new_title,v1_is_first=False)
                log("[Author]: " + authname + "  [was changed to]: " + new_auth + " [for a book with a new title of]: " + new_title)
                log(" ")
                log(" ")
                book_list.append(book)
    if len(book_list) == 0:
        return
    sleep(.1)
    mysql = "SELECT id,'dummy' FROM custom_column_18 WHERE value = 'auth_ok' "
    tmp_id_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql,book=None)
    if not tmp_id_rows:
        sleep(.1)
        mysql = "INSERT OR IGNORE INTO custom_column_18 (id,value,link) VALUES (null, 'auth_ok','') "
        execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql,book=None)
        sleep(.1)
        mysql = "SELECT id,'dummy' FROM custom_column_18 WHERE value = 'auth_ok' "
        tmp_id_rows = execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql,book=None)
    if not tmp_id_rows:
        tmp_id_rows = []
    if len(tmp_id_rows) == 0:
        log("sql error: custom_column_18 WHERE value = 'auth_ok' ; notify developer")
        return
    tmp_id,dummy = tmp_id_rows[0]
    book_list = qs_convert_list_of_nominal_book_ids_to_integers(book_list)
    for book in book_list:
        sleep(.1)
        mysql = "DELETE FROM books_custom_column_18_link WHERE book = ? AND book > ?"
        execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=0,v1_is_first=True)
        sleep(.1)
        mysql = "INSERT OR REPLACE INTO books_custom_column_18_link (id,book,value) VALUES (null,?,?) "
        execute_mysql_for_custom_column_generic(my_db,my_cursor,log,mysql,v1=book,v2=tmp_id,v1_is_first=True)
        sleep(.1)
        clear_work_freeze(my_db, my_cursor, book, notifications, log)
def rename_authors_per_mapping_rules(my_db,my_cursor,notifications,log):
    mysql = "SELECT Count(*),'dummy' FROM custom_column_4 WHERE value IN(SELECT name FROM  _author_mapping WHERE name = custom_column_4.value AND newname NOT NULL AND name NOT NULL)"
    my_cursor.execute(mysql)
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        tmp_list = []
    if len(tmp_list) == 0:
        count1 = 0
    else:
        count1 = 0
        for row in tmp_list:
            count1,dummy = row
    count1 = as_unicode(count1)
    log(" ")
    log(" ")
    log("Number of Author Names Changed Per Author Mapping Rules: " +as_unicode(count1))
    log(" ")
    sleep(.1)
    mysql = "UPDATE custom_column_4 SET value =(SELECT newname FROM _author_mapping WHERE name = custom_column_4.value ) \
                    WHERE value IN(SELECT name FROM  _author_mapping WHERE name = custom_column_4.value AND newname NOT NULL AND name NOT NULL)"
    execute_mysql_with_commit_generic(my_db,my_cursor,log,mysql)
    sleep(0)
def titlecase_authors(my_db,my_cursor,notifications,log):
    sleep(.1)
    rows = list(my_cursor.execute("SELECT id,value FROM custom_column_4") )
    mysql = "UPDATE custom_column_4 SET value = ? WHERE id = ?"
    my_cursor.execute("begin")
    for row in rows:
        id,value = row
        value = titlecase(value)
        value = value.strip()
        my_cursor.execute(mysql,(value,id))
    my_cursor.execute("commit")
    log("Work Authors title-cased: " +as_unicode(len(rows)) )
    sleep(0)
