# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "3.6.120"    # Qt.core

# Simple natural order sorting API for Python.
#
# Author: Peter Odding <peter@peterodding.com>
# Last Change: November 16, 2013
# URL: https://github.com/xolox/python-naturalsort

# Standard library modules.
import re

# Regular expression to match a consecutive run of digits.
integer_pattern = re.compile('([0-9]+)')

def natsort(l, key=None, reverse=False):
    """
    Sort the given list in the way that humans expect (using natural order
    sorting).
    """
    return sorted(l, key=lambda v: natsort_key(key and key(v) or v),
                  reverse=reverse)

def natsort_key(s):
    #import re
    #integer_pattern = re.compile('([0-9]+)')
    """
    Turn a string into a list of substrings and numbers.
    """
    return [natsort_coerce(c) for c in integer_pattern.split(s) if c != '']

def natsort_coerce(s):
    """
    Coerce strings of digits into proper integers.
    """
    if s.isdigit():
        return int(s)
    else:
        return s
