# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "3.6.120"    # Qt.core

from calibre.constants import DEBUG
from polyglot.builtins import as_unicode, iteritems, unicode_type

def debug_nicely(locals_dict,name0=None,name1=None,other1=None,other2=None):
    #~ USAGE:    if DEBUG: debug_nicely(locals(),sys._getframe(0).f_code.co_name,sys._getframe(1).f_code.co_name,other1="something",other2="somethingelse")
    if not DEBUG:
        return
    print("[1]------------------------- BEGIN debug_nicely ----------------------------------")
    print("Local Variables within Function Name: ", name0, "    which was called by: ", name1)
    if other1 is not None:
        if isinstance(other1,unicode_type):
            print("other1: ", other1)
        else:
            debug_nicely_iterables(other1)
    if other2 is not None:
        if isinstance(other2,unicode_type):
            print("other2: ", other2)
        else:
            debug_nicely_iterables(other2)
    print("-----------------------------------------------------------------------------------------")
    var_value_dict = {k: v for k,v in iteritems(locals_dict) if  k[0] != '_'}
    for k,v in iteritems(var_value_dict):
        print(as_unicode(k), ":", as_unicode(v))
    print("[2]------------------------- END debug_nicely ----------------------------------")
    del locals_dict
    del var_value_dict
#----------------------------------------------------------------------------------------------------------------
def debug_nicely_iterables(obj):
    if isinstance(obj,dict):
        for k,v in iteritems(obj):
            print(as_unicode(k), "  :   ", as_unicode(v))
    elif isinstance(obj,list) or isinstance(obj,set) or isinstance(obj,tuple):
        for row in obj:
            print(as_unicode(row))
    else:
        print(as_unicode(obj))
#----------------------------------------------------------------------------------------------------------------
