# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "3.6.122"    # Copy Pristine Authors job fix.

import os, sys
import sqlite3
from calibre import isbytestring
from calibre.constants import iswindows, filesystem_encoding, DEBUG
from calibre.utils.logging import Log as log
from time import sleep
import time

from polyglot.builtins import as_unicode,  unicode_type
from polyglot.queue import Queue

my_terminate_early = False

notifications = Queue()

mynothing = ""

from calibre_plugins.quarantine_and_scrub.heading import log_heading_common
header_s1 = None
header_s2 = None
header_s3 = None
header_s4 = None
header_s5 = None

from calibre_plugins.quarantine_and_scrub.convert_types_to_other_types import (qs_standardize_any_string,
                                                                                                                                    qs_convert_list_of_nominal_book_ids_to_integers)
from calibre_plugins.quarantine_and_scrub.debug_nicely import debug_nicely

    #----------------------------------------------------------------------------------------------------------------
    #Copy Author and Series Plus Link to Q&S metadata.com Into Tables _pristine_xxxxx
    #----------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------
def util_copy_pristine_metadata(self, guidb, log=None, abort=None, notifications=True):  # <<<<====called from jobs.py
    global header_s1
    global header_s2
    global header_s3
    global header_s4
    global header_s5
    global my_terminate_early

    db = guidb
    path = db.library_path
    if isbytestring(path):
        path = path.decode(filesystem_encoding)
    path = path.replace(os.sep, '/')
    path = os.path.join(path, 'metadata.db')
    path = path.replace(os.sep, '/')
    if DEBUG: print(path)
    log(path)
    try:
        my_db = sqlite3.connect(path)   #sqlite not apsw
    except Exception as e:
        return

    my_cursor = my_db.cursor()

    header_s1 =  str("SQLite Version: " + str(sqlite3.version))

    #~ mysql = as_unicode("PRAGMA main.locking_mode=EXCLUSIVE;")
    #~ my_cursor.execute(mysql)  #apsw
    #~ header_s2 = mysql
    header_s2 = "Database is SHARED, not EXCLUSIVE"

    header_s3 = "Copying Pristine Author Names to Q&S Pristine Author Validation Table."
    log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)

    notifications.put((0.01, 'Attaching Calibre Pristine Database'))
    Attach_Calibre_metadata_db(my_db, my_cursor, path, notifications, log)

    sleep(1.0)

    if not my_terminate_early:
        Util_copy_control(my_db, my_cursor, notifications, log)
        Detach_Calibre_metadata_db(my_db, my_cursor, notifications, log)
        my_db.close()
    else:
         my_db.close()

    if DEBUG: debug_nicely(locals(),sys._getframe(0).f_code.co_name,sys._getframe(1).f_code.co_name, 'Complete.')

    #----------------------------------------------------------------------------------------------
def Util_copy_control(my_db, my_cursor, notifications,log):

    global my_terminate_early

    log("Copying Pristine Authors to Q&S metadata.db")
    notifications.put((0.0001, 'Copying Pristine Authors to Q&S metadata.db'))

    copy_pristine_authors(my_db, my_cursor, notifications, log)

    log("Copying Pristine Series to Q&S metadata.db")
    notifications.put((0.81, 'Copying Pristine Series to Q&S metadata.db'))

    copy_pristine_series(my_db, my_cursor, notifications, log)

    log("Copying Pristine Author/Series Links to Q&S metadata.db")
    notifications.put((0.90, 'Copying Pristine Author/Series Links to Q&S metadata.db'))

    copy_pristine_author_series_link(my_db, my_cursor, notifications, log)

    log("Finished Copying Pristine Data to Q&S metadata.db")
    notifications.put((0.99, 'Finished Copying Pristine Data to Q&S metadata.db'))

    my_db.close()

    #----------------------------------------------------------------------------------------------
def copy_pristine_authors(my_db, my_cursor, notifications, log):

    global my_terminate_early

    sleep(1.0)

    try:
        my_cursor.execute("BEGIN TRANSACTION")
        mysql = "DELETE FROM main._pristine_authors WHERE id >= 0 "
        my_cursor.execute(mysql)
        my_db.commit()
    except Exception as e:
        log( str(e))
        if DEBUG: print( str(e))
        my_terminate_early = True
        raise e

    sleep(1.0)

    my_cursor.execute("BEGIN TRANSACTION")
    mysql = "INSERT or IGNORE INTO main._pristine_authors SELECT * FROM Calibre.authors   ;"
    my_cursor.execute(mysql)
    my_db.commit()

    log("Completed Copying Pristine Authors.  Continuing.")

    sleep(1.0)

    try:
        mysql = "REINDEX _pristine_authors_index"
        my_cursor.execute(mysql)
        my_db.commit()
    except Exception as e:
        if DEBUG: print(mysql)
        if DEBUG: print( str(e))
        raise e



    #----------------------------------------------------------------------------------------------
def copy_pristine_series(my_db, my_cursor, notifications, log):

    global my_terminate_early

    sleep(2.0)

    try:
        my_cursor.execute("BEGIN TRANSACTION")
        mysql = "DELETE FROM main._pristine_series WHERE id >= 0 "
        my_cursor.execute(mysql)
        my_db.commit()
    except Exception as e:
        log( str(e))
        if DEBUG: print( str(e))
        my_terminate_early = True
        raise e

    sleep(2.0)

    try:
        my_cursor.execute("BEGIN TRANSACTION")
        mysql = "INSERT or IGNORE INTO main._pristine_series SELECT * FROM Calibre.series WHERE id > 0 "
        my_cursor.execute(mysql)
        my_db.commit()
    except Exception as e:
        log( str(e))
        if DEBUG: print( str(e))
        my_terminate_early = True
        raise e

    sleep(1.0)

    try:
        mysql = "REINDEX _pristine_series_index"
        my_cursor.execute(mysql)
        my_db.commit()
    except Exception as e:
        if DEBUG: print(mysql)
        if DEBUG: print( str(e))
        raise e



     #----------------------------------------------------------------------------------------------
def copy_pristine_author_series_link(my_db, my_cursor, notifications, log):

    global my_terminate_early

    sleep(1.0)

    try:
        my_cursor.execute("BEGIN TRANSACTION")
        mysql = "DELETE FROM main._pristine_author_series_link WHERE id >= 0 "
        my_cursor.execute(mysql)
        my_db.commit()
    except Exception as e:
        log( str(e))
        if DEBUG: print( str(e))
        my_terminate_early = True
        raise e

    sleep(2.0)

    try:
        mysql =  "INSERT OR IGNORE INTO main._pristine_author_series_link (id,authid,seriesid) SELECT DISTINCT null, \
              (SELECT id FROM Calibre.authors WHERE authors.id IN (SELECT author FROM Calibre.books_authors_link \
              WHERE book = books.id)) authid,(SELECT id FROM Calibre.series WHERE series.id IN (SELECT series \
              FROM Calibre.books_series_link WHERE book=books.id)) seriesid FROM Calibre.books WHERE seriesid >= 0  ;"

        my_cursor.execute("BEGIN TRANSACTION")
        my_cursor.execute(mysql)
        my_db.commit()
    except Exception as e:
        if DEBUG: print(mysql)
        if DEBUG: print( str(e))
        log(mysql)
        log( str(e))
        raise e

    sleep(2.0)

    try:
        mysql = "REINDEX _pristine_author_series_link_index_a"
        my_cursor.execute(mysql)
        my_db.commit()
    except Exception as e:
        if DEBUG: print(mysql)
        if DEBUG: print( str(e))
        raise e

    sleep(1.0)

    try:
        mysql = "REINDEX _pristine_author_series_link_index_b"
        my_cursor.execute(mysql)
        my_db.commit()
    except Exception as e:
        if DEBUG: print(mysql)
        if DEBUG: print( str(e))
        raise e


  #----------------------------------------------------------------------------------------------------------------
def Attach_Calibre_metadata_db(my_db, my_cursor, path, notifications, log):

    global my_terminate_early

    sleep(0.5)

    from calibre_plugins.quarantine_and_scrub.config import prefs
    pristine_path = prefs['pristine_library']
    log(" ")
    pristine_path = pristine_path.replace(os.sep, '/')
    log("Configured Pristine Library Path is: " + str(pristine_path))
    log(" ")
    path = path.replace(os.sep, '/')
    log("Current Q&S Library Path is: " + str(path))
    log(" ")

    if pristine_path == path:
        my_terminate_early = True
        if DEBUG: print("ERROR.  Pristine Calibre Library Cannot Be The Q+S Library!")
        log("ERROR.  Pristine Calibre Library Cannot Be The Q+S Library!")
        return

    try:
        s1 = "ATTACH DATABASE '"
        s2 =  "'  As 'Calibre';"
        mysql = s1 + pristine_path + s2
        if isbytestring(mysql):
            mysql = mysql.decode(filesystem_encoding)
        my_cursor.execute(mysql)
        if DEBUG: print("Calibre Pristine Library metadata.db has been properly attached")
        log("Calibre Pristine Library metadata.db has been properly attached")
    except Exception as e:
        if DEBUG: print("Calibre Pristine Library metadata.db has NOT been properly attached")
        if DEBUG: print(mysql)
        if DEBUG: print( str(e))
        s = str(e)
        log(s)
        my_db.close()
        if DEBUG: print("terminating early...")
        log("terminating early...")
        my_terminate_early = True
        return

    #now test the connection using a Calibre metadata.db table...
    mysql = "select id from Calibre.books where id < 1000000 ;"
    mysql = str(mysql)
    try:
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchone() #will get the first row from the query
        n = len(tmp_rows)
        if n > 0:
            del tmp_rows
            return
        else:
            if DEBUG: print("Calibre metadata.db has NOT been properly attached")
            log("Calibre metadata.db has NOT been properly attached")
            my_db.close()
            if DEBUG: print("terminating early...")
            log("terminating early...")
            my_terminate_early = True
            return
    except Exception as e:
        if DEBUG: print("Calibre metadata.db has NOT been properly attached")
        if DEBUG: print( str(e))
        s = str(e)
        log(s)
        my_db.close()
        if DEBUG: print("terminating early...")
        log("terminating early...")
        my_terminate_early = True
        return

    #----------------------------------------------------------------------------------------------------------------
def Detach_Calibre_metadata_db(my_db, my_cursor, notifications, log):

    try:
        mysql = "DETACH DATABASE 'Calibre' "
        my_cursor.execute(mysql)
        log("Calibre Pristine Library metadata.db has been detached")
        if DEBUG: print("Calibre Pristine Library metadata.db has been detached")
    except:
        pass

 #---------------------------------------------------------------------------------------------------------------------------------------------

#END of copypristine.py
