# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.2.5"   #  Links

import os, sys, sqlite3
from time import sleep

from calibre import isbytestring
from calibre.constants import iswindows, filesystem_encoding, DEBUG
from calibre.gui2.threaded_jobs import ThreadedJob
from calibre.utils.logging import Log

from polyglot.builtins import as_unicode
from polyglot.queue import Queue

custom_table = "custom_column_X"
custom_id = 999

my_terminate_early = False

notifications = Queue()
log = Log()

my_results_list = []
is_testing = False    #if True, does not create TEMP tables...and creates physical db...

# ----------------------------------------------------------------------------------------
#    Creates an Author Book Count Hierarchy for all books in the library
# -----------------------------------------------------------------------------------------

def Create_ABC_Hierarchy(self, my_guidb, log=None, abort=None, notifications=True):

    global my_terminate_early

    notifications.put((0.01, 'Building ABC Hierarchy'))
    log('====================================================')

    self.guidb = my_guidb
    path = my_guidb.library_path
    log("Library path: " + path)

    if is_testing:
        abch_db_path = "X:/testing_temp_db/abch.db"
        if isbytestring(abch_db_path):
            abch_db_path = abch_db_path.decode(filesystem_encoding)
        if DEBUG: print(abch_db_path)
        log(abch_db_path)
        my_db = sqlite3.connect(abch_db_path)
    else:
        my_db = sqlite3.connect(':memory:')
        log("External-to-Calibre SQLite in-memory database is being used")

    my_cursor = my_db.cursor()

    mysql = "PRAGMA main.busy_timeout = 15000;"
    my_cursor.execute(mysql)

    my_terminate_early = False

    ABCH_Control(my_guidb, my_db, my_cursor, log, notifications)

    if not my_terminate_early:
        notifications.put((0.99, 'ABCH Has Completed Processing'))

    my_db.close()

    log('====================================================')
    log('      Author Book Count Hierarchy Is Complete       ')
    log('Every book in this library has been updated for ABCH')
    log('====================================================')
    #-----------------------------------------------------------------------------------------------------------------------------------------------------------
def ABCH_Control(my_guidb, my_db, my_cursor, log, notifications):

        global my_terminate_early

        log("Beginning ABCH for All Books In Library")
        Attach_Calibre_metadata_db(my_guidb, my_db, my_cursor, log)
        Verify_Custom_Column_Exists(my_db, my_cursor, log, notifications)
        log("Custom_Column Configuration Verified")
        notifications.put((0.02, 'Verifying Configuration...'))
        if not my_terminate_early :
            Build_Temp_Tables(my_db, my_cursor, log, notifications)
            log("Temporary Tables Created")
            Detach_Calibre_metadata_db(my_db, my_cursor, log)
            notifications.put((0.03, 'Constructing New ABC Hierarchy...'))
            if not my_terminate_early:
                Populate_zbooks_abc(my_db, my_cursor, log, notifications)
                log("New ABC Hierarchy Constructed")
                notifications.put((0.50, 'Updating Books with New ABC...'))
                if not my_terminate_early :
                    Attach_Calibre_metadata_db(my_guidb, my_db, my_cursor, log)
                    Update_Custom_Column_Tables(my_db, my_cursor, log, notifications)
                    log("Custom_Column Tables Populated")
    #-----------------------------------------------------------------------------------------------------------------------------------------------------------
def Update_Custom_Column_Tables(my_db, my_cursor, log, notifications):
    #wipe then insert the new values in both the custom table and the books custom column link table

    global custom_table
    global custom_id
    global my_terminate_early

    custom_table = as_unicode(custom_table)
    custom_id_string = as_unicode(custom_id)
    books_custom_column_X_link_string = "books_custom_column_X_link"
    books_custom_column_X_link_string =  books_custom_column_X_link_string.replace('X', custom_id_string)
    books_custom_column_X_link = books_custom_column_X_link_string

    my_cursor.execute("BEGIN TRANSACTION")
    mysql = "DELETE FROM " + custom_table + " WHERE id > '0' "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if my_terminate_early:
        log("Job Failure.  Terminated.  ")
        return

    my_cursor.execute("BEGIN TRANSACTION")
    mysql = "DELETE FROM " + books_custom_column_X_link + " WHERE id > '0' "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if my_terminate_early:
        log("Job Failure.  Terminated.  ")
        return

    my_cursor.execute("BEGIN TRANSACTION")
    mysql = "UPDATE sqlite_sequence SET seq = 1 WHERE name = '" + custom_table + "'   ;"
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if my_terminate_early:
        log("Job Failure.  Terminated.  ")
        return

    my_cursor.execute("BEGIN TRANSACTION")
    mysql = "UPDATE sqlite_sequence SET seq = 1 WHERE name = '" + books_custom_column_X_link + "'  ;"
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if my_terminate_early:
        log("Job Failure.  Terminated.  ")
        return

    my_cursor.execute("BEGIN TRANSACTION")
    mysql = "INSERT OR IGNORE INTO " + custom_table + " SELECT id, abc,'' FROM zabc WHERE id > '0' ;"
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if my_terminate_early:
        log("Job Failure.  Terminated.  ")
        return

    my_cursor.execute("BEGIN TRANSACTION")
    mysql = "UPDATE " + custom_table + " SET value = replace(value,'|',',') "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if my_terminate_early:
        log("Job Failure.  Terminated.  ")
        return

    sleep(0)

    mysql = "SELECT book,'dummy' FROM zbooks_abc WHERE book IS NOT NULL "
    my_cursor.execute(mysql)
    my_books = my_cursor.fetchall()
    if not my_books:
        log("Job Failure.  Terminated.  ")
        my_terminate_early = True
        return
    else:
        if len(my_books) == 0:
            log("Job Failure.  Terminated.  ")
            my_terminate_early = True
            return

    n = len(my_books)
    i = 0
    my_cursor.execute ("BEGIN TRANSACTION")
    for row in my_books:
        i = i + 1
        tmp_book,dummy = row
        tmp_book = as_unicode(tmp_book)

        mysql = "SELECT id,'dummy' FROM zabc WHERE zabc.abc IN (SELECT abc FROM zbooks_abc \
                                                           WHERE book = '" + tmp_book + "' );"
        my_cursor.execute (mysql)
        tmp_tmp_list = my_cursor.fetchall()
        if tmp_tmp_list:
            mysql = "INSERT OR IGNORE INTO " + books_custom_column_X_link + " SELECT null, book, id \
                                           FROM zbooks_abc WHERE book = '" + tmp_book + "'  ;"
            #~ if DEBUG: print(mysql)
            Execute_mysql_without_commit_generic(my_db, my_cursor, log, mysql)

            n_float = (0.5 + (0.5*(i/n) ) )
            notifications.put((n_float, 'Updating ' + as_unicode(n) + ' Books...'))
        else:
            if DEBUG: print("Error Updating books_custom_column_X_link_.  No id found from SELECT id FROM zabc for: ", tmp_book)
            log("Error Updating books_custom_column_X_link_.  No id found from SELECT id FROM zabc for: ", tmp_book)
            #~ if DEBUG: print(mysql)
    #END FOR
    try:
        my_db.commit()
    except:
        pass
    #-----------------------------------------------------------------------------------------------------------------------------------------------------------
def Populate_zbooks_abc(my_db, my_cursor, log, notifications):

    my_list = []
    my_work_list = []
    my_book_list = []
    my_books = []
    my_zbooks_abc_list = []
    tmp_list2 = []
    my_rows = []

    global my_results_list
    my_results_list = []

    mysql = "SELECT book,'dummy' FROM zbooks_authors WHERE book IS NOT NULL "
    my_cursor.execute (mysql)
    my_books = my_cursor.fetchall()
    if my_books is None:
        my_books = []
    my_books = list(set(my_books))
    my_books.sort()

    for item in my_books:  #now only unique values for a book in this list
        tmp_book,dummy = item
        tmp_book = as_unicode(tmp_book)
        my_book_list.append(tmp_book)
    #END FOR
    del my_books

    my_cursor.execute ("BEGIN TRANSACTION")
    for tmp_book in my_book_list:
        mysql = "SELECT author_name, author_count FROM zbooks_authors WHERE book = '" + tmp_book + "' ;"
        my_cursor.execute (mysql)
        my_rows = my_cursor.fetchall()  #all of the authors for the same book
        del my_work_list
        my_work_list = []
        appnd = ""
        for row in my_rows:  # 1 row for each co-author of the identical current book
            author_name, author_count = row
            author_name = as_unicode(author_name)
            author_count = as_unicode(author_count)
            appnd =  author_count + "$$" + author_name  + "(" + author_count + ")"     #now:   "7$$Evangeline Anderson(7)"
            my_work_list.append(appnd)
        #END FOR

        del my_rows
        my_work_list.sort(reverse=True) #sort in-place; sorted by author_count and then author_name

        #after sorting, can remove leading abc value from each row     #now:   "7$Evangeline Anderson(7)"

        my_highest_abc = 0
        tmp_split_list = []
        tmp_list2 = []

        for tmp_abc in my_work_list:   #now:   "7$$Evangeline Anderson(7)"
            tmp_split_list = tmp_abc.split("$$")
            tmp_list2.append(tmp_split_list[1])  #now "Evangeline Anderson(7)"
            n = tmp_split_list[0].strip()
            if n.isdigit():
                n = int(n)
                if n > my_highest_abc:
                    my_highest_abc = n
        #END FOR
        tmp_split_list = []
        del tmp_split_list

        tmp_abc = ""
        n = 0
        for row in tmp_list2:   #desired format:  7  Evangeline Anderson(7) Reese Dante(1) Barb Rice(1)
            n = n + 1
            #now concatenate all the rows for the current tmp_book  into a single row appropriate for a Tag Browser Hierarchy
            if n == 1:
                tmp_abc = tmp_abc + " " + row    #without leading abc,           e.g.      Evangeline Anderson(7) Reese Dante(1) Barb Rice(1)
            else:
                tmp_abc = tmp_abc + " " + row
        #END FOR
        del tmp_list2

        tmp_abc = tmp_abc.strip()      # Remove unnecessary blank space from final ABCH value.

        mysql = 'INSERT OR IGNORE INTO zabc (id, abc) VALUES (null, "' + tmp_abc + '" );'
        #~ if DEBUG: print(mysql)
        Execute_mysql_without_commit_generic(my_db, my_cursor, log, mysql)

        appnd = tmp_book,tmp_abc
        my_zbooks_abc_list.append(appnd)

    #END FOR
    try:
        my_db.commit()
    except:
        pass

    del my_book_list

    my_zbooks_abc_list.sort()

    tmp_tmp_list = []

    my_cursor.execute ("BEGIN TRANSACTION")
    for row in my_zbooks_abc_list:
        tmp_book,tmp_abc = row
        if '"' in tmp_abc:
            if DEBUG: print("author name has double quotes; skipping: ", tmp_abc)
            continue
        mysql = 'SELECT id,id FROM zabc WHERE abc = "' + tmp_abc + '" ;'
        #~ if DEBUG: print(mysql)
        try:
            my_cursor.execute(mysql)
        except:    # e.g.  INSERT OR IGNORE INTO zabc (id, abc) VALUES (null, "Un"known" ".(1)" )     author has unescaped double quotes...
            continue
        tmp_tmp_list = my_cursor.fetchall()
        if not tmp_tmp_list:
            tmp_tmp_list = []
        for row in tmp_tmp_list:
            id,dummy = row
            tmp_id = as_unicode(id)
            mysql = 'INSERT OR IGNORE INTO zbooks_abc (book, abc, id) VALUES ("' + tmp_book + '","' +  tmp_abc + '","' + tmp_id + '" ) ;'
            #~ if DEBUG: print(mysql)
            Execute_mysql_without_commit_generic(my_db, my_cursor, log, mysql)
        #END FOR
    #END FOR
    del tmp_tmp_list
    try:
        my_db.commit()
    except:
        pass
   #-----------------------------------------------------------------------------------------------------------------------------------------------------------
def Build_Temp_Tables(my_db, my_cursor, log, notifications):

    global is_testing

    if not is_testing:
        mysql = "CREATE TEMP TABLE IF NOT EXISTS zbooks_authors(book INTEGER NOT NULL,\
                author_id INTEGER NOT NULL,\
                author_name TEXT COLLATE NOCASE DEFAULT NULL,\
                author_count INTEGER DEFAULT NULL,\
                PRIMARY KEY (book, author_id)  )"
    else:
        mysql = "CREATE TABLE IF NOT EXISTS zbooks_authors(book INTEGER NOT NULL,\
        author_id INTEGER NOT NULL,\
        author_name TEXT COLLATE NOCASE DEFAULT NULL,\
        author_count INTEGER DEFAULT NULL,\
        PRIMARY KEY (book, author_id)  )"
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    mysql = "DELETE FROM zbooks_authors WHERE book > '0' "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    mysql = "INSERT OR IGNORE INTO zbooks_authors (book, author_id)\
             SELECT book, author  FROM books_authors_link  WHERE book > 0 and author > 0 "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    mysql = "UPDATE zbooks_authors SET author_name = (SELECT name FROM authors \
                                                    WHERE authors.id = zbooks_authors.author_id) "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    mysql = "UPDATE zbooks_authors SET author_count = (SELECT COUNT(id) FROM books_authors_link \
                                                    WHERE author=zbooks_authors.author_id) "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if not is_testing:
        mysql = "CREATE TEMP TABLE IF NOT EXISTS zbooks_abc (book INTEGER NOT NULL,abc TEXT COLLATE NOCASE DEFAULT NULL,\
                                        id INTEGER, PRIMARY KEY (book)  ) "
    else:
        mysql = "CREATE TABLE IF NOT EXISTS zbooks_abc (book INTEGER NOT NULL,abc TEXT COLLATE NOCASE DEFAULT NULL,\
                                id INTEGER, PRIMARY KEY (book)  ) "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    mysql = "DELETE FROM zbooks_abc WHERE book > '0' "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if not is_testing:
        mysql = "CREATE TEMP TABLE IF NOT EXISTS zabc ( id INTEGER PRIMARY KEY AUTOINCREMENT, abc TEXT NOT NULL COLLATE NOCASE)"
    else:
        mysql = "CREATE TABLE IF NOT EXISTS zabc ( id INTEGER PRIMARY KEY AUTOINCREMENT, abc TEXT NOT NULL COLLATE NOCASE)"
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    mysql = "DELETE FROM zabc WHERE id > '0' "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    my_cursor.execute ("BEGIN TRANSACTION")
    mysql = "UPDATE sqlite_sequence SET seq = 1 WHERE name = 'zabc'   ;"
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    mysql = "SELECT COUNT(id) FROM authors WHERE name LIKE '%| %'  "
    my_cursor.execute(mysql)
    rows = my_cursor.fetchall()
    if not rows:
        rows = []
    if len(rows) > 0:
        for row in rows:
            for col in row:
                n = col
        log("-------------------------------------------------------------------------------------------------------------------------------------")
        msg = "Number of authors with a bar '|' due to a LN,FN format: " + as_unicode(n)
        log(msg)
        del rows
        mysql = "SELECT COUNT(id) FROM authors WHERE name  NOT LIKE '%| %'  AND name LIKE '%, %'  "
        my_cursor.execute(mysql)
        rows = my_cursor.fetchall()
        if not rows:
            rows = []
        if len(rows) > 0:
            for row in rows:
                for col in row:
                    n = col
                #END FOR
            #END FOR
            if n > 0:
                n = as_unicode(n)
                msg = "Number of authors without a bar '|' but with a comma: " + n + "  This could be correct, such as for a suffix.  However, if your #abc_hierarchy is incorrect, then this is likely the cause. "
                log(msg)
                log("To fix a corrupt author name as described above, simply manually change the author from LN,FN to FN,LN.  Save.  Then, manually change it back to LN,FN.  It should now be fixed.")
            else:
                msg = "Number of authors without a bar '|' but with a comma:  0  "
                log("")
        del rows
        log("-------------------------------------------------------------------------------------------------------------------------------------")
   #----------------------------------------------------------------------------------------------------------------------------------------------------------
def Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql):
    global my_terminate_early
    try:
        my_cursor.execute (mysql)
        my_db.commit()
    except Exception as e:
        log("Exception in Execute_mysql_with_commit_generic(my_db, my_cursor, mysql, log) ")
        log(as_unicode(e))
        log(mysql)
        my_terminate_early = True
  #----------------------------------------------------------------------------------------------------------------------------------------------------------
def Execute_mysql_without_commit_generic(my_db, my_cursor, log, mysql):
    global my_terminate_early
    try:
        my_cursor.execute (mysql)
    except Exception as e:
        log("       --------------------------------------")
        log("Exception in Execute_mysql_without_commit_generic(my_db, my_cursor, log, mysql) ")
        log(as_unicode(e))
        log(mysql)
        if as_unicode('"') in as_unicode(e) and as_unicode("syntax") in as_unicode(e):   # double quotes in an author's name caused mysql syntax error
            log("...double quotes in an author's name caused mysql syntax error...continuing...")
        else:
            log("...terminating job early...")
            my_terminate_early = True
        log("       --------------------------------------")
    #-----------------------------------------------------------------------------------------------------------------------------------------------------------
def Verify_Custom_Column_Exists(my_db, my_cursor, log, notifications):

        # Determine what the custom column Author Book Count Hierarchy has as a physical field name as added previously by the user manually

        global custom_table
        global custom_id
        global my_terminate_early

        custom_table = "custom_column_X"
        custom_id = 999

        mysql = "SELECT id FROM custom_columns WHERE label = 'abc_hierarchy' "
        my_cursor.execute(mysql)
        rows = my_cursor.fetchall()
        if not rows:
            log("No Custom Table Column abc_hierarchy Configured By User Yet.")
            log("Plugin terminated. Add abc_hierarchy as a custom column.")
            my_terminate_early = True
        else:
            if len(rows) == 0:
                log("No Custom Table Column abc_hierarchy Configured By User Yet.")
                log("Plugin terminated. Add abc_hierarchy as a custom column.    ")
                my_terminate_early = True
            else:
                for row in rows:
                    for col in row:
                        custom_id = col

        s = as_unicode(custom_table)
        custom_id_string = as_unicode(custom_id)
        custom_table = s.replace(as_unicode('X'), custom_id_string)

        if custom_table == "custom_column_999" or custom_table == "custom_column_X":
            log("No Custom Table Column abc_hierarchy Configured By User Yet.")
            log("Plugin terminated. Add abc_hierarchy as a custom column.    ")
            my_terminate_early = True
    #-----------------------------------------------------------------------------------------------------------------------------------------------------------
def Attach_Calibre_metadata_db(my_guidb, my_db, my_cursor, log):
    global my_terminate_early

    path = my_guidb.library_path
    if isbytestring(path):
        path = path.decode(filesystem_encoding)
    path = path.replace(os.sep, '/')
    path = os.path.join(path, 'metadata.db')
    path = path.replace(os.sep, '/')

    try:
        s1 = "ATTACH DATABASE '"
        s2 =  "'  As 'Calibre';"
        mysql = s1 + path + s2
        if isbytestring(mysql):
            mysql = mysql.decode(filesystem_encoding)
        my_cursor.execute(mysql)
        if DEBUG: print("Calibre metadata.db has been properly attached")
        if DEBUG: print(path)
        log("Calibre metadata.db has been properly attached")
        log(path)
    except Exception as e:
        if DEBUG: print("Calibre metadata.db has NOT been properly attached")
        if DEBUG: print(mysql)
        if DEBUG: print(as_unicode(e))
        s = as_unicode(e)
        log(s)
        my_db.close()
        if DEBUG: print("terminating early...")
        log("terminating early...")
        my_terminate_early = True
   #----------------------------------------------------------------------------------------------------------------
def Detach_Calibre_metadata_db(my_db, my_cursor, log):
    try:
        mysql = "DETACH DATABASE 'Calibre' "
        my_cursor.execute(mysql)
        if DEBUG: print("Calibre metadata.db has been detached")
        log("Calibre metadata.db has been detached")
    except Exception as e:
        pass
      #---------------------------------------------------------------------------------------------------
#END of main.py
