# -*- coding: utf-8 -*-
__my_version__ = "1.0.14"  # Change mappings of A1-A4 to #ris_primary_authors etc.
#--------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------
#~ Generic RIS Tag Descriptions
#--------------------------------------------------------------------------------------------
#~ Important: the tag descriptions must be unique to their tag, or key errors will occur.
#--------------------------------------------------------------------------------------------
#~ __my_version__ = "1.0.13"  #  # Change mappings of C0-C9 & U0-U5 for PubMed NBIB .nbib files
ris_tag_desc_mapping_dict = {\
                                     'A1': 'first_authors',
                                     'A2': 'secondary_authors',
                                     'A3': 'tertiary_authors',
                                     'A4': 'subsidiary_authors',
                                     'AB': 'abstract',
                                     'AD': 'author_address',
                                     'AN': 'accession_number',
                                     'AU': 'authors',
                                     'AV': 'location_in_archives',
                                     'BT':  'user_defined/secondary_title',
                                     'C1': 'custom1',   # C1-C8 + C0 have been redefined for NBIB; see Job Spy Tool that converts NBIB to RIS.  __my_version__ = "1.0.13"
                                     'C2': 'custom2',
                                     'C3': 'custom3',
                                     'C4': 'custom4',
                                     'C5': 'custom5',
                                     'C6': 'custom6',
                                     'C7': 'custom7',
                                     'C8': 'custom8',
                                     'CA': 'caption',
                                     'CN': 'call_number',
                                     'CP': 'pmid',    #changed from 'User Defined' to PMID in 'BIB', since virtually all Life Sciences citations use .nbib with a PMID...which is why RIS was exchanged for NBIB.  __my_version__ = "1.0.12"
                                     'CT': 'title_of_unpublished_reference',
                                     'CY': 'place_published',
                                     'DA': 'date',
                                     'DB': 'name_of_database',
                                     'DO': 'doi',
                                     'DP': 'database_provider',
                                     'ED': 'editor',
                                     'EP': 'end_page',
                                     'ER': 'end_of_reference',
                                     'ET': 'edition',
                                     'ID': 'reference_id',
                                     'IS':	'issue_number',
                                     'J1': 'periodical_name_user_abbreviation',
                                     'J2': 'alternate_title',
                                     'JA': 'journal_periodical_name_abbreviation',
                                     'JF':	'journal_periodical_name_full',
                                     'JO': 'journal_name',
                                     'KW': 'keywords',
                                     'L1': 'file_attachments1/pdf',
                                     'L2': 'file_attachments2',
                                     'L3': 'related_records',
                                     'L4': 'image(s)',
                                     'LA': 'language',
                                     'LB': 'label',
                                     'LK': 'website_link',
                                     'M1': 'note',
                                     'M2': 'miscellaneous',
                                     'M3': 'type_of_work',
                                     'N1': 'notes',
                                     'N2': 'notes/abstract',
                                     'NV': 'number_of_volumes',
                                     'OP': 'original_publication',
                                     'PB': 'publisher',
                                     'PP': 'publishing_place',
                                     'PY': 'publication_year',
                                     'RI': 'reviewed_item',
                                     'RN': 'research_notes',
                                     'RP': 'reprint_edition',
                                     'SE': 'section',
                                     'SN': 'isbn/issn',
                                     'SP': 'start_page',
                                     'ST': 'short_title',
                                     'T1': 'primary_title',
                                     'T2': 'secondary_title',
                                     'T3': 'tertiary_title',
                                     'TA': 'translated_author',
                                     'TI': 'primary_title_other',
                                     'TT': 'translated_title',
                                     'TY': 'type_of_reference',
                                     'U1': 'user_definable_1',  # U1-U5 have been redefined for NBIB; see Job Spy Tool that converts NBIB to RIS.  __my_version__ = "1.0.13"
                                     'U2': 'user_definable_2',
                                     'U3': 'user_definable_3',
                                     'U4': 'user_definable_4',
                                     'U5': 'user_definable_5',
                                     'UK': 'unknown_tag',
                                     'UR': 'url',
                                     'VL': 'volume',
                                     'VO': 'published_standard_number',
                                     'Y1': 'publication_year',
                                     'Y2': 'access_date'\
                                     }
#--------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------
#~ Default Tag Mappings to *All* Supported Calibre Standard Columns
#--------------------------------------------------------------------------------------------
#~ __my_version__ = "1.0.14"  # Change mappings of A1-A4 to #ris_primary_authors etc.
    #~ 'A1': 'authors',   #ris_first_authors
    #~ 'A2': 'authors',  #ris_secondary_authors
    #~ 'A3': 'authors',  #ris_tertiary_authors
    #~ 'A4': 'authors',  #ris_subsidiary_authors
ris_tag_column_mapping_dict = \
                                     {'AU': 'authors',
                                      'DA': 'pubdate',
                                      'DO': 'identifiers',
                                      'ER': 'reserved',
                                      'KW': 'tags',
                                      'LA': 'languages',
                                      'M1': 'comments',
                                      'N1': 'comments',
                                      'N2': 'comments',
                                      'PB': 'publisher',
                                      'SN': 'identifiers',
                                      'T1': 'title'}
#--------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------