# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.85"  # Qt6

from qt.core import (Qt, QImage, QPalette, QPixmap, QSize, QApplication, QLabel, QVBoxLayout,
                                      QDialog, QPushButton, QMessageBox, QScrollArea, QSizePolicy)

IMAGE_DEFAULT_WIDTH = 450
IMAGE_DEFAULT_HEIGHT = 680

class ImageViewerDialog(QDialog):
    def __init__(self,icon_image,path=None):
        super(ImageViewerDialog, self).__init__()

        self.path = path

        if self.path:
            image = QImage(self.path)
            if image.isNull():
                QMessageBox.information(self, "CalibreSpy Book Cover Viewer", ("Cannot load: " + self.path))

        self.setWindowFlags(Qt.Window | Qt.WindowTitleHint | Qt.WindowCloseButtonHint | Qt.WindowMinMaxButtonsHint)
        self.setModal(False)
        self.setWindowIcon(icon_image)
        self.setWindowTitle("CalibreSpy")

        self.layout = QVBoxLayout()
        self.layout.setAlignment(Qt.AlignLeft)
        self.setLayout(self.layout)

        self.imageLabel = QLabel()
        self.imageLabel.setBackgroundRole(QPalette.Base)
        self.imageLabel.setSizePolicy(QSizePolicy.Ignored, QSizePolicy.Ignored)
        self.imageLabel.setScaledContents(True)

        self.layout.addWidget(self.imageLabel)

        self.scrollArea = QScrollArea()
        self.scrollArea.setBackgroundRole(QPalette.Dark)
        self.scrollArea.setWidget(self.imageLabel)
        self.scrollArea.setWidgetResizable(True)
        self.layout.addWidget(self.scrollArea)

        self.scrollArea.ensureVisible(IMAGE_DEFAULT_WIDTH,IMAGE_DEFAULT_HEIGHT)

        self.scrollArea.setHorizontalScrollBarPolicy(Qt.ScrollBarAlwaysOn)
        self.scrollArea.setVerticalScrollBarPolicy(Qt.ScrollBarAlwaysOn)

        self.resize(IMAGE_DEFAULT_WIDTH,IMAGE_DEFAULT_HEIGHT)

        p = QPixmap.fromImage(image)
        size = QSize(IMAGE_DEFAULT_WIDTH,IMAGE_DEFAULT_HEIGHT)
        p = p.scaled(size, Qt.KeepAspectRatio, Qt.SmoothTransformation)
        self.imageLabel.setPixmap(p)

        self.exit_pushbutton = QPushButton("Exit", self)
        self.exit_pushbutton.clicked.connect(self.done)
        self.layout.addWidget(self.exit_pushbutton)
#~ # end of image_viewer_dialog.py