# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.85"  # Qt6

from qt.core import (Qt, QMimeData, QDialog, QLabel, QWidget,
                                       QIcon, QGroupBox, QMargins, QScrollArea, QSize, QVBoxLayout)

import re
from polyglot.builtins import as_unicode
from polyglot.builtins import native_string_type

DSR_DEFAULT_WIDTH = 60
DSR_DEFAULT_HEIGHT = 50
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class DropSearchResultsDialogBase(QDialog):
    def __init__(self):
        QDialog.__init__(self, None)
    def resize_dialog_to_defaults(self):
        size = QSize()
        size.setWidth(DSR_DEFAULT_WIDTH)
        size.setHeight(DSR_DEFAULT_HEIGHT)
        self.resize(size)
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class DropSearchResultsDialog(DropSearchResultsDialogBase):

    def __init__(self,icon,pixmap_dsr,font,style_text,process_file_paths):
        DropSearchResultsDialogBase.__init__(self)
        self.process_file_paths = process_file_paths
        self.setWindowFlags(Qt.CustomizeWindowHint | Qt.Dialog | Qt.WindowTitleHint | Qt.WindowStaysOnTopHint | Qt.WindowCloseButtonHint )
        self.setWindowState(Qt.WindowActive)
        self.setAcceptDrops(True)
        self.setWindowTitle(' ')
        self.setWindowIcon(icon)

        self.setStyleSheet(style_text)
        #~ self.setStyleSheet("QToolTip { color: #000000; background-color: #ffffcc; border: 1px solid white; }")

        self.setToolTip("<p style='white-space:wrap'>Drop the full paths for Calibre books that already exist in the current Calibre library anywhere within this area.")

        self.layout_top = QVBoxLayout()
        self.layout_top.setAlignment(Qt.AlignCenter)
        self.setLayout(self.layout_top)

        self.drop_label = QLabel()
        self.drop_label.setAlignment(Qt.AlignCenter)
        self.drop_label.setPixmap(pixmap_dsr)
        self.layout_top.addWidget(self.drop_label)
        #-----------------------------------------------------
        self.resize_dialog_to_defaults()
    #----------------------------------------------------
    def dragEnterEvent(self, e):
        if e.mimeData().hasText():
            e.accept()
        else:
            e.ignore()
    #----------------------------------------------------
    def dropEvent(self, e):
        data = e.mimeData().text()
        self.convert_mime_data(data)
    #----------------------------------------------------
    def convert_mime_data(self,data):
        data = native_string_type(data)
        book_list = []
        if data.count("file:") > 0:     # standard MIME drag-and-drop format  for files:    file:///s:/.....
            file_list = data.split("file:")
            if len(file_list) > 0:
                my_re = "[(][0-9]+[)][/]"
                p = re.compile(my_re)
                for path in file_list:
                    path = path.strip()
                    match_book_id = p.search(path)
                    if match_book_id:
                        s = match_book_id.group(0)
                        s = s.replace("(","")
                        s = s.replace(")","")
                        s = s.replace("/","")
                        s = s.strip()
                        if s.isdigit():
                            id = int(s)
                            book_list.append(id)
                #END FOR
        else:
            if DEBUG: print(as_unicode(data))  # do nothing, but can inspect the data format if desired...

        self.process_file_paths(book_list)

        self.close()
    #----------------------------------------------------
#END OF drop_widget_dialog.py