# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.85"  # Qt6

from qt.core import Qt, QTextEdit, QVBoxLayout, QDialog, QPushButton, QTextOption, QAbstractScrollArea

COMMENTS_DEFAULT_WIDTH = 450

class CommentsViewerSingleDialog(QDialog):
    def __init__(self,icon_comments,title,comments,font,normal_fontsize,style_text):
        super(CommentsViewerSingleDialog, self).__init__()

        font.setPointSize(normal_fontsize + 2)
        self.setStyleSheet(style_text)
        #~ self.setStyleSheet("QToolTip { color: #000000; background-color: #ffffcc; border: 1px solid white; }")

        self.setWindowFlags(Qt.Window | Qt.WindowTitleHint | Qt.WindowCloseButtonHint | Qt.WindowMinMaxButtonsHint)
        self.setModal(False)
        self.setWindowIcon(icon_comments)
        title = "CalibreSpy:   " + title
        self.setWindowTitle(title)
        self.setSizeGripEnabled(True)
        self.setModal(False)

        self.layout = QVBoxLayout()
        self.layout.setAlignment(Qt.AlignLeft)
        self.setLayout(self.layout)

        self.comments_qtextedit =  QTextEdit("")
        self.comments_qtextedit.setFont(font)
        self.comments_qtextedit.setReadOnly(True)
        self.comments_qtextedit.setWordWrapMode(QTextOption.WrapMode.WordWrap)
        self.comments_qtextedit.setSizeAdjustPolicy(QAbstractScrollArea.SizeAdjustPolicy.AdjustToContents)
        self.comments_qtextedit.setMinimumWidth(COMMENTS_DEFAULT_WIDTH)
        self.comments_qtextedit.setMaximumWidth(COMMENTS_DEFAULT_WIDTH)
        self.comments_qtextedit.clear()
        self.comments_qtextedit.setHtml(comments)
        self.layout.addWidget(self.comments_qtextedit)

        self.resize(self.comments_qtextedit.size())

        self.exit_pushbutton = QPushButton("Exit", self)
        self.exit_pushbutton.clicked.connect(self.done)
        self.layout.addWidget(self.exit_pushbutton)
#~ # end of comments_viewer_dialog.py