# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.215"  # Notes Viewer: New: Edit Mode as well as View Mode.

import os,sys,apsw,ast,copy,datetime,json,re,subprocess,time,uuid
from difflib import SequenceMatcher
from functools import partial
from time import sleep

from qt.core import (Qt, QMenu, QDialog, QIcon, QAction, QSize, QWidget, QRegularExpression, QTimer,
                                       QFileDialog,QObject,QApplication, QPoint, QPalette, QComboBox, QInputDialog)

from calibre import isbytestring, sanitize_file_name_unicode
from calibre.constants import filesystem_encoding, preferred_encoding, DEBUG, iswindows
from calibre.db.backend import _author_to_author_sort
from calibre.ebooks.metadata.book.base import Metadata
from calibre.gui2 import gprefs, FileDialog, error_dialog, question_dialog, info_dialog, Dispatcher
from calibre.gui2.actions import InterfaceAction
from calibre.utils.config import config_dir, from_json
from calibre.utils.date import format_date
from calibre.utils.html2text import html2text

from polyglot.builtins import as_bytes, as_unicode, codepoint_to_chr, iteritems, map, range, unicode_type

from calibre.ebooks.metadata import title_sort, get_title_sort_pat, author_to_author_sort, string_to_authors, authors_to_string
_title_pats = {}
_ignore_starts = '\'"'+''.join(codepoint_to_chr(x) for x in list(range(0x2018, 0x201e))+[0x2032, 0x2033])

from calibre_plugins.job_spy.__init__ import JS_DESCRIPTION
from calibre_plugins.job_spy.config import prefs,PREFS_NAMESPACE,PREFS_KEY_SETTINGS
from calibre_plugins.job_spy.config import ConfigWidget
from calibre_plugins.job_spy.common_utils import set_plugin_icon_resources, get_icon, get_pixmap, get_local_images_dir, create_menu_action_unique
from calibre_plugins.job_spy.jobs import start_threaded_js_extract_original_title_translator, start_threaded_js_add_null_values

if 'GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_REGEX' in prefs:
    VL_REGEX = prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_REGEX']
else:
    VL_REGEX = "[-]+[0-9]+$"


TAG_CAPITALIZATION_RULES = "Tag Capitalization Rules"
TAG_COMBINATION_RULES = "Tag Combination Rules"
TAG_RULES = "Tag Rules"
TAG_STRING_REPLACEMENT_RULES = "Tag String Replacement Rules"
TAG_PREFIX_SUFFIX_RULES = "Tag Prefix Suffix Rules"
TAG_SPLITTING_RULES = "Tag Splitting Rules"

HEADER_TAG_STRING_REPLACEMENT_TABLE = '"old_string","new_string"'
HEADER_TAG_RULES_TABLE = '"oldtag","newtag","purgetag"'
HEADER_TAG_COMBINATION_RULES_TABLE = '"tag_keyword_1","tag_keyword_2","tag_keyword_3","newtag"'
HEADER_TAG_CAPITALIZATION_RULES_TABLE = '"regex","rule","priority"'
HEADER_TAG_PREFIX_SUFFIX_RULES_TABLE = '"regex","prefix","suffix"'
HEADER_TAG_SPLITTING_RULES_TABLE = '"target","regex","split_string_1","split_string_2","split_string_3","split_string_4"'

PREFS_NAMESPACE = 'JobSpyPlugin'
PREFS_KEY_SETTINGS = 'settings'

PLUGIN_ICONS = ['images/job_spy.png','images/wrench-hammer.png','images/minus.png','images/plus.png', \
'images/execute.png','images/calendar_month.png','images/search.png','images/unlinked.png', \
'images/dropdown.png','images/protect.png','images/piechart.png','images/purge.png','images/reading_list.png',\
'images/translate.png', 'images/html2text.png', 'images/view_manager.png', 'images/ignore.png', 'images/rainbow.png',\
'images/vacuum.png','images/shortcuts.png','images/lookfeel.png','images/exec.png','images/config.png','images/column.png',\
'images/ftp.png','images/empty_value.png','images/change.png', 'images/spreadsheet.png','images/null.png',\
'images/user_category.png','images/polish.png','images/authorsort.png','images/quill.png','images/import.png','images/export.png',
'images/nothing_found.png','images/filenotfound.png','images/tags.png','images/ris_filetype.png']

#-------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------
RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS = False   # development and testing only
if DEBUG:
    if RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS:
        print("RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS", RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS)
#-------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------
class ActionJobSpy(InterfaceAction):

    name = 'Job Spy'
    action_spec = ('JS+','images/job_spy.png', JS_DESCRIPTION, None)
    action_type = 'global'
    accepts_drops = False
    auto_repeat = False
    priority = 1
    popup_type = 1

    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def genesis(self):
        icon_resources = self.load_resources(PLUGIN_ICONS)
        set_plugin_icon_resources(self.name, icon_resources )
        self.menu = QMenu(self.gui)
        self.menu.aboutToShow.connect(self._about_to_show_menu)
        self.built_already = False
        #~ self.build_menus(self.gui)  # must defer until self.guidb exists due to apsw lookup for menu names...dynamic menus...
        self.qaction.setMenu(self.menu)
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.qaction.triggered.connect(self.spy_on_jobs)

        self.tweak_thread_is_running = False
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def _about_to_show_menu(self):
        # Need to rebuild the menus each time shown, because the associated
        # QAction objects likely have changed due to different Group names...
        if not self.built_already:
            return

        self.get_reserved_prefs()   #need column labels for matrix for group names...

        #dynamic names based on the library...the "about to show" is critical for this; otherwise, silent crash in Qt...soon.

        #~ only rebuild self.j3, since that is the only submenu with dynamic menu names...

        self.js3.clear()    # if the user changes a group name, the old menu item with that old name would otherwise still be displayed on the menu...

        unique_name = "JS+:GUI Tool:   Protect/Unprotect Custom Columns from Edit Metadata Dialogs"
        menu_desc = unique_name.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_normal),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js3.addSeparator()

        create_menu_action_unique(self, self.js3, ' ', ' ',
                              triggered=None)
        self.js3.addSeparator()

        unique_name1 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name1 = unique_name1.replace("Group [G]",self.group1_name)
        menu_desc1 = unique_name1.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc1, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group1),unique_name=unique_name1, favourites_menu_unique_name=unique_name1)
        self.js3.addSeparator()

        unique_name2 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name2 = unique_name2.replace("Group [G]",self.group2_name)
        menu_desc2 = unique_name2.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc2, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group2),unique_name=unique_name2, favourites_menu_unique_name=unique_name2)
        self.js3.addSeparator()

        unique_name3 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name3 = unique_name3.replace("Group [G]",self.group3_name)
        menu_desc3 = unique_name3.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc3, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group3),unique_name=unique_name3, favourites_menu_unique_name=unique_name3)
        self.js3.addSeparator()

        unique_name4 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name4 = unique_name4.replace("Group [G]",self.group4_name)
        menu_desc4 = unique_name4.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc4, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group4),unique_name=unique_name4, favourites_menu_unique_name=unique_name4)
        self.js3.addSeparator()

        unique_name5 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name5 = unique_name5.replace("Group [G]",self.group5_name)
        menu_desc5 = unique_name5.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc5, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group5),unique_name=unique_name5, favourites_menu_unique_name=unique_name5)
        self.js3.addSeparator()

        unique_name6 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name6 = unique_name6.replace("Group [G]",self.group6_name)
        menu_desc6 = unique_name6.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc6, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group6),unique_name=unique_name6, favourites_menu_unique_name=unique_name6)
        self.js3.addSeparator()
        #END submenu js3 ----------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def library_changed(self,guidb):

        self.guidb = guidb

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_AUTHOR_SORT_COPY_METHOD'] == unicode_type("True"):
            self.apply_author_sort_method_by_library()
            self.maingui.tags_view.recount()

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_ADD_BOOKS_READ_METADATA_FROM_FILE_CONTENTS_NOT_NAME'] == unicode_type("True"):
            self.apply_read_file_metadata_pref_by_library()

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY'] == unicode_type("True"):
            self.apply_auto_add_directory_by_library(source="library_changed")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY'] == unicode_type("True"):
            self.apply_save_to_directory_by_library(source="library_changed")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] == unicode_type("True"):
            self.apply_save_to_template_by_library(source="library_changed")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_COVER_SEPARATELY_BY_LIBRARY'] == unicode_type("True"):
            self.apply_save_cover_separately_option_by_library(source="library_changed")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_METADATA_IN_OPF_FILE_BY_LIBRARY'] == unicode_type("True"):
            self.apply_save_metadata_in_opf_file_option_by_library(source="library_changed")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY'] == unicode_type("True"):
            self.apply_default_output_format_option_by_library(source="library_changed")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_TITLE_SERIES_SORTING_BY_LIBRARY'] == unicode_type("True"):
            self.apply_title_series_sorting_by_library(source="library_changed")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_METADATA_EDIT_CUSTOM_COLUMN_ORDER_BY_LIBRARY'] == unicode_type("True"):
            self.apply_metadata_edit_custom_column_order_by_library(source="library_changed")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_TAG_BROWSER_CATEGORY_ORDER'] == unicode_type("True"):
            self.apply_tag_browser_category_order_by_library(source="library_changed")

        self.qf_ids_previous = []

        try:
            self.purge_prefs_dialog.close()
        except:
            pass
        try:
            self.cc_editable_dialog.close()
        except:
            pass
        try:
            self.my_copy_saved_searches_dialog.close()
        except:
            pass
        try:
            self.my_visualize_metadata_dialog.close()
        except:
            pass
        try:
            self.cctechnicallistingdialog.close()
        except:
            pass
        try:
            self.rowspy_dialog.close()
        except:
            pass
        try:
            self.notesviewer_dialog.close()
        except:
            pass
        try:
            self.copy_user_categories_dialog.close()
        except:
            pass
        try:
            self.formatspy_dialog.close()
        except:
            pass
        try:
            self.tagbrowsericonsdialog.close()
        except:
            pass
        try:
            self.remove_id_types_dialog.close()
        except:
            pass
        try:
            self.identifiers_edit_dialog.close()
        except:
            pass
        try:
            self.copy_virtual_libraries_dialog.close()
        except:
            pass

        try:
            if  self.tweak_thread_is_running:
                self.tweak_thread_is_running = False
                try:
                    self.tweak_thread.stop()
                except Exception as e:
                    if DEBUG: print("JS+ self.tweak_thread.stop(): ", as_unicode(e))
                if DEBUG: print("JS+ Tweak Widget Properties Daemon has been STOPPED due to a Library change. ")
                try:
                    del self.tweak_thread
                except:
                    pass
                self.gui.status_bar.show_message(_('Edit Metadata Dropdown Daemon has been STOPPED due to a Library change'), 10000)
            else:
                pass
        except Exception as e:
            if DEBUG: print("JS+ Library Change:  Unexpected Error: ", as_unicode(e))
            self.tweak_thread_is_running = False

        try:
            del self.current_custom_columns_list
        except:
            pass
        self.current_custom_columns_list = []
        tmp_list = self.guidb.custom_field_keys()
        for row in tmp_list:
            self.current_custom_columns_list.append(row)
        #END FOR
        del tmp_list
        self.current_custom_columns_list.sort()

        self.custom_columns_metadata_dict = self.gui.current_db.field_metadata.custom_field_metadata()

        if prefs['GUI_TOOLS_ADD_NULL_VALUES_AUTORUN'] == unicode_type("True"):
            if prefs['GUI_TOOLS_ADD_NULL_VALUES_ACTIVE'] == unicode_type("True"):
                self.autorun_add_null_values()

        try:
            self.quality_fix_original_titles_dict.clear()
        except:
            pass

        if prefs['GUI_TOOLS_TAGBROWSER_ICONS_AUTO_SET_AT_STARTUP']  == unicode_type("True"):
            if DEBUG: print("JS Tag Browser Icons Tool is running at Library Changed")
            self.tagbrowser_icon_tool_is_running = True
            self.ensure_icon_directory_exists()
            self.apply_tagbrowser_custom_icons()   #after every tag_browser.recount() and after the library changes
        else:
            self.tagbrowser_icon_tool_is_running = False

        self.update_last_viewed_custom_column_automatically_control(source='library_changed')

        #----------------------------------------
        self.migrate_table_preferences_for_jobspy()   #current library only...purge table preferences for JS (and do not create anything)
        #----------------------------------------
        #----------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def initialization_complete(self):

        if DEBUG: print("Job Spy has begun initialization...")

        self.guidb = self.gui.library_view.model().db

        self.search_bar_object_set = None

        self.tweak_thread_is_running = False

        self.job_is_running = False

        self.gprefs = gprefs
        #----------------------------------------
        #----------------------------------------
        for k,v in iteritems(prefs.defaults):
            if k in prefs:
                continue
            else:
                prefs[k] = v
                prefs
        #END FOR
        #----------------------------------------
        #----------------------------------------
        try:
            from calibre.gui2.ui import get_gui
            self.maingui = get_gui()
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            self.maingui = None
        #----------------------------------------
        #----------------------------------------
        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_ADD_BOOKS_READ_METADATA_FROM_FILE_CONTENTS_NOT_NAME'] == unicode_type("True"):
            self.apply_read_file_metadata_pref_by_library()  #execute as early as feasible due to Pools...

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_AUTHOR_SORT_COPY_METHOD'] == unicode_type("True"):
            self.apply_author_sort_method_by_library()
            self.maingui.tags_view.recount()

        self.original_global_auto_add_path = None
        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY'] == unicode_type("True"):
            self.apply_auto_add_directory_by_library(source="initialization_complete")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY'] == unicode_type("True"):
            self.apply_save_to_directory_by_library(source="initialization_complete")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] == unicode_type("True"):
            self.apply_save_to_template_by_library(source="initialization_complete")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_COVER_SEPARATELY_BY_LIBRARY'] == unicode_type("True"):
            self.apply_save_cover_separately_option_by_library(source="initialization_complete")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_METADATA_IN_OPF_FILE_BY_LIBRARY'] == unicode_type("True"):
            self.apply_save_metadata_in_opf_file_option_by_library(source="initialization_complete")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY'] == unicode_type("True"):
            self.apply_default_output_format_option_by_library(source="initialization_complete")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_TITLE_SERIES_SORTING_BY_LIBRARY'] == unicode_type("True"):
            self.apply_title_series_sorting_by_library(source="initialization_complete")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_METADATA_EDIT_CUSTOM_COLUMN_ORDER_BY_LIBRARY'] == unicode_type("True"):
            self.apply_metadata_edit_custom_column_order_by_library(source="initialization_complete")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_TAG_BROWSER_CATEGORY_ORDER'] == unicode_type("True"):
            if prefs['JOB_SPY_GRACEFUL_SHUTDOWN_LAST_TIME'] == unicode_type("True"):
                self.apply_tag_browser_category_order_by_library(source="initialization_complete")
            else:
                prefs['GUI_TOOLS_ACTIVATE_TWEAK_TAG_BROWSER_CATEGORY_ORDER'] = unicode_type("False")
                prefs

        #----------------------------------------
        #----------------------------------------
        self.migrate_table_preferences_for_jobspy()  #current library only
        #----------------------------------------
        #----------------------------------------
        self.jobs_to_show_consecutively = int(prefs['JOBS_TO_SHOW_CONSECUTIVELY'])

        self.my_jobs_dialog_object = None
        self.my_copytolibraryaction_object = None

        try:
            found_jobsdialog = False
            found_jobsmanager = False
            found_vlbutton = False
            sre = QRegularExpression(".+")
            answer  = self.gui.findChildren(QWidget,sre)
            if answer:
                if isinstance(answer,list):
                    for item in answer:
                        if item:
                            s = as_unicode(item)
                            #~ if DEBUG: print(item.staticMetaObject.className(),item.objectName(),s)
                            if "JobsDialog" in s:
                                self.my_jobs_dialog_object = item
                                found_jobsdialog = True
                                #~ if DEBUG: print(item.staticMetaObject.className(),item.objectName(),s)
                                break
                    #END FOR
                    del answer
        except Exception as e:
            if DEBUG: print("Exception in initialization_complete(): ", as_unicode(e))
            self.my_jobs_dialog_object = None

        #----------------------------------------
        if prefs['GUI_TOOLS_VISIBLE_ITEMS_SEARCHBAR_AUTORUN'] == unicode_type("True"):
            self.searchbar_increase_visible_items()
        #----------------------------------------

        if prefs['JOB_SPY_GRACEFUL_SHUTDOWN_LAST_TIME'] == unicode_type("True"):
            if prefs['GUI_TOOLS_VISIBLE_ITEMS_EDIT_METADATA_AUTORUN'] == unicode_type("True"):
                self.start_stop_tweak_widget_properties_daemon()
        else:
            prefs['GUI_TOOLS_VISIBLE_ITEMS_EDIT_METADATA_AUTORUN'] = unicode_type("False")
            prefs
            if prefs['GUI_TOOLS_TAGBROWSER_ICONS_AUTO_SET_AT_STARTUP']  == unicode_type("True"):
                prefs['GUI_TOOLS_TAGBROWSER_ICONS_AUTO_SET_AT_STARTUP']  = unicode_type("False")
                prefs
                msg = "Job Spy has automatically gone into 'Safe Mode' because Calibre was 'Aborted' last time, rather than Shutting Down gracefully.\
                           <br><br>The JS Customization for the 'Tag Browser Custom Icons' GUI Tool has been 'Deactivated'.\
                           <br><br>If you intentionally 'Aborted' or 'abnormally ended' Calibre last session, and this GUI Tool was not the reason you did so, then you may 'Activate' it in the Tag Browser Custom Icon Assignment customization if you wish, and then Restart Calibre.\
                           <br><br>If that GUI Tool <b>was</b> the reason for the 'abnormal end' of Calibre last session, please 'Activate' it but immediately Restart Calibre in <b>Debug Mode</b> to capture any error details generated by your activity.  Save the Debug Log as a text file, and then provide it to the JS developer for action.  Thank you."
                info_dialog(self.gui, 'Calibre Previous Shutdown Improper',msg).show()
                if DEBUG: print(msg)

        if DEBUG: print("Calibre, and hence Job Spy, was gracefully shut down last time? ", prefs['JOB_SPY_GRACEFUL_SHUTDOWN_LAST_TIME'])
        if DEBUG: print("Last time daemon started: ", prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_LAST_STARTED'])
        if DEBUG: print("Last time daemon failed: ", prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_LAST_FAILED'])
        if DEBUG: print("Total daemon starts inception_to_date: ", as_unicode(prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_TOTAL_STARTS']))
        if DEBUG: print("Total daemon failures inception-to-date: ", as_unicode(prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_TOTAL_FAILURES']))

        prefs['JOB_SPY_GRACEFUL_SHUTDOWN_LAST_TIME'] = unicode_type("False")
        prefs

           #----------------------------------------
        self.build_menus(self.gui)
        self.gui.keyboard.finalize()

        if prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_ACTIVE'] == unicode_type("True"):
            self.ignore_copy_to_library_cc_messages()

        if prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_AUTORUN'] == unicode_type("True"):
            self.autorun_library_view_colors = True
        else:
            self.autorun_library_view_colors = False

        if not 'GUI_TOOLS_LIBRARY_VIEW_COLOR_JSON_CONVERTED' in prefs:
            if self.autorun_library_view_colors:
                prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_CONFIGURED'] = unicode_type("True")
                prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_ACTIVE'] = unicode_type("True")
                prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_JSON_CONVERTED'] = __my_version__
                prefs

        #~ ------------------------------------------------------------------------------------
        if prefs['GUI_TOOLS_MAIN_GUI_COLOR_AUTORUN'] == unicode_type("True"):
            self.autorun_main_gui_colors = True
        else:
            self.autorun_main_gui_colors = False

        if self.autorun_library_view_colors or self.autorun_main_gui_colors:
            self.color_runtype = "autorun"
            self.change_gui_alternating_row_colors()

        self.color_runtype = "manual"

        if DEBUG: print("JS: ===>>> change_gui_alternating_row_colors()")
        #~ ------------------------------------------------------------------------------------

        self.current_custom_columns_list = []
        tmp_list = self.guidb.custom_field_keys()
        for row in tmp_list:
            self.current_custom_columns_list.append(row)
        #END FOR
        del tmp_list
        self.current_custom_columns_list.sort()

        self.custom_columns_metadata_dict = self.gui.current_db.field_metadata.custom_field_metadata()

        self.pseudonym_matching_in_progress = False

        self.mycopytolibraryobject = None

        self.myftp = None

        self.clip = QApplication.clipboard()

        if prefs['GUI_TOOLS_ADD_NULL_VALUES_AUTORUN'] == unicode_type("True"):
            if prefs['GUI_TOOLS_ADD_NULL_VALUES_ACTIVE'] == unicode_type("True"):
                self.autorun_add_null_values()

        self.qf_ids_previous = []
        if prefs['GUI_TOOLS_QUALITY_FIXES_ACTIVATE'] == unicode_type("True"):
            self.initialize_quality_fixes()

        if prefs['GUI_TOOLS_TAGBROWSER_ICONS_AUTO_SET_AT_STARTUP']  == unicode_type("True"):
            if DEBUG: print("JS Tag Browser Icons Tool is running at Startup")
            self.tagbrowser_icon_tool_is_running = True
            self.ensure_icon_directory_exists() #once per Calibre session.
            self.apply_decoration_to_tagbrowser()  #once per Calibre session.
            self.maingui.tags_view._model.modelReset.connect(self.apply_tagbrowser_recount_delayed) #once per Calibre session.   this catches odds and sods that do not later invoke a recount()
            self.apply_tagbrowser_custom_icons()   #after every tag_browser.recount()
        else:
            self.tagbrowser_icon_tool_is_running = False

        self.original_gui_iaction_view = self.gui.iactions['View']._view_calibre_books
        self.original_gui_iaction_view_format_by_id = self.gui.iactions['View'].view_format_by_id

        self.update_last_viewed_custom_column_automatically_control(source='initialization_complete')

        self.extract_plugin_resources()

        if DEBUG: print("Job Spy has finished initialization...")
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def extract_plugin_resources(self):

        try:
            destination_path = self.plugin_path
            destination_path = destination_path.replace("\Job Spy.zip", "")
            destination_path = destination_path.replace("/Job Spy.zip", "")

            dir_name = "job_spy"

            resources_dir = os.path.join(destination_path,dir_name)

            if isbytestring(resources_dir):
                resources_dir = resources_dir.decode(filesystem_encoding)
            resources_dir = resources_dir.replace(os.sep, '/')

            if os.path.isdir(resources_dir):
                pass
            else:
                if DEBUG: print("Job Spy resources dir does NOT exist; it will be created: ", resources_dir)
                os.mkdir(resources_dir)

            zipfile_path = self.plugin_path
            import zipfile
            zfile = zipfile.ZipFile(zipfile_path)

            resources_dir = resources_dir.encode("ascii", "strict")
            resources_dir = as_unicode(resources_dir)

            for name in zfile.namelist(): #all files in zip with full internal paths
                name = as_unicode(name)
                n = name.find("_js_tag_")
                if n >= 0:
                    zfile.extract(name, resources_dir)    #  "...\calibre\plugins\job_spy\resources"
                n = name.find(".xlsx")
                if n >= 0:
                    zfile.extract(name, resources_dir)    #  "...\calibre\plugins\job_spy\resources"
                n = name.find(".ods")
                if n >= 0:
                    zfile.extract(name, resources_dir)    #  "...\calibre\plugins\job_spy\resources"
                n = name.find(".csv")
                if n >= 0:
                    zfile.extract(name, resources_dir)    #  "...\calibre\plugins\job_spy\resources"
            #END FOR

            del destination_path
            del resources_dir
            del zipfile_path
            del zipfile
            del zfile

        except Exception as e:
            if DEBUG: print("ERROR: extract_plugin_resources Exception: ", as_unicode(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def shutting_down(self):

        try:
            self.tweak_thread.stop()
        except:
            pass

        self.delete_temporary_reading_lists()

        prefs['JOB_SPY_GRACEFUL_SHUTDOWN_LAST_TIME'] = unicode_type("True")
        prefs

        return True
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def build_menus(self,gui):

        self.gui = gui

        self.job_spy_menu = self.menu
        self.job_spy_menu.clear()

        self.job_spy_menu.setTearOffEnabled(True)
        self.job_spy_menu.setWindowTitle('JS+ Tool Box Menu')

        self.job_spy_menu.addSeparator()
        create_menu_action_unique(self, self.job_spy_menu, ' ', ' ',
                              triggered=None)
        self.job_spy_menu.addSeparator()

        create_menu_action_unique(self, self.job_spy_menu, 'Show Last: Default', 'images/job_spy.png',
                              triggered=partial(self.show_last_per_customization))
        self.job_spy_menu.addSeparator()
        #BEGIN submenu js1 --------------------------------------------------------------------------
        self.js1 = QMenu(_('[Menu] Job Dialog Tools'))
        self.js1_action = self.job_spy_menu.addMenu(self.js1)
        self.js1.setIcon(get_icon('images/job_spy.png'))

        self.js1.setTearOffEnabled(True)
        self.js1.setWindowTitle('JS+ Tool Box Menu - Job Details')

        self.js1.addSeparator()
        unique_name = "JS+:Show Last: Default"
        create_menu_action_unique(self, self.js1, 'Show Last: Default', 'images/job_spy.png',
                              triggered=partial(self.show_last_per_customization),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  1"
        create_menu_action_unique(self, self.js1, 'Show Last:  1', 'images/job_spy.png',
                              triggered=partial(self.show_last_1),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  2"
        create_menu_action_unique(self, self.js1, 'Show Last:  2', 'images/job_spy.png',
                              triggered=partial(self.show_last_2),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  3"
        create_menu_action_unique(self, self.js1, 'Show Last:  3', 'images/job_spy.png',
                              triggered=partial(self.show_last_3),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  4"
        create_menu_action_unique(self, self.js1, 'Show Last:  4', 'images/job_spy.png',
                              triggered=partial(self.show_last_4),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  5"
        create_menu_action_unique(self, self.js1, 'Show Last:  5', 'images/job_spy.png',
                              triggered=partial(self.show_last_5),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  6"
        create_menu_action_unique(self, self.js1, 'Show Last:  6', 'images/job_spy.png',
                              triggered=partial(self.show_last_6),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  7"
        create_menu_action_unique(self, self.js1, 'Show Last:  7', 'images/job_spy.png',
                              triggered=partial(self.show_last_7),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  8"
        create_menu_action_unique(self, self.js1, 'Show Last:  8', 'images/job_spy.png',
                              triggered=partial(self.show_last_8),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  9"
        create_menu_action_unique(self, self.js1, 'Show Last:  9', 'images/job_spy.png',
                              triggered=partial(self.show_last_9),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  10"
        create_menu_action_unique(self, self.js1, 'Show Last: 10', 'images/job_spy.png',
                              triggered=partial(self.show_last_10),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Increase Current Session Value by 200%"
        create_menu_action_unique(self, self.js1, 'Increase Current Session Value by 200%', 'images/job_spy.png',
                              triggered=partial(self.increase_n_by_200_percent),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Set Default to Current Session Value"
        create_menu_action_unique(self, self.js1, 'Set Default to Current Session Value', 'images/wrench-hammer.png',
                              triggered=partial(self.reset_default),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        create_menu_action_unique(self, self.js1, ' ', ' ',
                              triggered=None)
        self.js1.addSeparator()
        unique_name = "JS+:Customize Job Spy"
        create_menu_action_unique(self, self.js1, 'Customize Job Spy', 'images/config.png',
                              triggered=partial(self.show_configuration),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        create_menu_action_unique(self, self.js1, ' ', ' ',
                              triggered=None)
        #END submenu js1 --------------------------------------------------------------------------
        self.job_spy_menu.addSeparator()
        create_menu_action_unique(self, self.job_spy_menu, ' ', ' ',
                              triggered=None)
        self.job_spy_menu.addSeparator()

        #~ BEGIN: GUI Tools: -----------------------------------------------------------------

        #~ BEGIN submenu js_look_and_feel --------------------------------------------------------------------------
        self.js_look_and_feel = QMenu(_('[Menu] GUI Tools that are Look and Feel Related'))
        self.js_look_and_feel_action = self.job_spy_menu.addMenu(self.js_look_and_feel)
        self.js_look_and_feel.setIcon(get_icon('images/lookfeel.png'))

        self.js_look_and_feel.setTearOffEnabled(True)
        self.js_look_and_feel.setWindowTitle('JS+ Look and Feel GUI Tools Menu')

        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   Change GUI Text and Alternating Row Colors [As Customized]"
        create_menu_action_unique(self, self.js_look_and_feel, "GUI Tool:   Change GUI Text and Alternating Row Colors [As Customized]", 'images/rainbow.png',
                              triggered=partial(self.change_gui_alternating_row_colors),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   Customize User Category Tag Browser Icons"
        create_menu_action_unique(self, self.js_look_and_feel, 'GUI Tool:   Customize User Category Tag Browser Icons', 'images/rainbow.png',
                              shortcut = True,
                              triggered=partial(self.customize_tag_browser_icons),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   Resize Column Widths to Fit [Calibre Will Auto-Save]"
        create_menu_action_unique(self, self.js_look_and_feel, 'GUI Tool:   Resize Column Widths to Fit [Calibre Will Auto-Save]', 'images/plus.png',
                              triggered=partial(self.expand_column_widths),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   Compress Column Widths Uniformly [Calibre Will Auto-Save]"
        create_menu_action_unique(self, self.js_look_and_feel, 'GUI Tool:   Compress Column Widths Uniformly [Calibre Will Auto-Save]', 'images/minus.png',
                              triggered=partial(self.compress_column_widths),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   Search Bar Dropdowns - Increase Visible Items"
        create_menu_action_unique(self, self.js_look_and_feel, 'GUI Tool:   Search Bar Dropdowns - Increase Visible Items and Search History', 'images/dropdown.png',
                              triggered=partial(self.searchbar_increase_visible_items),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   'Edit Metadata' Dropdowns - Start/Stop 'Visible Items Increaser' Daemon"
        create_menu_action_unique(self, self.js_look_and_feel, "GUI Tool:   Edit Metadata Dropdowns - Start/Stop 'Visible Items Increaser' Daemon", 'images/dropdown.png',
                              triggered=partial(self.start_stop_tweak_widget_properties_daemon),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        #BEGIN submenu js3 --------------------------------------------------------------
        self.js3 = QMenu(_('GUI Tool:   Protect/Unprotect Custom Columns from Edit Metadata Dialogs [Menu]'))
        self.js3_action = self.js_look_and_feel.addMenu(self.js3)
        self.js3.setIcon(get_icon('images/protect.png'))

        self.js3.setTearOffEnabled(True)
        self.js3.setWindowTitle('JS+:GUI Tool:   [Menu] Protect/Unprotect Custom Columns from Edit Metadata Dialogs')

        self.js3.addSeparator()
        create_menu_action_unique(self, self.js3, ' ', ' ',
                              triggered=None)
        self.js3.addSeparator()

        unique_name = "JS+:GUI Tool:   Protect/Unprotect Custom Columns from Edit Metadata Dialogs"
        menu_desc = unique_name.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_normal),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js3.addSeparator()

        create_menu_action_unique(self, self.js3, ' ', ' ',
                              triggered=None)
        self.js3.addSeparator()

        self.get_reserved_prefs()   #need column labels for matrix for group names...

        #dynamic names based on the library...the "about to show" is critical for this; otherwise, silent crash in Qt...soon.

        unique_name1 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name1 = unique_name1.replace("Group [G]",self.group1_name)
        menu_desc1 = unique_name1.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc1, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group1),unique_name=unique_name1, favourites_menu_unique_name=unique_name1)
        self.js3.addSeparator()

        unique_name2 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name2 = unique_name2.replace("Group [G]",self.group2_name)
        menu_desc2 = unique_name2.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc2, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group2),unique_name=unique_name2, favourites_menu_unique_name=unique_name2)
        self.js3.addSeparator()

        unique_name3 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name3 = unique_name3.replace("Group [G]",self.group3_name)
        menu_desc3 = unique_name3.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc3, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group3),unique_name=unique_name3, favourites_menu_unique_name=unique_name3)
        self.js3.addSeparator()

        unique_name4 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name4 = unique_name4.replace("Group [G]",self.group4_name)
        menu_desc4 = unique_name4.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc4, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group4),unique_name=unique_name4, favourites_menu_unique_name=unique_name4)
        self.js3.addSeparator()

        unique_name5 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name5 = unique_name5.replace("Group [G]",self.group5_name)
        menu_desc5 = unique_name5.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc5, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group5),unique_name=unique_name5, favourites_menu_unique_name=unique_name5)
        self.js3.addSeparator()

        unique_name6 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name6 = unique_name6.replace("Group [G]",self.group6_name)
        menu_desc6 = unique_name6.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc6, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group6),unique_name=unique_name6, favourites_menu_unique_name=unique_name6)
        self.js3.addSeparator()
        #END submenu js3 ----------------------------------------------------------------
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   'RowSpy"
        create_menu_action_unique(self, self.js_look_and_feel, "GUI Tool:   RowSpy", 'images/job_spy.png',
                              shortcut = True,
                              triggered=partial(self.show_rowspy_dialog),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   'Notes Viewer"
        create_menu_action_unique(self, self.js_look_and_feel, "GUI Tool:   Notes Viewer", 'images/job_spy.png',
                              shortcut = True,
                              triggered=partial(self.show_notesviewer_dialog),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   'Hide/Show Unused/Used Custom Columns [Beta Test]"
        create_menu_action_unique(self, self.js_look_and_feel, "GUI Tool:   Hide/Show Unused/Used Custom Columns [Beta Test]", 'images/job_spy.png',
                              shortcut = True,
                              triggered=partial(self.hide_unused_show_used_custom_columns),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   'Hide All Custom Columns [Beta Test]"
        create_menu_action_unique(self, self.js_look_and_feel, "GUI Tool:   Hide All Custom Columns [Beta Test]", 'images/job_spy.png',
                              shortcut = True,
                              triggered=partial(self.hide_all_custom_columns),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   'Show All Custom Columns [Beta Test]"
        create_menu_action_unique(self, self.js_look_and_feel, "GUI Tool:   Show All Custom Columns [Beta Test]", 'images/job_spy.png',
                              shortcut = True,
                              triggered=partial(self.show_all_custom_columns),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()

        #~ END submenu js_look_and_feel --------------------------------------------------------------------------
        self.job_spy_menu.addSeparator()
        #~ BEGIN submenu js_behavior --------------------------------------------------------------------------
        self.js_behavior = QMenu(_('[Menu] GUI Tools that are Behavior Related'))
        self.js_behavior_action = self.job_spy_menu.addMenu(self.js_behavior)
        self.js_behavior.setIcon(get_icon('images/exec.png'))

        self.js_behavior.setTearOffEnabled(True)
        self.js_behavior.setWindowTitle('JS+ Behavior GUI Tools Menu')

        self.js_behavior.addSeparator()
        unique_name = "JS+:GUI Tool:   Invert Selection"
        create_menu_action_unique(self, self.js_behavior, 'GUI Tool:   Invert Selection [Selected Books]', 'images/shortcuts.png',
                              shortcut = True,
                              triggered=partial(self.invert_selection),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_behavior.addSeparator()
        unique_name = "JS+:GUI Tool:   Apply View Manager Views based on Virtual Library"
        create_menu_action_unique(self, self.js_behavior, "GUI Tool:   Apply View Manager Views based on Virtual Library", 'images/view_manager.png',
                              shortcut = True,
                              triggered=partial(self.select_view_manager_view_for_vl),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_behavior.addSeparator()
        unique_name = "JS+:GUI Tool:   Ignore Copy-to-Library Custom Column Messages [Selected Library Combinations]"
        create_menu_action_unique(self, self.js_behavior, "GUI Tool:   Ignore Copy-to-Library Custom Column Messages [Selected Library Combinations]", 'images/ignore.png',
                              triggered=partial(self.show_configuration),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_behavior.addSeparator()
        unique_name = "JS+:GUI Tool:   Copy-to-Library Shortcut"
        create_menu_action_unique(self, self.js_behavior, 'GUI Tool:   Copy-to-Library Shortcut [Selected Books]', 'images/shortcuts.png',
                              shortcut = True,
                              triggered=partial(self.copy_to_library_shortcut),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_behavior.addSeparator()
        unique_name = "JS+:GUI Tool:   Tickle Auto-Adder to Wake Up"
        create_menu_action_unique(self, self.js_behavior, 'GUI Tool:   Tickle Auto-Adder to Wake Up', 'images/shortcuts.png',
                              shortcut = True,
                              triggered=partial(self.tickle_auto_adder_watcher_worker),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_behavior.addSeparator()
        #~ END submenu js_behavior --------------------------------------------------------------------------
        self.job_spy_menu.addSeparator()
        #~ BEGIN submenu js_metadata --------------------------------------------------------------------------
        self.js_metadata = QMenu(_('[Menu] GUI Tools that are Metadata Related'))
        self.js_metadata_action = self.job_spy_menu.addMenu(self.js_metadata)
        self.js_metadata.setIcon(get_icon('images/column.png'))

        self.js_metadata.setTearOffEnabled(True)
        self.js_metadata.setWindowTitle('JS+ Metadata GUI Tools Menu')

        self.js_metadata.addSeparator()
        #BEGIN submenu js7 --------------------------------------------------------------------------
        self.js7 = QMenu(_('GUI Tool:   Apply JS Quality Fixes [Menu]'))
        self.js7_action = self.js_metadata.addMenu(self.js7)
        self.js7.setIcon(get_icon('images/change.png'))

        self.js7.setTearOffEnabled(True)
        self.js7.setWindowTitle('JS+:GUI Tool:   [Menu] Apply JS Quality Fixes')

        unique_name = "JS+:GUI Tool:   Apply JS Quality Fixes [Selected Books]"
        create_menu_action_unique(self, self.js7, "GUI Tool:   Apply JS Quality Fixes [Selected Books]", 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.manually_invoke_quality_fixes),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js7.addSeparator()
        unique_name = "JS+:GUI Tool:   Single Fix:  Change Author Name Format Per Customizing [Selected Books]"
        create_menu_action_unique(self, self.js7, "GUI Tool:   Single Fix:  Change Author Name Format Per Customizing  [Selected Books]", 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.manually_invoke_quality_fix_single_author_name_format),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js7.addSeparator()
        unique_name = "JS+:GUI Tool:   Single Fix:  Change Author Initials Format Per Customizing [Selected Books]"
        create_menu_action_unique(self, self.js7, "GUI Tool:   Single Fix:  Change Author Initials Format Per Customizing  [Selected Books]", 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.manually_invoke_quality_fix_single_author_initials_format),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js7.addSeparator()
        unique_name = "JS+:GUI Tool:   Single Fix:  Apply English Title-Casing Rules to Title [Selected Books]"
        create_menu_action_unique(self, self.js7, "GUI Tool:   Single Fix:  Apply English Title-Casing Rules to Title [Selected Books]", 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.manually_invoke_quality_fix_single_english_titlecase_title),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js7.addSeparator()
        unique_name = "JS+:GUI Tool:   Single Fix:  Apply English Title-Casing Rules to Series Name [Selected Books]"
        create_menu_action_unique(self, self.js7, "GUI Tool:   Single Fix:  Apply English Title-Casing Rules to Series Name [Selected Books]", 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.manually_invoke_quality_fix_single_english_titlecase_series),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js7.addSeparator()
        #END submenu js7 --------------------------------------------------------------------------
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Apply Default Values [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, "GUI Tool:   Apply Default Values [Selected Books]", 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.apply_default_values_manually),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Update Custom Column Based on Another Custom Column [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Update Custom Column Based on Another Custom Column [Selected Books]', 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.update_cc_based_on_another_cc),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        #BEGIN submenu js4 --------------------------------------------------------------------------
        self.js4 = QMenu(_('GUI Tool:   Autofill Custom Columns via Keyboard Shortcuts [Menu]'))
        self.js4_action = self.js_metadata.addMenu(self.js4)
        self.js4.setIcon(get_icon('images/change.png'))

        self.js4.setTearOffEnabled(True)
        self.js4.setWindowTitle('JS+:GUI Tool:   [Menu] Autofill Custom Columns via Keyboard Shortcuts')

        self.js4.addSeparator()
        unique_name = "JS+:GUI Tool:   Keyboard Shortcut to Autofill Custom Column #1 [Selected Books]"
        create_menu_action_unique(self, self.js4, 'GUI Tool:   Keyboard Shortcut to Autofill Custom Column #1 [Selected Books]', 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.kb_shortcut_cc1),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js4.addSeparator()
        unique_name = "JS+:GUI Tool:   Keyboard Shortcut to Autofill Custom Column #2 [Selected Books]"
        create_menu_action_unique(self, self.js4, 'GUI Tool:   Keyboard Shortcut to Autofill Custom Column #2 [Selected Books]', 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.kb_shortcut_cc2),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js4.addSeparator()
        unique_name = "JS+:GUI Tool:   Keyboard Shortcut to Autofill Custom Column #3 [Selected Books]"
        create_menu_action_unique(self, self.js4, 'GUI Tool:   Keyboard Shortcut to Autofill Custom Column #3 [Selected Books]', 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.kb_shortcut_cc3),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js4.addSeparator()
        unique_name = "JS+:GUI Tool:   Keyboard Shortcut to Autofill Custom Column #4 [Selected Books]"
        create_menu_action_unique(self, self.js4, 'GUI Tool:   Keyboard Shortcut to Autofill Custom Column #4 [Selected Books]', 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.kb_shortcut_cc4),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js4.addSeparator()
        #END submenu js4 --------------------------------------------------------------------------
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Bulk Empty Chosen 'Comments/Long Text' Custom Column of all Values [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, "GUI Tool:   Bulk Empty Chosen 'Comments/Long Text' Custom Column of all Values [Selected Books]", 'images/empty_value.png',
                              shortcut = True,
                              triggered=partial(self.bulk_empty_comments_custom_columns),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Bulk Update Chosen 'Comments/Long Text' Custom Column from Clipboard Text [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, "GUI Tool:   Bulk Update Chosen 'Comments/Long Text' Custom Column from Clipboard Text [Selected Books]", 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.bulk_update_comments_custom_columns),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Update Author Sort for Complex Surnames [Selected Books - Matching Authors]"
        create_menu_action_unique(self, self.js_metadata, "GUI Tool:   Update Author Sort for Complex Surnames [Selected Books - Matching Authors]", 'images/authorsort.png',
                              shortcut = True,
                              triggered=partial(self.update_author_sort_for_complex_surnames_menu),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Extract Original Title/Translator to Update Custom Columns [Selected EPUBs]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Extract Original Title/Translator to Update Custom Columns [Selected EPUBs]', 'images/translate.png',
                              triggered=partial(self.extract_translation_data),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Mega-Metadata Reference Book Dropdown Helper [Selected Book]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Mega-Metadata Reference Book Dropdown Helper [Selected Book]', 'images/dropdown.png',
                              shortcut = True,
                              triggered=partial(self.mega_metadata_book_creator_tool),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Reset Last-Modified Date [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Reset Last-Modified Date [Selected Books]', 'images/calendar_month.png',
                              triggered=partial(self.reset_last_modified_date),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Set Last-Modified Date to Date-Added (Timestamp) [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Set Last-Modified Date to Date-Added (Timestamp) [Selected Books]', 'images/calendar_month.png',
                              triggered=partial(self.set_last_modified_date_to_timestamp),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        #BEGIN submenu js2 --------------------------------------------------------------------------
        self.js2 = QMenu(_('GUI Tool:   Back up/Restore Last-Modified Dates [Menu]'))
        self.js2_action = self.js_metadata.addMenu(self.js2)
        self.js2.setIcon(get_icon('images/calendar_month.png'))

        self.js2.setTearOffEnabled(True)
        self.js2.setWindowTitle('JS+:GUI Tool:   [Menu] Back up/Restore Last-Modified Dates')

        self.js2.addSeparator()
        create_menu_action_unique(self, self.js2, ' ', ' ',
                              triggered=None)
        self.js2.addSeparator()
        unique_name = "JS+:GUI Tool:   Back Up Last_Modified Dates [All Books]"
        create_menu_action_unique(self, self.js2, 'GUI Tool:   Back Up Last-Modified Dates [All Books]', 'images/calendar_month.png',
                              triggered=partial(self.back_up_last_modified_dates),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js2.addSeparator()
        create_menu_action_unique(self, self.js2, ' ', ' ',
                              triggered=None)
        self.js2.addSeparator()
        unique_name = "JS+:GUI Tool:   Restore Last_Modified Dates [All Books]"
        create_menu_action_unique(self, self.js2, 'GUI Tool:   Restore Last-Modified Dates [All Books]', 'images/calendar_month.png',
                              triggered=partial(self.restore_last_modified_dates),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js2.addSeparator()
        create_menu_action_unique(self, self.js2, ' ', ' ',
                              triggered=None)
        self.js2.addSeparator()
        #END submenu js2 --------------------------------------------------------------------------
        self.js_metadata.addSeparator()
        #BEGIN submenu js5 --------------------------------------------------------------------------
        self.js5 = QMenu(_('GUI Tool:   Pseudonymous Authors [Menu]'))
        self.js5_action = self.js_metadata.addMenu(self.js5)
        self.js5.setIcon(get_icon('images/quill.png'))

        self.js5.setTearOffEnabled(True)
        self.js5.setWindowTitle('JS+:GUI Tool:   [Menu] Author Pseudonyms')

        unique_name = "JS+:GUI Tool:   Update Real Authors CC for Pseudonymous Authors [Selected Books]"
        create_menu_action_unique(self, self.js5, 'GUI Tool:   Update Real Authors CC for Pseudonymous Authors [Selected Books]', 'images/quill.png',
                              shortcut = True,
                              triggered=partial(self.update_author_pseudonyms),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js5.addSeparator()
        create_menu_action_unique(self, self.js5, ' ', ' ',
                              triggered=None)
        self.js5.addSeparator()
        unique_name = "JS+:GUI Tool:   Export Current Pseudonym Table to CSV Text File"
        create_menu_action_unique(self, self.js5, 'GUI Tool:   Export Current Pseudonym Table to CSV Text File', 'images/export.png',
                              shortcut = True,
                              triggered=partial(self.export_pseudonym_csv_file),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js5.addSeparator()
        unique_name = "JS+:GUI Tool:   Import New Pseudonym Table from CSV Text File"
        create_menu_action_unique(self, self.js5, 'GUI Tool:   Import New Pseudonym Table from CSV Text File', 'images/import.png',
                              shortcut = True,
                              triggered=partial(self.import_pseudonym_csv_file),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js5.addSeparator()
        create_menu_action_unique(self, self.js5, ' ', ' ',
                              triggered=None)
        self.js5.addSeparator()
        unique_name = "JS+:GUI Tool:   Uninstall Pseudonym Table [Current Library]"
        create_menu_action_unique(self, self.js5, 'GUI Tool:   Uninstall Pseudonym Table [Current Library]', 'images/wrench-hammer.png',
                              shortcut = True,
                              triggered=partial(self.uninstall_pseudonym_table),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js5.addSeparator()
        #END submenu js5 --------------------------------------------------------------------------
        self.js_metadata.addSeparator()
       #BEGIN submenu js6 --------------------------------------------------------------------------
        self.js6 = QMenu(_('GUI Tool:   Scrub Tag/Tag-Like Columns Using Rules Tables [Menu]'))
        self.js6_action = self.js_metadata.addMenu(self.js6)
        self.js6.setIcon(get_icon('images/tags.png'))

        self.js6.setTearOffEnabled(True)
        self.js6.setWindowTitle('JS+:GUI Tool:   [Menu] Tag/Tag-Like Scrubbing')


        t = "<p style='white-space:wrap'>For Instructions and CSV file templates, look in in Calibre's configuration directory path:  '.../calibre/plugins/job_spy/resources which contains a .txt file for each Rule table, plus file 'JSTagRuleTablesInstructionsAndTemplates.xlsx'.\
                                                            <br><br>The Instructions in file JSTagRuleTablesInstructionsAndTemplates.xlsx show the <b>exact</b> options that must be selected to save any CSV file properly:\
                                                            <br><br>[1] UTF-8 Encoded characterset (to enable words like 'Español', 'לקרוא ספר', 'Czytać książkę', and '小說');\
                                                            <br>[2] All Text Values 'Double-Quoted';\
                                                            <br>[3] Comma-separated as the Delimiter.\
                                                            <br><br>To remove all of the rules for a <i>particular</i> rules table, simply import an appropriate CSV file with only a single row: the 'header'.\
                                                            <br><br>To remove all rules for <i>all</i> rules tables, 'Uninstall' the Scrub Tags rules tables using the indicated menu option."
        self.js6.setToolTip(t)

        unique_name = "JS+:GUI Tool:   Scrub Tag/Tag-Like Columns Using Rules Tables [All Tags]"
        create_menu_action_unique(self, self.js6, 'GUI Tool:   Scrub Tag/Tag-Like Columns Using Rules Tables [All Tags]', 'images/tags.png',
                              shortcut = True,
                              triggered=partial(self.tag_scrubbing_scrub_tag_metadata_using_ruleset),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js6.addSeparator()
        create_menu_action_unique(self, self.js6, ' ', ' ',
                              triggered=None)
        self.js6.addSeparator()
        unique_name = "JS+:GUI Tool:   Export Current Tag/Tag-Like Rules Tables to CSV Text Files"
        create_menu_action_unique(self, self.js6, 'GUI Tool:   Export Current Tag/Tag-Like Rules Tables to CSV Text Files', 'images/export.png',
                              shortcut = True,
                              triggered=partial(self.tag_scrubbing_export_tag_rules_tables_csv_files),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js6.addSeparator()
        unique_name = "JS+:GUI Tool:   Import New Tag/Tag-Like Rules Tables from CSV Text Files"
        create_menu_action_unique(self, self.js6, 'GUI Tool:   Import New Tag/Tag-Like Rules Tables from CSV Text Files', 'images/import.png',
                              shortcut = True,
                              triggered=partial(self.tag_scrubbing_import_tag_rules_tables_csv_files),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js6.addSeparator()
        create_menu_action_unique(self, self.js6, ' ', ' ',
                              triggered=None)
        self.js6.addSeparator()
        unique_name = "JS+:GUI Tool:   Uninstall Tag/Tag-Like Rules Tables [Current Library]"
        create_menu_action_unique(self, self.js6, 'GUI Tool:   Uninstall Tag/Tag-Like Rules Tables [Current Library]', 'images/wrench-hammer.png',
                              shortcut = True,
                              triggered=partial(self.tag_scrubbing_uninstall_tag_rules_tables),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js6.addSeparator()
        #END submenu js6 --------------------------------------------------------------------------
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Add 'Null' to Selected Custom Columns for books with no existing 'real' values in them [All Books]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Add Null to Selected Custom Columns for books with no existing real values in them [All Books]', 'images/null.png',
                              triggered=partial(self.add_null_values),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Convert HTML 'Comments' to Plain Text [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, "GUI Tool:   Convert HTML 'Comments' to Plain Text [Selected Books]", 'images/html2text.png',
                              triggered=partial(self.convert_datatype_coments_to_plaintext),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Edit Identifiers [Current Book]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Edit Identifiers [Current Book]', 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.show_edit_identifiers_dialog),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Show Book-Identifier Matrix [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Show Book-Identifier Matrix [Selected Books]', 'images/spreadsheet.png',
                              shortcut = True,
                              triggered=partial(self.show_book_identifier_matrix),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Remove Identifier Types [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Remove Identifier Types [Selected Books]', 'images/empty_value.png',
                              shortcut = True,
                              triggered=partial(self.remove_identifier_types_tool),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Refresh Format File Sizes [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Refresh Format File Sizes [Selected Books]', 'images/wrench-hammer.png',
                              shortcut = True,
                              triggered=partial(self.refresh_format_file_sizes_tool),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Create Bibliography Text [Selected Books] [Copy to Clipboard]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Create Bibliography Text [Selected Books] [Copy to Clipboard]', 'images/wrench-hammer.png',
                              shortcut = True,
                              triggered=partial(self.create_bibliography_text),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   View Comments [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   View Comments [Selected Books]', 'images/search.png',
                              shortcut = True,
                              triggered=partial(self.show_comments_viewer_dialog),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Visualize Metadata"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Visualize Metadata', 'images/piechart.png',
                              shortcut = True,
                              triggered=partial(self.visualize_metadata),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Import CSV File to Update Metadata"
        create_menu_action_unique(self, self.js_metadata, "GUI Tool:   Import CSV File to Update Metadata", 'images/import.png',
                              shortcut = True,
                              triggered=partial(self.import_csv_file_to_update_metadata),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        #~ END submenu js_metadata --------------------------------------------------------------------------
        self.job_spy_menu.addSeparator()
        #~ BEGIN submenu js_search --------------------------------------------------------------------------
        self.js_search = QMenu(_('[Menu] GUI Tools that are Search Related'))
        self.js_search_action = self.job_spy_menu.addMenu(self.js_search)
        self.js_search.setIcon(get_icon('images/search.png'))

        self.js_search.setTearOffEnabled(True)
        self.js_search.setWindowTitle('JS+ Search GUI Tools Menu')

        self.js_search.addSeparator()
        unique_name = "JS+:GUI Tool:   Search for Book Title List Currently in System Clipboard"
        create_menu_action_unique(self, self.js_search, 'GUI Tool:   Search for Book Title List Currently in System Clipboard', 'images/search.png',
                              shortcut = True,
                              triggered=partial(self.search_for_clipboard_book_list_titles),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_search.addSeparator()
        unique_name = "JS+:GUI Tool:   Search Current Custom Column Using Text Currently in System Clipboard"
        create_menu_action_unique(self, self.js_search, 'GUI Tool:   Search Current Custom Column Using Text Currently in System Clipboard', 'images/search.png',
                              shortcut = True,
                              triggered=partial(self.search_for_clipboard_book_list_custom_columns),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_search.addSeparator()
        unique_name = "JS+:GUI Tool:   Virtual Library Helper - Create Search Criteria Using Selected Book IDs"
        create_menu_action_unique(self, self.js_search, 'GUI Tool:   Virtual Library Helper - Create Search Criteria Using Selected Book IDs', 'images/search.png',
                              triggered=partial(self.vl_helper_set_search_string_using_book_ids),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_search.addSeparator()
        unique_name = "JS+:GUI Tool:   Virtual Library Helper - View VLs Sorted by VL Criteria instead of VL Name"
        create_menu_action_unique(self, self.js_search, 'GUI Tool:   Virtual Library Helper - View VLs Sorted by VL Criteria instead of VL Name', 'images/search.png',
                              triggered=partial(self.create_vl_helper_dialog),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_search.addSeparator()
        unique_name = "JS+:GUI Tool:   Copy Saved Searches of Current Library to Target Library"
        create_menu_action_unique(self, self.js_search, 'GUI Tool:   Copy Saved Searches of Current Library to Target Library', 'images/search.png',
                              triggered=partial(self.copy_saved_searches),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_search.addSeparator()
        unique_name = "JS+:GUI Tool:   Copy Selected Virtual Library from Current Library to Target Library"
        create_menu_action_unique(self, self.js_search, 'GUI Tool:   Copy Selected Virtual Library from Current Library to Target Library', 'images/search.png',
                              triggered=partial(self.copy_virtual_libraries_to_target),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_search.addSeparator()
        #~ END submenu js_search --------------------------------------------------------------------------
        self.job_spy_menu.addSeparator()
        #~ BEGIN submenu js_utilities --------------------------------------------------------------------------
        self.js_utilities = QMenu(_('[Menu] GUI Tools that are Utilities'))
        self.js_utilities_action = self.job_spy_menu.addMenu(self.js_utilities)
        self.js_utilities.setIcon(get_icon('images/wrench-hammer.png'))

        self.js_utilities.setTearOffEnabled(True)
        self.js_utilities.setWindowTitle('JS+ Utility GUI Tools Menu')

        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   List Active Keyboard Shortcuts"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   List Active Keyboard Shortcut Assignments', 'images/shortcuts.png',
                              shortcut = True,
                              triggered=partial(self.list_all_keyboard_shortcuts),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()

        unique_name = "JS+:GUI Tool:   Select & Open Arbitrary Programs and Files"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   Select && Open Arbitrary Programs and Files', 'images/execute.png',
                              triggered=partial(self.create_arbitrary_file_dialog),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Select & Open Arbitrary Programs and Files (Basic)"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   Select && Open Arbitrary Programs and Files (Basic)', 'images/execute.png',
                              triggered=partial(self.select_and_open_files),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Vacuum/Compress metadata.db En Masse [All Other Calibre Libraries]"
        create_menu_action_unique(self, self.js_utilities, "GUI Tool:   Vacuum/Compress metadata.db En Masse [All Other Calibre Libraries]", 'images/vacuum.png',
                              triggered=partial(self.sqlite_vacuum_en_masse),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Purge Library-specific Preferences [Selected Plug-ins]"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   Purge Library-specific Preferences [Selected Plug-ins]', 'images/unlinked.png',
                              triggered=partial(self.purge_plugin_settings),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Purge metadata.opf Backup Queue [User Discretion Advised]"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   Purge metadata.opf Backup Queue [User Discretion Advised]', 'images/purge.png',
                              triggered=partial(self.purge_metadata_opf_backup_queue),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Automatically Delete Temporary Reading Lists at Calibre Shutdown"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   Automatically Delete Temporary Reading Lists at Calibre Shutdown', 'images/reading_list.png',
                              triggered=partial(self.show_configuration),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Copy Selected 'User Category' to a Target Library"
        create_menu_action_unique(self, self.js_utilities, "GUI Tool:   Copy Selected 'User Category' to a Target Library", 'images/user_category.png',
                              shortcut = True,
                              triggered=partial(self.copy_user_categories),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   List Technical Custom Column Details from Table Custom Columns"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   List Technical Custom Column Details from Table Custom Columns', 'images/column.png',
                              triggered=partial(self.list_custom_columns_technical_details),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Create Matrix of All Custom Columns used in All Libraries"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   Create Matrix of All Custom Columns used in All Libraries', 'images/column.png',
                              triggered=partial(self.create_matrix_custom_columns_by_library),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   'FormatSpy"
        create_menu_action_unique(self, self.js_utilities, "GUI Tool:   FormatSpy", 'images/job_spy.png',
                              shortcut = True,
                              triggered=partial(self.show_formatspy_dialog),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Display 'Polish Books' Job Font-Embedding Failures and Failed Books"
        create_menu_action_unique(self, self.js_utilities, "GUI Tool:   Display 'Polish Books' Job Font-Embedding Failures and Failed Books", 'images/polish.png',
                              shortcut = True,
                              triggered=partial(self.display_polish_books_job_log_fails),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   FTP Books to Host [Selected Books] [Specified Formats]"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   FTP Books to Host [Selected Books] [Specified Formats]', 'images/ftp.png',
                              shortcut = True,
                              triggered=partial(self.ftp_selected_books),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Back Up Job Spy Configuration File 'Job Spy.json'"
        create_menu_action_unique(self, self.js_utilities, "GUI Tool:   Back Up Job Spy Configuration File 'Job Spy.json'", 'images/wrench-hammer.png',
                              shortcut = True,
                              triggered=partial(self.create_job_spy_json_backup_file),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        #~ BEGIN submenu js_utilities_bibliography---------------------------------------------------------------------
        self.js_utilities_bibliography = QMenu(_('GUI Tool:  Bibliography/Citations [Menu] '))
        self.js_utilities_bibliography_action = self.js_utilities.addMenu(self.js_utilities_bibliography)
        self.js_utilities_bibliography.setIcon(get_icon('images/ris_filetype.png'))

        self.js_utilities_bibliography.setTearOffEnabled(True)
        self.js_utilities_bibliography.setWindowTitle('JS+ RIS Citation Files')

        self.js_utilities_bibliography.setSeparatorsCollapsible(False)

        self.js_utilities_bibliography.setToolTip("<p style='white-space:wrap'>GUI Tool:  RIS Citation Files [Menu]: \
                                                        <br><br>[1] 'RIS Tags: Create Individual Custom Columns' is used to create desired RIS Tag-specific Calibre Custom Columns that may be \
                                                        automatically populated by the required <b>FileType Plugin 'Extract RIS Citations</b>' (if so customized in Calibre > Preferences > Plugins'.\
                                                        <br>Version 2:  PMID (PubMed ID used in NBIB/MEDLINE) is supported, creating #ris_pmid for RIS Tag 'CP' when this Tool is executed.\
                                                        <br>This can be safely run even if all available RIS Custom Columns have already been created.  <b>Always run this Tool when its Version changes.</b>\
                                                        <br><br>[2] 'Customize the 'Extract RIS Citations' File-Type Plugin (ERC) for RIS Tag-to-Calibre Column Mappings' \
                                                        is a convenience menu item that allows you to easily customize the ERC plugin within this Job Spy RIS Citation Files menu. \
                                                        <br><br>[3] 'RIS Citation File: Split Each RIS Tag Set into a Single RIS File' imports a single .ris file with multiple citations, splits those into multiple .ris \
                                                        files, then adds those many .ris files into the Calibre Auto-Add directory specified in Calibre > Preferences > Add Books.\
                                                        <br><br>[4] 'Single RIS Book: Copy '#ris_...' Metadata to Related PDF/TXT/EPUB Book' will match a .ris book with a .pdf or .txt or .epub that \
                                                        has the identical Title and Author(s).  It then copies the '#ris_...' Custom Copy values from the .ris Book to its matching 'real' Book, but only \
                                                        for '#ris_...' values that did not previously exist in the related target PDF/TXT/EPUB Book.  It adds new metadata only; it does not change metadata.\
                                                        Finally, #[4] copies the source .ris file into the target PDF/TXT/EPUB Book's directory as an additional format, RIS, for future reference.\
                                                        <br><br>[5] 'All Selected Books: Copy '#ris_...' Metadata to Related PDF/TXT/EPUB Book' is the same as #[3], but matches and updates all of the \
                                                        matched pairs of books found within the list of Selected Books that you specify.  It is ignores non-matches.  It also ignores any PDF/TXT/EPUB Books \
                                                        that already have an existing RIS format, meaning that once a particular PDF/TXT/EPUB Book has been updated with its matching .ris file, it no longer \
                                                        may be updated in the same manner again.  \
                                                        <br><br>[6] 'BIB Catalog to RIS Converter/Exploder to Auto-Add' does for BIB .bib files what #[1] does for RIS .ris files, but only after first \
                                                        converting from BIB to RIS.  The original .bib filename is retained as an RIS Tag of 'L3', and will be mapped to Calibre Comments labeled as 'related_records:' \
                                                        for future reference.\
                                                        <br><br>[7] 'NBIB to RIS Converter/Exploder to Auto-Add' does for NBIB .bib files what #[1] does for RIS .ris files, but only after first \
                                                        converting from NBIB to RIS.  All NBIB citations have a PubMed ID, PMID, which can be used to find the original citation in PubMed.\
                                                        <br><br>[8] 'Via PMID: Automatically Download NBIB, Convert to RIS & Auto-Add' does what #[7] does, but the source is a list of PMIDs, not a \
                                                        physical NBIB file. \
                                                        <br><br>Suggestion for BIB catalogs:  retain indefinitely all original BIB .bib files in a non-Calibre directory for future reference using 'related_records:' in Comments,\
                                                        since BIB .bib files are not nearly as standardized in their 'grammar' as NBIB and RIS .ris files.  'Standard BIB' is an oxymoron in the real world.  If you have a specific problem with a specific .bib file being \
                                                        converted to RIS, simply run Calibre in debug mode and import that specific .bib file once again.  This GUI Tool creates a debugging log that will \
                                                        help you to easily identify the source of the .bib file's format issues.  Given a choice between BIB and NBIB, the latter is the much better alternative.\
                                                        <br><br>")
        self.js_utilities_bibliography.addSeparator()
        self.js_utilities_bibliography.addSeparator()
        unique_name = "JS+:GUI Tool:   Create Bibliography Text [Selected Books] [Copy to Clipboard]"
        create_menu_action_unique(self, self.js_utilities_bibliography, 'GUI Tool:   Create Bibliography Text [Selected Books] [Copy to Clipboard]', 'images/wrench-hammer.png',
                              shortcut = True,
                              triggered=partial(self.create_bibliography_text),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities_bibliography.addSeparator()
        self.js_utilities_bibliography.addSeparator()
        self.js_utilities_bibliography.addSeparator()
        unique_name = "JS+:GUI Tool:   RIS Tags: Create Individual Custom Columns"   # version 3: add NBIB Cn & Un custom columns for PubMed .nbib files
        create_menu_action_unique(self, self.js_utilities_bibliography, "GUI Tool:   RIS Tags: Create Individual Custom Columns (v3)", 'images/ris_filetype.png',
                              shortcut = True,
                              triggered=partial(self.create_ris_citation_tags_custom_columns),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities_bibliography.addSeparator()
        self.js_utilities_bibliography.addSeparator()
        unique_name = "JS+:GUI Tool:   RIS Tags: Customize the 'Extract RIS Citations' File-Type Plugin (ERC) for RIS Tag-to-Calibre Column Mappings"
        create_menu_action_unique(self, self.js_utilities_bibliography, "GUI Tool:   Customize the 'Extract RIS Citations' File-Type Plugin (ERC) for RIS Tag-to-Calibre Column Mappings", 'images/ris_filetype.png',
                              shortcut = True,
                              triggered=partial(self.customize_the_erc_filetype_plugin_within_js),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities_bibliography.addSeparator()
        self.js_utilities_bibliography.addSeparator()
        self.js_utilities_bibliography.addSeparator()
        unique_name = "JS+:GUI Tool:   RIS Citation File: Split Each RIS Tag Set into a Single RIS File"
        create_menu_action_unique(self, self.js_utilities_bibliography, "GUI Tool:   RIS Citation File: Split Each RIS Tag Set into a Single RIS File", 'images/ris_filetype.png',
                              shortcut = True,
                              triggered=partial(self.ris_citation_file_split_sets_of_tags),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities_bibliography.addSeparator()
        self.js_utilities_bibliography.addSeparator()
        unique_name = "JS+:GUI Tool:   Single RIS Book: Copy '#ris_...' Metadata to Related PDF/TXT/EPUB Book"
        create_menu_action_unique(self, self.js_utilities_bibliography, "GUI Tool:   RIS Book: Copy '#ris_...' Metadata to Related PDF/TXT/EPUB Book", 'images/ris_filetype.png',
                              shortcut = True,
                              triggered=partial(self.copy_ris_custom_columns_to_related_format_control),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities_bibliography.addSeparator()
        self.js_utilities_bibliography.addSeparator()
        unique_name = "JS+:GUI Tool:   All Selected Books: Copy '#ris_...' Metadata to Related PDF/TXT/EPUB Book"
        create_menu_action_unique(self, self.js_utilities_bibliography, "GUI Tool:   All Selected Books: Copy '#ris_...' Metadata to Related PDF/TXT/EPUB Book", 'images/ris_filetype.png',
                              shortcut = True,
                              triggered=partial(self.mass_processing_copy_ris_custom_columns_to_related_format_control),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities_bibliography.addSeparator()
        self.js_utilities_bibliography.addSeparator()
        unique_name = "JS+:GUI Tool:   BIB Catalog to RIS Converter/Exploder to Auto-Add"
        create_menu_action_unique(self, self.js_utilities_bibliography, "GUI Tool:   BIB Catalog to RIS Converter/Exploder to Auto-Add", 'images/ris_filetype.png',
                              shortcut = True,
                              triggered=partial(self.convert_bib_to_ris_tool),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities_bibliography.addSeparator()
        self.js_utilities_bibliography.addSeparator()
        unique_name = "JS+:GUI Tool:   PubMed NBIB to RIS Converter/Exploder to Auto-Add"
        create_menu_action_unique(self, self.js_utilities_bibliography, "GUI Tool:   PubMed NBIB to RIS Converter/Exploder to Auto-Add", 'images/ris_filetype.png',
                              shortcut = True,
                              triggered=partial(self.convert_nbib_to_ris_tool_menu),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities_bibliography.addSeparator()
        self.js_utilities_bibliography.addSeparator()
        unique_name = "JS+:GUI Tool:   Via PMID: Automatically Download NBIB, Convert to RIS && Auto-Add "
        create_menu_action_unique(self, self.js_utilities_bibliography, "GUI Tool:  Via PMID: Automatically Download NBIB, Convert to RIS && Auto-Add", 'images/ris_filetype.png',
                              shortcut = True,
                              triggered=partial(self.download_pmid_nbib_control),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities_bibliography.addSeparator()

        #~ END submenu js_utilities_bibliography-----------------------------------------------------------------------
        #~ END submenu js_utilities --------------------------------------------------------------------------

        self.job_spy_menu.addSeparator()

        create_menu_action_unique(self, self.job_spy_menu, ' ', ' ',
                              triggered=None)
        self.job_spy_menu.addSeparator()
        unique_name = "JS+:GUI Tool:   Customize GUI Tools"
        create_menu_action_unique(self, self.job_spy_menu, 'Customize GUI Tools', 'images/config.png',
                              triggered=partial(self.show_configuration),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.job_spy_menu.addSeparator()
        create_menu_action_unique(self, self.job_spy_menu, ' ', ' ',
                              triggered=None)

        #~ END: GUI Tools: -----------------------------------------------------------------


        self.tooltipjs1 = ("<p style='white-space:wrap'>Your default N 'last jobs to execute' to show consecutively is set via Calibre > Preferences > Plug-ins > Customize.\
                                                <br><br>This menu can be used to quickly and easily change the value of N for this Calibre session only.\
                                                <br><br>The default value set in Customization will not be changed unless you explicitly select the bottom menu option to do so.\
                                                <br><br>\
                                                <br><br>")

        self.tooltipmain = ("<p style='white-space:wrap'>\
                                                <br><br>[-]  The GUI Tool 'Search Bar Dropdowns - Increase Visible Items' sets the number of visible items and maximum items to 100 for the current Calibre session only. This is only a temporary tweak.<br><br>The JS Customization has an option to specify that this tweak is to be automatically executed after Calibre starts.\
                                                <br><br>[-]  The GUI Tool  'Edit Metadata' Dropdowns - Start/Stop 'Visible Items Increaser' Daemon sets the number of visible items and maximum items to 100 for the current Calibre session only.<br><br>Unlike the Search Bar, the Bulk Edit dialog is created and closed by the user, so a daemon that 'runs' only every eight (8) seconds (to minimize resources) is needed to 'fix' it whenever it suddenly appears. There will be a 'lag' from the time you open an Edit Metadata dialog to the time that the daemon will have discovered and tweaked it.<br><br>The JS Customization has an option to specify that this tweak is to be automatically executed after Calibre starts.\
                                                <br><br>[-]  The GUI Tool 'Resize Column Widths to Fit' can easily be reversed by clicking the 'View Manager' plug-in 'View' you wish to activate.\
                                                <br><br>[-]  The GUI Tool 'Compress Column Widths Uniformly' can easily be reversed by clicking the 'View Manager' plug-in 'View' you wish to activate.\
                                                <br><br>[-]  The GUI Tool 'Select & Open Arbitrary Programs and Files' is generic.\
                                                <br><br>[-]  The GUI Tool 'Reset Last-Modified Date' will ignore any selected future date.\
                                                <br><br>[-]  The GUI Tool 'Virtual Library Helper - Create Search Criteria Using Selected Book IDs' allows totally random and arbitrary book selections to be easily made into a Virtual Library.  Maximum: 200 books.\
                                                <br><br>[-]  The GUI Tool 'Virtual Library Helper - View VLs Sorted by VL Criteria instead of VL Name' does what it says.  This can be very handy.\
                                                <br><br>[-]  The GUI Tool 'Purge Library-specific Preferences' is useful for removing 'orphaned' or 'unlinked' settings for (currently) non-existent Plug-ins.  If the current Calibre Library has no Library-specific Preferences for any Plug-ins, then clicking the menu item will do nothing.\
                                                <br><br>[-]  The GUI Tool 'Protect/Unprotect Custom Columns from Edit Metadata Dialogs' removes the selected Custom Columns from both Edit Metadata dialogs.  Caution: The 'Bulk Edit Search and Replace' tab ignores this setting.  Also, 'Composite' (virtual) Custom Columns are excluded by this GUI Tool.  \
                                                <br><br>[-]   And too many more to fit in this ToolTip.  View many more specific ToolTips in 'Customization'. ")

        if prefs['GUI_TOOLS_SHOW_TOOLTIPS'] == unicode_type("True"):
            self.job_spy_menu.setToolTip(self.tooltipmain)

        self.js1.setToolTip(self.tooltipjs1)

        self.built_already = True
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def show_configuration(self):
        self.interface_action_base_plugin.do_user_config(self.gui)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def spy_on_jobs(self):

        if not self.my_jobs_dialog_object:
            return

        for n in range(0,self.jobs_to_show_consecutively):
            index = self.my_jobs_dialog_object.jobs_view.model().index(n, 0)
            if index.isValid():
                self.my_jobs_dialog_object.show_job_details(index)
        #END FOR
    #-------------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------------------------------------------------------------------------
    def show_last_per_customization(self):
        n = int(prefs['JOBS_TO_SHOW_CONSECUTIVELY'])
        self.show_last_n(n)
    def show_last_1(self):
        self.show_last_n(1)
    def show_last_2(self):
        self.show_last_n(2)
    def show_last_3(self):
        self.show_last_n(3)
    def show_last_4(self):
        self.show_last_n(4)
    def show_last_5(self):
        self.show_last_n(5)
    def show_last_6(self):
        self.show_last_n(6)
    def show_last_7(self):
        self.show_last_n(7)
    def show_last_8(self):
        self.show_last_n(8)
    def show_last_9(self):
        self.show_last_n(9)
    def show_last_10(self):
        self.show_last_n(10)
    #-------------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------------------------------------------------------------------------
    def increase_n_by_200_percent(self):
        self.jobs_to_show_consecutively = self.jobs_to_show_consecutively * 2
        self.spy_on_jobs()
    #-------------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------------------------------------------------------------------------
    def show_last_n(self,n):
        self.jobs_to_show_consecutively = n
        self.spy_on_jobs()
    #-------------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------------------------------------------------------------------------
    def reset_default(self):
        prefs['JOBS_TO_SHOW_CONSECUTIVELY'] = self.jobs_to_show_consecutively
        prefs
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_settings(self):
        prefs
    #-------------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------------------------------------------------------------------------
    # GUI Tools:
    #-------------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------------------------------------------------------------------------
    #-----------------------------------------------------
    #-----------------------------------------------------
    def expand_column_widths(self):
        try:
            if not self.maingui:
                return
            self.maingui.library_view.resizeColumnsToContents()
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass
    #-----------------------------------------------------
    #-----------------------------------------------------
    def compress_column_widths(self):
        try:
            if not self.maingui:
                return
            db = self.gui.current_db.new_api
            work_book_ids_frozenset = db.all_book_ids()
            n_total_rows = len(work_book_ids_frozenset)
            for r in range(0,n_total_rows):
                self.maingui.library_view.setColumnWidth(r, 100)
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass
    #-----------------------------------------------------
    #-----------------------------------------------------
    def select_and_open_files(self):
        try:
            gotten_files = self.choose_file_to_open()
            if not gotten_files:
                info_dialog(self.gui, 'Canceled','Nothing Selected; Canceled.').show()
                return
            else:
                chosen_path = gotten_files[0]
                p_pid = subprocess.Popen(chosen_path, shell=True)
        except Exception as e:
            if DEBUG: print(as_unicode(e))
    #-----------------------------------------------------
    def choose_file_to_open(self):

        name = "choose_file_to_open"
        title = "JS GUI Tool: Choose Arbitrary File to Open"
        all_files=True
        select_only_single_file=True
        filters=[]
        window = None   # parent = None

        mode = QFileDialog.FileMode.ExistingFile if select_only_single_file else QFileDialog.FileMode.ExistingFiles
        fd = FileDialog(title=title, name=name, filters=filters, parent=window, add_all_files_filter=all_files, mode=mode)
        fd.setParent(None)
        if fd.accepted:
            return fd.get_files()
        return None
    #-----------------------------------------------------
    #-----------------------------------------------------
    def reset_last_modified_date(self):
        from calibre_plugins.job_spy.ui import PopUpCalendar
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.my_popupdialog = PopUpCalendar(self.gui,self.qaction.icon(),self.guidb,self.execute_reset_date_for_selected_books)
    #-----------------------------------------------------
    def execute_reset_date_for_selected_books(self,new_last_modified_date):
        self.my_popupdialog.close()
        new_last_modified_date = as_unicode(new_last_modified_date) + as_unicode(" 12:00:00.000000+00:00")             # UTC at Noon...       # example last_modified:      2015-11-05 15:07:15.635000+00:00
        #~ if DEBUG: print(new_last_modified_date)
        self.guidb = self.gui.library_view.model().db
        #-------------------------------------
        # get selected books
        #-------------------------------------
        self.selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Books Were Selected.'), show=True)
        self.selected_books_list.sort()
        #-------------------------------------
        # process selected books
        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        try:
            my_cursor.execute("begin")
            mysql = "UPDATE books SET last_modified = ? WHERE id = ?"
            for book in self.selected_books_list:
                my_cursor.execute(mysql,(new_last_modified_date,book))
            #END FOR
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            try:
                my_cursor.execute("commit")
            except:
                pass
            del self.selected_books_list
            self.selected_books_list = []

        #-------------------------------------
        my_db.close()
        #-------------------------------------
        self.force_refresh_of_cache(self.selected_books_list)
        #-------------------------------------
        self.mark_selected_books()
        #-------------------------------------
        del self.selected_books_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def set_last_modified_date_to_timestamp(self):
        self.guidb = self.gui.library_view.model().db
        self.selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Books Were Selected.'), show=True)
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        try:
            my_cursor.execute("begin")
            mysql = "UPDATE books SET last_modified = timestamp WHERE books.id = ?"
            for book in self.selected_books_list:
                my_cursor.execute(mysql,([book]))            # books has a trigger to auto-change the author sort, so this takes longer than you would think...
            #END FOR
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            try:
                my_cursor.execute("commit")
            except:
                pass
            del self.selected_books_list
            self.selected_books_list = []

        #-------------------------------------
        my_db.close()
        #-------------------------------------
        self.force_refresh_of_cache(self.selected_books_list)
        #-------------------------------------
        self.mark_selected_books()
        #-------------------------------------
        del self.selected_books_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def mark_selected_books(self):

        found_dict = {}
        s_true = 'true'
        for row in self.selected_books_list:
            key = int(row)
            found_dict[key] = s_true
        #END FOR

        marked_ids = dict.fromkeys(found_dict, s_true)
        self.gui.current_db.set_marked_ids(marked_ids)
        self.gui.search.clear()
        self.gui.search.set_search_string('marked:true')

        del found_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_selected_books(self):

        try:
            del self.selected_books_list
        except:
            pass
        self.selected_books_list = []

        book_ids_list = []

        book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids()))  #https://stackoverflow.com/questions/50671360/map-in-python-3-vs-python-2
        n = len(book_ids_list)
        if n == 0:
            del book_ids_list
            return self.selected_books_list
        for item in book_ids_list:
            s = as_unicode(item['calibre_id'])
            self.selected_books_list.append(s)
        #END FOR

        del book_ids_list

        return self.selected_books_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def convert_id_to_book(self, idval):
        book = {}
        book['calibre_id'] = idval
        return book
    #---------------------------------------------------------------------------------------------------------------------------------------
    def force_refresh_of_cache(self,books_to_select):
        db = self.maingui.current_db.new_api
        frozen = db.all_book_ids()
        books = list(frozen)
        db.reload_from_db(clear_caches=False)
        self.maingui.library_view.model().refresh_ids(books)
        self.maingui.tags_view.recount()
        QApplication.instance().processEvents()
        identifiers = set(books_to_select)
        self.maingui.library_view.select_rows(identifiers,using_ids=True,change_current=True,scroll=True)  #refreshing the cache also clears the currently selected book...
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apsw_connect_to_library(self):

        self.guidb = self.gui.library_view.model().db

        my_db = self.gui.library_view.model().db

        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')

        if isbytestring(path):
            path = path.decode(filesystem_encoding)

        if path.endswith("/"):
            path = path[0:-1]

        try:
            my_db =apsw.Connection(path)
            is_valid = True
        except Exception as e:
            if DEBUG: print("path to metadata.db is: ", path)
            if DEBUG: print("error: ", as_unicode(e))
            is_valid = False
            return None,None,is_valid

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        # Standard Calibre uses these in backend.py as of Release 3.17
        my_db.createscalarfunction("title_sort", title_sort,1)   # for trigger...
        my_db.createscalarfunction('author_to_author_sort',_author_to_author_sort, 1)
        my_db.createscalarfunction('uuid4', lambda: as_unicode(uuid.uuid4()),0)

        return my_db,my_cursor,is_valid
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def vl_helper_set_search_string_using_book_ids(self):

        self.selected_books_list = self.get_selected_books()
        n = len(self.selected_books_list)
        if n == 0 or n > 200:
            return
        bids = ""  #book id search string
        for book in self.selected_books_list:
            book = as_unicode(book)
            bids = bids + "id:" + book + " OR "
        #END FOR
        if bids.endswith(" OR "):
            bids = bids[0:-4]
        self.gui.search.clear()
        self.gui.search.set_search_string(bids)
    #-------------------------------------------------------------------------------------------------------------------------------------
    def create_vl_helper_dialog(self):
        from calibre_plugins.job_spy.vl_helper_dialog import VLHelperDialog
        self.vl_helper_dialog = VLHelperDialog(self.gui,self.qaction.icon())
        self.vl_helper_dialog.show()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def purge_plugin_settings(self):
        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        mysql = "SELECT id,key FROM preferences WHERE key LIKE 'namespaced:%' ORDER BY key"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        if not tmp_rows:
            tmp_rows = []
        if len(tmp_rows) == 0:
            return
        preferences_list = []
        for row in tmp_rows:
            id,key = row
            #~ if DEBUG: print("full: ", key)
            key = key.replace("namespaced:","")
            if key.count(":") > 0:
                n = key.find(":")
                key = key[0:n]
                #~ if DEBUG: print("plugin: ", key)
                preferences_list.append(key)
        #END FOR
        if len(preferences_list) == 0:
            return

        from calibre_plugins.job_spy.purge_prefs_dialog import PurgePrefsDialog
        icon = get_icon('images/unlinked.png')
        self.purge_prefs_dialog = PurgePrefsDialog(self.gui,icon,preferences_list)
        self.purge_prefs_dialog.show()
        del PurgePrefsDialog
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def protect_unprotect_custom_column_normal(self):
        mode = "normal"
        group = 0
        self.protect_unprotect_custom_column(mode,group)
    def protect_unprotect_custom_column_easy_group1(self):
        self.protect_unprotect_custom_column_easy_generic(1)
    def protect_unprotect_custom_column_easy_group2(self):
        self.protect_unprotect_custom_column_easy_generic(2)
    def protect_unprotect_custom_column_easy_group3(self):
        self.protect_unprotect_custom_column_easy_generic(3)
    def protect_unprotect_custom_column_easy_group4(self):
        self.protect_unprotect_custom_column_easy_generic(4)
    def protect_unprotect_custom_column_easy_group5(self):
        self.protect_unprotect_custom_column_easy_generic(5)
    def protect_unprotect_custom_column_easy_group6(self):
        self.protect_unprotect_custom_column_easy_generic(6)
    def protect_unprotect_custom_column_easy_generic(self,group):
        mode = "easy"
        self.protect_unprotect_custom_column(mode,group)
    def protect_unprotect_custom_column(self,mode,group):
        from calibre_plugins.job_spy.custom_column_editable_dialog import CustomColumnEditableDialog
        icon = get_icon('images/protect.png')
        self.guidb = self.gui.library_view.model().db
        self.cc_editable_dialog = CustomColumnEditableDialog(self.gui,self.guidb,icon,mode,group)
        if mode == "normal":
            self.cc_editable_dialog.show()
        else:
            pass
            #~ if DEBUG: self.cc_editable_dialog.show()
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def searchbar_increase_visible_items(self):
        try:
            if not self.search_bar_object_set:
                from calibre.gui2.ui import get_gui
                self.maingui = get_gui()
                from calibre_plugins.job_spy.gui_objects import JSGetGUIObjects
                #---------------------------------------------------------------------------------------------
                #~ criteria_type:  1 = name; 2 = hasattr; 3 = object_class; NNN = multiple ANDs
                #---------------------------------------------------------------------------------------------
                criteria_type = 12
                name_criteria_set = set()
                hasattr_criteria_set = set()
                hasattr_criteria_set.add("setMaxVisibleItems")
                object_class_set = set()
                name_criteria_set.add("calibre.gui2.search_box")
                my_jsgetguiobjects = JSGetGUIObjects(self.gui,self.maingui,QApplication)
                iterations = 1
                children_level = 0  # sufficient for the Search Bar
                self.search_bar_object_set = my_jsgetguiobjects.get_objects(criteria_type,name_criteria_set,hasattr_criteria_set,object_class_set,iterations,children_level)
                #~ <calibre.gui2.search_box.SearchBox2 object at 0x000000000A209CA8>
                #~ <calibre.gui2.search_box.SavedSearchBox object at 0x000000000D1A3048>
                del JSGetGUIObjects
                del my_jsgetguiobjects
            try:
                if not self.search_bar_object_set:
                    return
            except Exception as e:
                self.search_bar_object_set = None
                if DEBUG: print("[0] Exception in searchbar_increase_visible_items: ", as_unicode(e))
                return
            for item in self.search_bar_object_set:
                if hasattr(item, 'setMaxVisibleItems'):
                    if item.maxCount() < 100:
                        item.setMaxCount(100)
                    if item.maxVisibleItems() < 100:
                        item.setMaxVisibleItems(100)
                    s = as_unicode(item)
                    if 'calibre.gui2.search_box.SearchBox2' in s:
                        final_list = self.append_additional_search_history()
                        numitems = item.count()
                        for i in range(0,numitems):
                            if not item.itemText(i) in final_list:
                                item.removeItem(i)
                        for row in final_list:
                            n = item.findText(row,Qt.MatchExactly)
                            if n == -1:
                                if row > " ":
                                    item.addItem(row)
                        #END
                    item.update()
                self.gui.status_bar.show_message(_('Search Bar Visible Items Increased to 100'), 10000)
        except Exception as e:
            if DEBUG: print("[1] Exception in searchbar_increase_visible_items: ", as_unicode(e))
            pass
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def start_stop_tweak_widget_properties_daemon(self):

        if not self.tweak_thread_is_running:
            from calibre.gui2.ui import get_gui
            self.maingui = get_gui()
            from calibre_plugins.job_spy.tweak_widget_properties_daemon import TweakWidgetPropertiesDaemon
            self.tweak_thread = TweakWidgetPropertiesDaemon(self.gui,self.maingui,QApplication)
            self.tweak_thread.start()
            self.tweak_thread_is_running = True
            self.gui.status_bar.show_message(_('JS+ Edit Metadata Dropdown Daemon has been STARTED'), 10000)
            del TweakWidgetPropertiesDaemon
        else:
            try:
                self.tweak_thread.stop()
                if DEBUG: print("JS+ Tweak Widget Properties Daemon has been STOPPED")
                self.tweak_thread_is_running = False
                del self.tweak_thread
                self.gui.status_bar.show_message(_('JS+ Edit Metadata Dropdown Daemon has been STOPPED'), 10000)
            except:
                pass
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def append_additional_search_history(self):

        if prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY_PURGE'] == unicode_type("True"):
            prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY'] = prefs.defaults['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY']
            prefs

        import ast

        additional_history = as_unicode(prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY'])
        additional_history_list = ast.literal_eval(additional_history)

        from calibre.gui2 import config
        opt_name = "main_search_history"
        full_list = []
        for line in config[opt_name]:
            full_list.append(line)
        prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY']  = unicode_type(as_unicode(full_list))
        prefs

        if prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY_PURGE'] == unicode_type("True"):
            prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY_PURGE'] = unicode_type("False")
            full_list = full_list[0:25]
            prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY']  = unicode_type(as_unicode(full_list))
            prefs
        else:
            additional_history_list.sort()
            for row in additional_history_list:
                if row in full_list:
                    pass
                else:
                    full_list.append(row)
            #END FOR

        try:
            del ast
            del additional_history
            del additional_history_list
        except:
            pass

        #~ if DEBUG: print("Number of search history items available: ", as_unicode(len(full_list)))

        return full_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def copy_saved_searches(self):
        from calibre_plugins.job_spy.synchronize_saved_searches_dialog import SynchronizeSavedSearchesDialog
        icon = get_icon('images/search.png')
        self.my_copy_saved_searches_dialog = SynchronizeSavedSearchesDialog(self.gui,self.guidb,icon)
        self.my_copy_saved_searches_dialog.show()
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def visualize_metadata(self):
        from calibre_plugins.job_spy.visualize_metadata_dialog import VisualizeMetadataDialog
        icon = get_icon('images/piechart.png')
        self.my_visualize_metadata_dialog = VisualizeMetadataDialog(self.gui,self.guidb,icon)
        self.my_visualize_metadata_dialog.show()
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def purge_metadata_opf_backup_queue(self):

        if question_dialog(self.gui, "JS+ GUI Tool - Purge metadata.opf Backup Queue", "Purge the Queue of the Current Library?  Are you sure?"):
            pass
        else:
            return

        mydbcache = self.gui.current_db.new_api
        mybackend = self.gui.library_view.model().db.backend

        try:
            #~ if DEBUG: print("[0] len of tmp_dict: ", as_unicode(len(mydbcache.dirtied_cache)))
            mydbcache.dirtied_cache.clear()
            mybackend.execute('DELETE FROM metadata_dirtied')      # autocommits...
            #~ if DEBUG: print("[1] len of tmp_dict: ", as_unicode(len(mydbcache.dirtied_cache)))
            #~ if DEBUG: print("Queue Cleared: All Books")
            del mydbcache
            del mybackend
            return info_dialog(self.gui, 'JS+ GUI Tool - Purge metadata.opf Backup Queue','The Queue has been purged.').show()
        except Exception as e:
            del mydbcache
            del mybackend
            return error_dialog(self.gui, _('JS+ GUI Tool - Purge Error - Try Again - Exception: '),_(as_unicode(e)), show=True)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def back_up_last_modified_dates(self):

        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        mysql = "SELECT id AS book,uuid AS book_uuid,last_modified,(select uuid from library_id) AS library_uuid,datetime() as date_saved FROM books"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        if not tmp_rows:
            tmp_rows = []
        if len(tmp_rows) == 0:
            return
        data_list = []
        for row in tmp_rows:
            #~ if DEBUG: print(as_unicode(row))
            book,book_uuid,last_modified,library_uuid,date_saved = row
            new_line = as_unicode(book) + "|" + as_unicode(book_uuid) + "|" + as_unicode(last_modified) + "|" + as_unicode(date_saved)
            data_list.append(as_unicode(new_line))
            #~ if DEBUG: print(as_unicode(new_line))
        #END FOR
        del tmp_rows

        if library_uuid == "07111111-0000-4000-b000-f00000000001":
            return error_dialog(self.gui, _('JS+ GUI Tool - Back Up Last-Modified Dates: '),_('Sorry, but QuarantineAndScrub Libraries cannot use this function.'), show=True)
        if library_uuid == "5d170c8f-1b20-4243-8d68-31a255e34fdd":
            return error_dialog(self.gui, _('JS+ GUI Tool - Back Up Last-Modified Dates: '),_('Sorry, but CALM Target Libraries cannot use this function.'), show=True)

        saved_data_dict = {}
        saved_data_dict[library_uuid] = as_unicode(data_list)

        self.build_protected_subdirectory_path()

        unique_library_name = library_uuid + as_unicode(".txt")

        out_file =  os.path.join(self.protected_data_directory, unique_library_name)
        out_file.encode("ascii", "strict")
        out_file = as_unicode(out_file)
        out_file = out_file.replace(os.sep, '/')         #   /calibre/plugins/job_spy/[library_uuid]

        my_outfile = open(out_file, 'w')
        my_outfile.write(as_unicode(saved_data_dict))
        my_outfile.close

        #~ if DEBUG: print("data was saved to: ", as_unicode(out_file))

        msg = "Backup was successful for " + as_unicode(len(data_list)) + " books.  <br><br> The backup file path for this library is: " + out_file
        info_dialog(self.gui, 'JS+ GUI Tool - Back Up Last-Modified Dates',msg).show()

        del data_list
        del saved_data_dict
        del out_file
        del my_outfile
    #---------------------------------------------------------------------------------------------------------------------------------------
    def restore_last_modified_dates(self):

        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        mysql = "SELECT id,uuid FROM library_id"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        if not tmp_rows:
            tmp_rows = []
        if len(tmp_rows) == 0:
            return
        for row in tmp_rows:
            id,library_uuid = row
        #END FOR
        del tmp_rows

        if library_uuid == "07111111-0000-4000-b000-f00000000001":
            return error_dialog(self.gui, _('JS+ GUI Tool - Restore Last-Modified Dates: '),_('Sorry, but QuarantineAndScrub Libraries cannot use this function.'), show=True)
        if library_uuid == "5d170c8f-1b20-4243-8d68-31a255e34fdd":
            return error_dialog(self.gui, _('JS+ GUI Tool - Back Up Last-Modified Dates: '),_('Sorry, but CALM Target Libraries cannot use this function.'), show=True)

        self.build_protected_subdirectory_path()

        unique_library_name = library_uuid + as_unicode(".txt")

        in_file =  os.path.join(self.protected_data_directory, unique_library_name)
        in_file = as_unicode(in_file)
        in_file = in_file.replace(os.sep, '/')         #   /calibre/plugins/job_spy/[library_uuid]

        saved_data_list = []
        if os.path.exists(in_file):
            try:
                with open(in_file, 'r') as f:
                    lines = f.readlines()
                    for line in lines:
                        line = as_unicode(line)
                        line = line.encode("ascii", "strict")
                        saved_data_list.append(as_unicode(line))
                    f.close()
            except Exception as e:
                return error_dialog(self.gui, _('JS+ GUI Tool - Restore Last-Modified Dates: '),_('Sorry, but the backed up data could not be restored.  Error [0]. Please try again. '), show=True)
        else:
            return error_dialog(self.gui, _('JS+ GUI Tool - Restore Last-Modified Dates: '),_('Sorry, but there is no backed up data to restore.  Error [1].  Nothing done.'), show=True)

        import ast

        for row in saved_data_list:
            row = as_unicode(row)
            saved_data_dict = ast.literal_eval(row)                #~ saved_data_dict = {}
            break
        #END FOR
        if not isinstance(saved_data_dict,dict):
            return error_dialog(self.gui, _('JS+ GUI Tool - Restore Last-Modified Dates: '),_('Sorry, but the backed up data could not be restored.  Error [2].'), show=True)

        if not library_uuid in saved_data_dict:                   #~ saved_data_dict[library_uuid] = as_unicode(data_list)
            return error_dialog(self.gui, _('JS+ GUI Tool - Restore Last-Modified Dates: '),_('Sorry, but the backed up data could not be restored.  Error [3].'), show=True)
        else:
            data_list = saved_data_dict[library_uuid]
            data_list = as_unicode(data_list)
            data_list = ast.literal_eval(data_list)
            if not isinstance(data_list,list):
                return error_dialog(self.gui, _('JS+ GUI Tool - Restore Last-Modified Dates: '),_('Sorry, but the backed up data could not be restored.  Error [4].'), show=True)

        if len(data_list) == 0:
            return error_dialog(self.gui, _('JS+ GUI Tool - Restore Last-Modified Dates: '),_('Sorry, but the backed up data could not be restored.  Error [5].'), show=True)

        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        book_list = []
        my_cursor.execute("begin")
        for row in data_list:
            s_split = row.split("|")                                         #~ as_unicode(book) + "|" + as_unicode(book_uuid) + "|" + as_unicode(last_modified) + "|" + as_unicode(date_saved)
            if s_split:
                if len(s_split) == 4:
                    book = s_split[0]
                    if book.isdigit():
                        book = int(book)
                        book_list.append(book)
                        book_uuid = s_split[1]
                        saved_last_modified = s_split[2]
                        date_saved = s_split[3]
                        mysql = "UPDATE books SET last_modified = ? WHERE id = ? and uuid = ?"
                        my_cursor.execute(mysql,(saved_last_modified,book,book_uuid))
        #END FOR
        my_cursor.execute("commit")
        my_db.close()

        self.force_refresh_of_cache(book_list)

        msg = "Restore was successful for " + as_unicode(len(book_list)) + " books that were previously backed up at:  " + date_saved + " (UTC) to backup file: " + in_file

        del in_file
        del data_list
        del book_list
        del saved_data_dict
        del ast

        return info_dialog(self.gui, 'JS+ GUI Tool - Restore Last-Modified Dates',msg).show()
    #--------------------------------------------------------------------------------------------------
    def build_protected_subdirectory_path(self):

        self.protected_data_path = self.plugin_path
        self.protected_data_path = self.protected_data_path.replace("\Job Spy.zip", "")
        self.protected_data_path = self.protected_data_path.replace("/Job Spy.zip", "")
        self.protected_data_directory = self.protected_data_path
        sub_directory = "job_spy"
        self.protected_data_directory =  os.path.join(self.protected_data_directory, sub_directory)
        self.protected_data_directory = self.protected_data_directory.replace(os.sep, '/')         #   /calibre/plugins/job_spy
        if not os.path.exists(self.protected_data_directory):
            os.makedirs(self.protected_data_directory)
        #~ if DEBUG: print("protected_data_directory: ",self.protected_data_directory)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def extract_translation_data(self):

        if self.job_is_running:
            return

        self.selected_book_list = self.get_selected_books()

        n_books = len(self.selected_book_list)
        if  n_books == 0:
            return

        self.guidb = self.gui.library_view.model().db

        param_dict = self.build_job_param_dict()

        start_threaded_js_extract_original_title_translator(self, self.guidb, self.plugin_path, self.selected_books_list, param_dict, Dispatcher(self.js_finish_with_refresh))

        self.job_is_running = True

        msg = ('JS+ Job was submitted and is processing %d book(s)' %(n_books))
        self.show_gui_status_bar_qtimer(msg,5000)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def js_finish_with_refresh(self, job):

        self.job_is_running = False

        if job.failed:
            self.force_refresh_of_cache(self.selected_books_list)
            self.gui.job_exception(job, dialog_title=_('JS+ Job Failed...'))

        self.gui.status_bar.show_message(_('JS+ Job Has Finished'), 5000)

        self.force_refresh_of_cache(self.selected_books_list)

        self.mark_selected_books()

        del self.selected_books_list

        try:
            del job
        except:
            pass
    #---------------------------------------------------------------------------------------------------------------------------------------
    def build_job_param_dict(self):
        param_dict = {}
        return param_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def delete_temporary_reading_lists(self):

        if not prefs['GUI_TOOLS_AUTO_DELETE_TEMPORARY_READING_LISTS'] == unicode_type("True"):
            return

        try:
            from calibre_plugins.reading_list.config import (PREFS_NAMESPACE, PREFS_KEY_SETTINGS, KEY_LISTS,
                                                                                          KEY_DEFAULT_LIST, KEY_SCHEMA_VERSION,
                                                                                          DEFAULT_SCHEMA_VERSION, DEFAULT_LIBRARY_VALUES)
        except Exception as e:
            prefs['GUI_TOOLS_AUTO_DELETE_TEMPORARY_READING_LISTS'] = unicode_type("False")
            prefs
            if DEBUG: print("Reading List Plug-in is NOT installed, but the user has activated it in JS+...", as_unicode(e))
            return

        try:
            import copy
            db = self.gui.library_view.model().db
            library_config = db.prefs.get_namespaced(PREFS_NAMESPACE, PREFS_KEY_SETTINGS,
                                                                                copy.deepcopy(DEFAULT_LIBRARY_VALUES))
            lists = library_config[KEY_LISTS]
            tmp_dict = lists.copy()
            found_tmp_list = False
            #~ for k,v in tmp_dict.iteritems():
            for k,v in iteritems(tmp_dict):
              if k.startswith('!'):
                del lists[k]
                found_tmp_list = True
            #END FOR
            if found_tmp_list:
                library_config[KEY_LISTS]  = lists
                db.prefs.set_namespaced(PREFS_NAMESPACE, PREFS_KEY_SETTINGS, library_config)
        except Exception as e:
            if DEBUG: print("delete_temporary_reading_lists: ", as_unicode(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    def convert_datatype_coments_to_plaintext(self):

        self.selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Books Were Selected.'), show=True)
        self.selected_books_list.sort()
        #-------------------------------------
        # process selected books
        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        tmp_dict = {}
        mysql = "SELECT book,text FROM comments WHERE book = ?"
        for book in self.selected_books_list:
            my_cursor.execute(mysql,[book])
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                continue
            if len(tmp_rows) == 0:
                continue
            for row in tmp_rows:
                book,text = row
                tmp_dict[book] = text
            del tmp_rows
        #END FOR
        #-------------------------------------
        comments_dict = {}
        #~ for book,text in tmp_dict.iteritems():
        for book,text in iteritems(tmp_dict):
            text = html2text(text)
            text = text.strip()
            comments_dict[book] = text
        #END FOR
        del tmp_dict
        #-------------------------------------
        mysql = "UPDATE comments SET text = ? WHERE book = ? "
        my_cursor.execute("begin")
        #~ for book,text in comments_dict.iteritems():
        for book,text in iteritems(comments_dict):
            my_cursor.execute(mysql,(text,book))
        #END FOR
        my_cursor.execute("commit")
        #-------------------------------------
        my_db.close()
        #-------------------------------------
        self.force_refresh_of_cache(self.selected_books_list)
        #-------------------------------------
        self.mark_selected_books()
        #-------------------------------------

        n_books = len(self.selected_books_list)

        msg = ('Comments were converted from HTML to Plain Text for %d book(s)' %(n_books))
        self.show_gui_status_bar_qtimer(msg,5000)

        del comments_dict
        del self.selected_books_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def select_view_manager_view_for_vl(self):

        if prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_ACTIVE'] == unicode_type("False"):
            msg = "VL Views are inactive per Customization.  Nothing can be done until VL Views are activated and Calibre is restarted."
            error_dialog(self.gui, _('JS+ GUI Tool'),_(msg), show=True)
            return

        vlname = self.guidb.data.get_base_restriction_name()     #full name of the virtual library
        if DEBUG: print(vlname)

        try:
            p = re.compile(VL_REGEX, re.IGNORECASE)
            match_vl_tag = p.search(vlname)
            if not match_vl_tag:
                if DEBUG: print("RE no match_vl_tag")
                return
        except Exception as e:
            if DEBUG: print("RE COMPILE ERROR IN VL_REGEX", as_unicode(e))
            return

        vl_tag = match_vl_tag.group()
        if DEBUG: print("select_view_manager_view_for_vl:      vl_tag: ", vl_tag)

        try:
            from calibre_plugins.view_manager.config import (PREFS_NAMESPACE as vl_namespace,
                                                                                               PREFS_KEY_SETTINGS as vl_key_settings,
                                                                                               KEY_VIEWS as vl_key_views,
                                                                                               KEY_LAST_VIEW as vl_key_last_view)
        except Exception as e:
            if DEBUG: print("View Manager Plug-in is NOT installed, but the user has tried to use it via JS+...", as_unicode(e))
            prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_ACTIVE'] = unicode_type("False")
            prefs
            return

        db = self.gui.library_view.model().db
        library_config = db.prefs.get_namespaced(vl_namespace,vl_key_settings)
        views = library_config[vl_key_views]

        matching_view = None
        for view in views:
            if vl_tag in view:
                matching_view = view
                if DEBUG: print("select_view_manager_view_for_vl:  matching_view: ", matching_view)
                break

        if not matching_view:
            if DEBUG: print("select_view_manager_view_for_vl:  no matching view found for: ", vl_tag)
            return

        view_info = views[matching_view]

        #~ if DEBUG: print("view_info: ", as_unicode(view_info))

        view_manager_object = None

        from calibre.customize.ui import _initialized_plugins as tmp_list2

        for item in tmp_list2:
            s = as_unicode(item)
            if "calibre_plugins.view_manager.ActionViewManager" in s:
                #~ if DEBUG: print(s)                  #~ <calibre_plugins.view_manager.ActionViewManager object at 0x000000000354A4A8>
                view_manager_object = item
                break
        del tmp_list2

        if not view_manager_object:
            return

        #~ if DEBUG:
            #~ s = ', '.join(i for i in dir(view_manager_object) if not i.startswith('__'))
            #~ print(s)

        key = matching_view

        msg = "JS+ VL View Changed to: " + key
        self.show_gui_status_bar_qtimer(msg,5000)

        #change only if not already using the correct vl view...
        if key == library_config[vl_key_last_view]:
            if DEBUG: print("select_view_manager_view_for_vl:  already using the correct vl view...")
            return
        view_manager_object.actual_plugin_.switch_view(key)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def show_gui_status_bar_qtimer(self,msg,timeout=1000):
        self.qtimer_status_msg = msg
        self.qtimer_status_timeout = timeout
        QTimer.singleShot(1000, self.show_gui_status_bar_delayed)               # milliseconds
    #---------------------------------------------------------------------------------------------------------------------------------------
    def show_gui_status_bar_delayed(self):
        msg = self.qtimer_status_msg
        timeout = self.qtimer_status_timeout
        self.maingui.status_bar.show_message(msg)
        QApplication.instance().processEvents()  #otherwise, status bar messages will never be shown...
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def migrate_table_preferences_for_jobspy(self):
        #current library only...
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
            return

        #the use of table preferences by JS is long-deprecated.  delete JS from it if it exists.
        my_cursor.execute("begin")
        mysql = "DELETE FROM preferences WHERE key LIKE '%:JobSpyPlugin:settings'  "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        try:
            #the use of table __js_settings is normal and required when it was needed and created by custom_column_editable_dialog.py; otherwise, delete it if it contains only an empty dict  '{}'  .
            #~ typical value:  {u'CUSTOM_COLUMN_EDITABLE_MATRIX': {2: "[2, 'True', 'False', 'False', 'True', 'False', 'True']", 3: "[3,.....................
            mysql = "SELECT id,val FROM __js_settings WHERE key = 'reserved:JobSpyPlugin:settings' AND val != '{}' "
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                tmp_rows = []
            if len(tmp_rows) > 0:       # val != '{}'
                can_delete = False
                #~ if DEBUG: print("**cannot** delete; found: __js_settings WHERE key = 'reserved:JobSpyPlugin:settings' AND val != '{}'")
            else:
                can_delete = True
                #~ if DEBUG: print("**can delete**; did not find __js_settings WHERE key = 'reserved:JobSpyPlugin:settings' AND val != '{}'")

            if can_delete:
                my_cursor.execute("begin")
                mysql = "DROP TABLE IF EXISTS __js_settings "
                my_cursor.execute(mysql)
                my_cursor.execute("commit")

            del tmp_rows
            del can_delete
        except:
            #~ if DEBUG: print(" Job Spy table __js_settings does not exist at this time (which is normal).")
            pass

        my_db.close()
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_all_libraries_list(self,include_current=False):
        # has the complete list of all currently known Calibre libraries

        self.current_library_path = self.gui.library_view.model().db.library_path
        if isbytestring(self.current_library_path):
            self.current_library_path = self.current_library_path.decode(filesystem_encoding)
        self.current_library_path = self.current_library_path.replace(os.sep, '/').strip()

        self.target_library_list = []

        stats = self.gprefs.get('library_usage_stats', {})

        #~ for k,v in stats.iteritems():
        for k,v in iteritems(stats):
            k = k.strip()
            if k != self.current_library_path:
                self.target_library_list.append(k)
                #~ if DEBUG: print("gprefs: k", k)
            else:
                if include_current:
                    self.target_library_list.append(k)

        #END FOR

        del stats

        self.target_library_list.sort()
    #----------------------------------------------------
    def apsw_connect_to_target_library(self,selected_target_library):

        path = selected_target_library
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')

        if isbytestring(path):
            path = path.decode(filesystem_encoding)

        if path.endswith("/"):
            path = path[0:-1]

        try:
            my_db =apsw.Connection(path)
            is_valid = True
        except Exception as e:
            #~ if DEBUG: print("path to metadata.db is: ", path)
            #~ if DEBUG: print("error: ", as_unicode(e))
            is_valid = False
            return None,None,is_valid

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        return my_db,my_cursor,is_valid
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_reserved_prefs(self):

        try:
            try:
                my_db,my_cursor,is_valid = self.apsw_connect_to_library()
                if not is_valid:
                    error_dialog(self.gui, _('Job Spy'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
                    return
                mysql = "SELECT id,val FROM __js_settings WHERE key = 'reserved:JobSpyPlugin:settings' "
                my_cursor.execute(mysql)
                tmp_rows = my_cursor.fetchall()
                my_db.close()
                if not tmp_rows:
                    tmp_rows = []
                    self.library_config = None
                if len(tmp_rows) == 0:
                    self.library_config = None
                for row in tmp_rows:
                    id,val = row
                    if not val:
                        self.library_config = None
                    else:
                        self.library_config = val
                    break
                del tmp_rows
                if not self.library_config:
                    self.library_config = {}
            except Exception as e:
                #~ if DEBUG: print("[0] Exception in get_reserved_prefs: ", as_unicode(e))
                self.library_config = {}

            self.matrix_dict = self.library_config
            self.matrix_dict = as_unicode(self.matrix_dict)
            if not isinstance(self.matrix_dict,dict):
                self.matrix_dict = as_unicode(self.matrix_dict)
                self.matrix_dict = ast.literal_eval(self.matrix_dict)
            if not isinstance(self.matrix_dict,dict):
                self.matrix_dict = {}
            #~ if DEBUG:
                #~ for k,v in iteritems(self.matrix_dict):
                    #~ print("initial self.matrix_dict: ", as_unicode(k),as_unicode(v))
        except Exception as e:
            if DEBUG: print("[1] Exception in get_reserved_prefs: ", as_unicode(e))
            self.library_config = {}
            self.matrix_dict = {}

        self.unpack_matrix_column_labels()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def unpack_matrix_column_labels(self):
        #default to the generic, cross-library prefs values, but these will be overridden by self.matrix_dict if one exists...
        self.group1_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP1']
        self.group2_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP2']
        self.group3_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP3']
        self.group4_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP4']
        self.group5_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP5']
        self.group6_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP6']

        if len(self.matrix_dict) == 0:
            return

        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP1' in self.matrix_dict:
            self.group1_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP1']
        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP2' in self.matrix_dict:
            self.group2_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP2']
        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP3' in self.matrix_dict:
            self.group3_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP3']
        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP4' in self.matrix_dict:
            self.group4_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP4']
        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP5' in self.matrix_dict:
            self.group5_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP5']
        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP6' in self.matrix_dict:
            self.group6_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP6']

        #~ if DEBUG: print("1: ", self.group1_name)
        #~ if DEBUG: print("2: ", self.group2_name)
        #~ if DEBUG: print("3: ", self.group3_name)
        #~ if DEBUG: print("4: ", self.group4_name)
        #~ if DEBUG: print("5: ", self.group5_name)
        #~ if DEBUG: print("6: ", self.group6_name)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ignore_copy_to_library_cc_messages(self):

        include_current = True
        self.get_all_libraries_list(include_current)

        if len(self.target_library_list) == 0:
            return

        self.library_name_uuid_dict = {}

        for library in self.target_library_list:
            self.get_all_target_library_uuids(library)
        #END FOR

        self.add_items_to_libraries_with_checked_columns_defaultdict()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_all_target_library_uuids(self,library):
        my_db,my_cursor,is_valid = self.apsw_connect_to_target_library(library)
        if not is_valid:
            #~ if DEBUG: print("ERROR: apsw connection error - not is_valid for: ", library)
            return

        try:
            mysql = "SELECT id,uuid FROM library_id WHERE uuid NOT NULL and uuid > ' ' "
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
        except Exception as e:
            if DEBUG: print("Library is invalid for UUID lookup: ", library, "    ", as_unicode(e))
            my_db.close()
            return

        my_db.close()
        if not tmp_rows:
            tmp_rows = []
        if len(tmp_rows) != 1:
            return
        for row in tmp_rows:
            id,library_id = row
            libraryname = self.decompose_library_path(library)
            if libraryname > " ":
                if library_id > " ":
                    self.library_name_uuid_dict[libraryname] = library_id
                    #~ if DEBUG: print("added to uuid_dict: ", libraryname,library_id)
        #END FOR
        del tmp_rows
        return
    #---------------------------------------------------------------------------------------------------------------------------------------
    def decompose_library_path(self,library):

        #~ if DEBUG: print("path: ", library)
        if library.endswith("/"):
            library = library[ :-1]
        s_split = library.split("/")
        n = len(s_split)
        libraryname = s_split[n-1]
        libraryname = libraryname.strip()
        #~ if DEBUG: print("decomposed: ", libraryname)

        return libraryname
    #---------------------------------------------------------------------------------------------------------------------------------------
    def add_items_to_libraries_with_checked_columns_defaultdict(self):

        sources1 = prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_SOURCES_1'] + "|"
        sources2 = prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_SOURCES_2'] + "|"
        targets1 = prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_TARGETS_1'] + "|"
        targets2 = prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_TARGETS_2'] +"|"

        #~ if DEBUG: print("Sources1: ", sources1)
        #~ if DEBUG: print("Targets1: ", targets1)
        #~ if DEBUG: print("Sources2: ", sources2)
        #~ if DEBUG: print("Targets2: ", targets2)

        #~ ---------------------------------
        source1_list = []
        s_split = sources1.split("|")
        if "*" in s_split:
            #~ for k,v in self.library_name_uuid_dict.iteritems():
            for k,v in iteritems(self.library_name_uuid_dict):
                source1_list.append(k)
            #END FOR
        else:
            for row in s_split:
                source = row.strip()
                if source > " ":
                    if source in self.library_name_uuid_dict:
                        source1_list.append(source)
                    else:
                        if DEBUG: print("source1 missing from uuid dict: ", source)
            #END FOR
        #~ ---------------------------------
        target1_list = []
        s_split = targets1.split("|")
        if "*" in s_split:
            #~ for k,v in self.library_name_uuid_dict.iteritems():
            for k,v in iteritems(self.library_name_uuid_dict):
                target1_list.append(k)
            #END FOR
        else:
            for row in s_split:
                target = row.strip()
                if target > " ":
                    if target in self.library_name_uuid_dict:
                        target1_list.append(target)
                    else:
                        if DEBUG: print("target1 missing from uuid dict: ", target)
            #END FOR
        #~ ---------------------------------
        #~ ---------------------------------
        source2_list = []
        s_split = sources2.split("|")
        if "*" in s_split:
            #~ for k,v in self.library_name_uuid_dict.iteritems():
            for k,v in iteritems(self.library_name_uuid_dict):
                source2_list.append(k)
            #END FOR
        else:
            for row in s_split:
                source = row.strip()
                if source > " ":
                    if source in self.library_name_uuid_dict:
                        source2_list.append(source)
                    else:
                        if DEBUG: print("source2 missing from uuid dict: ", source)
            #END FOR
        #~ ---------------------------------
        target2_list = []
        s_split = targets2.split("|")
        if "*" in s_split:
            #~ for k,v in self.library_name_uuid_dict.iteritems():
            for k,v in iteritems(self.library_name_uuid_dict):
                target2_list.append(k)
            #END FOR
        else:
            for row in s_split:
                target = row.strip()
                if target > " ":
                    if target in self.library_name_uuid_dict:
                        target2_list.append(target)
                    else:
                        if DEBUG: print("target2 missing from uuid dict: ", target)
            #END FOR
        #~ ---------------------------------
        try:
            from calibre.gui2.actions.copy_to_library import libraries_with_checked_columns
        except Exception as e:
            if DEBUG: print("ignore_copy_to_library_cc_messages: import error: ", as_unicode(e))
            return
        #~ ---------------------------------

        for source in source1_list:
            for target in target1_list:
                source_uuid = self.library_name_uuid_dict[source]
                target_uuid = self.library_name_uuid_dict[target]
                libraries_with_checked_columns[source_uuid].add(target_uuid)
                #~ if DEBUG: print("[1]: ", source_uuid,"--->>", target_uuid)
            #END FOR
        #END FOR

        for source in source2_list:
            for target in target2_list:
                source_uuid = self.library_name_uuid_dict[source]
                target_uuid = self.library_name_uuid_dict[target]
                libraries_with_checked_columns[source_uuid].add(target_uuid)
                #~ if DEBUG: print("[2]: ", source_uuid,"--->>", target_uuid)
            #END FOR
        #END FOR

        #~ if DEBUG:
            #~ for k,v in iteritems(libraries_with_checked_columns):
                #~ print(k,v)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def change_gui_alternating_row_colors(self):

        if not self.maingui:
            if DEBUG: print("no self.maingui; returning...")
            return

        try:
            if self.color_runtype == "manual" or self.autorun_main_gui_colors:
                if prefs['GUI_TOOLS_MAIN_GUI_COLOR_ACTIVE'] == unicode_type("True"):
                    tc = prefs['GUI_TOOLS_MAIN_GUI_TEXT_COLOR']
                    vl = prefs['GUI_TOOLS_MAIN_GUI_VIRTUAL_LIBRARY_COLOR']
                    srch = prefs['GUI_TOOLS_MAIN_GUI_SEARCHBAR_COLOR']

                    vl_style_string = "QToolButton {background-color: [VL];color : [TC]; }"
                    vl_style_string = vl_style_string.replace("[TC]",tc)
                    vl_style_string = vl_style_string.replace("[VL]",vl)
                    self.maingui.virtual_library.setStyleSheet(vl_style_string)     # QToolButton virtual_library
                    self.maingui.clear_vl.setStyleSheet(vl_style_string)               # QToolButton clear_vl

                    #~ ss_string = "[QT] {background-color: [SRCH];color : [TC]; }"                              removed @ Calibre 6.8
                    #~ search_style_string = ss_string.replace("[TC]",tc)
                    #~ search_style_string = search_style_string.replace("[SRCH]",srch)
                    #~ search_style_string = search_style_string.replace("[QT] ","QToolButton, RightClickButton,SavedSearchBox,SearchBar,SearchBox2,StatusBar, VersionLabel ")
                    #~ self.maingui.copy_search_button.setStyleSheet(search_style_string)    # QToolButton copy_search_button                removed @ Calibre 6.8
                    #~ self.maingui.save_search_button.setStyleSheet(search_style_string)     # RightClickButton save_search_button          removed @ Calibre 6.8
                    #~ self.maingui.saved_search.setStyleSheet(search_style_string)   #SavedSearchBox saved_search                                  removed @ Calibre 6.8
                    #~ self.maingui.search_bar.setStyleSheet(search_style_string)     # SearchBar search_bar
                    #~ self.maingui.search.setStyleSheet(search_style_string)            # SearchBox2 search
                    #~ if prefs['GUI_TOOLS_STATUS_BAR_COLOR_CHANGE'] == unicode_type("False"):
                        #~ self.maingui.status_bar.setStyleSheet(search_style_string)     # StatusBar status_bar
                        #~ self.maingui.status_bar.defmsg.setStyleSheet(search_style_string)  # Version Label on left of status bar


            if self.color_runtype == "manual" or self.autorun_library_view_colors:
                if prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_ACTIVE'] == unicode_type("True"):
                    tc = prefs['GUI_TOOLS_LIBRARY_VIEW_TEXT_COLOR']
                    bc = prefs['GUI_TOOLS_LIBRARY_VIEW_BACKGROUND_COLOR']
                    ac = prefs['GUI_TOOLS_LIBRARY_VIEW_ALTERNATING_COLOR']


                    if prefs['GUI_TOOLS_LIBRARY_VIEW_COLUMN_HEADING_COLOR_CHANGE'] == unicode_type("True"):
                        style_string = "QTableView, QTreeView, QHeaderView, StatusBar, QToolButton {alternate-background-color: [AC];background-color: [BC];color : [TC]; }"
                    else:
                        style_string = "QTableView, QTreeView, StatusBar, QToolButton {alternate-background-color: [AC];background-color: [BC];color : [TC]; }"
                    style_string = style_string.replace("[TC]",tc)
                    style_string = style_string.replace("[BC]",bc)
                    style_string = style_string.replace("[AC]",ac)
                    self.maingui.library_view.setAlternatingRowColors(True)    # QTableView BooksView library_view       QHeaderView will change the column/row heading colors
                    self.maingui.library_view.setStyleSheet(style_string)
                    #-----As of Calibre 3.17 20180209------Begin
                    try:
                        self.maingui.library_view.pin_view.setAlternatingRowColors(True)
                        self.maingui.library_view.pin_view.setStyleSheet(style_string)
                    except Exception as e:
                        if DEBUG: print("Calibre version is too low for pin_view...", as_unicode(e))
                    #-----As of Calibre 3.17 20180209------End

                    self.maingui.tags_view.setAlternatingRowColors(True)       # QTreeView TagsView tags_view
                    self.maingui.tags_view.setStyleSheet(style_string)
                    self.maingui.alter_tb.setStyleSheet(style_string)   # QToolButton alter_tb       This is the 'configure' button in the very left bottom of the tag browser...just above the status bar...
                    #~ Note: the "find" button to the right of alter_tb is really a child of the stack and is a combobox with completer that is first shown with the button merged with the line edit; it is not worth messing with...

                    #~ if prefs['GUI_TOOLS_STATUS_BAR_COLOR_CHANGE'] == unicode_type("True"):
                        #~ self.maingui.status_bar.setStyleSheet(style_string)   # StatusBar status_bar
                        #~ style_string2 = "VersionLabel, " + style_string
                        #~ self.maingui.status_bar.defmsg.setStyleSheet(style_string2)  # Version Label on left of status bar

                    #~ book_details_style_string = "QWidget {background-color: [BC];color : [TC];}"
                    #~ book_details_style_string = book_details_style_string.replace("[TC]",tc)
                    #~ book_details_style_string = book_details_style_string.replace("[BC]",bc)
                    #~ self.maingui.book_details.setStyleSheet(book_details_style_string)     # QWidget  BookDetails book_details

            #~ if self.color_runtype == "manual" or self.autorun_main_gui_colors:                                               removed @ Calibre 6.8
                #~ if prefs['GUI_TOOLS_MAIN_GUI_COLOR_ACTIVE'] == unicode_type("True"):
                    #~ tc = prefs['GUI_TOOLS_MAIN_GUI_TEXT_COLOR']
                    #~ srch = prefs['GUI_TOOLS_MAIN_GUI_SEARCHBAR_COLOR']
                    #~ search_style_string = "background-color: [SRCH];color : [TC];"
                    #~ search_style_string = search_style_string.replace("[TC]",tc)
                    #~ search_style_string = search_style_string.replace("[SRCH]",srch)
                    #~ toolbar_style_string = 'QToolBar { border: 0px;' + search_style_string + ' }'
                    #~ for bar in self.maingui.bars_manager.main_bars:
                        #~ bar.setStyleSheet(toolbar_style_string)
                        #~ if DEBUG: print("main bar", as_unicode(bar))  # <calibre.gui2.bars.ToolBar              2 of these...
                    #~ for bar in self.maingui.bars_manager.child_bars:
                        #~ bar.setStyleSheet(toolbar_style_string)
                        #~ if DEBUG: print("child bar", as_unicode(bar))  #<calibre.gui2.bars.ToolBar               1 of these...

        except Exception as e:
            if DEBUG: print("JS: Setting GUI Colors *Error*: ", as_unicode(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def sqlite_vacuum_en_masse(self):
        self.get_all_libraries_list()
        n = len(self.target_library_list)
        msg = "Vacuum all of the <b>" + as_unicode(n) + "</b> Calibre Libraries currently remembered if they still exist and can be connected?"
        #~ for library in self.target_library_list:
            #~ msg = msg + "<br>" + library
        #~ #END FOR
        msg = msg + "<br><br><b><i>Offline/Unconnected Network/Cloud Libraries will necessarily be skipped.<i></b>"
        if question_dialog(self.gui, "JS+ GUI Tool - Vacuum/Compress metadata.db En Masse", msg):
            pass
        else:
            return

        for library in self.target_library_list:
            msg = "Vacuuming: " + library
            self.gui.status_bar.show_message(_(msg), 2000)
            my_db,my_cursor,is_valid = self.apsw_connect_to_target_library(library)
            if not is_valid:
                if DEBUG: print("not is_valid for: ", library)
                continue
            my_cursor.execute("VACUUM")
            my_db.close()
        #END FOR
        n = len(self.target_library_list)
        msg = "Total Other Libraries Vacuumed: " + as_unicode(n) + "  --  Current  Library Ignored..."
        self.gui.status_bar.show_message(_(msg), 10000)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def kb_shortcut_cc1(self):
        if not prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_AUTOFILL_ACTIVE'] == unicode_type("True"):
            return
        selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool for KB Shortcut #1'),_('No Books Were Selected.'), show=True)
        selected_books_list.sort()
        predefined_cc1 = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE1_CUSTOM_COLUMN']
        predefined_cc1_value = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE1_VALUE']
        was_success = self.update_custom_metadata_using_standard_calibre(selected_books_list,predefined_cc1,predefined_cc1_value)
        if not was_success:
            if DEBUG: print("JS+:  CC1  ERROR: update_custom_column using keyboard shortcut")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def kb_shortcut_cc2(self):
        if not prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_AUTOFILL_ACTIVE'] == unicode_type("True"):
            return
        selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool for KB Shortcut #2'),_('No Books Were Selected.'), show=True)
        selected_books_list.sort()
        predefined_cc2 = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE2_CUSTOM_COLUMN']
        predefined_cc2_value = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE2_VALUE']
        was_success = self.update_custom_metadata_using_standard_calibre(selected_books_list,predefined_cc2,predefined_cc2_value)
        if not was_success:
            if DEBUG: print("JS+:  CC2  ERROR: update_custom_column using keyboard shortcut")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def kb_shortcut_cc3(self):
        if not prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_AUTOFILL_ACTIVE'] == unicode_type("True"):
            return
        selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool for KB Shortcut #3'),_('No Books Were Selected.'), show=True)
        selected_books_list.sort()
        predefined_cc3 = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE3_CUSTOM_COLUMN']
        predefined_cc3_value = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE3_VALUE']
        was_success = self.update_custom_metadata_using_standard_calibre(selected_books_list,predefined_cc3,predefined_cc3_value)
        if not was_success:
            if DEBUG: print("JS+:  CC3  ERROR: update_custom_column using keyboard shortcut")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def kb_shortcut_cc4(self):
        if not prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_AUTOFILL_ACTIVE'] == unicode_type("True"):
            return
        selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool for KB Shortcut #4'),_('No Books Were Selected.'), show=True)
        selected_books_list.sort()
        predefined_cc4 = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE4_CUSTOM_COLUMN']
        predefined_cc4_value = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE4_VALUE']
        was_success = self.update_custom_metadata_using_standard_calibre(selected_books_list,predefined_cc4,predefined_cc4_value)
        if not was_success:
            if DEBUG: print("JS+:  CC4  ERROR: update_custom_column using keyboard shortcut")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_custom_metadata_using_standard_calibre(self,selected_books_list,predefined_cc,predefined_value):

        predefined_cc = as_unicode(predefined_cc.strip())

        if not predefined_cc in self.current_custom_columns_list:
            return False

        mi_field = predefined_cc  # should be a '#label'

        #~ Validate datatype
        custcol = self.custom_columns_metadata_dict[mi_field]   # should be a '#label'
        cc_datatype = custcol['datatype']
        if cc_datatype != "text" and cc_datatype != "comments" and cc_datatype != "enumeration":
            #~ if DEBUG: print("cc_datatype is not text and is not comments and is not an enumeration: ", predefined_cc, "   ", cc_datatype)
            msg = "Customized KB Shortcut Custom Column datatype is not text and is not comments and is not an enumeration (fixed set of values): " + predefined_cc + " with a value type of:  " + cc_datatype
            error_dialog(self.gui, _('JS+ GUI Tool for KB Shortcuts'),_(msg), show=True)
            return False

        payload = selected_books_list

        id_map = {}

        for book in selected_books_list:
            book = int(book)
            mi = Metadata(_('Unknown'))
            custcol = self.custom_columns_metadata_dict[mi_field]   # should be a '#label'
            custcol['#value#'] = predefined_value
            mi.set_user_metadata(mi_field, custcol)
            id_map[book] = mi
        #END FOR
        edit_metadata_action = self.maingui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=None)

        del id_map
        del mi

        return True
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def list_all_keyboard_shortcuts(self):
        #~ -------------------------------------------------
        from calibre.utils.icu import sort_key
        self.keyboard = self.maingui.keyboard     #  gui2/keyboard.py      gui2/preferences/keyboard.py
        #~ -------------------------------------------------
        #~ First, get all standard Calibre shortcuts:
        #~ -------------------------------------------------
        groups = sorted(self.keyboard.groups, key=sort_key)
        #~ shortcut_map = {k:v.copy() for k, v in self.keyboard.shortcuts.iteritems()}
        shortcut_map = {k:v.copy() for k, v in iteritems(self.keyboard.shortcuts)}

        shortcut_assignments_dict = {}
        shortcut_name_std_dict = {}

        #~ for un, s in shortcut_map.iteritems():
        for un, s in iteritems(shortcut_map):
            s['keys'] = tuple(self.keyboard.keys_map.get(un, ()))
            k = as_unicode(s['keys'])
            if k.count("()") == 1:
                continue
            s['unique_name'] = un
            #~ s['group'] = [g for g, names in self.keyboard.groups.iteritems() if un in names][0]
            s['group'] = [g for g, names in iteritems(self.keyboard.groups) if un in names][0]
            shortcut = as_unicode(s['default_keys'])
            sc = shortcut
            shortcut = shortcut.replace("Ctrl+Shift","Shift+Ctrl")
            shortcut = shortcut.replace("Alt+Shift","Shift+Alt")
            shortcut = shortcut.replace("Alt+Ctrl","Ctrl+Alt")
            if DEBUG:
                if sc != shortcut:
                    print("Sequence of Ctrl, Shift, Alt standardized from: ", sc, "  to: ", shortcut)
            shortcut = as_unicode(shortcut)
            s['default_keys'] = ast.literal_eval(shortcut)
            row = 'Default', s['group'], s['name'], s['default_keys']
            ss = as_unicode(s['default_keys'])
            if ss.count("()") == 1:  # e.g.    tag browser alter ()
                if DEBUG: print("...............................................................................")
                continue
            name = s['name']
            shortcut_name_std_dict[name] = ss
            shortcut_assignments_dict[ss] = row
            if DEBUG: print("Standard: ", as_unicode(row))
        #END FOR

        #~ -------------------------------------------------
        #~ Next, get all User Custom shortcuts:
        #~ -------------------------------------------------

        if DEBUG: print("--------------------------------------------------------------")

        from calibre.utils.config import JSONConfig
        config_name='shortcuts/main'
        self.config = JSONConfig(config_name)

        #~ if DEBUG:
            #~ for map,data in iteritems(self.config):
                #~ for k,v in iteritems(data):
                    #~ print("k: ", as_unicode(k), "  v: ", as_unicode(v))

        shortcut_name_custom_dict = {}

        #~ custom_keys_map = {un:tuple(keys) for un, keys in self.config.get('map', {}).iteritems()}
        custom_keys_map = {un:tuple(keys) for un, keys in iteritems(self.config.get('map', {}))}

        #~ for un,shortcut in custom_keys_map.iteritems():
        for un,shortcut in iteritems(custom_keys_map):
            if DEBUG: print("custom_keys_map CUSTOM:  un: ", as_unicode(un), ",   shortcut: ", as_unicode(shortcut))
            ss = as_unicode(shortcut)
            if ss.count("()") == 1:  # e.g.    tag browser alter ()
                if DEBUG: print("...............................................................................")
                continue

            group,tmpname = self.parse_group_name(un)

            shortcut = as_unicode(shortcut)
            sc = shortcut
            shortcut = shortcut.replace("Ctrl+Shift","Shift+Ctrl")
            shortcut = shortcut.replace("Alt+Shift","Shift+Alt")
            shortcut = shortcut.replace("Alt+Ctrl","Ctrl+Alt")
            if DEBUG:
                if sc != shortcut:
                    print("Sequence of Ctrl, Shift, Alt standardized from: ", sc, "  to: ", shortcut)
            shortcut = as_unicode(shortcut)
            shortcut = ast.literal_eval(shortcut)

            if un in self.keyboard.shortcuts:
                name = self.keyboard.shortcuts[un]['name']
                if DEBUG: print("un unique name found in keyboard: ", name)
                if group == "qaction":
                    group = name
                    if DEBUG: print("temporary group of 'qaction' reset to final value of: ", name)
            else:
                name = tmpname
                if DEBUG: print("un unique name not found in keyboard.shortcuts: ", name, "  group: ", group)

            if name in shortcut_name_std_dict:
                #delete the standard sc which is no longer used...
                ss = shortcut_name_std_dict[name]
                del shortcut_assignments_dict[ss]
                if DEBUG: print("Reassigned Standard sc deleted from final list: ", name, ss)

            row = 'Custom', group, name, shortcut
            shortcut_assignments_dict[ss] = row
            shortcut_name_custom_dict[name] = row
            if DEBUG: print("shortcut_assignments_dict[ss] = row Custom: ", as_unicode(row))
            if DEBUG: print("...............................................................................")
        #END FOR

        shortcut_assignments_list = []
        #~ for k,v in shortcut_assignments_dict.iteritems():
        for k,v in iteritems(shortcut_assignments_dict):
            shortcut_assignments_list.append(v)
        #END FOR

        #~ -------------------------------------------------
        #~ Finally, display the sortable listing of all shortcuts
        #~ -------------------------------------------------
        try:
            self.shortcutslistingdialog.close()
        except:
            pass

        from calibre_plugins.job_spy.shortcuts_listing_dialog import ShortcutsListingDialog
        self.shortcutslistingdialog = ShortcutsListingDialog(None,shortcut_assignments_list)
        self.shortcutslistingdialog.show()

        del shortcut_name_custom_dict
        del shortcut_name_std_dict
        del shortcut_assignments_list
        del shortcut_assignments_dict
        del ShortcutsListingDialog
        del custom_keys_map
        del shortcut_map
        del JSONConfig
        del sort_key
    #---------------------------------------------------------------------------------------------------------------------------------------
    def parse_group_name(self,un):

        #~ Interface Action: Job Spy (Job Spy) : menu action : JS+:GUI Tool:   Keyboard Shortcut to Autofill Custom Column #1 [Selected Books] >>> (u'Ctrl+Num+1',)
        #~ Interface Action: Library Codes (Library Codes) : menu action : Attempt to Substitute Non-Responsive ISBN Using Author/Title [Selected Single Book] >>> (u'Ctrl+Alt+Z',)
        #~ Interface Action: Drop Search Results (Drop Search Results) : menu action : Drop Search Results >>> (u'F12',)
        #~ 62d04d2b-be8b-417f-89bd-b90bd7f0a8d2  >>> (u'Shift+Z',)               "matched with windows_open_with.json  for real name...
        #~ splitter cover_browser_splitter Cover browser  >>> (u'Ctrl+Alt+C',)
        #~ Focus To Quickview  >>> (u'Ctrl+Shift+Q',)

        if DEBUG: print("parse_group_name: *original* 'unique name': ", un)

        group = "Miscellaneous"
        name = un

        try:
            s_split1 = un.split("Interface Action:")
            if s_split1:
                if isinstance(s_split1,list):
                    if len(s_split1) > 1:
                        for row in s_split1:
                            row = row.strip()
                            if "qaction" in row:
                                group = "qaction"
                                name = "qaction"
                                if DEBUG: print("contains 'qaction', not 'menu action', so temporary values assigned until later")
                            else:
                                s_split2 = row.split(": menu action :")
                                if s_split2:
                                    if isinstance(s_split2,list):
                                        if len(s_split2) > 1:
                                            group = s_split2[0].strip()
                                            name = s_split2[1].strip()
                                        else:
                                            if DEBUG: print("unique name does not contain ': menu action :' so group MIGHT need to be defaulted to 'Miscellaneous': ", un)
                                    else:
                                        if DEBUG: print("unique name does not contain ': menu action :' so group MIGHT need to be defaulted to 'Miscellaneous': ", un)
                                else:
                                    if DEBUG: print("unique name does not contain ': menu action :' so group MIGHT need to be defaulted to 'Miscellaneous': ", un)
                        #END FOR
                    else:
                        if DEBUG: print("unique name does not contain 'Interface Action:' so group MIGHT need to be defaulted to 'Miscellaneous': ", un)
                else:
                    if DEBUG: print("unique name does not contain 'Interface Action:' so group MIGHT need to be defaulted to 'Miscellaneous': ", un)
            else:
                if DEBUG: print("unique name does not contain 'Interface Action:' so group MIGHT need to be defaulted to 'Miscellaneous': ", un)
        except Exception as e:
            if DEBUG: print("JS+ Shortcuts Listing custom shortcut parse error for: ", un, "     ", as_unicode(e), " >>>> Group set to 'Miscellaneous' ")

        if group.endswith(")") and "(" in group:  # example:  Job Spy (Job Spy)
            s_split = group.split("(")
            group = s_split[0].strip()   # example:  Job Spy

        name = name.strip()

        if DEBUG: print("parse_group_name: *parsed* group & name: ", group, "  ", name)

        return group,name
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def mega_metadata_book_creator_tool(self):

        selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool Mega-Metadata Book Creation Helper'),_('No Book Was Selected.'), show=True)
        if n_books > 1:
             return error_dialog(self.gui, _('JS+ GUI Tool Mega-Metadata Book Creation Helper'),_('Only a single book may be Selected.'), show=True)

        selected_books_list.sort()

        choices = as_unicode(prefs['GUI_TOOLS_MEGA_METADATA_BOOK_HELPER_CHOICES_DICT'])
        choices_dict = ast.literal_eval(choices)
        if not isinstance(choices_dict,dict):
            if DEBUG: print("choices_dict is invalid dict")
            return

        tags = choices_dict["tags"]
        if tags == "True":
            tags = True
        else:
            tags = False
        cc = choices_dict["cc"]
        if cc == "True":
            cc = True
        else:
            cc = False
        custom_columns = as_unicode(choices_dict["custom_columns"])
        custom_columns_list = ast.literal_eval(custom_columns)
        custom_columns_list.sort()


        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        cc_list_dict = {}

        if tags:
            tag_list = self.get_all_tags(my_db,my_cursor)
            if len(tag_list) > 0:
                self.mega_metadata_update_tags(my_db,my_cursor,selected_books_list,tag_list)

        if cc:
            for row in custom_columns_list:
                row = as_unicode(row).strip()
                value_list = self.get_all_of_cc(my_db,my_cursor,row)
                cc_list_dict[row] = value_list
            #END FOR
            #~ for custcolumn,value_list in cc_list_dict.iteritems():
            for custcolumn,value_list in iteritems(cc_list_dict):
                if len(value_list) > 0:
                    for book in selected_books_list:
                        is_valid = self.mega_metadata_update_custom_column(book,custcolumn,value_list)
                        if not is_valid:
                            if DEBUG: print("self.mega_metadata_update_custom_column(book,custcol,value_list) failed for: ", as_unicode(custcolumn))
                            break
                    #END FOR
            #END FOR

        my_db.close()
        #-------------------------------------
        self.force_refresh_of_cache(selected_books_list)
        #-------------------------------------
        self.selected_books_list = selected_books_list
        self.mark_selected_books()
        del selected_books_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_all_tags(self,my_db,my_cursor):
        tag_list = []
        mysql = "SELECT id,name FROM tags ORDER BY name"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            id,name = row
            tag_list.append(id)
        #END FOR
        del tmp_rows

        return tag_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def mega_metadata_update_tags(self,my_db,my_cursor,selected_books_list,tag_list):

        my_cursor.execute("begin")

        for book in selected_books_list:
            for tag in tag_list:
                mysql = "INSERT OR IGNORE INTO books_tags_link (id,book,tag) VALUES (null,?,?)"
                my_cursor.execute(mysql,(book,tag))
            #END FOR
        #END FOR

        my_cursor.execute("commit")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_all_of_cc(self,my_db,my_cursor,cc):

        custcol = self.custom_columns_metadata_dict[cc]   # should be a '#label'
        cc_table = as_unicode(custcol['table'])

        cc_list = []

        mysql = "SELECT id,value FROM [TABLE] ORDER BY value"
        mysql = mysql.replace("[TABLE]",cc_table)
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            id,value = row
            cc_list.append(value)
        #END FOR
        del tmp_rows

        return cc_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def mega_metadata_update_custom_column(self,book,custcolumn,value_list):

        custcolumn = custcolumn.strip()
        custcolumn = as_unicode(custcolumn)

        if not custcolumn in self.current_custom_columns_list:
            if DEBUG: print("not custcolumn in self.current_custom_columns_list; return False...")
            return False

        mi_field = custcolumn  # should be a '#label'

        #~ Validate datatype
        custcol = self.custom_columns_metadata_dict[mi_field]   # should be a '#label'
        cc_datatype = custcol['datatype']
        if cc_datatype != "text":
            msg = "Customized Custom Column is NOT a Tag-like Text type: " + custcolumn + " and has a value type of:  " + cc_datatype
            error_dialog(self.gui, _('JS+ GUI Tool for Mega-Metadata Book Creation Helper'),_(msg), show=True)
            return False

        book_list = []
        book = int(book)
        book_list.append(book)

        payload = book_list

        id_map = {}

        mi = Metadata(_('Unknown'))
        custcol = self.custom_columns_metadata_dict[mi_field]   # should be a '#label'
        custcol['#value#'] = value_list
        mi.set_user_metadata(mi_field, custcol)
        id_map[book] = mi

        edit_metadata_action = self.maingui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=None)

        del custcol
        del id_map
        del mi
        del value_list

        return True
    #---------------------------------------------------------------------------------------------------------------------------------------
    def invert_selection(self):
        #great as a shortcut...
        self.get_selected_books()
        self.mark_selected_books()
        self.gui.search.clear()
        self.gui.search.set_search_string('marked:false')
        self.maingui.library_view.selectAll()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def copy_to_library_shortcut(self):
        if not self.mycopytolibraryobject:
            #~ for k,v in self.maingui.iactions.iteritems():
            for k,v in iteritems(self.maingui.iactions):
                if "Copy To Library" in k:
                    self.mycopytolibraryobject = v
                    self.monkey_patch_chooselibrary()
                    break
            #END FOR

        if self.mycopytolibraryobject:
            try:
                self.mycopytolibraryobject.choose_library()
            except Exception as e:
                if DEBUG: print("Error in copy_to_library_shortcut: ", as_unicode(e))
        #----------------------------------------
        #----------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def monkey_patch_chooselibrary(self):
        #~ -------------------------------------
        def js_browse(self):
            title = "Choose the Target Calibre Library"
            default_user_library_directory = prefs['GUI_TOOLS_COPY_TO_LIBRARY_SHORTCUT_DEFAULT_DIRECTORY']
            chosen_directory_name = QFileDialog.getExistingDirectory(None,title,default_user_library_directory,QFileDialog.Option.ShowDirsOnly | QFileDialog.Option.DontResolveSymlinks )
            self.le.setText(chosen_directory_name)
        #~ -------------------------------------
        from calibre.gui2.actions.copy_to_library import ChooseLibrary
        ChooseLibrary.browse = js_browse
        #~ -------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ftp_selected_books(self):

        self.selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Books Were Selected.'), show=True)
        self.selected_books_list.sort()

        self.guidb = self.gui.library_view.model().db
        my_db = self.gui.library_view.model().db
        libpath = my_db.library_path
        if isbytestring(libpath):
            libpath = libpath.decode(filesystem_encoding)
        libpath = libpath.replace(os.sep, '/')
        libpath = libpath + "/"
        if DEBUG: print("libpath: ", libpath)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        try:
            my_book_path_dict = {}
            mysql = "SELECT id,path FROM books WHERE id = ?"
            for book in self.selected_books_list:
                my_cursor.execute(mysql,([book]))
                tmp_rows = my_cursor.fetchall()
                if not tmp_rows:
                    tmp_rows = []
                if len(tmp_rows) == 0:
                   continue
                for row in tmp_rows:
                    id,path = row
                    my_book_path_dict[id] = libpath + path
                #END FOR
                del tmp_rows
            #END FOR

            formats = prefs['GUI_TOOLS_FTP_FORMAT']
            formats = formats.upper().strip()
            formats = formats + ","
            formats = formats.replace(" ","")
            formats_list = formats.split(",")

            my_book_name_dict = {}

            mysql = "SELECT book,format,name FROM data WHERE book = ? AND format = ?"

            for book in self.selected_books_list:
                found_format = False
                format_to_use = ""
                name_to_use = ""
                for format in formats_list:  # in priority sequence
                    if format > " ":
                        my_cursor.execute(mysql,(book,format))
                        tmp_rows = my_cursor.fetchall()
                        if not tmp_rows:
                            #~ if DEBUG: print("format  not found for book: ", format)
                            continue
                        if len(tmp_rows) == 0:
                            #~ if DEBUG: print("format  not found for book: ", format)
                            continue
                        for row in tmp_rows:
                            book,form,name = row
                            found_format = True
                            format_to_use = form
                            name_to_use = name
                            #~ if DEBUG: print("format was found for book: ", format, name)
                        #END FOR
                        if found_format:
                            break
                #END FOR
                if not found_format:
                    if book in my_book_path_dict:
                        del my_book_path_dict[book]
                    continue
                else:
                    path = my_book_path_dict[book]
                    name = name + "." + format_to_use.lower()
                    my_book_name_dict[book] = name
                    path = os.path.join(path, name)
                    path = path.replace(os.sep, '/')
                    my_book_path_dict[book] = path
                    #~ if DEBUG: print("full book format path: ", path)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))
        #-------------------------------------
        my_db.close()
        #-------------------------------------

        host = prefs['GUI_TOOLS_FTP_HOST']
        port = prefs['GUI_TOOLS_FTP_HOST_PORT']
        host_directory = prefs['GUI_TOOLS_FTP_HOST_DIRECTORY']
        userid = prefs['GUI_TOOLS_FTP_USERID']
        password = prefs['GUI_TOOLS_FTP_PASSWORD']

        host = host.replace(os.sep,"/")
        host_directory = host_directory.replace(os.sep,"/")

        port = as_unicode(port.strip())
        if port.isdigit():
            port = int(port)
        else:
            port = 21

        if not self.myftp:
            from ftplib import FTP
            self.myftp = FTP
            del FTP

        ftp = self.myftp()

        try:
            ftp.connect(host,port)
        except Exception as e:
            msg = "Fatal error connecting to FTP host: " + as_unicode(host) + " port: " + as_unicode(port) + "  >>>  " + as_unicode(e)
            return error_dialog(self.gui, _('FTP'),_(msg), show=True)

        try:
            ftp.login(userid,password)
        except Exception as e:
            ftp.quit()
            msg = "Fatal error logging in to FTP host using specified credentials: " + as_unicode(e)
            return error_dialog(self.gui, _('FTP'),_(msg), show=True)

        try:
            ftp.cwd(host_directory)
        except Exception as e:
            ftp.quit()
            msg = "Fatal error changing directory to: " + host_directory + "  >>>  " + as_unicode(e)
            return error_dialog(self.gui, _('FTP'),_(msg), show=True)

        msg_list = []
        n_success = 0
        n_warning = 0
        n_no_formats_found = 0
        #~ for k,v in my_book_path_dict.iteritems():
        for k,v in iteritems(my_book_path_dict):
            if not k in my_book_name_dict:
                n_no_formats_found = n_no_formats_found + 1
                continue
            name = my_book_name_dict[k]
            v = v.replace( '/',os.sep)
            ok,msg = self.ftp_upload(ftp, v, name)
            if not ok:
                n_warning = n_warning + 1
                line = name,msg
                msg_list.append(line)
            else:
                n_success = n_success + 1
        #END FOR

        try:
            ftp.quit()
        except:
            try:
                ftp.close()
            except:
                pass

        n_total = len(my_book_path_dict)

        msg = "Books Selected: " + as_unicode(n_total) + "\nBooks with a specified format: " + as_unicode(n_success) + "\nBooks with no specified format: " + as_unicode(n_no_formats_found)
        msg = msg + "\nBooks having an FTP error message: " + as_unicode(n_warning) + "\n\n"
        for line in msg_list:
            name,m = line
            msg = msg + m + "\n"
        #END FOR

        if DEBUG: print(msg)

        info_dialog(self.gui, 'FTP Results: ',msg).show()

        del my_book_path_dict
        del ftp
    #----------------------------------------------------
    def ftp_upload(self,ftp, file, name):
        try:
            msg = "Uploading: " + name
            self.gui.status_bar.show_message(_(msg), 1000)
            #~ if DEBUG: print("ftp_upload: ", file)
            ftp.storbinary("STOR " + name, open(file, "rb"), 1024)   # 8192 or 1024
            return True,None
        except Exception as e:
            if DEBUG: print("ftp_upload error: ", as_unicode(e))
            msg = as_unicode(name) + "  :  " + as_unicode(e)
            return False,msg
    #---------------------------------------------------------------------------------------------------------------------------------------
    def list_custom_columns_technical_details(self):

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        cc_list = []

        try:
            mysql = "SELECT id,label,name,datatype,mark_for_delete,editable,display,is_multiple,normalized FROM custom_columns ORDER BY label,name"
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
        except:
            tmp_rows = []

        my_db.close()

        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            cc_list.append(row)
        #END FOR
        del tmp_rows

        try:
            self.cctechnicallistingdialog.close()
        except:
            pass

        from calibre_plugins.job_spy.custom_columns_technical_listing_dialog import CustomColumnsTechnicalListingDialog
        self.cctechnicallistingdialog = CustomColumnsTechnicalListingDialog(None,cc_list)
        self.cctechnicallistingdialog.show()
        self.cctechnicallistingdialog.setAttribute(Qt.WA_DeleteOnClose)
        del CustomColumnsTechnicalListingDialog
        del cc_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_matrix_custom_columns_by_library(self):
        self.get_all_libraries_list(include_current=True)
        library_cc_dict = {}  # [library] = cc_list
        for target in self.target_library_list:
            cc_list = []
            my_db,my_cursor,is_valid = self.apsw_connect_to_target_library(target)
            if not is_valid:
                library_cc_dict[target] = None
                continue
            try:
                mysql = "SELECT id,label,name,datatype,editable,display,is_multiple,normalized FROM custom_columns"
                my_cursor.execute(mysql)
                tmp_rows = my_cursor.fetchall()
            except:  #table never created...
                tmp_rows = []
            my_db.close()
            if not tmp_rows:
                tmp_rows = []
            for row in tmp_rows:
                cc_list.append(row)
            #END FOR
            del tmp_rows
            library_cc_dict[target] = cc_list
            del cc_list
        #END FOR

        try:
            self.ccmatrixbylibrarydialog.close()
        except:
            pass

        if len(library_cc_dict) == 0:
            return

        from calibre_plugins.job_spy.custom_columns_matrix_by_library_dialog import CustomColumnsMatrixByLibraryDialog
        self.ccmatrixbylibrarydialog = CustomColumnsMatrixByLibraryDialog(None,library_cc_dict)
        self.ccmatrixbylibrarydialog.show()
        self.ccmatrixbylibrarydialog.setAttribute(Qt.WA_DeleteOnClose)
        del CustomColumnsMatrixByLibraryDialog
        del library_cc_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def search_for_clipboard_book_list_titles(self):
        search_text = self.clip.text()
        if not isinstance(search_text,unicode_type):
            return
        #~ if DEBUG: print("self.clip.text():", search_text)
        if search_text:
            orig_text = search_text
            btitles = ""  #book title search string
            search_list = search_text.split("\n")
            if isinstance(search_list,list):
                for line in search_list:
                    line = line.strip()
                    #~ if DEBUG: print(line)
                    if line > " ":
                        btitles = btitles + 'title:"' + line + '" OR '
                #END FOR
            else:
                if orig_text > " ":
                    btitles = btitles + 'title:"' + orig_text + '" OR '

            if btitles.endswith(" OR "):
                btitles = btitles[0:-4]
            self.gui.search.clear()
            self.gui.search.set_search_string(btitles)

            del btitles
            del search_text
            del orig_text
            del search_list
        else:
            self.gui.search.clear()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def search_for_clipboard_book_list_custom_columns(self):
        search_text = self.clip.text()
        if not isinstance(search_text,unicode_type):
            self.gui.search.clear()
            return
        #~ if DEBUG: print("self.clip.text():", search_text)
        if search_text:
            orig_text = search_text
            bcol = self.get_bcol()      #selected library_view column to search
            if not bcol:
                self.gui.search.clear()
                return
            bcolval = ""  #book column search string
            search_list = search_text.split("\n")
            if isinstance(search_list,list):
                for line in search_list:
                    line = line.strip()
                    #~ if DEBUG: print(line)
                    if line > " ":
                        line = line.replace('"',"'")
                        bcolval = bcolval + bcol + ':"' + line + '" OR '
                #END FOR
            else:
                if orig_text > " ":
                    orig_text = orig_text.replace('"',"'")
                    bcolval = bcolval + bcol + ':"' + orig_text + '" OR '

            if bcolval.endswith(" OR "):
                bcolval = bcolval[0:-4]

            self.gui.search.clear()
            self.gui.search.set_search_string(bcolval)

            del bcolval
            del search_text
            del orig_text
            del search_list
        else:
            self.gui.search.clear()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_bcol(self):
        bcol = None
        current_col = self.maingui.library_view.currentIndex().column()
        bcol = self.maingui.library_view.column_map[current_col]
        if DEBUG: print("current_col: ", as_unicode(current_col), "lookup/search name: ", as_unicode(bcol))
        return bcol
    #---------------------------------------------------------------------------------------------------------------------------------------
    def bulk_update_comments_custom_columns(self):
        clipboard_text = self.clip.text()
        if not isinstance(clipboard_text,unicode_type):
            return
        if clipboard_text:
            self.bulk_actions_comments_custom_columns(action="update",update_text=clipboard_text)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def bulk_empty_comments_custom_columns(self):
        self.bulk_actions_comments_custom_columns(action="empty")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def bulk_actions_comments_custom_columns(self,action=None,update_text=None):

        if not action:
            return

        bcol = self.get_bcol()      #selected library_view column to empty
        if not bcol:
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Column Was Selected. Your cursor must be within a cell underneath the desired Column.'), show=True)
        if not bcol.startswith("#"):
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Custom Column Was Selected. Your cursor must be within a cell underneath the desired Column.'), show=True)

        if DEBUG: print("Update CC: ", bcol)

        custom_columns_metadata_dict = self.gui.current_db.field_metadata.custom_field_metadata()
        if not bcol in custom_columns_metadata_dict:
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('Custom Column Was Not Found.  Unexpected Error.'), show=True)
        custcol = custom_columns_metadata_dict[bcol]

        if not custcol['datatype'] == "comments":
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Comments/Long-Text Custom Column Was Selected. Your cursor must be within a cell underneath the desired Column.'), show=True)

        self.selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Books Were Selected.'), show=True)
        self.selected_books_list.sort()

        payload = self.selected_books_list

        id_map = {}

        for book in self.selected_books_list:
            book = int(book)
            mi = Metadata(_('Unknown'))
            mi_field = bcol
            custcol = custom_columns_metadata_dict[mi_field]   # should be a '#label'
            if action == "empty":
                custcol['#value#'] = ''   # clear it
            elif action == "update":
                custcol['#value#'] = update_text
            else:
                return
            mi.set_user_metadata(mi_field, custcol)
            id_map[book] = mi
        #END FOR
        edit_metadata_action = self.maingui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=None)

        del id_map
        del mi
        del custom_columns_metadata_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def show_rowspy_dialog(self):
        try:
            self.rowspy_dialog.save_and_exit()
        except:
            pass

        from calibre_plugins.job_spy.rowspy_dialog import RowSpyDialog
        self.rowspy_dialog = RowSpyDialog(self.maingui,self.maingui)
        self.rowspy_dialog.setAttribute(Qt.WA_DeleteOnClose)
        self.rowspy_dialog.show()
        del RowSpyDialog
    #---------------------------------------------------------------------------------------------------------------------------------------
    def show_notesviewer_dialog(self):
        try:
            self.notesviewer_dialog.save_and_exit()
        except:
            pass

        from calibre_plugins.job_spy.notes_viewer_dialog import NotesViewerDialog
        self.notesviewer_dialog = NotesViewerDialog(self.maingui,self.maingui)
        self.notesviewer_dialog.setAttribute(Qt.WA_DeleteOnClose)
        self.notesviewer_dialog.show()
        del NotesViewerDialog
    #---------------------------------------------------------------------------------------------------------------------------------------
    def show_book_identifier_matrix(self):
        self.guidb = self.gui.library_view.model().db
        #-------------------------------------
        # get selected books
        #-------------------------------------
        self.selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Books Were Selected.'), show=True)
        elif n_books  > 10000:
            msg = "You have selected " + as_unicode(n_books) + " books.  This may take quite some time.  Do you want to continue with the current selection of books?"
            if question_dialog(self.gui, "JS+ GUI Tool - Book Identifiers Matrix", msg):
                pass
            else:
                del self.selected_books_list
                return

        if DEBUG: print("show_book_identifier_matrix:  Number of book selected: ", as_unicode(n_books))

        selected_books_set = set(self.selected_books_list)
        #-------------------------------------
        # process selected books
        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        mysql = "SELECT type FROM identifiers GROUP BY type ORDER BY type"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            my_db.close()
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Identifiers Exist in Library'), show=True)
        if len(tmp_rows) == 0:
            my_db.close()
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Identifiers Exist in Library'), show=True)

        column_assignment_dict = {}  # [type] = column number  #starting with col 3
        column_number = 3
        for row in tmp_rows:
            for col in row:
                type = col
                column_assignment_dict[type] = column_number
                column_number = column_number + 1
                break
            #END FOR
        #END FOR
        del tmp_rows

        final_column_number = column_number - 1

        book_data_dict = {}  # [bookid] = title,author_sort
        book_type_dict = {}   # [type] = val
        book_identifiers_dict = {}  # [bookid] = book_type_dict


        mysql = "SELECT books.id,books.title,books.author_sort,identifiers.type,identifiers.val \
                        FROM books,identifiers \
                        WHERE books.id = identifiers.book \
                        ORDER BY books.id,identifiers.type "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        oldid = 0
        for row in tmp_rows:
            #~ if DEBUG: print("tmp_rows: ", as_unicode(row))
            id,title,author_sort,type,val = row
            if not as_unicode(id) in selected_books_set:
                continue
            newid = id
            if newid != oldid:
                del book_type_dict
                book_type_dict = {}
            book_data_dict[id] = title,author_sort
            book_type_dict[type] = val
            book_identifiers_dict[id] = book_type_dict
            oldid = id
        #END FOR
        del tmp_rows

        #~ some books have no identifiers at all, but if selected, should still appear in the matrix listing...
        mysql = "SELECT id,title,author_sort  \
                        FROM books"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()

        my_db.close()

        del book_type_dict
        book_type_dict = {}   # [type] = "NONE"     # just for books with no identifiers whatsoever

        #~ for type,col in column_assignment_dict.iteritems():
        for type,col in iteritems(column_assignment_dict):
            book_type_dict[type] = ""   # just for books with no identifiers whatsoever
        #END FOR

        for row in tmp_rows:
            id,title,author_sort = row
            if not as_unicode(id) in selected_books_set:
                continue
            if id in book_identifiers_dict:
                continue
            book_data_dict[id] = title,author_sort            # just for books with no identifiers whatsoever
            book_identifiers_dict[id] = book_type_dict     # just for books with no identifiers whatsoever
        #END FOR
        del tmp_rows

        if DEBUG: print("BookIdentifierMatrixDialog is now being created.")

        from calibre_plugins.job_spy.book_identifier_matrix_listing_dialog import BookIdentifierMatrixDialog
        self.bookidentifiermatrix_dialog =  BookIdentifierMatrixDialog(self.maingui,column_assignment_dict,final_column_number,book_data_dict,book_identifiers_dict)
        self.bookidentifiermatrix_dialog.show()

        del BookIdentifierMatrixDialog
        del book_identifiers_dict
        del column_assignment_dict
        del book_type_dict
        del selected_books_set
        del self.selected_books_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def autorun_add_null_values(self):
        wait_seconds = 5
        self.add_null_values(wait_seconds)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def add_null_values(self,wait_seconds=1):
        if prefs['GUI_TOOLS_ADD_NULL_VALUES_ACTIVE'] == unicode_type("False"):
            return

        if self.job_is_running:
            return

        self.guidb = self.gui.library_view.model().db
        path = self.guidb.library_path
        library_name = os.path.basename(path)
        #~ if DEBUG: print("current library name: ", library_name)

        active_libraries = prefs['GUI_TOOLS_ADD_NULL_VALUES_LIBRARIES']

        #~ if DEBUG: print("Add Null Values - active_libraries: ", active_libraries)

        active_libraries = active_libraries + "|"

        actionable_libraries = []

        tmp_list = active_libraries.split("|")
        for row in tmp_list:
            if not "QuarantineAndScrub" in row:   # this GUI Tool is invalid for use with Q&S Libraries...
                lib = row.strip()
                if lib > " ":
                    actionable_libraries.append(lib)
        #END FOR
        del tmp_list

        can_continue = False
        for lib in actionable_libraries:
            #~ if DEBUG: print("actionable_libraries: ", lib)
            if lib == "*":
                can_continue = True
                break
            elif lib == library_name:
                can_continue = True
                break
            else:
                pass
        #END FOR
        if can_continue:
            pass
        else:
            del actionable_libraries
            del path
            del library_name
            return

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        mysql = "SELECT id,id FROM books"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()

        my_db.close()

        if not tmp_rows:
           return error_dialog(self.gui, _('JS+ GUI Tool'),_('No books exist in the current Calibre Library.'), show=True)
        if len(tmp_rows) == 0:
           return error_dialog(self.gui, _('JS+ GUI Tool'),_('No books exist in the current Calibre Library.'), show=True)

        try:
            del self.selected_books_list
        except:
            pass

        self.selected_books_list = []

        for row in tmp_rows:
            id,dummy = row
            self.selected_books_list.append(id)
        #END FOR
        del tmp_rows

        #~ if DEBUG: print("number of books in library: ", as_unicode(len(self.selected_books_list)) )

        start_threaded_js_add_null_values(self, self.guidb, self.selected_books_list, wait_seconds, Dispatcher(self.js_finish_with_refresh_no_marking))

        self.job_is_running = True

        msg = 'JS+ Job was submitted and is processing all books in this library...'
        self.show_gui_status_bar_qtimer(msg,5000)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def js_finish_with_refresh_no_marking(self, job):

        self.job_is_running = False

        if job.failed:
            self.force_refresh_of_cache(self.selected_books_list)
            self.gui.job_exception(job, dialog_title=_('JS+ Job Failed...'))

        self.gui.status_bar.show_message(_('JS+ Add Nulls Job Has Finished'), 5000)

        self.force_refresh_of_cache(self.selected_books_list)

        del self.selected_books_list

        self.maingui.library_view.update()

        try:
            del job
        except:
            pass
    #---------------------------------------------------------------------------------------------------------------------------------------
    def copy_user_categories(self):
        try:
            self.copy_user_categories_dialog.close()
        except:
            pass
        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        mysql = "SELECT key,val FROM preferences WHERE key = 'user_categories' "
        my_cursor.execute(mysql)
        user_cat_rows = my_cursor.fetchall()
        if not user_cat_rows:
            user_cat_rows = []
        if len(user_cat_rows) == 0:
            my_db.close()
            del user_cat_rows
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('You have no User Categories to Copy.'), show=True)
        #-------------------------------------
        mysql = "SELECT key,val FROM preferences WHERE key = 'field_metadata' "
        my_cursor.execute(mysql)
        field_metadata_rows = my_cursor.fetchall()
        my_db.close()
        if not field_metadata_rows:
            field_metadata_rows = []
        if len(field_metadata_rows) == 0:  # impossible for the Source Library (although unfortunately entirely possible for a just-created Target Library due to timing of Restarts of Calibre...)
            del user_cat_rows
            del field_metadata_rows
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('You have no Copyable User Categories until after Calibre is Restarted.'), show=True)
        #-------------------------------------
        source_field_metadata_dict = {}
        for row in field_metadata_rows:
            key,val = row    # key = 'field_metadata'
            if val:
                val = self.raw_to_object(val)    # JSON
                val = as_unicode(val)
                source_field_metadata_dict = ast.literal_eval(val)
                if isinstance(source_field_metadata_dict,dict):
                    break
                else:
                    source_field_metadata_dict = {}
                    if DEBUG: print("field metadata in table preferences are corrupt: ", val)
                    return error_dialog(self.gui, _('JS+ GUI Tool'),_('[1] Field Metadata for User Categories cannot be used.  Aborted.'), show=True)
        #END FOR
        del field_metadata_rows
        if len(source_field_metadata_dict) == 0:
            del source_field_metadata_dict
            del user_cat_rows
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('[2] Field Metadata for User Categories cannot be used.  Aborted.'), show=True)
        #-------------------------------------
        source_user_cat_dict = {}
        for row in user_cat_rows:
            key,val = row    # key = 'user_categories'
            if val:
                val = self.raw_to_object(val)    # JSON
                val = as_unicode(val)
                source_user_cat_dict = ast.literal_eval(val)
                if isinstance(source_user_cat_dict,dict):
                    break
                else:
                    source_user_cat_dict = {}
                    if DEBUG: print("user categories in table preferences are corrupt: ", val)
                    return error_dialog(self.gui, _('JS+ GUI Tool'),_('[3] Source User Categories cannot be used.  Aborted.'), show=True)
        #END FOR
        del user_cat_rows
        if len(source_user_cat_dict) == 0:
            del source_user_cat_dict
            del source_field_metadata_dict
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('You have no User Categories in this Library to Copy.'), show=True)
        #-------------------------------------
        #-------------------------------------
        self.get_all_libraries_list(include_current=False)
        #-------------------------------------
        from calibre_plugins.job_spy.copy_user_categories_dialog import CopyUserCategoriesDialog
        icon = get_icon('images/user_category.png')
        self.copy_user_categories_dialog = CopyUserCategoriesDialog(self.gui,icon,source_user_cat_dict,source_field_metadata_dict,self.target_library_list)
        self.copy_user_categories_dialog.show()
        #-------------------------------------
        #-------------------------------------
        del CopyUserCategoriesDialog
        del source_user_cat_dict
        del source_field_metadata_dict
        del self.target_library_list
        del my_db
        del my_cursor
        del is_valid
    #---------------------------------------------------------------------------------------------------------------------------------------
    def raw_to_object(self,raw):
        if not isinstance(raw, unicode_type):
            raw = raw.decode(preferred_encoding)
        try:
            val = json.loads(raw, object_hook=from_json)
        except Exception as e:
            if DEBUG: print("json.loads error: ", as_unicode(e))
            val = "ERROR"
        return val
    #---------------------------------------------------------------------------------------------------------------------------------------
    def copy_virtual_libraries_to_target(self):

        try:
            self.copy_virtual_libraries_dialog.close()
        except:
            pass
        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        mysql = "SELECT key,val FROM preferences WHERE key = 'virtual_libraries' "
        my_cursor.execute(mysql)
        virtual_library_rows = my_cursor.fetchall()
        my_db.close()
        if not virtual_library_rows:
            virtual_library_rows = []
        if len(virtual_library_rows) == 0:
            del virtual_library_rows
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('You have no Virtual Libraries to Copy.'), show=True)
        #-------------------------------------
        #-------------------------------------
        source_virtual_library_dict = {}
        for row in virtual_library_rows:
            key,val = row    # key = name of VL, and val = search terms defining the VL '
            if DEBUG: print("virtual_library_rows: ", as_unicode(key),">>>", as_unicode(val))
            if val:
                val = self.raw_to_object(val)    # JSON
                val = as_unicode(val)
                source_virtual_library_dict = ast.literal_eval(val)
                if isinstance(source_virtual_library_dict,dict):
                    break
                else:
                    source_virtual_library_dict = {}
                    if DEBUG: print("virtual libraries in table preferences are corrupt: ", val)
                    return error_dialog(self.gui, _('JS+ GUI Tool'),_('[3] Source Virtual Libraries cannot be used.  Aborted.'), show=True)
        #END FOR
        del virtual_library_rows
        if len(source_virtual_library_dict) == 0:
            del source_virtual_library_dict
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('You have no Virtual Libraries in this Library to Copy.'), show=True)
        #-------------------------------------
        #-------------------------------------
        self.get_all_libraries_list(include_current=False)
        #-------------------------------------
        from calibre_plugins.job_spy.copy_virtual_libraries_dialog import CopyVirtualLibrariesDialog
        icon = get_icon('images/search.png')
        self.copy_virtual_libraries_dialog = CopyVirtualLibrariesDialog(self.gui,icon,source_virtual_library_dict,self.target_library_list)
        self.copy_virtual_libraries_dialog.show()
        #-------------------------------------
        #-------------------------------------
        del CopyVirtualLibrariesDialog
        del source_virtual_library_dict
        del self.target_library_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_author_sort_method_by_library(self):
        #-------------------------------------
        #~ job_spy_author_sort_copy_method = {'CalibreJobSpyTest3': 'invert', 'CalibreJobSpyTest2': 'copy', 'CalibreJobSpyTest1': 'nocomma', 'CalibreJobSpyTest4': 'comma'}
        #-------------------------------------
        from calibre.utils.config_base import tweaks
        if not 'job_spy_author_sort_copy_method' in tweaks:
            del tweaks
            msg = "Error in the Tweak 'job_spy_author_sort_copy_method' in Your Preferences > Tweaks > Plugin Tweaks.<br><br><b>Activated in JS but Tweak is missing.</b><br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_author_sort_copy_method',msg).show()
        if not 'author_sort_copy_method' in tweaks:
            return
        #-------------------------------------
        orig_method = tweaks['author_sort_copy_method']
        if DEBUG: print("author_sort_copy_method >>> default tweaks.py method is: ", orig_method)
        #-------------------------------------
        jsdict = tweaks['job_spy_author_sort_copy_method']
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                msg = "Error in the Tweak 'job_spy_author_sort_copy_method' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_author_sort_copy_method',msg).show()
                return
        #-------------------------------------
        valid_methods_list = ['comma','copy','invert','nocomma']
        #-------------------------------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict:
                method = jsdict[libname]
                if method in valid_methods_list:
                    if method != orig_method:
                        tweaks['author_sort_copy_method'] = method  # in-memory only; this will not be written to tweaks.py.  The user must use Preferences > Tweaks properly to make permanent changes.
                        if DEBUG: print("author_sort_copy_method changed FROM: ",orig_method, " TO: ", method)
                    else:
                        pass
                else:
                    if DEBUG: print("apply_author_sort_method_by_library:   new method is NOT valid:   ", as_unicode(method))
            else:
                if DEBUG: print("apply_author_sort_method_by_library:   libname is NOT tweaked; nothing changed:   ", libname)
        else:
            if DEBUG: print("ERROR in os.path.split(path): ", path, " head: ", as_unicode(head), " libname: ", as_unicode(libname))
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_read_file_metadata_pref_by_library(self):
        #-------------------------------------
        #~ job_spy_add_books_read_metadata_from_file_contents_not_name = {'CalibreJobSpyTest3': 'True', 'CalibreJobSpyTest2': 'False', 'CalibreJobSpyTest1': 'True', 'CalibreJobSpyTest4': 'False'}
        #-------------------------------------
        from calibre.utils.config_base import tweaks
        if not 'job_spy_add_books_read_metadata_from_file_contents_not_name' in tweaks:
            del tweaks
            msg = "Error in the Tweak 'job_spy_add_books_read_metadata_from_file_contents_not_name' in Your Preferences > Tweaks > Plugin Tweaks.<br><br><b>Activated in JS but Tweak is missing.</b><br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_add_books_read_metadata_from_file_contents_not_name',msg).show()
        #-------------------------------------
        #-------------------------------------
        jsdict = tweaks['job_spy_add_books_read_metadata_from_file_contents_not_name']
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                msg = "Error in the Tweak 'job_spy_add_books_read_metadata_from_file_contents_not_name' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_add_books_read_metadata_from_file_contents_not_name',msg).show()
                return
        #-------------------------------------
        #-------------------------------------
        option_key = as_unicode("read_file_metadata")   # global.py does NOT default to unicode; only specific values are specified as unicode via a manual u' prefix.
        from calibre.utils.config import prefs
        orig_option = prefs.get(option_key)   # orig_option is stored in global.py as a Boolean
        orig_option = as_unicode(orig_option)
        if DEBUG: print("orig_option = prefs.get[option_key]: ", orig_option)
        #-------------------------------------
        #-------------------------------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if DEBUG: print("Tweak Library Name: ", libname)
            if libname in jsdict:
                option = jsdict[libname]
            else:
                option = as_unicode("True")  # Defaults to True if a Library was not specified in the Tweak...
            option = as_unicode(option)
            if option == as_unicode("True") or option == as_unicode("False"):
                if option == as_unicode("True"):
                    option = True
                else:
                    option = False
                try:
                    prefs.set(option_key, option)  # this writes to global.py
                    if DEBUG: print("'read_file_metadata' global.py file prefs.set  FROM: ", orig_option, " TO: ", option)
                except Exception as e:
                    if DEBUG: print("[1] setting option caused Exception: ", as_unicode(e))
                    return
                try:
                    prefs[option_key] = option  # in-memory only
                    current_option = prefs[option_key]
                    if DEBUG: print("'read_file_metadata' global prefs[option_key] value changed FROM: ", as_unicode(orig_option), " TO: ", as_unicode(current_option))
                except Exception as e:
                    if DEBUG: print("[2] setting option caused Exception: ", as_unicode(e))
                    return
                try:
                    if self.maingui._spare_pool is not None:
                        if DEBUG: print("executing:  self.maingui._spare_pool.shutdown(wait_time=60.0)")
                        self.maingui._spare_pool.shutdown(wait_time=60.0)  #necessary since otherwise the first books added will use the last Library's Tweak due to the way 'common_data' in Pool.set_common_data() is handled.
                        self.maingui._spare_pool = None        # forces a new pool to get created...
                        if DEBUG: print("Successful; forced the upcoming new pool to reload global preference 'read_file_metadata' just tweaked here per-Library...")
                    return
                except Exception as e:
                    self.maingui._spare_pool = None        # forces a new pool to get created...
                    if DEBUG: print("[3] setting option caused Exception: ", as_unicode(e))
                    return
            else:
                if DEBUG: print("apply_read_file_metadata_pref_by_library:   new option is NOT valid (True or False):   ", as_unicode(option))
                return
        else:
            if DEBUG: print("ERROR in os.path.split(path): ", path, " head: ", as_unicode(head), " libname: ", as_unicode(libname))
            return
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_auto_add_directory_by_library(self,source="initialization_complete"):
        # IMPORTANT: the auto_adder is created in gui2.ui AFTER all GUI plugins have been loaded, so at Calibre Startup there will be NO self.maingui.auto_adder available here (yet), so some things may only be done LATER than at initialization_complete...
        if source == "initialization_complete":
            is_startup = True
        else:
            is_startup = False

        from calibre.utils.config_base import tweaks
        if not 'job_spy_auto_add_directory' in tweaks:
            del tweaks
            msg = "Error in the Tweak 'job_spy_auto_add_directory' in Your Preferences > Tweaks > Plugin Tweaks.<br><br><b>Activated in JS but Tweak is missing.</b><br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_auto_add_directory',msg).show()

        global_path = gprefs['auto_add_path']
        if DEBUG: print("original gprefs['auto_add_path'] global_path default: ", global_path)
        if not global_path:
            return
        global_path = self.standardize_path_format(global_path)
        if not os.path.isdir(global_path):
            return

        if is_startup:
            self.original_global_auto_add_path = global_path   # just validated as a good directory and can be trusted...
            if DEBUG: print("self.original_global_auto_add_path: ",  self.original_global_auto_add_path)
        #-------------------------------------
        # JS can be customized without restarting, so the user might have just changed the default directory to another value and then immediately switched libraries.
        self.default_tweak_auto_add_directory_path = prefs['GUI_TOOLS_DEFAULT_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY']
        self.default_tweak_auto_add_directory_path = self.standardize_path_format(self.default_tweak_auto_add_directory_path)
        #~ self.default_tweak_auto_add_directory_path = "xxxx"  #testing;force an error
        if not os.path.isdir(self.default_tweak_auto_add_directory_path):   #not frequent, since config.py validates before saving prefs, but it could have just been renamed or deleted.
            if DEBUG: print("ERROR: Invalid Directory: self.default_tweak_auto_add_directory_path: ",  self.default_tweak_auto_add_directory_path)
            self.default_tweak_auto_add_directory_path = self.original_global_auto_add_path
            prefs['GUI_TOOLS_DEFAULT_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY'] = self.original_global_auto_add_path
            prefs
            msg = "Error in the Tweak to Auto-Adding: your Default Directory by Library was invalid.<br><br>You should Customize Job Spy preferences for this GUI Tool before proceeding."
            info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_auto_add_directory by Library',msg).show()      #non-modal so does not stop Calibre startup or library switching
            if DEBUG: print(msg)
            return
        #-------------------------------------
        #-------------------------------------
        jsdict = tweaks['job_spy_auto_add_directory']
        if DEBUG: print("jsdict = tweaks['job_spy_auto_add_directory'] ", as_unicode(jsdict))  # {u'CalibreJobSpyTest5': u'x:/auto_add_dir5', u'CalibreJobSpyTest4': u'x:/auto_add_dir4', u'CalibreJobSpyTest1': u
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                msg = "Error in the Tweak to Auto-Adding: Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_auto_add_directory by Library',msg).show()     #non-modal so does not stop Calibre startup or library switching
                return
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        if DEBUG: print("library path: ", path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict:
                path = jsdict[libname]
                path = self.standardize_path_format(path)
                if DEBUG: print("new auto-add path: ", path)
                if os.path.isdir(path):
                    pass
                else:
                    msg = "Error in the Tweak to Auto-Adding: Your Preferences > Tweaks > Plugin Tweaks value for this specific Library is invalid.  <b>The specified directory does not exist.</b><br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                    info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_auto_add_directory by Library',msg).show()     #non-modal so does not stop Calibre startup or library switching
                    return
            else:
                if DEBUG: print("library not in JS dictionary: ", libname)
                path = self.default_tweak_auto_add_directory_path
        else:
            if DEBUG: print("library not valid: ", libname)
            path = self.default_tweak_auto_add_directory_path

        ospath = path.replace("/",os.sep)   # gui.json stores the global default for windows like:    "auto_add_path": "S:\\Calibre\\ToBeImported",

        if DEBUG: print("new os path to be watched by auto_adder: ",ospath)

        #~ note:        per src/calibre/gui2/ui.py     self.auto_adder = AutoAdder(gprefs['auto_add_path'], self)    where in gui.json:   "auto_add_path": "S:\\Calibre\\ToBeImported",

        if not is_startup:
            dirlist = self.maingui.auto_adder.watcher.directories()
            if DEBUG:
                for dir in dirlist:
                    if DEBUG: print("=========[A] QFileSystemWatcher:  dir in dirlist: ", dir)
                #END FOR

        gprefs['auto_add_path'] = ospath   # which means that the gui.json value will be updated at shutdown with this preference...unless another library is changed-to before then...

        if not is_startup:
            if not ospath in dirlist:
                self.maingui.auto_adder.watcher.addPath(ospath)
            self.remove_old_auto_add_watcher_directories(ospath)
            if DEBUG: print("old auto_adder.worker: ", as_unicode(self.maingui.auto_adder.worker))
            #~ if DEBUG:
                #~ for k,v in iteritems(self.maingui.auto_adder.worker.__dict__):
                    #~ print("======== OLD self.maingui.auto_adder.worker attribute: ", as_unicode(k), ">>", as_unicode(v))
                #~ print("------------------------------------------------------")
            self.maingui.auto_adder.worker.keep_running = False
            self.maingui.auto_adder.worker._stop()
            if DEBUG: print("[py3]====== after work stopped")
            from calibre.gui2.auto_add import Worker
            self.maingui.auto_adder.worker = Worker(ospath, self.maingui.auto_adder.metadata_read.emit)
            if DEBUG: print("============= new auto_adder.worker: ", as_unicode(self.maingui.auto_adder.worker))
            self.maingui.auto_adder.worker.keep_running = True
            self.maingui.auto_adder.dir_changed()
            self.maingui.auto_adder.worker.auto_add()
            #~ if DEBUG:
                #~ for k,v in iteritems(self.maingui.auto_adder.worker.__dict__):
                    #~ print("======== NEW self.maingui.auto_adder.worker attribute: ", as_unicode(k), ">>", as_unicode(v))
                #~ print("------------------------------------------------------")

        if DEBUG:
            if not is_startup:
                dirlist = self.maingui.auto_adder.watcher.directories()
                for dir in dirlist:
                    if DEBUG: print("========[B] QFileSystemWatcher:  dir in dirlist: ", dir)

        if DEBUG:
            if is_startup:
                print("[Calibre Startup] The per-Library tweak for the Current Library for auto_add_path has been changed to:  ", ospath)
            else:
                print("[Calibre Library Switched] The per-Library tweak for the Current Library for auto_add_path has been changed to:  ", ospath)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def remove_old_auto_add_watcher_directories(self,ospath):
        try:
            dirlist = self.maingui.auto_adder.watcher.directories()
            for dir in dirlist:
                if dir != ospath:  #keep the current tweak auto-add dir
                    self.maingui.auto_adder.watcher.removePath(dir)   #although it was lots of fun, having more than a single path being watched at a single moment is not desirable.
                    if DEBUG: print("dir was removed: ", dir)
                else:
                    if DEBUG: print("dir NOT removed: ", dir)
            #END FOR
        except Exception as e:
            if DEBUG: print("Exception for QFileSystemWatcher in remove_auto_add_watcher_directories: ", as_unicode(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    def standardize_path_format(self,path):
        path = path.replace('"','')  #no double quotes as used in windows
        path = path.strip()
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        if path.endswith("/"):
            path = path[0:-1]
            path = path.strip()
        return path
    #---------------------------------------------------------------------------------------------------------------------------------------
    def convert_string_to_dict(self,sdict):
        sdict = as_unicode(sdict)
        try:
            d = ast.literal_eval(sdict)
            del sdict
            if not isinstance(d,dict):
                if DEBUG: print("[1] tweaks['job_spy_XXX'] is not formatted properly as a valid dictionary.")
                return d,False
            else:
               return d,True
        except:
            if DEBUG: print("[2] tweaks['job_spy_XXX'] is not formatted properly as a valid dictionary.")
            return d,False
    #---------------------------------------------------------------------------------------------------------------------------------------
    def convert_string_to_list(self,slist):
        slist = as_unicode(slist)
        try:
            lst = ast.literal_eval(slist)
            del slist
            if not isinstance(lst,list):
                if DEBUG: print("[1] tweaks['job_spy_XXX'] is not formatted properly as a valid list.")
                return lst,False
            else:
               return lst,True
        except:
            if DEBUG: print("[2] tweaks['job_spy_XXX'] is not formatted properly as a valid list.")
            return lst,False
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def display_polish_books_job_log_fails(self):

        jmgr = self.maingui.job_manager

        done_jobs_list = [j for j in jmgr.jobs if (j.is_finished and not j.failed)]

        n_done_jobs = len(done_jobs_list)

        if n_done_jobs == 0:
            del done_jobs_list
            del jmgr
            del n_done_jobs
            return

        failed_fonts_set = set()
        failed_titles_set = set()
        found_failure = False

        for j in done_jobs_list:
            desc = j.description
            if "Polish" in desc:
                if j.log_path:
                    f = open(j.log_path, 'rb')
                    found_failure = False
                    for line in f:
                        line = as_bytes(line)
                        line =  line.decode('utf-8', 'replace')
                        if "Failed to find fonts for family" in line:
                            found_failure = True
                            line = line.replace("Failed to find fonts for family:","")
                            line = line.replace(", not embedding","")
                            failed_fonts_set.add(line.strip())
                    #END FOR
                    f.close()
                    del f
                    if found_failure:
                        n = desc.find("(")
                        if n < 1:
                            continue
                        desc = desc[n+1:-1]
                        failed_titles_set.add(desc)
        #END FOR

        titles_were_limited = False  #the search function will blow out due to python recursion errors if the search string is too long...
        NLIMIT = 199
        n = len(failed_titles_set)
        if n > 0:
            ssearch = ""
            n_limit = 0
            for title in failed_titles_set:
                ssearch = ssearch + 'title:"XXX" OR '
                ssearch = ssearch.replace("XXX",title)
                n_limit = n_limit + 1
                if n_limit > NLIMIT:
                    titles_were_limited = True
                    break
            #END FOR
            ssearch = ssearch[0:-3]
            ssearch = ssearch.strip()
            self.gui.search.clear()
            self.gui.search.set_search_string(ssearch)
            del ssearch
            del n_limit

        #~ if DEBUG: titles_were_limited = True

        msg = "Total Failed Titles: " + as_unicode(n) + "<br><br>"
        if titles_were_limited:
            msg = msg + "Search criteria limited to first 200 titles to avoid potential Calibre search errors.<br><br>"

        failed_fonts_list = list(failed_fonts_set)
        failed_fonts_list.sort()

        n = len(failed_fonts_list)
        if n > 1:
            msg = msg + "Failed to find fonts for families: <br><br>"
        else:
            msg = msg + "Failed to find fonts for family: <br><br>"

        for failure in failed_fonts_list:
            msg = msg + failure + "<br>"
        #END FOR

        if len(failed_fonts_set) > 0:
            info_dialog(self.gui, 'JS+ GUI Tool: Polishing-Missing Fonts',msg).show()

        try:
            del done_jobs_list
            del jmgr
            del n_done_jobs
            del desc
            del failed_fonts_list
            del failed_fonts_set
            del failed_titles_set
            del msg
            del found_failure
            del NLIMIT
        except:
            pass
    #---------------------------------------------------------------------------------------------------------------------------------------
    def show_formatspy_dialog(self):
        try:
            self.formatspy_dialog.close()
        except:
            pass

        from calibre_plugins.job_spy.formatspy_dialog import FormatSpyDialog
        self.formatspy_dialog = FormatSpyDialog(self.maingui,self.maingui)
        self.formatspy_dialog.show()
        del FormatSpyDialog
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_author_sort_for_complex_surnames_menu(self):
        self.update_author_sort_for_complex_surnames(True,False)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_author_sort_for_complex_surnames(self,confirm,ids):

        if not isinstance(ids,list):
            if confirm:
                self.selected_books_list = self.get_selected_books()  # ids are a string here...
                tids = self.selected_books_list
                if len(tids) == 0:
                    msg = "No Books Were Selected."
                    return error_dialog(self.gui, _('JS+ GUI Tool'),_(msg), show=True)
                else:
                    del ids
                    ids = []
                    for id in tids:
                        id = int(id)
                        ids.append(id)
                    if DEBUG: print("number of manually selected books for complex surnames: ", as_unicode(len(tids)))

        self.gui.library_view.model().refresh_ids(ids)
        self.gui.tags_view.recount()

        from calibre.utils.config_base import tweaks
        #-------------------------------------
        self.author_sort_copy_method = tweaks['author_sort_copy_method']
        if self.author_sort_copy_method == "copy":          #~ copy  : copy author to author_sort without modification
            msg = "Error: The current 'author_sort_copy_method' standard Calibre tweak is 'copy'.  Nothing needs to be done by this function.  Terminated."
            if confirm:
                return error_dialog(self.gui, _('JS+ GUI Tool'),_(msg), show=True)
            else:
                if DEBUG: print(msg)
                return
        #-------------------------------------
        if confirm:
            msg = "This Tool only has value if you are using a 'author_sort_copy_method' of 'invert', 'comma' or 'nocomma'.  "
            msg = msg + "<br><br>Methods:<br>[*] invert: use 'fn ln' -> 'ln, fn' "
            msg = msg + "<br>[*] comma : use 'copy' if there is a ',' in the name, otherwise use 'invert'.  'copy' means copy the author to author_sort without modification "
            msg = msg + "<br>[*] nocomma : 'fn ln' -> 'ln fn'(without the comma) "
            msg = msg + "<br><br>The current Author Sort Copy Method in Tweaks is:   " + self.author_sort_copy_method
            msg = msg + "<br><br>Authors themselves have an Author Sort, but each individual book also has a 'combined' Author Sort for all of its Authors. Different Calibre tools may update different locations for 'Author Sort'."
            msg = msg + "<br><br>To reset each Author's individal Author Sort to 'Standard Calibre' values, simply use 'Manage Author' to 'Recalculate All Author Sort Values'.  Then, use 'Bulk Edit Metadata-Set Author Sort' to update each book's individual combined Author Sort to the newly recalculated standard values. "
            msg = msg + "<br><br>Do you wish to continue?"
            if question_dialog(self.gui, "JS+ GUI Tool: Update Author Sort for Complex Surnames", msg):
                pass
            else:
                return
        #-------------------------------------
        self.complex_surname_dict = {}
        self.original_surname_dict = {}
        self.original_to_complex_surname_dict = {}
        #-------------------------------------
        self.surname_ignore_set = set()
        s = prefs['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_IGNORE']
        s_split = s.split("|")
        for row in s_split:
            row = row.strip()
            self.surname_ignore_set.add(row)
        #END FOR
        del s
        del row
        del s_split
        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        my_db.createscalarfunction("MYAUTHORSORT",self.myauthorsortregexp)
        #-------------------------------------
        self.create_temp_book_ids_table(my_db,my_cursor,ids)
        #-------------------------------------
        try:
            my_cursor.execute("begin")
            mysql = "UPDATE authors SET sort = MYAUTHORSORT(name,sort) \
                          WHERE id IN (SELECT author FROM books_authors_link WHERE author = authors.id AND book IN (SELECT book FROM _js_book_ids_temp) )"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            try:
                my_cursor.execute("commit")
            except:
                pass
        #-------------------------------------
        # All Single Authors (and the sole Author is in the Path)
        #-------------------------------------
        try:
            my_cursor.execute("begin")
            mysql = "UPDATE books SET author_sort = ? WHERE path LIKE ?  AND author_sort NOT LIKE '%&%' \
                           AND id IN (SELECT book FROM _js_book_ids_temp)"  # only single author scenarios
            #~ for name,newsort in self.complex_surname_dict.iteritems():    # only has names that matched the REGEX in MYAUTHORSORT
            for name,newsort in iteritems(self.complex_surname_dict):    # only has names that matched the REGEX in MYAUTHORSORT
                path = name + "/%"
                my_cursor.execute(mysql,(newsort,path))
                if DEBUG: print("[1] books: ", newsort, ">>>>", path)
            #END FOR
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            try:
                my_cursor.execute("commit")
            except:
                pass
        #-------------------------------------
        #~ for name,oldsort in self.original_surname_dict.iteritems():
        for name,oldsort in iteritems(self.original_surname_dict):
            if name in self.complex_surname_dict:        # only has names that matched the REGEX in MYAUTHORSORT
                newsort = self.complex_surname_dict[name]
                self.original_to_complex_surname_dict[oldsort] = newsort
            else:
                if DEBUG: print("Error: name not in self.original_surname_dict: ", name, "    ", oldsort)
        #END FOR
        #-------------------------------------
        # All Multiple Authors
        #-------------------------------------
        try:
            mysql = "UPDATE books SET author_sort = REPLACE(author_sort,?,?) WHERE author_sort LIKE '%&%' \
                           AND id IN (SELECT book FROM _js_book_ids_temp)"  # only multiple author scenarios
            #~ for oldsort,newsort in self.original_to_complex_surname_dict.iteritems():
            for oldsort,newsort in iteritems(self.original_to_complex_surname_dict):
                my_cursor.execute("begin")
                my_cursor.execute(mysql,(oldsort,newsort))
                my_cursor.execute("commit")
                if DEBUG: print("[2] books: ", oldsort, ">>>>", newsort)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))
        #-------------------------------------
        tmp_dict = {}  #id = author_sort
        mysql = "SELECT id,author_sort FROM books WHERE id IN (SELECT book FROM _js_book_ids_temp)"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            id,author_sort = row
            tmp_dict[id] = author_sort
        #END FOR
        #-------------------------------------
        my_db.close()
        #-------------------------------------
        self.gui.library_view.model().refresh_ids(ids)
        #-------------------------------------
        #~ This next is so that the metadata.db = cache = library_view without having to restart...
        payload = []
        id_map = {}
        for id in ids:
            id = int(id)
            payload.append(id)
            mi = Metadata(_('Unknown'))
            mi.author_sort = tmp_dict[id]
            id_map[id] = mi
        #END FOR

        edit_metadata_action = self.maingui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=self.apply_complex_surname_refresh_ids_callback)

        try:
            del self.complex_surname_dict
            del self.original_surname_dict
            del self.original_to_complex_surname_dict
            del self.surname_ignore_set
            del tmp_dict
            #~ del ids
        except:
            pass
    #---------------------------------------------------------------------------------------------------------------------------------------
    def myauthorsortregexp(self,name,sort):
        #~ self.author_sort_copy_method
        #~ invert: use "fn ln" -> "ln, fn"
        #~ comma : use 'copy' if there is a ',' in the name, otherwise use 'invert'
        #~ nocomma : "fn ln" -> "ln fn" (without the comma)

        expr = prefs['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_REGEXP']
        try:
            p = re.compile(expr,  re.IGNORECASE|re.DOTALL|re.MULTILINE)
            match = p.search(name)
            if not match:
                return sort
            else:
                lastnames = match.group()
                lastnames = lastnames.strip()
                s_split = lastnames.split(" ")
                for n in s_split:
                    n = n.strip()
                    if n in self.surname_ignore_set:
                        if DEBUG: print("Middle Name Ignored: ", n, "  so nothing done.")
                        return sort
                #END FOR
                if DEBUG: print("Before: ", name,"       ", sort)
                self.original_surname_dict[name] = sort
                firstnames = name.replace(lastnames,"")
                firstnames = firstnames.strip()
                if self.author_sort_copy_method == "invert":
                    sort = lastnames + ", " + firstnames
                elif self.author_sort_copy_method == "comma":
                    if "," in name:
                        sort = name
                    else:
                        sort = lastnames + ", " + firstnames
                elif self.author_sort_copy_method == "nocomma":
                    sort = lastnames + " " + firstnames
                else:
                    return sort
                sort = sort.strip()
                if DEBUG: print("After: ", name,"       ", sort)
                self.complex_surname_dict[name] = sort
                return sort
        except Exception as e:
            if DEBUG: print(" myauthorsortregexp exception: ", as_unicode(e))
            return sort
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_complex_surname_refresh_ids_callback(self,payload):
        if DEBUG: print("Payload count for complex surnames callback: ", as_unicode(len(payload)))
        self.gui.library_view.model().refresh_ids(payload)
        self.gui.tags_view.recount()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_temp_book_ids_table(self,my_db,my_cursor,ids):

        mysql = "CREATE TEMP TABLE _js_book_ids_temp \
                                (id INTEGER PRIMARY KEY AUTOINCREMENT, \
                                book INTEGER NOT NULL, \
                                UNIQUE(book) );"

        my_cursor.execute(mysql)

        mysql = "INSERT OR IGNORE INTO _js_book_ids_temp (id,book) VALUES (null,?) "
        my_cursor.execute("begin")
        for id in ids:
            my_cursor.execute(mysql,([id]))
            #~ if DEBUG: print("book id added to _js_book_ids_temp: ", as_unicode(id))
        #END FOR
        my_cursor.execute("commit")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def manually_invoke_quality_fixes(self):
        self.apply_quality_fixes('manually')
    #---------------------------------------------------------------------------------------------------------------------------------------
    def initialize_quality_fixes(self):
        QTimer.singleShot(500, self.activate_quality_fixes)                 # milliseconds
    #---------------------------------------------------------------------------------------------------------------------------------------
    def activate_quality_fixes(self):

        self.use_english_titlecasing = False
        from calibre_plugins.job_spy.titlecase import titlecase
        self.titlecase = titlecase
        if prefs['GUI_TOOLS_QUALITY_FIXES_TITLECASE_TITLES_ADVANCED'] == unicode_type("True"):
            self.use_english_titlecasing = True

        try:
            from calibre_plugins.job_spy.decorated_functions import decorated_do_add
            self.maingui.auto_adder.do_add = decorated_do_add(self.maingui.auto_adder.do_add,self.apply_quality_fixes)
            fmt = "%Y-%m-%d %H:%M:%S     "
            self.quality_fixes_checkpoint_time = as_unicode(time.strftime(fmt,time.gmtime(time.time())))   #~ 2018-03-10 13:06:26
            self.quality_fixes_checkpoint_time = self.quality_fixes_checkpoint_time[0:19]
            if DEBUG: print("Job Spy: Quality Fixes have been activated as of: ",self.quality_fixes_checkpoint_time)
            self.quality_fix_original_titles_dict = {}  # id = original title
        except Exception as e:
            QTimer.singleShot(10, self.activate_quality_fixes)                 # milliseconds
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fixes(self,source='auto_adder'):

        if source == "auto_adder":
            self.apply_quality_fixes_source_is_auto_adder = True
        else:
            self.apply_quality_fixes_source_is_auto_adder = False

        if prefs['GUI_TOOLS_QUALITY_FIXES_ACTIVATE'] == unicode_type("False"):  # user must have just updated preferences to deactivate it just before an actual auto-add action...
            return

        self.guidb = self.gui.library_view.model().db
        path = self.guidb.library_path
        path = path.replace(os.sep, '/')
        current_libname = self.decompose_library_path(path)

        libs = prefs['GUI_TOOLS_QUALITY_FIXES_ACTIVATE_LIBRARIES']
        libs = libs + "|"
        libs_list = libs.split("|")

        if "*" in libs_list:
            if DEBUG: print("wildcard specified in job spy quality fix active library names, which includes: ", current_libname)
        else:
            if not current_libname in libs_list:
                if DEBUG: print("current library not specified in job spy quality fix active library names...", current_libname)
                return
            else:
                if DEBUG: print("job spy quality fix active library names includes: ", current_libname)

        self.quality_fixes_checkpoint_time_previous = self.quality_fixes_checkpoint_time
        fmt = "%Y-%m-%d %H:%M:%S     "
        self.quality_fixes_checkpoint_time = as_unicode(time.strftime(fmt,time.gmtime(time.time())))   #~ 2018-03-10 13:06:26
        self.quality_fixes_checkpoint_time = self.quality_fixes_checkpoint_time[0:19]

        if not self.apply_quality_fixes_source_is_auto_adder:
            tids = self.get_selected_books()
            if len(tids) == 0:
                 return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Books Were Selected.'), show=True)
            ids = []
            for id in tids:
                id = int(id)
                ids.append(id)
            #END FOR
            ids.sort()
            del tids
            self.quality_fixes_checkpoint_time =  "0000-01-01 00:00:00"   #not used for manual fixes
            self.quality_fixes_checkpoint_time_previous = self.quality_fixes_checkpoint_time
        else:
            tids = self.retrieve_recently_added_books()
            if len(tids) == 0:
                return
            ids = []
            for id in tids:
                if not id in self.qf_ids_previous:
                    ids.append(id)
                    self.qf_ids_previous.append(id)
                else:
                    if DEBUG: print("already fixed book id: ", as_unicode(id), " from a previous auto-add event using the identical checkpoint time...")
            #END FOR
            del tids

        if len(ids) == 0:
            return

        self.quality_fix_current_ids = ids

        if not self.apply_quality_fixes_source_is_auto_adder:
            msg = "Job Spy is fixing " + as_unicode(len(ids)) + " manually selected books; wait..."
        else:
            msg = "Job Spy is fixing " + as_unicode(len(ids)) + " newly auto-added books; wait..."
        self.show_gui_status_bar_qtimer(msg,5000)
        if DEBUG: print(msg)

        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES'] == unicode_type("True"):
            self.update_original_title_custom_column(ids)
            self.update_original_series_custom_column(ids)

        if prefs['GUI_TOOLS_QUALITY_FIXES_CLEAR_PUBLISHERS'] == unicode_type("True"):
            self.apply_quality_fix_publishers(ids)

        if prefs['GUI_TOOLS_QUALITY_FIXES_CLEAR_TAGS'] == unicode_type("True"):
            self.apply_quality_fix_tags(ids)

        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES'] == unicode_type("True"):
            self.apply_quality_fixes_scrub_titles(ids)

        if prefs['GUI_TOOLS_QUALITY_FIXES_TITLECASE_TITLES'] == unicode_type("True"):
            self.apply_quality_fix_titlecase_titles(ids)
            self.apply_quality_fix_titlecase_series(ids)

        if prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_TITLE_SORTS'] == unicode_type("True"):
            my_db,my_cursor,is_valid = self.apsw_connect_to_library()
            if is_valid:
                self.apply_quality_fix_update_title_sorts(my_db,my_cursor,ids)
                my_db.close()
            else:
                if DEBUG: print("JS+ APSW connection error for updating title sorts...")

        also_do_author_sorts = False

        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS'] == unicode_type("True"):
            self.update_original_authors_custom_column(ids)

        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS'] == unicode_type("True"):  #part 1 of 2
            self.remove_title_from_authors(ids)
            also_do_author_sorts = True

        if prefs['GUI_TOOLS_QUALITY_FIXES_CHANGE_AUTHORS_FNLN'] == unicode_type("True"):
            self.apply_quality_fix_swap_author_names(ids,"FNLN")
            also_do_author_sorts = True
        elif prefs['GUI_TOOLS_QUALITY_FIXES_CHANGE_AUTHORS_LNFN'] == unicode_type("True"):
            self.apply_quality_fix_swap_author_names(ids,"LNFN")
            also_do_author_sorts = True

        if prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_INITIALS'] == unicode_type("True"):
            self.apply_quality_fix_update_author_initials(ids)
            also_do_author_sorts = True

        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS'] == unicode_type("True"):  #part 2 of 2
            self.remove_title_from_authors(ids)
            self.remove_series_from_authors(ids)
            self.swap_author_and_title_if_needed(ids)
            also_do_author_sorts = True

        if also_do_author_sorts or prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_SORTS'] == unicode_type("True"):
            my_db,my_cursor,is_valid = self.apsw_connect_to_library()
            if is_valid:
                self.apply_quality_fix_update_author_sorts(my_db,my_cursor,ids)
                my_db.close()
            else:
                if DEBUG: print("JS+ APSW connection error for updating author sorts...")

        if prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_PSEUDONYMS'] == unicode_type("True"):
            self.update_author_pseudonyms(ids,source='auto')

        self.apply_default_values_auto_add(ids)

        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_ISBN'] == unicode_type("True"):
            msg = "JS is scrubbing the ISBN of every book in the current Library that needs it; wait..."
            self.show_gui_status_bar_qtimer(msg,5000)
            self.scrub_isbn()

        self.quality_fix_current_ids = ids

        self.apply_quality_fix_refresh_ids()
        self.gui.tags_view.recount()

        QApplication.instance().processEvents()

        if len(ids) < 10:
            msg = "Job Spy has fixed the quality of " + as_unicode(len(ids)) + " book(s), but refreshing the displayed metadata may take a second"
        elif len(ids) < 50:
            msg = "Job Spy has fixed the quality of " + as_unicode(len(ids)) + " books, but refreshing their displayed metadata may take a few seconds"
        elif len(ids) < 200:
            msg = "Job Spy has fixed the quality of " + as_unicode(len(ids)) + " books, but refreshing their displayed metadata may take half a minute"
        elif len(ids) < 500:
            msg = "Job Spy has fixed the quality of " + as_unicode(len(ids)) + " books, but refreshing their displayed metadata may take a minute or so"
        else:
            msg = "Job Spy has fixed the quality of " + as_unicode(len(ids)) + " books, but refreshing their displayed metadata may take a minute or longer"
        self.show_gui_status_bar_qtimer(msg,5000)
        if DEBUG: print(msg)

        self.apply_quality_fix_refresh_ids()
        self.gui.tags_view.recount()

        for id in ids:
            if id in self.quality_fix_original_titles_dict:
                del self.quality_fix_original_titles_dict[id]
        #END FOR

        run_jobs = False

        if prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_EXTRACT_ISBN_JOB'] == unicode_type("True"):
            run_jobs = True

        if prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_POLISH_BOOKS_JOB'] == unicode_type("True"):
            run_jobs = True

        if prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_RESIZE_COVER_PLUGIN'] == unicode_type("True"):
            run_jobs = True

        if run_jobs:
            self.gui.current_db.set_marked_ids(ids)
            self.gui.search.set_search_string('marked:true')
            self.gui.esc()
            self.gui.library_view.select_rows(ids)
            if prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_EXTRACT_ISBN_JOB'] == unicode_type("True"):
                try:
                    extract_isbn_action = self.maingui.iactions['Extract ISBN']
                    QTimer.singleShot(0, extract_isbn_action.scan_for_isbns())
                except:
                    pass
            if prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_POLISH_BOOKS_JOB'] == unicode_type("True"):
                try:
                    polish_books_action = self.maingui.iactions['Polish Books']
                    QTimer.singleShot(0, polish_books_action.polish_books())
                except:
                    pass
            if prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_RESIZE_COVER_PLUGIN'] == unicode_type("True"):
                try:
                    resize_cover_action = self.maingui.iactions['Resize Cover']
                    resize_cover_action.resize_covers(None,None)
                    msg = "Resize Cover Plug-in Executed Using Customized ToolBar Defaults"
                    #~ self.show_gui_status_bar_qtimer(msg,5000)
                    if DEBUG: print(msg)
                except Exception as e:
                    if DEBUG: print("Exception executing Resize Covers plug-in: ", as_unicode(e))
                    msg = "Error executing Resize Covers plug-in " + as_unicode(e)
                    self.show_gui_status_bar_qtimer(msg,5000)


        QApplication.instance().processEvents()


        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_publishers(self,ids):
        for id in ids:
            self.guidb.set_publisher(id, None, notify=False)
            #~ if DEBUG: print("publisher cleared for book id: ", as_unicode(id))
        #END FOR
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_tags(self,ids):
        for id in ids:
            self.guidb.set_tags(id, None, notify=False)
            #~ if DEBUG: print("tags cleared for book id: ", as_unicode(id))
        #END FOR
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fixes_scrub_titles(self,ids):
        self.apply_quality_fix_scrub_titles_ignore_book(ids)
        self.apply_quality_fix_titles_regex_delete(ids)
        self.apply_quality_fix_titles_series_regex_control(ids)
        self.apply_quality_fix_titles_residual_artifacts_final(ids)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_scrub_titles_ignore_book(self,ids):
        apply_quality_fix_scrub_titles_ignore_books_list = []

        if RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_IGNORE_BOOK'] =  prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_IGNORE_BOOK']
            prefs

        r = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_IGNORE_BOOK']
        for id in ids:
            title = self.guidb.title(id, index_is_id=True)
            if not title:
                continue
            try:
                p = re.compile(r,re.IGNORECASE|re.MULTILINE|re.DOTALL)
            except Exception as e:
                if DEBUG: print("RE COMPILE ERROR IN apply_quality_fix_scrub_titles_ignore_book for book id:", as_unicode(id), "       ", as_unicode(e))
                continue
            try:
                match_r = p.search(title)
                if not match_r:
                    continue
                else:
                    apply_quality_fix_scrub_titles_ignore_books_list.append(id)
            except Exception as e:
                if DEBUG: print("RE p.search(title) Error in apply_quality_fix_scrub_titles_ignore_book for book id:", as_unicode(id), "       ", as_unicode(e), "  title: ", title)
        #END FOR
        self.apply_quality_fix_scrub_titles_ignore_books_set = set(apply_quality_fix_scrub_titles_ignore_books_list)  #*much* faster lookups
        del apply_quality_fix_scrub_titles_ignore_books_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_regex_delete(self,ids):

        if RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE'] = prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE']
            prefs

        r = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE']

        for id in ids:
            if id in self.apply_quality_fix_scrub_titles_ignore_books_set:
                continue
            newtitle = self.apply_quality_fix_titles_words_delete_apply_regex(id,r)
            self.guidb.set_title(id, newtitle, notify=True)
        #END FOR
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_words_delete_apply_regex(self,id,r):

        title = self.guidb.title(id, index_is_id=True)

        authors = self.guidb.authors(id, index_is_id=True)
        if isinstance(authors,list):
            author.sort()
        else:
            authors_list = []
            authors_list.append(authors)

        for a in authors_list:
            title = title.replace(a,"").strip()
            if "," in a:
                s_split = a.split(",")
                s = s_split[0].strip()
                title = title.replace(a,"").strip()
                a = self.swap_name_to_fnln(a)  # John Smith
                title = title.replace(a,"").strip()
            else:
                a = self.swap_name_to_lnfn(a)  # Smith, John
                title = title.replace(a,"").strip()
                s_split = a.split(",")
                s = s_split[0].strip()
                title = title.replace(a,"").strip()
        #END FOR
        del authors_list

        match_r = None

        try:
            p = re.compile(r,re.IGNORECASE|re.MULTILINE|re.DOTALL)
            match_r = p.search(title)
            if not match_r:
                pass
        except Exception as e:
            if DEBUG: print("RE COMPILE ERROR IN apply_quality_fix_titles_words_delete_apply_regex for book id:", as_unicode(id), "       ", as_unicode(e))

        r = r + "|"
        r_list = r.split("|")

        new_title = title

        for r in r_list:
            r = r.strip()
            if not r > " ":
                continue
            try:
                p = re.compile(r,re.IGNORECASE|re.MULTILINE|re.DOTALL)
            except Exception as e:
                if DEBUG: print("re.compile error: ", r, "   ", as_unicode(e))
                continue
            match_r = p.search(new_title)
            if not match_r:
                continue
            else:
                bad_string = match_r.group()
                if DEBUG: print("words to delete from title:  ", bad_string)
                new_title = new_title.replace(bad_string,"").strip()
        #END FOR
        del r_list
        del match_r

        new_title = new_title.strip()

        if not new_title:
            new_title = "None"
        if not new_title > " ":
            new_title = "None"

        # standardize delimiters...use [ ] only to simplify regular expressions
        new_title = new_title.replace("(","[")
        new_title = new_title.replace(")","]")
        new_title = new_title.replace("{","[")
        new_title = new_title.replace("}","]")
        new_title = new_title.replace("<","[")
        new_title = new_title.replace(">","]")

        # odds and sods
        new_title = self.apply_chosen_titlecase(new_title)   # standardize
        new_title = new_title.replace(" No."," #")
        new_title = new_title.replace("_ The",": The")
        new_title = new_title.replace("Book One_","Book 1:")
        new_title = new_title.replace("Book Two_","Book 2:")
        new_title = new_title.replace("Book Three_","Book 3:")
        new_title = new_title.replace("Book One","Book 1:")
        new_title = new_title.replace("Book Two","Book 2:")
        new_title = new_title.replace("Book Three","Book 3:")
        new_title = new_title.replace("- Book 1]",": #1]")
        new_title = new_title.replace("- Book 2]",": #2]")
        new_title = new_title.replace("- Book 3]",": #3]")
        new_title = new_title.replace("- Book 4]",": #4]")
        new_title = new_title.replace("- Book 5]",": #5]")
        new_title = new_title.replace("Book I","Book 1")
        new_title = new_title.replace("Book Ii","Book 2")
        new_title = new_title.replace("Book II","Book 2")
        new_title = new_title.replace("Book Iii","Book 3")
        new_title = new_title.replace("Book III","Book 3")
        new_title = new_title.replace("Book Iv","Book 4")
        new_title = new_title.replace("Book IV","Book 4")
        new_title = new_title.replace("Book V","Book 5")
        new_title = new_title.replace(" Vol."," Volume")
        new_title = new_title.replace(" Vol "," Volume")
        new_title = new_title.replace("Volume One","Volume 1")
        new_title = new_title.replace("Volume Two","Volume 2")
        new_title = new_title.replace("Volume Three","Volume 3")
        new_title = new_title.replace("Volume Four","Volume 4")
        new_title = new_title.replace("Volume Five","Volume 5")
        new_title = new_title.replace(" Part One"," #1")
        new_title = new_title.replace(" Part Two"," #2")
        new_title = new_title.replace(" Part Three"," #3")
        new_title = new_title.replace(" Part Four"," #4")
        new_title = new_title.replace(" Part Five"," #5")
        new_title = new_title.replace(" Number One"," #1")
        new_title = new_title.replace(" Number Two"," #2")
        new_title = new_title.replace(" Number Three"," #3")
        new_title = new_title.replace(" Number Four"," #4")
        new_title = new_title.replace(" Number Five"," #5")
        new_title = new_title.replace(" - #",": #")
        new_title = new_title.replace(" 1-2"," @~~~1-2~~~@")   # mark so no regex will capture it, then remove mark at very end.
        new_title = new_title.replace(" 1-3"," @~~~1-3~~~@")
        new_title = new_title.replace(" 1-4"," @~~~1-4~~~@")  # The Way of the Tigress 1-4
        new_title = new_title.replace(" 1-5"," @~~~1-5~~~@")
        new_title = new_title.replace("] [Volume 1]"," #1]")     # originally:    (Some Series Here) (Volume 1)
        new_title = new_title.replace("] [Volume 2]"," #2]")
        new_title = new_title.replace("] [Volume 3]"," #3]")
        new_title = new_title.replace("] [Volume 4]"," #4]")
        new_title = new_title.replace("] [Volume 5]"," #5]")
        new_title = new_title.replace(" :",":")
        new_title = new_title.replace("[Short Story]","")
        new_title = new_title.replace("[Kindle Single]","")
        new_title = new_title.replace("[Vintage Espanol]","")
        new_title = new_title.replace("[Spanish Edition]","")
        new_title = new_title.replace("BBw Paranormal Werewolf Shifter Romance","")
        new_title = new_title.replace("Taboo Bareback Romance Novella","")
        new_title = new_title.replace("Lycan Lovers","")
        new_title = new_title.replace("Novella","Novel")   # standardize to simplify regexes
        new_title = new_title.replace("An Novel","")         # sic
        new_title = new_title.replace("A Novel","")

        if new_title.startswith(":"):
            new_title = new_title[1: ].strip()
        if new_title.endswith(":"):
            new_title = new_title[0:-1].strip()
        if new_title.startswith("-"):
            new_title = new_title[1: ].strip()
        if new_title.endswith("-"):
            new_title = new_title[0:-1].strip()

        new_title = new_title.replace("  "," ")
        new_title = new_title.replace("[ ]","")
        new_title = new_title.replace("[]","")

        if DEBUG: print("apply_quality_fix_titles_words_delete_apply_regex    id: ", as_unicode(id), "  old_title: ", title, "   new_title: ", new_title)

        return new_title
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_chosen_titlecase(self,title):  # for Title and Series
        if self.use_english_titlecasing:
            new_title = self.titlecase(title)
        else:
            new_title = new_title.title()
        if DEBUG: print("old title, new title: ", title, new_title)
        return new_title
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_series_regex_control(self,ids):
        self.qfix_titles_update_series_dict = {}
        self.qfix_titles_update_series_index_dict = {}
        for id in ids:
            if id in self.apply_quality_fix_scrub_titles_ignore_books_set:
                continue
            title = self.guidb.title(id, index_is_id=True)
            scenario,series,index = self.apply_quality_fix_titles_series_analyze_scenario(id,title)
            if scenario == 0:
                new_title = self.apply_quality_fix_titles_series_scenario_0(id,title)
                new_title = self.apply_quality_fix_titles_residual_artifacts_delete(id,new_title)
            elif scenario == 1:
                new_title = self.apply_quality_fix_titles_series_scenario_0(id,title)
                new_title = self.apply_quality_fix_titles_series_scenario_1(id,new_title,series,index)
                new_title = self.apply_quality_fix_titles_residual_artifacts_delete(id,new_title)
            else:
                new_title = title

            if title != new_title:
                self.guidb.set_title(id, new_title, notify=True)
        #END FOR

        if len(self.qfix_titles_update_series_dict) > 0 or len(self.qfix_titles_update_series_index_dict) > 0:
            self.apply_quality_fix_titles_update_series()

        del self.qfix_titles_update_series_dict
        del self.qfix_titles_update_series_index_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_series_analyze_scenario(self,id,title):

        series = None
        index = None

        series = self.guidb.series(id, index_is_id=True)
        index = self.guidb.series_index(id, index_is_id=True)

        if not series:
            scenario = 0
        elif not index:
            index = 0
            scenario = 1
        else:
            if index >= 0:
                scenario = 1

        if DEBUG: print("book id: ", as_unicode(id), " scenario: ", as_unicode(scenario), " series: ", series, " index: ", as_unicode(index))

        return scenario,series,index
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_series_scenario_0(self,id,title):

        new_title = title

        if RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE'] = prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE']
            prefs

        r = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE']

        r_list = r.split("|")

        IS_REGEX_TESTING = False  # can see discrete search match values of each simple regex to confirm that whole regex is sorted properly from the most specific to the most generic. this is priceless.

        for r in r_list:
            try:
                p = re.compile(r,re.IGNORECASE|re.MULTILINE|re.DOTALL)
                match_r = p.search(title)
                if not match_r:
                    #~ if DEBUG: print("No series related words to relocate from title were found; nothing done.")
                    continue
                else:
                    series_related_string = match_r.group()
                    if DEBUG: print("Critical Value:  series_related_string = match_r.group() ",series_related_string, "      ", r)     # the very first one will be kept before the 'break', so it must be the correct answer...
                    if series_related_string > " ":
                        new_title = title.replace(series_related_string,"").strip()
                        self.qfix_titles_update_series_dict[id] = series_related_string  #for parse1
                        if not IS_REGEX_TESTING:
                            break  #we want to be non-greedy, so use only the *very first match* found in the original "|" separated regex...which *must* be manually sorted from most specific to most generic
            except Exception as e:
                if DEBUG: print("RE COMPILE ERROR IN apply_quality_fix_titles_series_scenario_0 for book id:", as_unicode(id), "       ", as_unicode(e))
                return title
        #END FOR

        if DEBUG: print("scenario 0:    id: ", as_unicode(id), "  old_title: ", title, "   new_title: ", new_title)

        return new_title
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_series_scenario_1(self,id,title,series,index):
        #~ example:   title:    Flat-Out Celeste (Flat-Out Love)             series:    Flat-Out Love [2]

        if not isinstance(series,unicode_type):
            if DEBUG: print("series is not unicode: ", as_unicode(series))
            return title

        new_title = title.replace(series,"")
        new_title = title.replace("[  ]","")
        new_title = title.replace("[ ]","")
        new_title = title.replace("[]","")
        new_title = new_title.strip()
        if DEBUG: print("scenario 1:    id: ", as_unicode(id), "  old_title: ", title, "   new_title: ", new_title, "   series:  ", series, "  index: ", as_unicode(index))
        #-------------------
        if RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE'] = prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE']
            prefs

        r = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE']
        try:
            p = re.compile(r,re.IGNORECASE|re.UNICODE|re.DOTALL)
        except Exception as e:
            if DEBUG: print("RE COMPILE ERROR IN apply_quality_fix_titles_series_scenario_1 for book id:", as_unicode(id), "       ", as_unicode(e))
            return new_title
        try:
            match_r_1 = p.search(title)
            match_r_2 = p.search(new_title)
            if match_r_1:
                match_r = match_r_1
            elif match_r_2:
                match_r = match_r_2
            else:
                match_r = None
            if not match_r:
                if DEBUG: print("No series_index related words to delete from title were found; nothing done.")
            else:
                series_index_related_string = match_r.group()
                #~                           new_title = new_title.replace(series_related_string,"").strip()        # scenario_0 took care of this already...
                #~ if not id in self.qfix_titles_update_series_index_dict:  #may have been discovered and relocated in scenario_0, which is done just before scenario_1.
                self.qfix_titles_update_series_index_dict[id] = series_index_related_string  #for parse2
                if DEBUG: print("possible series-index related words to relocate from title in parse2:  ", series_index_related_string)
                del match_r
                del match_r_1
                del match_r_2
        except Exception as e:
            if DEBUG: print("Other Error In apply_quality_fix_titles_series_scenario_1 for book id:", as_unicode(id), "       ", as_unicode(e))

        return new_title
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_residual_artifacts_delete(self,id,new_title):

        if RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE'] = prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE']
            prefs

        r = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE']

        try:
            p = re.compile(r,re.IGNORECASE)
            match_r = p.search(new_title)
            if not match_r:
                pass
                #~ if DEBUG: print("No artifacts to delete from title were found; nothing done.")
            else:
                artifacts_string = match_r.group()
                if DEBUG: print("artifacts to delete from title:  ", artifacts_string)
                new_title = new_title.replace(artifacts_string,"").strip()
                del match_r
        except Exception as e:
            if DEBUG: print("RE COMPILE ERROR IN apply_quality_fix_titles_residual_artifacts_delete for book id:", as_unicode(id), "       ", as_unicode(e))

        # odds and sods
        new_title = new_title.replace("_"," ").strip()
        new_title = new_title.replace(" :",":").strip()
        new_title = new_title.replace(": -2",": 1-2").strip()
        new_title = new_title.replace(": -3",": 1-3").strip()
        new_title = new_title.replace(": -4",": 1-4").strip()
        new_title = new_title.replace(": -5",": 1-5").strip()

        new_title = new_title.replace("The The","The").strip()
        new_title = new_title.replace("[The]","").strip()

        return new_title
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_update_series(self):

        new_series_dict = {}  #id = series
        new_series_index_dict = {}  #id = series_index

        #~ for id,series_related_string in self.qfix_titles_update_series_dict.iteritems():
        for id,series_related_string in iteritems(self.qfix_titles_update_series_dict):
            if DEBUG: print(series_related_string)
            new_series,new_index = self.apply_quality_fix_titles_update_series_parse_1(id,series_related_string)
            if new_series:
                new_series_dict[id] = new_series
                if DEBUG: print("new_series_dict[id] = new_series: ", as_unicode(new_series))
            if new_index:
                new_series_index_dict[id] = new_index
                if DEBUG: print("new_series_index_dict[id] = new_index: ", as_unicode(new_index))
        #END FOR

        #~ for id,series in new_series_dict.iteritems():
        for id,series in iteritems(new_series_dict):
            series = self.apply_chosen_titlecase(series)
            series = series.strip()
            #~ --------------------------
            #~ special corrections
            #~ --------------------------
            if series.startswith("_"): series = series[1: ]
            if series.startswith("-"): series = series[1: ]
            series = series.replace("'S","'s")  #  The Horse'S is not fixed by title()
            series = series.replace(" Ii "," II ")
            series = series.replace(" Iii "," III ")
            series = series.replace(" Iv "," IV ")
            series = series.replace(" Vi "," VI ")
            series = series.replace("(","")
            series = series.replace(")","")

            if series.endswith("0.5") or series.endswith(" .5"):
                if id in new_series_index_dict:
                    index = new_series_index_dict[id]
                    index = float(index) + float(".5")
                    new_series_index_dict[id] = float(index)
                    series = series[0:-2].strip()
                else:
                    new_series_index_dict[id] = 0.50
                    series = series[0:-3].strip()

            old = series # for undo if series would otherwise become blank...

            series = series.replace("Series","")
            series = series.replace("Books","")
            series = series.replace("Novels","")
            series = series.replace("Volumes","")
            series = series.replace("Book","")
            series = series.replace("Novel","")
            series = series.replace("Volume","")
            #~ --------------------------
            #~ --------------------------
            series = series.strip()
            if not series > " " :
                series = old
            if series > " " :
                self.guidb.set_series(id, series, notify=True)
                if id in new_series_index_dict:
                    index = new_series_index_dict[id]
                    self.guidb.set_series_index(id, index, notify=True)
        #END FOR

        #----------------------
        #----------------------
        #~ for id,series_index_related_string in self.qfix_titles_update_series_index_dict.iteritems():
        for id,series_index_related_string in iteritems(self.qfix_titles_update_series_index_dict):
            if DEBUG: print("for id,series_index_related_string in self.qfix_titles_update_series_index_dict.iteritems():  ", series_index_related_string)
            if id in new_series_index_dict:
                potential_new_index = new_series_index_dict[id]
            else:
                potential_new_index = None
            new_index = self.apply_quality_fix_titles_update_series_parse_2(id,series_index_related_string,potential_new_index)
            if not new_index:
                continue
            new_series_index_dict[id] = new_index
        #END FOR

        #~ for id,index in new_series_index_dict.iteritems():
        for id,index in iteritems(new_series_index_dict):
            self.guidb.set_series_index(id, index, notify=True)
        #END FOR

        #----------------------
        #----------------------
        del new_series_dict
        del new_series_index_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_update_series_parse_1(self,id,series_related_string):
        new_series = None
        new_index = None
        #----------------------
        if DEBUG: print("parse1  original   id,series_related_string: ", as_unicode(id), series_related_string)

        series_related_string = series_related_string.replace("[","")
        series_related_string = series_related_string.replace("]","")
        series_related_string = series_related_string.replace("(","")
        series_related_string = series_related_string.replace(")","")
        series_related_string = series_related_string.replace("{","")
        series_related_string = series_related_string.replace("}","")
        series_related_string = series_related_string.replace(",","")
        series_related_string = series_related_string.replace(";","")
        series_related_string = series_related_string.replace(":","")
        series_related_string = series_related_string.replace(" -","")  #but keep   Flat-Out
        series_related_string = series_related_string.replace("- ","")  #but keep   Flat-Out
        series_related_string = series_related_string.replace("#","")

        #~ ---------------
        r = "[0-9]+"  # extract series_index, if any
        index_found = False
        try:
            p = re.compile(r,re.IGNORECASE|re.UNICODE|re.DOTALL)
            match_r = p.search(series_related_string)              #  The Bear and the Dragon (A Jack Ryan Novel Book 8)
            if not match_r:
                pass
            else:
                new_index = match_r.group()
                if DEBUG: print("new index is: ", new_index)
                index_found = True         # A Jack Ryan Novel Book 8
                series_related_string = series_related_string.replace(new_index,"")  # A Jack Ryan Novel Book
                series_related_string = series_related_string.strip()
                new_series = self.apply_chosen_titlecase(series_related_string)
        except Exception as e:
            if DEBUG: print("RE COMPILE ERROR IN apply_quality_fix_titles_update_series_parse_1 for book id:", as_unicode(id), "       ", as_unicode(e))

        if new_series:
            if new_series.startswith("A "):    # A Jack Ryan Novel Book
                if "Novel" in new_series:
                    new_series = new_series[2: ]
                    new_series = new_series.replace("Novel","")
                    if "Book" in new_series:
                        new_series = new_series.replace("Book","")
                    new_series = new_series.replace("  "," ").strip()   # Jack Ryan

        if new_index:
            try:
                new_index = float(new_index)
            except:
                new_index = 0

        if DEBUG: print("parse1  final    new index found: ", index_found, "  new index: ", new_index, "  new series: ", new_series)

        #----------------------
        return new_series,new_index
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_update_series_parse_2(self,id,series_index_related_string,potential_new_index):

        if DEBUG: print("parse2[a]:  id,series_index_related_string,potential_new_index: ", as_unicode(id), "  ", series_index_related_string, "  ", as_unicode(potential_new_index))

        title = self.guidb.title(id, index_is_id=True)

        series_index_related_string = series_index_related_string.strip()
        new_title = title.replace(series_index_related_string,"")
        if potential_new_index:
            potential_new_index = as_unicode(potential_new_index).strip()
            new_title = title.replace(potential_new_index,"")
        if title != new_title:
            self.guidb.set_title(id, new_title, notify=True)
            if DEBUG: print("parse2[b]:  new_title is: ", new_title)
        #----------------------
        # Try SIRS
        #----------------------
        sirs = as_unicode(series_index_related_string).strip()     # examples:   [ #3]     #3       3
        sirs = sirs.replace("[","")
        sirs = sirs.replace("#","")
        sirs = sirs.replace(" ","")
        sirs = sirs.replace("]","")

        if sirs.isnumeric():
            new_index = int(sirs)      # e.g. 3
            if DEBUG: print("parse2[c]: final new_index is: ", as_unicode(new_index))
        else:
            try:
                new_index = float(sirs)  # e.g. 3.5
            except Exception as e:
                if DEBUG: print("parse2[d]:  apply_quality_fix_titles_update_series_parse_2:  parsing potential series index of: ", as_unicode(sirs), "   ", as_unicode(e))
                new_index = None
        #----------------------
        # Try PNI
        #----------------------
        if not new_index:
            pni = as_unicode(potential_new_index).strip()     # example:   [ #3]
            pni = pni.replace("[","")
            pni = pni.replace("#","")
            pni = pni.replace(" ","")
            pni = pni.replace("]","")

            if pni.isnumeric():
                new_index = int(pni)      # e.g. 3
                if DEBUG: print("parse2[e]: final new_index is: ", as_unicode(new_index))
            else:
                try:
                    new_index = float(pni)  # e.g. 3.5
                except Exception as e:
                    if DEBUG: print("parse2[f]:  apply_quality_fix_titles_update_series_parse_2:  parsing potential series index of: ", as_unicode(pni), "   ", as_unicode(e))
                    new_index = None

        series = self.guidb.series(id, index_is_id=True)
        new_title = new_title.replace(series,"")
        if new_index:
            new_title = new_title.replace(as_unicode(new_index),"")
        self.guidb.set_title(id, new_title, notify=True)
        if DEBUG: print("parse2[g]:  final new_title is: ", new_title)

        return new_index
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titlecase_titles(self,ids):
        for id in ids:
            newtitle = self.guidb.title(id, index_is_id=True)
            newtitle = self.apply_chosen_titlecase(newtitle)

            #~ special corrections
            newtitle = newtitle.replace("'S","'s")  #  The Horse'S is not fixed by newtitle()
            newtitle = newtitle.replace("n'T","n't")

            newtitle = newtitle.replace("Iii ","III ")
            newtitle = newtitle.replace("Ii ","II ")
            newtitle = newtitle.replace("Iv ","IV ")
            newtitle = newtitle.replace("Vi ","VI ")
            newtitle = newtitle.replace(" Iii"," III")
            newtitle = newtitle.replace(" Ii"," II")
            newtitle = newtitle.replace(" Iv"," IV")
            newtitle = newtitle.replace(" Vi"," VI")
            newtitle = newtitle.replace("Iii: ","III ")
            newtitle = newtitle.replace("Ii: ","II ")
            newtitle = newtitle.replace("Iv: ","IV ")
            newtitle = newtitle.replace("Vi: ","VI ")

            newtitle = newtitle.replace("VIscount ","Viscount ")

            newtitle = newtitle.replace("Tv ","TV ")
            newtitle = newtitle.replace("Fbi ","FBI ")
            newtitle = newtitle.replace("Cia ","CIA ")
            newtitle = newtitle.replace("Nsa ","NSA ")
            newtitle = newtitle.replace("Epub","EPUB")
            newtitle = newtitle.replace("Atm","ATM")
            newtitle = newtitle.replace(" Uk"," UK")
            newtitle = newtitle.replace(" Usa"," Usa")
            newtitle = newtitle.replace(" Eu "," EU ")

            newtitle = newtitle.replace("1St","1st")
            newtitle = newtitle.replace("2Nd","2nd")
            newtitle = newtitle.replace("3Rd","3rd")
            newtitle = newtitle.replace("4Th","4th")
            newtitle = newtitle.replace("5Th","5th")
            newtitle = newtitle.replace("6Th","6th")
            newtitle = newtitle.replace("7Th","7th")
            newtitle = newtitle.replace("8Th","8th")
            newtitle = newtitle.replace("9Th","9th")
            newtitle = newtitle.replace("10Th","10th")

            self.guidb.set_title(id, newtitle, notify=True)
        #END FOR
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titlecase_series(self,ids):
        for id in ids:
            series = self.guidb.series(id, index_is_id=True)
            if series is not None and series > " ":
                newseries = self.apply_chosen_titlecase(series)
                self.guidb.set_series(id, newseries, notify=True)
        #END FOR
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_update_title_sorts(self,my_db,my_cursor,ids):
        #Calibre has a table books trigger using a scalar function named 'title_sorts' that automatically updates it when the table is changed...but allow the user to force it here anyway...
        mysql = "UPDATE books SET sort = title_sort(title) WHERE id = ?"
        my_cursor.execute("begin")
        for id in ids:
            my_cursor.execute(mysql,([id]))
        #END FOR
        my_cursor.execute("commit")

        self.apply_quality_fix_refresh_ids()
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_residual_artifacts_final(self,ids):

        for id in ids:
            if id in self.apply_quality_fix_scrub_titles_ignore_books_set:
                continue
            title = self.guidb.title(id, index_is_id=True)
            orig = title
            series = self.guidb.series(id, index_is_id=True)
            index = self.guidb.series_index(id, index_is_id=True)
            if series:
                title = title.replace(series,"").strip()
            if index:
                s_index = as_unicode(index)
                if s_index in title:
                    title = title.replace("#","").strip()
                    title = title.replace(s_index,"").strip()
            title = title.replace("  "," ").strip()
            title = title.replace("[    ]","")
            title = title.replace("[   ]","")
            title = title.replace("[  ]","")
            title = title.replace("[ ]","")
            title = title.replace("[]","")
            nleft = title.count("[")
            nright = title.count("]")
            if nleft != nright:
                title = title.replace("[","")
                title = title.replace("]","")
            title = title.replace(", ]","]")
            title = title.replace("@~~~","")
            title = title.replace("~~~@","")
            title = title.strip()
            if title.startswith(":"):
                title = title[1: ].strip()
            if title.endswith(":"):
                title = title[0:-1].strip()
            title = title.replace("The  The","").strip()
            title = title.replace("::","").strip()
            title = title.replace("  "," ").strip()
            if title.count(".") > 4:
                title = title.replace("."," ").strip()
            if title.startswith("I -"):
                title = title[3: ].strip()
            if title.startswith("Ii -"):
                title = title[4: ].strip()
            if title.startswith("Iii -"):
                title = title[5: ].strip()
            if title.startswith("IV -"):
                title = title[4: ].strip()
            if title.startswith("V -"):
                title = title[3: ].strip()
            if title.startswith("Vi -"):
                title = title[4: ].strip()

            if title.startswith("'s"):
                title = title[2: ].strip()
            title = title.replace("'S","'s")  #  The Horse'S is not fixed by title()
            title = title.replace("n'T","n't")
            title = title.replace("Iii ","III ")
            title = title.replace("Ii ","II ")
            title = title.replace("Iv ","IV ")
            title = title.replace("Vi ","VI ")
            title = title.replace("Iii: ","III ")
            title = title.replace("Ii: ","II ")
            title = title.replace("Iv: ","IV ")
            title = title.replace("Vi: ","VI ")
            title = title.replace("Tv ","TV ")
            title = title.replace("Fbi ","FBI ")
            title = title.replace("Cia ","CIA ")
            title = title.replace("Nsa ","NSA ")
            title = title.replace("A Novel","")
            title = title.replace("An Novel","")  #sic

            if title.startswith("The ["):   # The [The Shades Of London]
                title = title.replace("The [","")
                title = title.replace("[","")
                title = title.replace("]","")

            title = title.replace("Fuck","F*ck")
            title = title.replace("Shit","Sh*t")

            title = title.strip()

            if title.startswith(":"):
                title = title[1: ].strip()
            if title.endswith(":"):
                title = title[0:-1].strip()

            if title.startswith("-"):
                title = title[1: ].strip()
            if title.endswith("-"):
                title = title[0:-1].strip()

            title = title.strip()

            if title == "The" or title == "A" or title == "An" or title <= " ":
                if series:
                    title = series
            if not title > " ":
                title = "None"

            if orig != title:
                self.guidb.set_title(id, title, notify=True)
        #END FOR
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_update_author_initials(self,ids):

        self.apply_quality_fix_refresh_ids()

        initials_mode = prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_INITIALS_MODE']

        for id in ids:
            authors = self.guidb.authors(id, index_is_id=True)
            if authors:
                authors = [a.strip().replace('|', ',') for a in authors.split(',')]
                new_authors = [self.get_formatted_author_initials(initials_mode, a) for a in authors]
                if authors != new_authors:
                    self.guidb.set_authors(id, new_authors, notify=True)
                    if DEBUG: print("author initials were standardized for book id: ", as_unicode(id), " with chosen style: ", initials_mode)
        #END FOR

        del initials_mode
        try:
            del authors
            del new_authors
        except:
            pass

        self.apply_quality_fix_refresh_ids()
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_update_author_sorts(self,my_db,my_cursor,ids):

        mysql = "UPDATE authors SET sort = author_to_author_sort(name) WHERE authors.id IN (SELECT author FROM books_authors_link WHERE book=?)"
        my_cursor.execute("begin")
        for id in ids:
            my_cursor.execute(mysql,([id]))
        #END FOR
        my_cursor.execute("commit")

        self.apply_quality_fix_refresh_ids()

        tmp_dict = {}

        for id in ids:
            authors_string = self.guidb.authors(id, index_is_id=True)
            authors_list = string_to_authors(authors_string)
            new_author_sort = self.guidb.new_api.author_sort_from_authors(authors_list, key_func=lambda x: x)
            tmp_dict[id] = new_author_sort
        #END FOR

        self.quality_fix_current_ids = copy.deepcopy(ids)

        #~ This ensures that the metadata.db = cache = library_view
        for id in ids:
            mi = Metadata(_('Unknown'))
            #~ ------------------------
            mi.author_sort = tmp_dict[id]
            #~ ------------------------
            id_map = {}
            id_map[id] = mi
            payload = []
            payload.append(id)
            edit_metadata_action = self.maingui.iactions['Edit Metadata']
            edit_metadata_action.apply_metadata_changes(id_map, callback=None)
        #END FOR

        self.apply_quality_fix_refresh_ids()

        del authors_string
        del authors_list
        del new_author_sort
        del tmp_dict
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_refresh_ids_callback(self,payload):
        self.gui.library_view.model().refresh_ids(payload)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_refresh_ids(self):
        ids = self.quality_fix_current_ids
        self.gui.library_view.model().refresh_ids(ids)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_formatted_author_initials(self,initials_mode, author):
        #~ Honors go to kiwidude for his excellent 'Quality Check' plug-in from which this is borrowed:
        '''
        Given an author name, break it down looking for potential initials
        and if any found reformat them to the desired preference indicated
        by initials mode.
        '''
        ignore_words = ['von', 'van', 'jr', 'jr.', 'sr', 'sr.', 'st', 'st.',
                        'ed', 'ed.', 'dr', 'dr.', 'phd', 'ph.d', 'ph.d.']
        ignore_upper_words = ['ii', 'iii']
        ignore_words_map = dict((k,True) for k in ignore_words)

        parts = author.split()
        new_parts = []
        append_to_previous = False
        for tok in parts:
            if len(tok) == 0:
                continue
            handled = False
            # We will only ignore these words if exact match and the
            # author does not have these in uppercase. i.e. JR should
            # be treated as author initials, but Jr or jr will be ignored
            if tok.lower() in ignore_words_map and tok.upper() != tok:
                pass
            # Some ignore words are likely to be all uppercase. If there
            # was a genuine author with these initials then bad luck!
            # i.e. II or III will get treated as not initials.
            elif tok.lower() in ignore_upper_words:
                pass
            elif tok.isnumeric():
                pass
            # Any word which has a period or is in uppercase with two or less
            # characters will be considered an initial
            elif '.' in tok or (tok.upper() == tok and len(tok) <= 2):
                # Ok, we have something in the expression we will treat as an initial
                # Now figure out how to format it
                if initials_mode == 'A.B.':
                    #print('Author',author,'Tok',tok)
                    new_tok = ''
                    for c in tok.replace('.',''):
                        new_tok += c + '.'
                    if append_to_previous:
                        new_parts[-1] = new_parts[-1] + new_tok
                    else:
                        new_parts.append(new_tok)
                        append_to_previous = True
                elif initials_mode == 'A. B.':
                    new_tok = ''
                    for c in tok.replace('.',''):
                        new_tok += c + '. '
                    new_parts.append(new_tok.strip())
                elif initials_mode == 'A B':
                    new_tok = ''
                    for c in tok.replace('.',''):
                        new_tok += c + ' '
                    new_parts.append(new_tok.strip())
                elif initials_mode == 'AB':
                    new_tok = tok.replace('.','')
                    if append_to_previous:
                        new_parts[-1] = new_parts[-1] + new_tok
                    else:
                        new_parts.append(new_tok)
                        append_to_previous = True

                handled = True

            if not handled:
                new_parts.append(tok)
                append_to_previous = False

        return ' '.join(new_parts)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_swap_author_names(self,ids,pattern="FNLN"):

        from calibre import force_unicode
        from calibre.utils.config_base import tweaks
        from calibre.ebooks.metadata.__init__ import ( _author_pat, \
                                                                                    string_to_authors, \
                                                                                    authors_to_sort_string, \
                                                                                    author_to_author_sort, \
                                                                                    remove_bracketed_text, \
                                                                                    authors_to_string )
        for id in ids:
            new_authors_list = []
            if id in self.quality_fix_scrub_authors_new_authors_dict:
                authors_list = self.quality_fix_scrub_authors_new_authors_dict[id]
            else:
                authors = self.guidb.authors(id, index_is_id=True) # Authors as a comma separated string or None;  In the comma separated string, commas in author names are replaced by | symbols
                if not authors:
                    authors = 'Unknown'
                if not isinstance(authors,unicode_type):
                    if DEBUG: print("ERROR:  raw authors from guidb: ", as_unicode(authors), " of type:  " , type(authors))  # should not be a list
                    continue
                if DEBUG: print("raw authors from guidb.authors(): ", authors)
                authors = authors.replace(',', '&')  # guidb.authors() returns a comma to separate multiple authors instead of an ampersand..."Daphne du Maurier,Antonio de la Madrid"
                authors = authors.replace('|', ',')    # likewise, commas in author names were replaced by | symbols
                authors = authors + " &"
                authors_list = authors.split("&")
            for author in authors_list:
                author = author.replace('|', ',')  # only possibly in list values from ..._dict[id]
                author = author.strip()
                if not author > " ":
                    continue
                if DEBUG: print("original single author: ", author)
                if pattern == "FNLN":
                    if ',' in author:
                        new_author = self.swap_name_to_fnln(author)
                        new_authors_list.append(new_author)
                        if DEBUG: print("new FNLN author: ", new_author)
                    else:
                        new_authors_list.append(author)
                        if DEBUG: print("author already FNLN: ", author)
                else:
                    if not ',' in author:
                        new_author = self.swap_name_to_lnfn(author)
                        new_authors_list.append(new_author)
                        if DEBUG: print("new LNFN author: ", new_author)
                    else:
                        new_authors_list.append(author)
                        if DEBUG: print("author already LNFN: ", author)
            #END FOR
            if len(new_authors_list) == 0:
                continue
            mi = Metadata(_('Unknown'))
            #~ ------------------------
            mi.authors = new_authors_list
            mi.author_sort = authors_to_sort_string(mi.authors)          #~ version 1.0.175  simultaneously update author sort too
            #~ ------------------------
            id_map = {}
            id_map[id] = mi
            payload = []
            payload.append(id)
            edit_metadata_action = self.maingui.iactions['Edit Metadata']
            edit_metadata_action.apply_metadata_changes(id_map, callback=None)
            del authors_list
            del author
            del new_authors_list
        #END FOR
        self.apply_quality_fix_refresh_ids()
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def swap_name_to_fnln(self,a):
        parts = a.split(',')
        if len(parts) <= 1:
            return a
        surname = parts[0]
        return '%s %s' % (' '.join(parts[1: ]), surname)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def swap_name_to_lnfn(self,a):
        parts = a.split(" ")
        if len(parts) <= 1:
            return a
        surname = parts[-1]
        return '%s, %s' % (surname, ' '.join(parts[0:-1]))
    #---------------------------------------------------------------------------------------------------------------------------------------
    def remove_title_from_authors(self,ids):

        if RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_RESIDUAL_ARTIFACTS_REGEX_DELETE'] =  prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_RESIDUAL_ARTIFACTS_REGEX_DELETE']

        r = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_RESIDUAL_ARTIFACTS_REGEX_DELETE']

        r = r + "|"
        r = r.strip()
        r_list = r.split("|")

        self.quality_fix_scrub_authors_new_authors_dict = {}  # id = new authors     used by  FNLN   LN, FN function...

        for id in ids:
            if id in self.apply_quality_fix_scrub_titles_ignore_books_set:
                continue
            authors = self.guidb.authors(id, index_is_id=True)
            title = self.guidb.title(id, index_is_id=True)
            if authors:
                if isinstance(authors,list):
                    pass
                else:
                    t = []
                    t.append(authors)
                    authors = t
                    del t
                if not title:
                    title = "Unknown"
                title = title.replace(" @~~~1-2~~~@"," 1-2")   # marked earlier so no regex would capture it...
                title = title.replace(" @~~~1-3~~~@"," 1-3")
                title = title.replace(" @~~~1-4~~~@"," 1-4")  # The Way of the Tigress 1-4
                title = title.replace(" @~~~1-5~~~@"," 1-5")
                title = title.strip()
                new_authors = []
                for a in authors:
                    a = a.replace("|",",")
                    a = a.replace(";"," ")
                    if DEBUG: print(" author prior to scrubbing: ", as_unicode(a))
                    orig = a
                    a = a.strip()
                    a = self.remove_artifacts_from_authors(a,r_list)
                    s = as_unicode(orig).strip()
                    t = as_unicode(title).strip()
                    a = a.replace(title,"").strip()
                    a = a.replace(t,"").strip()
                    a = self.remove_artifacts_from_authors(a,r_list)
                    if a == "_." or a == "*.":
                        a = ""
                    if a > " ":
                        if a != orig:
                            if "&" in a:  # ',' converted to a '&'
                                a_split = a.split("&")
                                for x in a_split:
                                    x = x.strip()
                                    x = x.title()
                                    new_authors.append(x)
                            else:
                                new_authors.append(a)
                            if DEBUG: print("author after scrubbing: ", as_unicode(a))
                    else:
                        new_authors.append("Unknown")
                    del s
                    del t
                #END FOR
                if len(new_authors) > 0:
                    #~ This ensures that the metadata.db = cache = library_view
                    mi = Metadata(_('Unknown'))
                    #~ ------------------------
                    mi.authors = new_authors
                    #~ ------------------------
                    id_map = {}
                    id_map[id] = mi
                    payload = []
                    payload.append(id)
                    edit_metadata_action = self.maingui.iactions['Edit Metadata']
                    edit_metadata_action.apply_metadata_changes(id_map, callback=None)
                    self.quality_fix_scrub_authors_new_authors_dict[id] = new_authors
                del new_authors
        #END FOR

        self.apply_quality_fix_refresh_ids()
#---------------------------------------------------------------------------------------------------------------------------------------
    def remove_series_from_authors(self,ids):
        for id in ids:
            if id in self.apply_quality_fix_scrub_titles_ignore_books_set:
                continue
            series = self.guidb.series(id, index_is_id=True)
            if series:
                index = self.guidb.series_index(id, index_is_id=True)
                authors_string = self.guidb.authors(id, index_is_id=True)
                if authors_string:
                    authors_list = string_to_authors(authors_string)
                    new_authors = []
                    for a in authors_list:
                        if DEBUG: print("remove_series_from_authors:   original author: ", a)
                        orig = a
                        series = series.strip()
                        a = a.replace("|",",")
                        a = a.replace("#","")
                        a = a.replace(";","")
                        a = a.strip()
                        s = as_unicode(orig)
                        t = as_unicode(series)
                        left = a.count("(")
                        right = a.count(")")
                        if left != right:
                            a = a.replace("(","")
                            a = a.replace(")","").strip()
                        b = a[0:1]
                        if b.isnumeric():
                            a = a[1: ]
                        if a.startswith("(") or a.startswith(")") or a.endswith(")") or a.endswith("("):
                            a = a.replace("(","")
                            a = a.replace(")","")
                        a = a.strip()
                        if (s.count(t) > 0) or (t in s) or (series in a) or (a != orig):
                            if DEBUG: print("series: ", t, "  index: ", as_unicode(index), "  author: ", s)
                            a = a.replace(series,"").strip()
                            a = a.replace(t,"").strip()
                            a = a.replace("-"," ")
                            if index:
                                index = as_unicode(index)
                                a = a.replace(index,"").strip()
                            a = a.replace("  "," ").strip()
                            if a > " ":
                                new_authors.append(a)
                                if DEBUG: print("[1] remove_series_from_authors:   new author: ", a)
                            else:
                                pass
                        else:
                            pass
                        del s
                        del t
                    #END FOR
                    if len(new_authors) > 0:
                        #~ This ensures that the metadata.db = cache = library_view
                        mi = Metadata(_('Unknown'))
                        #~ ------------------------
                        mi.authors = new_authors
                        #~ ------------------------
                        id_map = {}
                        id_map[id] = mi
                        payload = []
                        payload.append(id)
                        edit_metadata_action = self.maingui.iactions['Edit Metadata']
                        edit_metadata_action.apply_metadata_changes(id_map, callback=None)
                        self.quality_fix_scrub_authors_new_authors_dict[id] = new_authors
                    del new_authors
        #END FOR

        self.apply_quality_fix_refresh_ids()
#---------------------------------------------------------------------------------------------------------------------------------------
    def remove_artifacts_from_authors(self,a,r_list):

        match_r = None

        for r in r_list:
            r = r.strip()
            if not r > " ":
                continue
            try:
                p = re.compile(r,re.IGNORECASE|re.MULTILINE|re.DOTALL)
                match_r = p.search(a)
                if not match_r:
                    continue
                else:
                    bad_string = match_r.group()
                    if DEBUG: print("words to delete from author:  ", bad_string)
                    a = a.replace(bad_string,"").strip()
            except Exception as e:
                if DEBUG: print("RE COMPILE ERROR IN remove_artifacts_from_authors for author:", as_unicode(a), "       ", as_unicode(e), "  r = ", as_unicode(r))
        #END FOR
        del r_list
        del match_r

        a = a.replace("|",",")
        a = a.replace(";"," ")

        a = a.replace("-."," ")
        a = a.replace("_.","").strip()
        a = a.replace("*.","").strip()
        a = a.replace("_"," ").strip()
        a = a.replace("  "," ").strip()

        if "," in a:
            if a.count(" ") > 1:        #Examples:      Guillermo Del Toro,Daniel Kraus              Clive Cussler,Graham Brown
                if len(a) > 20:
                    a = a.replace(","," , ")
                    a = a.replace("  "," ").strip()
                    a = a.replace(",","&")

        if " trans " in a:
            a = a.replace(" trans ", "&")
        if "translator" in a:
            a = a.replace("translator", "&")
            a = a.replace(":","")
        if "translated by" in a:
            a = a.replace("translated by", "&")
            a = a.replace(":","")

        if DEBUG: print("author after artifacts, if any, removed: ", a)

        return a
    #---------------------------------------------------------------------------------------------------------------------------------------
    def swap_author_and_title_if_needed(self,ids):

        r = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_RESIDUAL_ARTIFACTS_REGEX_DELETE']
        r = r + "|"
        r = r.strip()
        r_list = r.split("|")

        for id in ids:
            if id in self.apply_quality_fix_scrub_titles_ignore_books_set:
                continue
            authors = self.guidb.authors(id, index_is_id=True)
            if not authors:
                continue
            if isinstance(authors,list):
                authors_list = authors
            else:
                authors_list = []
                authors_list.append(authors)
            authors = authors_to_string(authors_list)
            title = self.guidb.title(id, index_is_id=True)
            if ' ' in authors:
                if not ' ' in title:  #1-word title...unlikely it is an author's name...
                    continue
            tmpa = authors.replace(" ","").strip()  #remove characters normally found in a typical author from the current author
            tmpa = authors.replace(".","").strip()
            tmpa = authors.replace(",","").strip()
            tmpa = authors.replace("'","").strip()   # O'Shea
            tmpa = authors.replace("&","").strip()
            tmpt = title.replace(" ","").strip()  #remove characters normally found in a typical author from the current title
            tmpt = title.replace(".","").strip()
            tmpt = title.replace(",","").strip()
            tmpt = title.replace("'","").strip()
            tmpt = title.replace("&","").strip()
            if not tmpa.isalpha():
                if DEBUG: print("tmp author: ", tmpa)
                if tmpt.isalpha():
                    if DEBUG: print("tmp title: ", tmpt)
                    #check original title as a last check on correctness to do this swap...as title may have been scrubbed clean...
                    if id in self.quality_fix_original_titles_dict:
                        original_title = self.quality_fix_original_titles_dict[id]
                    else:
                        continue
                    original_title = original_title.replace(" ","").strip()
                    original_title = original_title.replace(".","").strip()
                    original_title = original_title.replace(",","").strip()
                    original_title = original_title.replace("'","").strip()
                    original_title = original_title.replace("&","").strip()
                    if not original_title.isalpha():
                        continue
                    t = authors  #swap
                    a = title
                    authors_list = []
                    a = a + "&"
                    a_split = a.split("&")
                    for a in a_split:
                        a = a.replace("*.","")
                        a = a.replace("_.","")
                        a = a.replace(";","")
                        a = a.strip()
                        if a > " ":
                            a = self.remove_artifacts_from_authors(a,r_list)  # remember that these new authors never went through the 'scrub author artifacts' function, since they were a title originally...
                            authors_list.append(a)
                    #END FOR
                    if len(authors_list) == 0:
                        authors_list.append("Unknown")
                    mi = Metadata(_('Unknown'))
                    #~ ------------------------
                    mi.authors = authors_list
                    mi.title = t
                    #~ ------------------------
                    id_map = {}
                    id_map[id] = mi
                    payload = []
                    payload.append(id)
                    edit_metadata_action = self.maingui.iactions['Edit Metadata']
                    edit_metadata_action.apply_metadata_changes(id_map, callback=None)
                    if DEBUG: print("Author and Title were swapped: ", as_unicode(id), " new Authors: ", as_unicode(t), " new Title: ", as_unicode(authors_list))
                    self.quality_fix_scrub_authors_new_authors_dict[id] = authors_list
        #END FOR

        self.apply_quality_fix_refresh_ids()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def retrieve_recently_added_books(self):
        tids = []
        for id in self.guidb.data.marked_ids:
            tids.append(id)
            #~ if DEBUG: print("Marked: ", as_unicode(id))
        #END FOR

        ids = []
        for id in tids:
            try:
                timestamp = self.guidb.timestamp(id, index_is_id=True)
                timestamp = as_unicode(timestamp)
                timestamp = timestamp[0:19]
                #~ if DEBUG: print(timestamp, " must be later than: ", self.quality_fixes_checkpoint_time_previous)
                if timestamp >= self.quality_fixes_checkpoint_time_previous:
                    ids.append(id)
            except Exception as e:
                pass
                #~ if DEBUG: print("Error in retrieve_recently_added_books for ", as_unicode(id), "  ",as_unicode(e))
        #END FOR
        del tids

        return ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_original_title_custom_column(self,ids):

        for id in ids:
            title = self.guidb.title(id, index_is_id=True)
            self.quality_fix_original_titles_dict[id] = title
        #END FOR

        orig_title_cc = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_ORIGINAL_TITLE_CUSTOM_COLUMN']
        custom_columns_metadata_dict = self.gui.current_db.field_metadata.custom_field_metadata()
        if not orig_title_cc in custom_columns_metadata_dict:
            if DEBUG: print("Original Title Custom Column was not found in Calibre: ", orig_title_cc)
            del custom_columns_metadata_dict
            return
        custcol = custom_columns_metadata_dict[orig_title_cc]
        table = custcol["table"]
        table = as_unicode(table)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        mysql = "INSERT OR REPLACE INTO " + table + " (id,book,value) VALUES(null,?,?)"
        my_cursor.execute("begin")
        for id in ids:
            title = self.quality_fix_original_titles_dict[id]
            my_cursor.execute(mysql,(id,title))
        #END FOR
        my_cursor.execute("commit")
        my_db.close()

        self.apply_quality_fix_refresh_ids()

        #This ensures that the metadata.db = cache = library_view
        id_map = {}
        mi_field = orig_title_cc
        #~ for id,orig_title in self.quality_fix_original_titles_dict.iteritems():
        for id,orig_title in iteritems(self.quality_fix_original_titles_dict):
            mi = Metadata(_('Unknown'))
            custcol['#value#']  = orig_title
            mi.set_user_metadata(mi_field, custcol)
            id_map = {}
            id_map[id] = mi
            payload = []
            payload.append(id)
            edit_metadata_action = self.maingui.iactions['Edit Metadata']
            edit_metadata_action.apply_metadata_changes(id_map, callback=None)     # critical: can avoid the progress dialog ***if only do 1 at a time***; progress dialog hangs sometimes, and is modal, so cannot manually close it...
        #END FOR
        self.quality_fix_current_ids = copy.deepcopy(ids)
        del ids
        del custom_columns_metadata_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_original_series_custom_column(self,ids):

        self.quality_fix_original_series_dict = {}   # id = series

        orig_series_cc = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_SERIES_ORIGINAL_SERIES_CUSTOM_COLUMN']
        custom_columns_metadata_dict = self.gui.current_db.field_metadata.custom_field_metadata()
        if not orig_series_cc in custom_columns_metadata_dict:
            if DEBUG: print("Original Series Custom Column was not found in Calibre: ", orig_series_cc)
            del custom_columns_metadata_dict
            return
        custcol = custom_columns_metadata_dict[orig_series_cc]
        table = custcol["table"]
        table = as_unicode(table)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        mysql = "INSERT OR REPLACE INTO " + table + " (id,book,value) VALUES(null,?,?)"
        my_cursor.execute("begin")
        for id in ids:
            series = self.guidb.series(id, index_is_id=True)
            if not series:
                continue
            self.quality_fix_original_series_dict[id] = series
            my_cursor.execute(mysql,(id,series))
        #END FOR
        my_cursor.execute("commit")
        my_db.close()

        self.apply_quality_fix_refresh_ids()

        #This ensures that the metadata.db = cache = library_view
        id_map = {}
        mi_field = orig_series_cc
        #~ for id,orig_series in self.quality_fix_original_series_dict.iteritems():
        for id,orig_series in iteritems(self.quality_fix_original_series_dict):
            mi = Metadata(_('Unknown'))
            custcol['#value#']  = orig_series
            mi.set_user_metadata(mi_field, custcol)
            id_map = {}
            id_map[id] = mi
            payload = []
            payload.append(id)
            edit_metadata_action = self.maingui.iactions['Edit Metadata']
            edit_metadata_action.apply_metadata_changes(id_map, callback=None)     # critical: can avoid the progress dialog ***if only do 1 at a time***; progress dialog hangs sometimes, and is modal, so cannot manually close it...
        #END FOR
        self.quality_fix_current_ids = copy.deepcopy(ids)
        del ids
        del custom_columns_metadata_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_original_authors_custom_column(self,ids):

        self.quality_fix_original_authors_dict = {}   # id = authors_string

        orig_authors_cc = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_ORIGINAL_AUTHORS_CUSTOM_COLUMN']
        custom_columns_metadata_dict = self.gui.current_db.field_metadata.custom_field_metadata()
        if not orig_authors_cc in custom_columns_metadata_dict:
            if DEBUG: print("Original authors Custom Column was not found in Calibre: ", orig_authors_cc)
            del custom_columns_metadata_dict
            return
        custcol = custom_columns_metadata_dict[orig_authors_cc]
        table = custcol["table"]
        table = as_unicode(table)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        mysql = "INSERT OR REPLACE INTO " + table + " (id,book,value) VALUES(null,?,?)"
        my_cursor.execute("begin")
        for id in ids:
            authors = self.guidb.authors(id, index_is_id=True)
            if not authors:
                continue
            if isinstance(authors,list):
                authors_list = authors
            else:
                authors_list = []
                authors_list.append(authors)
            authors_string = authors_to_string(authors_list)
            self.quality_fix_original_authors_dict[id] = authors_string
            my_cursor.execute(mysql,(id,authors_string))
        #END FOR
        my_cursor.execute("commit")
        my_db.close()

        self.apply_quality_fix_refresh_ids()

        #This ensures that the metadata.db = cache = library_view
        id_map = {}
        mi_field = orig_authors_cc
        #~ for id,orig_authors in self.quality_fix_original_authors_dict.iteritems():
        for id,orig_authors in iteritems(self.quality_fix_original_authors_dict):
            mi = Metadata(_('Unknown'))
            custcol['#value#']  = orig_authors
            mi.set_user_metadata(mi_field, custcol)
            id_map = {}
            id_map[id] = mi
            payload = []
            payload.append(id)
            edit_metadata_action = self.maingui.iactions['Edit Metadata']
            edit_metadata_action.apply_metadata_changes(id_map, callback=None)     # critical: can avoid the progress dialog ***if only do 1 at a time***; progress dialog hangs sometimes, and is modal, so cannot manually close it...
        #END FOR
        self.quality_fix_current_ids = copy.deepcopy(ids)
        del ids
        del custom_columns_metadata_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def scrub_isbn(self):

        self.quality_fix_isbns_scrubbed_books_list = []

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('Convert ISBNs'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        self.scrub_isbn_values(my_db,my_cursor)

        self.convert_identifiers_isbn_from_10_to_13(my_db, my_cursor)

        self.detect_isbn_changes_to_refresh(my_db, my_cursor)

        my_db.close()
    #-----------------------------------------------------------------------------------------
    def convert_identifiers_isbn_from_10_to_13(self,my_db, my_cursor):
        #~ Important: this is alway done for all books, even if they were NOT selected otherwise.

        mysql = "SELECT book, val FROM identifiers WHERE type = 'isbn'  AND val NOT LIKE '978%'  \
                        AND val NOT LIKE '979%'  AND val NOT NULL;"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            if DEBUG: print("No ISBN 10's Were Found to Convert")
            return
        else:
            n = len(tmp_rows)
            if DEBUG: print("Total Number of ISBN 10s Found: " + as_unicode(n))
            if n == 0 :
                return
            my_counter = 0
            my_total = 0
            my_cursor.execute("begin")  #apsw
            for row in tmp_rows:
                book, old_isbn = row
                book = int(book)
                old_isbn = as_unicode(old_isbn).strip()
                if len(old_isbn) == 10:
                    self.quality_fix_isbns_scrubbed_books_list.append(book)
                    new_isbn = as_unicode(self._convert_isbn_convert_10_to_13(old_isbn))
                    if len(new_isbn) == 13:
                        new_isbn = as_unicode(new_isbn)
                        mysql = "UPDATE identifiers SET val = ? WHERE book = ? AND type = 'isbn' "
                        my_cursor.execute(mysql,(new_isbn, book))
                        if DEBUG: print("ISBN10 Converted to ISBN13: " + as_unicode(old_isbn) + " >>> " + as_unicode(new_isbn))
                    else:
                        old_isbn = as_unicode(old_isbn)
                        if DEBUG: print("This ISBN10 appears to not really be an ISBN10, and was deleted:  " + as_unicode(old_isbn) )
                        mysql = "DELETE FROM identifiers WHERE val = ? AND book = ? AND type = 'isbn' "
                        my_cursor.execute(mysql,(old_isbn, book))
                    self.quality_fix_isbns_scrubbed_books_list.append(book)
                else:
                    old_isbn = as_unicode(old_isbn)
                    if DEBUG: print("This ISBN appears to not really be any kind of ISBN, and was deleted:  " + as_unicode(old_isbn) )
                    mysql = "DELETE FROM identifiers WHERE val = ? AND book = ? AND type = 'isbn' "
                    my_cursor.execute(mysql,(old_isbn, book))
                    self.quality_fix_isbns_scrubbed_books_list.append(book)
            #END FOR
            my_cursor.execute("commit")
    #-----------------------------------------------------------------------------------------
    def _convert_isbn_check_digit_13(self,isbn):
        try:
            assert len(isbn) == 12
            sum = 0
            for i in range(len(isbn)):
                c = int(isbn[i])
                if i % 2: w = 3
                else: w = 1
                sum += w * c
            r = 10 - (sum % 10)
            if r == 10: return '0'
            else: return as_unicode(r)
        except:
            return isbn
    #-----------------------------------------------------------------------------------------
    def _convert_isbn_convert_10_to_13(self,isbn):
        try:
            assert len(isbn) == 10
            prefix = '978' + isbn[:-1]
            check = self._convert_isbn_check_digit_13(prefix)
            return prefix + check
        except:
            return isbn
    #-----------------------------------------------------------------------------------------
    def scrub_isbn_values(self,my_db,my_cursor):
        try:
            #~ ----------
            my_cursor.execute("begin")
            mysql = "UPDATE OR IGNORE identifiers SET type = 'isbn',val=type WHERE type LIKE '%978%' AND val NOT LIKE '%978%'   "    # type 978000123456 value xxxxx  should be:  isbn:978000123456
            my_cursor.execute (mysql)
            mysql = "UPDATE OR IGNORE identifiers SET type = 'isbn',val=type WHERE type LIKE '979%' AND val NOT LIKE '979%'   "          # 979 is reservef for use by the same int'l agency that assigns 978
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            #~ ----------
            my_cursor.execute("begin")
            mysql = "UPDATE OR IGNORE identifiers SET type = 'isbn' WHERE type LIKE '%isbn%' AND type != 'isbn'   "                               # type urnisbn            value 978000123456   should be:  isbn:978000123456
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            #~ ----------
            my_cursor.execute("begin")
            mysql = "UPDATE OR IGNORE identifiers SET type = (trim(type)) WHERE type LIKE '%isbn%'  "
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            #~ ----------
            my_cursor.execute("begin")
            mysql = "UPDATE identifiers SET val = (replace(val,'-','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%-%')"
            my_cursor.execute (mysql)
            mysql = "UPDATE identifiers SET val = (replace(val,' ','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '% %') "
            my_cursor.execute (mysql)
            mysql = "UPDATE identifiers SET val = (replace(val,':','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%:%') "
            my_cursor.execute (mysql)
            mysql = "UPDATE identifiers SET val = (replace(val,'/','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%/%') "
            my_cursor.execute (mysql)
            mysql = "UPDATE identifiers SET val = (trim(val)) WHERE type = 'isbn'  "
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            #~ ----------
            my_cursor.execute("begin")
            mysql = "UPDATE identifiers SET val = (replace(val,'urn','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%urn%') "
            my_cursor.execute (mysql)
            mysql = "UPDATE identifiers SET val = (replace(val,'ebook','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%ebook%') "
            my_cursor.execute (mysql)
            mysql = "UPDATE identifiers SET val = (replace(val,'eBook','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%eBook%') "
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            #~ ----------
            my_cursor.execute("begin")
            mysql = "UPDATE identifiers SET val = (replace(val,'isbn','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%isbn%') "
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            #~ ----------
            if DEBUG: print("All ISBN13s have been standardized by removing any dashes, spaces and prefixes.")
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            try:
                my_cursor.execute("commit")
            except:
                pass
    #---------------------------------------------------------------------------------------------------------------------------------------
    def detect_isbn_changes_to_refresh(self,my_db, my_cursor):
        #~ self.quality_fix_isbns_scrubbed_books_list

        mysql = "SELECT book, val FROM identifiers WHERE type = 'isbn' "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            return
        if len(tmp_rows) == 0:
            return

        tmp_rows.sort()

        for row in tmp_rows:
            book,val = row
            mi = self.guidb.new_api.get_metadata(book)
            identifiers_dict = mi.get_identifiers()
            if 'isbn' in identifiers_dict:
                cache_val = identifiers_dict['isbn']
            else:
                cache_val = "NONE"
            if val != cache_val:
                self.quality_fix_isbns_scrubbed_books_list.append(book)
                if DEBUG: print("book: ", as_unicode(book), "  db val: ", as_unicode(val), "  cache val: ", as_unicode(cache_val))
        #END FOR

        self.quality_fix_isbns_scrubbed_books_list = list(set(self.quality_fix_isbns_scrubbed_books_list))

        if len(self.quality_fix_isbns_scrubbed_books_list) > 0:
            if DEBUG: print("Cache being refreshed from metadata.db due to ISBN key/value changes")
            self.force_refresh_of_cache(self.quality_fix_isbns_scrubbed_books_list)

        self.quality_fix_isbns_scrubbed_books_list[:] = []
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def manually_invoke_quality_fix_single_author_name_format(self):
        rows = self.maingui.library_view.selectionModel().selectedRows()
        if not rows:
            error_dialog(self.maingui, _('JS+ GUI Tool'),_('Cannot apply Quality Fix since no books were selected'), show=True)
        ids = [self.maingui.library_view.model().id(r) for r in rows]
        self.quality_fix_current_ids = ids
        numids = unicode_type(len(ids))
        self.quality_fix_scrub_authors_new_authors_dict = {}
        if prefs['GUI_TOOLS_QUALITY_FIXES_CHANGE_AUTHORS_FNLN'] == unicode_type("True"):
            self.apply_quality_fix_swap_author_names(ids,"FNLN")
            msg = "Author Name format changed to 'FNLN' for " + numids + " book(s)"
        elif prefs['GUI_TOOLS_QUALITY_FIXES_CHANGE_AUTHORS_LNFN'] == unicode_type("True"):
            self.apply_quality_fix_swap_author_names(ids,"LNFN")
            msg = "Author Name format changed to 'LNFN' for " + numids + " book(s)"
        self.gui.status_bar.showMessage(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def manually_invoke_quality_fix_single_author_initials_format(self):
        rows = self.maingui.library_view.selectionModel().selectedRows()
        if not rows:
            error_dialog(self.maingui, _('JS+ GUI Tool'),_('Cannot apply Quality Fix since no books were selected'), show=True)
        ids = [self.maingui.library_view.model().id(r) for r in rows]
        self.quality_fix_current_ids = ids
        numids = unicode_type(len(ids))
        self.apply_quality_fix_update_author_initials(ids)
        msg = "Author initials format changed per Customizing for " + numids + " book(s)"
        self.gui.status_bar.showMessage(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def manually_invoke_quality_fix_single_english_titlecase_title(self):
        rows = self.maingui.library_view.selectionModel().selectedRows()
        if not rows:
            error_dialog(self.maingui, _('JS+ GUI Tool'),_('Cannot apply Quality Fix since no books were selected'), show=True)
        ids = [self.maingui.library_view.model().id(r) for r in rows]
        numids = unicode_type(len(ids))
        self.quality_fix_current_ids = ids
        self.use_english_titlecasing = True
        from calibre_plugins.job_spy.titlecase import titlecase
        self.titlecase = titlecase
        self.apply_quality_fix_titlecase_titles(ids)
        self.apply_quality_fix_refresh_ids()
        msg = "Title has been titlecased per English rules for " + numids + " book(s)"
        self.gui.status_bar.showMessage(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def manually_invoke_quality_fix_single_english_titlecase_series(self):
        rows = self.maingui.library_view.selectionModel().selectedRows()
        if not rows:
            error_dialog(self.maingui, _('JS+ GUI Tool'),_('Cannot apply Quality Fix since no books were selected'), show=True)
        ids = [self.maingui.library_view.model().id(r) for r in rows]
        numids = unicode_type(len(ids))
        self.quality_fix_current_ids = ids
        self.use_english_titlecasing = True
        from calibre_plugins.job_spy.titlecase import titlecase
        self.titlecase = titlecase
        self.apply_quality_fix_titlecase_series(ids)
        self.apply_quality_fix_refresh_ids()
        msg = "Series Name has been titlecased per English rules for " + numids + " book(s)"
        self.gui.status_bar.showMessage(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def tickle_auto_adder_watcher_worker(self):
        try:
            global_path = gprefs['auto_add_path']  # os path to be watched by auto_adder
            if not global_path:
                return
            self.tickle_global_path = self.standardize_path_format(global_path)
            if not os.path.isdir(self.tickle_global_path):
                return

            QTimer.singleShot(2, self.do_tickle)

        except Exception as e:
            if DEBUG: print("tickle_auto_adder_watcher_worker ",as_unicode(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    def do_tickle(self):
        try:
            msg = "The Auto-Adder will be tickled for 2 seconds...Wait..."
            self.show_gui_status_bar_qtimer(msg,5000)
            if DEBUG: print(msg)
            filename_list = []
            for i in range(2):
                dummy_filename = "jsdummyfile_" + as_unicode(i) + ".tickle"
                self.tickle_global_path = self.tickle_global_path.replace(os.sep, '/')
                dummy_filename = os.path.join(self.tickle_global_path,dummy_filename)
                dummy_filename = dummy_filename.replace(os.sep, '/')
                if isbytestring(dummy_filename):
                    dummy_filename = dummy_filename.decode(filesystem_encoding)
                if DEBUG: print(dummy_filename)
                filename_list.append(dummy_filename)
                f = open(dummy_filename, 'wb')
                msg = "This is a dummy file to tickle the Calibre auto-adder watcher to wake up and start auto-adding..."
                msg = as_bytes(msg)
                f.write(msg)
                f.close()
                sleep(1.00)
            #END FOR
            QApplication.instance().processEvents()
            msg = "The Auto-Adder has been tickled"
            self.show_gui_status_bar_qtimer(msg,5000)
            if DEBUG: print(msg)
            for f in filename_list:
                try:
                    os.remove(f)
                except Exception as e:
                    if DEBUG: print("os.remove failed for: ", f, "  ", as_unicode(e))
            #END FOR
            del filename_list
        except Exception as e:
            if DEBUG: print("Exception in do_tickle(): ", as_unicode(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_cc_based_on_another_cc(self):
        if prefs['GUI_TOOLS_UCCBOACC_ACTIVE'] == unicode_type("False"):
            return

        cc_list = self.guidb.custom_field_keys()

        if not prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_1'] in cc_list:
            return
        if not prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_1'] in cc_list:
            return

        self.rule_1_is_valid = True

        self.rule_2_is_valid = True
        if not prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_2'] in cc_list:
            self.rule_2_is_valid = False
        if not prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_2'] in cc_list:
            self.rule_2_is_valid = False

        del cc_list

        self.uccboacc_1_source_cc = prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_1']
        self.uccboacc_1_source_cc_value = prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_VALUE_1']
        self.uccboacc_1_target_cc = prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_1']
        self.uccboacc_1_target_cc_value = prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_VALUE_1']

        self.uccboacc_2_source_cc = prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_2']
        self.uccboacc_2_source_cc_value = prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_VALUE_2']
        self.uccboacc_2_target_cc = prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_2']
        self.uccboacc_2_target_cc_value = prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_VALUE_2']

        if DEBUG:
            try:
                print("=====--------------update_cc_based_on_another_cc--------------===== ")
                print("rule_1_is_valid:",self.rule_1_is_valid)
                print(self.uccboacc_1_source_cc)
                print(self.uccboacc_1_source_cc_value)
                print(self.uccboacc_1_target_cc)
                print(self.uccboacc_1_target_cc_value)
                print("rule_2_is_valid:",self.rule_2_is_valid)
                print(self.uccboacc_2_source_cc)
                print(self.uccboacc_2_source_cc_value)
                print(self.uccboacc_2_target_cc)
                print(self.uccboacc_2_target_cc_value)
            except:
                print("some value could not be printed...such as the 'null' symbol...")


        tids = self.get_selected_books()
        if len(tids) == 0:
            del tids
            return

        ids = []
        for id in tids:
            id = int(id)
            ids.append(id)
        #END FOR
        ids.sort()
        del tids
        if DEBUG: print("selected books: ", as_unicode(len(ids)))

        self.uccboacc_null = "␀"
        self.uccboacc_asterisk = "*"

        self.custom_columns_metadata_dict = self.maingui.current_db.field_metadata.custom_field_metadata()

        for id in ids:
            self.uccboacc_book_control(id)
        #END FOR

        self.maingui.library_view.model().refresh_ids(ids)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def uccboacc_book_control(self,id):

        value_list = self.uccboacc_get_rule_source_values(1,id)
        passed_filter = self.uccboacc_filter_rule_value(1,value_list)
        if passed_filter:
            self.uccboacc_update_rule_target_value(1,id)

        if self.rule_2_is_valid:
            value_list = self.uccboacc_get_rule_source_values(2,id)
            passed_filter = self.uccboacc_filter_rule_value(2,value_list)
            if passed_filter:
                self.uccboacc_update_rule_target_value(2,id)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def uccboacc_get_rule_source_values(self,rule,id):
        value_list = []

        if rule == 1:
            cc = self.uccboacc_1_source_cc
        else:
            cc = self.uccboacc_2_source_cc

        mi = self.guidb.new_api.get_metadata(id)
        value = mi.get(cc)
        if value is None:
            value_list.append(self.uccboacc_null)
        elif isinstance(value,unicode_type):  #e.g. comments
            value_list.append(value)
        elif isinstance(value,list):  #e.g. tag-like
            for v in value:
                value_list.append(v)
            #END FOR

        del mi
        del value

        return value_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def uccboacc_filter_rule_value(self,rule,value_list):

        passed_filter = False

        vl_number_rows = len(value_list)

        if vl_number_rows == 0:
            return passed_filter

        if rule == 1:
            criteria = self.uccboacc_1_source_cc_value
        else:
            criteria = self.uccboacc_2_source_cc_value

        criteria_list = []
        criteria = criteria + "|"
        s_split = criteria.split("|")
        for s in s_split:
            s = s.strip()
            if s > " ":
                criteria_list.append(s)
        #END FOR
        del s_split

        if self.uccboacc_null in criteria_list:
            if self.uccboacc_null in value_list:
                passed_filter = True
                return passed_filter

        if self.uccboacc_asterisk in criteria_list:
            if vl_number_rows == 1:
                if self.uccboacc_null in value_list:  #the only value in value_list...
                    passed_filter = False  #because self.uccboacc_null is *not* in criteria_list...
                else:
                    passed_filter = True
                    return passed_filter
            else:
                passed_filter = True
                return passed_filter
        else:
            for criterion in criteria_list:
                if criterion in value_list:
                    passed_filter = True
                    return passed_filter
            #END FOR

        del criteria_list
        del value_list
        del criteria

        return passed_filter
    #---------------------------------------------------------------------------------------------------------------------------------------
    def uccboacc_update_rule_target_value(self,rule,id):

        if rule == 1:
            cc = self.uccboacc_1_target_cc
            value = self.uccboacc_1_target_cc_value
        else:
            cc = self.uccboacc_2_target_cc
            value = self.uccboacc_2_target_cc_value

        mi_field = cc
        mi = Metadata(_('Unknown'))
        custcol = self.custom_columns_metadata_dict[mi_field]
        custcol['#value#']  = value
        mi.set_user_metadata(mi_field, custcol)
        id_map = {}
        id_map[id] = mi
        payload = []
        payload.append(id)
        edit_metadata_action = self.maingui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=None)
        if DEBUG: print("Rule: ", as_unicode(rule), "  edit_metadata_action.apply_metadata_changes        new value for: ", cc, "   is: ", value)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_author_pseudonyms(self,ids=None,source='manual'):
        #~ ---------------------------------------------------------------
        #~ A Calibre book's "Author" may in fact be a pseudonym for a "Real Author".
        #~ The "author" in table _js_pseudonyms is a "Real Author".  The "pseudonym" in table _js_pseudonym is a Calibre book's Author.
        #~ This function finds a Calibre book's Author that matches a Pseudonym in table _js_pseudonyms, and updates a custom column with the "Real Author" for that Pseudonym.
        #~ ---------------------------------------------------------------
        #~                     table _js_pseudonyms
        #~ ---------------------------------------------------------------
        #~ rowid	pseudonym	                    author (real_author)
        #~ ---------------------------------------------------------------
        #~ 369	    Mary Westmacott	        Agatha Christie
        #~ 60	    Bob Hart                        	Al Trace
        #~ 102	    Clem Watts                  	Al Trace
        #~ 16	    Alberto Moravia	            Alberto Pincherle
        #~ 496	    Sonny Powell	                Alfred Bester
        #~ 20	    Algoth Tietäväinen	        Algot Untola
        #~ 233  	Irmari Rantamala	            Algot Untola
        #~ 242	    J.I. Vatanen                      Algot Untola
        #~ 357	    Maiju Lassila                    Algot Untola
        #~ 539	    Väinö Stenberg	            Algot Untola
        #~ 260	    James Tiptree	                Alice Bradley Sheldon
        #~ 437	    Raccoona Sheldon        	Alice Bradley Sheldon
        #~ ---------------------------------------------------------------
        #~ 'Real Author' Custom Column for the Pseudonyms GUI Tool Must Be: Text,Tag-Like, Ampersand Separated People's Names.
        #~ ---------------------------------------------------------------

        if self.pseudonym_matching_in_progress:
            return

        if not ids:
            ids = self.get_selected_books()
            if len(ids) == 0:
                del ids
                msg = "No Books Were Selected"
                return error_dialog(self.gui, _('JS Author Pseudonyms'),_(msg), show=True)

        selected_books_list = []
        for book in ids:
            book = int(book)
            selected_books_list.append(book)
        #END FOR
        del ids

        mi_field = prefs['GUI_TOOLS_AUTHOR_PSEUDONYMS_CUSTOM_COLUMN']

        custom_columns_metadata_dict = self.gui.current_db.field_metadata.custom_field_metadata()

        if not mi_field in custom_columns_metadata_dict:
            del selected_books_list
            del custom_columns_metadata_dict
            msg = "Customized Pseudonym 'Real Author' Custom Column Does Not Exist in Library: " + mi_field
            del mi_field
            if source == 'manual':
                return error_dialog(self.gui, _('Author Pseudonyms'),_(msg), show=True)
            else:
                return info_dialog(self.gui,msg).show()

        self.pseudonym_matching_in_progress = True

        msg = "JS: Matching Calibre Author Pseudonyms to their Real Author Names.  Selected Books: " + as_unicode(len(selected_books_list))
        self.show_gui_status_bar_qtimer(msg,5000)

        custcol = custom_columns_metadata_dict[mi_field]

        del custom_columns_metadata_dict

        is_valid,msg =  self.verify_js_pseudonym_table_exists()
        if not is_valid:
            self.pseudonym_matching_in_progress = False
            return error_dialog(self.gui, _('JS Author Pseudonyms'),_(msg), show=True)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            self.pseudonym_matching_in_progress = False
            return error_dialog(self.gui, _('Author Pseudonyms'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        self.purge_table_selected_books(my_db,my_cursor)

        self.update_table_selected_books(my_db,my_cursor,selected_books_list)

        #~ --------------------------
        pseudonym_author_list = []   # pseudonym,real_author

        mysql = "SELECT pseudonym,author FROM _js_pseudonyms \
                        WHERE pseudonym != author AND pseudonym NOT NULL AND author NOT NULL;"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            self.pseudonym_matching_in_progress = False
            return error_dialog(self.gui, _('Author Pseudonyms'),_('The JS Pseudonyms Table is empty.  Nothing can be done.'), show=True)
        if len(tmp_rows) == 0:
            self.pseudonym_matching_in_progress = False
            return error_dialog(self.gui, _('Author Pseudonyms'),_('The JS Pseudonyms Table is empty.  Nothing can be done.'), show=True)
        for row in tmp_rows:
            pseudonym,real_author = row
            r = pseudonym,real_author
            pseudonym_author_list.append(r)
        #END FOR
        del tmp_rows

        pseudonym_author_list.sort()
        #~ --------------------------
        author_id_name_dict = {}    # authid = name
        author_id_sort_dict = {}       # authid = sort

        mysql = "SELECT id,name,sort FROM authors \
                       WHERE id IN (SELECT author FROM books_authors_link \
                                             WHERE books_authors_link.author = authors.id \
                                                 AND books_authors_link.book IN (SELECT book FROM _js_selected_books WHERE _js_selected_books.book = books_authors_link.book ) )"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        for row in tmp_rows:
            authid,name,sort = row
            author_id_name_dict[authid] = name
            author_id_sort_dict[authid] = sort
        #END FOR
        del tmp_rows

        if DEBUG:
            n1 = len(author_id_name_dict)
            s1 = as_unicode(n1)
            print("Selected Author Count: ", s1)

        #~ --------------------------
        author_id_book_list = []  # row =  authid,book

        mysql = "SELECT book,author FROM books_authors_link \
                       WHERE books_authors_link.book IN (SELECT book FROM _js_selected_books WHERE _js_selected_books.book = books_authors_link.book )"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        for row in tmp_rows:
            book,authid = row
            s = authid,book
            author_id_book_list.append(s)
        #END FOR
        del tmp_rows

        author_id_book_list.sort()

        if DEBUG: print("Number of books/author combinations: ", as_unicode(len(author_id_book_list)))

        #~ --------------------------
        #~ Compare Author Names with Pseudonyms, yielding the real_author for very similar values...
        #~ --------------------------
        #~ pseudonym_author_list = []   # pseudonym,real_author
        #~ author_id_name_dict = {}    # authid = name
        #~ author_id_sort_dict = {}      # authid = sort

        matched_author_pseudonyms_results_list = []
        unmatched_authid_name_list = []

        SIMILARITY_MINIMUM = 0.85

        #~ for authid,name in author_id_name_dict.iteritems():  # Mary Westmacott
        for authid,name in iteritems(author_id_name_dict):
            match = False
            for row in pseudonym_author_list:
                pseudonym,real_author = row      # Mary Westmacott,Agatha Christie
                p = self.calculate_similarity(name,pseudonym) #Mary Westmacott,Mary Westmacott
                if p >=SIMILARITY_MINIMUM:
                    r = authid,name,real_author,pseudonym   #authid,Mary Westmacott,Agatha Christie,Mary Westmacott
                    matched_author_pseudonyms_results_list.append(r)
                    match = True
                    if DEBUG: print("Pseudonym match:  Book's Author: ", name,"  Pseudonym: ",pseudonym, "   Real Author: ",real_author)
                else:
                    continue
            #END FOR
            if not match:
                r = authid,name  # Mary Westmacott
                unmatched_authid_name_list.append(r)
        #END FOR
        for row in unmatched_authid_name_list:
            authid,name = row
            if authid in author_id_sort_dict:
                sort = author_id_sort_dict[authid]
            else:
                continue
            for row in pseudonym_author_list:
                real_author,pseudonym = row
                p = self.calculate_similarity(sort,pseudonym)
                if p >= SIMILARITY_MINIMUM:
                    r = authid,sort,real_author,pseudonym
                    matched_author_pseudonyms_results_list.append(r)
                    if DEBUG: print("Pseudonym match:  Book's Author: ", sort,"  Pseudonym: ",pseudonym, "   Real Author: ",real_author)
                    break  #a book's author may be a pseudonym for a person, who is the "author" named in table _js_pseudonyms...and there is only 1 possible "author" here...
                else:
                    continue
            #END FOR
        #END FOR
        del unmatched_authid_name_list
        del pseudonym_author_list

        matched_author_pseudonyms_results_list = list(set(matched_author_pseudonyms_results_list))
        matched_author_pseudonyms_results_list.sort()   # r = id,name,sort,pseudonym
        #~ --------------------------
        #~ --------------------------
        #~ multiple Authors could each have a Pseudonym, so the Real Authors custom column must be updated with all of the possible Real Authors for a single book...

        #~ author_id_book_list    row = authid,book

        final_real_authors_dict = {}  #book = list of real authors

        #~ seed the dict for every book
        tmp_list = []  # placeholder for:  real_author_list
        for row in author_id_book_list:
            author_id,book = row
            for row in matched_author_pseudonyms_results_list:
                authid,name,real_author,pseudonym = row
                if author_id != authid:
                    continue
                if DEBUG: print("authid: ", as_unicode(authid), " name: ", name, " real_author: ", real_author, " pseudonym: ", pseudonym)
                if book in final_real_authors_dict:
                    if DEBUG: print("book already in final_real_authors_dict; additional row being added.")
                    tmp_list = final_real_authors_dict[book]
                    tmp_list.append(real_author)
                    final_real_authors_dict[book] = tmp_list
                    del tmp_list
                else:
                    if DEBUG: print("book not in final_real_authors_dict yet; first row will be added.")
                    tmp_list = []
                    tmp_list.append(real_author)
                    final_real_authors_dict[book] = tmp_list
                    del tmp_list
            #END FOR
        #END FOR
        #~ --------------------------
        bookids = []
        #~ for book,real_author_list in final_real_authors_dict.iteritems():
        for book,real_author_list in iteritems(final_real_authors_dict):
            self.apply_new_pseudonyms(mi_field,custcol,book,real_author_list)
            bookids.append(book)
        #END FOR
        del matched_author_pseudonyms_results_list
        del selected_books_list
        del final_real_authors_dict
        #~ --------------------------
        self.purge_table_selected_books(my_db,my_cursor)
        #~ --------------------------
        my_db.close()
        #~ --------------------------
        if source == 'manual':
            n = len(bookids)
            if n > 0:
                self.maingui.library_view.model().refresh_ids(bookids)
                msg = "JS: " + as_unicode(n) + " Books have been updated."
            else:
                msg = "JS: No Matching Pseudonyms Found for any Selected Book."
            self.show_gui_status_bar_qtimer(msg,5000)
            if DEBUG: print(msg)

        del bookids

        self.pseudonym_matching_in_progress = False
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_new_pseudonyms(self,mi_field,custcol,book,real_author_list):
        #Requires a Tag-Like Custom Column, Ampersand Separated, Like Authors, With Names

        if len(real_author_list) > 1:
            real_author_list = list(set(real_author_list))  #no duplicates
            real_author_list.sort()

        real_author_list_string = ""    # unlike the authors standard column, a string is required and not a list...
        for author in real_author_list:
            real_author_list_string = author + "&" + real_author_list_string
        #END FOR
        real_author_list_string = real_author_list_string[0:-1]

        mi = Metadata(_('Unknown'))
        custcol['#value#']  = real_author_list_string
        mi.set_user_metadata(mi_field, custcol)
        id_map = {}
        id_map[book] = mi
        payload = []
        payload.append(book)
        edit_metadata_action = self.maingui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=None)

        if DEBUG: print("book: ", as_unicode(book), "  new value for: ", mi_field, "   is: ", real_author_list_string)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def verify_js_pseudonym_table_exists(self):

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('Author Pseudonyms'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
            return False

        try:
            my_cursor.execute("begin")
            mysql = "CREATE TABLE _js_pseudonyms (pseudonym TEXT NOT NULL , author TEXT NOT NULL, PRIMARY KEY (pseudonym, author));"
            my_cursor.execute (mysql)
            mysql = "CREATE TABLE _js_selected_books (book INTEGER NOT NULL PRIMARY KEY);"
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            is_valid = False  #if does not already exist, just created but still needs to be seeded with default values
        except:
            is_valid = True   #if already exists, SQL error

        if not is_valid:
            is_valid,msg = self.load_js_pseudonym_table(my_db,my_cursor)
            self.show_gui_status_bar_qtimer(msg,5000)
            if DEBUG: print(msg)
        else:
            msg = ""

        my_db.close()

        return is_valid,msg
    #---------------------------------------------------------------------------------------------------------------------------------------
    def load_js_pseudonym_table(self,my_db,my_cursor):

        from calibre_plugins.job_spy.sqlobjects_js_pseudonyms import add_js_pseudonyms

        is_valid,msg = add_js_pseudonyms(my_db,my_cursor,DEBUG)

        del add_js_pseudonyms

        if not is_valid:
            msg = "Table Pseudonyms Creation Seeding Error: "  + msg

        return is_valid,msg
    #---------------------------------------------------------------------------------------------------------------------------------------
    def calculate_similarity(self,a,b):
        #returns the probability that string a is the same as string b
        try:
            p = SequenceMatcher(None, a, b).ratio()
            if p:
                return p
            else:
                return 0.0000
        except:
            return 0.0000
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_table_selected_books(self,my_db,my_cursor,selected_books_list):
        try:
            my_cursor.execute("begin")
            mysql = "INSERT OR IGNORE INTO _js_selected_books (book) VALUES(?)"
            for book in selected_books_list:
                my_cursor.execute(mysql,([book]))
            #END FOR
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print("update_table_selected_books [1]: ", as_unicode(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    def purge_table_selected_books(self,my_db,my_cursor):
        try:
            my_cursor.execute("begin")
            mysql = "DELETE FROM _js_selected_books"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print("purge_table_selected_books: ", as_unicode(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def import_pseudonym_csv_file(self):

        if self.pseudonym_matching_in_progress:
            return

        csv_path = self.choose_csv_file_to_import()
        if not csv_path:
            info_dialog(self.gui, 'Import Canceled','No CSV File was was selected; Execution canceled.').show()
            return

        if DEBUG: print("import csv_path selected by user: ", csv_path)

        pseudonyms_csv_list = self.import_csv_file(csv_path)

        n_added = 0

        initials_mode = prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_INITIALS_MODE']  # T.S. Elliot or T. S. Elliot or T S Elliot  default is T.S. Elliot

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        try:
            my_cursor.execute("begin")
            mysql = "DROP TABLE IF EXISTS _js_pseudonyms"
            my_cursor.execute(mysql)
            mysql = "DROP TABLE IF EXISTS _js_selected_books"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            my_cursor.execute("begin")
            mysql = "CREATE TABLE _js_pseudonyms (pseudonym TEXT NOT NULL , author TEXT NOT NULL, PRIMARY KEY (pseudonym, author));"
            my_cursor.execute (mysql)
            mysql = "CREATE TABLE _js_selected_books (book INTEGER NOT NULL PRIMARY KEY);"
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            my_cursor.execute("begin")
            for row in pseudonyms_csv_list:
                #~ if DEBUG: print("pseudonyms_csv_list row: ", row)
                row = row.replace('" ,','",')          #  must be "," as was exported
                row = row.replace(', "',',"')          #  must be "," as was exported
                s_split = row.split('","')               # split at "," and not  just , due to name formats like  Joe Smith, Jr.
                if not isinstance(s_split,list):
                    if DEBUG: print(">>>>>>>>>error 1: row was not properly formatted to split: ", as_unicode(row))
                    continue
                if len(s_split) != 2:
                    if DEBUG: print(">>>>>>>>>error 2: row was not properly formatted to split: ", as_unicode(row))
                    continue
                pseudonym = s_split[0]
                author = s_split[1]
                pseudonym = pseudonym.replace('"','')
                author = author.replace('"','')
                if pseudonym == author:
                    if DEBUG: print("pseudonym: ", pseudonym, "  author: ", author)
                    continue
                if not pseudonym > " ":
                    if DEBUG: print("pseudonym: ", pseudonym, "  author: ", author)
                    continue
                if not author > " ":
                    if DEBUG: print("pseudonym: ", pseudonym, "  author: ", author)
                    continue
                if pseudonym == "Pseudonym" or author == "Author":
                    if DEBUG: print("pseudonym: ", pseudonym, "  author: ", author)
                    continue
                if pseudonym == "pseudonym" or author == "author":
                    if DEBUG: print("pseudonym: ", pseudonym, "  author: ", author)
                    continue
                pseudonym = self.get_formatted_author_initials(initials_mode,pseudonym)
                author = self.get_formatted_author_initials(initials_mode,author)
                mysql = "INSERT OR IGNORE INTO _js_pseudonyms (pseudonym,author) VALUES (?,?)"
                my_cursor.execute(mysql,(pseudonym,author))
                n_added = n_added + 1
            #END FOR
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print("error importing .csv file and then adding new records: ", as_unicode(e))

        my_db.close()

        del pseudonyms_csv_list

        msg = "JS: Pseudonyms Table was updated with " + as_unicode(n_added) + " row imported from the CSV text file for this Library (only)."
        self.show_gui_status_bar_qtimer(msg,5000)
        if DEBUG: print(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def choose_csv_file_to_import(self):
        default_user_csv_directory = prefs['GUI_TOOLS_AUTHOR_PSEUDONYMS_DEFAULT_CSV_DIRECTORY']
        import_tuple = QFileDialog.getOpenFileName(None,"Import New Pseudonym Table UTF-8 Encoded CSV Text File ",default_user_csv_directory,("Text File (*pseudonym*.txt)") )
        if not import_tuple:
            return None
        path, dummy = import_tuple
        if not path:
            return None
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        if os.path.isfile(path):
            return path
        else:
            return None
    #---------------------------------------------------------------------------------------------------------------------------------------
    def import_csv_file(self,csv_path):
        pseudonyms_csv_list  = []

        if csv_path == unicode_type(""):
            if DEBUG: print("csv_path == unicode_type(""); nothing to do.")
            return pseudonyms_csv_list

        try:
            with open (csv_path,'r') as csvfile:
                lines = csvfile.readlines()
                for line in lines:
                    pseudonyms_csv_list.append(line)
                    if DEBUG: print("raw csv row: ", as_unicode(line))
            #END FOR
            csvfile.close()
            del lines
            del csvfile
            del csv_path
        except Exception as e:
            if DEBUG: print("Import CSV File Error: " + as_unicode(e))
            error_dialog(self.gui, _('Import CSV File Error'),_(e), show=True)

        return pseudonyms_csv_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def export_pseudonym_csv_file(self):
        if self.pseudonym_matching_in_progress:
            return

        is_valid,msg =  self.verify_js_pseudonym_table_exists()
        if not is_valid:
            return error_dialog(self.gui, _('JS Author Pseudonyms'),_(msg), show=True)

        msg = self.do_export_of_pseudonym_table()

        self.show_gui_status_bar_qtimer(msg,5000)
        if DEBUG: print(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def do_export_of_pseudonym_table(self):

        title = "Choose the Directory for the export file' "

        default_user_csv_directory = prefs['GUI_TOOLS_AUTHOR_PSEUDONYMS_DEFAULT_CSV_DIRECTORY']

        chosen_directory_name = QFileDialog.getExistingDirectory(None,title,default_user_csv_directory,QFileDialog.Option.ShowDirsOnly | QFileDialog.Option.DontResolveSymlinks )

        if not chosen_directory_name:
            return

        prefs['GUI_TOOLS_AUTHOR_PSEUDONYMS_DEFAULT_CSV_DIRECTORY'] = chosen_directory_name
        prefs

        head,tail = os.path.split(self.guidb.library_path)
        tail = tail.lower().strip()  # the current calibre library name
        outfilename = "js_pseudonyms_table_exported_from_" + tail + ".txt"    # IMPORTANT:  to guarantee the original UTF-8 encoding is preserved, a .txt is output instead of a .csv so that a text editor is used to open it properly with UTF-8, which does not corrupt it upon opening.  However, it is a comma-separated file.
        outfilename = as_unicode(outfilename)

        del head
        del tail

        export_csv_file_full_path = os.path.join(chosen_directory_name,outfilename)
        export_csv_file_full_path = export_csv_file_full_path.replace(os.sep, '/')

        if DEBUG: print("pseudonyms table export file path is: ", export_csv_file_full_path)

        #~ ------------------------------------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        table_list = []

        mysql = "SELECT pseudonym,author FROM _js_pseudonyms"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        for row in tmp_rows:
            pseudonym,author = row
            if pseudonym:
                if author:
                    if pseudonym != author:
                        if pseudonym > " " and author > " ":
                            table_list.append(row)
        #END FOR
        del tmp_rows

        #~ ------------------------------------------------------------------
        if os.path.isdir(chosen_directory_name):
            try:
                with open(export_csv_file_full_path, 'w') as outfile:
                    for row in table_list:
                        pseudonym,author = row
                        r = unicode_type('"') + pseudonym + unicode_type('"') + unicode_type(',') + unicode_type('"') + author + unicode_type('"') + "\n"
                        #~ if DEBUG: print(pseudonym,author)
                        outfile.write(r)
                    #END FOR
                outfile.close()
                msg = 'The export of the table was successful.<br><br>File path:'+ export_csv_file_full_path + "<br><br>Number of rows exported: " + as_unicode(len(table_list))
                info_dialog(self.gui, 'Export Success',msg).show()
                if DEBUG: print(msg)
                del outfile
            except Exception as e:
                if DEBUG: print("export failure: ", as_unicode(e))
                msg = 'The export of the pseudonym table failed due to: ' + as_unicode(e)
                info_dialog(self.gui, 'Export Failure',msg).show()
                if DEBUG: print(msg)

        #~ ------------------------------------------------------------------
        n = len(table_list)
        msg = as_unicode(n) + " Pseudonyms Exported to: " + as_unicode(export_csv_file_full_path)
        #~ ------------------------------------------------------------------
        del table_list
        del export_csv_file_full_path
        del chosen_directory_name

        return msg
    #---------------------------------------------------------------------------------------------------------------------------------------
    def uninstall_pseudonym_table(self):
        if self.pseudonym_matching_in_progress:
            return

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            return error_dialog(self.gui, _('Author Pseudonyms'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        try:
            my_cursor.execute("begin")
            mysql = "DROP TABLE IF EXISTS _js_pseudonyms"
            my_cursor.execute(mysql)
            mysql = "DROP TABLE IF EXISTS _js_selected_books"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print("uninstall_pseudonym_table: ", as_unicode(e))
        my_db.close()
        msg = "JS: Pseudonyms Table was uninstalled for this Library only.  Reinstallation will be automatic if ever needed."
        self.show_gui_status_bar_qtimer(msg,5000)
        if DEBUG: print(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_arbitrary_file_dialog(self):
        try:
            self.arbitrary_file_dialog.close()
        except:
            pass
        from calibre_plugins.job_spy.arbitrary_file_dialog import ArbitraryFileDialog
        self.arbitrary_file_dialog = ArbitraryFileDialog(self.gui,self.qaction.icon())
        self.arbitrary_file_dialog.setModal(False)
        self.arbitrary_file_dialog.show()
        del ArbitraryFileDialog
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_save_to_directory_by_library(self,source="library_changed"):
        #~ Calibre saves its last-used save-to directory for Windows in file  C:\Users\username\AppData\Roaming\calibre\dynamic.pickle
         #-------------------------------------
        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY'] == unicode_type("False"):
            return
        #-------------------------------------
        from calibre.utils.config_base import tweaks
        if not 'job_spy_save_to_directory' in tweaks:
            del tweaks
            if DEBUG: print("'job_spy_save_to_directory' is NOT a key in tweaks; returning; nothing done...")
            msg = "Error in the Tweak 'job_spy_save_to_directory' in Your Preferences > Tweaks > Plugin Tweaks.<br><br><b>Activated in JS but Tweak is missing.</b><br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_to_directory',msg).show()
        #-------------------------------------
        jsdict = tweaks['job_spy_save_to_directory']
        del tweaks
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                msg = "Error in the Tweak 'job_spy_save_to_directory' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_to_directory',msg).show()
        #----------------
        defaultdir = prefs['GUI_TOOLS_DEFAULT_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY']
        defaultdir = self.standardize_path_format(defaultdir)
        if not os.path.isdir(defaultdir):
            msg = "Error in the Tweak to Save-To Directory: your Default Directory by Library was invalid.<br><br>You should Customize Job Spy preferences for this GUI Tool before proceeding."
            if DEBUG: print(msg)
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_to_directory by Library',msg).show()      #non-modal so does not stop Calibre startup or library switching
        #----------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict:
                newdir = jsdict[libname]
                if DEBUG: print("apply_save_to_directory_by_library:   libname IS tweaked; new directory for: ", libname, "   is: ", newdir)
            else:
                newdir = defaultdir
                if DEBUG: print("apply_save_to_directory_by_library:   libname is NOT tweaked; default directory used for:   ", libname, "   is: ", defaultdir)
        else:
            if DEBUG: print("ERROR in os.path.split(path): ", path, " head: ", as_unicode(head), " libname: ", as_unicode(libname))
            return
        #----------------
        #~ save_to_disk.py         path = choose_dir(self.gui, 'save to disk dialog', _('Choose destination directory'))
        #~                                                                              'save to disk dialog'  is a key in the in dynamic.pickle dict
        #----------------
        from calibre.utils.config import dynamic      #dynamic >>> class DynamicConfig(dict):
        ans = dynamic.get('save to disk dialog',None)
        if DEBUG:
            if not ans:
                ans = "NOTHING FOUND IN DYNAMIC.PICKLE"
            print("Prior value used for 'save to disk dialog' in dynamic.pickle was:  ", as_unicode(ans))

        if not os.path.isdir(newdir):
            newdir = defaultdir
            msg = "Your customized value in Tweaks for this Library is NOT a valid directory. Your customized default directory was used instead: " + defaultdir
            if DEBUG: print(msg)
            info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_to_directory by Library',msg).show()      #non-modal so does not stop Calibre startup or library switching

        if newdir:
            newdir = newdir.replace("/",os.sep)   #the path saved to dynamic.pickle must have the Windows "\", and not  "/"
            dynamic.set('save to disk dialog',newdir)  #does a commit automatically via cPickle.dumps and f.write
            if DEBUG: print("New Save-To Directory for Library:  ",newdir)

        del dynamic
        del jsdict
        del path
        del newdir
        del ans
        del head
        del libname
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_save_to_template_by_library(self,source=None):
        #~ Calibre saves its save_to_template_history for Windows in file  C:\Users\username\AppData\Roaming\calibre\gui.py

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] == unicode_type("False"):
            if DEBUG: print("--->>>prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] = False; nothing to do; returning.")
            return

        defaulttemplate = prefs['GUI_TOOLS_DEFAULT_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY']

        if DEBUG: print("--->>>default template is: ", defaulttemplate)

        #-------------------------------------
        from calibre.utils.config_base import tweaks
        if not 'job_spy_save_to_template' in tweaks:
            del tweaks
            if DEBUG: print("--->>>'job_spy_save_to_template' is NOT a key in tweaks; returning; nothing done...")
            msg = "Error in the Tweak 'job_spy_save_to_template' in Your Preferences > Tweaks > Plugin Tweaks.<br><br><b>Activated in JS but Tweak is missing.</b><br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_to_template',msg).show()
        #-------------------------------------
        jsdict = tweaks['job_spy_save_to_template']
        del tweaks
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("--->>>jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                msg = "Error in the Tweak 'job_spy_save_to_template' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_to_template',msg).show()
        #----------------
        #----------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict:
                newtemplate = jsdict[libname]
                if DEBUG: print("--->>>apply_save_to_template_by_library:   libname IS tweaked; new template for: ", libname, "   is: ", newtemplate)
            else:
                newtemplate = defaulttemplate
                if DEBUG: print("--->>>apply_save_to_template_by_library:   libname is NOT tweaked; default template used for:   ", libname, "   is: ", defaulttemplate)
        else:
            if DEBUG: print("--->>>ERROR in os.path.split(path): ", path, " head: ", as_unicode(head), " libname: ", as_unicode(libname))
            return
        #----------------
        from calibre.utils.config import Config, StringConfig
        from calibre.gui2.preferences import save_template
        from calibre.library.save_to_disk import DEFAULT_TEMPLATE, DEFAULT_SEND_TEMPLATE, FORMAT_ARGS, config
        c = config(None)
        c.set('template',newtemplate)
        if DEBUG: print("--->>> job_spy_save_to_template was used to set this library's template to: ", newtemplate)

        del c
        del head
        del libname
        del path
        del jsdict
        del defaulttemplate
        del newtemplate
        del Config
        del StringConfig
        del config
        del save_template
        del DEFAULT_TEMPLATE
        del DEFAULT_SEND_TEMPLATE
        del FORMAT_ARGS
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_save_cover_separately_option_by_library(self,source=None):
        #~ Calibre saves its save_cover separately option for Windows in file  C:\Users\username\AppData\Roaming\calibre\save_to_disk.py.json

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_COVER_SEPARATELY_BY_LIBRARY'] == unicode_type("False"):
            return

        default_value = True

        if DEBUG: print("--->>>job_spy_save_cover_separately default value is: ", default_value)

        #-------------------------------------
        from calibre.utils.config_base import tweaks
        if not 'job_spy_save_cover_separately' in tweaks:
            del tweaks
            if DEBUG: print("--->>>'job_spy_save_cover_separately' is NOT a key in tweaks; returning; nothing done...")
            msg = "Error in the Tweak 'job_spy_save_cover_separately' in Your Preferences > Tweaks > Plugin Tweaks.<br><br><b>Activated in JS but Tweak is missing.</b><br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_cover_separately',msg).show()
        #-------------------------------------
        jsdict = tweaks['job_spy_save_cover_separately']
        del tweaks
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("--->>>jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                msg = "Error in the Tweak 'job_spy_save_cover_separately' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_cover_separately',msg).show()
        #----------------
        #----------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict:
                new_value = jsdict[libname]
                if new_value == unicode_type("True"):
                    new_value = True
                else:
                    new_value = False
                if DEBUG: print("--->>>apply_save_cover_separately_by_library:   libname IS tweaked; new value for: ", libname, "   is: ", new_value)
            else:
                new_value = default_value
                if DEBUG: print("--->>>apply_save_cover_separately_by_library:   libname is NOT tweaked; default value used for:   ", libname, "   is: ", default_value)
        else:
            if DEBUG: print("--->>>ERROR in os.path.split(path): ", path, " head: ", as_unicode(head), " libname: ", as_unicode(libname))
            return
        #----------------
        from calibre.utils.config import Config, StringConfig
        from calibre.gui2.preferences import save_template
        from calibre.library.save_to_disk import DEFAULT_TEMPLATE, DEFAULT_SEND_TEMPLATE, FORMAT_ARGS, config
        c = config(None)
        c.set('save_cover',new_value)
        if DEBUG: print("--->>> job_spy_save_cover_separately was used to set this library's value to: ", new_value)

        del c
        del head
        del libname
        del path
        del jsdict
        del default_value
        del new_value
        del Config
        del StringConfig
        del config
        del save_template
        del DEFAULT_TEMPLATE
        del DEFAULT_SEND_TEMPLATE
        del FORMAT_ARGS
            #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_save_metadata_in_opf_file_option_by_library(self,source=None):
       #~ Calibre saves its save_metadata_in_opf_file option for Windows in file  C:\Users\username\AppData\Roaming\calibre\save_to_disk.py.json as   "write_opf": false/true

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_METADATA_IN_OPF_FILE_BY_LIBRARY'] == unicode_type("False"):
            return

        default_value = True

        if DEBUG: print("--->>>job_spy_save_metadata_in_opf_file default value is: ", default_value)

        #-------------------------------------
        from calibre.utils.config_base import tweaks
        if not 'job_spy_save_metadata_in_opf_file' in tweaks:
            del tweaks
            if DEBUG: print("--->>>'job_spy_save_metadata_in_opf_file' is NOT a key in tweaks; returning; nothing done...")
            msg = "Error in the Tweak 'job_spy_save_metadata_in_opf_file' in Your Preferences > Tweaks > Plugin Tweaks.<br><br><b>Activated in JS but Tweak is missing.</b><br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_metadata_in_opf_file',msg).show()
        #-------------------------------------
        jsdict = tweaks['job_spy_save_metadata_in_opf_file']
        del tweaks
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("--->>>jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                msg = "Error in the Tweak 'job_spy_save_metadata_in_opf_file' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_metadata_in_opf_file',msg).show()
        #----------------
        #----------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict:
                new_value = jsdict[libname]
                if new_value == unicode_type("True"):
                    new_value = True
                else:
                    new_value = False
                if DEBUG: print("--->>>apply_save_metadata_in_opf_file_by_library:   libname IS tweaked; new value for: ", libname, "   is: ", new_value)
            else:
                new_value = default_value
                if DEBUG: print("--->>>apply_save_metadata_in_opf_file_by_library:   libname is NOT tweaked; default value used for:   ", libname, "   is: ", default_value)
        else:
            if DEBUG: print("--->>>ERROR in os.path.split(path): ", path, " head: ", as_unicode(head), " libname: ", as_unicode(libname))
            return
        #----------------
        from calibre.utils.config import Config, StringConfig
        from calibre.gui2.preferences import save_template
        from calibre.library.save_to_disk import DEFAULT_TEMPLATE, DEFAULT_SEND_TEMPLATE, FORMAT_ARGS, config
        c = config(None)
        c.set('write_opf',new_value)
        if DEBUG: print("--->>> job_spy_save_metadata_in_opf_file was used to set this library's value to: ", new_value)

        del c
        del head
        del libname
        del path
        del jsdict
        del default_value
        del new_value
        del Config
        del StringConfig
        del config
        del save_template
        del DEFAULT_TEMPLATE
        del DEFAULT_SEND_TEMPLATE
        del FORMAT_ARGS
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_default_output_format_option_by_library(self,source=None):

        if not prefs['GUI_TOOLS_ACTIVATE_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY'] == unicode_type("True"):
            return
        #-------------------------------------
        js_default_default = prefs['GUI_TOOLS_DEFAULT_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY']
        if not js_default_default > " ":
            return
        #-------------------------------------
        from calibre.utils.config_base import tweaks
        if not 'job_spy_default_output_format' in tweaks:
            del tweaks
            if DEBUG: print("--->>>'job_spy_default_output_format' is NOT a key in tweaks; returning; nothing done...")
            msg = "Error in the Tweak 'job_spy_default_output_format' in Your Preferences > Tweaks > Plugin Tweaks.<br><br><b>Activated in JS but Tweak is missing.</b><br><br>You should recustomize Job Spy Tweaks and Preferences > Behavior for this GUI Tool before proceeding."
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_default_output_format',msg).show()
        #-------------------------------------
        jsdict = tweaks['job_spy_default_output_format']
        del tweaks
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("--->>>jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                msg = "Error in the Tweak 'job_spy_default_output_format' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_default_output_format',msg).show()
        #-------------------------------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict:
                new_format = jsdict[libname]
                if DEBUG: print("--->>>job_spy_default_output_format_by_library:   libname IS tweaked; new value for: ", libname, "   is: ", new_format.lower())
            else:
                new_format = js_default_default
                if DEBUG: print("--->>>job_spy_default_output_format_by_library:   libname is NOT tweaked; default value used for:   ", libname, "   is: ", new_format)
        else:
            if DEBUG: print("--->>>ERROR in os.path.split(path): ", path, " head: ", as_unicode(head), " libname: ", as_unicode(libname))
            return
        #-------------------------------------
        from calibre.utils.config import prefs as mainprefs
        if DEBUG: old_format = mainprefs.get('output_format')
        mainprefs.set('output_format', new_format.lower())
        if DEBUG: new_format = mainprefs.get('output_format')
        if DEBUG: print("--->>> job spy tweak was used to set this library's default output format from: ", old_format, "   to: ", new_format)
        del mainprefs
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_title_series_sorting_by_library(self,source=None):
        default_value = 'library_order'
        valid_values = ['library_order','strictly_alphabetic']      #  'library_order'  OR   'strictly_alphabetic'

        from calibre.utils.config_base import tweaks
        if not 'title_series_sorting' in tweaks:
            tweaks['title_series_sorting'] = default_value
            if DEBUG: print("tweak for 'title_series_sorting' was missing; temporarily set to Calibre default value of:  'library_order' ")
            return
        else:
            current_tweak = tweaks['title_series_sorting']
            if DEBUG: print("current  tweaks['title_series_sorting']: ", as_unicode(current_tweak))
        #----------------
        if not 'job_spy_title_series_sorting' in tweaks:
            del tweaks
            if DEBUG: print("Error in JS Customizing for Per-Library Tweak for 'job_spy_title_series_sorting':  Activated but NO Preferences > Tweaks > Plugins > customization for this JS Tweak.")
            return
        #----------------
        jsdict = tweaks['job_spy_title_series_sorting']
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("--->>>jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                del tweaks
                msg = "Error in the Tweak 'job_spy_title_series_sorting' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_title_series_sorting',msg).show()
        #----------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict:
                new_value = jsdict[libname]
                if new_value in valid_values:
                    pass
                else:
                    if DEBUG: print("--->>>apply_title_series_sorting_by_library: INVALID value used in Preferences > Tweaks: ", new_value)
                    new_value = default_value
                if DEBUG: print("--->>>apply_title_series_sorting_by_library:   libname IS tweaked; new value for: ", libname, "   is: ", new_value)
            else:
                new_value = default_value
                if DEBUG: print("--->>>apply_title_series_sorting_by_library:   libname is NOT tweaked; default value used for:   ", libname, "   is: ", default_value)
        else:
            if DEBUG: print("--->>>ERROR in os.path.split(path): ", path, " head: ", as_unicode(head), " libname: ", as_unicode(libname))
            return

        tweaks['title_series_sorting'] = new_value  # in-memory only; this will not be written to tweaks.py.  The user must use Preferences > Tweaks properly to make permanent changes.
        if DEBUG: print("title_series_sorting changed FROM: ",current_tweak, " TO: ", new_value)

        del tweaks
        del jsdict
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_metadata_edit_custom_column_order_by_library(self,source=None):
        #~ job_spy_metadata_edit_custom_column_order = {u'CalibreJobSpyTest1': [u'#genre', u'#ddc', u'#lcc']}
        default_tweak = prefs['GUI_TOOLS_DEFAULT_TWEAK_METADATA_EDIT_CUSTOM_COLUMN_ORDER_BY_LIBRARY']
        default_value = '[]'

        from calibre.utils.config_base import tweaks
        if not 'metadata_edit_custom_column_order' in tweaks:
            tweaks['metadata_edit_custom_column_order'] = default_value
            if DEBUG: print("tweak for 'metadata_edit_custom_column_order' was missing; temporarily set to Calibre default value of:  '[]' ")
            return
        else:
            current_tweak = tweaks['metadata_edit_custom_column_order']
            if DEBUG: print("current  tweaks['metadata_edit_custom_column_order'']: ", as_unicode(current_tweak))
        #----------------
        if not 'job_spy_metadata_edit_custom_column_order' in tweaks:
            del tweaks
            if DEBUG: print("Error in JS Customizing for Per-Library Tweak for 'job_spy_metadata_edit_custom_column_order':  Activated but NO Preferences > Tweaks > Plugins > customization for this JS Tweak.")
            return
        #----------------
        jsdict = tweaks['job_spy_metadata_edit_custom_column_order']
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("--->>>jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                del tweaks
                msg = "Error in the Tweak 'job_spy_metadata_edit_custom_column_order' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_metadata_edit_custom_column_order',msg).show()
        #----------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict:
                new_value = jsdict[libname]       #{u'CalibreJobSpyTest1': [u'#genre', u'#ddc', u'#lcc']}
                if not isinstance(new_value,list):
                    new_value,isvalid = self.convert_string_to_list(new_value)
                    if not isvalid:
                        new_value = default_value
                        if DEBUG: print("--->>>apply_metadata_edit_custom_column_order_by_library:   libname's tweak value is NOT a valid 'List'; default value used for:   ", libname, "   is: ", default_value)
            else:
                new_value = default_value
                if DEBUG: print("--->>>apply_metadata_edit_custom_column_order_by_library:   libname is NOT tweaked; default value used for:   ", libname, "   is: ", default_value)
        else:
            if DEBUG: print("--->>>ERROR in os.path.split(path): ", path, " head: ", as_unicode(head), " libname: ", as_unicode(libname))
            return

        tweaks['metadata_edit_custom_column_order'] = new_value  # in-memory only; this will not be written to tweaks.py.  The user must use Preferences > Tweaks properly to make permanent changes.
        if DEBUG: print("metadata_edit_custom_column_order changed FROM: ",current_tweak, " TO: ", new_value)

        del tweaks
        del jsdict
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_tag_browser_category_order_by_library(self,source=None):
        #~ job_spy_tag_browser_category_order_assignment = { 'CalibreJobSpyTest1': 'A', 'CalibreJobSpyTest2': 'B', 'CalibreJobSpyTest3': 'C' }
        #~ job_spy_tag_browser_category_order_definition = { 'A': {'languages': 1 ,'*': 2 }, 'B': {'series': 1, '*': 2}, 'C': {'#genre': 1, '*': 2}  }

        default_value = {'*': 1}   # tag_browser_category_order = {u'*': 1}

        from calibre.utils.config_base import tweaks
        if not 'tag_browser_category_order' in tweaks:
            tweaks['tag_browser_category_order'] = default_value
            if DEBUG: print("tweak for 'tag_browser_category_order' was missing; temporarily set to Calibre default value of:  '{'*': 1}' ")
            return
        else:
            current_tweak = tweaks['tag_browser_category_order']
            if DEBUG: print("current  tweaks['tag_browser_category_order'']: ", as_unicode(current_tweak))
        #----------------
        if (not 'job_spy_tag_browser_category_order_assignment' in tweaks) or (not 'job_spy_tag_browser_category_order_definition' in tweaks):
            del tweaks
            if DEBUG: print("Error in JS Customizing for Per-Library Tweak for 'job_spy_tag_browser_category_order':  Activated but NO Preferences > Tweaks > Plugins > customization for this JS Tweak.")
            return
        #----------------
        jsdict = tweaks['job_spy_tag_browser_category_order_assignment']
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("--->>>jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                del tweaks
                msg = "Error[1] in the Tweak 'job_spy_tag_browser_category_order' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_tag_browser_category_order',msg).show()
        jsdict_assignment = jsdict
        del jsdict
        #----------------
        jsdict = tweaks['job_spy_tag_browser_category_order_definition']
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("--->>>jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                del tweaks
                msg = "Error[2] in the Tweak 'job_spy_tag_browser_category_order' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_tag_browser_category_order',msg).show()
        jsdict_definition = jsdict
        del jsdict
        #----------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict_assignment:
                assignment = jsdict_assignment[libname]   # { 'CalibreJobSpyTest1': 'A', 'CalibreJobSpyTest2': 'B', 'CalibreJobSpyTest3': 'C' }
                if assignment in jsdict_definition:
                    new_value = jsdict_definition[assignment]    #  { 'A': {'languages': 1 ,'*': 2 }, 'B': {'series': 1, '*': 2}, 'C': {'#genre': 1, '*': 2}  }
                    if not isinstance(new_value,dict):
                        new_value = default_value
                        if DEBUG: print("--->>>[1] apply_tag_browser_category_order_by_library:   libname's tweak value is NOT a valid 'List'; default value used for:   ", libname)
                else:
                    new_value = default_value
                    if DEBUG: print("--->>>[2] apply_tag_browser_category_order_by_library:   libname is NOT tweaked; default value used for:   ", libname)
            else:
                new_value = default_value
                if DEBUG: print("--->>>[3] apply_tag_browser_category_order_by_library:   libname is NOT tweaked; default value used for:   ", libname)
        else:
            if DEBUG: print("--->>>ERROR in os.path.split(path): ", path, " head: ", as_unicode(head), " libname: ", as_unicode(libname))
            return

        if not isinstance(new_value,dict):
            new_value = default_value
            if DEBUG: print("--->>>[4] apply_tag_browser_category_order_by_library:   ERROR[4] in tweak; default value used for:   ", libname)
        elif len(new_value) == 0:
            new_value = default_value
            if DEBUG: print("--->>>[5] apply_tag_browser_category_order_by_library:   ERROR[5] in tweak; default value used for:   ", libname)
        else:
            try:
                for k,v in iteritems(new_value):
                    if not isinstance(v,int):
                        new_value = default_value
                        if DEBUG: print("--->>>[6] apply_tag_browser_category_order_by_library:   ERROR[6] in tweak; default value used for:   ", libname)
                        break
                    elif isinstance(k,int):
                        new_value = default_value
                        if DEBUG: print("--->>>[7] apply_tag_browser_category_order_by_library:   ERROR[7] in tweak; default value used for:   ", libname)
                        break
            except Exception as e:
                new_value = default_value
                if DEBUG: print("--->>>[8] apply_tag_browser_category_order_by_library:   ERROR[8] in tweak; default value used for:   ", libname, "  Error: ", as_unicode(e))

        tweaks['tag_browser_category_order'] = new_value  # in-memory only; this will not be written to tweaks.py.

        self.maingui.tags_view.recount()  #causes this tweak's value-change to be reflected in the GUI...otherwise, everything above is fruitless...tags_view is created before plugins are even initialized...

        if DEBUG: print("tag_browser_category_order changed FROM: ", as_unicode(current_tweak), " TO: ", as_unicode(new_value))

        del tweaks
        del new_value
        del current_tweak
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_job_spy_json_backup_file(self):

        dir = prefs['JOB_SPY_JSON_FILE_BACKUP_DIRECTORY']
        title = "Select Directory Where 'Job Spy Customization Backup.json' Should Be Saved"
        dir = QFileDialog.getExistingDirectory(None,title,dir,QFileDialog.Option.ShowDirsOnly | QFileDialog.Option.DontResolveSymlinks )

        if not dir:
            return

        if not os.path.isdir(dir):
            return

        path = dir

        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')

        prefs['JOB_SPY_JSON_FILE_BACKUP_DIRECTORY'] = path
        prefs

        fmt = "%Y-%m-%d_%H-%M-%S     "
        t = as_unicode(time.strftime(fmt,time.gmtime(time.time())))   #~ 2018-03-10_13-06-26
        t = t[0:19]

        fname = "Job Spy Backup " + t + ".json"

        path = os.path.join(path, fname)
        dst = path.replace(os.sep, '/')

        path = self.plugin_path
        path = path.replace(".zip",".json")
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        src = path.replace(os.sep, '/')
        if not os.path.isfile(src):
            msg = "ERROR: Job Spy.json Back Up: Source File Not Found:" + src
            if DEBUG: print(msg)
            error_dialog(self.gui, _('JS+ .JSON File Back-Up'),_(msg), show=True)
        else:
            if DEBUG: print("Job Spy.json Back Up: ", src, "  >>>  ", dst)
            import shutil
            shutil.copy(src,dst)
            del shutil
            msg = "Job Spy.json file backed up to: " + dst
            info_dialog(self.gui, 'JS+ .JSON File Back-Up',msg).show()
        del path
        del src
        del dst
        del msg
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_tagbrowser_custom_icons(self):
        self.tv = self.maingui.tags_view
        self.tvm = self.tv._model
        #~ --------------------------------------------------------------------
        self.state_map_dict = {}
        self.category_list = []
        #~ --------------------------------------------------------------------
        expanded_categories, state_map = self.tv.get_state()
        for category,values in iteritems(state_map):
            if category.startswith("@") or category.startswith("#"):
                self.state_map_dict[category] = values
                self.category_list.append(category)
        #END FOR
        del expanded_categories
        del state_map
        self.category_list.sort()
        #~ --------------------------------------------------------------------
        self.ifc_dict = {}
        #~ --------------------------------------------------------------------
        for category,values in iteritems(self.state_map_dict):
            ifc = self.tvm.index_for_category(category)
            if ifc:
                self.ifc_dict[category] = ifc
                #~ if DEBUG: print("category: ", as_unicode(category), "  values: ", as_unicode(values))
        #END FOR
        #~ --------------------------------------------------------------------
        self.ifc_named_path_dict = {}
        #~ --------------------------------------------------------------------
        for category,ifc in iteritems(self.ifc_dict):
            named_path = self.tvm.named_path_for_index(ifc)
            if ifc:
                self.ifc_named_path_dict[ifc] = named_path
        #END FOR
        #~ --------------------------------------------------------------------
        #~ self.index_named_path_dict = {}
        self.index_category_dict = {}
        #~ --------------------------------------------------------------------
        for category in self.category_list:
            if category in self.ifc_dict:  #sub-categories are ignored...
                ifc = self.ifc_dict[category]
                named_path = self.ifc_named_path_dict[ifc]                             #[u'@MyColors:MyColors']
                index = self.tvm.index_for_named_path(named_path)             #<qt.coreCore.QModelIndex object at 0x0000027BD66AD198>
                if index.isValid():
                    self.index_category_dict[category] = index
        #END FOR
        #~ --------------------------------------------------------------------
        self.source_default_icon_dict = {}
        #~ --------------------------------------------------------------------
        self.apply_custom_icons_control()
        #~ --------------------------------------------------------------------
        del self.state_map_dict
        del self.category_list
        del self.ifc_dict
        del self.ifc_named_path_dict
        del self.index_category_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_custom_icons_control(self):

        source_dict = {}

        for category in self.category_list:
            self.current_category = category
            if self.current_category.startswith("@"):
                self.is_ampersand_uc = True
            else:
                self.is_ampersand_uc = False

            if self.is_ampersand_uc:
                use_source_dict = True
                dummy, state_map = self.tv.get_state()
                if self.current_category in state_map:              #~ state_map:  @MyColors >>> {(u'black', u'#mytaglike'): 0, (u'yellow', u'#mytaglike'): 0, (u'blue', u'#mytaglike'): 0, (u'green', u'#mytaglike'): 0}
                    v_dict = state_map[self.current_category]
                    k_list = []
                    #~ for k,v in v_dict.iteritems():
                    for k,v in iteritems(v_dict):
                        k_list = list(k)
                        value = k_list[0]
                        source = k_list[1]
                        source_dict[value] = source                         #~ source:  #real_authors   value:  Julia Pottinger
                        if source.startswith("#"):
                            if source in self.custom_columns_metadata_dict:
                                data_dict = self.custom_columns_metadata_dict[source]
                                is_names = "is_names': True"
                                if is_names in as_unicode(data_dict):                    #~ if DEBUG: print(as_unicode(data_dict))      # 'display': {u'is_names': True
                                    authors_list = []
                                    authors_list.append(value)                    #already == string_to_authors(authors_string)
                                    author_sort = self.guidb.new_api.author_sort_from_authors(authors_list, key_func=lambda x: x)
                                    source_dict[author_sort] = source        #~ source:  #real_authors   value of values' author-sort:  Pottinger, Julia    #author sort option:    invert
                                    author_sort = author_sort.replace(", "," ")
                                    source_dict[author_sort] = source        #~ source:  #real_authors   value of values' author-sort:  Pottinger Julia     #author sort option:    no comma
                                    source_dict[value] = source                 #~ source:  #real_authors   value of values' author-sort:   Julia Pottinger     #author sort option:    copy as-is
                                    del authors_list
                                    #~ if DEBUG: print("source: ", as_unicode(source), "  value of values' author-sort: ", as_unicode(author_sort))
                                else:
                                    pass
                                del data_dict
                                dummy = self.get_source_default_icon_file(source)  #builds dict too
                            else:
                                if DEBUG: print("Source Custom Column is NOT in self.custom_columns_metadata_dict......Error: ", source)
                        else:
                            pass
                    #END FOR
                    del v_dict
                    del k_list
                else:
                    pass
                del state_map
                del dummy
            else:
                use_source_dict = False
                cc_source = self.current_category
                dummy = self.get_source_default_icon_file(cc_source)  #builds dict too

            #~ -----------------------

            if self.current_category in self.index_category_dict:
                index = self.index_category_dict[self.current_category]
                for r in range(self.tvm.rowCount(index)):
                    child = index.child(r, 0)
                    value = self.tvm.data(child,role=Qt.DisplayRole)
                    if use_source_dict:
                        if value in source_dict:
                            source = source_dict[value]
                        else:
                            if DEBUG: print("UNKNOWN ERROR:   value not in source_dict: ", value, "      ...likely a non-standard author-sort value for an is-names source...")
                            source = "UNKNOWN ERROR"
                    else:
                        source = cc_source
                    new_icon_file = self.get_already_assigned_icon_file_for_value(source,value)
                    if new_icon_file:
                        new_icon = self.create_icon_image_from_file_path(new_icon_file)
                        isvalid = self.tvm.js_change_child_icon(self,self.tvm,child,new_icon,role=Qt.DecorationRole)  #  #~ a monkeypatched generic version of setData to set the value for the decoration role data...........
                        if isvalid:
                            data = self.tvm.data(child,role=Qt.DecorationRole)
                            #~ if DEBUG: print("NEW decoration data for source: ", as_unicode(source), "  value: ", as_unicode(value), "   data: ", as_unicode(data))
                    else:
                        pass
                #END FOR
            else:
                if DEBUG: print("===>>>Skipping an entire category since index was NOT valid: ", self.current_category)
        #END FOR

        del source_dict

        self.tv.repaint()
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_decoration_to_tagbrowser(self):
        #~ ---------------------
        jobspyaction = self.restore_treeitem_icons_after_recount
        from calibre_plugins.job_spy.decorated_functions import decorated_tags_view_recount
        decorated_tags_view_recount = decorated_tags_view_recount(self.maingui.tags_view.recount,jobspyaction)
        self.maingui.tags_view.recount = decorated_tags_view_recount
        #~ ---------------------
        self.monkey_patch_tagsviewmodel(self.maingui.tags_view._model)
   #---------------------------------------------------------------------------------------------------------------------------------------
    def monkey_patch_tagsviewmodel(self,tvm):
        def js_change_child_icon(self,tvm,child,new_icon,role=Qt.DecorationRole):
            try:
                node = tvm.get_node(child)
                node.icon_state_map[0] = new_icon               #TagTreeItem.icon_state_map[0] =new_icon
                return True
            except Exception as e:
                if DEBUG: print("js_change_child_icon Exception: ", as_unicode(e))
                return False
        #~ -------------------------------------
        tvm.js_change_child_icon = js_change_child_icon
   #---------------------------------------------------------------------------------------------------------------------------------------
    def restore_treeitem_icons_after_recount(self,object=None):  #None is for pyqtsignals that emit something, such as self.maingui.drag_drop_finished (a pyqtsignal, not a function) that was created to handle an object...
        self.apply_tagbrowser_custom_icons()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_tagbrowser_recount_delayed(self):
        QTimer.singleShot(100, self.apply_tagbrowser_custom_icons)                 # milliseconds
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ensure_icon_directory_exists(self):
        #~ also used by tagbrowser_icons_dialog.py
        dir = os.path.join(config_dir,'plugins')
        dir =  os.path.join(dir, 'tagbrowser_icons')
        if not os.path.exists(dir):
            os.makedirs(dir)
            if DEBUG: print("directory created: ", dir)
        self.tagbrowser_icon_file_dir = dir
    #-----------------------------------------------------
    #-----------------------------------------------------
    def get_already_assigned_icon_file_for_value(self,source,value):
        #~ also used by tagbrowser_icons_dialog.py
        icon_file_key = self.create_icon_file_key(source,value)
        icon_file = self.get_icon_file_name_for_current_value(icon_file_key)
        if os.path.isfile(icon_file):
            return icon_file
        else:
            if source in self.source_default_icon_dict:
                icon_file = self.source_default_icon_dict[source]
                return icon_file
            else:
                return None
    #-----------------------------------------------------
    #-----------------------------------------------------
    def create_icon_file_key(self,source,value):
        #~ also used by tagbrowser_icons_dialog.py
        icon_file_key = "_" + source + "_" + value + "_"
        icon_file_key = sanitize_file_name_unicode(icon_file_key)
        return icon_file_key
    #-----------------------------------------------------
    #-----------------------------------------------------
    def create_icon_image_from_file_path(self,path,type="icon"):
        #~ also used by tagbrowser_icons_dialog.py
        path = path.replace(os.sep,"/")
        #~ if DEBUG: print("create_icon_image_from_file_path", type, "  ", path)
        if type == "icon":
            p = QIcon(path).pixmap(QSize(20, 20))  # same size as TagBrowser uses...
            icon_image = QIcon(p)                            # QIcon object
            del p
        elif type == "pixmap":
            icon_image = QIcon(path).pixmap(QSize(20, 20))  # QPixMap object
            icon_image.save(path,format = 'PNG',quality = -1)
        else:
            icon_image = None
        return icon_image
    #-----------------------------------------------------
    #-----------------------------------------------------
    def get_icon_file_name_for_current_value(self,icon_file_key):
        #~ also used by tagbrowser_icons_dialog.py
        fname = icon_file_key + ".png"
        icon_file = os.path.join(self.tagbrowser_icon_file_dir,fname)
        icon_file = icon_file.replace(os.sep, '/')
        return icon_file
    #-----------------------------------------------------
    #-----------------------------------------------------
    #-----------------------------------------------------
    def get_source_default_icon_file(self,source):
        value = "default"
        self.source_default_icon_dict[source] = None
        icon_file_key = self.create_icon_file_key(source,value)
        icon_file = self.get_icon_file_name_for_current_value(icon_file_key)
        if icon_file:
            if os.path.isfile(icon_file):
                pixmap = self.create_pixmap_from_icon_file(icon_file)
                if pixmap:
                    self.source_default_icon_dict[source] = icon_file
                    return icon_file
                else:
                    return None
        else:
            return None
    #-----------------------------------------------------
    #-----------------------------------------------------
    def create_pixmap_from_icon_file(self,icon_file):
        pixmap = None
        icon_image = self.create_icon_image_from_file_path(icon_file)
        sizes = icon_image.availableSizes()
        if sizes:
            if len(sizes) == 0:
                pixmap = self.create_icon_image_from_file_path(icon_file,type="pixmap")
            else:
                pixmap = icon_image.pixmap(icon_image.availableSizes()[0])
        else:
            pixmap = self.create_icon_image_from_file_path(icon_file,type="pixmap")
        del icon_image
        del sizes
        return pixmap
    #-----------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def customize_tag_browser_icons(self):
        try:
            self.tagbrowsericonsdialog.close()
        except:
            pass

        nothingfound = get_pixmap('images/nothing_found.png')
        filenotfound = get_pixmap('images/filenotfound.png')

        from calibre_plugins.job_spy.tagbrowser_icons_dialog import TagBrowserIconsDialog
        self.tagbrowsericonsdialog = TagBrowserIconsDialog(None,self.maingui,nothingfound,filenotfound,self.tagbrowser_icon_tool_is_running)
        self.tagbrowsericonsdialog.setModal(False)
        self.tagbrowsericonsdialog.show()

        del TagBrowserIconsDialog
        del nothingfound
        del filenotfound
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def remove_identifier_types_tool(self):
        try:
            self.remove_id_types_dialog.close()
        except:
            pass

        from calibre_plugins.job_spy.remove_id_types_dialog import RemoveIdTypesDialog
        self.remove_id_types_dialog = RemoveIdTypesDialog(None,self.maingui,self.restart_remove_id_types_dialog)

        del RemoveIdTypesDialog
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def restart_remove_id_types_dialog(self):
        self.remove_identifier_types_tool()
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def tag_scrubbing_scrub_tag_metadata_using_ruleset(self):

        msg = "Scrub Tags: Starting..."
        self.gui.status_bar.show_message(_(msg), 10000)

        self.tags_changed_audit_list = []

        ruleset,ok = self.ts_select_scrubbing_rules_to_implement()
        if not ok:
            return

        self.ts_install_tag_rules_tables()

        self.scope_target = None
        OPTIMAL_SEQUENCE = "All Tag Rules Tables in Optimal Sequence"

        if ruleset == OPTIMAL_SEQUENCE:
            self.ts_scrub_tag_metadata_using_ruleset(TAG_SPLITTING_RULES,scope='optimal')
            self.ts_scrub_tag_metadata_using_ruleset(TAG_CAPITALIZATION_RULES,scope='optimal')
            self.ts_scrub_tag_metadata_using_ruleset(TAG_STRING_REPLACEMENT_RULES,scope='optimal')
            self.ts_scrub_tag_metadata_using_ruleset(TAG_RULES,scope='optimal')
            self.ts_scrub_tag_metadata_using_ruleset(TAG_COMBINATION_RULES,scope='optimal')
            self.ts_scrub_tag_metadata_using_ruleset(TAG_PREFIX_SUFFIX_RULES,scope='optimal')
        else:
            self.ts_scrub_tag_metadata_using_ruleset(ruleset,scope='single')
       #---------------------------------
        msg = ""
        for row in self.tags_changed_audit_list:
            value1,value2,value3 = row
            value1 = value1.replace("---","")
            value2 = value2.replace("---","")
            msg = msg + unicode_type(value1) + " " + unicode_type(value2) + " " + unicode_type(value3) + "\n"
        #END FOR
        msg = msg + "..............................................................................................................................................................................\n"
        del self.tags_changed_audit_list
       #---------------------------------
        icon = get_icon(PLUGIN_ICONS[0])
        from calibre_plugins.job_spy.generic_log_viewer_dialog import GenericLogViewerDialog
        self.log_viewer = GenericLogViewerDialog(icon,"Scrub Tags Audit Log",msg)
        self.log_viewer.setAttribute(Qt.WA_DeleteOnClose )
        del GenericLogViewerDialog
        del icon
        del msg
       #---------------------------------
        QApplication.instance().processEvents()  #required so the standard Calibre progress dialog for updating metadata finishes and closes...
       #---------------------------------
        msg = "Scrub Tags: Completed. See Audit Log."
        self.gui.status_bar.show_message(_(msg), 20000)
       #---------------------------------
        self.ts_refresh_cache_all_book_ids()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def tag_scrubbing_export_tag_rules_tables_csv_files(self):
        self.tags_changed_audit_list = []
        table,ok = self.ts_get_desired_rules_table_name()
        if not ok:
            return
        self.ts_install_tag_rules_tables()
        self.ts_export_tag_rules_tables_csv_files(table)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def tag_scrubbing_import_tag_rules_tables_csv_files(self):
        self.tags_changed_audit_list = []
        table,ok = self.ts_get_desired_rules_table_name()
        if not ok:
            return
        self.ts_install_tag_rules_tables()
        ok = self.ts_import_tag_rules_tables_csv_files(table)
        if not ok:
            error_dialog(self.gui, 'Import Canceled','No CSV File was was selected or Specified Rules Table Could Not Be Updated with CSV Data.').show()
        else:
            info_dialog(self.gui, 'Import Success','Specified Rules Table Was Updated with CSV Data.').show()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def tag_scrubbing_uninstall_tag_rules_tables(self):
        self.tags_changed_audit_list = []
        table,ok = self.ts_get_desired_rules_table_name()
        if not ok:
            return
        self.ts_uninstall_tag_rules_tables()
        msg = "Tag Scrubbing Rules Tables have been uninstalled"
        self.gui.status_bar.show_message(_(msg), 10000)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_get_desired_rules_table_name(self):
        title = "Rules Table Selection"
        label = "Choose Tag/Tag-Like Rules Table:"
        items = []
        items.append("_js_tag_splitting_rules")
        items.append("_js_tag_capitalization_rules")
        items.append("_js_tag_combination_rules")
        items.append("_js_tag_rules")
        items.append("_js_tag_string_replacement_rules")
        items.append("_js_tag_prefix_suffix_rules")
        table,ok = QInputDialog.getItem(None, title, label, items,0,False)
        #~ if DEBUG: print("Selected:  ", table)
        if not ok:
            table = None
            return table,False
        else:
            return table,True
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_select_scrubbing_rules_to_implement(self):
        title = "Rules to Execute"
        label = "Choose Rules to Execute  (Sequence is Important):"
        OPTIMAL_SEQUENCE = "All Tag Rules Tables in Optimal Sequence"
        items = []
        items.append(OPTIMAL_SEQUENCE)
        items.append(TAG_SPLITTING_RULES)
        items.append(TAG_CAPITALIZATION_RULES)
        items.append(TAG_STRING_REPLACEMENT_RULES)
        items.append(TAG_RULES)
        items.append(TAG_COMBINATION_RULES)
        items.append(TAG_PREFIX_SUFFIX_RULES)
        ruleset,ok = QInputDialog.getItem(None, title, label, items,0,False)
        #~ if DEBUG: print("Selected:  ", ruleset)
        if not ok:
            ruleset = None
            return ruleset,False
        else:
            msg = "Choose Rules to Execute  (Sequence is Important): ",ruleset," "
            self.tags_changed_audit_list.append(msg)
            msg = "","",""
            self.tags_changed_audit_list.append(msg)
            return ruleset,True
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_select_tag_column_to_scrub(self):
        EVERYTHING = "Scrub: All Tags & Tag-Like Custom Columns"
        self.ts_get_custom_column_technical_details()
        title = "Tag Column Selection"
        lbl = "Choose Tag/Tag-Like Column:"
        items = []
        items.append(EVERYTHING)
        items.append("Scrub: Tags")
        for label in self.ts_current_custom_columns_list:
            id,_label,name,datatype,display,is_multiple,normalized = self.custom_columns_label_dict[label]
            if datatype == "text":
                if is_multiple == 1:
                    if normalized == 1:
                        if not as_unicode('"is_names": true') in as_unicode(display):  #   & separated Authors-Like Tags
                            items.append("Scrub: " + label)
        #END FOR
        self.ts_tag_columns_list = items
        column,ok = QInputDialog.getItem(None, title, lbl, items,0,False)
        #~ if DEBUG: print("Selected:  ", column)
        del items
        if not ok:
            column = None
            return column,False
        else:
            for row in self.ts_tag_columns_list:
                msg = "Tag/Tag-Like Column Available to be chosen:  ",row,"  "
                self.tags_changed_audit_list.append(msg)
            #END FOR
            msg = "","",""
            self.tags_changed_audit_list.append(msg)
            msg = "Choose Tag/Tag-Like Column:  ",column," "
            self.tags_changed_audit_list.append(msg)
            return column,True
     #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_scrub_tag_metadata_using_ruleset(self,ruleset,scope=None):

        EVERYTHING = "Scrub: All Tags & Tag-Like Custom Columns"

        if scope == "single":
            target,ok = self.ts_select_tag_column_to_scrub()
            if not ok:
                return
        elif scope == "optimal":
            if self.scope_target is None:
                target,ok = self.ts_select_tag_column_to_scrub()
                if not ok:
                    return
                self.scope_target = target   # avoid asking for the target for every loop of the scope.
            else:
                target = self.scope_target
        else:
            return

        if target == EVERYTHING:
            for column in self.ts_tag_columns_list:
                if column == EVERYTHING:
                    continue
                s_split = column.split("Scrub:")
                for row in s_split:
                    row = row.strip()
                    if not row > " ":
                        continue
                    elif row == "Tags":
                        self.ts_apply_rulesets(ruleset,"Tags")
                    elif row.startswith("#"):
                        self.ts_apply_rulesets(ruleset,row)
                    else:
                        continue
            #END FOR
        else:
            target = target.replace("Scrub:","")
            target = target.strip()
            if target == "Tags":
                self.ts_apply_rulesets(ruleset,"tags")
            elif target.startswith("#"):
                self.ts_apply_rulesets(ruleset,target)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_apply_rulesets(self,ruleset,target):
        msg = "","",""
        self.tags_changed_audit_list.append(msg)
        msg = ".......................................................................................","",""
        self.tags_changed_audit_list.append(msg)
        msg = "Applying ruleset:  ",ruleset,"   for: " + target
        self.tags_changed_audit_list.append(msg)
        msg = "Applying ruleset:  " + ruleset + "   for: " + target
        self.gui.status_bar.show_message(_(msg), 10000)

        if target == "tags" or target == "Tags":
            label_dict_tuple = None
        else:
            label_dict_tuple = self.custom_columns_label_dict[target]   #  id,label,name,datatype,display,is_multiple_normalized = self.custom_columns_label_dict[label]

        table1,table2 = self.ts_build_target_table_names(target,label_dict_tuple)

        self.ts_create_special_views_for_selected_table(table1,table2)

        self.ts_build_target_tags_name_book_id_dicts(table1,table2)

        self.ts_get_ruleset_table_data(ruleset)

        #~ -------- in best sequence *if* restricted to one single pass -----------
        if ruleset == TAG_SPLITTING_RULES:
            self.ts_apply_tag_splitting_rules(target,table1,table2)
        elif ruleset == TAG_CAPITALIZATION_RULES:
            self.ts_apply_tag_capitalization_rules(table1,table2)
        elif ruleset == TAG_RULES:
            self.ts_apply_tag_rules(table1,table2)
        elif ruleset == TAG_STRING_REPLACEMENT_RULES:
            self.ts_apply_tag_string_replacement_rules(table1,table2)
        elif ruleset == TAG_COMBINATION_RULES:
            self.ts_apply_tag_combination_rules(table1,table2)
        elif ruleset == TAG_PREFIX_SUFFIX_RULES:
            self.ts_apply_tag_prefix_suffix_rules(table1,table2)

        del label_dict_tuple
        del ruleset
        del target
        del table1
        del table2
        del self.ts_target_tags_name_id_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_build_target_table_names(self,target,label_dict_tuple):
        if target == "tags" or target == "Tags":
            table1 = "tags"
            table2 = "books_tags_link"
        else:
            table1 = "custom_column_[NN]"
            table2 = "books_custom_column_[NN]_link"
            id,label,name,datatype,display,is_multiple,normalized = label_dict_tuple
            table1 = table1.replace("[NN]",as_unicode(id))
            table2 = table2.replace("[NN]",as_unicode(id))
        del label_dict_tuple
        #~ if DEBUG: print("target table names:  table1, table2: ", table1, "  ", table2)

        msg = "Target Tables to be scrubbed:  ",table1,"  " + table2
        self.tags_changed_audit_list.append(msg)

        return table1,table2
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_apply_tag_capitalization_rules(self,table1,table2):
        msg = "","",""
        self.tags_changed_audit_list.append(msg)
        msg = "Tag Capitalization Rules Being Applied to:  ",table1,"  " + table2
        self.tags_changed_audit_list.append(msg)
        msg = "Tag Capitalization Rules Being Applied"
        self.gui.status_bar.show_message(_(msg), 10000)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #---------------------------------
        all_target_tags_dict = self.ts_get_all_target_tags_simple(my_db, my_cursor,table1)
        #---------------------------------
        new_tag_dict = {}
        #~ for k,v in all_target_tags_dict.iteritems():       # all_target_tags_dict[name] = id
        for k,v in iteritems(all_target_tags_dict):       # all_target_tags_dict[name] = id
            tmp_tag = self.ts_apply_tag_capitalization_rules_to_single_tag(k)
            new_tag_dict[v] = tmp_tag                        # new_tag_dict[id] = name
        #END FOR
        #---------------------------------
        if table1 == "tags":
            mysql = "UPDATE tags SET name = ? WHERE id = ?"
        else:
            mysql = "UPDATE [TAGS] SET [NAME] = ? WHERE id = ?"
            mysql = mysql.replace("[TAGS]",table1)
            mysql = mysql.replace("[NAME]","value")

        my_cursor.execute("begin")
        #~ for k,v in new_tag_dict.iteritems():        # new_tag_dict[id] = name
        for k,v in iteritems(new_tag_dict):        # new_tag_dict[id] = name
            my_cursor.execute(mysql,(v,k))
        #END FOR
        my_cursor.execute("commit")
        #---------------------------------
        msg = "Tag Capitalization Rules Applied to: ",as_unicode(len(new_tag_dict))," tags in:  " + table1
        self.tags_changed_audit_list.append(msg)
        #---------------------------------
        del self.tag_capitalization_regex_rules_list
        del new_tag_dict
        del all_target_tags_dict
        #---------------------------------
        my_db.close()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_build_regex_list_from_tag_capitalization_rules(self,my_db, my_cursor):

        self.tag_capitalization_regex_rules_list = []

        mysql = "SELECT regex,rule,priority FROM _js_tag_capitalization_rules WHERE regex NOT NULL \
                        AND rule NOT NULL AND priority NOT NULL  AND regex NOT LIKE '%,%'   "
        my_cursor.execute(mysql)
        tmp_rule_list = my_cursor.fetchall()
        if not tmp_rule_list:
              return
        else:
            if len(tmp_rule_list) == 0:
                self.tag_capitalization_regex_rules_list.append(as_unicode("^DELETE$"))
                return
            else:
                for item in tmp_rule_list:
                    regex, rule, priority = item
                    s1 = as_unicode(regex)
                    s2 = as_unicode(rule)
                    s3 = as_unicode(priority)
                    s3 = as_unicode("000" + as_unicode(s3))
                    s3 = as_unicode(s3[-3: ])
                    new_row = as_unicode(as_unicode(s3) + "<|!!|>" + as_unicode(s1) + "<|!!|>" + as_unicode(s2))        #priority is first for sorting
                    self.tag_capitalization_regex_rules_list.append(as_unicode(new_row))
                #END FOR

        self.tag_capitalization_regex_rules_list.sort(reverse=True)    #sort by priority descending

        msg = "","",""
        self.tags_changed_audit_list.append(msg)
        n = len(self.tag_capitalization_regex_rules_list)
        msg = "Number of Tag Capitalization Rules: ",as_unicode(n),""
        self.tags_changed_audit_list.append(msg)
    #-------------------------------------------------------------------------------------------------------------------------------
    def ts_apply_tag_capitalization_rules_to_single_tag(self,tmp_tag):
        for row in self.tag_capitalization_regex_rules_list:
            rule_list = row.split("<|!!|>")  #     row ==   priority<|!!|>regex<|!!|>rule
            priority = as_unicode(rule_list[0])
            re1 = as_unicode(rule_list[1])
            rule = as_unicode(rule_list[2])
            try:
                p1 = re.compile(re1, re.IGNORECASE)
                match1 = p1.search(tmp_tag)
                if match1:
                    if as_unicode(rule) == as_unicode("titlecase"):
                        tmp_tag = re.sub(re1, self.ts_do_titlecase, tmp_tag, count=0, flags=re.IGNORECASE)
                        continue
                    else:
                        if as_unicode(rule) == as_unicode("uppercase"):
                            tmp_tag = re.sub(re1, self.ts_do_uppercase, tmp_tag, count=0, flags=re.IGNORECASE)
                            continue
                        else:
                            if as_unicode(rule) == as_unicode("lowercase"):
                                tmp_tag = re.sub(re1, self.ts_do_lowercase, tmp_tag, count=0, flags=re.IGNORECASE)
                                continue
                            else:
                                if as_unicode(rule) == as_unicode("delete"):
                                    tmp_tag = re.sub(re1, self.ts_do_delete, tmp_tag, count=0, flags=re.IGNORECASE)
                                    continue
                                else:
                                    if as_unicode(rule) == as_unicode("addspace_left"):
                                        tmp_tag = re.sub(re1, self.ts_do_addspace_left, tmp_tag, count=0, flags=re.IGNORECASE)
                                        continue
                                    else:
                                        if as_unicode(rule) == as_unicode("addspace_right"):
                                            tmp_tag = re.sub(re1, self.ts_do_addspace_right, tmp_tag, count=0, flags=re.IGNORECASE)
                                            continue
                                        else:
                                            continue
                else:
                    continue
            except Exception as e:
                try:
                    msg = "Tag Capitalization REGEX Rule Exception:  ",as_unicode(re1)," for:  " + as_unicode(tmp_tag) + " Exception: " + as_unicode(e)
                    self.tags_changed_audit_list.append(msg)
                except:
                    pass
                continue
        #END FOR
        return tmp_tag
    #-------------------------------------------------------------------------------------------------------------------------------
    def ts_do_titlecase(self,matchobj):
        s = ""
        if matchobj.group(0):
            s = matchobj.group(0)
            #if DEBUG: print("s was (0): ", as_unicode(s))
        s = s.title()
        #if DEBUG: print("s is now: " + as_unicode(s))
        return s
    #-------------------------------------------------------------------------------------------------------------------------------
    def ts_do_uppercase(self,matchobj):
        s = ""
        if matchobj.group(0):
            s = matchobj.group(0)
            #if DEBUG: print("s was (0): ", as_unicode(s))
        s = s.upper()
        #if DEBUG: print("s is now: " + as_unicode(s))
        return s
    #-------------------------------------------------------------------------------------------------------------------------------
    def ts_do_lowercase(self,matchobj):
        s = ""
        if matchobj.group(0):
            s = matchobj.group(0)
            #if DEBUG: print("s was (0): ", as_unicode(s))
        s = s.lower()
        #if DEBUG: print("s is now: " + as_unicode(s))
        return s
    #-------------------------------------------------------------------------------------------------------------------------------
    def ts_do_delete(self,matchobj):
        s = ""
        #if DEBUG: print("s is now: " + as_unicode(s))
        return s
    #-------------------------------------------------------------------------------------------------------------------------------
    def ts_do_addspace_left(self,matchobj):
        s = ""
        if matchobj.group(0):
            s = matchobj.group(0)
            #if DEBUG: print("s was (0): ", as_unicode(s))
        s = " " + s
        #if DEBUG: print("s is now: " + as_unicode(s))
        return s
    #-------------------------------------------------------------------------------------------------------------------------------
    def ts_do_addspace_right(self,matchobj):
        s = ""
        if matchobj.group(0):
            s = matchobj.group(0)
            #if DEBUG: print("s was (0): ", as_unicode(s))
        s =  s + " "
        #if DEBUG: print("s is now: " + as_unicode(s))
        return s
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_get_all_target_tags_simple(self,my_db, my_cursor,table1):
        import collections
        all_target_tags_dict = collections.OrderedDict([])
        del collections
        #---------------------------------
        if table1 == "tags":
            mysql = "SELECT id,name from tags ORDER BY name ASC"
        else:
            mysql = "SELECT id,[NAME] from [TAGS] ORDER BY [NAME] ASC"
            mysql = mysql.replace("[NAME]","value")
            mysql = mysql.replace("[TAGS]",table1)

        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
       #---------------------------------
        if not tmp_rows:
            pass
        else:
            for row in tmp_rows:
                id,name = row
                all_target_tags_dict[name] = id
            #END FOR
            del tmp_rows
       #---------------------------------
        return all_target_tags_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_apply_tag_string_replacement_rules(self,table1,table2):
        msg = "","",""
        self.tags_changed_audit_list.append(msg)
        msg = "Tag String Replacement Rules Being Applied to:  ",table1,"  " + table2
        self.tags_changed_audit_list.append(msg)
        msg = "Tag String Replacement Rules Being Applied"
        self.gui.status_bar.show_message(_(msg), 10000)

        if table1 == "tags":
            mysql1  = "INSERT OR IGNORE INTO tags (id,name) VALUES(null,?)"       # string does NOT have to be a full, whole tag, but temporarily assume it is...
            mysql2  = "INSERT OR IGNORE INTO tags (id,name) VALUES(null,?)"       # full, whole tag may or may not already exist in tags...
            mysql3  = "UPDATE tags SET name = ? WHERE name = ? AND ? NOT IN(SELECT name FROM tags WHERE name = ?) "       # if there were already a tag with name==new_name, would error out.
            mysql4  = "INSERT OR IGNORE INTO books_tags_link (id,book,tag) VALUES(null,?,(SELECT id FROM tags WHERE name = ?) )"
            mysql5a = "DELETE FROM books_tags_link WHERE books_tags_link.tag IN(SELECT id FROM tags WHERE tags.name = ? )"
            mysql5b = "DELETE FROM tags WHERE tags.name = ?  "
            mysql6  = "DELETE FROM tags WHERE id NOT IN(SELECT tag FROM books_tags_link WHERE books_tags_link.tag = tags.id) "
        else:
            mysql1 = "INSERT OR IGNORE INTO [TAGS] (id,value) VALUES (null,?) "    # string does NOT have to be a full, whole tag, but temporarily assume it is...
            mysql1 = mysql1.replace("[TAGS]",table1)

            mysql2  = "INSERT OR IGNORE INTO [TAGS] (id,value) VALUES(null,?)"       # full, whole tag may or may not already exist in tags...
            mysql2 = mysql2.replace("[TAGS]",table1)

            mysql3  = "UPDATE [TAGS] SET value = ? WHERE value = ? AND ? NOT IN(SELECT value FROM [TAGS] WHERE value = ?) "       # if there were already a tag with name==new_name, would error out.
            mysql3 = mysql3.replace("[TAGS]",table1)

            mysql4  = "INSERT OR IGNORE INTO [BOOKS_TAGS_LINK] (id,book,value) VALUES(null,?,(SELECT id FROM [TAGS] WHERE value = ?) )"
            mysql4 = mysql4.replace("[BOOKS_TAGS_LINK]",table2)
            mysql4 = mysql4.replace("[TAGS]",table1)

            mysql5a = "DELETE FROM [BOOKS_TAGS_LINK] WHERE [BOOKS_TAGS_LINK].value IN(SELECT id FROM [TAGS] WHERE value = ?)"
            mysql5a = mysql5a.replace("[BOOKS_TAGS_LINK]",table2)
            mysql5a = mysql5a.replace("[TAGS]",table1)

            mysql5b = "DELETE FROM [TAGS] WHERE [TAGS].value = ?  "
            mysql5b = mysql5b.replace("[TAGS]",table1)

            mysql6  = "DELETE FROM [TAGS] WHERE id NOT IN(SELECT value FROM [BOOKS_TAGS_LINK] WHERE [BOOKS_TAGS_LINK].value = [TAGS].id) "
            mysql6 = mysql6.replace("[TAGS]",table1)
            mysql6 = mysql6.replace("[BOOKS_TAGS_LINK]",table2)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        old_name_list = []
        new_name_list = []

        mysql0 = "SELECT book,tag,oldstring,newstring FROM __js_tag_string_replacement_rules_by_tag"
        my_cursor.execute(mysql0)
        tmp_list = my_cursor.fetchall()
        if not tmp_list:
            tmp_list = []

        msg = "Tag String Replacement for table:  ",table1,"   Number of Book-Tag-Oldstring-Newstring Combinations Processed: " + as_unicode(len(tmp_list))
        self.tags_changed_audit_list.append(msg)

        for row in tmp_list:
            book,old_name,old_string,new_string = row
            new_name = old_name.replace(old_string,new_string)
            new_name = new_name.strip()
            new_name_list.append(new_name)
            old_name = old_name.strip()
            old_name_list.append(old_name)
            #---------------------------------
            try:
                #~ # string does NOT have to be a full, whole tag, but temporarily assume it is...
                my_cursor.execute("begin")
                my_cursor.execute(mysql1,([new_string]))  #~ #mysql1 = "INSERT OR IGNORE INTO tags (id,name) VALUES(null,?)"
                my_cursor.execute("commit")
            except Exception as e:
                if DEBUG: print("[1]: ", as_unicode(e))
                try:
                    my_cursor.execute("commit")
                except:
                    pass

            try:
                #~ # full, whole tag may or may not already exist in tags...
                my_cursor.execute("begin")
                my_cursor.execute(mysql2,([new_name]))  #~ #mysql2 = "INSERT OR IGNORE INTO tags (id,name) VALUES(null,?)"
                my_cursor.execute("commit")
            except Exception as e:
                if DEBUG: print("[2]: ", as_unicode(e))
                try:
                    my_cursor.execute("commit")
                except:
                    pass

            try:
                #~ # if there were already a tag with name==new_name, would error out.
                my_cursor.execute("begin")
                my_cursor.execute(mysql3,(new_name,old_name,new_name,new_name))   #~ #mysql3 = "UPDATE tags SET name = ? WHERE name = ? AND ? NOT IN(SELECT name FROM tags WHERE name = ?) "
                my_cursor.execute("commit")
            except Exception as e:
                if DEBUG: print("[3]: ", as_unicode(e))
                try:
                    my_cursor.execute("commit")
                except:
                    pass

            try:
                #~ # if the new_name already existed before the old_name was changed to the new_name, then the books with the old_name need to be linked to the new_name and not the old_name...
                my_cursor.execute("begin")
                my_cursor.execute(mysql4,(book,new_name))   #~ #mysql4 = "INSERT OR IGNORE INTO books_tags_link (id,book,tag) VALUES(null,?,(SELECT id FROM tags WHERE name = ?) )"
                my_cursor.execute("commit")
            except Exception as e:
                if DEBUG: print("[4]: ", as_unicode(e))
                try:
                    my_cursor.execute("commit")
                except:
                    pass
        #END FOR
        del tmp_list

        try:
            my_cursor.execute("commit")
        except:
            pass

        old_name_set = set(old_name_list)   # no duplicates
        del old_name_list
        new_name_set = set(new_name_list)
        del new_name_list

        for old_name in old_name_set:
            if old_name in new_name_set:
                continue  # do not delete it...
            try:
                #~ # the old_name should no longer be linked to any books...which would occur if the new_name previously had ever existed simultaneously with the old_name as different tags...
                my_cursor.execute("begin")
                my_cursor.execute(mysql5a,([old_name]))  #~ #mysql5a = "DELETE FROM books_tags_link WHERE books_tags_link.tag IN(SELECT id FROM tags WHERE tags.name = ? )"
                my_cursor.execute(mysql5b,([old_name]))  #~ #mysql5b = "DELETE FROM tags WHERE tags.name = ?  "
                my_cursor.execute("commit")
            except Exception as e:
                if DEBUG: print("[5]: ", as_unicode(e))
                try:
                    my_cursor.execute("commit")
                except:
                    pass
        #END FOR

        del old_name_set
        del new_name_set

        try:
            #~ # finally, delete any unused (orphan) tags that might have been temporarily created above due to theoretical assumptions...
            my_cursor.execute("begin")
            my_cursor.execute(mysql6)  #~ #mysql6 = "DELETE FROM tags WHERE id NOT IN(SELECT tag FROM books_tags_link WHERE books_tags_link.tag = tags.id) "
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print("[6]: ", as_unicode(e))
            try:
                my_cursor.execute("commit")
            except:
                pass
        #---------------------------------
        my_db.close()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_apply_tag_combination_rules(self,table1,table2):
        msg = "","",""
        self.tags_changed_audit_list.append(msg)
        msg = "Tag Combination Rules Being Applied to:  ",table1,"  " + table2
        self.tags_changed_audit_list.append(msg)
        msg = "Tag Combination Rules Being Applied"
        self.gui.status_bar.show_message(_(msg), 10000)
      #---------------------------------
        all_target_tag_combination_rules_list = []
        all_target_tags_by_book_concat_list = []
        candidate_book_newtag_list = []
        candidate_newtag_list = []
       #---------------------------------
        msg = "Number of Tag Combination Rules: ",as_unicode(len(self.ts_tag_combination_rules_list)),""
        self.tags_changed_audit_list.append(msg)
       #---------------------------------
        for row in self.ts_tag_combination_rules_list:          # tag_keyword_1,tag_keyword_2,tag_keyword_3,newtag = row
            a,b,c,d = row
            try:
                a = a.lower()
                b = b.lower()
                c = c.lower()
                d = d.lower()
            except:
                pass
            newrow = a,b,c,d
            all_target_tag_combination_rules_list.append(newrow)
        #END FOR
        #---------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #---------------------------------
        if len(all_target_tag_combination_rules_list) > 0:
            mysql = "SELECT book,tagsconcat FROM __js_tags_by_book_concatenate"
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
           #---------------------------------
            if not tmp_rows:
                msg = "No Combination Tags to be Created Were Found: "," [1] "," for: " + table1
                self.tags_changed_audit_list.append(msg)
            else:
                for row in tmp_rows:
                    book,tagsconcat = row
                    book = int(book)
                    try:
                        s = tagsconcat.lower()
                    except:
                        s = tagsconcat
                    s = s.strip()
                    s = s.replace("  "," ")
                    s = s.replace(", ",",")
                    newrow = book,s
                    all_target_tags_by_book_concat_list.append(newrow)
                    #~ if DEBUG: print("all_target_tags_by_book_concat_list.append  ", as_unicode(newrow))
                #END FOR
                del tmp_rows
                #---------------------------------
                if len(all_target_tags_by_book_concat_list) == 0:
                    msg = "No Combination Tags to be Created Were Found: "," [2] "," for: " + table1
                    self.tags_changed_audit_list.append(msg)
                else:
                    for row in all_target_tags_by_book_concat_list:  #   12345     Español,Fiction:Fantasy,Fiction:Mysteries&Detectives,Fiction:Science
                        book, tagsconcat = row
                        tagsconcat = tagsconcat.strip()
                        for rule in all_target_tag_combination_rules_list:
                            tag_keyword_1,tag_keyword_2,tag_keyword_3,newtag = rule
                            newtag = newtag.strip()
                            s1 = "," + newtag + ","
                            s2 = newtag + ","
                            s3 = "," + newtag
                            if tagsconcat.count(s1) == 0:
                                if not tagsconcat.startswith(s2):
                                    if not tagsconcat.endswith(s3):      # tagsconcat does not already contain the new tag to add, newtag.
                                        if tagsconcat.count(tag_keyword_1) > 0:
                                            if tagsconcat.count(tag_keyword_2) > 0:
                                                if tagsconcat.count(tag_keyword_3) > 0 or tag_keyword_3 == "none":
                                                    book = int(book)
                                                    s = book,newtag
                                                    candidate_book_newtag_list.append(s)
                                                    candidate_newtag_list.append(newtag)
                                                    #~ msg = "New Combination Tag to be Created: ",newtag,"   for: " + table1
                                                    #~ self.tags_changed_audit_list.append(msg)
                                                else:
                                                    continue
                                            else:
                                                continue
                                        else:
                                            continue
                                    else:
                                        continue
                                else:
                                    continue
                            else:
                                continue
                        #END FOR
                    #END FOR
        #---------------------------------
        if len(candidate_book_newtag_list) > 0:
            candidate_newtag_set = set(candidate_newtag_list)  # no duplicates
            msg = "Tag Combination Rules: New Tags Created: ",as_unicode(len(candidate_newtag_set)),"   for: " + table1
            self.tags_changed_audit_list.append(msg)

            if table1 == "tags":
                mysql = "INSERT OR IGNORE INTO tags (id,name) VALUES (null,?) "
            else:
                mysql = "INSERT OR IGNORE INTO [TAGS] (id,[NAME]) VALUES (null,?) "
                mysql = mysql.replace("[TAGS]",table1)
                mysql = mysql.replace("[NAME]","value")
            my_cursor.execute("begin")
            for newtag in candidate_newtag_set:
                #~ if DEBUG: print("newtag to be added to tags: ", newtag)
                msg = "Tag Combination Rules: NewTag to be added: ",newtag,"   to: " + table1
                self.tags_changed_audit_list.append(msg)
                my_cursor.execute(mysql,([newtag]))
            #END FOR
            my_cursor.execute("commit")
            del candidate_newtag_set
            msg = "Tag Combination Rules: Book/NewTag Combinations Added: ",as_unicode(len(candidate_book_newtag_list)),"   for: " + table2
            self.tags_changed_audit_list.append(msg)
            if table1 == "tags":
                mysql = "INSERT OR IGNORE INTO books_tags_link (id,book,tag) VALUES (null,?,(SELECT id FROM tags WHERE name = ?) ) "
            else:
                mysql = "INSERT OR IGNORE INTO [BOOKS_TAGS_LINK] (id,book,[TAG]) VALUES (null,?,(SELECT id FROM [TAGS] WHERE [NAME] = ?) ) "
                mysql = mysql.replace("[BOOKS_TAGS_LINK]",table2)
                mysql = mysql.replace("[TAG]","value")
                mysql = mysql.replace("[TAGS]",table1)
                mysql = mysql.replace("[NAME]","value")
            my_cursor.execute("begin")
            for row in candidate_book_newtag_list:
                book,newtag = row
                #~ if DEBUG: print("book,newtag to be added to books_tags_link: ", as_unicode(book), as_unicode(newtag))
                my_cursor.execute(mysql,(book,newtag))
            #END FOR
            my_cursor.execute("commit")
        else:
            #~ if DEBUG: print("[5] empty candidate_book_newtag_list........")
            msg = "Tag Combination Rules: No Book/NewTag Combinations Created; nothing to do. ","","   for: " + table2
            self.tags_changed_audit_list.append(msg)
       #---------------------------------
        del all_target_tag_combination_rules_list
        del all_target_tags_by_book_concat_list
        del candidate_book_newtag_list
        del candidate_newtag_list
        #---------------------------------
        #---------------------------------
        my_db.close()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_apply_tag_rules(self,table1,table2):
        self.ts_apply_tag_rules_purge(table1,table2)
        self.ts_apply_tag_rules_change(table1,table2)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_apply_tag_rules_purge(self,table1,table2):
        #~ self.ts_tag_rules_list = []  # oldtag,newtag,purgetag = row
        #~ self.ts_target_tags_name_id_dict = {}   # name = id

        msg = "","",""
        self.tags_changed_audit_list.append(msg)
        msg = "Tag Purge Rules Being Applied to:  ",table1,"  " + table2
        self.tags_changed_audit_list.append(msg)
        msg = "Tag Purge Rules Being Applied"
        self.gui.status_bar.show_message(_(msg), 10000)

        tag_regex_rules_list = []
        tag_simple_rules_list = []

        for row in self.ts_tag_rules_list:
            oldtag,newtag,purgetag = row
            purgetag = int(purgetag)
            if purgetag != 1:
                continue
            if oldtag.startswith("/"):
                oldtag = oldtag[1: ]
                if oldtag.endswith("/"):
                    oldtag = oldtag[0:-1]
                tag_regex_rules_list.append(oldtag)
                #~ if DEBUG: print("self.ts_tag_rules_list - purge - regex: ",as_unicode(oldtag))
            else:
                tag_simple_rules_list.append(oldtag)
                #~ if DEBUG: print("self.ts_tag_rules_list - purge - simple: ",as_unicode(oldtag))
        #END FOR

        tag_regex_rules_list.sort()
        tag_simple_rules_set = set(tag_simple_rules_list)
        tag_ids_to_delete_list = []

        #~ for name,id in self.ts_target_tags_name_id_dict.iteritems():
        for name,id in iteritems(self.ts_target_tags_name_id_dict):
            su = name.upper()
            sl = name.lower()
            st = name.title()
            if (name in tag_simple_rules_set) or (su in tag_simple_rules_set) or (sl in tag_simple_rules_set) or (st in tag_simple_rules_set):    #simple match, not a regex
                tag_ids_to_delete_list.append(id)
                #~ if DEBUG: print("id to delete - simple: ", as_unicode(id))
                msg = "Tag Purge Rules: ","","simple tag to purge match: " + name
                self.tags_changed_audit_list.append(msg)
                continue
            for oldtag in tag_regex_rules_list:
                try:
                    p = re.compile(oldtag, re.IGNORECASE)
                    match = p.search(name)
                    if match:
                        tag_ids_to_delete_list.append(id)
                        #~ if DEBUG: print("id to delete - regex: ", as_unicode(id))
                        msg = "Tag Purge Rules: ","","regex tag to purge match: " + oldtag + " " + name
                        self.tags_changed_audit_list.append(msg)
                        del match
                        break
                except Exception as e:
                    #~ if DEBUG: print("Tag Purge Rule REGEX Compile Error: ", as_unicode(oldtag), as_unicode(e))
                    msg = "Tag Purge Rule REGEX Compile Error: ","as_unicode(oldtag)",as_unicode(e)
                    self.tags_changed_audit_list.append(msg)
                    continue
            #END FOR
        #END FOR

        del tag_regex_rules_list
        del tag_simple_rules_set

        if len(tag_ids_to_delete_list) == 0:
            del tag_ids_to_delete_list
            #~ if DEBUG: print("no tag ids to delete; returning")
            msg = "Scrub Tags: Purged:   0   for: " + table1,"",""
            self.tags_changed_audit_list.append(msg)
            return
       #---------------------------------
        mysql1 = "DELETE FROM " + table1 + " WHERE id = ? "

        if table1 == "tags":
            mysql2 = "DELETE FROM books_tags_link WHERE tag = ? "
        elif table1.startswith("custom_column"):
            mysql2 = "DELETE FROM " + table2 + " WHERE value = ? "
        else:
            return

        #~ if DEBUG: print("mysql1: ", mysql1, "  mysql2: ", mysql2)
       #---------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        my_cursor.execute("begin")
        for id in tag_ids_to_delete_list:
            #~ if DEBUG: print("deleting tag id: ", as_unicode(id))
            my_cursor.execute(mysql2,([id]))
            my_cursor.execute(mysql1,([id]))
        #END FOR
        my_cursor.execute("commit")
        my_db.close()
        del tag_ids_to_delete_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_apply_tag_rules_change(self,table1,table2):
        #~ self.ts_tag_rules_list = []  # oldtag,newtag,purgetag = row
        #~ self.ts_target_tags_name_id_dict = {}   # name = id
        #~ self.ts_target_tags_id_name_dict = {}   # id = name

        msg = "","",""
        self.tags_changed_audit_list.append(msg)
        msg = "Tag Change Rules Being Applied to:  ",table1,"  " + table2
        self.tags_changed_audit_list.append(msg)
        msg = "Tag Change Rules Being Applied"
        self.gui.status_bar.show_message(_(msg), 10000)
        msg = "","",""
        self.tags_changed_audit_list.append(msg)

        tag_regex_rules_dict = {}    # oldtag = newtag
        tag_simple_rules_dict = {}  # oldtag = newtag

        for row in self.ts_tag_rules_list:
            #~ if DEBUG: print("self.ts_tag_rules_list: ", as_unicode(row))
            oldtag,newtag,purgetag = row
            purgetag = int(purgetag)
            if purgetag != 0:
                continue
            if oldtag.startswith("/"):
                oldtag = oldtag[1: ]
                if oldtag.endswith("/"):
                    oldtag = oldtag[0:-1]
                tag_regex_rules_dict[oldtag] = newtag
                #~ if DEBUG: print("tag_regex_rules_dict[oldtag] = newtag :", oldtag, " ", newtag)
            else:
                if oldtag.lower() == newtag.lower():
                    if DEBUG: print("Tag Rule was ignored (rule attempts to change a Tag to itself): ", oldtag, " ", newtag)
                    continue
                tag_simple_rules_dict[oldtag] = newtag
                if DEBUG: print("tag_simple_rules_dict[oldtag] = newtag :", oldtag, " ", newtag)
        #END FOR

        tags_to_change_dict = {}

        #~ for name,id in self.ts_target_tags_name_id_dict.iteritems():
        for name,id in iteritems(self.ts_target_tags_name_id_dict):
            su = name.upper()
            sl = name.lower()
            st = name.title()
            if (name in tag_simple_rules_dict):
                newtag = tag_simple_rules_dict[name]
                tags_to_change_dict[name] = newtag
                continue
            elif (su in tag_simple_rules_dict):
                newtag = tag_simple_rules_dict[su]
                tags_to_change_dict[name] = newtag
                continue
            elif (sl in tag_simple_rules_dict):
                newtag = tag_simple_rules_dict[sl]
                tags_to_change_dict[name] = newtag
                continue
            elif (st in tag_simple_rules_dict):
                newtag = tag_simple_rules_dict[st]
                tags_to_change_dict[name] = newtag
                continue
            else:
                #~ for oldtag,newtag in tag_regex_rules_dict.iteritems():
                for oldtag,newtag in iteritems(tag_regex_rules_dict):
                    try:
                        p = re.compile(oldtag, re.IGNORECASE)
                        match = p.search(name)
                        if match:
                            tags_to_change_dict[name] = newtag
                            break
                    except Exception as e:
                        #~ if DEBUG: print("Tag Change Rule REGEX Compile Error: ", as_unicode(oldtag), as_unicode(e))
                        r = "Tag Change Rule REGEX Compile Error: ",as_unicode(oldtag),as_unicode(e)
                        self.tags_changed_audit_list.append(r)
                        continue
                #END FOR
        #END FOR

        del tag_regex_rules_dict
        del tag_simple_rules_dict

        if len(tags_to_change_dict) == 0:
            del tags_to_change_dict
            r = "No Tags to change; nothing to do.","",""
            self.tags_changed_audit_list.append(r)
            return

      #---------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
      #---------------------------------
        if table1 == "tags":
            mysql2 = "SELECT book,tag FROM books_tags_link "
        elif table1.startswith("custom_column"):
            mysql2 = "SELECT book,value FROM " + table2 + "  "
        else:
            my_db.close()
            return
        #~ if DEBUG: print("SELECT mysql: ", mysql2)
       #---------------------------------
        my_cursor.execute(mysql2)
        books_tags_link_list = my_cursor.fetchall()
        if not books_tags_link_list:
            my_db.close()
            return
        del mysql2
        #---------------------------------
        # add any newtags that do not already exist in table tags
        if table1 == "tags":
            mysql1 =  "INSERT OR IGNORE INTO tags (id,name) VALUES (null,?) "
        elif table1.startswith("custom_column"):
            mysql1 =  "INSERT OR IGNORE INTO " + table1 + " (id,value) VALUES (null,?) "
        else:
            my_db.close()
            return
        #~ if DEBUG: print("INSERT OR IGNORE mysql: ", mysql1)
       #---------------------------------
       #---------------------------------
        my_cursor.execute("begin")
        #~ for oldtag,newtag in tags_to_change_dict.iteritems():
        for oldtag,newtag in iteritems(tags_to_change_dict):
            my_cursor.execute(mysql1,([newtag]))
            msg = "      new tag added to: " + table1
            r = oldtag,"-->"+ newtag,msg
            self.tags_changed_audit_list.append(r)
        #END FOR
        my_cursor.execute("commit")
        del mysql1
        #---------------------------------
        # add any newtags that do not already exist in table tags
        # delete the oldtag that was just replaced by newtag
        if table1 == "tags":
            mysql2i = "INSERT OR IGNORE INTO books_tags_link (id,book,tag) VALUES (null,?,(SELECT id FROM tags WHERE tags.name = ? ) ) "
            mysql2d = "DELETE FROM books_tags_link WHERE book = ? AND tag IN(SELECT id FROM tags WHERE tags.name = ? ) "
        elif table1.startswith("custom_column"):
            mysql2i = "INSERT OR IGNORE INTO " + table2  +  " (id,book,value) VALUES (null,?,(SELECT id FROM " + table1 + " WHERE " + table1 + ".value = ? ) ) "
            mysql2d = "DELETE FROM " + table2  +  " WHERE book = ? AND value IN(SELECT id FROM " + table1 + " WHERE " + table1 + ".value= ? ) "
        else:
            my_db.close()
            return

        #~ if DEBUG: print("INSERT OR IGNORE mysql: ", mysql2i)
        #~ if DEBUG: print("DELETE mysql: ", mysql2d)
       #---------------------------------
        msg = "","",""
        self.tags_changed_audit_list.append(msg)
       #---------------------------------
        my_cursor.execute("begin")
        for row in books_tags_link_list:
            book,id = row   #really book,tag but tag===id in table tags.
            if not id in self.ts_target_tags_id_name_dict:
                r = "Should NEVER happen: if not id in self.ts_target_tags_id_name_dict: ",as_unicode(id),"  book:" + as_unicode(book)
                self.tags_changed_audit_list.append(r)
                continue
            else:
                oldtag = self.ts_target_tags_id_name_dict[id]       # id and name of original tag (oldtag) in table tags
                if not oldtag in tags_to_change_dict:
                    continue
                else:
                    newtag = tags_to_change_dict[oldtag]    # now have oldtag, its id in table tags, and the newtag for this oldtag
                    # newtag must already exist in table tags at this point
                    my_cursor.execute(mysql2i,(book,newtag))
                    msg = "  Inserted newtag to replace oldtag for book: " + as_unicode(book) + " old: " + oldtag + "  new: " + newtag
                    r = "",newtag,msg
                    self.tags_changed_audit_list.append(r)
                    # now delete the oldtag that was just replaced by newtag
                    my_cursor.execute(mysql2d,(book,oldtag))
                    msg = "Deleted oldtag for book: " + as_unicode(book) + " old: " + oldtag
                    r = oldtag,"",msg
                    self.tags_changed_audit_list.append(r)
        #END FOR
        my_cursor.execute("commit")

        # orphan ids in both tags and books_tags_link must be deleted
        my_cursor.execute("begin")
        if table1 == "tags":
            mysql = "DELETE FROM books_tags_link WHERE tag NOT IN(SELECT id FROM tags WHERE tags.id = books_tags_link.tag) "
            #~ if DEBUG: print("DELETE orphans [1] mysql: ", mysql)
            my_cursor.execute(mysql)
        else:
            mysql = "DELETE FROM " + table2 + " WHERE value NOT IN(SELECT id FROM " + table1 + " WHERE id = " + table2 + ".value) "
            #~ if DEBUG: print("DELETE orphans [2] mysql: ", mysql)
            my_cursor.execute(mysql)
        my_cursor.execute("commit")
        # orphan ids in table tags must be deleted
        my_cursor.execute("begin")
        if table1 == "tags":
            mysql = "DELETE FROM tags WHERE id NOT IN(SELECT tag FROM books_tags_link WHERE tags.id = books_tags_link.tag) "
            #~ if DEBUG: print("DELETE orphans [3] mysql: ", mysql)
            my_cursor.execute(mysql)
        else:
            mysql = "DELETE FROM " + table1 + " WHERE id NOT IN(SELECT value FROM " + table2 + " WHERE value = " + table1 + ".id) "
            #~ if DEBUG: print("DELETE orphans [4] mysql: ", mysql)
            my_cursor.execute(mysql)
        my_cursor.execute("commit")
        #--------------------------------------------------------------------
        my_db.close()
       #---------------------------------
        msg = "Scrub Tags: Changes completed for: ",table1,"  " + table2
        self.tags_changed_audit_list.append(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_apply_tag_prefix_suffix_rules(self,table1,table2):
        #~ self.ts_tag_prefix_suffix_rules_list = []  # regex,prefix,suffix = row
        #~ self.ts_target_tags_name_id_dict = {}   # name = id
        #~ self.ts_target_tags_id_name_dict = {}   # id = name

        msg = "","",""
        self.tags_changed_audit_list.append(msg)
        msg = "Tag Prefix Suffix Rules Being Applied to:  ",table1,"  " + table2
        self.tags_changed_audit_list.append(msg)
        msg = "Tag Prefix Suffix Rules Being Applied"
        self.gui.status_bar.show_message(_(msg), 10000)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        all_target_tags_dict = self.ts_get_all_target_tags_simple(my_db, my_cursor,table1)
        #---------------------------------
        new_tag_dict = {}     # [id] = name

        duplicate_names_dict = {}  #[id of changed tag] = [id of pre-existing tag]
        #---------------------------------
        for row in self.ts_tag_prefix_suffix_rules_list:
            regex,prefix,suffix = row
            regex = regex.strip()
            prefix = prefix.strip()
            suffix = suffix.strip()
            if regex > " ":
                if prefix > " " or suffix > " ":
                    pass
                else:
                    continue
            else:
                continue
            try:
                p = re.compile(regex, re.IGNORECASE)
                #~ for name,id in all_target_tags_dict.iteritems():        # all_target_tags_dict[name] = id
                for name,id in iteritems(all_target_tags_dict):        # all_target_tags_dict[name] = id
                    match = p.search(name)
                    if match:
                        tmp_tag = name

                        if prefix > " ":
                            if tmp_tag.startswith(prefix):  # do not add a prefix to a tag that already has that prefix...
                                pass
                            else:
                                tmp_tag = prefix + tmp_tag

                        if suffix > " ":
                            if tmp_tag.endswith(suffix):    # do not add a suffix to a tag that already has that suffix...
                                pass
                            else:
                                tmp_tag = tmp_tag + suffix

                        if tmp_tag != name:  #changed
                            #avoid collision with pre-existing duplicate name with another id...
                            if tmp_tag in all_target_tags_dict:
                                duplicate_id = all_target_tags_dict[tmp_tag]
                                duplicate_names_dict[id] = duplicate_id   #[id of changed tag] = [id of pre-existing identical tag]      pre-existing will "win"
                            new_tag_dict[id] = tmp_tag     # new_tag_dict[id] = name
                        else:
                            continue
                    else:
                        continue
            except Exception as e:
                #~ if DEBUG: print("Tag Prefix Suffix Rule REGEX Compile Error: ", as_unicode(oldtag), as_unicode(e))
                r = "Tag Prefix Suffix Rule REGEX Compile Error: ",as_unicode(regex),as_unicode(e)
                self.tags_changed_audit_list.append(r)
                continue
        #END FOR

        #---------------------------------
        if table1 == "tags":
            mysql1 = "UPDATE tags SET name = ? WHERE id = ?"                    #only when the new tag does not already pre-exist
            mysql2 = "UPDATE books_tags_link SET tag = ? WHERE tag = ?"   # set to "id of pre-existing identical tag" where id = "id of changed tag"
            mysql3 = "DELETE FROM tags WHERE id NOT IN (SELECT tag FROM books_tags_link)"
        else:
            mysql1 = "UPDATE [TAGS] SET [NAME] = ? WHERE id = ?"            #only when the new tag does not already pre-exist
            mysql1 = mysql1.replace("[TAGS]",table1)
            mysql1 = mysql1.replace("[NAME]","value")
            mysql2 = "UPDATE [BOOKS_TAGS_LINK] SET value = ? WHERE value = ?"  # change books to use "id of pre-existing (prior) identical tag" where id = "id of changed tag"
            mysql2 = mysql2.replace("[BOOKS_TAGS_LINK]",table2)
            mysql3 = "DELETE FROM [TAGS] WHERE id NOT IN (SELECT value FROM [BOOKS_TAGS_LINK])"
            mysql3 = mysql3.replace("[TAGS]",table1)
            mysql3 = mysql3.replace("[BOOKS_TAGS_LINK]",table2)
        #---------------------------------
        my_cursor.execute("begin")
        #~ for id,name in new_tag_dict.iteritems():        # [id] = name
        for id,name in iteritems(new_tag_dict):        # [id] = name
            if not id in duplicate_names_dict:
                my_cursor.execute(mysql1,(name,id))
                if DEBUG: print("tag is new, not a duplicate: ", as_unicode(id), name)
            else:
                if DEBUG: print("books using an ID that is now redundant must be have their ID reassigned from ID: ", as_unicode(id), " for name: ", name)
        #END FOR
        my_cursor.execute("commit")
        #---------------------------------
        my_cursor.execute("begin")
        #~ for changed_id,prior_id in duplicate_names_dict.iteritems():        # #[id of changed tag] = [id of pre-existing (prior) identical tag]      pre-existing will "win"
        for changed_id,prior_id in iteritems(duplicate_names_dict):        # #[id of changed tag] = [id of pre-existing (prior) identical tag]      pre-existing will "win"
            if prior_id == changed_id:
                continue
            try:
                my_cursor.execute(mysql2,(prior_id,changed_id))
            except Exception as e:
                #~ if DEBUG: print("cleanup is unnecessary; nothing done: ", as_unicode(prior_id), as_unicode(changed_id))
                continue
            if DEBUG: print("books using an ID that is now redundant have been changed from ID to ID: ", as_unicode(changed_id), " to: ", as_unicode(prior_id))
        #END FOR
        my_cursor.execute("commit")
        #---------------------------------
        my_cursor.execute("begin")
        my_cursor.execute(mysql3)
        if DEBUG: print("unused tags (if any) have been deleted...")
        my_cursor.execute("commit")
       #---------------------------------
        my_db.close()
        #---------------------------------
        msg = "Tag Prefix Suffix Rules created: ",as_unicode(len(new_tag_dict) - len(duplicate_names_dict))," new tags in:  " + table1
        self.tags_changed_audit_list.append(msg)
        msg = "Tag Prefix Suffix Rules reassigned: ",as_unicode(len(duplicate_names_dict))," books to preexisting tags identical to derived value for:  " + table1
        self.tags_changed_audit_list.append(msg)
        #---------------------------------
        del self.ts_tag_prefix_suffix_rules_list
        del new_tag_dict
        del all_target_tags_dict
        del duplicate_names_dict
        #---------------------------------
        msg = "Scrub Tags: Prefix Suffix Changes completed for: ",table1,"  " + table2
        self.tags_changed_audit_list.append(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_apply_tag_splitting_rules(self,target,table1,table2):
        msg = "","",""
        self.tags_changed_audit_list.append(msg)
        msg = "Tag Splitting Rules Being Applied to:  ",table1,"  " + table2
        self.tags_changed_audit_list.append(msg)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        all_target_tags_dict = self.ts_get_all_target_tags_simple(my_db, my_cursor,table1)
        my_db.close()
        #---------------------------------
        matching_tags_dict = {}

        for r in self.ts_tag_splitting_rules_list:      #example:  "#fast","^.+$",":","-","&","_"
            if DEBUG: print(as_unicode(r))
            column,regex,s1,s2,s3,s4 = r
            s1 = s1.strip()
            s2 = s2.strip()
            s3 = s3.strip()
            s4 = s4.strip()
            if column == target:
                p = re.compile(regex, re.IGNORECASE)
                #~ for name,original_id in all_target_tags_dict.iteritems():  #ordered dict, sorted ascending for audit log...
                for name,original_id in all_target_tags_dict.iteritems():  #ordered dict, sorted ascending for audit log...
                    match = p.search(name)                                             #example:  Factual:History-War&Military-WWII-Africa-North Africa_Libya
                    if match:
                        if s1 in name or s2 in name or s3 in name or s4 in name:
                            new_tags_list = self.ts_apply_tag_splitting_rules_single_tag(s1,s2,s3,s4,name,table1)
                            self.ts_apply_tag_splitting_rules_add_new_tags(original_id,name,new_tags_list,table1,table2,target)
                            del new_tags_list
                            msg = "Splitting Tag: " + name + "    ...Wait..."
                            self.gui.status_bar.show_message(_(msg), 2000)
                            QApplication.instance().processEvents()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_apply_tag_splitting_rules_single_tag(self,s1,s2,s3,s4,name,table1):

        msg = "Tag Splitting Rules Being Applied to Original Tag:  ",name,"  in: " + table1
        self.tags_changed_audit_list.append(msg)

        find_list = []

        n = name.find(s1)
        if n > -1:
            r = n,s1
            find_list.append(r)

        n = name.find(s2)
        if n > -1:
            r = n,s2
            find_list.append(r)

        n = name.find(s3)
        if n > -1:
            r = n,s3
            find_list.append(r)

        n = name.find(s4)
        if n > -1:
            r = n,s4
            find_list.append(r)

        find_list.sort()
        piece_list = []
        for f in find_list:  #sorted ascending (left to right) by offset of split_string within current tag to be split
            n,ss = f
            if len(ss) == 0:
                continue
            i = 0
            while i <= len(piece_list):  #list must start empty to avoid infinite loop
                if i == 0:
                    if len(piece_list) == 0:
                        p = name               #list must start empty to avoid infinite loop
                else:
                    if i < len(piece_list):
                        p = piece_list[i]
                    else:
                        break  #finished with the current "f"
                i = i + 1
                p = p.strip()
                s_split = p.split(ss)
                if isinstance(s_split,list):
                    if len(s_split) > 0:
                        s_split_unique = []
                        for s in s_split:
                            s = s.strip()
                            if s > "":
                                if not s in piece_list:
                                    if not s in s_split_unique:
                                        s_split_unique.append(s)
                        #END FOR
                        del s_split
                        piece_list.extend(s_split_unique)
                        del s_split_unique
                else:
                    del s_split
            #END WHILE
        #END FOR

        del find_list

        piece_list.sort()

        new_tags_list = []

        for piece in piece_list:
            piece = piece.strip()
            piece = piece.lower()
            piece = piece.title()
            if s1 == "" or (not s1 in piece):                #unsplit pieces that are artifacts
                if s2 == "" or (not s2 in piece):
                    if s3 == "" or (not s3 in piece):
                        if s4 == "" or (not s4 in piece):
                            if piece != "":
                                new_tags_list.append(piece)  #elemental pieces
        #END FOR
        del piece_list

        new_tags_list = list(set(new_tags_list))

        for tag in new_tags_list:
            msg = "Tag Splitting Rules: newly created tag: " , tag , ""
            self.tags_changed_audit_list.append(msg)
        #END FOR

        return new_tags_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_apply_tag_splitting_rules_add_new_tags(self,original_id,name,new_tags_list,table1,table2,target):

        original_tag = name

        #---------------------------------
        if table1 == "tags":
            mysql = "SELECT book,tag FROM books_tags_link WHERE tag = ?"
        else:
            mysql = "SELECT book,value FROM [BOOKS_TAGS_LINK] WHERE value = ?"
            mysql = mysql.replace("[BOOKS_TAGS_LINK]",table2)
        #---------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        book_list = []

        my_cursor.execute(mysql,([original_id]))
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            book,tag_id = row
            book_list.append(book)
        #END FOR
        del tmp_rows

        msg = "Tag Splitting Rules: number of books using original tag: ", original_tag , "  " + as_unicode(len(book_list))
        self.tags_changed_audit_list.append(msg)

        if len(book_list) == 0:  #can happen only in testing...
            return

        id_map = {}

        if table1 == "tags":
            for book in book_list:
                book_mi_object = self.guidb.new_api.get_metadata(book, get_cover=False, get_user_categories=False, cover_as_data=False)
                tags_already_list = book_mi_object.get("tags")
                all_tags_list = new_tags_list + tags_already_list
                all_tags_list = list(set(all_tags_list))
                all_tags_list.remove(original_tag)
                mi = Metadata('Unknown')
                mi.tags = new_tags_list
                id_map[book] = mi
                del book_mi_object
            #END FOR
            del mi
        else:
            custom_columns = self.gui.current_db.field_metadata.custom_field_metadata()
            for book in book_list:
                book_mi_object = self.guidb.new_api.get_metadata(book, get_cover=False, get_user_categories=False, cover_as_data=False)    # get_user_categories=True
                tags_already_list = book_mi_object.get(target)
                all_tags_list = new_tags_list + tags_already_list
                all_tags_list = list(set(all_tags_list))
                all_tags_list.remove(original_tag)
                custcol1 = custom_columns[target]         #  custcol = custom_columns["#mytaglike"]
                custcol1['#value#'] = all_tags_list
                mi = Metadata('Unknown')
                mi.set_user_metadata(target, custcol1)
                id_map[book] = mi
                del book_mi_object
            #END FOR

            del mi
            del custom_columns
            del all_tags_list
            del tags_already_list
            del new_tags_list

        #~ for k,v in id_map.iteritems():   #one-at-a-time is required since the standard Calibre progress dialog for updating metadata always hangs...and cannot be closed...ever...
        for k,v in iteritems(id_map):   #one-at-a-time is required since the standard Calibre progress dialog for updating metadata always hangs...and cannot be closed...ever...
            single_id_map = {}
            single_id_map[k] = v
            payload = []
            edit_metadata_action = self.gui.iactions['Edit Metadata']
            edit_metadata_action.apply_metadata_changes(single_id_map,callback=self.ts_apply_tag_splitting_rules_add_new_tags_callback(payload),merge_tags=False)  #do NOT merge Tags...
            sleep(0.05)
        #END FOR

        msg = "Tag Splitting Rules Have Finished Splitting Original Tag:  ",original_tag,"  in: " + table1
        self.tags_changed_audit_list.append(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_apply_tag_splitting_rules_add_new_tags_callback(self,payload):
        del payload
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_build_target_tags_name_book_id_dicts(self,table1,table2):
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #---------------------------------
        self.ts_target_tags_name_id_dict = {}   # name = id
        self.ts_target_tags_id_name_dict = {}   # id = name
        #---------------------------------
        mysql = "SELECT * from " + table1     # tags: id,name  tag-like:  id,value
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            id,name = row                                 # tags: id,name  tag-like:  id,value
            self.ts_target_tags_name_id_dict[name] = id   # name is text
            self.ts_target_tags_id_name_dict[id] = name
        #END FOR
        #~ if DEBUG: print("ts_build_target_tags_name_id_dict: number of rows: ", as_unicode(len(self.ts_target_tags_name_id_dict)))
        del tmp_rows

        msg = "Tag/Tag-Like Tags Found:  ",as_unicode(len(self.ts_target_tags_name_id_dict)),"  for table: "  + table1
        self.tags_changed_audit_list.append(msg)

        #---------------------------------
        self.ts_target_book_id_dict = {}   # book = name  (name is an int)
        #---------------------------------
        mysql = "SELECT * from " + table2     # tags: id,book,tag    tag-like:  id,book,value  where tag/value = table1 name/value
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            id,book,name = row                                 # tags: id,book,tag      tag-like:  id,book,value where tag/value = table1 name/value
            self.ts_target_book_id_dict[book] = name      # name is an int
        #END FOR
        del tmp_rows

        my_db.close()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_get_ruleset_table_data(self,ruleset,source=None):
       #---------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #---------------------------------
        if ruleset == TAG_CAPITALIZATION_RULES:
            self.ts_build_regex_list_from_tag_capitalization_rules(my_db,my_cursor)
            if source == "export":
                self.ts_tag_capitalization_rules_list = []
                mysql = "SELECT regex,rule,priority FROM _js_tag_capitalization_rules"
                my_cursor.execute(mysql)
                tmp_rows = my_cursor.fetchall()
                if not tmp_rows:
                    tmp_rows = []
                for row in tmp_rows:
                    self.ts_tag_capitalization_rules_list.append(row)
                #END FOR
                del tmp_rows
        #---------------------------------
        elif ruleset == TAG_COMBINATION_RULES:
            self.ts_tag_combination_rules_list = []  # tag_keyword_1,tag_keyword_2,tag_keyword_3,newtag = row
            mysql = "SELECT tag_keyword_1,tag_keyword_2,tag_keyword_3,newtag FROM _js_tag_combination_rules WHERE tag_keyword_1 NOT NULL AND tag_keyword_2 NOT NULL AND newtag NOT NULL  "
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                tmp_rows = []
            for row in tmp_rows:
                self.ts_tag_combination_rules_list.append(row)
            #END FOR
            del tmp_rows
        #---------------------------------
        elif ruleset == TAG_RULES:
            self.ts_tag_rules_list = []  # oldtag,newtag,purgetag = row
            mysql = "SELECT oldtag,newtag,purgetag FROM _js_tag_rules WHERE oldtag NOT NULL AND purgetag NOT NULL"
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                tmp_rows = []
            for row in tmp_rows:
                self.ts_tag_rules_list.append(row)
                #~ if DEBUG: print("self.ts_tag_rules_list: ", as_unicode(row))
            #END FOR
            del tmp_rows
        #---------------------------------
        elif ruleset == TAG_STRING_REPLACEMENT_RULES:
            # normally uses views instead of self.ts_tag_string_replacement_rules_list
            if source == "export":
                self.ts_tag_string_replacement_rules_list = []
                mysql = "SELECT old_string,new_string FROM _js_tag_string_replacement_rules"
                my_cursor.execute(mysql)
                tmp_rows = my_cursor.fetchall()
                if not tmp_rows:
                    tmp_rows = []
                for row in tmp_rows:
                    self.ts_tag_string_replacement_rules_list.append(row)
                #END FOR
                del tmp_rows
        #---------------------------------
        elif ruleset == TAG_PREFIX_SUFFIX_RULES:
            self.ts_tag_prefix_suffix_rules_list = []
            mysql = "SELECT regex,prefix,suffix FROM _js_tag_prefix_suffix_rules"
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                tmp_rows = []
            for row in tmp_rows:
                self.ts_tag_prefix_suffix_rules_list.append(row)
            #END FOR
            del tmp_rows
        #---------------------------------
        elif ruleset == TAG_SPLITTING_RULES:
            self.ts_tag_splitting_rules_list = []
            mysql = "SELECT target,regex,split_string_1,split_string_2,split_string_3,split_string_4 FROM _js_tag_splitting_rules"
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                tmp_rows = []
            for row in tmp_rows:
                self.ts_tag_splitting_rules_list.append(row)
            #END FOR
            del tmp_rows
       #---------------------------------
        my_db.close()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_get_custom_column_technical_details(self):
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        self.custom_columns_label_dict = {}
        self.ts_current_custom_columns_list = []

        mysql = "SELECT id,label,name,datatype,mark_for_delete,editable,display,is_multiple,normalized FROM custom_columns ORDER BY label,name"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            id,label,name,datatype,mark_for_delete,editable,display,is_multiple,normalized = row
            label = "#" + label
            self.custom_columns_label_dict[label] = id,label,name,datatype,display,is_multiple,normalized
            self.ts_current_custom_columns_list.append(label)
        #END FOR
        del tmp_rows

        self.ts_current_custom_columns_list.sort()

        my_db.close()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_import_tag_rules_tables_csv_files(self,table):
        csv_path = self.ts_choose_csv_file_to_import()
        if not csv_path:
            return False
        if DEBUG: print("import csv_path selected by user: ", csv_path)
        single_table_csv_list = self.ts_import_csv_file(csv_path)
        header = single_table_csv_list[0]
        imported_table_name,msg = self.ts_validate_specific_ruleset_table_for_import(table,header)
        if not imported_table_name:
            msg = msg + '<br><br>CSV File header row did not match the expected header for the chosen table; Execution canceled.'
            del single_table_csv_list
            del header
            info_dialog(self.gui, 'Import Canceled',msg).show()
            return False
        del single_table_csv_list[0]
        ok = self.ts_add_csv_data_to_specified_table(imported_table_name,single_table_csv_list)
        if not ok:
            return False
        else:
            return True
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_validate_specific_ruleset_table_for_import(self,table,header):
        header = as_unicode(header)
        header = header.lower().strip()

        if header == HEADER_TAG_STRING_REPLACEMENT_TABLE:
            imported_table_name = "_js_tag_string_replacement_rules"
        elif header == HEADER_TAG_RULES_TABLE:
            imported_table_name = "_js_tag_rules"
        elif header == HEADER_TAG_COMBINATION_RULES_TABLE:
            imported_table_name = "_js_tag_combination_rules"
        elif header == HEADER_TAG_CAPITALIZATION_RULES_TABLE:
            imported_table_name = "_js_tag_capitalization_rules"
        elif header == HEADER_TAG_PREFIX_SUFFIX_RULES_TABLE:
            imported_table_name = "_js_tag_prefix_suffix_rules"
        elif header == HEADER_TAG_SPLITTING_RULES_TABLE:
            imported_table_name = "_js_tag_splitting_rules"
        else:
            msg = "imported table name could not be determined using the imported CSV file header row." + as_unicode(header)
            if DEBUG: print(msg)
            return None,msg

        msg = "header: " +  header + "  imported_table_name: " + imported_table_name + "   user selected table: " + table

        if DEBUG: print(msg)

        if table != imported_table_name:
            imported_table_name = None

        return imported_table_name,msg
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_choose_csv_file_to_import(self):
        default_user_csv_directory = prefs['GUI_TOOLS_TAG_RULES_DEFAULT_CSV_DIRECTORY']
        import_tuple = QFileDialog.getOpenFileName(None,"Import Any Tag Scrubbing Table UTF-8 Encoded CSV Text File ",default_user_csv_directory,("CSV Files (*.csv *.txt)") )
        if not import_tuple:
            return None
        path, dummy = import_tuple
        if DEBUG: print("ts_choose_csv_file_to_import: ", path)
        if not path:
            return None
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        head,tail = os.path.split(path)
        prefs['GUI_TOOLS_TAG_RULES_DEFAULT_CSV_DIRECTORY'] = head
        if os.path.isfile(path):
            return path
        else:
            return None
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_import_csv_file(self,csv_path):
        single_table_csv_list = []

        if csv_path == unicode_type(""):
            if DEBUG: print("csv_path == unicode_type(""); nothing to do.")
            return single_table_csv_list

        try:
            with open (csv_path,'rb') as csvfile:
                lines = csvfile.readlines()
                for line in lines:
                    line = line.strip()
                    single_table_csv_list.append(line)
                    #~ if DEBUG: print("raw csv row: ", as_unicode(line))
            #END FOR
            csvfile.close()
            del lines
            del csvfile
            del csv_path
        except Exception as e:
            if DEBUG: print("Import CSV File Error: " + as_unicode(e))
            error_dialog(self.gui, _('Import CSV File Error'),_(e), show=True)
            single_table_csv_list = []

        return single_table_csv_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_add_csv_data_to_specified_table(self,imported_table_name,single_table_csv_list):

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        mysql_purge,mysql_add_row = self.ts_build_mysql_for_target(imported_table_name)
        if not mysql_purge or not mysql_add_row:
            my_db.close()
            error_dialog(self.gui, _('JS+ GUI Tool'),_('Technical Error: Could not build SQL for imported table name.  Import Aborted.'), show=True)
            return False

        try:
            my_cursor.execute("begin")
            my_cursor.execute(mysql_purge)
            my_cursor.execute("commit")
            my_cursor.execute("begin")
            for row in single_table_csv_list:
                if not isinstance(row,unicode_type):
                    row = as_unicode(row)
                #~ if DEBUG: print(as_unicode(row))
                if imported_table_name == "_js_tag_capitalization_rules":
                    #~ "regex","rule",priority
                    s_split = row.split(',')
                    regex = s_split[0]
                    regex = self.ts_remove_leading_trailing_double_quotes(regex)
                    rule = s_split[1]
                    rule = self.ts_remove_leading_trailing_double_quotes(rule)
                    priority = as_unicode(s_split[2])
                    priority = self.ts_remove_leading_trailing_double_quotes(priority)
                    priority = int(priority)
                    my_cursor.execute(mysql_add_row,(regex,rule,priority))
                elif imported_table_name == "_js_tag_combination_rules":
                    #~ "tag_keyword_1","tag_keyword_2","tag_keyword_3","newtag"
                    s_split = row.split(',')
                    tag_keyword_1 = s_split[0]
                    tag_keyword_2 = s_split[1]
                    tag_keyword_3 = s_split[2]
                    newtag = s_split[3]
                    tag_keyword_1 = self.ts_remove_leading_trailing_double_quotes(tag_keyword_1)
                    tag_keyword_2 = self.ts_remove_leading_trailing_double_quotes(tag_keyword_2)
                    tag_keyword_3 = self.ts_remove_leading_trailing_double_quotes(tag_keyword_3)
                    newtag = self.ts_remove_leading_trailing_double_quotes(newtag)
                    my_cursor.execute(mysql_add_row,(tag_keyword_1,tag_keyword_2,tag_keyword_3,newtag))
                elif imported_table_name == "_js_tag_rules":
                    #~ "oldtag","newtag","purgetag"
                    s_split = row.split(',')
                    oldtag = s_split[0]
                    newtag = s_split[1]
                    purgetag = s_split[2].replace('"','').strip()
                    oldtag = self.ts_remove_leading_trailing_double_quotes(oldtag)
                    newtag = self.ts_remove_leading_trailing_double_quotes(newtag)
                    purgetag = purgetag.title()
                    if purgetag == "False" or purgetag == "0":
                        purgetag = False
                    else:
                        purgetag = True
                    if DEBUG: print(oldtag, newtag, purgetag)
                    my_cursor.execute(mysql_add_row,(oldtag,newtag,purgetag))
                elif imported_table_name == "_js_tag_string_replacement_rules":
                    #~ "old_string","new_string"
                    s_split = row.split(',')
                    old_string = s_split[0]
                    new_string = s_split[1]
                    old_string = self.ts_remove_leading_trailing_double_quotes(old_string)
                    new_string = self.ts_remove_leading_trailing_double_quotes(new_string)
                    my_cursor.execute(mysql_add_row,(old_string,new_string))
                elif imported_table_name == "_js_tag_prefix_suffix_rules":
                    #~ "regex","prefix","suffix"
                    s_split = row.split(',')
                    regex = s_split[0]
                    prefix = s_split[1]
                    suffix = s_split[2]
                    regex = self.ts_remove_leading_trailing_double_quotes(regex)
                    prefix = self.ts_remove_leading_trailing_double_quotes(prefix)
                    suffix = self.ts_remove_leading_trailing_double_quotes(suffix)
                    my_cursor.execute(mysql_add_row,(regex,prefix,suffix))
                elif imported_table_name == "_js_tag_splitting_rules":
                    #~ "target","regex","split_string_1","split_string_2","split_string_3","split_string_4"
                    s_split = row.split(',')
                    target = s_split[0]
                    regex = s_split[1]
                    split_string_1 = s_split[2]
                    split_string_2 = s_split[3]
                    split_string_3 = s_split[4]
                    split_string_4 = s_split[5]
                    target = self.ts_remove_leading_trailing_double_quotes(target)
                    regex = self.ts_remove_leading_trailing_double_quotes(regex)
                    split_string_1 = self.ts_remove_leading_trailing_double_quotes(split_string_1)
                    split_string_2 = self.ts_remove_leading_trailing_double_quotes(split_string_2)
                    split_string_3 = self.ts_remove_leading_trailing_double_quotes(split_string_3)
                    split_string_4 = self.ts_remove_leading_trailing_double_quotes(split_string_4)
                    my_cursor.execute(mysql_add_row,(target,regex,split_string_1,split_string_2,split_string_3,split_string_4))
            #END FOR
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print("import CSV file: ts_add_csv_data_to_specified_table: Exception:", as_unicode(e))
            my_db.close()
            return False

        del single_table_csv_list
        del imported_table_name

        my_db.close()

        return True
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_remove_leading_trailing_double_quotes(self,tag):
        #~ "oldtag"                                                                             ,"newtag"        ,"purgetag"
        #~ """A Hanging"" - George Orwell"                                     ,"A Hanging"     ,"False"
        #~ "Amidala69's ""Turn and Face the Strange"" Universe"   ,"Harry Potter"   ,"False"
        tag = tag.strip()
        if tag.startswith('"'):
            tag = tag[1: ]
        if tag.endswith('"'):
            tag = tag[0:-1]
        if '""' in tag:
            if DEBUG: print("Double-Quotes used in Tag Value - before: ", tag)
            tag = tag.replace('""','"')
            if DEBUG: print("Double-Quotes used in Tag Value - after: ", tag)
        tag = tag.strip()
        return tag
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_build_mysql_for_target(self,imported_table_name):

        if imported_table_name == "_js_tag_capitalization_rules":
            mysql_purge = "DELETE FROM _js_tag_capitalization_rules"
            mysql_add_row = "INSERT OR REPLACE INTO _js_tag_capitalization_rules (regex,rule,priority) VALUES (?,?,?) "
        elif imported_table_name == "_js_tag_combination_rules":
            mysql_purge = "DELETE FROM _js_tag_combination_rules"
            mysql_add_row = "INSERT OR REPLACE INTO _js_tag_combination_rules ( tag_keyword_1,tag_keyword_2,tag_keyword_3,newtag) VALUES (?,?,?,?) "
        elif imported_table_name == "_js_tag_rules":
            mysql_purge = "DELETE FROM _js_tag_rules"
            mysql_add_row = "INSERT OR REPLACE INTO _js_tag_rules (oldtag,newtag,purgetag) VALUES (?,?,?) "
        elif imported_table_name == "_js_tag_string_replacement_rules":
            mysql_purge = "DELETE FROM _js_tag_string_replacement_rules"
            mysql_add_row = "INSERT OR REPLACE INTO _js_tag_string_replacement_rules (old_string,new_string) VALUES (?,?) "
        elif imported_table_name == "_js_tag_prefix_suffix_rules":
            mysql_purge = "DELETE FROM _js_tag_prefix_suffix_rules"
            mysql_add_row = "INSERT OR REPLACE INTO _js_tag_prefix_suffix_rules (regex,prefix,suffix) VALUES (?,?,?) "
        elif imported_table_name == "_js_tag_splitting_rules":
            mysql_purge = "DELETE FROM _js_tag_splitting_rules"
            mysql_add_row = "INSERT OR REPLACE INTO _js_tag_splitting_rules (target,regex,split_string_1,split_string_2,split_string_3,split_string_4) VALUES (?,?,?,?,?,?) "
        else:
            return None,None

        #~ if DEBUG: print(mysql_purge)
        #~ if DEBUG: print(mysql_add_row)

        return mysql_purge,mysql_add_row
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_export_tag_rules_tables_csv_files(self,table):
        # IMPORTANT:  to guarantee the original UTF-8 encoding is preserved, a .txt is output instead of a .csv so that a text editor is used to open it properly with UTF-8,
        #~                    which does not corrupt it upon opening.  However, it is a comma-separated file.

        if table == "_js_tag_capitalization_rules":
            ruleset = TAG_CAPITALIZATION_RULES
            self.ts_get_ruleset_table_data(ruleset,source="export")
            export_rules_list = self.ts_tag_capitalization_rules_list
            header = "regex","rule","priority"
            export_rules_list.insert(0,header)
            filename = table + ".txt"
        elif table == "_js_tag_combination_rules":
            ruleset = TAG_COMBINATION_RULES
            self.ts_get_ruleset_table_data(ruleset,source="export")
            export_rules_list = self.ts_tag_combination_rules_list
            header = "tag_keyword_1","tag_keyword_2","tag_keyword_3","newtag"
            export_rules_list.insert(0,header)
            filename = table + ".txt"
        elif table == "_js_tag_rules":
            ruleset = TAG_RULES
            self.ts_get_ruleset_table_data(ruleset,source="export")
            export_rules_list = self.ts_tag_rules_list
            header = "oldtag","newtag","purgetag"
            export_rules_list.insert(0,header)
            filename = table + ".txt"
        elif table == "_js_tag_string_replacement_rules":
            ruleset = TAG_STRING_REPLACEMENT_RULES
            self.ts_get_ruleset_table_data(ruleset,source="export")
            export_rules_list = self.ts_tag_string_replacement_rules_list
            header = "old_string","new_string"
            export_rules_list.insert(0,header)
            filename = table + ".txt"
        elif table == "_js_tag_prefix_suffix_rules":
            ruleset = TAG_PREFIX_SUFFIX_RULES
            self.ts_get_ruleset_table_data(ruleset,source="export")
            export_rules_list = self.ts_tag_prefix_suffix_rules_list
            header = "regex","prefix","suffix"
            export_rules_list.insert(0,header)
            filename = table + ".txt"
        elif table == "_js_tag_splitting_rules":
            ruleset = TAG_SPLITTING_RULES
            self.ts_get_ruleset_table_data(ruleset,source="export")
            export_rules_list = self.ts_tag_splitting_rules_list
            header = "target","regex","split_string_1","split_string_2","split_string_3","split_string_4"
            export_rules_list.insert(0,header)
            filename = table + ".txt"
        else:
            return

        default_user_csv_directory = prefs['GUI_TOOLS_TAG_RULES_DEFAULT_CSV_DIRECTORY']
        title = "Choose Directory for CSV Rules Table Export"
        chosen_directory_name = QFileDialog.getExistingDirectory(None,title,default_user_csv_directory,QFileDialog.Option.ShowDirsOnly | QFileDialog.Option.DontResolveSymlinks )
        if not chosen_directory_name:
            return

        prefs['GUI_TOOLS_TAG_RULES_DEFAULT_CSV_DIRECTORY'] = chosen_directory_name
        prefs

        export_csv_file_full_path = os.path.join(chosen_directory_name,filename)
        export_csv_file_full_path = export_csv_file_full_path.replace(os.sep, '/')

        if DEBUG: print("selected tag rules table export file path is: ", export_csv_file_full_path)

        if os.path.isdir(chosen_directory_name):
            try:
                with open(export_csv_file_full_path, 'w') as outfile:
                    for row in export_rules_list:
                        if table == "_js_tag_capitalization_rules":
                            if DEBUG: print("js_tag_capitalization_rules ", as_unicode(row))
                            regex,rule,priority = row
                            if isinstance(priority,int):
                                priority = as_unicode(priority)
                            else:  #header row
                                priority = unicode_type('"') + priority + unicode_type('"')
                            r = unicode_type('"') + regex + unicode_type('"') + unicode_type(',') + unicode_type('"') + rule + unicode_type('"') + unicode_type(',') + priority + unicode_type("\n")
                        elif table == "_js_tag_combination_rules":
                            if DEBUG: print("js_tag_combination_rules ", as_unicode(row))
                            tag_keyword_1,tag_keyword_2,tag_keyword_3,newtag = row
                            r = unicode_type('"') + tag_keyword_1 + unicode_type('"') + unicode_type(',') + unicode_type('"') + tag_keyword_2 + unicode_type('"') + unicode_type(',')  + unicode_type('"') + tag_keyword_3 + unicode_type('"')  + unicode_type(',')  + unicode_type('"') + newtag + unicode_type('"')+ unicode_type("\n")
                        elif table == "_js_tag_rules":
                            if DEBUG: print("js_tag_rules ", as_unicode(row))
                            oldtag,newtag,purgetag = row
                            if isinstance(purgetag,int):
                                if purgetag == 0:
                                    purgetag = "False"
                                else:
                                    purgetag = "True"
                            r = unicode_type('"') + oldtag + unicode_type('"') + unicode_type(',') + unicode_type('"') + newtag + unicode_type('"') + unicode_type(',')  + unicode_type('"') + purgetag + unicode_type('"') + unicode_type("\n")
                        elif table == "_js_tag_string_replacement_rules":
                            if DEBUG: print("js_tag_string_replacement_rules ", as_unicode(row))
                            old_string,new_string = row
                            r = unicode_type('"') + old_string + unicode_type('"') + unicode_type(',') + unicode_type('"') + new_string + unicode_type('"') + unicode_type("\n")
                        elif table == "_js_tag_prefix_suffix_rules":
                            if DEBUG: print("_js_tag_prefix_suffix_rules ", as_unicode(row))
                            regex,prefix,suffix = row
                            r = unicode_type('"') + regex + unicode_type('"') + unicode_type(',') + unicode_type('"') + prefix + unicode_type('"') +  unicode_type(',') + unicode_type('"') + suffix + unicode_type('"') + unicode_type("\n")
                        elif table == "_js_tag_splitting_rules":
                            if DEBUG: print("_js_tag_splitting_rules ", as_unicode(row))
                            target,regex,split_string_1,split_string_2,split_string_3,split_string_4 = row
                            r = unicode_type('"') + target + unicode_type('"') + unicode_type(',') + unicode_type('"') + regex + unicode_type('"') + unicode_type(',') + unicode_type('"') + split_string_1 + unicode_type('"') +  unicode_type(',') + unicode_type('"') + split_string_2 + unicode_type('"') \
                               + unicode_type(',') + unicode_type('"') + split_string_3 + unicode_type('"') +  unicode_type(',') + unicode_type('"') + split_string_4 + unicode_type('"') + unicode_type("\n")
                        outfile.write(r)
                    #END FOR
                outfile.close()
                msg = 'The export of table ' + table + ' was successful.<br><br>File path:'+ export_csv_file_full_path + "<br><br>Number of rows exported: " + as_unicode(len(export_rules_list))
                info_dialog(self.gui, 'Export Success',msg).show()
                #~ if DEBUG: print(msg)
                del outfile
            except Exception as e:
                #~ if DEBUG: print("export failure: ", as_unicode(e))
                msg = 'The export of the selected table ' + table + ' failed due to: ' + as_unicode(e) + "   row: " + as_unicode(row)
                info_dialog(self.gui, 'Export Failure',msg).show()
                #~ if DEBUG: print(msg)
        #~ ------------------------------------------------------------------
        del export_rules_list
        del export_csv_file_full_path
        del chosen_directory_name
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_refresh_cache_all_book_ids(self):
        db = self.gui.current_db.new_api
        all_book_ids_frozenset = db.all_book_ids()
        selected_book_list = list(all_book_ids_frozenset)
        self.force_refresh_of_cache(selected_book_list)
        del db
        del all_book_ids_frozenset
        del selected_book_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_install_tag_rules_tables(self):
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        mysql_list_1 = []
        mysql_list_1.append("CREATE TABLE IF NOT EXISTS _js_tag_capitalization_rules (id INTEGER PRIMARY KEY  NOT NULL ,  regex TEXT NOT NULL , rule TEXT NOT NULL  DEFAULT 'uppercase', priority INTEGER NOT NULL  DEFAULT 100);")
        mysql_list_1.append("CREATE TABLE IF NOT EXISTS _js_tag_combination_rules (tag_keyword_1 TEXT NOT NULL , tag_keyword_2 TEXT NOT NULL , tag_keyword_3 TEXT NOT NULL  DEFAULT 'NONE', newtag TEXT NOT NULL , PRIMARY KEY (tag_keyword_1, tag_keyword_2, tag_keyword_3));")
        mysql_list_1.append("CREATE TABLE IF NOT EXISTS _js_tag_rules (id INTEGER PRIMARY KEY  AUTOINCREMENT  NOT NULL ,  oldtag TEXT NOT NULL  UNIQUE , newtag TEXT, purgetag BOOL NOT NULL  DEFAULT 0);")
        mysql_list_1.append("CREATE TABLE IF NOT EXISTS _js_tag_string_replacement_rules (id INTEGER PRIMARY KEY  AUTOINCREMENT  NOT NULL , old_string TEXT NOT NULL , new_string TEXT NOT NULL );")
        mysql_list_1.append("CREATE TABLE IF NOT EXISTS _js_tag_prefix_suffix_rules (id INTEGER PRIMARY KEY NOT NULL,regex TEXT NOT NULL DEFAULT '^.+$',prefix TEXT NOT NULL DEFAULT '',suffix TEXT NOT NULL DEFAULT '', UNIQUE(regex));")
        mysql_list_1.append("CREATE TABLE IF NOT EXISTS _js_tag_splitting_rules (id INTEGER PRIMARY KEY NOT NULL,target TEXT NOT NULL,regex TEXT NOT NULL DEFAULT '^.+$',split_string_1 TEXT NOT NULL DEFAULT '',split_string_2 TEXT NOT NULL DEFAULT '',split_string_3 TEXT NOT NULL DEFAULT '',split_string_4 TEXT NOT NULL DEFAULT '',UNIQUE(target,regex));")

        mysql_list_2 = []
        mysql_list_2.append('CREATE INDEX IF NOT EXISTS js_tag_capitalization_rules_1_idx ON _js_tag_capitalization_rules (regex ASC, rule ASC, priority ASC);')
        mysql_list_2.append('CREATE INDEX IF NOT EXISTS js_tag_rules_1_idx ON _js_tag_rules (oldtag ASC, newtag ASC);')
        mysql_list_2.append('CREATE INDEX IF NOT EXISTS js_tag_rules_2_idx ON _js_tag_rules (newtag ASC);')
        mysql_list_2.append('CREATE INDEX IF NOT EXISTS js_tag_string_replacement_rules_1_idx ON _js_tag_string_replacement_rules (old_string ASC, new_string ASC);')
        mysql_list_2.append('CREATE INDEX IF NOT EXISTS js_tag_prefix_suffix_rules_1_idx ON _js_tag_prefix_suffix_rules (regex ASC);')
        mysql_list_2.append('CREATE INDEX IF NOT EXISTS js_tag_splitting_rules_1_idx ON _js_tag_splitting_rules (regex ASC);')

        try:
            my_cursor.execute("begin")
            for mysql in mysql_list_1:
                #~ if DEBUG: print(mysql)
                my_cursor.execute (mysql)
            #END FOR
            my_cursor.execute("commit")
            my_cursor.execute("begin")
            for mysql in mysql_list_2:
                #~ if DEBUG: print(mysql)
                my_cursor.execute (mysql)
            #END FOR
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print("ts_install_tag_rules_tables: Exception:", as_unicode(e))

        del mysql_list_1
        del mysql_list_2

        self.ts_create_special_views(my_db,my_cursor)

        my_db.close()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_uninstall_tag_rules_tables(self):
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        mysql_list = []
        mysql_list.append('DROP TABLE IF EXISTS _js_tag_capitalization_rules ')
        mysql_list.append('DROP TABLE IF EXISTS _js_tag_combination_rules ')
        mysql_list.append('DROP TABLE IF EXISTS _js_tag_rules ')
        mysql_list.append('DROP TABLE IF EXISTS _js_tag_string_replacement_rules ')
        mysql_list.append('DROP TABLE IF EXISTS _js_tag_prefix_suffix_rules')
        mysql_list.append('DROP TABLE IF EXISTS _js_tag_splitting_rules')
        mysql_list.append('DROP INDEX IF EXISTS js_tag_capitalization_rules_1_idx;')
        mysql_list.append('DROP INDEX IF EXISTS js_tag_rules_1_idx ;')
        mysql_list.append('DROP INDEX IF EXISTS js_tag_rules_2_idx;')
        mysql_list.append('DROP INDEX IF EXISTS js_tag_string_replacement_rules_1_idx;')
        mysql_list.append('DROP INDEX IF EXISTS js_tag_prefix_suffix_rules_1_idx;')
        mysql_list.append('DROP INDEX IF EXISTS js_tag_splitting_rules_1_idx;')

        try:
            for mysql in mysql_list:
                my_cursor.execute("begin")
                #~ if DEBUG: print(mysql)
                my_cursor.execute (mysql)
                my_cursor.execute("commit")
            #END FOR
        except Exception as e:
            if DEBUG: print("ts_uninstall_tag_rules_tables: Exception:", as_unicode(e))

        del mysql_list

        self.ts_drop_special_views(my_db,my_cursor)

        my_db.close()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_create_special_views(self,my_db,my_cursor):

        my_cursor.execute("begin")
        mysql = \
        """
        CREATE VIEW IF NOT EXISTS __js_tags_by_book AS SELECT book,tag,
        (SELECT name FROM tags WHERE id = books_tags_link.tag) AS tagname
        FROM books_tags_link
        ORDER BY book,tag;
        """
        my_cursor.execute (mysql)
        my_cursor.execute("commit")

        my_cursor.execute("begin")
        mysql = \
        """
        CREATE VIEW IF NOT EXISTS __js_tag_string_replacement_rules_by_tag
        AS SELECT
        __js_tags_by_book.book AS book,
        __js_tags_by_book.tagname AS tag,
        _js_tag_string_replacement_rules.old_string AS oldstring,
        _js_tag_string_replacement_rules.new_string AS newstring
        FROM __js_tags_by_book,_js_tag_string_replacement_rules
        WHERE (instr(__js_tags_by_book.tagname, _js_tag_string_replacement_rules.old_string) > 0) AND _js_tag_string_replacement_rules.old_string NOT NULL;
        """
        my_cursor.execute (mysql)
        my_cursor.execute("commit")

        my_cursor.execute("begin")
        mysql = \
        """
        CREATE VIEW IF NOT EXISTS __js_tags_by_book_concatenate
        AS  SELECT book, group_concat(myconcat,',') AS tagsconcat
        FROM (SELECT book,
        CASE
        WHEN tagname IS NULL THEN 'unknown'
        WHEN tagname = ',' THEN 'unknown'
        WHEN tagname = ' ' THEN 'unknown'
        WHEN tagname = ''  THEN 'unknown'
        ELSE tagname
        END AS myconcat
        FROM __js_tags_by_book ORDER BY tagname  )
        GROUP BY book;
        """
        my_cursor.execute (mysql)
        my_cursor.execute("commit")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_create_special_views_for_selected_table(self,table1,table2):

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        mysql = \
        """
        DROP VIEW IF EXISTS __js_tags_by_book
        """
        my_cursor.execute("begin")
        my_cursor.execute (mysql)
        my_cursor.execute("commit")


        if table1 == "tags":
            my_cursor.execute("begin")
            mysql = \
            """
            CREATE VIEW IF NOT EXISTS __js_tags_by_book AS SELECT book,tag,
            (SELECT name FROM tags WHERE id = books_tags_link.tag) AS tagname
            FROM books_tags_link
            ORDER BY book,tag;
            """
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            my_db.close()
            return

        #~ table1:   custom_column_N                                 id,value
        #~ table2:   books_custom_column_N_link              id,book,value    where value == custom_column_N.id

        mysql = \
        """
        CREATE VIEW IF NOT EXISTS __js_tags_by_book AS SELECT [BOOK,TAG],
        (SELECT [NAME] FROM [TAGS] WHERE id = [BOOKS_TAGS_LINK].[TAG]) AS tagname
        FROM [BOOKS_TAGS_LINK]
        ORDER BY [BOOK,TAG]
        """
        mysql = mysql.replace("[BOOK,TAG]","book,value")
        mysql = mysql.replace("[NAME]","value")
        mysql = mysql.replace("[TAGS]",table1)
        mysql = mysql.replace("[BOOKS_TAGS_LINK]",table2)
        mysql = mysql.replace("[TAG]","value")

        #~ if DEBUG: print(mysql)

        my_cursor.execute("begin")
        my_cursor.execute (mysql)
        my_cursor.execute("commit")
        my_db.close()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ts_drop_special_views(self,my_db,my_cursor):
        my_cursor.execute("begin")
        mysql = "DROP VIEW IF EXISTS __js_tags_by_book "
        my_cursor.execute (mysql)
        mysql = "DROP VIEW IF EXISTS __js_tag_string_replacement_rules_by_tag"
        my_cursor.execute (mysql)
        mysql = "DROP VIEW IF EXISTS __js_tags_by_book_concatenate"
        my_cursor.execute (mysql)
        mysql = "DROP VIEW IF EXISTS __js_tags_by_book"
        my_cursor.execute (mysql)
        my_cursor.execute("commit")
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_default_values_manually(self):
        self.apply_default_values_control(ids=None,source="manual")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_default_values_auto_add(self,ids):
        if prefs['GUI_TOOLS_QUALITY_FIXES_APPLY_DEFAULT_VALUES'] == unicode_type("True"):
            msg = "JS is applying 'Default Values'..."
            self.show_gui_status_bar_qtimer(msg,5000)
            self.apply_default_values_control(ids=ids,source="auto_adder")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_default_values_control(self,ids=None,source=None):
        if source is None:
            return

        custom_columns_metadata_dict = self.gui.current_db.field_metadata.custom_field_metadata()

        if len(custom_columns_metadata_dict) == 0:
            return

        if source == "manual":
            books_list = []
            book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids()))  #https://stackoverflow.com/questions/50671360/map-in-python-3-vs-python-2
            for item in book_ids_list:
                id = item['calibre_id']
                books_list.append(id)
            #END FOR
            del book_ids_list
        elif source == "auto_adder":
            if ids is None:
                return
            books_list = ids
            del ids
        else:
            return

        if len(books_list) == 0:
            return

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        if prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_1_ACTIVATE'] == unicode_type("True"):
            self.apply_default_values(my_db,my_cursor,custom_columns_metadata_dict,source,1,books_list)

        if prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_2_ACTIVATE'] == unicode_type("True"):
            self.apply_default_values(my_db,my_cursor,custom_columns_metadata_dict,source,2,books_list)

        if prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_3_ACTIVATE'] == unicode_type("True"):
            self.apply_default_values(my_db,my_cursor,custom_columns_metadata_dict,source,3,books_list)

        my_db.close()

        self.force_refresh_of_cache(books_list)  #not just for manual, since the js auto-add's special refresh assumes the db cache is fresh, and is not stale like it is here...

        del custom_columns_metadata_dict
        del books_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_default_values(self,my_db,my_cursor,custom_columns_metadata_dict,source,default,books_list):

        if default == 1:
            column = prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_1_CUSTOM_COLUMN']
            if prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_1_VALUE'] == unicode_type("False"):
                value = 0
            else:
                value = 1
        elif default == 2:
            column = prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_2_CUSTOM_COLUMN']
            if prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_2_VALUE'] == unicode_type("False"):
                value = 0
            else:
                value = 1
        elif default == 3:
            column = prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_3_CUSTOM_COLUMN']
            if prefs['GUI_TOOLS_APPLY_DEFAULT_VALUES_3_VALUE'] == unicode_type("False"):
                value = 0
            else:
                value = 1
        else:
            return

        if not column.startswith("#"):
            return
        else:
            mi_field = column

        if not mi_field in custom_columns_metadata_dict:
            if DEBUG: print("Custom Column #name is Invalid: ", mi_field)
            return

        custcol = custom_columns_metadata_dict[mi_field]   # should be a '#label'
        datatype = custcol['datatype']
        table = custcol['table']

        if not datatype == "bool":
            if DEBUG: print("Custom Column datatype is NOT boolean: ", mi_field)
            return

        mysql = "INSERT OR IGNORE INTO " + table + " (id,book,value) VALUES (null,?,?)  "

        try:
            my_cursor.execute("begin")
            for book in books_list:
                book = int(book)
                my_cursor.execute(mysql,(book,value))
                if DEBUG: print("Apply Defaults: ", mi_field, " >>> ", table, " >>> ", as_unicode(value), " >>> book: ", as_unicode(book))
            #END FOR
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print("Apply Default Values database update error: ", as_unicode(e))

        del custcol
        del mi_field
        del column
        del custom_columns_metadata_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def show_edit_identifiers_dialog(self):
        try:
            self.identifiers_edit_dialog.close()
        except:
            pass
        from calibre_plugins.job_spy.identifiers_edit_dialog import IdentifiersEditDialog
        self.identifiers_edit_dialog = IdentifiersEditDialog(self.maingui,self.maingui)
        self.identifiers_edit_dialog.setAttribute(Qt.WA_DeleteOnClose)
        self.identifiers_edit_dialog.show()
        del IdentifiersEditDialog
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def refresh_format_file_sizes_tool(self):
        rows = self.maingui.library_view.selectionModel().selectedRows()
        if not rows:
            error_dialog(self.maingui, _('JS+ GUI Tool'),_('Cannot update format file sizes since no books were selected'), show=True)
            return
        ids = [self.maingui.library_view.model().id(r) for r in rows]
        payload = ids
        id_map = {}
        n_books = len(ids)
        n_formats = 0
        for book_id in ids:
            formats = self.maingui.current_db.new_api.formats(book_id, verify_formats=False)
            if not formats:
                n_books = n_books -1
                continue
            for format in formats:
                book_path = self.maingui.current_db.new_api.format_abspath(book_id, format)
                if not book_path:
                    continue
                if os.path.exists(book_path):
                    n_formats = n_formats + 1
                    actual_size = os.path.getsize(book_path)
                    self.maingui.current_db.new_api.format_metadata(book_id, format, allow_cache=False,update_db=True)  #updates the db
                    self.maingui.current_db.new_api.format_metadata(book_id, format, allow_cache=True,update_db=False)  #updates the cache
                    if DEBUG: print("refresh_format_file_sizes_tool: ", as_unicode(book_id), "  ", " format size refreshed: ", format, "  real size: ", as_unicode(actual_size))
                    mi = Metadata(_('Unknown'))
                    id_map[book_id] = mi    #do-nothing Edit Metadata just to get the gui row for each book to refresh so it is identical to the cache and metadata.db
            #END FOR
        #END FOR
        if n_formats > 0:
            edit_metadata_action = self.maingui.iactions['Edit Metadata']
            edit_metadata_action.apply_metadata_changes(id_map, callback=None,merge_tags=True)
            if n_books > 1:
                msg = "All " + as_unicode(n_formats) + " format sizes for " + as_unicode(len(ids)) + " selected books have been refreshed."
            else:
                if n_formats > 1:
                    msg = "All " + as_unicode(n_formats) + " format sizes for the single selected book have been refreshed."
                else:
                    msg = "The single format size for the single selected book has been refreshed"
        else:
            msg = "No formats found for the selected book(s); nothing done."
        self.gui.status_bar.showMessage(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def import_csv_file_to_update_metadata(self):
        try:
            self.import_csv_file_to_update_metadata_dialog.close()
        except:
            pass
        default_user_csv_directory = prefs['GUI_TOOLS_IMPORT_CSV_FILE_TO_UPDATE_METADATA_DEFAULT_DIRECTORY']
        import_tuple = QFileDialog.getOpenFileName(None,"Import Any Tag Scrubbing Table UTF-8 Encoded CSV Text File ",default_user_csv_directory,("CSV Files (*.csv *.txt)") )
        if not import_tuple:
            return None
        path, dummy = import_tuple
        if not path:
            return None
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        head,tail = os.path.split(path)
        prefs['GUI_TOOLS_IMPORT_CSV_FILE_TO_UPDATE_METADATA_DEFAULT_DIRECTORY'] = head
        if os.path.isfile(path):
            prefs
            csv_path = path
        else:
            return

        from calibre_plugins.job_spy.import_csv_file_to_update_metadata_dialog import ImportCSVFileToUpdateMetadataDialog
        self.import_csv_file_to_update_metadata_dialog = ImportCSVFileToUpdateMetadataDialog(self.maingui,self.maingui,self.qaction.icon(),csv_path)
        self.import_csv_file_to_update_metadata_dialog.setAttribute(Qt.WA_DeleteOnClose)
        del ImportCSVFileToUpdateMetadataDialog
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def show_comments_viewer_dialog(self):
        try:
            self.jscommentsviewerdialog.close()
        except:
            pass

        rows = self.maingui.library_view.selectionModel().selectedRows()
        if not rows:
            error_dialog(self.maingui, _('JS+ GUI Tool'),_('Cannot View Comments since no books were selected'), show=True)
            return

        selected_list = [self.maingui.library_view.model().id(r) for r in rows]

        from calibre_plugins.job_spy.comments_viewer_dialog import JSCommentsViewerDialog
        self.jscommentsviewerdialog = JSCommentsViewerDialog(self.maingui,self.guidb,self.qaction.icon(),selected_list)
        self.jscommentsviewerdialog.setAttribute(Qt.WA_DeleteOnClose)
        del JSCommentsViewerDialog
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_last_viewed_custom_column_automatically_control(self,source='library_changed'):

        self.update_last_viewed_custom_column_is_active = False

        if prefs['GUI_TOOLS_UPDATE_LAST_VIEWED_CUSTOM_COLUMN_AUTOMATICALLY_ACTIVATE'] == unicode_type("False"):
            return

        if source == 'library_changed':
            self.gui.iactions['View']._view_calibre_books = self.original_gui_iaction_view
            self.gui.iactions['View'].view_format_by_id = self.original_gui_iaction_view_format_by_id

        self.guidb = self.gui.library_view.model().db
        path = self.guidb.library_path
        path = path.replace(os.sep, '/')
        current_libname = self.decompose_library_path(path)

        libs = prefs['GUI_TOOLS_UPDATE_LAST_VIEWED_CUSTOM_COLUMN_AUTOMATICALLY_LIBRARIES']
        libs = libs + "|"
        libs_list = libs.split("|")

        if "*" in libs_list:
            if DEBUG: print("wildcard specified in Job Spy last-viewed tool active library names, which includes: ", current_libname)
        else:
            if not current_libname in libs_list:
                if DEBUG: print("current library not specified in Job Spy last-viewed tool active library names...", current_libname)
                return
            else:
                if DEBUG: print("Job Spy last-viewed tool active library names includes: ", current_libname)

        last_viewed_column = prefs['GUI_TOOLS_UPDATE_LAST_VIEWED_CUSTOM_COLUMN_AUTOMATICALLY_COLUMN_NAME']

        if not last_viewed_column in self.custom_columns_metadata_dict:
            if DEBUG: print("Job Spy last-viewed tool custom column was not found in the current Library: ", last_viewed_column)
            return

        custcol_dict = self.custom_columns_metadata_dict[last_viewed_column]
        cc_datatype = custcol_dict['datatype']
        if not cc_datatype == "datetime":
            prefs['GUI_TOOLS_UPDATE_LAST_VIEWED_CUSTOM_COLUMN_AUTOMATICALLY_ACTIVATE'] = unicode_type("False")
            prefs
            if DEBUG: print("Job Spy last-viewed tool custom column is not a 'datetime' custom column type: ", last_viewed_column, " >>> ", cc_datatype)
            return

        self.last_viewed_column_key = self.gui.library_view.model().db.field_metadata.key_to_label(last_viewed_column)

        self.update_last_viewed_custom_column_is_active = True

        self.gui.iactions['View']._view_calibre_books = self.view_then_datestamp

        self.gui.iactions['View'].view_format_by_id = self.view_format_then_datestamp

        try:
            self.maingui.book_details.view_specific_format.disconnect(self.original_gui_iaction_view_format_by_id)     #disconnect, or original connection will still be active causing 2 view actions to execute simultaneously...
        except Exception as e:
            if DEBUG: print(">>>[1] update_last_viewed_custom_column_automatically_control", source, as_unicode(e))

        try:
            self.maingui.book_details.view_specific_format.disconnect(self.maingui.iactions['View'].view_format_by_id)     #disconnect for same reason as above
        except Exception as e:
            if DEBUG: print(">>>[2] update_last_viewed_custom_column_automatically_control with source:  ", source, as_unicode(e))

        self.maingui.book_details.view_specific_format.connect(self.maingui.iactions['View'].view_format_by_id)  #now reconnect the signal to the "new"  iactions['View'].view_format_by_id

        del libs_list
        del custcol_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def view_then_datestamp(self,ids_list):
        #~ Context menu:  v
        self.original_gui_iaction_view(ids_list)
        if not self.update_last_viewed_custom_column_is_active:
            return
        for id in ids_list:
            dt = datetime.datetime.now()
            dt = format_date(dt, format='iso', assume_utc=False, as_utc=False)
            self.gui.library_view.model().db.set_custom(id, dt, label=self.last_viewed_column_key, commit=True)
            if DEBUG: print("view_then_datestamp: set to: ", as_unicode(dt),"   for book: ", as_unicode(id))
    #---------------------------------------------------------------------------------------------------------------------------------------
    def view_format_then_datestamp(self,id,format,open_at=None):
        #~ Context menu: alt+v
        #~ Book Details: clicking a format to open it
        #~ Annotations in Calibre 5:   self.gui.iactions['View'].view_format_by_id(book_id, fmt, open_at=cfi)    [open_at is for annotations]

        self.original_gui_iaction_view_format_by_id(id,format,open_at=open_at)

        if DEBUG and open_at is not None:
            print("view_format_then_datestamp --- annotations' open_at: ", as_unicode(open_at))

        if not self.update_last_viewed_custom_column_is_active:
            return

        dt = datetime.datetime.now()
        dt = format_date(dt, format='iso', assume_utc=False, as_utc=False)
        self.gui.library_view.model().db.set_custom(id, dt, label=self.last_viewed_column_key, commit=True)
        if DEBUG: print("view_format_then_datestamp: set to: ", as_unicode(dt),"   for book: ", as_unicode(id))
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_bibliography_text(self):

        #~ Example: 'AUTHOR (YYYY): TITLE' ---> 'John Smith (2020): Avoiding the Wuhan Virus'.  ['et al' never appears even if multiple Authors] \
        #~ Example: 'LN, 'TITLE', YYYY' ---> 'Smith, 'Avoiding the Wuhan Virus', 2020.\
        #~ Example: 'AUTHOR, YYYY' ---> 'John Smith 2020'.\
        #~ Example: 'TITLE. PUBLISHER, YYYY.' ---> 'Avoiding the Wuhan Virus. Science Publishing Group, 2020'.\
        #~ Example: 'AUTHOR_SORT, YYYY' ---> 'Smith, John 2020' OR 'John Smith 2020' depending on your personal Preferences > Tweaks for 'author_sort_copy_method'\
        #~ Example: 'AUTHOR ET AL (YYYY): TITLE' ---> 'John Smith et al (2020): Avoiding the Wuhan Virus'.  ['et al' appears only if there exist multiple Authors]\
        #~ Example: 'AUTHOR_SORT. TITLE. PUBLISHER, YYYY' ---> 'Smith, John. Avoiding the Wuhan Virus. Science Publishing Group, 2020.\
        #~ Example: 'AUTHOR_SORT. 'TITLE'. SERIES, no. SERIES_INDEX (MONTH YYYY)' ---> 'Smith, John. 'Avoiding the Wuhan Virus'. The Journal of Science, no. 18 (April 2020)."

        self.guidb = self.gui.library_view.model().db

        self.selected_books_list = self.get_selected_books()
        if len(self.selected_books_list) == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Books Were Selected.'), show=True)
        self.selected_books_list.sort()

        template = prefs['GUI_TOOLS_BIBLIOGRAPHY_TEXT_TEMPLATE']
        if len(template) < 5:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Template is invalid; correct it in JS Customizing.'), show=True)

        #~ if DEBUG: template = "AUTHOR_SORT ET AL.'TITLE'. SERIES, no. SERIES_INDEX #mybib1(MONTH YYYY) PUBLISHER #mybib2, #mybib3:, #mybib4. AUTHOR."
        #   example results:           Snyder, Timothy.'On Tyranny'. DaltonST10(February 2017) Tim Duggan Books DaltonST2a, 30:, DaltonST40. Timothy Snyder.

        bibcc_set = self.find_custom_column_keywords(template)

        from calibre.utils.config_base import tweaks
        ascm = tweaks['author_sort_copy_method']

        if "ET AL" in template:
            is_etal = True
        else:
            is_etal = False

        bib_list = []
        for id in self.selected_books_list:
            id = int(id)
            bib = self.populate_bibliography_text(template,bibcc_set,id,is_etal,ascm)
            bib = bib + "\n"
            bib_list.append(bib)
        #END FOR

        bib = "".join(bib_list)

        self.clip.setText(bib)

        del bib
        del bib_list
        del bibcc_set
    #---------------------------------------------------------------------------------------------------------------------------------------
    def populate_bibliography_text(self,template,bibcc_set,id,is_etal,ascm):

        bib = template  #  AUTHOR_SORT ET AL.'TITLE'. SERIES, no. SERIES_INDEX (MONTH YYYY) PUBLISHER.

        mi = self.guidb.new_api.get_metadata(id,False,False)

        bib_dict,bibcc_dict = self.get_bibliography_template_columns(is_etal,ascm,mi,bib,bibcc_set)

        author = bib_dict["AUTHOR"]
        fn = bib_dict["FN"]
        ln = bib_dict["LN"]
        author_sort = bib_dict["AUTHOR_SORT"]
        etal = bib_dict["ETAL"]
        title = bib_dict["TITLE"]
        yyyy = bib_dict["YYYY"]
        mnth = bib_dict["MM"]
        month = bib_dict["MONTH"]
        publisher = bib_dict["PUBLISHER"]
        series = bib_dict["SERIES"]
        series_index = bib_dict["SERIES_INDEX"]

        #~ SERIES, no. SERIES_INDEX
        if not series > "":
            bib = bib.replace("SERIES, no. SERIES_INDEX","")
            bib = bib.replace("SERIES_INDEX","")
            bib = bib.replace("SERIES","")
            bib = bib.replace("no.","")
            bib = bib.replace(" , "," ")
            bib = bib.replace("  "," ")

        bib = bib.replace("  . ",". ")

        #avoid substring replaces prematurely...
        bib = bib.replace("AUTHOR_SORT",author_sort)
        bib = bib.replace("AUTHOR",author)
        bib = bib.replace("FN",fn)
        bib = bib.replace("LN",ln)
        bib = bib.replace("ET AL",etal)
        bib = bib.replace("TITLE",title)
        bib = bib.replace("YYYY",yyyy)
        bib = bib.replace("MM",mnth)
        bib = bib.replace("MONTH",month)
        bib = bib.replace("PUBLISHER",publisher)
        bib = bib.replace("SERIES_INDEX",series_index)
        bib = bib.replace("SERIES",series)

        for k,v in iteritems(bibcc_dict):
            bib = bib.replace(k,v)
            if DEBUG: print("bibcc_dict: ",k,v)
        #END FOR

        bib = bib.strip()
        bib = bib.replace(",.",".")
        bib = bib.replace(",,",",")
        if bib.endswith(" ."):
            bib = bib[0:-2] + "."
        bib = bib.replace("et al .","et al.")
        bib = bib.replace("  .",".")
        bib = bib.replace("  "," ")

        if DEBUG: print("Bibliography Text: ", bib)

        del bib_dict
        del bibcc_dict

        return bib
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_bibliography_template_columns(self,is_etal,ascm,mi,bib,bibcc_set):

        bib_dict = {}
        fn = ""
        ln = ""

        authors = mi.authors
        if isinstance(authors,list):
            if len(authors) > 0:
                if len(authors) == 1:
                    is_etal = False
                author = authors[0]
            else:
                author = None
        elif isinstance(unicode_type):
            author = authors
        else:
            author = None

        if author is None:
            author = "Unknown"
            fn = "Unknown"
            ln = "Unknown"
            author_sort = "Unknown"
        else:
            author_sort = mi.author_sort
            if author_sort is None:
                author_sort = author
                ascm = "copy"

            if "&" in author_sort: #~ Cussler, Clive & Brown, Graham.
                if DEBUG: print("if & in author_sort: ", author_sort)
                n = author_sort.find("&")
                author_sort = author_sort[0:n].strip()
                if DEBUG: print("Truncated multiple authors author_sort: ", author_sort)

            if ascm == "invert":             #use "fn ln" -> "ln, fn"
                if "," in author_sort:
                    ssplit = author_sort.split(",")
                    ln = ssplit[0]
                    fn = ssplit[1]
                else:
                    ln = author
                    fn = ""
            elif ascm == "copy":           #copy author to author_sort without modification
                if " " in author:
                    ssplit = author.split(" ")
                    fn = ssplit[0]
                    ln = ssplit[1]
                else:
                    fn = author
                    ln = ""
            elif ascm == "comma":       #use 'copy' if there is a ',' in the name, otherwise use 'invert'
                if "," in author_sort:
                    ssplit = author_sort.split(",")
                    ln = ssplit[0]
                    fn = ssplit[1]
                else:
                    ln = author
                    fn = ""
            elif ascm == "nocomma":    #use "fn ln" -> "ln fn" (without the comma)
                if " " in author:
                    ssplit = author.split(" ")
                    fn = ssplit[0]
                    ln = ssplit[1]
                else:
                    fn = author
                    ln = ""
            else:
                fn = author
                ln = ""

        if author_sort.endswith(","):
            author_sort = author_sort[0:-1]
        if author.endswith(","):
            author = author[0:-1]

        bib_dict["AUTHOR_SORT"] =  author_sort
        bib_dict["AUTHOR"] =  author
        bib_dict["FN"] = fn
        bib_dict["LN"] =  ln

        publisher = mi.publisher
        if publisher is None:
            publisher = ""
        bib_dict["PUBLISHER"] =  publisher

        pubdate = mi.pubdate
        pubdt = mi.pubdate
        if pubdate is None:
            pubdate = "0000"
            month = "TBD"
            mnth = "00"
        else:
            try:
                month = pubdt.strftime("%B")
                mnth = pubdt.strftime("%m")
            except:  #year before 1900 causes .strftime error
                pubdt = unicode_type(pubdt)
                #~ 1856-10-13
                mnth = pubdt[5:7]
                month = self.derive_month(mnth)
            pubdate = unicode_type(pubdate)
        bib_dict["YYYY"] = pubdate[0:4]
        bib_dict["MONTH"] = month
        bib_dict["MM"] = mnth

        title = mi.title
        if title is None:
            title = "Unknown"
        bib_dict["TITLE"] = title

        series = mi.series
        if series is None:
            series = ""
        bib_dict["SERIES"] = series

        if series > "":
            series_index = mi.series_index
            if series_index is None:
                series_index = ""
        else:
            series_index = ""
        series_index = as_unicode(series_index)
        series_index = series_index.replace("0.0","0")
        if len(series_index) > 2:
            if series_index.startswith("0"):
                series_index = series_index[1:]
        series_index = series_index.replace(".0","")
        bib_dict["SERIES_INDEX"] = series_index

        if is_etal:
            bib_dict["ETAL"] =  " et al "
        else:
            bib_dict["ETAL"] =  " "

        bib_cc_dict = {}

        if len(bibcc_set) > 0:
            for cc in bibcc_set:
                value = mi.get(cc)
                if value is None:
                    value = ""
                elif isinstance(value,unicode_type):  #e.g. comments short-text
                    value = value.strip()
                elif isinstance(value,list):  #e.g. tag-like
                    s = ""
                    for v in value:
                        s = s + v + ", "
                    #END FOR
                    s = s.strip()
                    if s.endswith(","):
                        s = s[0:-1]
                    value = s.strip()
                else:  # int, float, etc.
                    value = as_unicode(value)
                bib_cc_dict[cc] = value
                if DEBUG: print("bib_cc_dict: cc,value: ", cc, value)
            #END FOR

        return bib_dict,bib_cc_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def find_custom_column_keywords(self,bib):
        bibcc_set = set()
        cc_list = []
        expr = "([#][a-z0-9]+)"        # AUTHOR_SORT ET AL.'TITLE'. SERIES, no. SERIES_INDEX #mybib1(MONTH YYYY) PUBLISHER #mybib2, #mybib3: #mybib4.
        try:
            cc_list = re.findall(expr,bib)
            for row in cc_list:
                if row is not None:
                    cc = as_unicode(row)
                    cc = cc.strip()
                    if cc != "":
                        bibcc_set.add(cc)
                        if DEBUG: print("Template #CC Found: ", cc)
            #END FOR
        except Exception as e:
            if DEBUG: print("REGEX Error in:  def find_custom_column_keywords(self,bib):", as_unicode(e), "  for: ", bib)

        del cc_list
        return bibcc_set
    #---------------------------------------------------------------------------------------------------------------------------------------
    def derive_month(self,month):
        if month is None:
            return ""

        if month == "01":
            month = "January"
        elif month == "02":
            month = "February"
        elif month == "03":
            month = "March"
        elif month == "04":
            month = "April"
        elif month == "05":
            month = "May"
        elif month == "06":
            month = "June"
        elif month == "07":
            month = "July"
        elif month == "08":
            month = "August"
        elif month == "09":
            month = "September"
        elif month == "10":
            month = "October"
        elif month == "11":
            month = "November"
        elif month == "12":
            month = "December"

        return month
    #-------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ris_citation_file_split_sets_of_tags(self):

        try:
            self.ris_citation_file_split_auto_add_path = gprefs['auto_add_path']  # os path to be watched by auto_adder
            if self.ris_citation_file_split_auto_add_path is None:
                if DEBUG: print("gprefs['auto_add_path'] is None...")
                msg = "Your Calibre Preferences for Auto-Adding books are invalid or incomplete."
                return error_dialog(self.maingui, _('JS+ GUI Tool: RIS Citation - Split Sets of RIS Tags'),_(msg), show=True)

            if not os.path.isdir(self.ris_citation_file_split_auto_add_path):
                if DEBUG: print("gprefs['auto_add_path'] is not a valid Directory...")
                msg = "Your Calibre Preferences for Auto-Adding books are invalid or incomplete."
                return error_dialog(self.maingui, _('JS+ GUI Tool: RIS Citation - Split Sets of RIS Tags'),_(msg), show=True)

            if DEBUG: print("the self.ris_citation_file_split_auto_add_path:  ", self.ris_citation_file_split_auto_add_path)

            self.ris_citation_file_to_split = self.get_ris_citation_file_to_split()

            if DEBUG: print("gotten file:  ", str(self.ris_citation_file_to_split))  # gotten file:   ('X:/MyPluginsPy3/_ris_import_dir/test3.ris', 'All Files (*)')

            if self.ris_citation_file_to_split is None:
                if DEBUG: print("self.ris_citation_file_to_split is None...")
                msg = "No source RIS file to split was selected..."
                return error_dialog(self.maingui, _('JS+ GUI Tool: RIS Citation - Split Sets of RIS Tags'),_(msg), show=True)

            if isinstance(self.ris_citation_file_to_split,tuple):
                path,filter = self.ris_citation_file_to_split
                self.ris_citation_file_to_split = path
            else:
                if DEBUG: print("self.ris_citation_file_to_split is not a tuple...")
                msg = "Program Error: Source RIS file to split path error."
                return error_dialog(self.maingui, _('JS+ GUI Tool: RIS Citation - Split Sets of RIS Tags'),_(msg), show=True)

            if not os.path.isfile(self.ris_citation_file_to_split):
                if DEBUG: print("self.ris_citation_file_to_split is not a valid File...")
                msg = "Source RIS file to split path error.  It is not a valid file..."
                return error_dialog(self.maingui, _('JS+ GUI Tool: RIS Citation - Split Sets of RIS Tags'),_(msg), show=True)

            last_used_dir,filename = os.path.split(self.ris_citation_file_to_split)

            if last_used_dir is not None:
                if os.path.isdir(last_used_dir):
                    last_used_dir = last_used_dir.replace(os.sep, '/')
                    prefs['GUI_TOOLS_RIS_CITATION_FILE_SPLIT_SETS_OF_TAGS'] = last_used_dir
                    prefs
                else:
                    if DEBUG: print("last_used_dir is an invalid directory: ", last_used_dir)

            QTimer.singleShot(0, self.do_ris_citation_file_split)

            QApplication.instance().processEvents()

        except Exception as e:
            if DEBUG: print("Error:  ris_citation_file_split_sets_of_tags: ",as_unicode(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_ris_citation_file_to_split(self):

        filters=['RIS (*.ris)']

        last_used_dir = prefs['GUI_TOOLS_RIS_CITATION_FILE_SPLIT_SETS_OF_TAGS']

        if not os.path.isdir(last_used_dir):
            msg = "Have you already set your Calibre > Preferences > Add Books > Automatic Adding properly?"
            msg = msg + "<br><br>RIS .ris file types are not ebook formats, so you must specify the proper Auto-Add option in the Preferences, "
            msg = msg + "or the newly exploded .ris files will not be automatically added by Calibre as new 'books'.  You will have to manually Drag-and-Drop them to add them."
            msg = msg + "<br><br>You must Restart Calibre after updating those Preferences."
            msg = msg + "<br><br>If you use the JS+ Tweak to specify an Auto-Add Directory by Library, you must do the above too."
            if question_dialog(self.gui, "JS+ GUI Tool: RIS Citation - Split Sets of RIS Tags", msg):
                pass
            else:
                return

        fd = QFileDialog()
        fd.setFileMode(QFileDialog.FileMode.ExistingFile)
        fd.setNameFilters(filters)
        if os.path.isdir(last_used_dir):
            fd.setDirectory(last_used_dir)
        fd.setParent(None)

        if fd.accepted:
            return fd.getOpenFileName()

        return None
    #---------------------------------------------------------------------------------------------------------------------------------------
    def do_ris_citation_file_split(self):

        msg = "The selected RIS file will be split into individual sets of RIS Tags, one new file per set."
        self.show_gui_status_bar_qtimer(msg,5000)
        if DEBUG: print(msg)

        QApplication.instance().processEvents()

        num_errors = 0
        num_written = 0
        error_list = []
        outfile_path = ""

        try:
            split_file_dict = self.read_and_split_source_ris_file()

            if len(split_file_dict) == 0:
                msg = "Selected File Has No RIS Tags.  <br>RIS File Could Not Be Split:  <br>" + self.ris_citation_file_to_split
                if DEBUG: print(msg)
                return error_dialog(self.maingui, _('JS+ GUI Tool: RIS Citation - Split Sets of RIS Tags'),_(msg), show=True)

            msg = "The selected large RIS file, " + self.ris_citation_file_to_split + ", will be split into " + str(len(split_file_dict)) + " single RIS Tag set .ris file(s), "
            msg = msg + "which will be added to the Calibre 'Auto-Add' folder, " + str(self.ris_citation_file_split_auto_add_path) + ", for normal Calibre processing.<br><br>Continue?"

            if len(split_file_dict) < 1000:
                if question_dialog(self.gui, "JS+ GUI Tool: RIS Citation - Split Sets of RIS Tags", msg):
                    pass
                else:
                    return
            else:
                msg = msg + "<br><br><b>This may take Calibre some time to 'Auto-Add'.</b><br><br>Continue?"
                if question_dialog(self.gui, "JS+ GUI Tool: RIS Citation - Split Sets of RIS Tags", msg):
                    pass
                else:
                    return

            self.ris_citation_file_split_auto_add_path = str(self.ris_citation_file_split_auto_add_path)

            for uniquename,tags in iteritems(split_file_dict):
                #~ if DEBUG: print("\n\n", uniquename,"\n", tags, "\n")
                outfile_name = str(uniquename) + ".ris"
                outfile_path = os.path.join(self.ris_citation_file_split_auto_add_path,outfile_name)
                outfile_path = outfile_path.replace(os.sep, '/')
                if DEBUG: print("outfile_path: ", outfile_path, "\n")
                try:
                    with open(outfile_path, 'wt', encoding='utf-8') as f:
                        f.write(tags)
                    #END WITH
                    f.close()
                    del f
                    num_written = num_written + 1
                except Exception as e:
                    num_errors = num_errors + 1
                    msg = "Save to .RIS File Error: " + str(e) + "for: " + outfile_path + "\n\n"
                    error_list.append(msg)
                    if DEBUG: print(msg)
            #END FOR

            if DEBUG: print("Number of new .ris files written: ", str(num_written))

            msg = "The selected source RIS file, " + self.ris_citation_file_to_split + ", has been split into " + str(len(split_file_dict)) + " single RIS Tag set .ris files, "
            msg = msg + "which have already been added to the Calibre 'Auto-Add' folder, " + str(self.ris_citation_file_split_auto_add_path) + ", for normal Calibre processing."
            msg = msg + "<br><br>You may monitor the  'Auto-Add' folder progress by opening that folder in your file manager.  After each new book is added, it will be deleted from that folder."
            info_dialog(self.gui, 'JS+ GUI Tool: RIS Citation - Split Sets of RIS Tags',msg).show()
            if DEBUG: print(msg)

            del split_file_dict

            msg = "Auto-Add Process..."
            self.show_gui_status_bar_qtimer(msg,5000)
            if DEBUG: print(msg)

            QApplication.instance().processEvents()

        except Exception as e:
            msg = "Fatal Exception in Splitting the Source RIS File: " + as_unicode(e)
            if num_errors > 0:
                if num_errors > 20:
                    error_list = error_list[0:19]
                s = "".join(error_list)
                msg = msg + "<br><br>" + s
            if DEBUG: print(msg)
            return error_dialog(self.maingui, _('JS+ GUI Tool: RIS Citation - Split Sets of RIS Tags'),_(msg), show=True)

        if num_errors > 0:
            if num_errors > 20:
                error_list = error_list[0:19]
            msg = "".join(error_list)
            if DEBUG: print(msg)
            return error_dialog(self.maingui, _('JS+ GUI Tool: RIS Citation - Split Sets of RIS Tags'),_(msg), show=True)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def read_and_split_source_ris_file(self):
        split_file_dict = {}  #  [timeinsecondssincebeginningofepochtime] = set of RIS Tags

        try:
            with open(self.ris_citation_file_to_split, 'r') as f:
                lines = f.readlines()  #each line is an RIS Tag, which may be long comments that wrap...
            f.close()
            del f
        except Exception as e:
            pass

        if DEBUG: print("number of lines from readlines: ", str(len(lines)))

        END_OF_RECORD = "ER"

        #~ The following variables and later related logic are also used for the identical purpose in '[File Type Plugin] Extract RIS Citations'.  Keep results in synch.
        TAG_TITLE_T1 = "T1"  # DOI-sourced .ris files have a T1, and no TI (usually)
        TAG_TITLE_TI = "TI"    # Zotero-sourced .ris files have a TI, and no T1 (usually)
        title_t1_value = None
        title_ti_value = None

        import time
        curr_time = round(time.time()*1000)
        curr_time = int(curr_time)

        current_ris_tag_set_list = []

        for line in lines:
            if line.startswith(END_OF_RECORD):
                if title_t1_value is None:
                    if title_ti_value is not None:
                        title_line = title_ti_value
                        title_line = title_line.replace(TAG_TITLE_TI,TAG_TITLE_T1,1)
                        current_ris_tag_set_list.append(title_line)
                        if DEBUG: print("TAG_TITLE_T1 added: ", title_line)
                elif title_ti_value is None:
                    if title_t1_value is not None:
                        title_line = title_t1_value
                        title_line = title_line.replace(TAG_TITLE_T1,TAG_TITLE_TI,1)
                        current_ris_tag_set_list.append(title_line)
                        if DEBUG: print("TAG_TITLE_TI added: ", title_line)
                current_ris_tag_set_list.append(line)
                curr_time = curr_time + 1
                k = str(curr_time)
                v = "".join(current_ris_tag_set_list)
                split_file_dict[k] = v
                current_ris_tag_set_list.clear()
                title_t1_value = None
                title_ti_value = None
                continue
            else:
                current_ris_tag_set_list.append(line)
                if line.startswith(TAG_TITLE_T1):
                    title_t1_value = line
                elif line.startswith(TAG_TITLE_TI):
                    title_ti_value = line
        #END FOR

        return split_file_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_ris_citation_tags_custom_columns(self):

        QApplication.instance().processEvents()

        msg = "Warning:  This can create up to ~55 New Custom Columns in THIS Library! \
        <br><br>Before proceeding, you MUST have: \
        <br><br>[1] Installed the '[File-Type Plugin] Extract RIS Citations' plugin; and,\
        <br><br>[2] Viewed and saved the ERC plugin's default configuration via 'Calibre > Preferences > Plugins > Customize'; and,\
        <br><br>[3] Backed up your Calibre metadata.db file in a safe place in case you do not like the results of this GUI Tool; and,\
        <br><br>[4] Backed up your current ERC configuration file,  '...\calibre\plugins\Extract RIS Citations.json'.\
        <br><br><br>If you have done all of the above already, click 'Yes'.<br>Otherwise, click 'No' to abort this execution."

        if question_dialog(self.maingui, "JS+ GUI Tool - Create #ris_custom_columns", msg):
            pass
        else:
            return

        msg = "Restart required to finalize new custom columns.\
        <br><br>You may manually delete as you wish any newly created #ris_... custom columns that you selected to create, but later do not need.\
        <br><br>If you later wish to re-add those manually deleted custom columns, or others that you originally did not select to be added, simply execute this GUI Tool again.  \
        Already-existing #ris_... custom columns will be skipped.  Only ones you choose will be added (or re-added).\
        <br><br>Note: All ERC Plugin mappings of RIS Tag to Target Column may be updated whenever this Tool is executed, depending on what you select and what you decide to do.  Review them after Calibre restarts.\
        <br><br>\
        <br><br>Ready to proceed immediately?"

        if question_dialog(self.maingui, "JS+ GUI Tool - Create #ris_custom_columns", msg):
            pass
        else:
            return

        from calibre_plugins.job_spy.ris_tags_custom_columns import (ris_add_custom_column_control,
                                                                                                                           create_custom_column_creation_params,
                                                                                                                           ris_add_custom_column,
                                                                                                                           return_ris_tag_name_target_list,
                                                                                                                           set_ris_plugin_prefs_for_tag_mapping)

        self.guidb = self.maingui.library_view.model().db

        self.guidb.prefs['field_metadata'] = self.guidb.field_metadata.all_metadata()

        js_icon = get_icon('images/job_spy.png')

        msg = None

        try:
            was_success,error_msg = ris_add_custom_column_control(self.guidb.prefs,self.guidb,self.plugin_path,js_icon)
        except Exception as e:
            error_msg = "Error in ris_add_custom_column_control: " + str(e)
            if DEBUG: print(error_msg)
            was_success = False
            msg = "There was a fatal error.  " + error_msg
            error_dialog(self.gui, _('JS+ GUI Tool'),_(msg), show=True)

        self.guidb.prefs['field_metadata'] = self.guidb.field_metadata.all_metadata()

        QApplication.instance().processEvents()

        if not was_success:
            msg = "There was an error: " + error_msg + "<br><br>After Restarting, review the new Custom Columns in Calibre > Preferences.  Also review the ERC plugin's customization.<br><br>Click a button to continue."
            if question_dialog(self.maingui, "JS+ GUI Tool - Create #ris_custom_columns", msg):
                pass
        else:
            if msg is not None:
                msg = msg + "<br><br>Click any button below to continue to a Calibre Restart..."
                if question_dialog(self.maingui, "JS+ GUI Tool - Create #ris_custom_columns", msg):
                    pass

        self.maingui.quit(restart=True)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def copy_ris_custom_columns_to_related_format_control(self):

        msg = "Select Simultaneously: \
        <br><br>One (1) Single RIS Format book as the 'Source' of the RIS #ris_... Custom Column Metadata.\
        <br><br>One (1) Single ZMI Format (e.g. PDF/TXT/EPUB) book as the 'Target' of the 'Source' RIS #ris_... Custom Column Metadata.\
        <br><br>Once you have selected the pair of two (2) books, click 'YES' to continue, or 'NO' to cancel this action."
        if question_dialog(self.maingui, "JS+ GUI Tool - Copy RIS Format Custom Columns to ZMI Format", msg):
            pass
        else:
            return

        selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books != 2:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Exactly two (2) Source Books Were Not Selected.'), show=True)

        first_bookid = int(selected_books_list[0])
        second_bookid = int(selected_books_list[1])

        if DEBUG: print("first_bookid: ", str(first_bookid))
        if DEBUG: print("second_bookid: ",str(second_bookid))

        first_mi = self.maingui.library_view.model().db.get_metadata(first_bookid, index_is_id=True, get_user_categories=False)
        second_mi = self.maingui.library_view.model().db.get_metadata(second_bookid, index_is_id=True, get_user_categories=False)

        first_title = first_mi.title
        second_title = second_mi.title

        if DEBUG: print("first_title: ", str(first_title))
        if DEBUG: print("second_title: ",str(second_title))

        first_formats_list = first_mi.formats
        second_formats_list = second_mi.formats

        if DEBUG: print("first_formats: ", str(first_formats_list))
        if DEBUG: print("second_formats: ",str(second_formats_list))

        if 'RIS' in first_formats_list and 'RIS' in second_formats_list:
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('Both selected books have an RIS format, which is not allowed.'), show=True)

        if 'RIS' in first_formats_list:
            source_mi = first_mi                   # class 'calibre.ebooks.metadata.book.base.Metadata'
            source_bookid = first_bookid
            source_title = first_title
            source_formats = ",".join(first_formats_list)
            target_mi = second_mi               # class 'calibre.ebooks.metadata.book.base.Metadata'
            target_bookid = second_bookid
            target_title = second_title
            target_formats  = ",".join(second_formats_list)
        elif 'RIS' in second_formats_list:
            source_mi = second_mi
            source_bookid = second_bookid
            source_title = second_title
            source_formats  = ",".join(second_formats_list)
            target_mi = first_mi
            target_bookid = first_bookid
            target_title = first_title
            target_formats  = ",".join(first_formats_list)

        source_authors_list = self.guidb.new_api._field_ids_for('authors', source_bookid)
        target_authors_list = self.guidb.new_api._field_ids_for('authors', target_bookid)

        sas = set(source_authors_list)
        tas = set(target_authors_list)

        if source_title == target_title and sas == tas:
            msg = "Confirm the 'Source' and 'Target' book details shown below:\
            <br><br>'Source Title': " + source_title + "<br>'Source Formats': " + source_formats + "\
            <br><br>'Target Title':  " + target_title + "<br>'Target Formats': " + target_formats + "\
            <br><br>(Source Authors match the Target Authors) \
            <br><br>Click 'YES' to continue, or 'NO' to cancel this action."
            if question_dialog(self.maingui, "JS+ GUI Tool - Copy RIS Format Custom Columns to ZMI Format", msg):
                pass
            else:
                return
        else:
            msg = "Source and Target Books have different Titles or Authors.  \
            <br><br>'Source Title': " + source_title + "         'Source Formats': " + source_formats + "\
            <br><br>'Target Title':  " + target_title + "         'Target Formats': " + target_formats + " "
            return error_dialog(self.gui, _('JS+ GUI Tool'),_(msg), show=True)

        del sas
        del tas

        self.suppress_info_messages = False

        is_valid,error_msg = self.update_target_metadata_from_source_metadata(source_mi,source_bookid,target_mi,target_bookid)
        if not is_valid:
            msg = "Error in updating Target Format from RIS Source Format: " + error_msg
            error_dialog(self.gui, _('JS+ GUI Tool'),_(msg), show=True)
        else:
            msg = None
            path = self.guidb.library_path
            if isbytestring(path):
                path = path.decode(filesystem_encoding)
            path = path.replace(os.sep, '/')
            if DEBUG: print("path: ", path)
            ris_path = self.guidb.new_api._field_for('path', source_bookid)
            ris_path = os.path.join(path, ris_path)
            ris_path = ris_path.replace(os.sep, '/')

            my_db,my_cursor,is_valid = self.apsw_connect_to_library()
            if not is_valid:
                msg = "Error in Connecting to Metadata.db!  " + error_msg
                if DEBUG: print(msg)
                return is_valid,msg

            mysql = "SELECT book,format,name FROM data WHERE book = ? AND format = 'RIS'  "
            my_cursor.execute(mysql,(source_bookid,))
            tmp_rows = my_cursor.fetchall()
            my_db.close()
            if not tmp_rows:
                tmp_rows = []
            if len(tmp_rows) == 0:
                msg = "Error in Reading Metadata.db!  " + error_msg
                if DEBUG: print(msg)
                return False,msg
            for row in tmp_rows:
                book,format,name = row
                if book == source_bookid:
                    if format == "RIS":
                        ris_path = os.path.join(ris_path, name)
            #END FOR

            ris_path = ris_path.replace(os.sep, '/')

            if DEBUG: print("ris_path: ", ris_path)

            ris_path = ris_path + ".ris"

            if isbytestring(ris_path):
                ris_path = ris_path.decode(filesystem_encoding)

            if os.path.isfile(ris_path):
                self.ris_file_copy_to_target_book_path(ris_path,target_bookid)
            else:
                is_valid = False
                msg = "Error in copying the RIS format from the Source to the Target:  Invalid Source Path: " + ris_path
                if DEBUG: print(msg)

        del first_mi
        del second_mi
        del source_mi
        del source_bookid
        del target_mi
        del target_bookid
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_target_metadata_from_source_metadata(self,source_mi,source_bookid,target_mi,target_bookid):

        try:

            ris_cc_list = self.return_ris_custom_column_fields()

            source_field_metadata_list = []

            for field in ris_cc_list:
                value = source_mi.get(field, default=None)
                if value is not None:
                    row = field,value
                    source_field_metadata_list.append(row)
                    if DEBUG: print("Source:  field,value: ", str(row))
            #END FOR

            custom_columns_metadata_dict = self.maingui.current_db.field_metadata.custom_field_metadata()

            target_was_changed = False
            n_target_columns_updated = 0
            target_columns_updated_list = []

            for row in source_field_metadata_list:
                field,source_value = row
                if source_value is None:                                               #only copy existing source to non-existing target...
                    continue
                target_value = target_mi.get(field, default=None)
                if target_value is not None:                                        #only copy existing source to non-existing target...
                    continue
                if not field in custom_columns_metadata_dict:
                    continue
                #~ -----------------------------------
                custcol = custom_columns_metadata_dict[field]   # should be a '#label'
                datatype = custcol['datatype']
                if datatype == "comments":
                    new_value = str(source_value)
                elif datatype == "text":
                    new_value = source_value  #is_multiple is a list
                elif datatype == "int":
                    new_value = int(source_value)
                elif datatype == "float":
                    new_value = float(source_value)
                elif datatype == "bool":
                    new_value = bool(source_value)
                elif datatype == "datetime":
                    new_value = source_value
                else:
                    continue
                #~ -----------------------------------
                custcol['#value#'] = new_value
                target_mi.set_user_metadata(field, custcol)
                target_columns_updated_list.append(field)
                n_target_columns_updated = n_target_columns_updated + 1
                target_was_changed = True
                if DEBUG: print("Target Changed:  field,value: ", field, str(new_value))
            #END FOR

            if target_was_changed:
                payload = []
                payload.append(target_bookid)
                id_map = {}
                id_map[target_bookid] = target_mi
                edit_metadata_action = self.maingui.iactions['Edit Metadata']
                edit_metadata_action.apply_metadata_changes(id_map, callback=None)
                del id_map
                #~ -----------------------------------
                found_dict = {}
                s_true = 'true'
                key = int(source_bookid)
                found_dict[key] = s_true
                key = int(target_bookid)
                found_dict[key] = s_true
                marked_ids = dict.fromkeys(found_dict, s_true)
                self.gui.current_db.set_marked_ids(marked_ids)
                #~ -----------------------------------
                target_columns_updated_list.sort()
                msg = "Target Book '" + target_mi.title + "'  has been updated where possible.\
                <br><br>Number of Empty #ris_... Custom Columns Updated: " + str(n_target_columns_updated) + "<br><br>"
                for cc in target_columns_updated_list:
                    msg = msg + cc + "; "
                #END FOR
                msg = msg[0:-2] + "<br>"
                if DEBUG: print(msg)
                if not self.suppress_info_messages:
                    info_dialog(self.gui, "RIS Format: Copy '#ris_...' CC Metadata to Related ZMI Format's '#ris_...' CC Metadata",msg).show()
                #~ -----------------------------------
            else:
                #~ -----------------------------------
                msg = "Nothing was changed in the Target Book, " + target_mi.title + "<br><br>All of the available Source RIS Metadata already exists (regardless of value) in the Target's Metadata. <br><br>"
                if DEBUG: print(msg)
                if not self.suppress_info_messages:
                    info_dialog(self.gui, "RIS Format: Copy '#ris_...' CC Metadata to Related ZMI Format's '#ris_...' CC Metadata",msg).show()
                #~ -----------------------------------
            #END IF


            del ris_cc_list
            del source_mi
            del source_bookid
            del target_mi
            del target_bookid
            del custom_columns_metadata_dict

            is_valid = True
            error_msg = ""

        except Exception as e:
            is_valid = False
            error_msg = str(e)

        return is_valid,error_msg
    #---------------------------------------------------------------------------------------------------------------------------------------
    def return_ris_custom_column_fields(self):
        ris_cc_list = []

        tmp_list = self.guidb.custom_field_keys()
        for cc in tmp_list:
            if cc.startswith("#ris_"):
                ris_cc_list.append(cc)
                if DEBUG: print(cc)
        #END FOR
        del tmp_list
        ris_cc_list.sort()

        return ris_cc_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def mass_processing_copy_ris_custom_columns_to_related_format_control(self):

        books_mi_dict = {}                   #  [bookid] = mi
        books_title_dict = {}                 #  [bookid] = mi.title
        books_formats_list_dict = {}     #  [bookid] = mi.formats  (a list)
        title_books_dict = {}                 #  [title] = bookid_list
        title_ignore_set = set()             #  set of titles for which only 1 book was found; must be ignored
        bookid_format_conflict_list = []    # bookids with multiple formats including RIS; must be ignored; also with no formats at all.

        self.selected_books_list = self.get_selected_books()

        n_selected = len(self.selected_books_list)
        if not n_selected > 1:
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('Error [1] Must Select At Least 2 Books...'), show=True)

        if n_selected > 2:
            msg = "For mass processing a large number of selected books, do you wish to suppress all 'Information' messages?  True 'Error' messages will always be displayed."
            if question_dialog(self.maingui, "JS+ GUI Tool", msg):
                self.suppress_info_messages = True
            else:
                self.suppress_info_messages = False
        else:
            self.suppress_info_messages = False

        for bookid in self.selected_books_list:
            bookid = int(bookid)
            mi = self.maingui.library_view.model().db.get_metadata(bookid, index_is_id=True, get_user_categories=False)
            if mi.formats is None:
                bookid_format_conflict_list.append(bookid)
                if DEBUG: print("no formats in mi: ", str(bookid))
                continue
            else:
                books_formats_list_dict[bookid] = mi.formats
            books_mi_dict[bookid] = mi
            title = mi.title
            books_title_dict[bookid] = title

            if title in title_books_dict:
                bookid_list = title_books_dict[title]
                bookid_list.append(bookid)
                title_books_dict[title] = bookid_list
            else:
                bookid_list = []
                bookid_list.append(bookid)
                title_books_dict[title] = bookid_list
            if DEBUG: print("title_books_dict[title] = bookid_list: ", str(title), str(bookid_list))
        #END FOR
        #~ ------------------------------------------
        #~ filter out unuseful books using title
        #~ ------------------------------------------
        title_books_dict_copy = title_books_dict.copy()
        for title, bookid_list in iteritems(title_books_dict_copy):
            if len(bookid_list) < 2:
                title_ignore_set.add(title)
                del title_books_dict[title]
                for bookid in bookid_list:
                    del books_mi_dict[bookid]
                    del books_title_dict[bookid]
                    del books_formats_list_dict[bookid]
                #END FOR
        #END FOR
        #~ ------------------------------------------

        n1 = len(books_formats_list_dict)
        n2 = len(books_mi_dict)
        n3 = len(books_title_dict)
        n4 = len(title_books_dict)

        if n1 == 0 or n2 == 0 or n3 == 0 or n4 == 0:
            msg = 'Error [2] None of the selected books could be used for this purpose.  Nothing done.'
            if DEBUG: print(msg)
            return error_dialog(self.gui, _('JS+ GUI Tool'),_(msg), show=True)

        if n1 != n2 or n2 != n3:
            msg = 'Error [3] None of the selected books could be used for this purpose.  Nothing done.'
            if DEBUG: print(msg)
            return error_dialog(self.gui, _('JS+ GUI Tool'),_(msg), show=True)

        #~ ------------------------------------------
        #~ filter out unuseful books using formats
        #~ ------------------------------------------
        RIS_FORMATS = ['RIS']
        ZMI_FORMATS = ['PDF','TXT','EPUB']
        for bookid, format_list in iteritems(books_formats_list_dict):
            if DEBUG: print("bookid, format_list: ", str(bookid), str(format_list))
            ris_found = False
            zmi_found = False
            for format in format_list:
                if format in RIS_FORMATS:
                    ris_found = True
                else:
                    ris_found = False
                if format in ZMI_FORMATS:
                    zmi_found = True
                else:
                    zmi_found = False
            #END FOR
            if ris_found and zmi_found:
                bookid_format_conflict_list.append(bookid)
        #END FOR

        for bookid in bookid_format_conflict_list:
            if bookid in books_mi_dict:
                del books_mi_dict[bookid]
            if bookid in books_title_dict:
                del books_title_dict[bookid]
            if bookid in books_formats_list_dict:
                del books_formats_list_dict[bookid]
        #END FOR

        n1 = len(books_formats_list_dict)
        n2 = len(books_mi_dict)
        n3 = len(books_title_dict)

        if n1 == 0 or n2 == 0 or n3 == 0:
            msg = 'Error [4] None of the selected books could be used for this purpose.  Nothing done.'
            if DEBUG: print(msg)
            return error_dialog(self.gui, _('JS+ GUI Tool'),_(msg), show=True)

        title_books_dict_copy = title_books_dict.copy()
        for title,bookid_list in iteritems(title_books_dict_copy):
            bookid_list_copy = copy.deepcopy(bookid_list)
            for book in bookid_list_copy:
                if book in bookid_format_conflict_list:
                    bookid_list.remove(book)
                    if book in books_mi_dict:
                        del books_mi_dict[book]
                    if book in books_title_dict:
                        del books_title_dict[book]
                    if book in books_formats_list_dict:
                        del books_formats_list_dict[book]
            #END FOR
            if len(bookid_list) < 2:
                del title_books_dict[title]
            if title in title_ignore_set:
                if title in title_books_dict:
                    del title_books_dict[title]
        #END FOR

        n1 = len(books_formats_list_dict)
        n2 = len(books_mi_dict)
        n3 = len(books_title_dict)
        n4 = len(title_books_dict)

        if n1 == 0 or n2 == 0 or n3 == 0 or n4 == 0:
            msg = 'Error [5] None of the selected books could be used for this purpose.  Nothing done.'
            if DEBUG: print(msg)
            return error_dialog(self.gui, _('JS+ GUI Tool'),_(msg), show=True)

        if n1 != n2 or n2 != n3:
            msg = 'Error [6] None of the selected books could be used for this purpose.  Nothing done.'
            if DEBUG: print(msg)
            return error_dialog(self.gui, _('JS+ GUI Tool'),_(msg), show=True)

        for title,bookid_list in iteritems(title_books_dict):
            if not len(bookid_list) > 1:
                title_ignore_set.add(title)
        #END FOR

        #~ ------------------------------------------
        #~ final check for consistency of all dicts
        #~ ------------------------------------------
        all_usable_book_id_list = list(books_mi_dict.keys())
        all_usable_book_id_list_copy = copy.deepcopy(all_usable_book_id_list)
        for book in all_usable_book_id_list_copy:
            del_mi_dict = False
            if not book in books_title_dict:
                del_mi_dict = True
            if not book in books_formats_list_dict:
                del_mi_dict = True
            if del_mi_dict:
                del books_mi_dict[book]
                if book in books_title_dict:
                    del books_title_dict[book]
                if book in books_formats_list_dict:
                    del books_formats_list_dict[book]
                all_usable_book_id_list.remove(book)
        #END FOR
        #~ ------------------------------------------
        #~ final check for consistency of title_books_dict
        #~ ------------------------------------------
        title_books_dict_copy = title_books_dict.copy()
        for title, bookid_list in iteritems(title_books_dict_copy):
            if title in title_ignore_set:
                del title_books_dict[title]
                for bookid in bookid_list:
                    if bookid in books_mi_dict:
                        del books_mi_dict[bookid]
                    if bookid in books_title_dict:
                        del books_title_dict[bookid]
                    if bookid in books_formats_list_dict:
                        del books_formats_list_dict[bookid]
                    if bookid in all_usable_book_id_list:
                        all_usable_book_id_list.remove(bookid)
            #END FOR
        #END FOR
        #~ ------------------------------------------
        all_usable_book_id_list = list(set(all_usable_book_id_list))

        all_usable_titles_list = list(title_books_dict.keys())
        all_usable_titles_list.sort()

        if DEBUG: print("all_usable_book_id_list:  ",str(all_usable_book_id_list))
        if DEBUG: print("all_usable_titles_list:  ",str(all_usable_titles_list))

        final_processed_books_list = []

        for title in all_usable_titles_list:
            bookid_list = title_books_dict[title]
            first_bookid = bookid_list[0]
            second_bookid = bookid_list[1]  #may be more than 2 with the identical title due to duplicates, but just consider the first 2 books...user should remove duplicate books...
            if first_bookid in all_usable_book_id_list:
                if second_bookid in all_usable_book_id_list:
                    if DEBUG: print("first_bookid",str(first_bookid),"    second_bookid",str(second_bookid))
                    is_valid,msg = self.mass_processing_copy_ris_custom_columns_to_related_format(books_mi_dict, books_title_dict, books_formats_list_dict,\
                                                                                                                                               title_books_dict, first_bookid, second_bookid)
                    if is_valid:
                        final_processed_books_list.append(first_bookid)
                        final_processed_books_list.append(second_bookid)
                        if DEBUG: print("is_valid: ", is_valid)
                        continue
                    else:
                        if DEBUG: print("is_valid: ", is_valid, "  msg: ", msg)
                        return error_dialog(self.gui, _('JS+ GUI Tool'),_(msg), show=True)
                else:
                    if DEBUG: print("***consistency error:  bookid_list = title_books_dict[title]:  bookid_list has an unusable second_bookid: ", str(second_bookid), title)
            else:
                if DEBUG: print("***consistency error:  bookid_list = title_books_dict[title]:  bookid_list has an unusable first_bookid: ", str(first_bookid), title)
        #END FOR

        #~ -----------------------------------
        #~ mark all updated books (again, at end)
        #~ -----------------------------------
        self.gui.current_db.data.set_marked_ids(())
        found_dict = {}
        s_true = 'true'
        for bookid in final_processed_books_list:
            key = int(bookid)
            found_dict[key] = s_true
        #END FOR
        marked_ids = dict.fromkeys(found_dict, s_true)
        self.gui.current_db.set_marked_ids(marked_ids)
        self.gui.search.clear()
        self.gui.search.set_search_string('marked:true')
        #~ -----------------------------------

        del books_mi_dict
        del books_title_dict
        del books_formats_list_dict
        del title_books_dict
        del title_books_dict_copy
        del all_usable_book_id_list
        del all_usable_book_id_list_copy
        del all_usable_titles_list
        del first_bookid
        del second_bookid
        del title
    #---------------------------------------------------------------------------------------------------------------------------------------
    def mass_processing_copy_ris_custom_columns_to_related_format(self, books_mi_dict, books_title_dict, books_formats_list_dict,\
                                                                                                                    title_books_dict, first_bookid, second_bookid):
        #~ books_mi_dict = {}                   #  [bookid] = mi
        #~ books_title_dict = {}                 #  [bookid] = mi.title
        #~ books_formats_list_dict = {}     #  [bookid] = mi.formats  (a list)
        #~ title_books_dict = {}                 #  [title] = bookid_list

        first_mi = books_mi_dict[first_bookid]
        second_mi = books_mi_dict[second_bookid]

        first_title = books_title_dict[first_bookid]
        second_title = books_title_dict[second_bookid]

        if DEBUG: print("first_title: ", str(first_title))
        if DEBUG: print("second_title: ",str(second_title))

        first_formats_list = books_formats_list_dict[first_bookid]
        second_formats_list = books_formats_list_dict[second_bookid]

        if DEBUG: print("first_formats: ", str(first_formats_list))
        if DEBUG: print("second_formats: ",str(second_formats_list))

        if 'RIS' in first_formats_list and 'RIS' in second_formats_list:  #cannot happen here due to previous preparation of dicts/lists
            msg = "Both selected books also have an RIS format, which is not allowed: " + first_title + "  " + str(first_bookid) + " & " + str(second_bookid)
            if DEBUG: print(msg)
            if not self.suppress_info_messages:
                info_dialog(self.gui, 'JS+ GUI Tool',msg).show()
            return True,None

        if 'RIS' in first_formats_list:
            source_mi = first_mi                   # class 'calibre.ebooks.metadata.book.base.Metadata'
            source_bookid = first_bookid
            source_title = first_title
            source_formats = ",".join(first_formats_list)
            target_mi = second_mi               # class 'calibre.ebooks.metadata.book.base.Metadata'
            target_bookid = second_bookid
            target_title = second_title
            target_formats  = ",".join(second_formats_list)
        elif 'RIS' in second_formats_list:
            source_mi = second_mi
            source_bookid = second_bookid
            source_title = second_title
            source_formats  = ",".join(second_formats_list)
            target_mi = first_mi
            target_bookid = first_bookid
            target_title = first_title
            target_formats  = ",".join(first_formats_list)
        else:
            msg = "Neither selected books have an RIS format to copy from; nothing can be done for: " + first_title + "  " + str(first_bookid) + " & " + str(second_bookid)
            if DEBUG: print(msg)
            if not self.suppress_info_messages:
                info_dialog(self.gui, 'JS+ GUI Tool',msg).show()
            return True,None

        source_authors_list = self.guidb.new_api._field_ids_for('authors', source_bookid)
        target_authors_list = self.guidb.new_api._field_ids_for('authors', target_bookid)

        sas = set(source_authors_list)
        tas = set(target_authors_list)

        if source_title == target_title and sas == tas:
            msg = "Confirm the 'Source' and 'Target' book details shown below:\
            <br><br>'Source Title': " + source_title + "<br>'Source Formats': " + source_formats + "\
            <br><br>'Target Title':  " + target_title + "<br>'Target Formats': " + target_formats + "\
            <br><br>(Source Authors match the Target Authors) \
            <br><br>Click 'YES' to continue, or 'NO' to cancel this action."
            if DEBUG: print(msg)
            if question_dialog(self.maingui, "JS+ GUI Tool - Copy RIS Format Custom Columns to ZMI Format", msg):
                pass
            else:
                return True,None
        else: #cannot happen here due to previous preparation of dicts/lists
            msg = "Source and Target Books have different Titles or Authors.  \
            <br><br>'Source Title': " + source_title + "         'Source Formats': " + source_formats + "\
            <br><br>'Target Title':  " + target_title + "         'Target Formats': " + target_formats + " "
            if DEBUG: print(msg)
            return False,msg

        del sas
        del tas

        is_valid,error_msg = self.update_target_metadata_from_source_metadata(source_mi,source_bookid,target_mi,target_bookid)
        if not is_valid:
            msg = "Error in updating Target Format from RIS Source Format: " + error_msg
            if DEBUG: print(msg)
        else:
            msg = None
            path = self.guidb.library_path
            if isbytestring(path):
                path = path.decode(filesystem_encoding)
            path = path.replace(os.sep, '/')
            if DEBUG: print("path: ", path)
            ris_path = self.guidb.new_api._field_for('path', source_bookid)
            ris_path = os.path.join(path, ris_path)
            ris_path = ris_path.replace(os.sep, '/')

            my_db,my_cursor,is_valid = self.apsw_connect_to_library()
            if not is_valid:
                msg = "Error in Connecting to Metadata.db!  " + error_msg
                if DEBUG: print(msg)
                return is_valid,msg

            mysql = "SELECT book,format,name FROM data WHERE book = ? AND format = 'RIS'  "
            my_cursor.execute(mysql,(source_bookid,))
            tmp_rows = my_cursor.fetchall()
            my_db.close()
            if not tmp_rows:
                tmp_rows = []
            if len(tmp_rows) == 0:
                msg = "Error in Reading Metadata.db!  " + error_msg
                if DEBUG: print(msg)
                return False,msg
            for row in tmp_rows:
                book,format,name = row
                if book == source_bookid:
                    if format == "RIS":
                        ris_path = os.path.join(ris_path, name)
            #END FOR
            del tmp_rows
            del my_db

            ris_path = ris_path.replace(os.sep, '/')

            if DEBUG: print("ris_path: ", ris_path)

            ris_path = ris_path + ".ris"

            if isbytestring(ris_path):
                ris_path = ris_path.decode(filesystem_encoding)

            if os.path.isfile(ris_path):
                self.ris_file_copy_to_target_book_path(ris_path,target_bookid)
            else:
                is_valid = False
                msg = "Error in copying the RIS format from the Source to the Target:  Invalid Source Path: " + ris_path
                if DEBUG: print(msg)

        del first_mi
        del second_mi
        del first_formats_list
        del second_formats_list
        del source_mi
        del source_bookid
        del source_title
        del source_formats
        del target_mi
        del target_bookid
        del target_title
        del target_formats

        return is_valid,msg
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ris_file_copy_to_target_book_path(self,ris_path,target_book_id):
        stream_or_path = open(ris_path, 'rb')  #file handle to be used by self.guidb.new_api.add_format()
        result = self.cache_add_format(book_id=target_book_id, fmt="RIS", stream_or_path=stream_or_path, replace=False, run_hooks=False, dbapi=None)
        if DEBUG: print("self.guidb.new_api.add_format()  -  result: ", str(result))
        try:
            stream_or_path.close()
            del stream_or_path
        except Exception as e:
            if DEBUG: print("stream_or_path.close() error:  ", str(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    def cache_add_format(self, book_id, fmt, stream_or_path, replace, run_hooks, dbapi):
        # Add a format to the specified book. Return True if the format was added successfully.
        result = self.guidb.new_api.add_format(book_id=book_id, fmt=fmt, stream_or_path=stream_or_path, replace=False, run_hooks=False, dbapi=None)
        return result
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def convert_bib_to_ris_tool(self):

        from calibre_plugins.job_spy.convert_bib_to_ris import (convert_bib_to_ris_control,
                                                                                                    parse_bib_set_list,
                                                                                                    convert_bib_items_dict_to_ris,
                                                                                                    convert_month_to_digits,
                                                                                                    write_new_ris_file_to_calibre_autoadd_directory)

        from calibre_plugins.job_spy.convert_bib_to_ris import bib_keys_list
        self.bib_keys_list = bib_keys_list

        self.bib_keys_found_set = set()

        tool_name = "JS+ GUI Tool: BIB Catalog to RIS Converter/Exploder to Auto-Add"

        if DEBUG: print("\n\n\nBEGIN:" + tool_name + "\n\n\n")

        self.converted_nbib_to_ris_auto_add_path = gprefs['auto_add_path']  # os path to be watched by auto_adder
        if self.converted_nbib_to_ris_auto_add_path is None:
            if DEBUG: print("gprefs['auto_add_path'] is None...")
            msg = "Your Calibre Preferences for Auto-Adding books are invalid or incomplete."
            return error_dialog(self.maingui, _(tool_name),_(msg), show=True)

        if not os.path.isdir(self.converted_nbib_to_ris_auto_add_path):
            if DEBUG: print("gprefs['auto_add_path'] is not a valid Directory...")
            msg = "Your Calibre Preferences for Auto-Adding books are invalid or incomplete."
            return error_dialog(self.maingui, _(tool_name),_(msg), show=True)

        if DEBUG: print("the self.converted_nbib_to_ris_auto_add_path:  ", self.converted_nbib_to_ris_auto_add_path)

        bib_paths = self.get_bib_file_to_convert_to_ris(tool_name)

        if DEBUG: print("qfiledialog bib_path(s): ", str(bib_paths))  #~ (['X:/MyPluginsPy3/_ris_import_dir/WrightOSWSHM22.bib'], 'All Files (*)')
        if DEBUG: print("type(bib_paths): ", type(bib_paths))  # <class 'tuple'>

        mylist,myfilter = bib_paths  # <class 'tuple'>
        del bib_paths

        if DEBUG: print(str(mylist), str(myfilter))
        if DEBUG: print("type(mylist): ", type(mylist))  #list

        bib_paths = mylist
        del mylist

        bib_paths_list = []

        for bib_path in bib_paths:
            if DEBUG: print("\n\nfor row in bib_paths: ", str(bib_path))
            if DEBUG: print(str(bib_path))
            bib_path = bib_path.strip()
            if bib_path.endswith(".bib"):
                bib_paths_list.append(bib_path)
                if DEBUG: print("bib_paths_list.append(bib_path): ", bib_path)
        #END FOR
        del bib_paths

        if DEBUG:
            for r in bib_paths_list:
                print(r)
            print("\n\n")

        last_used_dir = None
        bib_paths_final_list = []

        for bib_path in bib_paths_list:
            if not os.path.isfile(bib_path):
                if DEBUG: print("bib_path is not a valid File...")
                msg = "Source .bib file to convert path error.  It is not a valid file:   \n" + bib_path
                return error_dialog(self.maingui, _(tool_name),_(msg), show=True)
            last_used_dir,bib_filename = os.path.split(bib_path)
            if DEBUG: print("last_used_dir: ", last_used_dir, "  bib_filename", bib_filename)
            if not bib_filename.endswith(".bib"):
                continue
            r = bib_path,bib_filename
            bib_paths_final_list.append(r)
            if DEBUG: print("\n\npath & filename row added for use: ", r)
        #END FOR
        del bib_paths_list

        if last_used_dir is not None:
            if os.path.isdir(last_used_dir):
                last_used_dir = last_used_dir.replace(os.sep, '/')
                prefs['GUI_TOOLS_CONVERT_BIB_FORMAT_TO_RIS_FORMAT_DIR'] = last_used_dir
                prefs
            else:
                if DEBUG: print("last_used_dir is an invalid directory: ", last_used_dir)

        self.bib_set_list_dict = {}
        n_bib_sets = 0

        for r in bib_paths_final_list:
            bib_path,bib_filename = r
            n_sets,is_fatal_error = self.split_multiple_bib_set_file(bib_path,bib_filename)
            if is_fatal_error:
                msg = "Fatal error in processing the input data due to its non-standard BIB format.\n\nRun Calibre again in DEBUG mode to determine exactly why."
                return error_dialog(self.maingui, _(tool_name),_(msg), show=True)
            n_bib_sets = n_bib_sets + n_sets
            if DEBUG: print("for r in bib_paths_list;   n_sets: ", str(n_sets))
        #END FOR

        if n_bib_sets == 0:
            del self.bib_set_list_dict
            del convert_bib_to_ris_control
            del convert_bib_items_dict_to_ris
            del write_new_ris_file_to_calibre_autoadd_directory
            msg = "Nothing found within the selected files to convert to an RIS format output .ris file.  Nothing done. "
            return error_dialog(self.maingui, _(tool_name),_(msg), show=True)

        QApplication.instance().processEvents()

        #~ 1 .bib entry == 1 .bib group == 1 .bib set.
        #~ Rough number of lines in a .bib file for a single "entry":  ~10-20, depending on its Abstract wrapped length & number of Authors.
        #~ BIB formats have an "entry type", such as Article, etc.  "entry" is for the user info messages.
        #~ group = "a set of BIB lines that comprise a single "entry".  Analagous to an RIS "set" for the same reason and purpose.
        #~ 1 .bib entry (group) (set) is converted into 1 .ris set.
        #~ Factoid: although there are many more "Tags" in RIS than BIB, the NBIB format (used since ~2020) has been mandated (in lieu of RIS) for the Life Sciences.

        msg = "The number of RIS books ready to save for Calibre auto-adding: " + str(n_bib_sets)
        for k,bib_set_list in iteritems(self.bib_set_list_dict):
            for bib_set in bib_set_list:
                s = " ".join(bib_set)
                msg = msg + "<br>Preview:<br>" + s
                msg = msg[0:400]
                break
        #END FOR

        msg = msg + "<br><br>Do you wish to continue?"

        if question_dialog(self.maingui, tool_name, msg):
            pass
        else:
            del self.bib_set_list_dict
            del convert_bib_to_ris_control
            del convert_bib_items_dict_to_ris
            del write_new_ris_file_to_calibre_autoadd_directory
            return

        if DEBUG:
            bib_keys_found_list = list(self.bib_keys_found_set)
            del self.bib_keys_found_set
            bib_keys_found_list.sort()
            n = len(bib_keys_found_list)
            print("\n\nNumber of bib_keys found: ", str(n))
            for bib_key in bib_keys_found_list:
                    print(bib_key)
            print("\n\n")

        QApplication.instance().processEvents()
        qappcurrent = QApplication.instance()

        is_valid,msg = convert_bib_to_ris_control(qappcurrent, self.maingui, self.bib_set_list_dict, n_bib_sets, self.converted_nbib_to_ris_auto_add_path)
        if is_valid:
            msg = "Selected files containing " + str(n_bib_sets)  + " BIB/Medline/PubMed sets/entries/citations were each converted to the corresponding RIS format, then added to your specified Calibre Auto-Add directory: " + self.converted_nbib_to_ris_auto_add_path
        else:
            msg = "ERROR:  Selected files were NOT converted to RIS format(s)<br>and NOT added to the Auto-Add directory:<br>" + self.converted_nbib_to_ris_auto_add_path + "<br><br>" + msg

        msg2 = "JS: New RIS 'Books' are now being GRADUALLY Auto-Added by Calibre:  " + str(n_bib_sets)
        self.maingui.status_bar.show_message(msg2)
        QApplication.instance().processEvents()

        del self.bib_set_list_dict
        del convert_bib_to_ris_control
        del convert_bib_items_dict_to_ris
        del write_new_ris_file_to_calibre_autoadd_directory

        if DEBUG: print("\n\n\nEND: " + tool_name + "\n\n\n")

        return info_dialog(self.gui, tool_name,msg).show()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_bib_file_to_convert_to_ris(self,tool_name):

        last_used_dir = prefs['GUI_TOOLS_CONVERT_BIB_FORMAT_TO_RIS_FORMAT_DIR']

        if not os.path.isdir(last_used_dir):
            msg = "Have you already set your Calibre > Preferences > Add Books > Automatic Adding properly?"
            msg = msg + "<br><br>RIS .ris file types are not ebook formats, so you must specify the proper Auto-Add option in the Preferences, "
            msg = msg + "or the newly created .ris files will not be automatically added by Calibre as new 'books'.  You will have to manually Drag-and-Drop them to add them."
            msg = msg + "<br><br>You must Restart Calibre after updating those Preferences."
            msg = msg + "<br><br>If you use the JS+ Tweak to specify an Auto-Add Directory by Library, you must do the above too."
            if question_dialog(self.gui, tool_name, msg):
                pass
            else:
                return None

        fd = QFileDialog()
        fd.setFileMode(QFileDialog.FileMode.ExistingFile)
        fd.setNameFilters(['BIB (*.bib)'])
        fd.selectNameFilter('BIB (*.bib)')
        if os.path.isdir(last_used_dir):
            fd.setDirectory(last_used_dir)
        fd.setParent(None)

        if fd.accepted:
            bib_paths = fd.getOpenFileNames()  #multiple .bib files simultaneously
            return bib_paths

        return None
    #---------------------------------------------------------------------------------------------------------------------------------------
    def split_multiple_bib_set_file(self,bib_path,bib_filename):

        #~ @article{DBLP:journals/nature/WrightOSWSHM22,
          #~ author    = {Logan G. Wright and
                       #~ Tatsuhiro Onodera and
                       #~ Martin M. Stein and
                       #~ Tianyu Wang and
                       #~ Darren T. Schachter and
                       #~ Zoey Hu and
                       #~ Peter L. McMahon},
          #~ title     = {Deep physical neural networks trained with backpropagation},
          #~ journal   = {Nat.},
          #~ volume    = {601},
          #~ number    = {7894},
          #~ pages     = {549--555},
          #~ year      = {2022},
          #~ url       = {https://doi.org/10.1038/s41586-021-04223-6},
          #~ doi       = {10.1038/s41586-021-04223-6},
          #~ timestamp = {Mon, 05 Dec 2022 13:35:06 +0100},
          #~ biburl    = {https://dblp.org/rec/journals/nature/WrightOSWSHM22.bib},
          #~ bibsource = {dblp computer science bibliography, https://dblp.org}
        #~ }
        #~ ------------------------------------------------
        #~ CAUTION: the above group is "clean", and in no way represents even half of the random bib groups found in the wild that this tool must process!
        #~ 'Standardized BIB' is an oxymoron.  Even Zotero uses 'biburl' and 'bibsource' instead of 'url' and 'database', but those differences are comparatively trivial and insignificant.
        #~ ------------------------------------------------

        is_fatal_error = False
        n_bib_sets = 0

        try:
            with open(bib_path, 'r') as f:
                raw_lines = f.readlines()
            f.close()
            del f
        except Exception as e:
            if DEBUG: print("Exception in f.readlines(): ", str(e))
            raw_lines = []

        if DEBUG: print("\n\nnumber of lines in raw .bib file: ", str(len(raw_lines)))
        #~ ------------------------------------------------
        raw_string = "\n".join(raw_lines)
        #~ ------------------------------------------------
        for c in ['\t','\r','\f','\v']:  # not \n
            raw_string = raw_string.replace(c,"")
        #END FOR
        raw_string = raw_string.replace("    "," ")
        raw_string = raw_string.replace("  "," ")
        raw_string = raw_string.replace(" "," ")
        raw_string = raw_string.replace(" "," ")
        if DEBUG: print("\n\nraw string: ", raw_string)
        self.original_bib_file_raw_string = raw_string
        #~ ------------------------------------------------
        raw_lines_ = raw_string.split("\n")
        if DEBUG: print("\n\nnumber of lines in raw_lines after split at \\n  : ", str(len(raw_lines)))
        if DEBUG: print("\n\n")
        if DEBUG:
            for line in raw_lines_:
                print("raw_lines after .split(eol): ", line)
        #~ ------------------------------------------------
        if DEBUG: print("\n\n")
        raw_lines = []
        for r in raw_lines_:
            r = r.lstrip()  #do not remove eol \n from right side...
            if not r > "":
                continue  #remove blank lines
            r = as_unicode(r)  #does nothing if it already is a proper str; otherwise, decodes it.
            r = r.lstrip()
            if r.startswith("#") or r.startswith("%") or r.startswith("@preamble") or r.startswith("@STRING"):
                continue
            r = r.replace(" =","=")
            r = r.replace("= ","=")
            r = r.replace(" =","=")
            r = r.replace("= ","=")
            r = r.replace(" =","=")
            r = r.replace("= ","=")
            if r.startswith("}"):  #final line of a bib_set
                s = "originalbibfile={" + bib_filename + "},\n"
                raw_lines.append(s)  #  maps to RIS Tag 'L3', related files
                if DEBUG: print(s)
                del s
            raw_lines.append(r)
            if DEBUG: print("non-blank line in raw_lines: ", r)
        #END FOR
        del raw_string
        del r
        del raw_lines_
        if DEBUG: print("\n\n")
        if DEBUG: print("[1] number of lines in non-blank raw_lines: ", str(len(raw_lines)))
        if DEBUG: print("\n\n")
        #~ ------------------------------------------------
        self.build_bad_bib_grammar_correction_regex_list()
        #~ ------------------------------------------------
        raw_grouped_list = self.create_bib_grouped_list(raw_lines)
        #~ --------------------------------------------------

        #~ --------------------------------------------------
        #~ correct bib_keys with continuation lines separated by \n instead of just wrapping (e.g. a long text like Abstract)
        #~ assume not only the @line is concatenated with author or title or other random bib_key, but simultaneously Abstract and other bib_keys have continuation lines too.
        #~ --------------------------------------------------
        if DEBUG: print("groups in raw_grouped_list: ", str(len(raw_grouped_list)))
        if DEBUG: print("\n\n")
        for raw_lines in raw_grouped_list:  # raw_grouped_list is a list of lists (raw_lines is list comprising a single bib citation)
            continuation_target_index_dict = {}  # continuation_target_index_dict[target_index] = continuation_line_index_value_dict
            continuation_line_index_value_dict = {}
            continuation_target_index_list = []
            i = 0  # do not add or remove any indexes below!
            max = len(raw_lines)
            bib_keys_index_dict = {}            # [bib_key] = i
            index_to_bib_key_dict = {}         # [i] = bib_key
            last_bib_key = None
            target_index = None
            at_line_index = None
            while i < max:
                r = raw_lines[i]
                #~ if DEBUG: print("\n\n",type(r))
                if DEBUG: print(r)
                if r.strip() == "":
                    i = i + 1
                    continue
                if r.startswith("@"):
                    bib_key = "@"
                    last_bib_key = bib_key
                    index_to_bib_key_dict[i] = bib_key
                    bib_keys_index_dict[bib_key] = i
                    at_line_index = i
                    self.bib_keys_found_set.add(bib_key)
                    if DEBUG: print("bib_key: ", bib_key)
                elif r.count("=") > 0:
                    n = r.find("=")
                    bib_key = r[0:n].strip()
                    last_bib_key = bib_key
                    index_to_bib_key_dict[i] = bib_key
                    bib_keys_index_dict[bib_key] = i
                    self.bib_keys_found_set.add(bib_key)
                    if DEBUG: print("bib_key: ", bib_key)
                elif r.startswith("}"):
                    bib_key = "}"
                    if DEBUG: print("bib_key: ", bib_key)
                    i = max
                else:
                    #continuation lines
                    if DEBUG: print("\ncontinuation line found...")
                    future_target_index = bib_keys_index_dict[last_bib_key]
                    continuation_line_index_value_dict[i] = future_target_index,last_bib_key,r
                    continuation_target_index_dict[future_target_index] = continuation_line_index_value_dict
                    continuation_target_index_list.append(future_target_index)
                    if DEBUG: print("continuation_line_index_value_dict:  added:  contline index of: ", str(i)," with: ", last_bib_key, r)
                    if DEBUG: print("continuation_target_index_dict[future_target_index]: ", str(future_target_index), "  has a bib_key of: ", last_bib_key)
                i = i + 1
            #END WHILE

            continuation_target_index_list = list(set(continuation_target_index_list))
            continuation_target_index_list.sort()

            if DEBUG:
                print("\n\nindex_to_bib_key_dict: ")
                for k,v in iteritems(index_to_bib_key_dict):
                    print(str(k), str(v))

                    #~ index_to_bib_key_dict:
                    #~ 0 @
                    #~ 1 author
                    #~ 3 title
                    #~ 4 abstract
                    #~ 10 misc
                    #~ 14 journal
                    #~ 15 volume
                    #~ 16 number
                    #~ 17 pages
                    #~ 18 year
                    #~ 19 url
                    #~ 20 doi
                    #~ 21 timestamp
                    #~ 22 biburl
                    #~ 23 bibsource


                print("\n\ncontinuation_target_index_dict: ")
                for k,v in iteritems(continuation_target_index_dict):
                    print("\n",str(k), "\n", str(v))
                    #~ continuation_target_index_dict:

                     #~ 1
                     #~ {2: (1, 'author', 'Allan L. Smith},'), 5: (4, 'abstract', 'submitted to the Utah Veterinary Diagnostic Laboratory for necropsy.\n'), 6: (4, 'abstract', 'There were numerous thick-walled abscesses subcutaneously and\n'), 7: (4, 'abstract', 'internally, and Corynebacterium pseudotuberculosis was isolated in pure\n'), 8: (4, 'abstract', 'culture. In addition, the ram was severely copper deficient, with a\n'), 9: (4, 'abstract', 'liver copper concentration of 1.6 mg/kg.},'), 11: (10, 'misc', 'eeeeeeeeeeeeeeeeee ffffffffffffffffffff gggggggggggggggggg hhhhhhhhhhhhhh\n'), 12: (10, 'misc', 'iiiiiiiiiiiiiiiiiii jjjjjjjjjjjjjjjjjjjjjjjjj\n'), 13: (10, 'misc', 'kkkkkkkkkkkkkkkkkk}\n')}

                     #~ 4
                     #~ {2: (1, 'author', 'Allan L. Smith},'), 5: (4, 'abstract', 'submitted to the Utah Veterinary Diagnostic Laboratory for necropsy.\n'), 6: (4, 'abstract', 'There were numerous thick-walled abscesses subcutaneously and\n'), 7: (4, 'abstract', 'internally, and Corynebacterium pseudotuberculosis was isolated in pure\n'), 8: (4, 'abstract', 'culture. In addition, the ram was severely copper deficient, with a\n'), 9: (4, 'abstract', 'liver copper concentration of 1.6 mg/kg.},'), 11: (10, 'misc', 'eeeeeeeeeeeeeeeeee ffffffffffffffffffff gggggggggggggggggg hhhhhhhhhhhhhh\n'), 12: (10, 'misc', 'iiiiiiiiiiiiiiiiiii jjjjjjjjjjjjjjjjjjjjjjjjj\n'), 13: (10, 'misc', 'kkkkkkkkkkkkkkkkkk}\n')}

                     #~ 10
                     #~ {2: (1, 'author', 'Allan L. Smith},'), 5: (4, 'abstract', 'submitted to the Utah Veterinary Diagnostic Laboratory for necropsy.\n'), 6: (4, 'abstract', 'There were numerous thick-walled abscesses subcutaneously and\n'), 7: (4, 'abstract', 'internally, and Corynebacterium pseudotuberculosis was isolated in pure\n'), 8: (4, 'abstract', 'culture. In addition, the ram was severely copper deficient, with a\n'), 9: (4, 'abstract', 'liver copper concentration of 1.6 mg/kg.},'), 11: (10, 'misc', 'eeeeeeeeeeeeeeeeee ffffffffffffffffffff gggggggggggggggggg hhhhhhhhhhhhhh\n'), 12: (10, 'misc', 'iiiiiiiiiiiiiiiiiii jjjjjjjjjjjjjjjjjjjjjjjjj\n'), 13: (10, 'misc', 'kkkkkkkkkkkkkkkkkk}\n')}


                print("\n\ncontinuation_line_index_value_dict: ")
                for k,v in iteritems(continuation_line_index_value_dict):
                    future_target_index,last_bib_key,r = v
                    print("\ncontline index: ", str(k), "future_target_index: ", str(future_target_index), last_bib_key ,"\n     contiline: ",  str(v))
                    #~ continuation_line_index_value_dict:

                    #~ contline index:  2 future_target_index:  1 author
                         #~ contiline:  (1, 'author', 'Allan L. Smith},')

                    #~ contline index:  5 future_target_index:  4 abstract
                         #~ contiline:  (4, 'abstract', 'submitted to the Utah Veterinary Diagnostic Laboratory for necropsy.\n')

                    #~ contline index:  6 future_target_index:  4 abstract
                         #~ contiline:  (4, 'abstract', 'There were numerous thick-walled abscesses subcutaneously and\n')

                    #~ contline index:  7 future_target_index:  4 abstract
                         #~ contiline:  (4, 'abstract', 'internally, and Corynebacterium pseudotuberculosis was isolated in pure\n')

                    #~ contline index:  8 future_target_index:  4 abstract
                         #~ contiline:  (4, 'abstract', 'culture. In addition, the ram was severely copper deficient, with a\n')

                    #~ contline index:  9 future_target_index:  4 abstract
                         #~ contiline:  (4, 'abstract', 'liver copper concentration of 1.6 mg/kg.},')

                    #~ contline index:  11 future_target_index:  10 misc
                         #~ contiline:  (10, 'misc', 'eeeeeeeeeeeeeeeeee ffffffffffffffffffff gggggggggggggggggg hhhhhhhhhhhhhh\n')

                    #~ contline index:  12 future_target_index:  10 misc
                         #~ contiline:  (10, 'misc', 'iiiiiiiiiiiiiiiiiii jjjjjjjjjjjjjjjjjjjjjjjjj\n')

                    #~ contline index:  13 future_target_index:  10 misc
                         #~ contiline:  (10, 'misc', 'kkkkkkkkkkkkkkkkkk}\n')

                print("\n\n")

            strings_to_string_together_list = []
            indexes_to_blank_out_values_list = []

            if len(continuation_line_index_value_dict) > 0:
                is_fatal_error = False
                for target_index in continuation_target_index_list:
                    if DEBUG: print("current target_index in continuation_target_index_list: ", str(target_index))
                    if is_fatal_error:
                        break
                    current_target_bib_key = index_to_bib_key_dict[target_index]
                    if DEBUG: print("current_target_bib_key: ",current_target_bib_key)
                    continuation_line_index_value_dict = continuation_target_index_dict[target_index]
                    for i,vals in iteritems(continuation_line_index_value_dict):
                        if is_fatal_error:
                            break
                        future_target_index,last_bib_key,r = vals
                        if not future_target_index == target_index:
                            continue
                        if not last_bib_key == current_target_bib_key:
                            continue
                        if DEBUG: print("vals:  future_target_index, last_bib_key,r :", str(future_target_index), last_bib_key, r)
                        if last_bib_key in bib_keys_index_dict:
                            last_bib_key_index = bib_keys_index_dict[last_bib_key]
                            if i > last_bib_key_index:
                                #~ target_index = last_bib_key_index
                                if last_bib_key_index != target_index or future_target_index != target_index:
                                    is_fatal_error = True
                                    if DEBUG: print("ERROR[1]: last_bib_key_index != target_index: ", str(last_bib_key_index), str(target_index))
                                b = target_index,r
                                strings_to_string_together_list.append(b)
                                if DEBUG: print("\n")
                                raw_lines[i] = "DELETE INDEX " + str(i)
                                indexes_to_blank_out_values_list.append(i)
                                if DEBUG: print("\n")
                    #END FOR
                #END FOR
                n_contlines_added = 0
                if len(strings_to_string_together_list) > 0:   #do not sort this list.
                    #~ vals:  future_target_index, last_bib_key,r : 1 author Allan L. Smith},
                    #~ vals:  future_target_index, last_bib_key,r : 4 abstract submitted to the Utah Veterinary Diagnostic Laboratory for necropsy.
                    #~ vals:  future_target_index, last_bib_key,r : 4 abstract There were numerous thick-walled abscesses subcutaneously and
                    #~ vals:  future_target_index, last_bib_key,r : 4 abstract internally, and Corynebacterium pseudotuberculosis was isolated in pure
                    #~ vals:  future_target_index, last_bib_key,r : 4 abstract culture. In addition, the ram was severely copper deficient, with a
                    #~ vals:  future_target_index, last_bib_key,r : 4 abstract liver copper concentration of 1.6 mg/kg.},
                    #~ vals:  future_target_index, last_bib_key,r : 10 misc eeeeeeeeeeeeeeeeee ffffffffffffffffffff gggggggggggggggggg hhhhhhhhhhhhhh
                    #~ vals:  future_target_index, last_bib_key,r : 10 misc iiiiiiiiiiiiiiiiiii jjjjjjjjjjjjjjjjjjjjjjjjj
                    #~ vals:  future_target_index, last_bib_key,r : 10 misc kkkkkkkkkkkkkkkkkk}
                    for target_index in continuation_target_index_list:
                        if DEBUG: print("\n\nprocessing target_index of: ", str(target_index))
                        is_real_root = False
                        real_root = None
                        max = len(strings_to_string_together_list)
                        for b in strings_to_string_together_list:
                            target_indexxx,r = b                               # see examples above
                            if target_indexxx != target_index:
                                if DEBUG: print("...........................skipping unrelated 'b': ", str(b))
                                continue
                            if DEBUG: print("\nprocessing current 'b': ", str(b))
                            if not is_real_root:
                                real_root = raw_lines[target_index]
                                is_real_root = True
                                real_root = real_root.strip()
                                real_root = real_root.replace("},","")
                                raw_lines[target_index] = real_root
                                if DEBUG: print("real_root: ", real_root)
                                root = real_root
                            else:
                                root = raw_lines[target_index]
                            new_root = root + " " + r.strip()
                            if DEBUG: print("new_root: ", new_root, "  target_index: ", str(target_index))
                            raw_lines[target_index] = new_root.replace("},","")
                            n_contlines_added = n_contlines_added + 1
                        #END FOR
                        if n_contlines_added > 0:
                            if DEBUG: print("  target_index: ", str(target_index), " rebuilt line: ", raw_lines[target_index])
                            val = raw_lines[target_index]
                            val = val.replace("},","")
                            val = val + "},"
                            raw_lines[target_index] = val.strip()
                        for i in indexes_to_blank_out_values_list:
                            if i == target_index:
                                if DEBUG: print("i == target_index!  NOT DELETED.")
                                continue
                            v = raw_lines[i]
                            if v.startswith("DELETE INDEX"):
                                raw_lines[i] = ""
                                if DEBUG: print("dead line has been deleted: ", str(i), v)
                        #END FOR
                        if DEBUG: print("\n\n")
                        if DEBUG: print("REBUILT line: ",raw_lines[target_index] )
                        if DEBUG: print("\n\n")
                    #END FOR (target_index in continuation_target_index_list)
                #END IF (strings_to_string_together_list > 0)
            #END IF (continuation_line_index_value_dict > 0)
        #END FOR (raw_lines in raw_grouped_list)

        if is_fatal_error:
            if DEBUG: print("\n\nFatal Error in processing Continuation Lines...Aborting Entire Process.\n\n")
            self.bib_set_list_dict.clear()
            return n_bib_sets, is_fatal_error

        #~ --------------------------------------------------
        #~ created grouped_list from raw_grouped_list.
        #~ in doing so, correct @line contiguous with title or author or whatever.
        #~ --------------------------------------------------
        grouped_list = []

        for raw_lines in raw_grouped_list:
            i = 0
            max = len(raw_lines)
            if DEBUG:
                if target_index in raw_lines:
                    print("[1] VERIFY EXISTS:  REBUILT line: ",raw_lines[target_index] )
            while i < max:
                if DEBUG: print("index of raw_lines:  i = ", str(i))
                r = raw_lines[i]
                r = r.lstrip()  #do not remove eol \n from right side...
                if r.startswith("@"):  #must be the first non-blank line in a bib entry
                    if DEBUG: print("@line =  ",r)
                    if r.count("=") > 0:  # title is on same physical line, with no \n after the at_line and before the title (or any other 2nd line bib_key)
                        ncomma = r.find(",")  # comma after the real at_line, and before the 2nd line
                        nequals = r.find("=") #  after the bib_key concatenated with the at_line erroneously
                        n_count_equals = r.count("=")
                        if n_count_equals == 1:
                            if ncomma > 0:
                                if nequals > 0:
                                    if ncomma < nequals:
                                        first = r[0:ncomma]  # 0 is either the current index, or the index of a skipped blank line
                                        if first.endswith(","):
                                            first = first[0:-1]
                                        raw_lines[i] = first + "},\n"  # change ',' to '{,' for @line to aid in splitting
                                        if DEBUG: print("@line:  @1st line: ", first)
                                        second = r[ncomma: ]
                                        second = second.strip() + "\n"
                                        if DEBUG: print("@line:  @2nd line : ", second)
                                        raw_lines.insert((i+1),second)
                                        if DEBUG: print("@2nd line inserted into raw_lines at index : ", str(i+1))
                                        i = max
                                else:
                                    i = i + 1
                                    continue
                            else:
                                i = i + 1
                                continue
                        else:
                            if DEBUG: print("n_count_equals != 1...", r)
                            i = max
                    else:
                        if DEBUG: print("clean @line; just change ',' to '},' : ", r)
                        if r.endswith(","):
                            r = r[0:-1]
                            r = r + "},\n"
                            raw_lines[i] = r
                        i = max
                    #END IF
                    i = i + 1
                elif r.startswith("}"):  # final line; append the original self.original_bib_file_raw_string as a comment to it for later ouput auditing...
                    r = r.strip()
                    raw_lines[i] = r + "\n"
                else:
                    i = i + 1
            #END WHILE
            #~ -----------------
            if DEBUG: print("\n\n[2] number of lines in raw_lines after any insertion of a possible @2nd line(e.g. author or title or whatever): ", str(len(raw_lines)))
            if DEBUG: print("\n\n")
            at_line_index = 0
            last_equals_row_index = None
            i = 0
            highest_index_found = None
            highest_continuation_index_found = None
            max = len(raw_lines)
            while i < max:
                r = raw_lines[i]
                r = r.lstrip()  #do not remove eol \n from right side...
                if r.strip() == "":
                    pass
                elif r.startswith("@"):
                    raw_lines[i] = r
                    at_line_index = i
                    last_equals_row_index = i
                elif r.count("=") > 0:
                    raw_lines[i] = r
                    last_equals_row_index = i  #e.g. author, title, abstract, or any other EXCLUDING continuation lines for prior author, title, abstract or other bib_keys.
                elif r.startswith("}"):
                    raw_lines[i] = r
                    last_equals_row_index = None
                else:
                    if DEBUG: print("\n\nCONTINUATION LINES LIKELY EXIST: ", r)
                    if last_equals_row_index is not None:
                        highest_index_found = last_equals_row_index
                        x = 0
                        ans = True
                        while ans is True:
                            if x == 0:
                                x = last_equals_row_index + 1
                            else:
                                x = x + 1
                            if DEBUG: print("x is: ", str(x))
                            #~ ------------------------------------------
                            #~ ------------------------------------------
                            if x < max:
                                #~ highest_index_found = x
                                s1 = raw_lines[x]
                                if s1.strip() == "":
                                    raw_lines[x] = ""
                                    highest_index_found = x
                                    ans = True
                                    continue
                                elif s1.strip().count("=") == 0:  #double-check...cannot be a continuation line if > 0...
                                    s1 = s1.lstrip()  #do not remove eol \n from right side...
                                    prior_value = raw_lines[last_equals_row_index]
                                    if DEBUG: print("prior_value: ", prior_value)
                                    if DEBUG: print("continuation value to add to prior_value: ", s1)
                                    new_value = prior_value + " " + s1
                                    raw_lines[last_equals_row_index] = new_value
                                    if DEBUG: print("new_value: ", new_value)
                                    #blank out the line to be consolidated so it is skipped and not processed later
                                    if x != last_equals_row_index: #blank out only a continuation line, not a 'real' line
                                        raw_lines[x] = ""
                                    ans = True
                                    highest_continuation_index_found = x
                                    highest_index_found = x
                                    continue
                                else:
                                    ans = False
                                    continue
                            else:
                                ans = False
                                continue
                            #END IF
                            #~ ------------------------------------------
                            #~ ------------------------------------------
                            if not ans:
                                break
                        #END WHILE
                        s = raw_lines[last_equals_row_index]
                        if s.count("=") > 0:
                            s = s.lstrip()  #do not remove eol \n from right side...
                            if s.startswith("author"):
                                bib_key = "author"
                                s_split = s.split("=")
                                if len(s_split) == 2:
                                    value = s_split[1]
                                    del s_split
                                    if value.count(" and ") > 0:
                                        s_split = value.split(" and ")
                                        authorslist = s_split #original order of names
                                        bib_value = ""
                                        for a in authorslist:
                                            a = a.replace("{","")
                                            a = a.replace("}","")
                                            a = a.strip()
                                            if a > "":
                                                if DEBUG: print("a: ", a)
                                                bib_value = bib_value + " and " +  a
                                                if DEBUG: print("bib_value: ", bib_value)
                                        #END FOR
                                        if DEBUG: print("interim author bib_value: ", bib_value)
                                        bib_value = bib_value.strip()
                                        if bib_value.startswith("and"):
                                            bib_value = bib_value[3: ].strip()
                                        if bib_value.endswith(","):
                                            bib_value = bib_value[0:-1].strip()
                                        r = "author = {" + bib_value + "},\n"
                                        if last_equals_row_index == at_line_index:             #  ~50% of the time
                                            last_equals_row_index = highest_continuation_index_found
                                        raw_lines[last_equals_row_index] = r
                                        if DEBUG: print("\n\nNewly reconstructed AUTHOR line is: ", r, "\n\n")
                                    #END IF
                            elif s.startswith("title"):
                                bib_key = "title"
                                #~ s = s.replace("="," = ",1)  no; standardized to no spaces around the =
                                s_split = s.split("=")
                                if len(s_split) == 2:
                                    bib_value = s_split[1]
                                    del s_split
                                    if bib_value.endswith(","):
                                        bib_value = bib_value[0:-1].strip()
                                    r = "title = {" + bib_value + "},\n"
                                    if last_equals_row_index == at_line_index:          #  ~50% of the time
                                        last_equals_row_index = highest_continuation_index_found
                                    raw_lines[last_equals_row_index] = r
                                    if DEBUG: print("\n\nNewly reconstructed TITLE line is: ", r, "\n\n")
                                #END IF
                            elif s.startswith("abstract"):
                                bib_key = "abstract"
                                #~ s = s.replace("="," = ",1)  #no; standardized to no spaces around the =
                                s_split = s.split("=")
                                if len(s_split) == 2:
                                    bib_value = s_split[1]
                                    del s_split
                                    if bib_value.endswith(","):
                                        bib_value = bib_value[0:-1].strip()
                                    r = "abstract = {" + bib_value + "},\n"
                                    if last_equals_row_index == at_line_index:  #highly uncommon for any bib_keys except for author and title lines...
                                        last_equals_row_index = highest_continuation_index_found
                                    raw_lines[last_equals_row_index] = r
                                    if DEBUG: print("\n\nNewly reconstructed ABSTRACT line is: ", r, "\n\n")
                                #END IF
                            else:
                                for bib_key in self.bib_keys_list:
                                    if bib_key != "author" and bib_key != "title" and bib_key != "abstract":  # these 3 are ~99.9% of the need to reconstruct a line with its continuation lines...
                                        if r.startswith(bib_key):
                                            #~ s = s.replace("="," = ",1)  #no; standardized to no spaces around the =
                                            s_split = s.split("=")
                                            if len(s_split) == 2:
                                                bib_value = s_split[1].strip()
                                                del s_split
                                                if bib_value.endswith(","):
                                                    bib_value = bib_value[0:-1].strip()
                                                r = bib_key + " = {" + bib_value + "},\n"
                                                if last_equals_row_index == at_line_index:   #highly uncommon for any bib_keys except for author and title lines...
                                                    last_equals_row_index = highest_continuation_index_found
                                                raw_lines[last_equals_row_index] = r
                                                if DEBUG: print("\n\nNewly reconstructed ", bib_key.upper(), " line is: ", r, "\n\n")
                                            #END IF
                                        #END IF
                                    else:
                                        continue
                                #END FOR
                            #END IF
                        #END IF
                        if highest_index_found is not None:
                            i = highest_index_found  #skip over the continuation lines just added to the last_equals_row_index value
                i = i + 1
            #END WHILE
            if DEBUG: print("\n\n")
            if DEBUG: print("number of lines in raw_lines being added as a bib set list to grouped_list:  ", str(len(raw_lines)))
            if DEBUG: print("\n\n")
            grouped_list.append(raw_lines)
            if DEBUG: print("END OF GROUP OF RAW_LINES")
        #END FOR (raw_lines in raw_grouped_list:)
        if DEBUG: print("END OF GROUP_LIST OF RAW_LINES")
        if DEBUG: print("\n\n")
        if DEBUG: print("number of logical bib set groups in raw .bib file: ", str(len(grouped_list)))
        if DEBUG: print("\n\n")

        if DEBUG:
            for bib_set in grouped_list:
                for line in bib_set:
                    if line == "":
                        continue
                    print(line)
                #END FOR
                print("END OF bib_set\n\n\n")
            #END FOR
            print("END OF grouped_list\n\n\n")

        #~ ------------------------------------------------
        #~ finalize_current_bib_set
        #~ ------------------------------------------------
        import time
        curr_time = round(time.time()*1000)
        curr_time = int(curr_time) # unique base filename for output .ris file...

        bib_set_list = []
        n_bib_sets = 0
        for bib_set in grouped_list:
            bib_set = self.finalize_current_bib_set(bib_set)
            bib_set_list.append(bib_set)
            n_bib_sets =  n_bib_sets + 1
            if DEBUG:
                for r in bib_set:
                    print(str(r))
                #END FOR
        #END FOR

        del grouped_list
        self.bib_set_list_dict[(curr_time+1)] = bib_set_list  # list of list

        if DEBUG: print("\n\n ui.py   number of lines in bib-set group just added to self.bib_set_list_dict: ", str(len(bib_set_list)))
        if DEBUG: print("bib_set_list count: ", str(len(bib_set_list)))
        if DEBUG: print("ui.py   len(self.bib_set_list_dict): ", str(len(self.bib_set_list_dict)))

        return n_bib_sets, is_fatal_error
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_bib_grouped_list(self,raw_lines):
        #~ raw_lines may contain many bib_sets (lines is a list)

        if DEBUG: print("\n\n===begin create_bib_grouped_list(raw_lines)===\n\n")

        QApplication.instance().processEvents()

        lines = []
        grouped_list = []

        self.found_group_start_line = False
        self.found_group_end_line = False
        n_lines_in_raw_lines = len(raw_lines)
        n_line_count = 0
        n_group_count = 0
        for line in raw_lines:
            n_line_count = n_line_count + 1
            if DEBUG: print("\nraw line in raw_lines: ", line)
            line = line.lstrip()
            if line.endswith("}}"):  #~ correct missing final } set terminator line; often the prior line has }} instead.
                line = line[0:-1] + "," + "\n"
            elif  (not line.endswith("},")) and (not line.startswith("@")) and (not line.startswith("abstract")) and (not line.startswith("author")) and (not line.startswith("title")):
                if line.count("={") > 0:
                    if line.endswith(",") and not line.endswith("},"):
                        line = line[0:-1] + "}," + "\n"
                    elif line.endswith("}"):
                        line = line + "," + "\n"
                    else:
                        line = line + "}," + "\n"
                elif line.count("=") > 0:  # skip continuation lines to be re-concatenated to their bib_key = line; they end in nothing special
                    # missing:  ={
                    line = line.replace("=","={",1)
                    if line.endswith(","):
                        line = line[0:-1] + "}," + "\n"
                    elif line.endswith("}"):
                        line = line + "," + "\n"
                    else:
                        line = line + "}," + "\n"
                else:
                    line = line.strip() + "\n" #make consistent the continuation lines to be re-concatenated to their bib_key = line so all end in \n for the later split.
            else:
                pass

            line = line.replace("}, },","},")

            if line.startswith("@"):
                if DEBUG: print("\n@line: ", line)
                #~ -----------------------------
                if not self.found_group_end_line:  #only can be true of there are at least 2 bib_sets in raw_lines...
                    if self.found_group_start_line:  # previous group error;  no last line with a proper closing of "}" that would have reset this boolean to False for the next group to use.
                        if DEBUG: print("new first line without the prior group having been finalized via a proper last line: ", line)
                        lines.append("}\n")
                        if DEBUG: print("\nfinal } line appended.")
                        grouped_list.append(lines)
                        if  DEBUG: print("\n\n\nlines in lines: ", str(len(lines)))
                        del lines
                        lines = []
                    else:
                        #normal case
                        #but possible author/title concatenation to @line.  e.g.  @book{xxxxxxx,author = {william shakespeare, joe blow, sam smith}
                        n0 = line.find("{")
                        n1 = line.find(",")
                        n2 = line.find("=")
                        if n0 > 3:
                            if n1 > n0 + 3:
                                if n2 > n1 + 3:
                                    # seems legitimate concatenation...
                                    if line.endswith(",") and not line.endswith("},"):
                                        line = line.replace(",","},\n")
                                        if DEBUG: print("@line changed due to apparent concatenation: ", line)
                #~ -----------------------------
                self.found_group_start_line = True
                self.found_group_end_line = False

                lines.append(line)   #start of new group
            elif line.startswith("}"):   # end of a logical bib set (group)....except some bad .bib files have no last line with a proper closing of "}"...see above...
                if DEBUG: print("{line found...")
                if self.found_group_start_line:
                    if DEBUG: print("final { line with a valid matching first line: ", line, "<<<<<")
                    lines.append(line)  #end of current group
                    grouped_list.append(lines)
                    n_group_count = n_group_count + 1
                    nr = round(n_group_count, -1)
                    if str(nr).endswith("0"):
                        QApplication.instance().processEvents()
                        msg = "JS: BIB Entries Completed: ~" + str(nr)
                        self.maingui.status_bar.show_message(msg)
                    if  DEBUG: print("\n\n\nlines in lines: ", str(len(lines)))
                    del lines
                    lines = []
                    self.found_group_start_line = False
                    self.found_group_end_line = False
                    if DEBUG: print("\ncurrent group was finalized, and now ready for the new group.")
                else:
                    if DEBUG: print("\nlast line without a matching first line; ignore it: ", line)
                    continue
            else:
                lines.append(line)  #all group lines except for the first and the last.
                if DEBUG: print("\ncreate_bib_grouped_list: ", line)
                #~ if there is a missing final "}" line, and if there are no more lines to be grouped, finalize the previous (and only) group
                if n_line_count == n_lines_in_raw_lines:  #implicit end of current group
                    if len(grouped_list) == 0:
                        grouped_list.append(lines)
                        n_group_count = n_group_count + 1
        #END FOR

        if DEBUG: print("bib_sets in grouped_list: ", str(len(grouped_list)))

        if len(grouped_list) == 1:
            for lines in grouped_list:
                lines.append("}\n")  #may or may not be redundant, but the extra final line will be deleted later anyway...
                if DEBUG: print("} line appended due to missing } line...")
                break
            #END FOR

        msg = "JS: BIB Entries Imported:  " + str(n_group_count) + ".   ...Wait..."
        self.maingui.status_bar.show_message(msg)
        QApplication.instance().processEvents()

        if DEBUG: print("\n==end create_bib_grouped_list(raw_lines)==\n\n")

        return grouped_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def finalize_current_bib_set(self,bib_set):
        # done as late as possible
        i = 0
        while i < len(bib_set):
            r = bib_set[i]
            r = as_unicode(r)  #does nothing if it already is a proper str; otherwise, decodes it.
            r = r.lstrip()
            if r.startswith("#") or r.startswith("%") or r.startswith("@preamble") or r.startswith("@STRING"):
                r = ""
            else:

                r = r.replace("}}}}","}")
                r = r.replace("}}}","}")
                r = r.replace("}}","}")
                r = r.replace("}, },","},")

                r = self.correct_bad_bib_grammar(r)

                if r != "":
                    if r.count("={") == 0:
                        if not r.startswith("@") and not r.startswith("}"):
                            if DEBUG: print("ERROR: line is missing '={'   :", r)
                            r = r.replace("=","={",1)

                    if r.count("},") == 0:
                        if not r.startswith("}"):
                            if DEBUG: print("ERROR: line is missing '},'   :", r)
                            r = r.replace(",","},",1)

                    r = r.replace("}, },","},")
                    r = r.replace("={{","={")
                    r = r.replace('"','')  #remove all "  double-quotes

                    #~ ---------------------------------------------
                    #~ final odds and ends to fix (found testing with 100% 'real' .bibs
                    #~ from various academic sources in the wild (PLOS etc. )).
                    #~ ---------------------------------------------
                    if r.startswith("author") or r.startswith("editor"):
                        r = r.replace(" AND "," and ")  #n.b. the Extract RIS Citations (ERC) file-type plugin will change " and " to the Calibre-standard '&'

                    if r.startswith("journal"):
                        r=r.replace("Acm","ACM")
                        r=r.replace("Bmc","BMC")
                        r=r.replace("Faseb","FASEB")
                        r=r.replace("Febs","FEBS")
                        r=r.replace("Hindawi","HINDAWI")
                        r=r.replace("Ieee","IEEE")
                        r=r.replace("Ijatm","IJATM")
                        r=r.replace("Ijss","IJSS")
                        r=r.replace("Isme","ISME")
                        r=r.replace("Mdpi","MDPI")
                        r=r.replace("Nat.","Nature")
                        r=r.replace("Nlm","NLM")
                        r=r.replace("Plos","PLOS")
                        r=r.replace("Pmid","PMID")
                        r=r.replace("Pubmed","PubMed")
                        r=r.replace("\\","")
                    #~ for future use
                    #~ for future use

                    #~ ---------------------------------------------

            bib_set[i] = r
            i = i + 1
        #END WHILE
        return bib_set
    #---------------------------------------------------------------------------------------------------------------------------------------
    def build_bad_bib_grammar_correction_regex_list(self):

        #~ [01] '@BOOK{book-full,'                                should be:  '@book{book-full,'
        #~ [02] 'author = "Donald E. Knuth", '                should be:  'author = {Donald E. Knuth}, '
        #~ [03] 'author = "{\'{E}}douard Masterly",         should be:  'author = {Edouard Masterly},'          another invalid example: Ulrich {\"{U}}nderwood and Ned {\~N}et and Paul {\={P}}ot
        #~ [04] 'volume = 1,'                                           should be:    'volume = {1},'
        #~ [05] 'pages = "179--183",'                              should be:   'pages = {179-183},'
        #~ [06] 'month = "10~" # jan,'                            should be:   'month = {jan},'
        #~ [07] 'month = apr # "-" # may,'                      should be:   'month = {apr},'
        #~ [08] 'year = "{\noopsort{1973b}}1973",'         should be:    'year = {1973},'
        #~ [09]            #for future use
        #~ [10]            #for future use

        #~ all are executed in numeric sequence, so, for example, #05 will already have had its double-quotes corrected by #02
        regex01 = '(^@.+?[,])'                                               # @BOOK{book-full,
        regex02 = '^[a-z]+[ ]+[=][ ]+(["].+?["])[,]'                  # author = "Donald E. Knuth",   caution: raw lines may have random spacing length, so:  [ ]+  not  [ ]
        regex03 = '^(author|title)'                                         # author = Ulrich {\"{U}}nderwood and Ned {\~N}et and Paul {\={P}}ot
        regex04 = '[^{].+?[^}][,]$'                                          # volume = 1,
        regex05 = 'pages[ ]+='                                              #pages = {179--183},     caution: raw lines may have random spacing length, so:  [ ]+  not  [ ]
        regex06 = '^month[= ]+.+?([0-9][0-9]*)'                   #  month = "10~" # jan,
        regex07 = '^month[= ]+.+?([a-z]{3})'                         # month = apr # "-" # may
        regex08 = '([0-9]{4})'                                                  # year = "{\noopsort{1973b}}1973",
        #~ regex09 = ''                                                          #for future use
        #~ regex10 = ''                                                          #for future use

        regex_list = []
        regex_list.append(regex01)
        regex_list.append(regex02)
        regex_list.append(regex03)
        regex_list.append(regex04)
        regex_list.append(regex05)
        regex_list.append(regex06)
        regex_list.append(regex07)
        regex_list.append(regex08)
        #~ regex_list.append(regex09)   #for future use
        #~ regex_list.append(regex10)   #for future use

        self.bad_bib_grammar_regex_list = regex_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def correct_bad_bib_grammar(self,line):
        if DEBUG: print("\ncorrect_bad_bib_grammar:  line in: ", line)
        line = self.correct_bad_bib_grammar_case_01(line)
        line = self.correct_bad_bib_grammar_case_02(line)
        line = self.correct_bad_bib_grammar_case_03(line)
        line = self.correct_bad_bib_grammar_case_04(line)
        line = self.correct_bad_bib_grammar_case_05(line)
        line = self.correct_bad_bib_grammar_case_06(line)
        line = self.correct_bad_bib_grammar_case_07(line)
        line = self.correct_bad_bib_grammar_case_08(line)
        #~ line = self.correct_bad_bib_grammar_case_09(line)
        #~ line = self.correct_bad_bib_grammar_case_10(line)
        if DEBUG: print("correct_bad_bib_grammar:  line out: ", line)
        return line
    #---------------------------------------------------------------------------------------------------------------------------------------
    def correct_bad_bib_grammar_case_01(self,line):
        if not line.startswith("@"):
            return line
        # @BOOK{book-full,
        regex01 = self.bad_bib_grammar_regex_list[0]
        match = re.search(regex01,line,re.IGNORECASE|re.MULTILINE)
        if match:
            orig = line
            line = line.lower()
            line = line.strip()
            #~ print("line.strip() added to @line just now in case_01...")
            if line != orig:
                if DEBUG: print("01:  result: ", str(line))
        del match
        return line
    #---------------------------------------------------------------------------------------------------------------------------------------
    def correct_bad_bib_grammar_case_02(self,line):
        #~ bib_key = "........................",  with " around its value
        regex02 = self.bad_bib_grammar_regex_list[1]
        match = re.search(regex02,line,re.IGNORECASE|re.MULTILINE)
        if match:
            orig = line
            line = line.replace('"','')  #remove all "  double-quotes
            if not "={" in line:
                line = line.replace("=","={",1)
            if not "}," in line:
                line = line.replace(",","},",1)    # replace bib_key = "........................" with bib_key = {........................},
            if line != orig:
                if DEBUG: print("02:  result: ", str(line))
        del match
        return line
    #---------------------------------------------------------------------------------------------------------------------------------------
    def correct_bad_bib_grammar_case_03(self,line):
        if line.startswith("abstract"):
            return line
        #~ author = Ulrich {\"{U}}nderwood and Ned {\~N}et and Paul {\={P}}ot
        #~ author = {\'Edouard Masterly},
        #~ author = {Tom T{\'{e}}rrific}
        #~ title = {Corynebacterium pseudotuberculosis and {Copper} {Deficiency} in a {Male} {Rocky} {Mountain} {Bighorn} {Sheep} ({Ovis} canadensis canadensis) in {Utah}, {USA}},
        #~ title = {An {$O(n \\log n / \\! \\log\\log n)$} Sorting Algorithm'
        regex03 = self.bad_bib_grammar_regex_list[2]
        match = re.search(regex03,line,re.IGNORECASE|re.MULTILINE)
        if match:  # matches any author and title lines (only)
            EOL_CHAR_LIST = ['\t','\n','\r','\f','\v']
            case_03_strings_to_remove_list = ['"','$',r'\\',r'\"',r'\~',r'\=',r"\'",r"\'",'[',']']  #also removes " (author and title only)
            orig = line
            if DEBUG: print("correct_bad_bib_grammar_case_03:  line to compress: ", line)
            for c in EOL_CHAR_LIST:
                line = line.replace(c," ")
            #END FOR
            line = line.replace("   "," ").strip()
            line = line.replace("  "," ").strip()
            line = line.replace("  "," ").strip()
            line = line.replace("  "," ").strip()

            line = line.replace("{","")   #e.g.   {Ovis} canadensis canadensis in {Utah}, {USA}},   avoid string.split("},") issues...
            line = line.replace("}","")   #e.g.   {Ovis} canadensis canadensis in {Utah}, {USA}},    avoid string.split("},") issues...
            if DEBUG: print("correct_bad_bib_grammar_case_03:  line length AFTER EOL , {, }, and extra spaces removal: ", str(len(line)))
            if DEBUG: print("correct_bad_bib_grammar_case_03:  line after compression: ", line)

            s_split = line.split("=")  # no spaces around = or will miss half the time...
            bib_key = s_split[0]  #  author or title
            if len(s_split) > 1:
                bib_value = s_split[1]
            else:
                bib_value = ""
            del s_split
            for s in case_03_strings_to_remove_list:
                if s in bib_value:
                    bib_value = bib_value.replace(s,'')
            #END FOR
            bib_value = bib_value.strip()
            if bib_value.endswith(","):
                bib_value = bib_value[0:-1].strip()
            if DEBUG: print("VERIFY:  bib_key: ", bib_key, "  bib_value: ", bib_value)
            line = bib_key + "={" + bib_value + "},"   # now a valid bib_value and line
            line = line.strip()
            if line != orig:
                if DEBUG: print("03:  result: ", str(line))
        del match
        return line
    #---------------------------------------------------------------------------------------------------------------------------------------
    def correct_bad_bib_grammar_case_04(self,line):
        # volume = 1,
        #~ NOT:   @book{mcdougall_doing_2018-1,
        #~ NOT:   title =
        #~ NOT:  author =
        #~ NOT:  abstract =
        regex04 = self.bad_bib_grammar_regex_list[3]
        match = re.search(regex04,line,re.IGNORECASE|re.MULTILINE)
        if match:
            if line.startswith("@") or "@" in line:
                return line
            if line.startswith("title "):
                return line
            if line.startswith("author "):
                return line
            if line.startswith("abstract "):
                return line
            orig = line
            if not "={" in match.group():
                line = line.replace("=","={",1)
            if not "}," in match.group():
                line = line.replace(",","},",1)
            if line != orig:
                if DEBUG: print("04:  result: ", str(line))
        del match
        return line
    #---------------------------------------------------------------------------------------------------------------------------------------
    def correct_bad_bib_grammar_case_05(self,line):
        if not line.startswith("pages"):
            return line
        #pages = {179--183},
        regex05 = self.bad_bib_grammar_regex_list[4]
        match = re.search(regex05,line,re.IGNORECASE|re.MULTILINE)
        if match:
            orig = line
            line = line.replace("---","-")
            line = line.replace("--","-")
            if line != orig:
                if DEBUG: print("05:  result: ", str(line))
        del match
        return line
    #---------------------------------------------------------------------------------------------------------------------------------------
    def correct_bad_bib_grammar_case_06(self,line):
        if not line.startswith("month"):
            return line
        #~  month = "10~" # jan,
        regex06 = self.bad_bib_grammar_regex_list[5]
        match = re.search(regex06,line,re.IGNORECASE|re.MULTILINE)
        if match:
            s = match.group(1)
            if DEBUG: print("month will be: ", s)
            orig = line
            line = "month={" + s + "},"
            if line != orig:
                if DEBUG: print("06:  result: ", str(line))
        del match
        return line
    #---------------------------------------------------------------------------------------------------------------------------------------
    def correct_bad_bib_grammar_case_07(self,line):
        if not line.startswith("month"):
            return line
        #~ month = apr # "-" # may
        regex07 = self.bad_bib_grammar_regex_list[6]
        match = re.search(regex07,line,re.IGNORECASE|re.MULTILINE)
        if match:
            s = match.group(1)
            s = s[0:3] #just in case...
            if DEBUG: print("month will be: ", s)
            orig = line
            line = "month={" + s.lower() + "},"
            if line != orig:
                if DEBUG: print("07:  result: ", str(line))
        del match
        return line
    #---------------------------------------------------------------------------------------------------------------------------------------
    def correct_bad_bib_grammar_case_08(self,line):
        #~ year = "{\noopsort{1973b}}1973"
        if not line.startswith("year"):
            return line
        regex08 = self.bad_bib_grammar_regex_list[7]
        match = re.search(regex08,line,re.IGNORECASE|re.MULTILINE)
        if match:
            s = match.group(1)
            if DEBUG: print("year will be: ", s)
            orig = line
            line = "year={" + s + "},"
            if line != orig:
                if DEBUG: print("08:  result: ", str(line))
        del match
        return line
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def compress_bib_line_eol_chars(self,p3, EOL_CHAR_LIST, line):
                #~ @article{DBLP:journals/nature/WrightOSWSHM22,
                  #~ author    = {Logan G. Wright and
                               #~ Tatsuhiro Onodera and
                               #~ Martin M. Stein and
                               #~ Tianyu Wang and
                               #~ Darren T. Schachter and
                               #~ Zoey Hu and
                               #~ Peter L. McMahon
        match = p3.search(line)   # matches everything, across all line breaks (with DOTALL) for a bib_value, in order to compress the multiline value into a single, long line
        if match:
            matchval = match.group()
            del match
            for c in EOL_CHAR_LIST:
                line = line.replace(c," ")
            #END FOR
            line = line.replace("   "," ").strip()
            line = line.replace("  "," ").strip()
            line = line.replace("  "," ").strip()
            line = line.replace("  "," ").strip()
        #END IF
        else:
            if DEBUG: print("not a match for p3.search(line)...everything should *always* be matched...regex or other related error...", line)
        return line
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def convert_nbib_to_ris_tool_menu(self):
        self.convert_nbib_to_ris_tool(br_data=None)
    def convert_nbib_to_ris_tool(self,br_data):

        #~ Reference:  https://www.nlm.nih.gov/bsd/mms/medlineelements.html

        from calibre_plugins.job_spy.convert_nbib_to_ris import (convert_nbib_to_ris_control,
                                                                                                    parse_nbib_set_list,
                                                                                                    convert_nbib_items_dict_to_ris,
                                                                                                    get_nbib_keys_mapping_dict,
                                                                                                    get_nbib_tag_name_dict,
                                                                                                    write_new_ris_file_to_calibre_autoadd_directory)

        NBIB_KEYS_MAPPING_DICT, NBIB_SPECIFIC_RIS_TAG_LIST = get_nbib_keys_mapping_dict()

        self.nbib_keys_found_set = set()

        tool_name = "JS+ GUI Tool: NBIB to RIS Converter/Exploder to Auto-Add"

        if DEBUG: print("\n\n\nBEGIN:" + tool_name + "\n\n\n")


        self.converted_nbib_to_ris_auto_add_path = gprefs['auto_add_path']  # os path to be watched by auto_adder
        if self.converted_nbib_to_ris_auto_add_path is None:
            if DEBUG: print("gprefs['auto_add_path'] is None...")
            msg = "Your Calibre Preferences for Auto-Adding books are invalid or incomplete."
            return error_dialog(self.maingui, _(tool_name),_(msg), show=True)

        if not os.path.isdir(self.converted_nbib_to_ris_auto_add_path):
            if DEBUG: print("gprefs['auto_add_path'] is not a valid Directory...")
            msg = "Your Calibre Preferences for Auto-Adding books are invalid or incomplete."
            return error_dialog(self.maingui, _(tool_name),_(msg), show=True)

        if DEBUG: print("the self.converted_nbib_to_ris_auto_add_path:  ", self.converted_nbib_to_ris_auto_add_path)


        if br_data is None:

            #~ ---------------------------------------------------------------------------
            nbib_paths = self.get_nbib_file_to_convert_to_ris(tool_name)

            if DEBUG: print("qfiledialog nbib_path(s): ", str(nbib_paths))
            #~ if DEBUG: print("type(nbib_paths): ", type(nbib_paths))  # <class 'tuple'>

            mylist,myfilter = nbib_paths  # <class 'tuple'>
            del nbib_paths

            #~ if DEBUG: print(str(mylist), str(myfilter))
            #~ if DEBUG: print("type(mylist): ", type(mylist))  #list

            nbib_paths = mylist
            del mylist

            nbib_paths_list = []

            for nbib_path in nbib_paths:  # unfiltered list
                nbib_path = nbib_path.strip()
                if nbib_path.endswith(".nbib") or nbib_path.endswith(".txt"):  # example: "pubmed-CuervoAnaM-set.txt
                    nbib_paths_list.append(nbib_path)  # list filtered by filtetype
                    if DEBUG: print("nbib_paths_list.append(nbib_path): ", nbib_path)
            #END FOR
            del nbib_paths

            last_used_dir = None
            nbib_paths_final_list = []  #final list after all filetype filtering completed

            for nbib_path in nbib_paths_list:
                if not os.path.isfile(nbib_path):
                    if DEBUG: print("nbib_path is not a valid File...")
                    msg = "Source .nbib file to convert path error.  It is not a valid file:   \n" + nbib_path
                    return error_dialog(self.maingui, _(tool_name),_(msg), show=True)
                last_used_dir,nbib_filename = os.path.split(nbib_path)
                if DEBUG: print("last_used_dir: ", last_used_dir, "  nbib_filename", nbib_filename)
                if not nbib_filename.endswith(".nbib"):
                    if not nbib_filename.endswith("-set.txt"):  # PubMed itself saves search results with the name ending in "-set.txt". example: "pubmed-CuervoAnaM-set.txt" for a file with multiple NBIB entries.
                        if not nbib_filename.startswith("pubmed-"):   # example: "pubmed-CuervoAnaM.txt"  for a single NBIB entry file.
                            continue
                r = nbib_path,nbib_filename
                nbib_paths_final_list.append(r)  #final list after all filetype filtering completed
                if DEBUG: print("\n\npath & filename added for use: ", r)
            #END FOR
            del nbib_paths_list

            if last_used_dir is not None:
                if os.path.isdir(last_used_dir):
                    last_used_dir = last_used_dir.replace(os.sep, '/')
                    prefs['GUI_TOOLS_CONVERT_NBIB_FORMAT_TO_RIS_FORMAT_DIR'] = last_used_dir
                    prefs
                else:
                    if DEBUG: print("last_used_dir is an invalid directory: ", last_used_dir)

            nbib_set_list_dict = {}
            n_nbib_sets = 0
            is_fatal_error = False

            #~ ------------------------------------------------
            #~ read *all* selected .nbib files immediately,
            #~ collect their data in a list, then pass
            #~ that large list of raw data onwards.
            #~ ------------------------------------------------
            files_raw_lines_list = []
            n_raw_lines = 0
            for r in nbib_paths_final_list:
                nbib_path,nbib_filename = r
                try:
                    with open(nbib_path, 'r') as f:
                        raw_lines = f.readlines()
                    f.close()
                    del f
                except Exception as e:
                    if DEBUG: print("Exception in f.readlines(): ", str(e))
                    raw_lines = []
                    is_fatal_error = True
                    break
                files_raw_lines_list.append(raw_lines)
                n_raw_lines = n_raw_lines + len(raw_lines)
                if DEBUG: print("\n\nnumber of lines in raw .nbib file: ", str(len(raw_lines)))
            #END FOR
            #~ ---------------------------------------------------------------------------
        else:
            #~ ---------------------------------------------------------------------------
            if isinstance(br_data,list):
                tool_name = "Via PMID: Automatically Download NBIB, Convert to RIS & Auto-Add"
                n_raw_lines = len(br_data)
                files_raw_lines_list = br_data
                nbib_set_list_dict = {}
                n_nbib_sets = 0
                is_fatal_error = False
            else:
                tool_name = "Via PMID: Automatically Download NBIB, Convert to RIS & Auto-Add"
                n_raw_lines = 0
                files_raw_lines_list = []
                nbib_set_list_dict = {}
                n_nbib_sets = 0
                is_fatal_error = True
                if DEBUG: print(tool_name, "ERROR:  Invalid List:  br_data: ", str(br_data))
            #~ ---------------------------------------------------------------------------
        #END IF (br_data is None)

        if DEBUG: print("\n\nGrand Total of All Lines in All Input Files in files_raw_lines_list: ", str(n_raw_lines))
        #~ ------------------------------------------------
        if not is_fatal_error:
            #~ ------------------------------------------------------------------------------------------------
            #~ ------------------------------------------------------------------------------------------------
            nbib_set_list_dict,n_sets,is_fatal_error = self.split_multiple_nbib_set_file(NBIB_KEYS_MAPPING_DICT,files_raw_lines_list)
            #~ ------------------------------------------------------------------------------------------------
            #~ ------------------------------------------------------------------------------------------------
        if is_fatal_error:
            msg = "Fatal error in processing the input data due to its non-standard nbib format.\n\nRun Calibre again in DEBUG mode to determine exactly why."
            return error_dialog(self.maingui, _(tool_name),_(msg), show=True)
            #~ ------------------------------------------------
        n_nbib_sets = n_nbib_sets + n_sets
        if DEBUG: print("for r in nbib_paths_list;   n_sets: ", str(n_sets))
        self.nbib_set_list_dict = copy.deepcopy(nbib_set_list_dict)

        if n_nbib_sets == 0:
            del self.nbib_set_list_dict
            del convert_nbib_to_ris_control
            del convert_nbib_items_dict_to_ris
            del write_new_ris_file_to_calibre_autoadd_directory
            msg = "Nothing found within the selected files to convert to an RIS format output .ris file.  Nothing done. "
            return error_dialog(self.maingui, _(tool_name),_(msg), show=True)

        #~ -----------------------------------------------------------------------------
        if DEBUG:
            n = 0
            print("\nSTART of k,v pairs.\n")
            for k,v in iteritems(nbib_set_list_dict):
                n = n + 1
                print("START k is type: ", type(k), " and v is type: ", type(v))  # k is type:  <class 'int'>  and v is type:  <class 'list'>
                print("k: ", str(k))
                #~ for r in v:
                    #~ print(type(r),"  row: ", r)
                #~ #END FOR
                print("END k is type.")
            #END FOR
            print("total k,v pairs found in nbib_set_list_dict: ", str(n))
            print("\nEND of k,v pairs.\n")
            #~ # print("returning True early")
            #~ # return True
        #~ -----------------------------------------------------------------------------
        del nbib_set_list_dict

        QApplication.instance().processEvents()

        #~ 1 .nbib entry == 1 .nbib group == 1 .nbib set.
        #~ Rough number of lines in a .nbib file for a single "entry":  ~10-20, depending on its Abstract wrapped length & number of Authors.
        #~ group = "a set of nbib lines that comprise a single "entry".  Analagous to an RIS "set" for the same reason and purpose.
        #~ 1 .nbib entry (group) (set) is converted into 1 .ris set.
        #~ Factoid: although there are many more "Tags" in RIS than nbib, the nbib format (used since ~2020) has been mandated (in lieu of RIS) for the Life Sciences.

        msg = "The number of RIS books ready to save for Calibre auto-adding: " + str(n_nbib_sets)
        for k,nbib_set in iteritems(self.nbib_set_list_dict):  # 1 unique filename per 1 nbib_set of nbib tags.
            s = " ".join(nbib_set)
            if DEBUG: print("\npreview msg: ", s)
            msg = msg + "<br>Preview:<br>" + s
            msg = msg[0:400]
            del s
            break
        #END FOR

        msg = msg + "<br><br>Do you wish to continue?"

        if question_dialog(self.maingui, tool_name, msg):
            pass
        else:
            del self.nbib_set_list_dict
            del convert_nbib_to_ris_control
            del convert_nbib_items_dict_to_ris
            del write_new_ris_file_to_calibre_autoadd_directory
            return

        if DEBUG:
            nbib_keys_found_list = list(self.nbib_keys_found_set)
            del self.nbib_keys_found_set
            nbib_keys_found_list.sort()
            n = len(nbib_keys_found_list)
            print("\n\nNumber of unique nbib_keys found: ", str(n))
            for nbib_key in nbib_keys_found_list:
                    print(nbib_key)  #inspect manually for 'unknown' keys.
            print("\n\n")

        QApplication.instance().processEvents()
        qappcurrent = QApplication.instance()
        #~ ------------------------------------------------------------------------------------------------
        #~ ------------------------------------------------------------------------------------------------
        is_valid,msg0 = convert_nbib_to_ris_control(qappcurrent, self.maingui, self.nbib_set_list_dict, n_nbib_sets, self.converted_nbib_to_ris_auto_add_path)
        if is_valid:
            msg = "Selected files containing " + str(n_nbib_sets)  + " NBIB/Medline/PubMed sets/entries/citations were each converted to the corresponding RIS format, then added to your specified Calibre Auto-Add directory:<br>" + self.converted_nbib_to_ris_auto_add_path
        else:
            msg = "ERROR:  Selected files were NOT converted to RIS formats <br>and NOT added to the Auto-Add directory:<br>" + self.converted_nbib_to_ris_auto_add_path + "<br><br>" + msg0
        #~ ------------------------------------------------------------------------------------------------
        #~ ------------------------------------------------------------------------------------------------
        msg2 = "JS: New RIS 'Books' are now being GRADUALLY Auto-Added by Calibre:  " + str(n_nbib_sets)
        self.maingui.status_bar.show_message(msg2)
        QApplication.instance().processEvents()

        del convert_nbib_items_dict_to_ris
        del convert_nbib_to_ris_control
        del get_nbib_keys_mapping_dict
        del get_nbib_tag_name_dict
        del parse_nbib_set_list
        del self.nbib_set_list_dict
        del write_new_ris_file_to_calibre_autoadd_directory

        if DEBUG: print("\n\n\nEND: " + tool_name + "\n\n\n")

        return info_dialog(self.maingui, tool_name,msg).show()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_nbib_file_to_convert_to_ris(self,tool_name):

        last_used_dir = prefs['GUI_TOOLS_CONVERT_NBIB_FORMAT_TO_RIS_FORMAT_DIR']

        if not os.path.isdir(last_used_dir):
            msg = "Have you already set your Calibre > Preferences > Add Books > Automatic Adding properly?"
            msg = msg + "<br><br>RIS .ris file types are not ebook formats, so you must specify the proper Auto-Add option in the Preferences, "
            msg = msg + "or the newly created .ris files will not be automatically added by Calibre as new 'books'.  You will have to manually Drag-and-Drop them to add them."
            msg = msg + "<br><br>You must Restart Calibre after updating those Preferences."
            msg = msg + "<br><br>If you use the JS+ Tweak to specify an Auto-Add Directory by Library, you must do the above too."
            if question_dialog(self.gui, tool_name, msg):
                pass
            else:
                return None

        fd = QFileDialog()
        fd.setFileMode(QFileDialog.FileMode.ExistingFile)
        fd.setNameFilters(['nbib (*.nbib)'])
        fd.selectNameFilter('nbib (*.nbib)')
        if os.path.isdir(last_used_dir):
            fd.setDirectory(last_used_dir)
        fd.setParent(None)

        if fd.accepted:
            nbib_paths = fd.getOpenFileNames()  #multiple .nbib files simultaneously
            return nbib_paths

        return None
    #---------------------------------------------------------------------------------------------------------------------------------------
    def split_multiple_nbib_set_file(self,NBIB_KEYS_MAPPING_DICT,files_raw_lines_list):
        #~ All lines from all selected input files are contained in parameter files_raw_lines_list.
        #~ Whether there are 10 files with 1 nbib set each, or 1 file with 10 nbib sets, or all 11,
        #~ the processing from here forward is of a single list,  'files_raw_lines_list'.
        #~ ------------------------------------------------
        nbib_set_list_dict = {}
        KEYVAL_SEPARATOR = "⎨"      # U+23A8  unique characters required for unique line splitting symbol  e.g. "pmid⎨35835100".split(KEYVAL_SEPARATOR)
        is_fatal_error = False
        n_nbib_sets = 0
        #~ ------------------------------------------------
        raw_string = "\n"
        raw_lines = None
        for raw_lines in files_raw_lines_list:
            raw_string = raw_string + "\n".join(raw_lines) + "\n"
        #END FOR
        del raw_lines
        del files_raw_lines_list
        #~ ------------------------------------------------
        for c in ['\t','\r','\f','\v']:  # not! \n
            raw_string = raw_string.replace(c,"")
        #END FOR
        raw_string = raw_string.replace("    "," ")
        raw_string = raw_string.replace("  "," ")
        raw_string = raw_string.replace(" "," ")
        raw_string = raw_string.replace(" "," ")
        #~ if DEBUG: print("\n\nraw string: ", raw_string)
        self.original_nbib_file_raw_string = raw_string
        #~ ------------------------------------------------
        n1 = raw_string.count("PMID")
        n2 = raw_string.count("OWN")
        if n1 > 0 and n2 > 0:
            n_pmids = n2     # PMIDs are often referenced in SO, so use OWN as its accurate proxy...
            if n_pmids > 1:  #multiple nbib_sets in a single physical input file.
                is_multiple_sets = True
            else:
                is_multiple_sets = False
        else:
            is_fatal_error = True
            msg = "FILE ERROR: The selected file is not an NBIB/Medline/PubMed format file.  Aborting Conversion to RIS."
            if DEBUG: print(msg)
            nbib_set_list_dict.clear()
            n_nbib_sets = 0
            return nbib_set_list_dict,n_nbib_sets,is_fatal_error

        #~ ------------------------------------------------
        raw_linesx = raw_string.split("\n")
        del raw_string
        if DEBUG:
            print("\nnumber of lines in raw_linesx after split at new-line: ", str(len(raw_linesx)))
            for line in raw_linesx:
                if line.startswith("PMID"):
                    print("PMID in raw_linesx: ", line)
            #END FOR
            print("\n")
        #~ ------------------------------------------------
        raw_lines = []
        for r in raw_linesx:
            r = r.lstrip()  #do not remove eol \n from right side...
            if not r.strip() > "":
                continue  #remove blank lines
            r = as_unicode(r)  #does nothing if it already is a proper str; otherwise, decodes it.
            r = r.lstrip()
            r = r.replace("  -","-",1)
            r = r.replace("-  ","-",1)
            r = r.replace(" -","-",1)
            r = r.replace("- ","-",1)
            r = r.replace(" -","-",1)
            r = r.replace("- ","-",1)
            if r[0:2] in NBIB_KEYS_MAPPING_DICT or r[0:3] in NBIB_KEYS_MAPPING_DICT or r[0:4] in NBIB_KEYS_MAPPING_DICT:  #never replace a 'real' hyphen used in 'real' continuation line text (e.g. AB Abstract)
                r = r.replace("-",KEYVAL_SEPARATOR,1)    # ⎨  U+23A8  unique character required for unique line splitting symbol  e.g. "pmid⎨35835100".split(KEYVAL_SEPARATOR)
            r = r.replace("{","") #this is NBIB, not BIB.
            r = r.replace("}","")
            raw_lines.append(r)
        #END FOR
        del r
        del raw_linesx
        if DEBUG: print("\n\nnew number of non-blank lines in raw_lines: ", str(len(raw_lines)), "\n\n")
        #~ ------------------------------------------------
        #~ ------------------------------------------------
        raw_grouped_list = self.create_nbib_grouped_list(is_multiple_sets,n_pmids,raw_lines)
        #~ --------------------------------------------------
        #~ --------------------------------------------------
        #~ correct nbib_keys with continuation lines separated by \n instead of just wrapping (e.g. a long text like Abstract, multiple Authors or Addresses, or anything else.)
        #~ --------------------------------------------------
        if DEBUG: print("groups in raw_grouped_list: ", str(len(raw_grouped_list)), "\n\n")
        #~ --------------------------------------------------
        del raw_lines
        raw_lines = None
        for raw_lines in raw_grouped_list:  # raw_grouped_list is a list of lists (raw_lines is list comprising a *single* entire nbib set (i.e., an entire citation))
            continuation_target_index_dict = {}  # continuation_target_index_dict[target_index] = continuation_line_index_value_dict
            continuation_line_index_value_dict = {}
            continuation_target_index_list = []
            i = 0  # do not add or remove any indexes below!
            max = len(raw_lines)
            nbib_keys_index_dict = {}            # [nbib_key] = i
            index_to_nbib_key_dict = {}         # [i] = nbib_key
            last_nbib_key = None
            target_index = None
            pmid_line_index = None
            current_pmid = None
            while i < max:
                r = raw_lines[i]
                if r.strip() == "":
                    i = i + 1
                    continue
                if r.startswith("PMID"):
                    current_pmid = r
                    if DEBUG: print("current_pmid: ", r)
                    nbib_key = "PMID"
                    last_nbib_key = nbib_key
                    index_to_nbib_key_dict[i] = nbib_key
                    nbib_keys_index_dict[nbib_key] = i
                    pmid_line_index = i
                    self.nbib_keys_found_set.add(nbib_key)
                elif r.count(KEYVAL_SEPARATOR) > 0:
                    n = r.find(KEYVAL_SEPARATOR)
                    nbib_key = r[0:n].strip()
                    last_nbib_key = nbib_key
                    index_to_nbib_key_dict[i] = nbib_key
                    nbib_keys_index_dict[nbib_key] = i
                    self.nbib_keys_found_set.add(nbib_key)
                else:
                    #continuation lines
                    future_target_index = nbib_keys_index_dict[last_nbib_key]
                    r = r.replace(KEYVAL_SEPARATOR,"-") #just in case the long text actually used a hyphen and now had the kvs.
                    continuation_line_index_value_dict[i] = future_target_index,last_nbib_key,r.strip()  # strip its root too below.
                    continuation_target_index_dict[future_target_index] = continuation_line_index_value_dict
                    continuation_target_index_list.append(future_target_index)
                    prev_root_tmp = raw_lines[future_target_index]
                    prev_root_tmp = prev_root_tmp.strip()
                    raw_lines[future_target_index] = prev_root_tmp  # strip its continuation line too above.
                    #~ if DEBUG: print("continuation_line_index_value_dict:  added:  contline index of: ", str(i)," with: ", last_nbib_key, r)
                    #~ if DEBUG: print("continuation_target_index_dict[future_target_index]: ", str(future_target_index), "  has a nbib_key of: ", last_nbib_key)
                i = i + 1
            #END WHILE

            continuation_target_index_list = list(set(continuation_target_index_list))
            continuation_target_index_list.sort()
        #~ --------------------------------------------------
            #~ if DEBUG:
                #~ print("\n\nindex_to_nbib_key_dict: ")
                #~ for k,v in iteritems(index_to_nbib_key_dict):
                    #~ print(str(k), str(v))
                #END FOR

                #~ print("\n\ncontinuation_target_index_dict: ")
                #~ for k,v in iteritems(continuation_target_index_dict):
                    #~ print("\n",str(k), "\n", str(v))
                #END FOR

                #~ print("\n\ncontinuation_line_index_value_dict: ")
                #~ for k,v in iteritems(continuation_line_index_value_dict):
                    #~ future_target_index,last_nbib_key,r = v
                    #~ print("\ncontline index: ", str(k), "future_target_index: ", str(future_target_index), last_nbib_key ,"\n     contiline: ",  str(v))
                 #END FOR
                #~ print("\n\n")
        #~ --------------------------------------------------
            strings_to_string_together_list = []
            indexes_to_blank_out_values_list = []

            if len(continuation_line_index_value_dict) > 0:
                if DEBUG: print("...continuation lines found for this current_pmid in raw_lines...", current_pmid)
                is_fatal_error = False
                for target_index in continuation_target_index_list:
                    #~ if DEBUG: print("current target_index in continuation_target_index_list: ", str(target_index))
                    if is_fatal_error:
                        break
                    current_target_nbib_key = index_to_nbib_key_dict[target_index]
                    #~ if DEBUG: print("current_target_nbib_key: ",current_target_nbib_key)
                    continuation_line_index_value_dict = continuation_target_index_dict[target_index]
                    for i,vals in iteritems(continuation_line_index_value_dict):
                        if is_fatal_error:
                            break
                        future_target_index,last_nbib_key,r = vals
                        if not future_target_index == target_index:
                            continue
                        if not last_nbib_key == current_target_nbib_key:
                            continue
                        #~ if DEBUG: print("vals:  future_target_index, last_nbib_key,r :", str(future_target_index), last_nbib_key, r)
                        if last_nbib_key in nbib_keys_index_dict:
                            last_nbib_key_index = nbib_keys_index_dict[last_nbib_key]
                            if i > last_nbib_key_index:
                                #~ target_index = last_nbib_key_index
                                if last_nbib_key_index != target_index or future_target_index != target_index:
                                    is_fatal_error = True
                                    if DEBUG: print("ERROR[1]: last_nbib_key_index != target_index: ", str(last_nbib_key_index), str(target_index))
                                b = target_index,r
                                strings_to_string_together_list.append(b)
                                #~ if DEBUG: print("\n")
                                #~ raw_lines[i] = "DELETE INDEX " + str(i)
                                indexes_to_blank_out_values_list.append(i)
                                #~ if DEBUG: print("\n")
                    #END FOR
                #END FOR
                n_contlines_added = 0
                if len(strings_to_string_together_list) > 0:   #do not! sort this list.
                    for target_index in continuation_target_index_list:
                        #~ if DEBUG: print("\n\nprocessing target_index of: ", str(target_index))
                        is_real_root = False
                        real_root = None
                        max = len(strings_to_string_together_list)
                        for b in strings_to_string_together_list:
                            target_indexxx,r = b                               # see examples above
                            if target_indexxx != target_index:
                                #~ if DEBUG: print("...........................skipping unrelated 'b': ", str(b))
                                continue
                            #~ if DEBUG: print("\nprocessing current 'b': ", str(b))
                            if not is_real_root:
                                real_root = raw_lines[target_index]
                                is_real_root = True
                                real_root = real_root.strip()
                                raw_lines[target_index] = real_root
                                if DEBUG: print("real_root: ", real_root)
                                root = real_root
                            else:
                                root = raw_lines[target_index]
                            new_root = root + " " + r.strip()
                            #~ if DEBUG: print("new_root: ", new_root, "  target_index: ", str(target_index))
                            raw_lines[target_index] = new_root.strip()
                            n_contlines_added = n_contlines_added + 1
                        #END FOR
                        if n_contlines_added > 0:
                            #~ if DEBUG: print("  target_index: ", str(target_index), " rebuilt line: ", raw_lines[target_index])
                            val = raw_lines[target_index]
                            raw_lines[target_index] = val.strip()
                        for i in indexes_to_blank_out_values_list:
                            if i == target_index:
                                #~ if DEBUG: print("i == target_index!  NOT DELETED.")
                                continue
                            v = raw_lines[i]
                            if v.startswith("DELETE INDEX"):
                                raw_lines[i] = ""
                                #~ if DEBUG: print("dead line has been deleted: ", str(i), v)
                        #END FOR
                        #~ if DEBUG: print("\n\n")
                        if DEBUG: print("REBUILT line: ",raw_lines[target_index] )
                        #~ if DEBUG: print("\n\n")
                    #END FOR (target_index in continuation_target_index_list)
                #END IF (strings_to_string_together_list > 0)
            else:
                if DEBUG: print("...No continuation lines found for this current_pmid in raw_lines...", current_pmid)
            #END IF (continuation_line_index_value_dict > 0)
        #END FOR (raw_lines in raw_grouped_list)

        if is_fatal_error:
            if DEBUG: print("\n\nFatal Error in processing Continuation Lines...Aborting Entire Process.\n\n")
            nbib_set_list_dict.clear()
            return nbib_set_list_dict,n_nbib_sets,is_fatal_error

        #~ --------------------------------------------------
        #~ --------------------------------------------------
        #~ verify data by (again) creating a single group from raw_lines in raw_grouped_list.
        #~ but this time, after continuation lines have been reattached.
        #~ --------------------------------------------------
        #~ --------------------------------------------------
        grouped_list = []
        raw_set = []
        pmid_found = False
        set_added = False
        del raw_lines
        raw_lines = None
        for raw_lines in raw_grouped_list:
            del raw_set
            raw_set = []
            i = 0
            max = len(raw_lines)
            n_pmid = 0
            while i < max:
                r = raw_lines[i]
                r = r.lstrip()
                if r.startswith("PMID"):
                    n_pmid = n_pmid + 1
                    if not pmid_found:
                        if DEBUG: print("Single Group Begins: ", r)  # should ALWAYS be only a first, single group.
                        pmid_found = True
                        raw_set.append(r)
                    else:
                        #~ current group ends...
                        grouped_list.append(raw_set)
                        set_added = True
                        if DEBUG: print("ERROR:  Current Group Ends. ")  # should NEVER see this
                        del raw_set
                        raw_set = []
                        #~ new group begins...
                        if DEBUG: print("ERROR:  New Group Begins: ", r) # should NEVER see this
                        pmid_found = False
                        raw_set.append(r)
                else:
                    raw_set.append(r)
                #~ if DEBUG: print("index, line: ", str(i), r)
                i = i + 1
            #~ #END WHILE
            #~ -----------------
            if DEBUG: print("Number of PMID Lines Found: ", str(n_pmid))

            if n_pmid > 0 and not set_added:     # should ALWAYS be true, since raw_lines should only be a one (1) nbib set.
                grouped_list.append(raw_set)
            else:
                if DEBUG: print("PROGRAM ERROR in 'if n_pmid > 0 and len(grouped_list) == 0: '")
            #~ -----------------
            if DEBUG:
                print("\n\n")
                print("number of nbib tag lines in raw_lines being added as a nbib set list to grouped_list:  ", str(len(raw_set)))
                print("\n\n")
                print("END OF GROUP OF RAW_LINES")
            #~ -----------------
            pmid_found = False
            set_added = False
        #END FOR (raw_lines in raw_grouped_list:)
        #~ -----------------
        del raw_set
        del raw_lines
        del raw_grouped_list
        if DEBUG: print("\n\nEND OF GROUP_LIST OF RAW_LINES")
        if DEBUG: print("number of logical nbib set groups in raw .nbib file: ", str(len(grouped_list)),"\n\n")
        #~ --------------------------------------------------
        #~ --------------------------------------------------

        #~ if DEBUG:
            #~ for nbib_set in grouped_list:
                #~ for line in nbib_set:
                    #~ if line == "":
                        #~ continue
                    #~ print(line)
                #~ #END FOR
                #~ print("END OF nbib_set\n\n\n")
            #~ #END FOR
            #~ print("END OF grouped_list\n\n\n")

        #~ ------------------------------------------------
        #~ finalize_current_nbib_set
        #~ ------------------------------------------------
        import time
        curr_time = round(time.time()*1000)
        curr_time = int(curr_time) # unique base filename prefix for output .ris file...

        if DEBUG: print("\n\nui.py number of nbib_sets in grouped_list to be finalized then added to nbib_set_list: ", str(len(grouped_list)))

        nbib_set_list = []
        n_nbib_sets = 0
        for nbib_set in grouped_list:
            nbib_set = self.finalize_current_nbib_set(nbib_set)
            nbib_set_list.append(nbib_set)
            n_nbib_sets =  n_nbib_sets + 1
            if DEBUG:
                print("START nbib_set listing with: ",str(len(nbib_set)))
                for r in nbib_set:
                    print(str(r))
                    break
                #END FOR
                print("(END nbib_set listing with: ",str(len(nbib_set)))
        #END FOR

        del grouped_list

        for nbib_set in nbib_set_list:  # <<---- nbib_set_list is a list of nbib_sets, which are lists of nbib keys/value tuples.
            curr_time = curr_time + 1
            k = curr_time
            nbib_set_list_dict[k] = nbib_set  # 1 output file per nbib_set...
            if DEBUG: print("----------unique filename added as key to nbib_set_list_dict: ", str(k))
        #END FOR

        if DEBUG: print("\n\nui.py   number of nbib-sets just added to self.nbib_set_list_dict: ", str(len(nbib_set_list)))
        if DEBUG: print("ui.py   number of nbib_sets in nbib_set_list: ", str(len(nbib_set_list)))
        if DEBUG: print("ui.py   number of unique filename/nbib_set k,v pairs in self.nbib_set_list_dict: ", str(len(nbib_set_list_dict)), "\n\n")

        return nbib_set_list_dict,n_nbib_sets,is_fatal_error
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_nbib_grouped_list(self,is_multiple_sets,n_pmids,raw_lines):
        #~ raw_lines usually contains many nbib_sets, but is always explictly stated by is_multiple_sets.

        if DEBUG: print("total number of PMIDs being processed across all data: ", str(n_pmids))

        QApplication.instance().processEvents()

        lines = []
        grouped_list = []

        pmid_found = False
        set_added = False
        n_pmids_found = 0
        n_lines_in_raw_lines = len(raw_lines)
        n_line_count = 0
        n_group_count = 0
        for line in raw_lines:
            n_line_count = n_line_count + 1
            if DEBUG: print("\nraw line in raw_lines: ", line)
            line = line.lstrip()
            if line.startswith("PMID"):
                if DEBUG: print("\nPMIDline: ", line)
                #~ -----------------------------
                n_pmids_found = n_pmids_found + 1
                if pmid_found:
                    #~ finish current group
                    grouped_list.append(lines)
                    if DEBUG: print("set added: at finish of current group.")
                    set_added = True
                    if  DEBUG: print("\n\n\nCurrent PMID Group Finished: #lines: ", str(len(lines)))
                    #~ start new group
                    pmid_found = True
                    set_added = False
                    if DEBUG: print("\n\nNEW PMID: ", line)
                    del lines
                    lines = []
                    lines.append(line)   #start of new group
                else:
                    #normal case
                    pmid_found = True
                    lines.append(line)   #current group
                    if DEBUG: print("\n\nNEW PMID: ", line)
            else:
                lines.append(line)  #all group lines except for the first
                set_added = False
                if DEBUG: print("\ncreate_nbib_grouped_list: ", line)
                if n_line_count == n_lines_in_raw_lines:  #explicit end of the entire raw_lines data from all input files.  but...blank lines at end...
                    if not set_added:
                        grouped_list.append(lines)
                        if DEBUG: print("set added:  explicit end of the entire raw_lines data from all input files.")
                        set_added = True
                        n_group_count = n_group_count + 1
        #END FOR
        if not set_added:       #blank lines at end?  see above.
            grouped_list.append(lines)
            n_group_count = n_group_count + 1
            if DEBUG: print("set added:  after final #END FOR.")

        if n_pmids_found != n_pmids:  #possibly a change in the nbib format causes OWN nbib tags to no longer exist only once per set?
            msg = "\n\nPROGRAM WARNING: n_pmids_found != n_pmids: " + str(n_pmids_found) + " != " + str(n_pmids) + "\n\n"
            self.maingui.status_bar.show_message(msg)
            QApplication.instance().processEvents()
            if DEBUG: print(msg)

        if is_multiple_sets:
            if len(grouped_list) > 1:
                if DEBUG: print("nbib_sets in grouped_list: ", str(len(grouped_list)))
            else:
                msg = "ERROR: expected multiple sets of nbib data were not found! Program Error.  Number actually found was only: " + str(len(grouped_list))
                self.maingui.status_bar.show_message(msg)
                QApplication.instance().processEvents()
                if DEBUG: print(msg)
                grouped_list = []
                return grouped_list

        msg = "JS: All Selected NBIB Tag-Sets Imported...Wait..."
        self.maingui.status_bar.show_message(msg)
        QApplication.instance().processEvents()

        if DEBUG: print("\n==end create_nbib_grouped_list(raw_lines)==\n\n")

        return grouped_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def finalize_current_nbib_set(self,nbib_set):
        i = 0
        while i < len(nbib_set):
            r = nbib_set[i]
            r = r.lstrip()
            if r.startswith("#"):
                r = ""
            else:
                if r.startswith("AU") or r.startswith("FAU"):
                    r = r.replace(" AND "," and ")  #n.b. the Extract RIS Citations (ERC) file-type plugin will change " and " to the Calibre-standard '&' for multiple Authors.
            nbib_set[i] = r
            i = i + 1
        #END WHILE
        return nbib_set
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def customize_the_erc_filetype_plugin_within_js(self):
        from calibre.customize.ui import _initialized_plugins
        myplugin = None
        for plugin in _initialized_plugins:
            if plugin.name == 'Extract RIS Citations':
                myplugin = plugin
                break
        #END FOR
        del _initialized_plugins
        if myplugin is None:
            tool_name = "Customize File-Type Plugin 'Extract RIS Citations'"
            msg = "You must first install the File-Type Plugin 'Extract RIS Citations' before you may customize it.<br><br>If you have already, did you restart Calibre afterwards?"
            return error_dialog(self.maingui, _(tool_name),_(msg), show=True)
        else:
            #~ myplugin <class 'calibre_plugins.extract_ris_citations.Extract_RIS_Citations'> <calibre_plugins.extract_ris_citations.Extract_RIS_Citations object at 0x0000025102C4C040>
            return myplugin.do_user_config(self.maingui)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def download_pmid_nbib_control(self):

         #~ url:  https://pubmed.ncbi.nlm.nih.gov/36476245/?format=pubmed
         #~ caution:  due to javascript, must use browser.open_novisit and not urllib.request.

        tool_name = "Via PMID: Automatically Download NBIB, Convert to RIS and Auto-Add"
        #pop up a text input box to get one or more PMID numbers:
        pmids_string = self.open_qinputdialog_pmid()
        if pmids_string is None:
            msg = "[1] No PubMed PMIDs Specified; Nothing to Do."
            return  error_dialog(self.maingui, _(tool_name),_(msg), show=True)
        pmids_string = pmids_string + "\n"
        pmids = pmids_string.split("\n")
        if not len(pmids) > 0:
            msg = "[2] No PubMed PMIDs Specified; Nothing to Do."
            return  error_dialog(self.maingui, _(tool_name),_(msg), show=True)
        pmids_list = []
        for row in pmids:
            row = row.strip()
            if len(row) > 0:
                if row.isdigit():
                    pmids_list.append(row)
        #END FOR
        if not len(pmids_list) > 0:
            msg = "[3] No Numeric PubMed PMIDs Specified; Nothing to Do."
            return  error_dialog(self.maingui, _(tool_name),_(msg), show=True)

        URL = "https://pubmed.ncbi.nlm.nih.gov/00000000/?format=pubmed"
        VAL = "00000000"

        nbib_set_list = []
        msg = "Retrieved as NBIB and Auto-Added as RIS: \n"

        from calibre import browser
        from calibre.ebooks.BeautifulSoup import BeautifulSoup

        for pmid in pmids_list:
            msg = msg + "PMID: " + pmid + "\n"
            url = URL
            url = url.replace(VAL,pmid)
            nbib_html = None
            br = browser()
            timeout=5000
            raw = br.open_novisit(url, timeout=timeout).read().strip()
            if raw is None:
                continue
            nbib_html = as_unicode(raw)
            nbib_html = as_unicode(nbib_html)
            soup = BeautifulSoup(nbib_html)
            if not soup:
                if DEBUG: print("Not Soup for: ", pmid)
                continue
            soup.body
            soup.div
            ppre = soup.pre
            nbib = ppre.string
            #~ ----------------------------------------------------------------
            #must make data look 100% like it had been read using 'readlines' from a physical file
            #~ ----------------------------------------------------------------
            nbib_list = nbib.split("\n")
            if DEBUG:
                for r in nbib_list:
                    print(r)
                #END FOR
            #~ ----------------------------------------------------------------
            nbib_set_list.append(nbib_list)
            del soup
            del ppre
            del nbib
            del nbib_html
            del raw
        #END FOR

        del browser
        del BeautifulSoup

        if DEBUG: print(msg)

        if isinstance(nbib_set_list,list):
            if len(nbib_set_list) > 0:
                self.download_pmid_nbib_process(nbib_set_list)
                del nbib_set_list
                return
        del nbib_set_list
        msg = "Error: NBIB formats are invalid.\nRun in DEBUG mode to determine why."
        return  error_dialog(self.maingui, _(tool_name),_(msg), show=True)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def open_qinputdialog_pmid(self):
        qid = QInputDialog()
        title = "List of PMIDs for which to retrieve NBIB citations from 'pubmed.ncbi.nlm.nih.gov'"
        qid.setWindowTitle(title)
        s = "Enter a single numeric PMID on its own line, then press 'enter' to go to the next line"
        qid.setLabelText(s)
        if DEBUG:
            qid.setTextValue("36476245\n29626215\n34563704\n19339967\n33442062\n33891876")
        else:
            qid.setTextValue("")
        qid.setOption(QInputDialog.InputDialogOption.UsePlainTextEditForTextInput)
        qid.setInputMethodHints(Qt.ImhMultiLine|Qt.ImhLatinOnly)
        qid.setOkButtonText("Save Changes")
        qid.setFixedSize(200, 200)
        qid.setToolTip("<p style='white-space:wrap'>xxxxxxxxxxxxx")
        qid.show()
        if qid.exec_() == qid.Accepted:
            text = qid.textValue() # After clicking OK, get the input dialog content
            return text
        return None
    #---------------------------------------------------------------------------------------------------------------------------------------
    def download_pmid_nbib_process(self,nbib_set_list):
        self.convert_nbib_to_ris_tool(nbib_set_list)
        return
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def hide_all_custom_columns(self):
        self.hide_show_all_none_custom_columns(source="hide_all")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def show_all_custom_columns(self):
        self.hide_show_all_none_custom_columns(source="show_all")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def hide_unused_show_used_custom_columns(self):
        self.hide_show_all_none_custom_columns(source="default")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def hide_show_all_none_custom_columns(self,source):

        DEFAULT = "default"
        HIDE_ALL = "hide_all"
        SHOW_ALL = "show_all"

        if source == DEFAULT:
            is_default = True
            is_hide_all = False
            is_show_all = False
            tool_name = "JS+:GUI Tool:   'Hide/Show Unused/Used Custom Columns [Beta Test]"
        elif source == HIDE_ALL:
            is_default = False
            is_hide_all = True
            is_show_all = False
            tool_name = "JS+:GUI Tool:   'Hide All Custom Columns [Beta Test]"
        elif source == SHOW_ALL:
            is_default = False
            is_hide_all = False
            is_show_all = True
            tool_name = "JS+:GUI Tool:   'Show All Custom Columns [Beta Test]"
        else:
            return

        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        mysql = "Select type,name FROM sqlite_master WHERE type = 'table' AND name LIKE 'custom_column%' AND name <> 'custom_columns' "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        if len(tmp_rows) == 0:
            my_db.close()
            return
        tmp_rows.sort()
        cc_table_list = []
        for row in tmp_rows:
            type,name = row
            name = as_unicode(name)
            cc_table_list.append(name)
        #END FOR
        del tmp_rows

        cc_table_list = list(set(cc_table_list))

        cc_table_status_dict = {}  #

        mysql = "SELECT count(id) FROM ? "
        for name in cc_table_list:
            if DEBUG: print(name)
            mysql_ = mysql.replace("?",name)
            my_cursor.execute(mysql_)
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                count = 0
            elif len(tmp_rows) == 0:
                count = 0
            else:
                count = 0
                for row in tmp_rows:
                    for col in row:
                        if isinstance(col,int):
                            count = col
                    #END FOR
                #END FOR

            if is_hide_all:
                count = 0
            elif is_show_all:
                count = 1
            else:
                pass
            cc_table_status_dict[name] = count
        #END FOR

        my_db.close()

        library_view = self.maingui.library_view
        column_map = library_view.column_map       #which is also the column_map for the pin_view
        pin_view = library_view.pin_view                     #parent is library_view, not self.maingui
        custom_columns = self.guidb.field_metadata.custom_field_metadata()

        cc_field_to_hide_list = []
        cc_field_to_unhide_list = []

        for field,v in custom_columns.items():
            if 'table' in v:
                table = v['table']
                name = v['name']
                datatype = v['datatype']
                if table in cc_table_status_dict:
                    count = cc_table_status_dict[table]
                    r = field,name,datatype,count
                    if count == 0:
                        cc_field_to_hide_list.append(r)
                    else:
                        cc_field_to_unhide_list.append(r)
                else:
                    continue
            else:
                if DEBUG: print("Error:  table not in v: ", field, str(v))
        #END FOR

        if DEBUG: print("\ncolumns to hide: ", str(len(cc_field_to_hide_list)))
        if DEBUG: print("\ncolumns to unhide: ", str(len(cc_field_to_unhide_list)))

        cc_field_list = list(set(cc_field_to_hide_list + cc_field_to_unhide_list))
        cc_field_list.sort()

        state_before = self.maingui.library_view.get_state()

        n_hidden = 0
        n_unhidden = 0
        cc_hidden_dict = {}  # [field] = idx

        for r in cc_field_list:
            field,name,datatype,count = r   #   #ris_accession_number,AN_accession_number,comments,259
            column = field                           #    explicitly stated for clarity of reference; too many "cols, colnames, columns", etc. that all mean "field".
            if column in column_map:
                idx = column_map.index(column)
                if count > 0:
                    self.maingui.library_view.column_header.setSectionHidden(idx, False)
                    self.maingui.library_view.pin_view.column_header.setSectionHidden(idx, False)
                    n_unhidden = n_unhidden + 1
                else:
                    cc_hidden_dict[column] = idx
                    self.maingui.library_view.column_header.setSectionHidden(idx, True)
                    self.maingui.library_view.column_header.hideSection(idx)
                    self.maingui.library_view.pin_view.column_header.setSectionHidden(idx, True)
                    self.maingui.library_view.pin_view.column_header.hideSection(idx)
                    n_hidden = n_hidden + 1
                #END IF
                if DEBUG: print("\ncolumn/field: ", field, " name: ", name, " datatype: ", datatype, " count: ", str(count))
            else:
                if DEBUG: print("\nError: column not in column_map: ", column)
        #END FOR

        #state is a dict with 7 keys, their values varying from dicts, to lists, to lists of lists, to booleans.
        #state = {'hidden_columns': ['size', 'rating', 'series', '#ris_access_date', '#ris_accession_number',...],         #Notice that hidden columns also have a column_size of 0.
        #~           'sort_history': [['author_sort', True], ['series', True], ['title', True], ['timestamp', False]] ,
        #~           'column_alignment': {'pubdate': 'center', 'size': 'center', 'timestamp': 'center'},
        #~           'column_positions': {'ondevice': 3, 'title': 2, 'authors': 4, 'timestamp': 0, 'size': 80, 'rating': 81, 'tags': 5, 'series': 82, 'publisher': 7, 'pubdate': 8, 'last_modified': 1, 'languages': 9, '#ris_abstract': 6, '#ris_access_date': 10,...
        #~           'column_sizes': {'title': 130, 'authors': 206, 'timestamp': 70, 'size': 0, 'rating': 0, 'tags': 117, 'series': 0, 'publisher': 86,...,
        #~           'last_modified_injected': True,
        #~           'languages_injected': True }

        #~ now begin to update new_state to become the final desired state...

        new_state = state_before  #always start with the current, valid state in existence before this Tool does anything.

        official_hidden_cols_dict = {library_view.column_map[i]: i for i in range(library_view.column_header.count()) if library_view.column_header.isSectionHidden(i) and library_view.column_map[i] not in ('ondevice', 'inlibrary')}

        #~ {'size': 4, 'rating': 5, 'series': 7, '#ris_access_date': 13, '#ris_accession_number': 14, '#ris_alternate_title': 15, '#ris_database_provider': 21, '#ris_end_page': 29, '#ris_journal_name': 34, '#ris_keywords': 37, '#ris_miscellaneous': 42, '#ris_name_of_database': 44, '#ris_note': 45, '#ris_notes': 46, '#ris_place_published': 54, '#ris_pmc_release': 56, '#ris_publication_year': 58, '#ris_reference_id': 61, '#ris_reprint_edition': 62, '#ris_republication': 63, '#ris_secondary_authors': 66, '#ris_secondary_title': 67, '#ris_short_title': 69, '#ris_type_of_work': 79, '#ris_url': 80}

        for col,idx in cc_hidden_dict.items():
            if not col in official_hidden_cols_dict:
                official_hidden_cols_dict[col] = idx
            elif col in cc_field_to_unhide_list:
                del official_hidden_cols_dict[col]
        #END FOR

        hidden_cols = []

        for col,idx in official_hidden_cols_dict.items():
            if col.startswith("#"):
                if col in cc_hidden_dict:
                    hidden_cols.append(col)
                else:
                    pass
            else:
                hidden_cols.append(col)
        #END FOR

        hidden_cols = list(set(hidden_cols))

        if DEBUG: print("n_hidden by this tool: ", str(n_hidden),"<<==#custom <- -> standard + #custom==>>",str(len(hidden_cols)))
        if DEBUG: print("n_unhidden by this tool: ", str(n_unhidden))

        new_state['hidden_columns'] = hidden_cols

        temp = set(hidden_cols)
        error_list = [value for value in cc_field_to_unhide_list if value in temp]
        if len(error_list) > 0:
            if DEBUG: print("ERROR: intersection exists between hidden_cols & cc_field_to_unhide_list: ", str(error_list))
            return

        sizes_dict = new_state['column_sizes']

        for column in hidden_cols:
            sizes_dict[column] = 0
        #END FOR

        for column in cc_field_to_unhide_list:
            sizes_dict[column] = 100
        #END FOR

        new_state['column_sizes'] = sizes_dict

        new_state['sort_history'] = []

        sort_history_list = []
        sort_history_list.append(['authors', True])
        sort_history_list.append(['series', True])
        sort_history_list.append(['title', True])
        sort_history_list = self.maingui.library_view.cleanup_sort_history(sort_history_list, ignore_column_map=False)
        n_sorted = len(sort_history_list)

        new_state['sort_history'] = sort_history_list

        new_state['last_modified_injected'] = False
        new_state['languages_injected'] = False

        if DEBUG:
            for k,v in new_state.items():
                print("\n", str(k), str(v),"\n")

        self.maingui.library_view.apply_state(new_state, max_sort_levels=n_sorted, save_state=True)
        self.maingui.library_view.pin_view.apply_state(new_state)
        self.maingui.library_view.pin_view.save_state()
        QApplication.instance().processEvents()

        msg = tool_name + ": Complete"
        self.maingui.status_bar.show_message(msg)
        QApplication.instance().processEvents()

        if DEBUG: print("\n\n", msg, "\n\n")

        del cc_field_list
        del cc_field_to_hide_list
        del cc_field_to_unhide_list
        del column_map
        del custom_columns
        del hidden_cols
        del library_view
        del mysql
        del mysql_
        del new_state
        del pin_view
        del sizes_dict
        del sort_history_list
        del state_before
        del temp

    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
#END class ActionJobSpy
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
from qt.core import Qt, QCalendarWidget, QLabel, QDate, QVBoxLayout, QPushButton
    #---------------------------------------------------------------------------------------------------------------------------------------
class PopUpCalendar(QDialog):

    def __init__(self,gui,icon,guidb,execute_reset_date_for_selected_books):
        parent = gui
        QDialog.__init__(self, parent)

        self.gui = gui
        self.guidb = guidb

        self.execute_reset_date_for_selected_books = execute_reset_date_for_selected_books

        self.layout_frame = QVBoxLayout()
        self.layout_frame.setAlignment(Qt.AlignLeft)
        self.setLayout(self.layout_frame)

        self.my_calendar = QCalendarWidget(self)
        self.my_calendar.setGridVisible(True)
        self.layout_frame.addWidget(self.my_calendar)

        self.today = self.my_calendar.selectedDate().toString("yyyy-MM-dd")

        self.push_button_reset_data = QPushButton("Apply New Date [Selected Books]")
        self.push_button_reset_data.clicked.connect(self.reset_date_for_selected_books)
        self.push_button_reset_data.setDefault(True)
        self.push_button_reset_data.setToolTip("<p style='white-space:wrap'>Apply the chosen date (UTC at 12 Noon) as the new Last-Modified Date.  Future dates will be ignored.")
        self.layout_frame.addWidget(self.push_button_reset_data)

        self.setGeometry(300, 300, 300, 300)
        self.setWindowTitle('New Last-Modified Date')

        self.show()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def reset_date_for_selected_books(self):
        d = self.my_calendar.selectedDate()
        new_last_modified_date = d.toString("yyyy-MM-dd")
        if new_last_modified_date > self.today:    # disallow future dates
            return
        self.execute_reset_date_for_selected_books(new_last_modified_date)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #END of ui.py