#!/usr/bin/env python2

__license__   = 'GPL v3'
__copyright__ = '2023, Split, split@ahmadz.ai'

from calibre.gui2.actions import InterfaceAction
from calibre.customize import InterfaceActionBase
import time
from calibre_plugins.discord_rpc.pypresence.presence import Presence


class InterfacePluginBase(InterfaceActionBase):
    name = 'Discord RPC'
    description = 'Adds Discord Rich Presence support to Calibre'
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'Split'
    version = (0, 0, 1)
    can_be_disabled = True
    minimum_calibre_version = (0, 7, 0)
    actual_plugin = 'calibre_plugins.discord_rpc:DiscordRPC'


class DiscordRPC(InterfaceAction):
    def genesis(self):
        self.qaction.triggered.connect(self.gui.iactions['View']._view_calibre_books)
        orig_func = self.gui.iactions['View']._view_calibre_books

        client_id = '1080014793064316949'
        RPC = Presence(client_id)
        RPC.connect()

        def view_and_rpc(book_ids):
            orig_func(book_ids)

            if len(book_ids) > 0:
                db = self.gui.current_db.new_api
                first_book = db.field_for('title', book_ids[0], default_value='Unknown Title')
                first_book_author = db.field_for('authors', book_ids[0])
                first_book_author = first_book_author[0] if len(first_book_author) > 0 else 'Unknown Author'

                # Update the RPC
                RPC.update(details=first_book, state=first_book_author, large_image="calibre", large_text="Calibre", small_image="book", small_text="Reading a book", start=time.time())

        self.gui.iactions['View']._view_calibre_books = view_and_rpc

        RPC.update(details="Browsing books", state="Not reading", large_image="calibre", large_text="Calibre",
                   small_image="book", small_text="Not reading a book")
