EPOM_ALL_VALID_TWEAKS = \
"""
#~--------------------------------------------------------------------------
#~--------------------------------------------------------------------------
#~This list of Tweaks will be executed in the exact order you decide.
#~Tweaks may be executed multiple times via copy & paste.
#~Activate a Tweak by removing the leading '#'
#~Deactivate a Tweak by adding a leading '#'
#~Default values are available for copying from "Tweaks Example".
#~--------------------------------------------------------------------------
#~--------------------------------------------------------------------------
ADDITIONAL_FINDITER_REGEX='pattern',flags=IGNORECASE,MULTILINE,DOTALL
ADDITIONAL_SEARCH_REGEX='pattern',flags=IGNORECASE,MULTILINE,DOTALL
#~--------------------------------------------------------------------------
#~The "REMOVE_" function values should be changed as needed.
#~--------------------------------------------------------------------------
#~Remember that in Unicode, a 'dash' is not always a 'dash'.
#~For example, both of these are 'dashes', but are different:  – & -
#~see: https://codepoints.net
#~If 'removing' a specific character does nothing, see the above.
#~--------------------------------------------------------------------------
REMOVE_CHARACTERS=©!@#$%=*+{}[]|:;
REMOVE_STARTSWITH='?'
REMOVE_ENDSWITH='?'
REMOVE_(.......)=True
REMOVE_NUMBERS=True
REMOVE_LETTERS=a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,ä,ö,ü,ß,å,æ,œ,ø,ñ,ç,ã,á,é,í,ó,ú,ğ,ı,ş,à,â,ê,ô,ã,õ,Α,α,Β,β,Γ,γ,Δ,δ,Ε,ε,Ζ,ζ,Η,η,Θ,θ,Ι,ι,Κ,κ,Λ,λ,Μ,μ,Ν,ν,Ξ,ξ,Ο,ο,Π,π,Ρ,ρ,Σ,σ,/,ς,Τ,τ,Υ,υ,Φ,φ,Χ,χ,Ψ,ψ,Ω,ω
REMOVE_PUNCTUATION=['~','`','@','#','$','%','^','&','*','(',')','-','–','_','+','=','{','}','[',']','<','>',',','.','/','?',';',':','|','\\','"',"'"]
REMOVE_UNICODE_DASHES=-֊־᐀᠆‑‒–—⸗⸚⸺⸻⹀〜〰゠﹘﹣－
REMOVE_UNICODE_DOTS=.܁·𐤟࠰·․
#~--------------------------------------------------------------------------
#~For adding values to Tag-Like Custom Columns, the
#~INSERT_SEPARATOR_BEFORE function is useful, since EPOM
#~will easily be able to create a list of separated values.
#~The first parameter is where to insert in front of, and the second is what to insert
#~The first parameter is retained in the final value; nothing is done but to
#~insert the separator value before each of the found first parameters.
#~------------------------------------------
#~INSERT_SEPARATOR_BEFORE requires an "escaped" comma (even for & Author-Like)
#~in the values to differentiate them from the commas within each argument.
#~Example:    Wrong:  '978',','     Correct:  '978','\,'  for updating a Tag-Like ISBN
#~Custom Column containing all of the possible ISBNs to be found in a book.
#~--------------------------------------------------------------------------
INSERT_SEPARATOR_BEFORE='978','\,'
INSERT_SEPARATOR_BEFORE='979','\,'
#~--------------------------------------------------------------------------
#~ "TO_ACCEPT" Means that 'nothing' will be used from the point
#~ that the 2 Tweaks below are executed and found to be True.
#~ These 2 Tweaks do not slice the existing results; they either
#~ do nothing if False, or change the results to an empty value of ''.
#~--------------------------------------------------------------------------
MINIMUM_LENGTH_TO_ACCEPT=3
MAXIMUM_LENGTH_TO_ACCEPT=150
#~--------------------------------------------------------------------------
#~--------------------------------------------------------------------------
#~ EPOM itself will always insert the most current search results value, val.
#~--------------------------------------------------------------------------
#~ String Case Changes - supported functions:
#~--------------------------------------------------------------------------
CALIBRE_TEMPLATE_LANGUAGE_BUILTIN=capitalize(val)
CALIBRE_TEMPLATE_LANGUAGE_BUILTIN=lowercase(val)
CALIBRE_TEMPLATE_LANGUAGE_BUILTIN=titlecase(val)
CALIBRE_TEMPLATE_LANGUAGE_BUILTIN=uppercase(val)
#~--------------------------------------------------------------------------
#~ String Manipulation - supported functions:
#~--------------------------------------------------------------------------
CALIBRE_TEMPLATE_LANGUAGE_BUILTIN=re(val, 'pattern', 'replacement')
CALIBRE_TEMPLATE_LANGUAGE_BUILTIN=shorten(val, n_left, 'middle text', n_right)
CALIBRE_TEMPLATE_LANGUAGE_BUILTIN=strlen(val)
CALIBRE_TEMPLATE_LANGUAGE_BUILTIN=substr(val, n_start, n_end)
CALIBRE_TEMPLATE_LANGUAGE_BUILTIN=swap_around_articles(val)
CALIBRE_TEMPLATE_LANGUAGE_BUILTIN=swap_around_comma(val)
CALIBRE_TEMPLATE_LANGUAGE_BUILTIN=transliterate(val)
#~--------------------------------------------------------------------------
#~--------------------------------------------------------------------------
#~This list of Tweaks will be executed in the exact order you decide.
#~Tweaks may be executed multiple times via copy & paste.
#~Activate a Tweak by removing the leading '#'
#~Deactivate a Tweak by adding a leading '#'
#~--------------------------------------------------------------------------
#~String Manipulation builtin functions may require an "escaped" comma
#~in the values to differentiate them from the commas separating each argument.
#~Example:    Wrong:  re(val, '^.+$', 'x,y,z')     Correct:  re(val, '^.+$', 'x\,y\,z')
#~--------------------------------------------------------------------------
#~--------------------------------------------------------------------------
"""