# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.27" #qt.core

from calibre.customize import InterfaceActionBase

class ActionBaseMediaFileImporter(InterfaceActionBase):

    name                    = 'Media File Importer'
    description           = "Drag media file paths and Drop them to automatically create new books within Calibre having dynamically created metadata, plus a copy of the original media file placed into the same directory as the new book.  For use in a Workbench/Intake Library only."
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 0, 27)
    minimum_calibre_version = (6, 0, 0)  # originally 2.63

    actual_plugin       = 'calibre_plugins.media_file_importer.ui:ActionMediaFileImporter'

    gui_name = 'Media File Importer'

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):
        pass
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return False
    #--------------------------------------------------------------------------------------------------------------------------
#END of __init__py