# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.27" #qt.core

from qt.core import Qt, QMenu, QDialog, QIcon, QAction

from calibre.constants import DEBUG
from calibre.gui2.actions import InterfaceAction
from calibre.ptempfile import PersistentTemporaryDirectory
from calibre.utils.config import JSONConfig

from polyglot.builtins import iteritems, range

from calibre_plugins.media_file_importer.common_utils import set_plugin_icon_resources, get_icon
from calibre_plugins.media_file_importer.mfi_dialog import MediaFileImporterDialog
from calibre_plugins.media_file_importer.config import prefs

import os

PLUGIN_ICONS = ['images/mfi.png']

#-------------------------------------------------------------------------------------------
class ActionMediaFileImporter(InterfaceAction):

    name = 'Media File Importer'
    action_spec = ('MFI','images/drop.png', "Drag media file paths and Drop them to automatically create new books within Calibre having dynamically created metadata, plus a copy of the original media file placed into the same directory as the new book.", None)
    action_type = 'global'
    accepts_drops = False
    auto_repeat = False
    priority = 9
    popup_type = 1

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def genesis(self):
        icon_resources = self.load_resources(PLUGIN_ICONS)
        set_plugin_icon_resources(self.name, icon_resources )
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.qaction.triggered.connect(self.drag_and_drop_control)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def initialization_complete(self):
        from calibre.gui2.ui import get_gui
        self.maingui = get_gui()
        self.guidb = self.maingui.library_view.model().db

        for k,v in iteritems(prefs.defaults):
            if not k in prefs:
                prefs[k] = v
        #END FOR

        self.mfi_tempdir = PersistentTemporaryDirectory(suffix='_mfi_', prefix='', dir=None)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def library_changed(self,guidb):
        self.guidb = self.maingui.library_view.model().db
        try:
            self.mediafileimporterdialog.close()
        except:
            pass
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def shutting_down(self):
        return True
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def drag_and_drop_control(self):
        try:
            self.mediafileimporterdialog.close()
        except:
            pass

        self.maingui.library_view.model().stop_metadata_backup()     # will be re-started as dialog exits...

        self.guidb = self.maingui.library_view.model().db
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.mediafileimporterdialog = MediaFileImporterDialog(self.maingui,self.guidb,self.qaction.icon(),self.mfi_tempdir)
        self.mediafileimporterdialog.setAttribute(Qt.WA_DeleteOnClose )
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#END of ui.py