# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.27" #qt.core

from qt.core import (Qt, QDialog, QFont, QIcon, QGridLayout, QGroupBox, QLabel, QMargins, QVBoxLayout, QWidget)

from calibre.utils.config import JSONConfig

from polyglot.builtins import unicode_type

#~ S_FALSE = "False"
S_TRUE = "True"

# This is where all preferences for this plugin are stored
prefs = JSONConfig('plugins/Media File Importer')

# Set defaults
prefs.defaults['MODE'] = "image"
prefs.defaults['TITLE'] = "{file_name}"
prefs.defaults['AUTHORS'] = "{directory_name:1}"
prefs.defaults['SERIES'] = "{directory_name:0}"
prefs.defaults['PUBLISHER'] = "me"
prefs.defaults['TAGS'] = "{file_extension}"
prefs.defaults['IDENTIFIER'] = ""
prefs.defaults['COMMENTS'] = ""
prefs.defaults['COVER_PATH'] = "{path}"
prefs.defaults['CUSTOM_COLUMN_1'] = ""
prefs.defaults['CUSTOM_COLUMN_2'] = ""
prefs.defaults['CUSTOM_COLUMN_3'] = ""
prefs.defaults['CUSTOM_COLUMN_4'] = ""
prefs.defaults['CUSTOM_COLUMN_1_VALUE'] = ""
prefs.defaults['CUSTOM_COLUMN_2_VALUE'] = ""
prefs.defaults['CUSTOM_COLUMN_3_VALUE'] = ""
prefs.defaults['CUSTOM_COLUMN_4_VALUE'] = ""
prefs.defaults['COPY_ORIGINAL_FILE_TOO'] = S_TRUE
prefs.defaults['KEEP_ORIGINAL_PATH_IDENTIFIER'] = S_TRUE
prefs.defaults['COPY_SAME_BASE_FILENAMES_TO_SAME_CALIBRE_DIRECTORY'] = S_TRUE
prefs.defaults['FILE_EXTENSION_PRIORITY_SEQUENCE'] = "Image=.jpg;Image=.png;Audio=.mp3;Audio=.acc;Video=.mkv;Video=.mp4;Video=.avi;Binary=.pcs;Binary=.hus"

class ConfigWidget(QWidget):

    def __init__(self):

        QWidget.__init__(self)

        self.layout_1 = QVBoxLayout()
        self.setLayout(self.layout_1)

        self.layout_1.setSpacing(0)
        self.layout_1.setContentsMargins(QMargins(0,0,0,0));

        self.paths_groupbox = QGroupBox('Preferences')
        self.layout_1.addWidget(self.paths_groupbox)

        self.paths_layout = QGridLayout()
        self.paths_groupbox.setLayout(self.paths_layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(10)

        self.label1 = QLabel()
        self.label1.setTextFormat(1)
        self.label1.setText("<center><font color='#0404B4'>               Please Customize Directly Within MFI           </font></center>")
        self.label1.setFont(font)
        self.paths_layout.addWidget(self.label1)

        self.resize(self.sizeHint())

    def save_settings(self):
        return
    def validate(self):
        return False
#END of config.py

