#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

from __future__ import (unicode_literals, division, absolute_import, print_function)


__license__ = 'GPL v3'
__copyright__ = '2012-2022, John Howell <jhowell@acm.org>'


# OverDrive sites using the new (2016) website design as of 10/20/16

known_new_overdrive_sites = {
    "buckscounty.overdrive.com",    # working synonym for buckslib.overdrive.com

    "1stsfgroup.overdrive.com",
    "aarplibrary.overdrive.com",
    "aberdeenshirelibraries.overdrive.com",
    "abilene.overdrive.com",
    "acla.overdrive.com",
    "acld.overdrive.com",
    "aclib.overdrive.com",
    "aclibrary.overdrive.com",
    "acpl.overdrive.com",
    "act.overdrive.com",
    "adl.overdrive.com",
    "adlc.overdrive.com",
    "afmlibrary.overdrive.com",
    "afpls.overdrive.com",
    "ajax.overdrive.com",
    "ak-chin.overdrive.com",
    "ak.overdrive.com",
    "akronlibrary.overdrive.com",
    "alamancelibraries.overdrive.com",
    "ald.overdrive.com",
    "alexandria.overdrive.com",
    "alliance.overdrive.com",
    "alliedreit.overdrive.com",
    "alpenacc.overdrive.com",
    "altamonte.overdrive.com",
    "amc.overdrive.com",
    "amda.overdrive.com",
    "americanlibraryinparis.overdrive.com",
    "anan.overdrive.com",
    "andersonlibrary.overdrive.com",
    "anythinklibraries.overdrive.com",
    "anytime.overdrive.com",
    "apex.overdrive.com",
    "arapahoe.overdrive.com",
    "argyllandbute.overdrive.com",
    "arl.overdrive.com",
    "arlington.overdrive.com",
    "arlingtontx.overdrive.com",
    "army.overdrive.com",
    "arrowhead.overdrive.com",
    "asfmrc.overdrive.com",
    "asiclibrary.overdrive.com",
    "asub.overdrive.com",
    "atlantahumane.overdrive.com",
    "atwaterlibrary.overdrive.com",
    "auckland.overdrive.com",
    "aurora.overdrive.com",
    "aurorapubliclibrary.overdrive.com",
    "austinlibrary.overdrive.com",
    "auth0.overdrive.com",
    "avalonfreelibrary.overdrive.com",
    "avon.overdrive.com",
    "awabank.overdrive.com",
    "ayase.overdrive.com",
    "b4church.overdrive.com",
    "badico.overdrive.com",
    "balibrary.overdrive.com",
    "banq.overdrive.com",
    "banrepcultural.overdrive.com",
    "barnet.overdrive.com",
    "barnsley.overdrive.com",
    "barth.overdrive.com",
    "bartowlibrary.overdrive.com",
    "baycountylibrary.overdrive.com",
    "bayouland.overdrive.com",
    "baypath.overdrive.com",
    "baysidelibrary.overdrive.com",
    "bbna.overdrive.com",
    "bc.overdrive.com",
    "bci.overdrive.com",
    "bcpl.overdrive.com",
    "bcsdmc.overdrive.com",
    "beaverlibraries.overdrive.com",
    "belbib.overdrive.com",
    "bellevuelibrary.overdrive.com",
    "bentleydownload.overdrive.com",
    "berkeleypubliclibrary.overdrive.com",
    "bexley.overdrive.com",
    "bgst.overdrive.com",
    "bhpl.overdrive.com",
    "bibliomation.overdrive.com",
    "bibliomontreal.overdrive.com",
    "bibliotecafundadores.overdrive.com",
    "bibliotecauao.overdrive.com",
    "bibliothequesdesherbrooke.overdrive.com",
    "bibliovalle.overdrive.com",
    "bibnetz.overdrive.com",
    "bibstlaz.overdrive.com",
    "biddlelaw.overdrive.com",
    "bigcountry.overdrive.com",
    "bilkent.overdrive.com",
    "birmingham-uk.overdrive.com",
    "bismarckstate.overdrive.com",
    "blackfoot.overdrive.com",
    "blackgold.overdrive.com",
    "blackhills.overdrive.com",
    "blackpool.overdrive.com",
    "blacktown.overdrive.com",
    "bld.overdrive.com",
    "bloomberg.overdrive.com",
    "bluebookshelf.overdrive.com",
    "bluehill.overdrive.com",
    "bnl.overdrive.com",
    "bnllux.overdrive.com",
    "bocalibrary.overdrive.com",
    "boise.overdrive.com",
    "boisestate.overdrive.com",
    "boroondara.overdrive.com",
    "bpl.overdrive.com",
    "bpls.overdrive.com",
    "bportlibrary.overdrive.com",
    "brant.overdrive.com",
    "brantford.overdrive.com",
    "brdc.overdrive.com",
    "bremen.overdrive.com",
    "brevard.overdrive.com",
    "bridges.overdrive.com",
    "brimbanklibraries.overdrive.com",
    "brisbane.overdrive.com",
    "bristollibraries.overdrive.com",
    "brooklyn.overdrive.com",
    "broward.overdrive.com",
    "brownsburg.overdrive.com",
    "brrl.overdrive.com",
    "buckinghamshire.overdrive.com",
    "buckslib.overdrive.com",
    "buenapark.overdrive.com",
    "buffalo.overdrive.com",
    "burbank.overdrive.com",
    "burlington.overdrive.com",
    "burlingtonpl.overdrive.com",
    "burnaby.overdrive.com",
    "byu.overdrive.com",
    "cabq.overdrive.com",
    "cachecounty.overdrive.com",
    "cairnmillar.overdrive.com",
    "cairnuniversity.overdrive.com",
    "calgary.overdrive.com",
    "cals.overdrive.com",
    "camdenlibrary.overdrive.com",
    "camdigital.overdrive.com",
    "camellia.overdrive.com",
    "campbelltown.overdrive.com",
    "candid.overdrive.com",
    "capitalarealibrary.overdrive.com",
    "ccc.overdrive.com",
    "ccfls.overdrive.com",
    "ccld.overdrive.com",
    "ccls.overdrive.com",
    "cclsys.overdrive.com",
    "ccpl.overdrive.com",
    "ccpls.overdrive.com",
    "ccri.overdrive.com",
    "cdwlearninglabelibrary.overdrive.com",
    "ced.overdrive.com",
    "cefls.overdrive.com",
    "centralagencies.overdrive.com",
    "centralcoast.overdrive.com",
    "centralpalibraries.overdrive.com",
    "cfbc.overdrive.com",
    "cfc.overdrive.com",
    "cfwpl.overdrive.com",
    "cgg.overdrive.com",
    "charlestoncounty.overdrive.com",
    "chatham.overdrive.com",
    "chcbl.overdrive.com",
    "chelsea.overdrive.com",
    "chesapeake.overdrive.com",
    "chester.overdrive.com",
    "chesterfield.overdrive.com",
    "childrens.overdrive.com",
    "chinookarch.overdrive.com",
    "chipublib.overdrive.com",
    "chl.overdrive.com",
    "christchurch.overdrive.com",
    "christianrecord.overdrive.com",
    "cidc.overdrive.com",
    "cin.overdrive.com",
    "cincinnatilibrary.overdrive.com",
    "citrus.overdrive.com",
    "cityofdarwin.overdrive.com",
    "ciu.overdrive.com",
    "clamsnet.overdrive.com",
    "clarendoncountylibrary.overdrive.com",
    "clarkco.overdrive.com",
    "claytonnc.overdrive.com",
    "clc.overdrive.com",
    "cldl.overdrive.com",
    "clevelandfbc.overdrive.com",
    "clevnet.overdrive.com",
    "cloviscollegeca.overdrive.com",
    "cmilibrary.overdrive.com",
    "cna.overdrive.com",
    "cne-siar.overdrive.com",
    "coa.overdrive.com",
    "cobbcounty.overdrive.com",
    "cocolib.overdrive.com",
    "cod.overdrive.com",
    "cogswell.overdrive.com",
    "cojlibrary.overdrive.com",
    "colbertdigitaldownloads.overdrive.com",
    "colecciondigital.overdrive.com",
    "collier.overdrive.com",
    "coloradodc.overdrive.com",
    "com.overdrive.com",
    "comfama.overdrive.com",
    "commerceresearchlibrary.overdrive.com",
    "connors.overdrive.com",
    "cookmemorial.overdrive.com",
    "cornell.overdrive.com",
    "cpcregional.overdrive.com",
    "cpls.overdrive.com",
    "cppib.overdrive.com",
    "craibiblioteca.overdrive.com",
    "crownpoint.overdrive.com",
    "crsbpl.overdrive.com",
    "cru.overdrive.com",
    "ctdl.overdrive.com",
    "cuhksz.overdrive.com",
    "cumberland.overdrive.com",
    "cvl.overdrive.com",
    "cwcl.overdrive.com",
    "cwmars.overdrive.com",
    "dakotastate.overdrive.com",
    "dallaslibrary.overdrive.com",
    "danburylibrary.overdrive.com",
    "darien.overdrive.com",
    "davidsonccc.overdrive.com",
    "daviscounty.overdrive.com",
    "dayton.overdrive.com",
    "dbrl.overdrive.com",
    "dcbottineau.overdrive.com",
    "dcl.overdrive.com",
    "dcla.overdrive.com",
    "dclibrary.overdrive.com",
    "dcu.overdrive.com",
    "defender.overdrive.com",
    "deichman.overdrive.com",
    "dekalb.overdrive.com",
    "delaware.overdrive.com",
    "delco.overdrive.com",
    "dementia-e-library.overdrive.com",
    "denver.overdrive.com",
    "denverseminary.overdrive.com",
    "detroitpubliclibrary.overdrive.com",
    "digibel.overdrive.com",
    "digitalvanguardlibrary.overdrive.com",
    "disneytech.overdrive.com",
    "dliflc.overdrive.com",
    "dlil.overdrive.com",
    "dlrcoco.overdrive.com",
    "dls.overdrive.com",
    "dmpl.overdrive.com",
    "dmz.overdrive.com",
    "donnellycollegelibrary.overdrive.com",
    "dorchesterlibrarysc.overdrive.com",
    "dorval.overdrive.com",
    "douglasbcuk.overdrive.com",
    "downbeach.overdrive.com",
    "downloadlibrary.overdrive.com",
    "dpls.overdrive.com",
    "drcldc.overdrive.com",
    "du.overdrive.com",
    "dubuque.overdrive.com",
    "duke-energy.overdrive.com",
    "duke.overdrive.com",
    "dundeecity.overdrive.com",
    "durango.overdrive.com",
    "durhamcounty.overdrive.com",
    "dutchbros.overdrive.com",
    "dwci.overdrive.com",
    "e-inc.overdrive.com",
    "e-stockton.overdrive.com",
    "e-thek.overdrive.com",
    "eafit.overdrive.com",
    "easterncape.overdrive.com",
    "eastonpl.overdrive.com",
    "eastsussexlibrary.overdrive.com",
    "eausleihe-hannover.overdrive.com",
    "ebccls.overdrive.com",
    "ebonnerlibrary.overdrive.com",
    "ebooksforyou.overdrive.com",
    "ebookssjclibrary.overdrive.com",
    "ebooksusa.overdrive.com",
    "ebr.overdrive.com",
    "ebranch2go.overdrive.com",
    "ecat.overdrive.com",
    "ecoop.overdrive.com",
    "ecpl.overdrive.com",
    "ecrl.overdrive.com",
    "edinburgh.overdrive.com",
    "edownload.overdrive.com",
    "egfmn.overdrive.com",
    "elibrary.overdrive.com",
    "elibrary247.overdrive.com",
    "elibrarybw.overdrive.com",
    "elibraryhh.overdrive.com",
    "elibrarynj.overdrive.com",
    "elin.overdrive.com",
    "elm.overdrive.com",
    "elnb-bnnb.overdrive.com",
    "elpaso.overdrive.com",
    "emagnolia.overdrive.com",
    "emcfl.overdrive.com",
    "emedia.overdrive.com",
    "emedialibrary.overdrive.com",
    "emoney.overdrive.com",
    "emory.overdrive.com",
    "eodls.overdrive.com",
    "epannapolis.overdrive.com",
    "epl.overdrive.com",
    "epukapuka.overdrive.com",
    "equityresourcelibrary.overdrive.com",
    "ereolenglobal.overdrive.com",
    "erielibrary.overdrive.com",
    "erl.overdrive.com",
    "essexca.overdrive.com",
    "eunc.overdrive.com",
    "everett.overdrive.com",
    "evpl.overdrive.com",
    "fahe.overdrive.com",
    "fairfax.overdrive.com",
    "fairfield.overdrive.com",
    "falklandcommunitylibrary.overdrive.com",
    "fandm.overdrive.com",
    "fbcmedialibrary.overdrive.com",
    "fclspa.overdrive.com",
    "fdot.overdrive.com",
    "first.overdrive.com",
    "firstcrc.overdrive.com",
    "flatiron.overdrive.com",
    "flint.overdrive.com",
    "flls.overdrive.com",
    "flux7.overdrive.com",
    "flyfrontier.overdrive.com",
    "fmb.overdrive.com",
    "forestcity.overdrive.com",
    "forsyth.overdrive.com",
    "fortbend.overdrive.com",
    "fortvancouver.overdrive.com",
    "fourcounty.overdrive.com",
    "franklinpierce.overdrive.com",
    "freelibrary.overdrive.com",
    "fremont.overdrive.com",
    "fresno.overdrive.com",
    "friendmemorial.overdrive.com",
    "frisco.overdrive.com",
    "frontrange.overdrive.com",
    "fselibrary.overdrive.com",
    "fuelyourmind.overdrive.com",
    "fullerton.overdrive.com",
    "fundacionepm.overdrive.com",
    "fvrl.overdrive.com",
    "fwpl.overdrive.com",
    "garlandcounty.overdrive.com",
    "gatech.overdrive.com",
    "gauteng.overdrive.com",
    "gcldaz.overdrive.com",
    "geelong.overdrive.com",
    "geh-online.overdrive.com",
    "georgesriver.overdrive.com",
    "georgetowncollege.overdrive.com",
    "georgiahighlands.overdrive.com",
    "georgiasouthern.overdrive.com",
    "gia.overdrive.com",
    "glasgow.overdrive.com",
    "gldl.overdrive.com",
    "glllibraries.overdrive.com",
    "gmlc.overdrive.com",
    "gotlib.overdrive.com",
    "gplebooks.overdrive.com",
    "gptx.overdrive.com",
    "greaterdandenong.overdrive.com",
    "greatnecklibrary.overdrive.com",
    "greengoldlibraries.overdrive.com",
    "greenvillesc.overdrive.com",
    "greenwich.overdrive.com",
    "greenwoodsc.overdrive.com",
    "griver.overdrive.com",
    "grpl.overdrive.com",
    "guernsey.overdrive.com",
    "guidestone.overdrive.com",
    "gwinnett.overdrive.com",
    "gympie.overdrive.com",
    "habersham.overdrive.com",
    "hadc.overdrive.com",
    "halifax.overdrive.com",
    "hamiltondigitallibrary.overdrive.com",
    "hamiltondiocesebfl.overdrive.com",
    "hancock.overdrive.com",
    "hardinglibrary.overdrive.com",
    "haringey.overdrive.com",
    "hawaii.overdrive.com",
    "hawkesbury.overdrive.com",
    "hclib.overdrive.com",
    "hclibrary.overdrive.com",
    "hcpl.overdrive.com",
    "hcplc.overdrive.com",
    "hcplibrary.overdrive.com",
    "hct.overdrive.com",
    "hecsa.overdrive.com",
    "helmet.overdrive.com",
    "hempcolib.overdrive.com",
    "hendersonlibraries.overdrive.com",
    "henrico.overdrive.com",
    "hepl.overdrive.com",
    "highlandparktexas.overdrive.com",
    "highplains.overdrive.com",
    "hindscc.overdrive.com",
    "hkpl.overdrive.com",
    "holmeslibrary.overdrive.com",
    "hoodcounty.overdrive.com",
    "hornsby.overdrive.com",
    "hpl.overdrive.com",
    "hpulibraries.overdrive.com",
    "hslda.overdrive.com",
    "hst.overdrive.com",
    "huie.overdrive.com",
    "huntingdon.overdrive.com",
    "huntington.overdrive.com",
    "huntingtonuniversity.overdrive.com",
    "icculibrary.overdrive.com",
    "icpcolombia.overdrive.com",
    "icpl.overdrive.com",
    "id8.overdrive.com",
    "idahodigital.overdrive.com",
    "iddc.overdrive.com",
    "idfbins.overdrive.com",
    "idm.overdrive.com",
    "iedigital.overdrive.com",
    "ifpl.overdrive.com",
    "indianbible.overdrive.com",
    "indietexas.overdrive.com",
    "indypl.overdrive.com",
    "infoway.overdrive.com",
    "investorsbanklibrary.overdrive.com",
    "iohumc.overdrive.com",
    "irclibrary.overdrive.com",
    "iredell.overdrive.com",
    "isb.overdrive.com",
    "itako-public.overdrive.com",
    "itrs.overdrive.com",
    "iw.overdrive.com",
    "iyte.overdrive.com",
    "jasmine.overdrive.com",
    "jc.overdrive.com",
    "jcjc.overdrive.com",
    "jclc.overdrive.com",
    "jclibrary.overdrive.com",
    "jdcpl.overdrive.com",
    "jeff.overdrive.com",
    "jefferson.overdrive.com",
    "jefflibrary.overdrive.com",
    "jericholibrary.overdrive.com",
    "jerseylibrary.overdrive.com",
    "jessiehallett.overdrive.com",
    "jhlibrary.overdrive.com",
    "jpl.overdrive.com",
    "jplmontreal.overdrive.com",
    "kaia.overdrive.com",
    "kaipo.overdrive.com",
    "kcc.overdrive.com",
    "kclibrary.overdrive.com",
    "kcls.overdrive.com",
    "kcpl.overdrive.com",
    "kdicl.overdrive.com",
    "kennebunklibrary.overdrive.com",
    "kent.overdrive.com",
    "kenton.overdrive.com",
    "kern.overdrive.com",
    "keskraamatukogu.overdrive.com",
    "keyassets.overdrive.com",
    "keyslibraries.overdrive.com",
    "kfpl.overdrive.com",
    "kic-innoenergy.overdrive.com",
    "kings.overdrive.com",
    "kirkland.overdrive.com",
    "kirklees.overdrive.com",
    "kirtland.overdrive.com",
    "kleberglibrary.overdrive.com",
    "kmbs.overdrive.com",
    "knoxcounty.overdrive.com",
    "kobe.overdrive.com",
    "koeln.overdrive.com",
    "krl.overdrive.com",
    "kumagayacity.overdrive.com",
    "kuna.overdrive.com",
    "kurthmemorial.overdrive.com",
    "kwbc.overdrive.com",
    "kyunbound.overdrive.com",
    "kznpls.overdrive.com",
    "lacnm.overdrive.com",
    "lacoe.overdrive.com",
    "lacountylibrary.overdrive.com",
    "lakeareatech.overdrive.com",
    "lakecounty.overdrive.com",
    "lakeland.overdrive.com",
    "lakesidebc.overdrive.com",
    "lamarcounty.overdrive.com",
    "lamb.overdrive.com",
    "lancasterlibraries.overdrive.com",
    "lansdalelibrary.overdrive.com",
    "lapl.overdrive.com",
    "laportelibrary.overdrive.com",
    "larl.overdrive.com",
    "lasalle.overdrive.com",
    "lassencollege.overdrive.com",
    "lasvegas.overdrive.com",
    "laurellibrary.overdrive.com",
    "lawrencepl.overdrive.com",
    "lbpl.overdrive.com",
    "lbrut.overdrive.com",
    "lccpl.overdrive.com",
    "lclibs.overdrive.com",
    "lcls.overdrive.com",
    "lclshome.overdrive.com",
    "lcpl.overdrive.com",
    "leeward.overdrive.com",
    "leicesteruk.overdrive.com",
    "leoncounty.overdrive.com",
    "levine-sklutjudaiclibrary.overdrive.com",
    "lewisham.overdrive.com",
    "lex.overdrive.com",
    "lexpublib.overdrive.com",
    "lfpl.overdrive.com",
    "lib2go.overdrive.com",
    "librariesniuk.overdrive.com",
    "librariestasmania.overdrive.com",
    "librariesunlimited.overdrive.com",
    "library2go.overdrive.com",
    "libraryconnection.overdrive.com",
    "librarypoint.overdrive.com",
    "libraryweb.overdrive.com",
    "libriid.overdrive.com",
    "lift.overdrive.com",
    "lincoln.overdrive.com",
    "lincolnshirelibraries.overdrive.com",
    "lion.overdrive.com",
    "listeneasternwv.overdrive.com",
    "listening-books.overdrive.com",
    "livebrary.overdrive.com",
    "livermore.overdrive.com",
    "liverpool.overdrive.com",
    "llc.overdrive.com",
    "lltc.overdrive.com",
    "logan.overdrive.com",
    "lonestardigitalibrary.overdrive.com",
    "longwood.overdrive.com",
    "lpclibrary.overdrive.com",
    "lpl.overdrive.com",
    "lplelibrary.overdrive.com",
    "lruffin-smith.overdrive.com",
    "lsw.overdrive.com",
    "lubbock.overdrive.com",
    "lumlibrary.overdrive.com",
    "luxottica.overdrive.com",
    "macu.overdrive.com",
    "maderalibrary.overdrive.com",
    "mainehealthlrc.overdrive.com",
    "maltalibraries.overdrive.com",
    "manno.overdrive.com",
    "maribyrnong.overdrive.com",
    "marinesociety.overdrive.com",
    "marinet.overdrive.com",
    "markham.overdrive.com",
    "marmot.overdrive.com",
    "marshallcenter.overdrive.com",
    "martinluther.overdrive.com",
    "maryland.overdrive.com",
    "mastercontrol.overdrive.com",
    "mayvillestate.overdrive.com",
    "mbts.overdrive.com",
    "mcallen.overdrive.com",
    "mcdermott.overdrive.com",
    "mcgill.overdrive.com",
    "mcpl.overdrive.com",
    "mcu.overdrive.com",
    "mdc.overdrive.com",
    "mdpls.overdrive.com",
    "mdtlibrary.overdrive.com",
    "mediaondemand.overdrive.com",
    "medway.overdrive.com",
    "melbourneathenaeum.overdrive.com",
    "memphis.overdrive.com",
    "mercantile.overdrive.com",
    "mercedcountylibrary.overdrive.com",
    "mercerebooks.overdrive.com",
    "meridian.overdrive.com",
    "meridianlauderdale.overdrive.com",
    "metrolibrary.overdrive.com",
    "metronet.overdrive.com",
    "mfo.overdrive.com",
    "mgccc.overdrive.com",
    "mhls.overdrive.com",
    "mi.overdrive.com",
    "michbar.overdrive.com",
    "midcolumbialibraries.overdrive.com",
    "middlebury.overdrive.com",
    "middleburypubliclibrary.overdrive.com",
    "midnorthcoast.overdrive.com",
    "midyork.overdrive.com",
    "minuteman.overdrive.com",
    "miracosta.overdrive.com",
    "mississauga.overdrive.com",
    "mlc.overdrive.com",
    "mlcstl.overdrive.com",
    "mln.overdrive.com",
    "mlpebooks.overdrive.com",
    "mmlc.overdrive.com",
    "mmpl.overdrive.com",
    "mnstate.overdrive.com",
    "mobius.overdrive.com",
    "mohave.overdrive.com",
    "molib2go.overdrive.com",
    "monmouth.overdrive.com",
    "montana.overdrive.com",
    "montanastatelibrary.overdrive.com",
    "montcolibs.overdrive.com",
    "montvillelibrary.overdrive.com",
    "mooneevalley.overdrive.com",
    "moretonbay.overdrive.com",
    "morgancitylibrary.overdrive.com",
    "morrin.overdrive.com",
    "mpkdigital.overdrive.com",
    "mrcc.overdrive.com",
    "mrl.overdrive.com",
    "mrspl.overdrive.com",
    "msa.overdrive.com",
    "msgsu.overdrive.com",
    "msl.overdrive.com",
    "multcolib.overdrive.com",
    "murraylibrary.overdrive.com",
    "musselmanlibrary.overdrive.com",
    "mvlc.overdrive.com",
    "mvls.overdrive.com",
    "myapl.overdrive.com",
    "myepl.overdrive.com",
    "myforeverfamily.overdrive.com",
    "mygd.overdrive.com",
    "myjdl.overdrive.com",
    "mylakelibrary.overdrive.com",
    "mylibrarynow.overdrive.com",
    "mymanatee.overdrive.com",
    "myrl.overdrive.com",
    "nacc.overdrive.com",
    "nachikatsuuratown.overdrive.com",
    "nafcpl.overdrive.com",
    "naperville.overdrive.com",
    "nashcc.overdrive.com",
    "nashville.overdrive.com",
    "nassau.overdrive.com",
    "ncbi.overdrive.com",
    "ncc.overdrive.com",
    "ncdigital.overdrive.com",
    "ncdl.overdrive.com",
    "nckids.overdrive.com",
    "ncrl.overdrive.com",
    "ndlibrary2go.overdrive.com",
    "ndscs.overdrive.com",
    "ndsu.overdrive.com",
    "nebraska.overdrive.com",
    "neflin.overdrive.com",
    "neo.overdrive.com",
    "netldc.overdrive.com",
    "newcanaanlibrary.overdrive.com",
    "neworleans.overdrive.com",
    "newrelic.overdrive.com",
    "ngrls.overdrive.com",
    "nh.overdrive.com",
    "nhfpl.overdrive.com",
    "nic.overdrive.com",
    "nicc.overdrive.com",
    "nidl.overdrive.com",
    "nihlibrary.overdrive.com",
    "nilrc.overdrive.com",
    "nioga.overdrive.com",
    "nlb.overdrive.com",
    "nm.overdrive.com",
    "nmbm.overdrive.com",
    "nmls.overdrive.com",
    "nmotclibrary.overdrive.com",
    "nnpls.overdrive.com",
    "nnyoverdrive.overdrive.com",
    "noble.overdrive.com",
    "nobts.overdrive.com",
    "nordleihe.overdrive.com",
    "norfolk-va.overdrive.com",
    "norfolk.overdrive.com",
    "northcountrylibraries.overdrive.com",
    "northeaststate.overdrive.com",
    "northernbeacheslibraries.overdrive.com",
    "northmankato.overdrive.com",
    "northnet.overdrive.com",
    "northyorks.overdrive.com",
    "norwalk.overdrive.com",
    "novascotia.overdrive.com",
    "novel.overdrive.com",
    "npl.overdrive.com",
    "nsdc.overdrive.com",
    "nswdg.overdrive.com",
    "ntrls.overdrive.com",
    "ntu.overdrive.com",
    "nu.overdrive.com",
    "nulibrary.overdrive.com",
    "nuqlibrary.overdrive.com",
    "nvclibrary.overdrive.com",
    "nwrl.overdrive.com",
    "nwrlib.overdrive.com",
    "nwrls.overdrive.com",
    "nyp.overdrive.com",
    "nypa.overdrive.com",
    "nypl.overdrive.com",
    "oakland.overdrive.com",
    "oberlinpl.overdrive.com",
    "occc.overdrive.com",
    "oceancity.overdrive.com",
    "ocl.overdrive.com",
    "ocln.overdrive.com",
    "ocls.overdrive.com",
    "ocnc.overdrive.com",
    "oconee.overdrive.com",
    "ocpl.overdrive.com",
    "odl.overdrive.com",
    "odmc.overdrive.com",
    "ohdbks.overdrive.com",
    "oilcreek.overdrive.com",
    "oitapref-e-book.overdrive.com",
    "okaloosa.overdrive.com",
    "okvirtuallibrary.overdrive.com",
    "oldwestburylibrary.overdrive.com",
    "olivebaptist.overdrive.com",
    "omaha.overdrive.com",
    "omnilibraries.overdrive.com",
    "onlib.overdrive.com",
    "orkney.overdrive.com",
    "orl.overdrive.com",
    "orlandparklibrary.overdrive.com",
    "orparc.overdrive.com",
    "orpl.overdrive.com",
    "osakacity.overdrive.com",
    "otpls.overdrive.com",
    "ottawa.overdrive.com",
    "owen.overdrive.com",
    "owwl.overdrive.com",
    "oxfordshire.overdrive.com",
    "ozyegin.overdrive.com",
    "paclibrary.overdrive.com",
    "palestine.overdrive.com",
    "palmbeach.overdrive.com",
    "palmetto.overdrive.com",
    "palmspringslibrary.overdrive.com",
    "palsplus.overdrive.com",
    "pas-gdl.overdrive.com",
    "pclc.overdrive.com",
    "peipls.overdrive.com",
    "penang.overdrive.com",
    "pentagonlib.overdrive.com",
    "pettes.overdrive.com",
    "pgcmls.overdrive.com",
    "phoenix.overdrive.com",
    "pickens.overdrive.com",
    "piercecounty.overdrive.com",
    "piki.overdrive.com",
    "pima.overdrive.com",
    "pinnacle.overdrive.com",
    "pioneerland.overdrive.com",
    "pioneerok.overdrive.com",
    "pjl.overdrive.com",
    "planning.overdrive.com",
    "plano.overdrive.com",
    "plcmc.overdrive.com",
    "pls.overdrive.com",
    "plumcreeklibrary.overdrive.com",
    "plymouthuk.overdrive.com",
    "pmi.overdrive.com",
    "pnm.overdrive.com",
    "poetrylibrary.overdrive.com",
    "pokagon.overdrive.com",
    "portagelibrary.overdrive.com",
    "portphillip.overdrive.com",
    "poudre.overdrive.com",
    "ppas.overdrive.com",
    "pplc.overdrive.com",
    "ppld.overdrive.com",
    "prairiestate.overdrive.com",
    "princeton.overdrive.com",
    "princetonlibrary.overdrive.com",
    "princewilliam.overdrive.com",
    "prl.overdrive.com",
    "pwdl.overdrive.com",
    "qroc.overdrive.com",
    "queenslibrary.overdrive.com",
    "qut.overdrive.com",
    "rabun.overdrive.com",
    "rafbokasafnid.overdrive.com",
    "randolph.overdrive.com",
    "randwick.overdrive.com",
    "rapid7.overdrive.com",
    "rcc.overdrive.com",
    "rccc.overdrive.com",
    "rcls.overdrive.com",
    "rdpl.overdrive.com",
    "reading.overdrive.com",
    "reads.overdrive.com",
    "realtor.overdrive.com",
    "reddecolombos.overdrive.com",
    "renfrewshire.overdrive.com",
    "rhodes.overdrive.com",
    "rhpl.overdrive.com",
    "richardson.overdrive.com",
    "richmondlibrary.overdrive.com",
    "richmondpubliclibrary.overdrive.com",
    "riezone.overdrive.com",
    "riopl.overdrive.com",
    "riti.overdrive.com",
    "rivershare.overdrive.com",
    "rivershareacademic.overdrive.com",
    "rml.overdrive.com",
    "roberts.overdrive.com",
    "robleyrex.overdrive.com",
    "rochester.overdrive.com",
    "rolfing.overdrive.com",
    "roswellnm.overdrive.com",
    "roundrock.overdrive.com",
    "rpl.overdrive.com",
    "rpls.overdrive.com",
    "rscc.overdrive.com",
    "rsulibraries.overdrive.com",
    "rvl.overdrive.com",
    "ryde.overdrive.com",
    "ryutosho.overdrive.com",
    "saba.overdrive.com",
    "saclibrary.overdrive.com",
    "saginawlibrary.overdrive.com",
    "sails.overdrive.com",
    "salb.overdrive.com",
    "salinaspubliclibrary.overdrive.com",
    "salon.overdrive.com",
    "salvationarmyflorida.overdrive.com",
    "samsung.overdrive.com",
    "sanantonio.overdrive.com",
    "sandburg.overdrive.com",
    "sandiegochristian.overdrive.com",
    "sandoval.overdrive.com",
    "sanfe.overdrive.com",
    "sanibel.overdrive.com",
    "sanjose.overdrive.com",
    "sanleandrolibrary.overdrive.com",
    "santaanapubliclibrary.overdrive.com",
    "santaclara.overdrive.com",
    "santaclarita.overdrive.com",
    "santamonica.overdrive.com",
    "sapl.overdrive.com",
    "sapln.overdrive.com",
    "saskatchewan.overdrive.com",
    "sbcldigital.overdrive.com",
    "sbpl.overdrive.com",
    "scdl.overdrive.com",
    "scl.overdrive.com",
    "scld.overdrive.com",
    "sclibrary.overdrive.com",
    "scw.overdrive.com",
    "sdcl.overdrive.com",
    "sdg.overdrive.com",
    "searchdiscovery.overdrive.com",
    "sefl-municipal.overdrive.com",
    "sekicity.overdrive.com",
    "selco.overdrive.com",
    "semcofl.overdrive.com",
    "senecalibraries.overdrive.com",
    "seoullib.overdrive.com",
    "sequoyah.overdrive.com",
    "serra.overdrive.com",
    "sewanee.overdrive.com",
    "sfpl.overdrive.com",
    "shortgrass.overdrive.com",
    "showcaseworks.overdrive.com",
    "shure.overdrive.com",
    "silverstarcoop.overdrive.com",
    "simba2.overdrive.com",
    "simbacqlm.overdrive.com",
    "simcoe.overdrive.com",
    "sir.overdrive.com",
    "sjcpl.overdrive.com",
    "sjcpls.overdrive.com",
    "sjrlc.overdrive.com",
    "sjstsg.overdrive.com",
    "skokielibrary.overdrive.com",
    "slc.overdrive.com",
    "slcl.overdrive.com",
    "slco.overdrive.com",
    "slcpl.overdrive.com",
    "slpl.overdrive.com",
    "smcm.overdrive.com",
    "smdl.overdrive.com",
    "smsa.overdrive.com",
    "sno-isle.overdrive.com",
    "somerset.overdrive.com",
    "sonoma.overdrive.com",
    "south-ayrshire.overdrive.com",
    "southdakota.overdrive.com",
    "southeasternok.overdrive.com",
    "southisland.overdrive.com",
    "southtexas.overdrive.com",
    "southtyneside.overdrive.com",
    "southwestfl.overdrive.com",
    "sovalue.overdrive.com",
    "sp.overdrive.com",
    "spartanburglibraries.overdrive.com",
    "spbc.overdrive.com",
    "spfconnect.overdrive.com",
    "spl.overdrive.com",
    "spokanelibrary.overdrive.com",
    "sppl.overdrive.com",
    "springfield.overdrive.com",
    "srlsinfo.overdrive.com",
    "ssecoreideation.overdrive.com",
    "ssense.overdrive.com",
    "ssjcpl.overdrive.com",
    "sst.overdrive.com",
    "stadtbibliothek-graz.overdrive.com",
    "stadtbibliothek-leipzig.overdrive.com",
    "stamford.overdrive.com",
    "stanford.overdrive.com",
    "stanfordchildrens.overdrive.com",
    "state.overdrive.com",
    "stavanger.overdrive.com",
    "stcharles.overdrive.com",
    "stclaircounty.overdrive.com",
    "stimson.overdrive.com",
    "stlawu.overdrive.com",
    "stls.overdrive.com",
    "stlucieco.overdrive.com",
    "stonington.overdrive.com",
    "stratford.overdrive.com",
    "sttammany.overdrive.com",
    "suffolklibraries.overdrive.com",
    "sumclibrary.overdrive.com",
    "sunflowerelibrary.overdrive.com",
    "surreyca.overdrive.com",
    "surveyor-capital.overdrive.com",
    "susqcolibrary.overdrive.com",
    "sutherland.overdrive.com",
    "svlc.overdrive.com",
    "svld.overdrive.com",
    "swarthmore.overdrive.com",
    "swiss.overdrive.com",
    "swu.overdrive.com",
    "swvapub.overdrive.com",
    "tacoma.overdrive.com",
    "tadl.overdrive.com",
    "taipei.overdrive.com",
    "talc.overdrive.com",
    "tamlibrary.overdrive.com",
    "tamus.overdrive.com",
    "tangilibrary.overdrive.com",
    "tbc-elibrary.overdrive.com",
    "tblc.overdrive.com",
    "tbldc.overdrive.com",
    "tds.overdrive.com",
    "telenav.overdrive.com",
    "telford.overdrive.com",
    "tells.overdrive.com",
    "tempe.overdrive.com",
    "teshiotown.overdrive.com",
    "theamericanclub.overdrive.com",
    "thegdl.overdrive.com",
    "thehills.overdrive.com",
    "thelosc.overdrive.com",
    "thetradedesk.overdrive.com",
    "timberland.overdrive.com",
    "tkpark.overdrive.com",
    "tln.overdrive.com",
    "tokyoamericanclub.overdrive.com",
    "toledo.overdrive.com",
    "tolibrary.overdrive.com",
    "toronto.overdrive.com",
    "trac.overdrive.com",
    "trails.overdrive.com",
    "tri-c.overdrive.com",
    "tricountycc.overdrive.com",
    "trine.overdrive.com",
    "trinity.overdrive.com",
    "trinitycville.overdrive.com",
    "trinitylibrary.overdrive.com",
    "triparish.overdrive.com",
    "tscpl.overdrive.com",
    "tularecounty.overdrive.com",
    "tulsa.overdrive.com",
    "tuscaloosa.overdrive.com",
    "tvcc.overdrive.com",
    "ucb.overdrive.com",
    "ucirvinemain.overdrive.com",
    "ucmmo.overdrive.com",
    "ucny.overdrive.com",
    "udea.overdrive.com",
    "udel.overdrive.com",
    "ugc.overdrive.com",
    "uhls.overdrive.com",
    "uhnpatient.overdrive.com",
    "uj.overdrive.com",
    "una.overdrive.com",
    "unimelb.overdrive.com",
    "unioncounty.overdrive.com",
    "uofmiami.overdrive.com",
    "uofnkona.overdrive.com",
    "upnorth.overdrive.com",
    "usstratcom.overdrive.com",
    "usu.overdrive.com",
    "utahsonlinelibrary.overdrive.com",
    "uws.overdrive.com",
    "valley.overdrive.com",
    "valnet.overdrive.com",
    "vapld.overdrive.com",
    "vaski.overdrive.com",
    "vaudreuildorion.overdrive.com",
    "vaughanpl.overdrive.com",
    "vbpl.overdrive.com",
    "vcc.overdrive.com",
    "vccs.overdrive.com",
    "vcsu.overdrive.com",
    "vhy.overdrive.com",
    "viax.overdrive.com",
    "vikingdigitallibrary.overdrive.com",
    "vincent.overdrive.com",
    "virl.overdrive.com",
    "virtualbpld.overdrive.com",
    "virtuallibrary.overdrive.com",
    "virtualmoreland.overdrive.com",
    "voebb.overdrive.com",
    "volusia.overdrive.com",
    "vppl.overdrive.com",
    "waggin.overdrive.com",
    "wakegov.overdrive.com",
    "walmart.overdrive.com",
    "wapldmc.overdrive.com",
    "warrenpl.overdrive.com",
    "warrenwilson.overdrive.com",
    "washington.overdrive.com",
    "washoecounty.overdrive.com",
    "wauclib.overdrive.com",
    "waukegan.overdrive.com",
    "waverley.overdrive.com",
    "wbrl.overdrive.com",
    "wccls.overdrive.com",
    "wcl.overdrive.com",
    "westbanklibrary.overdrive.com",
    "westberks.overdrive.com",
    "westchester.overdrive.com",
    "westlake.overdrive.com",
    "westmoreland.overdrive.com",
    "westmount.overdrive.com",
    "westtexas.overdrive.com",
    "wfld.overdrive.com",
    "whitby.overdrive.com",
    "whittierpubliclibrary.overdrive.com",
    "wichita.overdrive.com",
    "wild.overdrive.com",
    "willowbrookbaptist.overdrive.com",
    "winnetkalibrary.overdrive.com",
    "winnipeg.overdrive.com",
    "wirral.overdrive.com",
    "wiscal.overdrive.com",
    "witcc.overdrive.com",
    "wml.overdrive.com",
    "woodlands.overdrive.com",
    "woollahra.overdrive.com",
    "wpl.overdrive.com",
    "wplc.overdrive.com",
    "wplibs.overdrive.com",
    "wppl.overdrive.com",
    "wrl.overdrive.com",
    "wtcpl.overdrive.com",
    "wvdeli.overdrive.com",
    "wvreads.overdrive.com",
    "wvu.overdrive.com",
    "wvuparkersburg.overdrive.com",
    "wyopublib.overdrive.com",
    "xs.overdrive.com",
    "yahabatown.overdrive.com",
    "yclibrary.overdrive.com",
    "ykkgroup.overdrive.com",
    "yln.overdrive.com",
    "ylpl.overdrive.com",
    "yolocounty.overdrive.com",
    "yorkcountyva.overdrive.com",
    "yorklibraries.overdrive.com",
    "youngstown.overdrive.com",
    "yourlibraryca.overdrive.com",
    "ypl.overdrive.com",
    "yprl.overdrive.com",
    "yspubliclib.overdrive.com",
    "yukon.overdrive.com",
    "yuma.overdrive.com",
    "yvl.overdrive.com",
    "zjlib.overdrivechina.cn",
    "zulabryantwylie.overdrive.com",
}


overdrive_site_equivalents = [
    # drop two large groups containing: accounts.google.com (non working), siteclosed.overdrive.com (no longer overdrive)

    {
        "abbe.overdrive.com",
        "digital.abbe-lib.org"
    },
    {
        "acfpl.overdrive.com",
        "overdrive.acfpl.org"
    },
    {
        "aclib.overdrive.com",
        "overdrive.aclib.us"
    },
    {
        "aclibrary.overdrive.com",
        "overdrive.aclibrary.org"
    },
    {
        "adfs.jcboe.net",
        "jchighschool.lib.overdrive.com"
    },
    {
        "adfs.leeschools.net",
        "leeschools.lib.overdrive.com",
        "sso.leeschools.net"
    },
    {
        "adfs.shellharbourac.nsw.edu.au",
        "shellharbour.lib.overdrive.com"
    },
    {
        "adfs.wylieisd.net",
        "wylieisd.lib.overdrive.com"
    },
    {
        "adlc.overdrive.com",
        "arkansasbookcooperative.lib.overdrive.com",
        "clarkcounty.overdrive.com",
        "clarkcountyar.lib.overdrive.com",
        "crossettpublic.lib.overdrive.com",
        "ebookconnection.lib.overdrive.com",
        "fcl.lib.overdrive.com",
        "independence.lib.overdrive.com",
        "laman.lib.overdrive.com",
        "pbjclibrary.lib.overdrive.com",
        "salineelibrary.lib.overdrive.com",
        "wcrls.lib.overdrive.com"
    },
    {
        "aguafriaaz.lib.overdrive.com",
        "asheboro.lib.overdrive.com",
        "bedfordva.lib.overdrive.com",
        "buncombe.lib.overdrive.com",
        "canyonview.lib.overdrive.com",
        "clever.com",
        "cobb.lib.overdrive.com",
        "dekalbga.lib.overdrive.com",
        "deschools.lib.overdrive.com",
        "falconheightses.lib.overdrive.com",
        "firth.lib.overdrive.com",
        "fsusd.lib.overdrive.com",
        "fznorth.lib.overdrive.com",
        "georgiacyber.lib.overdrive.com",
        "germantown.lib.overdrive.com",
        "katytx.lib.overdrive.com",
        "kershawsc.lib.overdrive.com",
        "kippdelta.lib.overdrive.com",
        "maryvillehs.lib.overdrive.com",
        "newbergor.lib.overdrive.com",
        "newtonrams.lib.overdrive.com",
        "noblesvillein.lib.overdrive.com",
        "pfisdtx.lib.overdrive.com",
        "putnam.lib.overdrive.com",
        "sanbenitoca.lib.overdrive.com",
        "sbcusd.lib.overdrive.com",
        "smcisd.lib.overdrive.com",
        "ssaisd.lib.overdrive.com",
        "vstream.lib.overdrive.com",
        "walshintermediate.lib.overdrive.com",
        "weisshstx.lib.overdrive.com",
        "westlaurens.lib.overdrive.com"
    },
    {
        "alliedreit.overdrive.com",
        "library.alliedreit.com"
    },
    {
        "arapahoe.overdrive.com",
        "digital.arapahoelibraries.org"
    },
    {
        "auburn.lib.overdrive.com",
        "cumberland.overdrive.com",
        "holroyd.lib.overdrive.com"
    },
    {
        "auburnpublical.overdrive.com",
        "ebooks.auburnalabama.org"
    },
    {
        "auth.rcs.k12.va.us",
        "rcps.lib.overdrive.com"
    },
    {
        "b2gsdl.lib.overdrive.com",
        "senecalibraries.overdrive.com"
    },
    {
        "badico.overdrive.com",
        "bayern.overdrive.com"
    },
    {
        "bartow.overdrive.com",
        "bartowlibrary.overdrive.com"
    },
    {
        "baypath.overdrive.com",
        "overdrive.baypath.edu"
    },
    {
        "bci.overdrive.com",
        "bcimc.overdrive.com"
    },
    {
        "bcpl.overdrive.com",
        "downloads.bclibrary.ca"
    },
    {
        "beaumontlib.overdrive.com",
        "bld.overdrive.com"
    },
    {
        "berkeleypubliclibrary.overdrive.com",
        "overdrive.berkeleypubliclibrary.org"
    },
    {
        "bethel.lib.overdrive.com",
        "bibliomation.overdrive.com"
    },
    {
        "betterlibraries.overdrive.com",
        "bromley.lib.overdrive.com",
        "glllibraries.overdrive.com",
        "greenwich-uk.lib.overdrive.com",
        "wandsworthlibraries.lib.overdrive.com"
    },
    {
        "bilkent.overdrive.com",
        "overdrive.library.bilkent.edu.tr"
    },
    {
        "bisd-sso.brazosportisd.net",
        "brazosport.lib.overdrive.com"
    },
    {
        "blackhills.overdrive.com",
        "rapidcity.lib.overdrive.com"
    },
    {
        "brantford.overdrive.com",
        "overdrive.brantford.library.on.ca"
    },
    {
        "brightonhove.overdrive.com",
        "overdrive.brighton-hove-rpml.org.uk"
    },
    {
        "brisbane.overdrive.com",
        "brisyprl.lib.overdrive.com"
    },
    {
        "bristol.overdrive.com",
        "bristollibraries.overdrive.com"
    },
    {
        "brooklyn.overdrive.com",
        "digitalbooks.brooklynpubliclibrary.org"
    },
    {
        "brownsburg.overdrive.com",
        "overdrive.brownsburg.lib.in.us"
    },
    {
        "buckscounty.overdrive.com",
        "buckslib.overdrive.com"
    },
    {
        "burlington.overdrive.com",
        "ebooks.bcls.lib.nj.us"
    },
    {
        "burlingtonpl.overdrive.com",
        "downloadcentre.bpl.on.ca"
    },
    {
        "carmel.overdrive.com",
        "overdrive.carmel.lib.in.us"
    },
    {
        "carsoncitylibrary.lib.overdrive.com",
        "churchillcountylibrary.lib.overdrive.com",
        "elkocountylibrary.lib.overdrive.com",
        "silverstar.lib.overdrive.com",
        "silverstarcoop.overdrive.com"
    },
    {
        "ccpl.overdrive.com",
        "ebcd.cuyahogalibrary.org"
    },
    {
        "cefls.overdrive.com",
        "ecollection.cefls.org"
    },
    {
        "centralcoast.overdrive.com",
        "gosford.lib.overdrive.com"
    },
    {
        "centralpalibraries.overdrive.com",
        "digitallibrary.centralpalibraries.org"
    },
    {
        "cherokeecountylibrary.lib.overdrive.com",
        "jasmine.overdrive.com"
    },
    {
        "chester.overdrive.com",
        "overdrive.ccls.org"
    },
    {
        "chinookarch.overdrive.com",
        "downloads.chinookarch.ca"
    },
    {
        "chipublib.overdrive.com",
        "overdrive.chipublib.org"
    },
    {
        "christchurch.overdrive.com",
        "overdrive.christchurchcitylibraries.com"
    },
    {
        "cityofjoha.overdrive.com",
        "cojlibrary.overdrive.com"
    },
    {
        "clevnet.overdrive.com",
        "geaugalibrary.lib.overdrive.com",
        "morley.lib.overdrive.com",
        "rrpl.overdrive.com",
        "www.digiload.org"
    },
    {
        "cloudconnect.vistausd.org",
        "vistausdca.lib.overdrive.com"
    },
    {
        "cloviscollegeca.overdrive.com",
        "cloviscomm.overdrive.com"
    },
    {
        "cmpld.lib.overdrive.com",
        "cookmemorial.overdrive.com"
    },
    {
        "colapublib.overdrive.com",
        "lacountylibrary.overdrive.com",
        "overdrive.colapublib.org"
    },
    {
        "colecciondigital.overdrive.com",
        "piloto.overdrive.com"
    },
    {
        "cologne.overdrive.com",
        "koeln.overdrive.com"
    },
    {
        "condenast.overdrive.com",
        "www.condenastoverdrive.com"
    },
    {
        "cpcregional.overdrive.com",
        "cpcrls.overdrive.com"
    },
    {
        "crystallake.lib.overdrive.com",
        "nsdc.overdrive.com"
    },
    {
        "dayton.overdrive.com",
        "overdrive.daytonmetrolibrary.org"
    },
    {
        "dbooks.wplc.info",
        "wplc.overdrive.com"
    },
    {
        "dbrl.overdrive.com",
        "overdrive.dbrl.org"
    },
    {
        "dcl.overdrive.com",
        "emedia2go.org"
    },
    {
        "dclibrary.overdrive.com",
        "overdrive.dclibrary.org"
    },
    {
        "defender.overdrive.com",
        "library.defenderdirect.com"
    },
    {
        "deichman.overdrive.com",
        "oslo.overdrive.com"
    },
    {
        "delco.overdrive.com",
        "digitallibrary.delcolibraries.org"
    },
    {
        "denver.overdrive.com",
        "downloadmedia.denverlibrary.org"
    },
    {
        "devon.lib.overdrive.com",
        "librariesunlimited.overdrive.com"
    },
    {
        "digital.fairfieldpubliclibrary.org",
        "fairfield.overdrive.com"
    },
    {
        "digital.friscolibrary.com",
        "frisco.overdrive.com"
    },
    {
        "digital.griver.org",
        "griver.overdrive.com"
    },
    {
        "digital.larl.org",
        "larl.overdrive.com"
    },
    {
        "digital.minlib.net",
        "minuteman.overdrive.com"
    },
    {
        "digital.rochesterpubliclibrary.org",
        "rochester.overdrive.com"
    },
    {
        "digital.santaclaritalibrary.com",
        "santaclarita.overdrive.com"
    },
    {
        "digital.thegdl.org",
        "thegdl.overdrive.com"
    },
    {
        "digital.whitbylibrary.on.ca",
        "whitby.overdrive.com"
    },
    {
        "digital.whiteplainslibrary.org",
        "whiteplains.overdrive.com"
    },
    {
        "digitalbooks.gwinnettpl.org",
        "gwinnett.overdrive.com"
    },
    {
        "digitalbooks.infodepot.org",
        "infodepot.overdrive.com"
    },
    {
        "digitalbooks.lcpl.lib.va.us",
        "lcpl.overdrive.com"
    },
    {
        "digitalbooks.pgcmls.info",
        "pgcmls.overdrive.com"
    },
    {
        "digitalbooks.toledolibrary.org",
        "toledo.overdrive.com"
    },
    {
        "digitalcollection.uhls.org",
        "uhls.overdrive.com"
    },
    {
        "digitallibrary.dlrcoco.ie",
        "dlrcoco.overdrive.com"
    },
    {
        "digitallibrary.leicester.gov.uk",
        "leicesteruk.overdrive.com"
    },
    {
        "digitallibrary.nafclibrary.org",
        "nafcpl.overdrive.com"
    },
    {
        "digitallibrary.norfolk.gov.uk",
        "norfolk.overdrive.com"
    },
    {
        "digitalmedia.forsythpl.org",
        "forsyth.overdrive.com"
    },
    {
        "digitalmedia.halifaxpubliclibraries.ca",
        "halifax.overdrive.com"
    },
    {
        "digitalmedia.library.ns.ca",
        "novascotia.overdrive.com"
    },
    {
        "digitalmedia.tolibrary.org",
        "tolibrary.overdrive.com"
    },
    {
        "digitalmedia.waterburypubliclibrary.com",
        "waterbury.overdrive.com"
    },
    {
        "dlrdownload.infoway.org",
        "infoway.overdrive.com"
    },
    {
        "dmz.hmcpl.org",
        "dmz.overdrive.com"
    },
    {
        "download.maineinfonet.org",
        "maine.overdrive.com",
        "www.maineinfonet.org"
    },
    {
        "download.saclibrary.org",
        "saclibrary.overdrive.com"
    },
    {
        "downloadable.jclc.org",
        "jclc.overdrive.com"
    },
    {
        "downloadable.mccpl.lib.al.us",
        "mccpl.overdrive.com"
    },
    {
        "downloadable.saginawlibrary.org",
        "saginawlibrary.overdrive.com"
    },
    {
        "downloadables.lib.overdrive.com",
        "slpl.overdrive.com"
    },
    {
        "downloadcentre.library.on.ca",
        "odmc.overdrive.com"
    },
    {
        "downloadlibrary.overdrive.com",
        "kpl.overdrive.com",
        "www.downloadlibrary.ca"
    },
    {
        "downloads.cmlibrary.org",
        "plcmc.overdrive.com"
    },
    {
        "downloads.live-brary.com",
        "livebrary.overdrive.com"
    },
    {
        "downloads.myepl.org",
        "myepl.overdrive.com"
    },
    {
        "downloads.northnetlibs.org",
        "northnet.overdrive.com"
    },
    {
        "downloads.sonomalibrary.org",
        "sonoma.overdrive.com"
    },
    {
        "downloads.union.lib.nc.us",
        "unioncounty.overdrive.com"
    },
    {
        "downloads.yourlibrary.ca",
        "yourlibraryca.overdrive.com"
    },
    {
        "dpls.overdrive.com",
        "ebooks.dpls.lib.or.us"
    },
    {
        "duke.overdrive.com",
        "overdrive.library.duke.edu"
    },
    {
        "e-media.lapl.org",
        "lapl.overdrive.com"
    },
    {
        "e-thek.overdrive.com",
        "zurich.overdrive.com"
    },
    {
        "e.hbpl.org",
        "hbpl.overdrive.com"
    },
    {
        "e.lprlibrary.org",
        "elprlibrary.overdrive.com",
        "lonesomepine.boundless.ly"
    },
    {
        "eaudiocatalog.ocln.org",
        "ocln.overdrive.com"
    },
    {
        "ebccls.overdrive.com",
        "overdrive.ebccls.org"
    },
    {
        "ebook.smpl.org",
        "santamonica.overdrive.com"
    },
    {
        "ebook.trl.org",
        "timberland.overdrive.com"
    },
    {
        "ebook.yourcloudlibrary.com",
        "ebooks.kdl.org",
        "kdl.overdrive.com"
    },
    {
        "ebooks.kentonlibrary.org",
        "kenton.overdrive.com"
    },
    {
        "ebooks.library.ipswich.qld.gov.au",
        "ipswich.overdrive.com"
    },
    {
        "ebooks.libraryvisit.org",
        "youngstown.overdrive.com"
    },
    {
        "ebooks.lvccld.org",
        "lasvegas.overdrive.com"
    },
    {
        "ebooks.mcls.org",
        "mlc.overdrive.com"
    },
    {
        "ebooks.mdpls.org",
        "mdpls.overdrive.com"
    },
    {
        "ebooks.myjdl.com",
        "myjdl.overdrive.com"
    },
    {
        "ebooks.nypl.org",
        "nypl.overdrive.com"
    },
    {
        "ebooks.omahalibrary.org",
        "omaha.overdrive.com"
    },
    {
        "ebooks.orlandparklibrary.org",
        "orlandparklibrary.overdrive.com"
    },
    {
        "ebooks.pvld.org",
        "pvld.overdrive.com"
    },
    {
        "ebooks.realtor.org",
        "realtor.overdrive.com"
    },
    {
        "ebooks.smsa.org.au",
        "smsa.overdrive.com"
    },
    {
        "ebooks.surreycc.gov.uk",
        "surreycc.overdrive.com"
    },
    {
        "ebooks.trinity.qld.edu.au",
        "trinity.overdrive.com"
    },
    {
        "ebooks.tscpl.org",
        "tscpl.overdrive.com"
    },
    {
        "ebooks.vaughanpl.info",
        "vaughanpl.overdrive.com"
    },
    {
        "ebooks.wildernesscoast.org",
        "wild.overdrive.com"
    },
    {
        "ebr.overdrive.com",
        "overdrive.ebrpl.com"
    },
    {
        "ebranch.yorklibraries.org",
        "yorkebranch.overdrive.com"
    },
    {
        "ecollection.imcpl.org",
        "ecollection.indypl.org",
        "indypl.overdrive.com"
    },
    {
        "ecollection.ranchomiragelibrary.org",
        "rml.overdrive.com"
    },
    {
        "econtent.hclib.org",
        "hclib.overdrive.com"
    },
    {
        "efiles.rcls.org",
        "rcls.overdrive.com"
    },
    {
        "egfmn.overdrive.com",
        "elend.egf.mn"
    },
    {
        "elib.rvl.info",
        "rvl.overdrive.com"
    },
    {
        "elibrary.gympie.qld.gov.au",
        "gympie.overdrive.com"
    },
    {
        "elibrary.moretonbay.qld.gov.au",
        "moretonbay.overdrive.com"
    },
    {
        "elibrary.neo.edu",
        "neo.overdrive.com"
    },
    {
        "elibrary.nlpl.ca.lib.overdrive.com",
        "elibrary.overdrive.com"
    },
    {
        "elibrarynj.overdrive.com",
        "listennj.lib.overdrive.com"
    },
    {
        "elibraryoverdrive.gov.yk.ca",
        "yukon.overdrive.com"
    },
    {
        "emedia.library.nashville.org",
        "nashville.overdrive.com"
    },
    {
        "emory.overdrive.com",
        "overdrive.emory.edu"
    },
    {
        "entertainment.haverford.edu",
        "harborday.lib.overdrive.com",
        "harrogategrammar.lib.overdrive.com",
        "hncps.lib.overdrive.com",
        "ipswichgrammar.lib.overdrive.com",
        "leabharlann.overdrive.com",
        "masada.lib.overdrive.com",
        "mbi.lib.overdrive.com",
        "mountridleycollege.lib.overdrive.com",
        "oroville.lib.overdrive.com",
        "pegasus.lib.overdrive.com",
        "ridgwaychristian.lib.overdrive.com",
        "shontoprep.lib.overdrive.com",
        "slvusd.lib.overdrive.com",
        "usd382.lib.overdrive.com",
        "valleypark.lib.overdrive.com"
    },
    {
        "eplace.oklibrary.net",
        "southeasternok.overdrive.com"
    },
    {
        "epukapuka.org",
        "epukapuka.overdrive.com"
    },
    {
        "essex.bookaisle.com",
        "essex.overdrive.com"
    },
    {
        "ezone.oslri.net",
        "riezone.overdrive.com"
    },
    {
        "falkland.overdrive.com",
        "falklandcommunitylibrary.overdrive.com"
    },
    {
        "federation1.irvingisd.net",
        "irvingisd.lib.overdrive.com"
    },
    {
        "fletcherfree.lib.overdrive.com",
        "gmlc.overdrive.com",
        "www.listenupvermont.org"
    },
    {
        "fmpl.lib.overdrive.com",
        "wbrl.overdrive.com"
    },
    {
        "fontbonne.lib.overdrive.com",
        "lindenwood.lib.overdrive.com",
        "mobius.overdrive.com"
    },
    {
        "fortbend.overdrive.com",
        "overdrive.fortbend.lib.tx.us"
    },
    {
        "fs.sainteanne.ca",
        "sainteanne.lib.overdrive.com"
    },
    {
        "fundacionepm.overdrive.com",
        "reddebibliotecas.lib.overdrive.com"
    },
    {
        "garland.lib.overdrive.com",
        "garlandcounty.overdrive.com"
    },
    {
        "gatech.overdrive.com",
        "overdrive.library.gatech.edu"
    },
    {
        "geh-online.overdrive.com",
        "gehonline.overdrive.com"
    },
    {
        "georgesriver.overdrive.com",
        "kogarah.lib.overdrive.com"
    },
    {
        "georgiahighlands.overdrive.com",
        "highlands.lib.overdrive.com"
    },
    {
        "graz.overdrive.com",
        "stadtbibliothek-graz.overdrive.com"
    },
    {
        "greengoldlibraries.overdrive.com",
        "overdrive.greengoldlibraries.org"
    },
    {
        "grpl.overdrive.com",
        "overdrive.grpl.org"
    },
    {
        "gvpl.overdrive.com",
        "overdrive.gvpl.ca"
    },
    {
        "hkacademy.lib.overdrive.com",
        "isnsebooks.lib.overdrive.com",
        "montessori.lib.overdrive.com",
        "security.follettsoftware.com",
        "soongchinglingschool.lib.overdrive.com",
        "wscschools.lib.overdrive.com"
    },
    {
        "hoodcolib.lib.overdrive.com",
        "hoodcounty.overdrive.com"
    },
    {
        "hslda.lib.overdrive.com",
        "members.hslda.ca"
    },
    {
        "humbleisd.lib.overdrive.com",
        "my.humbleisd.net"
    },
    {
        "huntington.overdrive.com",
        "suffolk.lib.overdrive.com"
    },
    {
        "icpcolombia.overdrive.com",
        "instituto.overdrive.com"
    },
    {
        "icpl.overdrive.com",
        "overdrive.icpl.org"
    },
    {
        "indianbible.overdrive.com",
        "indianbiblecoll.lib.overdrive.com"
    },
    {
        "irc.overdrive.com",
        "irc.usembassy.montevideo.lib.overdrive.com"
    },
    {
        "kcls.overdrive.com",
        "overdrive.downloads.kcls.org"
    },
    {
        "kfpl.overdrive.com",
        "overdrive.kfpl.ca"
    },
    {
        "knoxcounty.overdrive.com",
        "mdl.knoxlib.org"
    },
    {
        "lakecounty.overdrive.com",
        "overdrive.lcplin.org"
    },
    {
        "leipzig.overdrive.com",
        "stadtbibliothek-leipzig.overdrive.com"
    },
    {
        "lfpl.overdrive.com",
        "overdrive.lfpl.org"
    },
    {
        "librariesofstevenscounty.lib.overdrive.com",
        "thelosc.overdrive.com"
    },
    {
        "librariesonthego.library.on.ca",
        "librariesonthego.overdrive.com"
    },
    {
        "librariestasmania.overdrive.com",
        "linc.lib.overdrive.com"
    },
    {
        "library.overdrive.com",
        "library.ucmo.lib.overdrive.com"
    },
    {
        "libraryonthego.org",
        "rpls.overdrive.com"
    },
    {
        "librarypoint.overdrive.com",
        "overdrive.librarypoint.org"
    },
    {
        "librarytogo.shortgrass.ca",
        "shortgrass.overdrive.com"
    },
    {
        "libraryweb.overdrive.com",
        "overdrive.libraryweb.org"
    },
    {
        "libri.lib.overdrive.com",
        "libriid.overdrive.com"
    },
    {
        "lincolnshire.overdrive.com",
        "lincolnshirelibraries.overdrive.com"
    },
    {
        "madera.overdrive.com",
        "maderalibrary.overdrive.com"
    },
    {
        "marshallcenter.on.lib.overdrive.com",
        "marshallcenter.overdrive.com"
    },
    {
        "merced.overdrive.com",
        "mercedcountylibrary.overdrive.com"
    },
    {
        "miami.lib.overdrive.com",
        "uofmiami.overdrive.com"
    },
    {
        "mlcstl.overdrive.com",
        "overdrive.mlcstl.org"
    },
    {
        "montana.overdrive.com",
        "montanalibrary2go.org"
    },
    {
        "msgsu.kutuphane.lib.overdrive.com",
        "msgsu.overdrive.com"
    },
    {
        "multco.lib.overdrive.com",
        "multcolib.overdrive.com"
    },
    {
        "myrcpl.lib.overdrive.com",
        "myrl.overdrive.com"
    },
    {
        "ncdl.overdrive.com",
        "sanbenitofl.lib.overdrive.com",
        "tuolumnecounty.lib.overdrive.com",
        "watsonville.lib.overdrive.com"
    },
    {
        "nicoletcollegelibrary.overdrive.com",
        "wiscal.overdrive.com"
    },
    {
        "nlb.overdrive.com",
        "singapore.lib.overdrive.com"
    },
    {
        "nnyoverdrive.nnyln.net",
        "nnyoverdrive.overdrive.com"
    },
    {
        "northcountrylibraries.overdrive.com",
        "overdrive.northcountrylibraries.org"
    },
    {
        "northernbeacheslibraries.overdrive.com",
        "warringah.lib.overdrive.com"
    },
    {
        "nsls.overdrive.com",
        "www.mymediamall.net"
    },
    {
        "ntrls.overdrive.com",
        "www.ntexlibrariesonthego.org"
    },
    {
        "oakland.overdrive.com",
        "overdrive.oaklandlibrary.org"
    },
    {
        "omnilibraries.overdrive.com",
        "www.omnilibraries.org"
    },
    {
        "osceolalibrary.overdrive.com",
        "overdrive.osceolalibrary.org"
    },
    {
        "overdrive-audio-books.sno-isle.org",
        "sno-isle.overdrive.com"
    },
    {
        "overdrive.harlingen.tstc.edu",
        "tstc.overdrive.com"
    },
    {
        "overdrive.portagelibrary.org",
        "portagelibrary.overdrive.com"
    },
    {
        "overdrive.princetonlibrary.org",
        "princetonlibrary.overdrive.com"
    },
    {
        "overdrive.shastalibraries.org",
        "shastalibraries.overdrive.com"
    },
    {
        "overdrive.sjlibrary.org",
        "sanjose.overdrive.com"
    },
    {
        "overdrive.slcl.org",
        "slcl.overdrive.com"
    },
    {
        "overdrive.slcpl.org",
        "slcpl.overdrive.com"
    },
    {
        "overdrive.thelibrary.org",
        "springfield.overdrive.com"
    },
    {
        "overdrive.ville.vaudreuil-dorion.qc.ca",
        "vaudreuildorion.overdrive.com"
    },
    {
        "overdrive.volusialibrary.org",
        "volusia.overdrive.com"
    },
    {
        "overdrive.westlakelibrary.org",
        "westlake.overdrive.com"
    },
    {
        "overdrive.yclibrary.org",
        "yclibrary.overdrive.com"
    },
    {
        "overdrive.yln.info",
        "prescott.overdrive.com",
        "yln.overdrive.com"
    },
    {
        "overdrive.youranswerplace.org",
        "stcharles.overdrive.com"
    },
    {
        "owwl.overdrive.com",
        "owwl2go.owwl.org"
    },
    {
        "pentagon.lib.overdrive.com",
        "pentagonlib.overdrive.com"
    },
    {
        "pinnacle.overdrive.com",
        "www.pindigital.org"
    },
    {
        "pioneer.lib.overdrive.com",
        "pioneerok.overdrive.com"
    },
    {
        "portal.salinasuhsd.org",
        "salinasuhsd.lib.overdrive.com"
    },
    {
        "pulse.simcoe.ca",
        "simcoe.overdrive.com"
    },
    {
        "rafbokasafn.overdrive.com",
        "rafbokasafnid.overdrive.com"
    },
    {
        "sabah.overdrive.com",
        "ssl.lib.overdrive.com"
    },
    {
        "salon.overdrive.com",
        "salon.sals.edu"
    },
    {
        "saskatchewan.overdrive.com",
        "www.library2go.sk.ca"
    },
    {
        "schaffhausen.lib.overdrive.com",
        "swiss.overdrive.com"
    },
    {
        "sequoyah.overdrive.com",
        "srls.lib.overdrive.com"
    },
    {
        "shchildren.overdrive.com",
        "sst.overdrive.com"
    },
    {
        "shenzhen.overdrive.com",
        "sz.overdrive.com"
    },
    {
        "shijingshan.overdrive.com",
        "sjstsg.overdrive.com"
    },
    {
        "smcisd.lib.overdrive.com",
        "sts.smcisd.net"
    },
    {
        "southwestfl.overdrive.com",
        "swfln.lib.overdrive.com"
    },
    {
        "sovalue.org",
        "sovalue.overdrive.com"
    },
    {
        "sppl.overdrive.com",
        "spps.lib.overdrive.com"
    },
    {
        "sublettecountydigital.lib.overdrive.com",
        "tc.lib.overdrive.com",
        "virtuallibrary.overdrive.com"
    },
    {
        "whittier.overdrive.com",
        "whittierpubliclibrary.overdrive.com"
    },
    {
        "windsor.lib.overdrive.com",
        "windsorpublic.overdrive.com"
    },
    {
        "winnetkalibrary.overdrive.com",
        "winnetkano.overdrive.com"
    },
    {
        "novascotia.overdrive.com",
        "samepage.overdrive.com"
    },
]


# reformat equivalents
equivalent_overdrive_sites = {}
for ose in overdrive_site_equivalents:
    for s in ose:
        equivalent_overdrive_sites[s] = list(ose - {s})
