#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import, print_function)

__license__ = 'GPL v3'
__copyright__ = '2012-2022, John Howell <jhowell@acm.org>'


AZW3_FILE_TYPE = 'azw3'
MOBI_FILE_TYPE = 'mobi'
EPUB_FILE_TYPE = 'epub'


# e-book formats (use caution when changing - old values may be cached)

FORMAT_BLIO = 'Blio eBook'
FORMAT_BOOKREADER = 'BookReader'        # Internet Archive: Read in Browser
FORMAT_ADOBE_EPUB = 'Adobe EPUB eBook'  # ADE DRM
FORMAT_ADOBE_PDF = 'Adobe PDF eBook'    # ADE DRM
FORMAT_KINDLE_BOOK = 'Kindle Book'      # Amazon DRM
FORMAT_MOBI_EBOOK = 'Mobipocket eBook'
FORMAT_OD_READ = 'OverDrive Read'
FORMAT_ONLINE_READER = 'Online Reader'
FORMAT_OPEN_EPUB = 'Open EPUB eBook'
FORMAT_OPEN_PDF = 'Open PDF eBook'
FORMAT_SCRIBD_BOOK_READER = 'Scribd Reader'
FORMAT_SCRIBD_COMIC_READER = 'Scribd Comic Reader'
FORMAT_SCRIBD_EBOOK = 'Scribd eBook'    # old, replaced by FORMAT_SCRIBD_BOOK_READER (keep for cached entries)
FORMAT_PROTECTED_DAISY = 'Protected DAISY eBook'
FORMAT_DJVU = 'Open DjVu eBook'
FORMAT_HTML = 'HTML eBook'
FORMAT_TEXT = 'Plain Text eBook'
FORMAT_MEDIADO_READER = 'MediaDo Reader'
FORMAT_HOOPLA_BOOK_READER = 'Hoopla Book Reader'
FORMAT_HOOPLA_COMIC_READER = 'Hoopla Comic Reader'
FORMAT_AXIS360_READER = 'Axis 360 Reader'
FORMAT_CBR = 'CBR'
FORMAT_CBZ = 'CBZ'

ALL_READABLE_FORMATS = {
    FORMAT_BLIO, FORMAT_BOOKREADER, FORMAT_ADOBE_EPUB, FORMAT_ADOBE_PDF, FORMAT_KINDLE_BOOK,
    FORMAT_MOBI_EBOOK, FORMAT_OD_READ, FORMAT_ONLINE_READER, FORMAT_OPEN_EPUB, FORMAT_OPEN_PDF,
    FORMAT_SCRIBD_BOOK_READER, FORMAT_SCRIBD_COMIC_READER, FORMAT_PROTECTED_DAISY, FORMAT_DJVU, FORMAT_HTML, FORMAT_TEXT,
    FORMAT_MEDIADO_READER, FORMAT_HOOPLA_BOOK_READER, FORMAT_HOOPLA_COMIC_READER, FORMAT_AXIS360_READER, FORMAT_CBR, FORMAT_CBZ}

ALL_EPUB_FORMATS = {FORMAT_ADOBE_EPUB, FORMAT_OPEN_EPUB}
ALL_KINDLE_FORMATS = {FORMAT_KINDLE_BOOK, FORMAT_MOBI_EBOOK}
ALL_PDF_FORMATS = {FORMAT_ADOBE_PDF, FORMAT_OPEN_PDF}
ALL_BLIO_FORMATS = {FORMAT_BLIO}
ALL_OTHER_EBOOK_FORMATS = {FORMAT_PROTECTED_DAISY, FORMAT_DJVU, FORMAT_TEXT, FORMAT_HTML, FORMAT_CBR, FORMAT_CBZ}
ALL_APP_ONLINE_EBOOK_FORMATS = {
    FORMAT_BOOKREADER, FORMAT_OD_READ, FORMAT_ONLINE_READER, FORMAT_SCRIBD_BOOK_READER, FORMAT_SCRIBD_COMIC_READER,
    FORMAT_MEDIADO_READER, FORMAT_HOOPLA_BOOK_READER, FORMAT_HOOPLA_COMIC_READER, FORMAT_AXIS360_READER}

# audiobook formats

FORMAT_ACOUSTIK = 'Acoustik Audiobook'
FORMAT_HOOPLA_AUDIOBOOK = 'Hoopla Audiobook'
FORMAT_M4B = 'Apple Audiobook'
FORMAT_MP3 = 'MP3 Audiobook'
FORMAT_RBD = 'RBdigital Audiobook'
FORMAT_OCD = 'OneClickdigital Audiobook'    # old name (keep for possible cached data)
FORMAT_OD_LISTEN = 'OverDrive Listen'
FORMAT_OD_MP3 = 'OverDrive MP3 Audiobook'
FORMAT_OD_WMA = 'OverDrive WMA Audiobook'
FORMAT_SCRIBD_AUDIOBOOK = 'Scribd Audiobook'
FORMAT_WMA = 'WMA Audiobook'
FORMAT_AXIS360_AUDIO = 'Axis 360 Audio'
FORMAT_AUDIBLE_AUDIOBOOK = 'Audible Audiobook'
FORMAT_OD_READ_ALONG = 'OverDrive Read-along'

ALL_LISTENABLE_FORMATS = {
    FORMAT_ACOUSTIK, FORMAT_HOOPLA_AUDIOBOOK, FORMAT_M4B, FORMAT_MP3,
    FORMAT_RBD, FORMAT_OCD, FORMAT_OD_LISTEN, FORMAT_OD_MP3, FORMAT_OD_WMA, FORMAT_SCRIBD_AUDIOBOOK,
    FORMAT_WMA, FORMAT_AXIS360_AUDIO, FORMAT_AUDIBLE_AUDIOBOOK, FORMAT_OD_READ_ALONG}

ALL_MP3_FORMATS = {FORMAT_OD_MP3, FORMAT_MP3}
ALL_WMA_FORMATS = {FORMAT_OD_WMA, FORMAT_WMA}
ALL_OTHER_AUDIOBOOK_FORMATS = {
    FORMAT_ACOUSTIK, FORMAT_HOOPLA_AUDIOBOOK,
    FORMAT_M4B, FORMAT_RBD, FORMAT_OCD, FORMAT_OD_LISTEN, FORMAT_SCRIBD_AUDIOBOOK,
    FORMAT_AXIS360_AUDIO, FORMAT_AUDIBLE_AUDIOBOOK, FORMAT_OD_READ_ALONG}

# video formats
FORMAT_OD_VIDEO = 'OverDrive Video'
FORMAT_OD_VIDEO_MOBILE = 'OverDrive Video (mobile)'
FORMAT_STREAMING_VIDEO = 'Streaming Video'

ALL_WATCHABLE_FORMATS = {FORMAT_OD_VIDEO, FORMAT_OD_VIDEO_MOBILE, FORMAT_STREAMING_VIDEO}

# music formats
FORMAT_OD_MUSIC = 'OverDrive Music'

ALL_MUSIC_FORMATS = {FORMAT_OD_MUSIC, }

#periodical formats
FORMAT_NOOK_PERIODICALS = 'NOOK Periodicals'
FORMAT_OD_MAGAZINE = 'OverDrive Magazine'

ALL_PERIODICAL_FORMATS = {FORMAT_NOOK_PERIODICALS, FORMAT_OD_MAGAZINE}


# Other formats
FORMAT_DISNEY_ONLINE_BOOK = 'Disney Online Book'    # read-along stories

ALL_OTHER_FORMATS = {FORMAT_DISNEY_ONLINE_BOOK, }
