# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.16"     # qt.core
#~ zzzzzzzzzzzzzz not uploaded yet zzzzzzzzzzzzzzzz not even tested yet z

from qt.core import QMenu, QDialog, QIcon, QAction, QSize, QApplication
from qt.core import QWidget,QRegularExpression  #for searching the widget tree for the JobDialog item

import os, sys
import apsw
from functools import partial
import subprocess
import time
from time import sleep
import zipfile

from calibre import isbytestring, force_unicode, prints
from calibre.constants import filesystem_encoding, DEBUG, iswindows
from calibre.gui2 import error_dialog, Dispatcher
from calibre.gui2.actions import InterfaceAction
from calibre.utils.config import JSONConfig

from polyglot.builtins import as_unicode, map

from calibre_plugins.english_noun_frequency.config import prefs
from calibre_plugins.english_noun_frequency.common_utils import set_plugin_icon_resources, get_icon, create_menu_action_unique
from calibre_plugins.english_noun_frequency.enf_dialog import ENFDialog
from calibre_plugins.english_noun_frequency.jobs import start_threaded_enf
from calibre_plugins.english_noun_frequency.ui_toastdialog import UIToastDialog

PLUGIN_ICONS = ['images/enficon.png', 'images/enfsmallicon.png']

documentation_path = "unknown"

selected_books_list = []

my_count_of_total_currently_running_jobs = 0

#--------------------------------------------------------------------------------------------
class ActionEnglishNounFrequency(InterfaceAction):

    name = 'English Noun Frequency'
    action_spec = ('ENF', 'images/enficon.png', "Determine the 'English Noun Frequencies' for a particular book's text, and optionally add Comments, Tags, and/or update a Custom Column.", None)
    action_type = 'global'
    accepts_drops = False
    auto_repeat = False
    priority = 9
    popup_type = 1

    #-----------------------------------------------------------------------------------------
    def genesis(self):
        self.maingui = self.gui

        self.is_library_selected = True

        icon_resources = self.load_resources(PLUGIN_ICONS)
        set_plugin_icon_resources(self.name, icon_resources )

        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.qaction.triggered.connect(self.enf_dialog)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def initialization_complete(self):

        self.maingui = self.gui

        self.guidb = self.gui.library_view.model().db

        global my_count_of_total_currently_running_jobs
        my_count_of_total_currently_running_jobs = 0

        global documentation_path
        documentation_path = "unknown"

        global selected_books_list
        selected_books_list[:] = []   #clear it

        self.my_jobs_dialog_object = "unknown"
        try:
            sre = QRegularExpression(".+")
            answer  = self.gui.findChildren(QWidget,sre)
            if answer:
                if isinstance(answer,list):
                    for item in answer:
                        if item:
                            s = as_unicode(item)
                            if "JobsDialog" in s:
                                self.my_jobs_dialog_object = item
                                break
        except:
            self.my_jobs_dialog_object = "unknown"

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def library_changed(self,guidb):

        self.guidb = self.gui.library_view.model().db

        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))

        try:
            self.enf_dialog.close()
        except:
            pass

        try:
            self.ui_toast_dialog.close()
        except:
            pass

        global my_count_of_total_currently_running_jobs
        my_count_of_total_currently_running_jobs = 0

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def enf_dialog(self):

        self.guidb = self.gui.library_view.model().db

        db = self.guidb
        path = db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')

        global my_count_of_total_currently_running_jobs
        if my_count_of_total_currently_running_jobs > 0 :
             return error_dialog(self.gui, _('English Noun Frequencies Has a Running Job'),_('Sorry, but the currently running ENF job is already using the identical files that you wish to use.  Please wait until that job finishes before continuing.'), show=True)
        else:
            my_count_of_total_currently_running_jobs = 0  #no negatives
            self.create_ui_toast_dialog(0)
            self.qaction.setIcon(get_icon(PLUGIN_ICONS[1]))
            self.enf_dialog = ENFDialog(self.gui,self.qaction.icon(),self.guidb,self.plugin_path,self.enf_job_control)
            self.enf_dialog.show()
            self.ui_toast_dialog.close()
            self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def enf_job_control(self,guidb,param_dict,sel_type):

        global selected_books_list
        selected_books_list[:] = []   #clear it

        selected_books_list = self.get_selected_books(guidb,sel_type)

        n_books = len(selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('ENF'),_('No Books Were Selected.'), show=True)

        try:
            self.enf_dialog.close()
            global my_count_of_total_currently_running_jobs
            my_count_of_total_currently_running_jobs = my_count_of_total_currently_running_jobs + 1
            start_threaded_enf(self,guidb, self.plugin_path, selected_books_list, param_dict, Dispatcher(self.enf_finish_with_refresh))
            msg = ('ENF Job was submitted and is processing %d book(s)' %(n_books))
            self.gui.status_bar.showMessage(msg)
        except Exception as e:
            my_count_of_total_currently_running_jobs = my_count_of_total_currently_running_jobs - 1

        if self.my_jobs_dialog_object:
            if self.my_jobs_dialog_object != "unknown":
                try:
                    self.my_jobs_dialog_object.show()
                except:
                    pass

    #-----------------------------------------------------------------------------------------
    def enf_finish_with_refresh(self, job):

        global my_count_of_total_currently_running_jobs
        my_count_of_total_currently_running_jobs = my_count_of_total_currently_running_jobs - 1

        global selected_books_list

        if job.failed:
            self.force_refresh_of_cache(selected_books_list)
            self.gui.job_exception(job, dialog_title=_('ENF Job Failed...'))

        self.gui.status_bar.show_message(_('ENF Job Has Finished'), 5000)

        self.force_refresh_of_cache(selected_books_list)

        self.mark_selected_books()

        try:
            del job
        except:
            pass

   #-----------------------------------------------------------------------------------------
    def mark_selected_books(self):

        global selected_books_list

        found_dict = {}
        s_true = 'true'
        for row in selected_books_list:
            key = int(row)
            found_dict[key] = s_true

        marked_ids = dict.fromkeys(found_dict, s_true)
        self.gui.current_db.set_marked_ids(marked_ids)
        self.gui.search.clear()
        self.gui.search.set_search_string('marked:true')

    #-----------------------------------------------------------------------------------------
    def get_selected_books(self,guidb,sel_type):

        selected_books_list = []
        del selected_books_list
        selected_books_list = []

        book_ids_list = []
        work_book_ids_frozenset = ""

        if sel_type == "selected":
            book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids()))  #https://stackoverflow.com/questions/50671360/map-in-python-3-vs-python-2
            n = len(book_ids_list)
            if  n == 0:
                return selected_books_list
            for item in book_ids_list:
                s = as_unicode(item['calibre_id'])
                selected_books_list.append(s)
        else:
            db = self.gui.current_db.new_api
            work_book_ids_frozenset = db.all_book_ids()
            for row in work_book_ids_frozenset:
                selected_books_list.append(row)

        del book_ids_list
        del work_book_ids_frozenset

        return selected_books_list
  #-----------------------------------------------------------------------------------------
    def convert_id_to_book(self, idval):
        book = {}
        book['calibre_id'] = idval
        return book
  #-------------------------------------------------------------------------------------------------------------------------------------
    def force_refresh_of_cache(self, books_to_refresh):
        db = self.maingui.current_db.new_api
        db.reload_from_db(clear_caches=False)
        frozen = db.all_book_ids()
        books = list(frozen)
        self.maingui.library_view.model().refresh_ids(books)
        self.maingui.tags_view.recount()
        QApplication.instance().processEvents()
        if DEBUG: print("number of books in selected_books_list to be re-selected after cache refresh: ", as_unicode(len(books_to_refresh)))
        if len(books_to_refresh) > 0:
            identifiers = set(books_to_refresh)
            self.maingui.library_view.select_rows(identifiers,using_ids=True,change_current=True,scroll=True)  #refreshing the cache also clears the currently selected books...
  #-------------------------------------------------------------------------------------------------------------------------------------
    def create_ui_toast_dialog(self,msg_num):

        #msg_num = 0 : Please Wait While Your User Custom Word Rules are Loaded and Cross-Checked
        #msg_num = 1 : Job Submitted


        self.ui_toast_dialog = UIToastDialog(self.gui,self.qaction.icon(),msg_num)

        self.ui_toast_dialog.show()

        self.ui_toast_dialog.setModal(True)

        self.ui_toast_dialog.update()

        self.ui_toast_dialog.repaint()


    #-------------------------------------------------------------------------------------------------------------------------------------
    def create_ui_toast_dialog_for_jobs(self):
        #msg_num = 1 : Job Submitted

        self.create_ui_toast_dialog(1)
        sleep(0.75)
        self.ui_toast_dialog.close()


#-------------------------------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#END of ui.py