# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.16"     # qt.core

from calibre.gui2.threaded_jobs import ThreadedJob
from calibre.utils.logging import Log

from polyglot.io import PolyglotStringIO

from queue import Queue

from calibre_plugins.english_noun_frequency.enf_main import main_english_noun_frequency

# ------------------------------------------------------------------------------
#    Functions to perform English Noun Frequency using ThreadedJob
# ------------------------------------------------------------------------------
def start_threaded_enf(self, guidb, plugin_path, book_ids, param_dict, callback):

    job = ThreadedJob('englishnounfrequencyplugin','English Noun Frequency',main_english_noun_frequency,(self,guidb, plugin_path, book_ids, param_dict), {}, callback)
    self.gui.job_manager.run_threaded_job(job)

#END of jobs.py
