# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.16"     # qt.core
from calibre_plugins.english_noun_frequency.enf_polyglot import enf_as_unicode
#------------------------------------------------------------------------------------------------------
def log_heading_common(log,s1,s2,s3,s4,s5):

    import time
    localtime = time.asctime( time.localtime(time.time()) )
    localtime = enf_as_unicode(localtime)
    log(localtime)

    import platform
    log("Python: " + platform.system() + "   " + platform.python_implementation() + "   " + platform.python_version())

    if s1:
        s1 = enf_as_unicode(s1)
        if "00" in s1:
            s1 = s1.replace("00",".")
        log(s1)       #usually SQLite version

    if s2:              #usually PRAGMA statement
        s2 = enf_as_unicode(s2)
        if s2 == "":
            s2 = ""
            log(s2)
            log(" ")
            log("═════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════")
        else:
            log(s2)
            log(" ")

    if s3:
        s3 = enf_as_unicode(s3)
        log(s3)        #usually "Beginning ...."

    if s4:
        s4 = enf_as_unicode(s4)
        log(s4)        #optional

    if s5:
        s5 = enf_as_unicode(s5)
        log(s5)        #optional

    log("═════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════")

#END heading.py