# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.16"     # qt.core

from polyglot.builtins import as_unicode
#-------------------------------------------------------------------------------------------------------------------------------------
def return_english_to_other_language_dict(english_to_other_language_dict_file_path,language,log):

   english_to_other_language_dict = {}

   try:
      #------------------------------------------------------------------------------------------------
      # Retrieve User Custom English to Another Language Translation Pairs File in UTF-8
      #------------------------------------------------------------------------------------------------
      import codecs
      s_filename = english_to_other_language_dict_file_path
      my_infile = codecs.open(s_filename, 'r', "utf-8", 'replace')      #  codecs.open(filename, mode[, encoding[, errors[, buffering]]])
      infile_list = my_infile.readlines()
      my_infile.close()
      #------------------------
      tmp_list1 = []
      for row in infile_list:     #      u'girl' , u'chica' \n
         if row:
            if row > " ":
               line = row
               line = line.strip()
               line = line.replace(" ","")
               line = line.replace("\r","")
               line = line.replace("\n","")  #  u'girl',u'chica'
               line = line.replace("\t","")
               line = line.replace("\v","")
               line = line.strip()
               s = "(" + line + ")"
               s = s.replace("''","'")   # replace double single quotes with a single single quote
               s = s.replace(":",",")    # replace colons with commas (in case the user did not follow directions)
               s = s.replace(","," , ")  #   (u'girl' , u'chica')
               s = s.replace("  "," ")
               tmp_list1.append(s)     #   (u'girl' , u'chica')
            else:
               continue
         else:
            continue
      #END FOR

      for pair in tmp_list1:
         s_split = pair.split(",")
         if s_split:
            if len(s_split) != 2:
               continue
            else:
               k = s_split[0]
               v = s_split[1]
               k = k.replace("(","")
               v = v.replace(")","")
               k = k.strip()
               v = v.strip()
               english_to_other_language_dict[k] = v
               #~ log("english_to_other_language_dict[k] = v  :" + k + "   " + v)
         else:
            continue
      #END FOR
      del tmp_list1
   except Exception as e:
      if language != 'Español':
         log("**************************************************************************************************************")
         log("ERROR in importing the User Custom Translation Mapping File: " + s_filename)
         log("The ERROR was exactly: " + as_unicode(e))
         log("A partial loading may or may not have been possible.")
         log("**************************************************************************************************************")
      else:
         pass   # Spanish is standard in ENF, so it is not an error if the user does not wish to specify a supplemental translation file...

   log(" ")
   log(" ")
   log("Number of User Custom 'English to Other Language' Translation Pairs imported: " + as_unicode(len(english_to_other_language_dict)) )
   log(" ")

   #--------------------------------------------------
   return english_to_other_language_dict
   #--------------------------------------------------

#-------------------------------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------------------
#END OF english_to_other_language_translation_pairs.py