# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.16"     # qt.core

import unicodedata
from polyglot.builtins import as_bytes, unicode_type

#~ ENF is for "English", which was the original basis of ASCII.  Hence, 'ignore'.

def enf_as_unicode(x):
    if isinstance(x, unicode_type):
        return x
    if isinstance(x, bytes):
        x = x.decode('utf-8', 'ignore')
    return unicode_type(x)

def enf_as_bytes(x):
    if isinstance(x, bytes):
        return x
    if isinstance(x, unicode_type):
        x = unicodedata.normalize('NFKD', x).encode('ASCII', 'ignore')        # we want Désirée  to become Desiree, not Dsire ...
        x = as_bytes(x)
        return x
    #~ ...not bytes and not unicode_type...
    ans = enf_as_unicode(x)
    ans = unicodedata.normalize('NFKD', ans).encode('ASCII', 'ignore')      # we want Désirée  to become Desiree, not Dsire ..
    ans = as_bytes(ans)
    return ans


