#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path, sys
from time import sleep
from updater import updateCheck
import options
            
import tkinter as tk
from tkinter import *
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox 
from tkinter import ttk 

LINUX_MACHINE = False
if sys.platform == 'linux' or \
    sys.platform == 'darwin':
    LINUX_MACHINE = True

def show_msgbox(title, msg, msgtype='info'):
    """ For general information, warnings and errors
    """
    localRoot = tk.Tk()
    localRoot.withdraw()
    localRoot.option_add('*font', 'Helvetica -12')
    localRoot.quit()
    if msgtype == 'info':
        return(mbox.showinfo(title, msg))
    elif msgtype == 'warning':
        return(mbox.showwarning(title, msg))
    elif msgtype == 'error':
        return(mbox.showerror(title, msg))

def centeredWindow(self, w, h):
    # get screen width and height
    ws = self.winfo_screenwidth()
    hs = self.winfo_screenheight()
   
    # calculate x and y coordinates for the Tk window
    x = (ws/2) - (w/2)
    y = ((hs/2) - (h/2) - 75)
    return(self.geometry('%dx%d+%d+%d' % (w, h, x, y)))

class SelectDialog(Tk):

    def __init__(self, bk):
        super().__init__()
        self.bk = bk
        self.resizable(width=True, height=True)
        self.minsize(300, 150)
        self.maxsize(800, 700)
        self.title('CombineNCXHeadings')
        centeredWindow(self, 405, 190)
        self.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()
        
    def setup_UI(self):
    
        self.labelf1 = Frame(self)
        self.labelf1.pack(side=TOP, fill=BOTH, expand=True)
        
        #**** create blank space text *****#                
        self.Label1 = Label(self.labelf1, text=" ").grid()
 
        lblSeparator = Label(self.labelf1, 
                        text     = 'Add separator between h1 and h2',
                        font     = ('Helvetica', 11),
                        justify = CENTER 
                        )
        lblSeparator.grid(column=1, sticky=W, row=1, pady=2, padx=25)

        self.var1 = StringVar()
        self.var1.set('space') 
        self.optSeparator = ttk.Combobox(self.labelf1,  textvariable=self.var1, width=9, font=('Helvetica', 11))
        self.optSeparator['values'] = ('space', 'colon', '– endash', '— emdash', '~ tilde')   
        self.optSeparator.current(0)
        self.optSeparator.state(['readonly'])        
        self.optSeparator.grid(column=1, sticky=W, row=1, padx=260, pady=6)          
        
        lblH1Case = Label(self.labelf1, 
                        text     = 'Select word case for h1',
                        font     = ('Helvetica', 11),
                        justify = CENTER 
                        )
        lblH1Case.grid(column=1, sticky=W, row=2, pady=2, padx=25)  
        
        self.var2 = StringVar()
        self.var2.set('As is') 
        self.optH1 = ttk.Combobox(self.labelf1,  textvariable=self.var2, width=9,font=('Helvetica', 11))
        self.optH1['values'] = ('As is', 'capstart', 'titlecase', 'uppercase')   
        self.optH1.current(0)
        self.optH1.state(['readonly'])        
        self.optH1.grid(column=1, sticky=W, row=2, padx=260, pady=6)
        
        lblH2Case = Label(self.labelf1, 
                        text     = 'Select word case for h2',
                        font     = ('Helvetica', 11),
                        justify = CENTER 
                        )
        lblH2Case.grid(column=1, sticky=W, row=3, pady=3, padx=25)  
        
        self.var3 = StringVar()
        self.var3.set('As is') 
        self.optH2 = ttk.Combobox(self.labelf1,  textvariable=self.var3, width=9,font=('Helvetica', 11))
        self.optH2['values'] = ('As is', 'capstart', 'titlecase', 'uppercase')   
        self.optH2.current(0)
        self.optH2.state(['readonly'])        
        self.optH2.grid(column=1, sticky=W, row=3, padx=260, pady=6)
 
        #**** create the OK button *****#
        self.frame1 = Frame(self).pack(side=TOP)        
        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', '11'), background='#E0E0E0', width=20, relief=GROOVE) 
        self.okButton = ttk.Button(self.frame1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        )
        self.okButton.pack(pady=15)     
        
        # adjust window layout for Linux
        if LINUX_MACHINE == True:
            centeredWindow(self, 425, 190) 
            self.optSeparator.grid(padx=280)
            self.optH1.grid(padx=280)
            self.optH2.grid(padx=280)
            
        self.grab_set()
            
    def onOK(self):        
        options.SEPARATOR_CHOICE = self.var1.get()
        options.H1_CASE_CHOICE= self.var2.get()
        options.H2_CASE_CHOICE = self.var3.get()
        self.destroy() 
            
     
    def onCancel(self):
        options.SYS_EXIT = True
        self.destroy() 
    

            
