#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function


#********************************************************************************#
#                                                                                #
# MIT Licence(OSI)                                                               #
# Copyright (c) 2017 Bill Thompson                                               #
#                                                                                #
# Permission is hereby granted, free of charge, to any person obtaining a copy   # 
# of this software and associated documentation files (the "Software"), to deal  # 
# in the Software without restriction, including without limitation the rights   #
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell      #
# copies of the Software, and to permit persons to whom the Software is          #
# furnished to do so, subject to the following conditions:                       # 
#                                                                                #
# The above copyright notice and this permission notice shall be included in all #
# copies or substantial portions of the Software.                                #
#                                                                                # 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR     # 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,       #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE    #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER         # 
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,  # 
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE  # 
# SOFTWARE.                                                                      #
#                                                                                #  
#********************************************************************************#


import os, os.path, sys, shutil, inspect
from tempfile import mkdtemp                  
from cutils import *
from dialog import *
import options
from updater import updateCheck
import tkinter.messagebox as mbox

SITE_URL = "https://www.mobileread.com/forums/showpost.php?p=4011146&postcount=1"
PLUGIN_PATH = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
options.PLUGIN_PATH = PLUGIN_PATH

# borrowed from DiapDealer with thanks    
def is_connected():
    try:
        sock = socket.create_connection(('8.8.8.8', 53), 1)
        sock.close()
        return True
    except:
        pass

    return False    
    
def run(bk): 
    print('Python version: ', sys.version, '\n')
    print('Running CombineNCXHeadings...Please wait\n') 
 
    if is_connected: 
        #check for new plugin versions
        latest_version, installed_version = updateCheck(SITE_URL, PLUGIN_PATH)
        if latest_version and latest_version != installed_version:
            options.NEW_PLUGIN_VERSION = True
            options.MSG_NEW_VERSION_AVAILABLE = "A new plugin version is now available from MR - v" + latest_version     
 
    #create work dir   
    WDIR = mkdtemp()   
    
    fnames = []
    for (id, href) in bk.text_iter():
        html = bk.readfile(id)                
        fnames.append(href)    
    
    # check for blank epub
    if len(fnames) == 1 and fnames[0] == 'Section0001.xhtml':
        msg = 'Epub contains no data. Please try again.'
        print('\n>>> Error: ' + msg + '\n\nAbort plugin...')
        show_msgbox('Unusable Epub', msg, msgtype='error')
        cleanExit(WDIR)
        return(0)

    # input file must be epub - not html
    if len(fnames) == 1:
        msg = 'Only valid epub format is supported by this plugin. Imported html files are not supported.'    
        print('\n>>> Error: ' + msg + '\n\nAbort plugin...')
        show_msgbox('Incorrect File Formet', msg, msgtype='error')       
        cleanExit(WDIR)
        return(0)

    prefs = bk.getPrefs()        
    if 'ignore_titlecase' not in prefs:
        prefs['ignore_titlecase'] = options.IGNORE_TITLECASE
    bk.savePrefs(prefs)
    
    # show plugin dialog
    win_dialog = SelectDialog(bk)
    win_dialog.mainloop()
    
    # process files
    processAllTasks(bk, WDIR)
    
    # inform user if a new plugin version is available
    if options.NEW_PLUGIN_VERSION == True:
        msg = options.MSG_NEW_VERSION_AVAILABLE
        show_msgbox('', msg, msgtype='info') 
        
    print('\n -- Completed SUCCESSFULLY...')
    # remove the temp work dir
    cleanExit(WDIR)
    return(0)                

def main():
    print('I reached main when I should not have\n')
    return(-1)

if __name__ == "__main__":
    sys.exit(main())    