#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path, sys, shutil
import options
import time
from six.moves.html_parser import HTMLParser
import tkinter as tk
import tkinter.messagebox as mbox
from string import capwords

try:
    from sigil_bs4 import BeautifulSoup, Comment, Tag
except:
    from bs4 import BeautifulSoup, Comment, Tag
    

def processAllTasks(bk, wdir):

    filenames, ncx_headings = getNCXHeadingList(bk, wdir)
    createNCXFile(bk, wdir, ncx_headings, filenames)
    
    return(0)

def getNCXHeadingList(bk, wdir):
    ncx_headings = []
    fnames = []
    
    for (id, href) in bk.text_iter():
        html = bk.readfile(id)
        soup = BeautifulSoup(html, 'html.parser')
        
       #---------------------------------------#    
       # gather the modified ncx headings into #  
       # an appropriate ncx heading list       #
       #---------------------------------------#
       
        h1_string = ''
        h2_string = ''
        h3_string = ''
        h4_string = ''
        h5_string = ''
        
        # get the h1 tag from the current file
        for tag in soup.find_all('h1', limit=1):
            h1_string = tag.get_text() 
                
        # get the h2 tag from the current file, if any        
        for tag in soup.find_all('h2', limit=1):        
            h2_string = tag.get_text()
            
        # combine the h1 and h2 headings with a
        # separator and add it to an ncx heading list  
        if h1_string and h2_string:              
            h1_str, h2_str, separator = applyUserOptions1(bk, h1_string, h2_string)
            if separator == ' ':
                ncx_headings.append(h1_str + separator + h2_str)
            elif separator == ':':
                ncx_headings.append(h1_str + separator + ' ' + h2_str)
            else:                
                ncx_headings.append(h1_str + ' ' + separator + ' ' + h2_str)
            fnames.append(href)
            
        # add lone h1 headings as normal with word case formatting    
        elif h1_string and not h2_string:
            h1_str = applyUserOptions2(bk, h1_string)                
            ncx_headings.append(h1_str)
            fnames.append(href)
             
        # add sub-headings as well    
        search_str = ['h3','h4','h5','h6']     
        for tag in soup.find_all(search_str):
            head_str = tag.get_text()
            ncx_headings.append(head_str)
            if tag.has_attr('id') and tag['id'] != None:
                id = tag['id']
                fnames.append(href + '#' + id)
            else:
                fnames.append(href)
            
    print('\nLast NCX headings...' + str(ncx_headings))   
    #time.sleep(100)    
    return(fnames, ncx_headings)    
    
def createNCXFile(bk, wdir, ncx_headings, filenames):
    print(' -- Create the toc.ncx XML file')
    uuid, title = getOPFMetadata(bk)
    if title == None:
        title = ''
    if uuid == None:
        uuid = ''    
    options.TITLE = title
    options.UUID = uuid
    
    outf = os.path.join(wdir, 'toc.ncx')
    with open(outf, 'wt', encoding=('utf-8')) as outfp:  
        outfp.write('<?xml version="1.0" encoding="utf-8" ?>\n')
        outfp.write('<!DOCTYPE ncx PUBLIC "-//NISO//DTD ncx 2005-1//EN"\
         "http://www.daisy.org/z3986/2005/ncx-2005-1.dtd"><ncx version="2005-1" \
        xmlns="http://www.daisy.org/z3986/2005/ncx/">\n')
        
        outfp.write('  <head>\n')
        outfp.write('    <meta content="' + uuid + '" name="dtb:uid"/>\n')
        outfp.write('    <meta content="1" name="dtb:depth"/>\n')
        outfp.write('    <meta content="0" name="dtb:totalPageCount"/>\n')
        outfp.write('    <meta content="0" name="dtb:maxPageNumber"/>\n')
        outfp.write('  </head>\n')
        outfp.write('  <docTitle>\n')
        outfp.write('    <text>' + title + '</text>\n')
        outfp.write('  </docTitle>\n')
        outfp.write('  <navMap>\n')
        

        i = 1
        j = 0        
        for chap_title in ncx_headings:
            outfp.write('    <navPoint id="navPoint-' + str(i) + '" playOrder="' + str(i) + '">\n')
            outfp.write('      <navLabel>\n')
            outfp.write('        <text>' + chap_title + '</text>\n')
            outfp.write('      </navLabel>\n')
            outfp.write('      <content src="' + filenames[j] + '"/>\n')
            outfp.write('    </navPoint>\n')
            i = i + 1
            j = j + 1
            
        outfp.write('  </navMap>\n')
        outfp.write('</ncx>')
        
    # copy the toc.ncx file back to the epub
    with open(os.path.join(wdir, 'toc.ncx'), 'rt', encoding='utf-8') as fp:        
        data = fp.read()
        bk.writefile(bk.gettocid(), data)
        
    #time.sleep(200)
    return(0)

def getOPFMetadata(bk):    
    uuid = ''
    title = ''
    
    data = bk.getmetadataxml()
    lines = data.splitlines(True)
    for line in lines:
        if 'dc:identifier' in line:
            xml = BeautifulSoup(line, 'xml')
            uuid = xml.get_text()
            
        if 'dc:title' in line:
            xml = BeautifulSoup(line, 'xml')
            title = xml.get_text()    
       
    return(uuid, title)
  
def show_msgbox(title, msg, msgtype='info'):
    """ For general information, warnings and errors
    """
    localRoot = tk.Tk()
    localRoot.withdraw()
    localRoot.option_add('*font', 'Helvetica -12')
    localRoot.quit()
    if msgtype == 'info':
        return(mbox.showinfo(title, msg))
    elif msgtype == 'warning':
        return(mbox.showwarning(title, msg))
    elif msgtype == 'error':
        return(mbox.showerror(title, msg))    
        
def cleanExit(wdir):
    """ Clean up and remove all work directories and files """
    shutil.rmtree(wdir, ignore_errors=True)
    return(0)   
    
def svgAttributes2CamelCase(wdir, file):
    file = os.path.join(wdir, file)
    file = os.path.join(wdir, os.path.basename(file))       
    output = os.path.join(wdir, 'reformat.html')
    outfp = open(output, 'wt', encoding='utf-8')
    html = open(file, 'rt', encoding='utf-8').read()

    soup = BeautifulSoup(html, 'html.parser')
    
    for svg in soup.find_all('svg'):
    
        # reformat the par to camel case
        if svg.has_attr('preserveaspectratio'):
            par = svg['preserveaspectratio']
            del svg['preserveaspectratio']
            svg['preserveAspectRatio'] = par
        
        # reformat the vb to camel case
        if svg.has_attr('viewbox'):
            vb = svg['viewbox']
            del svg['viewbox']
            svg['viewBox'] = vb
               
    outfp.writelines(str(soup.prettyprint_xhtml(indent_level=0, eventual_encoding="utf-8", formatter="minimal", indent_chars="  ")))
    outfp.close()
    os.remove(file)
    os.rename(output, file)        
    return(0)        
 
def applyUserOptions1(bk, h1string, h2string):
    h1str = ''
    h2str = ''
    separator = ''
    
    # style h1 with the user's choice of word case
    if options.H1_CASE_CHOICE == 'capstart':
        h1str = convert2Capstart(h1string)  
    elif options.H1_CASE_CHOICE == 'uppercase':
        h1str = h1string.upper()
    elif options.H1_CASE_CHOICE == 'titlecase':
        h1str = convert2TitleCase(bk, h1string)
    elif options.H1_CASE_CHOICE == 'As is':
        h1str = h1string              
    
    # style h2 with the user's choice of word case
    if options.H2_CASE_CHOICE == 'capstart':
        h2str = convert2Capstart(h2string)  
    elif options.H2_CASE_CHOICE == 'uppercase':
        h2str = h2string.upper()
    elif options.H2_CASE_CHOICE == 'titlecase':
        h2str = convert2TitleCase(bk, h2string)
    elif options.H2_CASE_CHOICE == 'As is':
        h2str = h2string
    
    # add user's choice of separator
    if options.SEPARATOR_CHOICE == 'space':
        separator = ' '
    if options.SEPARATOR_CHOICE == 'colon':
        separator = ': '    
    elif options.SEPARATOR_CHOICE == '- dash':
        separator = '-'
    elif options.SEPARATOR_CHOICE == '– endash':
        separator = '–'
    elif options.SEPARATOR_CHOICE == '— emdash':
        separator = '—'  
    elif options.SEPARATOR_CHOICE == '~ tilde':
        separator = '~'     
         
    return(h1str, h2str, separator)     
    
def applyUserOptions2(bk, h1string):
    h1str = ''

    # style h1 with the user's choice of word case
    if options.H1_CASE_CHOICE == 'capstart':
        h1str = convert2Capstart(h1string)  
    elif options.H1_CASE_CHOICE == 'uppercase':
        h1str = h1string.upper()
    elif options.H1_CASE_CHOICE == 'titlecase':
        h1str = convert2TitleCase(bk, h1string)
    elif options.H1_CASE_CHOICE == 'As is':
        h1str = h1string  
    
    return(h1str)         
                
def convert2TitleCase(bk, strng):
    # convert word strings to title case
    prefs = bk.getPrefs()
    
    text = str()
    if strng != '' or strng != None:
        strg_list = strng.lower().split()                # create a word list from the string and convert to lower case
        strg_list[0] = strg_list[0].title()              # convert the first word only to titlecase 
        new_list = []     
        for i, word in enumerate(strg_list, 1):          # process all after the first word
            if word in str(prefs['ignore_titlecase']):   # if word in ignore_titlecase list don't convert to titlecase
                new_list.append(word)
            else:
                word = word.title()
                new_list.append(word)
        text = " ".join(new_list)                        # convert the list back to a string
    else:
        text = ''
   
    bk.savePrefs(prefs)
    return(text)    

def convert2Capstart(strng):
    # just capitalize the first char
    # of the first word in the string.
    strng = strng.lower() 
    text = strng.split()         
    text[0]= text[0].title() 
    s = " ".join(text)       

    return(s)