# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.7"  #Qt.core

from qt.core import QMenu, QDialog, QIcon, QAction

from functools import partial

from calibre.constants import DEBUG
from calibre.gui2.actions import InterfaceAction

from polyglot.builtins import iteritems

from calibre_plugins.library_splitter.common_utils import set_plugin_icon_resources, get_icon,create_menu_action_unique

PLUGIN_ICONS = ['images/split.png']

#-------------------------------------------------------------------------------------------
class ActionLibrarySplitter(InterfaceAction):

    name = 'Library Splitter'
    action_spec = ('LS','images/split.png', "Front-end to Calibre's Copy/Move Book functions.  Automatically copies or moves books from the current library to a target library based on each book's metadata value in a '#target_library' Custom Column.", None)
    action_type = 'global'
    accepts_drops = False
    auto_repeat = False
    priority = 9
    popup_type = 1

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def genesis(self):
        icon_resources = self.load_resources(PLUGIN_ICONS)
        set_plugin_icon_resources(self.name, icon_resources )

        self.menu = QMenu(self.gui)
        self.build_menus(self.gui)

        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.qaction.triggered.connect(self.library_splitter_control)

        self.gui.keyboard.finalize()
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def initialization_complete(self):
        self.guidb = self.gui.library_view.model().db

        self.copytolibraryaction_object = None

        for k,v in iteritems(self.gui.iactions):
            if "Copy To Library" in k:
                self.copytolibraryaction_object = v
                break
        #END FOR

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def library_changed(self,guidb):
        self.guidb = self.gui.library_view.model().db
        try:
            self.librarysplitterdialog.close()
        except:
            pass
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def build_menus(self,gui):
        self.gui = gui
        m = self.menu
        m.clear()
        unique_name = "Library Splitter"
        shortcut_name = "Library Splitter"
        create_menu_action_unique(self, m, 'Library Splitter', 'images/split.png',shortcut=None,
                                                      triggered=partial(self.library_splitter_control), is_checked=None,
                                                      shortcut_name=shortcut_name,unique_name=unique_name,
                                                      favourites_menu_unique_name=unique_name)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def library_splitter_control(self):
        try:
            self.librarysplitterdialog.close()
        except:
            pass
        if not self.copytolibraryaction_object:
            if DEBUG: print("Fatal error: copytolibraryaction_object was not found.")
            return
        self.guidb = self.gui.library_view.model().db
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        from calibre_plugins.library_splitter.library_splitter_dialog import LibrarySplitterDialog
        self.librarysplitterdialog = LibrarySplitterDialog(self.gui,self.qaction.icon(),self.guidb,self.exit_dialog,self.copytolibraryaction_object)
        self.librarysplitterdialog.show()
        del LibrarySplitterDialog
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def exit_dialog(self):
        self.librarysplitterdialog.close()
   #-----------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#END of ui.py