# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.7"  #Qt.core

from calibre.customize import InterfaceActionBase

class ActionBaseLibrarySplitter(InterfaceActionBase):

    name                    = 'Library Splitter'
    description           = "Front-end to Calibre's Copy/Move Book functions.  Automatically copies or moves books from the current library to a target library based on each book's metadata value in a '#target_library' Custom Column."
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 0, 7)
    minimum_calibre_version = (6, 0, 0)

    actual_plugin       = 'calibre_plugins.library_splitter.ui:ActionLibrarySplitter'

    gui_name = 'Library Splitter'

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):
        pass
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return False
    #--------------------------------------------------------------------------------------------------------------------------
#END of __init__py