# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "2.0.46"  # apsw_attach_to_source: added debug statements

from qt.core import (Qt, QDialog, QFileDialog, QObject, QApplication,
                                        QLabel, QHBoxLayout, QWidget, QPushButton, QRegularExpression,
                                        QTextEdit, QListWidget, QListWidgetItem, QComboBox, QSize,
                                        QGridLayout, QTabWidget, QVBoxLayout, QScrollArea, QLayout,
                                        QPalette, QColor, QMargins, QSizePolicy, QAbstractItemView, QTextOption,
                                        QIcon, QGroupBox, QSpacerItem, QLineEdit, QDialogButtonBox,
                                        QCheckBox, QRadioButton, QButtonGroup, QToolTip, QFont, QFontDatabase )
import os,sys
import apsw
import ast
import codecs
import collections
from contextlib import contextmanager
from copy import deepcopy
import datetime
from datetime import datetime
from functools import partial
import re
import time
from time import sleep
import unicodedata
import zipfile

from calibre import isbytestring
from calibre.constants import filesystem_encoding, iswindows, DEBUG
from calibre.gui2 import FileDialog, gprefs
from calibre.gui2 import error_dialog, info_dialog, question_dialog
from calibre.utils.config import JSONConfig

from polyglot.builtins import as_bytes, as_unicode, iteritems, map, only_unicode_recursive, range, unicode_type

from calibre_plugins.consolidate_all_library_metadata.config import prefs
from calibre_plugins.consolidate_all_library_metadata.config import ConfigWidget
from calibre_plugins.consolidate_all_library_metadata.calm_cli_custom_columns import calm_cli_add_custom_column
from calibre_plugins.consolidate_all_library_metadata.cc_activation_list_editor import CCActivationListEditor
from calibre_plugins.consolidate_all_library_metadata.cc_activation_list_editor_ui import Ui_CCActivationListEditor
from calibre_plugins.consolidate_all_library_metadata.tag_rules_list_editor import TagRulesListEditor
from calibre_plugins.consolidate_all_library_metadata.tag_rules_list_editor_ui import Ui_TagRulesListEditor
from calibre_plugins.consolidate_all_library_metadata.tag_rules_list_editor_2 import TagRulesListEditor2
from calibre_plugins.consolidate_all_library_metadata.tag_rules_list_editor_ui_2 import Ui_TagRulesListEditor2
from calibre_plugins.consolidate_all_library_metadata.ui_toastdialog import UIToastDialog

ERROR_MESSAGE_TARGET_LIBRARY_CUSTOM_COLUMN_NEVER_GENERATED = "ERROR: This CALM Target Library has a Custom Column that was <b>not</b> Generated."

WORKING_MESSAGE_0 = "WORKING"
WORKING_MESSAGE_1 = "......WORKING......"

CC_GENERATION_FALSE_MESSAGE = "...NEVER..."

ERROR_MESSAGE_METADATA_TOOLS_DB_FILE_IS_MISSING = "ERROR: 'metadata_tools.db' file is missing.<br><br>If you <b>already</b> have extracted the Target Library, then you <b>must<b/> 'Delete the Entire CALM Directory'.   Keep a backup of your customized metadata_tools.db so you do not lose your customizations.<br><br><b>Regardless, you must 'Extract a Fresh Copy of the Special CALM Library' before using this Tab.</b>"

MOST_CURRENT_VERSION_OF_METADATA_TOOLS = as_unicode(2)     # as of:  October 2015 - newly released version 2.0.0 of CALM

MSG_NEW_USER = "Some important things that you need to know before continuing: \
            <br><br>[1] The 'User Guide' is decentralized within the various Tabs of CALM.\
            <br><br>[2] The 'ToolTips have useful and necessary information to learn.  Do not 'turn off' ToolTips within Calibre > Preferences.\
            <br><br>[3] The 'Source Libraries' Tab is where you select All or Some of your Calibre Libraries for Consolidation into the 'Target Library'.\
            <br><br>[4] The 'Target Library' Tab where you create your 'Target Library' that will be the 'target' of the Consolidation process.  It also has additional important information to read as soon as possible.\
            <br><br>[5] The 'Source Custom Columns' Tab is where you decide whether All, Some, or No Custom Columns should be Consolidated into the 'Target Library'. \
            <br><br>[6] The 'Metadata Tools' Tab is used AFTER you have finished running the Consolidation process.\
            <br><br>[7] The 'Library Tools' Tab is used AFTER you have finished running the Consolidation process.\
            <br><br>[8] The 'FAQ' Tab has information about both the 'Metadata Tools' Tab and the 'Library Tools' Tab."


disallowed_custom_column_labels_list = []
disallowed_custom_column_labels_list.append("work_series_full")  # text but not normalized; unsupported by standard Calibre; used only by QuarantineAndScrub.

DB_PREFS_NAMESPACE = 'CALMPlugin'
DB_PREFS_KEY_SETTINGS = 'CALMTargetDBSettings'
DB_PREFS_FULL_KEY = "namespaced:CALMPlugin:CALMTargetDBSettings"

CALM_HIGHEST_OWN_CUSTOM_COLUMN_ID = int(16)           # the 'standard' custom_columns in the Target currently end at id = 16.      # source_cover is 16; source_format_types is 15;

#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):

    initial_extra_size = QSize(10, 10)

    def __init__(self, parent, unique_pref_name):
        QDialog.__init__(self, parent)
        self.unique_pref_name = unique_pref_name
        self.geom = gprefs.get(unique_pref_name, None)

    def resize_dialog(self):
        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
        else:
            self.restoreGeometry(self.geom)

    def save_dialog_geometry(self):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_name] = geom
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class CALMDialog(SizePersistedDialog):

    #-----------------------------------------------------------------------------------------------
    def __init__(self,gui,icon,guidb,plugin_path,calm_dialog_restart_immediately,calm_consolidation_job_control,calm_derivegenres_job_control):
        parent = gui
        unique_pref_name = 'consolidate_all_library_metadata:gui_parameters_dialog'
        SizePersistedDialog.__init__(self, parent, unique_pref_name)
        #-----------------------------------------------------
        self.gui = gui
        self.guidb = guidb
        #-----------------------------------------------------
        self.icon = icon         #  == self.qaction.icon()
        #-----------------------------------------------------
        self.plugin_path = plugin_path
        #-----------------------------------------------------
        self.calm_dialog_restart_immediately = calm_dialog_restart_immediately
        #-----------------------------------------------------
        self.calm_consolidation_job_control = calm_consolidation_job_control
        #-----------------------------------------------------
        self.calm_derivegenres_job_control = calm_derivegenres_job_control
        #-----------------------------------------------------
        #~ Calibre Release 3.0.0 deprecated the use of calibredb while the GUI is also running
        if 'GUI_METADATA_TOOLS_LAST_SOURCES_OPF_BACKUP_DATETIME' in prefs:
            del prefs['GUI_METADATA_TOOLS_LAST_SOURCES_OPF_BACKUP_DATETIME']
            prefs
        if 'GUI_METADATA_TOOLS_LAST_SOURCES_OPF_BACKUP_COUNT' in prefs:
            del prefs['GUI_METADATA_TOOLS_LAST_SOURCES_OPF_BACKUP_COUNT']
            prefs
        if 'SHUFFLE_BOOKS_LAST_CHOSEN_LIBRARY_DIRECTORY' in prefs:
            del prefs['SHUFFLE_BOOKS_LAST_CHOSEN_LIBRARY_DIRECTORY']
            prefs
        #----------------------------------------------------
        self.myparentprefs = collections.OrderedDict([])
        prefsdefaults = deepcopy(prefs.defaults)
        self.calm_target_library_db_namespaced_prefs = deepcopy(prefs.defaults)
        tmp_list = []
        #~ for k,v in prefs.iteritems():
        for k,v in iteritems(prefs):
            tmp_list.append(k)
        #END FOR
        #~ for k,v in prefsdefaults.iteritems():
        for k,v in iteritems(prefsdefaults):
            tmp_list.append(k)
        #END FOR
        tmp_set = set(tmp_list)
        tmp_list = list(tmp_set)  #no duplicates
        del tmp_set
        tmp_list.sort()
        for k in tmp_list:
            self.myparentprefs[k] = " "  # ordered by key
        #END FOR
        del tmp_list
        #~ for k,v in prefs.iteritems():
        for k,v in iteritems(prefs):
            self.myparentprefs[k] = v
        #END FOR
        #~ for k,v in prefsdefaults.iteritems():
        for k,v in iteritems(prefsdefaults):
            if not k in prefs:
                prefs[k] = v
            else:
                if not prefs[k] > " ":
                    prefs[k] = v
            if not k in self.myparentprefs:
                self.myparentprefs[k] = v
            else:
                if not self.myparentprefs[k] > " ":
                    self.myparentprefs[k] = v
        #END FOR

        self.current_library_is_a_target_library = False
        is_true = self.confirm_current_guidb_path_not_calm()
        if not is_true:
            self.current_library_is_a_target_library = True
            if self.current_library_is_a_target_library:
                s = prefs['CALM_TARGET_DB_GENERATING_NONCALM_LIBRARY_PATH']
                if not "ZZ:" in s:
                    self.maintain_target_library_namespaced_db_preferences("transfer_once")
                self.maintain_target_library_namespaced_db_preferences("load")
        else:
            pass

        #~ for k,v in self.myparentprefs.iteritems():
        for k,v in iteritems(self.myparentprefs):
            prefs[k] = v
        #END FOR
        prefs  #prefs now synched

        if DEBUG:
            #~ for k,v in self.myparentprefs.iteritems():
            for k,v in iteritems(self.myparentprefs):
                if k.count("CALM") > 0:  # db related...
                    print(k,v)   # in key order...
            #END FOR

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.last_tab_selected = 0
        #-----------------------------------------------------
        self.gprefs = gprefs
        #-----------------------------------------------------
        self.param_dict = collections.OrderedDict([])
        #-----------------------------------------------------
        self.target_db = "/CALM/metadata.db"
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.init_tooltips_for_parent()
        self.setToolTip(self.parent_tooltip_00)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #0: CALMSourceLibrariesTab
        #-----------------------------------------------------
        self.qt_source_tab_qcheckbox_objects_dict = {}
        self.qt_source_tab_qlineedit_objects_dict = {}
        #-----------------------------------------------------
        from calibre_plugins.consolidate_all_library_metadata.calm_dialog import CALMSourceLibrariesTab
        self.CALMSourceLibrariesTab = CALMSourceLibrariesTab(self.gui,self.myparentprefs,prefsdefaults,self.gprefs,self.param_dict,
                                                                                                        self.child_invocation_of_save_real_prefs_parent,
                                                                                                        self.qt_source_tab_qcheckbox_objects_dict,
                                                                                                        self.qt_source_tab_qlineedit_objects_dict)

        self.save_current_list_of_source_libraries = self.CALMSourceLibrariesTab.save_current_list_of_source_libraries

        self.return_latest_source_prefs = self.CALMSourceLibrariesTab.return_latest_source_prefs

        self.myparentprefs = self.return_latest_source_prefs(self.myparentprefs)        # includes prefs additions & changes made by that Tab upon its init

        del prefsdefaults

        #-----------------------------------------------------
        parent_pointer = self  # children can then parent_pointer.close().  this must be freshly set immediately prior to initing a child tab, because 'self' is changing...
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #1: CALMTargetTab
        #-----------------------------------------------------
        from calibre_plugins.consolidate_all_library_metadata.calm_dialog import CALMTargetTab
        self.CALMTargetTab = CALMTargetTab(parent_pointer,self.gui,self.guidb,self.myparentprefs,self.gprefs,self.plugin_path,
                                                                        self.target_db,self.create_new_sqlite_objects_in_tools_db,
                                                                        self.child_invocation_of_save_real_prefs_parent,self.child_invocation_of_set_current_tab_index,
                                                                        self.child_invocation_to_set_source_libraries_read_only,self.calm_dialog_restart_immediately,
                                                                        self.child_invocation_to_retrieve_most_current_parent_prefs)

        self.return_target_db = self.CALMTargetTab.return_target_db

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #2: CALMCustomColumnsTab
        #-----------------------------------------------------
        from calibre_plugins.consolidate_all_library_metadata.calm_dialog import CALMCustomColumnsTab
        self.CALMCustomColumnsTab = CALMCustomColumnsTab(self.gui,self.guidb,self.target_db,self.myparentprefs,
                                                                                                            self.create_new_sqlite_objects_in_tools_db,
                                                                                                            self.child_invocation_of_save_real_prefs_parent,
                                                                                                            self.child_invocation_to_retrieve_most_current_parent_prefs)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        parent_pointer = self  # children can then parent_pointer.close().  this must be freshly set immediately prior to initializing a child tab, because 'self' is changing...
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #3: CALMToolsTab
        #-----------------------------------------------------
        from calibre_plugins.consolidate_all_library_metadata.calm_dialog import CALMToolsTab
        self.CALMToolsTab = CALMToolsTab(parent_pointer,self.gui,self.guidb,self.target_db,self.myparentprefs,
                                                                        self.create_new_sqlite_objects_in_tools_db,self.execute_calm_derivegenres,
                                                                        self.child_invocation_of_save_real_prefs_parent,
                                                                        self.child_invocation_of_set_current_tab_index,
                                                                        self.calm_dialog_restart_immediately)

        self.return_latest_tools_prefs = self.CALMToolsTab.return_latest_tools_prefs

        self.myparentprefs = self.return_latest_tools_prefs(self.myparentprefs)                  # includes prefs additions & changes made by that Tab upon its init

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab # None (was 4): CALMShuffleTab
        #-----------------------------------------------------
        #~ Calibre Release 3.0.0 deprecated the use of calibredb while the GUI is also running, which the CALMShuffleTab heavily used in complex ways.
        #~ Users must now do the shuffling of books around their many Calibre libraries in their ecosystem manually. Sorry.
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #4 (was 5): CALMFAQTab
        #-----------------------------------------------------
        from calibre_plugins.consolidate_all_library_metadata.calm_dialog import CALMFAQTab
        self.CALMFAQTab = CALMFAQTab()
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #    Parent             CALMDialog
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(10)

        tablabel_font = QFont()
        tablabel_font.setBold(False)
        tablabel_font.setPointSize(10)

        #-----------------------------------------------------
        self.setWindowTitle('CALM: Consolidate All Library Metadata')
        self.setWindowIcon(icon)
        #-----------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.layout_frame.setAlignment(Qt.AlignLeft)
        self.setLayout(self.layout_frame)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        n_width = 800

        self.CALMtabWidget = QTabWidget()
        #~ self.CALMtabWidget.setMinimumWidth(n_width)
        #~ self.CALMtabWidget.setMaximumWidth(n_width)
        self.CALMtabWidget.setFont(tablabel_font)

        self.CALMtabWidget.addTab(self.CALMSourceLibrariesTab,"Source Libraries")
        self.CALMSourceLibrariesTab.setToolTip("<p style='white-space:wrap'>This Tab controls what the consolidation 'Source Libraries' are to be.  All of these 'Source Libraries' will be 'Generated' by the 'Target Tab' regardless of whether they are checked or unchecked.  However, only currently checked Source Libraries will be considered by the Consolidation Job.")
        #~ self.CALMSourceLibrariesTab.setMaximumWidth(n_width)

        self.CALMtabWidget.addTab(self.CALMTargetTab,"Target Library")
        self.CALMTargetTab.setToolTip("<p style='white-space:wrap'>This Tab is used to specify where the consolidation 'Target Library' is to be, Generates the Source Custom Columns, and has instructions for this Tab, including the Consolidation Job.")
        #~ self.CALMTargetTab.setMaximumWidth(n_width)

        self.CALMtabWidget.addTab(self.CALMCustomColumnsTab,"Source Custom Columns")
        self.CALMCustomColumnsTab.setToolTip("<p style='white-space:wrap'>This Tab controls whether All, Some or No 'Source Custom Columns' should be consolidated by the Consolidation Job.  ")
        #~ self.CALMCustomColumnsTab.setMaximumWidth(n_width)

        self.CALMtabWidget.addTab(self.CALMToolsTab,"Metadata Tools")
        self.CALMToolsTab.setToolTip("<p style='white-space:wrap'>This Tab is used to change metadata in the 'Target Library' and then to propagate those changes to the 'Source Libraries'.")
        #~ self.CALMToolsTab.setMaximumWidth(n_width)

        self.CALMtabWidget.addTab(self.CALMFAQTab,"FAQs")
        self.CALMFAQTab.setToolTip("<p style='white-space:wrap'>This Tab displays 'Frequently Asked Questions' about the 'Metadata Tools' and the 'Library Tools' Tabs.")
        #~ self.CALMFAQTab.setMaximumWidth(n_width)

        #-----------------------------------------------------
        self.layout_frame.addWidget(self.CALMtabWidget)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.CALMtabWidget.currentChanged.connect(self.event_tab_index_changed)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.bottom_buttonbox = QDialogButtonBox()
        self.bottom_buttonbox.setOrientation(Qt.Horizontal)
        self.bottom_buttonbox.setCenterButtons(True)

        self.layout_frame.addWidget(self.bottom_buttonbox,1)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_execute_all = QPushButton(" ", self)
        self.push_button_execute_all.setText("Execute [Consolidate Selected Libraries]")
        self.push_button_execute_all.clicked.connect(self.execute_calm_consolidation)
        self.push_button_execute_all.setFont(font)
        self.push_button_execute_all.setToolTip("<p style='white-space:wrap'>Execute the Job for All Saved and Selected (checked) Libraries")
        self.bottom_buttonbox.addButton(self.push_button_execute_all,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_exit_with_save = QPushButton("Save && Exit")
        self.push_button_exit_with_save.clicked.connect(self.calm_exit_with_save)
        self.push_button_exit_with_save.setDefault(False)
        self.push_button_exit_with_save.setToolTip("<p style='white-space:wrap'>Exit after saving any changes to user settings plus other related information.")
        self.bottom_buttonbox.addButton(self.push_button_exit_with_save,QDialogButtonBox.AcceptRole)

        self.push_button_exit_without_save = QPushButton("Exit")
        self.push_button_exit_without_save.clicked.connect(self.calm_exit_without_save)
        self.push_button_exit_without_save.setDefault(False)
        self.push_button_exit_without_save.setToolTip("<p style='white-space:wrap'>Exit Immediately without saving anything.")
        self.bottom_buttonbox.addButton(self.push_button_exit_without_save,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------

        self.resize_dialog()      # inherited from SizePersistedDialog

        #-----------------------------------------------------
        self.suppress_multiple_target_libraries_message = False
        #-----------------------------------------------------
        try:
            n = prefs['GUI_LAST_TAB_USED']
            n = int(n)
            self.myparentprefs['GUI_LAST_TAB_USED'] = prefs['GUI_LAST_TAB_USED']
        except:
            n = 1
            self.myparentprefs['GUI_LAST_TAB_USED'] = unicode_type('1')
            prefs['GUI_LAST_TAB_USED'] = unicode_type('1')

        if n == 0:  # Source Libraries tab
            self.push_button_execute_all.hide()
            self.push_button_exit_with_save.hide()  # must use the Tab's special "Save" button to save the Source Libraries...
            self.push_button_exit_without_save.hide()

        self.already_set_sources_read_only = False
        try:
            if self.myparentprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] ==  unicode_type(1) :
                self.set_source_libraries_read_only(True)
                self.already_set_sources_read_only = True
                if n == 0:     #never start in the Source Libraries tab after a successful generation
                    n = 1
        except:
            pass

        self.current_target_library_is_read_only = False

        if as_unicode(self.myparentprefs['CALM_DB_VERSION_METADATA_TOOLS_DB']) != MOST_CURRENT_VERSION_OF_METADATA_TOOLS:
            self.myparentprefs['CALM_TARGET_DB_MUST_BE_REFRESHED'] = unicode_type("True")

        if self.myparentprefs['CALM_TARGET_DB_MUST_BE_REFRESHED'] == unicode_type("True"):
            n = 1   # Always go straight to the Target Tab at startup if the above is true.

        self.CALMtabWidget.setCurrentIndex(n)

        try:
            self.age_of_current_target_library = 0
            if self.current_library_is_a_target_library:
                if as_unicode(self.current_target_library_path) == as_unicode(prefs['CALM_TARGET_DB_FULL_PATH']):
                    todays_date = datetime.strftime(datetime.now(), '%Y-%m-%d')
                    generated_date = prefs['GUI_LAST_UPDATE_DATETIME_TARGET']        # example:  "2015-12-26 09:20:59"
                    generated_date = generated_date[0:11].strip()
                    todays_date1 = datetime.strptime(todays_date, "%Y-%m-%d").date()
                    generated_date1 = datetime.strptime(generated_date, "%Y-%m-%d").date()
                    self.age_of_current_target_library =  (todays_date1 - generated_date1).days
                    if DEBUG: print("today, generated, age in days: ", todays_date, " - ", generated_date, " = ", as_unicode(self.age_of_current_target_library))
                    #~ self.age_of_current_target_library = 7
                    n_age = int(self.age_of_current_target_library)
                    if  n_age > 6:
                        if n_age % 2 != 0:   # display on only odd-number ages so as to not annoy...
                            if prefs['GUI_TARGET_DB_AGE_MESSAGE_LAST_DISPLAYED'] < todays_date:        # display this message no more than once per day...
                                prefs['GUI_TARGET_DB_AGE_MESSAGE_LAST_DISPLAYED'] = unicode_type(todays_date)
                                prefs
                                msg = "This CALM Target Library was generated " + as_unicode(self.age_of_current_target_library) + " days ago.  If you have made any significant changes to your Source Library metadata, including adding or deleting books, you should create (i.e., Refresh, Generate, then Consolidate) a new CALM Target Library."
                                info_dialog(self.gui, _("Information: This Most-Recent CALM Target Library's Age"), _(msg), show=True)
        except Exception as e:
            if DEBUG: print("Exception in calculating self.age_of_current_target_library: ", as_unicode(e))
            pass
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def enable_qtabwidget_tabs(self,tab,enable):
        self.CALMtabWidget.setTabEnabled(tab, enable)  #disable the Source Custom Columns tab...
        self.update()
        QApplication.instance().processEvents()
    #-----------------------------------------------------------------------------------------------
    # EVENTS
    #-----------------------------------------------------------------------------------------------
    def event_tab_index_changed(self,event):

        n = self.CALMtabWidget.currentIndex()

        if self.myparentprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS'] == unicode_type("True"):
            pass   # metadata_tools.db sqlite objects upgrade is already in process
        else:
            if self.myparentprefs['CALM_TARGET_DB_MUST_BE_REFRESHED'] == unicode_type("True"):
                if (self.myparentprefs['CALM_TARGET_PARENT_DIRECTORY'] == unicode_type('ZZ:') or
                    self.myparentprefs['CALM_TARGET_DB_FULL_PATH'] == unicode_type('ZZ:') or
                    self.myparentprefs['CALM_TARGET_DB_LAST_CHOSEN_LIBRARY_DIRECTORY'] == unicode_type('ZZ:')) :
                    if self.myparentprefs['CALM_USER_STATUS'] != unicode_type('USER'):
                        if question_dialog(self.gui, _('CALM'),_('Are you a NEW user of CALM who has NEVER previously installed CALM<br><brr> and has NEVER clicked its icon (even once) before?')) :
                            # NEW USERS
                            self.myparentprefs['CALM_USER_STATUS'] = unicode_type("NEW")
                            self.myparentprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS'] = unicode_type("True")
                            self.myparentprefs['CALM_DB_VERSION_METADATA_TOOLS_DB'] = unicode_type(MOST_CURRENT_VERSION_OF_METADATA_TOOLS)
                            self.myparentprefs['CALM_TARGET_DB_MUST_BE_REFRESHED'] = unicode_type("True")
                            self.mini_save_real_prefs_parent()
                            info_dialog(self.gui, _("CALM - User Helpful Information"), _(MSG_NEW_USER), show=True)
                            info_dialog(self.gui, _("CALM - Very First Task"), _("Your first task must be to identify the 'permanent' directory for your new CALM Target Library.  Please do so in the Target Library tab."), show=True)
                        else:
                            # OLD USERS who had a bad .json file
                            self.myparentprefs['CALM_TARGET_DB_MUST_BE_REFRESHED'] = unicode_type("True") #previous user with tools db to convert automatically, but a totally new metadata.db is required
                            self.myparentprefs['CALM_DB_VERSION_METADATA_TOOLS_DB'] = unicode_type(MOST_CURRENT_VERSION_OF_METADATA_TOOLS)
                            self.myparentprefs['CALM_USER_STATUS'] = unicode_type("USER")
                            self.myparentprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS'] = unicode_type("True")
                            info_dialog(self.gui, _("CALM - User Helpful Information"), _(MSG_NEW_USER), show=True)
                            msg = "Please immediately create a new Target Library before continuing within CALM.<br><br>Thank you."
                            info_dialog(self.gui, _("CALM PRE-UPGRADE IMPORTANT INFORMATION"), _(msg), show=True)
                            self.mini_save_real_prefs_parent()
                        if self.myparentprefs['CALM_USER_STATUS'] != unicode_type("USER"):
                            self.myparentprefs['CALM_USER_STATUS'] = unicode_type("USER")
                            self.mini_save_real_prefs_parent()
                        else:
                            pass
                    else:
                        # OLD USERS who manually messed with the .json file such that they arrived right here, right now
                        self.myparentprefs['CALM_TARGET_DB_MUST_BE_REFRESHED'] = unicode_type("True") #previous user with tools db to convert automatically, but a totally new metadata.db is required
                        self.myparentprefs['CALM_USER_STATUS'] = unicode_type("USER")
                        self.myparentprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS'] = unicode_type("True")
                        self.mini_save_real_prefs_parent()
                        info_dialog(self.gui, _("CALM - User Helpful Information"), _(MSG_NEW_USER), show=True)
                        msg = "Please immediately create a new Target Library before continuing within CALM.<br><br>Thank you."
                        info_dialog(self.gui, _("CALM PRE-UPGRADE IMPORTANT INFORMATION"), _(msg), show=True)
                else:
                    # OLD USERS who had a good .json file
                    self.myparentprefs['CALM_TARGET_DB_MUST_BE_REFRESHED'] = unicode_type("True") #previous user with tools db to convert automatically, but a totally new metadata.db is required
                    self.myparentprefs['CALM_USER_STATUS'] = unicode_type("USER")
                    self.myparentprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS'] = unicode_type("True")
                    self.mini_save_real_prefs_parent()
                    info_dialog(self.gui, _("CALM - User Helpful Information"), _(MSG_NEW_USER), show=True)
                    msg = "Please immediately create a new Target Library before continuing within CALM.<br><br>Thank you."
                    info_dialog(self.gui, _("CALM PRE-UPGRADE IMPORTANT INFORMATION"), _(msg), show=True)
            else:
                pass  # base case
        #END IF

        if self.myparentprefs['CALM_DB_VERSION_METADATA_TOOLS_DB'] != unicode_type(MOST_CURRENT_VERSION_OF_METADATA_TOOLS):
            self.myparentprefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("True")  # failsafe if schema.user_version is already correct
            self.myparentprefs['CALM_DB_VERSION_METADATA_TOOLS_DB'] = unicode_type(MOST_CURRENT_VERSION_OF_METADATA_TOOLS)
            self.mini_save_real_prefs_parent()

        if self.myparentprefs['CALM_TARGET_DB_MUST_BE_REFRESHED'] == unicode_type("True") \
            or self.myparentprefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] == unicode_type("True"):
            self.enable_qtabwidget_tabs(0,False)
            self.enable_qtabwidget_tabs(2,False)
            self.enable_qtabwidget_tabs(3,False)
            self.enable_qtabwidget_tabs(4,False)
            self.enable_qtabwidget_tabs(5,False)
            if self.CALMtabWidget.currentIndex() != 1:
                self.CALMtabWidget.setCurrentIndex(1)

        prefs['GUI_LAST_TAB_USED'] = unicode_type(as_unicode(n))  # set but not saved yet; newly selected child tab will save if appropriate, and will already be saved if user later clicks the red 'x'.
        self.last_tab_selected = n   # only useful if the exit button is clicked to invoke calm_exit(); clicking the red 'x' bypasses calm_exit().

        #--------------------------
        if n == 0:     # Source Tab
        #--------------------------
            self.push_button_execute_all.hide()
            self.push_button_exit_with_save.hide()  # must use the Tab's special "Save" button to save the Source Libraries...
            if self.myparentprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] ==  unicode_type(1) or self.myparentprefs["GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES"] > unicode_type(0):
                self.CALMSourceLibrariesTab.push_button_load_known_libraries.hide()
                self.CALMSourceLibrariesTab.push_button_erase_unselected_libraries.hide()
                self.CALMSourceLibrariesTab.push_button_check_all_libraries.hide()
                self.CALMSourceLibrariesTab.push_button_uncheck_all_libraries.hide()
                self.CALMTargetTab.source_libraries_number_generated_warning_pushbutton.hide()
                if not self.already_set_sources_read_only:
                    self.set_source_libraries_read_only(True)
                    self.already_set_sources_read_only = True
                    self.call_hide_show_source_libraries(True)
                self.update()
                QApplication.instance().processEvents()
            else:
                self.CALMSourceLibrariesTab.push_button_load_known_libraries.show()
                self.CALMSourceLibrariesTab.push_button_erase_unselected_libraries.show()
                if self.already_set_sources_read_only:
                    self.set_source_libraries_read_only(False)
                    self.already_set_sources_read_only = False
                    self.call_hide_show_source_libraries(False)
                self.update()
                QApplication.instance().processEvents()

        #--------------------------
        elif n == 1:  # Target Tab
        #--------------------------
            self.push_button_exit_with_save.show()
            self.push_button_exit_without_save.hide()
            if self.myparentprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] ==  unicode_type(1):
                self.CALMTargetTab.push_button_generate_custom_columns.hide()
                self.CALMTargetTab.source_libraries_number_generated_warning_pushbutton.hide()
                self.push_button_execute_all.show()
            else:
                self.CALMTargetTab.push_button_generate_custom_columns.show()
                self.CALMTargetTab.source_libraries_number_generated_warning_pushbutton.show()
                self.push_button_execute_all.hide()
            self.update()
            QApplication.instance().processEvents()
            self.multiple_target_libraries_message()

        #--------------------------
        elif n == 2:  # Source Custom Columns Tab
        #--------------------------
            self.push_button_execute_all.hide()
            self.push_button_exit_with_save.show()
            self.push_button_exit_without_save.hide()
            if self.myparentprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] ==  unicode_type(1):
                self.CALMCustomColumnsTab.push_button_list_source_target_mappings_listing.show()
                self.CALMCustomColumnsTab.push_button_autopopulate_sourcelibrary_cc_control_table.hide()
                self.CALMCustomColumnsTab.push_button_mass_activate_all_combinations.hide()
                self.CALMCustomColumnsTab.push_button_mass_deactivate_all_combinations.hide()
                self.CALMCustomColumnsTab.push_button_mass_deactivate_only_composite_columns.hide()
                self.CALMCustomColumnsTab.push_button_selectively_activate_combinations.hide()
                self.CALMTargetTab.source_libraries_number_generated_warning_pushbutton.hide()
            else:
                self.CALMCustomColumnsTab.push_button_list_source_target_mappings_listing.hide()
                self.CALMCustomColumnsTab.push_button_autopopulate_sourcelibrary_cc_control_table.show()
                self.CALMCustomColumnsTab.push_button_mass_activate_all_combinations.show()
                self.CALMCustomColumnsTab.push_button_mass_deactivate_all_combinations.show()
                self.CALMCustomColumnsTab.push_button_mass_deactivate_only_composite_columns.show()
                self.CALMCustomColumnsTab.push_button_selectively_activate_combinations.show()
            self.update()
            QApplication.instance().processEvents()
            self.multiple_target_libraries_message()

        #--------------------------
        elif n == 3:     # Tools Tab
        #--------------------------
            self.push_button_execute_all.hide()
            self.push_button_exit_with_save.show()
            self.push_button_exit_without_save.hide()
            self.multiple_target_libraries_message()
            if self.current_target_library_is_read_only:
                self.CALMtabWidget.setCurrentIndex(5)
            else:
                if self.disable_tools_tabs:
                    self.CALMtabWidget.setCurrentIndex(1)
        #--------------------------
        elif n == 4:  # FAQ Tab
        #--------------------------
            self.push_button_execute_all.hide()
            self.push_button_exit_with_save.show()
            self.push_button_exit_without_save.show()
            self.multiple_target_libraries_message()
        else:
            pass
    #-----------------------------------------------------------------------------------------------
    def multiple_target_libraries_message(self):
        if self.current_library_is_a_target_library:
            self.disable_tools_tabs = False
            if as_unicode(self.current_target_library_path) != as_unicode(self.myparentprefs['CALM_TARGET_DB_FULL_PATH']):
                if not "ZZ:" in self.myparentprefs['CALM_TARGET_DB_FULL_PATH']:
                    if not self.suppress_multiple_target_libraries_message:
                        msg = "The current Calibre Library is a CALM Target Library, but it is NOT the same as the latest CALM Target Library that you created.  \
                                   <br><br> Please verify that you are now using the correct CALM Target Library.\
                                   <br><br> This Current CALM Target Library will now be set as 'Read-Only', meaning that the Metadata Tools and Library Tools may not be used.\
                                   <br><br> Current: " + self.current_target_library_path + "<br><br> Latest:  " + self.myparentprefs['CALM_TARGET_DB_FULL_PATH']
                        info_dialog(self.gui, _("Warning: Multiple CALM Target Libraries Exist"), _(msg), show=True)
                        self.suppress_multiple_target_libraries_message = True
                        self.current_target_library_is_read_only = True
        else:
            self.disable_tools_tabs = True
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    # OTHER
    #-----------------------------------------------------------------------------------------------
    def execute_calm_consolidation(self):
        self.myparentprefs['GUI_LAST_TAB_USED'] = unicode_type(1)
        is_valid = self.confirm_current_guidb_path_not_calm()
        if not is_valid:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is a CALM Target Library.  Execution canceled.  Please QuickSwitch elsewhere before attempting another execution.')), show=True)
            return
        self.save_dialog_geometry()          #  inherited from SizePersistedDialog
        self.hide()
        self.create_ui_toast_dialog(1)
        job_source = "consolidation"
        is_valid = self.validate_param_dict(job_source)
        self.ui_toast_dialog.close()
        if is_valid:
            #~ self.myparentprefs['CALM_LAST_CONSOLIDATION_TARGET_DB_FULL_PATH'] = unicode_type(self.target_db)
            prefs['CALM_LAST_CONSOLIDATION_TARGET_DB_FULL_PATH'] = unicode_type(self.target_db)
            prefs
            tmpprefs = prefs.copy()
            self.maintain_generating_noncalm_library_namespaced_prefs(tmpprefs)
            self.calm_consolidation_job_control(self.target_db, self.param_dict)
            self.close()
        else:
            return
    #-----------------------------------------------------------------------------------------------
    def execute_calm_derivegenres(self):
        # actually submitted by the Tools Tab using the parent's objects
        self.myparentprefs['GUI_LAST_TAB_USED'] = unicode_type(3)
        self.save_dialog_geometry()          #  inherited from SizePersistedDialog
        self.hide()
        self.create_ui_toast_dialog(1)
        job_source = "derivegenres"
        is_valid = self.validate_param_dict(job_source)
        self.ui_toast_dialog.close()
        if is_valid:
            self.calm_derivegenres_job_control(self.param_dict)
            tmpprefs = prefs.copy()
            self.maintain_generating_noncalm_library_namespaced_prefs(tmpprefs)
            del tmpprefs
        else:
            return
    #-----------------------------------------------------------------------------------------------
    def validate_param_dict(self,job_source):
        # validate self.param_dict that has been updated by all of the child tabs that need to do so

        is_valid = True

        #-------------
        self.save_real_prefs_parent()          #  gets latest tab prefs and adds theirs to the parent's prior to saving to the 'real' prefs, 'prefs'.
        #-------------

        if not '/CALM/metadata.db' in self.target_db:
            is_valid = False
            error_dialog(self.gui, _('CALM'),_(('CALM Path is Invalid: ' + self.target_db)), show=True)
            return is_valid


        if job_source == "derivegenres":
            return is_valid


        num_libraries = 0
        calm_was_found = False
        #~ for k,v in self.param_dict.iteritems():
        for k,v in iteritems(self.param_dict):
            if 'LIBRARY_PATH' in k:
                if not '_IS_ACTIVE' in k:
                    if v > " ":
                        if not "||>>>||" in v:
                            num_libraries = num_libraries + 1
                            if 'calm' in v or 'CALM' in v or 'Calm' in v:
                                calm_was_found = True
        #END FOR

        if calm_was_found:
            self.show()
            is_valid = False
            error_dialog(self.gui, _('CALM'),_('You may NOT select the CALM library itself.'), show=True)
            return is_valid

        if num_libraries == 0:
            self.show()
            is_valid = False
            error_dialog(self.gui, _('CALM'),_('No Libraries Were Selected.'), show=True)
            return is_valid

        if num_libraries == 1:
            self.show()
            if not question_dialog(self.gui, _('CALM'),_('Only One (1) Library Was Selected.  Continue anyway?')) :
                is_valid = False
                return is_valid


        return is_valid
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def create_ui_toast_dialog(self,msg_num):

        #msg_num = 0 : Please Wait...
        #msg_num = 1 : Job Parameters are Being Validated...

        self.ui_toast_dialog = UIToastDialog(self.gui,self.icon,msg_num)

        self.ui_toast_dialog.show()

        self.ui_toast_dialog.setModal(True)

        self.ui_toast_dialog.update()

        QApplication.instance().processEvents()

    #-----------------------------------------------------------------------------------------
    def child_invocation_of_save_real_prefs_parent(self,tab):

        if DEBUG: print("Number of keys in self.myparentprefs in 'child_invocation_of_save_real_prefs_parent' : ", as_unicode(len(self.myparentprefs)))

        if tab == 'Source Libraries':
            self.myparentprefs = self.return_latest_source_prefs(self.myparentprefs)
        elif tab == 'Target Library':
            self.target_db, self.myparentprefs = self.return_target_db(self.myparentprefs)
        elif tab == 'Source Custom Columns':
            self.myparentprefs = self.return_latest_source_cc_prefs(self.myparentprefs)
        elif tab == 'Metadata Tools':
            self.myparentprefs = self.return_latest_tools_prefs(self.myparentprefs)
        elif tab == 'ALL':
            self.save_real_prefs_parent()
            return
        else:
            if DEBUG: print("ERROR: Call to child_invocation_of_save_real_prefs_parent() has invalid parameter for tab: ", as_unicode(tab))
            return

        #~ for k,v in self.myparentprefs.iteritems():
        for k,v in iteritems(self.myparentprefs):
            prefs[k] = v
        prefs
    #-----------------------------------------------------------------------------------------
    def child_invocation_of_set_current_tab_index(self,index):
        self.CALMtabWidget.setCurrentIndex(index)
    #-----------------------------------------------------------------------------------------
    def child_invocation_to_retrieve_most_current_parent_prefs(self):
        return self.myparentprefs
    #-----------------------------------------------------------------------------------------
    def child_invocation_to_set_source_libraries_read_only(self,is_read_only):
        self.set_source_libraries_read_only(is_read_only)
    #-----------------------------------------------------------------------------------------
    def save_real_prefs_parent(self):

        if DEBUG: print("Number of keys in self.myparentprefs in 'save_real_prefs_parent' : ", as_unicode(len(self.myparentprefs)))

        self.myparentprefs = self.return_latest_source_prefs(self.myparentprefs)                    # from Sources tab

        self.target_db, self.myparentprefs = self.return_target_db(self.myparentprefs)           # from Target tab

        #currently no prefs keys owned by this tab...                                                                # from Source Custom Columns tab

        self.myparentprefs = self.return_latest_tools_prefs(self.myparentprefs)                      # from Metadata Tools tab

        self.myparentprefs['genre'] = unicode_type("#genre_calm")                                                # Target custom column name for Genre is '#genre_calm'.

        self.myparentprefs['GUI_LAST_TAB_USED'] = unicode_type(self.last_tab_selected)

        if self.current_library_is_a_target_library:
            #~ for k,v in self.myparentprefs.iteritems():
            for k,v in iteritems(self.myparentprefs):
                self.calm_target_library_db_namespaced_prefs[k] = v
            self.maintain_target_library_namespaced_db_preferences("update")
            #~ self.maintain_target_library_namespaced_db_preferences("print")

        #~ for k,v in self.myparentprefs.iteritems():
        for k,v in iteritems(self.myparentprefs):
            prefs[k] = v
        prefs
    #-----------------------------------------------------------------------------------------
    def mini_save_real_prefs_parent(self):
        #~ for k,v in self.myparentprefs.iteritems():
        for k,v in iteritems(self.myparentprefs):
            prefs[k] = v
        prefs
        if self.current_library_is_a_target_library:
            self.maintain_target_library_namespaced_db_preferences("update")
    #-----------------------------------------------------------------------------------------
    def create_new_sqlite_objects_in_tools_db(self,my_db,my_cursor,type):
        # this is to be invoked by children tabs...

        #---------------------
        # Version 2:   many new tables, views and custom indexes.
        #---------------------

        info_dialog(self.gui, _("CALM"), _("Your legacy Version 1 metadata_tools.db file must be upgraded to Version 2.  Please be patient."), show=True)

        #---------------------
        try:
            my_cursor.execute("ANALYZE  sqlite_master")  # create the query-optimizer statistics table for this legacy metadata_tools.db
        except:
            my_cursor.execute("ANALYZE")

        #---------------------
        mysql_list = []
        #---------------------

        #---------------------
        # TABLES
        #---------------------
        mysql_list.append("DROP TABLE IF EXISTS [TOOLSDOT]_source_libraries")
        mysql_list.append("DROP TABLE IF EXISTS [TOOLSDOT]_source_library_custom_columns")
        mysql_list.append("DROP TABLE IF EXISTS [TOOLSDOT]_source_custom_column_groups")
        mysql_list.append("DROP TABLE IF EXISTS [TOOLSDOT]_source_custom_column_mapping")
        mysql_list.append("DROP TABLE IF EXISTS [TOOLSDOT]_source_cc_to_target_cc_mapping")
        mysql_list.append("DROP TABLE IF EXISTS [TOOLSDOT]_source_library_cc_labels_renamed_in_target_cc_table")
        mysql_list.append("DROP TABLE IF EXISTS [TOOLSDOT]_target_custom_column_to_group_mapping")
        mysql_list.append("DROP TABLE IF EXISTS [TOOLSDOT]_target_custom_columns")
        mysql_list.append("DROP TABLE IF EXISTS [TOOLSDOT]_target_groupid_longest_display_value")
        mysql_list.append("DROP TABLE IF EXISTS [TOOLSDOT]_target_metadata_db_preferences_table")


        mysql_list.append('CREATE TABLE IF NOT EXISTS [TOOLSDOT]_source_libraries ( id INTEGER PRIMARY KEY AUTOINCREMENT, source_library TEXT NOT NULL, UNIQUE(source_library) )')

        mysql_list.append('CREATE TABLE IF NOT EXISTS [TOOLSDOT]_source_library_custom_columns (\
                                        source_library  TEXT NOT NULL,\
                                        source_library_cc_id  INTEGER NOT NULL,\
                                        source_library_cc_label    TEXT NOT NULL,\
                                        source_library_cc_name     TEXT NOT NULL,\
                                        source_library_cc_datatype TEXT NOT NULL,\
                                        source_library_cc_mark_for_delete   BOOL DEFAULT 0 NOT NULL,\
                                        source_library_cc_editable BOOL DEFAULT 1 NOT NULL,\
                                        source_library_cc_display  TEXT DEFAULT "{}" NOT NULL,\
                                        source_library_cc_is_multiple BOOL DEFAULT 0 NOT NULL,\
                                        source_library_cc_normalized BOOL NOT NULL, \
                                        activate_for_calm BOOL NOT NULL  DEFAULT 0,\
                                        PRIMARY KEY (source_library,source_library_cc_id,source_library_cc_label),\
                                        UNIQUE(source_library,source_library_cc_id,source_library_cc_label)  )')

        mysql_list.append("DROP TABLE IF EXISTS [TOOLSDOT]_source_custom_column_groups")                 # version 2.0.27 changed unique by to include display for enumeration only...
        mysql_list.append('CREATE TABLE IF NOT EXISTS [TOOLSDOT]_source_custom_column_groups \
                                        (\
                                        id INTEGER PRIMARY KEY  AUTOINCREMENT  NOT NULL,\
                                        source_library_cc_label           TEXT NOT NULL,\
                                        source_library_cc_name          TEXT NOT NULL,\
                                        source_library_cc_datatype     TEXT NOT NULL,\
                                        source_library_cc_mark_for_delete   BOOL DEFAULT 0 NOT NULL,\
                                        source_library_cc_editable       BOOL DEFAULT 1 NOT NULL,\
                                        source_library_cc_display         TEXT DEFAULT "{}",\
                                        source_library_cc_is_multiple    BOOL DEFAULT 0 NOT NULL,\
                                        source_library_cc_normalized   BOOL NOT NULL, \
                                        activate_for_calm                      BOOL NOT NULL  DEFAULT 0,\
                                        UNIQUE(source_library_cc_label, source_library_cc_name, source_library_cc_datatype, \
                                                     source_library_cc_mark_for_delete, source_library_cc_editable,source_library_cc_display, \
                                                     source_library_cc_is_multiple,source_library_cc_normalized)\
                                        )')


        mysql_list.append('CREATE TABLE IF NOT EXISTS [TOOLSDOT]_source_custom_column_mapping \
                                        (\
                                        source_library  TEXT NOT NULL,\
                                        source_library_cc_id  INTEGER NOT NULL,\
                                        groupid INTEGER NOT NULL,\
                                        PRIMARY KEY (source_library,source_library_cc_id),\
                                        UNIQUE(source_library,source_library_cc_id)  \
                                         )')


        mysql_list.append('CREATE TABLE IF NOT EXISTS [TOOLSDOT]_source_cc_to_target_cc_mapping \
                                        (\
                                        id INTEGER PRIMARY KEY AUTOINCREMENT,\
                                        source_library TEXT NOT NULL, \
                                        source_library_cc_id INTEGER NOT NULL, \
                                        groupid  INTEGER NOT NULL, \
                                        source_library_cc_label TEXT NOT NULL, \
                                        target_cc_id INTEGER NOT NULL, \
                                        target_cc_label TEXT NOT NULL, \
                                        UNIQUE(source_library,source_library_cc_id)\
                                        )')

        mysql_list.append('CREATE TABLE IF NOT EXISTS [TOOLSDOT]_source_library_cc_labels_renamed_in_target_cc_table \
                                        (source_library_cc_label TEXT PRIMARY KEY  NOT NULL  UNIQUE , target_library_cc_label TEXT NOT NULL  UNIQUE )   ')

        mysql_list.append('CREATE TABLE IF NOT EXISTS [TOOLSDOT]_target_custom_column_to_group_mapping \
                                        ( \
                                        target_cc_id INTEGER NOT NULL, \
                                        groupid INTEGER NOT NULL, \
                                        target_library_cc_label TEXT NOT NULL, \
                                        PRIMARY KEY (target_cc_id,groupid), \
                                        UNIQUE(target_cc_id,groupid)   \
                                        )   ')

        mysql_list.append('CREATE TABLE IF NOT EXISTS [TOOLSDOT]_target_custom_columns (\
                                        id       INTEGER PRIMARY KEY AUTOINCREMENT,\
                                        label    TEXT NOT NULL,\
                                        name     TEXT NOT NULL,\
                                        datatype TEXT NOT NULL,\
                                        mark_for_delete   BOOL DEFAULT 0 NOT NULL,\
                                        editable BOOL DEFAULT 1 NOT NULL,\
                                        display  TEXT DEFAULT "{}" NOT NULL,\
                                        is_multiple BOOL DEFAULT 0 NOT NULL,\
                                        normalized BOOL NOT NULL,\
                                        UNIQUE(label)\
                                    )   ')

        mysql_list.append('CREATE TABLE IF NOT EXISTS [TOOLSDOT]_target_groupid_longest_display_value (groupid INTEGER PRIMARY KEY  NOT NULL  UNIQUE , display TEXT NOT NULL )   ')

        mysql_list.append('CREATE TABLE IF NOT EXISTS [TOOLSDOT]_target_metadata_db_preferences_table(id INTEGER PRIMARY KEY,\
                                         key TEXT NOT NULL,\
                                         val TEXT NOT NULL,\
                                         UNIQUE(key))   ')

        mysql_list.append("INSERT OR REPLACE INTO [TOOLSDOT]_source_library_cc_labels_renamed_in_target_cc_table VALUES('enf','enf_source'); ")
        mysql_list.append("INSERT OR REPLACE INTO [TOOLSDOT]_source_library_cc_labels_renamed_in_target_cc_table VALUES('status','status_source'); ")
        mysql_list.append("INSERT OR REPLACE INTO [TOOLSDOT]_source_library_cc_labels_renamed_in_target_cc_table VALUES('work_series','work_series_source'); ")
        mysql_list.append("INSERT OR REPLACE INTO [TOOLSDOT]_source_library_cc_labels_renamed_in_target_cc_table VALUES('isbn','isbn_source'); ")
        mysql_list.append("INSERT OR REPLACE INTO [TOOLSDOT]_source_library_cc_labels_renamed_in_target_cc_table VALUES('genre','genre_source'); ")
        mysql_list.append("INSERT OR REPLACE INTO [TOOLSDOT]_source_library_cc_labels_renamed_in_target_cc_table VALUES('pages','pages_source'); ")

        #---------------------
        # VIEWS
        #---------------------
        # in the sequence to drop the views with dependencies on other views first:
        mysql_list.append("DROP VIEW IF EXISTS [TOOLSDOT]__active_sources_not_mapped_to_target_with_valid_mapping_final")
        mysql_list.append("DROP VIEW IF EXISTS [TOOLSDOT]__source_library_cc_groupid_not_in_table_source_cc_to_target_cc_mapping")
        mysql_list.append("DROP VIEW IF EXISTS [TOOLSDOT]__source_library_cc_display_length_by_groupid")
        mysql_list.append("DROP VIEW IF EXISTS [TOOLSDOT]__source_library_cc_id_display_by_groupid")
        mysql_list.append("DROP VIEW IF EXISTS [TOOLSDOT]__source_custom_column_groupid_explanation")
        mysql_list.append("DROP VIEW IF EXISTS [TOOLSDOT]__source_cc_to_target_cc_mapping_indirect_only")
        mysql_list.append("DROP VIEW IF EXISTS [TOOLSDOT]__source_cc_to_target_cc_mapping_direct_only")
        mysql_list.append("DROP VIEW IF EXISTS [TOOLSDOT]__source_cc_id_indirectly_mapped_to_target_cc_id")
        mysql_list.append("DROP VIEW IF EXISTS [TOOLSDOT]__target_cc_id_indirectly_mapped_to_source_library_cc_label")
        mysql_list.append("DROP VIEW IF EXISTS [TOOLSDOT]__target_cc_id_directly_mapped_to_source_library_cc_label")
        mysql_list.append("DROP VIEW IF EXISTS [TOOLSDOT]__invalid_source_to_target_cc_normalization_mappings")
        mysql_list.append("DROP VIEW IF EXISTS [TOOLSDOT]__compare_normalization_source_and_target")
        mysql_list.append("DROP VIEW IF EXISTS [TOOLSDOT]__active_sources_not_mapped_to_target_with_valid_mapping")
        mysql_list.append("DROP VIEW IF EXISTS [TOOLSDOT]__active_sources_not_mapped_to_target")
        mysql_list.append("DROP VIEW IF EXISTS [TOOLSDOT]__source_custom_columns_not_generated_but_activated")

        # in the opposite sequence as just above so as to create the views with no dependencies first, and those with many dependencies last, all in the proper sequence:

        # prerequisite for: __active_sources_not_mapped_to_target_with_valid_mapping
        mysql_list.append("CREATE VIEW IF NOT EXISTS [TOOLSDOT]__active_sources_not_mapped_to_target AS \
                                        SELECT source_library,source_library_cc_id,activate_for_calm,source_library_cc_label,source_library_cc_datatype,source_library_cc_is_multiple,source_library_cc_normalized \
                                        FROM _source_library_custom_columns \
                                        WHERE activate_for_calm = 1 \
                                        AND (source_library_cc_id NOT IN(SELECT source_library_cc_id \
                                        FROM _source_cc_to_target_cc_mapping \
                                        WHERE (source_library_cc_id = _source_library_custom_columns.source_library_cc_id \
                                        AND source_library = _source_library_custom_columns.source_library) ) )")
        # prerequisite for:  __active_sources_not_mapped_to_target_with_valid_mapping_final
        mysql_list.append("CREATE VIEW IF NOT EXISTS [TOOLSDOT]__active_sources_not_mapped_to_target_with_valid_mapping AS \
                                        SELECT source_library, source_library_cc_id, activate_for_calm, source_library_cc_label, source_library_cc_datatype, source_library_cc_is_multiple, source_library_cc_normalized,\
                                        (SELECT id  FROM _source_custom_column_groups \
                                        WHERE source_library_cc_label = __active_sources_not_mapped_to_target.source_library_cc_label \
                                        AND source_library_cc_datatype = __active_sources_not_mapped_to_target.source_library_cc_datatype \
                                        AND source_library_cc_is_multiple = __active_sources_not_mapped_to_target.source_library_cc_is_multiple \
                                        AND source_library_cc_label IN(SELECT source_library_cc_label FROM _source_library_cc_labels_renamed_in_target_cc_table) \
                                                ) AS potential_groupid,\
                                        (SELECT target_library_cc_label FROM _source_library_cc_labels_renamed_in_target_cc_table \
                                        WHERE source_library_cc_label = __active_sources_not_mapped_to_target.source_library_cc_label) AS target_library_cc_label \
                                        FROM __active_sources_not_mapped_to_target")

        # prerequisite for: __invalid_source_to_target_cc_normalization_mappings
        mysql_list.append("CREATE VIEW IF NOT EXISTS [TOOLSDOT]__compare_normalization_source_and_target AS \
                                        SELECT source_library,source_library_cc_id,target_cc_id,\
                                        (SELECT datatype FROM _target_custom_columns WHERE id = _source_cc_to_target_cc_mapping.target_cc_id) AS target_cc_datatype,\
                                        (SELECT source_library_cc_datatype FROM _source_library_custom_columns \
                                        WHERE source_library = _source_cc_to_target_cc_mapping.source_library \
                                           AND source_library_cc_id = _source_cc_to_target_cc_mapping.source_library_cc_id) AS source_library_cc_datatype,\
                                        (SELECT normalized FROM _target_custom_columns WHERE id = _source_cc_to_target_cc_mapping.target_cc_id) AS target_cc_normalized,\
                                        (SELECT source_library_cc_normalized FROM _source_library_custom_columns \
                                        WHERE source_library = _source_cc_to_target_cc_mapping.source_library \
                                          AND source_library_cc_id = _source_cc_to_target_cc_mapping.source_library_cc_id) AS source_library_cc_normalized \
                                        FROM _source_cc_to_target_cc_mapping \
                                        ORDER BY target_cc_datatype,target_cc_id")
        # prerequisite is: __compare_normalization_source_and_target
        mysql_list.append("CREATE VIEW IF NOT EXISTS [TOOLSDOT]__invalid_source_to_target_cc_normalization_mappings AS   \
                                            SELECT * FROM __compare_normalization_source_and_target \
                                            WHERE (target_cc_normalized != source_library_cc_normalized) \
                                                  OR (target_cc_datatype != source_library_cc_datatype) \
                                                  OR (target_cc_datatype = 'text' AND target_cc_normalized = 0)")
        # prerequisite for: __target_cc_id_indirectly_mapped_to_source_library_cc_label
        mysql_list.append("CREATE VIEW IF NOT EXISTS [TOOLSDOT] __target_cc_id_directly_mapped_to_source_library_cc_label AS \
                                          SELECT _source_custom_column_groups.id AS groupid, _source_custom_column_groups.source_library_cc_label, \
                                          (SELECT id FROM _target_custom_columns \
                                          WHERE _target_custom_columns.label =  _source_custom_column_groups.source_library_cc_label) AS target_cc_id, \
                                          (SELECT label FROM _target_custom_columns WHERE _target_custom_columns.label =  _source_custom_column_groups.source_library_cc_label AND label NOT NULL) AS target_cc_label \
                                          FROM _source_custom_column_groups, _source_custom_column_mapping \
                                          WHERE _source_custom_column_groups.id = _source_custom_column_mapping.groupid \
                                               AND target_cc_id NOT NULL \
                                          GROUP BY groupid ORDER BY target_cc_id, groupid")
        # prerequisite is: __target_cc_id_directly_mapped_to_source_library_cc_label)
        # prerequisite for: __source_cc_id_indirectly_mapped_to_target_cc_id
        # prerequisite for: __source_cc_to_target_cc_mapping_indirect_only
        mysql_list.append("CREATE VIEW IF NOT EXISTS [TOOLSDOT] __target_cc_id_indirectly_mapped_to_source_library_cc_label AS \
                                            SELECT target_cc_id,groupid,target_library_cc_label FROM _target_custom_column_to_group_mapping \
                                            WHERE target_cc_id NOT IN(SELECT target_cc_id FROM __target_cc_id_directly_mapped_to_source_library_cc_label)")
        # prerequisite is:  __target_cc_id_indirectly_mapped_to_source_library_cc_label
        # prerequisite for: nothing
        mysql_list.append("CREATE VIEW IF NOT EXISTS [TOOLSDOT]__source_cc_id_indirectly_mapped_to_target_cc_id AS \
                                        SELECT source_library,source_library_cc_id,groupid,\
                                        (SELECT source_library_cc_label FROM _source_library_custom_columns \
                                        WHERE source_library = _source_custom_column_mapping.source_library \
                                        AND source_library_cc_id = _source_custom_column_mapping.source_library_cc_id ) AS source_library_cc_label \
                                        FROM _source_custom_column_mapping \
                                        WHERE groupid IN(SELECT groupid FROM __target_cc_id_indirectly_mapped_to_source_library_cc_label)")
        # prerequisite is: __target_cc_id_directly_mapped_to_source_library_cc_label)
        mysql_list.append("CREATE VIEW IF NOT EXISTS [TOOLSDOT]__source_cc_to_target_cc_mapping_direct_only AS \
                                        SELECT source_library,source_library_cc_id,groupid,\
                                        (SELECT source_library_cc_label FROM _source_library_custom_columns WHERE source_library = _source_custom_column_mapping.source_library AND source_library_cc_id = _source_custom_column_mapping.source_library_cc_id ) AS source_library_cc_label,\
                                        (SELECT target_cc_id FROM __target_cc_id_directly_mapped_to_source_library_cc_label WHERE groupid = _source_custom_column_mapping.groupid) AS target_cc_id,\
                                        (SELECT target_cc_label FROM __target_cc_id_directly_mapped_to_source_library_cc_label WHERE groupid = _source_custom_column_mapping.groupid) AS target_library_cc_label \
                                        FROM _source_custom_column_mapping \
                                        WHERE groupid IN(SELECT groupid FROM __target_cc_id_directly_mapped_to_source_library_cc_label)")
        # prerequisite is:  __target_cc_id_indirectly_mapped_to_source_library_cc_label
        # prerequisite for: __source_library_cc_groupid_not_in_table_source_cc_to_target_cc_mapping
        mysql_list.append("CREATE VIEW IF NOT EXISTS [TOOLSDOT]__source_cc_to_target_cc_mapping_indirect_only AS \
                                        SELECT source_library,source_library_cc_id,groupid,\
                                        (SELECT source_library_cc_label FROM _source_library_custom_columns WHERE source_library = _source_custom_column_mapping.source_library AND source_library_cc_id = _source_custom_column_mapping.source_library_cc_id ) AS source_library_cc_label,\
                                        (SELECT target_cc_id FROM __target_cc_id_indirectly_mapped_to_source_library_cc_label WHERE groupid = _source_custom_column_mapping.groupid) AS target_cc_id,\
                                        (SELECT target_library_cc_label FROM __target_cc_id_indirectly_mapped_to_source_library_cc_label WHERE groupid = _source_custom_column_mapping.groupid) AS target_library_cc_label \
                                        FROM _source_custom_column_mapping \
                                        WHERE groupid IN(SELECT groupid FROM __target_cc_id_indirectly_mapped_to_source_library_cc_label)")
        # prerequisite for:  nothing
        mysql_list.append("CREATE VIEW IF NOT EXISTS [TOOLSDOT]__source_custom_column_groupid_explanation AS \
                                        SELECT source_library,source_library_cc_id,groupid,\
                                        (SELECT source_library_cc_label \
                                          FROM _source_library_custom_columns WHERE source_library = _source_custom_column_mapping.source_library \
                                                                                                              AND source_library_cc_id = _source_custom_column_mapping.source_library_cc_id) AS source_library_cc_label, \
                                        (SELECT source_library_cc_name \
                                          FROM _source_library_custom_columns WHERE source_library = _source_custom_column_mapping.source_library \
                                                                                                              AND source_library_cc_id = _source_custom_column_mapping.source_library_cc_id) AS source_library_cc_name, \
                                        (SELECT source_library_cc_datatype \
                                          FROM _source_library_custom_columns WHERE source_library = _source_custom_column_mapping.source_library \
                                                                                                              AND source_library_cc_id = _source_custom_column_mapping.source_library_cc_id) AS source_library_cc_datatype, \
                                        (SELECT source_library_cc_display \
                                          FROM _source_library_custom_columns WHERE source_library = _source_custom_column_mapping.source_library \
                                                                                                              AND source_library_cc_id = _source_custom_column_mapping.source_library_cc_id) AS source_library_cc_display, \
                                        (SELECT source_library_cc_editable \
                                          FROM _source_library_custom_columns WHERE source_library = _source_custom_column_mapping.source_library \
                                                                                                              AND source_library_cc_id = _source_custom_column_mapping.source_library_cc_id) AS source_library_cc_editable, \
                                        (SELECT source_library_cc_is_multiple \
                                          FROM _source_library_custom_columns WHERE source_library = _source_custom_column_mapping.source_library \
                                                                                                              AND source_library_cc_id = _source_custom_column_mapping.source_library_cc_id) AS source_library_cc_is_multiple \
                                        FROM _source_custom_column_mapping \
                                        ORDER BY source_library_cc_label, source_library_cc_name, source_library_cc_datatype, source_library_cc_display")
        # prerequisite for:  __source_library_cc_display_length_by_groupid
        mysql_list.append("CREATE VIEW IF NOT EXISTS [TOOLSDOT]__source_library_cc_id_display_by_groupid AS \
                                            SELECT source_library, source_library_cc_id, source_library_cc_display, \
                                            (SELECT groupid FROM _source_custom_column_mapping \
                                            WHERE source_library = _source_library_custom_columns.source_library \
                                               AND  source_library_cc_id = _source_library_custom_columns.source_library_cc_id) AS groupid \
                                            FROM _source_library_custom_columns \
                                            ORDER BY groupid, source_library_cc_display")
        # prerequisite is:  __source_library_cc_id_display_by_groupid
        mysql_list.append("CREATE VIEW IF NOT EXISTS [TOOLSDOT]__source_library_cc_display_length_by_groupid AS \
                                        SELECT groupid, source_library_cc_display, (length(source_library_cc_display)) as display_length \
                                        FROM __source_library_cc_id_display_by_groupid \
                                        WHERE source_library_cc_display NOT NULL \
                                        ORDER BY groupid, display_length DESC")
        # prerequisite is: __source_cc_to_target_cc_mapping_indirect_only
        mysql_list.append("CREATE VIEW IF NOT EXISTS [TOOLSDOT]__source_library_cc_groupid_not_in_table_source_cc_to_target_cc_mapping  AS \
                                        SELECT source_library, source_library_cc_id,groupid \
                                        FROM __source_cc_to_target_cc_mapping_indirect_only \
                                        WHERE source_library_cc_id NOT IN(SELECT source_library_cc_id \
                                        FROM  _source_cc_to_target_cc_mapping \
                                        WHERE source_library = __source_cc_to_target_cc_mapping_indirect_only.source_library)")
        # prerequisite for:  nothing
        mysql_list.append("CREATE VIEW __source_custom_columns_not_generated_but_activated  AS \
                                        SELECT * FROM _source_library_custom_columns \
                                        WHERE source_library NOT IN(SELECT source_library  FROM _source_cc_to_target_cc_mapping ) \
                                            AND   activate_for_calm = 1  ")
        # prerequisite for:  nothing
        # prerequisites are:  __active_sources_not_mapped_to_target_with_valid_mapping,     __source_library_cc_id_display_by_groupid
        mysql_list.append("CREATE VIEW IF NOT EXISTS [TOOLSDOT]__active_sources_not_mapped_to_target_with_valid_mapping_final AS \
                                        SELECT source_library,\
                                        (SELECT source_library_cc_id FROM _source_library_custom_columns \
                                                                 WHERE source_library = __active_sources_not_mapped_to_target_with_valid_mapping.source_library \
                                                                     AND source_library_cc_label = __active_sources_not_mapped_to_target_with_valid_mapping.source_library_cc_label) AS source_library_cc_id,\
                                        source_library_cc_label,\
                                        (SELECT source_library_cc_name FROM _source_library_custom_columns \
                                                                 WHERE source_library = __active_sources_not_mapped_to_target_with_valid_mapping.source_library \
                                                                     AND source_library_cc_label = __active_sources_not_mapped_to_target_with_valid_mapping.source_library_cc_label) AS source_library_cc_name,\
                                        (SELECT id FROM _source_custom_column_groups \
                                                                 WHERE source_library_cc_name = (SELECT source_library_cc_name FROM _source_library_custom_columns \
                                                                                                                        WHERE source_library = __active_sources_not_mapped_to_target_with_valid_mapping.source_library \
                                                                                                                            AND source_library_cc_label = __active_sources_not_mapped_to_target_with_valid_mapping.source_library_cc_label) \
                                                                     AND source_library_cc_label = __active_sources_not_mapped_to_target_with_valid_mapping.source_library_cc_label) AS groupid,\
                                        source_library_cc_datatype, \
                                        (SELECT source_library_cc_display FROM __source_library_cc_id_display_by_groupid \
                                                                 WHERE source_library = __active_sources_not_mapped_to_target_with_valid_mapping.source_library \
                                                                     AND source_library_cc_label = __active_sources_not_mapped_to_target_with_valid_mapping.source_library_cc_label) AS source_library_cc_display,\
                                        source_library_cc_is_multiple, source_library_cc_normalized \
                                        FROM __active_sources_not_mapped_to_target_with_valid_mapping \
                                        ORDER BY source_library_cc_label,source_library_cc_name,groupid ")

        #---------------------
        # INDEXES
        #---------------------
        mysql_list.append('DROP INDEX IF EXISTS [TOOLSDOT]calm_dg_genre_tag_rules_factual_1_idx')
        mysql_list.append('DROP INDEX IF EXISTS [TOOLSDOT]calm_dg_genre_tag_rules_fiction_1_idx')
        mysql_list.append('DROP INDEX IF EXISTS [TOOLSDOT]calm_tag_capitalization_rules_1_idx')
        mysql_list.append('DROP INDEX IF EXISTS [TOOLSDOT]calm_tag_rules_1')
        mysql_list.append('DROP INDEX IF EXISTS [TOOLSDOT]calm_tag_rules_2')
        mysql_list.append('DROP INDEX IF EXISTS [TOOLSDOT]calm_tag_string_replacement_rules_1_idx')
        mysql_list.append('CREATE INDEX IF NOT EXISTS "[TOOLSDOT]calm_dg_genre_tag_rules_factual_1_idx" ON "_dg_genre_tag_rules_factual" ("new_genre" ASC, "tag_keyword_1" ASC, "tag_operator_1" ASC, "tag_keyword_2" ASC, "tag_operator_2" ASC, "tag_keyword_3" ASC, "tag_operator_3" ASC,\
                                        "tag_keyword_4" ASC, "tag_operator_4" ASC, "tag_keyword_5" ASC)')
        mysql_list.append('CREATE INDEX IF NOT EXISTS "[TOOLSDOT]calm_dg_genre_tag_rules_fiction_1_idx" ON "_dg_genre_tag_rules_fiction" ("new_genre" ASC, "tag_keyword_1" ASC, "tag_operator_1" ASC, "tag_keyword_2" ASC, "tag_operator_2" ASC, "tag_keyword_3" ASC, "tag_operator_3" ASC,\
                                        "tag_keyword_4" ASC, "tag_operator_4" ASC, "tag_keyword_5" ASC)')
        mysql_list.append('CREATE INDEX IF NOT EXISTS "[TOOLSDOT]calm_tag_capitalization_rules_1_idx" ON "_tag_capitalization_rules" ("regex" ASC, "rule" ASC, "priority" ASC)')
        mysql_list.append('CREATE INDEX IF NOT EXISTS "[TOOLSDOT]calm_tag_rules_1" ON "_tag_rules" ("oldtag" ASC, "newtag" ASC)')
        mysql_list.append('CREATE INDEX IF NOT EXISTS "[TOOLSDOT]calm_tag_rules_2" ON "_tag_rules" ("newtag" ASC)')
        mysql_list.append('CREATE INDEX IF NOT EXISTS "[TOOLSDOT]calm_tag_string_replacement_rules_1_idx" ON "_tag_string_replacement_rules" ("old_string" ASC, "new_string" ASC)')

        #-------------------------------------------
        #-------------------------------------------
        #-------------------------------------------
        #-------------------------------------------
        mysql_execute_list = []
        for row in mysql_list:
            if type == "CONNECTED":
                row = row.replace("[TOOLSDOT]","")
            elif type == "ATTACHED":
                row = row.replace("[TOOLSDOT]","TOOLS.")
            else:
                continue
            mysql_execute_list.append(row)
        #END FOR
        del mysql_list

        #-------------------------------------------
        #-------------------------------------------
        for mysql in mysql_execute_list:
            if DEBUG: print(mysql)
            my_cursor.execute("begin")
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        #END FOR
        del mysql_execute_list

        #-------------------------------------------
        #-------------------------------------------
        mysql = "ANALYZE sqlite_master"
        if DEBUG: print(mysql)
        my_cursor.execute("begin")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        #-------------------------------------------
        #-------------------------------------------
        prefs['CALM_DB_VERSION_METADATA_TOOLS_DB'] = unicode_type("2")
        self.myparentprefs['CALM_DB_VERSION_METADATA_TOOLS_DB'] = unicode_type("2")
        prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("False")
        self.myparentprefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("False")

        mycopy = prefs.copy()
        #~ for k,v in mycopy.iteritems():          # reset all Source Library related prefs, since they have changed in Version 2.
        for k,v in iteritems(mycopy):          # reset all Source Library related prefs, since they have changed in Version 2.
            k = unicode_type(k)
            v = unicode_type(v)
            if k.count("LIBRARY_PATH_") > 0 :
                if k.count("IS_ACTIVE") == 0 :
                    self.myparentprefs[k] = unicode_type("")
                    prefs[k] = unicode_type("")
                else:
                    self.myparentprefs[k] = unicode_type("False")
                    prefs[k] = unicode_type("False")
        #END FOR
        del mycopy
        if DEBUG: print("Legacy Source Library Paths have been reset")
        prefs
        tmpcopy = prefs.copy()    # a simple 'prefs' is a function, not a dict...
        db.prefs.set_namespaced(DB_PREFS_NAMESPACE, DB_PREFS_KEY_SETTINGS, tmpcopy)   #update metadata.db table=preferences...
        del tmpcopy

        info_dialog(self.gui, _("CALM"), _("Your legacy Version 1 metadata_tools.db file has been upgraded to Version 2.\
                                                                <br><br>It now supports Source Custom Column Consolidation."), show=True)

        return True
        #-------------------------------------------
        #-------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def set_source_libraries_read_only(self,is_read_only):

        self.CALMSourceLibrariesTab.library_3.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_4.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_5.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_6.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_7.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_8.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_9.setReadOnly(is_read_only)

        self.CALMSourceLibrariesTab.library_10.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_11.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_12.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_13.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_14.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_15.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_16.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_17.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_18.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_19.setReadOnly(is_read_only)

        self.CALMSourceLibrariesTab.library_20.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_21.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_22.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_23.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_24.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_25.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_26.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_27.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_28.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_29.setReadOnly(is_read_only)

        self.CALMSourceLibrariesTab.library_30.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_31.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_32.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_33.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_34.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_35.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_36.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_37.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_38.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_39.setReadOnly(is_read_only)

        self.CALMSourceLibrariesTab.library_40.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_41.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_42.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_43.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_44.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_45.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_46.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_47.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_48.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_49.setReadOnly(is_read_only)

        self.CALMSourceLibrariesTab.library_50.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_51.setReadOnly(is_read_only)
        self.CALMSourceLibrariesTab.library_52.setReadOnly(is_read_only)

        should_hide = is_read_only
        self.call_hide_show_source_libraries(should_hide)
    #-----------------------------------------------------------------------------------------------
    def call_hide_show_source_libraries(self,should_hide):

        all_source_library_paths_set = set()

        #~ for k,v in self.myparentprefs.iteritems():          # get all configured source libraries
        for k,v in iteritems(self.myparentprefs):          # get all configured source libraries
            k = unicode_type(k)
            v = unicode_type(v)
            if "||>>>||" in v:
                continue
            #~ if DEBUG: print(k,"  >>>>",v,"<<<<")
            if k.count("LIBRARY_PATH_") > 0 :
                if k.count("IS_ACTIVE") == 0 :
                    if v == unicode_type("None"):
                        if DEBUG: print("[0] skipping a bad path for key: ", k, "   value: ", v)
                        continue
                    v = v.strip()
                    if v.count("/") > 0 or v.count("\\") > 0:
                        all_source_library_paths_set.add(v)
                        if DEBUG: print(k,"  :  ",v)
        #END FOR
        number_source_libraries = len(all_source_library_paths_set)

        del all_source_library_paths_set

        if DEBUG: print("number_source_libraries: ",number_source_libraries)

        n_last_to_show = number_source_libraries + 3 - 1

        if DEBUG: print("n_last_to_show: ", as_unicode(n_last_to_show))

        self.hide_show_source_libraries(should_hide,n_last_to_show)

        self.update()
        QApplication.instance().processEvents()

    #-----------------------------------------------------------------------------------------------
    def hide_show_source_libraries(self,should_hide,n_last_to_show):

        for x in range(0,53):
            if x > n_last_to_show and x < 53:
                try:
                    qitem_checkbox = self.qt_source_tab_qcheckbox_objects_dict[x]
                    qitem_lineedit = self.qt_source_tab_qlineedit_objects_dict[x]
                    if should_hide:
                        qitem_checkbox.hide()
                        qitem_lineedit.hide()
                    else:
                        qitem_checkbox.show()
                        qitem_lineedit.show()
                    continue
                except:
                    continue
            else:
                continue
        #END FOR
        del x
        del qitem_checkbox
        del qitem_lineedit
        del n_last_to_show
        del should_hide
    #-----------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
    def confirm_current_guidb_path_not_calm(self):
        # verify that current db path of self.guidb does NOT contain "/CALM/metadata.db
        path = self.guidb.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')
        if "/CALM/metadata.db" in path:
            self.current_library_is_a_target_library = True
            self.current_target_library_path = path
            self.current_non_target_library_path = "ZZ:"
            return False
        else:
            self.current_library_is_a_target_library = False
            self.current_target_library_path = "ZZ:"
            self.current_non_target_library_path = path
            return True
#--------------------------------------------------------------------------------------------------
    def calm_exit_without_save(self):
        self.close()
#--------------------------------------------------------------------------------------------------
    def calm_exit_with_save(self):
        self.save_real_prefs_parent()    # saves all of the various changes to each child tab's prefs within the parent's and the real prefs.
        self.close()
    #-------------------------------------------------------------------------------------------------------------------------------
    def init_tooltips_for_parent(self):
        self.setStyleSheet("QToolTip { color: #ffffff; background-color: #2a82da; border: 1px solid white; }")

        self.parent_tooltip_00 = "<p style='white-space:wrap'>" + \
        '''
            "Things to know: \
            <br><br>[1] The 'User Guide' is decentralized within the various Tabs of CALM.\
            <br><br>[2] The 'ToolTips have useful and necessary information to learn. \
            <br><br>[3] The 'Source Libraries' Tab is where you select All or Some of your Calibre Libraries for Consolidation into the 'Target Library'.\
            <br><br>[4] The 'Target Library' Tab where you create your 'Target Library' that will be the 'target' of the Consolidation process.  It also has additional important information.\
            <br><br>[5] The 'Source Custom Columns' Tab is where you decide whether All, Some, or No Custom Columns should be Consolidated into the 'Target Library'. \
            <br><br>[6] The 'Metadata Tools' Tab is used after you have finished running the Consolidation process.\
            <br><br>[7] The 'FAQ' Tab has information about the 'Metadata Tools' Tab."
        '''
#--------------------------------------------------------------------------------------------------
    def maintain_target_library_namespaced_db_preferences(self,action):
        # namespaced preferences stored in metadata.db table preferences must remain specific to a particular CALM Target Library.
        # the normal plugin .json prefs are STILL required as usual, because the CALM Target Library is updated by CALM when the current Calibre Library is NOT the CALM Target Library.
        # the transient prefs key used to tie the generating library to its target library is:    prefs['CALM_TARGET_DB_GENERATING_NONCALM_LIBRARY_PATH'] = unicode_type("generatingnoncalmpath||>>>||generatedtargetpath")
        # one a 1-time basis (action == "transfer_once"), the namespaced prefs from the generating non-calm library are transferred to the corresponding calm target library.  then, the special key is defaulted.
        # so, this function can only be used when the current Calibre Library *is* a CALM Target Library.

        if not self.current_library_is_a_target_library:
            return

        if "ZZ:" in self.current_target_library_path:
            return False

        #~ DB_PREFS_NAMESPACE = 'CALMPlugin'
        #~ DB_PREFS_KEY_SETTINGS = 'CALMTargetDBSettings'
        #~ DB_PREFS_FULL_KEY = "namespaced:CALMPlugin:CALMTargetDBSettings"

        db = self.guidb

        if action == "load":
            library_config_dict = db.prefs.get_namespaced(DB_PREFS_NAMESPACE, DB_PREFS_KEY_SETTINGS)
            if library_config_dict is None:  # should never happen, since the plugin template metadata.db has the default config already...
                library_config_dict = db.prefs.get_namespaced(DB_PREFS_NAMESPACE, DB_PREFS_KEY_SETTINGS,
                                                         deepcopy(self.calm_target_library_db_namespaced_prefs))
            #~ for k,v in library_config_dict.iteritems():
            for k,v in iteritems(library_config_dict):
                self.calm_target_library_db_namespaced_prefs[k] = v   # customize the very latest CALM default prefs for this Target Library's previously saved db prefs...
            #END FOR
            del library_config_dict
            db.prefs.set_namespaced(DB_PREFS_NAMESPACE, DB_PREFS_KEY_SETTINGS, self.calm_target_library_db_namespaced_prefs)   #update metadata.db table=preferences...
        elif action == "update":
            #~ for k,v in self.myparentprefs.iteritems():
            for k,v in iteritems(self.myparentprefs):
                self.calm_target_library_db_namespaced_prefs[k] = v
            db.prefs.set_namespaced(DB_PREFS_NAMESPACE, DB_PREFS_KEY_SETTINGS, self.calm_target_library_db_namespaced_prefs)   #update metadata.db table=preferences...
        elif action == "print":
            #~ for k,v in self.calm_target_library_db_namespaced_prefs.iteritems():
            for k,v in iteritems(self.calm_target_library_db_namespaced_prefs):
                if DEBUG: print(as_unicode(k),as_unicode(v))
            #END FOR
        elif action == "transfer_once":
            was_transferred = self.transfer_namespaced_prefs_from_generating_library_to_target_library()
            if was_transferred:
                self.myparentprefs['CALM_TARGET_DB_GENERATING_NONCALM_LIBRARY_PATH'] = unicode_type("ZZ:||>>>||ZZ:")
                prefs['CALM_TARGET_DB_GENERATING_NONCALM_LIBRARY_PATH'] = unicode_type("ZZ:||>>>||ZZ:")
                prefs
                if DEBUG: print("transfer was completed, including updating of:   prefs['CALM_TARGET_DB_GENERATING_NONCALM_LIBRARY_PATH']")
            else:
                pass
        elif action == "db_upgrade":
            #~ for k,v in self.myparentprefs.iteritems():
            for k,v in iteritems(self.myparentprefs):
                self.calm_target_library_db_namespaced_prefs[k] = v
            db.prefs.set_namespaced(DB_PREFS_NAMESPACE, DB_PREFS_KEY_SETTINGS, self.calm_target_library_db_namespaced_prefs)   #update metadata.db table=preferences...
        else:
            pass

    #--------------------------------------------------------------------------------------------------
    def transfer_namespaced_prefs_from_generating_library_to_target_library(self):
        #~ DB_PREFS_NAMESPACE = 'CALMPlugin'
        #~ DB_PREFS_KEY_SETTINGS = 'CALMTargetDBSettings'
        #~ DB_PREFS_FULL_KEY = "namespaced:CALMPlugin:CALMTargetDBSettings"

        if DEBUG: print("executing:  transfer_namespaced_prefs_from_generating_library_to_target_library")

        s = prefs['CALM_TARGET_DB_GENERATING_NONCALM_LIBRARY_PATH']
        if not "||>>>||" in s:
            return False
        if "ZZ:" in s:
            return False
        s_split = s.split("||>>>||")
        if len(s_split) != 2:
            return False
        generating_path = s_split[0]
        target_path = s_split[1]
        generating_path = generating_path.strip()
        target_path = target_path.strip()
        if as_unicode(generating_path) == as_unicode(target_path):
            return False
        if as_unicode(self.current_target_library_path) != as_unicode(target_path):
            return False
        if not "/metadata.db" in generating_path:
            return False
        if not "/metadata.db" in target_path:
            return False
        my_db,my_cursor,is_valid = self.apsw_connect_to_target(target_path)
        if not is_valid:
            return False
        is_valid = self.apsw_attach_to_generating_db(my_db,my_cursor,generating_path)
        if not is_valid:
            my_db.close()
            return False

        try:
            my_cursor.execute("begin")
            mysql = "INSERT OR REPLACE INTO main.preferences SELECT null, 'namespaced:CALMPlugin:CALMTargetDBSettings',(SELECT val FROM GENERATING.preferences WHERE key = 'namespaced:CALMPlugin:CALMTargetDBSettings' ) "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            my_cursor.execute("begin")
            mysql = "DELETE FROM GENERATING.preferences WHERE key = 'namespaced:CALMPlugin:CALMTargetDBSettings'; "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            my_db.close()
            if DEBUG: print("named spaced db prefs were successfully transferred from the Generating library to the current Target library.")
            return True
        except Exception as e:
            my_db.close()
            if DEBUG: print("Exception: ", as_unicode(e))
            return False
    #--------------------------------------------------------------------------------------------------
    def maintain_generating_noncalm_library_namespaced_prefs(self,prefs_dict_to_save):
        #when executing a Consolidation from the library that just generated the CALM Target Library...
        db = self.guidb
        db.prefs.set_namespaced(DB_PREFS_NAMESPACE, DB_PREFS_KEY_SETTINGS, prefs_dict_to_save)             #update non-calm generating metadata.db table=preferences...
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def apsw_connect_to_target(self,path):

        try:
            my_db =apsw.Connection(path)
            is_valid = True
        except Exception as e:
            if DEBUG: print("path to target is: ", path)
            if DEBUG: print("error: ", as_unicode(e))
            is_valid = False
            return None,None,is_valid

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        return my_db,my_cursor,is_valid
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def apsw_attach_to_generating_db(self,my_db,my_cursor,generating_path):

        s1 = "ATTACH DATABASE '"
        s2 =  "'  As 'GENERATING' ;"

        path = generating_path.replace(os.sep, '/')
        if isbytestring(path):
            if DEBUG: print("path isbytestring: ", path)
            path = path.decode(filesystem_encoding)
            if DEBUG: print("path = path.decode(filesystem_encoding): decoded path is now: ", path)
        if DEBUG: print("filesystem_encoding is: ", str(filesystem_encoding))
        generating_path = path

        mysql = s1 + generating_path + s2

        try:
            if DEBUG: print("Attaching to the Generating DB: " + generating_path)
            my_cursor.execute (mysql)
            is_valid = True
        except Exception as e:
            if DEBUG: print("NOT Attached to Generating DB: " + as_unicode(generating_path))
            if DEBUG: print(as_unicode(e))
            is_valid = False

        mysql = "PRAGMA GENERATING.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        return is_valid
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class CALMSourceLibrariesTab(QWidget):

    def __init__(self,mygui,mymainprefs, prefsdefaults,mygprefs,myparam_dict,child_invocation_of_save_real_prefs_parent,
                            qt_source_tab_checkbox_objects_dict,qt_source_tab_qlineedit_objects_dict):
        super(CALMSourceLibrariesTab, self).__init__()

        #-----------------------------------------------------
        self.gui = mygui
        self.child_invocation_of_save_real_prefs_parent = child_invocation_of_save_real_prefs_parent
        self.qt_source_tab_qcheckbox_objects_dict = qt_source_tab_checkbox_objects_dict
        self.qt_source_tab_qlineedit_objects_dict = qt_source_tab_qlineedit_objects_dict
        #-----------------------------------------------------
        self.mysourceprefs = collections.OrderedDict([])
        tmp_list = []
        #~ for k,v in mymainprefs.iteritems():
        for k,v in iteritems(mymainprefs):
            if k.count("LIBRARY_PATH") > 0 or k.count('SOURCE_LIBRARIES') > 0 or k.count('GUI_LAST_UPDATE_DATETIME_SOURCE') > 0 :
                tmp_list.append(k)
        #END FOR
        self.mydefaults = deepcopy(prefsdefaults)
        del prefsdefaults
        #~ for k,v in self.mydefaults.iteritems():
        for k,v in iteritems(self.mydefaults):
            if k.count("LIBRARY_PATH") > 0 or k.count('SOURCE_LIBRARIES') > 0 or k.count('GUI_LAST_UPDATE_DATETIME_SOURCE') > 0 :
                tmp_list.append(k)
        #END FOR
        tmp_set = set(tmp_list)
        tmp_list = list(tmp_set)
        del tmp_set
        tmp_list.sort()
        for k in tmp_list:
            self.mysourceprefs[k] = ""
        #END FOR
        del tmp_list
        #~ for k,v in mymainprefs.iteritems():
        for k,v in iteritems(mymainprefs):
            if v:
                self.mysourceprefs[k] = v
            else:
                self.mysourceprefs[k] = ""
        #END FOR
        #-----------------------------------------------------
        self.gprefs = mygprefs
        #-----------------------------------------------------
        self.param_dict = myparam_dict
        #-----------------------------------------------------
        self.library_dict = collections.OrderedDict([])
        #-----------------------------------------------------
        self.init_tooltips_for_sources_tab()
        #-----------------------------------------------------

        font = QFont()
        font.setBold(False)
        font.setPointSize(10)

        #-----------------------------------------------------
        self.layout_top = QVBoxLayout()
        self.layout_top.setSpacing(0)
        self.layout_top.setAlignment(Qt.AlignLeft)
        self.setLayout(self.layout_top)
        #-----------------------------------------------------
        self.scroll_area_frame = QScrollArea()
        self.scroll_area_frame.setAlignment(Qt.AlignLeft)
        self.scroll_area_frame.setWidgetResizable(True)
        self.scroll_area_frame.ensureVisible(700,700)

        self.layout_top.addWidget(self.scroll_area_frame)       # the scroll area is now the child of the parent of self.layout_top

        # NOTE: the self.scroll_area_frame.setWidget(self.scroll_widget) is at the end of the init() AFTER all children have been created and assigned to a layout...

        #-----------------------------------------------------
        self.scroll_widget = QWidget()
        self.layout_top.addWidget(self.scroll_widget)           # causes automatic reparenting of QWidget to the parent of self.layout_top, which is:  self .
        #-----------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setAlignment(Qt.AlignCenter)

        self.scroll_widget.setLayout(self.layout_frame)        # causes automatic reparenting of any widget later added to self.layout_frame to the parent of self.layout_frame, which is:  QWidget .

        #-----------------------------------------------------
        self.libraries_groupbox = QGroupBox('Consolidation Source Libraries:')
        self.libraries_groupbox.setMaximumWidth(800)
        self.libraries_groupbox.setToolTip("<p style='white-space:wrap'>The 'Source Libraries' Tab is where you select All or Some of your Calibre Libraries for Consolidation into the 'Target Library'")
        self.layout_frame.addWidget(self.libraries_groupbox)

        self.libraries_layout = QGridLayout()
        self.libraries_groupbox.setLayout(self.libraries_layout)
        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setPointSize(8)
        font.setBold(True)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.libraries_last_saved_label = QLabel()
        self.libraries_last_saved_label.setTextFormat(Qt.PlainText)
        #~ self.libraries_last_saved_label.setText(self.mysourceprefs['GUI_LAST_UPDATE_DATETIME_SOURCE'])
        self.libraries_last_saved_label.setFont(font)
        self.libraries_last_saved_label.setToolTip("<p style='white-space:wrap'>The Date and Time Last Saved.")
        self.libraries_last_saved_label.setMinimumWidth(100)
        #~ self.libraries_last_saved_label.setMaximumWidth(500)

        self.libraries_layout.addWidget(self.libraries_last_saved_label,00,1)

        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setBold(False)
        font.setPointSize(10)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.libraries_buttonbox = QDialogButtonBox()
        self.libraries_buttonbox.setOrientation(Qt.Horizontal)
        self.libraries_buttonbox.setCenterButtons(True)
        #~ self.libraries_buttonbox.setMaximumWidth(600)

        self.libraries_layout.addWidget(self.libraries_buttonbox,1,1)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_load_known_libraries = QPushButton(" ", self)
        self.push_button_load_known_libraries.setText("Load All Libraries")
        self.push_button_load_known_libraries.clicked.connect(self.load_known_libraries)
        self.push_button_load_known_libraries.setFont(font)
        self.push_button_load_known_libraries.setToolTip("<p style='white-space:wrap'>If you have more than one (1) Library, this will load the entire list of Libraries that are known to Calibre, sorted alphabetically.  A hard maximum of 50 Source Libraries may be used by CALM, because only Generated Source Libraries may be consolidated.  ")

        self.libraries_buttonbox.addButton(self.push_button_load_known_libraries,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_check_all_libraries = QPushButton(" ", self)
        self.push_button_check_all_libraries.setText("Check All")
        self.push_button_check_all_libraries.clicked.connect(self.check_all_libraries)
        self.push_button_check_all_libraries.setFont(font)
        self.push_button_check_all_libraries.setToolTip("Check the entire list of Source Libraries.")

        self.libraries_buttonbox.addButton(self.push_button_check_all_libraries,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_uncheck_all_libraries = QPushButton(" ", self)
        self.push_button_uncheck_all_libraries.setText("Uncheck All")
        self.push_button_uncheck_all_libraries.clicked.connect(self.uncheck_all_libraries)
        self.push_button_uncheck_all_libraries.setFont(font)
        self.push_button_uncheck_all_libraries.setToolTip("<p style='white-space:wrap'>Uncheck the entire list of Source Libraries.")

        self.libraries_buttonbox.addButton(self.push_button_uncheck_all_libraries,QDialogButtonBox.AcceptRole)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_erase_unselected_libraries = QPushButton(" ", self)
        self.push_button_erase_unselected_libraries.setText("Erase All Unchecked")
        self.push_button_erase_unselected_libraries.clicked.connect(self.erase_unselected_libraries)
        self.push_button_erase_unselected_libraries.setFont(font)
        self.push_button_erase_unselected_libraries.setToolTip("<p style='white-space:wrap'>Erase Unchecked Libraries from the List.")

        self.libraries_buttonbox.addButton(self.push_button_erase_unselected_libraries,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_save_current_list_of_source_libraries = QPushButton(" ", self)
        self.push_button_save_current_list_of_source_libraries.setText("Save")
        self.push_button_save_current_list_of_source_libraries.setDefault(True)
        self.push_button_save_current_list_of_source_libraries.clicked.connect(self.save_current_list_of_source_libraries)
        self.push_button_save_current_list_of_source_libraries.setFont(font)
        self.push_button_save_current_list_of_source_libraries.setToolTip("Save this list of Libraries.  After the Target Tab 'Generates' this list, the paths in this list will be set to Read-Only.")

        self.libraries_buttonbox.addButton(self.push_button_save_current_list_of_source_libraries,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        #-----------------------------------------------------

        self.create_source_library_qlineedits()

        #-----------------------------------------------------
        self.current_number_of_source_libraries_checked = 0
        #-----------------------------------------------------
        # prefs cannot be loaded until all of the widgets have been created just above...
        #-----------------------------------------------------
        self.load_source_prefs_init()
        self.load_source_prefs()
        #-----------------------------------------------------
        # now, the widgets values can be defaulted from prefs...
        #-----------------------------------------------------
        try:
            msg = self.mysourceprefs['GUI_LAST_UPDATE_DATETIME_SOURCE']
        except:
            self.current_number_of_source_libraries_checked = 0
            msg = "Last Saved:  (never saved)        Number of 'Checked' Libraries Saved:   0 "
            self.mysourceprefs['GUI_LAST_UPDATE_DATETIME_SOURCE'] = unicode_type(msg)

        self.libraries_last_saved_label.setText(msg)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.save_param_dict()
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_widget.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.setWidget(self.scroll_widget)    # now that all widgets have been created and assigned to a layout...
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
   #-----------------------------------------------------------------------------------------------
   #-----------------------------------------------------------------------------------------------
    def save_current_list_of_source_libraries(self):

        self.libraries_last_saved_label.setText('saving...')
        self.update()
        QApplication.instance().processEvents()


        self.save_source_preferences()                # prior to optimization; self.mysourceprefs are set but not saved to prefs

        self.optimize_source_prefs()                   # self.mysourceprefs are updated after filtering non-paths and sorting paths, retaining checkmarks

        self.load_source_prefs()                         # after optimization but not yet saved.                                             example:  self.library_3.setText(self.mysourceprefs['LIBRARY_PATH_03'])

        self.libraries_last_saved_label.setText('still saving...please be patient')
        self.update()
        QApplication.instance().processEvents()


        self.save_source_preferences()              # saved after optimization and loading to qlineedit widget values.  example: self.mysourceprefs['LIBRARY_PATH_03'] = unicode_type(self.library_3.text())

        self.save_param_dict()                           # saved after qlineedit widget values loaded.                                    example: self.param_dict['LIBRARY_PATH_03'] = unicode_type(self.library_3.text())

        self.libraries_last_saved_label.setText('...almost finished...')
        self.update()
        QApplication.instance().processEvents()


        self.child_invocation_of_save_real_prefs_parent('Source Libraries')

        self.libraries_last_saved_label.setText(prefs['GUI_LAST_UPDATE_DATETIME_SOURCE'])
        self.update()
        QApplication.instance().processEvents()
    #-----------------------------------------------------------------------------------------------
    def save_param_dict(self):

        self.param_dict['LIBRARY_PATH_03'] = unicode_type(self.library_3.text())
        self.param_dict['LIBRARY_PATH_04'] = unicode_type(self.library_4.text())
        self.param_dict['LIBRARY_PATH_05'] = unicode_type(self.library_5.text())
        self.param_dict['LIBRARY_PATH_06'] = unicode_type(self.library_6.text())
        self.param_dict['LIBRARY_PATH_07'] = unicode_type(self.library_7.text())
        self.param_dict['LIBRARY_PATH_08'] = unicode_type(self.library_8.text())
        self.param_dict['LIBRARY_PATH_09'] = unicode_type(self.library_9.text())

        self.param_dict['LIBRARY_PATH_10'] = unicode_type(self.library_10.text())
        self.param_dict['LIBRARY_PATH_11'] = unicode_type(self.library_11.text())
        self.param_dict['LIBRARY_PATH_12'] = unicode_type(self.library_12.text())
        self.param_dict['LIBRARY_PATH_13'] = unicode_type(self.library_13.text())
        self.param_dict['LIBRARY_PATH_14'] = unicode_type(self.library_14.text())
        self.param_dict['LIBRARY_PATH_15'] = unicode_type(self.library_15.text())
        self.param_dict['LIBRARY_PATH_16'] = unicode_type(self.library_16.text())
        self.param_dict['LIBRARY_PATH_17'] = unicode_type(self.library_17.text())
        self.param_dict['LIBRARY_PATH_18'] = unicode_type(self.library_18.text())
        self.param_dict['LIBRARY_PATH_19'] = unicode_type(self.library_19.text())

        self.param_dict['LIBRARY_PATH_20'] = unicode_type(self.library_20.text())
        self.param_dict['LIBRARY_PATH_21'] = unicode_type(self.library_21.text())
        self.param_dict['LIBRARY_PATH_22'] = unicode_type(self.library_22.text())
        self.param_dict['LIBRARY_PATH_23'] = unicode_type(self.library_23.text())
        self.param_dict['LIBRARY_PATH_24'] = unicode_type(self.library_24.text())
        self.param_dict['LIBRARY_PATH_25'] = unicode_type(self.library_25.text())
        self.param_dict['LIBRARY_PATH_26'] = unicode_type(self.library_26.text())
        self.param_dict['LIBRARY_PATH_27'] = unicode_type(self.library_27.text())
        self.param_dict['LIBRARY_PATH_28'] = unicode_type(self.library_28.text())
        self.param_dict['LIBRARY_PATH_29'] = unicode_type(self.library_29.text())

        self.param_dict['LIBRARY_PATH_30'] = unicode_type(self.library_30.text())
        self.param_dict['LIBRARY_PATH_31'] = unicode_type(self.library_31.text())
        self.param_dict['LIBRARY_PATH_32'] = unicode_type(self.library_32.text())
        self.param_dict['LIBRARY_PATH_33'] = unicode_type(self.library_33.text())
        self.param_dict['LIBRARY_PATH_34'] = unicode_type(self.library_34.text())
        self.param_dict['LIBRARY_PATH_35'] = unicode_type(self.library_35.text())
        self.param_dict['LIBRARY_PATH_36'] = unicode_type(self.library_36.text())
        self.param_dict['LIBRARY_PATH_37'] = unicode_type(self.library_37.text())
        self.param_dict['LIBRARY_PATH_38'] = unicode_type(self.library_38.text())
        self.param_dict['LIBRARY_PATH_39'] = unicode_type(self.library_39.text())

        self.param_dict['LIBRARY_PATH_40'] = unicode_type(self.library_40.text())
        self.param_dict['LIBRARY_PATH_41'] = unicode_type(self.library_41.text())
        self.param_dict['LIBRARY_PATH_42'] = unicode_type(self.library_42.text())
        self.param_dict['LIBRARY_PATH_43'] = unicode_type(self.library_43.text())
        self.param_dict['LIBRARY_PATH_44'] = unicode_type(self.library_44.text())
        self.param_dict['LIBRARY_PATH_45'] = unicode_type(self.library_45.text())
        self.param_dict['LIBRARY_PATH_46'] = unicode_type(self.library_46.text())
        self.param_dict['LIBRARY_PATH_47'] = unicode_type(self.library_47.text())
        self.param_dict['LIBRARY_PATH_48'] = unicode_type(self.library_48.text())
        self.param_dict['LIBRARY_PATH_49'] = unicode_type(self.library_49.text())

        self.param_dict['LIBRARY_PATH_50'] = unicode_type(self.library_50.text())
        self.param_dict['LIBRARY_PATH_51'] = unicode_type(self.library_51.text())
        self.param_dict['LIBRARY_PATH_52'] = unicode_type(self.library_52.text())

        self.param_dict['LIBRARY_PATH_03_IS_ACTIVE'] = unicode_type(self.library_3_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_04_IS_ACTIVE'] = unicode_type(self.library_4_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_05_IS_ACTIVE'] = unicode_type(self.library_5_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_06_IS_ACTIVE'] = unicode_type(self.library_6_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_07_IS_ACTIVE'] = unicode_type(self.library_7_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_08_IS_ACTIVE'] = unicode_type(self.library_8_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_09_IS_ACTIVE'] = unicode_type(self.library_9_checkbox.isChecked())

        self.param_dict['LIBRARY_PATH_10_IS_ACTIVE'] = unicode_type(self.library_10_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_11_IS_ACTIVE'] = unicode_type(self.library_11_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_12_IS_ACTIVE'] = unicode_type(self.library_12_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_13_IS_ACTIVE'] = unicode_type(self.library_13_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_14_IS_ACTIVE'] = unicode_type(self.library_14_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_15_IS_ACTIVE'] = unicode_type(self.library_15_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_16_IS_ACTIVE'] = unicode_type(self.library_16_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_17_IS_ACTIVE'] = unicode_type(self.library_17_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_18_IS_ACTIVE'] = unicode_type(self.library_18_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_19_IS_ACTIVE'] = unicode_type(self.library_19_checkbox.isChecked())

        self.param_dict['LIBRARY_PATH_20_IS_ACTIVE'] = unicode_type(self.library_20_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_21_IS_ACTIVE'] = unicode_type(self.library_21_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_22_IS_ACTIVE'] = unicode_type(self.library_22_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_23_IS_ACTIVE'] = unicode_type(self.library_23_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_24_IS_ACTIVE'] = unicode_type(self.library_24_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_25_IS_ACTIVE'] = unicode_type(self.library_25_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_26_IS_ACTIVE'] = unicode_type(self.library_26_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_27_IS_ACTIVE'] = unicode_type(self.library_27_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_28_IS_ACTIVE'] = unicode_type(self.library_28_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_29_IS_ACTIVE'] = unicode_type(self.library_29_checkbox.isChecked())

        self.param_dict['LIBRARY_PATH_30_IS_ACTIVE'] = unicode_type(self.library_30_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_31_IS_ACTIVE'] = unicode_type(self.library_31_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_32_IS_ACTIVE'] = unicode_type(self.library_32_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_33_IS_ACTIVE'] = unicode_type(self.library_33_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_34_IS_ACTIVE'] = unicode_type(self.library_34_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_35_IS_ACTIVE'] = unicode_type(self.library_35_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_36_IS_ACTIVE'] = unicode_type(self.library_36_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_37_IS_ACTIVE'] = unicode_type(self.library_37_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_38_IS_ACTIVE'] = unicode_type(self.library_38_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_39_IS_ACTIVE'] = unicode_type(self.library_39_checkbox.isChecked())

        self.param_dict['LIBRARY_PATH_40_IS_ACTIVE'] = unicode_type(self.library_40_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_41_IS_ACTIVE'] = unicode_type(self.library_41_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_42_IS_ACTIVE'] = unicode_type(self.library_42_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_43_IS_ACTIVE'] = unicode_type(self.library_43_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_44_IS_ACTIVE'] = unicode_type(self.library_44_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_45_IS_ACTIVE'] = unicode_type(self.library_45_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_46_IS_ACTIVE'] = unicode_type(self.library_46_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_47_IS_ACTIVE'] = unicode_type(self.library_47_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_48_IS_ACTIVE'] = unicode_type(self.library_48_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_49_IS_ACTIVE'] = unicode_type(self.library_49_checkbox.isChecked())

        self.param_dict['LIBRARY_PATH_50_IS_ACTIVE'] = unicode_type(self.library_50_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_51_IS_ACTIVE'] = unicode_type(self.library_51_checkbox.isChecked())
        self.param_dict['LIBRARY_PATH_52_IS_ACTIVE'] = unicode_type(self.library_52_checkbox.isChecked())
    #-----------------------------------------------------------------------------------------------
    def save_source_preferences(self):

        s = "Last Saved: " + datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        s = s.strip()
        s = s + '     Currently Checked:   ' + as_unicode(self.current_number_of_source_libraries_checked)
        self.mysourceprefs['GUI_LAST_UPDATE_DATETIME_SOURCE'] = unicode_type(s)
        self.libraries_last_saved_label.setText(s)

        if DEBUG: print("Number of keys in self.mysourceprefs in 'save_source_preferences' : ", as_unicode(len(self.mysourceprefs)))

        self.mysourceprefs['GUI_NUMBER_SOURCE_LIBRARIES_LAST_SAVED'] = unicode_type(self.current_number_of_source_libraries_checked)

        self.mysourceprefs['LIBRARY_PATH_03'] = unicode_type(self.library_3.text())
        self.mysourceprefs['LIBRARY_PATH_04'] = unicode_type(self.library_4.text())
        self.mysourceprefs['LIBRARY_PATH_05'] = unicode_type(self.library_5.text())
        self.mysourceprefs['LIBRARY_PATH_06'] = unicode_type(self.library_6.text())
        self.mysourceprefs['LIBRARY_PATH_07'] = unicode_type(self.library_7.text())
        self.mysourceprefs['LIBRARY_PATH_08'] = unicode_type(self.library_8.text())
        self.mysourceprefs['LIBRARY_PATH_09'] = unicode_type(self.library_9.text())

        self.mysourceprefs['LIBRARY_PATH_10'] = unicode_type(self.library_10.text())
        self.mysourceprefs['LIBRARY_PATH_11'] = unicode_type(self.library_11.text())
        self.mysourceprefs['LIBRARY_PATH_12'] = unicode_type(self.library_12.text())
        self.mysourceprefs['LIBRARY_PATH_13'] = unicode_type(self.library_13.text())
        self.mysourceprefs['LIBRARY_PATH_14'] = unicode_type(self.library_14.text())
        self.mysourceprefs['LIBRARY_PATH_15'] = unicode_type(self.library_15.text())
        self.mysourceprefs['LIBRARY_PATH_16'] = unicode_type(self.library_16.text())
        self.mysourceprefs['LIBRARY_PATH_17'] = unicode_type(self.library_17.text())
        self.mysourceprefs['LIBRARY_PATH_18'] = unicode_type(self.library_18.text())
        self.mysourceprefs['LIBRARY_PATH_19'] = unicode_type(self.library_19.text())

        self.mysourceprefs['LIBRARY_PATH_20'] = unicode_type(self.library_20.text())
        self.mysourceprefs['LIBRARY_PATH_21'] = unicode_type(self.library_21.text())
        self.mysourceprefs['LIBRARY_PATH_22'] = unicode_type(self.library_22.text())
        self.mysourceprefs['LIBRARY_PATH_23'] = unicode_type(self.library_23.text())
        self.mysourceprefs['LIBRARY_PATH_24'] = unicode_type(self.library_24.text())
        self.mysourceprefs['LIBRARY_PATH_25'] = unicode_type(self.library_25.text())
        self.mysourceprefs['LIBRARY_PATH_26'] = unicode_type(self.library_26.text())
        self.mysourceprefs['LIBRARY_PATH_27'] = unicode_type(self.library_27.text())
        self.mysourceprefs['LIBRARY_PATH_28'] = unicode_type(self.library_28.text())
        self.mysourceprefs['LIBRARY_PATH_29'] = unicode_type(self.library_29.text())

        self.mysourceprefs['LIBRARY_PATH_30'] = unicode_type(self.library_30.text())
        self.mysourceprefs['LIBRARY_PATH_31'] = unicode_type(self.library_31.text())
        self.mysourceprefs['LIBRARY_PATH_32'] = unicode_type(self.library_32.text())
        self.mysourceprefs['LIBRARY_PATH_33'] = unicode_type(self.library_33.text())
        self.mysourceprefs['LIBRARY_PATH_34'] = unicode_type(self.library_34.text())
        self.mysourceprefs['LIBRARY_PATH_35'] = unicode_type(self.library_35.text())
        self.mysourceprefs['LIBRARY_PATH_36'] = unicode_type(self.library_36.text())
        self.mysourceprefs['LIBRARY_PATH_37'] = unicode_type(self.library_37.text())
        self.mysourceprefs['LIBRARY_PATH_38'] = unicode_type(self.library_38.text())
        self.mysourceprefs['LIBRARY_PATH_39'] = unicode_type(self.library_39.text())

        self.mysourceprefs['LIBRARY_PATH_40'] = unicode_type(self.library_40.text())
        self.mysourceprefs['LIBRARY_PATH_41'] = unicode_type(self.library_41.text())
        self.mysourceprefs['LIBRARY_PATH_42'] = unicode_type(self.library_42.text())
        self.mysourceprefs['LIBRARY_PATH_43'] = unicode_type(self.library_43.text())
        self.mysourceprefs['LIBRARY_PATH_44'] = unicode_type(self.library_44.text())
        self.mysourceprefs['LIBRARY_PATH_45'] = unicode_type(self.library_45.text())
        self.mysourceprefs['LIBRARY_PATH_46'] = unicode_type(self.library_46.text())
        self.mysourceprefs['LIBRARY_PATH_47'] = unicode_type(self.library_47.text())
        self.mysourceprefs['LIBRARY_PATH_48'] = unicode_type(self.library_48.text())
        self.mysourceprefs['LIBRARY_PATH_49'] = unicode_type(self.library_49.text())

        self.mysourceprefs['LIBRARY_PATH_50'] = unicode_type(self.library_50.text())
        self.mysourceprefs['LIBRARY_PATH_51'] = unicode_type(self.library_51.text())
        self.mysourceprefs['LIBRARY_PATH_52'] = unicode_type(self.library_52.text())

        self.mysourceprefs['LIBRARY_PATH_03_IS_ACTIVE'] = unicode_type(self.library_3_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_04_IS_ACTIVE'] = unicode_type(self.library_4_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_05_IS_ACTIVE'] = unicode_type(self.library_5_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_06_IS_ACTIVE'] = unicode_type(self.library_6_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_07_IS_ACTIVE'] = unicode_type(self.library_7_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_08_IS_ACTIVE'] = unicode_type(self.library_8_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_09_IS_ACTIVE'] = unicode_type(self.library_9_checkbox.isChecked())

        self.mysourceprefs['LIBRARY_PATH_10_IS_ACTIVE'] = unicode_type(self.library_10_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_11_IS_ACTIVE'] = unicode_type(self.library_11_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_12_IS_ACTIVE'] = unicode_type(self.library_12_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_13_IS_ACTIVE'] = unicode_type(self.library_13_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_14_IS_ACTIVE'] = unicode_type(self.library_14_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_15_IS_ACTIVE'] = unicode_type(self.library_15_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_16_IS_ACTIVE'] = unicode_type(self.library_16_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_17_IS_ACTIVE'] = unicode_type(self.library_17_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_18_IS_ACTIVE'] = unicode_type(self.library_18_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_19_IS_ACTIVE'] = unicode_type(self.library_19_checkbox.isChecked())

        self.mysourceprefs['LIBRARY_PATH_20_IS_ACTIVE'] = unicode_type(self.library_20_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_21_IS_ACTIVE'] = unicode_type(self.library_21_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_22_IS_ACTIVE'] = unicode_type(self.library_22_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_23_IS_ACTIVE'] = unicode_type(self.library_23_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_24_IS_ACTIVE'] = unicode_type(self.library_24_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_25_IS_ACTIVE'] = unicode_type(self.library_25_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_26_IS_ACTIVE'] = unicode_type(self.library_26_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_27_IS_ACTIVE'] = unicode_type(self.library_27_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_28_IS_ACTIVE'] = unicode_type(self.library_28_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_29_IS_ACTIVE'] = unicode_type(self.library_29_checkbox.isChecked())

        self.mysourceprefs['LIBRARY_PATH_30_IS_ACTIVE'] = unicode_type(self.library_30_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_31_IS_ACTIVE'] = unicode_type(self.library_31_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_32_IS_ACTIVE'] = unicode_type(self.library_32_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_33_IS_ACTIVE'] = unicode_type(self.library_33_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_34_IS_ACTIVE'] = unicode_type(self.library_34_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_35_IS_ACTIVE'] = unicode_type(self.library_35_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_36_IS_ACTIVE'] = unicode_type(self.library_36_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_37_IS_ACTIVE'] = unicode_type(self.library_37_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_38_IS_ACTIVE'] = unicode_type(self.library_38_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_39_IS_ACTIVE'] = unicode_type(self.library_39_checkbox.isChecked())

        self.mysourceprefs['LIBRARY_PATH_40_IS_ACTIVE'] = unicode_type(self.library_40_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_41_IS_ACTIVE'] = unicode_type(self.library_41_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_42_IS_ACTIVE'] = unicode_type(self.library_42_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_43_IS_ACTIVE'] = unicode_type(self.library_43_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_44_IS_ACTIVE'] = unicode_type(self.library_44_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_45_IS_ACTIVE'] = unicode_type(self.library_45_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_46_IS_ACTIVE'] = unicode_type(self.library_46_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_47_IS_ACTIVE'] = unicode_type(self.library_47_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_48_IS_ACTIVE'] = unicode_type(self.library_48_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_49_IS_ACTIVE'] = unicode_type(self.library_49_checkbox.isChecked())

        self.mysourceprefs['LIBRARY_PATH_50_IS_ACTIVE'] = unicode_type(self.library_50_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_51_IS_ACTIVE'] = unicode_type(self.library_51_checkbox.isChecked())
        self.mysourceprefs['LIBRARY_PATH_52_IS_ACTIVE'] = unicode_type(self.library_52_checkbox.isChecked())

        self.mysourceprefs_copy = self.mysourceprefs.copy()
        #~ for k,v in self.mysourceprefs_copy.iteritems():
        for k,v in iteritems(self.mysourceprefs_copy):
            if k:
                if k.count("LIBRARY_PATH_") > 0 :
                    if k.count("IS_ACTIVE") == 0 :
                        #~ if DEBUG: print("k,v in self.mysourceprefs_copy.iteritems(): ", as_unicode(k), as_unicode(v))
                        if v:
                            #~ if DEBUG: print("if v: ", as_unicode(v))
                            continue
                        else:  #   None
                            #~ if DEBUG: print("else if not v: ", as_unicode(v))
                            self.mysourceprefs[k] = unicode_type("")
        #END FOR
        del self.mysourceprefs_copy

        self.child_invocation_of_save_real_prefs_parent("Source Libraries")
    #-----------------------------------------------------------------------------------------------
    def validate(self):
        return True
    #-----------------------------------------------------------------------------------------------
    def get_gprefs_library_usage_stats(self):
        # has the complete list of all currently known Calibre libraries

        self.library_dict.clear()       # which is an ordered dict...

        stats = self.gprefs.get('library_usage_stats', {})

        tmp_list = []
        #~ for k,v in stats.iteritems():
        for k,v in iteritems(stats):
            k = k.strip()
            k = unicode_type(k)
            line = v,k
            tmp_list.append(line)
        #END FOR

        del stats

        tmp_list.sort()
        for row in tmp_list:
            v,k = row
            if k:
                if k > " ":
                    if k != "00" and k != "01" and k != "02":
                        self.library_dict[k] =  "0"
        #END FOR

        del tmp_list
    #-----------------------------------------------------------------------------------------------
    def load_known_libraries(self):

        self.get_gprefs_library_usage_stats()

        try:
            del library_list
        except:
            pass

        library_list = []

        for k,v in iteritems(self.library_dict):
            k = k.strip()
            if 'calm' in k.lower():    # do not help them create a validation error
                continue
            if k == "!00" or k == "!01" or k == "!02":
                continue
            if k == "00" or k == "01" or k == "02":
                continue
            if k > " ":
                library_list.append(k)
        #END FOR

        if DEBUG:
            print("Number of known libraries: ", as_unicode(len(library_list)))
            for row in library_list:
                print("Known Library: ", row)

        library_list.append("!00")    # placeholders.  the real source path values begin with index = 3 so that the QGridLayout row number always equals its index...
        library_list.append("!01")    # ! sorts before / which is the first character in an OSX and Linux library path.
        library_list.append("!02")    # ! and numbers sort before letters which are the first character in a Windows path.

        library_list.sort()    # stats come in sorted descending by most commonly used, but resort here alphabetically since only a maximum of 50 source libraries are allowed at once, ever.

        for x in range(0,60):
            library_list.append('')

        self.library_3.setText(library_list[3])  # skip the placeholders
        self.library_4.setText(library_list[4])
        self.library_5.setText(library_list[5])
        self.library_6.setText(library_list[6])
        self.library_7.setText(library_list[7])
        self.library_8.setText(library_list[8])
        self.library_9.setText(library_list[9])

        self.library_10.setText(library_list[10])
        self.library_11.setText(library_list[11])
        self.library_12.setText(library_list[12])
        self.library_13.setText(library_list[13])
        self.library_14.setText(library_list[14])
        self.library_15.setText(library_list[15])
        self.library_16.setText(library_list[16])
        self.library_17.setText(library_list[17])
        self.library_18.setText(library_list[18])
        self.library_19.setText(library_list[19])

        self.library_20.setText(library_list[20])
        self.library_21.setText(library_list[21])
        self.library_22.setText(library_list[22])
        self.library_23.setText(library_list[23])
        self.library_24.setText(library_list[24])
        self.library_25.setText(library_list[25])
        self.library_26.setText(library_list[26])
        self.library_27.setText(library_list[27])
        self.library_28.setText(library_list[28])
        self.library_29.setText(library_list[29])

        self.library_30.setText(library_list[30])
        self.library_31.setText(library_list[31])
        self.library_32.setText(library_list[32])
        self.library_33.setText(library_list[33])
        self.library_34.setText(library_list[34])
        self.library_35.setText(library_list[35])
        self.library_36.setText(library_list[36])
        self.library_37.setText(library_list[37])
        self.library_38.setText(library_list[38])
        self.library_39.setText(library_list[39])

        self.library_40.setText(library_list[40])
        self.library_41.setText(library_list[41])
        self.library_42.setText(library_list[42])
        self.library_43.setText(library_list[43])
        self.library_44.setText(library_list[44])
        self.library_45.setText(library_list[45])
        self.library_46.setText(library_list[46])
        self.library_47.setText(library_list[47])
        self.library_48.setText(library_list[48])
        self.library_49.setText(library_list[49])

        self.library_50.setText(library_list[50])
        self.library_51.setText(library_list[51])
        self.library_52.setText(library_list[52])


        self.library_3_checkbox.setChecked(False)
        self.library_4_checkbox.setChecked(False)
        self.library_5_checkbox.setChecked(False)
        self.library_6_checkbox.setChecked(False)
        self.library_7_checkbox.setChecked(False)
        self.library_8_checkbox.setChecked(False)
        self.library_9_checkbox.setChecked(False)

        self.library_10_checkbox.setChecked(False)
        self.library_11_checkbox.setChecked(False)
        self.library_12_checkbox.setChecked(False)
        self.library_13_checkbox.setChecked(False)
        self.library_14_checkbox.setChecked(False)
        self.library_15_checkbox.setChecked(False)
        self.library_16_checkbox.setChecked(False)
        self.library_17_checkbox.setChecked(False)
        self.library_18_checkbox.setChecked(False)
        self.library_19_checkbox.setChecked(False)

        self.library_20_checkbox.setChecked(False)
        self.library_21_checkbox.setChecked(False)
        self.library_22_checkbox.setChecked(False)
        self.library_23_checkbox.setChecked(False)
        self.library_24_checkbox.setChecked(False)
        self.library_25_checkbox.setChecked(False)
        self.library_26_checkbox.setChecked(False)
        self.library_27_checkbox.setChecked(False)
        self.library_28_checkbox.setChecked(False)
        self.library_29_checkbox.setChecked(False)

        self.library_30_checkbox.setChecked(False)
        self.library_31_checkbox.setChecked(False)
        self.library_32_checkbox.setChecked(False)
        self.library_33_checkbox.setChecked(False)
        self.library_34_checkbox.setChecked(False)
        self.library_35_checkbox.setChecked(False)
        self.library_36_checkbox.setChecked(False)
        self.library_37_checkbox.setChecked(False)
        self.library_38_checkbox.setChecked(False)
        self.library_39_checkbox.setChecked(False)

        self.library_40_checkbox.setChecked(False)
        self.library_41_checkbox.setChecked(False)
        self.library_42_checkbox.setChecked(False)
        self.library_43_checkbox.setChecked(False)
        self.library_44_checkbox.setChecked(False)
        self.library_45_checkbox.setChecked(False)
        self.library_46_checkbox.setChecked(False)
        self.library_47_checkbox.setChecked(False)
        self.library_48_checkbox.setChecked(False)
        self.library_49_checkbox.setChecked(False)

        self.library_50_checkbox.setChecked(False)
        self.library_51_checkbox.setChecked(False)
        self.library_52_checkbox.setChecked(False)

        del library_list
    #-----------------------------------------------------------------------------------------------
    def load_source_prefs_init(self):
        # ONLY called from __init__
        # initializes self.mysourceprefs from prefs.defaults if the keys do not exist yet

        try:
            s = self.mysourceprefs['LIBRARY_PATH_03']
            s = self.mysourceprefs['LIBRARY_PATH_52_IS_ACTIVE']
            if DEBUG: print("Number of keys in self.mysourceprefs in 'load_source_prefs_init' : ", as_unicode(len(self.mysourceprefs)))
            return
        except:
            if DEBUG: print("Number of keys in self.mydefaults in 'load_source_prefs_init' : ", as_unicode(len(self.mydefaults)))
            self.mysourceprefs['LIBRARY_PATH_03'] = self.mydefaults['LIBRARY_PATH_03']
            self.mysourceprefs['LIBRARY_PATH_04'] = self.mydefaults['LIBRARY_PATH_04']
            self.mysourceprefs['LIBRARY_PATH_05'] = self.mydefaults['LIBRARY_PATH_05']
            self.mysourceprefs['LIBRARY_PATH_06'] = self.mydefaults['LIBRARY_PATH_06']
            self.mysourceprefs['LIBRARY_PATH_07'] = self.mydefaults['LIBRARY_PATH_07']
            self.mysourceprefs['LIBRARY_PATH_08'] = self.mydefaults['LIBRARY_PATH_08']
            self.mysourceprefs['LIBRARY_PATH_09'] = self.mydefaults['LIBRARY_PATH_09']

            self.mysourceprefs['LIBRARY_PATH_10'] = self.mydefaults['LIBRARY_PATH_10']
            self.mysourceprefs['LIBRARY_PATH_11'] = self.mydefaults['LIBRARY_PATH_11']
            self.mysourceprefs['LIBRARY_PATH_12'] = self.mydefaults['LIBRARY_PATH_12']
            self.mysourceprefs['LIBRARY_PATH_13'] = self.mydefaults['LIBRARY_PATH_13']
            self.mysourceprefs['LIBRARY_PATH_14'] = self.mydefaults['LIBRARY_PATH_14']
            self.mysourceprefs['LIBRARY_PATH_15'] = self.mydefaults['LIBRARY_PATH_15']
            self.mysourceprefs['LIBRARY_PATH_16'] = self.mydefaults['LIBRARY_PATH_16']
            self.mysourceprefs['LIBRARY_PATH_17'] = self.mydefaults['LIBRARY_PATH_17']
            self.mysourceprefs['LIBRARY_PATH_18'] = self.mydefaults['LIBRARY_PATH_18']
            self.mysourceprefs['LIBRARY_PATH_19'] = self.mydefaults['LIBRARY_PATH_19']

            self.mysourceprefs['LIBRARY_PATH_20'] = self.mydefaults['LIBRARY_PATH_20']
            self.mysourceprefs['LIBRARY_PATH_21'] = self.mydefaults['LIBRARY_PATH_21']
            self.mysourceprefs['LIBRARY_PATH_22'] = self.mydefaults['LIBRARY_PATH_22']
            self.mysourceprefs['LIBRARY_PATH_23'] = self.mydefaults['LIBRARY_PATH_23']
            self.mysourceprefs['LIBRARY_PATH_24'] = self.mydefaults['LIBRARY_PATH_24']
            self.mysourceprefs['LIBRARY_PATH_25'] = self.mydefaults['LIBRARY_PATH_25']
            self.mysourceprefs['LIBRARY_PATH_26'] = self.mydefaults['LIBRARY_PATH_26']
            self.mysourceprefs['LIBRARY_PATH_27'] = self.mydefaults['LIBRARY_PATH_27']
            self.mysourceprefs['LIBRARY_PATH_28'] = self.mydefaults['LIBRARY_PATH_28']
            self.mysourceprefs['LIBRARY_PATH_29'] = self.mydefaults['LIBRARY_PATH_29']

            self.mysourceprefs['LIBRARY_PATH_30'] = self.mydefaults['LIBRARY_PATH_30']
            self.mysourceprefs['LIBRARY_PATH_31'] = self.mydefaults['LIBRARY_PATH_31']
            self.mysourceprefs['LIBRARY_PATH_32'] = self.mydefaults['LIBRARY_PATH_32']
            self.mysourceprefs['LIBRARY_PATH_33'] = self.mydefaults['LIBRARY_PATH_33']
            self.mysourceprefs['LIBRARY_PATH_34'] = self.mydefaults['LIBRARY_PATH_34']
            self.mysourceprefs['LIBRARY_PATH_35'] = self.mydefaults['LIBRARY_PATH_35']
            self.mysourceprefs['LIBRARY_PATH_36'] = self.mydefaults['LIBRARY_PATH_36']
            self.mysourceprefs['LIBRARY_PATH_37'] = self.mydefaults['LIBRARY_PATH_37']
            self.mysourceprefs['LIBRARY_PATH_38'] = self.mydefaults['LIBRARY_PATH_38']
            self.mysourceprefs['LIBRARY_PATH_39'] = self.mydefaults['LIBRARY_PATH_39']

            self.mysourceprefs['LIBRARY_PATH_40'] = self.mydefaults['LIBRARY_PATH_40']
            self.mysourceprefs['LIBRARY_PATH_41'] = self.mydefaults['LIBRARY_PATH_41']
            self.mysourceprefs['LIBRARY_PATH_42'] = self.mydefaults['LIBRARY_PATH_42']
            self.mysourceprefs['LIBRARY_PATH_43'] = self.mydefaults['LIBRARY_PATH_43']
            self.mysourceprefs['LIBRARY_PATH_44'] = self.mydefaults['LIBRARY_PATH_44']
            self.mysourceprefs['LIBRARY_PATH_45'] = self.mydefaults['LIBRARY_PATH_45']
            self.mysourceprefs['LIBRARY_PATH_46'] = self.mydefaults['LIBRARY_PATH_46']
            self.mysourceprefs['LIBRARY_PATH_47'] = self.mydefaults['LIBRARY_PATH_47']
            self.mysourceprefs['LIBRARY_PATH_48'] = self.mydefaults['LIBRARY_PATH_48']
            self.mysourceprefs['LIBRARY_PATH_49'] = self.mydefaults['LIBRARY_PATH_49']

            self.mysourceprefs['LIBRARY_PATH_50'] = self.mydefaults['LIBRARY_PATH_50']
            self.mysourceprefs['LIBRARY_PATH_51'] = self.mydefaults['LIBRARY_PATH_51']
            self.mysourceprefs['LIBRARY_PATH_52'] = self.mydefaults['LIBRARY_PATH_52']


            self.mysourceprefs['LIBRARY_PATH_03_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_03_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_04_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_04_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_05_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_05_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_06_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_06_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_07_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_07_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_08_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_08_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_09_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_09_IS_ACTIVE']

            self.mysourceprefs['LIBRARY_PATH_10_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_10_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_11_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_11_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_12_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_12_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_13_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_13_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_14_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_14_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_15_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_15_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_16_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_16_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_17_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_17_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_18_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_18_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_19_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_19_IS_ACTIVE']

            self.mysourceprefs['LIBRARY_PATH_20_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_20_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_21_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_21_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_22_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_22_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_23_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_23_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_24_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_24_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_25_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_25_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_26_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_26_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_27_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_27_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_28_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_28_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_29_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_29_IS_ACTIVE']

            self.mysourceprefs['LIBRARY_PATH_30_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_30_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_31_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_31_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_32_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_32_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_33_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_33_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_34_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_34_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_35_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_35_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_36_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_36_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_37_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_37_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_38_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_38_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_39_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_39_IS_ACTIVE']

            self.mysourceprefs['LIBRARY_PATH_40_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_40_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_41_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_41_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_42_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_42_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_43_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_43_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_44_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_44_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_45_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_45_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_46_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_46_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_47_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_47_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_48_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_48_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_49_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_49_IS_ACTIVE']

            self.mysourceprefs['LIBRARY_PATH_50_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_50_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_51_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_51_IS_ACTIVE']
            self.mysourceprefs['LIBRARY_PATH_52_IS_ACTIVE'] = self.mydefaults['LIBRARY_PATH_52_IS_ACTIVE']

            if DEBUG: print("Number of keys in self.mysourceprefs in 'load_source_prefs_init' : ", as_unicode(len(self.mysourceprefs)))
    #-----------------------------------------------------------------------------------------------
    def load_source_prefs(self):

        if DEBUG: print("Number of keys in self.mysourceprefs in 'load_source_prefs' : ", as_unicode(len(self.mysourceprefs)))

        self.sanitize_placeholders()

        self.library_3.setText(self.mysourceprefs['LIBRARY_PATH_03'])
        self.library_4.setText(self.mysourceprefs['LIBRARY_PATH_04'])
        self.library_5.setText(self.mysourceprefs['LIBRARY_PATH_05'])
        self.library_6.setText(self.mysourceprefs['LIBRARY_PATH_06'])
        self.library_7.setText(self.mysourceprefs['LIBRARY_PATH_07'])
        self.library_8.setText(self.mysourceprefs['LIBRARY_PATH_08'])
        self.library_9.setText(self.mysourceprefs['LIBRARY_PATH_09'])

        self.library_10.setText(self.mysourceprefs['LIBRARY_PATH_10'])
        self.library_11.setText(self.mysourceprefs['LIBRARY_PATH_11'])
        self.library_12.setText(self.mysourceprefs['LIBRARY_PATH_12'])
        self.library_13.setText(self.mysourceprefs['LIBRARY_PATH_13'])
        self.library_14.setText(self.mysourceprefs['LIBRARY_PATH_14'])
        self.library_15.setText(self.mysourceprefs['LIBRARY_PATH_15'])
        self.library_16.setText(self.mysourceprefs['LIBRARY_PATH_16'])
        self.library_17.setText(self.mysourceprefs['LIBRARY_PATH_17'])
        self.library_18.setText(self.mysourceprefs['LIBRARY_PATH_18'])
        self.library_19.setText(self.mysourceprefs['LIBRARY_PATH_19'])

        self.library_20.setText(self.mysourceprefs['LIBRARY_PATH_20'])
        self.library_21.setText(self.mysourceprefs['LIBRARY_PATH_21'])
        self.library_22.setText(self.mysourceprefs['LIBRARY_PATH_22'])
        self.library_23.setText(self.mysourceprefs['LIBRARY_PATH_23'])
        self.library_24.setText(self.mysourceprefs['LIBRARY_PATH_24'])
        self.library_25.setText(self.mysourceprefs['LIBRARY_PATH_25'])
        self.library_26.setText(self.mysourceprefs['LIBRARY_PATH_26'])
        self.library_27.setText(self.mysourceprefs['LIBRARY_PATH_27'])
        self.library_28.setText(self.mysourceprefs['LIBRARY_PATH_28'])
        self.library_29.setText(self.mysourceprefs['LIBRARY_PATH_29'])

        self.library_30.setText(self.mysourceprefs['LIBRARY_PATH_30'])
        self.library_31.setText(self.mysourceprefs['LIBRARY_PATH_31'])
        self.library_32.setText(self.mysourceprefs['LIBRARY_PATH_32'])
        self.library_33.setText(self.mysourceprefs['LIBRARY_PATH_33'])
        self.library_34.setText(self.mysourceprefs['LIBRARY_PATH_34'])
        self.library_35.setText(self.mysourceprefs['LIBRARY_PATH_35'])
        self.library_36.setText(self.mysourceprefs['LIBRARY_PATH_36'])
        self.library_37.setText(self.mysourceprefs['LIBRARY_PATH_37'])
        self.library_38.setText(self.mysourceprefs['LIBRARY_PATH_38'])
        self.library_39.setText(self.mysourceprefs['LIBRARY_PATH_39'])

        self.library_40.setText(self.mysourceprefs['LIBRARY_PATH_40'])
        self.library_41.setText(self.mysourceprefs['LIBRARY_PATH_41'])
        self.library_42.setText(self.mysourceprefs['LIBRARY_PATH_42'])
        self.library_43.setText(self.mysourceprefs['LIBRARY_PATH_43'])
        self.library_44.setText(self.mysourceprefs['LIBRARY_PATH_44'])
        self.library_45.setText(self.mysourceprefs['LIBRARY_PATH_45'])
        self.library_46.setText(self.mysourceprefs['LIBRARY_PATH_46'])
        self.library_47.setText(self.mysourceprefs['LIBRARY_PATH_47'])
        self.library_48.setText(self.mysourceprefs['LIBRARY_PATH_48'])
        self.library_49.setText(self.mysourceprefs['LIBRARY_PATH_49'])

        self.library_50.setText(self.mysourceprefs['LIBRARY_PATH_50'])
        self.library_51.setText(self.mysourceprefs['LIBRARY_PATH_51'])
        self.library_52.setText(self.mysourceprefs['LIBRARY_PATH_52'])

        self.library_3_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_03_IS_ACTIVE']))
        self.library_4_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_04_IS_ACTIVE']))
        self.library_5_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_05_IS_ACTIVE']))
        self.library_6_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_06_IS_ACTIVE']))
        self.library_7_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_07_IS_ACTIVE']))
        self.library_8_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_08_IS_ACTIVE']))
        self.library_9_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_09_IS_ACTIVE']))

        self.library_10_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_10_IS_ACTIVE']))
        self.library_11_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_11_IS_ACTIVE']))
        self.library_12_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_12_IS_ACTIVE']))
        self.library_13_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_13_IS_ACTIVE']))
        self.library_14_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_14_IS_ACTIVE']))
        self.library_15_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_15_IS_ACTIVE']))
        self.library_16_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_16_IS_ACTIVE']))
        self.library_17_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_17_IS_ACTIVE']))
        self.library_18_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_18_IS_ACTIVE']))
        self.library_19_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_19_IS_ACTIVE']))

        self.library_20_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_20_IS_ACTIVE']))
        self.library_21_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_21_IS_ACTIVE']))
        self.library_22_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_22_IS_ACTIVE']))
        self.library_23_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_23_IS_ACTIVE']))
        self.library_24_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_24_IS_ACTIVE']))
        self.library_25_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_25_IS_ACTIVE']))
        self.library_26_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_26_IS_ACTIVE']))
        self.library_27_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_27_IS_ACTIVE']))
        self.library_28_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_28_IS_ACTIVE']))
        self.library_29_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_29_IS_ACTIVE']))

        self.library_30_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_30_IS_ACTIVE']))
        self.library_31_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_31_IS_ACTIVE']))
        self.library_32_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_32_IS_ACTIVE']))
        self.library_33_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_33_IS_ACTIVE']))
        self.library_34_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_34_IS_ACTIVE']))
        self.library_35_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_35_IS_ACTIVE']))
        self.library_36_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_36_IS_ACTIVE']))
        self.library_37_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_37_IS_ACTIVE']))
        self.library_38_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_38_IS_ACTIVE']))
        self.library_39_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_39_IS_ACTIVE']))

        self.library_40_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_40_IS_ACTIVE']))
        self.library_41_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_41_IS_ACTIVE']))
        self.library_42_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_42_IS_ACTIVE']))
        self.library_43_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_43_IS_ACTIVE']))
        self.library_44_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_44_IS_ACTIVE']))
        self.library_45_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_45_IS_ACTIVE']))
        self.library_46_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_46_IS_ACTIVE']))
        self.library_47_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_47_IS_ACTIVE']))
        self.library_48_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_48_IS_ACTIVE']))
        self.library_49_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_49_IS_ACTIVE']))

        self.library_50_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_50_IS_ACTIVE']))
        self.library_51_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_51_IS_ACTIVE']))
        self.library_52_checkbox.setChecked(self.str_to_bool(self.mysourceprefs['LIBRARY_PATH_52_IS_ACTIVE']))

        try:
            self.libraries_last_saved_label.setText(self.mysourceprefs['GUI_LAST_UPDATE_DATETIME_SOURCE'])
        except:
            pass
    #-----------------------------------------------------------------------------------------------
    def str_to_bool(self,s):
        s = as_unicode(s)
        s = as_unicode(s.strip())
        if s == as_unicode('True'):
             return True
        else:
            return False
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def erase_unselected_libraries(self):

        if not self.library_3_checkbox.isChecked():
            self.library_3.setText("")
        if not self.library_4_checkbox.isChecked():
            self.library_4.setText("")
        if not self.library_5_checkbox.isChecked():
            self.library_5.setText("")
        if not self.library_6_checkbox.isChecked():
            self.library_6.setText("")
        if not self.library_7_checkbox.isChecked():
            self.library_7.setText("")
        if not self.library_8_checkbox.isChecked():
            self.library_8.setText("")
        if not self.library_9_checkbox.isChecked():
            self.library_9.setText("")

        if not self.library_10_checkbox.isChecked():
            self.library_10.setText("")
        if not self.library_11_checkbox.isChecked():
            self.library_11.setText("")
        if not self.library_12_checkbox.isChecked():
            self.library_12.setText("")
        if not self.library_13_checkbox.isChecked():
            self.library_13.setText("")
        if not self.library_14_checkbox.isChecked():
            self.library_14.setText("")
        if not self.library_15_checkbox.isChecked():
            self.library_15.setText("")
        if not self.library_16_checkbox.isChecked():
            self.library_16.setText("")
        if not self.library_17_checkbox.isChecked():
            self.library_17.setText("")
        if not self.library_18_checkbox.isChecked():
            self.library_18.setText("")
        if not self.library_19_checkbox.isChecked():
            self.library_19.setText("")

        if not self.library_20_checkbox.isChecked():
            self.library_20.setText("")
        if not self.library_21_checkbox.isChecked():
            self.library_21.setText("")
        if not self.library_22_checkbox.isChecked():
            self.library_22.setText("")
        if not self.library_23_checkbox.isChecked():
            self.library_23.setText("")
        if not self.library_24_checkbox.isChecked():
            self.library_24.setText("")
        if not self.library_25_checkbox.isChecked():
            self.library_25.setText("")
        if not self.library_26_checkbox.isChecked():
            self.library_26.setText("")
        if not self.library_27_checkbox.isChecked():
            self.library_27.setText("")
        if not self.library_28_checkbox.isChecked():
            self.library_28.setText("")
        if not self.library_29_checkbox.isChecked():
            self.library_29.setText("")

        if not self.library_30_checkbox.isChecked():
            self.library_30.setText("")
        if not self.library_31_checkbox.isChecked():
            self.library_31.setText("")
        if not self.library_32_checkbox.isChecked():
            self.library_32.setText("")
        if not self.library_33_checkbox.isChecked():
            self.library_33.setText("")
        if not self.library_34_checkbox.isChecked():
            self.library_34.setText("")
        if not self.library_35_checkbox.isChecked():
            self.library_35.setText("")
        if not self.library_36_checkbox.isChecked():
            self.library_36.setText("")
        if not self.library_37_checkbox.isChecked():
            self.library_37.setText("")
        if not self.library_38_checkbox.isChecked():
            self.library_38.setText("")
        if not self.library_39_checkbox.isChecked():
            self.library_39.setText("")

        if not self.library_40_checkbox.isChecked():
            self.library_40.setText("")
        if not self.library_41_checkbox.isChecked():
            self.library_41.setText("")
        if not self.library_42_checkbox.isChecked():
            self.library_42.setText("")
        if not self.library_43_checkbox.isChecked():
            self.library_43.setText("")
        if not self.library_44_checkbox.isChecked():
            self.library_44.setText("")
        if not self.library_45_checkbox.isChecked():
            self.library_45.setText("")
        if not self.library_46_checkbox.isChecked():
            self.library_46.setText("")
        if not self.library_47_checkbox.isChecked():
            self.library_47.setText("")
        if not self.library_48_checkbox.isChecked():
            self.library_48.setText("")
        if not self.library_49_checkbox.isChecked():
            self.library_49.setText("")

        if not self.library_50_checkbox.isChecked():
            self.library_50.setText("")
        if not self.library_51_checkbox.isChecked():
            self.library_51.setText("")
        if not self.library_52_checkbox.isChecked():
            self.library_52.setText("")
    #-----------------------------------------------------------------------------------------------
    def check_all_libraries(self):

        self.library_3_checkbox.setChecked(True)
        self.library_4_checkbox.setChecked(True)
        self.library_5_checkbox.setChecked(True)
        self.library_6_checkbox.setChecked(True)
        self.library_7_checkbox.setChecked(True)
        self.library_8_checkbox.setChecked(True)
        self.library_9_checkbox.setChecked(True)

        self.library_10_checkbox.setChecked(True)
        self.library_11_checkbox.setChecked(True)
        self.library_12_checkbox.setChecked(True)
        self.library_13_checkbox.setChecked(True)
        self.library_14_checkbox.setChecked(True)
        self.library_15_checkbox.setChecked(True)
        self.library_16_checkbox.setChecked(True)
        self.library_17_checkbox.setChecked(True)
        self.library_18_checkbox.setChecked(True)
        self.library_19_checkbox.setChecked(True)

        self.library_20_checkbox.setChecked(True)
        self.library_21_checkbox.setChecked(True)
        self.library_22_checkbox.setChecked(True)
        self.library_23_checkbox.setChecked(True)
        self.library_24_checkbox.setChecked(True)
        self.library_25_checkbox.setChecked(True)
        self.library_26_checkbox.setChecked(True)
        self.library_27_checkbox.setChecked(True)
        self.library_28_checkbox.setChecked(True)
        self.library_29_checkbox.setChecked(True)

        self.library_30_checkbox.setChecked(True)
        self.library_31_checkbox.setChecked(True)
        self.library_32_checkbox.setChecked(True)
        self.library_33_checkbox.setChecked(True)
        self.library_34_checkbox.setChecked(True)
        self.library_35_checkbox.setChecked(True)
        self.library_36_checkbox.setChecked(True)
        self.library_37_checkbox.setChecked(True)
        self.library_38_checkbox.setChecked(True)
        self.library_39_checkbox.setChecked(True)

        self.library_40_checkbox.setChecked(True)
        self.library_41_checkbox.setChecked(True)
        self.library_42_checkbox.setChecked(True)
        self.library_43_checkbox.setChecked(True)
        self.library_44_checkbox.setChecked(True)
        self.library_45_checkbox.setChecked(True)
        self.library_46_checkbox.setChecked(True)
        self.library_47_checkbox.setChecked(True)
        self.library_48_checkbox.setChecked(True)
        self.library_49_checkbox.setChecked(True)

        self.library_50_checkbox.setChecked(True)
        self.library_51_checkbox.setChecked(True)
        self.library_52_checkbox.setChecked(True)
    #-----------------------------------------------------------------------------------------------
    def uncheck_all_libraries(self):

        self.library_3_checkbox.setChecked(False)
        self.library_4_checkbox.setChecked(False)
        self.library_5_checkbox.setChecked(False)
        self.library_6_checkbox.setChecked(False)
        self.library_7_checkbox.setChecked(False)
        self.library_8_checkbox.setChecked(False)
        self.library_9_checkbox.setChecked(False)

        self.library_10_checkbox.setChecked(False)
        self.library_11_checkbox.setChecked(False)
        self.library_12_checkbox.setChecked(False)
        self.library_13_checkbox.setChecked(False)
        self.library_14_checkbox.setChecked(False)
        self.library_15_checkbox.setChecked(False)
        self.library_16_checkbox.setChecked(False)
        self.library_17_checkbox.setChecked(False)
        self.library_18_checkbox.setChecked(False)
        self.library_19_checkbox.setChecked(False)

        self.library_20_checkbox.setChecked(False)
        self.library_21_checkbox.setChecked(False)
        self.library_22_checkbox.setChecked(False)
        self.library_23_checkbox.setChecked(False)
        self.library_24_checkbox.setChecked(False)
        self.library_25_checkbox.setChecked(False)
        self.library_26_checkbox.setChecked(False)
        self.library_27_checkbox.setChecked(False)
        self.library_28_checkbox.setChecked(False)
        self.library_29_checkbox.setChecked(False)

        self.library_30_checkbox.setChecked(False)
        self.library_31_checkbox.setChecked(False)
        self.library_32_checkbox.setChecked(False)
        self.library_33_checkbox.setChecked(False)
        self.library_34_checkbox.setChecked(False)
        self.library_35_checkbox.setChecked(False)
        self.library_36_checkbox.setChecked(False)
        self.library_37_checkbox.setChecked(False)
        self.library_38_checkbox.setChecked(False)
        self.library_39_checkbox.setChecked(False)

        self.library_40_checkbox.setChecked(False)
        self.library_41_checkbox.setChecked(False)
        self.library_42_checkbox.setChecked(False)
        self.library_43_checkbox.setChecked(False)
        self.library_44_checkbox.setChecked(False)
        self.library_45_checkbox.setChecked(False)
        self.library_46_checkbox.setChecked(False)
        self.library_47_checkbox.setChecked(False)
        self.library_48_checkbox.setChecked(False)
        self.library_49_checkbox.setChecked(False)

        self.library_50_checkbox.setChecked(False)
        self.library_51_checkbox.setChecked(False)
        self.library_52_checkbox.setChecked(False)
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def create_source_library_qlineedits(self):

        t = ""

        max_width = 600

        self.library_3_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[3] = self.library_3_checkbox
        self.library_4_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[4] = self.library_4_checkbox
        self.library_5_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[5] = self.library_5_checkbox
        self.library_6_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[6] = self.library_6_checkbox
        self.library_7_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[7] = self.library_7_checkbox
        self.library_8_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[8] = self.library_8_checkbox
        self.library_9_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[9] = self.library_9_checkbox

        self.library_10_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[10] = self.library_10_checkbox
        self.library_11_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[11] = self.library_11_checkbox
        self.library_12_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[12] = self.library_12_checkbox
        self.library_13_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[13] = self.library_13_checkbox
        self.library_14_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[14] = self.library_14_checkbox
        self.library_15_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[15] = self.library_15_checkbox
        self.library_16_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[16] = self.library_16_checkbox
        self.library_17_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[17] = self.library_17_checkbox
        self.library_18_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[18] = self.library_18_checkbox
        self.library_19_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[19] = self.library_19_checkbox

        self.library_20_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[20] = self.library_20_checkbox
        self.library_21_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[21] = self.library_21_checkbox
        self.library_22_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[22] = self.library_22_checkbox
        self.library_23_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[23] = self.library_23_checkbox
        self.library_24_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[24] = self.library_24_checkbox
        self.library_25_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[25] = self.library_25_checkbox
        self.library_26_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[26] = self.library_26_checkbox
        self.library_27_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[27] = self.library_27_checkbox
        self.library_28_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[28] = self.library_28_checkbox
        self.library_29_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[29] = self.library_29_checkbox

        self.library_30_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[30] = self.library_30_checkbox
        self.library_31_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[31] = self.library_31_checkbox
        self.library_32_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[32] = self.library_32_checkbox
        self.library_33_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[33] = self.library_33_checkbox
        self.library_34_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[34] = self.library_34_checkbox
        self.library_35_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[35] = self.library_35_checkbox
        self.library_36_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[36] = self.library_36_checkbox
        self.library_37_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[37] = self.library_37_checkbox
        self.library_38_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[38] = self.library_38_checkbox
        self.library_39_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[39] = self.library_39_checkbox

        self.library_40_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[40] = self.library_40_checkbox
        self.library_41_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[41] = self.library_41_checkbox
        self.library_42_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[42] = self.library_42_checkbox
        self.library_43_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[43] = self.library_43_checkbox
        self.library_44_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[44] = self.library_44_checkbox
        self.library_45_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[45] = self.library_45_checkbox
        self.library_46_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[46] = self.library_46_checkbox
        self.library_47_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[47] = self.library_47_checkbox
        self.library_48_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[48] = self.library_48_checkbox
        self.library_49_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[49] = self.library_49_checkbox

        self.library_50_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[50] = self.library_50_checkbox
        self.library_51_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[51] = self.library_51_checkbox
        self.library_52_checkbox = QCheckBox('')
        self.qt_source_tab_qcheckbox_objects_dict[52] = self.library_52_checkbox

        self.libraries_layout.addWidget(self.library_3_checkbox,3,0)  # have to skip the first 3 lines for the command buttons; checkboxes 0,1,2 changed to 50,51,52 and moved to the bottom.
        self.libraries_layout.addWidget(self.library_4_checkbox,4,0)
        self.libraries_layout.addWidget(self.library_5_checkbox,5,0)
        self.libraries_layout.addWidget(self.library_6_checkbox,6,0)
        self.libraries_layout.addWidget(self.library_7_checkbox,7,0)
        self.libraries_layout.addWidget(self.library_8_checkbox,8,0)
        self.libraries_layout.addWidget(self.library_9_checkbox,9,0)

        self.libraries_layout.addWidget(self.library_10_checkbox,10,0)
        self.libraries_layout.addWidget(self.library_11_checkbox,11,0)
        self.libraries_layout.addWidget(self.library_12_checkbox,12,0)
        self.libraries_layout.addWidget(self.library_13_checkbox,13,0)
        self.libraries_layout.addWidget(self.library_14_checkbox,14,0)
        self.libraries_layout.addWidget(self.library_15_checkbox,15,0)
        self.libraries_layout.addWidget(self.library_16_checkbox,16,0)
        self.libraries_layout.addWidget(self.library_17_checkbox,17,0)
        self.libraries_layout.addWidget(self.library_18_checkbox,18,0)
        self.libraries_layout.addWidget(self.library_19_checkbox,19,0)

        self.libraries_layout.addWidget(self.library_20_checkbox,20,0)
        self.libraries_layout.addWidget(self.library_21_checkbox,21,0)
        self.libraries_layout.addWidget(self.library_22_checkbox,22,0)
        self.libraries_layout.addWidget(self.library_23_checkbox,23,0)
        self.libraries_layout.addWidget(self.library_24_checkbox,24,0)
        self.libraries_layout.addWidget(self.library_25_checkbox,25,0)
        self.libraries_layout.addWidget(self.library_26_checkbox,26,0)
        self.libraries_layout.addWidget(self.library_27_checkbox,27,0)
        self.libraries_layout.addWidget(self.library_28_checkbox,28,0)
        self.libraries_layout.addWidget(self.library_29_checkbox,29,0)

        self.libraries_layout.addWidget(self.library_30_checkbox,30,0)
        self.libraries_layout.addWidget(self.library_31_checkbox,31,0)
        self.libraries_layout.addWidget(self.library_32_checkbox,32,0)
        self.libraries_layout.addWidget(self.library_33_checkbox,33,0)
        self.libraries_layout.addWidget(self.library_34_checkbox,34,0)
        self.libraries_layout.addWidget(self.library_35_checkbox,35,0)
        self.libraries_layout.addWidget(self.library_36_checkbox,36,0)
        self.libraries_layout.addWidget(self.library_37_checkbox,37,0)
        self.libraries_layout.addWidget(self.library_38_checkbox,38,0)
        self.libraries_layout.addWidget(self.library_39_checkbox,39,0)

        self.libraries_layout.addWidget(self.library_40_checkbox,40,0)
        self.libraries_layout.addWidget(self.library_41_checkbox,41,0)
        self.libraries_layout.addWidget(self.library_42_checkbox,42,0)
        self.libraries_layout.addWidget(self.library_43_checkbox,43,0)
        self.libraries_layout.addWidget(self.library_44_checkbox,44,0)
        self.libraries_layout.addWidget(self.library_45_checkbox,45,0)
        self.libraries_layout.addWidget(self.library_46_checkbox,46,0)
        self.libraries_layout.addWidget(self.library_47_checkbox,47,0)
        self.libraries_layout.addWidget(self.library_48_checkbox,48,0)
        self.libraries_layout.addWidget(self.library_49_checkbox,49,0)

        self.libraries_layout.addWidget(self.library_50_checkbox,50,0)
        self.libraries_layout.addWidget(self.library_51_checkbox,51,0)
        self.libraries_layout.addWidget(self.library_52_checkbox,52,0)

        self.library_3 = QLineEdit(self)
        self.library_3.setText(t)
        self.library_3.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_3.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_3,3,1)
        self.qt_source_tab_qlineedit_objects_dict[3] = self.library_3

        self.library_4 = QLineEdit(self)
        self.library_4.setText(t)
        self.library_4.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_4.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_4,4,1)
        self.qt_source_tab_qlineedit_objects_dict[4] = self.library_4

        self.library_5 = QLineEdit(self)
        self.library_5.setText(t)
        self.library_5.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_5.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_5,5,1)
        self.qt_source_tab_qlineedit_objects_dict[5] = self.library_5

        self.library_6 = QLineEdit(self)
        self.library_6.setText(t)
        self.library_6.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_6.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_6,6,1)
        self.qt_source_tab_qlineedit_objects_dict[6] = self.library_6

        self.library_7 = QLineEdit(self)
        self.library_7.setText(t)
        self.library_7.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_7.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_7,7,1)
        self.qt_source_tab_qlineedit_objects_dict[7] = self.library_7

        self.library_8 = QLineEdit(self)
        self.library_8.setText(t)
        self.library_8.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_8.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_8,8,1)
        self.qt_source_tab_qlineedit_objects_dict[8] = self.library_8

        self.library_9 = QLineEdit(self)
        self.library_9.setText(t)
        self.library_9.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_9.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_9,9,1)
        self.qt_source_tab_qlineedit_objects_dict[9] = self.library_9


        self.library_10 = QLineEdit(self)
        self.library_10.setText(t)
        self.library_10.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_10.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_10,10,1)
        self.qt_source_tab_qlineedit_objects_dict[10] = self.library_10


        self.library_11 = QLineEdit(self)
        self.library_11.setText(t)
        self.library_11.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_11.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_11,11,1)
        self.qt_source_tab_qlineedit_objects_dict[11] = self.library_11


        self.library_12 = QLineEdit(self)
        self.library_12.setText(t)
        self.library_12.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_12.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_12,12,1)
        self.qt_source_tab_qlineedit_objects_dict[12] = self.library_12

        self.library_13 = QLineEdit(self)
        self.library_13.setText(t)
        self.library_13.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_13.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_13,13,1)
        self.qt_source_tab_qlineedit_objects_dict[13] = self.library_13

        self.library_14 = QLineEdit(self)
        self.library_14.setText(t)
        self.library_14.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_14.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_14,14,1)
        self.qt_source_tab_qlineedit_objects_dict[14] = self.library_14

        self.library_15 = QLineEdit(self)
        self.library_15.setText(t)
        self.library_15.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_15.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_15,15,1)
        self.qt_source_tab_qlineedit_objects_dict[15] = self.library_15


        self.library_16 = QLineEdit(self)
        self.library_16.setText(t)
        self.library_16.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_16.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_16,16,1)
        self.qt_source_tab_qlineedit_objects_dict[16] = self.library_16

        self.library_17 = QLineEdit(self)
        self.library_17.setText(t)
        self.library_17.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_17.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_17,17,1)
        self.qt_source_tab_qlineedit_objects_dict[17] = self.library_17


        self.library_18 = QLineEdit(self)
        self.library_18.setText(t)
        self.library_18.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_18.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_18,18,1)
        self.qt_source_tab_qlineedit_objects_dict[18] = self.library_18

        self.library_19 = QLineEdit(self)
        self.library_19.setText(t)
        self.library_19.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_19.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_19,19,1)
        self.qt_source_tab_qlineedit_objects_dict[19] = self.library_19

        self.library_20 = QLineEdit(self)
        self.library_20.setText(t)
        self.library_20.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_20.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_20,20,1)
        self.qt_source_tab_qlineedit_objects_dict[20] = self.library_20

        self.library_21 = QLineEdit(self)
        self.library_21.setText(t)
        self.library_21.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_21.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_21,21,1)
        self.qt_source_tab_qlineedit_objects_dict[21] = self.library_21

        self.library_22 = QLineEdit(self)
        self.library_22.setText(t)
        self.library_22.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_22.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_22,22,1)
        self.qt_source_tab_qlineedit_objects_dict[22] = self.library_22

        self.library_23 = QLineEdit(self)
        self.library_23.setText(t)
        self.library_23.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_23.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_23,23,1)
        self.qt_source_tab_qlineedit_objects_dict[23] = self.library_23

        self.library_24 = QLineEdit(self)
        self.library_24.setText(t)
        self.library_24.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_24.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_24,24,1)
        self.qt_source_tab_qlineedit_objects_dict[24] = self.library_24

        self.library_25 = QLineEdit(self)
        self.library_25.setText(t)
        self.library_25.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_25.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_25,25,1)
        self.qt_source_tab_qlineedit_objects_dict[25] = self.library_25

        self.library_26 = QLineEdit(self)
        self.library_26.setText(t)
        self.library_26.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_26.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_26,26,1)
        self.qt_source_tab_qlineedit_objects_dict[26] = self.library_26

        self.library_27 = QLineEdit(self)
        self.library_27.setText(t)
        self.library_27.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_27.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_27,27,1)
        self.qt_source_tab_qlineedit_objects_dict[27] = self.library_27

        self.library_28 = QLineEdit(self)
        self.library_28.setText(t)
        self.library_28.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_28.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_28,28,1)
        self.qt_source_tab_qlineedit_objects_dict[28] = self.library_28

        self.library_29 = QLineEdit(self)
        self.library_29.setText(t)
        self.library_29.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_29.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_29,29,1)
        self.qt_source_tab_qlineedit_objects_dict[29] = self.library_29

        self.library_30 = QLineEdit(self)
        self.library_30.setText(t)
        self.library_30.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_30.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_30,30,1)
        self.qt_source_tab_qlineedit_objects_dict[30] = self.library_30

        self.library_31 = QLineEdit(self)
        self.library_31.setText(t)
        self.library_31.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_31.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_31,31,1)
        self.qt_source_tab_qlineedit_objects_dict[31] = self.library_31

        self.library_32 = QLineEdit(self)
        self.library_32.setText(t)
        self.library_32.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_32.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_32,32,1)
        self.qt_source_tab_qlineedit_objects_dict[32] = self.library_32

        self.library_33 = QLineEdit(self)
        self.library_33.setText(t)
        self.library_33.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_33.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_33,33,1)
        self.qt_source_tab_qlineedit_objects_dict[33] = self.library_33

        self.library_34 = QLineEdit(self)
        self.library_34.setText(t)
        self.library_34.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_34.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_34,34,1)
        self.qt_source_tab_qlineedit_objects_dict[34] = self.library_34

        self.library_35 = QLineEdit(self)
        self.library_35.setText(t)
        self.library_35.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_35.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_35,35,1)
        self.qt_source_tab_qlineedit_objects_dict[35] = self.library_35

        self.library_36 = QLineEdit(self)
        self.library_36.setText(t)
        self.library_36.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_36.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_36,36,1)
        self.qt_source_tab_qlineedit_objects_dict[36] = self.library_36

        self.library_37 = QLineEdit(self)
        self.library_37.setText(t)
        self.library_37.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_37.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_37,37,1)
        self.qt_source_tab_qlineedit_objects_dict[37] = self.library_37

        self.library_38 = QLineEdit(self)
        self.library_38.setText(t)
        self.library_38.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_38.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_38,38,1)
        self.qt_source_tab_qlineedit_objects_dict[38] = self.library_38

        self.library_39 = QLineEdit(self)
        self.library_39.setText(t)
        self.library_39.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_39.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_39,39,1)
        self.qt_source_tab_qlineedit_objects_dict[39] = self.library_39

        self.library_40 = QLineEdit(self)
        self.library_40.setText(t)
        self.library_40.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_40.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_40,40,1)
        self.qt_source_tab_qlineedit_objects_dict[40] = self.library_40

        self.library_41 = QLineEdit(self)
        self.library_41.setText(t)
        self.library_41.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_41.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_41,41,1)
        self.qt_source_tab_qlineedit_objects_dict[41] = self.library_41

        self.library_42 = QLineEdit(self)
        self.library_42.setText(t)
        self.library_42.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_42.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_42,42,1)
        self.qt_source_tab_qlineedit_objects_dict[42] = self.library_42

        self.library_43 = QLineEdit(self)
        self.library_43.setText(t)
        self.library_43.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_43.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_43,43,1)
        self.qt_source_tab_qlineedit_objects_dict[43] = self.library_43

        self.library_44 = QLineEdit(self)
        self.library_44.setText(t)
        self.library_44.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_44.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_44,44,1)
        self.qt_source_tab_qlineedit_objects_dict[44] = self.library_44

        self.library_45 = QLineEdit(self)
        self.library_45.setText(t)
        self.library_45.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_45.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_45,45,1)
        self.qt_source_tab_qlineedit_objects_dict[45] = self.library_45

        self.library_46 = QLineEdit(self)
        self.library_46.setText(t)
        self.library_46.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_46.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_46,46,1)
        self.qt_source_tab_qlineedit_objects_dict[46] = self.library_46

        self.library_47 = QLineEdit(self)
        self.library_47.setText(t)
        self.library_47.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_47.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_47,47,1)
        self.qt_source_tab_qlineedit_objects_dict[47] = self.library_47

        self.library_48 = QLineEdit(self)
        self.library_48.setText(t)
        self.library_48.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_48.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_48,48,1)
        self.qt_source_tab_qlineedit_objects_dict[48] = self.library_48

        self.library_49 = QLineEdit(self)
        self.library_49.setText(t)
        self.library_49.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_49.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_49,49,1)
        self.qt_source_tab_qlineedit_objects_dict[49] = self.library_49

        self.library_50 = QLineEdit(self)
        self.library_50.setText(t)
        self.library_50.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_50.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_50,50,1)
        self.qt_source_tab_qlineedit_objects_dict[50] = self.library_50

        self.library_51 = QLineEdit(self)
        self.library_51.setText(t)
        self.library_51.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_51.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_51,51,1)
        self.qt_source_tab_qlineedit_objects_dict[51] = self.library_51

        self.library_52 = QLineEdit(self)
        self.library_52.setText(t)
        self.library_52.setToolTip(self.sources_tab_tooltip_path)
        #~ self.library_52.setMaximumWidth(max_width)
        self.libraries_layout.addWidget(self.library_52,52,1)
        self.qt_source_tab_qlineedit_objects_dict[52] = self.library_52
    #--------------------------------------------------------------------------------------------------
    def optimize_source_prefs(self):

        if DEBUG: print("Number of keys in self.mysourceprefs in 'optimize_source_prefs' [1] : ", as_unicode(len(self.mysourceprefs)))

        tmp_sorted_list = []                        # library qlineedit text had a \ or a / in it
        tmp_original_path_dict = {}            # library qlineedit text had a \ or a / in it
        tmp_was_checked_dict = {}            # library was checked = True (always)
        path_checked_status_dict = {}       # library qlineedit text (k) and checkbox value (v) for every qlineedit text value

        tmp_sorted_list[:] = []                   # clear to guarantee emptiness
        tmp_original_path_dict.clear()
        tmp_was_checked_dict.clear()
        path_checked_status_dict.clear()

        tmp_sorted_list.append("!00")    # placeholders.  the real source path values begin with index = 3 so that the QGridLayout row number always equals its index...
        tmp_sorted_list.append("!01")    # ! sorts before / which is the first character in an OSX and Linux library path.
        tmp_sorted_list.append("!02")    # ! and numbers sort before letters which are the first character in a Windows path.

        #~ for k,v in self.mysourceprefs.iteritems():    #  e.g.   'LIBRARY_PATH_03'  = S:\Calibre\QS\QuarantineAndScrub_Test8\
        for k,v in iteritems(self.mysourceprefs):    #  e.g.   'LIBRARY_PATH_03'  = S:\Calibre\QS\QuarantineAndScrub_Test8\
            k = k.strip()
            v = v.strip()
            k = unicode_type(k)
            v = unicode_type(v)
            if k:
                if k != "":
                    if v:
                        if v != "":
                            if "||>>>||" in v:
                                continue
                            if 'LIBRARY_PATH' in k:
                                if not '_IS_ACTIVE' in k:   #  e.g. 'LIBRARY_PATH_03'
                                    if '/' in v or '\\' in v :
                                        v = v.replace(os.sep, '/')
                                        if v not in tmp_sorted_list:  # no duplicates
                                            tmp_sorted_list.append(v)         # v is only non-blank:  S:\Calibre\QS\QuarantineAndScrub_Test8\
                                            tmp_original_path_dict[k] = v
                                            if DEBUG: print("Saved: ", k, v)
                                        else:
                                            continue
                                    else:
                                        if DEBUG: print("Not Saved: ", k, v)
                                        continue
                                else:  # '_IS_ACTIVE' is in k:     e.g. ''LIBRARY_PATH_03_IS_ACTIVE'
                                    if v == unicode_type("True"):
                                        tmp_was_checked_dict[k] = unicode_type("True")     #  'LIBRARY_PATH_03_IS_ACTIVE' = True only
                                        if DEBUG: print('tmp_was_checked_dict[k] = unicode_type("True")', k, v)
                                    else:
                                        continue
                            else:
                                continue
                        else:
                            continue
                    else:
                        continue
                else:
                    continue
            else:
                continue
        #END FOR

        #~ for k1,v1 in tmp_original_path_dict.iteritems():       #  e.g. 'LIBRARY_PATH_00'  = blank or has a \ or a / in it
        for k1,v1 in iteritems(tmp_original_path_dict):       #  e.g. 'LIBRARY_PATH_00'  = blank or has a \ or a / in it
            if k1:
                if v1:
                    if ((v1.count('\\') > 0) or (v1.count('/') > 0)) :
                        pass
                    else:
                        if DEBUG: print("optimize_source_prefs - skipping non-paths: ", as_unicode(k1), as_unicode(v1))
                        continue  # we do not care about non-paths

                    #~ for k2,v2 in tmp_was_checked_dict.iteritems():   #  e.g. 'LIBRARY_PATH_00_IS_ACTIVE' = True or False
                    for k2,v2 in iteritems(tmp_was_checked_dict):   #  e.g. 'LIBRARY_PATH_00_IS_ACTIVE' = True or False
                        if k2:
                            if v2:
                                if k2.count(k1) > 0:     #  e.g. 'LIBRARY_PATH_00' is in 'LIBRARY_PATH_00_IS_ACTIVE'
                                    if v2.count(unicode_type("True")) > 0:  # double-check
                                        v1 = unicode_type(v1)
                                        v2 = unicode_type(v2)
                                        path_checked_status_dict[v1] =  v2       #  e.g. S:\Calibre\QS\QuarantineAndScrub_Test8\  = True  (only)
                                        if DEBUG: print("path_checked_status_dict[v1] =  v2 : ", v1, v2)
                                        break
                                    else:
                                        if DEBUG: print("optimize_source_prefs - v2 != True: ", as_unicode(k2), as_unicode(v2))
                                        continue
                                else:
                                    continue
                            else:
                                continue
                        else:
                            continue
                    #END FOR
                else:
                    continue
            else:
                continue
        #END FOR

        self.current_number_of_source_libraries_checked = len(path_checked_status_dict)

        tmp_sorted_list.sort()

        for x in range(0,100):
            tmp_sorted_list.append("")    # guarantees a value exists for every possible row, even if all were originally blank, and this value will never be in a real path in path_checked_status_dict
        #END FOR

        if DEBUG:
            for row in tmp_sorted_list:
                if row > "":
                    print("for row in tmp_sorted_list: ", row)

        if DEBUG: print("Number of keys in self.mysourceprefs in 'optimize_source_prefs' [2] : ", as_unicode(len(self.mysourceprefs)))

        self.mysourceprefs['LIBRARY_PATH_03'] = unicode_type(tmp_sorted_list[3])        # the real values begin with index = 3 so that the QGridLayout row number always equals its index...
        if tmp_sorted_list[3] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_03_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_03_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_04'] = unicode_type(tmp_sorted_list[4])
        if tmp_sorted_list[4] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_04_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_04_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_05'] = unicode_type(tmp_sorted_list[5])
        if tmp_sorted_list[5] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_05_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_05_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_06'] = unicode_type(tmp_sorted_list[6])
        if tmp_sorted_list[6] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_06_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_06_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_07'] = unicode_type(tmp_sorted_list[7])
        if tmp_sorted_list[7] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_07_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_07_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_08'] = unicode_type(tmp_sorted_list[8])
        if tmp_sorted_list[8] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_08_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_08_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_09'] = unicode_type(tmp_sorted_list[9])
        if tmp_sorted_list[9] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_09_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_09_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_10'] = unicode_type(tmp_sorted_list[10])
        if tmp_sorted_list[10] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_10_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_10_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_11'] = unicode_type(tmp_sorted_list[11])
        if tmp_sorted_list[11] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_11_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_11_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_12'] = unicode_type(tmp_sorted_list[12])
        if tmp_sorted_list[12] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_12_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_12_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_13'] = unicode_type(tmp_sorted_list[13])
        if tmp_sorted_list[13] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_13_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_13_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_14'] = unicode_type(tmp_sorted_list[14])
        if tmp_sorted_list[14] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_14_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_14_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_15'] = unicode_type(tmp_sorted_list[15])
        if tmp_sorted_list[15] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_15_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_15_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_16'] = unicode_type(tmp_sorted_list[16])
        if tmp_sorted_list[16] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_16_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_16_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_17'] = unicode_type(tmp_sorted_list[17])
        if tmp_sorted_list[17] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_17_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_17_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_18'] = unicode_type(tmp_sorted_list[18])
        if tmp_sorted_list[18] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_18_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_18_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_19'] = unicode_type(tmp_sorted_list[19])
        if tmp_sorted_list[19] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_19_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_19_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_20'] = unicode_type(tmp_sorted_list[20])
        if tmp_sorted_list[20] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_20_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_20_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_21'] = unicode_type(tmp_sorted_list[21])
        if tmp_sorted_list[21] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_21_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_21_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_22'] = unicode_type(tmp_sorted_list[22])
        if tmp_sorted_list[22] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_22_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_22_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_23'] = unicode_type(tmp_sorted_list[23])
        if tmp_sorted_list[23] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_23_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_23_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_24'] = unicode_type(tmp_sorted_list[24])
        if tmp_sorted_list[24] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_24_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_24_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_25'] = unicode_type(tmp_sorted_list[25])
        if tmp_sorted_list[25] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_25_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_25_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_26'] = unicode_type(tmp_sorted_list[26])
        if tmp_sorted_list[26] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_26_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_26_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_27'] = unicode_type(tmp_sorted_list[27])
        if tmp_sorted_list[27] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_27_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_27_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_28'] = unicode_type(tmp_sorted_list[28])
        if tmp_sorted_list[28] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_28_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_28_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_29'] = unicode_type(tmp_sorted_list[29])
        if tmp_sorted_list[29] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_29_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_29_IS_ACTIVE'] = unicode_type("False")


        self.mysourceprefs['LIBRARY_PATH_30'] = unicode_type(tmp_sorted_list[30])
        if tmp_sorted_list[30] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_30_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_30_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_31'] = unicode_type(tmp_sorted_list[31])
        if tmp_sorted_list[31] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_31_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_31_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_32'] = unicode_type(tmp_sorted_list[32])
        if tmp_sorted_list[32] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_32_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_32_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_33'] = unicode_type(tmp_sorted_list[33])
        if tmp_sorted_list[33] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_33_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_33_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_34'] = unicode_type(tmp_sorted_list[34])
        if tmp_sorted_list[34] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_34_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_34_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_35'] = unicode_type(tmp_sorted_list[35])
        if tmp_sorted_list[35] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_35_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_35_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_36'] = unicode_type(tmp_sorted_list[36])
        if tmp_sorted_list[36] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_36_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_36_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_37'] = unicode_type(tmp_sorted_list[37])
        if tmp_sorted_list[37] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_37_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_37_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_38'] = unicode_type(tmp_sorted_list[38])
        if tmp_sorted_list[38] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_38_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_38_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_39'] = unicode_type(tmp_sorted_list[39])
        if tmp_sorted_list[39] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_39_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_39_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_40'] = unicode_type(tmp_sorted_list[40])
        if tmp_sorted_list[40] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_40_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_40_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_41'] = unicode_type(tmp_sorted_list[41])
        if tmp_sorted_list[41] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_41_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_41_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_42'] = unicode_type(tmp_sorted_list[42])
        if tmp_sorted_list[42] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_42_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_42_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_43'] = unicode_type(tmp_sorted_list[43])
        if tmp_sorted_list[43] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_43_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_43_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_44'] = unicode_type(tmp_sorted_list[44])
        if tmp_sorted_list[44] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_44_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_44_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_45'] = unicode_type(tmp_sorted_list[45])
        if tmp_sorted_list[45] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_45_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_45_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_46'] = unicode_type(tmp_sorted_list[46])
        if tmp_sorted_list[46] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_46_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_46_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_47'] = unicode_type(tmp_sorted_list[47])
        if tmp_sorted_list[47] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_47_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_47_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_48'] = unicode_type(tmp_sorted_list[48])
        if tmp_sorted_list[48] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_48_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_48_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_49'] = unicode_type(tmp_sorted_list[49])
        if tmp_sorted_list[49] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_49_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_49_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_50'] = unicode_type(tmp_sorted_list[50])
        if tmp_sorted_list[50] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_50_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_50_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_51'] = unicode_type(tmp_sorted_list[51])
        if tmp_sorted_list[51] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_51_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_51_IS_ACTIVE'] = unicode_type("False")

        self.mysourceprefs['LIBRARY_PATH_52'] = unicode_type(tmp_sorted_list[52])
        if tmp_sorted_list[52] in path_checked_status_dict:
            self.mysourceprefs['LIBRARY_PATH_52_IS_ACTIVE'] = unicode_type("True")
        else:
            self.mysourceprefs['LIBRARY_PATH_52_IS_ACTIVE'] = unicode_type("False")


        del tmp_sorted_list
        del tmp_original_path_dict
        del tmp_was_checked_dict
        del path_checked_status_dict


        #-------------
        self.save_real_prefs_source()
        #-------------
#--------------------------------------------------------------------------------------------------
    def save_real_prefs_source(self):
        #~ for k,v in self.mysourceprefs.iteritems():
        for k,v in iteritems(self.mysourceprefs):
            prefs[k] = v
        prefs
        if DEBUG: print("Number of keys in self.mysourceprefs in 'save_real_prefs_source': ", as_unicode(len(self.mysourceprefs)))
    #-----------------------------------------------------------------------------------------------
    def return_latest_source_prefs(self,parentprefs):
        #~ for k,v in self.mysourceprefs.iteritems():
        for k,v in iteritems(self.mysourceprefs):
            parentprefs[k] = v
        return parentprefs
        if DEBUG: print("Number of keys in self.mysourceprefs in 'return_latest_source_prefs': ", as_unicode(len(self.mysourceprefs)))
    #-------------------------------------------------------------------------------------------------------------------------------
    def init_tooltips_for_sources_tab(self):
        self.setStyleSheet("QToolTip { color: #ffffff; background-color: #2a82da; border: 1px solid white; }")
        self.sources_tab_tooltip_path = "<p style='white-space:wrap'>Calibre Library Path for a 'Source Library' for which a snapshot of its metadata will be taken and added to the single (consolidated) 'Target Library'.\
                                                                                                            <br><br>There is a hard maximum of 50 Source Libraries that may be specified for any single incarnation of a Target Library metadata.db file.  \
                                                                                                            <br><br> The limit of 50 is a compromise between functionality and performance.  Fortunately, very few (if any) Calibre users have more than 50 'real' Calibre Libraries."
#--------------------------------------------------------------------------------------------------
    def sanitize_placeholders(self):
        tmp_dict = self.mysourceprefs.copy()
        #~ for k,v in tmp_dict.iteritems():
        for k,v in iteritems(tmp_dict):
            v = as_unicode(v)
            if 'LIBRARY_PATH_' in k:
                if v == as_unicode("!00") or v == as_unicode("!01") or v == as_unicode("!02"):
                    self.mysourceprefs[k] = unicode_type("")
                if v == as_unicode("00") or v == as_unicode("01") or v == as_unicode("02"):
                    self.mysourceprefs[k] = unicode_type("")
        #END FOR
        del tmp_dict
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class CALMTargetTab(QWidget):

    def __init__(self,myparent_pointer,mygui,myguidb,myparentprefs,mygprefs,mypluginpath,mytarget_db,
                            mycreate_new_sqlite_objects_in_tools_db,mychild_invocation_of_save_real_prefs_parent,
                            mychild_invocation_of_set_current_tab_index,mychild_invocation_to_set_source_libraries_read_only,\
                            mycalm_dialog_restart_immediately,mychild_invocation_to_retrieve_most_current_parent_prefs):
        super(CALMTargetTab, self).__init__()

        #-----------------------------------------------------
        self.parent_pointer = myparent_pointer

        self.gui = mygui

        self.guidb = myguidb

        self.gprefs = mygprefs

        self.myparentprefs = myparentprefs

        self.plugin_path = mypluginpath

        self.create_new_sqlite_objects_in_tools_db = mycreate_new_sqlite_objects_in_tools_db

        self.child_invocation_of_save_real_prefs_parent = mychild_invocation_of_save_real_prefs_parent

        self.child_invocation_of_set_current_tab_index = mychild_invocation_of_set_current_tab_index

        self.child_invocation_to_set_source_libraries_read_only = mychild_invocation_to_set_source_libraries_read_only

        self.calm_dialog_restart_immediately = mycalm_dialog_restart_immediately

        self.child_invocation_to_retrieve_most_current_parent_prefs = mychild_invocation_to_retrieve_most_current_parent_prefs

        self.mytargetprefs = collections.OrderedDict([])

        #---------------------------------------------------
        # prefs added in release 2.0.15.
        if not 'CALM_MCS_INDEX_CONSOLIDATION' in prefs:
            prefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("False")
            prefs
        if not 'CALM_MCS_INDEX_CONSOLIDATION' in self.myparentprefs:
            self.myparentprefs['CALM_MCS_INDEX_CONSOLIDATION'] = prefs['CALM_MCS_INDEX_CONSOLIDATION']
            self.mytargetprefs['CALM_MCS_INDEX_CONSOLIDATION'] = prefs['CALM_MCS_INDEX_CONSOLIDATION']

        prefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("False")
        prefs
        self.myparentprefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("False")
        self.mytargetprefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("False")


        #------------------------------------------------------------
        # prefs added in release 2.0.0.  Users already have a .json file, but that legacy file does not contain these new keys...
        try:
            self.mytargetprefs['CALM_DB_VERSION_METADATA_TOOLS_DB'] = self.myparentprefs['CALM_DB_VERSION_METADATA_TOOLS_DB']
        except:
            self.myparentprefs['CALM_DB_VERSION_METADATA_TOOLS_DB'] = unicode_type(1)
            self.mytargetprefs['CALM_DB_VERSION_METADATA_TOOLS_DB'] = unicode_type(1)
            self.myparentprefs['CALM_DB_VERSION_METADATA_DB']  = unicode_type(1)
            self.mytargetprefs['CALM_DB_VERSION_METADATA_DB']  = unicode_type(1)
        try:
            self.mytargetprefs['CALM_TARGET_DB_MUST_BE_REFRESHED'] = self.myparentprefs['CALM_TARGET_DB_MUST_BE_REFRESHED']
        except:
            self.myparentprefs['CALM_TARGET_DB_MUST_BE_REFRESHED'] = unicode_type("False")
            self.mytargetprefs['CALM_TARGET_DB_MUST_BE_REFRESHED'] = unicode_type("False")
        try:
            self.mytargetprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS'] = self.myparentprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS']
        except:
            self.myparentprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS']  = unicode_type("False")
            self.mytargetprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS'] = unicode_type("False")
        try:
            self.mytargetprefs['CALM_LAST_CONSOLIDATION_JOB_DATETIME'] = self.myparentprefs['CALM_LAST_CONSOLIDATION_JOB_DATETIME']  # updated by the calm_consolidation.py job
        except:
            self.myparentprefs['CALM_LAST_CONSOLIDATION_JOB_DATETIME'] = "...NEVER..."
            self.mytargetprefs['CALM_LAST_CONSOLIDATION_JOB_DATETIME'] = "...NEVER..."
        try:
            self.mytargetprefs['CALM_LAST_CONSOLIDATION_NUMBER_LIBRARIES'] = self.myparentprefs['CALM_LAST_CONSOLIDATION_NUMBER_LIBRARIES']  # updated by the calm_consolidation.py job
        except:
            self.myparentprefs['CALM_LAST_CONSOLIDATION_NUMBER_LIBRARIES'] = unicode_type(0)
            self.mytargetprefs['CALM_LAST_CONSOLIDATION_NUMBER_LIBRARIES'] = unicode_type(0)
        try:
            self.mytargetprefs['CALM_LAST_CONSOLIDATION_NUMBER_BOOKS'] = self.myparentprefs['CALM_LAST_CONSOLIDATION_NUMBER_BOOKS']  # updated by the calm_consolidation.py job
        except:
            self.myparentprefs['CALM_LAST_CONSOLIDATION_NUMBER_BOOKS'] = unicode_type(0)
            self.mytargetprefs['CALM_LAST_CONSOLIDATION_NUMBER_BOOKS'] = unicode_type(0)
        try:
            self.mytargetprefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET'] =  self.myparentprefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET']
        except:
            self.myparentprefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET'] = CC_GENERATION_FALSE_MESSAGE
            self.mytargetprefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET'] = CC_GENERATION_FALSE_MESSAGE
        try:
            self.mytargetprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES'] = self.myparentprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES']
        except:
            self.myparentprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES'] = unicode_type(0)
            self.mytargetprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES'] = unicode_type(0)

        try:
            self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = self.myparentprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE']
        except:
            self.myparentprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("False")
            self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("False")

        try:
            self.mytargetprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] = self.myparentprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL']
        except:
            self.myparentprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] = unicode_type(0)
            self.mytargetprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] = unicode_type(0)
        #------------------------------------------------------------
        # original release 1.0.0 prefs
        try:
            self.mytargetprefs['CALM_TARGET_DB_LAST_CHOSEN_LIBRARY_DIRECTORY'] = self.myparentprefs['CALM_TARGET_DB_LAST_CHOSEN_LIBRARY_DIRECTORY']
            self.mytargetprefs['CALM_TARGET_DB_FULL_PATH']  = self.myparentprefs['CALM_TARGET_DB_FULL_PATH']
            self.mytargetprefs['CALM_TARGET_PARENT_DIRECTORY'] = self.myparentprefs['CALM_TARGET_PARENT_DIRECTORY']
            self.mytargetprefs['GUI_LAST_UPDATE_DATETIME_TARGET']  = self.myparentprefs['GUI_LAST_UPDATE_DATETIME_TARGET']
        except:
            self.myparentprefs['CALM_TARGET_DB_LAST_CHOSEN_LIBRARY_DIRECTORY'] = unicode_type('ZZ:')
            self.myparentprefs['CALM_TARGET_DB_FULL_PATH']  = unicode_type('ZZ:')
            self.myparentprefs['CALM_TARGET_PARENT_DIRECTORY'] = unicode_type('ZZ:')
            self.myparentprefs['GUI_LAST_UPDATE_DATETIME_TARGET']  = "...NEVER..."
            #-------------------
            self.mytargetprefs['CALM_TARGET_DB_LAST_CHOSEN_LIBRARY_DIRECTORY'] = unicode_type('ZZ:')
            self.mytargetprefs['CALM_TARGET_DB_FULL_PATH']  = unicode_type('ZZ:')
            self.mytargetprefs['CALM_TARGET_PARENT_DIRECTORY'] = unicode_type('ZZ:')
            self.mytargetprefs['GUI_LAST_UPDATE_DATETIME_TARGET']  = "...NEVER..."
        #------------------------------------------------------------

        self.calm_target_parent_directory = self.mytargetprefs['CALM_TARGET_PARENT_DIRECTORY']

        self.calm_target_db_full_path = self.mytargetprefs['CALM_TARGET_DB_FULL_PATH']

        self.target_db = mytarget_db
        self.target_db = self.mytargetprefs['CALM_TARGET_DB_FULL_PATH']

        self.current_non_target_library_path = "ZZ:"

        #-----------------------------------------------------
        self.init_tooltips_for_target_tab()
        #-----------------------------------------------------
        #-----------------------------------------------------
        font = QFont()
        font.setPointSize(10)
        font.setBold(False)
        #-----------------------------------------------------
        self.layout_top = QVBoxLayout()
        self.layout_top.setSpacing(0)
        self.layout_top.setAlignment(Qt.AlignCenter)
        self.setLayout(self.layout_top)
        #-----------------------------------------------------
        self.scroll_area_frame = QScrollArea()
        self.scroll_area_frame.setAlignment(Qt.AlignCenter)
        self.scroll_area_frame.setWidgetResizable(True)
        self.scroll_area_frame.ensureVisible(800,800)

        self.layout_top.addWidget(self.scroll_area_frame)       # the scroll area is now the child of the parent of self.layout_top

        # NOTE: the self.scroll_area_frame.setWidget(self.scroll_widget) is at the end of the init() AFTER all children have been created and assigned to a layout...

        #-----------------------------------------------------
        self.scroll_widget = QWidget()
        self.layout_top.addWidget(self.scroll_widget)           # causes automatic reparenting of QWidget to the parent of self.layout_top, which is:  self .
        #-----------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setAlignment(Qt.AlignCenter)

        self.scroll_widget.setLayout(self.layout_frame)        # causes automatic reparenting of any widget later added to self.layout_frame to the parent of self.layout_frame, which is:  QWidget .

        font.setPointSize(10)
        font.setBold(False)
        #-----------------------------------------------------
        self.calm_library_groupbox = QGroupBox('Consolidation Target Library Maintenance:')
        self.calm_library_groupbox.setToolTip("<p style='white-space:wrap'>CALM Target Library Creation and Recreation, including the Generation of new Custom Columns based on Source Library Custom Columns.")
        self.calm_library_groupbox.setMinimumWidth(400)
        #~ self.calm_library_groupbox.setMaximumWidth(800)
        self.calm_library_groupbox.setMinimumHeight(0)
        #~ self.calm_library_groupbox.setMaximumHeight(200)
        self.layout_frame.addWidget(self.calm_library_groupbox)

        self.calm_library_layout = QVBoxLayout()
        self.calm_library_layout.setAlignment(Qt.AlignCenter)
        self.calm_library_groupbox.setLayout(self.calm_library_layout)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.calm_library_buttonbox = QDialogButtonBox()
        self.calm_library_buttonbox.setOrientation(Qt.Vertical)
        self.calm_library_buttonbox.setCenterButtons(True)

        self.calm_library_layout.addWidget(self.calm_library_buttonbox)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_select_calm_parent_directory = QPushButton(" ", self)
        self.push_button_select_calm_parent_directory.setText("Select the Parent Directory for the Target Library")
        self.push_button_select_calm_parent_directory.setMinimumWidth(200)
        #~ self.push_button_select_calm_parent_directory.setMaximumWidth(400)
        self.push_button_select_calm_parent_directory.clicked.connect(self.choose_calm_target_parent_directory_filedialog)
        self.push_button_select_calm_parent_directory.setDefault(False)
        self.push_button_select_calm_parent_directory.setFont(font)
        self.push_button_select_calm_parent_directory.setToolTip("<p style='white-space:wrap'>Select the (Permanent) Parent Directory for the Special CALM Target Library.  If you have highly customized your Tag Rules and Derive Genre Rules, you will not want to lose your work.  Please read the instructions at the bottom of the Target Library Tab for more information.")
        self.calm_library_buttonbox.addButton(self.push_button_select_calm_parent_directory,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_extract_calm_db = QPushButton(" ", self)
        self.push_button_extract_calm_db.setText("Extract a Fresh Copy of the Target Library")
        self.push_button_extract_calm_db.setMinimumWidth(200)
        #~ self.push_button_extract_calm_db.setMaximumWidth(400)
        self.push_button_extract_calm_db.clicked.connect(self.extract_fresh_calm_metadata_db)
        self.push_button_extract_calm_db.setDefault(False)
        self.push_button_extract_calm_db.setToolTip("<p style='white-space:wrap'>Extract a Fresh Copy of the Special CALM Target Library metadata.db file.  Refer to the Instructions, below, for important information.")
        self.calm_library_buttonbox.addButton(self.push_button_extract_calm_db,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_purge_calm_db = QPushButton(" ", self)
        self.push_button_purge_calm_db.setText("Delete the Entire CALM Library Directory")
        self.push_button_purge_calm_db.setMinimumWidth(200)
        #~ self.push_button_purge_calm_db.setMaximumWidth(400)
        self.push_button_purge_calm_db.clicked.connect(self.delete_entire_calm_directory)
        self.push_button_purge_calm_db.setDefault(False)
        self.push_button_purge_calm_db.setToolTip("<p style='white-space:wrap'>Totally delete 'everything' and start over.  This is an easy and fast way to reset CALM to its default settings and databases.")
        self.calm_library_buttonbox.addButton(self.push_button_purge_calm_db,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_generate_custom_columns = QPushButton(" ", self)
        self.push_button_generate_custom_columns.setText("Generate Custom Columns in the Target Library")
        self.push_button_generate_custom_columns.setMinimumWidth(200)
        #~ self.push_button_generate_custom_columns.setMaximumWidth(400)
        self.push_button_generate_custom_columns.clicked.connect(self.generate_custom_columns_control)
        self.push_button_generate_custom_columns.setDefault(False)
        self.push_button_generate_custom_columns.setToolTip("<p style='white-space:wrap'>Generate Custom Columns in the Special CALM Target Library.  'Generate' refers to creating new Custom Columns for the Source Library Custom Columns that you selected in the Source Custom Columns Tab.  Refer to the Instructions, below, for important information.")
        self.calm_library_buttonbox.addButton(self.push_button_generate_custom_columns,QDialogButtonBox.AcceptRole)

        s = self.mytargetprefs['CALM_TARGET_DB_FULL_PATH']
        if s.count("CALM") == 0:
            self.push_button_generate_custom_columns.hide()
        else:
            if prefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] == unicode_type(1):
                self.push_button_generate_custom_columns.hide()
            else:
                self.push_button_generate_custom_columns.show()
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.calm_library_status_groupbox = QGroupBox('Consolidation Target Library Status:')
        self.calm_library_status_groupbox.setToolTip("<p style='white-space:wrap'>The status of Target Library as pertains to:  its current full path; the date and time of its last recreation; whether or not it has been Generated; and the date and time of that Generation. ")
        self.calm_library_status_groupbox.setMinimumWidth(400)
        #~ self.calm_library_status_groupbox.setMaximumWidth(800)
        self.calm_library_status_groupbox.setMinimumHeight(0)
        #~ self.calm_library_status_groupbox.setMaximumHeight(150)
        self.layout_frame.addWidget(self.calm_library_status_groupbox)

        self.calm_library_status_layout = QGridLayout()
        self.calm_library_status_groupbox.setLayout(self.calm_library_status_layout)
        #-----------------------------------------------------
        font.setPointSize(8)
        font.setBold(True)
        self.special_calm_db_full_path_label = QLabel()
        self.special_calm_db_full_path_label.setTextFormat(Qt.PlainText)
        self.special_calm_db_full_path_label.setText("Last Target Library--Full Path:")
        self.special_calm_db_full_path_label.setFont(font)
        self.special_calm_db_full_path_label.setAlignment(Qt.AlignLeft)
        self.special_calm_db_full_path_label.setToolTip("<p style='white-space:wrap'>The full path to the very latest special CALM Target Library metadata.db file.  Its companion metadata_tools.db file will be in the same directory as this file.")

        self.calm_library_status_layout.addWidget(self.special_calm_db_full_path_label,2,0)

        font.setPointSize(8)
        font.setBold(True)
        self.special_calm_db_full_path_value_label = QLabel()
        self.special_calm_db_full_path_value_label.setTextFormat(Qt.PlainText)
        self.special_calm_db_full_path_value_label.setText(self.calm_target_db_full_path)
        self.special_calm_db_full_path_value_label.setFont(font)
        self.special_calm_db_full_path_value_label.setAlignment(Qt.AlignLeft)
        self.special_calm_db_full_path_value_label.setToolTip("<p style='white-space:wrap'>The full path to the special CALM metadata.db file.")

        self.calm_library_status_layout.addWidget(self.special_calm_db_full_path_value_label,2,1)
        #-----------------------------------------------------
        font.setPointSize(8)
        font.setBold(True)
        self.special_calm_db_updated_label = QLabel()
        self.special_calm_db_updated_label.setTextFormat(Qt.PlainText)
        self.special_calm_db_updated_label.setText("Last 'Fresh Copy' Extraction: ")
        self.special_calm_db_updated_label.setFont(font)
        self.special_calm_db_updated_label.setAlignment(Qt.AlignLeft)
        self.special_calm_db_updated_label.setToolTip("<p style='white-space:wrap'>The Date and Time of the Last 'Fresh Copy' Extraction.")
        #~ self.special_calm_db_updated_label.setMinimumWidth(200)
        #~ self.special_calm_db_updated_label.setMaximumWidth(200)

        self.calm_library_status_layout.addWidget(self.special_calm_db_updated_label,3,0)

        font.setPointSize(8)
        font.setBold(True)
        self.special_calm_db_updated_value_label = QLabel()
        self.special_calm_db_updated_value_label.setTextFormat(Qt.PlainText)
        self.special_calm_db_updated_value_label.setText(self.mytargetprefs['GUI_LAST_UPDATE_DATETIME_TARGET'])
        self.special_calm_db_updated_value_label.setFont(font)
        self.special_calm_db_updated_value_label.setAlignment(Qt.AlignLeft)
        self.special_calm_db_updated_value_label.setToolTip("<p style='white-space:wrap'>The Date and Time of the Last 'Fresh Copy' Extraction.")
        #~ self.special_calm_db_updated_value_label.setMinimumWidth(400)

        self.calm_library_status_layout.addWidget(self.special_calm_db_updated_value_label,3,1)
        #-----------------------------------------------------
        self.source_libraries_number_generated_label = QLabel()
        self.source_libraries_number_generated_label.setTextFormat(Qt.PlainText)
        self.source_libraries_number_generated_label.setText("Source Libraries Generated: ")
        self.source_libraries_number_generated_label.setFont(font)
        self.source_libraries_number_generated_label.setAlignment(Qt.AlignLeft)
        self.source_libraries_number_generated_label.setToolTip("<p style='white-space:wrap'>The number of Source Libraries last generated for the current incarnation of the Target Library metadata.db file.")

        self.calm_library_status_layout.addWidget(self.source_libraries_number_generated_label,4,0)

        self.source_libraries_number_generated_value_label = QLabel()
        self.source_libraries_number_generated_value_label.setTextFormat(Qt.PlainText)
        s = prefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES']
        self.source_libraries_number_generated_value_label.setText(s)
        self.source_libraries_number_generated_value_label.setFont(font)
        self.source_libraries_number_generated_value_label.setAlignment(Qt.AlignLeft)
        self.source_libraries_number_generated_value_label.setToolTip("<p style='white-space:wrap'>The number of Source Libraries last generated for the current incarnation of the Target Library metadata.db file.")
        #~ self.source_libraries_number_generated_value_label.setMinimumWidth(10)
        #~ self.source_libraries_number_generated_value_label.setMaximumWidth(25)

        self.calm_library_status_layout.addWidget(self.source_libraries_number_generated_value_label,4,1)

        font.setPointSize(7)
        font.setBold(True)

        self.source_libraries_number_generated_warning_pushbutton = QPushButton()
        self.source_libraries_number_generated_warning_pushbutton.setText("Prior to Generation, Please Activate the Desired Source Custom Columns")
        self.source_libraries_number_generated_warning_pushbutton.setFont(font)
        self.source_libraries_number_generated_warning_pushbutton.setMinimumWidth(0)
        self.source_libraries_number_generated_warning_pushbutton.clicked.connect(self.switch_to_source_custom_columns_tab)
        self.source_libraries_number_generated_warning_pushbutton.setToolTip("<p style='white-space:wrap'>The entire purpose of Generation is to add new Custom Columns to the Target Library metadata.db file based on your selected Source Library Custom Columns.")

        self.calm_library_status_layout.addWidget(self.source_libraries_number_generated_warning_pushbutton,4,1)

        font.setPointSize(8)
        font.setBold(True)

        if 'GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL' in self.mytargetprefs:
            if self.mytargetprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] == unicode_type(1):
                self.source_libraries_number_generated_warning_pushbutton.hide()
                self.source_libraries_number_generated_value_label.show()
                if self.mytargetprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES'] == unicode_type(0):
                    number_generated_libraries = self.get_number_of_generated_libraries()
                    if DEBUG: print("number_generated_libraries",number_generated_libraries)
                    self.source_libraries_number_generated_value_label.setText(number_generated_libraries)
                    prefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES'] = number_generated_libraries
                    self.myparentprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES'] = number_generated_libraries
                    if number_generated_libraries == unicode_type(0):
                        self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("True")
                    else:
                        self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("False")
        else:
            self.source_libraries_number_generated_warning_pushbutton.show()
            self.source_libraries_number_generated_value_label.hide()
            self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("False")


        #-----------------------------------------------------
        font.setPointSize(8)
        font.setBold(True)
        self.custom_columns_generated_label = QLabel()
        self.custom_columns_generated_label.setTextFormat(Qt.PlainText)
        self.custom_columns_generated_label.setText("Last Target Library--Generated:")
        self.custom_columns_generated_label.setFont(font)
        self.custom_columns_generated_label.setAlignment(Qt.AlignLeft)
        self.custom_columns_generated_label.setToolTip("<p style='white-space:wrap'>The Date and Time of the Last Generation of Custom Columns in the Target Library metadata.db file.")

        self.calm_library_status_layout.addWidget(self.custom_columns_generated_label,5,0)

        if self.myparentprefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET'] == CC_GENERATION_FALSE_MESSAGE:       # ...Never...
            s = CC_GENERATION_FALSE_MESSAGE
            self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("False")
        else:
            if self.myparentprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] == unicode_type(0):
                s = ""
                self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("False")
            else:
                s = self.myparentprefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET']

        self.custom_columns_generated_value_label = QLabel()
        self.custom_columns_generated_value_label.setTextFormat(Qt.PlainText)
        self.custom_columns_generated_value_label.setText(s)
        self.custom_columns_generated_value_label.setFont(font)
        self.custom_columns_generated_value_label.setAlignment(Qt.AlignLeft)
        self.custom_columns_generated_value_label.setToolTip("<p style='white-space:wrap'>The Date and Time of the Last Generation of Custom Columns in the Target Library metadata.db file.")
        self.custom_columns_generated_value_label.setMinimumWidth(400)

        self.calm_library_status_layout.addWidget(self.custom_columns_generated_value_label,5,1)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setPointSize(10)
        font.setBold(False)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.calm_consolidation_status_groupbox  = QGroupBox('Consolidation Status and History:')
        self.calm_consolidation_status_groupbox.setToolTip("<p style='white-space:wrap'>The status of Target Library as pertains to:  (a) Whether or not the Consolidation Job may be submitted; (b) The results of the most recent Consolidation Job that you executed, irrespective of whether you have refreshed the Target Library since then. ")
        self.calm_consolidation_status_groupbox.setMinimumWidth(400)
        #~ self.calm_consolidation_status_groupbox.setMaximumWidth(800)
        self.calm_consolidation_status_groupbox.setMinimumHeight(0)
        #~ self.calm_consolidation_status_groupbox.setMaximumHeight(150)
        self.layout_frame.addWidget(self.calm_consolidation_status_groupbox )

        self.consolidation_status_layout = QGridLayout()
        self.calm_consolidation_status_groupbox.setLayout(self.consolidation_status_layout)
        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setPointSize(8)
        font.setBold(True)
        #-----------------------------------------------------
        self.consolidation_may_proceed_label = QLabel()
        #~ self.consolidation_may_proceed_label.setMinimumWidth(0)
        self.consolidation_may_proceed_label.setTextFormat(Qt.PlainText)
        self.consolidation_may_proceed_label.setText("Last Target Library--Status:")
        self.consolidation_may_proceed_label.setFont(font)
        self.consolidation_may_proceed_label.setAlignment(Qt.AlignLeft)
        self.consolidation_may_proceed_label.setToolTip("<p style='white-space:wrap'>Whether or not you may now execute a CALM Consolidation Job, or if you already have.")

        self.consolidation_status_layout.addWidget(self.consolidation_may_proceed_label,2,0)

        self.consolidation_may_proceed_value_label = QLabel()
        self.consolidation_may_proceed_value_label.setTextFormat(Qt.PlainText)

        if 'GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL' in self.mytargetprefs:
            if self.mytargetprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] == unicode_type(1):
                msg = "Consolidation May Proceed"
            else:
                msg = "Consolidation is Currently Prohibited"
        else:
            self.mytargetprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] = unicode_type(0)
            msg = "Consolidation is Currently Prohibited"

        self.consolidation_may_proceed_value_label.setText(msg)
        self.consolidation_may_proceed_value_label.setFont(font)
        self.consolidation_may_proceed_value_label.setAlignment(Qt.AlignLeft)
        self.consolidation_may_proceed_value_label.setToolTip("<p style='white-space:wrap'>Whether or not you may now execute a CALM Consolidation Job, or if you already have.")

        self.consolidation_status_layout.addWidget(self.consolidation_may_proceed_value_label,2,1)

        self.status_datetime_consolidated_label = QLabel()
        self.status_datetime_consolidated_label.setTextFormat(Qt.PlainText)
        self.status_datetime_consolidated_label.setText("Latest Consolidation (Any): ")
        self.status_datetime_consolidated_label.setFont(font)
        self.status_datetime_consolidated_label.setAlignment(Qt.AlignLeft)
        self.status_datetime_consolidated_label.setToolTip("<p style='white-space:wrap'>The date and time of the last Consolidation Job executed, irrespective of whether it was for the current or previous incarnation of the Target Library.")

        self.consolidation_status_layout.addWidget(self.status_datetime_consolidated_label,3,0)

        self.status_datetime_consolidated_value_label = QLabel()
        self.status_datetime_consolidated_value_label.setTextFormat(Qt.PlainText)
        if 'CALM_LAST_CONSOLIDATION_JOB_DATETIME' in self.mytargetprefs:
            s = self.mytargetprefs['CALM_LAST_CONSOLIDATION_JOB_DATETIME']
        else:
            s = unicode_type("never")
        self.status_datetime_consolidated_value_label.setText(s)
        self.status_datetime_consolidated_value_label.setFont(font)
        self.status_datetime_consolidated_value_label.setAlignment(Qt.AlignLeft)
        self.status_datetime_consolidated_value_label.setToolTip("<p style='white-space:wrap'>The date and time of the last Consolidation Job executed, irrespective of whether it was for the current or previous incarnation of the Target Library.")

        self.consolidation_status_layout.addWidget(self.status_datetime_consolidated_value_label,3,1)
        #-----------------------------------------------------
        self.status_number_consolidated_label = QLabel()
        self.status_number_consolidated_label.setTextFormat(Qt.PlainText)
        self.status_number_consolidated_label.setText("Libraries Consolidated: ")
        self.status_number_consolidated_label.setFont(font)
        self.status_number_consolidated_label.setAlignment(Qt.AlignLeft)
        self.status_number_consolidated_label.setToolTip("<p style='white-space:wrap'>The cumulative number of Source Libraries consolidated for the particular incarnation of the Target Library referred to by the above 'Last Consolidation' \
                                                                                         <br><br>The Consolidation Job may be run for as many or as few of the Source Libraries at once as you wish. \
                                                                                         <br><br>The cumulative number of Source Libraries consolidated may never be greater than the total number of Source Libraries, because a single Source Library may be consolidated by the Consolidation Job only one (1) time.  Afterwards, any attempts to consolidate it 'again' will be ignored and noted in the Consolidation Job Log.\
                                                                                         <br><br>Source Libraries with no (zero) books will not be counted as having been Consolidated, because you could add some books and then run the Consolidation Job for those Source Libraries.  They would then be included in the total number of Source Libraries consolidated so far.")
        #~ self.status_number_consolidated_label.setMinimumWidth(200)
        #~ self.status_number_consolidated_label.setMaximumWidth(200)

        self.consolidation_status_layout.addWidget(self.status_number_consolidated_label,4,0)

        self.status_number_consolidated_value_label = QLabel()
        self.status_number_consolidated_value_label.setTextFormat(Qt.PlainText)

        if 'CALM_LAST_CONSOLIDATION_NUMBER_LIBRARIES' in self.myparentprefs:
            s = self.myparentprefs['CALM_LAST_CONSOLIDATION_NUMBER_LIBRARIES']
        else:
            s = unicode_type(0)
        self.status_number_consolidated_value_label.setText(s)
        self.status_number_consolidated_value_label.setFont(font)
        self.status_number_consolidated_value_label.setAlignment(Qt.AlignLeft)
        self.status_number_consolidated_value_label.setToolTip("<p style='white-space:wrap'>The cumulative number of Source Libraries consolidated for the particular incarnation of the Target Library referred to by the above 'Last Consolidation' \
                                                                                         <br><br>The Consolidation Job may be run for as many or as few of the Source Libraries at once as you wish. \
                                                                                         <br><br>The cumulative number of Source Libraries consolidated may never be greater than the total number of Source Libraries, because a single Source Library may be consolidated by the Consolidation Job only one (1) time.  Afterwards, any attempts to consolidate it 'again' will be ignored and noted in the Consolidation Job Log.\
                                                                                         <br><br>Source Libraries with no (zero) books will not be counted as having been Consolidated, because you could add some books and then run the Consolidation Job for those Source Libraries.  They would then be included in the total number of Source Libraries consolidated so far.")
        self.consolidation_status_layout.addWidget(self.status_number_consolidated_value_label,4,1)
        #-----------------------------------------------------
        self.status_number_books_label = QLabel()
        self.status_number_books_label.setTextFormat(Qt.PlainText)
        self.status_number_books_label.setText("Books Consolidated:")
        self.status_number_books_label.setFont(font)
        self.status_number_books_label.setAlignment(Qt.AlignLeft)
        self.status_number_books_label.setToolTip("<p style='white-space:wrap'>The cumulative number of Books consolidated (so far) into the Target Library:    Does not include any Shuffling Activity. ")

        self.consolidation_status_layout.addWidget(self.status_number_books_label,5,0)

        self.status_number_books_value_label = QLabel()
        self.status_number_books_value_label.setTextFormat(Qt.PlainText)
        if 'CALM_LAST_CONSOLIDATION_NUMBER_BOOKS' in self.mytargetprefs:
            s = self.mytargetprefs['CALM_LAST_CONSOLIDATION_NUMBER_BOOKS']
        else:
            s = unicode_type(0)
        self.status_number_books_value_label.setText(s)
        self.status_number_books_value_label.setFont(font)
        self.status_number_books_value_label.setAlignment(Qt.AlignLeft)
        self.status_number_books_value_label.setToolTip("<p style='white-space:wrap'>The cumulative number of Books consolidated (so far) into the Target Library:    Does not include any Shuffling Activity. ")

        self.consolidation_status_layout.addWidget(self.status_number_books_value_label,5,1)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setPointSize(10)
        font.setBold(False)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.multicolumnsearch_groupbox = QGroupBox('Consolidation Options:')
        self.multicolumnsearch_groupbox.setToolTip("<p style='white-space:wrap'>Miscellaneous options to control the Consolidation Job.")
        self.multicolumnsearch_groupbox.setMinimumWidth(400)
        #~ self.multicolumnsearch_groupbox.setMaximumWidth(800)
        self.layout_frame.addWidget(self.multicolumnsearch_groupbox)

        self.multicolumnsearch_layout = QHBoxLayout()
        self.multicolumnsearch_layout.setAlignment(Qt.AlignCenter)
        self.multicolumnsearch_groupbox.setLayout(self.multicolumnsearch_layout)

        self.mcs_word_book_index_checkbox = QCheckBox("Consolidate the MCS 'Word-Book Query Index'?")
        self.mcs_word_book_index_checkbox.setToolTip("<p style='white-space:wrap'>Do you want to Consolidate the Multi-Column Search plug-in's 'Word-Book Index' for use in performing Consolidated MCS Word-Book Queries within the CALM Target Library itself?  The Source Library Indexes may have a very large number of rows, so only activate this option if you plan on using the Consolidated Index.")
        self.multicolumnsearch_layout.addWidget(self.mcs_word_book_index_checkbox)

        if 'CALM_MCS_INDEX_CONSOLIDATION' in prefs:
            if prefs['CALM_MCS_INDEX_CONSOLIDATION'] == unicode_type("True"):
                self.mcs_word_book_index_checkbox.setChecked(True)
                self.mytargetprefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("True")
                self.myparentprefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("True")
        else:
            self.mytargetprefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("False")
            self.myparentprefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("False")
            prefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("False")
            prefs

        self.calm_force_reconsolidation_checkbox = QCheckBox("Force Reconsolidation [Use with Caution]?")
        self.calm_force_reconsolidation_checkbox.setToolTip("<p style='white-space:wrap'>Do you absolutely need to force a reconsolidation of a previously consolidated Source Library due to rare, unusual and exigent circumstances?\
                                                                                                                                            <br><br>If you have any doubts whatsoever, you should Refresh, Generate, and Consolidate a new Target Library.\
                                                                                                                                            <br><br>If you have future job failures or other issues, then selecting this option is very likely the cause, and you must Refresh, Generate, and Consolidate a new Target Library.")
        self.multicolumnsearch_layout.addWidget(self.calm_force_reconsolidation_checkbox)

        self.mytargetprefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("False")
        self.myparentprefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("False")
        prefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("False")
        prefs

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setPointSize(10)
        font.setBold(False)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------

        self.instructions_groupbox = QGroupBox('Consolidation Instructions:')
        self.instructions_groupbox.setToolTip("<p style='white-space:wrap'>Instructions for Creating, Generating, and Consolidating the current incarnation of the Target Library.")
        self.instructions_groupbox.setMinimumWidth(400)
        #~ self.instructions_groupbox.setMaximumWidth(800)
        self.instructions_groupbox.setMinimumHeight(500)
        self.layout_frame.addWidget(self.instructions_groupbox)

        self.instructions_layout = QVBoxLayout()
        self.instructions_layout.setAlignment(Qt.AlignCenter)
        self.instructions_groupbox.setLayout(self.instructions_layout)

        font.setPointSize(9)
        font.setBold(False)

        self.instructions_qtextedit =  QTextEdit("")
        self.instructions_qtextedit.setReadOnly(True)

        self.instructions_qtextedit.setWordWrapMode(QTextOption.WrapMode.WordWrap)
        self.instructions_qtextedit.clear()

        self.instructions_html = self.initialize_instructions_html()

        self.instructions_qtextedit.setHtml(self.instructions_html)

        self.instructions_layout.addWidget(self.instructions_qtextedit)

        self.instructions_qtextedit.setToolTip("<p style='white-space:wrap'>Instructions for Creating, Generating, and Consolidating the current incarnation of the Target Library.")

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_widget.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.setWidget(self.scroll_widget)    # now that all widgets have been created and assigned to a layout...
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def switch_to_source_custom_columns_tab(self):
        msg = "Consolidation is Currently Prohibited"
        self.consolidation_may_proceed_value_label.setText(msg)
        self.child_invocation_of_set_current_tab_index(2)
        self.save_real_prefs_target()
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def confirm_current_guidb_path_not_calm(self):
        # verify that current db path of self.guidb does NOT contain "/CALM/metadata.db
        path = self.guidb.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')
        if "/CALM/metadata.db" in path:
            self.current_library_is_a_target_library = True
            self.current_target_library_path = path
            self.current_non_target_library_path = "ZZ:"
            return False
        else:
            self.current_library_is_a_target_library = False
            self.current_target_library_path = "ZZ:"
            self.current_non_target_library_path = path
            return True
    #--------------------------------------------------------------------------------------------------
    def confirm_calm_target_library_exists(self):

        if os.path.exists(self.calm_target_db_full_path):
            return True
        else:
            return False
    #-----------------------------------------------------------------------------------------------
    def confirm_calm_tools_db_exists(self):

        path = self.calm_target_db_full_path
        path = path.replace('metadata.db','metadata_tools.db')

        if os.path.exists(path):
            n_tools_size = os.path.getsize(path)
            if DEBUG: print("n_tools_size = os.path.getsize(tools_path): ", as_unicode(n_tools_size))
            if not as_unicode(n_tools_size) > as_unicode(1000):     # an illogical series of user clicks could theoretically cause the creation of a metadata_tools.db file that is 0 bytes in size.
                return False
            else:
                return True
        else:
            return False
    #-----------------------------------------------------------------------------------------------
    def choose_calm_target_parent_directory_filedialog(self):

        is_valid = self.confirm_current_guidb_path_not_calm()
        if not is_valid:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is a CALM Target Library.  Please QuickSwitch elsewhere before trying again.')), show=True)
            return

        self.calm_metadata_bottom_path = unicode_type("CALM/metadata.db")

        title = "Choose the Parent Directory where CALM should extract its special metadata.db file within a (new or existing) Library named 'CALM'"

        if self.calm_target_parent_directory.count("CALM") == 0:
            try:
                self.calm_target_parent_directory = prefs['CALM_TARGET_DB_LAST_CHOSEN_LIBRARY_DIRECTORY']
            except:
                prefs['CALM_TARGET_DB_LAST_CHOSEN_LIBRARY_DIRECTORY'] = unicode_type("ZZ:")
                self.calm_target_parent_directory = unicode_type("ZZ:")

        chosen_directory_name = QFileDialog.getExistingDirectory(None,title,self.calm_target_parent_directory,QFileDialog.Option.ShowDirsOnly | QFileDialog.Option.DontResolveSymlinks )

        if not chosen_directory_name:
            return

        if iswindows:
            if as_unicode("Desktop") in as_unicode(chosen_directory_name) and as_unicode("Users") in as_unicode(chosen_directory_name):
                error_dialog(self.gui, _('CALM'),_(('The Windows Desktop may not be used for the CALM Target Library.')), show=True)
                return

        self.calm_target_parent_directory =  unicode_type(chosen_directory_name)
        self.mytargetprefs['CALM_TARGET_DB_LAST_CHOSEN_LIBRARY_DIRECTORY'] = unicode_type(chosen_directory_name)
        self.calm_target_parent_directory =  self.calm_target_parent_directory.replace(os.sep, '/')
        self.calm_metadata_bottom_path =  self.calm_metadata_bottom_path.replace(os.sep, '/')
        self.calm_target_db_full_path = os.path.join(self.calm_target_parent_directory,self.calm_metadata_bottom_path)
        self.calm_target_db_full_path = self.calm_target_db_full_path.replace(os.sep, '/')
        self.calm_target_db_full_path = as_unicode(self.calm_target_db_full_path)

        self.special_calm_db_full_path_value_label.setText(self.calm_target_db_full_path)

        self.target_db = self.calm_target_db_full_path

        self.mytargetprefs['CALM_TARGET_PARENT_DIRECTORY'] = unicode_type(self.calm_target_parent_directory)
        self.mytargetprefs['CALM_TARGET_DB_FULL_PATH'] = unicode_type(self.calm_target_db_full_path)
        self.mytargetprefs['GUI_LAST_TAB_USED'] = unicode_type('1')

        self.extract_fresh_calm_metadata_db()
    #-----------------------------------------------------------------------------------------------
    def extract_fresh_calm_metadata_db(self):

        is_valid = self.confirm_current_guidb_path_not_calm()
        if not is_valid:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is a CALM Target Library.  Please QuickSwitch elsewhere before trying again.')), show=True)
            return

        if (not self.calm_target_db_full_path) or (self.calm_target_db_full_path.count("CALM/metadata.db") == 0):
            error_dialog(self.gui, _('CALM'),_(('You Must First Select the Parent Directory into which to Extract the Target Library.')), show=True)
            return

        destination_folder = os.path.join(self.calm_target_parent_directory,"CALM")
        destination_folder = destination_folder.replace(os.sep, '/')
        destination_folder = as_unicode(destination_folder)

        if not self.mytargetprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS'] == unicode_type("True"):
            was_backed_up = False
            if os.path.exists(self.calm_target_db_full_path) and self.calm_target_db_full_path.count("/CALM/metadata.db") > 0:
                title = "CALM"
                msg = "Do you want to back up (now) your current Target Library 'View Manager' and other library-specific customizations to restore after you extract a fresh Target Library copy? \
                            <br>They will be temporarily cached in the current metadata_tools.db..."
                if question_dialog(self.gui, _(title),_(msg)) :
                    self.back_up_metadata_db_preferences_table()
                    was_backed_up = True
        else:
            was_backed_up = False

        if os.path.exists(self.calm_target_db_full_path) and self.calm_target_db_full_path.count("/CALM/metadata.db") > 0:
            os.remove(self.calm_target_db_full_path)            #start with a fresh metadata.db but leave the .json file that the user likely indirectly changed

        if not os.path.exists(destination_folder):
            os.mkdir(destination_folder)
            was_virgin_directory = True
        else:
            was_virgin_directory = False

        # just to be sure the metadata.db was NOT created by Calibre itself automatically if the user ran Calibre and it opened up into the last used library which happened to be the path to its "memorized" Target Library:
        tools_path = self.calm_target_db_full_path.replace("metadata.db","metadata_tools.db")
        if not was_virgin_directory:
            if not os.path.exists(tools_path):
                was_virgin_directory = True
            else:
                n_tools_size = os.path.getsize(tools_path)
                if DEBUG: print("n_tools_size = os.path.getsize(tools_path): ", as_unicode(n_tools_size))
                if not as_unicode(n_tools_size) > as_unicode(1000):     # an illogical series of user clicks could theoretically cause the creation of a metadata_tools.db file that is 0 bytes in size.
                    self.extract_everything_forced(destination_folder)
                    was_virgin_directory = True

        if was_virgin_directory:
            file_name_partial = 'metadata'           # 3 files to extract:   metadata.db , metadata_db_prefs_backup.json , metadata_tools.db
        else:
            file_name_partial = 'metadata.db'      # 1 file to extract:   metadata.db        # start with a fresh metadata.db but leave the .json file and the tools.db that the user will have changed and wants to keep as-is

        file_name_partial = file_name_partial.encode("ascii", "strict")

        zipfile_path = self.plugin_path

        zfile = zipfile.ZipFile(zipfile_path)

        for name in zfile.namelist():       #all files in zip with full internal paths
            name_bytes = as_bytes(name)
            n = name_bytes.find(file_name_partial)
            if n >= 0:
                zfile.extract(name, destination_folder)     # will extract all of the files in the plugin .zip that contain file_name_partial
        #END FOR



        self.child_invocation_of_save_real_prefs_parent("Source Libraries")      # ensure latest source libraries are saved to prefs, as this also causes all 'real' prefs values currently known by the parent to be saved

       #------------------------
        self.mytargetprefs['CALM_TARGET_PARENT_DIRECTORY'] = unicode_type(self.calm_target_parent_directory)
        self.mytargetprefs['CALM_TARGET_DB_FULL_PATH'] = unicode_type(self.calm_target_db_full_path)
        self.mytargetprefs['CALM_TARGET_DB_GENERATING_NONCALM_LIBRARY_PATH'] = unicode_type("ZZ:")
        self.mytargetprefs['GUI_LAST_TAB_USED'] = unicode_type('1')
        s = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
        self.mytargetprefs['GUI_LAST_UPDATE_DATETIME_TARGET'] = unicode_type(s.strip())
        self.mytargetprefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET'] = CC_GENERATION_FALSE_MESSAGE       # ...Never...
        self.mytargetprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] = unicode_type(0)
        self.mytargetprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES']  = unicode_type(0)
        self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("False")
        self.mytargetprefs['CALM_TARGET_DB_MUST_BE_REFRESHED'] = unicode_type("False")
        self.mytargetprefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("False")
        self.mytargetprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS'] = unicode_type("False")
        self.mytargetprefs['CALM_DB_VERSION_METADATA_TOOLS_DB'] = unicode_type(MOST_CURRENT_VERSION_OF_METADATA_TOOLS)
        self.mytargetprefs['CALM_USER_STATUS'] = unicode_type("USER")
        self.mytargetprefs['GUI_LAST_TAB_USED'] = unicode_type('1')
        #------------------------
        self.special_calm_db_updated_value_label.setText(self.mytargetprefs['GUI_LAST_UPDATE_DATETIME_TARGET'])
        self.custom_columns_generated_value_label.setText(CC_GENERATION_FALSE_MESSAGE)        # ...Never...
        s = unicode_type(0)
        self.source_libraries_number_generated_value_label.setText(s)
        self.consolidation_may_proceed_value_label.setText("Consolidation is Currently Prohibited")
        self.update()
        QApplication.instance().processEvents()
        #------------------------

        if was_backed_up:
            title = "CALM"
            msg = "Do you want to restore (now) your backed-up Target Library 'View Manager' and other <b>library-specific</b> customizations that were previously and \
                        temporarily cached in the current metadata_tools.db <b>(which you should already have manually backed-up after manual configuration changes)</b>?"
            if question_dialog(self.gui, _(title),_(msg)) :
                self.restore_metadata_db_preferences_table()

        msg = "All information will be saved, and then CALM will automatically restart.  This will take a second. "
        info_dialog(self.gui, _("CALM"), _(msg), show=True)

        self.child_invocation_to_set_source_libraries_read_only(False)

        # guarantee the 'real' prefs are up-to-date for the few Target Tab-owned prefs keys before exiting and restarting...
        prefs['CALM_TARGET_PARENT_DIRECTORY'] = unicode_type(self.calm_target_parent_directory)
        prefs['CALM_TARGET_DB_FULL_PATH'] = unicode_type(self.calm_target_db_full_path)
        prefs['GUI_LAST_TAB_USED'] = unicode_type('1')
        prefs['GUI_LAST_UPDATE_DATETIME_TARGET']  = self.mytargetprefs['GUI_LAST_UPDATE_DATETIME_TARGET']
        prefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET']  = self.mytargetprefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET']
        prefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL']  = self.mytargetprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL']
        prefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES']  = self.mytargetprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES']
        prefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE']
        prefs['CALM_TARGET_DB_MUST_BE_REFRESHED']  = self.mytargetprefs['CALM_TARGET_DB_MUST_BE_REFRESHED']
        prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = self.mytargetprefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE']
        prefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS']  = self.mytargetprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS']
        prefs['CALM_DB_VERSION_METADATA_TOOLS_DB']  = self.mytargetprefs['CALM_DB_VERSION_METADATA_TOOLS_DB']
        prefs['CALM_USER_STATUS']  = self.mytargetprefs['CALM_USER_STATUS']
        prefs

        #failsafe if the user manually cut and pasted the Target Library elsewhere in the filesystem so the prefs no longer match reality.
        is_valid_db = self.confirm_calm_target_library_exists()
        is_valid_tools_db = self.confirm_calm_tools_db_exists()
        if (not is_valid_db) or (not is_valid_tools_db):
            if DEBUG: print("Something is Wrong in Denmark.  Forcing extraction of all 3 files.")
            self.extract_everything_forced(destination_folder)

        #quick failsafe to ensure that the current metadata_tools.db is indeed the current db version.
        my_db, my_cursor, is_valid = self.apsw_connect_to_tools_db()
        try:
            my_cursor.execute("SELECT * FROM  _source_library_custom_columns")
            my_db.close()
            if DEBUG: print("metadata_tools.db is good to go.")
        except:
            my_db.close()
            if DEBUG: print("metadata_tools.db is NOT good to go.")
            prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("True")
            prefs
            sleep(0.25)
            my_db, my_cursor, is_valid = self.apsw_connect_to_tools_db()   # just connecting now will force an upgrade.
            sleep(0.25)
            my_db.close()

        self.calm_dialog_restart_immediately()
    #--------------------------------------------------------------------------------------------------
    def extract_everything_forced(self,destination_folder):

        file_name_partial = 'metadata'      # 3 files to extract:   metadata.db , metadata_db_prefs_backup.json , metadata_tools.db

        file_name_partial = file_name_partial.encode("ascii", "strict")

        zipfile_path = self.plugin_path

        zfile = zipfile.ZipFile(zipfile_path)

        for name in zfile.namelist():       #all files in zip with full internal paths
            n = name.find(file_name_partial )
            if n >= 0:
                zfile.extract(name, destination_folder)     # will extract all of the files in the plugin .zip that contain file_name_partial
        #END FOR
    #--------------------------------------------------------------------------------------------------
    def delete_entire_calm_directory(self):

        is_valid = self.confirm_current_guidb_path_not_calm()
        if not is_valid:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is a CALM Target Library.  Please QuickSwitch elsewhere before trying again.')), show=True)
            return

        try:  # user might click the button for this out of sequence or randomly, so self.target_db_full_path may not yet exist
            path = self.target_db_full_path
        except:
            self.target_db_full_path = prefs['CALM_TARGET_DB_FULL_PATH']

        path = prefs['CALM_TARGET_DB_FULL_PATH']
        if path.count("/CALM/metadata.db") > 0:
            self.target_db_full_path = path
        else:
            if self.target_db_full_path.count("/CALM/metadata.db") > 0:
                path = self.target_db_full_path
            else:
                self.reset_to_nothing_at_all_done_for_target()
                error_dialog(self.gui, _('CALM'),_(('You must MANUALLY delete the entire /CALM/ directory, including all of its subordinate files and itself.')), show=True)
                json_path = self.plugin_path.replace(".zip",".json")
                if os.path.exists(json_path):
                    os.remove(json_path)  # delete the .json in the plugin config directory too...start fresh to avoid strange behaviors...no downside to this at this moment.
                self.parent_pointer.close()  # close while the user deletes the directory so nothing is locked.

        top = path.replace("/metadata.db","")
        if DEBUG: print("Directory of Target Library: " + top)

        s = top.lower()
        if s.count("calm") == 0 or len(s) < 6:       # never delete the wrong directory...
            return

        title = 'CALM - Delete Directory:   '+ top
        msg = "Are you <b>really</b> sure that you want to purge " + top + " ?<br><br>Ensure that you have already manually backed up the metadata_tools.db file that has all of your personal Tag and Genre Rules."
        if not question_dialog(self.gui, _(title),_(msg)) :
            return

        # ONLY for use on the Target Library path, '/CALM/...'

        # Delete everything reachable from the directory named in "top", assuming there are no symbolic links.
        # CAUTION:  This is dangerous!  For example, if top == '/', it could delete all your disk files.

        #  os.walk(top, topdown=True, onerror=None, followlinks=False)

        # Standard Calibre keeps recreating them no matter how often they are removed unless Target.metadata_dirtied is emptied often.

        if not self.target_db_full_path:
            if DEBUG: print("returning [1]")
            return
        if len(self.target_db_full_path) < 18:
            if DEBUG: print("returning [2]")
            return
        sl = self.target_db_full_path.lower()
        if sl.count("calm") > 1:
            if DEBUG: print("returning [3]")
            return

        if os.path.exists(self.target_db_full_path):
            os.remove(self.target_db_full_path)
        tools_path = self.target_db_full_path.replace("metadata.db","metadata_tools.db")
        if os.path.exists(tools_path):
            os.remove(tools_path)
        json_path = self.target_db_full_path.replace("metadata_tools.db","metadata_db_prefs_backup.json")
        if os.path.exists(json_path):
            os.remove(json_path)

        if (not top == '/') and (len(top) > 5):
            if (not top == '\\') and (len(top) > 5):
                for root, dirs, files in os.walk(top, topdown=False, followlinks=False):
                    for name in files:
                        try:
                            os.remove(os.path.join(root, name))
                            #~ if DEBUG: print(root,name)
                        except Exception as e:
                            if DEBUG: print(as_unicode(e))
                            pass
                    #END FOR
                    for name in dirs:
                        if not top == '/':
                            if not top == '\\':
                                if not name == '/':
                                    if not name == '\\':
                                        if not 'CALM' in name:
                                            if not 'Calm' in name:
                                                if not 'calm' in name:
                                                    if name != top:
                                                        try:
                                                            os.rmdir(os.path.join(root, name))
                                                            if DEBUG: print(root,name)
                                                        except Exception as e:
                                                            if DEBUG: print(as_unicode(e))
                                                            pass
                    #END FOR
                #END FOR
                if (not top == '/') and (len(top) > 5):  # redundant, but just to be super-extra safe...
                    if (not top == '\\') and (len(top) > 5):
                        if top.count("/calm/") > 0:  # redundant, but just to be super-extra safe...
                            if DEBUG: print("top directory will be removed next....",top)
                            top = top.replace("calm","CALM")
                            if os.path.exists(top):
                                os.rmdir(top)
            else:
                return
        else:
            return

        json_path = self.plugin_path.replace(".zip",".json")
        if os.path.exists(json_path):
            os.remove(json_path)  # delete the .json in the plugin config directory too...

        info_dialog(self.gui, _("CALM"), _("Please visually confirm that the <b>entire</b> CALM directory has been deleted, <br>including '/CALM/' itself.  If not, please delete it manually."), show=True)
        self.reset_to_nothing_at_all_done_for_target()
        self.parent_pointer.close()  # close while the user deletes the directory so nothing is locked.
    #--------------------------------------------------------------------------------------------------
    def reset_to_nothing_at_all_done_for_target(self):
        # reset everything to nothing after the CALM directory was totally purged.

        s = "None.  CALM Directory Purged."
        self.mytargetprefs['GUI_LAST_UPDATE_DATETIME_TARGET'] = unicode_type(s.strip())

        self.mytargetprefs['GUI_LAST_TAB_USED'] = unicode_type('1')

        self.mytargetprefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET'] = CC_GENERATION_FALSE_MESSAGE    # ...Never...
        self.mytargetprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] = unicode_type(0)
        self.mytargetprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES']  = unicode_type(0)
        self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("False")

        self.mytargetprefs['CALM_TARGET_DB_FULL_PATH'] = ""

        self.mytargetprefs['CALM_LAST_CONSOLIDATION_JOB_DATETIME'] = unicode_type('...NEVER...')
        self.mytargetprefs['CALM_LAST_CONSOLIDATION_NUMBER_LIBRARIES'] =  unicode_type(0)
        self.mytargetprefs['CALM_LAST_CONSOLIDATION_NUMBER_BOOKS'] =  unicode_type(0)

        self.save_real_prefs_target()

        self.calm_target_db_full_path = ""

        self.special_calm_db_full_path_value_label.setText(self.calm_target_db_full_path)
        self.special_calm_db_updated_value_label.setText(self.mytargetprefs['GUI_LAST_UPDATE_DATETIME_TARGET'])
        self.custom_columns_generated_value_label.setText(prefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET'])
        self.consolidation_may_proceed_value_label.setText("Consolidation is Currently Prohibited")
        self.source_libraries_number_generated_value_label.setText(unicode_type(0))
        self.status_datetime_consolidated_value_label.setText("...NEVER...")
        self.status_number_consolidated_value_label.setText(unicode_type(0))
        self.status_number_books_value_label.setText(unicode_type(0))

        self.child_invocation_to_set_source_libraries_read_only(False)

        self.update()
        QApplication.instance().processEvents()
    #--------------------------------------------------------------------------------------------------
    def save_real_prefs_target(self):
        # only for the pref keys owned by the target tab

        prefs['CALM_DB_VERSION_METADATA_TOOLS_DB'] = self.mytargetprefs['CALM_DB_VERSION_METADATA_TOOLS_DB']

        prefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS'] = self.mytargetprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS']

        prefs['CALM_TARGET_DB_MUST_BE_REFRESHED'] = self.mytargetprefs['CALM_TARGET_DB_MUST_BE_REFRESHED']

        try:
            prefs['CALM_USER_STATUS'] = self.mytargetprefs['CALM_USER_STATUS']
            prefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS'] = self.mytargetprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS']
        except:
            pass

        prefs['CALM_TARGET_PARENT_DIRECTORY'] = unicode_type(self.calm_target_parent_directory)
        prefs['CALM_TARGET_DB_FULL_PATH'] = unicode_type(self.calm_target_db_full_path)

        try:
            prefs['CALM_TARGET_DB_LAST_CHOSEN_LIBRARY_DIRECTORY'] = self.mytargetprefs['CALM_TARGET_DB_LAST_CHOSEN_LIBRARY_DIRECTORY']
        except:
            self.mytargetprefs['CALM_TARGET_DB_LAST_CHOSEN_LIBRARY_DIRECTORY'] = unicode_type("Z:")
            prefs['CALM_TARGET_DB_LAST_CHOSEN_LIBRARY_DIRECTORY'] =  unicode_type("Z:")

        prefs['GUI_LAST_UPDATE_DATETIME_TARGET'] = self.mytargetprefs['GUI_LAST_UPDATE_DATETIME_TARGET']
        prefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET'] = self.mytargetprefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET']

        try:
            prefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] = self.mytargetprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL']
        except:
            self.mytargetprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] = unicode_type(0)
            prefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] = unicode_type(0)

        try:
            prefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES'] = self.mytargetprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES']
        except:
            self.mytargetprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES'] = unicode_type(0)
            prefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES'] = unicode_type(0)

        try:
            prefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE']
        except:
            self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("False")
            prefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] =  unicode_type("False")

        try:
            prefs['CALM_LAST_CONSOLIDATION_JOB_DATETIME'] = self.mytargetprefs['CALM_LAST_CONSOLIDATION_JOB_DATETIME']
        except:
            self.mytargetprefs['CALM_LAST_CONSOLIDATION_JOB_DATETIME']  = unicode_type('...NEVER...')
            prefs['CALM_LAST_CONSOLIDATION_JOB_DATETIME'] = unicode_type('...NEVER...')

        try:
            prefs['CALM_LAST_CONSOLIDATION_NUMBER_LIBRARIES'] = self.mytargetprefs['CALM_LAST_CONSOLIDATION_NUMBER_LIBRARIES']
        except:
            self.mytargetprefs['CALM_LAST_CONSOLIDATION_NUMBER_LIBRARIES'] = unicode_type(0)
            prefs['CALM_LAST_CONSOLIDATION_NUMBER_LIBRARIES'] = unicode_type(0)

        try:
            prefs['CALM_LAST_CONSOLIDATION_NUMBER_BOOKS'] = self.mytargetprefs['CALM_LAST_CONSOLIDATION_NUMBER_BOOKS']
        except:
            self.mytargetprefs['CALM_LAST_CONSOLIDATION_NUMBER_BOOKS']  = unicode_type(0)
            prefs['CALM_LAST_CONSOLIDATION_NUMBER_BOOKS'] = unicode_type(0)

        try:
            prefs['CALM_MCS_INDEX_CONSOLIDATION'] = self.mytargetprefs['CALM_MCS_INDEX_CONSOLIDATION']
        except:
            self.mytargetprefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("False")
            prefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("False")

        if self.mcs_word_book_index_checkbox.isChecked():
            self.mytargetprefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("True")
            prefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("True")
        else:
            self.mytargetprefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("False")
            prefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("False")

        if self.calm_force_reconsolidation_checkbox.isChecked():
            self.mytargetprefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("True")
            prefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("True")
        else:
            self.mytargetprefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("False")
            prefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("False")

        # plus this shared prefs key:
        self.mytargetprefs['GUI_LAST_TAB_USED'] = unicode_type('1')
        prefs['GUI_LAST_TAB_USED'] = unicode_type('1')

        prefs  #save
    #-----------------------------------------------------------------------------------------------
    def return_target_db(self,myparentprefs):
        #called with this code:         self.target_db, self.myparentprefs = self.return_target_db(self.myparentprefs)

        # send self.target_db up to the parent tabwidget for inclusion in the full param_dict
        # send all of the keys owned by this tab back to the parent too, but as the parent's own but-just-updated preferences: myparentprefs

        myparentprefs['CALM_DB_VERSION_METADATA_TOOLS_DB'] =  self.mytargetprefs['CALM_DB_VERSION_METADATA_TOOLS_DB']

        myparentprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS'] = self.mytargetprefs['CALM_DB_VERSION_UPGRADE_SUPPRESS_INFO_DIALOGS']

        myparentprefs['CALM_TARGET_DB_MUST_BE_REFRESHED'] = self.mytargetprefs['CALM_TARGET_DB_MUST_BE_REFRESHED']

        myparentprefs['CALM_TARGET_DB_LAST_CHOSEN_LIBRARY_DIRECTORY'] = self.mytargetprefs['CALM_TARGET_DB_LAST_CHOSEN_LIBRARY_DIRECTORY']
        myparentprefs['CALM_TARGET_PARENT_DIRECTORY'] = self.mytargetprefs['CALM_TARGET_PARENT_DIRECTORY']
        myparentprefs['CALM_TARGET_DB_FULL_PATH'] = self.mytargetprefs['CALM_TARGET_DB_FULL_PATH']

        myparentprefs['GUI_LAST_UPDATE_DATETIME_TARGET'] = self.mytargetprefs['GUI_LAST_UPDATE_DATETIME_TARGET']

        myparentprefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET'] = self.mytargetprefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET']
        myparentprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] = self.mytargetprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL']
        myparentprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES']  =  self.mytargetprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES']
        myparentprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE']

        myparentprefs['CALM_LAST_CONSOLIDATION_JOB_DATETIME'] = self.mytargetprefs['CALM_LAST_CONSOLIDATION_JOB_DATETIME']
        myparentprefs['CALM_LAST_CONSOLIDATION_NUMBER_LIBRARIES'] = self.mytargetprefs['CALM_LAST_CONSOLIDATION_NUMBER_LIBRARIES']
        myparentprefs['CALM_LAST_CONSOLIDATION_NUMBER_BOOKS'] = self.mytargetprefs['CALM_LAST_CONSOLIDATION_NUMBER_BOOKS']

        if self.mcs_word_book_index_checkbox.isChecked():
            self.mytargetprefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("True")
            myparentprefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("True")
            prefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("True")
        else:
            self.mytargetprefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("False")
            myparentprefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("False")
            prefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("False")

        if self.calm_force_reconsolidation_checkbox.isChecked():
            self.mytargetprefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("True")
            myparentprefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("True")
            prefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("True")
        else:
            self.mytargetprefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("False")
            myparentprefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("False")
            prefs['CALM_FORCE_RECONSOLIDATION'] = unicode_type("False")

        prefs

        return self.target_db, myparentprefs
    #--------------------------------------------------------------------------------------------------
    def init_tooltips_for_target_tab(self):
        self.setStyleSheet("QToolTip { color: #ffffff; background-color: #2a82da; border: 1px solid white; }")
    #-----------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def generate_custom_columns_control(self):

        # verify that there is actually an existing target library directory to use in generation...
        is_valid = self.confirm_calm_target_library_exists()
        if not is_valid:
            error_dialog(self.gui, _('CALM'),_(('You must refresh the Target Library before doing its CC Generation')), show=True)
            return

        is_valid = self.confirm_current_guidb_path_not_calm()
        if not is_valid:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is a CALM Target Library.  Please QuickSwitch elsewhere before trying again.')), show=True)
            return

        # verify that a generation has NOT already been performed on THIS particular Target Library.  Otherwise, the user must refresh the Target Library first...
        is_valid = self.confirm_no_generation_yet()
        if not is_valid:
            error_dialog(self.gui, _('CALM'),_(('Current CALM Target Library has already had one CC Generation.<br><br>You must refresh the Target Library before doing another CC Generation')), show=True)
            return

        self.must_abort_user_error = False
        error_level = 0
        was_successful,error_level,number_libraries_generated = self.generate_custom_columns()

        #~ # # # if DEBUG: was_successful = False; error_level = 05; self.purge_all_enumerations = True  # testing only...

        if was_successful:
            self.push_button_generate_custom_columns.hide()
            s = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
            s = s.strip()
            self.mytargetprefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET'] = unicode_type(s)
            prefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET'] =  unicode_type(s)
            self.mytargetprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] =  unicode_type(1)
            prefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] =  unicode_type(1)
            s = self.current_non_target_library_path + "||>>>||" + prefs['CALM_TARGET_DB_FULL_PATH']
            #~ if DEBUG: print(">>>>>>>>>>['CALM_TARGET_DB_GENERATING_NONCALM_LIBRARY_PATH'] = ", s)
            self.mytargetprefs['CALM_TARGET_DB_GENERATING_NONCALM_LIBRARY_PATH'] = unicode_type(s)
            prefs['CALM_TARGET_DB_GENERATING_NONCALM_LIBRARY_PATH'] = unicode_type(s)
            s = unicode_type(number_libraries_generated)
            self.source_libraries_number_generated_value_label.setText(s)
            self.mytargetprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES'] = unicode_type(number_libraries_generated)
            prefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES'] = unicode_type(number_libraries_generated)
            if unicode_type(number_libraries_generated) == unicode_type(0):
                self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("True")
                prefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("True")
            else:
                self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("False")
                prefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("False")
            self.mytargetprefs['GUI_LAST_TAB_USED'] = unicode_type('1')
            self.custom_columns_generated_value_label.setText(self.mytargetprefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET'])
            self.source_libraries_number_generated_warning_pushbutton.hide()
            self.source_libraries_number_generated_value_label.show()
            msg = "Consolidation May Proceed"
            self.consolidation_may_proceed_value_label.setText(msg)
            if self.mcs_word_book_index_checkbox.isChecked():
                self.mytargetprefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("True")
                prefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("True")
            else:
                self.mytargetprefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("False")
                prefs['CALM_MCS_INDEX_CONSOLIDATION'] = unicode_type("False")
            self.update()
            QApplication.instance().processEvents()
            info_dialog(self.gui, _("CALM"), _("Source Custom Columns Activated for Use Have been Generated in the special CALM metadata.db. \
                                                                    <br><br> As soon as you click OK: all Source Libraries will be set to 'Read Only'; all statuses and settings will be saved; and CALM will automatically restart.  Please be patient..."), show=True)
            self.child_invocation_to_set_source_libraries_read_only(True)
            self.child_invocation_of_save_real_prefs_parent('ALL')
            tmpprefs = self.child_invocation_to_retrieve_most_current_parent_prefs()
            #~ for k,v in self.mytargetprefs.iteritems():
            for k,v in iteritems(self.mytargetprefs):
                tmpprefs[k]=v
                prefs[k] = v
            self.maintain_generating_noncalm_library_namespaced_prefs(tmpprefs)
            prefs
            self.calm_dialog_restart_immediately()
        else:
            self.push_button_generate_custom_columns.show()
            self.custom_columns_generated_value_label.setText(CC_GENERATION_FALSE_MESSAGE)  # required due to the validation prior to allowing generation to proceed...
            self.source_libraries_number_generated_warning_pushbutton.show()
            self.source_libraries_number_generated_value_label.hide()
            msg = "Consolidation is Prohibited: Generation Errors"
            self.consolidation_may_proceed_value_label.setText(msg)
            self.update()
            QApplication.instance().processEvents()
            self.mytargetprefs['CALM_TARGET_DB_GENERATING_NONCALM_LIBRARY_PATH'] = unicode_type("ZZ:||>>>||ZZ:")
            prefs['CALM_TARGET_DB_GENERATING_NONCALM_LIBRARY_PATH'] = unicode_type("ZZ:||>>>||ZZ:")
            self.mytargetprefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET'] = unicode_type(CC_GENERATION_FALSE_MESSAGE)
            prefs['GUI_LAST_CC_GENERATION_DATETIME_TARGET'] = unicode_type(CC_GENERATION_FALSE_MESSAGE)
            self.mytargetprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] =  unicode_type(0)
            prefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL'] =  unicode_type(0)
            self.mytargetprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES'] = unicode_type(0)
            prefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES'] = unicode_type(0)
            self.mytargetprefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("False")
            prefs['GUI_LAST_CC_GENERATION_NO_LIBRARIES_TO_GENERATE'] = unicode_type("False")
            self.child_invocation_to_set_source_libraries_read_only(False)
            self.child_invocation_of_save_real_prefs_parent('ALL')
            tmpprefs = self.child_invocation_to_retrieve_most_current_parent_prefs()
            #~ for k,v in self.mytargetprefs.iteritems():
            for k,v in iteritems(self.mytargetprefs):
                tmpprefs[k]=v
                prefs[k] = v
            self.maintain_generating_noncalm_library_namespaced_prefs(tmpprefs)
            prefs
            del tmpprefs

            if self.must_abort_user_error:
                error_level = 00

            if error_level == 99:
                error_dialog(self.gui, _('FAILURE TO GENERATE:  Program Technical Errors...'),_(("There are significant and fatal data errors in the generation process that are caused by a program error.<br><br>Please: [1]Refresh CALM after restarting Calibre; [2]Deactivate all Source Custom Columns for use; [3]Generate;  [4]Consolidate WITHOUT Source Custom Columns.[5]Notify the developer that you got this message.")), show=True)
            elif error_level == 98:
                error_dialog(self.gui, _('FAILURE TO GENERATE:  Calibre CC API Execution Errors...'),_(("There are fatal data errors in the use of an API to create new Target Custom Columns.<br><br>Please: [1]Refresh CALM after restarting Calibre; [2]Deactivate all Source Custom Columns for use; [3]Generate;  [4]Consolidate WITHOUT Source Custom Columns.[5]Notify the developer that you got this message, attaching a debug log of the first failed generation process.")), show=True)
            elif error_level == 10:
                error_dialog(self.gui, _('FAILURE TO GENERATE:  Database Technical Errors...'),_(("Please ensure your Source Library custom_columns are standardized and totally consistant across your Calibre ecosystem.<br><br>Restart Calibre, and after verifying all of your Source custom columns, try again.")), show=True)
            elif error_level == 5:
                error_dialog(self.gui, _('Custom Column Datatypes of Enumeration Were Invalid'),_(('Custom Columns of type Text with Fixed Allowed Values (a.k.a Enumerations) were invalid.  One display dictionary with valid values and their colors was corrupt.')), show=True)
                self.purge_all_enumerations = True
            else:
                error_dialog(self.gui, _('FAILURE TO GENERATE:  User CC Standardization Consistency Errors...'),_(('Please ensure your Source Library Custom Columns are standardized and totally consistant across your Calibre ecosystem.<br><br>Restart Calibre, and after verifying all of your Source custom columns, refresh the Target Library and then try again.')), show=True)

            if self.purge_all_enumerations:
                error_dialog(self.gui, _('Custom Column Datatypes of Enumeration Cannot Be Used'),_(('Custom Columns of type Text with Fixed Allowed Values (a.k.a Enumerations) are invalid due to consistency errors with those datatypes.   You need to either standardize all of those Libraries, or Deactivate them in the Source Custom Columns Tab and then Generate without them.')), show=True)
    #--------------------------------------------------------------------------------------------------
    def generate_custom_columns(self):

        was_successful = True
        error_level = 0
        number_libraries_generated = unicode_type(0)
        self.purge_all_enumerations = False

        self.custom_columns_generated_value_label.setText(WORKING_MESSAGE_1)
        self.update()
        QApplication.instance().processEvents()

        my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db()
        if not is_valid:
            error_level = 98
            return  was_successful,error_level,unicode_type(0)

        self.harmonize_enumeration_displays(my_db,my_cursor)

        if not self.harmonized_displays_valid:
            error_level = 5
            return  was_successful,error_level,unicode_type(0)

        #---------------------------------------------------------------------------------------------
         # version 2.0.27 changed 'unique by' to include the 'real' display for enumeration only...otherwise display is *always* going to be {}, so 'unique' anyway for non-enumeration...
        #---------------------------------------------------------------------------------------------
        #---------------------------------------------------------------------------------------------
        my_cursor.execute("begin")
        mysql = "DROP TABLE IF EXISTS _source_custom_column_groups"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        my_cursor.execute("begin")
        mysql = 'CREATE TABLE IF NOT EXISTS _source_custom_column_groups \
                                        (\
                                        id INTEGER PRIMARY KEY  AUTOINCREMENT  NOT NULL,\
                                        source_library_cc_label           TEXT NOT NULL,\
                                        source_library_cc_name          TEXT NOT NULL,\
                                        source_library_cc_datatype     TEXT NOT NULL,\
                                        source_library_cc_mark_for_delete   BOOL DEFAULT 0 NOT NULL,\
                                        source_library_cc_editable       BOOL DEFAULT 1 NOT NULL,\
                                        source_library_cc_display         TEXT DEFAULT "{}" NOT NULL,\
                                        source_library_cc_is_multiple    BOOL DEFAULT 0 NOT NULL,\
                                        source_library_cc_normalized   BOOL NOT NULL, \
                                        activate_for_calm                      BOOL NOT NULL  DEFAULT 0,\
                                        UNIQUE(source_library_cc_label, source_library_cc_name, source_library_cc_datatype, \
                                                     source_library_cc_mark_for_delete, source_library_cc_editable,source_library_cc_display, \
                                                     source_library_cc_is_multiple,source_library_cc_normalized)   )'
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        #---------------------------------------------------------------------------------------------
        my_cursor.execute("begin")
        mysql = "DELETE FROM _source_custom_column_groups"
        my_cursor.execute(mysql)
        mysql = "UPDATE sqlite_sequence SET seq = 9 WHERE name = '_source_custom_column_groups' "
        my_cursor.execute(mysql)
        mysql = "DELETE FROM _source_custom_column_mapping"
        my_cursor.execute(mysql)
        mysql = "DELETE FROM _target_custom_columns"
        my_cursor.execute(mysql)
        mysql = "DELETE FROM _target_custom_column_to_group_mapping"
        my_cursor.execute(mysql)
        mysql = "DELETE FROM _target_groupid_longest_display_value"
        my_cursor.execute(mysql)
        mysql = "DELETE FROM _source_cc_to_target_cc_mapping"
        my_cursor.execute(mysql)
        mysql = "DELETE FROM sqlite_sequence WHERE name = '_source_cc_to_target_cc_mapping' "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")


        #table source_library_custom_columns was previously populated by 'autopopulate' within the Source Custom Columns tab.  Since the user has to review its contents, it was not changed then at all.
        #source_library_custom_columns has the original labels from the original Source Libraries, but a few need tweaking right now, at the beginning, because they will have to be renamed within CALM.
        my_cursor.execute("begin")
        mysql = "UPDATE _source_library_custom_columns SET source_library_cc_label = \
                                                (SELECT target_library_cc_label FROM _source_library_cc_labels_renamed_in_target_cc_table \
                                                 WHERE _source_library_cc_labels_renamed_in_target_cc_table.source_library_cc_label = _source_library_custom_columns.source_library_cc_label ) \
                        WHERE source_library_cc_label IN(SELECT source_library_cc_label FROM _source_library_cc_labels_renamed_in_target_cc_table )"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        my_cursor.execute("begin")
        mysql = "UPDATE _source_library_custom_columns SET source_library_cc_name = source_library_cc_name||' (Source)' \
                                    WHERE source_library_cc_label LIKE '%_source' AND source_library_cc_name NOT LIKE '% (Source)'  "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        # multi-language Calibre Library ecosystem having 'pages' as a common label, but a variety of names for that identical label, such as: 'Pages','Paginas','Seiten', etc.
        my_cursor.execute("begin")
        mysql = "UPDATE _source_library_custom_columns SET source_library_cc_name = 'Pages (Source)' \
                                    WHERE source_library_cc_label = 'pages_source'  "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        # change all to is_editable = True so additional groups will not be created    as of version 2.0.27
        my_cursor.execute("begin")
        mysql = "UPDATE _source_library_custom_columns SET source_library_cc_editable = 1 "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        #-----------------

        # note: source_library_cc_display was replaced with a {} until later in order to avoid creating unnecessary groups...the longest will later "win" and be updated in this table......except for enumeration, as of version 2.0.27 due to valid value issues...
        try:  #all values must be identical (except for display) to be assigned to the identical group...except for enumeration, as of version 2.0.27, due to valid value issues...
            my_cursor.execute("begin")
            mysql = "INSERT OR IGNORE INTO _source_custom_column_groups \
                                                                    SELECT null, source_library_cc_label, source_library_cc_name, source_library_cc_datatype, \
                                                                                source_library_cc_mark_for_delete, source_library_cc_editable,\
                                                                                '{}', source_library_cc_is_multiple,\
                                                                                source_library_cc_normalized, \
                                                                                1  \
                                                                    FROM _source_library_custom_columns \
                                                                    WHERE _source_library_custom_columns.activate_for_calm = 1  AND _source_library_custom_columns.source_library_cc_datatype != 'enumeration'  "    # not enumeration
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            my_cursor.execute("begin")
            mysql = "INSERT OR IGNORE INTO _source_custom_column_groups \
                                                                    SELECT null, source_library_cc_label, source_library_cc_name, source_library_cc_datatype, \
                                                                                source_library_cc_mark_for_delete, source_library_cc_editable,\
                                                                                source_library_cc_display, source_library_cc_is_multiple,\
                                                                                source_library_cc_normalized, \
                                                                                1  \
                                                                    FROM _source_library_custom_columns \
                                                                    WHERE _source_library_custom_columns.activate_for_calm = 1 AND _source_library_custom_columns.source_library_cc_datatype = 'enumeration'  "        # enumeration
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            if DEBUG: print("_source_custom_column_groups populated.")
        except Exception as e:
            my_db.close()
            if DEBUG: print("[1] Error in populating _source_custom_column_groups: ", as_unicode(e))
            was_successful = False
            error_level = 10
            return  was_successful,error_level,unicode_type(0)

        # note:   groupid initially set to 0 and will be updated later...
        try:
            my_cursor.execute("begin")
            mysql = "INSERT OR REPLACE INTO _source_custom_column_mapping (source_library, source_library_cc_id, groupid) \
                                                                    SELECT source_library, source_library_cc_id, 0 \
                                                                    FROM _source_library_custom_columns \
                                                                    WHERE _source_library_custom_columns.activate_for_calm = 1  "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            if DEBUG: print("_source_custom_column_mapping populated.")
        except Exception as e:
            my_db.close()
            if DEBUG: print("[2] Error in populating _source_custom_column_mapping: ", as_unicode(e))
            was_successful = False
            error_level = 10
            return  was_successful,error_level,unicode_type(0)

        try:
            my_cursor.execute("begin")
            mysql = "\
            UPDATE OR IGNORE _source_custom_column_mapping SET groupid = \
            (SELECT id FROM _source_custom_column_groups \
                           WHERE  _source_custom_column_groups.id NOT NULL \
                               AND  _source_custom_column_groups.source_library_cc_label  =                     (SELECT source_library_cc_label FROM _source_library_custom_columns                      WHERE source_library = _source_custom_column_mapping.source_library      AND _source_library_custom_columns.source_library_cc_id =  _source_custom_column_mapping.source_library_cc_id ) \
                               AND  _source_custom_column_groups.source_library_cc_name  =                   (SELECT source_library_cc_name FROM _source_library_custom_columns                     WHERE source_library = _source_custom_column_mapping.source_library     AND _source_library_custom_columns.source_library_cc_id =  _source_custom_column_mapping.source_library_cc_id ) \
                               AND  _source_custom_column_groups.source_library_cc_datatype  =              (SELECT source_library_cc_datatype FROM _source_library_custom_columns               WHERE source_library = _source_custom_column_mapping.source_library      AND _source_library_custom_columns.source_library_cc_id =  _source_custom_column_mapping.source_library_cc_id ) \
                               AND  _source_custom_column_groups.source_library_cc_mark_for_delete  =   (SELECT source_library_cc_mark_for_delete FROM _source_library_custom_columns   WHERE source_library = _source_custom_column_mapping.source_library      AND _source_library_custom_columns.source_library_cc_id =  _source_custom_column_mapping.source_library_cc_id ) \
                               AND  _source_custom_column_groups.source_library_cc_editable  =                (SELECT source_library_cc_editable FROM _source_library_custom_columns               WHERE source_library = _source_custom_column_mapping.source_library      AND _source_library_custom_columns.source_library_cc_id =  _source_custom_column_mapping.source_library_cc_id ) \
                               AND  _source_custom_column_groups.source_library_cc_is_multiple  =            (SELECT source_library_cc_is_multiple FROM _source_library_custom_columns           WHERE source_library = _source_custom_column_mapping.source_library      AND _source_library_custom_columns.source_library_cc_id =  _source_custom_column_mapping.source_library_cc_id ) \
                               AND  _source_custom_column_groups.source_library_cc_normalized  =           (SELECT source_library_cc_normalized FROM _source_library_custom_columns          WHERE source_library = _source_custom_column_mapping.source_library      AND _source_library_custom_columns.source_library_cc_id =  _source_custom_column_mapping.source_library_cc_id ) \
                               AND _source_custom_column_groups.activate_for_calm  =  1 \
                               AND _source_custom_column_groups.source_library_cc_datatype != 'enumeration' ) WHERE groupid NOT NULL "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            if DEBUG: print("[Not-Enumeration]_source_custom_column_mapping updated with assigned groupid [1].")
            #~ CRITICAL: for enumerations this presupposes that the display dicts are identical in key sort and in dict content, not just dict content.  enumeration displays were harmonized previously.
            #~ CRITICAL: for enumerations with the identical labels and names, but different displays (values different and/or colors different) , only one of them will appear in the CALM Target Library.  The user MUST standardize enumerations!
            #~ CRITICAL: truly different enumeration custom columns must have different labels AND names, not just different labels, from all other enumeration custom columns.
            my_cursor.execute("begin")
            mysql = "\
            UPDATE OR IGNORE _source_custom_column_mapping SET groupid = \
            (SELECT id FROM _source_custom_column_groups \
                           WHERE  _source_custom_column_groups.id NOT NULL \
                               AND  _source_custom_column_groups.source_library_cc_label  =                     (SELECT source_library_cc_label FROM _source_library_custom_columns                      WHERE source_library = _source_custom_column_mapping.source_library      AND _source_library_custom_columns.source_library_cc_id =  _source_custom_column_mapping.source_library_cc_id ) \
                               AND  _source_custom_column_groups.source_library_cc_name  =                   (SELECT source_library_cc_name FROM _source_library_custom_columns                     WHERE source_library = _source_custom_column_mapping.source_library     AND _source_library_custom_columns.source_library_cc_id =  _source_custom_column_mapping.source_library_cc_id ) \
                               AND  _source_custom_column_groups.source_library_cc_datatype  =              (SELECT source_library_cc_datatype FROM _source_library_custom_columns               WHERE source_library = _source_custom_column_mapping.source_library      AND _source_library_custom_columns.source_library_cc_id =  _source_custom_column_mapping.source_library_cc_id ) \
                               AND  _source_custom_column_groups.source_library_cc_mark_for_delete  =   (SELECT source_library_cc_mark_for_delete FROM _source_library_custom_columns   WHERE source_library = _source_custom_column_mapping.source_library      AND _source_library_custom_columns.source_library_cc_id =  _source_custom_column_mapping.source_library_cc_id ) \
                               AND  _source_custom_column_groups.source_library_cc_editable  =                (SELECT source_library_cc_editable FROM _source_library_custom_columns               WHERE source_library = _source_custom_column_mapping.source_library      AND _source_library_custom_columns.source_library_cc_id =  _source_custom_column_mapping.source_library_cc_id ) \
                               AND  _source_custom_column_groups.source_library_cc_is_multiple  =            (SELECT source_library_cc_is_multiple FROM _source_library_custom_columns           WHERE source_library = _source_custom_column_mapping.source_library      AND _source_library_custom_columns.source_library_cc_id =  _source_custom_column_mapping.source_library_cc_id ) \
                               AND  _source_custom_column_groups.source_library_cc_normalized  =           (SELECT source_library_cc_normalized FROM _source_library_custom_columns          WHERE source_library = _source_custom_column_mapping.source_library      AND _source_library_custom_columns.source_library_cc_id =  _source_custom_column_mapping.source_library_cc_id ) \
                               AND _source_custom_column_groups.activate_for_calm  =  1 \
                               AND _source_custom_column_groups.source_library_cc_display =                   (SELECT source_library_cc_display FROM _source_library_custom_columns          WHERE source_library = _source_custom_column_mapping.source_library      AND _source_library_custom_columns.source_library_cc_id =  _source_custom_column_mapping.source_library_cc_id ) \
                               AND _source_custom_column_groups.source_library_cc_datatype = 'enumeration' )  WHERE groupid NOT NULL "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            if DEBUG: print("[Enumeration]_source_custom_column_mapping updated with assigned groupid [1].")
        except Exception as e:
            my_db.close()
            if DEBUG: print("[3] Error in updating _source_custom_column_mapping: ", as_unicode(e))   # e.g.  ConstraintError: NOT NULL constraint failed: _source_custom_column_mapping.groupid
            was_successful = False
            error_level = 10
            return  was_successful,error_level,unicode_type(0)

        #failsafe - others
        try:
            my_cursor.execute("begin")
            mysql = "INSERT OR REPLACE INTO _source_custom_column_mapping \
                                                                       SELECT source_library, source_library_cc_id,groupid \
                                                                       FROM __active_sources_not_mapped_to_target_with_valid_mapping_final \
                                                                     WHERE groupid NOT NULL AND source_library_cc_id NOT NULL \
                                                                         AND source_library_cc_datatype != 'enumeration'  "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            if DEBUG: print("_source_custom_column_mapping updated with assigned groupid [3].")
        except Exception as e:
            my_db.close()
            if DEBUG: print("[5] Error in updating _source_custom_column_mapping: ", as_unicode(e))
            was_successful = False
            error_level = 10
            return  was_successful,error_level,unicode_type(0)


        self.custom_columns_generated_value_label.setText(WORKING_MESSAGE_1)
        self.update()
        QApplication.instance().processEvents()

        # Generate a new Target Library custom column for each of the above "groups"
        mysql = "SELECT * FROM _source_custom_column_groups"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        #---------------------
        my_db.close()      # metadata_tools.db, NOT metadata.db
        #---------------------
        if not tmp_rows:
            info_dialog(self.gui, _("CALM"), _("No CALM Custom Columns Need to be Generated (There Is Nothing to Generate)."), show=True)
            was_successful = True
            error_level = 0
            return  was_successful,error_level,number_libraries_generated
        else:
            if len(tmp_rows) == 0:
                info_dialog(self.gui, _("CALM"), _("No CALM Custom Columns Need to be Generated (There Is Nothing to Generate)."), show=True)
                was_successful = True
                error_level = 0
                return  was_successful,error_level,number_libraries_generated
            else:
                pass

        lib_path = prefs['CALM_TARGET_DB_FULL_PATH']
        if isbytestring(lib_path):
            lib_path = lib_path.decode(filesystem_encoding)
        lib_path = lib_path.replace(os.sep, '/')
        lib_path = lib_path.replace("metadata.db","")
        if lib_path.endswith("/"):
            lib_path = lib_path[0:-1]
        if DEBUG: print("prefs['CALM_TARGET_DB_FULL_PATH']: ", lib_path)

        custom_columns_original_source_names_dict = {}

        calibre_api_param_list = []

        tmp_set = set(tmp_rows)
        tmp_rows = list(tmp_set)  # no duplicates
        del tmp_set
        tmp_rows.sort(key=lambda column: column[1])    # sort by label
        for row in tmp_rows:
            if DEBUG: print("row: ", as_unicode(row))
            groupid,label,name,datatype,mark_for_delete,editable,display,is_multiple,normalized,activate_for_calm = row
            if is_multiple == 1:
                m = "--is-multiple  "
            else:
                m = "mdummy"
            label = unicodedata.normalize('NFKD', label).encode('ascii','ignore')
            new_name = unicodedata.normalize('NFKD', name).encode('ascii','ignore')  # this is to avoid creating this:  VersiÃ³n  or this:   PÃ¡ginas
            if new_name != name:
                custom_columns_original_source_names_dict[label] = name
            #~ table custom_columns.display will be changed via SQL later using groupid to find it.
            #~ exception is datatype = enumeration as of version 2.0.27...enumeration is already made unique and displays permanent...no groupid in their label either...
            #~ --display:  This is a JSON string.
            if datatype == "enumeration":
                display_json_first = ' --display=' + '"{\\"enum_values\\":['
                display_json_middle = '\\"[VALUE]\\", '
                display_json_last = ']}"'
                display = as_unicode(display)
                display_dict = ast.literal_eval(display)  #   {"enum_values": ["true", "false", "one", "two", "three", "four", "yes", "no"], "use_decorations": 0, "enum_colors": [], "description": ""}
                if isinstance(display_dict,dict):
                    display_dict = only_unicode_recursive(display_dict)
                    for k,v in iteritems(display_dict):
                        if as_unicode(k) == as_unicode("enum_values"):
                            if DEBUG: print("enumeration display dict: ", as_unicode(k), as_unicode(v))
                            v = as_unicode(v)
                            value_list = ast.literal_eval(v)
                            middle = ""
                            if isinstance(value_list,list):
                                found_values = False
                                for row in value_list:
                                    s = display_json_middle
                                    s = s.replace("[VALUE]",row)
                                    middle = middle + s
                                    found_values = True
                                    #~ if DEBUG: print("middle: ", middle)
                                #END FOR
                                if found_values:
                                    middle = middle.strip()
                                    if middle.endswith(","):
                                        middle = middle[0:-1]
                                    display = display_json_first + middle + display_json_last + "  "
                                    if DEBUG: print("Enumeration --display param will be: ", display)
                                else:
                                    if DEBUG: print("[1] ERROR: Enumeration  display missing 'enum_values', which cannot be correct...", display, label, name, datatype)
                                    display = " "
                            else:
                                display = " "
                    #END FOR
                else:
                    if DEBUG: print("[2] ERROR: Enumeration  display missing 'enum_values', which cannot be correct...", display, label, name, datatype)
                    display = " "
            else:
                display = " "
            if datatype == "enumeration":
                pass  # enumeration names+labels+displays are unique already due to harmonization, so adding a groupid will not help at all, and would actually corrupt the mapping...
            else:
                label = as_unicode(label)
                name = as_unicode(name)
                label = label + "_" + as_unicode(groupid)   # also, so can easily determine its groupid in order to change its table custom_columns.display later..
                name = name + "_" + as_unicode(groupid)   # in case user had same names for different labels across multiple Source Libraries...

            if display == " ":
                display = "dblank"

            m = as_unicode(m)
            display = as_unicode(display)
            label = as_unicode(label)
            datatype = as_unicode(datatype)
            new_name = as_unicode(new_name)

            param = m + '|||' + display  + '|||' + label + '|||' + '"[NAME]"' + '|||' +  datatype
            param = param.replace("[NAME]",new_name)
            calibre_api_param_list.append(param)
            if DEBUG: print("param: ", param)
        #END FOR
        del tmp_rows

        self.custom_columns_generated_value_label.setText(WORKING_MESSAGE_0)
        self.update()
        QApplication.instance().processEvents()

        if DEBUG: print("Number of non-unique params: " + as_unicode(len(calibre_api_param_list)))

        calibre_api_param_list = list(set(calibre_api_param_list))
        calibre_api_param_list.sort()

        if DEBUG: print("Number of unique params: " + as_unicode(len(calibre_api_param_list)))

        #-------------------------------------------------------------------------------------
        was_successful = self.run_calibre_api_for_cc(lib_path,calibre_api_param_list)
        #-------------------------------------------------------------------------------------
        del calibre_api_param_list

        if was_successful:
            # connect to the Target metadata.db
            my_db,my_cursor,is_valid = self.apsw_connect_to_target()
            if not is_valid:
                error_level = 98
                return  was_successful,error_level,unicode_type(0)
            #---------------------
            self.eliminate_groupnumber_suffix_for_cc_pages_if_possible(my_db,my_cursor)
            #---------------------
            self.eliminate_groupnumber_suffix_where_possible_not_enumeration(my_db,my_cursor)
            #---------------------
            #~ custom_columns_original_source_names_dict[label] = name
            my_cursor.execute("begin")
            mysql = "UPDATE custom_columns SET name = ? WHERE label = ? "
            #~ for label,original_name in custom_columns_original_source_names_dict.iteritems():
            for label,original_name in iteritems(custom_columns_original_source_names_dict):
                my_cursor.execute(mysql,(original_name,label))
            #END FOR
            my_cursor.execute("commit")
            del custom_columns_original_source_names_dict
            #---------------------
            mysql = "SELECT * FROM custom_columns"     # Target
            my_cursor.execute(mysql)
            target_custom_column_table_list = my_cursor.fetchall()
            if not target_custom_column_table_list:
                if DEBUG: print("target_custom_column_table_list is None...")
                target_custom_column_table_list = []
            #---------------------
            my_db.close()      # metadata.db NOT tools
            #---------------------
            #---------------------
            #---------------------
            #---------------------
            # now update metadata_tools.db...
            #---------------------
            #---------------------
            my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db()
            if not is_valid:
                error_level = 98
                return  was_successful,error_level,unicode_type(0)
            #---------------------
            #---------------------
            # finalize the tools _target... tables used by main_consolidation.py to map source table data into equivalent target tables
            #---------------------
            #~ metadata_tools.db...
            target_label_id_dict = {}
            my_cursor.execute("begin")
            for row in target_custom_column_table_list:
                id,label,name,datatype,mark_for_delete,editable,display,is_multiple,normalized = row
                target_label_id_dict[label] = id
                mysql = "INSERT OR REPLACE INTO _target_custom_columns SELECT ?,?,?,?,?,?,?,?,?"
                my_cursor.execute(mysql,(id,label,name,datatype,mark_for_delete,editable,display,is_multiple,normalized))
            #END FOR
            my_cursor.execute("commit")
            del target_custom_column_table_list
            #---------------------
            my_cursor.execute("begin")
            mysql = "INSERT OR REPLACE INTO _target_custom_column_to_group_mapping  SELECT target_cc_id,groupid,target_library_cc_label  FROM __source_cc_to_target_cc_mapping_direct_only "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            #---------------------
            my_cursor.execute("begin")
            mysql = "INSERT OR REPLACE INTO _source_cc_to_target_cc_mapping  SELECT null,*  FROM __source_cc_to_target_cc_mapping_direct_only "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            #---------------------
            #~ metadata_tools.db...
            self.purge_all_enumerations = False

        else:
            error_level = 98
            return  was_successful,error_level,unicode_type(0)

        #------------------------------------------------------
        # NOTE:  When Auditing 'Source!=Target Mapping'
        #------------------------------------------------------
        # target cc labels that still have _NN suffixes will not directly map back to the original source library custom columns.
        # In order that they will be accounted for properly when manually auditing metadata_tools.db, do this:
        #        execute this view:              __target_labels_with_group_suffixes
        #        list the rows in this table:   _source_library_cc_labels_renamed_in_target_cc_table
        #------------------------------------------------------

        if was_successful:
            mysql = "SELECT * FROM __invalid_source_to_target_cc_normalization_mappings"        #~ example:    s:/calibre/calibremcs2  --  28  --  37  --  series  --  enumeration  --  1  --  1
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                pass
            else:
                if len(tmp_rows) == 0:
                    pass
                else:
                    was_successful = False
                    error_level = 99
                    my_db.close()
                    if DEBUG: print("SELECT * FROM __invalid_source_to_target_cc_normalization_mappings:  rows were returned, so there are data errors as shown below: ")
                    for row in tmp_rows:
                        source_library,source_library_cc_id,target_cc_id,target_cc_datatype,source_library_cc_datatype,target_cc_normalized,source_library_cc_normalized = row
                        if DEBUG: print(source_library," -- ",as_unicode(source_library_cc_id)," -- ",as_unicode(target_cc_id)," -- ",source_library_cc_datatype," -- ",target_cc_datatype," -- ",as_unicode(source_library_cc_normalized)," -- ",as_unicode(target_cc_normalized) )
                    #END FOR
                    return  was_successful,error_level,unicode_type(0)

        if was_successful:
            mysql = "SELECT count(DISTINCT source_library) AS number_source_libraries FROM _source_cc_to_target_cc_mapping "
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                number_libraries_generated = 0
            else:
                if len(tmp_rows) == 0:
                    number_libraries_generated = 0
                else:
                    for row in tmp_rows:
                        for col in row:
                            if DEBUG: print("col is: ", as_unicode(col))
                            number_libraries_generated = unicode_type(col)
                            if number_libraries_generated == "":
                                number_libraries_generated = unicode_type(0)
                            if DEBUG: print("number_libraries_generated = unicode_type(col): ", number_libraries_generated)
                            s = unicode_type(number_libraries_generated)
                            self.source_libraries_number_generated_value_label.setText(s)
                            self.mytargetprefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES']  = unicode_type(number_libraries_generated)
                            prefs['GUI_LAST_CC_GENERATION_NUMBER_LIBRARIES'] = unicode_type(number_libraries_generated)
                            break
                        #END FOR
                        break
                    #END FOR
                    self.update()
                    QApplication.instance().processEvents()

        if was_successful:
            #~ if DEBUG: print("groupid_display_dict,target_custom_column_to_group_mapping_dict = self.update_custom_column_display_with_best_available_value_tools_tables(my_db,my_cursor)")
            groupid_display_dict,target_custom_column_to_group_mapping_dict = self.update_custom_column_display_with_best_available_value_tools_tables(my_db,my_cursor)
            my_db.close()  #metadata_tools.db
            my_db,my_cursor,is_valid = self.apsw_connect_to_target()
            if not is_valid:
                error_level = 98
                return  was_successful,error_level,unicode_type(0)
            self.update_custom_column_display_with_best_available_value_target_tables(my_db,my_cursor,groupid_display_dict,target_custom_column_to_group_mapping_dict)
            #~ ---------------------------------
            #~ ---------------------------------
            my_db.close()  #metadata.db
        else:
            my_db.close()  #metadata_tools.db

        self.hide()
        self.update()
        QApplication.instance().processEvents()
        self.show()

        return  was_successful,error_level,number_libraries_generated
    #--------------------------------------------------------------------------------------------------
    def harmonize_enumeration_displays(self,my_db,my_cursor):
        # enumeration displays must be in the identical key order...
        # truly different enumeration custom columns must have different labels AND names, not just different displays, from all other enumeration custom columns.
        from collections import OrderedDict

        self.harmonized_displays_valid = True
        self.purge_all_enumerations = False

        self.harmonized_source_library_custom_columns = []
        empty_list = []
        empty_list = as_unicode(empty_list)

        mysql = "SELECT  source_library,source_library_cc_id,source_library_cc_name,source_library_cc_display FROM _source_library_custom_columns WHERE source_library_cc_datatype = 'enumeration' "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        tmp_rows.sort()
        for row in tmp_rows:
            if DEBUG: print(as_unicode(row))
            source_library,source_library_cc_id,source_library_cc_name,source_library_cc_display = row
            source_library_cc_display = as_unicode(source_library_cc_display)
            try:
                display_dict = ast.literal_eval(source_library_cc_display)  #   {"enum_values": ["true", "false", "one", "two", "three", "four", "yes", "no"], "use_decorations": 0, "enum_colors": [], "description": ""}
            except Exception as e:
                source_library_cc_display = str(source_library_cc_display)
                if DEBUG: print("display_dict = ast.literal_eval(source_library_cc_display): ", source_library_cc_display, "   ERROR: ", str(e))
            if isinstance(display_dict,dict):
                my_dictionary = OrderedDict()
                #~ for k,v in display_dict.iteritems():
                for k,v in iteritems(display_dict):
                    if as_unicode(k) == as_unicode("enum_values"):
                        v = as_unicode(v)
                        value_list = ast.literal_eval(v)
                        if isinstance(value_list,list):
                            value_list.sort()
                            my_dictionary[as_unicode(k)] = value_list
                        else:
                            my_dictionary[as_unicode(k)] = empty_list
                #END FOR
                #~ for k,v in display_dict.iteritems():
                for k,v in iteritems(display_dict):
                    if as_unicode(k) == as_unicode("enum_colors"):
                        v = as_unicode(v)
                        value_list = ast.literal_eval(v)
                        if isinstance(value_list,list):
                            value_list.sort()
                            my_dictionary[as_unicode(k)] = value_list
                        else:
                            my_dictionary[as_unicode(k)] = empty_list
                #END FOR
                #~ for k,v in display_dict.iteritems():
                for k,v in iteritems(display_dict):
                    if as_unicode(k) == as_unicode("description"):
                        my_dictionary[as_unicode(k)] = as_unicode("CALM: Harmonized")
                #END FOR

                new_dict = {}
                #~ for k,v in my_dictionary.iteritems():
                for k,v in iteritems(my_dictionary):
                    #~ k = as_unicode(k)
                    #~ v = as_unicode(v)
                    new_dict[k] = v
                #END FOR

                new_dict = only_unicode_recursive(new_dict, encoding='utf-8', errors='strict')
                if DEBUG: print("source_library_cc_display: ", as_unicode(new_dict))

                source_library_cc_display = as_unicode(new_dict)
                source_library_cc_display = source_library_cc_display.replace("'",'"')  # only double-quotes
                if DEBUG: print("source_library_cc_display",source_library_cc_display)

                my_cursor.execute("begin")
                mysql = "UPDATE _source_library_custom_columns  SET source_library_cc_display = ? WHERE source_library = ? AND source_library_cc_id = ?"
                my_cursor.execute(mysql,(source_library_cc_display,source_library,source_library_cc_id))
                my_cursor.execute("commit")
            else:
                self.harmonized_displays_valid = False
                if DEBUG: print("Error in harmonize_enumeration_displays: display_dict is not a valid dict for: ", source_library, source_library_cc_name)
        #END FOR

        if DEBUG: print("self.harmonized_displays_valid",self.harmonized_displays_valid)
    #--------------------------------------------------------------------------------------------------
    def update_custom_column_display_with_best_available_value_tools_tables(self,my_db,my_cursor):
        # find the display that has the longest length by groupid, and use that in the Target custom_columns table.
        # exception: datatype = enumeration

        groupid_display_dict = {}
        target_custom_column_to_group_mapping_dict = {}

        my_cursor.execute("begin")
        mysql = "DELETE FROM _target_groupid_longest_display_value"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        my_cursor.execute("begin")
        #~ mysql = "INSERT OR IGNORE INTO _target_groupid_longest_display_value SELECT groupid, source_library_cc_display FROM __source_library_cc_display_length_by_groupid"
        mysql = "INSERT OR IGNORE INTO _target_groupid_longest_display_value \
                        SELECT groupid, source_library_cc_display \
                        FROM __source_library_cc_display_length_by_groupid \
                        WHERE source_library_cc_display NOT LIKE '%enum_%' "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        mysql = "SELECT groupid,display FROM _target_groupid_longest_display_value"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            pass
        else:
            for row in tmp_rows:
                groupid,display = row
                groupid_display_dict[groupid] = display
            #END FOR
            del tmp_rows

        mysql = "SELECT id,source_library_cc_display FROM _source_custom_column_groups WHERE source_library_cc_datatype = 'enumeration' "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            pass
        else:
            for row in tmp_rows:
                groupid,display = row
                if 'u"' in display:  # artifact caused by changing from Python 2 to Python 3 while still using both...
                    if DEBUG: print('====>>>> warning:  leading u" in JSON will cause an immediate Calibre Switch-Library fatal error: /n', display)
                    display = as_bytes(display)
                    display = display.replace(as_bytes('u"'),as_bytes('"'))
                    display = as_unicode(display)
                groupid_display_dict[groupid] = display
                if DEBUG: print("enumeration groupid_display_dict[groupid] = display : ", as_unicode(groupid), display)
            #END FOR
            del tmp_rows

        mysql = "SELECT target_cc_id,groupid FROM _target_custom_column_to_group_mapping"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            pass
        else:
            for row in tmp_rows:
                target_cc_id,groupid = row
                target_custom_column_to_group_mapping_dict[target_cc_id] = groupid
            #END FOR
            del tmp_rows

        return groupid_display_dict,target_custom_column_to_group_mapping_dict
    #--------------------------------------------------------------------------------------------------
    def update_custom_column_display_with_best_available_value_target_tables(self,my_db,my_cursor,groupid_display_dict,target_custom_column_to_group_mapping_dict):
        # update the displays in the Target custom_columns table using what the tools counterpart to this function (just above) provides.
        my_cursor.execute("begin")
        #~ for target_cc_id,groupid in target_custom_column_to_group_mapping_dict.iteritems():
        for target_cc_id,groupid in iteritems(target_custom_column_to_group_mapping_dict):
            display = groupid_display_dict[groupid]
            mysql = "UPDATE custom_columns SET display = ? WHERE id = ? "
            my_cursor.execute(mysql,(display,target_cc_id))
        #END FOR
        my_cursor.execute("commit")

        # as of Calibre release 2.64, datatype=comments provides multiple attributes.  To avoid issues, all non-CALM datatype=comments will be set to a generic display value.
        my_cursor.execute("begin")
        mysql = "UPDATE custom_columns SET display = ? WHERE datatype = 'comments' AND id > 16 "
        display = '{"description": "", "interpret_as": "long-text", "heading_position": "side"}'
        my_cursor.execute(mysql,([display]))
        my_cursor.execute("commit")

        # special renamed labels require special handling.
        my_cursor.execute("begin")
        display = '{"composite_sort": "text", "composite_template": "{identifiers:select(isbn)}", "use_decorations": 0, "description": "", "make_category": false, "contains_html": true}'
        mysql = 'UPDATE custom_columns \
                              SET display = ? \
                        WHERE datatype = "composite" AND label = "isbn_source"  '
        my_cursor.execute(mysql,([display]))
        display = '{"description": "Genre originally used by Source Librates.  Not used by CALM Derive Genres.", "use_decorations": 0}'
        mysql = 'UPDATE custom_columns \
                              SET display = ? \
                        WHERE label = "genre_source"  '
        my_cursor.execute(mysql,([display]))
        display = '{"description": "English Noun Frequency.  CALM has no formats with extractable text, so the ENF plug-in cannot be used here.", "use_decorations": 0}'
        mysql = 'UPDATE custom_columns \
                              SET display = ? \
                        WHERE label = "enf_source"  '
        my_cursor.execute(mysql,([display]))
        my_cursor.execute("commit")

        # composite custom columns that have a display of simply '{}' will cause template key errors, so change them from datatype composite to datatype comments to inactivate them. user can manually change them.
        my_cursor.execute("begin")
        mysql = "UPDATE custom_columns SET datatype = 'comments' , display = ? WHERE datatype = 'composite' and display = '{}' "
        display = '{"description": "This was a Source Library Composite Column (Built from Other Columns) datatype, but was changed to a Comments datatype because of a Template error.  Manual intervention is suggested.  Standardization may be indicated."}'
        my_cursor.execute(mysql,([display]))
        my_cursor.execute("commit")

        del groupid_display_dict
        del target_custom_column_to_group_mapping_dict
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def eliminate_groupnumber_suffix_where_possible_not_enumeration(self,my_db,my_cursor):
        # if possible, eliminate the _NN suffix from the Target custom_columns labels.
        # it is possible if there would be zero (0) duplicate labels if that were done. if possible on a label basis, also remove it from that label's name.
        # 'possible' means 'will not cause a uniqueness constraint error in table custom_columns' for 'label'.

        cc_label_dict = {}
        cc_name_dict = {}
        s_label_concat = ""

        n = CALM_HIGHEST_OWN_CUSTOM_COLUMN_ID             # the 'standard' custom_columns in the Target end at id = 14.  genre_calm is 14 and isbn is 13...

        mysql = "SELECT id,label,name FROM custom_columns WHERE id > ? AND DATATYPE != 'enumeration' "
        my_cursor.execute(mysql,([n]))
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            if DEBUG: print("table custom_columns is empty.")
            return
        else:
            if len(tmp_rows) == 0:
                del tmp_rows
                return
            else:
                s_label_concat = ""
                for row in tmp_rows:
                    id,label,name = row
                    id = int(id)
                    s_label_concat = s_label_concat + label + "---"
                    cc_label_dict[id] = label
                    cc_name_dict[id] = name
                #END FOR
                del tmp_rows

        if DEBUG: print("s_label_concat: ", s_label_concat)

        p = re.compile("[_][0-9]+$", re.IGNORECASE)

        cc_label_dict_copy = cc_label_dict.copy()
        #~ for id,label in cc_label_dict_copy.iteritems():
        for id,label in iteritems(cc_label_dict_copy):
            original_label = label
            match_label = p.search(label)
            if not match_label:
                if DEBUG: print("not match_label: ",as_unicode(id)," ---- ",label)
                continue
            else:
                if DEBUG: print("yes, match_label: ",as_unicode(id)," ---- ",label)
                s = match_label.group()
                new_label = label.replace(s,"")
                if new_label == "genre":       #special handling to keep Drive Genres 'genre' totally separate and easily distinguished from Source Library 'genre', and vice-versa.
                    new_label = "genre_source"         # this row MUST be in table _source_library_cc_labels_renamed_in_target_cc_table :  genre, genre_source
                    cc_label_dict[id] = new_label
                    new_name = "Genre (Source)"
                    cc_name_dict[id] = new_name
                    continue
                if new_label == "isbn":       #special handling since 'isbn' in the Target is designed to work with the Metadata Tools Tab, so all other "isbns" must have a different label.
                    new_label = "isbn_source"         # this row MUST be in table _source_library_cc_labels_renamed_in_target_cc_table :  isbn , isbn_source
                    cc_label_dict[id] = new_label
                    new_name = "ISBN (Source)"
                    cc_name_dict[id] = new_name
                    continue
                if new_label == "work_series":   #special handling for QuarantineAndScrub 'work_series' to ensure its groupid is removed.
                    new_label = "work_series_source"   # this row MUST be in table _source_library_cc_labels_renamed_in_target_cc_table :  work_series , work_series_source
                    cc_label_dict[id] = new_label
                    new_name = "WorkSeriesPartial (Source)"
                    cc_name_dict[id] = new_name
                    continue
                if new_label == "status":   #special handling for QuarantineAndScrub 'status' since that is commonly used arbitrarily by many users.
                    new_label = "status_source"   # this row MUST be in table _source_library_cc_labels_renamed_in_target_cc_table :  status , status_source
                    cc_label_dict[id] = new_label
                    new_name = "Status (Source)"
                    cc_name_dict[id] = new_name
                    continue
                if new_label == "enf":   #special handling for 'enf' used by English Noun Frequency to ensure its groupid is removed.
                    new_label = "enf_source"        # this row MUST be in table _source_library_cc_labels_renamed_in_target_cc_table :  enf , enf_source
                    cc_label_dict[id] = new_label
                    new_name = "ENF (Source)"
                    cc_name_dict[id] = new_name
                    continue
                n = s_label_concat.count(new_label)
                if n == 1:
                    new_label = new_label.lower()
                    cc_label_dict[id] = new_label
                    name = cc_name_dict[id]
                    new_name = name.replace(s,"")
                    cc_name_dict[id] = new_name
                    if DEBUG: print("oldlabel: " + label + "  newlabel: " + new_label + "  --  oldname: " + name + "  newname: " + new_name)
                else:
                    continue
        #END FOR

        my_cursor.execute("begin")
        #~ for id,new_label in cc_label_dict.iteritems():
        for id,new_label in iteritems(cc_label_dict):
            if DEBUG: print("for id,new_label in cc_label_dict.iteritems() UPDATE custom_columns SET label = :", as_unicode(id), new_label)
            try:
                n = CALM_HIGHEST_OWN_CUSTOM_COLUMN_ID
                mysql = "UPDATE custom_columns SET label = ? WHERE id = ? AND label != ? AND id > ? "
                my_cursor.execute(mysql,(new_label,id,new_label,n))
                new_name = cc_name_dict[id]
                mysql = "UPDATE custom_columns SET name = ? WHERE id = ? AND name != ? AND id > ? "
                my_cursor.execute(mysql,(new_name,id,new_name,n))
            except Exception as e:
                if DEBUG: print("Exception in eliminating the group is almost certainly due to creating a uniqueness constraint error if it actually changed the label: " , as_unicode(e))
                pass
        #END FOR
        my_cursor.execute("commit")

        del s_label_concat
        del cc_label_dict_copy
        del cc_name_dict
        del cc_label_dict

        # ensure that the label of 'isbn_source' (if there is one) has the name of 'ISBN (Source)', and is not just 'ISBN'.  That would cause 2 different labels with the same name.
        my_cursor.execute("begin")
        mysql = "UPDATE custom_columns SET name = 'ISBN (Source)' WHERE label = 'isbn_source' "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def eliminate_groupnumber_suffix_for_cc_pages_if_possible(self,my_db,my_cursor):
        # the custom column 'pages' is extremely common, and deserves special consideration in the interest of user-friendliness.
        # currently connected to metadata.db, not metadata_tools.db

        short_pages_found = False

        mysql = "SELECT label,name FROM custom_columns WHERE label LIKE 'pages%' "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            pass
        else:
            if len(tmp_rows) == 0:
                pass
            else:
                for row in tmp_rows:
                    label,name = row
                    if label == "pages":
                        short_pages_found = True
                #END FOR

        if short_pages_found:
            if DEBUG: print("Target Library has a custom_column named 'pages', so nothing can be done to eliminate group suffixes.  The user must/should standardize their custom columns.  Returning")
            return

        target_custom_column_dict = {}
        work_list = []
        work_dict = {}

        mysql = "SELECT label,name FROM custom_columns WHERE label LIKE 'pages%' "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            return
        else:
            if len(tmp_rows) == 0:
                return
            else:
                for row in tmp_rows:
                    work_list.append(row)
                    work_dict[label] = row
                #END FOR
                del tmp_rows

        #~ "pages_11","Pages"
        #~ "pages_174","Paginas"

        work_list.sort()

        p = re.compile("[_][0-9]+$", re.IGNORECASE)

        for row in work_list:
            old_label,name = row
            match_label = p.search(old_label)
            if not match_label:
                continue
            else:
                s = match_label.group()
                new_label = old_label.replace(s,"")
                if new_label in work_dict:  # already exists, and cannot have duplicate label names...
                    continue
                else:
                    # can now safely  change the target library's table custom_columns from old_label to new_label
                    my_cursor.execute("begin")
                    mysql = "UPDATE custom_columns SET label = ? WHERE label = ? AND ? NOT IN(SELECT label FROM custom_columns) "
                    my_cursor.execute(mysql,(new_label,old_label,new_label))
                    my_cursor.execute("commit")
        #END FOR

        del target_custom_column_dict
        del work_list
        del work_dict

        # ensure that the label of 'pages' has the English name of 'Pages'.  solves the problem of different libraries with different languages, but all have a custom column called 'pages' with different names.
        my_cursor.execute("begin")
        mysql = "UPDATE custom_columns SET name = 'Pages' WHERE label = 'pages' "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def confirm_no_generation_yet(self):
        is_valid = True
        s = self.mytargetprefs['GUI_LAST_CC_GENERATION_WAS_SUCCESSFUL']
        if  not (s == unicode_type(0)):
            is_valid = False
        return is_valid
    #--------------------------------------------------------------------------------------------------
    def back_up_metadata_db_preferences_table(self):

        my_db,my_cursor,is_valid = self.apsw_connect_to_target()
        if not is_valid:
            return

        is_valid = self.apsw_attach_to_tools_db(my_db,my_cursor)
        if not is_valid:
            my_db.close()
            return

        try:
            my_cursor.execute("begin")
            mysql = "INSERT OR REPLACE INTO TOOLS._target_metadata_db_preferences_table SELECT * FROM main.preferences"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except:
            pass
        my_db.close()
    #--------------------------------------------------------------------------------------------------
    def restore_metadata_db_preferences_table(self):

        my_db,my_cursor,is_valid = self.apsw_connect_to_target()
        if not is_valid:
            return
        is_valid = self.apsw_attach_to_tools_db(my_db,my_cursor)
        if not is_valid:
            my_db.close()
            return

        try:
            my_cursor.execute("begin")
            mysql = "INSERT OR REPLACE INTO main.preferences SELECT * FROM TOOLS._target_metadata_db_preferences_table "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except:
            pass
        my_db.close()

        title = "CALM"
        msg = "Target Library 'View Manager' and other library-specific customizations have been restored."
        info_dialog(self.gui, _(title),_(msg), show=True)
    #--------------------------------------------------------------------------------------------------
    def get_number_of_generated_libraries(self):

        my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db()
        if not is_valid:
            return 0

        mysql = "SELECT count(DISTINCT source_library) AS number_source_libraries FROM _source_cc_to_target_cc_mapping "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            number_generated_libraries = 0
        else:
            if len(tmp_rows) == 0:
                number_generated_libraries = 0
            else:
                for row in tmp_rows:
                    for col in row:
                        number_generated_libraries = unicode_type(col)
                        if DEBUG: print("number_source_libraries [that were generated] = unicode_type(col): ", number_generated_libraries)
                        break
                    #END FOR
                    break
                #END FOR

        my_db.close()

        return number_generated_libraries
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def apsw_connect_to_tools_db(self):

        lib_path = prefs['CALM_TARGET_DB_FULL_PATH']
        path = lib_path.replace("metadata.db","metadata_tools.db")
        path = path.replace(os.sep, '/')
        if path.endswith("/"):
            path = path[0:-1]
        if isbytestring(path):
            if DEBUG: print("path isbytestring: ", path)
            path = path.decode(filesystem_encoding)
            if DEBUG: print("path = path.decode(filesystem_encoding): decoded path is now: ", path)
        if DEBUG: print("filesystem_encoding is: ", str(filesystem_encoding))

        if not os.path.exists(path):
            error_dialog(self.gui, _('CALM'),_((ERROR_MESSAGE_METADATA_TOOLS_DB_FILE_IS_MISSING)), show=True)
            error_dialog(self.gui, _('CALM'),_(("You should now exit Calibre, then use the command line to start Calibre specifying a Source Library to use.  Do NOT try to restart using the CALM Target Library.")), show=True)
            if DEBUG: print("path to tools db is: ", path)
            if DEBUG: print("error: ", as_unicode(e))
            if DEBUG: print(ERROR_MESSAGE_METADATA_TOOLS_DB_FILE_IS_MISSING)
            for k,v in iteritems(prefs.defaults):
                prefs[k] = v
            #END FOR
            prefs
            return None,None,False

        try:
            my_db =apsw.Connection(path)
        except Exception as e:
            my_db.close()
            if DEBUG: print("path to tools db is: ", path)
            if DEBUG: print("error: ", as_unicode(e))
            if DEBUG: print(ERROR_MESSAGE_METADATA_TOOLS_DB_FILE_IS_MISSING)
            for k,v in iteritems(prefs.defaults):
                prefs[k] = v
            #END FOR
            prefs
            return None,None,False

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 5000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        try:
            my_cursor.execute("SELECT * FROM  _source_library_custom_columns")
            self.mytargetprefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("False")
            prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("False")
        except:
            self.mytargetprefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("True")
            prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("True")

        mysql = "PRAGMA main.user_version;  "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        for row in tmp_rows:
            for col in row:
                schema_user_version = col
        if as_unicode(schema_user_version) != MOST_CURRENT_VERSION_OF_METADATA_TOOLS \
            or prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] == unicode_type("True"):
            if DEBUG: print("BEFORE schema_user_version: ", as_unicode(schema_user_version))
            type = "CONNECTED"
            self.create_new_sqlite_objects_in_tools_db(my_db,my_cursor,type)
            mysql = "PRAGMA main.user_version = [N] ;  "
            mysql = mysql.replace("[N]",as_unicode(MOST_CURRENT_VERSION_OF_METADATA_TOOLS))
            my_cursor.execute(mysql)
            mysql = "PRAGMA main.user_version;  "
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            for row in tmp_rows:
                for col in row:
                    schema_user_version = col
            if DEBUG: print("AFTER schema_user_version: ", as_unicode(schema_user_version))
            self.mytargetprefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("False")
            prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("False")
            tmpcopy = prefs.copy()    # a simple 'prefs' is a function, not a dict...
            db.prefs.set_namespaced(DB_PREFS_NAMESPACE, DB_PREFS_KEY_SETTINGS, tmpcopy)   #update metadata.db table=preferences...
            del tmpcopy
        else:
            pass

        return my_db,my_cursor,True
    #--------------------------------------------------------------------------------------------------
    def run_calibre_api_for_cc(self,target_lib_path,execution_param_list):

        was_successful = True
        self.must_abort_user_error = False

        counter = 0
        n_total = len(execution_param_list)
        for param in execution_param_list:
            if DEBUG: print(param)
            try:
                if counter == 0:
                    msg = "Creating " + as_unicode(n_total) + " New Custom Column(s)"
                    counter = 1
                else:
                    msg = "...Creating " + as_unicode(n_total) + " New Custom Column(s)"
                    counter = 0
                self.custom_columns_generated_value_label.setText(msg)
                self.update()
                QApplication.instance().processEvents()
                msg = "Running API: " + param
                if DEBUG: print("------------------",msg)
                try:
                    msg = calm_cli_add_custom_column(param,target_lib_path)
                    if not msg:
                        was_successful = True
                        if DEBUG: print("...New Custom Column Created...", param)
                        msg = "...New Custom Column(s) Created..."
                    else:
                        was_successful = False
                    self.custom_columns_generated_value_label.setText(msg)
                    self.update()
                    QApplication.instance().processEvents()
                except Exception as e:
                    if DEBUG: print("Exception: ", as_unicode(e))
                    was_successful = False
                    self.must_abort_user_error = True
                n_total = n_total - 1
                if not was_successful:
                    x1 = "ERROR: " +  "  >>>>" + msg
                    if DEBUG: print(x1)
                    x2 = "GENERATION OF CUSTOM COLUMNS TERMINATED PREMATURELY."
                    if DEBUG: print(x2)
                    msg = x2 + "......." + x1
                    error_dialog(self.gui, _('CALM'),_((msg)), show=True)
                    self.special_calm_db_updated_value_label.setText("MUST REFRESH DUE TO GENERATION ERROR[1]")
                    self.custom_columns_generated_value_label.setText(CC_GENERATION_FALSE_MESSAGE)
                    self.must_abort_user_error = True
                    return False
            except Exception as e:
                x1 = "ERROR: " +  "  >>>>" + as_unicode(e)
                if DEBUG: print(x1)
                x2 = "GENERATION OF CUSTOM COLUMNS TERMINATED PREMATURELY."
                if DEBUG: print(x2)
                msg = x2 + "......." + x1
                error_dialog(self.gui, _('CALM'),_((msg)), show=True)
                self.special_calm_db_updated_value_label.setText("MUST REFRESH DUE TO GENERATION ERROR[2]")
                self.custom_columns_generated_value_label.setText(CC_GENERATION_FALSE_MESSAGE)
                self.must_abort_user_error = True
                return False
        #END FOR
        self.must_abort_user_error = False
        return was_successful
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def apsw_connect_to_target(self):

        path = prefs['CALM_TARGET_DB_FULL_PATH']

        if path.count("metadata.db") == 0:
            path = path + "/metadata.db"
        path = path.replace(os.sep, '/')
        if path.endswith("/"):
            path = path[0:-1]
        if isbytestring(path):
            if DEBUG: print("path isbytestring: ", path)
            path = path.decode(filesystem_encoding)
            if DEBUG: print("path = path.decode(filesystem_encoding): decoded path is now: ", path)
        if DEBUG: print("filesystem_encoding is: ", str(filesystem_encoding))

        try:
            my_db =apsw.Connection(path)
            is_valid = True
        except Exception as e:
            if DEBUG: print("path to target is: ", path)
            if DEBUG: print("error: ", as_unicode(e))
            is_valid = False
            return None,None,is_valid

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 5000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        return my_db,my_cursor,is_valid
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def apsw_attach_to_tools_db(self,my_db,my_cursor):

        s1 = "ATTACH DATABASE '"
        s2 =  "'  As 'TOOLS' ;"

        path = self.target_db
        path = path.replace("metadata.db","metadata_tools.db")
        path = path.replace(os.sep, '/')
        if path.endswith("/"):
            path = path[0:-1]
        if isbytestring(path):
            if DEBUG: print("path isbytestring: ", path)
            path = path.decode(filesystem_encoding)
            if DEBUG: print("path = path.decode(filesystem_encoding): decoded path is now: ", path)
        if DEBUG: print("filesystem_encoding is: ", str(filesystem_encoding))

        mysql = s1 + path + s2

        try:
            if DEBUG: print("Attaching to Tools DB: " + path)
            my_cursor.execute (mysql)
            mysql = "PRAGMA TOOLS.busy_timeout = 5000;"      #PRAGMA busy_timeout = milliseconds;
            my_cursor.execute(mysql)
            is_valid = True
        except Exception as e:
            if DEBUG: print("NOT Attached: " + as_unicode(path))
            if DEBUG: print(as_unicode(e))
            is_valid = False
            return is_valid

        try:
            my_cursor.execute("SELECT * FROM  TOOLS._source_library_custom_columns")
            self.mytargetprefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("False")
            prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("False")
        except:
            self.mytargetprefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("True")
            prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("True")


        mysql = "PRAGMA TOOLS.user_version;  "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        for row in tmp_rows:
            for col in row:
                schema_user_version = col
        if as_unicode(schema_user_version) != MOST_CURRENT_VERSION_OF_METADATA_TOOLS \
            or prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] == unicode_type("True"):
            if DEBUG: print("BEFORE schema_user_version: ", as_unicode(schema_user_version))
            type = "ATTACHED"
            self.create_new_sqlite_objects_in_tools_db(my_db,my_cursor,type)
            mysql = "PRAGMA TOOLS.user_version = [N] ;  "
            mysql = mysql.replace("[N]",as_unicode(MOST_CURRENT_VERSION_OF_METADATA_TOOLS))
            my_cursor.execute(mysql)
            mysql = "PRAGMA TOOLS.user_version;  "
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            for row in tmp_rows:
                for col in row:
                    schema_user_version = col
            if DEBUG: print("AFTER schema_user_version: ", as_unicode(schema_user_version))
            self.mytargetprefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("False")
            prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("False")
            tmpcopy = prefs.copy()    # a simple 'prefs' is a function, not a dict...
            db.prefs.set_namespaced(DB_PREFS_NAMESPACE, DB_PREFS_KEY_SETTINGS, tmpcopy)   #update metadata.db table=preferences...
            del tmpcopy
        else:
            pass

        return is_valid
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def initialize_instructions_html(self):
        self.instructions_html = \
        '''
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><html><head><meta http-equiv="content-type" content="text/html; charset=utf-8"/><title></title><meta name="generator" content="LibreOffice 5.0.2.2 (Windows)"/><meta name="created" content="00:00:00"/><meta name="changed" content="2015-10-29T10:02:02.517000000"/><meta name="created" content="00:00:00"><meta name="changed" content="2015-10-29T09:38:57.365000000"><meta name="created" content="00:00:00"><meta name="changed" content="2015-10-29T09:33:26.128000000"><meta name="created" content="00:00:00"><meta name="changed" content="2015-10-28T21:20:25.395000000"><meta name="changed" content="2015-08-16T12:50:33.897000000"></head><body lang="en-US" dir="ltr"><table width="100%" cellpadding="0" cellspacing="0" style="page-break-before: always"><col width="14*"><col width="211*"><col width="32*"><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p> <br/></p>  </td> <td width="82%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"><b>Target    Library Instructions</b></font></font></p><p align="center"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 14pt"><i><b>Be    sure to read all 'ToolTips' by hovering your mouse over the    buttons and text.</b></i></font></font></p><p align="center"> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p style="margin-right: 2.38in"> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[ 1 ]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">Using    the Calibre menu option</font> <font size="5" style="font-size: 18pt"><i>[Current    Library Icon] &gt; Quick Switch</i></font>, <font size="5" style="font-size: 18pt">   switch to a Calibre Library that is</font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>any</b></u></font></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">Calibre</span></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">Library</span></font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>except</b></u></font></font> <font size="5" style="font-size: 18pt">the</font> <font size="5" style="font-size: 18pt"><b>Target    Library</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">itself</span></font>.</font></p><p> <font face="Times New Roman, serif"> <font color="#800000"> <font size="5" style="font-size: 18pt"><i><u><b>None</b></u></i></font></font> <font size="5" style="font-size: 18pt"><i> <span style="font-weight: normal">of    the actions available from the Target Library Tab, including    submitting the</span></i></font> <font size="5" style="font-size: 18pt"><i><b>Consolidation    Job,</b></i></font> <font size="5" style="font-size: 18pt"><i>may    be executed</i></font> <font size="5" style="font-size: 18pt"><i>while    currently within</i></font> <font size="5" style="font-size: 18pt"><i>the</i></font> <font size="5" style="font-size: 18pt"><i><b>Target Library</b></i></font> <font size="5" style="font-size: 18pt"><i> <span style="font-weight: normal">itself.</span></i></font></font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>2</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p style="margin-bottom: 0in"> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">Select    the</font> <font size="5" style="font-size: 18pt"><b>Parent    Directory</b></font> <font size="5" style="font-size: 18pt">under    which the single new</font> <font size="5" style="font-size: 18pt"><b>Target    Library</b></font> <font size="5" style="font-size: 18pt">created    by the</font> <font size="5" style="font-size: 18pt"><b>Consolidation    Job</b></font> <font size="5" style="font-size: 18pt">is to be    located.</font> <font size="5" style="font-size: 18pt"><b>CALM</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">will    automatically perform the next step for you, then will    automatically restart.</span></font></font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font>
        <font size="3" style="font-size: 12pt"><b>3</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">If    you only need to refresh the</font> <font size="5" style="font-size: 18pt"><b>Target    Library</b></font>, <font size="5" style="font-size: 18pt">manually    extract a</font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>Fresh    Copy</b></u></font></font> <font size="5" style="font-size: 18pt">of    the special</font> <font size="5" style="font-size: 18pt"><b>Target</b></font> <font size="5" style="font-size: 18pt"><b>Library</b></font>. <font size="5" style="font-size: 18pt">   The</font> <font size="5" style="font-size: 18pt"><b>Target    Library</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">full    path will appear.</span></font></font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">Example:</span></font> <font size="5" style="font-size: 18pt"><b>X:/CALM/metadata.db</b></font></font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"><i><b>CALM</b></i></font> <font size="5" style="font-size: 18pt"><i> <span style="font-weight: normal">will    automatically restart.</span></i></font></font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[ 4 ]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">Click    the</font> <font size="5" style="font-size: 18pt"><b>Source    Libraries Tab</b></font> <font size="5" style="font-size: 18pt">.</font> <font size="5" style="font-size: 18pt">Select the</font> <font size="5" style="font-size: 18pt"><b>Source    Libraries</b></font> <font size="5" style="font-size: 18pt">that    you wish to take a</font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>snapshot</b></u></font></font> <font size="5" style="font-size: 18pt">of and then combine into a    single new</font> <font size="5" style="font-size: 18pt"><b>Target    Library</b></font> <font size="5" style="font-size: 18pt">.</font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>Save</b></u></font></font>. <font size="5" style="font-size: 18pt">Be patient.</font> <font size="5" style="font-size: 18pt"> <br/></font> <br/> <font size="5" style="font-size: 18pt">Verify    your selections. You will</font> <font size="5" style="font-size: 18pt"><u><b>not</b></u></font> <font size="5" style="font-size: 18pt">be able to change the list    of</font> <font size="5" style="font-size: 18pt"><b>Source    Libraries</b></font> <font size="5" style="font-size: 18pt">later    after you have '</font> <font size="5" style="font-size: 18pt"><b>Generated</b></font> <font size="5" style="font-size: 18pt">' your</font> <font size="5" style="font-size: 18pt"><b>Source    Custom Columns</b></font>.</font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>5</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">Click    the</font> <font size="5" style="font-size: 18pt"><b>Source Custom    Columns Tab</b></font>.</font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"><i>Read    the 'ToolTips' for more information.</i></font></font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>6</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">Click    the button named '</font> <font size="5" style="font-size: 18pt"><b>Get    All Source Library/Custom Column Combinations'.</b></font> <font size="5" style="font-size: 18pt">   Wait while it retrieves and then lists them for your review.</font></font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top">
        <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>7</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">Using    the various other buttons, '</font> <font size="5" style="font-size: 18pt"><b>Activate</b></font> <font size="5" style="font-size: 18pt">' all, some, or no</font> <font size="5" style="font-size: 18pt"><b>Source Custom Columns</b></font>. <font size="5" style="font-size: 18pt">   '</font> <font size="5" style="font-size: 18pt"><b>Activate</b></font> <font size="5" style="font-size: 18pt">' means '</font> <font size="5" style="font-size: 18pt"><b>Mark    for Generation</b></font> <font size="5" style="font-size: 18pt">'.    '</font> <font size="5" style="font-size: 18pt"><b>Generation</b></font> <font size="5" style="font-size: 18pt">' means '</font> <font size="5" style="font-size: 18pt"><b>Add    this Custom Column to the Target Library so it can receive Source    Custom Column metadata via the Consolidation Job</b></font> <font size="5" style="font-size: 18pt">'.</font></font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"><i>Read    the 'ToolTips' for more information.</i></font></font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>8</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">Once    you are satisfied with your</font> <font size="5" style="font-size: 18pt"><b>Activated    Source Custom Columns</b></font>, <font size="5" style="font-size: 18pt">   click the</font> <font size="5" style="font-size: 18pt"><b>Target    Library Tab</b></font>.</font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>9</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">Click    the button named '</font> <font size="5" style="font-size: 18pt"><b>Generate    Custom Columns in the Special CALM Library'</b></font>.</font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">Wait    while it uses a standard Calibre API to '</font> <font size="5" style="font-size: 18pt"><b>Generate</b></font> <font size="5" style="font-size: 18pt">' (add) all of the    appropriate</font> <font size="5" style="font-size: 18pt"><b>Custom    Columns</b></font> <font size="5" style="font-size: 18pt">to the</font> <font size="5" style="font-size: 18pt"><b>Target Library</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">metadata.db    file.</span></font></font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"><i><b>CALM</b></i></font> <font size="5" style="font-size: 18pt"><i> <span style="font-weight: normal">will    automatically restart.</span></i></font></font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>10</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">Click    the</font> <font size="5" style="font-size: 18pt"><b>Source Custom    Columns Tab</b></font>.</font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>11</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">Click    the button named '
        </font> <font size="5" style="font-size: 18pt"><b>List    Generated Source-to-Target CC Mappings</b></font> <font size="5" style="font-size: 18pt">'.</font></font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"><i>Read    the list's 'ToolTips' for more information.</i></font></font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>12</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"><b>Click    the</b></font> <font size="5" style="font-size: 18pt"><b>Target    Library</b></font> <font size="5" style="font-size: 18pt"><b>Tab.</b></font></font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>13</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">Execute    the</font> <font size="5" style="font-size: 18pt"><b>CALM</b></font> <font size="5" style="font-size: 18pt"><b>Consolidation Job</b></font> <font size="5" style="font-size: 18pt">by clicking the button at    the very bottom named '</font> <font size="5" style="font-size: 18pt"><b>Execute    [Saved &amp; Selected Libraries]</b></font> <font size="5" style="font-size: 18pt">'.</font></font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>14</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">Monitor    the</span></font> <font size="5" style="font-size: 18pt"><b>Consolidation    Job Log</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">until    the</span></font> <font size="5" style="font-size: 18pt"><b>Consolidation    Job</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">finishes.</span></font></font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>15</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">Using    the</font> <font size="5" style="font-size: 18pt">Calibre</font> <font size="5" style="font-size: 18pt">menu option</font> <font size="5" style="font-size: 18pt"><i>[Current    Library Icon] &gt; Quick Switch</i></font>, <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>switch</b></u></font></font> <font size="5" style="font-size: 18pt">to the</font> <font size="5" style="font-size: 18pt"><b>Target    Library</b></font>.</font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">Example:</span></font> <span style="font-variant: normal"> <font color="#3333ff"> <font size="5" style="font-size: 18pt"> <span style="font-style: normal"><u><b>X:/CALM</b></u></span></font></font></span></font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">The    very first time you use</span></font> <font size="5" style="font-size: 18pt"><b>CALM</b></font>, <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">   or if you subsequently change its location, you will have to tell    Calibre where the</span></font> <font size="5" style="font-size: 18pt"><b>Target    CALM Library</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">is    so it will remember it for future use.</span></font></font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">Use    the menu option</span></font>
        <font size="5" style="font-size: 18pt"><i> <span style="font-weight: normal">[Current    Library Icon] &gt; Switch/create Library &gt; Use the previously    existing library at the new location.</span></i></font></font></p><p> <span style="font-variant: normal"> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"> <span style="font-style: normal"> <span style="font-weight: normal">Browse    to the</span></span></font></font></span> <font face="Times New Roman, serif"></font> <span style="font-variant: normal"> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"> <span style="font-style: normal"><b>Target    CALM Library</b></span></font></font></span> <font face="Times New Roman, serif"></font> <span style="font-variant: normal"> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"> <span style="font-style: normal"> <span style="font-weight: normal">and    select that folder (e.g.</span></span></font></font></span> <font face="Times New Roman, serif"></font> <a href="/X:/CALM"> <span style="font-variant: normal"> <font color="#3333ff"> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"> <span style="font-style: normal"><b>X:/CALM</b></span></font></font></font></span></a> <font face="Times New Roman, serif"></font> <span style="font-variant: normal"> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"> <span style="font-style: normal"> <span style="font-weight: normal">).</span></span></font></font></span></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>16</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">View    the fresh</font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>snapshot</b></u></font></font> <font size="5" style="font-size: 18pt">of the Calibre metadata    consolidated from the selected</font> <font size="5" style="font-size: 18pt"><b>Source    Libraries</b></font>.</font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>17</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">If    you do not already have it,</font> <font size="5" style="font-size: 18pt">please</font> <font size="5" style="font-size: 18pt">install the superb plug-in    'View Manager'.</font> <font size="5" style="font-size: 18pt"><u>You    will need it</u></font>.</font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">The    official</font> <font size="5" style="font-size: 18pt"><b>Target    CALM Library</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">that    you freshly extracted and then updated</span></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">comes</span></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">'standard'</span></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">with    a profile for 'View Manager'</span></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">named</span></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">'CALM'.</span></font></font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">You    will</span></font> <font size="5" style="font-size: 18pt"><u> <span style="font-weight: normal">want    and need</span></u></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">to    customize this “View Manager” profile for your personal use.</span></font></font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>18</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font color="#800000">
        <font size="5" style="font-size: 18pt"><u><b>IMPORTANT</b></u></font></font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>CONSIDERATION    [A]</b></u></font></font> <font size="5" style="font-size: 18pt"><b>: <br/> <br/></b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">The</span></font> <font size="5" style="font-size: 18pt"><b>CALM</b></font>. <font size="5" style="font-size: 18pt"><b>json</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">file    that goes along with the</span></font> <font size="5" style="font-size: 18pt"><b>CALM</b></font> <font size="5" style="font-size: 18pt"><b>metadata.db</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">file    will be</span></font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>freshly</b></u></font></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">extracted</span></font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>only    the very first time</b></u></font></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">that    the</span></font> <font size="5" style="font-size: 18pt"><b>metadata.db</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">file    is extracted to a</span></font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>new</b></u></font></font> <font size="5" style="font-size: 18pt"><b>Target CALM Library</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">path. <br/> <br/>Any    library-specific Calibre preferences and options that you make    subsequently to the</span></font> <font size="5" style="font-size: 18pt"><b>Target    CALM Library,</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">and    are stored in that particular</span></font>. <font size="5" style="font-size: 18pt"><b>json</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">file,</span></font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>will    survive</b></u></font></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">future    “</span></font> <font size="5" style="font-size: 18pt"><b>Extract    a Fresh Copy</b></font> ” <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">events.</span></font></font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">If    you later specify a</span></font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>new</b></u></font></font> <font size="5" style="font-size: 18pt"><b>Target CALM Library</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">path,    and if that path was</span></font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>not</b></u></font></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">previously    created by</span></font> <font size="5" style="font-size: 18pt"><b>CALM</b></font>, <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">   then a</span></font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>new</b></u></font></font>. <font size="5" style="font-size: 18pt"><b>json</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">file    will be freshly extracted.</span></font></font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>19</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>RECOMMENDATION</b></u></font></font> <font size="5" style="font-size: 18pt"><b>:</b></font></font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">Carefully    consider where you will want the</span></font> <font size="5" style="font-size: 18pt"><b>Target    CALM Library</b></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">to    reside long-term so you will</span></font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>not</b></u></font></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">have    to move it later and</span></font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>lose</b></u></font></font> <font size="5" style="font-size: 18pt">
        <span style="font-weight: normal">any    library-specific customizations</span></font> <font size="5" style="font-size: 18pt"> <span style="font-weight: normal">that    you have made.</span></font></font></p><p> <br/></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr><tr valign="top"> <td width="5%" style="border: none; padding: 0in"><p align="center"> <font face="Times New Roman, serif"> <font size="3" style="font-size: 12pt"><b>[</b></font> <font size="3" style="font-size: 12pt"><b>20</b></font> <font size="3" style="font-size: 12pt"><b>]</b></font></font></p>  </td> <td width="82%" style="border: none; padding: 0in"><p> <font face="Times New Roman, serif"> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>IMPORTANT    CONSIDERATION [B]</b></u></font></font> <font size="5" style="font-size: 18pt"><b>:</b></font></font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">The    special</font> <font size="5" style="font-size: 18pt"><b>CALM    metadata_tools.db</b></font> <font size="5" style="font-size: 18pt">file    is handled</font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>identically</b></u></font></font> <font size="5" style="font-size: 18pt">as the.</font> <font size="5" style="font-size: 18pt"><b>json</b></font> <font size="5" style="font-size: 18pt">file described just above.    That tools database file is described in more detail in the</font> <font size="5" style="font-size: 18pt"><b>FAQ</b></font> <font size="5" style="font-size: 18pt">tab.</font></font></p><p> <font face="Times New Roman, serif"> <font size="5" style="font-size: 18pt">The    important consideration for now is that</font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>you    will lose all of your manual table maintenance</b></u></font></font> <font size="5" style="font-size: 18pt">in the</font> <font size="5" style="font-size: 18pt"><b>metadata_tools.db</b></font> <font size="5" style="font-size: 18pt">file</font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>unless</b></u></font></font> <font size="5" style="font-size: 18pt">you heed the</font> <font color="#800000"> <font size="5" style="font-size: 18pt"><u><b>RECOMMENDATION</b></u></font></font> <font size="5" style="font-size: 18pt">that was stated just above.</font></font></p>  </td> <td width="12%" style="border: none; padding: 0in"><p> <br/></p>  </td></tr></table><p style="margin-bottom: 0in"> <br/></p></body></html>
        '''
        return self.instructions_html
    #--------------------------------------------------------------------------------------------------
    def maintain_generating_noncalm_library_namespaced_prefs(self,prefs_dict_to_save):
        #~ DB_PREFS_NAMESPACE = 'CALMPlugin'
        #~ DB_PREFS_KEY_SETTINGS = 'CALMTargetDBSettings'
        #~ DB_PREFS_FULL_KEY = "namespaced:CALMPlugin:CALMTargetDBSettings"
        db = self.guidb
        db.prefs.set_namespaced(DB_PREFS_NAMESPACE, DB_PREFS_KEY_SETTINGS, prefs_dict_to_save)             #update non-calm generating metadata.db table=preferences...
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class CALMCustomColumnsTab(QWidget):
    def __init__(self,mygui,myguidb,mytargetdb,myparentprefs,
                            mycreate_new_sqlite_objects_in_tools_db,child_invocation_of_save_real_prefs_parent,
                            child_invocation_to_retrieve_most_current_parent_prefs):
        super(CALMCustomColumnsTab, self).__init__()

        #-----------------------------------------------------
        self.gui = mygui
        self.guidb = myguidb
        self.target_db = mytargetdb
        self.myparentprefs = myparentprefs
        self.create_new_sqlite_objects_in_tools_db = mycreate_new_sqlite_objects_in_tools_db
        self.child_invocation_of_save_real_prefs_parent = child_invocation_of_save_real_prefs_parent
        self.child_invocation_to_retrieve_most_current_parent_prefs = child_invocation_to_retrieve_most_current_parent_prefs
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.init_tooltips_for_custom_columns_tab()
        #-----------------------------------------------------
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(10)

        #-----------------------------------------------------
        self.layout_top = QVBoxLayout()
        self.layout_top.setSpacing(0)
        self.layout_top.setAlignment(Qt.AlignCenter)
        self.setLayout(self.layout_top)
        #-----------------------------------------------------
        self.scroll_area_frame = QScrollArea()
        self.scroll_area_frame.setAlignment(Qt.AlignCenter)
        self.scroll_area_frame.setWidgetResizable(True)
        self.scroll_area_frame.ensureVisible(800,800)

        self.layout_top.addWidget(self.scroll_area_frame)       # the scroll area is now the child of the parent of self.layout_top

        # NOTE: the self.scroll_area_frame.setWidget(self.scroll_widget) is at the end of the init() AFTER all children have been created and assigned to a layout...

        #-----------------------------------------------------
        self.scroll_widget = QWidget()
        self.layout_top.addWidget(self.scroll_widget)           # causes automatic reparenting of QWidget to the parent of self.layout_top, which is:  self .
        #-----------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setAlignment(Qt.AlignCenter)

        self.scroll_widget.setLayout(self.layout_frame)        # causes automatic reparenting of any widget later added to self.layout_frame to the parent of self.layout_frame, which is:  QWidget .

        #-----------------------------------------------------
        self.custom_columns_groupbox = QGroupBox("Currently Available Actions:")
        self.custom_columns_groupbox.setToolTip("<p style='white-space:wrap'>The shown pushbuttons will vary based on the current Generation Status of the current Target Library.  The less that has been accomplished so far, the more pushbuttons will be shown.")
        self.custom_columns_groupbox.setMinimumWidth(500)
        #~ self.custom_columns_groupbox.setMaximumWidth(800)
        self.custom_columns_groupbox.setMinimumHeight(0)
        self.custom_columns_groupbox.setFont(font)
        self.layout_frame.addWidget(self.custom_columns_groupbox)

        self.custom_columns_layout = QVBoxLayout()
        self.custom_columns_layout.setAlignment(Qt.AlignCenter)
        self.custom_columns_groupbox.setLayout(self.custom_columns_layout)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setPointSize(10)
        font.setBold(True)

        self.tools_db_path = "/CALM/metadata_tools.db"

        self.special_calm_tools_db_full_path_label = QLabel()
        self.special_calm_tools_db_full_path_label.setTextFormat(Qt.PlainText)
        self.special_calm_tools_db_full_path_label.setText(self.tools_db_path)
        self.special_calm_tools_db_full_path_label.setFont(font)
        self.special_calm_tools_db_full_path_label.setAlignment(Qt.AlignCenter)
        self.special_calm_tools_db_full_path_label.setToolTip("<p style='white-space:wrap'>The path to the metadata_tools.db file that is used to control the generation of Source Custom Columns.  It will always reside alongside of the Target Library, to which it is a companion.")
        self.special_calm_tools_db_full_path_label.setMinimumWidth(500)
        #~ self.special_calm_tools_db_full_path_label.setMaximumWidth(600)

        self.custom_columns_layout.addWidget(self.special_calm_tools_db_full_path_label)

        font.setPointSize(10)
        font.setBold(False)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.custom_columns_buttonbox = QDialogButtonBox()
        self.custom_columns_buttonbox.setOrientation(Qt.Vertical)
        self.custom_columns_buttonbox.setCenterButtons(True)

        self.custom_columns_layout.addWidget(self.custom_columns_buttonbox)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        testing_mode = False       # This button is for the Developer's Use Only
        if testing_mode:
            self.push_button_list_saved_json_prefs_listing = QPushButton(" ", self)
            self.push_button_list_saved_json_prefs_listing.setText("Audit Current Preferences Dicts")
            self.push_button_list_saved_json_prefs_listing.setMinimumWidth(500)
            #~ self.push_button_list_saved_json_prefs_listing.setMaximumWidth(600)
            self.push_button_list_saved_json_prefs_listing.setFont(font)
            self.push_button_list_saved_json_prefs_listing.clicked.connect(self.list_audit_of_current_preferences)
            self.push_button_list_saved_json_prefs_listing.setDefault(True)
            self.push_button_list_saved_json_prefs_listing.setToolTip("<p style='white-space:wrap'>This is for the Developer's Use Only.  You should not be reading this.")
            self.custom_columns_buttonbox.addButton(self.push_button_list_saved_json_prefs_listing,QDialogButtonBox.AcceptRole)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_list_source_cc_activation_listing = QPushButton(" ", self)
        self.push_button_list_source_cc_activation_listing.setText("List Current Source Library/Custom Column Activation Statuses")
        self.push_button_list_source_cc_activation_listing.setMinimumWidth(500)
        #~ self.push_button_list_source_cc_activation_listing.setMaximumWidth(600)
        self.push_button_list_source_cc_activation_listing.setFont(font)
        self.push_button_list_source_cc_activation_listing.clicked.connect(self.list_current_table_combinations)
        self.push_button_list_source_cc_activation_listing.setDefault(True)
        self.push_button_list_source_cc_activation_listing.setToolTip("<p style='white-space:wrap'>List Current Source Library/Custom Column Combinations used in Generation.")
        self.custom_columns_buttonbox.addButton(self.push_button_list_source_cc_activation_listing,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------

        self.push_button_list_source_target_mappings_listing = QPushButton(" ", self)
        self.push_button_list_source_target_mappings_listing.setText("List Generated Source-to-Target CC Mappings")
        self.push_button_list_source_target_mappings_listing.setMinimumWidth(500)
        #~ self.push_button_list_source_target_mappings_listing.setMaximumWidth(600)
        self.push_button_list_source_target_mappings_listing.setFont(font)
        self.push_button_list_source_target_mappings_listing.clicked.connect(self.list_source_to_target_cc_mappings)
        self.push_button_list_source_target_mappings_listing.setDefault(True)
        self.push_button_list_source_target_mappings_listing.setToolTip("<p style='white-space:wrap'>List Current Source Library Custom Column mappings to the current Target Library Custom Columns.<br><br>You cannot change this directly.  Instead, you must standardize your Source Library Custom Column configuration directly for each Source Library using 'Calibre > Preferences >add your own columns', and then regenerate.")
        self.custom_columns_buttonbox.addButton(self.push_button_list_source_target_mappings_listing,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setPointSize(10)
        font.setBold(True)
        self.push_button_autopopulate_sourcelibrary_cc_control_table = QPushButton(" ", self)
        self.push_button_autopopulate_sourcelibrary_cc_control_table.setText("Get All Source Library/Custom Column Combinations")
        self.push_button_autopopulate_sourcelibrary_cc_control_table.setMinimumWidth(500)
        #~ self.push_button_autopopulate_sourcelibrary_cc_control_table.setMaximumWidth(600)
        self.push_button_autopopulate_sourcelibrary_cc_control_table.clicked.connect(self.autopopulate_source_library_custom_columns_table)
        self.push_button_autopopulate_sourcelibrary_cc_control_table.setDefault(False)
        self.push_button_autopopulate_sourcelibrary_cc_control_table.setFont(font)
        tip = "<p style='white-space:wrap'>Using all currently saved Source Libraries, populate the metadata_tools.db with <br>\
                    the current 'Source Library Custom Columns' so you can select which combinations to Generate by 'activating' them.\
                    <br><br>If you get an error message stating that no Source Libraries were found, ensure you configured the Source Libraries Tab and Saved. \
                    <br><br>If you have already configured and saved the Source Libraries, and you still get an error message stating that no \
                    Source Libraries were found, and if you use Windows, ensure that this file exists:  'C:\\Users\\...\\AppData\\Roaming\\calibre\\plugins\\Consolidate All Library Metadata.json' \
                    <br><br>If you have already configured and saved the Source Libraries, and you still get an error message stating that no \
                    Source Libraries were found, and if you use Calibre Portable, ensure that this file exists where it belongs: Consolidate All Library Metadata.json   "

        self.push_button_autopopulate_sourcelibrary_cc_control_table.setToolTip(tip)
        self.custom_columns_buttonbox.addButton(self.push_button_autopopulate_sourcelibrary_cc_control_table,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setPointSize(10)
        font.setBold(False)
        self.push_button_mass_activate_all_combinations = QPushButton(" ", self)
        self.push_button_mass_activate_all_combinations.setText("Mass Activate All Source Library/Custom Column Combinations")
        self.push_button_mass_activate_all_combinations.setMinimumWidth(500)
        #~ self.push_button_mass_activate_all_combinations.setMaximumWidth(600)
        self.push_button_mass_activate_all_combinations.setFont(font)
        self.push_button_mass_activate_all_combinations.clicked.connect(self.mass_activate_cc_control_table)
        self.push_button_mass_activate_all_combinations.setDefault(False)
        self.push_button_mass_activate_all_combinations.setToolTip("<p style='white-space:wrap'>Activate all Source Library/Custom Column Combinations at once.  ")
        self.custom_columns_buttonbox.addButton(self.push_button_mass_activate_all_combinations,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_mass_deactivate_all_combinations = QPushButton(" ", self)
        self.push_button_mass_deactivate_all_combinations.setText("Mass Deactivate All Source Library/Custom Column Combinations")
        self.push_button_mass_deactivate_all_combinations.setMinimumWidth(500)
        #~ self.push_button_mass_deactivate_all_combinations.setMaximumWidth(600)
        self.push_button_mass_deactivate_all_combinations.setFont(font)
        self.push_button_mass_deactivate_all_combinations.clicked.connect(self.mass_deactivate_cc_control_table)
        self.push_button_mass_deactivate_all_combinations.setDefault(False)
        self.push_button_mass_deactivate_all_combinations.setToolTip("<p style='white-space:wrap'>Deactivate all Source Library/Custom Column Combinations at once.  If deactivated, those combinations will not be Generated, and hence will not be Consolidated into the Target Library.")
        self.custom_columns_buttonbox.addButton(self.push_button_mass_deactivate_all_combinations,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_mass_deactivate_only_composite_columns = QPushButton(" ", self)
        self.push_button_mass_deactivate_only_composite_columns.setText("Mass Deactivate All Composite Custom Columns (Only)")
        self.push_button_mass_deactivate_only_composite_columns.setMinimumWidth(500)
        #~ self.push_button_mass_deactivate_only_composite_columns.setMaximumWidth(600)
        self.push_button_mass_deactivate_only_composite_columns.setFont(font)
        self.push_button_mass_deactivate_only_composite_columns.clicked.connect(self.mass_deactivate_cc_control_table_composite_only)
        self.push_button_mass_deactivate_only_composite_columns.setDefault(False)
        self.push_button_mass_deactivate_only_composite_columns.setToolTip("<p style='white-space:wrap'>Deactivate Only Composite Custom Columns.  If deactivated, those Composite Custom Columns will not be Generated, and hence will not be Consolidated into the Target Library.")
        self.custom_columns_buttonbox.addButton(self.push_button_mass_deactivate_only_composite_columns,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        #-----------------------------------------------------

        font.setBold(True)

        self.push_button_selectively_activate_combinations = QPushButton(" ", self)
        self.push_button_selectively_activate_combinations.setText("Selectively Activate Source Library/Custom Column Combinations")
        self.push_button_selectively_activate_combinations.setMinimumWidth(500)
        #~ self.push_button_selectively_activate_combinations.setMaximumWidth(600)
        self.push_button_selectively_activate_combinations.setFont(font)
        self.push_button_selectively_activate_combinations.clicked.connect(self.ccactivation_editor_dialog  )
        self.push_button_selectively_activate_combinations.setDefault(False)
        self.push_button_selectively_activate_combinations.setToolTip("<p style='white-space:wrap'>Activate or Deactivate selective Source Library/Custom Column Combinations.  If deactivated, those combinations will not be Generated, and hence will not be Consolidated into the Target Library.")
        self.custom_columns_buttonbox.addButton(self.push_button_selectively_activate_combinations,QDialogButtonBox.AcceptRole)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setPointSize(8)
        font.setBold(False)

        self.table_listing_groupbox = QGroupBox("Lists:")
        msg = "<p style='white-space:wrap'>Source Custom Column Listings and Related Information.\
                                                                                                                    <br><br>Only 'Activated' Source Custom Columns will be Generated. \
                                                                                                                    <br><br>Only 'Generated' Source Custom Columns will be Consolidated. \
                                                                                                                    <br><br><br><br>Important Note:  There are 2 'suffixes' that you may see in this listing:\
                                                                                                                    <br><br> [1]  A suffix of '_source' is used to guarantee full separation of CALM-specific Custom Columns and your Source Library Custom Columns, such as between #genre in CALM and #genre in a Source Library.  Different Calibre users have different definitions of 'Genre', some of which are incompatible with the definition of CALM's 'Genre' used in the Metadata Tool 'Derive Genres'. \
                                                                                                                    <br><br> [2]  A suffix of '_NN' (where NN is a 2-digit Integer) is used to avoid Calibre errors related to Custom Columns.  Calibre allows only \
                                                                                                                    one (1) Search/Lookup Name (#name), such as #pages, to exist at one time, \
                                                                                                                    even if everything else about the second #name is different from the first #name that has the identical #name as the second label. \
                                                                                                                    <br><br>If you see a '_NN' suffix in a Generated Custom Column, it is because you have not (yet) fully standardized your Source Library Custom Columns.\
                                                                                                                    <br><br> Example:<br>\
                                                                                                                    <br>Your Source Library 'English' uses '#pages' with a column heading of 'Pages'.  \
                                                                                                                    <br>Your Source Library 'Spanish' uses '#pages with a column heading of 'Páginas' \
                                                                                                                    <br><br> Because your Calibre>Preferences>add your own column' configuration is not <b>IDENTICAL IN ALL RESPECTS</b>,\
                                                                                                                    the 2 '#pages' will <b>NOT</b> be mapped to a single Target Library Custom Column of '#pages'.\
                                                                                                                    <br><br> If you want them to be mapped together, then you must change them to be <b>IDENTICAL IN ALL RESPECTS</b>. \
                                                                                                                    <br><br> If you want them to be mapped separately, but <b>NOT</b> with the '_NN' suffix, \
                                                                                                                    simply change one of the #pages to something else, such as '#paginas' (although it should be spelled '#páginas', Calibre does not allow diacritics in #names).\
                                                                                                                    <br><br> Standardization is highly recommended, because plugins that use Custom Column #names, such as 'View Manager', will constantly have to be 'customized' after every Generation because the '_NN' suffixes are arbitrary sequential numbers.  The Generation process actually assigns an initial '_NN' suffix to each and every Target Library Custom Column, but then removes it whenever it is possible to do so (i.e., it would not cause a fatal Calibre error to remove it).  "
        self.table_listing_groupbox.setToolTip(msg)

        self.table_listing_groupbox.setMinimumWidth(400)
        #~ self.table_listing_groupbox.setMaximumWidth(800)
        self.table_listing_groupbox.setMinimumHeight(600)
        self.table_listing_groupbox.setFont(font)
        self.layout_frame.addWidget(self.table_listing_groupbox)

        self.table_listing_layout = QVBoxLayout()
        self.table_listing_layout.setSpacing(0)
        self.table_listing_layout.setAlignment(Qt.AlignCenter)
        self.table_listing_groupbox.setLayout(self.table_listing_layout)

        #-----------------------------------------------------
        #-----------------------------------------------------

        self.table_listing_qtextedit =  QTextEdit("")
        self.table_listing_qtextedit.setReadOnly(True)

        myFixedFont = QFont(QFontDatabase.systemFont(QFontDatabase.SystemFont.FixedFont))
        myFixedFont.setPointSize(8)
        myFixedFont.setBold(False)

        self.table_listing_qtextedit.setFont(myFixedFont)

        self.table_listing_qtextedit.setWordWrapMode(QTextOption.WrapMode.WordWrap)
        self.table_listing_qtextedit.clear()

        self.table_listing_html = self.initialize_table_listing_html()

        self.table_listing_qtextedit.setHtml(self.table_listing_html)

        self.table_listing_layout.addWidget(self.table_listing_qtextedit)

        self.table_listing_qtextedit.setToolTip(msg)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_widget.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.setWidget(self.scroll_widget)    # now that all widgets have been created and assigned to a layout...
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def list_current_table_combinations(self):

        self.update()
        QApplication.instance().processEvents()

        my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab()
        if not is_valid:
            self.table_listing_qtextedit.clear()
            self.table_listing_qtextedit.setHtml("ERROR: not is_valid returned from:  my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab()")
            self.update()
            QApplication.instance().processEvents()
            if DEBUG: print("def list_current_table_combinations(self): -------- ERROR: not is_valid returned from:  my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab()")
            return

        self.table_listing_qtextedit.clear()

        self.table_listing_qtextedit.setHtml("...working...")
        self.update()
        QApplication.instance().processEvents()

        self.myparentprefs = self.child_invocation_to_retrieve_most_current_parent_prefs()

        all_source_library_paths_set = set()

        #~ for k,v in self.myparentprefs.iteritems():          # get all configured source libraries
        for k,v in iteritems(self.myparentprefs):          # get all configured source libraries
            k = unicode_type(k)
            v = unicode_type(v)
            if k.count("LIBRARY_PATH_") > 0 :
                if k.count("IS_ACTIVE") == 0 :
                    if v == unicode_type("None"):
                        continue
                    v = v.strip()
                    if v.count("/") > 0 or v.count("\\") > 0:
                        all_source_library_paths_set.add(v)
                        if DEBUG: print("source library path added to set: ", v)
        #END FOR

        my_cursor.execute("begin")
        for source in all_source_library_paths_set:
            if DEBUG: print("adding source to table _source_libraries: ", source)
            mysql = "INSERT OR REPLACE INTO _source_libraries SELECT ?,? "
            my_cursor.execute(mysql,(None,source))
        #END FOR
        my_cursor.execute("commit")
        sleep(0)

        number_source_libraries_0 = unicode_type(len(all_source_library_paths_set))
        del all_source_library_paths_set

        if DEBUG: print("number_source_libraries_0: ",number_source_libraries_0)

        mysql = "SELECT count(DISTINCT source_library) AS number_source_libraries FROM _source_library_custom_columns WHERE activate_for_calm = 1 "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            number_source_libraries = 0
        else:
            if len(tmp_rows) == 0:
                number_source_libraries = 0
            else:
                for row in tmp_rows:
                    for col in row:
                        number_source_libraries = unicode_type(col)
                        if DEBUG: print("number_source_libraries = unicode_type(col): ", number_source_libraries)
                        break
                    #END FOR
                    break
                #END FOR
                del tmp_rows

        number_source_libraries_1 = number_source_libraries

        mysql = "SELECT count(DISTINCT source_library) AS number_source_libraries FROM __source_custom_columns_not_generated_but_activated "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            number_source_libraries = 0
        else:
            if len(tmp_rows) == 0:
                number_source_libraries = 0
            else:
                for row in tmp_rows:
                    for col in row:
                        number_source_libraries = unicode_type(col)
                        if DEBUG: print("number_source_libraries = unicode_type(col): ", number_source_libraries)
                        break
                    #END FOR
                    break
                #END FOR
                del tmp_rows

        number_source_libraries_2 = number_source_libraries

        listing = "Source Library Custom Column 'Activation for Generation and Consolidation' Status:<br><br>"
        listing = listing + "[*] Number of Source Libraries Last Saved (checked or not): " + number_source_libraries_0 + "<br>"
        listing = listing + "[*] Number of Source Libraries with at least one Active Custom Column: " + number_source_libraries_1 + "<br>"
        listing = listing + "[*] Number of Source Libraries with no Generated, yet Active, Custom Columns: " + number_source_libraries_2 + "<br><br>"

        if number_source_libraries_0 != number_source_libraries_1:
            delta = int(number_source_libraries_0) - int(number_source_libraries_1)
            if delta < 0:
                listing = "Please review and confirm your Source Libraries before continuing."
                self.table_listing_html = listing
                del listing
                self.table_listing_qtextedit.setHtml(self.table_listing_html)
                self.update()
                QApplication.instance().processEvents()
                return
            else:
                listing = listing + "[*] Number of Source Libraries with no Custom Columns whatsoever: " + unicode_type(delta) + "<br><br>"


        if number_source_libraries_2 > unicode_type(0):
            listing = listing + "You may Generate from the Target Library Tab as soon as you are satisfied with the listing below, \
            which includes there being no Source Custom Columns still requiring standardization. \
            <br><br> Lack of standardization of Source Library Custom Columns will result in arbitrary sequential numbers being appended to the '#Search Name' and the 'Column Heading Name',\
            which will cause your View Manager settings to endlessly need tweaking since your list of custom columns is forever changing.  The same will be true with 'Calibre > Preferences > Add your own columns'.<br><br>"

        del number_source_libraries
        del number_source_libraries_0
        del number_source_libraries_1
        del number_source_libraries_2

        mysql = "SELECT * FROM _source_library_custom_columns ORDER BY source_library_cc_label,source_library_cc_name,source_library"
        my_cursor.execute(mysql)
        tmp_list = my_cursor.fetchall()
        my_db.close()
        if not tmp_list:
            pass
        else:
            if len(tmp_list) == 0:
                pass
            else:
                for row in tmp_list:
                    s_filler = "----------------------------------------------------------------------------------------------------------------"
                    source_library,source_library_cc_id,source_library_cc_label,source_library_cc_name,source_library_cc_datatype,\
                    source_library_cc_mark_for_delete,source_library_cc_editable,source_library_cc_display,\
                    source_library_cc_is_multiple,source_library_cc_normalized,activate_for_calm = row
                    if as_unicode(activate_for_calm) == as_unicode("0"):
                        active = "<b>Not</b> Activated"
                    else:
                        active = "<b>Activated</b>"
                    n  = len(source_library)
                    if n < 42:
                        n1 = 42 - n
                    else:
                        n1 = 1
                    s_filler = s_filler[0:n1]
                    listing = listing + source_library + " " + s_filler + " " + "#" + source_library_cc_label + "  -  " + source_library_cc_name + "  -  " + source_library_cc_datatype +  "  -  " + active + "<br>"
                #END FOR
                del tmp_list

        self.table_listing_html = listing
        del listing
        self.table_listing_qtextedit.setHtml(self.table_listing_html)
        self.update()
        QApplication.instance().processEvents()
    #--------------------------------------------------------------------------------------------------
    def list_source_to_target_cc_mappings(self):

        self.update()
        QApplication.instance().processEvents()

        my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab()
        if not is_valid:
            self.table_listing_qtextedit.clear()
            self.table_listing_qtextedit.setHtml("ERROR: not is_valid returned from:  my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab()")
            self.update()
            QApplication.instance().processEvents()
            if DEBUG: print("def list_source_to_target_cc_mappings(self): -------- ERROR: not is_valid returned from:  my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab()")
            return

        self.table_listing_qtextedit.clear()

        self.table_listing_qtextedit.setHtml("...working...")
        self.update()
        QApplication.instance().processEvents()

        mysql = "SELECT count(DISTINCT source_library) AS number_source_libraries FROM _source_cc_to_target_cc_mapping "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            number_source_libraries = 0
        else:
            if len(tmp_rows) == 0:
                number_source_libraries = 0
            else:
                for row in tmp_rows:
                    for col in row:
                        number_source_libraries = unicode_type(col)
                        if DEBUG: print("number_source_libraries [that were generated] = unicode_type(col): ", number_source_libraries)
                        break
                    #END FOR
                    break
                #END FOR

        listing = "Generated Source Library to Target Library Custom Column Mappings:<br><br>"
        listing = listing + "Number of Source Libraries with at least one (1) Generated Custom Column: " + number_source_libraries + "<br><br>"

        del number_source_libraries

        mysql = "SELECT source_library,source_library_cc_label,target_cc_label FROM _source_cc_to_target_cc_mapping ORDER BY source_library,source_library_cc_label"
        my_cursor.execute(mysql)
        tmp_list = my_cursor.fetchall()
        my_db.close()
        if not tmp_list:
            self.table_listing_qtextedit.setHtml("None")
        else:
            if len(tmp_list) == 0:
                self.table_listing_qtextedit.setHtml("None")
            else:
                for row in tmp_list:
                    source_library,source_library_cc_label,target_cc_label = row
                    source_library_cc_label = source_library_cc_label + "    ------>>    "
                    listing = listing + source_library + "    ---     #" + source_library_cc_label + "#" + target_cc_label + "<br>"
                #END FOR
                del tmp_list
                #~ if DEBUG: print(listing)
                self.table_listing_html = listing
                del listing
                self.table_listing_qtextedit.setHtml(self.table_listing_html)

        self.update()
        QApplication.instance().processEvents()
    #--------------------------------------------------------------------------------------------------
    def list_audit_of_current_preferences(self):

        self.update()
        QApplication.instance().processEvents()

        self.child_invocation_of_save_real_prefs_parent("ALL")
        self.myparentprefs = self.child_invocation_to_retrieve_most_current_parent_prefs()

        listing = "prefs not equal to myparentprefs: <br><br>"
        #~ for k,v in prefs.iteritems():
        for k,v in iteritems(prefs):
            if k in self.myparentprefs:
                if v == self.myparentprefs[k]:
                    continue
                else:
                    listing = listing + "prefs[k]: " + k + ">>>" + v + "  NOT equal to myparentprefs[k]:  " + self.myparentprefs[k] + "<br>"
            else:
                listing = listing + "prefs[k]: " + k + ">>>" + v + "  MISSING from myparentprefs[k]: " + self.myparentprefs[k] + "<br>"
        #END FOR
        listing = listing + "<br><br>All of 'self.myparentprefs': <br><br>"
        #~ for k,v in self.myparentprefs.iteritems():
        for k,v in iteritems(self.myparentprefs):
            listing = listing + k + " --->> " + v + " <br>"
        #END FOR
        self.table_listing_html = listing
        del listing
        self.table_listing_qtextedit.setHtml(self.table_listing_html)
        self.update()
        QApplication.instance().processEvents()

    #--------------------------------------------------------------------------------------------------
    def autopopulate_source_library_custom_columns_table(self):
        # this populates metadata_tools.db table '_source_library_custom_columns'
        if DEBUG: print("... def autopopulate_source_library_custom_columns_table() ...")

        # IMPORTANT:  The Quarantine&Scrub add-on has a customized custom column named 'work_series_full', which is datatype = text BUT normalized = 0 !  Calibre does not support this combination.
        #                        Q&S 'work_series_full' CANNOT be consolidated into CALM, since it would cause fatal errors during 'generation'.

        self.table_listing_qtextedit.setHtml("...working...retrieving most recently saved Source Libraries, if any, and then searching for their Custom Columns, if any.   Please wait. ")
        self.update()
        QApplication.instance().processEvents()

        self.child_invocation_of_save_real_prefs_parent("ALL")
        self.myparentprefs = self.child_invocation_to_retrieve_most_current_parent_prefs()

        all_source_library_paths_set = set()
        all_case_sensitive_library_paths_dict = {}  # [lowercase = [originalcase]

        for k,v in iteritems(self.myparentprefs):          # get all configured source libraries
            k = unicode_type(k)
            v = unicode_type(v)
            if k.count("LIBRARY_PATH_") > 0 :
                if k.count("IS_ACTIVE") == 0 :
                    if v == unicode_type("None"):
                        if DEBUG: print("[0] skipping a bad path for key: ", k, "   value: ", v)
                        continue
                    if v.count("/") > 0 or v.count("\\") > 0:
                        v = v.strip()
                        vo = v.replace("\\","/")
                        vl = vo.lower()  # for internal matching within the target library; not for apsw connection use...
                        all_source_library_paths_set.add(vl)
                        all_case_sensitive_library_paths_dict[vl] = vo
                        if DEBUG: print("autopopulate:   k, :  ",vo,vl)
        #END FOR

        if len(all_source_library_paths_set) == 0:
            info_dialog(self.gui, _("CALM"), _("There are no specified Source Libraries.  Nothing to do."), show=True)
            self.table_listing_qtextedit.setHtml("")
            self.update()
            QApplication.instance().processEvents()
            return

        self.table_listing_qtextedit.setHtml("...still working...please wait...")
        self.update()
        QApplication.instance().processEvents()

        my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab()
        if not is_valid:
            if DEBUG: print("my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab(): ERROR;  returning...")
            return

        try:  # verify that the metadata_tools.db upgrade is the correct version.
            mysql = "SELECT count(DISTINCT source_library) AS number_source_libraries FROM _source_library_custom_columns WHERE activate_for_calm = 1 "
            my_cursor.execute(mysql)
        except:
            if DEBUG: print("Re-upgrade of metadata_tools.db is being executed.")
            prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("True")
            prefs
            my_db.close()
            my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab()

        # need to delete leftover rows in table _source_library_custom_columns from prior saved-library selections, if any.
        my_cursor.execute("begin")
        mysql = "DELETE FROM _source_libraries"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        my_cursor.execute("begin")
        for source in all_source_library_paths_set:
            mysql = "INSERT OR REPLACE INTO  _source_libraries SELECT ?,? "
            my_cursor.execute(mysql,(None,source))
        #END FOR
        my_cursor.execute("commit")
        my_cursor.execute("begin")
        mysql = "DELETE FROM  _source_library_custom_columns WHERE source_library NOT IN(SELECT source_library FROM _source_libraries)"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        #--------------------------------
        sleep(0)

        #deactivate all records in case user-created existing sources will not be deleted just below...
        my_cursor.execute("begin")
        mysql = "UPDATE _source_library_custom_columns SET activate_for_calm = 0 "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        #ensure the user did not manually do this...
        my_cursor.execute("begin")
        mysql = "UPDATE _source_library_custom_columns SET source_library = trim(lower(source_library)); "
        my_cursor.execute(mysql)
        mysql = "UPDATE _source_library_custom_columns SET source_library = replace(source_library,'/metadata.db','') "
        my_cursor.execute(mysql)
        mysql = "UPDATE _source_library_custom_columns SET source_library = replace(source_library,'metadata.db','') "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        #ensure the user did not manually add source libraries with \ instead of / in their paths...
        try:
            my_cursor.execute("begin")
            mysql = "UPDATE _source_library_custom_columns SET source_library = replace(source_library,'\\','/') "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except:  # likely would cause a duplicate key since the correct form might already exist along with the incorrect form...
            try:
                my_cursor.execute("commit")
            except:
                #just kill it...
                my_cursor.execute("begin")
                mysql = "DELETE FROM _source_library_custom_columns WHERE source_library LIKE '%\\%' "
                my_cursor.execute(mysql)
                my_cursor.execute("commit")

        #delete any existing records for the current known sources (which may or may not account for all sources in the table due to (undesireable) manual user activity...)
        for source in all_source_library_paths_set:
            if source in all_case_sensitive_library_paths_dict:   # [lowercase] = [originalcase]
                original_case = all_case_sensitive_library_paths_dict[source]
                if DEBUG: print("Original Case Library Name used for APSW Path: ", original_case)
            else:
                original_case = source
                if DEBUG: print("Error: Lower Case Library Name used for APSW Path: ", source)
            path = original_case
            library_name = original_case
            library_name = library_name.replace(os.sep, '/')
            library_name = library_name.replace("/metadata.db","")      #standardize in library
            library_name = library_name.lower()   #standardize on lower case for all paths in this table, because it becomes a critical match key in main_consolidate.py...
            library_name = library_name.strip()
            if library_name.endswith("/"):
                library_name = library_name[0:-1]
            if isbytestring(library_name):
                library_name = library_name.decode(filesystem_encoding)

            my_cursor.execute("begin")
            mysql = "DELETE FROM main._source_library_custom_columns WHERE source_library = ? "
            my_cursor.execute(mysql,([library_name]))
            my_cursor.execute("commit")

            was_found = self.apsw_attach_to_source(my_db, my_cursor,path)
            if was_found:
                mysql = "SELECT id,label,name,datatype,mark_for_delete,editable,display,is_multiple,normalized FROM SOURCE.custom_columns"
                my_cursor.execute(mysql)
                tmp_list = my_cursor.fetchall()
                if not tmp_list:
                    self.apsw_detach_from_source(my_db, my_cursor,path)
                    continue
                n = len(tmp_list)
                if DEBUG: print("number of rows found in source.custom_columns: ", as_unicode(n))
                for row in tmp_list:
                    if DEBUG: print("row of SOURCE.custom_columns: ", library_name, "---", as_unicode(row))
                    id,label,name,datatype,mark_for_delete,editable,display,is_multiple,normalized = row
                    try:
                        my_cursor.execute("begin")
                        mysql = "INSERT OR REPLACE INTO main._source_library_custom_columns  VALUES(?,?,?,?,?,?,?,?,?,?,?) "
                        my_cursor.execute(mysql,(library_name,id,label,name,datatype,mark_for_delete,editable,display,is_multiple,normalized,1))
                        my_cursor.execute("commit")
                        #~ if DEBUG: print(mysql)
                    except Exception as e:
                        if DEBUG: print("Exception: ", as_unicode(e))
                        my_db.close()
                        raise(e)
                        return
                #END FOR
                self.apsw_detach_from_source(my_db, my_cursor,path)
            else:
                if DEBUG: print("^^^^^^^ Source Library was NOT found: ", path)
                continue
            sleep(0)
        #END FOR
        del all_source_library_paths_set
        del all_case_sensitive_library_paths_dict

        try:
            my_cursor.execute("begin")
            mysql = "UPDATE _source_library_custom_columns SET source_library = trim(lower(source_library)); "
            my_cursor.execute(mysql)
            mysql = "UPDATE _source_library_custom_columns SET source_library = replace(source_library,'/metadata.db','') "
            my_cursor.execute(mysql)
            mysql = "UPDATE _source_library_custom_columns SET source_library = replace(source_library,'metadata.db','') "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print("Exception: ", as_unicode(e))
            my_db.close()
            raise(e)
            return

        try:
            my_cursor.execute("begin")
            mysql = "UPDATE _source_library_custom_columns SET source_library = replace(source_library,'\\','/') "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except:  # likely would cause a duplicate key since the correct form might already exist along with the incorrect form...
            try:
                my_cursor.execute("commit")
            except:
                #just kill it...
                my_cursor.execute("begin")
                mysql = "DELETE FROM _source_library_custom_columns WHERE source_library LIKE '%\\%' "
                my_cursor.execute(mysql)
                my_cursor.execute("commit")

        #~ # The combination of "Text and Not Normalized" are not supported by calibre, and would cause fatal errors during 'generation'.
        my_cursor.execute("begin")
        mysql = "DELETE FROM _source_library_custom_columns WHERE source_library_cc_datatype = 'text' AND source_library_cc_normalized = 0  "   # this is the combination that native Calibre does not support, but Q&S uses.
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        global disallowed_custom_column_labels_list   #  Q&S 'work_series_full' CANNOT be consolidated into CALM, since it would cause fatal errors during 'generation'.

        my_cursor.execute("begin")
        for label in disallowed_custom_column_labels_list:
            mysql = "DELETE FROM _source_library_custom_columns WHERE source_library_cc_label = ? "
            my_cursor.execute(mysql,([label]))
        #END FOR
        my_cursor.execute("commit")

        my_db.close()

        self.list_current_table_combinations()
    #--------------------------------------------------------------------------------------------------
    def mass_activate_cc_control_table(self):

        my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab()
        if not is_valid:
            if DEBUG: print("my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab(): ERROR;  returning...")
            return
        my_cursor.execute("begin")
        mysql = "UPDATE _source_library_custom_columns SET activate_for_calm = 1 "
        my_cursor.execute(mysql)
        mysql = "UPDATE _source_library_custom_columns SET source_library = replace(source_library,'\\','/') "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        self.list_current_table_combinations()
    #--------------------------------------------------------------------------------------------------
    def mass_deactivate_cc_control_table(self):

        my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab()
        if not is_valid:
            if DEBUG: print("my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab(): ERROR;  returning...")
            return
        my_cursor.execute("begin")
        mysql = "UPDATE _source_library_custom_columns SET activate_for_calm = 0 "
        my_cursor.execute(mysql)
        mysql = "UPDATE _source_library_custom_columns SET source_library = replace(source_library,'\\','/') "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        my_db.close()

        self.list_current_table_combinations()
    #--------------------------------------------------------------------------------------------------
    def mass_deactivate_cc_control_table_composite_only(self):
        my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab()
        if not is_valid:
            if DEBUG: print("my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab(): ERROR;  returning...")
            return
        my_cursor.execute("begin")
        mysql = "UPDATE _source_library_custom_columns SET activate_for_calm = 0 WHERE source_library_cc_datatype = 'composite' "
        my_cursor.execute(mysql)
        mysql = "UPDATE _source_library_custom_columns SET source_library = replace(source_library,'\\','/') "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        my_db.close()

        self.list_current_table_combinations()
    #--------------------------------------------------------------------------------------------------
    def ccactivation_editor_dialog(self, guidb):

        my_db,my_cursor,is_valid = self.apsw_connect_to_tools_db_cc_tab()
        if not is_valid:
            return

        source_cc_list = []

        mysql = "SELECT * FROM _source_library_custom_columns ORDER BY source_library,source_library_cc_id"
        my_cursor.execute(mysql)
        tmp_list = my_cursor.fetchall()

        if not tmp_list:
            my_db.close()
            return
        else:
            if len(tmp_list) == 0:
                my_db.close()
                return
            else:
                for row in tmp_list:
                    source_library,source_library_cc_id,source_library_cc_label,source_library_cc_name,source_library_cc_datatype,\
                    source_library_cc_mark_for_delete,source_library_cc_editable,source_library_cc_display,\
                    source_library_cc_is_multiple,source_library_cc_normalized,activate_for_calm = row

                    new_row = source_library,source_library_cc_label,activate_for_calm
                    source_cc_list.append(new_row)
                #END FOR
                                                                 # def __init__(self, window, cat_name, tag_to_match, data, sorter):
        ccactivationlist_editor_dialog = CCActivationListEditor(self.gui, 'CALM', 'None',\
                                                                                    source_cc_list, None, self.guidb,my_db,my_cursor)
        ccactivationlist_editor_dialog.show()
    #--------------------------------------------------------------------------------------------------
    def actually_update_activations(self):
        pass
    #--------------------------------------------------------------------------------------------------
    def init_tooltips_for_custom_columns_tab(self):
        self.setStyleSheet("QToolTip { color: #ffffff; background-color: #2a82da; border: 1px solid white; }")
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def initialize_table_listing_html(self):
        self.table_listing_html = "... click the above 'List Current Source Library/Custom Column Combinations' button for the latest table listing ..."
        return self.table_listing_html
    #--------------------------------------------------------------------------------------------------
    def return_latest_source_cc_prefs(self,myparentprefs):
        try:
            myparentprefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = self.mysourcecustomcolumnprefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE']
            del self.mysourcecustomcolumnprefs
        except:
            pass
        return myparentprefs
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def apsw_attach_to_source(self,my_db, my_cursor,path):

        s1 = "ATTACH DATABASE '"
        s2 =  "'  AS 'SOURCE' ;"

        path = path.replace(os.sep, '/')
        if path.endswith("/"):
            path = path[0:-1]
        if path.count("metadata.db") == 0:
            path = path + "/metadata.db"
        if isbytestring(path):
            if DEBUG: print("path isbytestring: ", path)
            path = path.decode(filesystem_encoding)
            if DEBUG: print("path = path.decode(filesystem_encoding): decoded path is now: ", path)
        if DEBUG: print("filesystem_encoding is: ", str(filesystem_encoding))

        mysql = s1 + path + s2

        if DEBUG: print(mysql)
        if DEBUG: print("length of path: ", str(len(path)))

        try:
            if DEBUG: print("Attaching to New Source Library: " + path)
            my_cursor.execute (mysql)
            if DEBUG: print("Now Attached to New Source Library: " + path)
            mysql = "PRAGMA SOURCE.busy_timeout = 4000;"      #PRAGMA busy_timeout = milliseconds;
            if DEBUG: print(mysql)
            my_cursor.execute(mysql)
            if DEBUG: print("Finished: apsw_attach_to_source")
            return True
        except Exception as e:
            if DEBUG: print("NOT Attached: " + as_unicode(path))
            if DEBUG: print(as_unicode(e))
            msg = as_unicode(e)
            error_dialog(self.gui, _('CALM Target Database Connection Attachment Path Error'),_((msg)), show=True)
            return False
    #--------------------------------------------------------------------------------------------------
    def apsw_detach_from_source(self,my_db, my_cursor,path):
        try:
            mysql = "DETACH 'SOURCE'"
            my_cursor.execute (mysql)
            if DEBUG: print("Previously Attached Source Library Detached: " + as_unicode(path))
        except Exception as e:
            if DEBUG: print("NOT Detached: " + as_unicode(path))
            if DEBUG: print(as_unicode(e))
            raise e
            return
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def apsw_connect_to_target(self):

        path = prefs['CALM_TARGET_DB_FULL_PATH']

        path = path.replace(os.sep, '/')
        if path.endswith("/"):
            path = path[0:-1]
        if path.count("metadata.db") == 0:
            path = path + "/metadata.db"
        path = path.replace("metadata.db","metadata_tools.db")
        if isbytestring(path):
            if DEBUG: print("path isbytestring: ", path)
            path = path.decode(filesystem_encoding)
            if DEBUG: print("path = path.decode(filesystem_encoding): decoded path is now: ", path)
        if DEBUG: print("filesystem_encoding is: ", str(filesystem_encoding))

        tools_path = path

        if not os.path.exists(tools_path):
            error_dialog(self.gui, _('CALM'),_((ERROR_MESSAGE_METADATA_TOOLS_DB_FILE_IS_MISSING)), show=True)
            for k,v in iteritems(prefs.defaults):
                prefs[k] = v
            #END FOR
            prefs
            return

        self.tools_db_path = tools_path
        self.special_calm_tools_db_full_path_label.setText(self.tools_db_path)

        try:
            my_db =apsw.Connection(path)
        except Exception as e:
            if DEBUG: print("path to target is: ", path)
            if DEBUG: print("error: ", as_unicode(e))
            msg = as_unicode(e)
            error_dialog(self.gui, _('CALM Target Database Connection Path Error'),_((msg)), show=True)
            for k,v in iteritems(prefs.defaults):
                prefs[k] = v
            #END FOR
            prefs
            return

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 5000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        return my_db,my_cursor
    #-----------------------------------------------------------------------------------------------
    def apsw_attach_to_tools_db(self,my_db,my_cursor):

        s1 = "ATTACH DATABASE '"
        s2 =  "'  As 'TOOLS' ;"

        path = self.target_db
        path = path.replace("metadata.db","metadata_tools.db")
        path = path.replace(os.sep, '/')
        if isbytestring(path):
            if DEBUG: print("path isbytestring: ", path)
            path = path.decode(filesystem_encoding)
            if DEBUG: print("path = path.decode(filesystem_encoding): decoded path is now: ", path)
        if DEBUG: print("filesystem_encoding is: ", str(filesystem_encoding))

        if path.count("/CALM/metadata_tools.db") == 0:
            my_db.close()
            error_dialog(self.gui, _('CALM'),_(("SERIOUS ERROR:  You must create a Target Library via a 'refresh' before using this Tab.")), show=True)
            return

        if not os.path.exists(path):
            my_db.close()
            error_dialog(self.gui, _('CALM'),_((ERROR_MESSAGE_METADATA_TOOLS_DB_FILE_IS_MISSING)), show=True)
            if DEBUG: print("path to tools db is: ", path)
            if DEBUG: print("error: ", as_unicode(e))
            if DEBUG: print(ERROR_MESSAGE_METADATA_TOOLS_DB_FILE_IS_MISSING)
            for k,v in iteritems(prefs.defaults):
                prefs[k] = v
            #END FOR
            prefs
            return

        mysql = s1 + path + s2

        try:
            if DEBUG: print("Attaching to Tools DB: " + path)
            my_cursor.execute (mysql)
            mysql = "PRAGMA TOOLS.busy_timeout = 5000;"      #PRAGMA busy_timeout = milliseconds;
            my_cursor.execute(mysql)
        except Exception as e:
            if DEBUG: print("NOT Attached: " + as_unicode(path))
            if DEBUG: print(as_unicode(e))
            msg = as_unicode(e)
            error_dialog(self.gui, _('CALM Database Connection Path Error'),_((msg)), show=True)
            for k,v in iteritems(prefs.defaults):
                prefs[k] = v
            #END FOR
            prefs
            return

        mysql = "PRAGMA main.user_version;  "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        for row in tmp_rows:
            for col in row:
                schema_user_version = col
        if as_unicode(schema_user_version) != MOST_CURRENT_VERSION_OF_METADATA_TOOLS \
            or prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] == unicode_type("True"):
            try:
                if not self.mysourcecustomcolumnprefs:
                    self.mysourcecustomcolumnprefs = {}
            except:
                    self.mysourcecustomcolumnprefs = {}
            self.mysourcecustomcolumnprefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("False")  # prior to calling self.create_new_sqlite_objects_in_tools_db, not after.
            if DEBUG: print("BEFORE schema_user_version: ", as_unicode(schema_user_version))
            type = "ATTACHED"
            self.create_new_sqlite_objects_in_tools_db(my_db,my_cursor,type)
            mysql = "PRAGMA main.user_version = [N] ;  "
            mysql = mysql.replace("[N]",as_unicode(MOST_CURRENT_VERSION_OF_METADATA_TOOLS))
            my_cursor.execute(mysql)
            mysql = "PRAGMA main.user_version;  "
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            for row in tmp_rows:
                for col in row:
                    schema_user_version = col
            if DEBUG: print("AFTER schema_user_version: ", as_unicode(schema_user_version))
            prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("False")
            tmpcopy = prefs.copy()    # a simple 'prefs' is a function, not a dict...
            db.prefs.set_namespaced(DB_PREFS_NAMESPACE, DB_PREFS_KEY_SETTINGS, tmpcopy)   #update metadata.db table=preferences...
            del tmpcopy
        else:
            pass

       #---------------------------------
    #--------------------------------------------------------------------------------------------------
    def apsw_detach_from_tools_db(self,my_db, my_cursor):

        # note:  the metadata_tools.db in the .zip already includes a template SQLITE_STAT1 table that was manually pre-populated from an actual metadata_tools.db that was fully exercised.
        try:
            my_cursor.execute("ANALYZE TOOLS")  # https://sqlite.org/lang_analyze.html
        except Exception as e:
            if DEBUG: print('[metadata_tools.db] my_cursor("ANALYZE")', as_unicode(e))
            pass

        try:
            mysql = "DETACH 'TOOLS'"
            my_cursor.execute (mysql)
            if DEBUG: print("TOOLS DB Detached")
        except Exception as e:
            if DEBUG: print("TOOLS DB NOT Detached")
            if DEBUG: print(as_unicode(e))
            raise e
            return
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def apsw_connect_to_tools_db_cc_tab(self):

        lib_path = prefs['CALM_TARGET_DB_FULL_PATH']

        path = lib_path.replace("metadata.db","metadata_tools.db")
        path = path.replace(os.sep, '/')
        if isbytestring(path):
            if DEBUG: print("path isbytestring: ", path)
            path = path.decode(filesystem_encoding)
            if DEBUG: print("path = path.decode(filesystem_encoding): decoded path is now: ", path)
        if DEBUG: print("filesystem_encoding is: ", str(filesystem_encoding))

        if path.count("/CALM/metadata_tools.db") == 0:
            error_dialog(self.gui, _('CALM'),_(("You must create a Target Library via a 'refresh' before using this Tab.")), show=True)
            prefs['GUI_LAST_TAB_USED'] = unicode_type(1)  # change to the Target Tab instead of the current Source CC Tab...
            prefs
            return None,None,False

        if not os.path.exists(path):
            error_dialog(self.gui, _('CALM'),_((ERROR_MESSAGE_METADATA_TOOLS_DB_FILE_IS_MISSING)), show=True)
            prefs['GUI_LAST_TAB_USED'] = unicode_type(1)  # change to the Target Tab instead of the current Source CC Tab...
            prefs
            return None,None,False

        self.tools_db_path = path
        self.special_calm_tools_db_full_path_label.setText(self.tools_db_path)

        try:
            my_db =apsw.Connection(path)
            self.update()
            QApplication.instance().processEvents()
        except Exception as e:
            if DEBUG: print("path to tools db is: ", path)
            if DEBUG: print("error: ", as_unicode(e))
            msg = as_unicode(e)
            error_dialog(self.gui, _('CALM Database Connection Path Error'),_((msg)), show=True)
            raise e
            return None,None,False

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 5000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        mysql = "PRAGMA main.user_version;  "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        for row in tmp_rows:
            for col in row:
                schema_user_version = col
        if as_unicode(schema_user_version) != MOST_CURRENT_VERSION_OF_METADATA_TOOLS \
            or prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] == unicode_type("True"):
            try:
                if not self.mysourcecustomcolumnprefs:
                    self.mysourcecustomcolumnprefs = {}
            except:
                    self.mysourcecustomcolumnprefs = {}
            self.mysourcecustomcolumnprefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("False")  # prior to calling self.create_new_sqlite_objects_in_tools_db, not after.
            if DEBUG: print("BEFORE schema_user_version: ", as_unicode(schema_user_version))
            type = "CONNECTED"
            self.create_new_sqlite_objects_in_tools_db(my_db,my_cursor,type)
            mysql = "PRAGMA main.user_version = [N] ;  "
            mysql = mysql.replace("[N]",as_unicode(MOST_CURRENT_VERSION_OF_METADATA_TOOLS))
            my_cursor.execute(mysql)
            mysql = "PRAGMA main.user_version;  "
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            for row in tmp_rows:
                for col in row:
                    schema_user_version = col
            if DEBUG: print("AFTER schema_user_version: ", as_unicode(schema_user_version))
            prefs['CALM_DB_VERSION_UPGRADE_FORCE_UPGRADE'] = unicode_type("False")
            tmpcopy = prefs.copy()    # a simple 'prefs' is a function, not a dict...
            db.prefs.set_namespaced(DB_PREFS_NAMESPACE, DB_PREFS_KEY_SETTINGS, tmpcopy)   #update metadata.db table=preferences...
            del tmpcopy
        else:
            pass


        # note:  the metadata_tools.db in the .zip already includes a template SQLITE_STAT1 table that was manually pre-populated from an actual metadata_tools.db that was fully exercised.
        my_cursor.execute("ANALYZE")  # https://sqlite.org/lang_analyze.html


        return my_db,my_cursor,True
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class CALMToolsTab(QWidget):

    def __init__(self,myparent_pointer,mygui,myguidb,mytarget_db,myparentprefs,
                            mycreate_new_sqlite_objects_in_tools_db,myexecute_calm_derivegenres,
                            mychild_invocation_of_save_real_prefs_parent,
                            mychild_invocation_of_set_current_tab_index,
                            mycalm_dialog_restart_immediately):

        super(CALMToolsTab, self).__init__()

        #-----------------------------------------------------
        self.parent_pointer = myparent_pointer
        self.gui = mygui
        self.guidb = myguidb
        self.target_db = mytarget_db
        self.myparentprefs = myparentprefs
        #-----------------------------------------------------
        self.execute_calm_derivegenres = myexecute_calm_derivegenres
        self.create_new_sqlite_objects_in_tools_db = mycreate_new_sqlite_objects_in_tools_db
        self.child_invocation_of_save_real_prefs_parent = mychild_invocation_of_save_real_prefs_parent
        self.child_invocation_of_set_current_tab_index = mychild_invocation_of_set_current_tab_index
        self.calm_dialog_restart_immediately = mycalm_dialog_restart_immediately
        #-----------------------------------------------------
        self.toolsprefs = {}
        #-----------------------------------------------------
        self.init_tooltips_for_metadata_tools_tab()
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(9)
        #-----------------------------------------------------
        self.layout_top = QVBoxLayout()
        self.layout_top.setSpacing(0)
        self.layout_top.setAlignment(Qt.AlignCenter)
        self.setLayout(self.layout_top)
        #-----------------------------------------------------
        self.scroll_area_frame = QScrollArea()
        self.scroll_area_frame.setAlignment(Qt.AlignCenter)
        self.scroll_area_frame.setWidgetResizable(True)
        self.scroll_area_frame.ensureVisible(800,800)

        self.layout_top.addWidget(self.scroll_area_frame)       # the scroll area is now the child of the parent of self.layout_top

        # NOTE: the self.scroll_area_frame.setWidget(self.scroll_widget) is at the end of the init() AFTER all children have been created and assigned to a layout...

        #-----------------------------------------------------
        self.scroll_widget = QWidget()
        self.layout_top.addWidget(self.scroll_widget)           # causes automatic reparenting of QWidget to the parent of self.layout_top, which is:  self .
        #-----------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setAlignment(Qt.AlignCenter)

        self.scroll_widget.setLayout(self.layout_frame)        # causes automatic reparenting of any widget later added to self.layout_frame to the parent of self.layout_frame, which is:  QWidget .

        #-----------------------------------------------------
        self.calm_tools_groupbox = QGroupBox('Tags:')
        self.calm_tools_groupbox.setToolTip("<p style='white-space:wrap'>Easily Standardize Tags Across all of your Calibre Source Libraries.")
        self.calm_tools_groupbox.setMinimumWidth(400)
        #~ self.calm_tools_groupbox.setMaximumWidth(800)
        self.calm_tools_groupbox.setMinimumHeight(0)
        self.layout_frame.addWidget(self.calm_tools_groupbox)

        self.calm_tools_tags_layout = QVBoxLayout()
        self.calm_tools_tags_layout.setAlignment(Qt.AlignCenter)
        self.calm_tools_groupbox.setLayout(self.calm_tools_tags_layout)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.calm_tools_buttonbox = QDialogButtonBox()
        self.calm_tools_buttonbox.setOrientation(Qt.Vertical)
        self.calm_tools_buttonbox.setCenterButtons(True)

        self.calm_tools_tags_layout.addWidget(self.calm_tools_buttonbox)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_tags_easyadd_tag_purge_rules = QPushButton(" ", self)
        self.push_button_tags_easyadd_tag_purge_rules.setText("Easy-Add Tags-to-Purge Rules")
        self.push_button_tags_easyadd_tag_purge_rules.setMinimumWidth(500)
        #~ self.push_button_tags_easyadd_tag_purge_rules.setMaximumWidth(600)
        self.push_button_tags_easyadd_tag_purge_rules.clicked.connect(self.tags_rules_purge_dialog)
        self.push_button_tags_easyadd_tag_purge_rules.setDefault(False)
        self.push_button_tags_easyadd_tag_purge_rules.setFont(font)
        self.push_button_tags_easyadd_tag_purge_rules.setToolTip("<p style='white-space:wrap'>Easily Add Tags that you wish to always have deleted to the CALM Tag Rules Table, _tag_rules, in the special CALM 'metadata_tools.db' file.  Note the '_tools' in its name.  It is NOT a metadata.db Calibre database file.")

        self.calm_tools_buttonbox.addButton(self.push_button_tags_easyadd_tag_purge_rules,QDialogButtonBox.AcceptRole)

        self.push_button_tags_easyadd_tag_change_rules = QPushButton(" ", self)
        self.push_button_tags_easyadd_tag_change_rules.setText("Easy-Add Tags-to-Change Rules")
        self.push_button_tags_easyadd_tag_change_rules.setMinimumWidth(500)
        #~ self.push_button_tags_easyadd_tag_change_rules.setMaximumWidth(600)
        self.push_button_tags_easyadd_tag_change_rules.clicked.connect(self.tags_rules_change_dialog)
        self.push_button_tags_easyadd_tag_change_rules.setDefault(False)
        self.push_button_tags_easyadd_tag_change_rules.setFont(font)
        self.push_button_tags_easyadd_tag_change_rules.setToolTip("<p style='white-space:wrap'>Easily Add 'Tag Change Rules' to the CALM Tag Rules Table, _tag_rules, in the special CALM 'metadata_tools.db' file.  Note the '_tools' in its name.  It is NOT a metadata.db Calibre database file.")

        self.calm_tools_buttonbox.addButton(self.push_button_tags_easyadd_tag_change_rules,QDialogButtonBox.AcceptRole)

        self.push_button_tags_apply_purge_rules = QPushButton(" ", self)
        self.push_button_tags_apply_purge_rules.setText("Apply Tag Purge Rules to Target Library [All Books]")
        self.push_button_tags_apply_purge_rules.setMinimumWidth(500)
        #~ self.push_button_tags_apply_purge_rules.setMaximumWidth(600)
        self.push_button_tags_apply_purge_rules.clicked.connect(self.tag_purge_rules_apply_to_target)
        self.push_button_tags_apply_purge_rules.setDefault(False)
        self.push_button_tags_apply_purge_rules.setFont(font)
        self.push_button_tags_apply_purge_rules.setToolTip("<p style='white-space:wrap'>Using the Tag Rules Table, automatically 'purge' (delete) any Tags that exist in the special CALM Target Library (which you are working in at this moment).")

        self.calm_tools_buttonbox.addButton(self.push_button_tags_apply_purge_rules,QDialogButtonBox.AcceptRole)

        self.push_button_tags_apply_change_rules = QPushButton(" ", self)
        self.push_button_tags_apply_change_rules.setText("Apply Tag Change Rules to Target Library [All Books]")
        self.push_button_tags_apply_change_rules.setMinimumWidth(500)
        #~ self.push_button_tags_apply_change_rules.setMaximumWidth(600)
        self.push_button_tags_apply_change_rules.clicked.connect(self.tag_change_rules_apply_to_target)
        self.push_button_tags_apply_change_rules.setDefault(False)
        self.push_button_tags_apply_change_rules.setFont(font)
        self.push_button_tags_apply_change_rules.setToolTip("<p style='white-space:wrap'>Using the Tag Rules Table, automatically 'change' any Tags that exist in the special CALM Target Library (which you are working in at this moment).")

        self.calm_tools_buttonbox.addButton(self.push_button_tags_apply_change_rules,QDialogButtonBox.AcceptRole)

        self.push_button_tags_apply_combination_rules = QPushButton(" ", self)
        self.push_button_tags_apply_combination_rules.setText("Apply Tag Combination Rules to Target Library [All Books]")
        self.push_button_tags_apply_combination_rules.setMinimumWidth(500)
        #~ self.push_button_tags_apply_combination_rules.setMaximumWidth(600)
        self.push_button_tags_apply_combination_rules.clicked.connect(self.apply_target_tag_combination_rules)
        self.push_button_tags_apply_combination_rules.setDefault(False)
        self.push_button_tags_apply_combination_rules.setFont(font)
        self.push_button_tags_apply_combination_rules.setToolTip("<p style='white-space:wrap'>Using the Tag Combination Rules Table, automatically create new Tags for CALM Target Library books having the required Tag Combination.")

        self.calm_tools_buttonbox.addButton(self.push_button_tags_apply_combination_rules,QDialogButtonBox.AcceptRole)

        self.push_button_tags_apply_capitalization_rules = QPushButton(" ", self)
        self.push_button_tags_apply_capitalization_rules.setText("Apply Tag Capitalization Rules to Target Library [All Books]")
        self.push_button_tags_apply_capitalization_rules.setMinimumWidth(500)
        #~ self.push_button_tags_apply_capitalization_rules.setMaximumWidth(600)
        self.push_button_tags_apply_capitalization_rules.clicked.connect(self.apply_target_tag_capitalization_rules)
        self.push_button_tags_apply_capitalization_rules.setDefault(False)
        self.push_button_tags_apply_capitalization_rules.setFont(font)
        self.push_button_tags_apply_capitalization_rules.setToolTip("<p style='white-space:wrap'>Using the Tag Capitalization Rules Table, automatically capitalize all CALM Target Library Tags.")

        self.calm_tools_buttonbox.addButton(self.push_button_tags_apply_capitalization_rules,QDialogButtonBox.AcceptRole)

        self.push_button_tags_apply_string_replacement_rules = QPushButton(" ", self)
        self.push_button_tags_apply_string_replacement_rules.setText("Apply Tag String Replacement Rules to Target Library [All Books]")
        self.push_button_tags_apply_string_replacement_rules.setMinimumWidth(500)
        #~ self.push_button_tags_apply_string_replacement_rules.setMaximumWidth(600)
        self.push_button_tags_apply_string_replacement_rules.clicked.connect(self.apply_target_tag_string_replacement_rules)
        self.push_button_tags_apply_string_replacement_rules.setDefault(False)
        self.push_button_tags_apply_string_replacement_rules.setFont(font)
        self.push_button_tags_apply_string_replacement_rules.setToolTip("<p style='white-space:wrap'>Using the Tag String Replacement Rules Table, automatically replace strings with new strings for all CALM Target Library Tags.")

        self.calm_tools_buttonbox.addButton(self.push_button_tags_apply_string_replacement_rules,QDialogButtonBox.AcceptRole)

        #-----------------------------------------------------
        self.calm_tools_tags_layout.insertSpacing(-1,10)
        #-----------------------------------------------------
        self.push_button_tags_replace_source_with_target = QPushButton(" ", self)
        self.push_button_tags_replace_source_with_target.setText("Replace Source Library Tags with Target Library Tags [All Sources && All Books]")
        self.push_button_tags_replace_source_with_target.setMinimumWidth(500)
        #~ self.push_button_tags_replace_source_with_target.setMaximumWidth(600)
        self.push_button_tags_replace_source_with_target.clicked.connect(self.change_source_tags_to_target_tags_connect)
        self.push_button_tags_replace_source_with_target.setDefault(False)
        self.push_button_tags_replace_source_with_target.setFont(font)
        self.push_button_tags_replace_source_with_target.setToolTip("<p style='white-space:wrap'>Change the Tags for each book in its Original Source Library to be identical to its CALM Target Library snapshot twin. ")

        self.calm_tools_tags_layout.addWidget(self.push_button_tags_replace_source_with_target,0)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.tags_label_layout = QVBoxLayout()
        self.tags_label_layout.setAlignment(Qt.AlignCenter)
        self.calm_tools_tags_layout.addLayout(self.tags_label_layout)

        font.setPointSize(8)
        font.setBold(True)
        self.tags_action_message = QLabel()
        self.tags_action_message.setTextFormat(Qt.PlainText)
        self.tags_action_message.setText("Last Action: None")
        self.tags_action_message.setFont(font)
        self.tags_action_message.setAlignment(Qt.AlignCenter)
        self.tags_action_message.setToolTip("<p style='white-space:wrap'>The last Tag Action performed during this most recent 'session'.  This is to help you keep track of what you have been doing.")
        self.tags_action_message.setMinimumWidth(100)
        #~ self.tags_action_message.setMaximumWidth(600)

        self.tags_label_layout.addWidget(self.tags_action_message)

        font.setPointSize(9)
        font.setBold(False)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.calm_tools_genre_groupbox = QGroupBox('Genre:')
        self.calm_tools_genre_groupbox.setToolTip("<p style='white-space:wrap'>Easily Standardize Genres Across all of your Calibre Source Libraries")
        self.calm_tools_genre_groupbox.setMinimumWidth(400)
        #~ self.calm_tools_genre_groupbox.setMaximumWidth(800)
        self.calm_tools_genre_groupbox.setMinimumHeight(0)
        self.layout_frame.addWidget(self.calm_tools_genre_groupbox)

        self.calm_tools_genre_layout = QVBoxLayout()
        self.calm_tools_genre_layout.setAlignment(Qt.AlignCenter)
        self.calm_tools_genre_groupbox.setLayout(self.calm_tools_genre_layout)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.calm_tools_genre_buttonbox = QDialogButtonBox()
        self.calm_tools_genre_buttonbox.setOrientation(Qt.Vertical)
        self.calm_tools_genre_buttonbox.setCenterButtons(True)

        self.calm_tools_genre_layout.addWidget(self.calm_tools_genre_buttonbox)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_derive_genres = QPushButton(" ", self)
        self.push_button_derive_genres.setText("Derive Genres [All Target Library Books]")
        self.push_button_derive_genres.setMinimumWidth(500)
        #~ self.push_button_derive_genres.setMaximumWidth(600)
        self.push_button_derive_genres.clicked.connect(self.derive_genres)
        self.push_button_derive_genres.setDefault(False)
        self.push_button_derive_genres.setFont(font)
        self.push_button_derive_genres.setToolTip("<p style='white-space:wrap'>Submits the CALM 'Derive Genres Job' that updates the #genre_calm custom column in the CALM Target Library using the various Derive Genre Tag and Author Rules that you have maintained in the special CALM metadata_tools.db file. ")

        self.calm_tools_genre_buttonbox.addButton(self.push_button_derive_genres,QDialogButtonBox.AcceptRole)

        #-----------------------------------------------------
        self.calm_tools_genre_layout.insertSpacing(-1,10)
        #-----------------------------------------------------
        self.push_button_copy_genre_to_sources = QPushButton(" ", self)
        self.push_button_copy_genre_to_sources.setText("Replace Source Library Genres with Target Library Genres [All Sources && All Books]")
        self.push_button_copy_genre_to_sources.setMinimumWidth(500)
        #~ self.push_button_copy_genre_to_sources.setMaximumWidth(600)
        self.push_button_copy_genre_to_sources.clicked.connect(self.copy_target_genres_to_sources)
        self.push_button_copy_genre_to_sources.setDefault(False)
        self.push_button_copy_genre_to_sources.setFont(font)
        self.push_button_copy_genre_to_sources.setToolTip("<p style='white-space:wrap'>Change the Genre for each book in its Original Source Library to be identical to its CALM Target Library snapshot twin.  CALM uses common sense to figure out the Lookup/Search Name for each Orginal Source Library's custom column equivalent for CALM's '#genre_calm' custom column.  If it cannot determine it, it prints an error message.  However, it is highly recommended that you standardize all of your Genre custom column names across all of your Calibre Library Ecosystem.  ")

        self.calm_tools_genre_layout.addWidget(self.push_button_copy_genre_to_sources,0)

        #-----------------------------------------------------
        #-----------------------------------------------------
          #-----------------------------------------------------
        self.genre_label_layout = QVBoxLayout()
        self.genre_label_layout.setAlignment(Qt.AlignCenter)
        self.calm_tools_genre_layout.addLayout(self.genre_label_layout)

        font.setPointSize(8)
        font.setBold(True)
        self.genre_action_message = QLabel()
        self.genre_action_message.setTextFormat(Qt.PlainText)
        self.genre_action_message.setText("Last Action: None")
        self.genre_action_message.setFont(font)
        self.genre_action_message.setAlignment(Qt.AlignCenter)
        self.genre_action_message.setToolTip("<p style='white-space:wrap'>The last Genre Action performed during this most recent 'session'.  This is to help you keep track of what you have been doing.")
        self.genre_action_message.setMinimumWidth(100)
        #~ self.genre_action_message.setMaximumWidth(600)

        self.genre_label_layout.addWidget(self.genre_action_message)

        font.setPointSize(9)
        font.setBold(False)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.calm_tools_custom_columns_groupbox = QGroupBox('Custom Columns:')
        self.calm_tools_custom_columns_groupbox.setToolTip("<p style='white-space:wrap'>Synchronize a chosen Target Custom Column with its original Source Custom Columns by changing the Source Custom Columns.")
        self.calm_tools_custom_columns_groupbox.setMinimumWidth(400)
        #~ self.calm_tools_custom_columns_groupbox.setMaximumWidth(800)
        self.calm_tools_custom_columns_groupbox.setMinimumHeight(0)
        self.layout_frame.addWidget(self.calm_tools_custom_columns_groupbox)

        self.calm_tools_custom_columns_layout = QVBoxLayout()
        self.calm_tools_custom_columns_layout.setAlignment(Qt.AlignCenter)
        self.calm_tools_custom_columns_groupbox.setLayout(self.calm_tools_custom_columns_layout)


        #combo box of all non-CALM, non-Q&S, non-composite, not-special custom columns
        self.custom_columns_combobox = QComboBox()
        self.custom_columns_combobox.setEditable(False)
        self.custom_columns_combobox.setFont(font)
        #~ self.custom_columns_combobox.setMaximumWidth(250)
        self.calm_tools_custom_columns_layout.addWidget(self.custom_columns_combobox)

        self.custom_column_list = []
        self.custom_columns_combobox.addItem(as_unicode(""))

        tmp_list =self.guidb.custom_field_keys(include_composites=False)     # no composites are allowed...
        tmp_list.sort()

        forbidden_list = []
        forbidden_list.append("#original_book_path")
        forbidden_list.append("#original_library_path")
        forbidden_list.append("#target_bookid")
        forbidden_list.append("#source_formats")
        forbidden_list.append("#action_history")
        forbidden_list.append("#user_notes")
        forbidden_list.append("#genre_calm")
        forbidden_list.append("#source_format_types")
        forbidden_list.append("#source_cover")
        forbidden_list.append("#calm_genre_only")
        forbidden_list.append("#work_author")
        forbidden_list.append("#work_title")
        forbidden_list.append("#work_series_number")
        forbidden_list.append("#work_series_source")
        forbidden_list.append("#work_freeze")
        forbidden_list.append("#work_tags")
        forbidden_list.append("#pages_source")
        forbidden_list.append("#pages")

        for table in tmp_list:
            if "_" in table:
                n = len(table)
                if table[n-1:n].isdigit():
                    #~ if DEBUG: print("custom column label has a group number: ", table)
                    forbidden_list.append(table)
        #END FOR

        try:
            for table in tmp_list:
                if not table in forbidden_list:
                    table = as_unicode(table)
                    self.custom_columns_combobox.addItem(table)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass

        del tmp_list
        del self.custom_column_list

        self.custom_columns_combobox.setCurrentIndex(-1)

        tooltip = "<p style='white-space:wrap'>Select the Target Custom Column to be copied back to its originally Generated Source Custom Column.\
                                                                        <br><br>The choices are limited to those eligible Custom Columns shown in the drop-down.<br><br>\
                                                                        <br><br>Ineligible:  CALM's personal Custom Columns.\
                                                                        <br><br>Ineligible:  Q&S's personal Custom Columns.\
                                                                        <br><br>Ineligible:  #pages; #pages_source.\
                                                                        <br><br>Ineligible:  Any Custom Column that (still) has a '_NN' suffix.  See the ToolTips on the Source Custom Column Tab for more information.<br><br>"
        self.custom_columns_combobox.setToolTip(tooltip)

        self.push_button_copy_custom_columns_to_sources = QPushButton(" ", self)
        self.push_button_copy_custom_columns_to_sources.setText("Replace Source Library CC with Generated Target Library CC [All Sources && All Books]")
        self.push_button_copy_custom_columns_to_sources.setMinimumWidth(500)
        #~ self.push_button_copy_custom_columns_to_sources.setMaximumWidth(600)
        self.push_button_copy_custom_columns_to_sources.clicked.connect(self.copy_target_custom_columns_to_sources_control)
        self.push_button_copy_custom_columns_to_sources.setDefault(False)
        self.push_button_copy_custom_columns_to_sources.setFont(font)
        self.push_button_copy_custom_columns_to_sources.setToolTip("<p style='white-space:wrap'>Synchronize a chosen Target Custom Column with its originally Generated Source Custom Columns by changing the Source Custom Columns (but only if a Source Library has the selected Generated Custom Column, of course).  Values in 'books' whose Source Library is missing the chosen Custom Column will be ignored.")

        self.calm_tools_custom_columns_layout.addWidget(self.push_button_copy_custom_columns_to_sources,0)

        self.custom_columns_label_layout = QVBoxLayout()
        self.custom_columns_label_layout.setAlignment(Qt.AlignCenter)
        self.calm_tools_custom_columns_layout.addLayout(self.custom_columns_label_layout)

        font.setPointSize(8)
        font.setBold(True)
        self.custom_columns_action_message = QLabel()
        self.custom_columns_action_message.setTextFormat(Qt.PlainText)
        self.custom_columns_action_message.setText("Last Action: None")
        self.custom_columns_action_message.setFont(font)
        self.custom_columns_action_message.setAlignment(Qt.AlignCenter)
        self.custom_columns_action_message.setToolTip("<p style='white-space:wrap'>The last Custom Column Action performed during this most recent 'session'.  This is to help you keep track of what you have been doing.")
        self.custom_columns_action_message.setMinimumWidth(400)
        #~ self.custom_columns_action_message.setMaximumWidth(600)

        self.custom_columns_label_layout.addWidget(self.custom_columns_action_message)

        font.setPointSize(9)
        font.setBold(False)


        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.calm_tools_identifiers_groupbox = QGroupBox('Identifiers:')
        self.calm_tools_identifiers_groupbox.setToolTip("<p style='white-space:wrap'>Easily Remove Non-Library Codes Identifiers from All of your Calibre Source Libraries.")
        self.calm_tools_identifiers_groupbox.setMinimumWidth(400)
        #~ self.calm_tools_identifiers_groupbox.setMaximumWidth(800)
        self.calm_tools_identifiers_groupbox.setMinimumHeight(0)
        self.layout_frame.addWidget(self.calm_tools_identifiers_groupbox)

        self.calm_tools_identifiers_layout = QVBoxLayout()
        self.calm_tools_identifiers_layout.setAlignment(Qt.AlignCenter)
        self.calm_tools_identifiers_groupbox.setLayout(self.calm_tools_identifiers_layout)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.calm_tools_identifiers_buttonbox = QDialogButtonBox()
        self.calm_tools_identifiers_buttonbox.setOrientation(Qt.Vertical)
        self.calm_tools_identifiers_buttonbox.setCenterButtons(True)

        self.calm_tools_identifiers_layout.addWidget(self.calm_tools_identifiers_buttonbox)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_derive_identifiers = QPushButton(" ", self)
        self.push_button_derive_identifiers.setText("Delete Non-Library Codes Identifiers [All Target Library Books]")
        self.push_button_derive_identifiers.setMinimumWidth(500)
        #~ self.push_button_derive_identifiers.setMaximumWidth(600)
        self.push_button_derive_identifiers.clicked.connect(self.delete_target_identifiers)
        self.push_button_derive_identifiers.setDefault(False)
        self.push_button_derive_identifiers.setFont(font)
        self.push_button_derive_identifiers.setToolTip("<p style='white-space:wrap'>Perform a 'trial run' using only the Target Library in order to satisfy yourself that you will want to do this for your 'real' Source Libraries.")

        self.calm_tools_identifiers_buttonbox.addButton(self.push_button_derive_identifiers,QDialogButtonBox.AcceptRole)

        #-----------------------------------------------------
        self.calm_tools_identifiers_layout.insertSpacing(-1,10)
        #-----------------------------------------------------

        self.push_button_copy_identifiers_to_sources = QPushButton(" ", self)
        self.push_button_copy_identifiers_to_sources.setText("Delete Non-Library Codes Identifiers [In All Source Libraries && For All Books]")
        self.push_button_copy_identifiers_to_sources.setMinimumWidth(500)
        #~ self.push_button_copy_identifiers_to_sources.setMaximumWidth(600)
        self.push_button_copy_identifiers_to_sources.clicked.connect(self.delete_source_identifiers)
        self.push_button_copy_identifiers_to_sources.setDefault(False)
        self.push_button_copy_identifiers_to_sources.setFont(font)
        self.push_button_copy_identifiers_to_sources.setToolTip("<p style='white-space:wrap'>Perform Actual Deletes in your 'real' Source Libraries.")

        self.calm_tools_identifiers_layout.addWidget(self.push_button_copy_identifiers_to_sources,0)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.identifiers_label_layout = QVBoxLayout()
        self.identifiers_label_layout.setAlignment(Qt.AlignCenter)
        self.calm_tools_identifiers_layout.addLayout(self.identifiers_label_layout)

        font.setPointSize(8)
        font.setBold(True)
        self.identifiers_action_message = QLabel()
        self.identifiers_action_message.setTextFormat(Qt.PlainText)
        self.identifiers_action_message.setText("Last Action: None")
        self.identifiers_action_message.setFont(font)
        self.identifiers_action_message.setAlignment(Qt.AlignCenter)
        self.identifiers_action_message.setToolTip("<p style='white-space:wrap'>The last Identifiers Action performed during this most recent 'session'.  This is to help you keep track of what you have been doing.")
        self.identifiers_action_message.setMinimumWidth(100)
        #~ self.identifiers_action_message.setMaximumWidth(600)

        self.identifiers_label_layout.addWidget(self.identifiers_action_message)

        font.setPointSize(9)
        font.setBold(False)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.layout_top.insertSpacing(-1,10)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_widget.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.setWidget(self.scroll_widget)    # now that all widgets have been created and assigned to a layout...
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
        self.current_target_library_is_read_only = False
        self.check_for_read_only_status()
        from calibre.gui2.ui import get_gui
        self.maingui = get_gui()
    #-----------------------------------------------------------------------------------------------
    def verify_current_guidb_path(self):
        # verify that current db path of self.guidb contains "/CALM/metadata.db
        self.myparentprefs['GUI_LAST_TAB_USED'] = unicode_type('3')
        path = self.guidb.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')
        if "/CALM/metadata.db" in path:
            self.target_db_full_path = path
            if not os.path.exists(path):
                error_dialog(self.gui, _('CALM'),_(('You must create a Target Library before using this Tab.')), show=True)
                return False
            else:
                path = path.replace("metadata.db","metadata_tools.db")
                if not os.path.exists(path):
                    error_dialog(self.gui, _('CALM'),_((ERROR_MESSAGE_METADATA_TOOLS_DB_FILE_IS_MISSING)), show=True)
                    return False
                else:
                    return True
        else:
            return False
    #-----------------------------------------------------------------------------------------------
    def tags_rules_purge_dialog(self):
        if self.current_target_library_is_read_only:
            return
        is_valid_guidb = self.verify_current_guidb_path()
        if is_valid_guidb:
            self.tagruleseditor_dialog(self.guidb)
        else:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is NOT a CALM Target Library')), show=True)
            return
    #-----------------------------------------------------------------------------------------------
    def tags_rules_change_dialog(self):
        if self.current_target_library_is_read_only:
            return
        is_valid_guidb = self.verify_current_guidb_path()
        if is_valid_guidb:
            self.tagruleseditor_2_dialog(self.guidb)
        else:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is NOT a CALM Target Library')), show=True)
            return
    #-----------------------------------------------------------------------------------------------
    def tag_purge_rules_apply_to_target(self):
        if self.current_target_library_is_read_only:
            return
        is_valid_guidb = self.verify_current_guidb_path()
        if is_valid_guidb:
            self.tags_action_message.setText(" ")
            self.tags_action_message.setText("Applying Tag Purge Rules to Target Library for All Books...")
            self.update()
            QApplication.instance().processEvents()
            action_type = "purge"
            self.tag_rules_apply_to_target_generic(self.guidb,action_type)
            self.force_refresh_of_cache()
            self.tags_action_message.setText("Last Action:  Target Tags were deleted per Tag Purge Rules.")
            self.update()
            QApplication.instance().processEvents()
        else:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is NOT a CALM Target Library')), show=True)
            return
    #-----------------------------------------------------------------------------------------------
    def tag_change_rules_apply_to_target(self):
        if self.current_target_library_is_read_only:
            return
        is_valid_guidb = self.verify_current_guidb_path()
        if is_valid_guidb:
            self.tags_action_message.setText("Applying Tag Change Rules to Target Library for All Books...")
            self.update()
            QApplication.instance().processEvents()
            action_type = "change"
            self.tag_rules_apply_to_target_generic(self.guidb,action_type)
            self.force_refresh_of_cache()
            self.tags_action_message.setText("Last Action:  Target Tags were changed per Tag Change Rules.")
            self.update()
            QApplication.instance().processEvents()
        else:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is NOT a CALM Target Library')), show=True)
            return
    #-----------------------------------------------------------------------------------------------
    def change_source_tags_to_target_tags_connect(self):
        if self.current_target_library_is_read_only:
            return
        is_valid_guidb = self.verify_current_guidb_path()
        if is_valid_guidb:
            self.tags_action_message.setText(WORKING_MESSAGE_0)
            self.update()
            QApplication.instance().processEvents()
            self.change_source_tags_to_target_tags()
            self.tags_action_message.setText("Last Action:  Source Tags Replaced with CALM Target Tags.")
            self.update()
            QApplication.instance().processEvents()
        else:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is NOT a CALM Target Library')), show=True)
            return
    #-----------------------------------------------------------------------------------------
    def tagruleseditor_dialog(self, guidb):
        if self.current_target_library_is_read_only:
            return
        # tags to purge
        self.tags_action_message.setText("Tags-to-Purge Rules were maintained via Easy-Add")
        tags_list_of_lists = self.get_all_tags_for_tagruleseditor(guidb)
        tagruleslisteditor_dialog = TagRulesListEditor(self.gui, 'CALM:  Tags-to-Purge Rules', 'None',\
                                                                                    tags_list_of_lists, None, self.actually_insert_tag_rules_rows, guidb)
        tagruleslisteditor_dialog.show()
    #-----------------------------------------------------------------------------------------
    def tagruleseditor_2_dialog(self, guidb):
        if self.current_target_library_is_read_only:
            return
        # tags to change into something else
        self.tags_action_message.setText("Tags-to-Change Rules were maintained via Easy-Add")
        tags_list_of_lists = self.get_all_tags_for_tagruleseditor_2(guidb)
        tagruleslisteditor_2_dialog = TagRulesListEditor2(self.gui, 'CALM:  Tags-to-Change Rules', 'None',\
                                                                                    tags_list_of_lists, None, self.actually_insert_tag_rules_rows_2, guidb)
        tagruleslisteditor_2_dialog.show()
    #-----------------------------------------------------------------------------------------
    def actually_insert_tag_rules_rows(self, guidb, list):
        #for tag rules list editor for tag purge rules.
        # this adds the tag rules to the metadata_tools.db, NOT metadata.db!
        if self.current_target_library_is_read_only:
            return
        mynothing = ""

        if list:
            n = len(list)
            if n == 0:
                return
        else:
            return

        #---------------------------------
        my_db = guidb
        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata_tools.db')                          # this adds the tag rules to the metadata_tools.db, NOT metadata.db!
        path = path.replace(os.sep, '/')
        try:
            my_db = apsw.Connection(path)
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            raise e
            return

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 2000;"      #PRAGMA busy_timeout = milliseconds;  (obviously just for this connection)
        my_cursor.execute(mysql)

        my_cursor.execute("begin")
        for row in list:
            s = row.split("|||")
            a = s[0]      #tag (i.e., oldtag)
            b = s[1]      #make regex (1 = True else False)
            a = a.strip()
            b = b.strip()
            if (not a > " "):
                continue

            if isinstance(a, str):
                try:
                    a = unicode_type(a, errors='ignore')
                except:
                    pass
            else:
                pass

            if as_unicode(b) == '1':     #from list editor, should create regex
                s1 = "/" + a + "/"        #case insensitive regex match
            else:
                s1 = a
            s2 = '1'   #purge tag = 1 to purge; always 1 here
            if as_unicode(a) != as_unicode(s1):
                mysql = as_unicode('INSERT OR REPLACE INTO _tag_rules (id,oldtag,newtag,purgetag) VALUES (null, ?, null, ?)   ')
                my_cursor.execute(mysql,(s1,s2))

            #for every /oldtag/, insert a simple match rule 'oldtag' too
            mysql = as_unicode('INSERT OR REPLACE INTO _tag_rules (id,oldtag,newtag,purgetag) VALUES (null, ?, null, ?)   ')
            my_cursor.execute(mysql,(a,s2))
        #END FOR
        my_cursor.execute("commit")
        my_db.close()
    #-----------------------------------------------------------------------------------------
    def actually_insert_tag_rules_rows_2(self, guidb, list):
        #for tag rules list editor 2, which is for tag change rules easy-add
        # this adds the tag rules to the metadata_tools.db, NOT metadata.db!
        if self.current_target_library_is_read_only:
            return
        mynothing = ""

        if list:
            n_rows = len(list)
            if n_rows == 0:
                return
        else:
            return

        #---------------------------------
        my_db = guidb
        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata_tools.db')           # this adds the tag rules to the metadata_tools.db, NOT metadata.db!
        path = path.replace(os.sep, '/')
        try:
            my_db = apsw.Connection(path)
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            raise e
            return

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 2000;"      #PRAGMA busy_timeout = milliseconds;  (obviously just for this connection)
        my_cursor.execute(mysql)

        my_cursor.execute("begin")
        for row in list:
            s = row.split("|||")
            a = s[0]      #tag (i.e., oldtag)
            b = s[1]      #subject (i.e., newtag)
            c = s[2]      #make regex (1 = True else False)
            a = a.strip()
            b = b.strip()
            if (not a > " ")  and (not b > " ") :
                continue
            if a == b:
                pass

            if isinstance(a, str):
                try:
                    a = unicode_type(a, errors='ignore')
                except:
                    pass
            else:
                pass

            if as_unicode(c) == '1':
                s1 = "/" + a + "/"        #case insensitive regex match
            else:
                s1 = a
            s2 = b

            if s2 == s1:    # oldtag == newtag, so why add a rule?
                continue

            if b == "DELETE" or b == "delete" or b == "" or b == '""' or b == "''":
                s2 = None
                mysql = as_unicode('INSERT OR REPLACE INTO _tag_rules (id,oldtag,newtag,purgetag) VALUES (null, ?, ?, 1 )   ')
                my_cursor.execute(mysql,(s1,s2))
                if s1 != a:   #for every /oldtag/, insert a simple match rule 'oldtag' too
                    mysql = as_unicode('INSERT OR REPLACE INTO _tag_rules (id,oldtag,newtag,purgetag) VALUES (null, ?, ?, 1 )   ')
                    my_cursor.execute(mysql,(a,s2))
            else:
                mysql = as_unicode('INSERT OR REPLACE INTO _tag_rules (id,oldtag,newtag,purgetag) VALUES (null, ?, ?, 0 )   ')
                my_cursor.execute(mysql,(s1,s2))
                if s1 != a:   #for every /oldtag/, insert a simple match rule 'oldtag' too
                    mysql = as_unicode('INSERT OR REPLACE INTO _tag_rules (id,oldtag,newtag,purgetag) VALUES (null, ?, ?, 0 )   ')
                    my_cursor.execute(mysql,(a,s2))
        #END FOR
        my_cursor.execute("commit")


        #~ if DEBUG: print(">>>>>>Number of Rows Inserted or Replaced:", as_unicode(n_rows))
        my_cursor.execute("begin")
        mysql = as_unicode("UPDATE _tag_rules SET purgetag = 1 WHERE newtag = 'delete' OR newtag = 'DELETE' ")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        my_cursor.execute("begin")
        mysql = as_unicode("UPDATE _tag_rules SET newtag = NULL WHERE purgetag = 1 ")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        my_cursor.execute("begin")
        mysql = as_unicode("DELETE FROM _tag_rules WHERE newtag = oldtag ")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        my_db.close()
    #-----------------------------------------------------------------------------------------
    def get_all_tags_for_tagruleseditor(self, guidb):
        #for tag rules list editor for tag purge rules only
        if self.current_target_library_is_read_only:
            return
        tags_list_of_lists = []
        tags = []

     #---------------------------------
        my_db = guidb
        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')
        try:
            my_db = apsw.Connection(path)
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            raise e
            return

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 2000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)
        #-------------------------------------------------
        # now attach metadata_tools.db
        s1 = "ATTACH DATABASE '"
        s2 =  "'  As 'TOOLS' ;"
        path = path.replace('.db','_tools.db')
        mysql = s1 + path + s2
        if DEBUG: print("Attaching to Tools db: " + path)
        my_cursor.execute (mysql)
        #-------------------------------------------------
        mysql = as_unicode("SELECT name FROM main.tags WHERE ('/'||name||'/'  NOT IN(SELECT oldtag FROM TOOLS._tag_rules \
                                                WHERE oldtag NOT NULL) ) AND (name NOT IN(SELECT oldtag FROM TOOLS._tag_rules \
                                                WHERE oldtag NOT NULL) ) AND (name NOT IN(SELECT newtag \
                                                FROM TOOLS._tag_rules WHERE newtag NOT NULL) ) ")
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()

        my_db.close()

        if tmp_rows:
            r = []
            for row in tmp_rows:
                del r
                r = []
                n_col = 0
                for col in row:   #there is only 1 column
                    s1 = col
                    r.append(s1)
                    tags.append(r)
                #END FOR
            #END FOR
        else:
            return tags_list_of_lists

        tagset = set(list(map(tuple,tags)))   #need to convert the inner lists to tuples so they are hashable
        tags = list(map(list,tagset))              #Now convert tuples back into lists - with no duplicates

        tags.sort()

        for row in tags:
            tags_list_of_lists.append(row)

        return tags_list_of_lists
    #-----------------------------------------------------------------------------------------
    def get_all_tags_for_tagruleseditor_2(self, guidb):
        #for tag rules list editor2 for easy-add tag change rules only
        if self.current_target_library_is_read_only:
            return
     #---------------------------------
        my_db = guidb
        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')
        try:
            my_db = apsw.Connection(path)
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            raise e
            return

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 2000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        #-------------------------------------------------
        # now attach metadata_tools.db
        s1 = "ATTACH DATABASE '"
        s2 =  "'  As 'TOOLS' ;"
        path = path.replace('.db','_tools.db')
        mysql = s1 + path + s2
        my_cursor.execute (mysql)
        #-------------------------------------------------

        mysql = as_unicode("SELECT name,name FROM main.tags WHERE name NOT NULL \
                            AND name NOT IN(SELECT oldtag FROM TOOLS._tag_rules) \
                            AND name NOT IN(SELECT oldtag FROM TOOLS._tag_rules WHERE oldtag LIKE '%'||'/'||name||'/'||'%'  ) \
                            AND name NOT IN(SELECT oldtag FROM TOOLS._tag_rules WHERE oldtag = '/'||name||'/'   )  ")

        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()

        my_db.close()

        tags_list_of_lists = []
        tags = []

        if tmp_rows:
            if len(tmp_rows) == 0:
                info_dialog(self.gui, _('Nothing to Show You'),_('Nothing to Show You.'), show=True)
                return tags_list_of_lists
            else:
                pass
            r = []
            for row in tmp_rows:
                del r
                r = []
                n_col = 0
                for col in row:
                    if n_col == 0:
                        s1 = col
                        r.append(s1)
                        n_col = 1
                    else:
                        s2 = col
                        if s2.endswith("-*"):
                            s2 = s2[0:-2]
                        if s2.endswith("-") or s2.endswith("*"):
                            s2 = s2[0:-1]
                        r.append(s2)
                        tags.append(r)
                        break
            #END FOR
        else:
            info_dialog(self.gui, _('Nothing to Show You'),
                _('Nothing to Show You.'), show=True)
            return tags_list_of_lists

        tagset = set(list(map(tuple,tags)))   #need to convert the inner lists to tuples so they are hashable
        tags = list(map(list,tagset))              #Now convert tuples back into lists - with no duplicates

        tags.sort()

        for row in tags:
            tags_list_of_lists.append(row)

        return tags_list_of_lists
    #-----------------------------------------------------------------------------------------
    def tag_rules_apply_to_target_generic(self,guidb,action_type):
        if self.current_target_library_is_read_only:
            return

        tag_rules_list = self.get_tag_rules(guidb,action_type)

        all_target_tags_dict = self.get_all_target_tags_full(guidb)

        if action_type == "purge":
            self.purge_target_tags(guidb,tag_rules_list,all_target_tags_dict)
        else:
            self.change_target_tags(guidb,tag_rules_list,all_target_tags_dict)

        del all_target_tags_dict
        del tag_rules_list
#-----------------------------------------------------------------------------------------------
    def purge_target_tags(self,guidb,tag_rules_list,all_target_tags_dict):
        # this particular tag_rules_list only has purgetag == 1 rules
        # all_target_tags_dict[name] = id
        if self.current_target_library_is_read_only:
            return
        tag_regex_rules_list = []
        tag_simple_rules_list = []
        for row in tag_rules_list:
            oldtag,dummy = row
            if oldtag.startswith("/"):
                oldtag = oldtag.replace("/","")
                tag_regex_rules_list.append(oldtag)
            else:
                tag_simple_rules_list.append(oldtag)
        #END FOR

        tag_regex_rules_list.sort()

        tag_simple_rules_set = set(tag_simple_rules_list)

        tag_ids_to_delete_list = []

        #~ for name,id in all_target_tags_dict.iteritems():
        for name,id in iteritems(all_target_tags_dict):
            su = name.upper()
            sl = name.lower()
            st = name.title()
            if (name in tag_simple_rules_set) or (su in tag_simple_rules_set) or  (sl in tag_simple_rules_set) or  (st in tag_simple_rules_set):          #simple match, not a regex
                tag_ids_to_delete_list.append(id)
                continue
            else:
                pass
            for row in tag_regex_rules_list:
                oldtag = row
                re1 = oldtag
                try:
                    p1 = re.compile(re1, re.IGNORECASE)
                    match1 = p1.search(name)
                    if match1:
                        tag_ids_to_delete_list.append(id)
                        break
                except Exception as e:
                    if DEBUG: print("Tag Purge Rule REGEX Compile Error: ", as_unicode(re1), as_unicode(e))
                    continue
            #END FOR
        #END FOR

        del tag_regex_rules_list
        del tag_rules_list
        del tag_simple_rules_set
        del all_target_tags_dict

        if len(tag_ids_to_delete_list) == 0:
            del tag_ids_to_delete_list
            return

        #---------------------------------
        my_db = guidb
        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')

        self.target_db_full_path = path

        try:
            my_db = apsw.Connection(path)
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            raise e
            return

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 2000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        #---------------------------------
        my_cursor.execute("begin")
        for id in tag_ids_to_delete_list:
            mysql = "DELETE FROM books_tags_link WHERE tag = ? "
            my_cursor.execute(mysql,([id]))
            mysql = "DELETE FROM tags WHERE id = ? "
            my_cursor.execute(mysql,([id]))
        #END FOR
        my_cursor.execute("commit")
        #---------------------------------
        table = "_tag_rules"
        self.erase_main_tag_rules_tables(my_db,my_cursor,table)         # was never populated unless the user maintained it instead of the master in metadata_tools.db.  so, erase it just in case.
        #---------------------------------
        self.empty_table_metadata_dirtied(my_db,my_cursor)
        #---------------------------------
        my_db.close()
        #---------------------------------
        del tag_ids_to_delete_list
        #---------------------------------
        self.remove_empty_subdirectories(self.target_db_full_path)    # doing it here guarantees that the current library is the Target Library, and that the path to it has been set properly.
        #---------------------------------
    #-----------------------------------------------------------------------------------------------
    def change_target_tags(self,guidb,tag_rules_list,all_target_tags_dict):
        if self.current_target_library_is_read_only:
            return
        # this particular tag_rules_list only has purgetag == 0 rules
        # all_target_tags_dict[name] = id

        tag_regex_rules_dict = {}
        tag_simple_rules_dict = {}

        for row in tag_rules_list:
            oldtag,newtag = row
            if oldtag.startswith("/"):
                oldtag = oldtag.replace("/","")
                tag_regex_rules_dict[oldtag] = newtag
            else:
                tag_simple_rules_dict[oldtag] = newtag
        #END FOR

        tags_to_change_dict = {}

        all_target_tag_ids_dict = {}

        #~ for name,id in all_target_tags_dict.iteritems():
        for name,id in iteritems(all_target_tags_dict):
            all_target_tag_ids_dict[id] = name
            su = name.upper()
            sl = name.lower()
            st = name.title()
            if (name in tag_simple_rules_dict):
                newtag = tag_simple_rules_dict[name]
                tags_to_change_dict[name] = newtag
                continue
            elif (su in tag_simple_rules_dict):
                newtag = tag_simple_rules_dict[su]
                tags_to_change_dict[name] = newtag
                continue
            elif (sl in tag_simple_rules_dict):
                newtag = tag_simple_rules_dict[sl]
                tags_to_change_dict[name] = newtag
                continue
            elif (st in tag_simple_rules_dict):
                newtag = tag_simple_rules_dict[st]
                tags_to_change_dict[name] = newtag
                continue
            else:
                #~ for oldtag,newtag in tag_regex_rules_dict.iteritems():
                for oldtag,newtag in iteritems(tag_regex_rules_dict):
                    re1 = oldtag
                    try:
                        p1 = re.compile(re1, re.IGNORECASE)
                        match1 = p1.search(name)
                        if match1:
                            tags_to_change_dict[name] = newtag
                            break
                    except Exception as e:
                        if DEBUG: print("Tag Change Rule REGEX Compile Error: ", as_unicode(re1), as_unicode(e))
                        continue
                #END FOR
        #END FOR

        del tag_regex_rules_dict
        del tag_simple_rules_dict
        del all_target_tags_dict

        if len(tags_to_change_dict) == 0:
            del tags_to_change_dict
            del all_target_tag_ids_dict
            if DEBUG: print("No Tags to Change Found")
            return

        #---------------------------------
        my_db = guidb
        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')

        self.target_db_full_path = path

        try:
            my_db = apsw.Connection(path)
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            raise e
            return

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 2000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        #---------------------------------
        mysql = 'SELECT book,tag FROM books_tags_link'
        my_cursor.execute(mysql)
        books_tags_link_list = my_cursor.fetchall()
        if not books_tags_link_list:
            return
        #---------------------------------

        # add any newtags that do not already exist in table tags
        my_cursor.execute("begin")
        #~ for oldtag,newtag in tags_to_change_dict.iteritems():
        for oldtag,newtag in iteritems(tags_to_change_dict):
            mysql = "INSERT OR IGNORE INTO tags (id,name) VALUES (null,?) "
            my_cursor.execute(mysql,([newtag]))
        #END FOR
        my_cursor.execute("commit")

        my_cursor.execute("begin")
        for row in books_tags_link_list:
            book,id = row
            if not id in all_target_tag_ids_dict:
                continue   # should not ever happen unless corrupt metadata.db
            else:
                oldtag = all_target_tag_ids_dict[id]       # id and name of original tag (oldtag) in table tags
                if not oldtag in tags_to_change_dict:
                    continue
                else:
                    newtag = tags_to_change_dict[oldtag]    # now have oldtag, its id in table tags, and the newtag for this oldtag
                    # newtag must already exist in table tags at this point
                    mysql = "INSERT OR IGNORE INTO books_tags_link (id,book,tag) VALUES (null,?,(SELECT id FROM tags WHERE tags.name = ? ) ) "
                    my_cursor.execute(mysql,(book,newtag))
                    # now delete the oldtag that was just replaced by newtag
                    mysql = "DELETE FROM books_tags_link WHERE book = ? AND tag IN(SELECT id FROM tags WHERE tags.name = ? ) "
                    my_cursor.execute(mysql,(book,oldtag))
        #END FOR
        my_cursor.execute("commit")

        # orphan ids in books_tags_link must be deleted
        my_cursor.execute("begin")
        mysql = "DELETE FROM books_tags_link WHERE tag NOT IN(SELECT id FROM tags WHERE tags.id = books_tags_link.tag) "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        # orphan ids in table tags must be deleted
        my_cursor.execute("begin")
        mysql = "DELETE FROM tags WHERE id NOT IN(SELECT tag FROM books_tags_link WHERE tags.id = books_tags_link.tag) "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        #--------------------------------------------------------------------
        table = "_tag_rules"
        self.erase_main_tag_rules_tables(my_db,my_cursor,table)         # was never populated unless the user maintained it instead of the master in metadata_tools.db.  so, erase it just in case.
        #--------------------------------------------------------------------
        self.empty_table_metadata_dirtied(my_db,my_cursor)

        my_db.close()
        #--------------------------------------------------------------------
        del tags_to_change_dict
        del all_target_tag_ids_dict
        #--------------------------------------------------------------------
        self.remove_empty_subdirectories(self.target_db_full_path)    # doing it here guarantees that the current library is the Target Library, and that the path to it has been set properly.
        #--------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def apply_target_tag_string_replacement_rules(self):
        if self.current_target_library_is_read_only:
            return
        is_valid_guidb = self.verify_current_guidb_path()
        if is_valid_guidb:
            pass
        else:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is NOT a CALM Target Library')), show=True)
            return

        s = "WORKING"
        self.tags_action_message.setText(s)
        self.update()
        QApplication.instance().processEvents()

        my_db, my_cursor = self.apsw_connect_to_target()
        if self.current_target_library_is_read_only:
            return
        self.apsw_attach_to_tools_db(my_db, my_cursor)

        table = "_tag_string_replacement_rules"
        self.refresh_main_tag_rules_tables_from_tools_db(my_db, my_cursor, table)

        self.apsw_detach_from_tools_db(my_db, my_cursor)

        tmp_list = []
        old_name_list = []
        new_name_list = []

        mysql = "SELECT book,tag,oldstring,newstring FROM __tag_string_replacement_rules_by_tag"
        my_cursor.execute(mysql)
        tmp_list = my_cursor.fetchall()
        if not tmp_list:
            pass
        else:
            if len(tmp_list) == 0:
                del tmp_list
                pass
            else:
                for row in tmp_list:
                    book,old_name,old_string,new_string = row
                    new_name = old_name.replace(old_string,new_string)
                    new_name = new_name.strip()
                    new_name_list.append(new_name)
                    old_name = old_name.strip()
                    old_name_list.append(old_name)
                    #---------------------------------
                    s = as_unicode(book) + ":" + old_name
                    self.tags_action_message.setText(s)
                    self.update()
                    QApplication.instance().processEvents()
                    #---------------------------------
                    try:
                        my_cursor.execute("begin")
                        mysql = "INSERT OR IGNORE INTO tags (id,name) VALUES(null,?)"       # string does NOT have to be a full, whole tag, but temporarily assume it is...
                        my_cursor.execute(mysql,([new_string]))
                        my_cursor.execute("commit")
                    except Exception as e:
                        if DEBUG: print("[1]: ", as_unicode(e))
                        try:
                            my_cursor.execute("commit")
                        except:
                            pass
                    try:
                        my_cursor.execute("begin")
                        mysql = "INSERT OR IGNORE INTO tags (id,name) VALUES(null,?)"       # full, whole tag may or may not already exist in tags...
                        my_cursor.execute(mysql,([new_name]))
                        my_cursor.execute("commit")
                    except Exception as e:
                        if DEBUG: print("[2]: ", as_unicode(e))
                        try:
                            my_cursor.execute("commit")
                        except:
                            pass
                    try:
                        my_cursor.execute("begin")
                        mysql = "UPDATE tags SET name = ? WHERE name = ? AND ? NOT IN(SELECT name FROM tags WHERE name = ?) "       # if there were already a tag with name==new_name, would error out.
                        my_cursor.execute(mysql,(new_name,old_name,new_name,new_name))
                        my_cursor.execute("commit")
                    except Exception as e:
                        if DEBUG: print("[3]: ", as_unicode(e))
                        try:
                            my_cursor.execute("commit")
                        except:
                            pass
                    try:
                        # if the new_name already existed before the old_name was changed to the new_name, then the books with the old_name need to be linked to the new_name and not the old_name...
                        my_cursor.execute("begin")
                        mysql = "INSERT OR IGNORE INTO books_tags_link (id,book,tag) VALUES(null,?,(SELECT id FROM tags WHERE name = ?) )"
                        my_cursor.execute(mysql,(book,new_name))
                        my_cursor.execute("commit")
                    except Exception as e:
                        if DEBUG: print("[4]: ", as_unicode(e))
                        try:
                            my_cursor.execute("commit")
                        except:
                            pass
                    sleep(0)
                 #END FOR

                try:
                    my_cursor.execute("commit")
                except:
                    pass

                del tmp_list

                old_name_set = set(old_name_list)   # no duplicates
                del old_name_list
                new_name_set = set(new_name_list)
                del new_name_list

                for old_name in old_name_set:
                    if old_name in new_name_set:
                        continue  # do not delete it...
                    try:
                        # the old_name should no longer be linked to any books...which would occur if the new_name previously had ever existed simultaneously with the old_name as different tags...
                        my_cursor.execute("begin")
                        mysql = "DELETE FROM books_tags_link WHERE books_tags_link.tag IN(SELECT id FROM tags WHERE tags.name = ? )"
                        my_cursor.execute(mysql,([old_name]))
                        mysql = "DELETE FROM tags WHERE tags.name = ?  "
                        my_cursor.execute(mysql,([old_name]))
                        my_cursor.execute("commit")
                    except Exception as e:
                        if DEBUG: print("[5]: ", as_unicode(e))
                        try:
                            my_cursor.execute("commit")
                        except:
                            pass
                #END FOR

                del old_name_set
                del new_name_set

                try:
                    # finally, delete any unused (orphan) tags that might have been temporarily created above due to theoretical assumptions...
                    my_cursor.execute("begin")
                    mysql = "DELETE FROM tags WHERE id NOT IN(SELECT tag FROM books_tags_link WHERE books_tags_link.tag = tags.id) "
                    my_cursor.execute(mysql)
                    my_cursor.execute("commit")
                except Exception as e:
                    if DEBUG: print("[6]: ", as_unicode(e))
                    try:
                        my_cursor.execute("commit")
                    except:
                        pass
            #END IF
        #END IF
        sleep(0)
       #---------------------------------
        table = "_tag_string_replacement_rules"
        self.erase_main_tag_rules_tables(my_db, my_cursor, table)
        #---------------------------------
        self.empty_table_metadata_dirtied(my_db,my_cursor)
        #---------------------------------
        my_db.close()
        #---------------------------------
        self.force_refresh_of_cache()
        #---------------------------------
        sleep(0)
        self.tags_action_message.setAlignment(Qt.AlignCenter)
        self.tags_action_message.setText("Last Action: Tag String Replacement Rules Applied to Target")
        self.update()
        QApplication.instance().processEvents()
        #---------------------------------
        self.remove_empty_subdirectories(self.target_db_full_path)    # doing it here guarantees that the current library is the Target Library, and that the path to it has been set properly.
        #---------------------------------
        QApplication.instance().processEvents()
    #-----------------------------------------------------------------------------------------------
    def apply_target_tag_capitalization_rules(self):
        if self.current_target_library_is_read_only:
            return

        is_valid_guidb = self.verify_current_guidb_path()
        if is_valid_guidb:
            pass
        else:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is NOT a CALM Target Library')), show=True)
            return

        self.tags_action_message.setText(WORKING_MESSAGE_1)
        self.update()
        QApplication.instance().processEvents()

        my_db, my_cursor = self.apsw_connect_to_target()
        if self.current_target_library_is_read_only:
            return
        #---------------------------------
        self.apsw_attach_to_tools_db(my_db, my_cursor)
        #---------------------------------
        table = "_tag_capitalization_rules"
        self.refresh_main_tag_rules_tables_from_tools_db(my_db,my_cursor,table)
        #---------------------------------
        self.tag_capitalization_regex_rules = []
        self.build_regex_list_from_tag_capitalization_rules(my_db, my_cursor)
        #---------------------------------
        self.apsw_detach_from_tools_db(my_db, my_cursor)
        #---------------------------------
        all_target_tags_dict = self.get_all_target_tags_simple(my_db, my_cursor)
        #---------------------------------
        self.tags_action_message.setText("...STILL WORKING...")
        self.update()
        QApplication.instance().processEvents()
        new_tag_dict = {}
        #~ for k,v in all_target_tags_dict.iteritems():       # all_target_tags_dict[name] = id
        for k,v in iteritems(all_target_tags_dict):       # all_target_tags_dict[name] = id
            tmp_tag = self.apply_tag_capitalization_rules_to_single_tag(k)
            new_tag_dict[v] = tmp_tag                      # new_tag_dict[id] = name
        #END FOR
        #---------------------------------
        my_cursor.execute("begin")
        #~ for k,v in new_tag_dict.iteritems():        # new_tag_dict[id] = name
        for k,v in iteritems(new_tag_dict):        # new_tag_dict[id] = name
            mysql = "UPDATE tags SET name = ? WHERE id = ?"
            my_cursor.execute(mysql,(v,k))
        #END FOR
        my_cursor.execute("commit")
        #---------------------------------
        del self.tag_capitalization_regex_rules
        #---------------------------------
        self.empty_table_metadata_dirtied(my_db,my_cursor)
        #---------------------------------
        my_db.close()
        #---------------------------------
        self.force_refresh_of_cache()
        #---------------------------------
        self.tags_action_message.setText("Last Action: Applied Tag Capitalization Rules to Target")
        self.update()
        QApplication.instance().processEvents()
        #---------------------------------
        self.remove_empty_subdirectories(self.target_db_full_path)    # doing it here guarantees that the current library is the Target Library, and that the path to it has been set properly.
        #---------------------------------
    #-----------------------------------------------------------------------------------------------
    def apply_target_tag_combination_rules(self):
        if self.current_target_library_is_read_only:
            return

        is_valid_guidb = self.verify_current_guidb_path()
        if is_valid_guidb:
            pass
        else:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is NOT a CALM Target Library')), show=True)
            return

        self.tags_action_message.setText(WORKING_MESSAGE_1)
        self.update()
        QApplication.instance().processEvents()

        my_db, my_cursor = self.apsw_connect_to_target()
        if self.current_target_library_is_read_only:
            return
       #---------------------------------
        self.apsw_attach_to_tools_db(my_db, my_cursor)
        table = "_tag_combination_rules"
        self.refresh_main_tag_rules_tables_from_tools_db(my_db,my_cursor,table)
        self.apsw_detach_from_tools_db(my_db, my_cursor)
       #---------------------------------
        all_target_tag_combination_rules_list = []
        all_target_tags_by_book_concat_list = []
        candidate_book_newtag_list = []
        candidate_newtag_list = []
        #---------------------------------
        mysql = "SELECT tag_keyword_1, tag_keyword_2, tag_keyword_3,newtag FROM _tag_combination_rules"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
       #---------------------------------
        if not tmp_rows:
            pass
        else:
            for row in tmp_rows:
                a,b,c,d = row
                try:
                    a = a.lower()
                    b = b.lower()
                    c = c.lower()
                    d = d.lower()
                except:
                    pass
                newrow = a,b,c,d
                all_target_tag_combination_rules_list.append(newrow)
            #END FOR
            del tmp_rows
            #---------------------------------
            if len(all_target_tag_combination_rules_list) > 0:
                mysql = "SELECT book,tagsconcat FROM __tags_by_book_concatenate"
                my_cursor.execute(mysql)
                tmp_rows = my_cursor.fetchall()
               #---------------------------------
                if not tmp_rows:
                    pass
                else:
                    for row in tmp_rows:
                        book,tagsconcat = row
                        book = int(book)
                        try:
                            s = tagsconcat.lower()
                        except:
                            s = tagsconcat
                        s = s.strip()
                        s = s.replace("  "," ")
                        s = s.replace(", ",",")
                        newrow = book,s
                        all_target_tags_by_book_concat_list.append(newrow)
                    #END FOR
                    del tmp_rows
                    #---------------------------------
                    if len(all_target_tags_by_book_concat_list) == 0:
                        pass
                    else:
                        for row in all_target_tags_by_book_concat_list:  #   12345     Español,Fiction:Fantasy,Fiction:Mysteries&Detectives,Fiction:Science
                            book, tagsconcat = row
                            tagsconcat = tagsconcat.strip()
                            for rule in all_target_tag_combination_rules_list:
                                tag_keyword_1,tag_keyword_2,tag_keyword_3,newtag = rule
                                newtag = newtag.strip()
                                s1 = "," + newtag + ","
                                s2 = newtag + ","
                                s3 = "," + newtag
                                if tagsconcat.count(s1) == 0:
                                    if not tagsconcat.startswith(s2):
                                        if not tagsconcat.endswith(s3):      # tagsconcat does not already contain the new tag to add, newtag.
                                            if tagsconcat.count(tag_keyword_1) > 0:
                                                if tagsconcat.count(tag_keyword_2) > 0:
                                                    if tagsconcat.count(tag_keyword_3) > 0 or tag_keyword_3 == "none":
                                                        book = int(book)
                                                        s = book,newtag
                                                        candidate_book_newtag_list.append(s)
                                                        candidate_newtag_list.append(newtag)
                                                    else:
                                                        continue
                                                else:
                                                    continue
                                            else:
                                                continue
                                        else:
                                            continue
                                    else:
                                        continue
                                else:
                                    continue
                            #END FOR
                        #END FOR
            else:
                pass
        #---------------------------------
        if len(candidate_book_newtag_list) > 0:
            self.tags_action_message.setText("...STILL WORKING...")
            self.update()
            QApplication.instance().processEvents()
            candidate_newtag_set = set(candidate_newtag_list)  # no duplicates
            my_cursor.execute("begin")
            for newtag in candidate_newtag_set:
                if DEBUG: print("newtag to be added to tags: ", newtag)
                mysql = "INSERT OR IGNORE INTO tags (id,name) VALUES (null,?) "
                my_cursor.execute(mysql,([newtag]))
            #END FOR
            my_cursor.execute("commit")
            del candidate_newtag_set
            my_cursor.execute("begin")
            for row in candidate_book_newtag_list:
                book,newtag = row
                if DEBUG: print("book,newtag to be added to books_tags_link: ", as_unicode(book), as_unicode(newtag))
                mysql = "INSERT OR IGNORE INTO books_tags_link (id,book,tag) VALUES (null,?,(SELECT id FROM tags WHERE name = ?) ) "
                my_cursor.execute(mysql,(book,newtag))
            #END FOR
            my_cursor.execute("commit")
        else:
            if DEBUG: print("[5] empty candidate_book_newtag_list........")
            pass
       #---------------------------------
        del all_target_tag_combination_rules_list
        del all_target_tags_by_book_concat_list
        del candidate_book_newtag_list
        del candidate_newtag_list
        #---------------------------------
        self.empty_table_metadata_dirtied(my_db,my_cursor)
        #---------------------------------
        my_db.close()
        #---------------------------------
        self.force_refresh_of_cache()
        #---------------------------------
        self.tags_action_message.setText("Last Action: Tag Combination Rules Applied to Target")
        self.update()
        QApplication.instance().processEvents()
        #---------------------------------
        self.remove_empty_subdirectories(self.target_db_full_path)    # doing it here guarantees that the current library is the Target Library, and that the path to it has been set properly.
        #---------------------------------
    #-----------------------------------------------------------------------------------------------
    def get_all_target_tags_simple(self,my_db, my_cursor):

        all_target_tags_dict = {}
        #---------------------------------
        mysql = "SELECT id,name from tags"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
       #---------------------------------
        if not tmp_rows:
            pass
        else:
            for row in tmp_rows:
                id,name = row
                all_target_tags_dict[name] = id
            #END FOR
            del tmp_rows
       #---------------------------------
        return all_target_tags_dict

    #-----------------------------------------------------------------------------------------------
    def get_all_target_tags_full(self,guidb):
        if self.current_target_library_is_read_only:
            return
        #---------------------------------
        my_db = guidb
        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')
        try:
            my_db = apsw.Connection(path)
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            raise e
            return

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 2000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)
        #---------------------------------
        all_target_tags_dict = {}
        mysql = "SELECT id,name from tags"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
       #---------------------------------
        if not tmp_rows:
            pass
        else:
            for row in tmp_rows:
                id,name = row
                all_target_tags_dict[name] = id
            #END FOR
            del tmp_rows
       #---------------------------------
        return all_target_tags_dict
    #-----------------------------------------------------------------------------------------------
    def get_tag_rules(self,guidb,action_type):
        if self.current_target_library_is_read_only:
            return
       #---------------------------------
        my_db = guidb
        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata_tools.db')           # this gets the tag rules from the metadata_tools.db, NOT metadata.db!
        path = path.replace(os.sep, '/')
        try:
            my_db = apsw.Connection(path)
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            raise e
            return

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 2000;"      #PRAGMA busy_timeout = milliseconds;  (obviously just for this connection)
        my_cursor.execute(mysql)
       #---------------------------------
        tag_rules_list = []
        if action_type == "purge":
            mysql = "SELECT oldtag,oldtag FROM _tag_rules WHERE purgetag = 1 AND oldtag NOT NULL"
        if action_type == "change":
            mysql = "SELECT oldtag,newtag FROM _tag_rules WHERE purgetag = 0 AND oldtag NOT NULL AND newtag NOT NULL"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
       #---------------------------------
        if not tmp_rows:
            pass
        else:
            for row in tmp_rows:
                tag_rules_list.append(row)
            #END FOR
            del tmp_rows
       #---------------------------------
        my_db.close()
       #---------------------------------
        return tag_rules_list
       #---------------------------------
    #-----------------------------------------------------------------------------------------------
    def refresh_main_tag_rules_tables_from_tools_db(self,my_db,my_cursor,table):
        # copy from metadata_tools.db to metadata.db.
        # these metadata.db tables will be purged afterwards; user must maintain only metadata_tools.db

        self.erase_main_tag_rules_tables(my_db,my_cursor,table)

        my_cursor.execute("begin")
        mysql = "INSERT OR REPLACE INTO main.[TABLE] SELECT * FROM TOOLS.[TABLE] "
        mysql = mysql.replace("[TABLE]",table)
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

    #-----------------------------------------------------------------------------------------------
    def erase_main_tag_rules_tables(self,my_db,my_cursor,table):
        # purge metadata.db tag rules tables after use; user must maintain only metadata_tools.db

        my_cursor.execute("begin")
        mysql = "DELETE FROM [TABLE]"
        mysql = mysql.replace("[TABLE]",table)
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def change_source_tags_to_target_tags(self):
        # Replace Source Library Tags with Target Library Tags [All Sources && All Books]
        if self.current_target_library_is_read_only:
            return

        is_valid_guidb = self.verify_current_guidb_path()
        if is_valid_guidb:
            pass
        else:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is NOT a CALM Target Library')), show=True)
            return

        #---------------------------------
        my_db,my_cursor = self.apsw_connect_to_target()
        if self.current_target_library_is_read_only:
            return
        #---------------------------------
        all_source_library_paths_set = self.get_all_current_source_library_paths_in_target_db(my_db,my_cursor)
        #---------------------------------
        #---------------------------------
        for source in all_source_library_paths_set:
            self.tags_action_message.setText(WORKING_MESSAGE_1)
            self.update()
            QApplication.instance().processEvents()
            self.apsw_attach_to_source(my_db, my_cursor, source)
            self.delete_all_source_tags(my_db,my_cursor,source)
            self.tags_action_message.setText(WORKING_MESSAGE_0)
            self.update()
            QApplication.instance().processEvents()
            self.add_all_new_source_tags(my_db,my_cursor,source)
            self.apsw_detach_from_source(my_db, my_cursor, source)
        #END FOR
        #---------------------------------
        #---------------------------------
        my_db.close()
        #---------------------------------
        #---------------------------------
    #-----------------------------------------------------------------------------------------------
    def delete_all_source_tags(self,my_db,my_cursor,source):
        my_cursor.execute("begin")
        mysql = "DELETE FROM SOURCE.books_tags_link"
        my_cursor.execute(mysql)
        mysql = "DELETE FROM SOURCE.tags"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.5)
    #-----------------------------------------------------------------------------------------------
    def add_all_new_source_tags(self,my_db,my_cursor,source):
        my_cursor.execute("begin")
        mysql = "INSERT OR ABORT INTO SOURCE.tags SELECT null,name FROM main.tags ORDER BY name ASC"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.5)
        my_cursor.execute("begin")
        # the user might have shuffled books around such that the source book still in the target library no longer exists...so check the action_history custom column...
        mysql = "INSERT OR IGNORE INTO SOURCE.books_tags_link SELECT null,\
                                                                                                    (SELECT (make_string_integer(lccn)) \
                                                                                                      FROM main.books  \
                                                                                                      WHERE main.books.id = main.books_tags_link.book \
                                                                                                          AND main.books.isbn = ? ) AS book,\
                                                                                                    (SELECT id \
                                                                                                      FROM SOURCE.tags \
                                                                                                      WHERE SOURCE.tags.name =(SELECT name FROM main.tags WHERE main.tags.id =  main.books_tags_link.tag) ) AS tag \
                                                                                        FROM main.books_tags_link  \
                                                                                        WHERE main.books_tags_link.book IN(SELECT id FROM main.books WHERE main.books.id = main.books_tags_link.book \
                                                                                                                                                                                                         AND isbn = ? ) \
                                                                                            AND main.books_tags_link.book NOT IN(SELECT book from custom_column_11 \
                                                                                                                                                             WHERE custom_column_11.book = main.books_tags_link.book \
                                                                                                                                                                 AND (custom_column_11.value LIKE '%remove%' OR custom_column_11.value LIKE '%delete%') ) \
                                                                                        ORDER BY main.books_tags_link.book,main.books_tags_link.tag  "
        try:
            my_cursor.execute(mysql,(source,source))
        except Exception as e:
            if DEBUG: print(mysql)
            if DEBUG: print("See sql above: ", as_unicode(e))
            if DEBUG: print("source: ",source)

        try:
            mysql = "UPDATE SOURCE.books SET last_modified = CURRENT_TIMESTAMP "
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print(mysql)
            if DEBUG: print("See sql above: ", as_unicode(e))

        try:
            my_cursor.execute("commit")  #no hanging transactions
        except:
            pass
        sleep(0.5)
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def derive_genres(self):
        if self.current_target_library_is_read_only:
            return

        is_valid_guidb = self.verify_current_guidb_path()
        if is_valid_guidb:
            pass
        else:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is NOT a CALM Target Library')), show=True)
            return
        if DEBUG: print("in Tools Tab derive_genres")
        self.execute_calm_derivegenres()     # from the parent tab using its objects not available in this tab
        self.genre_action_message.setText("Last Action:  Derive Genres Job Submitted.")
        self.update()
        QApplication.instance().processEvents()
        self.remove_empty_subdirectories(self.target_db_full_path)   # while job is running anyway...
    #-----------------------------------------------------------------------------------------------
    def copy_target_genres_to_sources(self):

        if self.current_target_library_is_read_only:
            return

        is_valid_guidb = self.verify_current_guidb_path()
        if is_valid_guidb:
            pass
        else:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is NOT a CALM Target Library')), show=True)
            return

        self.genre_action_message.setText(WORKING_MESSAGE_0)
        self.update()
        QApplication.instance().processEvents()

        #---------------------------------
        # Replace Source Library Genres with Target Library Genres [All Sources && All Books]
        #---------------------------------
        my_db,my_cursor = self.apsw_connect_to_target()
        #---------------------------------
        all_source_library_paths_set = self.get_all_current_source_library_paths_in_target_db(my_db,my_cursor)
        #---------------------------------
        #---------------------------------
        for source in all_source_library_paths_set:
            self.apsw_attach_to_source(my_db, my_cursor, source)
            is_valid,custom_table,custom_link_table = self.get_source_custom_column_table_id_for_genre(my_db, my_cursor,source)
            if is_valid:
                self.genre_action_message.setText(WORKING_MESSAGE_1)
                self.update()
                QApplication.instance().processEvents()
                self.delete_all_source_genres(my_db,my_cursor,source,custom_table,custom_link_table)
                self.add_all_new_source_genres(my_db,my_cursor,source,custom_table,custom_link_table)
                self.genre_action_message.setText(WORKING_MESSAGE_0)
                self.update()
                QApplication.instance().processEvents()
            self.apsw_detach_from_source(my_db, my_cursor, source)
        #END FOR
        #---------------------------------
        #---------------------------------
        my_db.close()
        #---------------------------------
        #---------------------------------
        self.genre_action_message.setText("Last Action: Source Genres Replaced with Target Genres")
        self.update()
        QApplication.instance().processEvents()
    #-----------------------------------------------------------------------------------------------
    def get_source_custom_column_table_id_for_genre(self,my_db, my_cursor,source):

        custom_table = 'custom_column_[N]'
        custom_link_table = 'books_custom_column_[N]_link'
        is_valid = True

        source_genre_custom_column_ids_list = []
        mysql = "SELECT id, label FROM SOURCE.custom_columns WHERE (label LIKE '%genre%' AND name LIKE '%genre%') AND datatype = 'text' AND normalized = 1 "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            if DEBUG: print("ERROR:  Missing or Ambiguous Source Custom Column for Genre:  ", source )
            msg = "ERROR:  Missing or Ambiguous Source Custom Column for Genre:  " +  source
            is_valid = False
        else:
            if len(tmp_rows) == 0:
                if DEBUG: print("ERROR:  Missing or Ambiguous Source Custom Column for Genre:  ", source )
                msg = "ERROR:  Missing or Ambiguous Source Custom Column for Genre:  " +  source
                is_valid = False
            else:
                for row in tmp_rows:
                    id,label = row
                    source_genre_custom_column_ids_list.append(id)
                #END FOR
                del tmp_rows
                if len(source_genre_custom_column_ids_list) != 1 :
                    if DEBUG: print("ERROR:  Multiple Source Custom Columns for Genre:  ", source )
                    msg = "ERROR:  Multiple Source Custom Columns for Genre:  " +  source
                    is_valid = False
                else:
                    table_id = source_genre_custom_column_ids_list[0]
                    try:
                        table_id = int(table_id)
                        table_id = as_unicode(table_id)
                        if DEBUG: print("Source Custom Column Table ID for Genre Found:  ", table_id, " for  ", source )
                        custom_table = custom_table.replace("[N]",table_id)
                        custom_link_table = custom_link_table.replace("[N]",table_id)
                    except:
                        if DEBUG: print("ERROR:  Missing or Ambiguous Source Custom Column for Genre:  ", source )
                        msg = "ERROR:  Missing or Ambiguous Source Custom Column for Genre:  " +  source
                        is_valid = False

        if custom_table.count("[N]") > 0 or custom_link_table.count("[N]") > 0 :
            is_valid = False

        if not is_valid:
            error_dialog(self.gui, _('CALM'),_((msg)), show=True)

        return is_valid,custom_table,custom_link_table
    #-----------------------------------------------------------------------------------------------
    def delete_all_source_genres(self,my_db,my_cursor,source,custom_table,custom_link_table):

        mysql1 = "DELETE FROM SOURCE.[CUSTOM_LINK_TABLE] ;"
        mysql1 = mysql1.replace("[CUSTOM_LINK_TABLE]",custom_link_table)
        my_cursor.execute("begin")
        my_cursor.execute(mysql1)
        my_cursor.execute("commit")

        mysql2 = "DELETE FROM SOURCE.[CUSTOM_TABLE] ;"
        mysql2 = mysql2.replace("[CUSTOM_TABLE]",custom_table)
        my_cursor.execute("begin")
        my_cursor.execute(mysql2)
        my_cursor.execute("commit")

        if DEBUG: print("All Source Genres have been deleted for: ", source, custom_table, custom_link_table)

    #-----------------------------------------------------------------------------------------------
    def add_all_new_source_genres(self,my_db,my_cursor,source,custom_table,custom_link_table):

        mysql = "INSERT OR ABORT INTO SOURCE.[CUSTOM_TABLE] SELECT null,value FROM main.custom_column_14 ORDER BY value ASC"
        mysql = mysql.replace("[CUSTOM_TABLE]",custom_table)
        my_cursor.execute("begin")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        sleep(0.5)
        # the user might have shuffled books around such that the source book still in the target library no longer exists...so check the action_history custom column...
        mysql = "INSERT OR ABORT INTO SOURCE.[CUSTOM_LINK_TABLE] SELECT null,\
                                                                                                    (SELECT (make_string_integer(lccn)) \
                                                                                                      FROM main.books  \
                                                                                                      WHERE main.books.id = main.books_custom_column_14_link.book \
                                                                                                          AND main.books.isbn = ? ) AS book,\
                                                                                                    (SELECT id \
                                                                                                      FROM SOURCE.[CUSTOM_TABLE] \
                                                                                                      WHERE SOURCE.[CUSTOM_TABLE].value =(SELECT value FROM main.custom_column_14 \
                                                                                                                                                                          WHERE main.custom_column_14.id =  main.books_custom_column_14_link.value) ) AS value \
                                                                                        FROM main.books_custom_column_14_link  \
                                                                                        WHERE main.books_custom_column_14_link.book IN(SELECT id FROM main.books WHERE main.books.id = main.books_custom_column_14_link.book \
                                                                                                                                                                                                         AND isbn = ? )\
                                                                                            AND main.books_custom_column_14_link.book NOT IN(SELECT book from main.custom_column_11 \
                                                                                                                                                             WHERE main.custom_column_11.book = main.books_custom_column_14_link.book \
                                                                                                                                                                 AND (main.custom_column_11.value LIKE '%remove%' OR main.custom_column_11.value LIKE '%delete%') ) \
                                                                                        ORDER BY main.books_custom_column_14_link.book "

        mysql = mysql.replace("[CUSTOM_TABLE]",custom_table)
        mysql = mysql.replace("[CUSTOM_LINK_TABLE]",custom_link_table)

        my_cursor.execute("begin")
        my_cursor.execute(mysql,(source,source))      #  target books.isbn was repurposed as original source library path, just as lccn was repurposed as original source book id.
        mysql = "UPDATE SOURCE.books SET last_modified = CURRENT_TIMESTAMP "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        sleep(0.5)


    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def delete_target_identifiers(self):

        if self.current_target_library_is_read_only:
            return

        is_valid_guidb = self.verify_current_guidb_path()
        if is_valid_guidb:
            pass
        else:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is NOT a CALM Target Library')), show=True)
            return

        self.identifiers_action_message.setText("Deleting Non-Library Codes Identifiers in Target Library")
        self.update()
        QApplication.instance().processEvents()
        #---------------------------------
        my_db = self.guidb
        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')

        self.target_db_full_path = path

        try:
            my_db = apsw.Connection(path)
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            raise e
            return

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 2000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)
        #---------------------------------
        my_cursor.execute("begin")
        #~ mysql = as_unicode("DELETE FROM identifiers WHERE (type != 'isbn') AND (type != 'oclc-owi') AND (type != 'issn');")
        mysql = as_unicode("DELETE FROM identifiers \
                                        WHERE (type != 'isbn') \
                                        AND (type != 'oclc-owi') \
                                        AND (type != 'issn') \
                                        AND (type != 'isni')\
                                        AND (type != 'lccn')\
                                        AND (type != 'loc_lccn')\
                                        AND (type != 'viaf_author_id')\
                                        AND (type != 'lc_authority_name')\
                                        AND (type != 'doi')\
                                        AND (type NOT LIKE 'z%')\
                                        AND (type != 'oclc');")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        #---------------------------------
        self.empty_table_metadata_dirtied(my_db,my_cursor)
        #---------------------------------
        my_db.close()
        #---------------------------------
        self.force_refresh_of_cache()
        #---------------------------------
        self.identifiers_action_message.setText("Last Action: Deleted Non-Library Codes Identifiers in Target Library")
        self.update()
        QApplication.instance().processEvents()
        self.remove_empty_subdirectories(self.target_db_full_path)    # doing it here guarantees that the current library is the Target Library, and that the path to it has been set properly.
    #-----------------------------------------------------------------------------------------------
    def delete_source_identifiers(self):
        if self.current_target_library_is_read_only:
            return

        is_valid_guidb = self.verify_current_guidb_path()
        if is_valid_guidb:
            pass
        else:
            error_dialog(self.gui, _('CALM'),_(('Current Calibre Library is NOT a CALM Target Library')), show=True)
            return

        self.identifiers_action_message.setText("Deleting Non-Library Codes Identifiers from All Source Libraries")
        self.update()
        QApplication.instance().processEvents()
        #---------------------------------
        my_db = self.guidb
        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')
        try:
            my_db = apsw.Connection(path)
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            raise e
            return

        my_cursor = my_db.cursor()
        #---------------------------------
        mysql = "PRAGMA main.busy_timeout = 2000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)
        #---------------------------------
        # many standard triggers call this user function:
        title_pat = re.compile('^(A|The|An)\s+', re.IGNORECASE)
        def title_sort(title):
            match = title_pat.search(title)
            if match:
                prep = match.group(1)
                title = title.replace(prep, '') + ', ' + prep
            return title.strip()
        my_db.createscalarfunction('title_sort', title_sort,1)
        #---------------------------------
        # standard book triggers call this user function:
        def uuid4():
            return as_unicode(uuid.uuid4())
        my_db.createscalarfunction('uuid4', uuid4, 0)
        #---------------------------------
        #---------------------------------
        all_source_library_paths_set = self.get_all_current_source_library_paths_in_target_db(my_db,my_cursor)
        #---------------------------------
        #---------------------------------
        for source in all_source_library_paths_set:
            self.apsw_attach_to_source(my_db, my_cursor, source)
            my_cursor.execute("begin")
            mysql = "UPDATE SOURCE.books SET last_modified = CURRENT_TIMESTAMP \
                            WHERE SOURCE.books.id IN(SELECT book FROM SOURCE.identifiers \
                                                                                              WHERE book = SOURCE.books.id \
                                                                                                  AND (SOURCE.identifiers.type != 'isbn') AND (SOURCE.identifiers.type != 'oclc-owi') AND (SOURCE.identifiers.type != 'issn')  ) ; "
            my_cursor.execute(mysql)
            #~ mysql = "DELETE FROM SOURCE.identifiers WHERE (type != 'isbn') AND (type != 'oclc-owi') AND (type != 'issn');"
            mysql = as_unicode("DELETE FROM identifiers \
                                            WHERE (type != 'isbn') \
                                            AND (type != 'oclc-owi') \
                                            AND (type != 'issn') \
                                            AND (type != 'isni')\
                                            AND (type != 'lccn')\
                                            AND (type != 'viaf_author_id')\
                                            AND (type != 'lc_authority_name')\
                                            AND (type != 'oclc');")
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            self.apsw_detach_from_source(my_db, my_cursor, source)
        #END FOR
        #---------------------------------
        #---------------------------------
        my_db.close()
        #---------------------------------
        #---------------------------------
        self.identifiers_action_message.setText("Last Action: Deleted Non-Library Codes Identifiers from All Source Libraries")
        self.update()
        QApplication.instance().processEvents()
        #---------------------------------
    #-----------------------------------------------------------------------------------------------
    def get_all_current_source_library_paths_in_target_db(self,my_db,my_cursor):
        all_source_library_paths_list = []
        mysql = "SELECT value FROM custom_column_6 WHERE (value LIKE '%/%' AND value NOT NULL)  GROUP BY value ORDER BY value ;"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            pass
        else:
            for row in tmp_rows:
                for col in row:
                    full_path = col + 'metadata.db'
                    all_source_library_paths_list.append(full_path)
                #END FOR
            #END FOR
            del tmp_rows
        all_source_library_paths_set = set(all_source_library_paths_list)
        del all_source_library_paths_list
        return all_source_library_paths_set

    #--------------------------------------------------------------------------------------------------
    def check_for_read_only_status(self):

        self.target_db = self.myparentprefs['CALM_TARGET_DB_FULL_PATH']

        path = self.target_db
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')

        my_db = self.guidb

        lib_path = my_db.library_path

        if isbytestring(lib_path):
            lib_path = lib_path.decode(filesystem_encoding)
        lib_path = lib_path.replace(os.sep, '/')

        if DEBUG: print("my_db.library_path: ", lib_path)         #   X:/CALM
        if DEBUG: print("self.target_db: ", path)                       #   X:/CALM/metadata.db

        if not path.count(lib_path) > 0:   # user keeps multiple  /CALM/metadata.db libraries, but only the last one generated is NOT read-only...
            self.current_target_library_is_read_only = True

    #--------------------------------------------------------------------------------------------------
    def apsw_attach_to_source(self,my_db, my_cursor,path):

        if self.current_target_library_is_read_only:
            return

        s1 = "ATTACH DATABASE '"
        s2 =  "'  AS 'SOURCE' ;"

        path = path.replace(os.sep, '/')
        if isbytestring(path):
            if DEBUG: print("path isbytestring: ", path)
            path = path.decode(filesystem_encoding)
            if DEBUG: print("path = path.decode(filesystem_encoding): decoded path is now: ", path)
        if DEBUG: print("filesystem_encoding is: ", str(filesystem_encoding))

        mysql = s1 + path + s2

        try:
            if DEBUG: print("Attaching to New Source Library: " + path)
            my_cursor.execute (mysql)
            mysql = "PRAGMA SOURCE.busy_timeout = 2000;"      #PRAGMA busy_timeout = milliseconds;
            my_cursor.execute(mysql)
        except Exception as e:
            if DEBUG: print("NOT Attached: " + as_unicode(path))
            if DEBUG: print(as_unicode(e))
            raise e
            return
    #--------------------------------------------------------------------------------------------------
    def apsw_detach_from_source(self,my_db, my_cursor,path):
        try:
            mysql = "DETACH 'SOURCE'"
            my_cursor.execute (mysql)
            if DEBUG: print("Previously Attached Source Library Detached: " + as_unicode(path))
        except Exception as e:
            if DEBUG: print("NOT Detached: " + as_unicode(path))
            if DEBUG: print(as_unicode(e))
            raise e
            return
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def apsw_connect_to_target(self):
        if self.current_target_library_is_read_only:
            return

        self.target_db = self.myparentprefs['CALM_TARGET_DB_FULL_PATH']

        path = self.target_db
        path = path.replace(os.sep, '/')
        if isbytestring(path):
            if DEBUG: print("path isbytestring: ", path)
            path = path.decode(filesystem_encoding)
            if DEBUG: print("path = path.decode(filesystem_encoding): decoded path is now: ", path)
        if DEBUG: print("filesystem_encoding is: ", str(filesystem_encoding))

        self.target_db_full_path = path

        try:
            my_db =apsw.Connection(path)
        except Exception as e:
            if DEBUG: print("apsw_connect_to_target:  target_db_full_path: ", path)
            if DEBUG: print("error: ", as_unicode(e))
            if DEBUG: print(ERROR_MESSAGE_METADATA_TOOLS_DB_FILE_IS_MISSING)
            for k,v in iteritems(prefs.defaults):
                prefs[k] = v
            #END FOR
            prefs
            return

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 5000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        # many standard triggers call this user function:
        title_pat = re.compile('^(A|The|An)\s+', re.IGNORECASE)
        def title_sort(title):
            match = title_pat.search(title)
            if match:
                prep = match.group(1)
                title = title.replace(prep, '') + ', ' + prep
            return title.strip()
        my_db.createscalarfunction('title_sort', title_sort,1)

        # standard book triggers call this user function:
        def uuid4():
            return as_unicode(uuid.uuid4())
        my_db.createscalarfunction('uuid4', uuid4, 0)

        # for calm_main and calm_dialog only
        def make_string_integer(s):
            try:
                s = as_unicode(s)
                s = as_unicode(s.strip())
                n = int(s)
                return n
            except:
                return s
        my_db.createscalarfunction('make_string_integer', make_string_integer, 1)

        self.remove_empty_subdirectories(self.target_db_full_path)   # doing it here guarantees that the current library is the Target Library, and that the path to it has been set properly.

        return my_db,my_cursor
    #-----------------------------------------------------------------------------------------------
    def apsw_attach_to_tools_db(self,my_db,my_cursor):

        s1 = "ATTACH DATABASE '"
        s2 =  "'  As 'TOOLS' ;"

        path = self.target_db
        path = path.replace("metadata.db","metadata_tools.db")
        path = path.replace(os.sep, '/')
        if isbytestring(path):
            if DEBUG: print("path isbytestring: ", path)
            path = path.decode(filesystem_encoding)
            if DEBUG: print("path = path.decode(filesystem_encoding): decoded path is now: ", path)
        if DEBUG: print("filesystem_encoding is: ", str(filesystem_encoding))

        mysql = s1 + path + s2

        try:
            if DEBUG: print("Attaching to Tools DB: " + path)
            my_cursor.execute (mysql)
            mysql = "PRAGMA TOOLS.busy_timeout = 5000;"      #PRAGMA busy_timeout = milliseconds;
            my_cursor.execute(mysql)
        except Exception as e:
            if DEBUG: print("NOT Attached: " + as_unicode(path))
            if DEBUG: print(as_unicode(e))
            raise e
            return

        mysql = "PRAGMA TOOLS.user_version;  "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        for row in tmp_rows:
            for col in row:
                schema_user_version = col
        if as_unicode(schema_user_version) != MOST_CURRENT_VERSION_OF_METADATA_TOOLS:
            if DEBUG: print("BEFORE schema_user_version: ", as_unicode(schema_user_version))
            type = "ATTACHED"
            self.create_new_sqlite_objects_in_tools_db(my_db,my_cursor,type)
            mysql = "PRAGMA TOOLS.user_version = [N] ;  "
            mysql = mysql.replace("[N]",as_unicode(MOST_CURRENT_VERSION_OF_METADATA_TOOLS))
            my_cursor.execute(mysql)
            mysql = "PRAGMA TOOLS.user_version;  "
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            for row in tmp_rows:
                for col in row:
                    schema_user_version = col
            if DEBUG: print("AFTER schema_user_version: ", as_unicode(schema_user_version))
        else:
            pass

       #---------------------------------
    #--------------------------------------------------------------------------------------------------
    def apsw_detach_from_tools_db(self,my_db, my_cursor):

        # note:  the metadata_tools.db in the .zip already includes a template SQLITE_STAT1 table that was manually pre-populated from an actual metadata_tools.db that was fully exercised.
        try:
            my_cursor.execute("ANALYZE TOOLS")  # https://sqlite.org/lang_analyze.html
        except Exception as e:
            if DEBUG: print('[metadata_tools.db] my_cursor("ANALYZE")', as_unicode(e))
            pass

        try:
            mysql = "DETACH 'TOOLS'"
            my_cursor.execute (mysql)
            if DEBUG: print("TOOLS DB Detached")
        except Exception as e:
            if DEBUG: print("TOOLS DB NOT Detached")
            if DEBUG: print(as_unicode(e))
            raise e
            return
    #--------------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def return_latest_tools_prefs(self,prefs_to_change):
        if not self.toolsprefs:
            self.toolsprefs = {}
            return prefs_to_change

        self.save_real_prefs_tools()

        #~ for k,v in self.toolsprefs.iteritems():
        for k,v in iteritems(self.toolsprefs):
            prefs_to_change[k] = v
        return prefs_to_change
    #-----------------------------------------------------------------------------------------------
    def save_real_prefs_tools(self):
        if not self.toolsprefs:
            self.toolsprefs = {}
            return

        #~ for k,v in self.toolsprefs.iteritems():
        for k,v in iteritems(self.toolsprefs):
            prefs[k] = v
        prefs
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def force_refresh_of_cache(self):
        db = self.maingui.current_db.new_api
        frozen = db.all_book_ids()
        books = list(frozen)
        db.reload_from_db(clear_caches=False)
        self.maingui.library_view.model().refresh_ids(books)
        self.maingui.tags_view.recount()
    #--------------------------------------------------------------------------------------------------
    def empty_table_metadata_dirtied(self,my_db,my_cursor):
        #---------------------------------
        my_cursor.execute("begin")
        mysql = "DELETE FROM metadata_dirtied"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        #---------------------------------
    #--------------------------------------------------------------------------------------------------
    def remove_empty_subdirectories(self,target_db_full_path):
        # ONLY for use on the Target Library path, '/CALM/...'

        # Delete everything reachable from the directory named in "top", assuming there are no symbolic links.
        # CAUTION:  This is dangerous!  For example, if top == '/', it could delete all your disk files.

        #  os.walk(top, topdown=True, onerror=None, followlinks=False)

        #~ return   # Standard Calibre keeps recreating them no matter how often they are removed unless Target.metadata_dirtied is emptied often.

        if self.current_target_library_is_read_only:
            return

        if not target_db_full_path:
            return
        if len(target_db_full_path) < 18:
            return
        sl = target_db_full_path.lower()
        if sl.count("calm") == 0:
            return

        top = target_db_full_path.replace("/metadata.db","")
        if DEBUG: print("Directory of Target Library: " + top)

        if not top == '/':
            if not top == '\\':
                for root, dirs, files in os.walk(top, topdown=False, followlinks=False):
                    for name in files:
                        if not 'metadata.db' in name:
                            if not '.json' in name:
                                if not 'tools.db' in name:
                                    try:
                                        os.remove(os.path.join(root, name))
                                        #~ if DEBUG: print(root,name)
                                    except Exception as e:
                                        if DEBUG: print(as_unicode(e))
                                        pass
                    for name in dirs:
                        if not top == '/':
                            if not top == '\\':
                                if not name == '/':
                                    if not name == '\\':
                                        if not 'CALM' in name:
                                            if not 'Calm' in name:
                                                if not 'calm' in name:
                                                    if name != top:
                                                        try:
                                                            os.rmdir(os.path.join(root, name))
                                                            #~ if DEBUG: print(root,name)
                                                        except Exception as e:
                                                            if DEBUG: print(as_unicode(e))
                                                            pass
            else:
                return
        else:
            return
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def build_regex_list_from_tag_capitalization_rules(self,my_db, my_cursor):

        if not self.tag_capitalization_regex_rules:
            self.tag_capitalization_regex_rules = []

        mysql = "SELECT regex,rule,priority FROM _tag_capitalization_rules WHERE regex NOT NULL \
                        AND rule NOT NULL AND priority NOT NULL  AND regex NOT LIKE '%,%'   "
        my_cursor.execute(mysql)
        tmp_rule_list = my_cursor.fetchall()
        if not tmp_rule_list:
              return
        else:
            if len(tmp_rule_list) == 0:
                self.tag_capitalization_regex_rules.append(as_unicode("^DELETE$"))
                return
            else:
                for item in tmp_rule_list:
                    regex, rule, priority = item
                    s1 = as_unicode(regex)
                    s2 = as_unicode(rule)
                    s3 = as_unicode(priority)
                    s3 = as_unicode("000" + as_unicode(s3))
                    s3 = as_unicode(s3[-3: ])
                    new_row = as_unicode(as_unicode(s3) + "<|!!|>" + as_unicode(s1) + "<|!!|>" + as_unicode(s2))        #priority is first for sorting
                    self.tag_capitalization_regex_rules.append(as_unicode(new_row))
                #END FOR

        self.tag_capitalization_regex_rules.sort(reverse=True)    #sort by priority descending

        #~ n = len(self.tag_capitalization_regex_rules)
        #~ if DEBUG: print("Number of Tag Capitalization Rules:" + as_unicode(n))
    #-------------------------------------------------------------------------------------------------------------------------------
    def apply_tag_capitalization_rules_to_single_tag(self,tmp_tag):
        for row in self.tag_capitalization_regex_rules:
            rule_list = row.split("<|!!|>")  #     row ==   priority<|!!|>regex<|!!|>rule
            priority = as_unicode(rule_list[0])
            re1 = as_unicode(rule_list[1])
            rule = as_unicode(rule_list[2])
            try:
                p1 = re.compile(re1, re.IGNORECASE)
                match1 = p1.search(tmp_tag)
                if match1:
                    if as_unicode(rule) == as_unicode("titlecase"):
                        tmp_tag = re.sub(re1, self.do_titlecase, tmp_tag, count=0, flags=re.IGNORECASE)
                        continue
                    else:
                        if as_unicode(rule) == as_unicode("uppercase"):
                            tmp_tag = re.sub(re1, self.do_uppercase, tmp_tag, count=0, flags=re.IGNORECASE)
                            continue
                        else:
                            if as_unicode(rule) == as_unicode("lowercase"):
                                tmp_tag = re.sub(re1, self.do_lowercase, tmp_tag, count=0, flags=re.IGNORECASE)
                                continue
                            else:
                                if as_unicode(rule) == as_unicode("delete"):
                                    tmp_tag = re.sub(re1, self.do_delete, tmp_tag, count=0, flags=re.IGNORECASE)
                                    continue
                                else:
                                    if as_unicode(rule) == as_unicode("addspace_left"):
                                        tmp_tag = re.sub(re1, self.do_addspace_left, tmp_tag, count=0, flags=re.IGNORECASE)
                                        continue
                                    else:
                                        if as_unicode(rule) == as_unicode("addspace_right"):
                                            tmp_tag = re.sub(re1, self.do_addspace_right, tmp_tag, count=0, flags=re.IGNORECASE)
                                            continue
                                        else:
                                            continue
                else:
                    continue
            except Exception as e:
                try:
                    if DEBUG: print("Table _tag_capitalization_rules REGEX Rule Issue: " + as_unicode(e))
                    if DEBUG: print("REGEX rule was:" + as_unicode(re1) + "  Work Tag was: " + as_unicode(tmp_tag)  )
                except:
                    pass
                continue
        #END FOR
        return tmp_tag
    #-------------------------------------------------------------------------------------------------------------------------------
    def do_titlecase(self,matchobj):

        s = ""

        if matchobj.group(0):
            s = matchobj.group(0)
            #if DEBUG: print("s was (0): ", as_unicode(s))

        s = s.title()

        #if DEBUG: print("s is now: " + as_unicode(s))

        return s
    #-------------------------------------------------------------------------------------------------------------------------------
    def do_uppercase(self,matchobj):

        s = ""

        if matchobj.group(0):
            s = matchobj.group(0)
            #if DEBUG: print("s was (0): ", as_unicode(s))

        s = s.upper()

        #if DEBUG: print("s is now: " + as_unicode(s))

        return s
    #-------------------------------------------------------------------------------------------------------------------------------
    def do_lowercase(self,matchobj):

        s = ""

        if matchobj.group(0):
            s = matchobj.group(0)
            #if DEBUG: print("s was (0): ", as_unicode(s))

        s = s.lower()

        #if DEBUG: print("s is now: " + as_unicode(s))

        return s
    #-------------------------------------------------------------------------------------------------------------------------------
    def do_delete(self,matchobj):

        s = ""

        #if DEBUG: print("s is now: " + as_unicode(s))

        return s
    #-------------------------------------------------------------------------------------------------------------------------------
    def do_addspace_left(self,matchobj):

        s = ""

        if matchobj.group(0):
            s = matchobj.group(0)
            #if DEBUG: print("s was (0): ", as_unicode(s))

        s = " " + s

        #if DEBUG: print("s is now: " + as_unicode(s))

        return s
    #-------------------------------------------------------------------------------------------------------------------------------
    def do_addspace_right(self,matchobj):

        s = ""

        if matchobj.group(0):
            s = matchobj.group(0)
            #if DEBUG: print("s was (0): ", as_unicode(s))

        s =  s + " "

        #if DEBUG: print("s is now: " + as_unicode(s))

        return s
    #-------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------------------------------------------------------------------
    def copy_target_custom_columns_to_sources_control(self):
        label = self.custom_columns_combobox.currentText()
        if not label > " ":
            return
        else:
            if not question_dialog(self.gui, _('CALM - Custom Column Metadata Tool.'),_('Are you sure?')) :
                return

        label = label.replace("#","")
        label = as_unicode(label.strip())

        msg = WORKING_MESSAGE_1
        self.custom_columns_action_message.setText(msg)
        self.update()
        QApplication.instance().processEvents()

        my_db, my_cursor = self.apsw_connect_to_target()
        self.apsw_attach_to_tools_db(my_db,my_cursor)

        mysql = "SELECT  source_library,source_library_cc_id,target_cc_id,\
                        (SELECT source_library_cc_datatype FROM TOOLS._source_library_custom_columns WHERE source_library = TOOLS._source_cc_to_target_cc_mapping.source_library AND source_library_cc_id = TOOLS._source_cc_to_target_cc_mapping.source_library_cc_id) AS source_library_cc_datatype ,\
                        (SELECT source_library_cc_normalized FROM TOOLS._source_library_custom_columns WHERE source_library = TOOLS._source_cc_to_target_cc_mapping.source_library AND source_library_cc_id = TOOLS._source_cc_to_target_cc_mapping.source_library_cc_id) AS source_library_cc_normalized \
                        FROM TOOLS._source_cc_to_target_cc_mapping \
                        WHERE target_cc_label = ? AND target_cc_id > 16 "
        my_cursor.execute(mysql,([label]))
        self.target_to_source_cc_mappings = my_cursor.fetchall()
        if not self.target_to_source_cc_mappings:
            self.target_to_source_cc_mappings = []
        if len(self.target_to_source_cc_mappings) == 0:
            self.target_library_is_corrupt = True
        else:
            self.target_library_is_corrupt = False

        self.apsw_detach_from_tools_db(my_db, my_cursor)

        i = 0
        for row in self.target_to_source_cc_mappings:
            source_library,source_library_cc_id,target_cc_id,source_library_cc_datatype,source_library_cc_normalized = row
            if i == 0:
                msg = WORKING_MESSAGE_0
                i = 1
            else:
                msg = WORKING_MESSAGE_1
                i = 0
            self.custom_columns_action_message.setText(msg)
            self.update()
            QApplication.instance().processEvents()
            self.copy_target_cc_to_source_cc(my_db,my_cursor,target_cc_id,source_library,source_library_cc_id,source_library_cc_datatype,source_library_cc_normalized)
        #END FOR

        my_db.close()

        msg = "Last Action: Completed Copying Target to Source for:  " + label
        self.custom_columns_action_message.setText(msg)
        self.update()
        QApplication.instance().processEvents()

        if self.target_library_is_corrupt:
            msg = ERROR_MESSAGE_TARGET_LIBRARY_CUSTOM_COLUMN_NEVER_GENERATED + "<br><br>Custom Column in Error: " + label + "<br><br>If you did not manually create it here, then you should Refresh this Target Library.<br><br>Be sure to standardize your Custom Columns among all of your Calibre Libraries."
            error_dialog(self.gui, _('CALM'),_((msg)), show=True)

    #-------------------------------------------------------------------------------------------------------------------------------
    def copy_target_cc_to_source_cc(self,my_db,my_cursor,target_cc_id,source_library,source_library_cc_id,source_library_cc_datatype,source_library_cc_normalized):
        path = source_library + "/metadata.db"
        self.apsw_attach_to_source(my_db, my_cursor,path)
        if source_library_cc_normalized == 1:
            self.update_source_cc_normalized(my_db, my_cursor,target_cc_id,source_library,source_library_cc_id,source_library_cc_datatype,source_library_cc_normalized)
        else:
            self.update_source_cc_not_normalized(my_db, my_cursor,target_cc_id,source_library,source_library_cc_id,source_library_cc_datatype,source_library_cc_normalized)
        try:
            my_cursor.execute("commit")
        except:
            pass
        self.apsw_detach_from_source(my_db, my_cursor,path)
    #-------------------------------------------------------------------------------------------------------------------------------
    def update_source_cc_normalized(self,my_db,my_cursor,target_cc_id,source_library,source_library_cc_id,source_library_cc_datatype,source_library_cc_normalized):

        if not source_library.endswith("/"):
            source_library = source_library + "/"

        s = as_unicode(target_cc_id)
        target_custom_column_N = "custom_column_[N]".replace("[N]",s)
        target_books_custom_column_N_link = "books_custom_column_[N]_link".replace("[N]",s)

        #~ if DEBUG: print(target_custom_column_N,target_books_custom_column_N_link )

        s = as_unicode(source_library_cc_id)
        source_custom_column_N = "custom_column_[N]".replace("[N]",s)
        source_books_custom_column_N_link = "books_custom_column_[N]_link".replace("[N]",s)

        #~ if DEBUG: print(source_custom_column_N,source_books_custom_column_N_link)

        mysql = "DELETE FROM SOURCE.[SOURCE_CUSTOM_COLUMN_N]"
        mysql = mysql.replace("[SOURCE_CUSTOM_COLUMN_N]",source_custom_column_N)
        #~ if DEBUG: print(mysql)
        my_cursor.execute("begin")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        mysql = "DELETE FROM SOURCE.[SOURCE_CUSTOM_COLUMN_N]"
        mysql = mysql.replace("[SOURCE_CUSTOM_COLUMN_N]",source_books_custom_column_N_link)
        #~ if DEBUG: print(mysql)
        my_cursor.execute("begin")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        mysql = "INSERT OR IGNORE INTO SOURCE.[SOURCE_CUSTOM_COLUMN_N] SELECT * FROM main.[TARGET_CUSTOM_COLUMN_N] WHERE value NOT NULL"
        mysql = mysql.replace("[SOURCE_CUSTOM_COLUMN_N]",source_custom_column_N)
        mysql = mysql.replace("[TARGET_CUSTOM_COLUMN_N]",target_custom_column_N)
        #~ if DEBUG: print(mysql)
        my_cursor.execute("begin")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        if DEBUG: print("source_library: ", source_library)   #upper/lower case differences...view has the real spelling...calm is always all lower case...
        mysql = "SELECT target_id, orig_source_id FROM __book_original_source_paths WHERE lower(orig_source_library) =  ? AND target_id NOT NULL AND orig_source_id NOT NULL"
        my_cursor.execute(mysql,([source_library]))
        tmp_rows1 = my_cursor.fetchall()
        if not tmp_rows1:
            return
        my_cursor.execute("begin")
        for row in tmp_rows1:
            target_id, orig_source_id = row
            if not orig_source_id:
                continue
            if not target_id:
                continue
            #~ if DEBUG: print(as_unicode(target_id), as_unicode(orig_source_id))
            if source_library_cc_datatype != "series":
                mysql = "SELECT id,value FROM main.[TARGET_CUSTOM_COLUMN_N] WHERE id = (SELECT value FROM main.[TARGET_BOOKS_CUSTOM_COLUMN_N_LINK] WHERE book = ?) "
                mysql = mysql.replace("[TARGET_CUSTOM_COLUMN_N]",target_custom_column_N)
                mysql = mysql.replace("[TARGET_BOOKS_CUSTOM_COLUMN_N_LINK]",target_books_custom_column_N_link)
                #~ if DEBUG: print(mysql)
                my_cursor.execute(mysql,([target_id]))
                tmp_rows2 = my_cursor.fetchall()
                if not tmp_rows2:
                    return
                for item in tmp_rows2:
                    dummy,target_value = item
                    if not target_value:
                        continue
                    #~ if DEBUG: print("data: ", source_books_custom_column_N_link,as_unicode(orig_source_id),source_custom_column_N,target_value)
                    mysql = "INSERT OR IGNORE INTO SOURCE.[SOURCE_BOOKS_CUSTOM_COLUMN_N_LINK] SELECT NULL,?,(SELECT id FROM SOURCE.[SOURCE_CUSTOM_COLUMN_N] WHERE SOURCE.[SOURCE_CUSTOM_COLUMN_N].value = ?  )  "
                    mysql = mysql.replace("[SOURCE_BOOKS_CUSTOM_COLUMN_N_LINK]",source_books_custom_column_N_link)
                    mysql = mysql.replace("[SOURCE_CUSTOM_COLUMN_N]",source_custom_column_N)
                    #~ if DEBUG: print(mysql)
                    my_cursor.execute(mysql,(orig_source_id,target_value))
                #END FOR
                del tmp_rows2
            else:
                mysql = "SELECT id,value FROM [TARGET_CUSTOM_COLUMN_N] WHERE id = (SELECT value FROM [TARGET_BOOKS_CUSTOM_COLUMN_N_LINK] WHERE book = ?) "
                mysql = mysql.replace("[TARGET_CUSTOM_COLUMN_N]",target_custom_column_N)
                mysql = mysql.replace("[TARGET_BOOKS_CUSTOM_COLUMN_N_LINK]",target_books_custom_column_N_link)
                #~ if DEBUG: print(mqysql)
                my_cursor.execute(mysql,([target_id]))
                tmp_rows2 = my_cursor.fetchall()
                if not tmp_rows2:
                    return
                for item in tmp_rows2:
                    dummy,target_value = item
                    if not target_value:
                        continue
                    #--------------
                    mysql = "SELECT book,extra FROM [TARGET_BOOKS_CUSTOM_COLUMN_N_LINK] WHERE book = ?"
                    mysql = mysql.replace("[TARGET_BOOKS_CUSTOM_COLUMN_N_LINK]",target_books_custom_column_N_link)
                    my_cursor.execute(mysql,([target_id]))
                    tmp_rows3 =  my_cursor.fetchall()
                    if not tmp_rows3:
                        continue
                    for item in tmp_rows3:
                        dummy,target_extra = item
                        if not target_extra:
                            continue
                    #END FOR
                    del tmp_rows3
                    #--------------
                    mysql = "INSERT OR IGNORE INTO SOURCE.[SOURCE_BOOKS_CUSTOM_COLUMN_N_LINK] SELECT NULL,?,(SELECT id FROM SOURCE.[SOURCE_CUSTOM_COLUMN_N] WHERE SOURCE.[SOURCE_CUSTOM_COLUMN_N].value = ?),?  "
                    mysql = mysql.replace("[SOURCE_BOOKS_CUSTOM_COLUMN_N_LINK]",source_books_custom_column_N_link)
                    mysql = mysql.replace("[SOURCE_CUSTOM_COLUMN_N]",source_custom_column_N)
                    #~ if DEBUG: print(mysql)
                    my_cursor.execute(mysql,(orig_source_id,target_value,target_extra))
                #END FOR
                del tmp_rows2
        #END FOR
        del tmp_rows1
        try:
            my_cursor.execute("commit")
        except:
            pass
    #-------------------------------------------------------------------------------------------------------------------------------
    def update_source_cc_not_normalized(self,my_db,my_cursor,target_cc_id,source_library,source_library_cc_id,source_library_cc_datatype,source_library_cc_normalized):

        if not source_library.endswith("/"):
            source_library = source_library + "/"

        s = as_unicode(target_cc_id)
        target_custom_column_N = "custom_column_[N]".replace("[N]",s)

        s = as_unicode(source_library_cc_id)
        source_custom_column_N = "custom_column_[N]".replace("[N]",s)

        mysql = "DELETE FROM SOURCE.[SOURCE_CUSTOM_COLUMN_N]"
        mysql = mysql.replace("[SOURCE_CUSTOM_COLUMN_N]",source_custom_column_N)
        #~ if DEBUG: print(mysql)
        my_cursor.execute("begin")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        #~ if DEBUG: print("source_library: ", source_library)   #upper/lower case differences...view has the real spelling...calm is always all lower case...
        mysql = "SELECT target_id, orig_source_id FROM __book_original_source_paths WHERE lower(orig_source_library) =  ? AND target_id NOT NULL AND orig_source_id NOT NULL "
        my_cursor.execute(mysql,([source_library]))
        tmp_rows1 = my_cursor.fetchall()
        if not tmp_rows1:
            return
        my_cursor.execute("begin")
        for row in tmp_rows1:
            target_id, orig_source_id = row
            if not orig_source_id:
                continue
            if not target_id:
                continue
            #~ if DEBUG: print(as_unicode(target_id), as_unicode(orig_source_id))
            mysql = "INSERT OR IGNORE INTO SOURCE.[SOURCE_CUSTOM_COLUMN_N] SELECT NULL,?,(SELECT value FROM main.[TARGET_CUSTOM_COLUMN_N] WHERE main.[TARGET_CUSTOM_COLUMN_N].book = ? AND main.[TARGET_CUSTOM_COLUMN_N].value NOT NULL) "
            mysql = mysql.replace("[SOURCE_CUSTOM_COLUMN_N]",source_custom_column_N)
            mysql = mysql.replace("[TARGET_CUSTOM_COLUMN_N]",target_custom_column_N)

            try:
                my_cursor.execute(mysql,(orig_source_id,target_id))
            except Exception as e:
                if DEBUG: print(mysql)
                if DEBUG: print("See sql above: ", as_unicode(e))
                if DEBUG: print("source: ", source_custom_column_N, "   target: ", target_custom_column_N)
                if DEBUG: print("orig_source_id ", as_unicode(orig_source_id),"target_id ", as_unicode(target_id ))
        #END FOR
        del tmp_rows1
        try:
            my_cursor.execute("commit")
        except:
            pass

    #-------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------------------------------------------------------------------
    def init_tooltips_for_metadata_tools_tab(self):

        self.setStyleSheet("QToolTip { color: #ffffff; background-color: #2a82da; border: 1px solid white; }")
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class CALMFAQTab(QWidget):

    def __init__(self):
        super(CALMFAQTab, self).__init__()

        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(9)

        #-----------------------------------------------------
        self.layout_top = QVBoxLayout()
        self.layout_top.setSpacing(0)
        self.layout_top.setAlignment(Qt.AlignCenter)
        self.setLayout(self.layout_top)
        #-----------------------------------------------------
        self.scroll_area_frame = QScrollArea()
        self.scroll_area_frame.setAlignment(Qt.AlignCenter)
        self.scroll_area_frame.setWidgetResizable(True)
        self.scroll_area_frame.ensureVisible(800,800)

        self.layout_top.addWidget(self.scroll_area_frame)       # the scroll area is now the child of the parent of self.layout_top

        # NOTE: the self.scroll_area_frame.setWidget(self.scroll_widget) is at the end of the init() AFTER all children have been created and assigned to a layout...

        #-----------------------------------------------------
        self.scroll_widget = QWidget()
        self.layout_top.addWidget(self.scroll_widget)           # causes automatic reparenting of QWidget to the parent of self.layout_top, which is:  self .
        #-----------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setAlignment(Qt.AlignCenter)

        self.scroll_widget.setLayout(self.layout_frame)        # causes automatic reparenting of any widget later added to self.layout_frame to the parent of self.layout_frame, which is:  QWidget .

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.faq_faq_groupbox = QGroupBox('Frequently Asked Questions:')
        self.faq_faq_groupbox.setToolTip("<p style='white-space:wrap'>This Tab displays 'Frequently Asked Questions' about the 'Metadata Tools' and the 'Library Tools' Tabs.")
        self.faq_faq_groupbox.setMinimumWidth(400)
        #~ self.faq_faq_groupbox.setMaximumWidth(800)
        self.faq_faq_groupbox.setMinimumHeight(400)
        self.layout_frame.addWidget(self.faq_faq_groupbox)

        self.faq_faq_layout = QVBoxLayout()
        self.faq_faq_layout.setAlignment(Qt.AlignCenter)
        self.faq_faq_groupbox.setLayout(self.faq_faq_layout)

        font.setPointSize(9)
        font.setBold(False)

        self.faq_faq_qtextedit =  QTextEdit("")
        self.faq_faq_qtextedit.setReadOnly(True)

        self.faq_faq_qtextedit.setWordWrapMode(QTextOption.WrapMode.WordWrap)
        self.faq_faq_qtextedit.clear()

        self.faq_faq_html = self.initialize_faq_faq_html()

        self.faq_faq_qtextedit.setHtml(self.faq_faq_html)

        self.faq_faq_layout.addWidget(self.faq_faq_qtextedit)

        self.faq_faq_qtextedit.setToolTip("<p style='white-space:wrap'>This Tab displays 'Frequently Asked Questions' about the 'Metadata Tools' and the 'Library Tools' Tabs.")

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_widget.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.setWidget(self.scroll_widget)    # now that all widgets have been created and assigned to a layout...
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def init_tooltips_for_faq_tab(self):

        self.setStyleSheet("QToolTip { color: #ffffff; background-color: #2a82da; border: 1px solid white; }")

    #-----------------------------------------------------------------------------------------------
    # FAQ Tab:  FAQs
    #-----------------------------------------------------------------------------------------------
    def initialize_faq_faq_html(self):
        self.faq_faq_html = \
            '''
            <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><html><head><meta http-equiv="content-type" content="text/html; charset=utf-8"/><title> </title><meta name="generator" content="LibreOffice 5.0.2.2 (Windows)"/><meta name="created" content="00:00:00"/><meta name="changed" content="2015-10-29T10:12:53.432000000"/><style type="text/css"> @page { margin: 0.79in } h2.western { font-family: "Albany", sans-serif; font-size: 16pt } h2.cjk { font-family: "SimSun"; font-size: 16pt } h2.ctl { font-family: "Arial"; font-size: 16pt }</style></head><body lang="en-US" dir="ltr"><div align="right"><table width="1880" cellpadding="0" cellspacing="0" style="page-break-before: always; page-break-after: auto; page-break-inside: auto"><col width="19"><col width="568"><col width="1293"><tr valign="top"> <td width="19" style="border: none; padding: 0in"><p align="left"><br/></p></td> <td width="568" style="border: none; padding: 0in"><p align="center" style="text-decoration: none"><font face="Times New Roman, serif"><font size="5" style="font-size: 18pt"><b>Metadata Tools FAQs</b></font></font></p></td> <td width="1293" style="border: none; padding: 0in"><p><br/></p></td></tr><tr valign="top"> <td width="19" style="border: none; padding: 0in"><p align="left"><br/></p></td> <td width="568" style="border: none; padding: 0in"><p><br/></p></td> <td width="1293" style="border: none; padding: 0in"><p><br/></p></td></tr><tr valign="top"> <td width="19" style="border: none; padding: 0in"><p align="left"><br/></p></td> <td width="568" style="border: none; padding: 0in"><h2 class="western" align="center"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt"></font></font></a></p><p><br/></p></td> <td width="1293" style="border: none; padding: 0in"><p><br/></p></td></tr><tr valign="top"> <td width="19" style="border: none; padding: 0in"><p align="left"><br/></p></td> <td width="568" style="border: none; padding: 0in"><p><br/></p></td> <td width="1293" style="border: none; padding: 0in"><p><br/></p></td></tr><tr valign="top"> <td width="19" style="border: none; padding: 0in"><p align="left"><br/></p></td> <td width="568" style="border: none; padding: 0in"><h2 class="western" align="center"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt"><u>Metadata Tools</u> </font></font></h2></td> <td width="1293" style="border: none; padding: 0in"><p><br/></p></td></tr><tr valign="top"> <td width="19" style="border: none; padding: 0in"><p align="left"><br/></p></td> <td width="568" style="border: none; padding: 0in"><p><br/></p></td> <td width="1293" style="border: none; padding: 0in"><p><br/></p></td></tr><tr valign="top"> <td width="19" style="border: none; padding: 0in"><p align="left"><br/></p></td> <td width="568" style="border: none; padding: 0in"><p><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt"><b>What is the purpose of the Metadata Tools?</b> </font></font></p><p style="margin-left: 0.49in"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">To standardize Tags and Genres across all of your Calibre Libraries.</font></font></p><p style="margin-left: 0.49in"><br/></p></td> <td width="1293" style="border: none; padding: 0in"><p><br/></p></td></tr><tr valign="top"> <td width="19" style="border: none; padding: 0in"><p align="left"><br/></p></td> <td width="568" style="border: none; padding: 0in"><p><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt"><b>How are the Tag Tools used? What are the Steps?</b> </font></font></p>
            <p><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">Change each Tag in the CALM snapshot Target Library from its original Source Library value to its new standardized or harmonized value as you see appropriate. </font></font></p><p><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">Delete any undesirable Tags in the Target Library. </font></font></p><p><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">Change all of the Tags in each of your Source Libraries to exactly match the Tags now existing for all of their books in the CALM snapshot Target Library. <br/> <br/></font></font><br/></p></td> <td width="1293" style="border: none; padding: 0in"><p><br/></p></td></tr><tr valign="top"> <td width="19" style="border: none; padding: 0in"><p align="left"><br/></p></td> <td width="568" style="border: none; padding: 0in"><p><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt"><b>Where are the special User-Maintained Tables that I must maintain for Tags and Genres?</b> </font></font></p><p style="margin-left: 0.49in"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">They are in a special database file named “metadata_tools.db” that is located in the same Library directory as the special CALM “metadata.db” file that you freshly create in the Target Library Tab of CALM. <br/> <br/> Its path will be: &quot;….\CALM\metadata_tools.db&quot; </font></font></p><p style="margin-left: 0.49in"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">You must maintain this database file, and <u><b>not</b></u> the metadata.db file. This is a “permanent” file, just as is &quot;….\CALM\metadata_db_prefs_backup.json&quot; </font></font></p><p style="margin-left: 0.49in"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">The &quot;….\CALM\metadata.db&quot; file is what you “Freshly Extract” before you consolidate your libraries. It is transient, and will be deleted and recreated with an empty, fresh copy using the button you click to do so in the Target Library Tab of CALM. <br/></font></font><br/></p></td> <td width="1293" style="border: none; padding: 0in"><p><br/></p></td></tr><tr valign="top"> <td width="19" style="border: none; padding: 0in"><p align="left"><br/></p></td> <td width="568" style="border: none; padding: 0in"><p><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt"><b>What tool do I use to access them?</b> </font></font></p><p style="margin-left: 0.49in"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">Install the cross-platform tool “ </font></font><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt"><i><b>DB Browser for SQLite</b></i></font></font><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt"></font></font><font face="Times New Roman, serif">” </font><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">that is available from: </font></font><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt"><u><a href="http://sqlitebrowser.org/">http://sqlitebrowser.org/</a> <br/></u></font></font><br/></p></td> <td width="1293" style="border: none; padding: 0in"><p><br/></p></td></tr><tr valign="top"> <td width="19" style="border: none; padding: 0in"><p align="left"><br/></p></td> <td width="568" style="border: none; padding: 0in"><p><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt"><b>What are the technical names of the tables in the 'metadata_tools.db' database file that I am responsible for maintaining based on my personal needs?</b> </font></font></p><p style="font-weight: normal; text-decoration: none"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_tag_rules</font></font></p><p style="font-weight: normal; text-decoration: none"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_tag_capitalization_rules</font></font></p><p style="font-weight: normal; text-decoration: none"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_tag_combination_rules</font></font></p><p style="font-weight: normal; text-decoration: none"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_tag_string_replacement_rules</font></font></p><p style="font-weight: normal; text-decoration: none"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_dg_genre_author_rules</font></font></p><p style="font-weight: normal; text-decoration: none"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_dg_genre_tag_rules_factual</font></font></p><p style="font-weight: normal; text-decoration: none"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_dg_genre_tag_rules_fiction</font></font></p>
            <p style="font-weight: normal; text-decoration: none"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_dg_nf_language_keywords</font></font></p><p style="font-weight: normal; text-decoration: none"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_dg_missing_tag_rules</font></font></p><p><br/></p></td> <td width="1293" style="border: none; padding: 0in"><p><br/></p></td></tr><tr valign="top"> <td width="19" style="border: none; padding: 0in"><p align="left"><br/></p></td> <td width="568" style="border: none; padding: 0in"><p><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt"><b>How do I maintain them?</b> </font></font></p><p style="margin-left: 0.49in"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">Please download the CALM Table Maintenance User Instructions and the CALM Derive Genres User Instructions attached to the CALM Plugin Original Post in the Calibre-Plugins Forum of mobileread.com. </font></font></p><p style="margin-left: 0.49in"><font face="Times New Roman, serif"><a href="http://www.mobileread.com/forums/forumdisplay.php?f=237">http://www.mobileread.com/forums/forumdisplay.php?f=237</a></font></p><p style="margin-left: 0.49in"><br/></p></td> <td width="1293" style="border: none; padding: 0in"><p><br/></p></td></tr><tr valign="top"> <td width="19" style="border: none; padding: 0in"><p align="left"><br/></p></td> <td width="568" style="border: none; padding: 0in"><p><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt"><b>Were the Metadata Tools for Tags and Genres developed specifically for CALM?</b> </font></font></p><p style="margin-left: 0.49in"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt"><span style="font-weight: normal">No. <br/> <br/> CALM's 'Tag Management' and 'Derive Genres' functionality was ported directly to CALM from the QuarantineAndScrub add-on. <br/> <br/> Q&amp;S has a lot of Tag functionality that was not ported to CALM, such as Tag Minimization, Tags by Series Propagation, and much more. Q&amp;S is an industrial-strength add-on. <br/> <br/> CALM is different, and does not compete with Q&amp;S, and vice-versa. Different tools for different user scenarios and different user needs. <br/> <br/> Most Calibre users might need or want CALM, whereas most Calibre users absolutely do not need, nor should they install, Q&amp;S. </span><br/> <br/> If you currently use Q&amp;S, you might also want to use CALM. <br/></font></font><br/></p></td> <td width="1293" style="border: none; padding: 0in"><p align="center"><br/></p></td></tr><tr valign="top"> <td width="19" style="border: none; padding: 0in"><p align="left"><br/></p></td> <td width="568" style="border: none; padding: 0in"><p><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt"><b>I already use QuarantineAndScrub. In what scenario would I ever want to also use CALM?</b> </font></font></p><p style="margin-left: 0.49in; font-weight: normal"><font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">Q&amp;S works only with Calibre Q&amp;S Libraries. CALM works with any Calibre Library, “Normal” or “Q&amp;S”. So, if your “Pristine Library” is a “Normal Calibre Library”, you can use CALM's metadata tools with it even though you cannot use Q&amp;S for that “Normal Calibre Library”. <br/> <br/> If you already use Q&amp;S, then undoubtedly your Q&amp;S Tag Rules and Derive Genres tables have already been personalized by you. It would be a good idea to download the data from the subset of its Tag and Derive Genre tables that are also found in the CALM metadata_tools.db, and upload the downloaded table data into the latter. Those tables would be: </font></font></p><p style="margin-left: 0.98in; font-weight: normal; text-decoration: none"> <font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_tag_rules</font></font></p><p style="margin-left: 0.98in; font-weight: normal; text-decoration: none"> <font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_tag_capitalization_rules</font></font></p><p style="margin-left: 0.98in; font-weight: normal; text-decoration: none"> <font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_tag_combination_rules</font></font></p><p style="margin-left: 0.98in; font-weight: normal; text-decoration: none"> <font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_tag_string_replacement_rules</font></font></p><p style="margin-left: 0.98in; font-weight: normal; text-decoration: none"> <font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_dg_genre_author_rules</font></font></p><p style="margin-left: 0.98in; font-weight: normal; text-decoration: none"> <font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_dg_genre_tag_rules_factual</font></font></p><p style="margin-left: 0.98in; font-weight: normal; text-decoration: none">
            <font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_dg_genre_tag_rules_fiction</font></font></p><p style="margin-left: 0.98in; font-weight: normal; text-decoration: none"> <font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">_dg_nf_language_keywords</font></font></p><p style="margin-left: 0.49in"><br/></p></td> <td width="1293" style="border: none; padding: 0in"><p align="center"><br/></p></td></tr><tr valign="top"> <td width="19" style="border: none; padding: 0in"><p align="left"><br/></p></td> <td width="568" style="border: none; padding: 0in"><p><br/></p></td> <td width="1293" style="border: none; padding: 0in"><p align="center"><br/></p></td></tr></table></div><p style="margin-right: 14.81in"><br/> <br/></p><p style="margin-right: 14.81in"><br/> <br/></p><p style="margin-right: 14.81in"><br/> <br/></p></body></html>
            '''

        return self.faq_faq_html
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#END of calm_dialog.py